option(null: hard);	
/*	
	instrument wrapper functions
	Developer: Algorithmica Research, Magnus Nyström			

	--------------------------------------------------------------------
	real rate fixflt swap
	--------------------------------------------------------------------
*/



//-----------------------------------------------------------------------
//  class swap_il_rr_fixflt
//----------------------------------------------------------------------
class swap_il_rr_fixflt: public swap_gen
option(category: "Instrument/Inflation Linked/Real Rate Fixed vs Float")
//option(allow_undeclared_mfuncs)
{
public:
	//override string				instr_type_s();
	override instrument 		inst();
	override swap_il_rr_fixflt 	clone() ;

	override void     	__dbg_print(__dbg_label);
    override void    	__dbg_browse(__dbg_split);
	
	/*----------ADD FUNCS [PUBLIC]---------------*/	
	void 		add_quote(number,..quote_style );//???i.e. means add new cpn --> should be a new instrument
	override void	add_quote(number);	
	void 		add_notional(number );
	void 		add_notional(number , number);
	void		add_fx_rate(number,logical,string,string );
	void 		add_fx_mult_fix_leg(number );
	void 		add_fx_mult_flt_leg(number );
	//void 		add_disc_func(disc_func option(nullable)); 
	void 		add_disc_func_fix_leg(disc_func option(nullable));
	void 		add_disc_func_flt_leg(disc_func option(nullable));	
	void 		add_surface(tenor_surface option(nullable));	
	void		add_fixing(vector(date) ,vector(number) ,logical option(nullable) fixing_as_fwd = false);	
	void		add_fixing(number ,logical option(nullable) fixing_as_fwd = false);
	void		add_current_fixing(number option(nullable));
	void 		add_data( 	number option(nullable), disc_func ,disc_func ,
										tenor_surface option(nullable), vector(date) option(nullable),
										vector(number) option(nullable),
										logical option(nullable) fixing_as_fwd_flt_leg = false,
										logical upd_null_crv = false,logical upd_null_fix = false);
	void 		add_ccy_data(	number,disc_func,number,number,disc_func,number,
											tenor_surface,vector(date),vector(number),
											logical option(nullable) fixing_as_fwd_flt_leg = false,
											logical upd_null_crv = false,logical upd_null_fix = false);
	void 		add_cpi_link(..cpi_link);
	void 		add_cpi_link_forecast(..cpi_link);

	/*----------MISC FUNCS [PUBLIC]---------------*/
	//DLL_SWAP_HANDLER OK
	date 			start_date(error_info option(nullable) error = null<error_info> );				/*name change of issuedate*/
	//DLL_SWAP_HANDLER --> IN PROGRESS
	logical			is_par_flat(error_info option(nullable) error = null<error_info>);
	logical			pay_fix(error_info option(nullable) error = null<error_info>);
	override void 	notional(out number, out number,error_info option(nullable) error = null<error_info>);
	number 			notional(error_info option(nullable) error = null<error_info>);
	void 			is_regular_first(out logical option(nullable), out logical option(nullable),error_info option(nullable) error = null<error_info>);				
	void 			is_regular_last(out logical option(nullable), out logical option(nullable),error_info option(nullable) error = null<error_info>);		
	override void 	fx_mult_factor(out number, out number,error_info option(nullable) error = null<error_info>);
	override void	currency(out string, out string, error_info option(nullable) error = null<error_info>);
	override void 	coupon(out number  option(nullable),out number  option(nullable),error_info option(nullable) error = null<error_info>);
	override void 	coupon_freq(out integer,out integer,error_info option(nullable) error = null<error_info> );
	override void 	dc_method(	out day_count_method , out day_count_method ,error_info option(nullable) error = null<error_info>);									
	override void  	pmt_bus_day(out bd_convention option(nullable), out bd_convention option(nullable),error_info option(nullable) error = null<error_info>);				
	override void 	roll_day(out integer,out integer,error_info option(nullable) error = null<error_info>);
	override void 	eom(out logical option(nullable),out logical option(nullable),error_info option(nullable) error = null<error_info> );
	override void 	calendar(out ..calendar option(nullable),out ..calendar option(nullable), error_info option(nullable) error = null<error_info>);
	//void 		quote(out number  option(nullable),out number  option(nullable),
								 // error_info option(nullable) error = null<error_info> );
	override void  	effective_date(	out date , out date , error_info option(nullable) error = null<error_info>);
	
	/*----------CASHFLOW FUNCS [PUBLIC]---------------*/
	override void		cash_flow_dates(logical,out vector(date) ,out vector(date) ,error_info option(nullable) error = null<error_info> ) ;
	override void		cash_flows_cpn(logical,out vector(number) ,out vector(number),error_info option(nullable) error = null<error_info> );
	override void		cash_flows(logical,out vector(number) ,out vector(number),error_info option(nullable) error = null<error_info> );
	override void		cash_flow_data(	logical,ir_cf_code cf_code,out vector(date)   ,out vector(number)   ,
											out vector(date)    ,out vector(number)   ,
											error_info option(nullable) error = null<error_info> );
	override void 		cash_flow_data(logical,logical option(nullable),out vector(date)   ,out vector(number)  ,
											out vector(number)   ,out vector(number)   ,
											out vector(number)   ,out vector(number)   ,
											out vector(number)  ,out vector(date)   	,
											out vector(number)   ,out vector(number)   ,
											out vector(number)   ,out vector(number)   ,
											out vector(number)   ,out vector(number)   ,
											error_info option(nullable) error = null<error_info> );

	/*vector(number) 	cash_flow_nom_amounts(	..cpi_link ,number option(nullable) nominal = null<number>,
											logical post_settle = true,error_info option(nullable) error = null<error_info>);
	
	vector(number) 	cash_flow_nom_cpn(	..cpi_link ,number option(nullable) nominal = null<number>,
											logical post_settle = true,error_info option(nullable) error = null<error_info>);*/

	void 			data(out swap_fix_infl_ci_leg_data,out swap_flt_leg_data,error_info option(nullable) error = null<error_info>);
	
	
	/*----------PV FUNCS [PUBLIC]---------------*/
	override number  	present_value(	disc_func option(nullable),disc_func option(nullable),out number ,
											out number ,number option(nullable) ,
											logical option(nullable) trade_date_pv = false,		
											error_info option(nullable) error = null<error_info>);
	
	override number  	present_value(	disc_func option(nullable),disc_func option(nullable),out number ,
										out number,date option(nullable) ,date option(nullable) ,
										logical,logical  ,error_info option(nullable) error = null<error_info>);
	
	override number  	present_value(	out number ,out number ,logical option(nullable) ,error_info option(nullable) error = null<error_info> );
	override number 	accrued(logical,out number,out number, error_info option(nullable) error = null<error_info>);
	override void 		accrued_period(out number,out number,out integer,out integer,error_info option(nullable) error = null<error_info>);		
	override number 	accrued_chg (integer bus_days, out	number option(nullable)	,out number,out	number option(nullable)	,out number ,
									out date ,out date ,error_info option(nullable) error = null<error_info> );

	//void					implied_par_funcs(	out disc_func option(nullable),out fwd_func option(nullable) ,
	//											number option(nullable),error_info option(nullable) error = null<error_info>);
	
	override number		solver(	number,swap_solver_code ,logical option(nullable) trade_date_pv = false,
								error_info option(nullable) error = null<error_info>);
/*
	number 					dv01(number option(nullable) delta = 0.0001, 
								logical option(nullable) trade_date_pv = false,
								error_info option(nullable) error  = null<error_info>) ;

	number 					delta_risk_disc(number option(nullable) delta = 0.0001, 
											logical option(nullable) trade_date_pv = false,
											error_info option(nullable) error  = null<error_info>) ;
	
	number  				delta_risk(	logical,number option(nullable) delta = 0.0001, 
										logical option(nullable) trade_date_pv = false,
										error_info option(nullable) error  = null<error_info>) ;
	number  				delta_pvdiff(	number option(nullable) delta_disc = 0.0001,
											number option(nullable) delta_fwd = 0.0001,
											logical option(nullable) trade_date_pv = false,
											error_info option(nullable) error  = null<error_info>) ;
	
	number  				gamma_risk(	logical,number option(nullable) delta = 0.0001, 
										logical option(nullable) trade_date_pv = false,
										error_info option(nullable) error  = null<error_info>) ;

	number 					gamma_risk_disc(number option(nullable) delta = 0.0001, 
											logical option(nullable) trade_date_pv = false,
											error_info option(nullable) error  = null<error_info>) ;
	
	number 					upfront_carry(	date option(nullable) ,date option(nullable) ,out number ,
												out number ,out number ,																																	
												error_info option(nullable) error = null<error_info> ) ;

	number 					upfront_rolldown(	date option(nullable) ,date option(nullable) ,out number ,
												out number ,out number ,																																	
												error_info option(nullable) error = null<error_info> ) ;

	
	void 					risk_ladder_fwd(vector(fwd_func),fwd_func,fwd_func option(nullable),number,out vector(number) ,
										out number, error_info option(nullable) error = null<error_info> ) ;
	void					risk_ladder_disc(fwd_func option(nullable),vector(disc_func),disc_func,disc_func option(nullable) ,
											 number, out vector(number) ,
											out number ,error_info option(nullable) error = null<error_info> ) ;*/

	number					pv01(	number option(nullable),number option(nullable),
									disc_func option(nullable) df = null<disc_func>,
									error_info option(nullable) error = null<error_info>);
	
	/*----------FIXLEG FUNCS [PUBLIC]---------------*/
	number					coupon_fix_leg(error_info option(nullable) error = null<error_info> );
	number					deltapv_fix_cpn_rate(number ,
												 disc_func option(nullable) df = null<disc_func>,
												error_info option(nullable) error = null<error_info>);
	
	disc_func 				disc_func_fix_leg(error_info option(nullable) error = null<error_info> ) ;			
	//override number 		fix_leg_y_to_pv(number option(nullable) y = null<number>,logical l= true ,error_info option(nullable) error = null<error_info>);
	override number			imp_rate_fix_leg(number,logical option(nullable) trade_date_pv = false,
											 error_info option(nullable) error = null<error_info>);
	
	/*----------FIXLEG CPI FUNCS [PUBLIC]---------------*/
	//integer 		index_freq(	error_info option(nullable) error = null<error_info>);
	number 			index_factor(error_info option(nullable) error = null<error_info>);
	number 			index_factor(date option(nullable),date,error_info option(nullable) error = null<error_info>);
	//number 			base_cpi(error_info option(nullable) error = null<error_info>);
	//..cpi_link 		cpi_link(error_info option(nullable) error = null<error_info>);

	//void  			cpi_knots(date ,out date  option(nullable),out date   option(nullable),out logical option(nullable)	,
	//							out logical   option(nullable)	,error_info option(nullable) error = null<error_info>);
	
	//void  			cpi_values(out number  option(nullable),out number   option(nullable),error_info option(nullable) error = null<error_info>);
	..cpi_link 			cpi_link(error_info option(nullable) error = null<error_info> );
	..cpi_link 			cpi_link_forecast(error_info option(nullable) error = null<error_info> );	
	void  				cpi_knots(	date ,out date  option(nullable),out date   option(nullable),out logical option(nullable)	,
									out logical   option(nullable)	,error_info option(nullable) error = null<error_info> );
	/*----------FLTLEG FUNCS [PUBLIC]---------------*/
	number					spread_flt_leg(error_info option(nullable) error = null<error_info> );
	number					current_coupon_flt_leg(error_info option(nullable) error = null<error_info> );
	number					current_fixing_flt_leg(out date,out logical,error_info option(nullable) error = null<error_info>);
	integer					reset_freq_flt_leg(error_info option(nullable) error = null<error_info>);
	void					index_dates_flt_leg(logical,out vector(date)  ,out vector(date)  ,
												out vector(logical)option(nullable) ,error_info option(nullable) error = null<error_info> ) ;
	void					fixing_data_flt_leg(logical ,logical option(nullable),out vector(date)   ,									
												out vector(number)   ,out vector(logical) option(nullable),
												error_info option(nullable) error = null<error_info> ) ;
	number					imp_spread_flt_leg(number,logical option(nullable) trade_date_pv = false,
											   error_info option(nullable) error = null<error_info>);
	
	disc_func 				disc_func_flt_leg(error_info option(nullable) error = null<error_info> ) ;
	tenor_surface 			tenor_surface_flt_leg(error_info option(nullable) error = null<error_info>);
	ir_index 				ir_index_flt_leg(error_info option(nullable) error = null<error_info> ); 
	string 					index_tenor_flt_leg(error_info option(nullable) error = null<error_info> ) ;
	tenor_code 				index_tenor_code_flt_leg(error_info option(nullable) error = null<error_info> ) ;
	
	//-----external swap specific-----
	override instrument_type 	swap_type(error_info option(nullable) error = null<error_info> );
	vector(ql_swap_leg) 		legs(logical,error_info option(nullable) error = null<error_info>);
	ql_float_leg 				float_leg(logical,error_info option(nullable) error = null<error_info>);
	ql_fix_infl_ci_leg 			fix_leg(logical,error_info option(nullable) error = null<error_info>);
	override ql_fixed_income_swap 	swap_instrument(error_info option(nullable) error = null<error_info>) ;

	/*---set functions-required--*/
	override swap_il_rr_fixflt	set_quote(number option(nullable),error_info option(nullable) error = null<error_info>);
	override swap_il_rr_fixflt	set_quote(string option(nullable),error_info option(nullable) error = null<error_info>);
	//virtual instrument 	set_settle_date(date ,logical ,error_info option(nullable) error = null<error_info> );

	/*-----set functions-if applicable-----*/
	swap_il_rr_fixflt		set_rate_fix_leg(number option(nullable) ,error_info option(nullable) error = null<error_info>);
	swap_il_rr_fixflt		set_pay_leg(logical ,error_info option(nullable) error = null<error_info>);
	//swap_il_rr_fixflt			set_spread_flt_leg(number option(nullable) ,error_info option(nullable) error = null<error_info>);

	//local set funcs						
	swap_il_rr_fixflt 			set_date(date,date option(nullable) settle_date=null<date>, error_info option(nullable) error = null<error_info>);
	override swap_il_rr_fixflt 	set_date(date,date option(nullable),logical,logical , error_info option(nullable) error = null<error_info> );
	//void					update_to_par(error_info option(nullable) error = null<error_info> );
	
	tenor_surface 			create_tenor_surface(disc_func ,fwd_func );
	tenor_surface 			create_tenor_surface(disc_func ,disc_func );
	
	/*----------HIDDEN FUNCS [PUBLIC]-(mostly for backward compat)--------------*/
	swap_il_rr_fixflt(__instrument);

	//general-one per leg
	//override calendar 		calendar(integer ,error_info option(nullable) error = null<error_info>  );		/*hidden, visible in root*/
	//override calendar 		calendar(error_info option(nullable) error = null<error_info>  );				/*hidden, visible in root*/
	//override string 		calendar_name(integer, error_info option(nullable) error = null<error_info> );	/*hidden, visible in root*/
	//override string 		calendar_name(error_info option(nullable) error = null<error_info> );			/*hidden, visible in root*/	
	override logical 		eom(error_info option(nullable) error = null<error_info>);						/*hidden, visible in root*/
	override integer		roll_day(error_info option(nullable) error = null<error_info>);					/*hidden, not visible in root*/
	override bd_convention 	pmt_bus_day(error_info option(nullable) error = null<error_info> );				/*hidden, not visible in root*/
	override string 		currency(error_info option(nullable) error = null<error_info> );				/*hidden, visible in root*/
	override day_count_method dc_method(error_info option(nullable) error = null<error_info> );				/*hidden, not visible in root*/							
	override integer 		coupon_freq(error_info option(nullable) error = null<error_info> );				/*hidden, visible in root*/
	override number 		coupon(error_info option(nullable) error = null<error_info> );					/*hidden, visible in root*/
//override number 		nominal(error_info option(nullable) error = null<error_info> );					/*hidden, visible in root*/
	override date 			cpn_start_date(error_info option(nullable) error = null<error_info>);			/*hidden, not visible in root*/	
	//general-one per swap
	override ir_index 		ir_index(error_info option(nullable) error = null<error_info> ); 				/*hidden, not visible in root*/
	override date 			issue_date(error_info option(nullable) error = null<error_info> ); 				/*hidden, visible in root*/	
	override string 		settle_code(error_info option(nullable) error = null<error_info>);				/*hidden, visible in root*/
	
	//price
	/*override number 		dirty_price(number option(nullable) ,logical disable_rounding = false,
										logical in_pcnt = true,error_info option(nullable) error = null<error_info>);				
												
	override number  		dirty_price(logical disable_rounding = false,logical in_pcnt = true,
										error_info option(nullable) error = null<error_info>);										
		
	override number 		clean_price(number option(nullable),logical disable_rounding = false,
										logical in_pcnt = true,error_info option(nullable) error = null<error_info>);				
												
	override number 		clean_price(logical disable_rounding = false,logical in_pcnt = true,
										error_info option(nullable) error = null<error_info>);										
	override number 		clean_price(disc_func,logical disable_rounding = false,
										logical in_pcnt = true,error_info option(nullable) error = null<error_info>);					
	override number  		dirty_price(disc_func,logical disable_rounding = false,
										logical in_pcnt = true,error_info option(nullable) error = null<error_info>);	*/			
	//override number 		yield(disc_func ,logical disable_rounding = false,
		//						  error_info option(nullable) error = null<error_info>);											
	override number 		yield(logical disable_rounding = false,error_info option(nullable) error = null<error_info>);			/*hidden, visible in root*/
	override number  		quote(	disc_func , ..quote_style option(nullable) ,error_info option(nullable) error = null<error_info>);  /*hidden, visible in root*/
	

	swap_il_rr_fixflt(swap_il_rr_fixflt);
protected:	
	override swap_il_rr_fixflt	create(__instrument option(nullable),out instr_error option(nullable),error_type type = E_INVALID_ARG);
	swap_il_rr_fixflt 			err_type(swap_il_rr_fixflt option(nullable), error_info option(nullable) error = null<error_info>);
	//logical 					y_ne_cpn_err();

	disc_func 				df_shifted_flt_leg(number,disc_func);
	tenor_surface 			fwd_shifted_flt_leg(number ,disc_func,tenor_surface);

	//add
	//override void 			add_nominal(number );
	//override void 			add_quote(number,logical option(nullable ));	
	//override void 			add_quote_from_yield(number,logical option(nullable) set_coupon_to_yield = null<logical>);
	
	//general	
		
	/*override number 		present_value(	number option(nullable) nom=null<number>,
											logical trade_date_pv = false,
											disc_func option(nullable) disc_func_disc = null<disc_func>,
											error_info option(nullable) error = null<error_info>);	
	override number 		present_value(	disc_func,
											number option(nullable) nom=null<number>,
											logical trade_date_pv = false,
											disc_func option(nullable) disc_func_disc = null<disc_func>,
											error_info option(nullable) error = null<error_info>);
	override number 		accrued(logical disable_rounding = false,logical in_pcnt = true,
										error_info option(nullable) error = null<error_info>);
	override number 		accrued_period(out integer,error_info option(nullable) error = null<error_info>);																		
	override number 		accrued_chg(integer,out number,out date,
										out date,logical in_pcnt = true,
										error_info option(nullable) error = null<error_info>) ; */
	//cashflow
	/*override vector(date)		cash_flow_dates(logical post_settle = true,
												logical adj_dates = true,
												logical keep_size = false,
												error_info option(nullable) error = null<error_info>);
	
	override vector(number)		cash_flows_cpn(	number option(nullable) nom = null<number>,
											logical post_settle = true,
											logical keep_size = false,
											error_info option(nullable) error = null<error_info>);

	override void 				cash_flows(	out vector(date)  ,
											out vector(number)   ,
											number option(nullable) nominal = null<number>,
											logical post_settle = true ,											
											error_info option(nullable) error = null<error_info> );			

	override vector(date)		cash_flow_dates_noadj(logical post_settle = true ,
													  error_info option(nullable) error = null<error_info>);				
	
	override vector(number)		cash_flow_amounts(	number option(nullable) nom = null<number>,
													logical post_settle = true,
													logical keep_size = false,
													error_info option(nullable) error = null<error_info> );			
	
	override vector(number)		cash_flow_nom_amounts(	number option(nullable) nominal = null<number>,
														logical post_settle = true,
														logical keep_size = false,
														error_info option(nullable) error = null<error_info> );	
			
	override vector(number)		cash_flows(	number option(nullable) nom = null<number>,
											logical post_settle = true,
											logical keep_size = false,
											error_info option(nullable) error = null<error_info>);
	
	override void 				cash_flow_data(	number option(nullable) ,logical ,ir_cf_code ,logical,
												logical ,out vector(date)   ,
												out vector(number)   ,
												error_info option(nullable) error = null<error_info>);*/

	
	
	override number 		pvbp(number option(nullable),number option(nullable),logical option(nullable),
								logical option(nullable),	error_info option(nullable) error = null<error_info>) ;
	
	override number 		pvbp(number option(nullable),number  option(nullable),
								 error_info option(nullable) error = null<error_info>);

	/*number 				pvdiff_curve_shift(	number option(nullable) ,number option(nullable),number option(nullable),
										logical option(nullable) ,out number, out number  ,out number ,
										error_info option(nullable) error = null<error_info> );*/
	
	//disc_func				implied_par_disc_func_fix_leg(error_info option(nullable) error = null<error_info>);

	//set funcs
	
	//override swap_il_rr_fixflt 	set_date(date,date option(nullable),logical,logical ,
									 //error_info option(nullable) error = null<error_info> );
	override swap_il_rr_fixflt 	set_date(date,logical ,error_info option(nullable) error = null<error_info>);								/*legacy*/
	
	override swap_il_rr_fixflt 	move_date(	date,date option(nullable) settle_date=null<date> ,
										error_info option(nullable) error = null<error_info>);											/*legacy*/

	override swap_il_rr_fixflt	set_yield(number option(nullable) ,error_info option(nullable) error = null<error_info>);
	override swap_il_rr_fixflt	set_quote_from_yield(number option(nullable),error_info option(nullable) error = null<error_info> );		/*legacy*/


	//logical ext_swap_;
	//logical ccy_swap_;
	//logical full_swap_;
};

//------------------------------------------------
// __dbg_print
//------------------------------------------------
void swap_il_rr_fixflt.__dbg_print(__dbg_label l)
{

	error_info ee 	= new error_info(true,false);
    l.set_text(strcat([
						"name: ",
						name(ee),
						",  ext_swap: ",
						null(ext_swap_) ? "" : string(ext_swap_),
                        ", ccy_swap: ",
						null(ccy_swap_) ? "" : string(ccy_swap_),
						", valid: ",
						null(this.is_valid(ee)) ? "" : string(this.is_valid(ee))
					]));
}
//------------------------------------------------
// __dbg_browse
//------------------------------------------------
void swap_il_rr_fixflt.__dbg_browse(__dbg_split s)
{
    s.resize(4);
	error_info ee 	= new error_info(true,false);
	
    s.set_text(0, "name");
    s.set_value(0, this.name(ee));

    s.set_text(1, "ext_swap");
    s.set_value(1, ext_swap_);

    s.set_text(2, "ccy_swap");
    s.set_value(2, ccy_swap_);

	s.set_text(3, "valid");
    s.set_value(3, is_valid(ee));
}

//------------------------------------------------
// copy constructor
//------------------------------------------------
swap_il_rr_fixflt.swap_il_rr_fixflt(swap_il_rr_fixflt c)
						: swap_gen(c)
{}

//------------------------------------------------
// constructor [HIDDEN, cannot be protected]
//------------------------------------------------
swap_il_rr_fixflt.swap_il_rr_fixflt(__instrument i) option(hidden): swap_gen(i)
{
	//try {
		error_info ee = new error_info(true,false);
		if(!this.is_valid(ee)) {
			ext_swap_ = ccy_swap_ = full_swap_ = false;
			return;
		}

		ext_swap_ 	= this.is_ext_swap(ee);
		ccy_swap_ 	= this.is_ccy_swap(ee);
		full_swap_	= this.verify_full_swap(true,ee);
	
		return;									
	//}
	//catch {		
		//CORE_INT.write_warning_message(err.message());
		//the instrument is ok even if we get here
		//the consequence is only that the disc_func, fwd_func, tenor_surface are not updated
	//}	
}

//------------------------------------------------
// instr_type_s
//------------------------------------------------
//string swap_il_rr_fixflt.instr_type_s()  { return string(..instr_type.IL_SWAP_REAL_FIXFLT);}
//------------------------------------------------
// inst
//------------------------------------------------
instrument 	swap_il_rr_fixflt.inst()		{ return this;}

//------------------------------------------------
// copy constructor <FUNCTION>
//------------------------------------------------
swap_il_rr_fixflt swap_il_rr_fixflt(swap_il_rr_fixflt b)			{ return new swap_il_rr_fixflt(b);}
//------------------------------------------------
// clone
//------------------------------------------------
swap_il_rr_fixflt swap_il_rr_fixflt.clone() 	{ return new swap_il_rr_fixflt(this);}

//------------------------------------------------
// create  [PROTECTED]
// create swap_il_rr_fixflt from internal instrument
//------------------------------------------------
swap_il_rr_fixflt swap_il_rr_fixflt.create(	__instrument option(nullable) c,
											out instr_error option(nullable) error,
											error_type type )
{
	QL_FAIL_COND(null(c), "invalid/unknown (null) instrument",type );

	logical valid = c.is_valid(error);
	if( !valid && INSTR_CREATE_NULL_ERR)
		return null<swap_il_rr_fixflt>; 
	
	..instr_type it = c.instr_type(error);
	QL_FAIL_COND(null(it), "invalid instrument type (unknown)",type );
	QL_FAIL_COND(it != ..instr_type.IL_SWAP_REAL_FIXFLT, "invalid instrument type",type );//should not happen
	
	return new swap_il_rr_fixflt(c);
}
/*-----------------------------------------------------------------------
  create_swap_il_rr_fixflt  <FUNCTION>
  ----------------------------------------------------------------------*/
swap_il_rr_fixflt create_swap_il_rr_fixflt(	__instrument option(nullable) c,
											out instr_error option(nullable) error,
											error_type type = E_INVALID_ARG)
option(com_name: 'INTERNAL_create_swap_il_rr_fixflt')
{
	QL_FAIL_COND(null(c), "invalid/unknown (null) instrument",type );

	logical valid = c.is_valid(error);
	if(!valid && INSTR_CREATE_NULL_ERR)
		return null<swap_il_rr_fixflt>; 
	
	..instr_type it = c.instr_type(error);
	QL_FAIL_COND(null(it), "invalid instrument type (unknown)",type );
	QL_FAIL_COND(it != ..instr_type.IL_SWAP_REAL_FIXFLT, "invalid instrument type",type );//should not happen
	
	return new swap_il_rr_fixflt(c);
}

swap_il_rr_fixflt create_swap_il_rr_fixflt(	__instrument option(nullable) 		c,
											error_info option(nullable) 		error,
											error_type 							type = E_INIT)
option(com_name: 'INTERNAL_create_swap_il_rr_fixflt_ei')
{
	instr_error ee 		= instr_error();
	swap_il_rr_fixflt b = create_swap_il_rr_fixflt(c,ee, E_INIT);
	if(ee.is_error())
		CORE_INT.add_error_info(error,ee.type(),ee.message(), "create_swap_il_rr_fixflt");
	return b;
}

//-----------------------------------------------
// constructor <FUNCTION> dynamic cast  EXT SWAP: ok
//-----------------------------------------------
swap_il_rr_fixflt	swap_il_rr_fixflt(instrument i,
									  error_info option(nullable) error = null<error_info>)
option (category: "Instrument/Inflation Linked/Real Rate Fixed vs Float")
option(com_name: 'swap_il_rr_fixflt_dyncast') 
{ 
	try {
		swap_il_rr_fixflt d = dynamic_cast<swap_il_rr_fixflt>(i); 
		if(null(d))
			CORE_INT.add_error_info(error,ERR_T_INIT,"invalid cast (instrument is not a swap_il_rr_fixflt)","swap_il_rr_fixflt" );

		return d;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_il_rr_fixflt");
		return null<swap_il_rr_fixflt>;
	}
}

/*-----------------------------------------------------------------------
  err_type	EXT SWAP: ok
  ----------------------------------------------------------------------*/
swap_il_rr_fixflt swap_il_rr_fixflt.err_type(swap_il_rr_fixflt option(nullable) nul, error_info option(nullable) error )
{	
	CORE_INT.add_error_info(error,ERR_T_CALC,"mwlib(ql) error: inapplicable function call for current instrument type");
	return null<swap_il_rr_fixflt>;
}

/*-----------------------------------------------------------------------
  swap_il_rr_fixflt: add_quote		EXT SWAP: ok
  ----------------------------------------------------------------------*/
void swap_il_rr_fixflt.add_quote(	number  quote ) 
{	
	instrument.add_quote(quote, true);
	return ;						
}
/*-----------------------------------------------------------------------
  swap_il_rr_fixflt: add_quote		EXT SWAP: ok
  ----------------------------------------------------------------------*/
void swap_il_rr_fixflt.add_quote(	number  quote,
							..quote_style quote_style) 
{
	error_info ee = new error_info(true,true);
	..quote_style qs = instrument.quote_style_e(ee);
	
	if(quote_style == qs)
		this.add_quote(quote);
	else{
		if(quote_style == ..quote_style.YIELD)
			this.add_quote(quote*100);//instr quotestyle must be pct
		else if(quote_style == ..quote_style.YIELD_PCT)
			this.add_quote(quote/100);//instr quotestyle is not pct
		else
			QL_FAIL("invalid quote style",this,true);
	}					
}

/*-----------------------------------------------------------------------
  swap_il_rr_fixflt: add_funcs   EXT SWAP: ok
  ----------------------------------------------------------------------*/
void swap_il_rr_fixflt.add_notional(number notional)							{ swap_gen.swap_add_notional(notional);}		//if ccy swap: err
void swap_il_rr_fixflt.add_notional(number notional1, number notional2)			{ swap_gen.swap_add_notional(notional1, notional2);}
void swap_il_rr_fixflt.add_fx_mult_fix_leg(number fx_mult)						{ swap_gen.swap_add_fx_mult_leg1(fx_mult);}	//if non ccy swap: err
void swap_il_rr_fixflt.add_fx_mult_flt_leg(number fx_mult)						{ swap_gen.swap_add_fx_mult_leg2(fx_mult);}	//if non ccy swap: err
/*-----------------------------------------------------------------------
  add_fx_rate EXT SWAP: ok
  ----------------------------------------------------------------------*/
void swap_il_rr_fixflt.add_fx_rate(	number fx_quote_dec,//must be a quote per unit of base ccy 
									logical pv_in_base_ccy,
									string 	base_ccy,
									string 	price_ccy)
{
	
	swap_gen.swap_add_fx_rate(fx_quote_dec,pv_in_base_ccy,base_ccy,price_ccy);
}
//void swap_il_rr_fixflt.add_disc_func(disc_func option(nullable) df)			{ swap_gen.swap_add_disc_func(df); }	//if ccy swap: err
void swap_il_rr_fixflt.add_disc_func_fix_leg(disc_func option(nullable) df)			{ swap_gen.swap_add_disc_func_leg1(df); } //if non ccy swap: both legs will be updated
void swap_il_rr_fixflt.add_disc_func_flt_leg(disc_func  option(nullable) df) 		{ swap_gen.swap_add_disc_func_leg2(df); }	//if non ccy swap: both legs will be updated
void swap_il_rr_fixflt.add_surface(tenor_surface option(nullable) tenor_surface)	{ swap_gen.swap_add_surface_leg2(tenor_surface);}
void swap_il_rr_fixflt.add_fixing(vector(date) fixing_dates,
							vector(number) fixings,
							logical option(nullable) fixing_as_fwd )			{ swap_gen.swap_add_fixing_leg2(fixing_dates,fixings,fixing_as_fwd);}
void swap_il_rr_fixflt.add_fixing(number fixing_proxy,
							logical option(nullable) fixing_as_fwd ) 			{ swap_gen.swap_add_fixing_leg2(fixing_proxy, fixing_as_fwd);	}

void swap_il_rr_fixflt.add_current_fixing(number option(nullable) fixing) 		{ swap_gen.swap_add_curr_fixing_leg2(fixing);	}

void swap_il_rr_fixflt.add_data(number option(nullable) notional,
								disc_func 				disc_func_fix_leg,
								disc_func 				disc_func_flt_leg,
								tenor_surface  option(nullable) tenor_surface_flt_leg,
								vector(date) option(nullable) fixing_dates_flt_leg,
								vector(number) option(nullable) fixings_flt_leg,
								logical option(nullable) fixing_as_fwd_flt_leg,
								logical upd_null_crv ,
								logical upd_null_fix )//upd_nulls does not apply to notional
{
	QL_FAIL_COND(ccy_swap_,"not applicable for cross currency swaps", this,true);
	notional = conv_null_number_com(notional) ;
	//i().__swap_add_fixflt_data(notional,disc_func, tenor_surface_flt_leg,fixing_dates_flt_leg,
		//					   fixings_flt_leg, fixing_as_fwd_flt_leg, upd_nulls);

	i().__swap_add_fixflt_ext_data(	notional,disc_func_fix_leg, null<number>,notional,disc_func_flt_leg,null<number>,
									tenor_surface_flt_leg,fixing_dates_flt_leg,fixings_flt_leg, fixing_as_fwd_flt_leg,
									upd_null_crv,upd_null_fix);
	
	return ;
}

void swap_il_rr_fixflt.add_ccy_data(number 			notional_fix_leg,
									disc_func 		disc_func_fix_leg,
									number			fx_mult_fix_leg,
									number 			notional_flt_leg,
									disc_func 		disc_func_flt_leg,
									number			fx_mult_flt_leg,
									tenor_surface 	tenor_surface_flt_leg,
									vector(date) 	fixing_dates_flt_leg,
									vector(number) 	fixings_flt_leg,
									logical option(nullable) fixing_as_fwd_flt_leg,
									logical upd_null_crv ,
									logical upd_null_fix )//upd_nulls does not apply to notional 
{
	QL_FAIL_COND(!ccy_swap_,"applicable only for cross currency swaps", this,true);
	i().__swap_add_fixflt_ext_data(	notional_fix_leg,disc_func_fix_leg, fx_mult_fix_leg,notional_flt_leg,disc_func_flt_leg,
									fx_mult_flt_leg,tenor_surface_flt_leg,fixing_dates_flt_leg,fixings_flt_leg, fixing_as_fwd_flt_leg,
									upd_null_crv,upd_null_fix);
}

/*-----------------------------------------------------------------------
  add_cpi_link	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void swap_il_rr_fixflt.add_cpi_link(..cpi_link cpi_link)
{	
	error_info ee = error_info(true,true);
	ql_fix_infl_ci_leg l = fix_leg(false,ee );			
	l.set_cpi(cpi_link);
	return;
	
}
/*-----------------------------------------------------------------------
  add_cpi_link_forecast	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void swap_il_rr_fixflt.add_cpi_link_forecast(..cpi_link cpi_link)
{
	error_info ee = error_info(true,true);
	ql_fix_infl_ci_leg l = fix_leg(false,ee );			
	l.set_cpi_forecast(cpi_link);
	return;
}
/*-----------------------------------------------------------------------
  set_date 		EXT SWAP: ok
  ext_swap: if trade date is the same --> the settle date will be preserved (if not input)
  ----------------------------------------------------------------------*/
swap_il_rr_fixflt swap_il_rr_fixflt.set_date(	date  					trade_date, 
									date  option(nullable)	settle_date,
									error_info option(nullable) error )
{
	instrument cc;
	if(ext_swap_) {
		logical re_init = false; 
		logical init_quote = false;
		cc = instrument._set_date(trade_date,settle_date,re_init,init_quote,error);
	}
	else {
		QL_FAIL_COND(!null(settle_date),"input of settlement date only supported for non-db swaps",this,true );
		logical re_init = true; 
		logical init_quote = true;
		cc = instrument._set_date(trade_date,settle_date,re_init,init_quote,error);
	}
	return null(cc) ? null<swap_il_rr_fixflt>: dynamic_cast<swap_il_rr_fixflt>(cc);
	
}

/*-----------------------------------------------------------------------
  set_date <protected>		EXT SWAP: ok	
	re_init for swaps means that updated disc_funcs, fixing data etc is not preserved
	ext_swap: if trade date is the same --> the settle date will be preserved (if not input)	
  ----------------------------------------------------------------------*/
swap_il_rr_fixflt swap_il_rr_fixflt.set_date(	date  				trade_date, 
									date  option(nullable)	settle_date,
									logical 			re_init, 		//true->fail for ext_swap
									logical 			re_init_quote, 	//true->fail for ext_swap
									error_info option(nullable) error )
{
	QL_FAIL_COND(ext_swap_ && (re_init || re_init_quote),"re_init/re_init_quote flags = true not supported for non-db swaps",this,true );
	QL_FAIL_COND(!ext_swap_ && !null(settle_date),"input of settlement date only supported for non-db swaps",this,true );
	instrument cc = instrument._set_date(trade_date,settle_date,re_init,re_init_quote,error);
	return null(cc) ? null<swap_il_rr_fixflt>: dynamic_cast<swap_il_rr_fixflt>(cc);
	
}

/*-----------------------------------------------------------------------
  set_date <protected/legacy>		EXT SWAP: ok
  re_init for swaps means that updated disc_funcs, fixing data etc is not preserved
  ----------------------------------------------------------------------*/
swap_il_rr_fixflt swap_il_rr_fixflt.set_date(	date  				trade_date, 
									logical 			re_init, 
									error_info option(nullable) error ) 

{	
	instrument cc;
	if(ext_swap_){
		QL_FAIL_COND(re_init,"re_init = true not supported for non-db swaps",this,true );
		logical init_quote = false;
		cc = instrument._set_date(trade_date,null<date>,re_init,init_quote,error);
	}
	else{		
		logical init_quote = true;
		cc = instrument._set_date(trade_date,null<date>,re_init,init_quote,error);
	}
	return null(cc) ? null<swap_il_rr_fixflt>: dynamic_cast<swap_il_rr_fixflt>(cc);	
}


/*-----------------------------------------------------------------------
   move_date  <protected/legacy>		EXT SWAP: ok
	changes the trade date of the instrument without retrieving the 
 	corresponding quote from the database or the real-time feed.
	ext_swap: if trade date is the same --> the settle date will be preserved (if not input)	
  ----------------------------------------------------------------------*/
swap_il_rr_fixflt swap_il_rr_fixflt.move_date(	date  				trade_date, 
									date option(nullable) settle_date,
									error_info option(nullable) error ) 
{
	QL_FAIL_COND(!ext_swap_ && !null(settle_date),"input of settlement date only supported for non-db swaps",this,true );
	instrument cc = instrument._move_date(trade_date,settle_date,error);
	return null(cc) ? null<swap_il_rr_fixflt>: dynamic_cast<swap_il_rr_fixflt>(cc);
}
/*-----------------------------------------------------------------------
  swap_il_rr_fixflt: set_quote		EXT SWAP: ok
  ----------------------------------------------------------------------*/
swap_il_rr_fixflt swap_il_rr_fixflt.set_quote(	number 	option(nullable) quote,									
									error_info option(nullable) error )
{		
	instrument cc = instrument._set_quote(quote,null<date>, null<date>, true,error);
	return null(cc) ? null<swap_il_rr_fixflt>: dynamic_cast<swap_il_rr_fixflt>(cc);
}

/*-----------------------------------------------------------------------
  swap_il_rr_fixflt: set_quote 		EXT SWAP: will throw because of quote_side
  ----------------------------------------------------------------------*/
swap_il_rr_fixflt swap_il_rr_fixflt.set_quote(	string 	option(nullable) quote_side,
									error_info option(nullable) error )
{	
	instrument cc = instrument._set_quote(quote_side,null<date>, null<date>, true,error);
	return null(cc) ? null<swap_il_rr_fixflt>: dynamic_cast<swap_il_rr_fixflt>(cc);
}

/*-----------------------------------------------------------------------
  set_yield   FIX-FLT SWAP: yield == fix_cpn_rate  backward compat
  ----------------------------------------------------------------------*/
swap_il_rr_fixflt swap_il_rr_fixflt.set_yield(	number 	option(nullable) yield,							
												error_info option(nullable) error )
{
	QL_FAIL_COND(ext_swap_,"inapplicable function call for non-db swaps", this,true);

	error_info ee 	= new error_info(true,false);
	number y 		= this.yield(false,ee);
	number cpnr 	= this.coupon_rate(ee);
	if(null(y) || null(cpnr) || CORE_INT.is_equal(y,cpnr))
		return this.set_rate_fix_leg(yield,error);
	
	QL_FAIL_COND(ext_swap_,"inapplicable function call for non-par swaps", this,true);
	
}

/*-----------------------------------------------------------------------
  set_quote_from_yield  EXT SWAP: throws
  ----------------------------------------------------------------------*/
swap_il_rr_fixflt swap_il_rr_fixflt.set_quote_from_yield(number 	option(nullable) yield,
											error_info option(nullable) error )
{

	QL_FAIL_COND(ext_swap_,"inapplicable function call for non-db swaps", this,true);

	error_info ee 	= new error_info(true,false);
	number y 		= this.yield(false,ee);
	number cpnr 	= this.coupon_rate(ee);
	if(null(y) || null(cpnr) || CORE_INT.is_equal(y,cpnr)) {		
		instrument cc = instrument._set_quote_from_yield(yield,  true,error);
		return null(cc) ? null<swap_il_rr_fixflt>: dynamic_cast<swap_il_rr_fixflt>(cc);
	}
	QL_FAIL_COND(ext_swap_,"inapplicable function call for non-par swaps", this,true);
	
	
}

/*-----------------------------------------------------------------------
  set_rate_fix_leg  EXT SWAP: ok
  ----------------------------------------------------------------------*/
swap_il_rr_fixflt swap_il_rr_fixflt.set_rate_fix_leg(	number 	option(nullable) cpn_rate,							
											error_info option(nullable) error )
{
	try{
	
		if(!ext_swap_) {
			instrument cc = instrument._set_yield(	cpn_rate, null<date>, null<date>,true, error);
			return null(cc) ? null<swap_il_rr_fixflt>: dynamic_cast<swap_il_rr_fixflt>(cc);
		}

		error_info ee = new error_info(true,true);
		..quote_style qs = this.quote_style_e(ee);
		
		number q;
		if(qs == ..quote_style.YIELD_PCT)
			q = cpn_rate * 100;		
		__instrument  c = i().__swap_ext_set_quote(q, null<date>, null<date> );

		instr_error e = new instr_error();
		instrument cc 	= this.create( c, e, E_INIT);
		CORE_INT.instr_fail_check(null(cc), "invalid swap_il_rr_fixflt", this, e);
		
		if(!cc.is_valid(error)) 
			return null<swap_il_rr_fixflt>;	
				
		return dynamic_cast<swap_il_rr_fixflt>(cc);					
	}	
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_il_rr_fixflt.set_rate_fix_leg");
		return null<swap_il_rr_fixflt>;
	}
}




/*-----------------------------------------------------------------------
  set_pay_leg   --> returns an external swap, a db swap cannot be changed in regards to pay vs receive 
  ----------------------------------------------------------------------*/
swap_il_rr_fixflt swap_il_rr_fixflt.set_pay_leg(logical pay_fix,							
									error_info option(nullable) error )
{
	try{
		
		__instrument  c = i().__swap_set_pay_leg1(pay_fix );
		
		instr_error e = new instr_error();
		instrument cc 	= this.create( c, e, E_INIT);
		CORE_INT.instr_fail_check(null(cc), "invalid swap_il_rr_fixflt", this, e);
		
		if(!cc.is_valid(error)) 
			return null<swap_il_rr_fixflt>;	
				
		return dynamic_cast<swap_il_rr_fixflt>(cc);					
	}	
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_il_rr_fixflt.set_pay_leg");
		return null<swap_il_rr_fixflt>;
	}
}
/*-----------------------------------------------------------------------
  create_tenor_surface	(fwd is a fwd_func)  EXT SWAP: ok
  ----------------------------------------------------------------------*/
tenor_surface swap_il_rr_fixflt.create_tenor_surface(disc_func df,fwd_func fwdf)
{
	try{
		error_info ee 			= error_info(true,true);
		..ir_index ir			= this.ir_index(ee);
		CORE_INT.instr_fail_check(null(ir), "invalid ir_index", this, ee);
		
		//integer tenor_m			= integer(ir.tenor_months());	
		logical allow_extrap 	= false;		
		return tenor_surface(this.trade_date(), df,[fwdf],[ir],allow_extrap);
	}
	catch {
		return null<tenor_surface>;
	}
}
/*-----------------------------------------------------------------------
  create_tenor_surface	(fwd is a disc_func) EXT SWAP: ok
  ----------------------------------------------------------------------*/
tenor_surface swap_il_rr_fixflt.create_tenor_surface(disc_func df,disc_func fwddf)
{
	try{
		error_info ee 			= error_info(true,true);
		..ir_index ir			= this.ir_index(ee);
		CORE_INT.instr_fail_check(null(ir), "invalid ir_index", this, ee);
		
		//integer tenor_m			= integer(ir.tenor_months());	
		logical allow_extrap 	= false;		
		return tenor_surface(this.trade_date(), df,[fwddf],[ir],allow_extrap);
	}
	catch {
		return null<tenor_surface>;
	}
}

/*-----------------------------------------------------------------------
  set_to_par	EXT SWAP: ok,  not for currency swaps
  ----------------------------------------------------------------------*/
/*void swap_il_rr_fixflt.update_to_par(error_info option(nullable) error )
{
	try {
		QL_FAIL_COND(ccy_swap_,"inapplicable function call for cross currency swaps", this,true);

		error_info ee = error_info(true,true);
		disc_func df;
		fwd_func flt_fwd_func;
		this.implied_par_funcs(df,flt_fwd_func,null<number>,ee);		
		
		tenor_surface ts = create_tenor_surface( df,flt_fwd_func);
		QL_FAIL_COND(null(ts), "error creating tenor surface", this, true);

		vector(date) fd[0];
		vector(number) fr[0];
		//this.add_data(this.nominal(),df,ts,null<vector(date)>,null<vector(number)>,null<logical>, false);
		logical fix_as_fwd = false;
		logical upd_nulls = false;
		this.add_data(this.nominal(),df,ts,fd,fr,fix_as_fwd,upd_nulls);
		return;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_il_rr_fixflt.set_to_par");
		return;
	}
}*/

/*-----------------------------------------------------------------------
  settle_code  EXT SWAP: ok
  ----------------------------------------------------------------------*/
string swap_il_rr_fixflt.settle_code(error_info option(nullable) error )  option(hidden)
{	
	return swap_gen.settle_code(error);
}
/*-----------------------------------------------------------------------
  issue_date	DLL_SWAP_HANDLER: ok
  ----------------------------------------------------------------------*/
date  swap_il_rr_fixflt.issue_date(error_info option(nullable) error ) option(hidden)
{
	return instrument.issue_date(error);
}
/*-----------------------------------------------------------------------
  start_date	DLL_SWAP_HANDLER: ok
  ----------------------------------------------------------------------*/
date  swap_il_rr_fixflt.start_date(error_info option(nullable) error ) 
{
	return this.issue_date(error);
}

/*-----------------------------------------------------------------------
  fx_mult_factor	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_il_rr_fixflt.fx_mult_factor(	out number fx_mult_fix_leg, 
							out number fx_mult_flt_leg, 
							error_info option(nullable) error ) 
{	
	swap_gen.fx_mult_factor(fx_mult_fix_leg, fx_mult_flt_leg, error ) ;
	return;
}

/*-----------------------------------------------------------------------
  is_regular_first	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_il_rr_fixflt.is_regular_first(	out logical option(nullable) is_reg_fix_leg, 
									out logical option(nullable) is_reg_flt_leg, 
									error_info option(nullable) error ) 
{	
	try{
		error_info ee = error_info(true,true);
		
		ql_float_leg flt = this.float_leg(false,ee);
		is_reg_flt_leg = flt.is_reg_first_period();
		
		ql_fix_infl_ci_leg fix = this.fix_leg(false,ee);
		is_reg_fix_leg = fix.is_reg_first_period();
		
		return ;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_il_rr_fixflt.is_regular_first");
		is_reg_fix_leg = is_reg_flt_leg = null<logical >;
		return ;
	}
}

/*-----------------------------------------------------------------------
  is_regular_last	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_il_rr_fixflt.is_regular_last(	out logical option(nullable) is_reg_fix_leg, 
									out logical option(nullable) is_reg_flt_leg, 
									error_info option(nullable) error ) 
{	
	try{
		error_info ee = error_info(true,true);
		ql_float_leg flt = this.float_leg(false,ee);
		is_reg_flt_leg = flt.is_reg_last_period();
		
		ql_fix_infl_ci_leg fix = this.fix_leg(false,ee);
		is_reg_fix_leg = fix.is_reg_last_period();
		return ;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_il_rr_fixflt.is_regular_last");
		is_reg_fix_leg = is_reg_flt_leg = null<logical >;
		return ;
	}
}
/*-----------------------------------------------------------------------
  current_fixing_flt_leg	EXT SWAP: ok
  ----------------------------------------------------------------------*/
number	swap_il_rr_fixflt.current_fixing_flt_leg(out date reset_date,out logical is_fixed,
												 error_info option(nullable) error)
{
	try{
		error_info ee = error_info(true,true);
		ql_float_leg flt = this.float_leg(false,ee);

		return flt.current_fixing_rate(reset_date,is_fixed);
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_il_rr_fixflt.current_fixing_flt_leg");		
		return null<number>;
	}
}

/*-----------------------------------------------------------------------
  notional	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_il_rr_fixflt.notional(	out number notional_fix_leg, 
							out number notional_flt_leg, 
							error_info option(nullable) error ) 
{	
	swap_gen.notional( notional_fix_leg,notional_flt_leg, error ) ;
	return;
}


/*-----------------------------------------------------------------------
  notional	EXT SWAP: ok
  ----------------------------------------------------------------------*/
number  swap_il_rr_fixflt.notional(	error_info option(nullable) error ) 
{	
	return swap_gen.nominal(error);
}


/*-----------------------------------------------------------------------
  currency	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_il_rr_fixflt.currency(	out string curr_fix_leg, 
							out string curr_flt_leg, 
							error_info option(nullable) error ) 
{	
	swap_gen.currency(curr_fix_leg,  curr_flt_leg,  error);
	return;
}

/*-----------------------------------------------------------------------
  currency(fix leg- backward compat)	EXT SWAP: ok
  ----------------------------------------------------------------------*/
string  swap_il_rr_fixflt.currency(error_info option(nullable) error )  option(hidden)
{	
	string curr_fix_leg,  curr_flt_leg;
	swap_gen.currency(curr_fix_leg,  curr_flt_leg,  error);
	return curr_fix_leg;
}

/*-----------------------------------------------------------------------
  quote 	EXT SWAP: ok
  ----------------------------------------------------------------------*/
/*void  swap_il_rr_fixflt.quote(	out number quote_fix_leg, 
							out number quote_flt_leg, 
							error_info option(nullable) error ) 
{	
	try{	
		instr_error_type t;
   		string 			s;	
		i().__swap_quote(quote_fix_leg,quote_flt_leg,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_il_rr_fixflt.quote");
		if(e)
			quote_fix_leg = quote_flt_leg = null<number>;
		return ;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_il_rr_fixflt.quote");
		quote_fix_leg = quote_flt_leg = null<number>;
		return ;
	}
}*/
/*-----------------------------------------------------------------------
  spread_flt_leg 	EXT SWAP: ok
  ----------------------------------------------------------------------*/
number  swap_il_rr_fixflt.spread_flt_leg(error_info option(nullable) error ) 
{	
	/*try{	
		instr_error_type t;
   		string 			s;
		number quote_fix_leg,quote_flt_leg;
		i().__swap_quote(quote_fix_leg,quote_flt_leg,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_il_rr_fixflt.spread_flt_leg");
		return e ? null<number> : quote_flt_leg;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_il_rr_fixflt.spread_flt_leg");
		return null<number> ;
	}*/
	try{
		
		instr_error_type t;
   		string 			s;
		number q,quote_flt_leg;
		i().__swap_def_quote(q,quote_flt_leg,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_il_rr_fixflt.spread_flt_leg");
		if( e) {
			return null<number> ;
		}
		
		..quote_style qs = i().__swap_quote_style_e_leg2(t,s);
		e = CORE_INT.add_error_info(error,t,s, "swap_il_rr_fixflt.spread_flt_leg");
		if(e)
			return null<number>;
		
		switch(qs) {
			case ..quote_style.SPREAD:
				return quote_flt_leg;
			case ..quote_style.SPREAD_BP:					
			default:
				return quote_flt_leg/10000;
		}
							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_il_rr_fixflt.spread_flt_leg");
		return null<number> ;
	}
}

/*-----------------------------------------------------------------------
  coupon   	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_il_rr_fixflt.coupon(	out number cpn_fix_leg, 
							out number cpn_flt_leg, 
							error_info option(nullable) error ) 
{	
	try{	
		instr_error_type t;
   		string 			s;	
		i().__swap_coupon(cpn_fix_leg,cpn_flt_leg,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_il_rr_fixflt.coupon");
		if(e)
			cpn_fix_leg = cpn_flt_leg = null<number>;
		return ;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_il_rr_fixflt.coupon");
		cpn_fix_leg = cpn_flt_leg = null<number>;
		return ;
	}
}

/*-----------------------------------------------------------------------
  coupon_fix_leg	DLL_SWAP_HANDLER: ok
  ----------------------------------------------------------------------*/
number  swap_il_rr_fixflt.coupon_fix_leg(error_info option(nullable) error ) 
{	
	try{	
		instr_error_type t;
   		string 			s;	
		number c1,c2;
		i().__swap_coupon(c1,c2,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_il_rr_fixflt.coupon_fix_leg");	
		return e ? null<number>: c1;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_il_rr_fixflt.coupon_fix_leg");
		return null<number>;
	}
}

/*-----------------------------------------------------------------------
  coupon   (fix leg- backward compat)	DLL_SWAP_HANDLER: ok
  ----------------------------------------------------------------------*/
number  swap_il_rr_fixflt.coupon(error_info option(nullable) error )  option(hidden)
{	
	return this.coupon_fix_leg(error);
}
/*-----------------------------------------------------------------------
  current_coupon_flt_leg	DLL_SWAP_HANDLER: ok
  ----------------------------------------------------------------------*/
number  swap_il_rr_fixflt.current_coupon_flt_leg(error_info option(nullable) error ) 
{	
	try{	
		instr_error_type t;
   		string 			s;	
		number c1,c2;
		i().__swap_coupon(c1,c2,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_il_rr_fixflt.current_coupon_flt_leg");	
		return e ? null<number>: c2;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_il_rr_fixflt.current_coupon_flt_leg");
		return null<number>;
	}
}
/*-----------------------------------------------------------------------
  reset_freq_flt_leg	
  ----------------------------------------------------------------------*/
integer  swap_il_rr_fixflt.reset_freq_flt_leg(error_info option(nullable) error ) 
{	
	integer c1,c2;
	swap_gen.reset_freq(c1,c2  ,error ) ;
	return c2;
}
/*-----------------------------------------------------------------------
  dc_method   	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_il_rr_fixflt.dc_method(	out day_count_method  dc_method_fix_leg, 
								out day_count_method  dc_method_flt_leg, 
								error_info option(nullable) error ) 
{	
	swap_gen.dc_method(dc_method_fix_leg,dc_method_flt_leg,error);
	return;
}

/*-----------------------------------------------------------------------
  dc_method   (fix leg- backward compat)	EXT SWAP: ok
  ----------------------------------------------------------------------*/
day_count_method  swap_il_rr_fixflt.dc_method(error_info option(nullable) error )  option(hidden)
{	
	day_count_method dc_method_fix_leg,dc_method_flt_leg;
	swap_gen.dc_method(dc_method_fix_leg,dc_method_flt_leg,error);
	return dc_method_fix_leg;
}

/*-----------------------------------------------------------------------
  effective_date   	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_il_rr_fixflt.effective_date(	out date  effective_date_leg1, 
									out date  effective_date_leg2, 
									error_info option(nullable) error) 
{
	try{
		error_info ee = error_info(true,true);
		vector(ql_swap_leg) l = this.legs(false,ee);
		
		QL_FAIL_COND(v_size(l) < 2,"invalid swap_il_rr_fixflt", this, true);				
		effective_date_leg1 = l[0].effective_date();
		effective_date_leg2 = l[1].effective_date();
				
		return ;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_il_rr_fixflt.effective_date");		
		effective_date_leg1 = effective_date_leg2 = null<date>;
		return ;
	}
}

/*-----------------------------------------------------------------------
  cpn_start_date	EXT SWAP: ok
  ----------------------------------------------------------------------*/
date swap_il_rr_fixflt.cpn_start_date(error_info option(nullable) error) option(hidden)
{	
	try{	
		error_info ee = error_info(true,true);
		date  d1,  d2;
		this.effective_date(d1, d2, ee) ;
		CORE_INT.instr_fail_check(null(d1), "cpn_start_date", this, ee);
		return d1;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_il_rr_fixflt.cpn_start_date");
		return null<date>;
	}
}
/*-----------------------------------------------------------------------
  coupon_freq   	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_il_rr_fixflt.coupon_freq(	out integer  cpn_freq_fix_leg, 
								out integer  cpn_freq_flt_leg, 
								error_info option(nullable) error ) 
{	
	swap_gen.coupon_freq(cpn_freq_fix_leg,cpn_freq_flt_leg,error);
	return;
}

/*-----------------------------------------------------------------------
  coupon_freq   (fix leg- backward compat)	EXT SWAP: ok
  ----------------------------------------------------------------------*/
integer  swap_il_rr_fixflt.coupon_freq(error_info option(nullable) error )  option(hidden)
{	
	integer c1,c2;
	swap_gen.coupon_freq(c1,c2  ,error ) ;
	return c1;
}

/*-----------------------------------------------------------------------
  roll_day   	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_il_rr_fixflt.roll_day(	out integer  roll_day_fix_leg, 
							out integer  roll_day_flt_leg, 
							error_info option(nullable) error ) 
{	
	roll_day(roll_day_fix_leg, roll_day_flt_leg,  error ) ;
	return;
}

/*-----------------------------------------------------------------------
  roll_day	EXT SWAP: ok
  ----------------------------------------------------------------------*/
integer swap_il_rr_fixflt.roll_day(error_info option(nullable) error )  option(hidden)
{
	integer roll_day_fix_leg, roll_day_flt_leg;
	roll_day(roll_day_fix_leg, roll_day_flt_leg,  error ) ;
	return roll_day_fix_leg;
}

/*-----------------------------------------------------------------------
  eom   	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_il_rr_fixflt.eom(	out logical option(nullable)  	eom_fix_leg, 
						out logical option(nullable) 	eom_flt_leg, 
						error_info option(nullable) 	error ) 
{	
	swap_gen.eom(eom_fix_leg, eom_flt_leg,  error ) ;
	return;
}

/*-----------------------------------------------------------------------
  eom	EXT SWAP: ok
  ----------------------------------------------------------------------*/
logical swap_il_rr_fixflt.eom(error_info option(nullable) error )  option(hidden)
{	
	logical efix,eflt;
	swap_gen.eom(efix,eflt, error ) ;
	return efix;
}

/*-----------------------------------------------------------------------
  cal   	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_il_rr_fixflt.calendar(	out ..calendar option(nullable)  cal_fix_leg, 
							out ..calendar option(nullable) cal_flt_leg, 
							error_info option(nullable) error ) 
{	
	swap_gen.calendar(cal_fix_leg, cal_flt_leg,  error ) ;
	return;
}

/*-----------------------------------------------------------------------
  calendar  	EXT SWAP: ok
  ----------------------------------------------------------------------*/
/*..calendar swap_il_rr_fixflt.calendar(error_info option(nullable) error )  option(hidden)
{	
	try{
		QL_FAIL_COND(ccy_swap_,"inapplicable function call for currency swaps (use 2-leg version)", this,true);
		
		instr_error_type t;
   		string 			s;	
		..calendar c1,c2;
		i().__swap_calendar(c1,c2,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_il_rr_fixflt.calendar");	
		return e ? null<..calendar>: c1;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_il_rr_fixflt.calendar");
		return null<..calendar>;
	}
}*/
/*-----------------------------------------------------------------------
  calendar
  ----------------------------------------------------------------------*/
/*calendar swap_il_rr_fixflt.calendar(integer index, error_info option(nullable) error) option(hidden)
{
	try {
		QL_FAIL_COND(index != 0,"function call not applicable swaps (only index = 0 is supported)", this,true);

		return this.calendar(error );
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_il_rr_fixflt.calendar");
		return null<..calendar>;
	}
}*/
/*-----------------------------------------------------------------------
  calendar_name  	
  ----------------------------------------------------------------------*/
/*string swap_il_rr_fixflt.calendar_name(error_info option(nullable) error )  option(hidden)
{	
	try{
		QL_FAIL_COND(ext_swap_,"inapplicable function call for non-db swaps", this,true);
		QL_FAIL_COND(ccy_swap_,"inapplicable function call for currency swaps (use 2-leg version)", this,true);

		return this.instr_def(error).swap_calendar_name_leg1(error);
								
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_il_rr_fixflt.calendar_name");
		return null<string>;
	}
}*/
/*-----------------------------------------------------------------------
  calendar_name  	
  ----------------------------------------------------------------------*/
/*string swap_il_rr_fixflt.calendar_name(integer index,
								 error_info option(nullable) error )  option(hidden)
{	
	try{
		QL_FAIL_COND(index != 0,"function call not applicable swaps (only index = 0 is supported)", this,true);		
		return this.calendar_name(error);
								
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_il_rr_fixflt.calendar_name");
		return null<string>;
	}
}*/
/*-----------------------------------------------------------------------
  pmt_bus_day 	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_il_rr_fixflt.pmt_bus_day(	out bd_convention option(nullable) pmt_bus_day_fix_leg, 
								out bd_convention option(nullable) pmt_bus_day_flt_leg, 
								error_info option(nullable) error ) 
{	
	swap_gen.pmt_bus_day(pmt_bus_day_fix_leg, pmt_bus_day_flt_leg,  error ) ;
	return;
}

/*-----------------------------------------------------------------------
  pmt_bus_day   (fix leg- backward compat)	EXT SWAP: ok
  ----------------------------------------------------------------------*/
bd_convention swap_il_rr_fixflt.pmt_bus_day(error_info option(nullable) error )  option(hidden)
{
	bd_convention b1,b2;
	swap_gen.pmt_bus_day(b1,b2,  error ) ;
	return b1;
}
/*-----------------------------------------------------------------------
  index_dates_flt_leg	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_il_rr_fixflt.index_dates_flt_leg(	logical 							post_settle, 
										out vector(date)  	index_start_dates,									
										out vector(date)  	index_end_dates,
										out vector(logical) option(nullable) index_regular,
										error_info option(nullable) 		error ) 
{	
	try{	
		instr_error_type t;
   		string 			s;	
		i().__swap_index_dates(post_settle,index_start_dates,index_end_dates,index_regular, false,false,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_il_rr_fixflt.index_dates_flt_leg");
		if(e) {
			index_start_dates = index_end_dates = null<vector(date)>; 
			index_regular = null<vector(logical)>;
		}			
		return ;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_il_rr_fixflt.index_dates_flt_leg");
		index_start_dates = index_end_dates = null<vector(date)>; 
		index_regular = null<vector(logical)>; 
		return ;
	}
}

/*-----------------------------------------------------------------------
  fixing_data_flt_leg	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_il_rr_fixflt.fixing_data_flt_leg(logical 					post_trade_date,
											logical option(nullable)	only_fixed, 
											out vector(date)   			reset_date,									
											out vector(number)   		rate,
											out vector(logical) option(nullable) is_fixed,
											error_info option(nullable) error ) 
{	
	try{
		error_info ee = error_info(true,true);
		ql_float_leg flt = this.float_leg(false,ee);
		
		date cut_off = post_trade_date ? this.trade_date(): null<date>;
		flt.fixing_data(only_fixed,reset_date,rate,is_fixed,cut_off);

		return ;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_il_rr_fixflt.fixing_data_flt_leg");
		reset_date = null<vector(date)>; 
		rate = null<vector(number)>; 
		is_fixed = null<vector(logical)>;
		return ;
	}
}


/*-----------------------------------------------------------------------
  cash_flow_dates	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_il_rr_fixflt.cash_flow_dates(logical 			post_settle, 
										out vector(date) 	pmt_dates_fix_leg,									
										out vector(date) 	pmt_dates_flt_leg,
										error_info option(nullable) error ) 
{	
	try{	
		instr_error_type t;
   		string 			s;	
		i().__swap_ir_pmt_dates(post_settle,pmt_dates_fix_leg,pmt_dates_flt_leg, t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_il_rr_fixflt.cash_flow_dates");
		if(e) {
			pmt_dates_fix_leg = pmt_dates_flt_leg = null<vector(date)>; 
		}
		return;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_il_rr_fixflt.cash_flow_dates");
		pmt_dates_fix_leg = pmt_dates_flt_leg = null<vector(date)>; 
		return ;
	}
}

/*-----------------------------------------------------------------------
  cash_flow_dates override (fix leg- backward compat)	EXT SWAP: ok
  ----------------------------------------------------------------------*/
/*vector(date) swap_il_rr_fixflt.cash_flow_dates(	logical post_settle, 
											logical adj_dates,   
											logical keep_size,  
											error_info option(nullable) error )
{	
	try{
		QL_FAIL_COND(keep_size == true,"keep size = true not applicable for swaps", this, true);

		vector(date) pmt_dates_leg1,pmt_dates_leg2;
		this.cash_flow_dates(post_settle,pmt_dates_leg1,pmt_dates_leg2,error);
		return pmt_dates_leg1;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_il_rr_fixflt.cash_flow_dates");
		return null<vector(date)>;
	}
}*/

/*-----------------------------------------------------------------------
  cash_flows_cpn	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_il_rr_fixflt.cash_flows_cpn(	logical 			post_settle, 
									out vector(number) 	cpn_cf_fix_leg,									
									out vector(number) 	cpn_cf_flt_leg,
									error_info option(nullable) error ) 
{	
	try{	
		instr_error_type t;
   		string 			s;	
		i().__swap_cashflows_cpn(post_settle,cpn_cf_fix_leg,cpn_cf_flt_leg, t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_il_rr_fixflt.cash_flows_cpn");
		if(e) {
			cpn_cf_fix_leg = cpn_cf_flt_leg = null<vector(number)>;
		}
		return;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_il_rr_fixflt.cash_flows_cpn");
		cpn_cf_fix_leg = cpn_cf_flt_leg = null<vector(number)>;
		return ;
	}
}

/*-----------------------------------------------------------------------
  cash_flows_cpn override-protected  (fix leg- backward compat)	EXT SWAP: ok
  ----------------------------------------------------------------------*/
/*vector(number) swap_il_rr_fixflt.cash_flows_cpn(	number option(nullable) nominal, 
											logical post_settle, 
											logical keep_size,  
											error_info option(nullable) error )
{	
	try{
		QL_FAIL_COND(keep_size == true,"keep size = true not applicable for swaps", this, true);
		QL_FAIL_COND(!null(nominal) && nominal != this.nominal(),"input of nominal not applicable for swaps", this, true);

		error_info ee = new error_info(true,true);
		vector(number) cf_leg1,cf_leg2;
		this.cash_flows_cpn(post_settle,cf_leg1,cf_leg2, ee);
		
		for(integer i=0;i<v_size(cf_leg1);i++)
			cf_leg1[i] = abs(cf_leg1[i]);
		return cf_leg1;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_il_rr_fixflt.cash_flows_cpn");
		return null<vector(number)>;
	}

}*/
/*-----------------------------------------------------------------------
  cash_flows	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_il_rr_fixflt.cash_flows(	logical 			post_settle, 
								out vector(number) 	cf_fix_leg,									
								out vector(number) 	cf_flt_leg,
								error_info option(nullable) error ) 
{	
	try{	
		instr_error_type t;
   		string 			s;	
		logical or=true;
		i().__swap_cashflows(post_settle,or,cf_fix_leg,cf_flt_leg, t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_il_rr_fixflt.cash_flows");
		if(e) {
			cf_fix_leg = cf_flt_leg = null<vector(number)>;
		}
		return;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_il_rr_fixflt.cash_flows");
		cf_fix_leg = cf_flt_leg = null<vector(number)>;
		return ;
	}
}

/*-----------------------------------------------------------------------
  cash_flows  LEGACY, prot
  ----------------------------------------------------------------------*/
/*void swap_il_rr_fixflt.cash_flows(out vector(date)   dates,
    						out vector(number)   amounts,
							number option(nullable) nominal ,
							logical post_settle,							
							error_info option(nullable) error)  
{
	//instr_error_type t;
   	//	string 			s;	
	//amounts = i().__cash_flows(nominal ,post_settle, false, t, s);

		
	QL_FAIL_COND(!null(nominal) && nominal != this.nominal(),"input of nominal not applicable for swaps", this, true);
	vector(date) pmt_dates_flt_leg;									
	vector(number) cf_flt_leg;

	this.cash_flow_data(	post_settle, ir_cf_code.COUPON, dates,amounts,
							pmt_dates_flt_leg,	cf_flt_leg,error );

	number notional_fix_leg,  notional_flt_leg;
	notional(notional_fix_leg, notional_flt_leg, error ) ;
	integer s = v_size(amounts);
	for(integer i=0; i<s;i++){
		amounts[i] = abs(amounts[i]);
	}
	amounts[s-1] += abs(notional_fix_leg);
}*/
/*-----------------------------------------------------------------------
  cash_flow_dates_noadj  LEGACY, prot
  ----------------------------------------------------------------------*/
/*vector(date) swap_il_rr_fixflt.cash_flow_dates_noadj(	logical 	post_settle,
												error_info option(nullable) error) 
												
{
	vector(date)  dates;
	vector(number)  amounts;
	this.cash_flow_data(null<number>, post_settle, ir_cf_code.TOTAL,false,false,  
						dates,  amounts, error );
	return dates;
}*/

/*-----------------------------------------------------------------------
  cash_flow_amounts  LEGACY, prot
  ----------------------------------------------------------------------*/
/*vector(number) swap_il_rr_fixflt.cash_flow_amounts(number option(nullable) nominal,
											logical post_settle,
											logical keep_size,											
											error_info option(nullable) error) 

{	
	vector(date)  dates;
	vector(number)  amounts;
	this.cash_flow_data(nominal, post_settle, ir_cf_code.COUPON,false,keep_size,  
						dates,  amounts, error );

	number notional_fix_leg,  notional_flt_leg;
	notional(notional_fix_leg, notional_flt_leg, error ) ;
	integer s = v_size(amounts);
	for(integer i=0; i<s;i++){
		amounts[i] = abs(amounts[i]);
	}
	amounts[s-1] += abs(notional_fix_leg);
	
	return amounts;
}*/
/*-----------------------------------------------------------------------
  cash_flow_nom_amounts  LEGACY, prot
  ----------------------------------------------------------------------*/
/*vector(number) swap_il_rr_fixflt.cash_flow_nom_amounts(number option(nullable) nominal,
												logical post_settle,
												logical keep_size,
												error_info option(nullable) error) option(hidden)
{	
	return cash_flow_amounts(nominal,post_settle, keep_size,error) ;
}*/
/*-----------------------------------------------------------------------
  cash_flows  override, protected	EXT SWAP: ok
  ----------------------------------------------------------------------*/
/*vector(number) swap_il_rr_fixflt.cash_flows(	number option(nullable) nominal, 
										logical 				post_settle, 
										logical 				keep_size,  
										error_info option(nullable) error )
{	
	try{
		QL_FAIL_COND(keep_size == true,"keep size = true not applicable for swaps", this, true);
		QL_FAIL_COND(!null(nominal) && nominal != this.nominal(),"input of nominal not applicable for swaps", this, true);

		error_info ee = new error_info(true,true);
		vector(number) cf_leg1,cf_leg2;
		this.cash_flows(post_settle,cf_leg1,cf_leg2, ee);
		
		for(integer i=0;i<v_size(cf_leg1);i++)
			cf_leg1[i] = abs(cf_leg1[i]);
		return cf_leg1;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_il_rr_fixflt.cash_flows");
		return null<vector(number)>;
	}
}*/

/*-----------------------------------------------------------------------
  cash_flow_data	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_il_rr_fixflt.cash_flow_data(	logical 							post_settle,
									ir_cf_code 							cf_code, 
									out vector(date)  	pmt_dates_fix_leg,									
									out vector(number)   cf_fix_leg,
									out vector(date)  	pmt_dates_flt_leg,									
									out vector(number)  	cf_flt_leg,
									error_info option(nullable) 		error ) 
{	
	try{
		error_info ee = new error_info(true,true);
		this.cash_flow_dates(post_settle, pmt_dates_fix_leg,pmt_dates_flt_leg,ee) ;
		
		if(cf_code == ir_cf_code.COUPON) {
			this.cash_flows_cpn(post_settle, cf_fix_leg,cf_flt_leg,ee) ;
		}
		else if	(cf_code == ir_cf_code.PRINCIPAL) {
			this.cash_flows(post_settle,cf_fix_leg,cf_flt_leg,ee) ;
			vector(number) cpn1,cpn2;
			this.cash_flows_cpn(post_settle,cpn1,cpn2,ee) ;
			cf_fix_leg -= cpn1;
			cf_flt_leg -= cpn2;
		}
		else {
			this.cash_flows(post_settle,cf_fix_leg,cf_flt_leg,ee) ;
		}
		return ;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_il_rr_fixflt.cash_flow_data");
		cf_fix_leg = cf_flt_leg = null<vector(number)>;
		pmt_dates_fix_leg= pmt_dates_flt_leg = null<vector(date)>;
		return ;
	}
}

/*-----------------------------------------------------------------------
  cash_flow_data protected, override	EXT SWAP: ok
  ----------------------------------------------------------------------*/
/*void swap_il_rr_fixflt.cash_flow_data(number option(nullable) nominal, 
								logical 				post_settle, 
								ir_cf_code 				cf_code,
								logical 				adj_dates, 
								logical 				keep_size,  
								out vector(date)   	dates,  
								out vector(number)   amounts,								
								error_info option(nullable) error ) 
{	
	try{
		QL_FAIL_COND(keep_size == true,"keep size = true not applicable for swaps", this, true);
		QL_FAIL_COND(!null(nominal) && nominal != this.nominal(),"input of nominal not applicable for swaps", this, true);

		error_info ee = new error_info(true,true);
		vector(number) cf_leg2;
		vector(date) dates_leg2;
		this.cash_flow_data(post_settle,cf_code, dates,amounts,  dates_leg2, cf_leg2, ee);
		for(integer i=0;i<v_size(amounts);i++)
			amounts[i] = abs(amounts[i]);
		return ;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_il_rr_fixflt.cash_flow_data");
		return ;
	}

}*/

/*-----------------------------------------------------------------------
  cash_flow_data	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_il_rr_fixflt.cash_flow_data(logical 							post_settle,
								logical option(nullable) 			trade_date_pv,
								out vector(date)   	pmt_date_fix_leg,
								out vector(number)   cpn_rate_fix_leg,
								out vector(number)   cpn_cashflow_fix_leg,
								out vector(number)   pv_cpn_cashflow_fix_leg,
								out vector(number)   fee_fix_leg,
								out vector(number)   pv_fee_fix_leg,
								out vector(number)   notional_fix_leg,
								out vector(date)   	pmt_date_flt_leg,
								out vector(number)   cpn_rate_flt_leg,
								out vector(number)   cpn_cashflow_flt_leg,
								out vector(number)   pv_cpn_cashflow_flt_leg,
								out vector(number)   fee_flt_leg,
								out vector(number)   pv_fee_flt_leg,
								out vector(number)   notional_flt_leg,
								error_info option(nullable) 		error ) 
{	
	try{	
		instr_error_type t;
   		string 			s;	
		i().__swap_payment_data(trade_date_pv,post_settle, 
								pmt_date_fix_leg,
								cpn_rate_fix_leg,
								cpn_cashflow_fix_leg,
								pv_cpn_cashflow_fix_leg,
								fee_fix_leg,
								pv_fee_fix_leg,
								notional_fix_leg,
								pmt_date_flt_leg,
								cpn_rate_flt_leg,
								cpn_cashflow_flt_leg,
								pv_cpn_cashflow_flt_leg,
								fee_flt_leg,
								pv_fee_flt_leg,
								notional_flt_leg, t,s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_il_rr_fixflt.cash_flow_data");
		if(e) {
			cpn_rate_fix_leg = cpn_cashflow_fix_leg = pv_cpn_cashflow_fix_leg = fee_fix_leg = null<vector(number)>;
			pv_fee_fix_leg = notional_fix_leg = null<vector(number)>;
			cpn_rate_flt_leg = cpn_cashflow_flt_leg = pv_cpn_cashflow_flt_leg = fee_flt_leg = null<vector(number)>;
			pv_fee_flt_leg = notional_flt_leg = null<vector(number)>;
			pmt_date_fix_leg= pmt_date_flt_leg = null<vector(date)>; 
		}			
		return ;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_il_rr_fixflt.cash_flow_data");
		cpn_rate_fix_leg = cpn_cashflow_fix_leg = pv_cpn_cashflow_fix_leg = fee_fix_leg = null<vector(number)>;
		pv_fee_fix_leg = notional_fix_leg = null<vector(number)>;
		cpn_rate_flt_leg = cpn_cashflow_flt_leg = pv_cpn_cashflow_flt_leg = fee_flt_leg = null<vector(number)>;
		pv_fee_flt_leg = notional_flt_leg = null<vector(number)>;
		pmt_date_fix_leg= pmt_date_flt_leg = null<vector(date)>; 
		return ;
	}
}


/*-----------------------------------------------------------------------
  data	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_il_rr_fixflt.data(out swap_fix_infl_ci_leg_data fix_leg_data,
							 out swap_flt_leg_data	float_leg_data,
							 error_info option(nullable) error )
{
	try{
		error_info ee = new error_info(true,true);
		vector(ql_swap_leg) l = legs(false,ee);
		fix_leg_data = new swap_fix_infl_ci_leg_data(l[0]);
		float_leg_data = new swap_flt_leg_data(l[1],true);
		return ;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_il_rr_fixflt.data");
		fix_leg_data = null<swap_fix_infl_ci_leg_data>;
		float_leg_data = null<swap_flt_leg_data>;
		return ;
	}
}
/*-----------------------------------------------------------------------
  accrued	EXT SWAP: ok
  ----------------------------------------------------------------------*/
/*number  swap_il_rr_fixflt.accrued(logical 	disable_rounding,
							logical 	in_pcnt,
							error_info option(nullable) error ) 
{
	number accr_leg1,accr_leg2;
	return this.accrued(in_pcnt,accr_leg1,accr_leg2,error);
}*/
/*-----------------------------------------------------------------------
  accrued	EXT SWAP: ok
  ----------------------------------------------------------------------*/
number  swap_il_rr_fixflt.accrued(logical 					in_pcnt,
							out number accr_fix_leg,									
							out number accr_flt_leg,
							error_info option(nullable) error ) 
option(com_name: 'accrued_ext')
{	
	try{	
		instr_error_type t;
   		string 			s;	
		number c = i().__swap_accrued(in_pcnt,accr_fix_leg,accr_flt_leg, t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_il_rr_fixflt.accrued");
		if(e) {
			accr_fix_leg = accr_flt_leg = null<number>;
			return  null<number>;
		}
		return c;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_il_rr_fixflt.accrued");
		accr_fix_leg = accr_flt_leg = null<number>; 
		return null<number>;
	}
}

/*-----------------------------------------------------------------------
  accrued_period	backward compat, returns leg1 data  EXT SWAP: ok
  ----------------------------------------------------------------------*/
/*number  swap_il_rr_fixflt.accrued_period(	out integer 				n_days_fix_leg,
									error_info option(nullable) error ) 
{
	try {
		error_info ee = new error_info(true,true);
		number period_leg1,period_leg2;
		integer n_days_leg2;
		this.accrued_period(period_leg1,period_leg2,n_days_fix_leg,n_days_leg2,ee);
		return period_leg1;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_il_rr_fixflt.accrued_period");
		n_days_fix_leg = err_int();
		return null<number>;
	}
}*/
/*-----------------------------------------------------------------------
  accrued_period  EXT SWAP: ok
  ----------------------------------------------------------------------*/
void swap_il_rr_fixflt.accrued_period(	out number period_fix_leg,
									out number period_flt_leg,
									out integer 				n_days_fix_leg,
									out integer 				n_days_flt_leg,
									error_info option(nullable) error ) 
{	
	try{	
		instr_error_type t;
   		string 			s;	
		i().__swap_accrued_period(period_fix_leg,period_flt_leg,n_days_fix_leg,n_days_flt_leg,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_il_rr_fixflt.accrued_period");
		if(e) {
			period_fix_leg = period_flt_leg = null<number>;
			n_days_fix_leg = n_days_flt_leg = err_int();
		}
		return ;					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_il_rr_fixflt.accrued_period");
		period_fix_leg = period_flt_leg = null<number>;
		n_days_fix_leg = n_days_flt_leg = err_int();
		return ;
	}
}

/*-----------------------------------------------------------------------
  accrued_chg  protected
  ----------------------------------------------------------------------*/
/*number  swap_il_rr_fixflt.accrued_chg(integer 					bus_days,
								out	number option(nullable)	cpn_cashflow,
								out date 	settle,
								out date 	settle_next,	
								logical 					in_pcnt,								
								error_info option(nullable) error ) 
{	
	try {
		QL_FAIL_COND(in_pcnt,"in_pcnt = true not applicable", this, true);	

		error_info ee = new error_info(true,true);
		number cpn_cashflow_leg2,ai_chg_leg1,ai_chg_leg2;
		number c = this.accrued_chg(bus_days,ai_chg_leg1,ai_chg_leg2,
									cpn_cashflow,cpn_cashflow_leg2,
									settle,settle_next,ee);		
		return c;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_il_rr_fixflt.accrued_chg");
		cpn_cashflow = null<number>;
		settle = settle_next = null<date>;
		return null<number>;
	}
}*/

/*-----------------------------------------------------------------------
  accrued_chg  EXT SWAP: ok
  ----------------------------------------------------------------------*/
number swap_il_rr_fixflt.accrued_chg  (	integer 					bus_days,
									out	number option(nullable)	ai_chg_fix_leg,
									out	number option(nullable)	ai_chg_flt_leg,
									out	number option(nullable)	cpn_cashflow_fix_leg,
									out	number option(nullable)	cpn_cashflow_flt_leg,
									out date settle,
									out date settle_next,	
									error_info option(nullable) error ) 
{	
	try{	
		instr_error_type t;
   		string 			s;	
		number c = i().__swap_accrued_chg(bus_days,ai_chg_fix_leg,ai_chg_flt_leg,cpn_cashflow_fix_leg,cpn_cashflow_flt_leg,settle, settle_next,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_il_rr_fixflt.accrued_chg");
		if(e) {
			ai_chg_fix_leg = ai_chg_flt_leg = cpn_cashflow_fix_leg = cpn_cashflow_flt_leg = null<number>;
			settle = settle_next = null<date>;
		}
		return c;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_il_rr_fixflt.accrued_chg");
		ai_chg_fix_leg = ai_chg_flt_leg = cpn_cashflow_fix_leg = cpn_cashflow_flt_leg = null<number>;
		settle = settle_next = null<date>;
		return null<number>;
	}
}

/*-----------------------------------------------------------------------
  df_shifted_flt_leg  prot
  ----------------------------------------------------------------------*/
disc_func swap_il_rr_fixflt.df_shifted_flt_leg(	number 		delta_disc,
											disc_func 	df)
{
	
	if(delta_disc == 0)
		return df;

	error_info ee = new error_info(true,true);
	
	vector(date) index_start_dates,index_end_dates;
	vector(logical) index_regular;
	this.index_dates_flt_leg(true, index_start_dates,index_end_dates,index_regular,ee);		
	day_count_method dc = this.ir_index(ee).day_count_method();
					
	disc_func df_shifted = CORE_INT.fwd_parallell_shift_df(	df, delta_disc, this.trade_date(), index_start_dates, index_end_dates, dc);
	return df_shifted;
	
}

/*-----------------------------------------------------------------------
  fwd_shifted_flt_leg		DUPLICATED FROM fltflt
  ----------------------------------------------------------------------*/
tenor_surface swap_il_rr_fixflt.fwd_shifted_flt_leg(number 			delta_fwd,
												disc_func 		df,							
												tenor_surface 	ts)
{	
	if(delta_fwd == 0)
		return ts;

	error_info ee = new error_info(true,true);
	tenor_code tc 	= this.index_tenor_code(ee);
	tenor_surface ts_delta;
	
	if(!ts.fwd_is_disc_func()) {
		fwd_func  fwdf 			= ts.fwd_curve_f(tc);
		fwd_func fwd_delta 		= CORE_INT.fwd_parallell_shift_f(fwdf,delta_fwd);
		ts_delta 				= create_tenor_surface( df,fwd_delta);			
	}
	else {						
		disc_func fwddf 		= ts.fwd_curve_d(tc);
		vector(date) index_start_dates,index_end_dates;
		vector(logical) index_regular;			
		this.index_dates_flt_leg(true, index_start_dates,index_end_dates,index_regular,ee);
		day_count_method dc 	= this.ir_index(ee).day_count_method();
		disc_func fwddf_delta 	= CORE_INT.fwd_parallell_shift_df(	fwddf,delta_fwd,this.trade_date(),
																	index_start_dates, index_end_dates, dc);
		ts_delta 				= create_tenor_surface( df,fwddf_delta);
	}
	return ts_delta;
}


/*-----------------------------------------------------------------------
  dv01
  DV01 refers to dollar value of 1 basis point and it's the change in value of the npv
  of the instrument with a change of 1 basis point in the curve(s).
  ----------------------------------------------------------------------*/
/*number  swap_il_rr_fixflt.dv01(	number option(nullable) delta, 
							logical option(nullable) trade_date_pv,
							error_info option(nullable) error ) 
{
	number pvdiff = delta_pvdiff(delta, delta, trade_date_pv,error ) ;	
	return pvdiff / delta / 10000.0;
}*/
/*-----------------------------------------------------------------------
  delta_risk_disc
  ----------------------------------------------------------------------*/
/*number  swap_il_rr_fixflt.delta_risk_disc(	number option(nullable) delta, 
								logical option(nullable) trade_date_pv,
								error_info option(nullable) error ) 
{
	number pvdiff = delta_pvdiff(delta,0, trade_date_pv,error ) ;	
	return pvdiff / delta / 10000.0;
	
}*/
/*-----------------------------------------------------------------------
  delta_risk
  ----------------------------------------------------------------------*/
/*number  swap_il_rr_fixflt.delta_risk(	logical 					incl_disc,
								number option(nullable) 	delta,								
								logical option(nullable) 	trade_date_pv,
								error_info option(nullable) error ) 
{
	number delta_disc = incl_disc ? delta: 0;	
	number pvdiff = delta_pvdiff(delta_disc, delta, trade_date_pv,error ) ;
	
	return pvdiff / delta / 10000.0;
	
}*/
/*-----------------------------------------------------------------------
  delta_pvdiff  WORK IN PROGRESS
  ----------------------------------------------------------------------*/
/*number  swap_il_rr_fixflt.delta_pvdiff(	number option(nullable) 	delta_disc,
									number option(nullable) 	delta_fwd, 
									logical option(nullable) 	trade_date_pv,
									error_info option(nullable) error ) 
{
	if(null(delta_disc))		
		delta_disc = 0.0001;
	if(null(delta_fwd) )
		delta_fwd = 0.0001;
	
	if(null(trade_date_pv))
		trade_date_pv = false;
	number pv,pvdiff_fix, pvdiff_flt;	
	number pvdiff = pvdiff_curve_shift(	delta_disc, delta_disc, delta_fwd, trade_date_pv, pv, pvdiff_fix, pvdiff_flt, error );
	return pvdiff ;
	
}*/

/*-----------------------------------------------------------------------
  deltapv_fix_cpn_rate	EXT SWAP: ok
  ----------------------------------------------------------------------*/
number  swap_il_rr_fixflt.deltapv_fix_cpn_rate(	number 						delta_fix_cpn_rate,									
											disc_func option(nullable) df,
											error_info option(nullable) error ) 
{	
	try{	
		error_info ee = new error_info(true,true);
		disc_func df_orig = this.disc_func_fix_leg(ee);

		logical upd = false;
		if(!null(df)){
			this.add_disc_func_fix_leg(df);
			upd = true;
		}
		else if(null(df_orig)) {	
			disc_func _df = this.implied_par_disc_func_fix_leg(ee);
			this.add_disc_func_fix_leg(_df);
			upd = true;
		}

		instr_error_type t;
   		string 			s;	
		number c = i().__swap_pv_diff_fix_leg(delta_fix_cpn_rate, true,t, s);

		if(upd )
			this.add_disc_func_fix_leg(df_orig);

		logical e = CORE_INT.add_error_info(error,t,s, "swap_il_rr_fixflt.deltapv_fix_cpn_rate");	
		return e ? null<number>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_il_rr_fixflt.deltapv_fix_cpn_rate");
		return null<number>;
	}
}


/*-----------------------------------------------------------------------
  pv01	EXT SWAP: ok  - always returns a positive number regardless of pay/receive and sign of notional
  Note: not a "true" measure of risk, does not take into account if the swap has a pv <> 0
   PV01 refers to present value of 1 basis point and it's the discounted value of the cashflows
  for a rate of 0.01% for all periods of a particular instrument, ie, the npv of the fixed leg with a rate of 0.01%
  ----------------------------------------------------------------------*/
number  swap_il_rr_fixflt.pv01(	number option(nullable) notional,
							number option(nullable) delta,
							//logical option(nullable) trade_date_pv,
							disc_func option(nullable) df,
							error_info option(nullable) error ) 
{	
	return swap_gen.pv01_fix_leg(notional,delta,df,error);
}


/*-----------------------------------------------------------------------
  pvbp	EXT SWAP: ok
  ----------------------------------------------------------------------*/
number  swap_il_rr_fixflt.pvbp(	number option(nullable) nominal,
							number option(nullable) delta,
							logical option(nullable) centered,
							logical option(nullable) disable_rounding,	
							error_info option(nullable) error ) 
{	
	try {
		error_info ee = new error_info(true,true);
		number pv01_ = this.pv01(nominal,delta,null<disc_func>,ee); //always positive
		if(!null(nominal) && nominal < 0)
			return -pv01_;
		else
			return pv01_;					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_il_rr_fixflt.pvbp");
		return null<number>;
	}
}

/*-----------------------------------------------------------------------
  pvbp	EXT SWAP: ok
  ----------------------------------------------------------------------*/
number  swap_il_rr_fixflt.pvbp(	number 	option(nullable) nominal,
							number  option(nullable) delta,																																		
							error_info option(nullable) error ) 
{	
	try{			
		error_info ee = new error_info(true,true);
		number pv01_ = this.pv01(nominal,delta, null<disc_func>,ee);//always positive
		if(!null(nominal) && nominal < 0)
			return -pv01_;
		else
			return pv01_;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_il_rr_fixflt.pvbp");
		return null<number>;
	}
}

/*-----------------------------------------------------------------------
  implied_par_disc_func_fix_leg		EXT SWAP: ok	prot
  ----------------------------------------------------------------------*/
/*disc_func swap_il_rr_fixflt.implied_par_disc_func_fix_leg(error_info option(nullable) error )
{
	try{
		error_info ee = new error_info(true,true);
		vector(date) dates;
		vector(number) amounts;
		logical ok = this.cash_flows_bootstrap(dates,amounts,ee);
		QL_FAIL_COND(!ok,"error creating bootstrap cashflows", this, true);
		
		CORE_INT.curve_min c = new CORE_INT.curve_min(this.trade_date(),dates,amounts,false);
		disc_func df = CORE_INT.bootstrap_min(c);
		QL_FAIL_COND(null(df),"error creating disc_func", this, true);	
		
		return df;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_il_rr_fixflt.implied_par_disc_func_fix_leg");
		return null<disc_func>;
	}
}*/

/*-----------------------------------------------------------------------
  implied_par_funcs		EXT SWAP: ok
  ----------------------------------------------------------------------*/
/*void swap_il_rr_fixflt.implied_par_funcs(	out disc_func option(nullable) 	df,
									out fwd_func option(nullable) 	fwdf,
									number option(nullable) 		first_flt_fixing,
									error_info option(nullable) 	error )
{
	try{		
		QL_FAIL_COND(ccy_swap_,"inapplicable function call for cross currency swaps", this,true);

		error_info ee = new error_info(true,true);
	
		df = implied_par_disc_func_fix_leg(ee );

		vector(date) dates;
		vector(number) amounts;
		vector(date)	float_idx0, float_pmt;
		vector(number)	float_dt;			
		logical ok = this.cash_flows_fwd_bootstrap(dates,amounts, first_flt_fixing,float_idx0,float_pmt,float_dt,ee) ;
		QL_FAIL_COND(!ok,"error creating bootstrap cashflows (fwd)", this,true);

		cashflows_fwd cf = cashflows_fwd(this.trade_date(), dates, amounts, float_idx0, float_pmt, float_dt);
		QL_FAIL_COND(null(cf),"error creating cash flows", this,true);	
		
		fwdf = bootstrap_fwd(cf, df, ip_linear());
		QL_FAIL_COND(null(fwdf ),"error creating fwd_func", this,true);	
		
		return ;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_il_rr_fixflt.implied_par_funcs");
		df 		= null<disc_func>;
		fwdf 	= null<fwd_func>;
		return ;
	}
}*/

/*-----------------------------------------------------------------------
  swap_il_rr_fixflt: ir_index_flt_leg		EXT SWAP: ok
  ----------------------------------------------------------------------*/
ir_index swap_il_rr_fixflt.ir_index_flt_leg(error_info option(nullable) error )
{	
	return swap_gen.swap_ir_index_leg2(error);
}
/*-----------------------------------------------------------------------
  swap_il_rr_fixflt: ir_index		EXT SWAP: ok
  ----------------------------------------------------------------------*/
ir_index swap_il_rr_fixflt.ir_index(error_info option(nullable) error ) option(hidden)
{	
	return swap_gen.swap_ir_index_leg2(error);
}
/*-----------------------------------------------------------------------
  index_tenor_flt_leg		EXT SWAP: ok
  ----------------------------------------------------------------------*/
string swap_il_rr_fixflt.index_tenor_flt_leg(error_info option(nullable) error ) 
{	
	return swap_gen.swap_index_tenor_leg2(error);
}

/*-----------------------------------------------------------------------
  index_tenor_code_flt_leg		EXT SWAP: ok
  ----------------------------------------------------------------------*/
tenor_code swap_il_rr_fixflt.index_tenor_code_flt_leg(error_info option(nullable) error ) 
{	
	return swap_gen.swap_index_tenor_code_leg2(error);
}

/*-----------------------------------------------------------------------
  swap_il_rr_fixflt: disc_func_fix_leg / disc_func_flt_leg   EXT SWAP: ok
  ----------------------------------------------------------------------*/
disc_func swap_il_rr_fixflt.disc_func_fix_leg(error_info option(nullable) error ) 	{ return swap_gen.swap_disc_func_leg1(error);}
disc_func swap_il_rr_fixflt.disc_func_flt_leg(error_info option(nullable) error ) 	{ return swap_gen.swap_disc_func_leg2(error);}
/*-----------------------------------------------------------------------
  tenor_surface_flt_leg   EXT SWAP: ok
  ----------------------------------------------------------------------*/
tenor_surface swap_il_rr_fixflt.tenor_surface_flt_leg(error_info option(nullable) error ) 	{ return swap_gen.swap_tenor_surface_leg2(error);}
/*-----------------------------------------------------------------------
  swap_type   EXT SWAP: ok
  ----------------------------------------------------------------------*/
instrument_type swap_il_rr_fixflt.swap_type(error_info option(nullable) error ) 
{	
	return swap_gen.swap_type(error);
}

/*-----------------------------------------------------------------------
  solver   EXT SWAP: ok
  ----------------------------------------------------------------------*/
number swap_il_rr_fixflt.solver(	number 				swap_pv,
							swap_solver_code 	solver_code,
							logical option(nullable) trade_date_pv,
							error_info option(nullable) error )
{	
	return swap_gen.solver(swap_pv,solver_code,trade_date_pv,error);
}

/*-----------------------------------------------------------------------
  imp_rate_fix_leg    EXT SWAP: ok
  ----------------------------------------------------------------------*/
number  swap_il_rr_fixflt.imp_rate_fix_leg(	number 							swap_pv,							
										logical option(nullable) 		trade_date_pv,
										error_info option(nullable) 	error ) 
{	
	try{	
		instr_error_type t;
   		string 			s;	
		number c = i().__swap_imp_fix_rate(swap_pv,trade_date_pv,true,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_il_rr_fixflt.imp_rate_fix_leg");	
		return e ? null<number>: c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_il_rr_fixflt.imp_rate_fix_leg");
		return null<number>;
	}
}

/*-----------------------------------------------------------------------
  imp_spread_flt_leg    EXT SWAP: ok
  ----------------------------------------------------------------------*/
number  swap_il_rr_fixflt.imp_spread_flt_leg(	number 						swap_pv,							
										logical option(nullable) 	trade_date_pv,
										error_info option(nullable) error ) 
{	
	try{	
		instr_error_type t;
   		string 			s;	
		number c = i().__swap_imp_flt_sprd(swap_pv,trade_date_pv,false,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_il_rr_fixflt.imp_spread_flt_leg");	
		return e ? null<number>: c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_il_rr_fixflt.imp_spread_flt_leg");
		return null<number>;
	}
}

/*-----------------------------------------------------------------------
  swap_instrument   EXT SWAP: ok
  ----------------------------------------------------------------------*/
ql_fixed_income_swap swap_il_rr_fixflt.swap_instrument(error_info option(nullable) error )
{
	return swap_gen.swap_instrument(error);
}

/*-----------------------------------------------------------------------
  swap_leg   EXT SWAP: ok
  ----------------------------------------------------------------------*/
vector(ql_swap_leg) swap_il_rr_fixflt.legs(logical clone,error_info option(nullable) error )
{	
	return swap_gen.swap_leg(clone,error);
}

/*-----------------------------------------------------------------------
  float_leg   EXT SWAP: ok
  ----------------------------------------------------------------------*/
ql_float_leg swap_il_rr_fixflt.float_leg(logical clone,error_info option(nullable) error )
{	
	vector(ql_float_leg) l = swap_gen.swap_float_leg(clone,error);
	return !null(l) ? l[0] : null<ql_float_leg>;
}

/*-----------------------------------------------------------------------
  fix_leg   EXT SWAP: ok
  ----------------------------------------------------------------------*/
ql_fix_infl_ci_leg swap_il_rr_fixflt.fix_leg(logical clone,error_info option(nullable) error )
{	
	vector(ql_fix_infl_ci_leg) l = swap_gen.swap_fix_infl_ci_leg(clone,error);
	return !null(l) ? l[0] : null<ql_fix_infl_ci_leg>;
}

/*-----------------------------------------------------------------------
  pay_fix  EXT SWAP: ok
  ----------------------------------------------------------------------*/
logical	 swap_il_rr_fixflt.pay_fix(error_info option(nullable) error )
{
	return swap_gen.swap_payleg1(error);
}

/*-----------------------------------------------------------------------
  is_par_flat (must be par, have flat floatleg, non-aged, ...)  EXT SWAP: ok
  ----------------------------------------------------------------------*/
logical	 swap_il_rr_fixflt.is_par_flat(error_info option(nullable) error )
{
	try{
				
		if(!ext_swap_)
			return true;

		error_info ee = new error_info(true,true);
		
		if(this.settle_date(ee) != this.issue_date(ee))
			return false;

		number quote_flt_leg = this.spread_flt_leg(ee);
	
		if(null(quote_flt_leg))
			return false;
		
		if(!CORE_INT.is_equal_zero(quote_flt_leg ))
			return false;
				
		number pv1,pv2;
		number pv = this.present_value(pv1,pv2,false,ee);
		
		if(null(pv))
			return false;

		number fixn,fltn;
		notional(fixn,fltn,ee);
		if(!CORE_INT.is_equal_zero(pv, CORE_INT.EPSILON*abs(fixn) ))
			return false;				

		return true;
	
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_il_rr_fixflt.is_par_flat");
		return null<logical>;
	}
}
/*-----------------------------------------------------------------------
  present_value
  ----------------------------------------------------------------------*/
number swap_il_rr_fixflt.present_value(	disc_func option(nullable)	disc_func_fix_leg,
									disc_func option(nullable) 	disc_func_flt_leg,
									out number pv_fix_leg,
									out number pv_flt_leg,
									number option(nullable) 	notional,
									logical option(nullable) 	trade_date_pv,																								
									error_info option(nullable) error )
{	
	return swap_gen.present_value(disc_func_fix_leg,disc_func_flt_leg,pv_fix_leg,pv_flt_leg,notional,trade_date_pv,error);
}

/*-----------------------------------------------------------------------
  present_value
  ----------------------------------------------------------------------*/
number swap_il_rr_fixflt.present_value(	disc_func option(nullable)	disc_func_fix_leg,
									disc_func option(nullable) 	disc_func_flt_leg,
									out number pv_fix_leg,
									out number pv_flt_leg,
									date option(nullable) 		pv_date,
									date option(nullable) 		settle_date,
									logical  					incl_issue_cf,
									logical  					incl_mat_cf,	
									error_info option(nullable) error )
{	
	return swap_gen.present_value(disc_func_fix_leg,disc_func_flt_leg,pv_fix_leg,pv_flt_leg,pv_date, settle_date ,incl_issue_cf,incl_mat_cf,error );
}


number swap_il_rr_fixflt.present_value(	out number pv_fix_leg,
									out number pv_flt_leg,
									logical option(nullable) 	trade_date_pv,	
									error_info option(nullable) error )
{	
	return swap_gen.present_value(pv_fix_leg,pv_flt_leg,trade_date_pv ,error );
}


/*-----------------------------------------------------------------------
  present_value override prot
  ----------------------------------------------------------------------*/
/*number  swap_il_rr_fixflt.present_value(	number option(nullable) 	notional,
									logical 					trade_date_pv,
									disc_func option(nullable) 	disc_func_disc,
									error_info option(nullable) error )
{	
	try{	
		notional = conv_null_number_com(notional) ;		
		QL_FAIL_COND(!null(disc_func_disc),"input of disc_func (for trade_date_pv calculation) not supported for swaps", this, true);
		
		QL_FAIL_COND(!null(notional) && ccy_swap_,"input of notional not applicable for currency swaps", this, true);//use a version with 2 notionals or set notional to null	

		number pv_fix_leg,pv_flt_leg;
		return present_value(	null<disc_func>,null<disc_func>, pv_fix_leg, pv_flt_leg,
								notional,trade_date_pv,error);					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_il_rr_fixflt.present_value");
		return null<number>;
	}
}*/

/*-----------------------------------------------------------------------
  present_value  override prot
  ----------------------------------------------------------------------*/
/*number  swap_il_rr_fixflt.present_value(	disc_func					disc_func,
									number option(nullable) 	notional,
									logical 					trade_date_pv,
									disc_func option(nullable) 	disc_func_disc,
									error_info option(nullable) error ) 
{	
	try{	
		notional= conv_null_number_com(notional) ;
		QL_FAIL_COND(!null(disc_func_disc),"input of disc_func (for trade_date_pv calculation) not supported for swaps");
		
		QL_FAIL_COND(ccy_swap_,"inapplicable function call for cross currency swaps");//use a version with 2 disc_funcs	

		number pv_fix_leg,pv_flt_leg;
		return present_value(	disc_func,disc_func, pv_fix_leg, pv_flt_leg,
								notional,trade_date_pv,error);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_il_rr_fixflt.present_value");
		return null<number>;
	}
*/



/*-----------------------------------------------------------------------
  swap_il_rr_fixflt: quote,  for backward compat reasons 
  ----------------------------------------------------------------------*/
number  swap_il_rr_fixflt.quote(	disc_func		df_fix_leg,
							..quote_style option(nullable) qs,	 							
							error_info option(nullable) error ) option(hidden)
{ 
	try {
		QL_FAIL_COND(ext_swap_,"inapplicable function call for non-db swaps", this,true);
		
		error_info ee 	= new error_info(true,false);
		tenor_surface ts = this.tenor_surface_flt_leg(ee);
		if(ee.is_error() || null(ts))
			return instrument.quote(df_fix_leg,qs,error);

		if(null(qs)) {
			qs = quote_style_e(ee);			
		}

		logical ok_qs = qs == ..quote_style.YIELD || qs == ..quote_style.YIELD_PCT;
		QL_FAIL_COND(null(qs) || !ok_qs ,"invalid quote style", this,true);
		
		disc_func df 	= this.disc_func_flt_leg(ee);
		QL_FAIL_COND(ee.is_error() || null(df),"discount function for float leg not set", this,true);
		
		disc_func dffix_orig 	= this.disc_func_fix_leg(ee);

		
		this.add_disc_func_fix_leg(df_fix_leg);
		
		number q = this.imp_rate_fix_leg(0,false,ee);

		if(qs == ..quote_style.YIELD_PCT){
			q *= 100;
		}		

		this.add_disc_func_fix_leg(dffix_orig);		

		return q;
							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_il_rr_fixflt.quote");
		return null<number>;
	}
}
/*-----------------------------------------------------------------------
  swap_il_rr_fixflt: yield,  for backward compat reasons --> returns fixleg cpn
  ----------------------------------------------------------------------*/
number  swap_il_rr_fixflt.yield(logical disable_rounding,
								error_info option(nullable) error )  option(hidden)
{ 
	try {

		error_info ee 	= new error_info(true,true);
		
		number cpnr 	= this.coupon_fix_leg(ee);
		
		if(!ext_swap_) {
			number y = instrument.yield(false,ee);
			if(CORE_INT.is_equal(cpnr,y))
				return y;
			else
				QL_FAIL("yield for non-par swaps not supported");
		}
			
		disc_func df 	= this.disc_func_fix_leg(ee);
		if(null(df)) {
			return this.coupon_rate(ee);
		}
		else {
			number y = swap_gen.yield(df, false , ee );
			if(CORE_INT.is_equal(cpnr,y))
				return y;
			else
				QL_FAIL("yield for non-par swaps not supported");
		}

		/*
		if(!ext_swap_)
			return instrument.yield(disable_rounding,error);

		error_info ee 	= new error_info(true,true);
		disc_func df 	= this.disc_func_fix_leg(ee);
		QL_FAIL_COND(null(df),"discount function for fixed leg not initialized (required for non-db swaps)", this,true);
		return swap_gen.yield(	df, disable_rounding , error );*/
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_il_rr_fixflt.yield");
		return null<number>;
	}
}


/*-----------------------------------------------------------------------
  cpi_link
  ----------------------------------------------------------------------*/
cpi_link swap_il_rr_fixflt.cpi_link(error_info option(nullable) error)
{	
	try{
		error_info ee = error_info(true,true);
		ql_fix_infl_ci_leg l = fix_leg(false,ee );			
		return l.cpi_link();						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_il_rr_fixflt.cpi_link");
		return null<..cpi_link> ;
	}
}

/*-----------------------------------------------------------------------
  cpi_link
  ----------------------------------------------------------------------*/
cpi_link swap_il_rr_fixflt.cpi_link_forecast(error_info option(nullable) error)
{	
	try{
		error_info ee = error_info(true,true);
		ql_fix_infl_ci_leg l = fix_leg(false,ee );			
		return l.cpi_link_fcast();						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_il_rr_fixflt.cpi_link_forecast");
		return null<..cpi_link> ;
	}
}
/*-----------------------------------------------------------------------
  cpi_knots

  ----------------------------------------------------------------------*/
void swap_il_rr_fixflt.cpi_knots(date date,
								out date  option(nullable)	mth_lag1,
								out date   option(nullable)	mth_lag2,
								out logical   option(nullable)	active_lag1,
								out logical   option(nullable)	active_lag2,
								error_info option(nullable) error)
{	
	try{
		error_info ee = error_info(true,true);
		ql_fix_infl_ci_leg l = fix_leg(false,ee );			
		l.cpi_knots(date,mth_lag1,mth_lag2,active_lag1,active_lag2);
		return;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_il_rr_fixflt.cpi_knots");
		mth_lag1 = mth_lag2 = null<date>;
		active_lag1 = active_lag2 = null<logical>;
		return  ;
	}
}

/*-----------------------------------------------------------------------
  swap_il_rr_fixflt: index_factor
  ----------------------------------------------------------------------*/
number swap_il_rr_fixflt.index_factor(	error_info option(nullable) error)
{	
	try{
		error_info ee = error_info(true,true);
		ql_fix_infl_ci_leg l = fix_leg(false,ee );			
		return l.index_factor_settle();						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_il_rr_fixflt.index_factor");
		return null<number> ;
	}
}

/*-----------------------------------------------------------------------
  swap_il_rr_fixflt: il_index_factor
  ----------------------------------------------------------------------*/
number swap_il_rr_fixflt.index_factor(	date option(nullable) trade_date,
										date settle_date,
										error_info option(nullable) error)
{	
	//return instrument.il_index_factor(trade_date, settle_date, error);
	try{
		error_info ee = error_info(true,true);
		ql_fix_infl_ci_leg l = fix_leg(false,ee );			
		return l.index_factor(trade_date,settle_date);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_il_rr_fixflt.index_factor");
		return null<number> ;
	}
}

//oooooooooooooooooo
//oooooooooooooooooo
//oooooooooooooooooo
//oooooooooooooooooo



/*-----------------------------------------------------------------------
  swap_il_rr_fixflt: index_freq
  ----------------------------------------------------------------------*/
/*integer swap_il_rr_fixflt.index_freq(	error_info option(nullable) error)
{	
	return instrument.il_index_freq(error);
}*/

/*-----------------------------------------------------------------------
  swap_il_rr_fixflt: index_factor
  ----------------------------------------------------------------------*/
/*number swap_il_rr_fixflt.index_factor(	error_info option(nullable) error)
{	
	return instrument.il_index_factor(error);
}*/

/*-----------------------------------------------------------------------
  swap_il_rr_fixflt: il_index_factor
  ----------------------------------------------------------------------*/
/*number swap_il_rr_fixflt.index_factor(date option(nullable) trade_date,
										date settle_date,
										error_info option(nullable) error)
{	
	return instrument.il_index_factor(trade_date, settle_date, error);
}*/

/*-----------------------------------------------------------------------
  swap_il_rr_fixflt: base_cpi
  ----------------------------------------------------------------------*/
/*number swap_il_rr_fixflt.base_cpi(error_info option(nullable) error)
{	
	 return instrument.il_base_cpi(error);
		
}*/

/*-----------------------------------------------------------------------
  swap_il_rr_fixflt: il_cpi_link
  ----------------------------------------------------------------------*/
/*cpi_link swap_il_rr_fixflt.cpi_link(error_info option(nullable) error)
{	
	return instrument.il_cpi_link(error);
}*/

/*-----------------------------------------------------------------------
  swap_il_rr_fixflt: cpi_knots

  ----------------------------------------------------------------------*/
/*void swap_il_rr_fixflt.cpi_knots(	date date,
									out date  option(nullable)	mth_lag1,
									out date   option(nullable)	mth_lag2,
									out logical   option(nullable)	active_lag1,
									out logical   option(nullable)	active_lag2,
									error_info option(nullable) error)
{	
	instrument.il_cpi_knots(date,mth_lag1,mth_lag2,active_lag1,active_lag2,error);
}*/

/*-----------------------------------------------------------------------
  swap_il_rr_fixflt: cpi_values

  ----------------------------------------------------------------------*/
/*void swap_il_rr_fixflt.cpi_values(out number  option(nullable)	value1,
									out number   option(nullable)	value2,	
									error_info option(nullable) error)
{	
	instrument.il_cpi_values(	value1,value2,error);
}*/

/*-----------------------------------------------------------------------
  swap_il_rr_fixflt: cash_flow_nom_amounts
  ----------------------------------------------------------------------*/
/*vector(number) swap_il_rr_fixflt.cash_flow_nom_amounts(	..cpi_link cpi_link,
															number option(nullable) nominal,
															logical post_settle,
															error_info option(nullable) error)
{	
	logical keep_size=false;
	return instrument.il_cash_flow_nom_amounts(cpi_link,nominal,post_settle,keep_size,error);
}*/

/*-----------------------------------------------------------------------
  swap_il_rr_fixflt: cash_flow_nom_cpn
  ----------------------------------------------------------------------*/
/*vector(number) swap_il_rr_fixflt.cash_flow_nom_cpn(	..cpi_link cpi_link,
														number option(nullable) nominal,
														logical post_settle,
														error_info option(nullable) error)
{	
	logical keep_size=false;
	return instrument.il_cash_flow_nom_cpn(cpi_link,nominal,post_settle,keep_size,error);
}*/

/*-----------------------------------------------------------------------
  fix_leg_y_to_pv
  ----------------------------------------------------------------------*/
/*number  swap_il_rr_fixflt.fix_leg_y_to_pv(number option(nullable)	yield,
									logical 				in_pcnt,
									error_info option(nullable) error) 
{	
	return instrument.fix_leg_y_to_pv(yield, in_pcnt, error);
}*/


