option(null: hard);	
/*	
	instrument wrapper functions
	Developer: Algorithmica Research, Magnus Nyström			

	--------------------------------------------------------------------
	real rate fixflt swap
	--------------------------------------------------------------------
*/



//-----------------------------------------------------------------------
//  class swap_il_rr_fixois
//----------------------------------------------------------------------
class swap_il_rr_fixois: public swap_gen
option(category: "Instrument/Inflation Linked/Real Rate Fixed vs ONIndex")
//option(allow_undeclared_mfuncs)
{
public:
	//override string				instr_type_s();
	override instrument 		inst();
	override swap_il_rr_fixois 	clone() ;

	override void                	__dbg_print(__dbg_label);
    override void                	__dbg_browse(__dbg_split);

	logical			pay_fix(error_info option(nullable) error = null<error_info>);
	override void	final_pmt_date(out date ,out date ,error_info option(nullable) error = null); 
	//-----external swap specific-----
	override instrument_type 	swap_type(error_info option(nullable) error = null<error_info> );
	vector(ql_swap_leg) 		legs(logical,error_info option(nullable) error = null<error_info>);
	ql_ois_leg 					ois_leg(logical,error_info option(nullable) error = null<error_info>);
	ql_fix_infl_ci_leg 			fix_leg(logical,error_info option(nullable) error = null<error_info>);
	override ql_fixed_income_swap 	swap_instrument(error_info option(nullable) error = null<error_info>) ;
	
	/*----------ADD FUNCS [PUBLIC]---------------*/
	void 		add_notional(number , number);
	swap_il_rr_fixois(__instrument);
	

	swap_il_rr_fixois(swap_il_rr_fixois);
protected:
	override swap_il_rr_fixois	create(__instrument option(nullable),out instr_error option(nullable),error_type type = E_INVALID_ARG);
	swap_il_rr_fixois 			err_type(swap_il_rr_fixois option(nullable), error_info option(nullable) error = null<error_info>);


	//logical ext_swap_;
	//logical ccy_swap_;
	//logical full_swap_;
};

//------------------------------------------------
// __dbg_print
//------------------------------------------------
void swap_il_rr_fixois.__dbg_print(__dbg_label l)
{
	error_info ee 	= new error_info(true,false);
    l.set_text(strcat([
						"name: ",
						name(ee),
						",  ext_swap: ",
						null(ext_swap_) ? "" : string(ext_swap_),
                        ", ccy_swap: ",
						null(ccy_swap_) ? "" : string(ccy_swap_),
						", valid: ",
						null(this.is_valid(ee)) ? "" : string(this.is_valid(ee))
					]));
}
//------------------------------------------------
// __dbg_browse
//------------------------------------------------
void swap_il_rr_fixois.__dbg_browse(__dbg_split s)
{
    s.resize(4);
	error_info ee 	= new error_info(true,false);
	
    s.set_text(0, "name");
    s.set_value(0, this.name(ee));

    s.set_text(1, "ext_swap");
    s.set_value(1, ext_swap_);

    s.set_text(2, "ccy_swap");
    s.set_value(2, ccy_swap_);

	s.set_text(3, "valid");
    s.set_value(3, is_valid(ee));
}

//------------------------------------------------
// copy constructor
//------------------------------------------------
swap_il_rr_fixois.swap_il_rr_fixois(swap_il_rr_fixois c)
						: swap_gen(c)
{}

//------------------------------------------------
// constructor [HIDDEN, cannot be protected]
//------------------------------------------------
swap_il_rr_fixois.swap_il_rr_fixois(__instrument i) option(hidden): swap_gen(i)
{
	//try {
		error_info ee = new error_info(true,false);
		if(!this.is_valid(ee)) {
			ext_swap_ = ccy_swap_ = full_swap_ = false;
			return;
		}

		ext_swap_ = this.is_ext_swap(ee);
		ccy_swap_ = this.is_ccy_swap(ee);
		full_swap_	= this.verify_full_swap(true,ee);
		
			
		return;									
	//}
	//catch {		
		//CORE_INT.write_warning_message(err.message());
		//the instrument is ok even if we get here
		//the consequence is only that the disc_func, fwd_func, tenor_surface are not updated
	//}	
}

//------------------------------------------------
// instr_type_s
//------------------------------------------------
//string swap_il_rr_fixois.instr_type_s()  { return string(..instr_type.IL_SWAP_REAL_FIXOIS);}
//------------------------------------------------
// inst
//------------------------------------------------
instrument 	swap_il_rr_fixois.inst()		{ return this;}

//------------------------------------------------
// copy constructor <FUNCTION>
//------------------------------------------------
swap_il_rr_fixois swap_il_rr_fixois(swap_il_rr_fixois b)			{ return new swap_il_rr_fixois(b);}
//------------------------------------------------
// clone
//------------------------------------------------
swap_il_rr_fixois swap_il_rr_fixois.clone() 	{ return new swap_il_rr_fixois(this);}

//------------------------------------------------
// create  [PROTECTED]
// create swap_il_rr_fixois from internal instrument
//------------------------------------------------
swap_il_rr_fixois swap_il_rr_fixois.create(	__instrument option(nullable) c,
											out instr_error option(nullable) error,
											error_type type )
{
	QL_FAIL_COND(null(c), "invalid/unknown (null) instrument",type );

	logical valid = c.is_valid(error);
	if( !valid && INSTR_CREATE_NULL_ERR)
		return null<swap_il_rr_fixois>; 
	
	..instr_type it = c.instr_type(error);
	QL_FAIL_COND(null(it), "invalid instrument type (unknown)",type );
	QL_FAIL_COND(it != ..instr_type.IL_SWAP_REAL_FIXOIS, "invalid instrument type",type );//should not happen
	
	return new swap_il_rr_fixois(c);
}
/*-----------------------------------------------------------------------
  create_swap_il_rr_fixois  <FUNCTION>
  ----------------------------------------------------------------------*/
swap_il_rr_fixois create_swap_il_rr_fixois(	__instrument option(nullable) c,
											out instr_error option(nullable) error,
											error_type type = E_INVALID_ARG)
option(com_name: 'INTERNAL_create_swap_il_rr_fixois')
{
	QL_FAIL_COND(null(c), "invalid/unknown (null) instrument",type );

	logical valid = c.is_valid(error);
	if(!valid && INSTR_CREATE_NULL_ERR)
		return null<swap_il_rr_fixois>; 
	
	..instr_type it = c.instr_type(error);
	QL_FAIL_COND(null(it), "invalid instrument type (unknown)",type );
	QL_FAIL_COND(it != ..instr_type.IL_SWAP_REAL_FIXOIS, "invalid instrument type",type );//should not happen
	
	return new swap_il_rr_fixois(c);
}

swap_il_rr_fixois create_swap_il_rr_fixois(	__instrument option(nullable) 		c,
											error_info option(nullable) 		error,
											error_type 							type = E_INIT)
option(com_name: 'INTERNAL_create_swap_il_rr_fixois_ei')
{
	instr_error ee 		= instr_error();
	swap_il_rr_fixois b = create_swap_il_rr_fixois(c,ee, E_INIT);
	if(ee.is_error())
		CORE_INT.add_error_info(error,ee.type(),ee.message(), "create_swap_il_rr_fixois");
	return b;
}

//-----------------------------------------------
// constructor <FUNCTION> dynamic cast  EXT SWAP: ok
//-----------------------------------------------
swap_il_rr_fixois	swap_il_rr_fixois(instrument i,
									  error_info option(nullable) error = null<error_info>)
option (category: "Instrument/Inflation Linked/Real Rate Fixed vs Float")
option(com_name: 'swap_il_rr_fixois_dyncast') 
{ 
	try {
		swap_il_rr_fixois d = dynamic_cast<swap_il_rr_fixois>(i); 
		if(null(d))
			CORE_INT.add_error_info(error,ERR_T_INIT,"invalid cast (instrument is not a swap_il_rr_fixois)","swap_il_rr_fixois" );

		return d;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_il_rr_fixois");
		return null<swap_il_rr_fixois>;
	}
}

/*-----------------------------------------------------------------------
  err_type	EXT SWAP: ok
  ----------------------------------------------------------------------*/
swap_il_rr_fixois swap_il_rr_fixois.err_type(swap_il_rr_fixois option(nullable) nul, error_info option(nullable) error )
{	
	CORE_INT.add_error_info(error,ERR_T_CALC,"mwlib(ql) error: inapplicable function call for current instrument type");
	return null<swap_il_rr_fixois>;
}

/*-----------------------------------------------------------------------
  swap_type   EXT SWAP: ok
  ----------------------------------------------------------------------*/
instrument_type swap_il_rr_fixois.swap_type(error_info option(nullable) error ) 
{	
	return swap_gen.swap_type(error);
}

/*-----------------------------------------------------------------------
  swap_instrument   EXT SWAP: ok
  ----------------------------------------------------------------------*/
ql_fixed_income_swap swap_il_rr_fixois.swap_instrument(error_info option(nullable) error )
{
	return swap_gen.swap_instrument(error);
}

/*-----------------------------------------------------------------------
  swap_leg   EXT SWAP: ok
  ----------------------------------------------------------------------*/
vector(ql_swap_leg) swap_il_rr_fixois.legs(logical clone,error_info option(nullable) error )
{	
	return swap_gen.swap_leg(clone,error);
}

/*-----------------------------------------------------------------------
  float_leg   EXT SWAP: ok
  ----------------------------------------------------------------------*/
ql_ois_leg swap_il_rr_fixois.ois_leg(logical clone,error_info option(nullable) error )
{	
	vector(ql_ois_leg) l = swap_gen.swap_ois_leg(clone,error);
	return !null(l) ? l[0] : null<ql_ois_leg>;
}

/*-----------------------------------------------------------------------
  fix_leg   EXT SWAP: ok
  ----------------------------------------------------------------------*/
ql_fix_infl_ci_leg swap_il_rr_fixois.fix_leg(logical clone,error_info option(nullable) error )
{	
	vector(ql_fix_infl_ci_leg) l = swap_gen.swap_fix_infl_ci_leg(clone,error);
	return !null(l) ? l[0] : null<ql_fix_infl_ci_leg>;
}

/*-----------------------------------------------------------------------
  pay_fix  EXT SWAP: ok
  ----------------------------------------------------------------------*/
logical	 swap_il_rr_fixois.pay_fix(error_info option(nullable) error )
{
	return swap_gen.swap_payleg1(error);
}
/*-----------------------------------------------------------------------
  final_pmt_date	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_il_rr_fixois.final_pmt_date(	out date 	final_pmt_date_fix_leg,									
										out date 	final_pmt_date_ois_leg,
										error_info option(nullable) error ) 
{	
	swap_gen.final_pmt_date( final_pmt_date_fix_leg, final_pmt_date_ois_leg, error ) ;
}


void swap_il_rr_fixois.add_notional(number notional1, number notional2)	{ swap_gen.swap_add_notional(notional1, notional2);}