option(null: hard);	
/*	
	instrument wrapper functions
	Developer: Algorithmica Research, Magnus Nyström			

	--------------------------------------------------------------------
	il zero
	--------------------------------------------------------------------
*/

//-----------------------------------------------------------------------
//  class il_zero_bond
//----------------------------------------------------------------------
class il_zero_bond: public instrument
option(category: "Instrument/Inflation Linked/Real Rate Zero Bond")
//option(allow_undeclared_mfuncs)
{
public:
	
	//override string	instr_type_s();
	override instrument 	inst();
	
	//-----add-funcs-----			
	override void 			add_nominal(number );										
	void 					add_quote(number );
	void 					add_quote_from_yield(number );

	override logical 		eom(error_info option(nullable) error = null<error_info> );
	override string 		maturity_code(error_info option(nullable) error = null<error_info> );
	override bd_convention 	pmt_bus_day(error_info option(nullable) error = null<error_info> );
	override date 			first_settle_date(error_info option(nullable) error = null<error_info> );	
	override integer 		comp_freq(error_info option(nullable) error = null<error_info> );
	override number  			redemp_price(error_info option(nullable) error = null<error_info>);
	override day_count_method 	next_last_dc_method(error_info option(nullable) error = null<error_info>) ;
	override day_count_method 	next_dc_method(error_info option(nullable) error = null<error_info>) ;

	integer 		index_freq(	error_info option(nullable) error = null<error_info>);
	number 			index_factor(error_info option(nullable) error = null<error_info>);
	number 			index_factor(date option(nullable),date,
								 error_info option(nullable) error = null<error_info>);
	number 			base_cpi(error_info option(nullable) error = null<error_info>);
	..cpi_link 		cpi_link(error_info option(nullable) error = null<error_info>);

	void  			cpi_knots(date ,out date  option(nullable),out date   option(nullable),out logical option(nullable)	,
								out logical   option(nullable)	,error_info option(nullable) error = null<error_info>);
	void  			cpi_values(out number  option(nullable),out number   option(nullable),
							   error_info option(nullable) error = null<error_info>); 
	
	..cpi_link 		cpi_link_forecast(	date,number ,vector(number) ,date ,
										error_info option(nullable) error = null<error_info>);
	
	void  			funding(date,number,day_count_method ,rate_type option(nullable) ,
							disc_func option(nullable),..cpi_link option(nullable) ,number option(nullable) ,
							out number,out number,
							out number	,out number,out number,
							out number	,out number,out number,
							error_info option(nullable) error = null<error_info>) ; 	

	number  		clean_price_fwd(date ,number ,day_count_method,rate_type option(nullable) ,
									disc_func option(nullable) ,..cpi_link option(nullable) ,logical,
									error_info option(nullable) error = null<error_info>) ; 	
	
	number  		dirty_price_fwd(date ,number ,day_count_method,rate_type option(nullable) ,
									disc_func option(nullable) ,..cpi_link option(nullable) ,
									error_info option(nullable) error = null<error_info>) ; 	

	number  		yield_fwd(	date ,number ,day_count_method,rate_type option(nullable) ,
								disc_func option(nullable) ,..cpi_link option(nullable) ,
								error_info option(nullable) error = null<error_info>) ; 		

	void  			roll_down(	date,disc_func ,logical,day_count_method,rate_type option(nullable),
								..cpi_link option(nullable), out number,
								out number ,out number ,out number ,
								error_info option(nullable) error = null<error_info>) ; 

	number  		horizon_return(date ,number ,..quote_style	option(nullable),day_count_method,rate_type option(nullable) ,
										disc_func option(nullable) ,..cpi_link option(nullable),error_info option(nullable) error = null<error_info>) ; 	


	//cashflow-funcs
	vector(number)	cash_flows(..cpi_link option(nullable) ,il_cf_code,number option(nullable) nominal = null<number>,
								logical post_settle = true,logical k=false,error_info option(nullable) error = null<error_info>);

	void 			cash_flow_data(..cpi_link option(nullable) ,number option(nullable) ,logical ,ir_cf_code ,il_cf_code ,
									logical ,logical ,out vector(date)   ,out vector(number)   ,								
									error_info option(nullable) error = null<error_info> );

	//backward compat
	vector(number)	cash_flow_nom_amounts(..cpi_link ,number option(nullable) nominal = null<number>,
											logical post_settle = true,error_info option(nullable) error = null<error_info>);		/*hidden*/


	number 					dirty_price(..cpi_link ,disc_func , error_info option(nullable) error = null<error_info>);
	number 					clean_price(logical , error_info option(nullable) error = null<error_info> );

	/*---set functions-required--*/	
	override il_zero_bond	set_quote(number option(nullable),error_info option(nullable) error = null<error_info>);
	override il_zero_bond	set_quote(string option(nullable),error_info option(nullable) error = null<error_info>);
	
	//local set funcs
	il_zero_bond			set_quote(number option(nullable),date option(nullable) trade_date , date option(nullable) settle_date = null<date>,
									error_info option(nullable) error = null<error_info>);
	il_zero_bond			set_quote(string option(nullable),date option(nullable) trade_date  , date option(nullable) settle_date = null<date>,
									error_info option(nullable) error = null<error_info>);

	/*---set functions-if applicable--*/					
	override il_zero_bond	set_date(date,date option(nullable) s = null<date>,logical r = true,logical rq = true ,
									 error_info option(nullable) error = null<error_info>);

	override il_zero_bond	set_settle_date(date ,logical re_initialize =false, error_info option(nullable) error = null<error_info> );

	override il_zero_bond	set_clean_price(number option(nullable),date option(nullable) trade_date  = null<date>,date option(nullable) settle_date = null<date>, 
											error_info option(nullable) error = null<error_info>);

	override il_zero_bond 	set_dirty_price(number option(nullable),date option(nullable) trade_date  = null<date>,date option(nullable) settle_date = null<date>, 
											error_info option(nullable) error = null<error_info>);

	override il_zero_bond	set_yield(number option(nullable) ,error_info option(nullable) error = null<error_info>);
	
	override il_zero_bond	set_quote_from_yield(number option(nullable),error_info option(nullable) error = null<error_info> );
	
	//local set funcs
	il_zero_bond			set_yield( number option(nullable) ,date option(nullable), date option(nullable) settle_date = null<date>,
										error_info option(nullable) error = null<error_info>);
		
	

	il_zero_bond(__instrument);	
	override il_zero_bond clone() ;
	il_zero_bond(il_zero_bond);

protected:

	
	override il_zero_bond	create(__instrument option(nullable),out instr_error option(nullable),error_type type = E_INVALID_ARG); 

	override void 			add_quote(number,logical option(nullable) ); 
	override void 			add_quote_from_yield(number,logical option(nullable) );

	override il_zero_bond	set_date(date,logical ,error_info option(nullable) error = null<error_info>);
	override il_zero_bond	move_date(date,date option(nullable) s = null<date>, error_info option(nullable) error = null<error_info>);

	  
};
//------------------------------------------------
// constructor [HIDDEN, cannot be protected]
//------------------------------------------------
il_zero_bond.il_zero_bond(__instrument i) option(hidden) : instrument(i){}
//------------------------------------------------
// instr_type_s
//------------------------------------------------
//string il_zero_bond.instr_type_s()  { return string(..instr_type.IL_REAL_ZERO_CPN_BOND);}
//------------------------------------------------
// inst
//------------------------------------------------
instrument 	il_zero_bond.inst()		{ return this;}
//------------------------------------------------
// copy constructor
//------------------------------------------------
il_zero_bond.il_zero_bond(il_zero_bond c) : instrument(c) {}
//------------------------------------------------
// copy constructor <FUNCTION>
//------------------------------------------------
il_zero_bond il_zero_bond(il_zero_bond b)	{ return new il_zero_bond(b);}
//------------------------------------------------
// clone
//------------------------------------------------
il_zero_bond il_zero_bond.clone() 			{ return new il_zero_bond(this);}
//-----------------------------------------------
// dynamic cast <FUNCTION>
//-----------------------------------------------
il_zero_bond	il_zero_bond(instrument i, error_info option(nullable) error = null<error_info>) 	
option (category: "Instrument/Inflation Linked/Real Rate Zero Bond")
option(com_name: 'il_zero_bond_dyncast') 
{ 
	try {
		il_zero_bond d = dynamic_cast<il_zero_bond>(i); 
		if(null(d))
			CORE_INT.add_error_info(error,ERR_T_INIT,"invalid cast (instrument is not an il_zero_bond)","il_zero_bond" );

		return d;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "il_zero_bond");
		return null<il_zero_bond>;
	}
}
//------------------------------------------------
// create  [PROTECTED]
// create il_zero_bond from internal instrument
//------------------------------------------------
il_zero_bond il_zero_bond.create(	__instrument option(nullable) c,
									out instr_error option(nullable) error,
									error_type type )
{
	QL_FAIL_COND(null(c), "invalid/unknown (null) instrument",type );

	logical valid = c.is_valid(error);
	if( !valid && INSTR_CREATE_NULL_ERR)
		return null<il_zero_bond>; 
	
	..instr_type it = c.instr_type(error);
	QL_FAIL_COND(null(it), "invalid instrument type (unknown)",type );
	QL_FAIL_COND(it != ..instr_type.IL_REAL_ZERO_CPN_BOND, "invalid instrument type",type );//should not happen
	
	return new il_zero_bond(c);
}

/*-----------------------------------------------------------------------
  create_il_zero_bond <FUNCTION>
  ----------------------------------------------------------------------*/

il_zero_bond create_il_zero_bond(__instrument option(nullable) c,
								out instr_error option(nullable) error,
								error_type type = E_INVALID_ARG)
option(com_name: 'INTERNAL_create_il_zero_bond')
{
	QL_FAIL_COND(null(c), "invalid/unknown (null) instrument",type );

	logical valid = c.is_valid(error);
	if( !valid && INSTR_CREATE_NULL_ERR)
		return null<il_zero_bond>; 
	
	..instr_type it = c.instr_type(error);
	QL_FAIL_COND(null(it), "invalid instrument type (unknown)",type );
	QL_FAIL_COND(it != ..instr_type.IL_REAL_ZERO_CPN_BOND, "invalid instrument type",type );//should not happen
	
	return new il_zero_bond(c);
}

il_zero_bond create_il_zero_bond(	__instrument option(nullable) 		c,
								error_info option(nullable) 		error,
								error_type 							type = E_INIT)
option(com_name: 'INTERNAL_create_il_zero_bond_ei')
{
	instr_error ee 	= instr_error();
	il_zero_bond b 	= create_il_zero_bond(c,ee, E_INIT);
	if(ee.is_error())
		CORE_INT.add_error_info(error,ee.type(),ee.message(), "create_il_zero_bond");
	return b;
}

/*-----------------------------------------------------------------------
  add_nominal 
  ----------------------------------------------------------------------*/
void il_zero_bond.add_nominal(number nominal) 
{			
	instrument.add_nominal(nominal );
	return ;						
}

/*-----------------------------------------------------------------------
  add_quote
  ----------------------------------------------------------------------*/
void il_zero_bond.add_quote(number  quote ) 
{	
	instrument.add_quote(quote, false);
	return ;					
	
}

void il_zero_bond.add_quote(number  quote, logical option(nullable) set_coupon_to_quote ) 
{	
	if(null(set_coupon_to_quote)) set_coupon_to_quote = false;
	QL_FAIL_COND(set_coupon_to_quote, "invalid argument: set coupon to quote not applicable for zero cpn bond", name(), true);
	instrument.add_quote(quote, set_coupon_to_quote);
	return ;						
}

/*-----------------------------------------------------------------------
  add_quote_from_yield
  ----------------------------------------------------------------------*/
void il_zero_bond.add_quote_from_yield(number  yield ) 
{	
	instrument.add_quote_from_yield(yield, false);
	return ;					
	
}

void il_zero_bond.add_quote_from_yield(number  yield, logical option(nullable) set_coupon_to_yield ) 
{	
	if(null(set_coupon_to_yield)) set_coupon_to_yield= false;
	QL_FAIL_COND(set_coupon_to_yield, "invalid argument: set coupon to yield not applicable for zero cpn bond", name(), true);
	instrument.add_quote_from_yield(yield, set_coupon_to_yield);
	return ;						
}


/*-----------------------------------------------------------------------
  il_zero_bond: set_date
	if trade date is the same --> the settle date will be preserved (if not input)	
	NOTE: 	if coupon is not null in instr_def it is kept unchanged --> deposit will be non-par 
			when a deposit is defined in db the coupon is always null
  ----------------------------------------------------------------------*/
il_zero_bond il_zero_bond.set_date(	date  				trade_date, 
									date  option(nullable)	settle_date,
									logical 			re_init_static, 
									logical 			re_init_quote, 
									error_info option(nullable) error)
{	
	instrument cc = instrument._set_date(trade_date,settle_date,re_init_static,re_init_quote,error);
	return null(cc) ? null<il_zero_bond>: dynamic_cast<il_zero_bond>(cc);
	
}

/*-----------------------------------------------------------------------
  il_zero_bond: set_date
	quote is NOT kept even if trade_date is unchanged
  ----------------------------------------------------------------------*/
il_zero_bond il_zero_bond.set_date(		date  				trade_date, 
										logical 			re_initialize, 
										error_info option(nullable) error)
{	
	instrument cc = instrument._set_date(	trade_date,re_initialize,error);
	return null(cc) ? null<il_zero_bond>: dynamic_cast<il_zero_bond>(cc);
	
}

/*-----------------------------------------------------------------------
  il_zero_bond: move_date
	changes the trade date of the instrument without retrieving the 
 	corresponding quote from the database or the real-time feed.
	if trade date is the same --> the settle date will be preserved	
  ----------------------------------------------------------------------*/
il_zero_bond il_zero_bond.move_date(date  				trade_date, 
					date option(nullable) settle_date,
					error_info option(nullable) error)
{	
	instrument cc = instrument._move_date(trade_date,settle_date,error);
	return null(cc) ? null<il_zero_bond>: dynamic_cast<il_zero_bond>(cc);
}

/*-----------------------------------------------------------------------
  il_zero_bond: set_quote 
  ----------------------------------------------------------------------*/
il_zero_bond il_zero_bond.set_quote(	number 	option(nullable) quote,
						error_info option(nullable) error)
{	
	instrument cc = instrument._set_quote(quote,null<date>, null<date>, false,error);
	return null(cc) ? null<il_zero_bond>: dynamic_cast<il_zero_bond>(cc);
}

/*-----------------------------------------------------------------------
  il_zero_bond: set_quote 
  ----------------------------------------------------------------------*/
il_zero_bond il_zero_bond.set_quote(	string 	option(nullable) quote_side,
						error_info option(nullable) error)
{	
	instrument cc = instrument._set_quote(quote_side,null<date>, null<date>, false,error);
	return null(cc) ? null<il_zero_bond>: dynamic_cast<il_zero_bond>(cc);
}

/*-----------------------------------------------------------------------
  il_zero_bond: set_quote 
  ----------------------------------------------------------------------*/
il_zero_bond il_zero_bond.set_quote(	number 	option(nullable) quote,
						date  	option(nullable) trade_date, 
						date  	option(nullable) settle_date, 
						error_info option(nullable) error)
{	
	instrument cc = instrument._set_quote(quote,trade_date, settle_date, false,error);
	return null(cc) ? null<il_zero_bond>: dynamic_cast<il_zero_bond>(cc);
}

/*-----------------------------------------------------------------------
  il_zero_bond: set_quote
  ----------------------------------------------------------------------*/
il_zero_bond il_zero_bond.set_quote(	string 	option(nullable) quote_side,
						date  	option(nullable) trade_date, 
						date  	option(nullable) settle_date, 
						error_info option(nullable) error)
{	
	instrument cc = instrument._set_quote(quote_side,trade_date, settle_date, false,error);
	return null(cc) ? null<il_zero_bond>: dynamic_cast<il_zero_bond>(cc);
}

/*-----------------------------------------------------------------------
  il_zero_bond: set_clean_price
  ----------------------------------------------------------------------*/
il_zero_bond il_zero_bond.set_clean_price(	number 	option(nullable) clean_pct,
									date  	option(nullable) trade_date, 
									date  	option(nullable) settle_date, 
									error_info option(nullable) error)
{	
	instrument cc = instrument._set_clean_price(	clean_pct,trade_date, settle_date,error);
	return null(cc) ? null<il_zero_bond>: dynamic_cast<il_zero_bond>(cc);
}

/*-----------------------------------------------------------------------
  set_dirty_price
  ----------------------------------------------------------------------*/
il_zero_bond il_zero_bond.set_dirty_price(	number 	option(nullable) dirty_pct,
							date  	option(nullable) trade_date, 
							date  	option(nullable) settle_date, 
							error_info option(nullable) error)
{	
	instrument cc = instrument._set_dirty_price(	dirty_pct,trade_date, settle_date,error);
	return null(cc) ? null<il_zero_bond>: dynamic_cast<il_zero_bond>(cc);
}

/*-----------------------------------------------------------------------
  il_zero_bond: set_yield
  ----------------------------------------------------------------------*/
il_zero_bond il_zero_bond.set_yield(	number 	option(nullable) yield,
								error_info option(nullable) error)
{	
	instrument cc = instrument._set_yield(yield, null<date>, null<date>,false, error);
	return null(cc) ? null<il_zero_bond>: dynamic_cast<il_zero_bond>(cc);
}

/*-----------------------------------------------------------------------
  il_zero_bond: set_yield
  ----------------------------------------------------------------------*/
il_zero_bond il_zero_bond.set_yield(number 	option(nullable) yield,
									date  	option(nullable) trade_date, 
									date  	option(nullable) settle_date, 
									//logical option(nullable) set_coupon_to_yield,
									error_info option(nullable) error)
{	
	instrument cc = instrument._set_yield(yield, trade_date, settle_date,false, error);
	return null(cc) ? null<il_zero_bond>: dynamic_cast<il_zero_bond>(cc);
}

/*-----------------------------------------------------------------------
  il_zero_bond: set_settle_date
  ----------------------------------------------------------------------*/
il_zero_bond il_zero_bond.set_settle_date(	date  				settle_date, 
									logical 			re_initialize, 
									error_info option(nullable) error)
{	
	
	instrument cc = instrument._set_settle_date(	settle_date, re_initialize, error);
	return null(cc) ? null<il_zero_bond>: dynamic_cast<il_zero_bond>(cc);
}
/*-----------------------------------------------------------------------
  il_zero_bond: set_quote_from_yield
  ----------------------------------------------------------------------*/
il_zero_bond il_zero_bond.set_quote_from_yield(	number 	option(nullable) yield,
												//logical option(nullable) set_coupon_to_yield,
												error_info option(nullable) error)
{	
	instrument cc = instrument._set_quote_from_yield(yield,  false,error);
	return null(cc) ? null<il_zero_bond>: dynamic_cast<il_zero_bond>(cc);
}

/*-----------------------------------------------------------------------
  hidden in root members
  ----------------------------------------------------------------------*/
logical il_zero_bond.eom(error_info option(nullable) error)					{ return instrument.eom(error);}
string 	il_zero_bond.maturity_code(error_info option(nullable) error)		{ return instrument.maturity_code(error);}
date  	il_zero_bond.first_settle_date(error_info option(nullable) error)	{ return instrument.first_settle_date(error);}
bd_convention il_zero_bond.pmt_bus_day(error_info option(nullable) error) 	{ return instrument.pmt_bus_day(error);}
integer il_zero_bond.comp_freq(error_info option(nullable) error) 			{ return instrument.comp_freq(error);}

number  il_zero_bond.redemp_price(error_info option(nullable) error)		{ return instrument.redemp_price(error);}
day_count_method il_zero_bond.next_last_dc_method(error_info option(nullable) error) { return instrument.next_last_dc_method(error);}
day_count_method il_zero_bond.next_dc_method(error_info option(nullable) error) { return instrument.next_dc_method(error);}
integer il_zero_bond.index_freq(error_info option(nullable) error)			{ return instrument.il_index_freq(error);}
number il_zero_bond.index_factor(error_info option(nullable) error)			{ return instrument.il_index_factor(error);}
number il_zero_bond.index_factor(date option(nullable)	trade_date,
								date 					settle_date,
								//logical 				check_publ_date,
								error_info option(nullable) error)			{ return instrument.il_index_factor(trade_date, settle_date, error);}
number il_zero_bond.base_cpi(	error_info option(nullable) error)			{ return instrument.il_base_cpi(error);	}
cpi_link il_zero_bond.cpi_link(	error_info option(nullable) error)			{ return instrument.il_cpi_link(error);}
void il_zero_bond.cpi_knots(date date,
							out date  option(nullable)	mth_lag1,
							out date   option(nullable)	mth_lag2,
							out logical   option(nullable)	active_lag1,
							out logical   option(nullable)	active_lag2,
							error_info option(nullable) error)				{ instrument.il_cpi_knots(date,mth_lag1,mth_lag2,active_lag1,active_lag2,error);}
void il_zero_bond.cpi_values(	out number  option(nullable)	value1,
								out number   option(nullable)	value2,	
								error_info option(nullable) error)			{ instrument.il_cpi_values(	value1,value2,error);}

/*-----------------------------------------------------------------------
  cpi_link_forecast	
  ----------------------------------------------------------------------*/
..cpi_link il_zero_bond.cpi_link_forecast(	date			cpi_forecast_end,
										number 			assumed_infl_mth,
										vector(number) 	mult_seas_fact,
										date 			seas_base_date,
										error_info option(nullable) 	error) 
{	
	try {	
		error_info ee = new error_info(true,true);
		..cpi_link cpi = this.instr_def(ee).il_cpi_link(ee);
		
		date trade = this.trade_date(ee);
		QL_FAIL_COND(null(trade),"invalid trade date", this,true);

		date base_cpi_date = cpi.find_last_published(trade);
		number base_cpi = cpi.value(base_cpi_date);

		integer  freq = index_freq(ee)	;
		
		vector(date) 	cpi_forecast_dates;
		vector(number) cpi_forecast_values;
		create_cpi_forecast(base_cpi_date, base_cpi,cpi_forecast_end, assumed_infl_mth,mult_seas_fact,
							seas_base_date,freq,cpi_forecast_dates,cpi_forecast_values);
		
		return ..cpi_link_forecast(cpi, cpi_forecast_dates,cpi_forecast_values );
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "il_zero_bond.cpi_link_forecast");			
		return null<..cpi_link>;
	}	
}

/*-----------------------------------------------------------------------
  il_zero_bond: funding

  ----------------------------------------------------------------------*/
void il_zero_bond.funding(	date 						fwd_settle_date,
							number  					repo_rate,
							day_count_method 			day_count_method,
							rate_type option(nullable) 	rate_type,
							disc_func option(nullable) 	disc_func_nominal,										
							..cpi_link option(nullable) cpi_link_forecast,
							number option(nullable)  	nominal,
							out number	dirty_price_fwd,
							out number	cf_fund_cost,
							out number cf_net_fund_cost,								
							out number	cf_coc,								
							out number index_factor,
							out number index_factor_fwd,
							out number cpi_return,
							out number real_return,								
							error_info option(nullable) error)
{	
	number cpn_reinv_rate = null<number>;
	cpn_reinv_type crt= cpn_reinv_type.FIXED;
	number cf_accr, cf_cpn, cf_cpn_reinv;
	instrument.il_bond_funding(fwd_settle_date,repo_rate,cpn_reinv_rate,day_count_method,rate_type,disc_func_nominal,	
					crt,cpi_link_forecast,nominal,dirty_price_fwd,cf_fund_cost,cf_net_fund_cost,
					cf_accr,cf_coc,cf_cpn,cf_cpn_reinv,index_factor,index_factor_fwd,cpi_return,
					real_return,error);
}
/*-----------------------------------------------------------------------
  il_zero_bond: clean_price_fwd

  ----------------------------------------------------------------------*/
number il_zero_bond.clean_price_fwd(date 						fwd_settle_date,
									number  					repo_rate,
									day_count_method 			day_count_method,
									rate_type option(nullable) 	rate_type,
									disc_func option(nullable) 	disc_func_nominal,	
									..cpi_link option(nullable) cpi_link_forecast,	
									logical						ex_inflation,						
									error_info option(nullable) error) 
{	
	number cpn_reinv_rate ;
	cpn_reinv_type crt= cpn_reinv_type.FIXED;
	return instrument.il_clean_price_fwd(fwd_settle_date,repo_rate,cpn_reinv_rate,day_count_method,rate_type,disc_func_nominal,	
						crt,cpi_link_forecast,ex_inflation, error);
}

/*-----------------------------------------------------------------------
  il_zero_bond: dirty_price_fwd

  ----------------------------------------------------------------------*/
number il_zero_bond.dirty_price_fwd(date 						fwd_settle_date,
									number  					repo_rate,
									day_count_method 			day_count_method,
									rate_type option(nullable) 	rate_type,
									disc_func option(nullable) 	disc_func_nominal,	
									..cpi_link option(nullable) cpi_link_forecast,	
									error_info option(nullable) error) 
{	
	number cpn_reinv_rate ;
	cpn_reinv_type crt= cpn_reinv_type.FIXED;
	return instrument.il_dirty_price_fwd(fwd_settle_date,repo_rate,cpn_reinv_rate,day_count_method,rate_type,disc_func_nominal,	
						crt,cpi_link_forecast,error);
}

/*-----------------------------------------------------------------------
  il_zero_bond: yield_fwd

  ----------------------------------------------------------------------*/
number il_zero_bond.yield_fwd(date 						fwd_settle_date,
									number  					repo_rate,									
									day_count_method 			day_count_method,
									rate_type option(nullable) 	rate_type,
									disc_func option(nullable) 	disc_func_nominal,										
									..cpi_link option(nullable) cpi_link_forecast,							
									error_info option(nullable) error)
{	
	number cpn_reinv_rate ;
	cpn_reinv_type crt= cpn_reinv_type.FIXED;
	return instrument.il_yield_fwd(fwd_settle_date,repo_rate,cpn_reinv_rate,day_count_method,rate_type,disc_func_nominal,	
						crt,cpi_link_forecast,error);
}

/*-----------------------------------------------------------------------
  il_zero_bond: roll_down

  ----------------------------------------------------------------------*/
void il_zero_bond.roll_down(	date 						fwd_settle_date,
									disc_func  					disc_func,
									logical  					disc_func_is_real,								
									day_count_method 			day_count_method,
									rate_type option(nullable) 	rate_type,							
									..cpi_link option(nullable) cpi_link_forecast,						
									out number	fwd_yield,
									out number	sprd_vs_crv,
									out number roll_sprd,
									out number	roll_return,															
									error_info option(nullable) error)
{	
	instrument.il_roll_down(fwd_settle_date,disc_func,disc_func_is_real,day_count_method,rate_type,							
				cpi_link_forecast,fwd_yield,sprd_vs_crv,roll_sprd,roll_return,error);
}

/*-----------------------------------------------------------------------
  il_zero_bond: horizon_return

  ----------------------------------------------------------------------*/
number il_zero_bond.horizon_return(	date 						fwd_settle_date,
									number  					quote,
									..quote_style option(nullable) quote_style,	
									day_count_method 			day_count_method,
									rate_type option(nullable) 	rate_type,
									disc_func option(nullable) 	disc_func,	
									..cpi_link option(nullable) cpi_link_forecast,	
									error_info option(nullable) error)
{	
	number cpn_reinv_rate ;
	cpn_reinv_type crt= cpn_reinv_type.FIXED;
	return instrument.il_horizon_return(fwd_settle_date,quote,quote_style,cpn_reinv_rate,day_count_method,rate_type,
								disc_func,crt,cpi_link_forecast,error);
}

/*-----------------------------------------------------------------------
  il_zero_bond: cash_flow_nom_amounts backward compat
  ----------------------------------------------------------------------*/
vector(number) il_zero_bond.cash_flow_nom_amounts(..cpi_link cpi_link,
													number option(nullable) nominal,
													logical post_settle,
													error_info option(nullable) error) option(hidden)
{	
	logical keep_size=false;
	return instrument.il_cash_flow_nom_amounts(cpi_link,nominal,post_settle,keep_size,error);
}

/*-----------------------------------------------------------------------
  il_zero_bond: cash_flows
  ----------------------------------------------------------------------*/
vector(number) il_zero_bond.cash_flows(	..cpi_link 	option(nullable) cpi_forecast,
										il_cf_code 		il_cf_code,
										number option(nullable) 	nominal,
										logical 					post_settle,
										logical 					keep_size,
										error_info option(nullable) error) 
{	
	return instrument.il_cash_flow_amounts(cpi_forecast,nominal,post_settle,keep_size,ir_cf_code.TOTAL, il_cf_code, error);
}

/*-----------------------------------------------------------------------
  cash_flow_data
  ----------------------------------------------------------------------*/
void il_zero_bond.cash_flow_data(..cpi_link 	option(nullable) cpi_forecast,								
								number option(nullable) 	nominal,
								logical 					post_settle,								
								ir_cf_code 		cf_code,
								il_cf_code 		il_cf_code,
								logical 					adj_dates,
								logical 					keep_size,
								out vector(date)   dates,
								out vector(number)   amounts,								
								error_info option(nullable) error)
{	
	try {
		error_info ee = new error_info(true,true);
		amounts = instrument.il_cash_flow_amounts(cpi_forecast,nominal,post_settle,keep_size,cf_code, il_cf_code, ee);	
		dates = instrument.cash_flow_dates(post_settle,adj_dates, keep_size,ee);
		return;	
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "il_zero_bond.cash_flow_data");
		dates = null<vector(date)>;
		amounts = null<vector(number)>;
		return;
	}
}



number il_zero_bond.dirty_price(..cpi_link cpi_link,
								disc_func disc_func_nominal,									
								error_info option(nullable) error)		{	return instrument.il_dirty_price(cpi_link,disc_func_nominal,error);}

number il_zero_bond.clean_price(	logical ex_inflation,									
									error_info option(nullable) error)	{	return instrument.il_clean_price(ex_inflation,error);}



