option(null: hard);	
/*	
	instrument wrapper functions
	Developer: Algorithmica Research, Magnus Nyström			

	--------------------------------------------------------------------
	ir future
	--------------------------------------------------------------------
*/

//-----------------------------------------------------------------------
//  class ir_future
//----------------------------------------------------------------------
class ir_future: public instrument
option(category: "Instrument/Interest Rate Future")
//option(allow_undeclared_mfuncs)
{
public:

	//override string			instr_type_s();
	override instrument 	inst();

	//-----add-funcs-----			
	override void 			add_nominal(number );										
	override void 			add_quote(number,logical option(nullable) = null<logical> );
	void 					add_quote(number,..quote_style,logical option(nullable) = null<logical>);
	void 					add_quote_from_rate(number,logical option(nullable) = null<logical>);
	
	//-----general-----
	override logical 		eom(error_info option(nullable) error = null<error_info>  );
	override string 		maturity_code(error_info option(nullable) error = null<error_info>  );
	override bd_convention 	pmt_bus_day(error_info option(nullable) error = null<error_info>  );
	override day_count_method dc_method(error_info option(nullable) error = null<error_info> );
	number 					contract_rate(error_info option(nullable) error = null<error_info>  );
	irfut_calc_method		style(error_info option(nullable) error = null<error_info>);
	
	logical 				is_daily_mtm(error_info option(nullable) error = null<error_info> );		
	number 					tick_value(number option(nullable),error_info option(nullable) error = null<error_info>  );
	number 					contract_size(error_info option(nullable) error = null<error_info> );	
	number 					tick_size(error_info option(nullable) error = null<error_info> );	

	override calendar 		fixing_calendar(error_info option(nullable) error = null<error_info> );				
	override string 		fixing_calendar_name(error_info option(nullable) error = null<error_info>  );			
	override string 		fixing_code(error_info option(nullable) error = null<error_info>  );		
	override string 		fixing_curve(error_info option(nullable) error = null<error_info> ) ;	
	override string 		fixing_instr(error_info option(nullable) error = null<error_info> ) ;	
	override string 		fixing_instr_qs(error_info option(nullable) error = null<error_info> ) ;		
	override date 			index_maturity(error_info option(nullable) error = null<error_info>  );	
	override ir_index 		ir_index(error_info option(nullable) error = null<error_info>  ); 	
	override date			fixing_date(error_info option(nullable) error = null<error_info> );	
	override string 		index_tenor(error_info option(nullable) error = null<error_info> ) ;
	override tenor_code 	index_tenor_code(error_info option(nullable) error = null<error_info> ) ;

	number 					rate_to_quote(	number ,error_info option(nullable) );
	
	number 					settle_amount(	number,number option(nullable) contract_quote= null<number>,
											number option(nullable)	nominal = 100,logical disc_to_trade = false,	
											disc_func option(nullable)	disc_func = null<disc_func>,
											logical option(nullable) l=null<logical>,error_info option(nullable) error = null<error_info> );

	number 					settle_amount_df(	disc_func ,number option(nullable) contract_quote= null<number>,
												number option(nullable)	nominal = 100,logical disc_to_trade = false,		
												disc_func option(nullable)	disc_func_disc = null<disc_func>,										
												logical option(nullable) l=null<logical>,error_info option(nullable) error = null<error_info> );

	number 					settle_amount_df(	fwd_func ,number option(nullable) contract_quote= null<number>,
												number option(nullable)	nominal = 100,logical disc_to_trade = false,		
												disc_func option(nullable)	disc_func_disc = null<disc_func>,										
												logical option(nullable) l=null<logical>,error_info option(nullable) error = null<error_info> );

	number 					settle_amount_to_market_rate(number, number option(nullable),logical option(nullable),
														error_info option(nullable) error = null<error_info> );	
	
	number 					settle_amount_to_contract_rate(number, number option(nullable),logical option(nullable),
														error_info option(nullable) error = null<error_info> );	

	//-----price-----
	number 					rate(logical = false,error_info option(nullable) error = null<error_info> );		
	number 					rate(disc_func ,logical disable_rounding = false,error_info option(nullable) error = null<error_info> );
	number  				par_rate(	disc_func,	error_info option(nullable) error = null<error_info>);
	//-----cashflow-funcs-----
	vector(date) 			cash_flow_dates(error_info option(nullable) error = null<error_info>);
	vector(number) 			cash_flows(logical,number option(nullable),logical,error_info option(nullable) error = null<error_info>);
	vector(number) 			cash_flows_cpn(logical,number option(nullable),error_info option(nullable) error = null<error_info> );
	
	void  					cash_flow_data(logical	,number option(nullable),logical,out vector(date)   option(nullable),
										out vector(number)  	,error_info option(nullable) error = null<error_info>);	//here to hide cash_flow_data in root


	/*---set functions-required--*/		
	override ir_future		set_quote(number option(nullable),error_info option(nullable) error = null<error_info> );

	override ir_future		set_quote(string option(nullable),error_info option(nullable) error = null<error_info> );

	//local set
	ir_future				set_date(date,logical,logical ,error_info option(nullable) error = null<error_info> );						

	
	ir_future				set_rate(number option(nullable) ,error_info option(nullable) error = null<error_info> );
	
	ir_future				set_rate(number option(nullable) ,date option(nullable),
									logical option(nullable) set_coupon_to_yield = true, error_info option(nullable) error = null<error_info> );

	ir_future				set_quote(	number option(nullable),date option(nullable) trade_date , 
										logical option(nullable) set_coupon_to_quote= true, error_info option(nullable) error = null<error_info> );
	
	ir_future				set_quote(	string option(nullable),date option(nullable) trade_date  , 
										logical option(nullable) set_coupon_to_quote= true, error_info option(nullable) error = null<error_info> );

	ir_future				set_quote_from_rate(number option(nullable),logical option(nullable) set_coupon_to_yield = true,
												error_info option(nullable) error = null<error_info> );

	/*hidden*/
	override date 			maturity_blend(error_info option(nullable) error = null<error_info>);
	
	ir_future(__instrument);	
	override ir_future clone();
	ir_future(ir_future ) ;
protected:

	
	override ir_future 		create(__instrument option(nullable),out instr_error option(nullable),error_type type = E_INVALID_ARG);  

	override ir_future		set_yield(number option(nullable) ,error_info option(nullable) error = null<error_info> );
							
	override ir_future 		set_date(date,date option(nullable) s=null<date> ,logical r = true,logical rq = true ,
									 error_info option(nullable) error = null<error_info> );
	
	override ir_future 		set_date(date,logical ,error_info option(nullable) error = null<error_info> );			/*legacy*/
	override ir_future 		move_date(	date,date option(nullable) s=null<date> ,
										error_info option(nullable) error = null<error_info> );						/*legacy*/

	override vector(date)	cash_flow_dates(logical ,logical, logical, error_info option(nullable) error = null<error_info>  );
	
	override vector(number)	cash_flows_cpn(number option(nullable) nom = null<number>,logical posts = true, logical k=false,
										   error_info option(nullable) error = null<error_info> ); 
	
	override vector(number)	cash_flows(number option(nullable) nom = null<number>,logical posts = true, logical k=false,
									   error_info option(nullable) error = null<error_info> );
	
	/*	
	override void 			cash_flows(	out vector(date)  , out vector(number)   ,
										number option(nullable) nom = null<number>, logical posts = true,out instr_error option(nullable));*/	

	override void 			cash_flow_data(	number option(nullable) ,logical ,ir_cf_code ,logical, logical ,out vector(date)   ,
											out vector(number)   ,error_info option(nullable) error = null<error_info> );

	override number 		dirty_price_to_yield(number ,logical,error_info option(nullable) error = null<error_info> );	
	
	override number 		clean_price_to_yield(number ,logical,error_info option(nullable) error = null<error_info> );	

	override number 		price_to_yield(number ,..quote_style, error_info option(nullable) error = null<error_info> );

	

};
//------------------------------------------------
// constructor [HIDDEN, cannot be protected]
//------------------------------------------------
ir_future.ir_future(__instrument i) option(hidden): instrument(i){}

//------------------------------------------------
// create  [PROTECTED]
// create frn from internal instrument
//------------------------------------------------
ir_future ir_future.create(	__instrument option(nullable) c,
								out instr_error option(nullable) error,
								error_type type )
{
	QL_FAIL_COND(null(c), "invalid/unknown (null) instrument",type );

	logical valid = c.is_valid(error);
	if( !valid && INSTR_CREATE_NULL_ERR)
		return null<ir_future>; 
	
	..instr_type it = c.instr_type(error);
	QL_FAIL_COND(null(it), "invalid instrument type (unknown)",type );
	QL_FAIL_COND(it != ..instr_type.IR_FUTURE, "invalid instrument type",type );//should not happen

	
	return new ir_future(c);
}
/*-----------------------------------------------------------------------
  create_ir_future <FUNCTION>
  ----------------------------------------------------------------------*/
ir_future create_ir_future(	__instrument option(nullable) c,
							out instr_error option(nullable) error,
							error_type type = E_INVALID_ARG)
option(com_name: 'INTERNAL_create_ir_future')
{
	QL_FAIL_COND(null(c), "invalid/unknown (null) instrument",type );

	logical valid = c.is_valid(error);
	if( !valid && INSTR_CREATE_NULL_ERR)
		return null<ir_future>; 
	
	..instr_type it = c.instr_type(error);
	QL_FAIL_COND(null(it), "invalid instrument type (unknown)",type );
	QL_FAIL_COND(it != ..instr_type.IR_FUTURE, "invalid instrument type",type );//should not happen
	
	return new ir_future(c);
}

ir_future create_ir_future(	__instrument option(nullable) 		c,
							error_info option(nullable) 		error,
							error_type 							type = E_INIT)
option(com_name: 'INTERNAL_create_ir_future_ei')
{
	instr_error ee 	= instr_error();
	ir_future b 	= create_ir_future(c,ee, E_INIT);
	if(ee.is_error())
		CORE_INT.add_error_info(error,ee.type(),ee.message(), "create_ir_future");
	return b;
}
//------------------------------------------------
// instr_type_s
//------------------------------------------------
//string ir_future.instr_type_s()  	{ return string(..instr_type.IR_FUTURE);}
//------------------------------------------------
// inst
//------------------------------------------------
instrument 	ir_future.inst()		{ return this;}
//------------------------------------------------
// copy constructor
//------------------------------------------------
ir_future.ir_future(ir_future c) : instrument(c) {}
//------------------------------------------------
// copy constructor <FUNCTION>
//------------------------------------------------
ir_future ir_future(ir_future b)	{ return new ir_future(b);}
//------------------------------------------------
// clone
//------------------------------------------------
ir_future ir_future.clone()			{ return new ir_future(this);}

//-----------------------------------------------
// dynamic cast <FUNCTION>
//-----------------------------------------------
ir_future	ir_future(instrument i, error_info option(nullable) error = null<error_info>) 	
option (category: 'Instrument/Interest Rate Future')
option(com_name: 'ir_future_dyncast') 
{ 
	try {
		ir_future d = dynamic_cast<ir_future>(i); 
		if(null(d))
			CORE_INT.add_error_info(error,ERR_T_INIT,"invalid cast (instrument is not a ir_future)","ir_future" );

		return d;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "ir_future");
		return null<ir_future>;
	}
}

/*-----------------------------------------------------------------------
  hidden in root members
  ----------------------------------------------------------------------*/
logical ir_future.eom(error_info option(nullable) error)				{ return instrument.eom(error);}
string 	ir_future.maturity_code(error_info option(nullable) error) 		{ return instrument.maturity_code(error);}
number  ir_future.contract_rate(error_info option(nullable) error)		{ return instrument.coupon(error);}
bd_convention ir_future.pmt_bus_day(error_info option(nullable) error)	{ return instrument.pmt_bus_day(error);}
day_count_method ir_future.dc_method(error_info option(nullable) error) { return instrument.dc_method(error);}

number  ir_future.rate(logical disable_rounding,
					   error_info option(nullable) error) 				{ return instrument.yield( disable_rounding,error);}
number  ir_future.rate(disc_func disc_func,
					   logical disable_rounding,
					   error_info option(nullable) error) option(com_name: 'rate_fit')	{ return instrument.yield( disc_func,disable_rounding,error);}

logical ir_future.is_daily_mtm(error_info option(nullable) error) 	{ return instrument.fut_daily_mtm(error);}
number  ir_future.contract_size(error_info option(nullable) error)	{ return instrument.fut_contract_size(error);}
number  ir_future.tick_size(error_info option(nullable) error)		{ return instrument.fut_tick_size(error);}
number  ir_future.tick_value(	number option(nullable) tick_size,									
								error_info option(nullable) error) 	{ return instrument.fut_tick_value(tick_size,error); }
string ir_future.fixing_code(error_info option(nullable) error) 	{ return instrument.fixing_code(error) ;}
ir_index ir_future.ir_index(error_info option(nullable) error) 		{ return instrument.ir_index(error) ;}
string ir_future.index_tenor(error_info option(nullable) error) 	{ return instrument.index_tenor(error) ;}
tenor_code ir_future.index_tenor_code(error_info option(nullable) error) 	{ return instrument.index_tenor_code(error);}
calendar ir_future.fixing_calendar(error_info option(nullable) error) 		{ return instrument.fixing_calendar(error) ;}
string ir_future.fixing_calendar_name(error_info option(nullable) error) 	{ return instrument.fixing_calendar_name(error) ;}
date ir_future.index_maturity(error_info option(nullable) error) 	{ return instrument.index_maturity(error) ;}
date ir_future.fixing_date(error_info option(nullable) error) 		{ return instrument.fixing_date(error);}
string ir_future.fixing_curve(error_info option(nullable) error) 	{ return instrument.fixing_curve(error);}
string ir_future.fixing_instr(error_info option(nullable) error) 	{ return instrument.fixing_instr(error);}
string ir_future.fixing_instr_qs(error_info option(nullable) error) { return instrument.fixing_instr_qs(error);}

/*-----------------------------------------------------------------------
  maturity_blend   <hidden>  
  ----------------------------------------------------------------------*/
date ir_future.maturity_blend(error_info option(nullable) error)  option(hidden)
{	
	return index_maturity(error) ;
}
/*-----------------------------------------------------------------------
  add_nominal 
  ----------------------------------------------------------------------*/
void ir_future.add_nominal(number nominal) 
{			
	instrument.add_nominal(nominal );
	return ;						
}

/*-----------------------------------------------------------------------
  ir_future: add_quote
  ----------------------------------------------------------------------*/
void ir_future.add_quote(	number  quote,
							logical option(nullable) set_to_par ) 
{	
	instrument.add_quote(quote, set_to_par);
	return ;					
	
}
/*-----------------------------------------------------------------------
  ir_future: add_quote
  ----------------------------------------------------------------------*/
void ir_future.add_quote(	number  quote,
							..quote_style quote_style,
							logical option(nullable) set_to_par ) 
{
	error_info ee= new error_info(true,true);
	..quote_style qs = instrument.quote_style_e(ee);
	
	if(quote_style == qs)
		instrument.add_quote(quote, set_to_par);
	else{
		if(quote_style == ..quote_style.YIELD) {
			if(qs == ..quote_style.YIELD_PCT)
				instrument.add_quote(quote*100, set_to_par);
			else if(qs == ..quote_style.EDFUT)
				instrument.add_quote(100-quote*100,set_to_par);
			else
				QL_FAIL("invalid quote style", this, true);
		}
		else if(quote_style == ..quote_style.YIELD_PCT){
			if(qs == ..quote_style.YIELD)
				instrument.add_quote(quote/100, set_to_par);
			else if(qs == ..quote_style.EDFUT)
				instrument.add_quote(100-quote, set_to_par);
			else
				QL_FAIL("invalid quote style", this, true);
		}
		else if(quote_style == ..quote_style.EDFUT){
			if(qs == ..quote_style.YIELD)
				instrument.add_quote((100.0-quote)/100, set_to_par);
			else if(qs == ..quote_style.YIELD_PCT)
				instrument.add_quote(100.0-quote, set_to_par);
			else
				QL_FAIL("invalid quote style", this, true);
		}
		else
			QL_FAIL("invalid quote style", this, true);
	}					
}
/*-----------------------------------------------------------------------
  add_quote_from_rate
  ----------------------------------------------------------------------*/
void ir_future.add_quote_from_rate(	number  rate,
									logical option(nullable) set_to_par ) 
{	
	instrument.add_quote_from_yield(rate,  set_to_par );
	return ;						
}

/*-----------------------------------------------------------------------
  set_date  (a version without settledate as argument)
	if trade date is the same --> the settle date will be preserved (if not input)	
	NOTE: 	if coupon is not null in instr_def it is kept unchanged --> deposit will be non-par 
			when a deposit is defined in db the coupon is always null
  ----------------------------------------------------------------------*/
ir_future ir_future.set_date(	date  				trade_date, 					
								logical 			re_init_static, 
								logical 			re_init_quote, 
								error_info option(nullable) error)
{	
	instrument cc = instrument._set_date(trade_date,null<date>,re_init_static,re_init_quote,error);
	return null(cc) ? null<ir_future>: dynamic_cast<ir_future>(cc);	
}

/*-----------------------------------------------------------------------
  set_date <protected>
	if trade date is the same --> the settle date will be preserved (if not input)	
	NOTE: 	if coupon is not null in instr_def it is kept unchanged --> deposit will be non-par 
			when a deposit is defined in db the coupon is always null
  ----------------------------------------------------------------------*/
ir_future ir_future.set_date(	date  				trade_date, 
								date  option(nullable)	settle_date,
								logical 			re_init_static, 
								logical 			re_init_quote, 
								error_info option(nullable) error)
{	
	instrument cc = instrument._set_date(trade_date,null<date>,re_init_static,re_init_quote,error);
	return null(cc) ? null<ir_future>: dynamic_cast<ir_future>(cc);	
}

/*-----------------------------------------------------------------------
  set_date <protected/legacy>
	quote is NOT kept even if trade_date is unchanged
  ----------------------------------------------------------------------*/
ir_future ir_future.set_date(	date  				trade_date, 
								logical 			re_init_static, 
								error_info option(nullable) error) 

{	
	instrument cc = instrument._set_date(trade_date,re_init_static,error);
	return null(cc) ? null<ir_future>: dynamic_cast<ir_future>(cc);	
}

/*-----------------------------------------------------------------------
   move_date  <protected/legacy>
	changes the trade date of the instrument without retrieving the 
 	corresponding quote from the database or the real-time feed.
	if trade date is the same --> the settle date will be preserved	
  ----------------------------------------------------------------------*/
ir_future ir_future.move_date(	date  				trade_date, 
								date option(nullable) settle_date,
								error_info option(nullable) error) 
{	
	instrument cc = instrument._move_date(trade_date,null<date>,error);
	return null(cc) ? null<ir_future>: dynamic_cast<ir_future>(cc);
}

/*-----------------------------------------------------------------------
  ir_future: set_yield protected
  ----------------------------------------------------------------------*/
ir_future ir_future.set_yield(	number 	option(nullable) rate,
								error_info option(nullable) error)
{	
	instrument cc = instrument._set_yield(	rate, null<date>, null<date>,true, error);
	return null(cc) ? null<ir_future>: dynamic_cast<ir_future>(cc);
}

/*-----------------------------------------------------------------------
  ir_future: set_rate
  ----------------------------------------------------------------------*/
ir_future ir_future.set_rate(	number 	option(nullable) rate,
								error_info option(nullable) error)
{	
	instrument cc = instrument._set_yield(	rate, null<date>, null<date>,true, error);
	return null(cc) ? null<ir_future>: dynamic_cast<ir_future>(cc);
}

/*-----------------------------------------------------------------------
  ir_future: set_rate
  ----------------------------------------------------------------------*/
ir_future ir_future.set_rate(number 	option(nullable) rate,
							date  	option(nullable) trade_date, 
							logical option(nullable) set_to_par,
							error_info option(nullable) error) option(com_name: 'set_rate_ext')
{	
	instrument cc = instrument._set_yield(	rate, trade_date,  null<date>,set_to_par, error);
	return null(cc) ? null<ir_future>: dynamic_cast<ir_future>(cc);
}


/*-----------------------------------------------------------------------
  ir_future: set_quote_from_rate
  ----------------------------------------------------------------------*/
ir_future ir_future.set_quote_from_rate(number 	option(nullable) rate,
										logical option(nullable) set_to_par,
										error_info option(nullable) error)
{	
	instrument cc = instrument._set_quote_from_yield(rate,  set_to_par,error);
	return null(cc) ? null<ir_future>: dynamic_cast<ir_future>(cc);
}

/*-----------------------------------------------------------------------
  ir_future: set_quote 
  ----------------------------------------------------------------------*/
ir_future ir_future.set_quote(	number 	option(nullable) quote,
							error_info option(nullable) error)
{	
	instrument cc = instrument._set_quote(quote,null<date>, null<date>, true,error);
	return null(cc) ? null<ir_future>: dynamic_cast<ir_future>(cc);
}

/*-----------------------------------------------------------------------
  ir_future: set_quote 
  ----------------------------------------------------------------------*/
ir_future ir_future.set_quote(	number 	option(nullable) quote,
							date  	option(nullable) trade_date, 
							//date  	option(nullable) settle_date, 
							logical option(nullable) set_to_par,
							error_info option(nullable) error)
{	
	instrument cc = instrument._set_quote(quote,trade_date, null<date>, set_to_par,error);
	return null(cc) ? null<ir_future>: dynamic_cast<ir_future>(cc);
}

/*-----------------------------------------------------------------------
  ir_future: set_quote 
  ----------------------------------------------------------------------*/
ir_future ir_future.set_quote(	string 	option(nullable) quote_side,
							error_info option(nullable) error)
{	
	instrument cc = instrument._set_quote(quote_side,null<date>, null<date>, true,error);
	return null(cc) ? null<ir_future>: dynamic_cast<ir_future>(cc);
}


/*-----------------------------------------------------------------------
  ir_future: set_quote
  ----------------------------------------------------------------------*/
ir_future ir_future.set_quote(	string 	option(nullable) quote_side,
							date  	option(nullable) trade_date, 
							//date  	option(nullable) settle_date, 
							logical option(nullable) set_to_par,
							error_info option(nullable) error)
{	
	instrument cc = instrument._set_quote(quote_side,trade_date, null<date>, set_to_par,error);
	return null(cc) ? null<ir_future>: dynamic_cast<ir_future>(cc);
}

/*-----------------------------------------------------------------------
  style
  ----------------------------------------------------------------------*/
irfut_calc_method ir_future.style(error_info option(nullable) error)
{
	try{	
		instr_error_type t;
   		string 			s;	
		irfut_calc_method c = i().__irfut_calc_method(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "ir_future.style");
		return e ? null<irfut_calc_method>: c;	
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "ir_future.style");
		return null<irfut_calc_method>;
	}
}

/*-----------------------------------------------------------------------
  ir_future: settle_amount
  ----------------------------------------------------------------------*/
number  ir_future.settle_amount(	number  				market_quote,
									number option(nullable)	contract_quote,
									number option(nullable)	nominal,											
									logical					disc_to_trade,
									disc_func option(nullable)	disc_func,
									logical option(nullable) sign_lend,
									error_info option(nullable) error)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		number c = i().__irfut_settle_amount(market_quote,contract_quote,nominal,disc_to_trade,disc_func,sign_lend,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "ir_future.settle_amount");	
		return e ? null<number>: c;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "ir_future.settle_amount");	
		return null<number>;
	}
}


/*-----------------------------------------------------------------------
  ir_future: rate_to_quote
  ----------------------------------------------------------------------*/
number  ir_future.rate_to_quote(	number  				rate,
									error_info option(nullable) error)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		number c = i().__irfut_rate_to_quote(rate,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "ir_future.rate_to_quote");	
		return e ? null<number>: c;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "ir_future.rate_to_quote");	
		return null<number>;
	}
}
/*-----------------------------------------------------------------------
  ir_future: settle_amount_df
  ----------------------------------------------------------------------*/
number  ir_future.settle_amount_df(	disc_func 				disc_func,
										number option(nullable)	contract_quote,
										number option(nullable)	nominal,											
										logical					disc_to_trade,
										disc_func option(nullable)	disc_func_disc,
										logical option(nullable) sign_lend,
										error_info option(nullable) error)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		number c = i().__irfut_settle_amount_df(disc_func,contract_quote,nominal,disc_to_trade,disc_func_disc,sign_lend,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "ir_future.settle_amount_df");	
		return e ? null<number>: c;					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "ir_future.settle_amount_df");
		return null<number>;
	}
}


/*-----------------------------------------------------------------------
  ir_future: settle_amount_df
  ----------------------------------------------------------------------*/
number  ir_future.settle_amount_df(	fwd_func 				fwd_func,
										number option(nullable)	contract_quote,
										number option(nullable)	nominal,											
										logical					disc_to_trade,
										disc_func option(nullable)	disc_func_disc,
										logical option(nullable) sign_lend,	
										error_info option(nullable) error)
option(com_name: 'settle_amount_df_fwd_func') 	
{	
	try{	
		instr_error_type t;
   		string 			s;	
		number c = i().__irfut_settle_amount_df(fwd_func,contract_quote,nominal,disc_to_trade,disc_func_disc,sign_lend,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "ir_future.settle_amount_df");	
		return e ? null<number>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "ir_future.settle_amount_df");
		return null<number>;
	}
}

/*-----------------------------------------------------------------------
   par_rate
  ----------------------------------------------------------------------*/
number  ir_future.par_rate(	disc_func		disc_func,
						error_info option(nullable) error)
{
	try{
		instr_error_type t;
   		string 			s;	
		number c = i().__df_to_par_coupon(disc_func,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "ir_future.par_rate");
		return e ? null<number>: c;	
		
		
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "ir_future.par_rate");
		return null<number>;
	}
}
/*-----------------------------------------------------------------------
  ir_future: cash_flow_dates
  ----------------------------------------------------------------------*/
vector(date) ir_future.cash_flow_dates(error_info option(nullable) error)
{	
	try{	
		instr_error_type t;
   		string 			s;
		vector(date) dates;	
		vector(number) a;	
		i().__irfut_cash_flows(100,true,true,false,dates,a,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "ir_future.cash_flow_dates");	
		return e ? null<vector(date)>: dates;					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "ir_future.cash_flow_dates");
		return null<vector(date)>;
	}
}

/*-----------------------------------------------------------------------
  ir_future: cash_flow_dates
  ----------------------------------------------------------------------*/
vector(date) ir_future.cash_flow_dates(logical post_settle,
										logical adj_dates, 
										logical keep_size,
										error_info option(nullable) error)
{	
	return this.cash_flow_dates(error );
}

/*-----------------------------------------------------------------------
  ir_future: cash_flows

  ----------------------------------------------------------------------*/
/*void ir_future.cash_flows(	logical					borrow,
							number option(nullable) nominal,
								logical					imp_loan_flow,															
								out vector(date)   option(nullable)	dates,
								out vector(number)  	amounts,																	
								error_info option(nullable) error)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		i().__irfut_cash_flows(nominal,borrow,imp_loan_flow,false,dates,amounts,t, s);
		set_error(error,t,s);
		if(error.is_error()){ 
			dates = null<vector(date)>;
			amounts = null<vector(number)>;
		}		
		return ;						
	}
	catch {
		set_error(error,ERR_T_CALC,err.message());
		return ;
	}
}
*/
/*-----------------------------------------------------------------------
  ir_future: cash_flows
  ----------------------------------------------------------------------*/
vector(number) ir_future.cash_flows(logical					borrow,
									number option(nullable) nominal,
									logical					imp_loan_flow,
									error_info option(nullable) error)
{	
	try{	
		instr_error_type t;
   		string 			s;
		vector(date) d;	
		vector(number) amounts;	
		i().__irfut_cash_flows(nominal,borrow,imp_loan_flow,false,d,amounts,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "ir_future.cash_flows");	
		return e ? null<vector(number)>: amounts;					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "ir_future.cash_flows");
		return null<vector(number)>;
	}
}


/*-----------------------------------------------------------------------
  ir_future: cash_flows_cpn
  ----------------------------------------------------------------------*/
vector(number) ir_future.cash_flows_cpn(logical					borrow,
										number option(nullable) nominal,
										error_info option(nullable) error)
{	
	try{	
		instr_error_type t;
   		string 			s;
		vector(date) d;	
		vector(number) amounts;	
		i().__irfut_cash_flows(nominal,borrow,true,true,d,amounts,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "ir_future.cash_flows_cpn");	
		return e ? null<vector(number)>: amounts;					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "ir_future.cash_flows_cpn");
		return null<vector(number)>;
	}
}

/*-----------------------------------------------------------------------
  ir_future: cash_flows_cpn
  ----------------------------------------------------------------------*/
vector(number) ir_future.cash_flows_cpn(number option(nullable) nominal ,
										logical post_settle, 
										logical keep_size,
										error_info option(nullable) error)
{	
	return this.cash_flows_cpn(false,nominal,error);
}

/*-----------------------------------------------------------------------
  ir_future: cash_flows
  ----------------------------------------------------------------------*/
vector(number) ir_future.cash_flows(number option(nullable) nominal ,
										logical post_settle, 
										logical keep_size,
										error_info option(nullable) error)
{	
	return this.cash_flows(false,nominal,true,error);
}

/*-----------------------------------------------------------------------
  ir_future: cash_flows
  ----------------------------------------------------------------------*/
/*void ir_future.cash_flows(	number option(nullable) nominal ,
							logical post_settle,
							out vector(date)   dates,
    						out vector(number)   amounts,
							error_info option(nullable) error)
{	
	this.cash_flows(false,nominal,true,dates,amounts,error);
}

*/
/*-----------------------------------------------------------------------
  ir_future: cash_flow_data
  ----------------------------------------------------------------------*/
void ir_future.cash_flow_data(	logical					borrow,
								number option(nullable) nominal,
								logical					imp_loan_flow,						
								out vector(date)   	dates,
								out vector(number)   amounts,								
								error_info option(nullable) error)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		i().__irfut_cash_flows(nominal,borrow,imp_loan_flow,false,dates,amounts,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "ir_future.cash_flow_data");			
		if(e){ 
			dates = null<vector(date)>;
			amounts = null<vector(number)>;
		}		
		return ;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "ir_future.cash_flow_data");
		dates = null<vector(date)>;
		amounts = null<vector(number)>;
		return ;
	}
}


/*-----------------------------------------------------------------------
  ir_future: cash_flow_data
  ----------------------------------------------------------------------*/
void ir_future.cash_flow_data(	number option(nullable) nominal,
								logical post_settle,
								ir_cf_code cf_code,
								logical adj_dates, 
								logical keep_size,
								out vector(date)   dates,
								out vector(number)   amounts,								
								error_info option(nullable) error)
{	
	try {
		error_info ee = error_info(true,true);
		dates = this.cash_flow_dates(ee);
		
		if(cf_code == ir_cf_code.COUPON) {
			amounts = this.cash_flows_cpn(false,nominal,ee);
		}
		else if(cf_code == ir_cf_code.PRINCIPAL){
			vector(number) cpn = this.cash_flows_cpn(false,nominal,ee);
			amounts = this.cash_flows(false,nominal,true,ee);
			amounts[1] -= cpn[1]; 
		}
		else {
			amounts = this.cash_flows(false,nominal,true,ee);
		}
	}
	catch {
		dates = null<vector(date)>;
		amounts = null<vector(number)>;
		CORE_INT.catch_error_info(error,err.type(),err.message(), "ir_future.cash_flow_data");
		return;
	}
}


/*-----------------------------------------------------------------------
  ir_future: dirty_price_to_yield
  ----------------------------------------------------------------------*/
number  ir_future.dirty_price_to_yield(number dirty_price_pcnt,
										logical disable_rounding ,									
										error_info option(nullable) error) 
{ return fin_instr.err_type(null<number  >, error, "dirty_price_to_yield");}

/*-----------------------------------------------------------------------
  ir_future: clean_price_to_yield
  ----------------------------------------------------------------------*/
number  ir_future.clean_price_to_yield(number dirty_price_pcnt,
										logical disable_rounding ,									
										error_info option(nullable) error) 
{ return fin_instr.err_type(null<number  >, error, "clean_price_to_yield");}


/*-----------------------------------------------------------------------
  ir_future: price_to_yield
  ----------------------------------------------------------------------*/
number  ir_future.price_to_yield(	number price,
									..quote_style qs,									
									error_info option(nullable) error) 
{ return fin_instr.err_type(null<number  >, error, "price_to_yield");}


/*-----------------------------------------------------------------------
  settle_amount_to_market_rate 
  ----------------------------------------------------------------------*/
number ir_future.settle_amount_to_market_rate(number amount_pcnt,
										number option(nullable)	contract_rate,								
										logical option(nullable) sign_lend,
										error_info option(nullable) error)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		number c = i().__irfut_settle_amount_to_mkt_rate(amount_pcnt,contract_rate,sign_lend,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "ir_future.settle_amount_to_market_rate");	
		return e ? null<number>: c;					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "ir_future.settle_amount_to_market_rate");
		return null<number>;
	}
}


/*-----------------------------------------------------------------------
  settle_amount_to_rate 
  ----------------------------------------------------------------------*/
number  ir_future.settle_amount_to_contract_rate(	number amount_pcnt,
													number option(nullable)	market_rate,								
													logical option(nullable) sign_lend,
													error_info option(nullable) error)	
{	
	try{	
		instr_error_type t;
   		string 			s;	
		number c = i().__irfut_settle_amount_to_contract_rate(amount_pcnt,market_rate,sign_lend,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "ir_future.settle_amount_to_contract_rate");	
		return e ? null<number>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "ir_future.settle_amount_to_contract_rate");
		return null<number>;
	}
}

module CORE_INT_IRFUT
{
	
	/*-----------------------------------------------------------------------
	  risk_ladder_fwd
	  ----------------------------------------------------------------------*/
	void  risk_ladder_fwd(	ir_future 			f,
							logical 			sign_borrow,
							number 				nominal,
							vector(fwd_func) 	f_v_pert,
							fwd_func 			f_base,
							fwd_func option(nullable) f_all,
							out vector(number) 	pv_diff_pert,
							out number 			pv_diff_all,
							number				y_shift,
							error_info option(nullable) error ) 
	{
		error_info ee 			= new error_info(true,true);
		//number sign 			= payfix ? 1.0:-1.0; 
				
		integer size = v_size(f_v_pert);
		resize(pv_diff_pert,size);
		pv_diff_pert = 0;

		date d 					= f.trade_date();
		date stl				= f.settle_date();
		number per 				= (stl-d)/365.0;
		
		number  market_rate 	= f_base.fwd(per) ;
		number market_q 		= f.rate_to_quote(market_rate, ee);
		number  contract_q 		= market_q;
		number pv_base 			= f.settle_amount(market_q,contract_q, nominal,false, null<disc_func> ,!sign_borrow, ee);

		number shift_mult 		= 0.0001 / y_shift;	
		number mult 			= /*sign**/shift_mult;
		
		QL_FAIL_COND(ee.is_error(), ee.message(), f.name(), true);
		
		for(integer i=0;i<size;i++){
			QL_FAIL_COND(null(f_v_pert[i]), "fwd_func in vector not valid", f.name(), true);
			
			market_rate = f_v_pert[i].fwd(per) ;
			market_q 	= f.rate_to_quote(market_rate, ee);
			number pvi 	= f.settle_amount(market_q,contract_q, nominal,false, null<disc_func> ,!sign_borrow, ee);
			QL_FAIL_COND(ee.is_error(), ee.message(), f.name(), true);			
			pv_diff_pert[i] = (pvi - pv_base)*mult;			
		
		}
		if(!null(f_all)){

			market_rate 	= f_all.fwd(per) ;
			market_q 		= f.rate_to_quote(market_rate, ee);
			number pv_all 	= f.settle_amount(market_q,contract_q, nominal,false, null<disc_func> ,!sign_borrow, ee);
			QL_FAIL_COND(ee.is_error(), ee.message(), f.name(), true);			
			pv_diff_all = (pv_all - pv_base)*mult;
		}
		else {
			pv_diff_all = null<number>;
		}
			
	}
}
