option(null: hard);	
/*	
	instrument wrapper functions
	Developer: Algorithmica Research, Magnus Nyström			

	--------------------------------------------------------------------
	swap_gen
	an abstract parent class to all swaps
	--------------------------------------------------------------------
	is_ext_swap is a swap created from a fixed_income_swap
*/

/*-----------------------------------------------------------------------
  carry_result
  ----------------------------------------------------------------------*/
object carry_result
{
	date  fwd_trade_date;
	date  fwd_settle_date;
	logical reinv_unchg_df;
	number carry_upfront_leg1;
	number carry_upfront_leg2;
	number carry_fwd_leg1;
	number carry_fwd_leg2;
	number npv_spot_leg1;
	number npv_spot_leg2;
	number npv_fwd_leg1;
	number npv_fwd_leg2;
	number npv_fwd_spot_leg1;
	number npv_fwd_spot_leg2;
	number ai_fwd_leg1;
	number ai_fwd_leg2;
	number reinv_irim_cf_leg1;
	number reinv_irim_cf_leg2;
	number irim_cf_leg1;
	number irim_cf_leg2;
	number npv_spot_ir_leg1;
	number npv_spot_ir_leg2;
	number pvadj_ai_spot_leg1;
	number pvadj_ai_spot_leg2;
	number pvadj_ai_fwd_leg1;
	number pvadj_ai_fwd_leg2;
	number carry_upfront_ai_leg1;
	number carry_upfront_ai_leg2;
	number carry_fwd_ai_leg1;
	number carry_fwd_ai_leg2;

	number npv_spot;
	number npv_fwd;
	number npv_spot_ir ;
	number carry_pv ;
	number carry;
	number carry_pv_ai_adj;	
	number carry_ai_adj ;
	number irim_cf;
	number reinv_irim_cf;
	number ai_fwd;
	number pvadj_ai_fwd;
};

/*-----------------------------------------------------------------------
  rolldown_result
  ----------------------------------------------------------------------*/
object rolldown_result
{
	date fwd_trade_date;
	date fwd_settle_date;
	logical incl_reinv_in_roll;
	number roll_upfront_leg1;
	number roll_upfront_leg2;
	number roll_fwd_leg1;
	number roll_fwd_leg2;
	number npv_spot_leg1;
	number npv_spot_leg2;
	number npv_fwd_leg1;
	number npv_fwd_leg2;
	number npv_fwd_spot_leg1;
	number npv_fwd_spot_leg2;
	number ai_fwd_leg1;
	number ai_fwd_leg2;
	number reinv_irim_cf_leg1;
	number reinv_irim_cf_leg2;
	number irim_cf_leg1;
	number irim_cf_leg2;
	number npv_spot_ir_leg1;
	number npv_spot_ir_leg2;
	number pvadj_ai_spot_leg1;
	number pvadj_ai_spot_leg2;
	number pvadj_ai_fwd_leg1;
	number pvadj_ai_fwd_leg2;
	number roll_upfront_ai_leg1;
	number roll_upfront_ai_leg2;
	number roll_fwd_ai_leg1;
	number roll_fwd_ai_leg2;
	number carry_roll_spot_leg1;
	number carry_roll_spot_leg2;
	number carry_roll_fwd_leg1;
	number carry_roll_fwd_leg2;
	number imp_carry_spot_leg1;
	number imp_carry_spot_leg2;
	number imp_carry_fwd_leg1;
	number imp_carry_fwd_leg2;

	number npv_spot;
	number npv_fwd;
	number irim_cf;
	number reinv_irim_cf;
	number npv_spot_ir ;		
	number roll_pv  ;
	number roll  ;		
	number roll_pv_ai_adj  ;
	number roll_ai_adj ;
	number ai_fwd;
	number pvadj_ai_fwd;
	number carry_roll;
	number carry_implied;
};

//----------------------------------------------------------------------
//  class swap_gen
//----------------------------------------------------------------------
class swap_gen : public instrument
//option(allow_undeclared_mfuncs)
{
public:
	swap_gen(swap_gen c);
	swap_gen(__instrument i);

	override instrument inst() = 0;
	
	virtual void add_quote(number);
	virtual instrument_type 		swap_type(error_info option(nullable) error = null<error_info> ) ;
	virtual ql_fixed_income_swap 	swap_instrument(error_info option(nullable) error = null<error_info>) ;//implemented in root (instrument)
	virtual void 		is_amortizing(out logical,out logical ,error_info option(nullable) error = null<error_info>);
	virtual logical 	is_amortizing(error_info option(nullable) error = null<error_info>);
	//logical				pay_leg1(error_info option(nullable) error = null<error_info>);
	
	override number 	nominal(error_info option(nullable) error = null<error_info> );					/*visible in root*/
	override string 	currency(error_info option(nullable) error = null<error_info> );				/*visible in root*/
	override string 	calendar_name(error_info option(nullable) error = null<error_info> );			/*visible in root*/
	override string 	calendar_name(integer, error_info option(nullable) error = null<error_info> );	/*visible in root*/
	override calendar 	calendar(error_info option(nullable) error = null<error_info>  );				/*visible in root*/
	override calendar 	calendar(integer ,error_info option(nullable) error = null<error_info>  );		/*visible in root*/
	override logical 	eom(error_info option(nullable) error = null<error_info>);						/*visible in root*/
	override integer 	coupon_freq(error_info option(nullable) error = null<error_info> );				/*visible in root*/
	override number 	coupon(error_info option(nullable) error = null<error_info> );					/*visible in root*/

	override date 		first_cpn_date(error_info option(nullable) error = null<error_info>);			/*not visible in root*/
	override date 		last_reg_cpn_date(error_info option(nullable) error = null<error_info>);		/*not visible in root*/
	override date 		cpn_start_date(error_info option(nullable) error = null<error_info>);			/*not visible in root*/
	
	override integer	roll_day(error_info option(nullable) error = null<error_info>);					/*not visible in root*/
	override bd_convention 		pmt_bus_day(error_info option(nullable) error = null<error_info> );		/*not visible in root*/
	override day_count_method 	dc_method(error_info option(nullable) error = null<error_info> );		/*not visible in root*/							
	override date 		issue_date(error_info option(nullable) error = null<error_info> ); 				/*visible in root*/	
	override string 	settle_code(error_info option(nullable) error = null<error_info>);				/*visible in root*/
	override quote_style quote_style_e(error_info option(nullable) error = null<error_info>  );

	virtual void 		ir_rule(out interest_rule , out interest_rule ,error_info option(nullable) error = null<error_info>);
	virtual void  		fx_mult_factor(out number ,out number ,error_info option(nullable) error = null<error_info>) ;
	
	virtual void		notional(out number ,out number ,error_info option(nullable) error = null<error_info>) ;
	virtual void		currency(	out string,out string ,error_info option(nullable) error = null<error_info>) ;
	virtual void 		coupon(out number ,out number , error_info option(nullable) error = null<error_info>) ;
	virtual void 		coupon_freq(out integer,out integer,error_info option(nullable) error = null<error_info> );
	virtual void		reset_freq(out integer,out integer  ,error_info option(nullable) error= null<error_info> ) ;
	virtual	void		first_cpn_date(	out date , out date , error_info option(nullable) error = null<error_info>);
	virtual void  		pmt_bus_day(out bd_convention , out bd_convention ,error_info option(nullable) error = null<error_info>);				
	virtual void 		roll_day(out integer,out integer,error_info option(nullable) error = null<error_info>);
	virtual void 		eom(out logical ,out logical ,error_info option(nullable) error = null<error_info> );
	virtual void 		calendar(out ..calendar ,out ..calendar ,error_info option(nullable) error = null<error_info>);
	virtual void		calendar_name(out string ,out string  , error_info option(nullable) error = null<error_info> ) ;
	virtual void  		last_reg_cpn_date(	out date , out date , error_info option(nullable) error = null<error_info>);
	virtual void 		dc_method(	out day_count_method , out day_count_method ,error_info option(nullable) error = null<error_info>);
	virtual void		effective_date(	out date , out date , error_info option(nullable) error = null<error_info>);
	virtual void  		next_cpn_date(	out date , out date , error_info option(nullable) error = null<error_info>);
	virtual void  		previous_cpn_date(	out date , out date , error_info option(nullable) error = null<error_info>);
	virtual void  		quote_style_e(out ..quote_style , out ..quote_style ,error_info option(nullable) error = null<error_info>);

	void 				swap_pmt_lag( 	out	integer 	pmt_lag_leg1,
										out	integer 	mat_pmt_lag_leg1,
										out	integer 	pmt_lag_prin_leg1,
										out	integer 	mat_pmt_lag_prin_leg1,
										out	integer 	pmt_lag_leg2,
										out	integer 	mat_pmt_lag_leg2,
										out	integer 	pmt_lag_prin_leg2,
										out	integer 	mat_pmt_lag_prin_leg2,	
										error_info option(nullable) error ) ;
	
	virtual void  		final_pmt_date(	out date ,out date ,error_info option(nullable) error = null<error_info> );
		
	virtual void 		quote(out number ,out number , error_info option(nullable) error = null<error_info>) ;
	override number		quote(error_info option(nullable) error = null<error_info>);

	virtual void  		accr_dates(	logical ,out vector(date) ,out vector(date),out vector(number) ,
									out vector(date) ,out vector(date) ,out vector(number) 	,
									error_info option(nullable)  error = null<error_info> );
	virtual void		cash_flow_dates(logical ,out vector(date),out vector(date) ,error_info option(nullable) error = null<error_info> ) ;
	virtual void		cash_flows_cpn(logical ,out vector(number),out vector(number) ,error_info option(nullable) error = null<error_info> ) ;
	virtual void 		cash_flows(	logical,out vector(number),out vector(number),error_info option(nullable) error = null<error_info>);
	virtual void		cash_flow_data(	logical,ir_cf_code,out vector(date) ,out vector(number) ,out vector(date) ,									
										out vector(number) 	,error_info option(nullable) error= null<error_info> ) ;
	virtual void 		cash_flow_data(logical,logical option(nullable),out vector(date)  ,out vector(number) ,
								out vector(number)  ,out vector(number)  , out vector(number)  ,out vector(number)  ,
								out vector(number) ,out vector(date)  	, out vector(number)  ,out vector(number)  ,
								out vector(number)  ,out vector(number)  , out vector(number)  ,out vector(number)  ,
								error_info option(nullable) error = null<error_info> );

	virtual number 		accrued(logical,out number ,out number ,error_info option(nullable) error = null<error_info>);
	virtual void 		accrued_period(out number ,out number ,out integer,out integer,error_info option(nullable) error = null<error_info>);
	virtual number 		accrued_chg  (	integer , out	number ,out number,out	number 	,out number  ,
										out date ,out date ,error_info option(nullable) error = null<error_info> );

	virtual number  	present_value(	disc_func option(nullable),disc_func option(nullable),out number  ,
										out number  ,number option(nullable) , logical option(nullable) trade_date_pv = false,		
										error_info option(nullable) error = null<error_info>);
	
	virtual number  	present_value(	disc_func option(nullable),disc_func option(nullable),out number  ,
										out number ,date option(nullable) ,date option(nullable) ,
										logical,logical  ,error_info option(nullable) error = null<error_info>);
	
	virtual number  	present_value_fee(	disc_func option(nullable),disc_func option(nullable),out number  ,
											out number ,date option(nullable) ,date option(nullable) ,
											logical,logical  ,error_info option(nullable) error = null<error_info>);
	
	virtual number  	present_value(	out number  ,out number  , logical option(nullable) ,error_info option(nullable) error = null<error_info> );

	override number 	mac_dur(error_info option(nullable) error = null<error_info>);
	override number 	mod_dur(error_info option(nullable) error = null<error_info>);
	override number 	dol_dur(error_info option(nullable) error = null<error_info>);
	override number 	convexity(error_info option(nullable) error = null<error_info>);
	override number 	dol_convexity(error_info option(nullable) error = null<error_info>);
	override number 	sensitivity(error_info option(nullable) error = null<error_info>);

	virtual number		solver(	number,swap_solver_code ,logical option(nullable) trade_date_pv = false,
									error_info option(nullable) error = null<error_info>);
	
	disc_func 			disc_func_leg1(error_info option(nullable) error= null<error_info> );
	disc_func 			disc_func_leg2(error_info option(nullable) error = null<error_info>);
	
	//backward compat
	override void 		add_nominal(number) ;
	override void 		add_quote(number,logical option(nullable ));	
	override void 		add_quote_from_yield(number,logical option(nullable) set_coupon_to_yield = null<logical>);
	
	override vector(date) cash_flow_dates(	logical post_settle = true, logical adj_dates = true, logical keep_size = false,
											error_info option(nullable) error = null<error_info>);			/*legacy*/
	override vector(number)	 cash_flows_cpn(	number option(nullable) nom = null<number>, logical post_settle = true, logical keep_size = false,
												error_info option(nullable) error = null<error_info>);		/*legacy*/

	override void 			cash_flows(	out vector(date) , out vector(number)   , number option(nullable) nominal = null<number>,
											logical post_settle = true , error_info option(nullable) error = null<error_info> );			/*legacy*/

	override vector(date)	cash_flow_dates_noadj(logical post_settle = true ,  error_info option(nullable) error = null<error_info>);/*legacy*/					
	
	override vector(number)	cash_flow_amounts(	number option(nullable) nom = null<number>, logical post_settle = true, logical keep_size = false,
												error_info option(nullable) error = null<error_info> );	/*legacy*/			
	
	override vector(number)	cash_flow_nom_amounts(	number option(nullable) nominal = null<number>, logical post_settle = true, logical keep_size = false,
													error_info option(nullable) error = null<error_info> );	/*legacy*/
			
	override vector(number)	cash_flows(	number option(nullable) nom = null<number>, logical post_settle = true, logical keep_size = false,
											error_info option(nullable) error = null<error_info>);
	
	override void 			cash_flow_data(	number option(nullable) ,logical ,ir_cf_code ,logical, logical ,out vector(date)  , out vector(number)  ,
												error_info option(nullable) error = null<error_info>);

	override number 		accrued(logical disable_rounding = false,logical in_pcnt = true, error_info option(nullable) error = null<error_info>);
	override number 		accrued_period(error_info option(nullable) error = null<error_info>);
	override number 		accrued_period(out integer,error_info option(nullable) error = null<error_info>);
	override integer		accrued_days(error_info option(nullable) error= null<error_info>);
	override number 		accrued_chg(integer,out number ,out date ,out date ,logical in_pcnt = true, error_info option(nullable) error = null<error_info>) ; 	
	override number 		present_value(	number option(nullable) nom=null<number>, logical trade_date_pv = false,
											disc_func option(nullable) disc_func_disc = null<disc_func>,
											error_info option(nullable) error = null<error_info>);	
	override number 		present_value(	disc_func, number option(nullable) nom=null<number>, logical trade_date_pv = false,
											disc_func option(nullable) disc_func_disc = null<disc_func>,
											error_info option(nullable) error = null<error_info>);
	override number 		dirty_price_to_yield(number ,logical,error_info option(nullable) error = null<error_info>);		/*visible in root*/			
	override number 		clean_price_to_yield(number ,logical,error_info option(nullable) error = null<error_info>);		/*visible in root*/			
	override number 		price_to_yield(number ,..quote_style, error_info option(nullable) error = null<error_info>);	/*visible in root*/
	
	override number 		dirty_price(number option(nullable) ,logical disable_rounding = false,
										logical in_pcnt = true,error_info option(nullable) error = null<error_info>);				/*hidden, visible in root*/
												
	override number  		dirty_price(logical disable_rounding = false,logical in_pcnt = true,
										error_info option(nullable) error = null<error_info>);										/*hidden, visible in root*/

	override number  		dirty_price(disc_func,logical disable_rounding = false,
										logical in_pcnt = true,error_info option(nullable) error = null<error_info>);				/*hidden, visible in root*/

	override number 		clean_price(number option(nullable),logical disable_rounding = false,
										logical in_pcnt = true,error_info option(nullable) error = null<error_info>);				/*hidden, visible in root*/
												
	override number 		clean_price(logical disable_rounding = false,logical in_pcnt = true,
										error_info option(nullable) error = null<error_info>);										/*hidden, visible in root*/
	override number 		clean_price(disc_func,logical disable_rounding = false,
										logical in_pcnt = true,error_info option(nullable) error = null<error_info>);				/*hidden, visible in root*/
	
	override number 		yield(disc_func ,logical disable_rounding = false, error_info option(nullable) error = null<error_info>);	/*hidden, visible in root*/

	logical 				get_ois_leg1(out ql_ois_leg );
	logical 				get_ois_leg2(out ql_ois_leg );
	logical 				get_float_leg1(out ql_float_leg );
	logical 				get_float_leg2(out ql_float_leg );
	logical 				get_fix_leg1(out ql_fix_leg );
	logical 				get_fix_leg2(out ql_fix_leg );
	logical 				get_zero_leg1(out ql_fix_zero_leg );
	logical 				get_zero_leg2(out ql_fix_zero_leg );
	logical 				leg1_is_fix();
	logical 				leg2_is_fix();
	logical 				leg1_is_zero();
	logical 				leg2_is_zero();
	logical 				leg1_is_flt();
	logical 				leg2_is_flt();
	logical 				leg1_is_ois();
	logical 				leg2_is_ois();
	logical					leg1_is_quote(error_info option(nullable) error = null<error_info> );
	logical					leg2_is_quote(error_info option(nullable) error = null<error_info> );

	//override instrument 	set_quote(number option(nullable),error_info option(nullable) error = null<error_info>);					
	//override instrument 	set_quote(string option(nullable),error_info option(nullable) error = null<error_info>);				
	//override instrument		set_quote_from_yield(number option(nullable) ,error_info option(nullable) error = null<error_info>);
	
protected:
	virtual number		fx_imp_rate(logical , error_info option(nullable) error = null<error_info>);
	logical 			fix_leg_y_ne_cpn_err();
	vector(ql_swap_leg) legs(logical clone,error_info option(nullable) error = null<error_info>);
	override number 	face_amount(error_info option(nullable) error = null<error_info>);				/*visible in root*/

	/*fix leg specific*/
	void 				fix_bond_equiv(	out vector(date),out vector(number) ,out number );
	ql_fix_leg 			fix_leg1(logical,error_info option(nullable) error = null<error_info>);
	void				fix_yield_ext_swap(disc_func,	out number ,out number,out rate_type,out vector(date) , out vector(number) );
	disc_func			implied_par_disc_func_fix_leg(error_info option(nullable) error = null<error_info>);
	virtual number		par_rate_fix_leg(	disc_func, error_info option(nullable) error = null<error_info>);
	virtual number  	imp_rate_fix_leg(	number,logical option(nullable),error_info option(nullable)  error = null<error_info>);
	number 				pv01_fix_leg(	number option(nullable) ,number option(nullable) ,disc_func option(nullable) ,
										error_info option(nullable) error = null<error_info>);
	virtual number		pvdiff_fix_rate(number , disc_func option(nullable) df = null<disc_func>,
											error_info option(nullable) error = null<error_info>);
	disc_func 			df_shifted_fix_leg(number,disc_func);

	void				payment_data_fix_leg(logical,logical,logical option(nullable) ,
										out vector(date),out vector(number),out vector(number) ,out vector(number)  	pv_cpn_cashflow,
										out vector(number),out vector(number),out vector(number)  ,
										error_info option(nullable)  error  = null<error_info>) ;
	
	void  				principal_data_fix_leg(	logical ,logical ,logical option(nullable) ,logical ,
											out vector(date) ,out vector(number),out vector(number) ,
											error_info option(nullable)  error  = null<error_info>) ;
	
	/*float leg specific*/
	
	void				flt_bond_equiv(	logical,out vector(date) ,out vector(number), out number );
	void 				flt_yield_ext_swap(logical ,disc_func ,out number ,out number ,out rate_type ,out vector(date) ,out vector(number) );
	void				payment_data_flt_leg(logical,logical,logical option(nullable) ,out vector(date)  ,out vector(number) ,out vector(logical)  ,
										out vector(date),out vector(number),out vector(number) ,out vector(number)  	pv_cpn_cashflow,
										out vector(number),out vector(number),out vector(number)  ,
										error_info option(nullable)  error  = null<error_info>) ;
	
	void  				principal_data_flt_leg(	logical ,logical ,logical option(nullable) ,logical ,
											out vector(date) ,out vector(number),out vector(number) ,
											error_info option(nullable)  error  = null<error_info>) ;

	void 				index_dates_flt_leg(	logical 			leg1,//false for fixflt
									logical 			post_settle, 
									out vector(date) 	index_start_dates,									
									out vector(date) 	index_end_dates,
									out vector(logical)  index_regular,
									error_info option(nullable) 		error= null<error_info> );

	number  			imp_spread_flt_leg(logical ,number,logical option(nullable) ,error_info option(nullable) error = null<error_info>) ;
	
	disc_func 			df_shifted_idx_rates_flt_leg(	logical 	leg1,
														number 		delta_disc,
														disc_func 	df);

	disc_func 			df_shifted_disc_rates_flt_leg(	logical 	leg1,
														number 		delta_disc,														
														disc_func 	df);

	tenor_surface 		fwd_shifted_flt_leg(	logical 		leg1,
												number 			delta_fwd,
												disc_func 		df,							
												tenor_surface 	ts);

	tenor_surface 		create_tenor_surface_flt_leg(logical 		leg1,
														disc_func df,
														fwd_func fwdf,
														error_info option(nullable) error = null<error_info>);

	tenor_surface 		create_tenor_surface_flt_leg(logical 		leg1,
														disc_func df,
														disc_func fwddf,
														error_info option(nullable) error = null<error_info>);


	/*ois leg specific*/
	void				payment_data_ois_leg(logical,logical,logical option(nullable) ,out vector(date)  ,out vector(number) ,out vector(logical)  ,
										out vector(date),out vector(number),out vector(number) ,out vector(number)  	pv_cpn_cashflow,
										out vector(number),out vector(number),out vector(number)  ,
										error_info option(nullable)  error  = null<error_info>) ;
	
	void  				principal_data_ois_leg(	logical ,logical ,logical option(nullable) ,logical ,
											out vector(date) ,out vector(number),out vector(number) ,
											error_info option(nullable)  error  = null<error_info>) ;
	
	/*moved from instrument root*/
	day_count_method	swap_dc_method_leg1(error_info option(nullable) error = null<error_info> );  	/*DLL_SWAP_HANDLER: ok*/
	day_count_method	swap_dc_method_leg2(error_info option(nullable) error = null<error_info> );		/*DLL_SWAP_HANDLER: ok*/
	string				swap_currency_leg1(error_info option(nullable) error = null<error_info> );
	string				swap_currency_leg2(error_info option(nullable) error = null<error_info> );	
	string				swap_index_tenor_leg1(error_info option(nullable) error = null<error_info> );
	string				swap_index_tenor_leg2(error_info option(nullable) error = null<error_info> );
	tenor_code			swap_index_tenor_code_leg1(error_info option(nullable) error = null<error_info> );
	tenor_code			swap_index_tenor_code_leg2(error_info option(nullable) error = null<error_info> );
	logical				swap_payleg1(error_info option(nullable) error = null<error_info>);
	integer				swap_coupon_freq_leg1(error_info option(nullable) error = null<error_info> );
	integer				swap_coupon_freq_leg2(error_info option(nullable) error = null<error_info> );
	integer				swap_reset_freq_leg1(error_info option(nullable) error = null<error_info> );
	integer				swap_reset_freq_leg2(error_info option(nullable) error = null<error_info> );
	ir_index 			swap_ir_index_leg1(error_info option(nullable) error = null<error_info> );
	ir_index 			swap_ir_index_leg2(error_info option(nullable) error = null<error_info> );
	
	disc_func 			swap_disc_func_leg1(error_info option(nullable) error = null<error_info> ) ;
	disc_func 			swap_disc_func_leg2(error_info option(nullable) error = null<error_info>) ;
	tenor_surface 		swap_tenor_surface_leg1(error_info option(nullable) error = null<error_info>) ;
	tenor_surface 		swap_tenor_surface_leg2(error_info option(nullable) error = null<error_info>) ;
	
	flt_stub_fwd_style 	swap_stub_fwd_style_leg1(error_info option(nullable) error = null<error_info>);
	flt_stub_fwd_style 	swap_stub_fwd_style_leg2(error_info option(nullable) error = null<error_info>);
	
	flt_avg_method 		swap_avg_method_leg1(error_info option(nullable) error = null<error_info>);
	flt_avg_method 		swap_avg_method_leg2(error_info option(nullable) error = null<error_info>);
	
	flt_sprd_comp_method swap_sprd_comp_method_leg1(error_info option(nullable) error = null<error_info>);
	flt_sprd_comp_method swap_sprd_comp_method_leg2(error_info option(nullable) error = null<error_info>);
	flt_comp_avg_type 	swap_comp_avg_type_leg1(error_info option(nullable) error = null<error_info>);
	flt_comp_avg_type 	swap_comp_avg_type_leg2(error_info option(nullable) error = null<error_info>) ;

	rfr_arrears_type 	swap_rfr_arr_type_leg1(error_info option(nullable) error = null<error_info>);
	integer 			swap_rfr_arr_days_leg1(error_info option(nullable) error = null<error_info>);
	rfr_arrears_type 	swap_rfr_arr_type_leg2(error_info option(nullable) error = null<error_info>);
	integer 			swap_rfr_arr_days_leg2(error_info option(nullable) error = null<error_info>);

	vector(ql_swap_leg) 	swap_leg(logical, error_info option(nullable) error = null<error_info>);
	vector(ql_float_leg) 	swap_float_leg(logical, error_info option(nullable) error = null<error_info>);
	vector(ql_fix_leg) 		swap_fix_leg(logical, error_info option(nullable) error = null<error_info>);
	vector(ql_fix_infl_ci_leg) swap_fix_infl_ci_leg(logical, error_info option(nullable) error = null<error_info>);
	
	
	vector(ql_ois_leg) 		swap_ois_leg(logical, error_info option(nullable) error = null<error_info>);
	vector(ql_fix_zero_leg) swap_fix_zero_leg(logical, error_info option(nullable) error = null<error_info>);
	vector(ql_zero_infl_leg) swap_zero_infl_leg(logical, error_info option(nullable) error = null<error_info>);
	vector(ql_yy_infl_leg) swap_yy_infl_leg(logical, error_info option(nullable) error = null<error_info>);

	void 				swap_upfront_carry(	date option(nullable),date option(nullable) ,logical,out carry_result,
											error_info option(nullable) error = null<error_info> );
	
	/*void 				swap_upfront_carry(	date option(nullable) ,date option(nullable) ,logical,out number ,
											out number ,out number ,out number ,out number ,out number ,out number ,
											out number ,out number ,out number ,out number ,out number ,out number ,
											out number ,out number ,out number ,out number ,out number ,out number ,
											out number ,out number ,out number ,out number,out number,out number ,out number,
											error_info option(nullable) error = null<error_info> ) ;*/

	void 				swap_upfront_rolldown(	date option(nullable),date option(nullable) ,logical,out rolldown_result,
												error_info option(nullable) error = null<error_info> );
	
	/*void 				swap_upfront_rolldown(	date option(nullable) ,date option(nullable) ,logical ,out number,
												out number ,out number ,out number ,out number ,out number ,out number ,
												out number ,out number ,out number ,out number ,out number ,out number ,
												out number ,out number ,out number ,out number ,out number ,out number ,
												out number ,out number ,out number ,out number ,out number ,out number ,
												out number ,out number ,out number ,out number ,out number,out number ,out number,
												out number ,out number,
												error_info option(nullable) error = null<error_info>) ;*/

	void 				swap_add_notional(number );
	void 				swap_add_notional(number, number );
	//void 				swap_add_notional_leg1(number );
	//void 				swap_add_notional_leg2(number );
	
	void				swap_add_fx_rate(number,logical ,string ,string );
	void 				swap_add_fx_mult_leg1(number );
	void 				swap_add_fx_mult_leg2(number );
	void 				swap_add_disc_func(disc_func option(nullable)); 
	void 				swap_add_disc_func_leg1(disc_func option(nullable));
	void 				swap_add_disc_func_leg2(disc_func option(nullable));
	void 				swap_add_surface_leg1(tenor_surface option(nullable));
	void 				swap_add_surface_leg2(tenor_surface option(nullable));
	//void 				swap_add_surface_leg3(tenor_surface option(nullable));
	//void 				swap_add_surface_leg4(tenor_surface option(nullable));
	//void 				swap_add_fwd_func_leg1(fwd_func option(nullable));
	//void 				swap_add_fwd_func_leg2(fwd_func option(nullable));
	void				swap_add_curr_fixing_leg1(number option(nullable));
	void				swap_add_curr_fixing_leg2(number option(nullable));
	void 				swap_add_fixing_start_stub_leg1(number option(nullable) ) ;
	void 				swap_add_fixing_start_stub_leg2(number option(nullable) ) ;
	void 				swap_add_fixing_end_stub_leg1(number option(nullable) ) ;
	void 				swap_add_fixing_end_stub_leg2(number option(nullable) ) ;
	void				swap_add_fixing_leg1(vector(date) ,vector(number) ,logical option(nullable) fixing_as_fwd = false);
	void				swap_add_fixing_leg2(vector(date) ,vector(number) ,logical option(nullable) fixing_as_fwd = false);
	void				swap_add_fixing_leg1(number ,logical option(nullable) fixing_as_fwd = false);
	void				swap_add_fixing_leg2(number ,logical option(nullable) fixing_as_fwd = false);

	virtual logical 	verify_full_swap(logical,error_info option(nullable) error = null<error_info>);	
	logical 			check_full_swap(logical, logical, error_info option(nullable) error = null<error_info>);

	logical  is_endog_df_ois_leg1(error_info option(nullable) error = null<error_info>);
	logical  is_endog_df_ois_leg2(error_info option(nullable) error = null<error_info>);
	logical  is_approx_calc_ois_leg1(error_info option(nullable) error = null<error_info>) ;
	logical  is_approx_calc_ois_leg2(error_info option(nullable) error = null<error_info>) ;
	tenor_surface create_tenor_surface_ois_leg1(out disc_func  ,out fwd_func ,logical,error_info option(nullable) error= null<error_info>);
	tenor_surface create_tenor_surface_ois_leg2(out disc_func  ,out fwd_func ,logical,error_info option(nullable) error= null<error_info>);
	tenor_surface create_tenor_surface_ois_leg(	..ir_index ,logical ,out disc_func  ,out fwd_func ,logical,error_info option(nullable) error = null<error_info>);
	void add_disc_func_ois_leg1(disc_func, logical,out tenor_surface );
	void add_disc_func_ois_leg2(disc_func, logical,out tenor_surface);
	void add_fwd_func_ois_leg1(fwd_func, logical ,out disc_func,out tenor_surface );
	void add_fwd_func_ois_leg2(fwd_func, logical ,out disc_func,out tenor_surface );
	void add_fwd_from_disc_func_ois_leg1(disc_func, logical,out tenor_surface );
	void add_fwd_from_disc_func_ois_leg2(disc_func, logical,out tenor_surface );
	void add_curve_data_ois_leg1(disc_func ,disc_func option(nullable) ,logical);
	void add_curve_data_ois_leg2(disc_func ,disc_func option(nullable),logical );
	void add_curve_data_ois_leg1(disc_func ,fwd_func option(nullable) ,logical);
	void add_curve_data_ois_leg2(disc_func ,fwd_func option(nullable) ,logical);

	logical  	is_mtm_leg1(error_info option(nullable) );
	logical  	is_mtm_leg2(error_info option(nullable) );
	void 		reset_mtm();
	void mtm_helper(	number 		option(nullable)	fx_spot,  
							string 		option(nullable)	fx_base_ccy,
							string 		option(nullable)	fx_price_ccy,
							out number fx_spot_leg1_is_base);
	
	void 	SWAP_ENTRY_FUNC(logical = true);
	
	logical ext_swap_;
	logical ccy_swap_;
	logical full_swap_;
};

//------------------------------------------------
// copy constructor
//------------------------------------------------
swap_gen.swap_gen(swap_gen c) : instrument(c),
							ext_swap_(c.ext_swap_), ccy_swap_(c.ccy_swap_), full_swap_(c.full_swap_)
{}

//------------------------------------------------
// constructor [HIDDEN, cannot be protected]
//------------------------------------------------
swap_gen.swap_gen(__instrument i)  : instrument(i)	
{}

/*-----------------------------------------------------------------------
 add_nominal  //if ccy swap: err
 -----------------------------------------------------------------------*/
void swap_gen.add_nominal(number nominal)
{
	this.swap_add_notional(nominal);
}
/*-----------------------------------------------------------------------
  add_quote		EXT SWAP: ok

  Note: 	the logical swap_leg1_is_quote()/swap_leg2_is_quote() determines which leg the quote is added to

  ----------------------------------------------------------------------*/
void swap_gen.add_quote(number  quote,
						logical option(nullable) set_to_par )
{	
	QL_FAIL_COND(!null(set_to_par) && !set_to_par,"set_to_par = false is not supported for swaps",this,true);
	this.add_quote(quote);
	return ;						
}
/*-----------------------------------------------------------------------
  add_quote_from_yield
  Note: 	the logical swap_leg1_is_quote()/swap_leg2_is_quote() determines which leg the quote is added to
  ----------------------------------------------------------------------*/
void swap_gen.add_quote_from_yield(	number  yield,
									logical option(nullable) set_to_par )
{
	QL_FAIL_COND(is_ext_swap(),"inapplicable function call for non-db swaps", this,true);
	QL_FAIL_COND(!null(set_to_par) && !set_to_par,"set_to_par = false is not supported for swaps",this,true);
	i().__add_quote_from_yield(yield , set_to_par );
}
/*-----------------------------------------------------------------------
  add_quote		EXT SWAP: ok
  Note: 	the logical swap_leg1_is_quote()/swap_leg2_is_quote() determines which leg the quote is added to
  ----------------------------------------------------------------------*/
void swap_gen.add_quote(number  quote ) 
{
	//SWAP_ENTRY_FUNC();
	//instrument.add_quote(quote, null<logical>);
	if(is_ext_swap())
		i().__swap_add_quote(quote);	
	else
		i().__add_quote(quote, true);
	return ;						
}

/*-----------------------------------------------------------------------
  swap_instrument   EXT SWAP: ok
  ----------------------------------------------------------------------*/
/*ql_fixed_income_swap swap_gen.swap_instrument(error_info option(nullable) error )
{
	//SWAP_ENTRY_FUNC();
	return instrument.swap_instrument(error);
}*/
/*-----------------------------------------------------------------------
  pay_fix  EXT SWAP: ok
  ----------------------------------------------------------------------*/
/*logical	 swap_gen.pay_leg1(error_info option(nullable) error )
{
	//SWAP_ENTRY_FUNC();
	return this.swap_payleg1(error);
}*/
/*-----------------------------------------------------------------------
  ENTRY_FUNC prot
  ----------------------------------------------------------------------*/
void	swap_gen.SWAP_ENTRY_FUNC(logical allow_non_norm_2swap)
{
	if(!null(full_swap_) && full_swap_)
		return;
	error_info ee = new error_info(true,true);
	full_swap_ = check_full_swap(full_swap_,allow_non_norm_2swap, ee) ;	
}
/*-----------------------------------------------------------------------
  swap_instrument
  ----------------------------------------------------------------------*/
ql_fixed_income_swap swap_gen.swap_instrument(error_info option(nullable) error) option(hidden)
{	
	try{
		SWAP_ENTRY_FUNC();
		instr_error_type t;
   		string 			s;	
		ql_fixed_income_swap c = i().__swap_instrument(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_gen.swap_instrument");
		return e ? null<ql_fixed_income_swap>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.swap_instrument");
		return null<ql_fixed_income_swap >;
	}
}
/*-----------------------------------------------------------------------
  fix_leg_y_ne_cpn_err  (true is an error)
  ----------------------------------------------------------------------*/
logical swap_gen.fix_leg_y_ne_cpn_err()
{	
	//QL_FAIL_COND(ext_swap_,"inapplicable function call for non-db swaps", this,true);
	if(is_ext_swap())
		return false;
	
	instr_error_type t;
	string 			s;	
	number y ;
	try{
		 y = i().__yield(false,t, s);
	}
	catch {
		y = null<number>;
	}
	if(null(y) || t != ERR_T_NONE)
		return false;
	
	number c1,c2;
	i().__swap_coupon(c1,c2,t, s);
	if(t != ERR_T_NONE)
		return false;
		
	if(null(y) || null(c1))
		return false;
	
	return !CORE_INT.is_equal(y, c1); 
}
/*-----------------------------------------------------------------------
  disc_func_leg1 / disc_func_leg2   EXT SWAP: ok
  ----------------------------------------------------------------------*/
disc_func swap_gen.disc_func_leg1(error_info option(nullable) error )
{
	//SWAP_ENTRY_FUNC();
	return this.swap_disc_func_leg1(error);
}
disc_func swap_gen.disc_func_leg2(error_info option(nullable) error )
{
	//SWAP_ENTRY_FUNC();
	return this.swap_disc_func_leg2(error);
}

/*-----------------------------------------------------------------------
  is_amortizing  EXT SWAP: ok
  ----------------------------------------------------------------------*/
void swap_gen.is_amortizing(	out logical is_amort_leg1,
							   out logical is_amort_leg2,
							   error_info option(nullable) error )
{
	try {
		if(!is_ext_swap()) {
			is_amort_leg1 = is_amort_leg2 = false;
				return ;
		}

		error_info ee = new error_info(true,true);
		ql_fixed_income_swap sw = this.swap_instrument(ee) ;
		sw.is_amortizing(is_amort_leg1, is_amort_leg2);

		return;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.is_amortizing");
		is_amort_leg1 = is_amort_leg2 = null<logical>;
		return ;
	}
	
}
/*-----------------------------------------------------------------------
  is_amortizing  EXT SWAP: ok
  ----------------------------------------------------------------------*/
logical swap_gen.is_amortizing(error_info option(nullable) error )
{
	logical is_amort_leg1,is_amort_leg2;
	is_amortizing(is_amort_leg1,is_amort_leg2,error );
	return is_amort_leg1 || is_amort_leg2;
	
}
/*-----------------------------------------------------------------------
  quote 	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_gen.quote(	out number  quote_leg1, 
						out number  quote_leg2, 
						error_info option(nullable) error ) 
{	
	try{
		//SWAP_ENTRY_FUNC();
		instr_error_type t;
   		string 			s;	
		i().__swap_def_quote(quote_leg1,quote_leg2,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_gen.quote");
		if(e)
			quote_leg1 = quote_leg2 = null<number>;
		return ;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.quote");
		quote_leg1 = quote_leg2 = null<number>;
		return ;
	}
}
/*-----------------------------------------------------------------------
  quote   
  ----------------------------------------------------------------------*/
number  swap_gen.quote(error_info option(nullable) error)

{	
	try{
		error_info 	ee = new error_info(true,false);
		number quote_leg1, quote_leg2;
		this.quote(	quote_leg1, quote_leg2,  ee) ;
		if(ee.is_error())
			QL_FAIL( ee.message(),this,true);

		logical l = this.leg1_is_quote(ee);
		
		return l ? quote_leg1: quote_leg2;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.quote");
		return null<number>;
	}
}
/*-----------------------------------------------------------------------
  next_cpn_date   	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_gen.next_cpn_date(	out date  next_cpn_date_leg1, 
								out date  next_cpn_date_leg2, 
								error_info option(nullable) error) 
{
	try{
		error_info ee = error_info(true,true);
		vector(ql_swap_leg) flt = this.legs(false,ee);
		
		QL_FAIL_COND(v_size(flt) < 2,"invalid swap", this, true);				
		next_cpn_date_leg1 = flt[0].next_cpn_date();
		next_cpn_date_leg2 = flt[1].next_cpn_date();
				
		return ;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.next_cpn_date");		
		next_cpn_date_leg1 = next_cpn_date_leg2 = null<date>;
		return ;
	}
}
/*-----------------------------------------------------------------------
  previous_cpn_date   	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_gen.previous_cpn_date(	out date  prev_cpn_date_leg1, 
									out date  prev_cpn_date_leg2, 
									error_info option(nullable) error) 
{
	try{
		error_info ee = error_info(true,true);
		vector(ql_swap_leg) flt = this.legs(false,ee);
		
		QL_FAIL_COND(v_size(flt) < 2,"invalid swap", this, true);				
		prev_cpn_date_leg1 = flt[0].previous_cpn_date();
		prev_cpn_date_leg2 = flt[1].previous_cpn_date();
				
		return ;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.previous_cpn_date");		
		prev_cpn_date_leg1 = prev_cpn_date_leg2 = null<date>;
		return ;
	}
}
/*-----------------------------------------------------------------------
  last_reg_cpn_date   	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_gen.last_reg_cpn_date(	out date  last_reg_cpn_date_leg1, 
									out date  last_reg_cpn_date_leg2, 
									error_info option(nullable) error) 
{
	try{
		error_info ee = error_info(true,true);
		vector(ql_swap_leg) flt = this.legs(false,ee);
		
		QL_FAIL_COND(v_size(flt) < 2,"invalid swap", this, true);				
		last_reg_cpn_date_leg1 = flt[0].last_reg_cpn_date();
		last_reg_cpn_date_leg2 = flt[1].last_reg_cpn_date();
				
		return ;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.last_reg_cpn_date");		
		last_reg_cpn_date_leg1 = last_reg_cpn_date_leg2 = null<date>;
		return ;
	}
}
/*-----------------------------------------------------------------------
  pmt_bus_day 	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_gen.pmt_bus_day(	out bd_convention  pmt_bus_day_leg1, 
							out bd_convention  pmt_bus_day_leg2, 
							error_info option(nullable) error ) 
{	
	try{
		//SWAP_ENTRY_FUNC();
		instr_error_type t;
   		string 			s;	
		i().__swap_def_bd(pmt_bus_day_leg1,pmt_bus_day_leg2,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_gen.pmt_bus_day");
		if(e)
			pmt_bus_day_leg1 = pmt_bus_day_leg2 = null<bd_convention>;
		return ;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.pmt_bus_day");
		pmt_bus_day_leg1 = pmt_bus_day_leg2 = null<bd_convention>;
		return ;
	}
}

//void 		ir_rule(out interest_rule , out interest_rule ,error_info option(nullable) error = null<error_info>);
/*-----------------------------------------------------------------------
  pmt_bus_day 	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_gen.ir_rule(	out interest_rule  ir_rule_leg1, 
						out interest_rule  ir_rule_leg2, 
						error_info option(nullable) error ) 
{	
	try{
		
		instr_error_type t;
   		string 			s;	
		i().__swap_def_int_rule(ir_rule_leg1,ir_rule_leg2,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_gen.ir_rule");
		if(e)
			ir_rule_leg1 = ir_rule_leg2 = null<interest_rule>;
		return ;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.ir_rule");
		ir_rule_leg1 = ir_rule_leg2 = null<interest_rule>;
		return ;
	}
}

/*-----------------------------------------------------------------------
  quote_style_e   <public>  quote_style in instr_def EXT SWAP: ok
  ----------------------------------------------------------------------*/
quote_style swap_gen.quote_style_e(error_info option(nullable) error)
{	
	return instrument.quote_style_e(error);
}
/*-----------------------------------------------------------------------
  quote_style_e 	EXT SWAP: ok
  for example a float spread on a fixfloat has a "quote_style" (either SPREAD_BP or SPREAD)
  ----------------------------------------------------------------------*/
void  swap_gen.quote_style_e(	out ..quote_style  qs_leg1, 
								out ..quote_style  qs_leg2, 
								error_info option(nullable) error ) 
{	
	try{
		//SWAP_ENTRY_FUNC();
		instr_error_type t;
   		string 			s;	
		qs_leg1 = i().__swap_quote_style_e_leg1(t,s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_gen.quote_style_e");
		if(e){
			qs_leg1 = qs_leg2 = null<..quote_style>;
			return;
		}
		qs_leg2 = i().__swap_quote_style_e_leg2(t,s);		
		e = CORE_INT.add_error_info(error,t,s, "swap_gen.quote_style_e");
		if(e){
			qs_leg1 = qs_leg2 = null<..quote_style>;
		}
		return ;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.quote_style_e");
		qs_leg1 = qs_leg2 = null<..quote_style>;
		return ;
	}
}
/*-----------------------------------------------------------------------
  roll_day   	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_gen.roll_day(	out integer  roll_day_leg1, 
							out integer  roll_day_leg2, 
							error_info option(nullable) error ) 
{	
	try{
		//SWAP_ENTRY_FUNC();
		instr_error_type t;
   		string 			s;	
		i().__swap_roll_day(roll_day_leg1,roll_day_leg2,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_gen.roll_day");
		if(e)
			roll_day_leg1 = roll_day_leg2 = err_int();
		return ;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.roll_day");
		roll_day_leg1 = roll_day_leg2 = err_int();
		return ;
	}
}
/*-----------------------------------------------------------------------
  eom   	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_gen.eom(	out logical   	eom_leg1, 
					out logical  	eom_leg2, 
					error_info option(nullable) 	error ) 
{	
	try{
		//SWAP_ENTRY_FUNC();
		instr_error_type t;
   		string 			s;	
		i().__swap_def_eom(eom_leg1,eom_leg2,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_gen.eom");
		if(e)
			eom_leg1 = eom_leg2 = null<logical>;
		return ;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.eom");
		eom_leg1 = eom_leg2 = null<logical>;
		return ;
	}
}
/*-----------------------------------------------------------------------
  cal   	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_gen.calendar(	out ..calendar  cal_leg1, 
							out ..calendar  cal_leg2, 
							error_info option(nullable) error ) 
{	
	try{
		//SWAP_ENTRY_FUNC();
		instr_error_type t;
   		string 			s;	
		i().__swap_def_calendar(cal_leg1,cal_leg2,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_gen.calendar");
		if(e)
			cal_leg1 = cal_leg2 = null<..calendar>;
		return ;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.calendar");
		cal_leg1 = cal_leg2 = null<..calendar>;
		return ;
	}
}
/*-----------------------------------------------------------------------
  calendar_name   	
  ----------------------------------------------------------------------*/
void  swap_gen.calendar_name(	out string  cal_name_leg1, 
								out string  cal_name_leg2, 
								error_info option(nullable) error ) 
{	
	try{
		QL_FAIL_COND(is_ext_swap(),"inapplicable function call for non-db swaps", this,true);
		
		//SWAP_ENTRY_FUNC();
		cal_name_leg1 = this.instr_def(error).swap_calendar_name_leg1(error);
		cal_name_leg2 = this.instr_def(error).swap_calendar_name_leg2(error);
		return ;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.calendar_name");
		cal_name_leg1 = cal_name_leg2 = null<string>;
		return ;
	}
}
/*-----------------------------------------------------------------------
  coupon   	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_gen.coupon(	out number  cpn_leg1, 
						out number  cpn_leg2, 
						error_info option(nullable) error ) 
{	
	try{
		//SWAP_ENTRY_FUNC();
		instr_error_type t;
   		string 			s;	
		i().__swap_coupon(cpn_leg1,cpn_leg2,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_gen.coupon");
		if(e)
			cpn_leg1 = cpn_leg2 = null<number>;
		return ;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.coupon");
		cpn_leg1 = cpn_leg2 = null<number>;
		return ;
	}
}
/*-----------------------------------------------------------------------
  coupon_freq   	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_gen.coupon_freq(	out integer  cpn_freq_leg1, 
							out integer  cpn_freq_leg2, 
							error_info option(nullable) error ) 
{	
	try{
		//SWAP_ENTRY_FUNC();
		instr_error_type t;
   		string 			s;	
		i().__swap_def_cpn_freq(cpn_freq_leg1,cpn_freq_leg2,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_gen.coupon_freq");
		if(e)
			cpn_freq_leg1 = cpn_freq_leg2 = err_freq();
		
		return ;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.coupon_freq");
		cpn_freq_leg1 = cpn_freq_leg2 = err_freq();
		return ;
	}
}
/*-----------------------------------------------------------------------
  reset_freq_flt_leg	
  ----------------------------------------------------------------------*/
void  swap_gen.reset_freq(	out integer  reset_freq_leg1, 
							out integer  reset_freq_leg2, 
							error_info option(nullable) error ) 
{	
	try{
		//SWAP_ENTRY_FUNC();
		instr_error_type t;
   		string 			s;			
		i().__swap_def_reset_freq(reset_freq_leg1,reset_freq_leg2,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_gen.reset_freq");	
		if(e)
			reset_freq_leg1 = reset_freq_leg2 = err_freq();
		
		return ;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.reset_freq");
		reset_freq_leg1 = reset_freq_leg2 = err_freq();
		return ;
	}
}
/*-----------------------------------------------------------------------
  fx_mult_factor	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_gen.fx_mult_factor(	out number  fx_mult_factor_leg1, 
								out number  fx_mult_factor_leg2, 
								error_info option(nullable) error ) 
{	
	try{
		//SWAP_ENTRY_FUNC();
		instr_error_type t;
   		string 			s;	
		i().__swap_fx_rate(fx_mult_factor_leg1,fx_mult_factor_leg2,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_gen.fx_mult_factor");
		if(e)
			fx_mult_factor_leg1 = fx_mult_factor_leg2 = null<number >;
		return ;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.fx_mult_factor");
		fx_mult_factor_leg1 = fx_mult_factor_leg2 = null<number >;
		return ;
	}
}
/*-----------------------------------------------------------------------
  fx_mult_factor	EXT SWAP: ok
  ----------------------------------------------------------------------*/
number  swap_gen.fx_imp_rate(logical leg1_is_baseccy,
							 error_info option(nullable) error )
{	
	try{
		number fx_mult_factor_leg1, fx_mult_factor_leg2;
		instr_error_type t;
   		string 			s;	
		i().__swap_fx_rate(fx_mult_factor_leg1,fx_mult_factor_leg2,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_gen.fx_imp_rate");
		if(e || null(fx_mult_factor_leg1) || null(fx_mult_factor_leg2))
			return null;
		return leg1_is_baseccy ? fx_mult_factor_leg1/fx_mult_factor_leg2: fx_mult_factor_leg2/fx_mult_factor_leg1;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.fx_imp_rate");
		return null;
	}
}
/*-----------------------------------------------------------------------
  currency	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_gen.currency(	out string curr_leg1, 
							out string curr_leg2, 
							error_info option(nullable) error ) 
{	
	try{
		//SWAP_ENTRY_FUNC();
		instr_error_type t;
   		string 			s;	
		i().__swap_def_currency(curr_leg1,curr_leg2,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_gen.currency");
		if(e)
			curr_leg1 = curr_leg2 = null<string>;
		return ;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.currency");
		curr_leg1 = curr_leg2 = null<string>;
		return ;
	}
}
/*-----------------------------------------------------------------------
  notional	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_gen.notional(	out number  notional_leg1, 
							out number  notional_leg2, 
							error_info option(nullable) error ) 
{	
	try{
		//SWAP_ENTRY_FUNC();
		instr_error_type t;
   		string 			s;	
		i().__swap_def_notional(notional_leg1,notional_leg2,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_gen.notional");
		if(e)
			notional_leg1 = notional_leg2 = null<number >;
		return;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.notional");
		notional_leg1 = notional_leg2 = null<number >;
		return ;
	}
}
/*-----------------------------------------------------------------------
  dc_method   	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_gen.dc_method(	out day_count_method  dc_method_leg1, 
							out day_count_method  dc_method_leg2, 
							error_info option(nullable) error ) 
{	
	try{
		//SWAP_ENTRY_FUNC();
		instr_error_type t;
   		string 			s;	
		i().__swap_def_dc_method(dc_method_leg1,dc_method_leg2,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_gen.dc_method");
		if(e)
			dc_method_leg1 = dc_method_leg2 = null<day_count_method>;
		return ;					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.dc_method");
		dc_method_leg1 = dc_method_leg2 = null<day_count_method>;
		return ;
	}
}
/*-----------------------------------------------------------------------
  effective_date   	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_gen.effective_date(	out date  effective_date_leg1, 
								out date  effective_date_leg2, 
								error_info option(nullable) error) 
{
	try{
		error_info ee = error_info(true,true);
		vector(ql_swap_leg) l = this.legs(false,ee);
		
		QL_FAIL_COND(v_size(l) < 2,"invalid swap", this, true);				
		effective_date_leg1 = l[0].effective_date();
		effective_date_leg2 = l[1].effective_date();
				
		return ;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.effective_date");		
		effective_date_leg1 = effective_date_leg2 = null<date>;
		return ;
	}
}
/*-----------------------------------------------------------------------
  first_cpn_date   	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_gen.first_cpn_date(	out date  first_cpn_date_leg1, 
								out date  first_cpn_date_leg2, 
								error_info option(nullable) error) 
{
	try{
		error_info ee = error_info(true,true);
		vector(ql_swap_leg) flt = this.legs(false,ee);
		
		QL_FAIL_COND(v_size(flt) < 2,"invalid swap_gen", this, true);				
		first_cpn_date_leg1 = flt[0].first_cpn_date();
		first_cpn_date_leg2 = flt[1].first_cpn_date();
				
		return ;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.first_cpn_date");		
		first_cpn_date_leg1 = first_cpn_date_leg2 = null<date>;
		return ;
	}
}
/*-----------------------------------------------------------------------
  first_cpn_date  backward compat
  ----------------------------------------------------------------------*/
date swap_gen.first_cpn_date(error_info option(nullable) error) 
{	
	try{
		error_info ee = error_info(true,true);		
		vector(ql_swap_leg) l = this.legs(false,ee);
		
		QL_FAIL_COND(v_size(l) < 2,"invalid swap", this, true);

		date d1 = l[0].first_cpn_date();
		CORE_INT.instr_fail_check(null(d1), "first_cpn_date", this, ee);
		
		return d1;					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.first_cpn_date");
		return null<date>;
	}
}
/*-----------------------------------------------------------------------
  last_reg_cpn_date backward compat
  ----------------------------------------------------------------------*/
date swap_gen.last_reg_cpn_date(error_info option(nullable) error) 
{	
	try{
		error_info ee = error_info(true,true);		
		vector(ql_swap_leg) l = this.legs(false,ee);
		
		QL_FAIL_COND(v_size(l) < 2,"invalid swap", this, true);

		date d1 = l[0].last_reg_cpn_date();
		CORE_INT.instr_fail_check(null(d1), "last_reg_cpn_date", this, ee);
		return d1;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.last_reg_cpn_date");
		return null<date>;
	}
}

/*-----------------------------------------------------------------------
  cpn_start_date	EXT SWAP: ok
  ----------------------------------------------------------------------*/
date swap_gen.cpn_start_date(error_info option(nullable) error) 
{	
	try{	
		error_info ee = error_info(true,true);
		vector(ql_swap_leg) l = this.legs(false,ee);
		
		QL_FAIL_COND(v_size(l) < 2,"invalid swap", this, true);				
		date d1  = l[0].effective_date();
		
		CORE_INT.instr_fail_check(null(d1), "cpn_start_date", this, ee);
		return d1;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.cpn_start_date");
		return null<date>;
	}
}

/*-----------------------------------------------------------------------
  nominal	EXT SWAP: ok
  ----------------------------------------------------------------------*/
number  swap_gen.nominal(error_info option(nullable) error ) 
{
	try{
		QL_FAIL_COND(is_ccy_swap(),"inapplicable function call for currency swaps (use 2-leg version)", this,true);
		//SWAP_ENTRY_FUNC();
		instr_error_type t;
   		string 			s;	
		number c1,c2;
		i().__swap_def_notional(c1,c2,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_gen.notional");	
		return e ? null<number>: c1;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.notional");
		return null<number>;
	}
}
/*-----------------------------------------------------------------------
  face_amount
  ----------------------------------------------------------------------*/
number swap_gen.face_amount(error_info option(nullable) error)
{
	return fin_instr.err_type(null<number>, error, "swap_gen.face_amount");
}
/*-----------------------------------------------------------------------
  currency(fix leg- backward compat)	EXT SWAP: ok
  ----------------------------------------------------------------------*/
string  swap_gen.currency(error_info option(nullable) error )  
{	
	try{
		QL_FAIL_COND(is_ccy_swap(error),"inapplicable function call for currency swaps (use 2-leg version)", this,true);
		//SWAP_ENTRY_FUNC();
		instr_error_type t;
   		string 			s;	
		string c1,c2;
		i().__swap_def_currency(c1,c2,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_gen.currency");	
		return e ? null<string>: c1;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.currency");
		return null<string>;
	}
}
/*-----------------------------------------------------------------------
  eom	EXT SWAP: ok
  ----------------------------------------------------------------------*/
logical swap_gen.eom(error_info option(nullable) error )  
{	
	try{
		//SWAP_ENTRY_FUNC();
		instr_error_type t;
   		string 			s;	
		logical c1,c2;
		i().__swap_def_eom(c1,c2,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_gen.eom");	
		return e ? null<logical>: c1;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.eom");
		return null<logical>;
	}
}
/*-----------------------------------------------------------------------
  calendar_name  	
  ----------------------------------------------------------------------*/
string swap_gen.calendar_name(error_info option(nullable) error )  
{	
	try{
		QL_FAIL_COND(is_ext_swap(error),"inapplicable function call for non-db swaps", this,true);
		
		return this.instr_def(error).swap_calendar_name_leg1(error);
								
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.calendar_name");
		return null<string>;
	}
}
/*-----------------------------------------------------------------------
  calendar_name  	
  ----------------------------------------------------------------------*/
string swap_gen.calendar_name(	integer index,
								 error_info option(nullable) error )  
{	
	try{
		QL_FAIL_COND(index != 0,"function call not applicable swaps (only index = 0 is supported)", this,true);		
		return this.calendar_name(error);
								
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.calendar_name");
		return null<string>;
	}
}
/*-----------------------------------------------------------------------
  calendar  	EXT SWAP: ok
  ----------------------------------------------------------------------*/
..calendar swap_gen.calendar(error_info option(nullable) error )  
{	
	try{
		//QL_FAIL_COND(is_ccy_swap(error),"inapplicable function call for currency swaps (use 2-leg version)", this,true);
		//SWAP_ENTRY_FUNC();
		instr_error_type t;
   		string 			s;	
		..calendar c1,c2;
		i().__swap_def_calendar(c1,c2,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_gen.calendar");
		return e ? null<..calendar>: ..calendar(c1,c2);
		
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.calendar");
		return null<..calendar>;
	}
}
/*-----------------------------------------------------------------------
  calendar
  ----------------------------------------------------------------------*/
calendar swap_gen.calendar(integer index, error_info option(nullable) error) 
{
	try {
		QL_FAIL_COND(index != 0,"function call not applicable swaps (only index = 0 is supported)", this,true);

		return this.calendar(error );
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.calendar");
		return null<..calendar>;
	}
}
/*-----------------------------------------------------------------------
  coupon_freq   (leg1- backward compat)	EXT SWAP: ok
  ----------------------------------------------------------------------*/
integer  swap_gen.coupon_freq(error_info option(nullable) error )  
{	
	try{
		//SWAP_ENTRY_FUNC();
		instr_error_type t;
   		string 			s;	
		integer c1,c2;
		i().__swap_def_cpn_freq(c1,c2,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_gen.coupon_freq");	
		return e ? err_freq(): c1;								
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.coupon_freq");
		return err_freq();
	}
}

/*-----------------------------------------------------------------------
  coupon   (leg1- backward compat)	DLL_SWAP_HANDLER: ok
  ----------------------------------------------------------------------*/
number  swap_gen.coupon(error_info option(nullable) error )  
{	
	try{
		//SWAP_ENTRY_FUNC();
		instr_error_type t;
   		string 			s;	
		number c1,c2;
		i().__swap_coupon(c1,c2,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_gen.coupon");	
		return e ? null<number>: c1;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.coupon");
		return null<number>;
	}
}

/*-----------------------------------------------------------------------
  dc_method   (leg1- backward compat)	EXT SWAP: ok
  ----------------------------------------------------------------------*/
day_count_method  swap_gen.dc_method(error_info option(nullable) error )  
{	
	try{
		//SWAP_ENTRY_FUNC();
		instr_error_type t;
   		string 			s;	
		day_count_method c1,c2;
		i().__swap_def_dc_method(c1,c2,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_gen.dc_method");	
		return e ? null<day_count_method>: c1;					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.dc_method");
		return null<day_count_method>;
	}
}
/*-----------------------------------------------------------------------
  roll_day	EXT SWAP: ok
  ----------------------------------------------------------------------*/
integer swap_gen.roll_day(error_info option(nullable) error )  
{	
	try{
		//SWAP_ENTRY_FUNC();
		instr_error_type t;
   		string 			s;	
		integer c1,c2;
		i().__swap_roll_day(c1,c2,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_gen.roll_day");	
		return e ? err_int(): c1;					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.roll_day");
		return err_int();
	}
}
/*-----------------------------------------------------------------------
  pmt_bus_day   (leg1- backward compat)	EXT SWAP: ok
  ----------------------------------------------------------------------*/
bd_convention swap_gen.pmt_bus_day(error_info option(nullable) error )  
{	
	try{
		//SWAP_ENTRY_FUNC();
		instr_error_type t;
   		string 			s;	
		bd_convention c1,c2;
		i().__swap_def_bd(c1,c2,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_gen.pmt_bus_day");	
		return e ? null<bd_convention>: c1;					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.pmt_bus_day");
		return null<bd_convention>;
	}
}

/*-----------------------------------------------------------------------
  settle_code  EXT SWAP: ok
  ----------------------------------------------------------------------*/
string swap_gen.settle_code(error_info option(nullable) error )  
{	
	try{
		//SWAP_ENTRY_FUNC();
		instr_error_type t;
   		string 			s;
		date_code dc1,dc2;	
		i().__swap_def_settle_code(dc1,dc2,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_gen.settle_code");
		return e ? null<string>: dc1.print();	
						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.settle_code");
		return null<string>;
	}
}
/*-----------------------------------------------------------------------
  issue_date	DLL_SWAP_HANDLER: ok
  ----------------------------------------------------------------------*/
date  swap_gen.issue_date(error_info option(nullable) error ) 
{
	//SWAP_ENTRY_FUNC();
	return instrument.issue_date(error);
}

/*-----------------------------------------------------------------------
  accr_dates	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_gen.accr_dates(	logical 			post_settle, 
							out vector(date) 	accr_start_date_leg1,									
							out vector(date) 	accr_end_date_leg1,
							out vector(number)  accr_period_leg1,
							out vector(date) 	accr_start_date_leg2,
							out vector(date) 	accr_end_date_leg2,
							out vector(number) 	accr_period_leg2,
							error_info option(nullable) 		error ) 
{	
	try{
		//SWAP_ENTRY_FUNC();
		instr_error_type t;
   		string 			s;
		
		i().__swap_accr_dates(post_settle,	accr_start_date_leg1, accr_end_date_leg1, accr_period_leg1,
											accr_start_date_leg2, accr_end_date_leg2, accr_period_leg2,t, s);
		
		logical e = CORE_INT.add_error_info(error,t,s, "swap_gen.accr_dates_leg1");
		if(e) {
			accr_start_date_leg1 = accr_end_date_leg1 = null<vector(date)>; 
			accr_period_leg1 = null<vector(number)>;
			accr_start_date_leg2 = accr_end_date_leg2 = null<vector(date)>; 
			accr_period_leg2 = null<vector(number)>;
		}			
		return ;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.accr_dates_leg1");
		accr_start_date_leg1 = accr_end_date_leg1 = null<vector(date)>; 
		accr_period_leg1 = null<vector(number)>;
		accr_start_date_leg2 = accr_end_date_leg2 = null<vector(date)>; 
		accr_period_leg2 = null<vector(number)>;
		return ;
	}
}

/*-----------------------------------------------------------------------
  cash_flow_data	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_gen.cash_flow_data(	logical 			post_settle,
								ir_cf_code 			cf_code, 
								out vector(date) 	pmt_dates_leg1,									
								out vector(number)  cf_leg1,
								out vector(date) 	pmt_dates_leg2,									
								out vector(number) 	cf_leg2,
								error_info option(nullable) error ) 
{	
	try{
		error_info ee = new error_info(true,true);	
		//QL_FAIL_COND(is_amortizing(ee),"amortizing swaps not supported in this function (work in progress)",this,true);
			
		this.cash_flow_dates(post_settle, pmt_dates_leg1,pmt_dates_leg2,ee) ;
		
		if(cf_code == ir_cf_code.COUPON) {
			this.cash_flows_cpn(post_settle, cf_leg1,cf_leg2,ee) ;
		}
		else if	(cf_code == ir_cf_code.PRINCIPAL) {
			this.cash_flows(post_settle,cf_leg1,cf_leg2,ee) ;
			vector(number) cpn1,cpn2;
			this.cash_flows_cpn(post_settle,cpn1,cpn2,ee) ;
			cf_leg1 -= cpn1;
			cf_leg2 -= cpn2;
		}
		else {
			this.cash_flows(post_settle,cf_leg1,cf_leg2,ee) ;
		}
		return ;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.cash_flow_data");
		cf_leg1 = cf_leg2 = null<vector(number)>;
		pmt_dates_leg1= pmt_dates_leg2 = null<vector(date)>;
		return ;
	}
}

/*-----------------------------------------------------------------------
  cash_flow_data LEGACY	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void swap_gen.cash_flow_data(	number option(nullable) nominal, 
								logical 				post_settle, 
								ir_cf_code 				cf_code,
								logical 				adj_dates, 
								logical 				keep_size,  
								out vector(date)		dates,  
								out vector(number)   	amounts,								
								error_info option(nullable) error ) 
{	
	try{
		QL_FAIL_COND(keep_size == true,"keep size = true not applicable for swaps", this, true);
		QL_FAIL_COND(!null(nominal) && nominal != this.nominal(),"input of nominal not supported for swaps (legacy function)", this, true);

		error_info ee = new error_info(true,true);
		vector(number) cf_leg2;
		vector(date) dates_leg2;
		this.cash_flow_data(post_settle,cf_code, dates,amounts,  dates_leg2, cf_leg2, ee);
		for(integer i=0;i<v_size(amounts);i++)
			amounts[i] = abs(amounts[i]);
		return ;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.cash_flow_data");
		return ;
	}
}

/*-----------------------------------------------------------------------
  cash_flow_data	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_gen.cash_flow_data(	logical 				post_settle,
								logical option(nullable) trade_date_pv,
								out vector(date)  		pmt_date_leg1,
								out vector(number)  	cpn_rate_leg1,
								out vector(number)  	cpn_cashflow_leg1,
								out vector(number)  	pv_cpn_cashflow_leg1,
								out vector(number)  	fee_leg1,
								out vector(number)  	pv_fee_leg1,
								out vector(number)  	notional_leg1,
								out vector(date)  		pmt_date_leg2,
								out vector(number)  	cpn_rate_leg2,
								out vector(number)  	cpn_cashflow_leg2,
								out vector(number)  	pv_cpn_cashflow_leg2,
								out vector(number)  	fee_leg2,
								out vector(number)  	pv_fee_leg2,
								out vector(number)  	notional_leg2,
								error_info option(nullable)  error ) 
{	
	try{
		//SWAP_ENTRY_FUNC();
		instr_error_type t;
   		string 			s;	
		i().__swap_payment_data(trade_date_pv,post_settle, 
								pmt_date_leg1,
								cpn_rate_leg1,
								cpn_cashflow_leg1,
								pv_cpn_cashflow_leg1,
								fee_leg1,
								pv_fee_leg1,
								notional_leg1,
								pmt_date_leg2,
								cpn_rate_leg2,
								cpn_cashflow_leg2,
								pv_cpn_cashflow_leg2,
								fee_leg2,
								pv_fee_leg2,
								notional_leg2, t,s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_gen.cash_flow_data");
		if(e) {
			cpn_rate_leg1 = cpn_cashflow_leg1 = pv_cpn_cashflow_leg1 = fee_leg1 = null<vector(number)>;
			pv_fee_leg1 = notional_leg1 = null<vector(number)>;
			cpn_rate_leg2 = cpn_cashflow_leg2 = pv_cpn_cashflow_leg2 = fee_leg2 = null<vector(number)>;
			pv_fee_leg2 = notional_leg2 = null<vector(number)>;
			pmt_date_leg1= pmt_date_leg2 = null<vector(date)>; 
		}			
		return ;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.cash_flow_data");
		cpn_rate_leg1 = cpn_cashflow_leg1 = pv_cpn_cashflow_leg1 = fee_leg1 = null<vector(number)>;
		pv_fee_leg1 = notional_leg1 = null<vector(number)>;
		cpn_rate_leg2 = cpn_cashflow_leg2 = pv_cpn_cashflow_leg2 = fee_leg2 = null<vector(number)>;
		pv_fee_leg2 = notional_leg2 = null<vector(number)>;
		pmt_date_leg1= pmt_date_leg2 = null<vector(date)>; 
		return ;
	}
}
/*-----------------------------------------------------------------------
  payment_data_fix_leg	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_gen.payment_data_fix_leg(logical leg2,
									logical 				post_settle,
									logical option(nullable) trade_date_pv,
									out vector(date)  		pmt_date,
									out vector(number) 		cpn_rate,
									out vector(number)  	cpn_cashflow,
									out vector(number)  	pv_cpn_cashflow,
									out vector(number)  	fee,
									out vector(number)  	pv_fee,
									out vector(number)  	notional ,
									error_info option(nullable)  error ) 
{	
	try{
		SWAP_ENTRY_FUNC();

		/*error_info ee 		= new error_info(true,true);
		vector(ql_fix_leg) l = swap_gen.swap_fix_leg(false,ee);

		ql_fix_leg fix;
		if(leg2 )	
			fix = leg1_is_fix() ? l[1]:l[0];
		else
			fix = l[0];*/

		ql_fix_leg fix;
		if(leg2)
			QL_REQUIRE(get_fix_leg2(fix),"invalid function call");
		else
			QL_REQUIRE(get_fix_leg1(fix),"invalid function call");
				
		date cut_off = post_settle ? this.settle_date() : null;
	
		fix.payment_data(pmt_date,cpn_rate,cpn_cashflow,pv_cpn_cashflow,
						 fee,pv_fee, notional, trade_date_pv,cut_off);
						
		return ;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.payment_data_fix_leg");
		pmt_date = null;
		cpn_rate = cpn_cashflow = pv_cpn_cashflow = fee = null<vector(number)>;
		pv_fee = notional = null<vector(number)>;
		return ;
	}
}

/*-----------------------------------------------------------------------
  principal_data_fix_leg	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_gen.principal_data_fix_leg(	logical 				leg2,
										logical 				post_settle,
										logical option(nullable) trade_date_pv,
										logical 				only_real_cf,
										out vector(date) 		prin_date,
										out vector(number) 		prin_cf,	
										out vector(number) 		pv_prin_cf,
										error_info option(nullable)  error ) 
{	
	try{
		SWAP_ENTRY_FUNC();

		/*error_info ee 		= new error_info(true,true);
		vector(ql_fix_leg) l = swap_gen.swap_fix_leg(false,ee);

		ql_fix_leg fix;
		if(leg2 )	
			fix = leg1_is_fix() ? l[1]:l[0];
		else
			fix = l[0];*/
		ql_fix_leg fix;
		if(leg2)
			QL_REQUIRE(get_fix_leg2(fix),"invalid function call");
		else
			QL_REQUIRE(get_fix_leg1(fix),"invalid function call");
		
		date cut_off = post_settle ? this.settle_date() : null;
	
		fix.principal_data(prin_date,prin_cf,	pv_prin_cf,only_real_cf, trade_date_pv, cut_off);
						
		return ;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.principal_data_fix_leg");
		prin_date = null;
		prin_cf = pv_prin_cf = null<vector(number)>;
	
		return ;
	}
}
/*-----------------------------------------------------------------------
  payment_data_flt_leg	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_gen.payment_data_flt_leg(logical leg2,
									logical 				post_settle,
									logical option(nullable) trade_date_pv,
									out vector(date)  		fixing_date,									
									out vector(number)  	fixing_rate,
									out vector(logical)  	is_fixed,
									out vector(date)  		pmt_date,
									out vector(number) 		cpn_rate,
									out vector(number)  	cpn_cashflow,
									out vector(number)  	pv_cpn_cashflow,
									out vector(number)  	fee,
									out vector(number)  	pv_fee,
									out vector(number)  	notional ,
									error_info option(nullable)  error ) 
{	
	try{
		SWAP_ENTRY_FUNC();

		/*error_info ee 		= new error_info(true,true);
		vector(ql_float_leg) l = swap_gen.swap_float_leg(false,ee);

		ql_float_leg flt;
		if(leg2 )	
			flt = leg1_is_flt() ? l[1]:l[0];
		else
			flt = l[0];*/

		ql_float_leg flt;
		if(leg2)
			QL_REQUIRE(get_float_leg2(flt),"invalid function call");
		else
			QL_REQUIRE(get_float_leg1(flt),"invalid function call");
		
		date cut_off = post_settle ? this.settle_date() : null;
		vector(date) pmt_date_sync;//useful when reset_freq>cpn_freq
		flt.payment_data(fixing_date, fixing_rate,is_fixed,pmt_date_sync,pmt_date,cpn_rate,cpn_cashflow,pv_cpn_cashflow,
						 fee,pv_fee, notional, trade_date_pv,cut_off);
						
		return ;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.payment_data_flt_leg");
		fixing_date = pmt_date = null;
		is_fixed = null;
		fixing_rate = cpn_rate = cpn_cashflow = pv_cpn_cashflow = fee = null<vector(number)>;
		pv_fee = notional = null<vector(number)>;
		return ;
	}
}

/*-----------------------------------------------------------------------
  principal_data_flt_leg	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_gen.principal_data_flt_leg(	logical 				leg2,
										logical 				post_settle,
										logical option(nullable) trade_date_pv,
										logical 				only_real_cf,
										out vector(date) 		prin_date,
										out vector(number) 		prin_cf,	
										out vector(number) 		pv_prin_cf,
										error_info option(nullable)  error ) 
{	
	try{
		SWAP_ENTRY_FUNC();

		/*error_info ee 		= new error_info(true,true);
		vector(ql_float_leg) l = swap_gen.swap_float_leg(false,ee);

		ql_float_leg flt;
		if(leg2 )	
			flt = leg1_is_flt() ? l[1]:l[0];
		else
			flt = l[0];*/

		ql_float_leg flt;
		if(leg2)
			QL_REQUIRE(get_float_leg2(flt),"invalid function call");
		else
			QL_REQUIRE(get_float_leg1(flt),"invalid function call");
		
		date cut_off = post_settle ? this.settle_date() : null;
	
		flt.principal_data(prin_date,prin_cf,	pv_prin_cf,only_real_cf, trade_date_pv, cut_off);
						
		return ;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.principal_data_flt_leg");
		prin_date = null;
		prin_cf = pv_prin_cf = null<vector(number)>;
	
		return ;
	}
}

/*-----------------------------------------------------------------------
  payment_data_ois_leg	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_gen.payment_data_ois_leg(logical leg2,
									logical 				post_settle,
									logical option(nullable) trade_date_pv,
									out vector(date)  		fixing_date,									
									out vector(number)  	fixing_rate,
									out vector(logical)  	is_fixed,									
									out vector(date)  		pmt_date,
									out vector(number) 		cpn_rate,
									out vector(number)  	cpn_cashflow,
									out vector(number)  	pv_cpn_cashflow,
									out vector(number)  	fee,
									out vector(number)  	pv_fee,
									out vector(number)  	notional ,
									error_info option(nullable)  error ) 
{	
	try{
		SWAP_ENTRY_FUNC();

		/*error_info ee 		= new error_info(true,true);
		vector(ql_ois_leg) l = swap_gen.swap_ois_leg(false,ee);

		ql_ois_leg ois;
		if(leg2 )	
			ois = leg1_is_ois() ? l[1]:l[0];
		else
			ois = l[0];*/

		ql_ois_leg ois;
		if(leg2)
			QL_REQUIRE(get_ois_leg2(ois),"invalid function call");
		else
			QL_REQUIRE(get_ois_leg1(ois),"invalid function call");
		
		date cut_off = post_settle ? this.settle_date() : null;
		vector(date) pmt_date_sync;
		ois.payment_data(fixing_date, fixing_rate,is_fixed,pmt_date_sync,pmt_date,cpn_rate,cpn_cashflow,pv_cpn_cashflow,
						 fee,pv_fee, notional, trade_date_pv,cut_off);
						
		return ;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.payment_data_ois_leg");
		fixing_date = pmt_date = null;
		is_fixed = null;
		fixing_rate = cpn_rate = cpn_cashflow = pv_cpn_cashflow = fee = null<vector(number)>;
		pv_fee = notional = null<vector(number)>;
		return ;
	}
}

/*-----------------------------------------------------------------------
  principal_data_ois_leg	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_gen.principal_data_ois_leg(	logical 				leg2,
									logical 				post_settle,
									logical option(nullable) trade_date_pv,
									logical 				only_real_cf,
									out vector(date) 		prin_date,
									out vector(number) 		prin_cf,	
									out vector(number) 		pv_prin_cf,
									error_info option(nullable)  error ) 
{	
	try{
		SWAP_ENTRY_FUNC();

		/*error_info ee 		= new error_info(true,true);
		vector(ql_ois_leg) l = swap_gen.swap_ois_leg(false,ee);

		ql_ois_leg ois;
		if(leg2 )	
			ois = leg1_is_ois() ? l[1]:l[0];
		else
			ois = l[0];*/

		ql_ois_leg ois;
		if(leg2)
			QL_REQUIRE(get_ois_leg2(ois),"invalid function call");
		else
			QL_REQUIRE(get_ois_leg1(ois),"invalid function call");
		
		date cut_off = post_settle ? this.settle_date() : null;
	
		ois.principal_data(prin_date,prin_cf,	pv_prin_cf,only_real_cf, trade_date_pv, cut_off);
						
		return ;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.principal_data_ois_leg");
		prin_date = null;
		prin_cf = pv_prin_cf = null<vector(number)>;
	
		return ;
	}
}

/*-----------------------------------------------------------------------
  final_pmt_date	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_gen.final_pmt_date(	out date 	final_pmt_date_leg1,									
								out date 	final_pmt_date_leg2,
								error_info option(nullable) error ) 
{	
	try{
		error_info ee = new error_info(true,true);
		vector(date) 	pmt_dates_leg1,	 pmt_dates_leg2;
		this.cash_flow_dates(false,  pmt_dates_leg1, pmt_dates_leg2, ee );
		integer s1 = v_size(pmt_dates_leg1);
		final_pmt_date_leg1 = s1 > 0 ? pmt_dates_leg1[s1-1] : null;
		integer s2 = v_size(pmt_dates_leg2);
		final_pmt_date_leg2 = s2 > 0 ? pmt_dates_leg2[s2-1] : null;
		return;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.final_pmt_date");
		final_pmt_date_leg1 = final_pmt_date_leg1 = null; 
		return ;
	}
}

/*-----------------------------------------------------------------------
  cash_flow_dates	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_gen.cash_flow_dates(	logical 			post_settle, 
								out vector(date) 	pmt_dates_leg1,									
								out vector(date) 	pmt_dates_leg2,
								error_info option(nullable) error ) 
{	
	try{
		//SWAP_ENTRY_FUNC();
		instr_error_type t;
   		string 			s;	
		i().__swap_ir_pmt_dates(post_settle,pmt_dates_leg1,pmt_dates_leg2, t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_gen.cash_flow_dates");
		if(e) {
			pmt_dates_leg1 = pmt_dates_leg2 = null<vector(date)>; 
		}
		return;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.cash_flow_dates");
		pmt_dates_leg1 = pmt_dates_leg2 = null<vector(date)>; 
		return ;
	}
}
/*-----------------------------------------------------------------------
  cash_flow_dates  (leg1- backward compat)	LEGACY EXT SWAP: ok
  ----------------------------------------------------------------------*/
vector(date) swap_gen.cash_flow_dates(	logical post_settle, 
										logical adj_dates,   
										logical keep_size,  
										error_info option(nullable) error )
{
	try{
		QL_FAIL_COND(keep_size == true,"keep size = true not applicable for swaps", this, true);

		vector(date) pmt_dates_leg1,pmt_dates_leg2;
		this.cash_flow_dates(post_settle,pmt_dates_leg1,pmt_dates_leg2,error);
		return pmt_dates_leg1;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.cash_flow_dates");
		return null<vector(date)>;
	}
}

/*-----------------------------------------------------------------------
  cash_flows_cpn	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_gen.cash_flows_cpn(	logical 			post_settle, 
								out vector(number) 	cpn_cf_leg1,									
								out vector(number) 	cpn_cf_leg2,
								error_info option(nullable) error ) 
{	
	try{
		//SWAP_ENTRY_FUNC();
		instr_error_type t;
   		string 			s;	
		i().__swap_cashflows_cpn(post_settle,cpn_cf_leg1,cpn_cf_leg2, t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_gen.cash_flows_cpn");
		if(e) {
			cpn_cf_leg1 = cpn_cf_leg2 = null<vector(number)>;
		}
		return;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.cash_flows_cpn");
		cpn_cf_leg1 = cpn_cf_leg2 = null<vector(number)>;
		return ;
	}
}
/*-----------------------------------------------------------------------
  cash_flows_cpn LEGACY  (leg1 - backward compat)	EXT SWAP: ok
  ----------------------------------------------------------------------*/
vector(number) swap_gen.cash_flows_cpn(	number option(nullable) nominal, 
										logical post_settle, 
										logical keep_size,  
										error_info option(nullable) error )
{	
	try{
		QL_FAIL_COND(keep_size == true,"keep size = true not applicable for swaps", this, true);
		QL_FAIL_COND(!null(nominal) && nominal != this.nominal(),"input of nominal not supported for swaps (legacy function)", this, true);

		error_info ee = new error_info(true,true);
		vector(number) cf_leg1,cf_leg2;
		this.cash_flows_cpn(post_settle,cf_leg1,cf_leg2, ee);
		
		for(integer i=0;i<v_size(cf_leg1);i++)
			cf_leg1[i] = abs(cf_leg1[i]);
		return cf_leg1;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.cash_flows_cpn");
		return null<vector(number)>;
	}

}
/*-----------------------------------------------------------------------
  cash_flows	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_gen.cash_flows(	logical 			post_settle, 
							out vector(number) 	cf_leg1,									
							out vector(number) 	cf_leg2,
							error_info option(nullable) error ) 
{	
	try{
		//SWAP_ENTRY_FUNC();
		instr_error_type t;
   		string 			s;	
		logical or=true;
		i().__swap_cashflows(post_settle,or,cf_leg1,cf_leg2, t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_gen.cash_flows");
		if(e) {
			cf_leg1 = cf_leg2 = null<vector(number)>;
		}
		return;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.cash_flows");
		cf_leg1 = cf_leg2 = null<vector(number)>;
		return ;
	}
}
/*-----------------------------------------------------------------------
  cash_flows  LEGACY
  ----------------------------------------------------------------------*/
void swap_gen.cash_flows(out vector(date)   dates,
						out vector(number)   amounts,
						number option(nullable) nominal ,
						logical post_settle,							
						error_info option(nullable) error)  
{
	//instr_error_type t;
   	//	string 			s;	
	//amounts = i().__cash_flows(nominal ,post_settle, false, t, s);

		
	QL_FAIL_COND(!null(nominal) && nominal != this.nominal(),"input of nominal not supported for swaps (legacy function)", this, true);
	vector(date) pmt_dates_flt_leg;									
	vector(number) cf_flt_leg;

	this.cash_flow_data(	post_settle, ir_cf_code.COUPON, dates,amounts,
							pmt_dates_flt_leg,	cf_flt_leg,error );

	number notional_fix_leg,  notional_flt_leg;
	notional(notional_fix_leg, notional_flt_leg, error ) ;
	integer s = v_size(amounts);
	for(integer i=0; i<s;i++){
		amounts[i] = abs(amounts[i]);
	}
	
	amounts[s-1] += abs(notional_fix_leg);
}
/*-----------------------------------------------------------------------
  cash_flow_dates_noadj  LEGACY
  ----------------------------------------------------------------------*/
vector(date) swap_gen.cash_flow_dates_noadj(	logical 	post_settle,
												error_info option(nullable) error) 
												
{
	vector(date)  dates;
	vector(number)  amounts;
	this.cash_flow_data(null<number>, post_settle, ir_cf_code.TOTAL,false,false,  
						dates,  amounts, error );
	return dates;
}

/*-----------------------------------------------------------------------
  cash_flow_amounts  LEGACY
  ----------------------------------------------------------------------*/
vector(number) swap_gen.cash_flow_amounts(number option(nullable) nominal,
											logical post_settle,
											logical keep_size,											
											error_info option(nullable) error) 

{	
	vector(date)  dates;
	vector(number)  amounts;
	this.cash_flow_data(nominal, post_settle, ir_cf_code.COUPON,false,keep_size,  
						dates,  amounts, error );

	number notional_fix_leg,  notional_flt_leg;
	notional(notional_fix_leg, notional_flt_leg, error ) ;
	integer s = v_size(amounts);
	for(integer i=0; i<s;i++){
		amounts[i] = abs(amounts[i]);
	}
	amounts[s-1] += abs(notional_fix_leg);
	
	return amounts;
}
/*-----------------------------------------------------------------------
  cash_flow_nom_amounts  LEGACYprot
  ----------------------------------------------------------------------*/
vector(number) swap_gen.cash_flow_nom_amounts(number option(nullable) nominal,
												logical post_settle,
												logical keep_size,
												error_info option(nullable) error) 
{	
	return this.cash_flow_amounts(nominal,post_settle, keep_size,error) ;
}
/*-----------------------------------------------------------------------
  cash_flows  LEGACY	EXT SWAP: ok
  ----------------------------------------------------------------------*/
vector(number) swap_gen.cash_flows(	number option(nullable) nominal, 
										logical 				post_settle, 
										logical 				keep_size,  
										error_info option(nullable) error )
{	
	try{
		QL_FAIL_COND(keep_size == true,"keep size = true not applicable for swaps", this, true);
		QL_FAIL_COND(!null(nominal) && nominal != this.nominal(),"input of nominal not supported for swaps (legacy function)", this, true);

		error_info ee = new error_info(true,true);
		vector(number) cf_leg1,cf_leg2;
		this.cash_flows(post_settle,cf_leg1,cf_leg2, ee);
		
		for(integer i=0;i<v_size(cf_leg1);i++)
			cf_leg1[i] = abs(cf_leg1[i]);
		return cf_leg1;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.cash_flows");
		return null<vector(number)>;
	}
}

/*-----------------------------------------------------------------------
  accrued	EXT SWAP: ok
  ----------------------------------------------------------------------*/
number  swap_gen.accrued(	logical 	in_pcnt,
							out number  accr_leg1,									
							out number  accr_leg2,
							error_info option(nullable) error ) 
option(com_name: 'accrued_ext')
{	
	try{
		//SWAP_ENTRY_FUNC();
		instr_error_type t;
   		string 			s;	
		number c = i().__swap_accrued(in_pcnt,accr_leg1,accr_leg2, t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_gen.accrued");
		if(e) {
			accr_leg1 = accr_leg2 = null<number>;
			return  null<number>;
		}
		return c;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.accrued");
		accr_leg1 = accr_leg2 = null<number>; 
		return null<number>;
	}
}
/*-----------------------------------------------------------------------
  accrued	EXT SWAP: ok
  ----------------------------------------------------------------------*/
number  swap_gen.accrued(	logical 	disable_rounding,
							logical 	in_pcnt,
							error_info option(nullable) error ) 
{
	number accr_leg1,accr_leg2;
	return this.accrued(in_pcnt,accr_leg1,accr_leg2,error);
}
/*-----------------------------------------------------------------------
  accrued_period  EXT SWAP: ok
  ----------------------------------------------------------------------*/
void swap_gen.accrued_period(	out number  period_leg1,
								out number  period_leg2,
								out integer n_days_leg1,
								out integer n_days_leg2,
								error_info option(nullable) error ) 
{	
	try{
		//SWAP_ENTRY_FUNC();
		instr_error_type t;
   		string 			s;	
		i().__swap_accrued_period(period_leg1,period_leg2,n_days_leg1,n_days_leg2,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_gen.accrued_period");
		if(e) {
			period_leg1 = period_leg2 = null<number>;
			n_days_leg1 = n_days_leg2 = err_int();
		}
		return ;					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.accrued_period");
		period_leg1 = period_leg2 = null<number>;
		n_days_leg1 = n_days_leg2 = err_int();
		return ;
	}
}
/*-----------------------------------------------------------------------
  accrued_period	LEGACY returns leg1 data  EXT SWAP: ok
  ----------------------------------------------------------------------*/
number  swap_gen.accrued_period(error_info option(nullable) error ) 
{
	try {
		error_info ee = new error_info(true,true);
		number period_leg1,period_leg2;
		integer n_days_leg1,n_days_leg2;
		this.accrued_period(period_leg1,period_leg2,n_days_leg1,n_days_leg2,ee);
		return period_leg1;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.accrued_period");	
		return null<number>;
	}
}
/*-----------------------------------------------------------------------
  accrued_period	LEGACY returns leg1 data  EXT SWAP: ok
  ----------------------------------------------------------------------*/
number  swap_gen.accrued_period(out integer n_days_leg1,
								error_info option(nullable) error )
{
	try {
		error_info ee = new error_info(true,true);
		number period_leg1,period_leg2;
		integer n_days_leg2;
		this.accrued_period(period_leg1,period_leg2,n_days_leg1,n_days_leg2,ee);
		return period_leg1;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.accrued_period");
		n_days_leg1 = err_int();
		return null<number>;
	}
}
/*-----------------------------------------------------------------------
  accrued_days	LEGACY returns leg1 data  EXT SWAP: ok
  ----------------------------------------------------------------------*/
integer  swap_gen.accrued_days(error_info option(nullable) error )  
{
	try {
		error_info ee = new error_info(true,true);
		number period_leg1,period_leg2;
		integer n_days_leg1,n_days_leg2;
		this.accrued_period(period_leg1,period_leg2,n_days_leg1,n_days_leg2,ee);
		return n_days_leg1;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.accrued_days");
		return err_int();
	}
}
/*-----------------------------------------------------------------------
  accrued_chg  EXT SWAP: ok
  ----------------------------------------------------------------------*/
number swap_gen.accrued_chg(integer 	bus_days,
							out	number 	ai_chg_leg1,
							out	number 	ai_chg_leg2,
							out	number 	cpn_cashflow_leg1,
							out	number 	cpn_cashflow_leg2,
							out date 	settle,
							out date 	settle_next,	
							error_info option(nullable) error ) 
{	
	try{
		//SWAP_ENTRY_FUNC();
		instr_error_type t;
   		string 			s;	
		number c = i().__swap_accrued_chg(bus_days,ai_chg_leg1,ai_chg_leg2,cpn_cashflow_leg1,cpn_cashflow_leg2,settle, settle_next,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_gen.accrued_chg");
		if(e) {
			ai_chg_leg1 = ai_chg_leg2 = cpn_cashflow_leg1 = cpn_cashflow_leg2 = null<number>;
			settle = settle_next = null<date>;
		}
		return c;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.accrued_chg");
		ai_chg_leg1 = ai_chg_leg2 = cpn_cashflow_leg1 = cpn_cashflow_leg2 = null<number>;
		settle = settle_next = null<date>;
		return null<number>;
	}
}
/*-----------------------------------------------------------------------
  accrued_chg  LEGACY
  ----------------------------------------------------------------------*/
number  swap_gen.accrued_chg(	integer 	bus_days,
								out	number 	cpn_cashflow,
								out date 	settle,
								out date  	settle_next,	
								logical 	in_pcnt,								
								error_info option(nullable) error ) 
{	
	try {
		QL_FAIL_COND(in_pcnt,"in_pcnt = true not applicable", this, true);	

		error_info ee = new error_info(true,true);
		number cpn_cashflow_leg2,ai_chg_leg1,ai_chg_leg2;
		number c = this.accrued_chg(bus_days,ai_chg_leg1,ai_chg_leg2,
									cpn_cashflow,cpn_cashflow_leg2,
									settle,settle_next,ee);		
		return c;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.accrued_chg");
		cpn_cashflow = null<number>;
		settle = settle_next = null<date>;
		return null<number>;
	}
}

/*-----------------------------------------------------------------------
  present_value override prot
  ----------------------------------------------------------------------*/
number  swap_gen.present_value(	number option(nullable) 	notional,
								logical 					trade_date_pv,
								disc_func option(nullable) 	disc_func_disc,
								error_info option(nullable) error )
{	
	try{	
		notional = conv_null_number_com(notional) ;		
		QL_FAIL_COND(!null(disc_func_disc),"input of disc_func (for trade_date_pv calculation) not supported for swaps", this, true);
		
		QL_FAIL_COND(!null(notional) && is_ccy_swap(),"input of notional not applicable for currency swaps", this, true);//use a version with 2 notionals or set notional to null	

		number pv_fix_leg,pv_flt_leg;
		return present_value(	null<disc_func>,null<disc_func>, pv_fix_leg, pv_flt_leg,
								notional,trade_date_pv,error);					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.present_value");
		return null<number>;
	}
}

/*-----------------------------------------------------------------------
  present_value
  ----------------------------------------------------------------------*/
/*number swap_gen.present_value(	disc_func option(nullable)	disc_func_fix_leg,
									disc_func option(nullable) 	disc_func_flt_leg,
									out number  pv_fix_leg,
									out number  pv_flt_leg,
									number option(nullable) 	notional,
									logical option(nullable) 	trade_date_pv,																								
									error_info option(nullable) error )
{
	//SWAP_ENTRY_FUNC();
	return swap_gen.present_value(disc_func_fix_leg,disc_func_flt_leg,pv_fix_leg,pv_flt_leg,notional,trade_date_pv,error);
}*/

/*-----------------------------------------------------------------------
  present_value
  ----------------------------------------------------------------------*/
/*number swap_gen.present_value(	disc_func option(nullable)	disc_func_fix_leg,
									disc_func option(nullable) 	disc_func_flt_leg,
									out number  pv_fix_leg,
									out number  pv_flt_leg,
									date option(nullable) 		pv_date,
									date option(nullable) 		settle_date,
									logical  					incl_issue_cf,
									logical  					incl_mat_cf,	
									error_info option(nullable) error )
{
	//SWAP_ENTRY_FUNC();
	return swap_gen.present_value(disc_func_fix_leg,disc_func_flt_leg,pv_fix_leg,pv_flt_leg,pv_date,
										 settle_date ,incl_issue_cf,incl_mat_cf,error );
}*/


/*number swap_gen.present_value(	out number  pv_fix_leg,
									out number  pv_flt_leg,
									logical option(nullable) 	trade_date_pv,	
									error_info option(nullable) error )
{
	//SWAP_ENTRY_FUNC();
	return swap_gen.present_value(pv_fix_leg,pv_flt_leg,trade_date_pv ,error );
}*/

/*-----------------------------------------------------------------------
  present_value_fee
  ----------------------------------------------------------------------*/
/*number swap_gen.present_value_fee(	disc_func option(nullable)	disc_func_fix_leg,
									disc_func option(nullable) 	disc_func_flt_leg,
									out number  pv_fee_fix_leg,
									out number  pv_fee_flt_leg,
									date option(nullable) 		pv_date,
									date option(nullable) 		settle_date,
									logical  					incl_issue_cf,
									logical  					incl_mat_cf,	
									error_info option(nullable) error )
{
	//SWAP_ENTRY_FUNC();
	return instrument.swap_present_value_fee(disc_func_fix_leg,disc_func_flt_leg,pv_fee_fix_leg,pv_fee_flt_leg,
											 pv_date, settle_date ,incl_issue_cf,incl_mat_cf,error );
}*/

/*-----------------------------------------------------------------------
  present_value  override prot
  ----------------------------------------------------------------------*/
number  swap_gen.present_value(	disc_func					disc_func,
								number option(nullable) 	notional,
								logical 					trade_date_pv,
								disc_func option(nullable) 	disc_func_disc,
								error_info option(nullable) error ) 
{	
	try{	
		notional= conv_null_number_com(notional) ;
		QL_FAIL_COND(!null(disc_func_disc),"input of disc_func (for trade_date_pv calculation) not supported for swaps",this,true);
		
		QL_FAIL_COND(is_ccy_swap(),"inapplicable function call for cross currency swaps",this,true);//use a version with 2 disc_funcs	

		number pv_fix_leg,pv_flt_leg;
		return present_value(	disc_func,disc_func, pv_fix_leg, pv_flt_leg,
								notional,trade_date_pv,error);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.present_value");
		return null<number>;
	}
}
/*-----------------------------------------------------------------------
  dirty_price_to_yield  override    for backward compat
  ----------------------------------------------------------------------*/
number  swap_gen.dirty_price_to_yield(	number dirty_price_pcnt,
										logical disable_rounding ,									
										error_info option(nullable) error ) 
{
	try {

		QL_FAIL("inapplicable function call for swaps", this,true);
		
		//QL_FAIL_COND(is_ext_swap(),"inapplicable function call for non-db swaps", this,true);
		//return instrument.dirty_price_to_yield(dirty_price_pcnt,disable_rounding,error);
							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.dirty_price_to_yield");
		return null<number>;
	}
}
/*-----------------------------------------------------------------------
  clean_price_to_yield  override    for backward compat
  ----------------------------------------------------------------------*/
number  swap_gen.clean_price_to_yield(number clean_price_pcnt,
										logical disable_rounding ,									
										error_info option(nullable) error )  
{
	try {
		QL_FAIL("inapplicable function call for swaps", this,true);
		//QL_FAIL_COND(is_ext_swap(),"inapplicable function call for non-db swaps", this,true);
		//return instrument.clean_price_to_yield(clean_price_pcnt,disable_rounding,error);
							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.clean_price_to_yield");
		return null<number>;
	}
}
/*-----------------------------------------------------------------------
  price_to_yield  override    for backward compat
  ----------------------------------------------------------------------*/
number  swap_gen.price_to_yield(	number price,
									..quote_style qs,									
									error_info option(nullable) error )  
{
	try {
		QL_FAIL("inapplicable function call for swaps", this,true);
		
		//QL_FAIL_COND(is_ext_swap(),"inapplicable function call for non-db swaps", this,true);		
		//return instrument.price_to_yield(price,qs,error);
							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.price_to_yield");
		return null<number>;
	}
}
/*-----------------------------------------------------------------------
  implied_par_disc_func_fix_leg		EXT SWAP: ok	prot
  ----------------------------------------------------------------------*/
disc_func swap_gen.implied_par_disc_func_fix_leg(error_info option(nullable) error )
{
	//try{
		//SWAP_ENTRY_FUNC();
		error_info ee = new error_info(true,false);

		QL_REQUIRE(leg1_is_fix(),"swap type not applicable",this,true);
	
		vector(date) dates;
		vector(number) amounts;
		logical ok = this.cash_flows_bootstrap(dates,amounts,ee);
		QL_FAIL_COND(!ok,"error creating bootstrap cashflows (for implied par disc_func)", this, true);
		
		CORE_INT.curve_min c = new CORE_INT.curve_min(this.trade_date(),dates,amounts,false);
		disc_func df = CORE_INT.bootstrap_min(c);
		QL_FAIL_COND(null(df),"error creating implied par disc_func", this, true);	
		
		return df;						
	//}
	//catch {
		//CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.implied_par_disc_func_fix_leg");
		//return null<disc_func>;
	//}
}
/*-----------------------------------------------------------------------
   par_rate_fix_leg
  ----------------------------------------------------------------------*/
number  swap_gen.par_rate_fix_leg(	disc_func		disc_func,
									error_info option(nullable) error)
{
	try{
		//error_info ee = new error_info(true,false);

		QL_REQUIRE(leg1_is_fix(),"swap type not applicable",this,true);
		
		instr_error_type t;
   		string 			s;	
		number c = i().__df_to_par_coupon(disc_func,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_gen.par_rate_fix_leg");
		return e ? null<number>: c;	
		
		
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.par_rate_fix_leg");
		return null<number>;
	}
}
/*-----------------------------------------------------------------------
  imp_rate_fix_leg    EXT SWAP: ok
  ----------------------------------------------------------------------*/
number  swap_gen.imp_rate_fix_leg(	number 							swap_pv,							
									logical option(nullable) 		trade_date_pv,
									error_info option(nullable) 	error ) 
{	
	try{
		//SWAP_ENTRY_FUNC();
		//error_info ee 		= new error_info(true,true);
	
		QL_REQUIRE(leg1_is_fix(),"swap type not applicable",this,true);
	
		instr_error_type t;
   		string 			s;	
		number c = i().__swap_imp_fix_rate(swap_pv,trade_date_pv,true,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_gen.imp_rate_fix_leg");	
		return e ? null<number>: c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.imp_rate_fix_leg");
		return null<number>;
	}
}
/*-----------------------------------------------------------------------
  fix_bond_equiv
  ----------------------------------------------------------------------*/
void  swap_gen.fix_bond_equiv(	out vector(date) pmt_date,
								out vector(number) cf_tot,
								out number notional)
{
	error_info ee 		= new error_info(true,true);
	
	QL_REQUIRE(leg1_is_fix(),"swap type not applicable",this,true);
	
	logical is_amort1, is_amort2;
	this.is_amortizing(is_amort1, is_amort2,ee);
	QL_REQUIRE(!is_amort1,"fix_bond_equiv does not supoort amortizing swaps (work in progress)",this,true);
	
	date settle 		= this.settle_date(ee);
	
	number not2;
	this.notional(notional,not2,ee);

	vector(ql_swap_leg) l = legs(false,ee);
	swap_fix_leg_data fix_leg_data = new swap_fix_leg_data(l[0]);
		
	vector(number) 	cpn_r, cf_ir, cf_prin, pv_cf_ir, pv_cf_prin, pv_cf_tot;
	
	date cut_off = settle;	
	fix_leg_data.pmtdates_cf(pmt_date, cpn_r, cf_ir, cf_prin, cf_tot, pv_cf_ir, pv_cf_prin, pv_cf_tot, cut_off);
	if(this.swap_payleg1(ee)){
		cf_tot *= -1;	
	}
	
	ql_fix_leg fixleg 	= this.fix_leg1(false,ee);
	notional_exchg_style ne = fixleg.fix_def().notional_exchange();
	if(ne == notional_exchg_style.NE_NONE || ne == notional_exchg_style.NE_START){
		cf_tot[v_size(cf_tot)-1] += notional;
	}
}
/*-----------------------------------------------------------------------
  fix_yield_ext_swap
  ----------------------------------------------------------------------*/
void  swap_gen.fix_yield_ext_swap(	disc_func df,
									out number y,
									out number pv,
									out rate_type ytm_type,
									out vector(date) pmt_date,
									out vector(number) 	cf_tot )
{
	error_info ee 		= new error_info(true,true);

	QL_REQUIRE(leg1_is_fix(),"swap type not applicable",this,true);
	
	date trade 			= this.trade_date(ee);
	date settle 		= this.settle_date(ee);
	
	day_count_method dc,dc2;
	this.dc_method(dc,dc2,ee);
	
	number yld_guess = this.coupon(ee);
	
	number not;
	fix_bond_equiv(	pmt_date,cf_tot,not );
	
	//disc_func df = this.disc_func_fix_leg(ee);
	//QL_FAIL_COND(null(df),"discount function for fixed leg not initialized (required for non-db swaps)", this,true);

	logical periodic_disc = true;
	ytm_type = rate_type.RT_SIMPLE;

	y = gen_ytm(trade,settle, pmt_date, cf_tot, df, not, yld_guess, ytm_type, dc, pv,periodic_disc,ytm_type) ;
	
	return ;
}

/*-----------------------------------------------------------------------
  swap_fixflt: yield,  for backward compat reasons 
  1. calc pv on fixed leg with current cpn
  2. solve for a constant yield (discount rate) 
  ----------------------------------------------------------------------*/
number  swap_gen.yield(	disc_func		disc_func,
						logical 		disable_rounding ,								
						error_info option(nullable) error ) 
{ 
	try {
		//SWAP_ENTRY_FUNC();

		if(!is_ext_swap())
			return instrument.yield(disc_func,disable_rounding,error);

		vector(date) pmt_date;
		vector(number) 	cf_tot;
		rate_type  ytm_type;
		number y, pv;
		fix_yield_ext_swap(disc_func, y, pv, ytm_type, pmt_date,cf_tot );

		return y;
		/*
		
		error_info ee 		= new error_info(true,true);
		
		instrument_type t = this.swap_type(ee);
	
		switch(t){
		case instrument_type.IT_SWAP_FIXINFLCI_FLOAT:
		case instrument_type.IT_SWAP_FIXINFLCI_OIS:
		case instrument_type.IT_SWAP_FIX_FIX:
		case instrument_type.IT_SWAP_FIX_FLOAT:
		case instrument_type.IT_SWAP_FIX_OIS:
		case instrument_type.IT_SWAP_FIX_ZERO:
			break;
		default:
			QL_FAIL("swap type not applicable");
		}
	
		
		date trade 			= this.trade_date(ee);
		date settle 		= this.settle_date(ee);
		
		day_count_method dc,dc2;
		this.dc_method(dc,dc2,ee);
		
		number yld_guess = this.coupon(ee);

		vector(date) pmt_date;
		vector(number) 	cf_tot; 
		number not;
		fix_bond_equiv(	pmt_date,cf_tot,not );
		
		logical periodic_disc = true;
		rate_type  ytm_type = rate_type.RT_SIMPLE;
		number pv;
		number y = gen_ytm(trade,settle, pmt_date, cf_tot, disc_func, not, yld_guess, ytm_type, dc, pv,periodic_disc,ytm_type) ;
		return y;*/
							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.yield");
		return null<number>;
	}
}

/*-----------------------------------------------------------------------
  dirty_price  override    for backward compat
  ----------------------------------------------------------------------*/
number  swap_gen.dirty_price(number option(nullable)		yield,
								logical 					disable_rounding,
								logical 					in_pcnt,									
								error_info option(nullable) error ) 
{ 
	try {

		if(!null(yield))
		   QL_FAIL("inapplicable function call for swaps (when yield is not null)", this,true);
		//QL_FAIL_COND(ext_swap_,"inapplicable function call for non-db swaps", this,true);
		//SWAP_ENTRY_FUNC();
		if(!is_ext_swap())
			return instrument.dirty_price(null<number>,disable_rounding,in_pcnt,error);
		
		if(!null(yield))
		   QL_FAIL("inapplicable function call for non-db swaps", this,true);

		return this.dirty_price(disable_rounding,in_pcnt,error );
							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.dirty_price");
		return null<number>;
	}
}

/*-----------------------------------------------------------------------
  dirty_price  override    for backward compat
  ----------------------------------------------------------------------*/
number  swap_gen.dirty_price(	logical 	disable_rounding,
								logical 	in_pcnt,									
								error_info option(nullable) error ) 
{ 
	try {
		//QL_FAIL_COND(ext_swap_,"inapplicable function call for non-db swaps", this,true);
		//SWAP_ENTRY_FUNC();
		//QL_FAIL_COND(y_ne_cpn_err(),"unexpected error", this,true);
		if(!is_ext_swap())
			return instrument.dirty_price(disable_rounding,in_pcnt,error);

		error_info ee = new error_info(true,true);

		number  notional_leg1,  notional_leg2;
		this.notional(notional_leg1, notional_leg2, ee) ;
		
		number pv_1,pv_2;
		number pv = this.present_value(pv_1,pv_2,false,ee);
		if(in_pcnt)
			pv = pv/notional_leg1*100;

		return pv;
		
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.dirty_price");
		return null<number>;
	}
}
/*-----------------------------------------------------------------------
  dirty_price  override    for backward compat
  ----------------------------------------------------------------------*/
number  swap_gen.dirty_price(	disc_func		disc_func,
								logical 		disable_rounding,								
								logical 		in_pcnt,									
								error_info option(nullable) error ) 
{ 
	try {
		QL_FAIL_COND(is_ext_swap(),"inapplicable function call for non-db swaps", this,true);
		//SWAP_ENTRY_FUNC();
		return instrument.dirty_price(disc_func,disable_rounding,in_pcnt,error);
							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.dirty_price");
		return null<number>;
	}
}

/*-----------------------------------------------------------------------
  clean_price  override    for backward compat
  ----------------------------------------------------------------------*/
number  swap_gen.clean_price(	number	option(nullable)	yield,
								logical 					disable_rounding,
								logical 					in_pcnt,									
								error_info option(nullable) error ) 
{ 
	try {
		//QL_FAIL_COND(ext_swap_,"inapplicable function call for non-db swaps", this,true);
		//SWAP_ENTRY_FUNC();
		if(!null(yield))
		   QL_FAIL("inapplicable function call for swaps (when yield is not null)", this,true);
		
		if(!is_ext_swap())
			return instrument.clean_price(null<number>,disable_rounding,in_pcnt,error);

		return clean_price(disable_rounding, in_pcnt,  error );
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.clean_price");
		return null<number>;
	}
}
/*-----------------------------------------------------------------------
  clean_price  override    for backward compat
  ----------------------------------------------------------------------*/
number  swap_gen.clean_price(	logical 					disable_rounding,
								logical 					in_pcnt,									
								error_info option(nullable) error ) 
{ 
	try {
		//QL_FAIL_COND(ext_swap_,"inapplicable function call for non-db swaps", this,true);
		//SWAP_ENTRY_FUNC();
		if(!is_ext_swap())	
			return instrument.clean_price(disable_rounding,in_pcnt,error);

		error_info ee = new error_info(true,true);

		number  notional_leg1,  notional_leg2;
		this.notional(notional_leg1, notional_leg2, ee) ;

		number  ai_leg1,  ai_leg2;
		number ai = this.accrued(in_pcnt, ai_leg1,  ai_leg2, ee) ;
		
		number pv_1,pv_2;
		number pv = this.present_value(pv_1,pv_2,false,ee);
		if(in_pcnt)
			pv = pv/notional_leg1*100;

		return pv-ai;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.clean_price");
		return null<number>;
	}
}
/*-----------------------------------------------------------------------
  clean_price  override    for backward compat
  ----------------------------------------------------------------------*/
number  swap_gen.clean_price(	disc_func		disc_func,
								logical 		disable_rounding,								
								logical 		in_pcnt,									
								error_info option(nullable) error )  
{ 
	try {
		QL_FAIL_COND(is_ext_swap(),"inapplicable function call for non-db swaps", this,true);
		//SWAP_ENTRY_FUNC();
		return instrument.clean_price(disc_func,disable_rounding,in_pcnt,error);
							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.clean_price");
		return null<number>;
	}
}

/*-----------------------------------------------------------------------
  mac_dur      <public>
  ----------------------------------------------------------------------*/
number  swap_gen.mac_dur(error_info option(nullable) error) 
{	
	try{
		if(!is_ext_swap())
			return instrument.mac_dur(error);

		QL_FAIL("work in progress for non-db swaps",this,true);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.mac_dur");
		return null<number>;
	}
}

/*-----------------------------------------------------------------------
  mod_dur      <public>
  ----------------------------------------------------------------------*/
number  swap_gen.mod_dur(error_info option(nullable) error) 
{	
	try{
		if(!is_ext_swap())
			return instrument.mod_dur(error);

		QL_FAIL("work in progress for non-db swaps",this,true);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.mod_dur");
		return null<number>;
	}
}
/*-----------------------------------------------------------------------
  dol_dur      <public>
  ----------------------------------------------------------------------*/
number  swap_gen.dol_dur(error_info option(nullable) error) 
{	
	try{
		if(!is_ext_swap())
			return instrument.dol_dur(error);

		QL_FAIL("work in progress for non-db swaps",this,true);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.dol_dur");
		return null<number>;
	}
}
/*-----------------------------------------------------------------------
  convexity      <public>
  ----------------------------------------------------------------------*/
number  swap_gen.convexity(error_info option(nullable) error) 
{	
	try{
		if(!is_ext_swap())
			return instrument.convexity(error);

		QL_FAIL("work in progress for non-db swaps",this,true);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.convexity");
		return null<number>;
	}
}
/*-----------------------------------------------------------------------
  dol_convexity      <public>
  ----------------------------------------------------------------------*/
number  swap_gen.dol_convexity(error_info option(nullable) error) 
{	
	try{
		if(!is_ext_swap())
			return instrument.dol_convexity(error);

		QL_FAIL("work in progress for non-db swaps",this,true);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.dol_convexity");
		return null<number>;
	}
}
/*-----------------------------------------------------------------------
  sensitivity      <public>
  ----------------------------------------------------------------------*/
number  swap_gen.sensitivity(error_info option(nullable) error) 
{	
	try{
		//if(!is_ext_swap())
			//return instrument.sensitivity(error);

		QL_FAIL("sensitivity is not applicable for swaps",this,true);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.sensitivity");
		return null<number>;
	}
}

/*-----------------------------------------------------------------------
  flt_yield_ext_swap
  ----------------------------------------------------------------------*/
void  swap_gen.flt_yield_ext_swap(	logical leg2,
									disc_func df,
									out number y,
									out number pv,
									out rate_type ytm_type,
									out vector(date) pmt_date,
									out vector(number) 	cf_tot )
{
	error_info ee 		= new error_info(true,true);

	if(leg2) 
		QL_REQUIRE(leg2_is_flt(),"swap type not applicable",this,true);
	else
		QL_REQUIRE(leg1_is_flt(),"swap type not applicable",this,true);
	
	number not;
	flt_bond_equiv(	leg2,pmt_date,cf_tot,not );

	if(v_size(pmt_date) == 0) {
		y = null<number>;
		pv = null<number>;
		return;
	}

	date trade 			= this.trade_date(ee);
	date settle 		= this.settle_date(ee);
	
	day_count_method dc1,dc2;
	this.dc_method(dc2,dc1,ee);
	day_count_method dc = leg2 ? dc2:dc1;

	number cpn1,cpn2;
	this.coupon(cpn1,cpn2,ee);
	number yld_guess = leg2 ? cpn2 : cpn1;
	ytm_type = rate_type.RT_SIMPLE;
	
	//disc_func df = this.disc_func_flt_leg(ee);
	//QL_FAIL_COND(null(df),"discount function for float leg not initialized (required for non-db swaps)", this,true);

	y = gen_ytm(trade,settle, pmt_date, cf_tot, df, not, yld_guess, ytm_type, dc, pv,true,ytm_type) ;
	
	return;
}

/*-----------------------------------------------------------------------
  flt_bond_equiv
  ----------------------------------------------------------------------*/
void  swap_gen.flt_bond_equiv(	logical leg2,
								out vector(date) pmt_date,
								out vector(number) cf_tot,
								out number notional)
{
	error_info ee 		= new error_info(true,true);

	
	if(leg2) 
		QL_REQUIRE(leg2_is_flt(),"swap type not applicable",this,true);
	else
		QL_REQUIRE(leg1_is_flt(),"swap type not applicable",this,true);
	
	logical is_amort1, is_amort2;
	this.is_amortizing(is_amort1, is_amort2,ee);
	logical is_amort_flt = leg2 ? is_amort2:is_amort1;
	QL_REQUIRE(!is_amort_flt,"flt_bond_equiv does not supoort amortizing swaps (work in progress)",this,true);
	
	date settle 		= this.settle_date(ee);
	
	number not1,not2;
	this.notional(not1,not2,ee);
	number _notional = leg2 ? not2: not1;
	/*swap_flt_leg_data	leg_data;
	this.data(leg_data,ee);
	
	vector(number) 	cpn_r, cf_ir, cf_prin, pv_cf_ir, pv_cf_prin, pv_cf_tot;
	
	date cut_off = settle;	
	leg_data.pmtdates_cf(pmt_date, cpn_r, cf_ir, cf_prin, cf_tot, pv_cf_ir, pv_cf_prin, pv_cf_tot, cut_off);
	if(!this.pay_fix(ee)){
		cf_tot *= -1;
	
	}*/

	date reset_date;
	logical is_fixed;
	//this.current_fixing_flt_leg(reset_date,is_fixed,ee);

	/*vector(ql_float_leg) l = swap_gen.swap_float_leg(false,ee);

	ql_float_leg flt;
	if(leg2 )	
		flt = leg1_is_flt() ? l[1]:l[0];
	else
		flt = l[0];*/

	ql_float_leg flt;
	if(leg2)
		QL_REQUIRE(get_float_leg2(flt),"invalid function call");
	else
		QL_REQUIRE(get_float_leg1(flt),"invalid function call");
	
	number fix;
	fix = flt.current_fixing_rate(reset_date,is_fixed);


	number cpn1,cpn2;
	this.coupon(cpn1,cpn2,ee);
	number cpn = leg2 ? cpn2 : cpn1;
	
	//number cpn = this.current_coupon_flt_leg(ee);

	date nc1,nc2;
	this.next_cpn_date(nc1,nc2,ee);
	date next = leg2 ? nc2: nc1;
	//vector(logical) is_fixed = leg_data.is_fixed(settle, cut_off_type.PMT_DATE_IR_FWD) ;

	/*ql_float_leg fltleg 	= this.float_leg(false,ee);
	notional_exchg_style ne = fltleg.float_def().notional_exchange();
	if(ne == notional_exchg_style.NE_NONE || ne == notional_exchg_style.NE_START){
		cf_tot[v_size(cf_tot)-1] += notional;
	}*/
	if(is_fixed) {
		resize(pmt_date,2);
		resize(cf_tot,2);
		pmt_date[0] = settle;
		pmt_date[1] = next;
		cf_tot[0] = 0;
		cf_tot[1] = _notional + cpn*_notional;
	}
	else {
		resize(pmt_date,0);
		resize(cf_tot,0);
	}
	
}

/*-----------------------------------------------------------------------
  solver   EXT SWAP: ok
  ----------------------------------------------------------------------*/
number swap_gen.solver(	number 				swap_pv,
						swap_solver_code 	solver_code,
						logical option(nullable) trade_date_pv,
						error_info option(nullable) error )
{
	try{	
		instr_error_type t;
   		string 			s;	
		number  c = i().__swap_solver(swap_pv, solver_code,trade_date_pv ,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_gen.swap_solver");
		return e ? null<number>: c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.swap_solver");
		return null<number  >;
	}
}


/*-----------------------------------------------------------------------
  pv01	EXT SWAP: ok  - always returns a positive number regardless of pay/receive and sign of notional
  Note: not a "true" measure of risk, does not take into account if the swap has a pv <> 0
   PV01 refers to present value of 1 basis point and it's the discounted value of the cashflows
  for a rate of 0.01% for all periods of a particular instrument, ie, the npv of the fixed leg with a rate of 0.01%

if sign is needed:
 receive fix --> negative sign
  ----------------------------------------------------------------------*/
number  swap_gen.pv01_fix_leg(	number option(nullable) notional,
								number option(nullable) delta,
								//logical option(nullable) trade_date_pv,
								disc_func option(nullable) df,
								error_info option(nullable) error ) 
{	
	try{
		error_info ee 		= new error_info(true,true);
		
		QL_REQUIRE(leg1_is_fix(),"swap type not applicable",this,true);
	
		instr_error_type t;
   		string 			s;	
		
		disc_func df_orig 	= this.disc_func_leg1(ee);
		logical upd 		= false;
		
		if(!null(df)){
			this.swap_add_disc_func_leg1(df);
			upd = true;
		}
		else if(null(df_orig)) {	
			disc_func _df = this.implied_par_disc_func_fix_leg(ee);
			this.swap_add_disc_func_leg1(_df);
			upd = true;
		}
		
		number c = i().__swap_pvbp_fix_leg(notional,delta, true,t, s);
		if(!null(c))
			c = abs(c);
		
		if(upd && !null(df_orig)){			
			this.swap_add_disc_func_leg1(df_orig);
		}
		
		logical e = CORE_INT.add_error_info(error,t,s, "swap_gen.pv01");	
		return e ? null<number>: c;
		
	
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.pv01");
		return null<number>;
	}
}
/*-----------------------------------------------------------------------
  leg1_is_zero
  ----------------------------------------------------------------------*/
logical swap_gen.leg1_is_zero()
{
	error_info ee = new error_info(true,true);
		
	instrument_type ty = this.swap_type(ee);
	
	switch(ty){
	case instrument_type.IT_SWAP_ZERO_FLOAT:
	case instrument_type.IT_SWAP_ZERO_OIS:
	case instrument_type.IT_SWAP_ZERO_ZERO:
	case instrument_type.IT_SWAP_ZERO_YYINFL:
	case instrument_type.IT_SWAP_ZERO_ZEROINFL:
		return true;
	default:
		return false;
	}
}
/*-----------------------------------------------------------------------
  leg2_is_zero
  ----------------------------------------------------------------------*/
logical swap_gen.leg2_is_zero()
{
	error_info ee = new error_info(true,true);
		
	instrument_type ty = this.swap_type(ee);
	
	switch(ty){
	case instrument_type.IT_SWAP_ZERO_ZERO:
		return true;
	default:
		return false;
	}
}
/*-----------------------------------------------------------------------
  leg1_is_fix
  ----------------------------------------------------------------------*/
logical swap_gen.leg1_is_fix()
{
	error_info ee = new error_info(true,true);
		
	instrument_type ty = this.swap_type(ee);
	
	switch(ty){
	case instrument_type.IT_SWAP_FIXINFLCI_FLOAT:
	case instrument_type.IT_SWAP_FIXINFLCI_OIS:
	case instrument_type.IT_SWAP_FIX_FIX:
	case instrument_type.IT_SWAP_FIX_FLOAT:
	case instrument_type.IT_SWAP_FIX_OIS:
	case instrument_type.IT_SWAP_FIX_ZERO:
	case instrument_type.IT_SWAP_FIX_YYINFL:
		return true;
	default:
		return false;
	}
}
/*-----------------------------------------------------------------------
  leg2_is_fix
  ----------------------------------------------------------------------*/
logical swap_gen.leg2_is_fix()
{
	error_info ee = new error_info(true,true);
		
	instrument_type ty = this.swap_type(ee);
	
	switch(ty){
	case instrument_type.IT_SWAP_FIX_FIX:
		return true;
	default:
		return false;
	}
}
/*-----------------------------------------------------------------------
  leg2_is_flt
  ----------------------------------------------------------------------*/
logical swap_gen.leg2_is_flt()
{
	error_info ee = new error_info(true,true);
	instrument_type t = this.swap_type(ee);
	
	switch(t){
	case instrument_type.IT_SWAP_FIXINFLCI_FLOAT:	
	case instrument_type.IT_SWAP_FIX_FLOAT:
	case instrument_type.IT_SWAP_FLOAT_FLOAT:
	case instrument_type.IT_SWAP_ZERO_FLOAT:
		return true;
		
	default:
		return false;
	}
}
/*-----------------------------------------------------------------------
  leg1_is_flt
  ----------------------------------------------------------------------*/
logical swap_gen.leg1_is_flt()
{
	error_info ee = new error_info(true,true);
	instrument_type t = this.swap_type(ee);
	
	switch(t){
	case instrument_type.IT_SWAP_FLOAT_FLOAT:
	case instrument_type.IT_SWAP_FLOAT_OIS:
		return true;
	default:
		return false;
	}
}
/*-----------------------------------------------------------------------
  leg2_is_ois
  ----------------------------------------------------------------------*/
logical swap_gen.leg2_is_ois()
{
	error_info ee = new error_info(true,true);
	instrument_type t = this.swap_type(ee);
	
	switch(t){
	case instrument_type.IT_SWAP_FIXINFLCI_OIS:	
	case instrument_type.IT_SWAP_FIX_OIS:
	case instrument_type.IT_SWAP_FLOAT_OIS:
	case instrument_type.IT_SWAP_ZERO_OIS:
	case instrument_type.IT_SWAP_OIS_OIS:
		return true;
	default:
		return false;
	}
}
/*-----------------------------------------------------------------------
  leg1_is_ois
  ----------------------------------------------------------------------*/
logical swap_gen.leg1_is_ois()
{
	error_info ee = new error_info(true,true);
	instrument_type t = this.swap_type(ee);
	
	switch(t){
	case instrument_type.IT_SWAP_OIS_OIS:
	case instrument_type.IT_SWAP_OIS_YYINFL:
		return true;
	default:
		return false;
	}
}
/*-----------------------------------------------------------------------
  pvdiff_fix_rate	EXT SWAP: ok
  compared to pv01 this is a plain diff without scaling and handling of the sign of the result
  ----------------------------------------------------------------------*/
number  swap_gen.pvdiff_fix_rate(	number 	delta_fix_cpn_rate,									
									disc_func option(nullable) df,
									error_info option(nullable) error ) 
{	
	try{	
		error_info ee = new error_info(true,true);
		
		QL_REQUIRE(leg1_is_fix(),"swap type not applicable",this,true);
		
		disc_func df_orig = this.disc_func_leg1(ee);

		logical upd = false;
		if(!null(df)){
			this.swap_add_disc_func_leg1(df);
			upd = true;
		}
		else if(null(df_orig)) {	
			disc_func _df = this.implied_par_disc_func_fix_leg(ee);
			this.swap_add_disc_func_leg1(_df);
			upd = true;
		}

		instr_error_type t;
   		string 			s;	
		number c = i().__swap_pv_diff_fix_leg(delta_fix_cpn_rate, true,t, s);

		if(upd)
			this.swap_add_disc_func_leg1(df_orig);

		logical e = CORE_INT.add_error_info(error,t,s, "swap_gen.pvdiff_fix_rate");	
		return e ? null<number>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.pvdiff_fix_rate");
		return null<number>;
	}
}

/*-----------------------------------------------------------------------
  swap_type  EXT SWAP: ok
  ----------------------------------------------------------------------*/
instrument_type swap_gen.swap_type(error_info option(nullable) error) 
{	
	try{	
		instr_error_type t;
   		string 			s;	
		instrument_type c = i().__swap_type(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_gen.swap_type");
		return e ? null<instrument_type>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.swap_type");
		return null<instrument_type >;
	}
}
/*-----------------------------------------------------------------------
  swap_rfr_arr_type_leg1
  ----------------------------------------------------------------------*/
rfr_arrears_type swap_gen.swap_rfr_arr_type_leg1(error_info option(nullable) error) 
{	
	try{
		SWAP_ENTRY_FUNC();
		ql_ois_leg ol;
		QL_REQUIRE(get_ois_leg1(ol),"invalid function call");				
		return ol.rfr_arrears_type();						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.swap_rfr_arr_type_leg1");
		return null<rfr_arrears_type>;
	}
}

/*-----------------------------------------------------------------------
  swap_rfr_arr_days_leg1
  ----------------------------------------------------------------------*/
integer swap_gen.swap_rfr_arr_days_leg1(error_info option(nullable) error) 
{	
	try{
		SWAP_ENTRY_FUNC();
		ql_ois_leg ol;
		QL_REQUIRE(get_ois_leg1(ol),"invalid function call");
		number c = ol.rfr_arrears_days();
		return null(c) ? err_int() : integer(c);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.swap_rfr_arr_days_leg1");
		return err_int();
	}
}

/*-----------------------------------------------------------------------
  swap_rfr_arr_type_leg2
  ----------------------------------------------------------------------*/
rfr_arrears_type swap_gen.swap_rfr_arr_type_leg2(error_info option(nullable) error) 
{	
	try{
		SWAP_ENTRY_FUNC();
		ql_ois_leg ol;
		QL_REQUIRE(get_ois_leg2(ol),"invalid function call");				
		return ol.rfr_arrears_type();					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.swap_rfr_arr_type_leg2");
		return null<rfr_arrears_type>;
	}
}


/*-----------------------------------------------------------------------
  swap_rfr_arr_days_leg2
  ----------------------------------------------------------------------*/
integer swap_gen.swap_rfr_arr_days_leg2(error_info option(nullable) error) 
{	
	try{
		SWAP_ENTRY_FUNC();
		ql_ois_leg ol;
		QL_REQUIRE(get_ois_leg2(ol),"invalid function call");				
		number c = ol.rfr_arrears_days();
		return null(c) ? err_int() : integer(c);					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.swap_rfr_arr_days_leg2");
		return err_int();
	}
}
/*-----------------------------------------------------------------------
  swap_comp_avg_type_leg1
  ----------------------------------------------------------------------*/
flt_comp_avg_type swap_gen.swap_comp_avg_type_leg1(error_info option(nullable) error) 
{	
	try{
		SWAP_ENTRY_FUNC();
		if(leg1_is_ois()){
			ql_ois_leg ol;
			QL_REQUIRE(get_ois_leg1(ol),"invalid function call");				
			return ol.comp_avg_type();
		}

		ql_float_leg fl;
		QL_REQUIRE(get_float_leg1(fl),"invalid function call");				
		return fl.comp_avg_type();						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.swap_comp_avg_type_leg1");
		return null<flt_comp_avg_type>;
	}
}
/*-----------------------------------------------------------------------
  swap_comp_avg_type_leg2
  ----------------------------------------------------------------------*/
flt_comp_avg_type swap_gen.swap_comp_avg_type_leg2(error_info option(nullable) error) 
{	
	try{
		SWAP_ENTRY_FUNC();
		if(leg2_is_ois()){
			ql_ois_leg ol;
			QL_REQUIRE(get_ois_leg2(ol),"invalid function call");				
			return ol.comp_avg_type();
		}

		ql_float_leg fl;
		QL_REQUIRE(get_float_leg2(fl),"invalid function call");				
		return fl.comp_avg_type();						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.swap_comp_avg_type_leg2");
		return null<flt_comp_avg_type>;
	}
}

/*-----------------------------------------------------------------------
  swap_stub_fwd_style_leg1
  ----------------------------------------------------------------------*/
flt_stub_fwd_style swap_gen.swap_stub_fwd_style_leg1(error_info option(nullable) error)
{	
	try{
		SWAP_ENTRY_FUNC();		
		ql_float_leg fl;
		QL_REQUIRE(get_float_leg1(fl),"invalid function call");				
		return fl.stub_fwd_style();						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.swap_stub_fwd_style_leg1");
		return null<flt_stub_fwd_style>;
	}
}
/*-----------------------------------------------------------------------
  swap_stub_fwd_style_leg2
  ----------------------------------------------------------------------*/
flt_stub_fwd_style swap_gen.swap_stub_fwd_style_leg2(error_info option(nullable) error)
{	
	try{
		SWAP_ENTRY_FUNC();		
		ql_float_leg fl;
		QL_REQUIRE(get_float_leg2(fl),"invalid function call");				
		return fl.stub_fwd_style();						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.swap_stub_fwd_style_leg2");
		return null<flt_stub_fwd_style>;
	}
}
/*-----------------------------------------------------------------------
  swap_avg_method_leg1
  ----------------------------------------------------------------------*/
flt_sprd_comp_method swap_gen.swap_sprd_comp_method_leg1(error_info option(nullable) error)
{	
	try{
		SWAP_ENTRY_FUNC();
		if(leg1_is_ois()){
			ql_ois_leg ol;
			QL_REQUIRE(get_ois_leg1(ol),"invalid function call");				
			return ol.spread_comp_method();
		}

		ql_float_leg fl;
		QL_REQUIRE(get_float_leg1(fl),"invalid function call");				
		return fl.spread_comp_method();						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.swap_sprd_comp_method_leg1");
		return null<flt_sprd_comp_method>;
	}
}
/*-----------------------------------------------------------------------
  swap_sprd_comp_method_leg2
  ----------------------------------------------------------------------*/
flt_sprd_comp_method swap_gen.swap_sprd_comp_method_leg2(error_info option(nullable) error) 
{	
	try{
		SWAP_ENTRY_FUNC();
		if(leg2_is_ois()){
			ql_ois_leg ol;
			QL_REQUIRE(get_ois_leg2(ol),"invalid function call");				
			return ol.spread_comp_method();
		}

		ql_float_leg fl;
		QL_REQUIRE(get_float_leg2(fl),"invalid function call");				
		return fl.spread_comp_method();						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.swap_sprd_comp_method_leg2");
		return null<flt_sprd_comp_method>;
	}
}

/*-----------------------------------------------------------------------
  swap_avg_method_leg1
  ----------------------------------------------------------------------*/
flt_avg_method swap_gen.swap_avg_method_leg1(error_info option(nullable) error)
{	
	try{
		SWAP_ENTRY_FUNC();
		if(leg1_is_ois()){
			ql_ois_leg ol;
			QL_REQUIRE(get_ois_leg1(ol),"invalid function call");				
			return ol.avg_method();
		}

		ql_float_leg fl;
		QL_REQUIRE(get_float_leg1(fl),"invalid function call");				
		return fl.avg_method();						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.swap_avg_method_leg1");
		return null<flt_avg_method>;
	}
}
/*-----------------------------------------------------------------------
  swap_avg_method_leg2
  ----------------------------------------------------------------------*/
flt_avg_method swap_gen.swap_avg_method_leg2(error_info option(nullable) error)
{	
	try{
		SWAP_ENTRY_FUNC();
		if(leg2_is_ois()){
			ql_ois_leg ol;
			QL_REQUIRE(get_ois_leg2(ol),"invalid function call");				
			return ol.avg_method();
		}

		ql_float_leg fl;
		QL_REQUIRE(get_float_leg2(fl),"invalid function call");				
		return fl.avg_method();							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.swap_avg_method_leg2");
		return null<flt_avg_method>;
	}
}

/*-----------------------------------------------------------------------
  swap_pmt_lag  EXT SWAP: ok
  ----------------------------------------------------------------------*/
void swap_gen.swap_pmt_lag(	out	integer 	pmt_lag_leg1,
							out	integer 	mat_pmt_lag_leg1,
							out	integer 	pmt_lag_prin_leg1,
							out	integer 	mat_pmt_lag_prin_leg1,
							out	integer 	pmt_lag_leg2,
							out	integer 	mat_pmt_lag_leg2,
							out	integer 	pmt_lag_prin_leg2,
							out	integer 	mat_pmt_lag_prin_leg2,	
							error_info option(nullable) error ) 
{	
	try{
		SWAP_ENTRY_FUNC();
		instr_error_type t;
   		string 			s;	
		i().__swap_def_pmt_delay(pmt_lag_leg1, mat_pmt_lag_leg1, pmt_lag_prin_leg1, mat_pmt_lag_prin_leg1,
											pmt_lag_leg2, mat_pmt_lag_leg2, pmt_lag_prin_leg2, mat_pmt_lag_prin_leg2,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_gen.swap_pmt_lag");
		if(e) {
			pmt_lag_leg1= mat_pmt_lag_leg1= pmt_lag_prin_leg1= mat_pmt_lag_prin_leg1= err_int();
			pmt_lag_leg2= mat_pmt_lag_leg2= pmt_lag_prin_leg2= mat_pmt_lag_prin_leg2= err_int();
		}
		return ;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.swap_pmt_lag");
		pmt_lag_leg1= mat_pmt_lag_leg1= pmt_lag_prin_leg1= mat_pmt_lag_prin_leg1= err_int();
		pmt_lag_leg2= mat_pmt_lag_leg2= pmt_lag_prin_leg2= mat_pmt_lag_prin_leg2= err_int();
		return ;
	}
}

/*-----------------------------------------------------------------------
  swap_payleg1 
  ----------------------------------------------------------------------*/
logical	 swap_gen.swap_payleg1(error_info option(nullable) error ) 
{
	try{
		SWAP_ENTRY_FUNC();
		instr_error_type t;
   		string 			s;	
		logical c = i().__swap_payleg1(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_gen.swap_payleg1");
		return e ? null<logical> : c;								
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.swap_payleg1");
		return null<logical>;
	}
}

/*-----------------------------------------------------------------------
  swap_ir_index_leg1
  ----------------------------------------------------------------------*/
ir_index swap_gen.swap_ir_index_leg1(error_info option(nullable) error) 
{	
	try{	
		instr_error_type t;
   		string 			s;	
		..ir_index c = i().__swap_def_ir_index_leg1(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_gen.swap_ir_index_leg1");
		return e ? null<..ir_index >: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.swap_ir_index_leg1");
		return null<..ir_index >;
	}
}
/*-----------------------------------------------------------------------
  swap_ir_index_leg2
  ----------------------------------------------------------------------*/
ir_index swap_gen.swap_ir_index_leg2(error_info option(nullable) error) 
{	
	try{	
		instr_error_type t;
   		string 			s;	
		..ir_index c = i().__swap_def_ir_index_leg2(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_gen.swap_ir_index_leg2");
		return e ? null<..ir_index >: c;					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.swap_ir_index_leg2");
		return null<..ir_index >;
	}
}

/*-----------------------------------------------------------------------
  swap_coupon_freq_leg1 
  ----------------------------------------------------------------------*/
integer swap_gen.swap_coupon_freq_leg1(error_info option(nullable) error) 
{	
	try{
		instr_error_type t;
   		string 			s;
		integer c1,c2;
		i().__swap_def_cpn_freq(c1,c2,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_gen.swap_coupon_freq_leg1");
		return e ? err_freq() : c1;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.swap_coupon_freq_leg1");
		return err_freq();
	}
}

/*-----------------------------------------------------------------------
  swap_coupon_freq_leg2 
  ----------------------------------------------------------------------*/
integer swap_gen.swap_coupon_freq_leg2(error_info option(nullable) error)
{	
	try{
		instr_error_type t;
   		string 			s;
		integer c1,c2;
		i().__swap_def_cpn_freq(c1,c2,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_gen.swap_coupon_freq_leg2");
		return e ? err_freq() : c2;					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.swap_coupon_freq_leg2");
		return err_freq();
	}
}

/*-----------------------------------------------------------------------
  swap_reset_freq_leg1 
  ----------------------------------------------------------------------*/
integer swap_gen.swap_reset_freq_leg1(error_info option(nullable) error) 
{	
	try{
		instr_error_type t;
   		string 			s;
		integer c1,c2;
		i().__swap_def_reset_freq(c1,c2,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_gen.swap_reset_freq_leg1");
		return e ? err_freq() : c1;					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.swap_reset_freq_leg1");
		return err_freq();
	}
}
/*-----------------------------------------------------------------------
  swap_reset_freq_leg2 
  ----------------------------------------------------------------------*/
integer swap_gen.swap_reset_freq_leg2(error_info option(nullable) error) 
{	
	try{
		instr_error_type t;
   		string 			s;
		integer c1,c2;
		i().__swap_def_reset_freq(c1,c2,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_gen.swap_reset_freq_leg2");
		return e ? err_freq() : c2;					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.swap_reset_freq_leg2");
		return err_freq();
	}
}
/*-----------------------------------------------------------------------
  swap_index_tenor_leg1
  ----------------------------------------------------------------------*/
string swap_gen.swap_index_tenor_leg1(error_info option(nullable) error) 
{	
	try{
		..ir_index ir = this.swap_ir_index_leg1(error) ;
		if(null(ir)) return null<string>;
		return ir.tenor();
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.swap_index_tenor_leg1");
		return null<string>;
	}
}

/*-----------------------------------------------------------------------
  swap_index_tenor_code_leg1
  ----------------------------------------------------------------------*/
tenor_code swap_gen.swap_index_tenor_code_leg1(error_info option(nullable) error) 
{	
	try{
		..ir_index ir = this.swap_ir_index_leg1(error) ;
		if(null(ir)) return null<tenor_code>;
		return ir.tenor_code();
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.swap_index_tenor_code_leg1");
		return null<tenor_code>;
	}
}
/*-----------------------------------------------------------------------
  swap_index_tenor_code_leg2
  ----------------------------------------------------------------------*/
tenor_code swap_gen.swap_index_tenor_code_leg2(error_info option(nullable) error) 
{	
	try{
		..ir_index ir = this.swap_ir_index_leg2(error) ;
		if(null(ir)) return null<tenor_code>;
		return ir.tenor_code();
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.swap_index_tenor_code_leg2");
		return null<tenor_code>;
	}
}

/*-----------------------------------------------------------------------
  swap_index_tenor_leg2
  ----------------------------------------------------------------------*/
string swap_gen.swap_index_tenor_leg2(error_info option(nullable) error) 
{	
	try{
		..ir_index ir = this.swap_ir_index_leg2(error) ;
		if(null(ir)) return null<string>;
		return ir.tenor();
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.swap_index_tenor_leg2");
		return null<string>;
	}
}

/*-----------------------------------------------------------------------
  leg1_is_quote
  ----------------------------------------------------------------------*/
logical swap_gen.leg1_is_quote(error_info option(nullable) error) 
{	
	try{
		instr_error_type t;
		string s;
		logical c = i().__swap_def_leg1_is_quote(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_gen.leg1_is_quote");
		return e ? null<logical>: c;				
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.leg1_is_quote");
		return null<logical >;
	}
}
/*-----------------------------------------------------------------------
  leg2_is_quote
  ----------------------------------------------------------------------*/
logical swap_gen.leg2_is_quote(error_info option(nullable) error) 
{
	try{
		instr_error_type t;
		string s;
		logical c = i().__swap_def_leg1_is_quote(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_gen.leg2_is_quote");
		return e ? null<logical>: !c;				
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.leg2_is_quote");
		return null<logical >;
	}
}
/*-----------------------------------------------------------------------
  swap_currency_leg1
  ----------------------------------------------------------------------*/
string swap_gen.swap_currency_leg1(error_info option(nullable) error) 
{	
	try{
		instr_error_type t;
		string s;
		string c1,c2;
		i().__swap_def_currency( c1,c2,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_gen.swap_currency_leg1");
		return e ? null<string>: c1;				
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.swap_currency_leg1");
		return null<string >;
	}
}

/*-----------------------------------------------------------------------
  swap_currency_leg2
  ----------------------------------------------------------------------*/
string swap_gen.swap_currency_leg2(error_info option(nullable) error) 
{	
	try{
		instr_error_type t;
		string s;
		string c1,c2;
		i().__swap_def_currency( c1,c2,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_gen.swap_currency_leg2");
		return e ? null<string>: c2;					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.swap_currency_leg2");
		return null<string >;
	}
}
/*-----------------------------------------------------------------------
  swap_dc_method_leg1   DLL_SWAP_HANDLER: ok
  ----------------------------------------------------------------------*/
day_count_method swap_gen.swap_dc_method_leg1(error_info option(nullable) error) 
{	
	try{
		instr_error_type t;
   		string 			s;
		day_count_method c1,c2;
		i().__swap_def_dc_method( c1,c2,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_gen.swap_dc_method_leg1");
		return e ? null<day_count_method>: c1;					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.swap_dc_method_leg1");
		return null<day_count_method>;
	}
}

/*-----------------------------------------------------------------------
  swap_dc_method_leg2   DLL_SWAP_HANDLER: ok
  ----------------------------------------------------------------------*/
day_count_method swap_gen.swap_dc_method_leg2(error_info option(nullable) error) 
{	
	try{		
		instr_error_type t;
   		string 			s;
		day_count_method c1,c2;
		i().__swap_def_dc_method( c1,c2,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_gen.swap_dc_method_leg2");
		return e ? null<day_count_method>: c2;					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.swap_dc_method_leg2");
		return null<day_count_method>;
	}
}
/*-----------------------------------------------------------------------
  swap_disc_func_leg1
  ----------------------------------------------------------------------*/
disc_func swap_gen.swap_disc_func_leg1(error_info option(nullable) error) 
{	
	try{
		SWAP_ENTRY_FUNC();
		instr_error_type t;
   		string 			s;	
		disc_func c = i().__swap_disc_func_leg1(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_gen.swap_disc_func_leg1");
		return e ? null<disc_func>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.swap_disc_func_leg1");
		return null<disc_func >;
	}
}

/*-----------------------------------------------------------------------
  swap_disc_func_leg2
  ----------------------------------------------------------------------*/
disc_func swap_gen.swap_disc_func_leg2(error_info option(nullable) error) 
{	
	try{
		SWAP_ENTRY_FUNC();
		instr_error_type t;
   		string 			s;	
		disc_func c = i().__swap_disc_func_leg2(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_gen.swap_disc_func_leg2");
		return e ? null<disc_func>: c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.swap_disc_func_leg2");
		return null<disc_func >;
	}
}
/*-----------------------------------------------------------------------
  swap_tenor_surface_leg1
  ----------------------------------------------------------------------*/
tenor_surface swap_gen.swap_tenor_surface_leg1(error_info option(nullable) error) 
{	
	try{
		SWAP_ENTRY_FUNC();
		instr_error_type t;
   		string 			s;	
		tenor_surface c = i().__swap_surface_leg1(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_gen.swap_tenor_surface_leg1");
		return e ? null<tenor_surface>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.swap_tenor_surface_leg1");
		return null<tenor_surface >;
	}
}
/*-----------------------------------------------------------------------
  swap_tenor_surface_leg2
  ----------------------------------------------------------------------*/
tenor_surface swap_gen.swap_tenor_surface_leg2(error_info option(nullable) error) 
{	
	try{
		SWAP_ENTRY_FUNC();
		instr_error_type t;
   		string 			s;	
		tenor_surface c = i().__swap_surface_leg2(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_gen.swap_tenor_surface_leg2");
		return e ? null<tenor_surface>: c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.swap_tenor_surface_leg2");
		return null<tenor_surface >;
	}
}
/*-----------------------------------------------------------------------
  swap_leg   EXT SWAP: ok
  ----------------------------------------------------------------------*/
vector(ql_swap_leg) swap_gen.legs(logical clone,error_info option(nullable) error )
{
	SWAP_ENTRY_FUNC();
	return swap_gen.swap_leg(clone,error);
}
/*-----------------------------------------------------------------------
  fix_leg   EXT SWAP: ok
  ----------------------------------------------------------------------*/
ql_fix_leg swap_gen.fix_leg1(logical clone,error_info option(nullable) error )
{
	SWAP_ENTRY_FUNC();
	vector(ql_fix_leg) l = swap_gen.swap_fix_leg(clone,error);
	return !null(l) ? l[0] : null<ql_fix_leg>;	
}
/*-----------------------------------------------------------------------
  swap_leg  size=4 if 2swap otherwise size=2
  ----------------------------------------------------------------------*/
vector(ql_swap_leg) swap_gen.swap_leg(logical clone, error_info option(nullable) error) 
{	
	try{
		SWAP_ENTRY_FUNC();
		instr_error_type t;
   		string 			s;	
		vector(ql_swap_leg) c = i().__swap_leg(clone,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_gen.swap_leg");
		return e ? null<vector(ql_swap_leg) >: c;					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.swap_leg");
		return null<vector(ql_swap_leg) >;
	}
}

/*-----------------------------------------------------------------------
  swap_float_leg
  Note: vector size for a fixflt/fltois/... is 1 and for a fltflt it is 2  (if not a 2swap)
  if it is a 2swap:
  vector size = 1 --> fltois2swap
  vector size = 2 --> fltflt2swap
  ----------------------------------------------------------------------*/
vector(ql_float_leg) swap_gen.swap_float_leg(logical clone, error_info option(nullable) error) 
{	
	try{
		SWAP_ENTRY_FUNC();
		instr_error_type t;
   		string 			s;	
		vector(ql_float_leg) c = i().__swap_float_leg(clone,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_gen.swap_float_leg");
		return e ? null<vector(ql_float_leg) >: c;					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.swap_float_leg");
		return null<vector(ql_float_leg) >;
	}
}
/*-----------------------------------------------------------------------
  swap_fix_leg
  Note: vector size for a fixflt/fixois/... is 1 and for a fixfix it is 2  (if not a 2swap)
  if it is a 2swap:
  vector size = 2 for both types
  ----------------------------------------------------------------------*/
vector(ql_fix_leg) swap_gen.swap_fix_leg(logical clone, error_info option(nullable) error) 
{	
	try{
		SWAP_ENTRY_FUNC();
		instr_error_type t;
   		string 			s;	
		vector(ql_fix_leg) c = i().__swap_fix_leg(clone,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_gen.swap_fix_leg");
		return e ? null<vector(ql_fix_leg) >: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.swap_fix_leg");
		return null<vector(ql_fix_leg) >;
	}
}

/*-----------------------------------------------------------------------
  ql_fix_infl_ci_leg
  ----------------------------------------------------------------------*/
vector(ql_fix_infl_ci_leg) swap_gen.swap_fix_infl_ci_leg(logical clone, error_info option(nullable) error) 
{	
	try{
		SWAP_ENTRY_FUNC();
		instr_error_type t;
   		string 			s;		
		vector(ql_fix_infl_ci_leg) c = i().__swap_fix_infl_ci_leg(clone,t, s);
		
		logical e = CORE_INT.add_error_info(error,t,s, "swap_gen.ql_fix_infl_ci_leg");
		return e ? null<vector(ql_fix_infl_ci_leg) >: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.ql_fix_infl_ci_leg");
		return null<vector(ql_fix_infl_ci_leg) >;
	}
}

/*-----------------------------------------------------------------------
  swap_ois_leg
   Note: vector size for a fixois is 1 and for a oisois it is 2
  ----------------------------------------------------------------------*/
vector(ql_ois_leg) swap_gen.swap_ois_leg(logical clone, error_info option(nullable) error) 
{	
	try{
		SWAP_ENTRY_FUNC();
		instr_error_type t;
   		string 			s;	
		vector(ql_ois_leg) c = i().__swap_ois_leg(clone,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_gen.swap_ois_leg");
		return e ? null<vector(ql_ois_leg) >: c;					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.swap_ois_leg");
		return null<vector(ql_ois_leg) >;
	}
}

/*-----------------------------------------------------------------------
  swap_fix_zero_leg
  ----------------------------------------------------------------------*/
vector(ql_fix_zero_leg) swap_gen.swap_fix_zero_leg(logical clone, error_info option(nullable) error) 
{	
	try{
		SWAP_ENTRY_FUNC();
		instr_error_type t;
   		string 			s;	
		vector(ql_fix_zero_leg) c = i().__swap_fix_zero_leg(clone,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_gen.swap_fix_zero_leg");
		return e ? null<vector(ql_fix_zero_leg) >: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.swap_fix_zero_leg");
		return null<vector(ql_fix_zero_leg) >;
	}
}

/*-----------------------------------------------------------------------
  ql_zero_infl_leg
  ----------------------------------------------------------------------*/
vector(ql_zero_infl_leg) swap_gen.swap_zero_infl_leg(logical clone, error_info option(nullable) error) 
{	
	try{
		SWAP_ENTRY_FUNC();
		instr_error_type t;
   		string 			s;	
		vector(ql_zero_infl_leg) c = i().__swap_zero_infl_leg(clone,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_gen.swap_zero_infl_leg");
		return e ? null<vector(ql_zero_infl_leg) >: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.swap_zero_infl_leg");
		return null<vector(ql_zero_infl_leg) >;
	}
}
/*-----------------------------------------------------------------------
  ql_yy_infl_leg
  ----------------------------------------------------------------------*/
vector(ql_yy_infl_leg) swap_gen.swap_yy_infl_leg(logical clone, error_info option(nullable) error) 
{	
	try{
		SWAP_ENTRY_FUNC();
		instr_error_type t;
   		string 			s;	
		vector(ql_yy_infl_leg) c = i().__swap_yy_infl_leg(clone,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_gen.swap_yy_infl_leg");
		return e ? null<vector(ql_yy_infl_leg) >: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.swap_yy_infl_leg");
		return null<vector(ql_yy_infl_leg) >;
	}
}


/*-----------------------------------------------------------------------
  swap_present_value

  ----------------------------------------------------------------------*/
number swap_gen.present_value(	disc_func option(nullable)  disc_func_leg1,
								disc_func option(nullable) 	disc_func_leg2,
								out number pv_leg1,
								out number pv_leg2,
								number option(nullable) 	notional,
								logical option(nullable) 	trade_date_pv,																								
								error_info option(nullable) error) 
option(com_name: 'present_value_df')
{	
	try{
		SWAP_ENTRY_FUNC();
		notional = conv_null_number_com(notional) ;
		instr_error_type t;
   		string 			s;			
		number c = i().__swap_present_value(disc_func_leg1,disc_func_leg2,pv_leg1,pv_leg2,notional,trade_date_pv,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_gen.present_value");
		if(e){
			pv_leg1 = pv_leg2 = null<number>;
			return null<number>;
		}
		return c;						
	}
	catch {
		pv_leg1 = pv_leg2 = null<number>;
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.present_value");
		return null<number>;
	}
}


/*-----------------------------------------------------------------------
  swap_present_value

  ----------------------------------------------------------------------*/
number swap_gen.present_value(	disc_func option(nullable)	disc_func_leg1,
								disc_func option(nullable) 	disc_func_leg2,
								out number pv_leg1,
								out number pv_leg2,
								date option(nullable) pv_date,
								date option(nullable) settle_date,
								logical  	incl_issue_cf,
								logical  	incl_mat_cf,	
								error_info option(nullable) error) 
option(com_name: 'present_value_df_alt')
{	
	try{
		SWAP_ENTRY_FUNC();
		pv_date = conv_null_date_com(pv_date) ;
		settle_date = conv_null_date_com(settle_date) ;
		instr_error_type t;
   		string 			s;
		number nom = null<number>;	
		number c = i().__swap_present_value(disc_func_leg1,disc_func_leg2,pv_leg1,pv_leg2,nom,pv_date,settle_date,incl_issue_cf,incl_mat_cf,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_gen.present_value");
		if(e){
			pv_leg1 = pv_leg2 = null<number>;
			return null<number>;
		}
		return c;							
	}
	catch {
		pv_leg1 = pv_leg2 = null<number>;
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.present_value");
		return null<number>;
	}
}
/*-----------------------------------------------------------------------
  swap_present_value_fee

  ----------------------------------------------------------------------*/
number swap_gen.present_value_fee(	disc_func option(nullable)	disc_func_leg1,
									disc_func option(nullable) 	disc_func_leg2,
									out number pv_leg1,
									out number pv_leg2,
									date option(nullable) pv_date,
									date option(nullable) settle_date,
									logical  	incl_issue_cf,
									logical  	incl_mat_cf,	
									error_info option(nullable) error) 
option(com_name: 'present_value_fee_df_alt')
{	
	try{
		SWAP_ENTRY_FUNC();
		pv_date = conv_null_date_com(pv_date) ;
		settle_date = conv_null_date_com(settle_date) ;
		instr_error_type t;
   		string 			s;
		number nom = null<number>;	
		number c = i().__swap_present_value_fee(disc_func_leg1,disc_func_leg2,pv_leg1,pv_leg2,nom,pv_date,settle_date,incl_issue_cf,incl_mat_cf,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_gen.present_value");
		if(e){
			pv_leg1 = pv_leg2 = null<number>;
			return null<number>;
		}
		return c;							
	}
	catch {
		pv_leg1 = pv_leg2 = null<number>;
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.present_value");
		return null<number>;
	}
}
/*-----------------------------------------------------------------------
  swap_present_value

  ----------------------------------------------------------------------*/
number swap_gen.present_value(	out number pv_leg1,
								out number pv_leg2,
								logical option(nullable) 	trade_date_pv,
								error_info option(nullable) error) 
option(com_name: 'present_value')
{	
	try{
		SWAP_ENTRY_FUNC();
		instr_error_type t;
   		string 			s;
		number nom = null<number>;
		disc_func df_null = null<disc_func>;	
		number c = i().__swap_present_value(df_null,df_null,pv_leg1,pv_leg2,nom,trade_date_pv,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_gen.present_value");
		if(e){
			pv_leg1 = pv_leg2 = null<number>;
			return null<number>;
		}
		return c;					
	}
	catch {
		pv_leg1 = pv_leg2 = null<number>;
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.present_value");
		return null<number>;
	}
}


/*-----------------------------------------------------------------------
  swap_upfront_carry
  ----------------------------------------------------------------------*/
void swap_gen.swap_upfront_carry(	date option(nullable)  	fwd_trade_date,
									date option(nullable) 	fwd_settle_date,										
									logical 				reinv_unchg_df,
									out carry_result 		res,
									error_info option(nullable) error)
{
	try{
		SWAP_ENTRY_FUNC();
		fwd_trade_date = conv_null_date_com(fwd_trade_date) ;
		fwd_settle_date = conv_null_date_com(fwd_settle_date) ;
		instr_error_type t;
   		string 			s;

		res.fwd_trade_date 	= fwd_trade_date;
		res.fwd_settle_date = fwd_settle_date;
		res.reinv_unchg_df 	= reinv_unchg_df;
		
		i().__swap_upfront_carry(res.fwd_trade_date,
								res.fwd_settle_date,
								res.reinv_unchg_df,
								res.carry_upfront_leg1,
								res.carry_upfront_leg2,
								res.carry_fwd_leg1,
								res.carry_fwd_leg2,
								res.npv_spot_leg1,
								res.npv_spot_leg2,
								res.npv_fwd_leg1,
								res.npv_fwd_leg2,
								res.npv_fwd_spot_leg1,
								res.npv_fwd_spot_leg2,
								res.ai_fwd_leg1,
								res.ai_fwd_leg2,
								res.reinv_irim_cf_leg1,
								res.reinv_irim_cf_leg2,
								res.irim_cf_leg1,
								res.irim_cf_leg2,
								res.npv_spot_ir_leg1,
								res.npv_spot_ir_leg2,
								res.pvadj_ai_spot_leg1,
								res.pvadj_ai_spot_leg2,
								res.pvadj_ai_fwd_leg1,
								res.pvadj_ai_fwd_leg2,
								res.carry_upfront_ai_leg1,
								res.carry_upfront_ai_leg2,
								res.carry_fwd_ai_leg1,
								res.carry_fwd_ai_leg2,t, s);

		logical e = CORE_INT.add_error_info(error,t,s, "swap_gen.swap_upfront_carry");
		if(e){
			res = null;
			return ;
		}

		res.npv_spot		= res.npv_spot_leg1 		+ res.npv_spot_leg2;
		res.npv_fwd			= res.npv_fwd_leg1 			+ res.npv_fwd_leg2;
		res.carry_pv 		= res.carry_upfront_leg1 	+ res.carry_upfront_leg2;
		res.npv_spot_ir 	= res.npv_spot_ir_leg1 		+ res.npv_spot_ir_leg2;
		res.carry 			= res.carry_fwd_leg1 		+ res.carry_fwd_leg2 	- res.npv_spot_ir;
		
		res.reinv_irim_cf 	= res.reinv_irim_cf_leg1 	+ res.reinv_irim_cf_leg2;	//interim cashflows pv @fwd
		res.irim_cf 		= res.irim_cf_leg1 			+ res.irim_cf_leg2;			//sum of interim cashflows
		
		res.carry_pv_ai_adj = res.carry_upfront_ai_leg1	+ res.carry_upfront_ai_leg2;	//pv @spot
		res.carry_ai_adj 	= res.carry_fwd_ai_leg1		+ res.carry_fwd_ai_leg2	- res.npv_spot_ir;//use this as carry

		res.ai_fwd 			= res.ai_fwd_leg1 			+ res.ai_fwd_leg2;
		res.pvadj_ai_fwd	= res.pvadj_ai_fwd_leg1 	+ res.pvadj_ai_fwd_leg2;		//ai calc at fwdsettle and pv adjusted from cpndate to fwdsettle
		
		return ;							
	}
	catch {
		res = null;
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.swap_upfront_carry");
		return ;
	}
}
									

/*-----------------------------------------------------------------------
  swap_upfront_carry
  ----------------------------------------------------------------------*/
void swap_gen.swap_upfront_rolldown(date option(nullable)  	fwd_trade_date,
									date option(nullable) 	fwd_settle_date,										
									logical 				incl_reinv_in_roll,
									out rolldown_result 		res,
									error_info option(nullable) error)
{
	try{
		SWAP_ENTRY_FUNC();
		fwd_trade_date = conv_null_date_com(fwd_trade_date) ;
		fwd_settle_date = conv_null_date_com(fwd_settle_date) ;
		instr_error_type t;
   		string 			s;

		res.fwd_trade_date 		= fwd_trade_date;
		res.fwd_settle_date 	= fwd_settle_date;
		res.incl_reinv_in_roll 	= incl_reinv_in_roll;
		
		i().__swap_upfront_rolldown(res.fwd_trade_date, res.fwd_settle_date, res.incl_reinv_in_roll,
									res.roll_upfront_leg1,
									res.roll_upfront_leg2,
									res.roll_fwd_leg1,
									res.roll_fwd_leg2,
									res.npv_spot_leg1,
									res.npv_spot_leg2,
									res.npv_fwd_leg1,
									res.npv_fwd_leg2,
									res.npv_fwd_spot_leg1,
									res.npv_fwd_spot_leg2,
									res.ai_fwd_leg1,
									res.ai_fwd_leg2,
									res.reinv_irim_cf_leg1,
									res.reinv_irim_cf_leg2,
									res.irim_cf_leg1,
									res.irim_cf_leg2,
									res.npv_spot_ir_leg1,
									res.npv_spot_ir_leg2,
									res.pvadj_ai_spot_leg1,
									res.pvadj_ai_spot_leg2,
									res.pvadj_ai_fwd_leg1,
									res.pvadj_ai_fwd_leg2,
									res.roll_upfront_ai_leg1,
									res.roll_upfront_ai_leg2,
									res.roll_fwd_ai_leg1,
									res.roll_fwd_ai_leg2,
									res.carry_roll_spot_leg1,
									res.carry_roll_spot_leg2,
									res.carry_roll_fwd_leg1,
									res.carry_roll_fwd_leg2,
									res.imp_carry_spot_leg1,
									res.imp_carry_spot_leg2,
									res.imp_carry_fwd_leg1,
									res.imp_carry_fwd_leg2,
									t, s);

		logical e = CORE_INT.add_error_info(error,t,s, "swap_gen.swap_upfront_rolldown");
		if(e){
			res = null;
			return ;
		}

		res.npv_spot		= res.npv_spot_leg1 		+ res. npv_spot_leg2;
		res.npv_fwd			= res.npv_fwd_leg1 			+ res. npv_fwd_leg2;
		res.reinv_irim_cf 	= res.reinv_irim_cf_leg1 	+ res.reinv_irim_cf_leg2;
		res.irim_cf 		= res.irim_cf_leg1 			+ res.irim_cf_leg2;
		
		res.npv_spot_ir 	= res.npv_spot_ir_leg1 		+ res.npv_spot_ir_leg2;		
		res.roll_pv 		= res.roll_upfront_leg1 	+ res.roll_upfront_leg2;
		res.roll 			= res.roll_fwd_leg1 		+ res.roll_fwd_leg2 	+ res.npv_spot_ir;		
		res.roll_pv_ai_adj 	= res.roll_upfront_ai_leg1 	+ res.roll_upfront_ai_leg2;
		res.roll_ai_adj 	= res.roll_fwd_ai_leg1 		+ res.roll_fwd_ai_leg2 	+ res.npv_spot_ir;

		res.ai_fwd 			= res.ai_fwd_leg1 			+ res.ai_fwd_leg2;
		res.pvadj_ai_fwd 	= res.pvadj_ai_fwd_leg1 	+ res.pvadj_ai_fwd_leg2; // == -(res.roll_ai_adj - res.roll);

		res.carry_roll		= res.carry_roll_fwd_leg1 	+ res.carry_roll_fwd_leg2 + res.npv_spot_ir;
		res.carry_implied	= res.imp_carry_fwd_leg1	+ res.imp_carry_fwd_leg2;
		return ;					
	}
	catch {
		res = null;
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.swap_upfront_rolldown");
		return ;
	}
}

/*-----------------------------------------------------------------------
  swap_add_notional
  ----------------------------------------------------------------------*/
void swap_gen.swap_add_notional(number notional) 
option(com_name: 'INTERNAL_swap_add_notional')
{
	SWAP_ENTRY_FUNC();
	i().__swap_add_notional(notional);
	return ;						
}
/*-----------------------------------------------------------------------
  swap_add_notional
  ----------------------------------------------------------------------*/
void swap_gen.swap_add_notional(number notional1, number notional2) 
option(com_name: 'INTERNAL_swap_add_notional')
{
	SWAP_ENTRY_FUNC();
	i().__swap_add_notional(notional1,notional2);
	return ;						
}
/*-----------------------------------------------------------------------
  swap_add_notional_leg1
  Note: for single currency swaps notional will be changed for both legs
  ----------------------------------------------------------------------*/
/*void swap_gen.swap_add_notional_leg1(number notional) 
option(com_name: 'INTERNAL_swap_add_notional_leg1')
{
	SWAP_ENTRY_FUNC();
	i().__swap_add_notional_leg1(notional);
	return ;						
}*/

/*-----------------------------------------------------------------------
  swap_add_notional_leg2
  Note: for single currency swaps notional will be changed for both legs
  ----------------------------------------------------------------------*/
/*void swap_gen.swap_add_notional_leg2(number notional) 
option(com_name: 'INTERNAL_swap_add_notional_leg2')
{
	SWAP_ENTRY_FUNC();
	i().__swap_add_notional_leg2(notional);
	return ;						
}*/
/*-----------------------------------------------------------------------
  swap_add_fx_rate
  Note: function only applicable for currency swap
  ----------------------------------------------------------------------*/
void swap_gen.swap_add_fx_rate(	number 	fx_quote_dec,//must be a quote per unit of base ccy
								logical pv_in_base_ccy,
								string 	base_ccy,
								string 	price_ccy)
option(com_name: 'INTERNAL_swap_add_fx')
{
	SWAP_ENTRY_FUNC();
	error_info ee = new error_info(true,true);
	
	string 	curr_leg1;
	string 	curr_leg2;

	this.currency(curr_leg1, curr_leg2, ee) ;

	QL_REQUIRE(!equal_casei(curr_leg1, curr_leg2),"function not applicable to single currency swaps");
		
	logical leg1_is_base_ccy;
	number 	leg1_fx_mult,leg2_fx_mult;
	CORE_INT_SWAPLIB.swap_lib_fx_handler_ccy(curr_leg1,curr_leg2, base_ccy, price_ccy, pv_in_base_ccy, fx_quote_dec,
											leg1_is_base_ccy, leg1_fx_mult, leg2_fx_mult);
	
	i().__swap_add_fx_rate_leg1(leg1_fx_mult);
	i().__swap_add_fx_rate_leg2(leg2_fx_mult);
	return ;						
}
/*-----------------------------------------------------------------------
  swap_add_fx_mult_leg1
  Note: function only applicable for currency swap
  ----------------------------------------------------------------------*/
void swap_gen.swap_add_fx_mult_leg1(number fx_mult) 
option(com_name: 'INTERNAL_swap_add_fx_mult_leg1')
{
	SWAP_ENTRY_FUNC();
	i().__swap_add_fx_rate_leg1(fx_mult);
	return ;						
}
/*-----------------------------------------------------------------------
  swap_add_fx_mult_leg2
  Note: function only applicable for currency swap
  ----------------------------------------------------------------------*/
void swap_gen.swap_add_fx_mult_leg2(number fx_mult) 
option(com_name: 'INTERNAL_swap_add_fx_mult_leg2')
{
	SWAP_ENTRY_FUNC();
	i().__swap_add_fx_rate_leg2(fx_mult);
	return ;						
}

/*-----------------------------------------------------------------------
  swap_add_disc_func
  Note: function not applicable for currency swap
  ----------------------------------------------------------------------*/
void swap_gen.swap_add_disc_func(disc_func  option(nullable)  disc_func) 
option(com_name: 'INTERNAL_swap_add_disc_func')
{
	SWAP_ENTRY_FUNC();
	i().__swap_add_disc_func(disc_func);
	return ;						
}

/*-----------------------------------------------------------------------
  swap_add_disc_func_leg1
  Note: beware that even for single curr swaps only one leg is updated
		normally single curr swaps have the same disc_func for both legs (an exception is real rate swaps where
		one leg has a real disc_func and the other a nominal)		
  ----------------------------------------------------------------------*/
void swap_gen.swap_add_disc_func_leg1(disc_func  option(nullable) disc_func) 
option(com_name: 'INTERNAL_swap_add_disc_func_leg1')
{
	SWAP_ENTRY_FUNC();
	i().__swap_add_disc_func_leg1(disc_func);
	return ;						
}
/*-----------------------------------------------------------------------
  swap_add_disc_func_leg2
  Note: beware that even for single curr swaps only one leg is updated
		normally single curr swaps have the same disc_func for both legs (an exception is real rate swaps where
		one leg has a real disc_func and the other a nominal)
  ----------------------------------------------------------------------*/
void swap_gen.swap_add_disc_func_leg2(disc_func  option(nullable)  disc_func) 
option(com_name: 'INTERNAL_swap_add_disc_func_leg2')
{
	SWAP_ENTRY_FUNC();
	i().__swap_add_disc_func_leg2(disc_func);
	return ;						
}

/*-----------------------------------------------------------------------
  swap_add_surface_leg1
  ----------------------------------------------------------------------*/
void swap_gen.swap_add_surface_leg1(tenor_surface option(nullable) tenor_surface) 
option(com_name: 'INTERNAL_swap_add_surface_leg1')
{
	SWAP_ENTRY_FUNC();
	i().__swap_add_surface_leg1(tenor_surface);
	return ;						
}

/*-----------------------------------------------------------------------
  swap_add_surface_leg2
  ----------------------------------------------------------------------*/
void swap_gen.swap_add_surface_leg2(tenor_surface option(nullable) tenor_surface) 
option(com_name: 'INTERNAL_swap_add_surface_leg2')
{
	SWAP_ENTRY_FUNC();
	i().__swap_add_surface_leg2(tenor_surface);
	return ;						
}

/*-----------------------------------------------------------------------
  swap_add_fixing_leg1
  ----------------------------------------------------------------------*/
void swap_gen.swap_add_fixing_leg1(	vector(date) fixing_dates,
										vector(number) fixings,
										logical option(nullable) fixing_as_fwd ) 
option(com_name: 'INTERNAL_swap_add_fixing_leg1')
{
	SWAP_ENTRY_FUNC();
	i().__swap_add_fixing_leg1(fixing_dates,fixings,fixing_as_fwd);
	return ;						
}

/*-----------------------------------------------------------------------
  swap_add_fixing_start_stub_leg1
  ----------------------------------------------------------------------*/
void swap_gen.swap_add_fixing_start_stub_leg1(	number option(nullable) fixing) 
{
	SWAP_ENTRY_FUNC();
	i().__swap_add_fixing_start_stub_leg1(fixing);
	return ;						
}
/*-----------------------------------------------------------------------
  swap_add_fixing_start_stub_leg2
  ----------------------------------------------------------------------*/
void swap_gen.swap_add_fixing_start_stub_leg2(	number option(nullable) fixing) 
{
	SWAP_ENTRY_FUNC();
	i().__swap_add_fixing_start_stub_leg2(fixing);
	return ;						
}

/*-----------------------------------------------------------------------
  swap_add_fixing_end_stub_leg1
  ----------------------------------------------------------------------*/
void swap_gen.swap_add_fixing_end_stub_leg1(	number option(nullable) fixing) 
{
	SWAP_ENTRY_FUNC();
	i().__swap_add_fixing_end_stub_leg1(fixing);
	return ;						
}
/*-----------------------------------------------------------------------
  swap_add_fixing_end_stub_leg2
  ----------------------------------------------------------------------*/
void swap_gen.swap_add_fixing_end_stub_leg2(	number option(nullable) fixing) 
{
	SWAP_ENTRY_FUNC();
	i().__swap_add_fixing_end_stub_leg2(fixing);
	return ;						
}

/*-----------------------------------------------------------------------
  swap_add_curr_fixing_leg2
  ----------------------------------------------------------------------*/
void swap_gen.swap_add_curr_fixing_leg2(	number option(nullable) fixing) 
option(com_name: 'INTERNAL_swap_add_curr_fixing_leg2')
{
	SWAP_ENTRY_FUNC();
	i().__swap_add_curr_fixing_leg2(fixing);
	return ;						
}
/*-----------------------------------------------------------------------
  swap_add_curr_fixing_leg1
  ----------------------------------------------------------------------*/
void swap_gen.swap_add_curr_fixing_leg1(	number option(nullable) fixing) 
option(com_name: 'INTERNAL_swap_add_curr_fixing_leg1')
{
	SWAP_ENTRY_FUNC();
	i().__swap_add_curr_fixing_leg1(fixing);
	return ;						
}
/*-----------------------------------------------------------------------
  swap_add_fixing_leg2
  ----------------------------------------------------------------------*/
void swap_gen.swap_add_fixing_leg2(	vector(date) fixing_dates,
										vector(number) fixings,
										logical option(nullable) fixing_as_fwd ) 
option(com_name: 'INTERNAL_swap_add_fixing_leg2')
{
	SWAP_ENTRY_FUNC();
	i().__swap_add_fixing_leg2(fixing_dates,fixings,fixing_as_fwd);
	return ;						
}
/*-----------------------------------------------------------------------
  swap_add_fixing_leg1
  ----------------------------------------------------------------------*/
void swap_gen.swap_add_fixing_leg1(	number fixing_proxy,
										logical option(nullable) fixing_as_fwd ) 
option(com_name: 'INTERNAL_swap_add_fixing_leg1_p')
{
	SWAP_ENTRY_FUNC();
	i().__swap_add_fixing_leg1(fixing_proxy, fixing_as_fwd);
	return ;						
}

/*-----------------------------------------------------------------------
  swap_add_fixing_leg2
  ----------------------------------------------------------------------*/
void swap_gen.swap_add_fixing_leg2(	number fixing_proxy,
										logical option(nullable) fixing_as_fwd ) 
option(com_name: 'INTERNAL_swap_add_fixing_leg2_p')
{
	SWAP_ENTRY_FUNC();
	i().__swap_add_fixing_leg2(fixing_proxy, fixing_as_fwd);
	return ;						
}

/*-----------------------------------------------------------------------
  check_full_swap  EXT SWAP: ok   <protected>
  ----------------------------------------------------------------------*/
logical swap_gen.check_full_swap(logical f, logical allow_non_norm_2swap, error_info option(nullable) error) 
{	
	try{
		error_info ee = new error_info(true,false);
		QL_REQUIRE(this.is_valid(ee),"invalid swap");
		
		if(null(f) || !f) {			
			f = this.verify_full_swap(allow_non_norm_2swap,ee);
			QL_REQUIRE(f, null(ee.message()) ? "invalid swap" : ee.message());
		}
				
		return f;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.check_full_swap");		
		return false;
	}
}

/*-----------------------------------------------------------------------
  verify_full_swap  EXT SWAP: ok <protected>
  if true is returned then we have a complete swap in __instrument
  (fltflt2s in "limbo" will return false)
  ----------------------------------------------------------------------*/
logical swap_gen.verify_full_swap(logical allow_non_norm_2swap,
								  error_info option(nullable) error)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		logical c = i().__verify_full_swap(allow_non_norm_2swap,t, s);//if c=null or c=false then t,s = error
		logical e = CORE_INT.add_error_info(error,t,s, "swap_gen.verify_full_swap");
		return e ? false: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.verify_full_swap");
		return false;
	}
}
/*-----------------------------------------------------------------------
  get_ois_leg1
  ----------------------------------------------------------------------*/
logical swap_gen.get_ois_leg1(out ql_ois_leg ol)
{
	ol = null;
	if(!leg1_is_ois())
		return false;
	error_info ee = error_info(true,true);
	vector(ql_ois_leg) l = swap_gen.swap_ois_leg(false,ee);
	if(null(l) || v_size(l) == 0)
		return false;
			
	ol = l[0];
	return true;
}

/*-----------------------------------------------------------------------
  get_ois_leg2
  ----------------------------------------------------------------------*/
logical swap_gen.get_ois_leg2(out ql_ois_leg ol)
{	
	ol = null;
	if(!leg2_is_ois())
		return false;
	error_info ee = error_info(true,true);
	vector(ql_ois_leg) l = swap_gen.swap_ois_leg(false,ee);
	if(null(l) || v_size(l) == 0)
		return false;
			
	ol = leg1_is_ois() ? l[1]: l[0];
	return true;
}

/*-----------------------------------------------------------------------
  get_float_leg1
  ----------------------------------------------------------------------*/
logical swap_gen.get_float_leg1(out ql_float_leg ol)
{
	ol = null;
	if(!leg1_is_flt())
		return false;
	error_info ee = error_info(true,true);
	vector(ql_float_leg) l = swap_gen.swap_float_leg(false,ee);
	if(null(l) || v_size(l) == 0)
		return false;
			
	ol = l[0];
	return true;
}

/*-----------------------------------------------------------------------
  get_float_leg2
  ----------------------------------------------------------------------*/
logical swap_gen.get_float_leg2(out ql_float_leg ol)
{	
	ol = null;
	if(!leg2_is_flt())
		return false;
	error_info ee = error_info(true,true);
	vector(ql_float_leg) l = swap_gen.swap_float_leg(false,ee);
	if(null(l) || v_size(l) == 0)
		return false;
			
	ol = leg1_is_flt() ? l[1]: l[0];
	return true;
}
/*-----------------------------------------------------------------------
  get_fix_leg1
  ----------------------------------------------------------------------*/
logical swap_gen.get_fix_leg1(out ql_fix_leg ol)
{
	ol = null;
	if(!leg1_is_fix())
		return false;
	error_info ee = error_info(true,true);
	vector(ql_fix_leg) l = swap_gen.swap_fix_leg(false,ee);
	if(null(l) || v_size(l) == 0)
		return false;
			
	ol = l[0];
	return true;
}

/*-----------------------------------------------------------------------
  get_fix_leg2
  ----------------------------------------------------------------------*/
logical swap_gen.get_fix_leg2(out ql_fix_leg ol)
{	
	ol = null;
	if(!leg2_is_fix())
		return false;
	error_info ee = error_info(true,true);
	vector(ql_fix_leg) l = swap_gen.swap_fix_leg(false,ee);
	if(null(l) || v_size(l) == 0)
		return false;
			
	ol = leg1_is_fix() ? l[1]: l[0];
	return true;
}
/*-----------------------------------------------------------------------
  get_zero_leg1
  ----------------------------------------------------------------------*/
logical swap_gen.get_zero_leg1(out ql_fix_zero_leg ol)
{
	ol = null;
	if(!leg1_is_zero())
		return false;
	error_info ee = error_info(true,true);
	vector(ql_fix_zero_leg) l = swap_gen.swap_fix_zero_leg(false,ee);
	if(null(l) || v_size(l) == 0)
		return false;
			
	ol = l[0];
	return true;
}

/*-----------------------------------------------------------------------
  get_zero_leg2
  ----------------------------------------------------------------------*/
logical swap_gen.get_zero_leg2(out ql_fix_zero_leg ol)
{	
	ol = null;
	if(!leg2_is_zero())
		return false;
	error_info ee = error_info(true,true);
	vector(ql_fix_zero_leg) l = swap_gen.swap_fix_zero_leg(false,ee);
	if(null(l) || v_size(l) == 0)
		return false;
			
	ol = leg1_is_zero() ? l[1]: l[0];
	return true;
}
/*-----------------------------------------------------------------------
  is_endog_df_ois_leg1	EXT SWAP: ok (defaults to true for all db swaps)
  ----------------------------------------------------------------------*/
logical  swap_gen.is_endog_df_ois_leg1(error_info option(nullable) error ) 
{	
	try{
		
		ql_ois_leg ol;
		QL_REQUIRE(get_ois_leg1(ol),"invalid function call");				
		return ol.is_endog_df();						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.is_endog_df_ois_leg1");
		return null<logical >;
	}
}

/*-----------------------------------------------------------------------
  is_endog_df_ois_leg2	EXT SWAP: ok (defaults to true for all db swaps)
  ----------------------------------------------------------------------*/
logical  swap_gen.is_endog_df_ois_leg2(error_info option(nullable) error ) 
{	
	try{
		ql_ois_leg ol;
		QL_REQUIRE(get_ois_leg2(ol),"invalid function call");				
		return ol.is_endog_df();					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.is_endog_df_ois_leg2");
		return null<logical >;
	}
}
/*-----------------------------------------------------------------------
  is_approx_calc_ois_leg2	EXT SWAP: ok (defaults to true for all db swaps)
  ----------------------------------------------------------------------*/
logical  swap_gen.is_approx_calc_ois_leg2(error_info option(nullable) error ) 
{	
	try{
		ql_ois_leg ol;
		QL_REQUIRE(get_ois_leg2(ol),"invalid function call");				
		return ol.approx_calc();	
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.is_approx_calc_ois_leg2");
		return null<logical >;
	}
}
/*-----------------------------------------------------------------------
  is_approx_calc_ois_leg1	EXT SWAP: ok (defaults to true for all db swaps)
  ----------------------------------------------------------------------*/
logical  swap_gen.is_approx_calc_ois_leg1(error_info option(nullable) error ) 
{	
	try{
		ql_ois_leg ol;
		QL_REQUIRE(get_ois_leg1(ol),"invalid function call");				
		return ol.approx_calc();
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.is_approx_calc_ois_leg1");
		return null<logical >;
	}
}

/*----------------------------------------------------------------------
 add_disc_func_ois_leg1
  Note: -this func refers to the discounting but if [endog_df = true] also the surface will be updated
		-beware that even for single curr swaps only ois leg is updated
----------------------------------------------------------------------*/
void swap_gen.add_disc_func_ois_leg1(disc_func  disc_func,
									 logical add_surf_if_endog,
									 out tenor_surface ts)//beware: ts is both input and output
{
	QL_REQUIRE(leg1_is_ois(),"invalid function call");
	error_info ee = new error_info(true,true);
	this.swap_add_disc_func_leg1(disc_func);
	
	if(add_surf_if_endog && this.is_endog_df_ois_leg1(ee) ){
		if(null(ts)) {		
			..ir_index idx = swap_ir_index_leg1(ee);
			//fwd_func f = fwd_func(disc_func,365,trade_date(),idx.day_count_method(),idx.fixing_calendar(),BD_FOLLOWING,false);
			date m = maturity(ee);
			number sprd = 0;
			fwd_func f = CORE_INT.create_fwd_func_from_df_on(trade_date(), m,idx.fixing_calendar(),idx.day_count_method(), disc_func,true,sprd);
			
			logical allow_extrap 	= false;
			ts = tenor_surface(trade_date(), disc_func,[f],[idx],allow_extrap);
		}
		this.swap_add_surface_leg1(ts);
	}
	else {
		ts = null;
	}
}
/*----------------------------------------------------------------------
 add_disc_func_ois_leg2
  Note: -this func refers to the discounting but if [endog_df = true] also the surface will be updated
		-beware that even for single curr swaps only ois leg is updated
----------------------------------------------------------------------*/
void swap_gen.add_disc_func_ois_leg2(disc_func  disc_func,
									 logical add_surf_if_endog,
									 out tenor_surface ts )//beware: ts is both input and output
{
	QL_REQUIRE(leg2_is_ois(),"invalid function call");
	error_info ee = new error_info(true,true);
	this.swap_add_disc_func_leg2(disc_func);
	
	if(add_surf_if_endog && this.is_endog_df_ois_leg2(ee) ){
		if(null(ts)) {	
			..ir_index idx = swap_ir_index_leg2(ee);
			//fwd_func f = fwd_func(disc_func,365,trade_date(),idx.day_count_method(),idx.fixing_calendar(),BD_FOLLOWING,false);
			date m = maturity(ee);
			number sprd = 0;
			fwd_func f = CORE_INT.create_fwd_func_from_df_on(trade_date(), m,idx.fixing_calendar(),idx.day_count_method(), disc_func,true,sprd);
			
			logical allow_extrap 	= false;
			ts = tenor_surface(trade_date(), disc_func,[f],[idx],allow_extrap);
		}
		this.swap_add_surface_leg2(ts);
	}
	else {
		ts = null;
	}
}

/*---------------------------------------------------------------------
 add_fwd_func_ois_leg1
 ---------------------------------------------------------------------*/
void swap_gen.add_fwd_func_ois_leg1(fwd_func fwd_func,
									logical add_disc_if_endog,
									out disc_func df,//beware: df is both input and output
									out tenor_surface ts)
{
	error_info ee = new error_info(true,true);

	logical ignore_idx_sprd = true;
	if(add_disc_if_endog && this.is_endog_df_ois_leg1(ee)){
		if(null(df)){
			..ir_index idx = this.swap_ir_index_leg1(ee);
			date m = maturity(ee);
			number sprd = ignore_idx_sprd ? 0 : idx.index_spread();
			df = CORE_INT.create_disc_func_from_fwd_on(trade_date(),m,fwd_func,idx.day_count_method(),idx.fixing_calendar(),true,sprd);
		}
		this.swap_add_disc_func_leg1(df);

		ts = this.create_tenor_surface_ois_leg1(df, fwd_func,true,ee);
		this.swap_add_surface_leg1(ts);
		return;
	}
	else {
		df = null;
	}

	disc_func __df;
	ts = this.create_tenor_surface_ois_leg1(__df, fwd_func,true,ee);//a discfunc will be created
	this.swap_add_surface_leg1(ts);

}
/*---------------------------------------------------------------------
 add_fwd_func_ois_leg2
 ---------------------------------------------------------------------*/
void swap_gen.add_fwd_func_ois_leg2(fwd_func fwd_func,
									logical add_disc_if_endog,
									out disc_func df,//beware: df is both input and output
									out tenor_surface ts )
{
	
	error_info ee = new error_info(true,true);
	logical ignore_idx_sprd = true;
	if(add_disc_if_endog && this.is_endog_df_ois_leg2(ee)){

		if(null(df)){
			..ir_index idx = this.swap_ir_index_leg2(ee);

			date m = maturity(ee);
			number sprd = ignore_idx_sprd ? 0 : idx.index_spread();
			df = CORE_INT.create_disc_func_from_fwd_on(trade_date(),m,fwd_func,idx.day_count_method(),idx.fixing_calendar(),true,sprd);
		}
		this.swap_add_disc_func_leg2(df);
		ts = this.create_tenor_surface_ois_leg2(df, fwd_func,true, ee);//a discfunc will be created
		this.swap_add_surface_leg2(ts);
		return;
				
	}
	else {
		df = null;
	}
	disc_func __df;
	ts = this.create_tenor_surface_ois_leg2(__df, fwd_func,true, ee);//a discfunc will be created
	this.swap_add_surface_leg2(ts);
}


/*-----------------------------------------------------------------------
 add_fwd_from_disc_func_ois_leg1
 -----------------------------------------------------------------------*/
void swap_gen.add_fwd_from_disc_func_ois_leg1(disc_func fwddf,
											  logical add_disc_if_endog,
											  out tenor_surface ts)
{	
	error_info ee = new error_info(true,true);
	//logical ignore_idx_sprd = true;
	
	if(add_disc_if_endog && this.is_endog_df_ois_leg1(ee)){
		this.swap_add_disc_func_leg1(fwddf);
	}
	fwd_func f;
	ts = this.create_tenor_surface_ois_leg1(fwddf, f, true,ee);//a fwdfunc will be created
	this.swap_add_surface_leg1(ts);
}
/*-----------------------------------------------------------------------
 add_fwd_from_disc_func_ois_leg2
 -----------------------------------------------------------------------*/
void swap_gen.add_fwd_from_disc_func_ois_leg2(disc_func fwddf,
											  logical add_disc_if_endog ,
											  out tenor_surface ts )
{	
	error_info ee = new error_info(true,true);
	//logical ignore_idx_sprd = true;
	
	if(add_disc_if_endog && this.is_endog_df_ois_leg2(ee)){
		this.swap_add_disc_func_leg2(fwddf);
	}

	fwd_func f;
	ts = this.create_tenor_surface_ois_leg2(fwddf, f,true,ee);//a fwdfunc will be created
	this.swap_add_surface_leg2(ts);
}


/*-----------------------------------------------------------------------
  add_curve_data_ois_leg1
  ----------------------------------------------------------------------*/
void swap_gen.add_curve_data_ois_leg1(	disc_func  df_disc,
										disc_func 	option(nullable) df_fwd,
										logical		sync_endog_ok ) 																													
{
	error_info ee = new error_info(true,true);
	//logical ignore_idx_sprd = true;
	logical endog_df = this.is_endog_df_ois_leg1(ee);	
	QL_FAIL_COND(endog_df && !sync_endog_ok && !null(df_fwd), "ambigious input");

	tenor_surface ts;
	
	if(!endog_df) {
		
		add_disc_func_ois_leg1(df_disc, false ,ts);//ts will be null here since endog_df = false
		QL_REQUIRE(!null(df_fwd), "df_func_fwd is required for non self discounting ois");
		fwd_func __f;
		ts = create_tenor_surface_ois_leg1(df_fwd, __f,true,ee);//__f will be ceated
		this.swap_add_surface_leg1(ts);
		return;
	}

	if(sync_endog_ok) {
		
		logical add_surf_if_endog = false;
		add_disc_func_ois_leg1(df_disc, add_surf_if_endog ,ts);//ts will be null here since add_surf_if_endog = false
		fwd_func __f;
		ts = create_tenor_surface_ois_leg1(df_disc, __f,sync_endog_ok,ee);//__f will be ceated
		this.swap_add_surface_leg1(ts);
	}
	else {
		logical add_surf_if_endog = true;
		add_disc_func_ois_leg1(df_disc, add_surf_if_endog, ts );//if endog we create a fwd_func and update surface
	}
}
/*-----------------------------------------------------------------------
  add_curve_data_ois_leg2
  ----------------------------------------------------------------------*/
void swap_gen.add_curve_data_ois_leg2(	disc_func  df_disc,
										disc_func 	option(nullable) df_fwd,
										logical		sync_endog_ok ) 	//only used if NOT endog_df																												
{
	error_info ee = new error_info(true,true);
	//logical ignore_idx_sprd = true;
	logical endog_df = this.is_endog_df_ois_leg2(ee);	
	QL_FAIL_COND(endog_df && !sync_endog_ok && !null(df_fwd), "ambigious input");

	tenor_surface ts;
	
	if(!endog_df) {
		add_disc_func_ois_leg2(df_disc, false  ,ts);//ts will be null here since endog_df = false
		QL_REQUIRE(!null(df_fwd), "df_func_fwd is required for non self discounting ois");
		fwd_func __f;
		ts = create_tenor_surface_ois_leg2(df_fwd, __f,true,ee);//__f will be ceated
		this.swap_add_surface_leg2(ts);
		return;
	}

	if(sync_endog_ok) {
		logical add_surf_if_endog = false;
		add_disc_func_ois_leg2(df_disc, add_surf_if_endog  ,ts);//ts will be null here since add_surf_if_endog = false
		fwd_func __f;
		ts = create_tenor_surface_ois_leg2(df_disc, __f,sync_endog_ok,ee);//__f will be ceated
		this.swap_add_surface_leg2(ts);
	}
	else {
		logical add_surf_if_endog = true;
		add_disc_func_ois_leg2(df_disc, add_surf_if_endog,ts );//if endog we create a fwd_func and update surface
	}
	
	/*add_disc_func_ois_leg2(df_disc );//if endog we create a fwd_func and update surface

	if(endog_df)
		return;
	
	QL_REQUIRE(!null(df_fwd), "df_fwd is required for non self discounting ois");
		
	tenor_surface ts = create_tenor_surface_ois_leg2(df_fwd, null,ee);//a fwdfunc will be created
	this.swap_add_surface_leg2(ts);	*/
}

/*-----------------------------------------------------------------------
  add_curve_data_ois_leg1
  ----------------------------------------------------------------------*/
void swap_gen.add_curve_data_ois_leg1(	disc_func  df_disc,
										fwd_func option(nullable) f_fwd,
										logical		sync_endog_ok)
{
	error_info ee = new error_info(true,true);
	//logical ignore_idx_sprd = true;
	logical endog_df = this.is_endog_df_ois_leg1(ee);	
	QL_FAIL_COND(endog_df && !sync_endog_ok && !null(f_fwd), "ambigious input");

	tenor_surface ts;
	
	if(!endog_df) {
		add_disc_func_ois_leg1(df_disc, false ,ts);//ts will be null here since endog_df = false
		QL_REQUIRE(!null(f_fwd), "fwd_func_fwd is required for non self discounting ois");
		disc_func __dffwd;
		ts = create_tenor_surface_ois_leg1(__dffwd, f_fwd,true,ee);
		this.swap_add_surface_leg1(ts);
		return;
	}

	if(sync_endog_ok) {
		logical add_surf_if_endog = false;
		add_disc_func_ois_leg1(df_disc, add_surf_if_endog ,ts);//ts will be null here since add_surf_if_endog = false
		ts = create_tenor_surface_ois_leg1(df_disc, f_fwd,sync_endog_ok,ee);
		this.swap_add_surface_leg1(ts);
	}
	else {
		logical add_surf_if_endog = true;
		add_disc_func_ois_leg1(df_disc, add_surf_if_endog ,ts);//if endog we create a fwd_func and update surface
	}
		
	return;
}
/*-----------------------------------------------------------------------
  add_curve_data_ois_leg2
  ----------------------------------------------------------------------*/
void swap_gen.add_curve_data_ois_leg2(	disc_func  df_disc,
										fwd_func option(nullable) f_fwd,
										logical		sync_endog_ok) 	
{
	error_info ee = new error_info(true,true);
	//logical ignore_idx_sprd = true;
	logical endog_df = this.is_endog_df_ois_leg2(ee);	
	QL_FAIL_COND(endog_df && !sync_endog_ok && !null(f_fwd), "ambigious input");

	tenor_surface ts;
	
	if(!endog_df) {
		add_disc_func_ois_leg2(df_disc, false ,ts);//ts will be null here since endog_df = false
		QL_REQUIRE(!null(f_fwd), "fwd_func_fwd is required for non self discounting ois");
		disc_func __dffwd;
		ts = create_tenor_surface_ois_leg2(__dffwd, f_fwd,true,ee);
		this.swap_add_surface_leg2(ts);
		return;
	}

	if(sync_endog_ok) {
		logical add_surf_if_endog = false;
		add_disc_func_ois_leg2(df_disc, add_surf_if_endog ,ts);//ts will be null here since add_surf_if_endog = false
		ts = create_tenor_surface_ois_leg2(df_disc, f_fwd,sync_endog_ok,ee);
		this.swap_add_surface_leg2(ts);
	}
	else {
		logical add_surf_if_endog = true;
		add_disc_func_ois_leg2(df_disc, add_surf_if_endog, ts );//if endog we create a fwd_func and update surface
	}
}
/*-----------------------------------------------------------------------
  create_tenor_surface_ois_leg1	(fwd is a fwd_func)  EXT SWAP: ok
  ----------------------------------------------------------------------*/
tenor_surface swap_gen.create_tenor_surface_ois_leg1(	out disc_func  fwddf,
														out fwd_func fwdf1d,
														logical	 sync_endog_ok,
														error_info option(nullable) error)
{
	error_info ee 	= new error_info(true,true);
	logical is_proxy = this.is_approx_calc_ois_leg1(ee);

	..ir_index ir			= this.swap_ir_index_leg1(ee);
	CORE_INT.instr_fail_check(null(ir), "invalid ir_index", this, ee);
		
	return create_tenor_surface_ois_leg(ir,is_proxy ,fwddf,fwdf1d,sync_endog_ok,error);
	
}
/*-----------------------------------------------------------------------
  create_tenor_surface_ois_leg2	(fwd is a fwd_func)  EXT SWAP: ok
  ----------------------------------------------------------------------*/
tenor_surface swap_gen.create_tenor_surface_ois_leg2(	out disc_func  fwddf,
														out fwd_func  fwdf1d,
														logical	 sync_endog_ok,
														error_info option(nullable) error)
{
	error_info ee 	= new error_info(true,true);
	logical is_proxy = this.is_approx_calc_ois_leg2(ee);

	..ir_index ir			= this.swap_ir_index_leg2(ee);
	CORE_INT.instr_fail_check(null(ir), "invalid ir_index", this, ee);
		
	return create_tenor_surface_ois_leg(ir,is_proxy ,fwddf,fwdf1d,sync_endog_ok,error);	
}

/*-----------------------------------------------------------------------
  create_tenor_surface_ois_leg2	(fwd is a fwd_func)  EXT SWAP: ok
  ----------------------------------------------------------------------*/
tenor_surface swap_gen.create_tenor_surface_ois_leg(	..ir_index ir,
														logical is_proxy ,
														out disc_func  fwddf,
														out fwd_func  fwdf1d,
														logical	 sync_endog_ok,
														error_info option(nullable) error)
{
	try{
		
		error_info ee 	= new error_info(true,true);
		
		QL_FAIL_COND(null(fwddf) && null(fwdf1d),"invalid input",this,true);
		QL_FAIL_COND(!sync_endog_ok && !null(fwddf) && !null(fwdf1d),"ambigious input",this,true);

		logical ignore_idx_sprd = true;
		number sprd = ignore_idx_sprd ? 0 : ir.index_spread() ;
		
		if(is_proxy) {
			
			//[endog_= true]: surface is not strictly necessary but we fill it up --> allow disc_func in the surface to be used
			//[endog_= false]: ** here the disc_func in the surface is used to calc the fwd rates
			if(null(fwddf) && !null(fwdf1d)){
				date m = this.maturity(ee);
				fwddf = CORE_INT.create_disc_func_from_fwd_on(trade_date(),m,fwdf1d,ir.day_count_method(),ir.fixing_calendar(),true,sprd);
			}
			
			if(null(fwdf1d) && !null(fwddf)){
				//fwdf1d = fwd_func(fwddf,365,trade_date(),ir.day_count_method(),ir.fixing_calendar(),BD_FOLLOWING,false);
				date m = maturity(ee);				
				fwdf1d = CORE_INT.create_fwd_func_from_df_on(trade_date(), m,ir.fixing_calendar(),ir.day_count_method(), fwddf,true,sprd);
			}
			
			logical allow_extrap 	= false;
			return tenor_surface(this.trade_date(), fwddf,[fwdf1d],[ir],allow_extrap);

		}
		else  { 
			//[endog_= true]: ** fwd_func (1day) is used to calc the fwd rates, surface necessary (but not the surf.disc curve)
			//[endog_= false]: ** fwd_func (1day) is used to calc the fwd rates, surface necessary (but not the surf.disc curve)
			if(null(fwdf1d) && !null(fwddf)) {
				
				//fwdf1d = fwd_func(fwddf,365,trade_date(),ir.day_count_method(),ir.fixing_calendar(),BD_FOLLOWING,false);
				date m = maturity(ee);				
				fwdf1d = CORE_INT.create_fwd_func_from_df_on(trade_date(), m,ir.fixing_calendar(),ir.day_count_method(), fwddf,true,sprd);
			}
			
			if(null(fwddf))
				fwddf = disc_func_interp([1],[1],ip_linear());//df is not used but cannot be null in tenor_surface(...)
				
			logical allow_extrap = false;		
			return tenor_surface(this.trade_date(), fwddf,[fwdf1d],[ir],allow_extrap);
		}		
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_fixois.create_tenor_surface_ois_leg");
		return null<tenor_surface>;
	}
}


/*-----------------------------------------------------------------------
  index_dates_flt_leg	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_gen.index_dates_flt_leg(	logical 			leg1,//false for fixflt
									logical 			post_settle, 
									out vector(date) 	index_start_dates,									
									out vector(date) 	index_end_dates,
									out vector(logical)  index_regular,
									error_info option(nullable) 		error ) 
{	
	try{
		instr_error_type t;
   		string 			s;
		logical all_dates = false;
		i().__swap_index_dates(post_settle,index_start_dates,index_end_dates,index_regular, leg1,all_dates,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_gen.index_dates_flt_leg");
		if(e) {
			index_start_dates = index_end_dates = null<vector(date)>; 
			index_regular = null<vector(logical)>;
		}			
		return ;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.index_dates_flt_leg");
		index_start_dates = index_end_dates = null<vector(date)>; 
		index_regular = null<vector(logical)>; 
		return ;
	}
}

/*-----------------------------------------------------------------------
  df_shifted_fix_leg  prot
  ----------------------------------------------------------------------*/
disc_func swap_gen.df_shifted_fix_leg(	number 		delta_disc,
										disc_func 	df)
{
	
	if(delta_disc == 0)
		return df;

	error_info ee = new error_info(true,true);
	
	vector(date) accr_start_date,accr_end_date;
	vector(number)  accr_period;

	vector(date) accr_start_date_leg2;
	vector(date) accr_end_date_leg2;
	vector(number) accr_period_leg2;
	this.accr_dates(true, accr_start_date,accr_end_date,accr_period,
						accr_start_date_leg2,accr_end_date_leg2,accr_period_leg2, ee ) ;

	
	//this.accr_dates_fix_leg(	true,  accr_start_date,	 accr_end_date, accr_period,ee) ;	
	day_count_method dc = this.dc_method(ee);
					
	disc_func df_shifted = CORE_INT.fwd_parallell_shift_df(	df, delta_disc, this.trade_date(ee), accr_start_date, accr_end_date, dc);
	return df_shifted;
	
}
/*-----------------------------------------------------------------------
  df_shifted_disc_rates_flt_leg  prot
  ----------------------------------------------------------------------*/
disc_func swap_gen.df_shifted_disc_rates_flt_leg(	logical 	leg1,
													number 		delta_disc,
													disc_func 	df)
{
	if(delta_disc == 0)
		return df;

	error_info ee = new error_info(true,true);

	vector(date) 	d1,d2;
	swap_gen.cash_flow_dates(true, d1, d2,ee );
	vector(date) d = leg1 ? d1 : d2;
	
	integer  size = v_size(d);
	vector(date) r_start_dates[size];	
	vector(date) r_end_dates[size];
	r_start_dates[0] = this.settle_date();
	r_end_dates[0] = d[0];
	for(integer i=1;i<size;i++){
		r_start_dates[i] 	= d[i-1];
		r_end_dates[i] 		= d[i];
	}

	day_count_method dc1,dc2;
	swap_gen.dc_method(dc1,dc2,ee);
	
	day_count_method dc = leg1 ? dc1 : dc2;

					
	disc_func df_shifted = CORE_INT.fwd_parallell_shift_df(	df, delta_disc, this.trade_date(ee), r_start_dates, r_end_dates, dc);

	//
	//vector(number) r = df_shifted.simple_rate(this.trade_date(ee),r_start_dates,r_end_dates,dc);
		
	return df_shifted;
	
}

/*-----------------------------------------------------------------------
  df_shifted_idx_rates_flt_leg  prot
  ----------------------------------------------------------------------*/
disc_func swap_gen.df_shifted_idx_rates_flt_leg(logical 	leg1,
												number 		delta_disc,
												disc_func 	df)
{
	if(delta_disc == 0)
		return df;

	error_info ee = new error_info(true,true);
	
	vector(date) index_start_dates,index_end_dates;
	vector(logical) index_regular;
	this.index_dates_flt_leg(leg1, true ,index_start_dates,index_end_dates,index_regular,ee ) ;
	
	..ir_index ir 		= leg1 ? swap_gen.swap_ir_index_leg1(ee): swap_gen.swap_ir_index_leg2(ee);
	CORE_INT.instr_fail_check(null(ir), "invalid ir_index", this, ee);
	
	day_count_method dc = ir.day_count_method();
					
	disc_func df_shifted = CORE_INT.fwd_parallell_shift_df(	df, delta_disc, this.trade_date(ee), index_start_dates, index_end_dates, dc);

	//
	//vector(number) r = df_shifted.simple_rate(this.trade_date(ee),index_start_dates,index_end_dates,dc);
		
	return df_shifted;
	
}

/*-----------------------------------------------------------------------
  fwd_shifted_flt_leg		
  ----------------------------------------------------------------------*/
tenor_surface swap_gen.fwd_shifted_flt_leg(	logical 		leg1,
											number 			delta_fwd,
											disc_func 		df,							
											tenor_surface 	ts)
{	
	if(delta_fwd == 0)
		return ts;

	error_info ee = new error_info(true,true);
	tenor_code tc = leg1 ? this.swap_index_tenor_code_leg1(ee): this.swap_index_tenor_code_leg2(ee);
	CORE_INT.instr_fail_check(null(tc), "invalid index tenor code", this, ee);
	
	if(!ts.fwd_is_disc_func()) {
		fwd_func  fwdf 			= ts.fwd_curve_f(tc);
		fwd_func fwd_delta 		= CORE_INT.fwd_parallell_shift_f(fwdf,delta_fwd);
		return create_tenor_surface_flt_leg(leg1, df,fwd_delta);			
	}
	else {						
		disc_func fwddf 		= ts.fwd_curve_d(tc);		
		disc_func fwddf_delta 	= df_shifted_idx_rates_flt_leg(leg1,delta_fwd, fwddf);		
		return create_tenor_surface_flt_leg(leg1, df,fwddf_delta);
	}
}

/*-----------------------------------------------------------------------
  create_tenor_surface	(fwd is a fwd_func)  EXT SWAP: ok
  ----------------------------------------------------------------------*/
tenor_surface swap_gen.create_tenor_surface_flt_leg(logical 		leg1,
													disc_func 		df,
													fwd_func 		fwdf,
													error_info option(nullable) error)
{
	try{
		
		error_info ee 	= error_info(true,true);
		..ir_index ir 	= leg1 ? swap_gen.swap_ir_index_leg1(ee): swap_gen.swap_ir_index_leg2(ee);
		CORE_INT.instr_fail_check(null(ir), "invalid ir_index", this, ee);
	
		logical allow_extrap 	= false;		
		return tenor_surface(trade_date(), df,[fwdf],[ir],allow_extrap);
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.create_tenor_surface_flt_leg");
		return null<tenor_surface>;
	}
}
/*-----------------------------------------------------------------------
  create_tenor_surface	(fwd is a disc_func) EXT SWAP: ok
  ----------------------------------------------------------------------*/
tenor_surface swap_gen.create_tenor_surface_flt_leg(logical 		leg1,
													disc_func 		df,
													disc_func 		fwddf,
													error_info option(nullable) error)
{
	try{
		
		error_info ee 	= error_info(true,true);
		..ir_index ir 	= leg1 ? swap_gen.swap_ir_index_leg1(ee): swap_gen.swap_ir_index_leg2(ee);
		CORE_INT.instr_fail_check(null(ir), "invalid ir_index", this, ee);
		
		logical allow_extrap 	= false;		
		return tenor_surface(trade_date(), df,[fwddf],[ir],allow_extrap);
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.create_tenor_surface_flt_leg");
		return null<tenor_surface>;
	}
}

/*-----------------------------------------------------------------------
  imp_spread_flt_leg    EXT SWAP: ok
  ----------------------------------------------------------------------*/
number  swap_gen.imp_spread_flt_leg(logical 		leg1,
									number 				pv,
									logical option(nullable) trade_date_pv,
									error_info option(nullable) error) 
{	
	try{	
		instr_error_type t;
   		string 			s;	
		number c = i().__swap_imp_flt_sprd(pv,trade_date_pv,leg1,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_gen.imp_spread_flt_leg");	
		return e ? null<number>: c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.imp_spread_flt_leg");		
		return null<number>;
	}
}
/*-----------------------------------------------------------------------
  mtm_helper    EXT SWAP: ok
  ----------------------------------------------------------------------*/
void swap_gen.mtm_helper(	number 	option(nullable) fx_spot,  //leg1=price_ccy, leg2=flat=base_ccy
							string 	option(nullable) fx_base_ccy,
							string 	option(nullable) fx_price_ccy,
							out number fx_spot_leg1_is_base)
{
	fx_spot_leg1_is_base = null;
	if(!null(fx_spot)) {

		QL_REQUIRE(!null(fx_base_ccy),"fx_base_ccy required when fx_spot is input (mtm)");
		QL_REQUIRE(!null(fx_price_ccy),"fx_price_ccy required when fx_spot is input (mtm)");
		
		error_info ee = new error_info(true,true);
		string ccy_leg1, ccy_leg2;		
		this.currency(ccy_leg1, ccy_leg2 ,ee);
		
		if(equal_casei(fx_base_ccy, ccy_leg1)){
			QL_FAIL_COND(!equal_casei(fx_price_ccy, ccy_leg2),"invalid fx price currency (mtm)" ,this,true );
			fx_spot_leg1_is_base = fx_spot;
		}
		else if(equal_casei(fx_base_ccy, ccy_leg2)){
			QL_FAIL_COND(!equal_casei(fx_price_ccy, ccy_leg1),"invalid fx price currency (mtm)" ,this,true );
			fx_spot_leg1_is_base = 1.0/fx_spot;
		}
		else {
			QL_FAIL("invalid currency (mtm)" ,this,true );		
		}
	}
}

/*-----------------------------------------------------------------------
  is_mtm_leg1	EXT SWAP: ok
  ----------------------------------------------------------------------*/
logical  swap_gen.is_mtm_leg1(error_info option(nullable) error) 
{	
	try{
		instr_error_type t;
   		string 			s;	
		logical c = i().__ccbs_is_mtm_leg1(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_gen.is_mtm_leg1");
		return e ? null : c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.is_mtm_leg1");		
		return null;
	}
}

/*-----------------------------------------------------------------------
  is_mtm_leg1	EXT SWAP: ok
  ----------------------------------------------------------------------*/
logical  swap_gen.is_mtm_leg2(error_info option(nullable) error) 
{	
	try{
		instr_error_type t;
   		string 			s;	
		logical c = i().__ccbs_is_mtm_leg2(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_gen.is_mtm_leg2");
		return e ? null : c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_gen.is_mtm_leg2");		
		return null;
	}
}
/*-----------------------------------------------------------------------
  reset_mtm
  ----------------------------------------------------------------------*/
void swap_gen.reset_mtm()
{
	try {
		error_info ee = error_info(true,true);
	
		if(this.is_mtm_leg1(ee) || this.is_mtm_leg2(ee))
			i().__swap_reset_mtm_data();
	}
	catch {}
}	

