option(null: hard);	
/*	
	instrument wrapper functions
	Developer: Algorithmica Research, Magnus Nyström			

INCOMPLETE

	--------------------------------------------------------------------
	oisois
	--------------------------------------------------------------------
*/

//----------------------------------------------------------------------
//  class swap_oisois
//----------------------------------------------------------------------
class swap_oisois: public swap_gen
option(category: "Instrument/Interest Rate Swap/ONIndex vs ONIndex")
//option(allow_undeclared_mfuncs)
{
public:
    //override string			instr_type_s();
	override instrument 	inst();
	override swap_oisois 	clone() ;

	override void         __dbg_print(__dbg_label);
    override void         __dbg_browse(__dbg_split);
	
	/*----------ADD FUNCS [PUBLIC]---------------*/
	void 		add_quote(number,..quote_style );//???i.e. means add new cpn --> should be a new instrument
	override void 		add_quote(number);
	void 		add_notional(number );
	void 		add_notional(number , number);
	void		add_fx_rate(number,logical,string,string );
	void 		add_fx_mult_leg1(number );
	void 		add_fx_mult_leg2(number );
	void 		add_disc_func(disc_func ); 
	void 		add_disc_func_leg1(disc_func );//note disc_func for mtm-feature not added here
	void 		add_disc_func_leg2(disc_func );//note disc_func for mtm-feature not added here
	void 		add_surface_leg1(tenor_surface option(nullable));
	void 		add_surface_leg2(tenor_surface option(nullable));
	void		add_fixing_leg1(vector(date) ,vector(number) ,logical option(nullable) fixing_as_fwd = false);
	void		add_fixing_leg2(vector(date) ,vector(number) ,logical option(nullable) fixing_as_fwd = false);
	void		add_fixing_leg1(number ,logical option(nullable) fixing_as_fwd = false);
	void		add_fixing_leg2(number ,logical option(nullable) fixing_as_fwd = false);
	void 		add_data( 	number,disc_func,tenor_surface ,vector(date),vector(number) ,tenor_surface ,vector(date),
							vector(number) ,logical option(nullable) fixing_as_fwd = false,logical upd_null_crv = false,logical upd_null_fix = false);		
	void		add_ccy_data(number,disc_func,number,tenor_surface,vector(date),vector(number) ,number ,
							disc_func ,number,tenor_surface,vector(date) ,vector(number) ,
							logical option(nullable) fixing_as_fwd = false,logical upd_null_crv = false,logical upd_null_fix = false) ;						
	void		add_mtm_data(number option(nullable),number option(nullable)	,string option(nullable)	,string option(nullable)	,
							 disc_func option(nullable) ,disc_func option(nullable) ) ;
	
	
	/*----------MISC FUNCS [PUBLIC]---------------*/

	date 			start_date(error_info option(nullable) error = null<error_info> );				/*name change of issuedate*/
	override void	final_pmt_date(out date ,out date ,error_info option(nullable) error = null); 

	//logical		is_par_flat(error_info option(nullable) error = null<error_info>);
	logical			is_cross_currency(error_info option(nullable) error = null<error_info>);
	logical 		pay_leg1(error_info option(nullable) error = null<error_info> );	
	void 			is_regular_first(out logical , out logical ,error_info option(nullable) error = null<error_info> );				
	void 			is_regular_last(out logical , out logical ,error_info option(nullable) error = null<error_info> );		
	override void 	notional(out number , out number ,error_info option(nullable) error = null<error_info> );
	number 			notional(error_info option(nullable) error = null<error_info>);
	override void 	fx_mult_factor(out number , out number ,error_info option(nullable) error = null<error_info> );
	override void 	currency(out string , out string ,error_info option(nullable) error = null<error_info> );
	override void 	coupon(out number  ,out number  ,error_info option(nullable) error = null<error_info> );
	override void	coupon_freq(out integer,out integer,error_info option(nullable) error = null<error_info> );
	override void 	reset_freq(out integer,out integer,error_info option(nullable) error = null<error_info> );	
	override void 	dc_method(	out day_count_method , out day_count_method ,error_info option(nullable) error = null<error_info> );								
	override void  	pmt_bus_day(out bd_convention , out bd_convention ,error_info option(nullable) error = null<error_info> );		
	override void 	roll_day(out integer,out integer,error_info option(nullable) error = null<error_info> );
	override void 	eom(out logical ,out logical ,error_info option(nullable) error = null<error_info> );
	override void 	calendar(out ..calendar ,out ..calendar ,error_info option(nullable) error = null<error_info> );
	override void 	quote(out number  ,out number  ,error_info option(nullable) error = null<error_info> );
	override number quote(error_info option(nullable) error = null<error_info> );
	override void  	first_cpn_date(	out date , out date , error_info option(nullable) error = null<error_info>);
	override void  	last_reg_cpn_date(	out date , out date , error_info option(nullable) error = null<error_info>);
	override void  	effective_date(	out date , out date , error_info option(nullable) error = null<error_info>);

	void 			pmt_lag(out	integer 	pmt_lag_leg1,
							out	integer 	mat_pmt_lag_leg1,
							out	integer 	pmt_lag_prin_leg1,
							out	integer 	mat_pmt_lag_prin_leg1,
							out	integer 	pmt_lag_leg2,
							out	integer 	mat_pmt_lag_leg2,
							out	integer 	pmt_lag_prin_leg2,
							out	integer 	mat_pmt_lag_prin_leg2,	
							error_info option(nullable) error) ;
	
	override string settle_code(error_info option(nullable) error = null<error_info> );	
	/*----------CASHFLOW FUNCS [PUBLIC]---------------*/
	
	override void	cash_flow_dates(logical,out vector(date) ,out vector(date) ,error_info option(nullable) error = null<error_info> ) ;
	void			prin_cash_flow_dates(logical,out vector(date) ,out vector(date) ,error_info option(nullable) error = null<error_info> ) ;
	override void	cash_flows_cpn(logical,out vector(number) ,out vector(number),error_info option(nullable) error = null<error_info> );
	override void	cash_flows(logical,out vector(number) ,out vector(number),error_info option(nullable) error = null<error_info> );
	override void	cash_flow_data(logical,ir_cf_code cf_code,out vector(date)  ,out vector(number)  ,
											out vector(date)   ,out vector(number)  ,error_info option(nullable) error = null<error_info> );
	override void 	cash_flow_data(logical,logical option(nullable),out vector(date)  ,out vector(number) ,
											out vector(number)  ,out vector(number)  ,
											out vector(number)  ,out vector(number)  ,
											out vector(number) ,out vector(date)  	,
											out vector(number)  ,out vector(number)  ,
											out vector(number)  ,out vector(number)  ,
											out vector(number)  ,out vector(number)  ,
											error_info option(nullable) error = null<error_info> );

	swap_ois_leg_data	data_leg1(logical,error_info option(nullable) error = null<error_info>);
	swap_ois_leg_data	data_leg2(logical,error_info option(nullable) error = null<error_info>);
	/*----------PV FUNCS [PUBLIC]---------------*/
	override number  	present_value(	disc_func option(nullable),disc_func option(nullable),out number  , out number  ,
									number option(nullable),logical option(nullable) trade_date_pv = false,
									error_info option(nullable) error = null<error_info>);
	
	override number  	present_value(	disc_func option(nullable),disc_func option(nullable),out number  ,out number  ,
									date option(nullable) ,date option(nullable) ,
									logical,logical  ,error_info option(nullable) error = null<error_info>);
	
	override number  	present_value(	out number  ,out number  pv_ois_leg,
									logical option(nullable) ,error_info option(nullable) error = null<error_info> );
	
	override number 	accrued(logical,out number,out number,error_info option(nullable) error = null<error_info>);

	override void 		accrued_period(out number ,out number , out integer,out integer,
								   error_info option(nullable) error = null<error_info>);

	override number 	accrued_chg  (integer bus_days, out number 	,out number ,
										out number 	,out number  ,
										out date  ,out date  ,error_info option(nullable) error = null<error_info> ); 

	//void			implied_par_funcs(	...)
	
	override number		solver(number,swap_solver_code ,logical option(nullable) trade_date_pv = false,
									error_info option(nullable) error = null<error_info>);

	/*
	 number  		pvbp_curve(	number option(nullable) ,number option(nullable),number option(nullable) ,number option(nullable) ,
										logical option(nullable) ,out number  ,out number ,
										error_info option(nullable) error = null<error_info> ) ;

	*/
	/*----------LEG1/LEG2 FUNCS [PUBLIC]---------------*/
	integer  			rfr_arrears_days_leg1(error_info option(nullable) error = null<error_info>);
	rfr_arrears_type  	rfr_arrears_type_leg1(error_info option(nullable) error = null<error_info>);
	flt_avg_method  	avg_method_leg1(error_info option(nullable) error = null<error_info>);
	flt_sprd_comp_method  sprd_comp_method_leg1(error_info option(nullable) error = null<error_info>);
	flt_comp_avg_type  	comp_avg_type_leg1(error_info option(nullable) error = null<error_info>);

	integer  			rfr_arrears_days_leg2(error_info option(nullable) error = null<error_info>);
	rfr_arrears_type  	rfr_arrears_type_leg2(error_info option(nullable) error = null<error_info>);
	flt_avg_method  	avg_method_leg2(error_info option(nullable) error = null<error_info>);
	flt_sprd_comp_method  sprd_comp_method_leg2(error_info option(nullable) error = null<error_info>);
	flt_comp_avg_type  	comp_avg_type_leg2(error_info option(nullable) error = null<error_info>);
	
	interest_rule  ir_rule_leg1(error_info option(nullable) error= null<error_info>);
	interest_rule  ir_rule_leg2(error_info option(nullable) error= null<error_info>);
	
	logical  			is_endog_df_leg1(error_info option(nullable) error = null<error_info>);
	logical  			is_endog_df_leg2(error_info option(nullable) error = null<error_info>);
	logical  			is_approx_calc_leg1(error_info option(nullable) error = null<error_info>);
	logical  			is_approx_calc_leg2(error_info option(nullable) error = null<error_info>);
	
	logical  		is_mtm_leg1(error_info option(nullable) error= null<error_info> );
	logical  		is_mtm_leg2(error_info option(nullable) error= null<error_info> ) ;
	number			spread_leg1(error_info option(nullable) error = null<error_info> );
	number			spread_leg2(error_info option(nullable) error = null<error_info> );

	override void			accr_dates(logical,out vector(date) ,out vector(date) ,out vector(number),
							   out vector(date) ,out vector(date) ,out vector(number),
								error_info option(nullable) error = null<error_info> ) ;
	
	
	void			index_dates_leg1(logical,logical,out vector(date) ,out vector(date) ,
												out vector(logical)  ,error_info option(nullable) error = null<error_info> ) ;

	void			index_dates_leg2(logical,logical,out vector(date) ,out vector(date) ,
												out vector(logical)  ,error_info option(nullable) error = null<error_info> ) ;

	void			fixing_data_leg1(logical ,logical option(nullable),out vector(date)  ,									
												out vector(number)  ,out vector(logical) ,
												error_info option(nullable) error = null<error_info> ) ;
		
	void			fixing_data_leg2(logical ,logical option(nullable),out vector(date)  ,									
												out vector(number)  ,out vector(logical) ,
												error_info option(nullable) error = null<error_info> ) ;

	void			current_fixings_leg1(logical,out vector(date),out vector(number) ,out vector(logical),
										error_info option(nullable) error = null<error_info>);
	void			current_fixings_leg2(logical,out vector(date),out vector(number) ,out vector(logical),
										error_info option(nullable) error = null<error_info>);
	
	number			imp_spread_leg1(number,logical option(nullable) trade_date_pv = false,error_info option(nullable) error = null<error_info>);
	number			imp_spread_leg2(number,logical option(nullable) trade_date_pv = false,error_info option(nullable) error = null<error_info>);

	disc_func 		disc_func_leg1(error_info option(nullable) error = null<error_info> ) ;
	disc_func 		disc_func_leg2(error_info option(nullable) error = null<error_info> ) ;
	tenor_surface 	tenor_surface_leg1(error_info option(nullable) error = null<error_info>);
	tenor_surface 	tenor_surface_leg2(error_info option(nullable) error = null<error_info>);
	ir_index 		ir_index_leg1(error_info option(nullable) error = null<error_info> ); 
	ir_index 		ir_index_leg2(error_info option(nullable) error = null<error_info> ); 	
	string 			index_tenor_leg1(error_info option(nullable) error = null<error_info> ) ;
	string 			index_tenor_leg2(error_info option(nullable) error = null<error_info> ) ;
	tenor_code 		index_tenor_code_leg1(error_info option(nullable) error = null<error_info> ) ;
	tenor_code		index_tenor_code_leg2(error_info option(nullable) error = null<error_info> ) ;

	//tenor_surface create_tenor_surface_leg1(disc_func ,fwd_func );
	tenor_surface 	create_tenor_surface_leg1(disc_func ,disc_func );
	//tenor_surface create_tenor_surface_leg2(disc_func ,fwd_func );
	tenor_surface 	create_tenor_surface_leg2(disc_func ,disc_func );					

	number			pv01_spread_leg1(number option(nullable)= null<number>,number option(nullable)= null<number>,
										disc_func option(nullable) df = null<disc_func>,
										error_info option(nullable) error = null<error_info>);
	
	number			pv01_spread_leg2(number option(nullable)= null<number>,number option(nullable)= null<number>,
										disc_func option(nullable) df = null<disc_func>,
										error_info option(nullable) error = null<error_info>);

	void 			payment_data_leg1(	logical,logical option(nullable),out vector(date) ,out vector(number) ,
										out vector(logical) ,out vector(date),out vector(number) ,out vector(number) ,out vector(number) ,
										out vector(number) ,out vector(number),out vector(number) ,
										error_info option(nullable)  error = null<error_info>) ;

	void 			principal_data_leg1(logical,logical option(nullable) ,logical ,
										out vector(date),out vector(number),out vector(number) ,
										error_info option(nullable)  error  = null<error_info>);

	void 			payment_data_leg2(logical,logical option(nullable),out vector(date) ,out vector(number) ,
										out vector(logical) ,out vector(date),out vector(number) ,out vector(number) ,out vector(number) ,
										out vector(number) ,out vector(number),out vector(number) ,
										error_info option(nullable)  error = null<error_info>) ;

	void 			principal_data_leg2(logical,logical option(nullable) ,logical ,
										out vector(date),out vector(number),out vector(number) ,
										error_info option(nullable)  error  = null<error_info>);
	
	/*-----external swap specific-----*/
	override ql_fixed_income_swap 	swap_instrument(error_info option(nullable) error = null<error_info>) ;	
	override instrument_type 		swap_type(error_info option(nullable) error = null<error_info>);
	vector(ql_ois_leg) 		ois_legs(logical,error_info option(nullable) error = null<error_info>);
	vector(ql_swap_leg) 	legs(logical,error_info option(nullable) error = null<error_info>);
	ql_ois_leg 				ois_leg2(logical,error_info option(nullable) error = null<error_info>);
	ql_ois_leg 				ois_leg1(logical,error_info option(nullable) error = null<error_info>);

	/*---set functions-required--*/
	override swap_oisois	set_quote(number option(nullable),error_info option(nullable) error = null<error_info>);
	override swap_oisois	set_quote(string option(nullable),error_info option(nullable) error = null<error_info>);
	
	
	/*-----set functions-if applicable-----*/
	//swap_oisois			set_spread_leg1(number option(nullable) ,error_info option(nullable) error = null<error_info>);
	//swap_oisois			set_spread_leg2(number option(nullable) ,error_info option(nullable) error = null<error_info>);
	
	//local set funcs
	swap_oisois 			set_date(date,date option(nullable) settle_date=null<date>, error_info option(nullable) error = null<error_info>);
	override swap_oisois	set_date(date,date option(nullable),logical,logical ,error_info option(nullable) error = null<error_info> );
	//void					update_to_par(error_info option(nullable) error = null<error_info> );
	swap_oisois				set_pay_leg(logical ,error_info option(nullable) error = null<error_info>);
	//---------------------------------

	//--------------------------------------------------------------------------
	//----------HIDDEN FUNCS [PUBLIC]--(mostly for backward compat)-------------
	//--------------------------------------------------------------------------
	swap_oisois(__instrument);
	//general-one per leg
	/*override calendar 		calendar(integer ,error_info option(nullable) error = null<error_info>  );		
	override calendar 		calendar(error_info option(nullable) error = null<error_info>  );				
	override string 		calendar_name(integer, error_info option(nullable) error = null<error_info> );	
	override string 		calendar_name(error_info option(nullable) error = null<error_info> );			
					
	override logical 		eom(error_info option(nullable) error = null<error_info>);						
	override integer		roll_day(error_info option(nullable) error = null<error_info>);					
	override bd_convention 	pmt_bus_day(error_info option(nullable) error = null<error_info> );				
	override string 		currency(error_info option(nullable) error = null<error_info> );				
	override day_count_method dc_method(error_info option(nullable) error = null<error_info> );										
	override integer 		coupon_freq(error_info option(nullable) error = null<error_info> );				
	override number 		coupon(error_info option(nullable) error = null<error_info> );					
	override number 		nominal(error_info option(nullable) error = null<error_info> );					
	override date 			first_cpn_date(error_info option(nullable) error = null<error_info>);			
	override date 			last_reg_cpn_date(error_info option(nullable) error = null<error_info>);		
	override date 			cpn_start_date(error_info option(nullable) error = null<error_info>);	*/		
	//general-one per swap
	//override date 			issue_date(error_info option(nullable) error = null<error_info> ); 				
				
	override ir_index 		ir_index(error_info option(nullable) error = null<error_info> ); /*hidden, not visible in root*/

	swap_oisois(swap_oisois );
protected:
	override swap_oisois	create(__instrument option(nullable),out instr_error ,error_type type = E_INVALID_ARG);
	swap_oisois				err_type(swap_oisois option(nullable), error_info option(nullable) error = null<error_info>);

	//add
	override void 			add_quote(number,logical option(nullable ));
	override void 			add_nominal(number );

	//general
	/*
	override number 		present_value(	number option(nullable) nom=null<number>, logical dtt = false,
												disc_func option(nullable) dfd = null<disc_func>, 
												error_info option(nullable) error = null<error_info>);
	
	override number 		present_value(	disc_func,number option(nullable) nom=null<number>,logical dtt = false,
												disc_func option(nullable) dfd = null<disc_func>, 
												error_info option(nullable) error = null<error_info>);

	override number 		accrued(logical disable_rounding = false,logical in_pcnt = true,error_info option(nullable) error = null<error_info>);

	override number 		accrued_period(out integer,error_info option(nullable) error = null<error_info>);		
	
	override number 		accrued_chg(integer,out number ,out date , 
										out date ,logical in_pcnt = true,error_info option(nullable) error = null<error_info> ) ;*/

	//disc_func 			df_pvbp_leg_delta(number,disc_func,logical);
	//tenor_surface 		ts_pvbp_leg_delta_fwd(number ,disc_func,tenor_surface,logical);
	
	
	
	//cashflow
	/*override vector(date)	cash_flow_dates(logical post_settle = true, logical a = true, logical k = false, 
											error_info option(nullable) error = null<error_info>);
	override vector(number)	cash_flows_cpn(number option(nullable) nom = null<number>,logical posts = true,
												logical k = false,error_info option(nullable) error = null<error_info>);

	override void 			cash_flows(	out vector(date) , out vector(number)  ,
										number option(nullable) notional = null<number>,
										logical post_settle = true ,											
										error_info option(nullable) error = null<error_info> );			

	override vector(date)		cash_flow_dates_noadj(logical post_settle = true ,
													  error_info option(nullable) error = null<error_info>);				
	
	override vector(number)		cash_flow_amounts(	number option(nullable) nom = null<number>,
													logical post_settle = true,
													logical keep_size = false,
													error_info option(nullable) error = null<error_info> );			
	
	override vector(number)		cash_flow_nom_amounts(	number option(nullable) notional = null<number>,
														logical post_settle = true,
														logical keep_size = false,
														error_info option(nullable) error = null<error_info> );	
	
	override vector(number)	cash_flows(number option(nullable) nom = null<number>,logical posts = true,
											logical k = false,error_info option(nullable) error = null<error_info>);
	
	override void 			cash_flow_data(	number option(nullable) ,logical ,ir_cf_code ,logical,
												logical ,out vector(date)  ,
												out vector(number)  ,error_info option(nullable) error = null<error_info>);*/

	override number 		pvbp(number option(nullable),number option(nullable),logical option(nullable),
										logical option(nullable),	error_info option(nullable) error = null<error_info>) ; 
	override number 		pvbp(number option(nullable) ,number  option(nullable) ,error_info option(nullable) error = null<error_info>);
	
	//set funcs
	//override swap_oisois	set_date(date,date option(nullable),logical,logical ,error_info option(nullable) error = null<error_info> );							
	override swap_oisois	set_date(date,logical ,error_info option(nullable) error = null<error_info> );							/*legacy*/
	override swap_oisois	move_date(	date,date option(nullable) s=null<date> , error_info option(nullable) error = null<error_info>);	/*legacy*/

	void  					get_legs(	out ql_ois_leg,out ql_ois_leg );
	//logical ext_swap_;
	//logical ccy_swap_;
	//logical full_swap_;
};

//------------------------------------------------
// __dbg_print
//------------------------------------------------
void swap_oisois.__dbg_print(__dbg_label l)
{
	error_info ee 	= new error_info(true,false);
    l.set_text(strcat([
						"name: ",
						name(ee),
						",  ext_swap: ",
						null(ext_swap_) ? "" : string(ext_swap_),
                        ", ccy_swap: ",
						null(ccy_swap_) ? "" : string(ccy_swap_),
						", valid: ",
						null(this.is_valid(ee)) ? "" : string(this.is_valid(ee))
					]));
}
//------------------------------------------------
// __dbg_browse
//------------------------------------------------
void swap_oisois.__dbg_browse(__dbg_split s)
{
    s.resize(4);

	error_info ee 	= new error_info(true,false);
	
    s.set_text(0, "name");
    s.set_value(0, this.name(ee));

    s.set_text(1, "ext_swap");
    s.set_value(1, ext_swap_);

    s.set_text(2, "ccy_swap");
    s.set_value(2, ccy_swap_);
	
	s.set_text(3, "valid");
    s.set_value(3, this.is_valid(ee));

}

//------------------------------------------------
// copy constructor
//------------------------------------------------
swap_oisois.swap_oisois(swap_oisois c) : swap_gen(c) {}
//------------------------------------------------
// constructor [HIDDEN, cannot be protected]
//------------------------------------------------
swap_oisois.swap_oisois(__instrument i) option(hidden): swap_gen(i)
{
	//try {
		error_info ee 	= new error_info(true,false);
		if(!this.is_valid(ee)) {
			ext_swap_ = ccy_swap_ = full_swap_ = false;
			return;
		}
		ext_swap_ 		= this.is_ext_swap(ee);
		ccy_swap_ 		= this.is_ccy_swap(ee);
		full_swap_		= this.verify_full_swap(true,ee);
		return;									
	//}
	//catch {		
	//	CORE_INT.write_warning_message(err.message());
	//}
}
//------------------------------------------------
// instr_type_s
//------------------------------------------------
//string swap_oisois.instr_type_s() 	{ return string(..instr_type.SWAP_OISOIS);}
//------------------------------------------------
// inst
//------------------------------------------------
instrument 	swap_oisois.inst()		{ return this;}

//------------------------------------------------
// copy constructor <FUNCTION>
//------------------------------------------------
swap_oisois swap_oisois(swap_oisois b)			{ return new swap_oisois(b);}
//------------------------------------------------
// clone
//------------------------------------------------
swap_oisois swap_oisois.clone() 	{ return new swap_oisois(this);}

//------------------------------------------------
// create  [PROTECTED]
// create swap_oisois from internal instrument
//------------------------------------------------
swap_oisois swap_oisois.create(	__instrument option(nullable) c,
								out instr_error  error,
								error_type type )
{
	QL_FAIL_COND(null(c), "invalid/unknown (null) instrument",type );

	logical valid = c.is_valid(error);
	if( !valid && INSTR_CREATE_NULL_ERR)
		return null<swap_oisois>; 
	
	..instr_type it = c.instr_type(error);
	QL_FAIL_COND(null(it), "invalid instrument type (unknown)",type );
	QL_FAIL_COND(it != ..instr_type.SWAP_OISOIS, "invalid instrument type",type );//should not happen
	
	return new swap_oisois(c);
}

/*-----------------------------------------------------------------------
  function: create_swap_oisois
  ----------------------------------------------------------------------*/
swap_oisois create_swap_oisois(	__instrument option(nullable) c,
									out instr_error  error,
									error_type type = E_INVALID_ARG)
option(com_name: 'INTERNAL_create_swap_oisois')
{
	QL_FAIL_COND(null(c), "invalid/unknown (null) instrument",type );

	logical valid = c.is_valid(error);
	if( !valid && INSTR_CREATE_NULL_ERR)
		return null<swap_oisois>; 
	
	..instr_type it = c.instr_type(error);
	QL_FAIL_COND(null(it), "invalid instrument type (unknown)",type );
	QL_FAIL_COND(it != ..instr_type.SWAP_OISOIS, "invalid instrument type",type );//should not happen
	
	return new swap_oisois(c);
}
swap_oisois create_swap_oisois(	__instrument option(nullable) 		c,
								error_info option(nullable) 		error,
								error_type 							type = E_INIT)
option(com_name: 'INTERNAL_create_swap_oisois_ei')
{
	instr_error ee 	= instr_error();
	swap_oisois b 	= create_swap_oisois(c,ee, E_INIT);
	if(ee.is_error())
		CORE_INT.add_error_info(error,ee.type(),ee.message(), "create_swap_oisois");
	return b;
}

//-----------------------------------------------
// dynamic cast <FUNCTION>   EXT SWAP: ok
//-----------------------------------------------
swap_oisois swap_oisois(instrument i, error_info option(nullable) error = null<error_info>) 	
option (category: 'Instrument/Interest Rate Swap/ONIndex vs ONIndex')
option(com_name: 'swap_oisois_dyncast')
{ 
	try {
		swap_oisois d = dynamic_cast<swap_oisois>(i); 
		if(null(d))
			CORE_INT.add_error_info(error,ERR_T_INIT,"invalid cast (instrument is not a swap_oisois)","swap_oisois" );

		return d;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_oisois");
		return null<swap_oisois>;
	}
}

/*-----------------------------------------------------------------------
  err_type		EXT SWAP: ok
  ----------------------------------------------------------------------*/
swap_oisois swap_oisois.err_type(swap_oisois option(nullable) nul, error_info option(nullable) error)
{	
	CORE_INT.add_error_info(error,ERR_T_CALC,"mwlib(ql) error: inapplicable function call for current instrument type");	
	return null<swap_oisois>;
}

/*-----------------------------------------------------------------------
  pay_leg1  EXT SWAP: ok
  ----------------------------------------------------------------------*/
logical	 swap_oisois.pay_leg1(error_info option(nullable) error )
{
	try {	
		return swap_gen.swap_payleg1(error);
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_oisois.pay_leg1");		
		return null<logical>;
	}
}

/*-----------------------------------------------------------------------
  add_quote		EXT SWAP OISOIS: NOT ok
  ----------------------------------------------------------------------*/
void swap_oisois.add_quote(	number  quote,
							logical option(nullable) set_to_par ) 
{	
	QL_FAIL_COND(!null(set_to_par),"set_to_par is not applicable for ois");
	this.add_quote(quote);
	return ;					
	
}
/*-----------------------------------------------------------------------
  add_quote		EXT SWAP OISOIS: NOT ok
  ----------------------------------------------------------------------*/
void swap_oisois.add_quote(	number  quote ) 
{	
	instrument.add_quote(quote, false);
	return ;					
	
}
/*-----------------------------------------------------------------------
  add_quote		EXT SWAP: ok
  ----------------------------------------------------------------------*/
void swap_oisois.add_quote(	number  quote,
							..quote_style quote_style) 
{
	error_info ee = new error_info(true,true);
	..quote_style qs = instrument.quote_style_e(ee);
	
	if(quote_style == qs)
		this.add_quote(quote);
	else{
		if(quote_style == ..quote_style.SPREAD_BP)
			this.add_quote(quote*10000);//instr quotestyle must be bp
		else if(quote_style == ..quote_style.SPREAD)
			this.add_quote(quote/10000);//instr quotestyle is not bp
		else
			QL_FAIL("invalid quote style");
	}					
}

/*-----------------------------------------------------------------------
  swap_oisois: add_funcs
  ----------------------------------------------------------------------*/
void swap_oisois.add_notional(number notional)			{ swap_gen.swap_add_notional(notional);}
void swap_oisois.add_nominal(number notional) 			{ this.add_notional(notional );}	//if ccy swap: err
void swap_oisois.add_notional(number notional1, number notional2)	{ swap_gen.swap_add_notional(notional1, notional2);}
void swap_oisois.add_fx_mult_leg1(number fx_mult)		{ swap_gen.swap_add_fx_mult_leg1(fx_mult);}
void swap_oisois.add_fx_mult_leg2(number fx_mult)		{ swap_gen.swap_add_fx_mult_leg2(fx_mult);}
/*-----------------------------------------------------------------------
  add_fx_rate EXT SWAP: ok
  ----------------------------------------------------------------------*/
void swap_oisois.add_fx_rate(number fx_quote_dec,//must be a quote per unit of base ccy 
							logical pv_in_base_ccy,
							string 	base_ccy,
							string 	price_ccy)
{
	
	swap_gen.swap_add_fx_rate(fx_quote_dec,pv_in_base_ccy,base_ccy,price_ccy);
}
void swap_oisois.add_disc_func(disc_func disc_func)		{ swap_gen.swap_add_disc_func(disc_func); }
void swap_oisois.add_disc_func_leg1(disc_func disc_func) { swap_gen.swap_add_disc_func_leg1(disc_func); }//note disc_func for mtm-feature not added here
void swap_oisois.add_disc_func_leg2(disc_func  disc_func) { swap_gen.swap_add_disc_func_leg2(disc_func); }//note disc_func for mtm-feature not added here

void swap_oisois.add_surface_leg1(tenor_surface option(nullable) tenor_surface)	{ swap_gen.swap_add_surface_leg1(tenor_surface);}
void swap_oisois.add_fixing_leg1(	vector(date) fixing_dates,
									vector(number) fixings,
									logical option(nullable) fixing_as_fwd )
{			
	swap_gen.swap_add_fixing_leg1(fixing_dates,fixings,fixing_as_fwd);						
}
void swap_oisois.add_surface_leg2(tenor_surface option(nullable) tenor_surface)	{ swap_gen.swap_add_surface_leg2(tenor_surface);}
void swap_oisois.add_fixing_leg2(	vector(date) fixing_dates,
									vector(number) fixings,
									logical option(nullable) fixing_as_fwd )
{			
	swap_gen.swap_add_fixing_leg2(fixing_dates,fixings,fixing_as_fwd);						
}
void swap_oisois.add_fixing_leg1(	number fixing_proxy,
									logical option(nullable) fixing_as_fwd ) 
{			
	swap_gen.swap_add_fixing_leg1(fixing_proxy, fixing_as_fwd);						
}
void swap_oisois.add_fixing_leg2(	number fixing_proxy,
									logical option(nullable) fixing_as_fwd ) 
{			
	swap_gen.swap_add_fixing_leg2(fixing_proxy, fixing_as_fwd);						
}

void swap_oisois.add_data(	number 			notional,
							disc_func 		disc_func,
							tenor_surface 	tenor_surface_leg1,	
							vector(date) 	fixing_dates_leg1,
							vector(number) 	fixings_leg1,
							tenor_surface 	tenor_surface_leg2,
							vector(date) 	fixing_dates_leg2,
							vector(number) 	fixings_leg2,
							logical option(nullable) fixing_as_fwd,
							logical upd_null_crv ,
							logical upd_null_fix)
{
	//swap_gen.swap_add_oisois_data(notional,disc_func, tenor_surface_leg1,fixing_dates_leg1,fixings_leg1,
									//tenor_surface_leg2,fixing_dates_leg2,fixings_leg2, fixing_as_fwd);

	i().__swap_add_oisois_data(notional,disc_func, tenor_surface_leg1,fixing_dates_leg1,fixings_leg1,
								tenor_surface_leg2,fixing_dates_leg2,fixings_leg2, fixing_as_fwd,upd_null_crv,upd_null_fix);
	return ;
}

void swap_oisois.add_ccy_data(	number 			notional_leg1,
								disc_func 		disc_func_leg1,
								number			fx_mult_leg1,
								tenor_surface 	tenor_surface_leg1,	
								vector(date) 	fixing_dates_leg1,
								vector(number) 	fixings_leg1,
								number 			notional_leg2,
								disc_func 		disc_func_leg2,
								number			fx_mult_leg2,
								tenor_surface 	tenor_surface_leg2,
								vector(date) 	fixing_dates_leg2,
								vector(number) 	fixings_leg2,
								logical option(nullable) fixing_as_fwd,
								logical upd_null_crv ,
								logical upd_null_fix)
{
	
	//swap_gen.swap_add_oisois_ccy_data(notional_leg1,disc_func_leg1, fx_mult_leg1,tenor_surface_leg1,fixing_dates_leg1,fixings_leg1,
										//notional_leg2,disc_func_leg2,fx_mult_leg2,tenor_surface_leg2,fixing_dates_leg2,fixings_leg2, fixing_as_fwd);

	i().__swap_add_fltflt_ext_data(	notional_leg1,disc_func_leg1, fx_mult_leg1,tenor_surface_leg1,fixing_dates_leg1,fixings_leg1,
									notional_leg2,disc_func_leg2,fx_mult_leg2,tenor_surface_leg2,fixing_dates_leg2,fixings_leg2,
									fixing_as_fwd,upd_null_crv,upd_null_fix);
	return ;
	
}


void swap_oisois.add_mtm_data(	number 	option(nullable) curr_notional_reset_leg,										
								//number	option(nullable) notional_leg2,										
								number 	option(nullable) fx_spot,  //leg1=price_ccy, leg2=flat=base_ccy
								string 	option(nullable) fx_base_ccy,
								string 	option(nullable) fx_price_ccy,
								//date option(nullable) fx_spot_date,
								disc_func option(nullable) df_leg1,
								disc_func option(nullable) 	df_leg2)  
{
	number fx_spot_leg1_is_base;
	swap_gen.mtm_helper(fx_spot, fx_base_ccy,fx_price_ccy,fx_spot_leg1_is_base);
		
	i().__swap_add_oisois_mtm_data(curr_notional_reset_leg,fx_spot_leg1_is_base,df_leg1,df_leg2);

	return ;					
}

/*-----------------------------------------------------------------------
  set_date 		EXT SWAP: ok
  ----------------------------------------------------------------------*/
swap_oisois swap_oisois.set_date(	date  				trade_date, 
									date  option(nullable)	settle_date,
									error_info option(nullable) error)
{
	instrument cc;
	if(ext_swap_){		
		logical re_init = false; 
		logical init_quote = false;
		cc = instrument._set_date(trade_date,settle_date,re_init,init_quote,error);
	}
	else{
		QL_FAIL_COND(!null(settle_date),"input of settlement date only supported for non-db swaps" ,this,true );
		logical re_init = true; 
		logical init_quote = true;
		cc = instrument._set_date(trade_date,settle_date,re_init,init_quote,error);
	}
	if(null(cc))
		return null<swap_oisois>;

	swap_oisois sw = dynamic_cast<swap_oisois>(cc);
	sw.reset_mtm();
	return sw;
	
}

/*-----------------------------------------------------------------------
  set_date <protected>
	re_init for swaps means that updated disc_funcs, fixing data etc is not preserved
	ext_swap: if trade date is the same --> the settle date will be preserved (if not input)
  ----------------------------------------------------------------------*/
swap_oisois swap_oisois.set_date(	date  				trade_date, 
									date  option(nullable)	settle_date,
									logical 			re_init, //true->fail for ext_swap
									logical 			re_init_quote, //true->fail for ext_swap
									error_info option(nullable) error)
{
	QL_FAIL_COND(ext_swap_ && (re_init || re_init_quote),"re_init/re_init_quote flags = true not supported for non-db swaps" ,this,true );
	QL_FAIL_COND(!ext_swap_ && !null(settle_date),"input of settlement date only supported for non-db swaps" ,this,true );
	instrument cc = instrument._set_date(trade_date,settle_date,re_init,re_init_quote,error);
	if(null(cc))
		return null<swap_oisois>;

	swap_oisois sw = dynamic_cast<swap_oisois>(cc);
	sw.reset_mtm();
	return sw;
}

/*-----------------------------------------------------------------------
  set_date <protected/legacy>
	re_init for swaps means that updated disc_funcs, fixing data etc is not preserved
  ----------------------------------------------------------------------*/
swap_oisois swap_oisois.set_date(	date  				trade_date, 
									logical 			re_init, 
									error_info option(nullable) error) 

{

	instrument cc;
	if(ext_swap_){
		QL_FAIL_COND(re_init,"re_init = true not supported for non-db swaps" ,this,true );
		logical init_quote = false;
		cc = instrument._set_date(trade_date,null<date>,re_init,init_quote,error);
	}
	else {
		logical init_quote = true;
		cc = instrument._set_date(trade_date,null<date>,re_init,init_quote,error);
	}
	if(null(cc))
		return null<swap_oisois>;

	swap_oisois sw = dynamic_cast<swap_oisois>(cc);
	sw.reset_mtm();
	return sw;

	
	//instrument cc = instrument._set_date(trade_date,true,error);
	//return null(cc) ? null<swap_oisois>: dynamic_cast<swap_oisois>(cc);	
}

/*-----------------------------------------------------------------------
   move_date  <protected/legacy>
	changes the trade date of the instrument without retrieving the 
 	corresponding quote from the database or the real-time feed.
	ext_swap: if trade date is the same --> the settle date will be preserved (if not input)	
  ----------------------------------------------------------------------*/
swap_oisois swap_oisois.move_date(	date  				trade_date, 
									date option(nullable) settle_date,
									error_info option(nullable) error) 
{
	QL_FAIL_COND(!ext_swap_ && !null(settle_date),"input of settlement date only supported for non-db swaps" ,this,true );
	
	instrument cc = instrument._move_date(trade_date,settle_date,error);
	if(null(cc))
		return null<swap_oisois>;

	swap_oisois sw = dynamic_cast<swap_oisois>(cc);
	sw.reset_mtm();
	return sw;
}

/*-----------------------------------------------------------------------
  set_quote 
  ----------------------------------------------------------------------*/
swap_oisois swap_oisois.set_quote(	number 	option(nullable) quote,									
									error_info option(nullable) error)
{	
	instrument cc = instrument._set_quote(quote,null<date>, null<date>, false,error);
	return null(cc) ? null<swap_oisois>: dynamic_cast<swap_oisois>(cc);
}

/*-----------------------------------------------------------------------
  set_quote
  ----------------------------------------------------------------------*/
swap_oisois swap_oisois.set_quote(	string 	option(nullable) quote_side,								
									error_info option(nullable) error)
{	
	instrument cc = instrument._set_quote(quote_side,null<date>, null<date>, false,error);
	return null(cc) ? null<swap_oisois>: dynamic_cast<swap_oisois>(cc);
}

/*-----------------------------------------------------------------------
  create_tenor_surface_leg1	EXT SWAP: ok
  ----------------------------------------------------------------------*/
tenor_surface swap_oisois.create_tenor_surface_leg1(disc_func df,disc_func fwddf)
{
	try{
		error_info ee 			= error_info(true,true);
		..ir_index ir			= this.ir_index_leg1(ee);
		CORE_INT.instr_fail_check(null(ir), "invalid ir_index leg1", this, ee);
		
		logical allow_extrap 	= false;		
		return tenor_surface(this.trade_date(), df,[fwddf],[ir],allow_extrap);
	}
	catch {
		return null<tenor_surface>;
	}
}

/*-----------------------------------------------------------------------
  create_tenor_surface_leg2	EXT SWAP: ok
  ----------------------------------------------------------------------*/
tenor_surface swap_oisois.create_tenor_surface_leg2(disc_func df,disc_func fwddf)
{
	try{
		error_info ee 			= error_info(true,true);
		..ir_index ir			= this.ir_index_leg2(ee);
		CORE_INT.instr_fail_check(null(ir), "invalid ir_index leg2", this, ee);
		
		logical allow_extrap 	= false;		
		return tenor_surface(this.trade_date(), df,[fwddf],[ir],allow_extrap);
	}
	catch {
		return null<tenor_surface>;
	}
}
/*-----------------------------------------------------------------------
  swap_type
  ----------------------------------------------------------------------*/
instrument_type swap_oisois.swap_type(error_info option(nullable) error) 
{	
	return swap_gen.swap_type(error);
}

/*-----------------------------------------------------------------------
  set_pay_leg   --> returns an external swap, a db swap cannot be changed in regards to pay vs receive 
  ----------------------------------------------------------------------*/
swap_oisois swap_oisois.set_pay_leg(logical pay_leg1,							
									error_info option(nullable) error )
{
	try{
		//swap_gen.reset_mtm();
		__instrument  c = i().__swap_set_pay_leg1(pay_leg1 );
		
		instr_error e = new instr_error();
		instrument cc 	= this.create( c, e, E_INIT);
		CORE_INT.instr_fail_check(null(cc), "invalid swap_oisois", this, e);
		
		if(!cc.is_valid(error)) 
			return null<swap_oisois>;	
				
		return dynamic_cast<swap_oisois>(cc);					
	}	
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_oisois.set_pay_leg");
		return null<swap_oisois>;
	}
}
/*-----------------------------------------------------------------------
  fx_mult	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_oisois.fx_mult_factor(	out number  fx_mult_leg1, 
							out number  fx_mult_leg2, 
							error_info option(nullable) error) 
{	
	swap_gen.fx_mult_factor(fx_mult_leg1, fx_mult_leg2, error ) ;
}


/*-----------------------------------------------------------------------
  is_regular_first	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_oisois.is_regular_first(	out logical  is_reg_ois_leg1, 
									out logical  is_reg_ois_leg2, 
									error_info option(nullable) error) 
{	
	try{
		ql_ois_leg  leg1,leg2;
		get_legs( leg1, leg2);		
		is_reg_ois_leg1 = leg1.is_reg_first_period();		
		is_reg_ois_leg2 = leg2.is_reg_first_period();

		return ;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_oisois.is_regular_first");		
		is_reg_ois_leg1 = is_reg_ois_leg2 = null<logical >;
		return ;
	}
}

/*-----------------------------------------------------------------------
  is_regular_last	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_oisois.is_regular_last(	out logical  is_reg_ois_leg1, 
									out logical  is_reg_ois_leg2, 
									error_info option(nullable) error) 
{	
	try{
		ql_ois_leg  leg1,leg2;
		get_legs( leg1, leg2);
		
		is_reg_ois_leg1 = leg1.is_reg_last_period();		
		is_reg_ois_leg2 = leg2.is_reg_last_period();			

		return ;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_oisois.is_regular_last");		
		is_reg_ois_leg1 = is_reg_ois_leg2 = null<logical >;
		return ;
	}
}
/*-----------------------------------------------------------------------
  is_endog_df_leg1	EXT SWAP: ok 
  ----------------------------------------------------------------------*/
logical  swap_oisois.is_endog_df_leg1(error_info option(nullable) error ) 
{	
	try{
		
		ql_ois_leg  leg1,leg2;
		get_legs( leg1, leg2);
		
		return leg1.is_endog_df();						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_oisois.is_endog_df_leg1");
		return null<logical >;
	}
}
/*-----------------------------------------------------------------------
  is_endog_df_leg2	EXT SWAP: ok 
  ----------------------------------------------------------------------*/
logical  swap_oisois.is_endog_df_leg2(error_info option(nullable) error ) 
{	
	try{
		
		ql_ois_leg  leg1,leg2;
		get_legs( leg1, leg2);
		
		return leg2.is_endog_df();						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_oisois.is_endog_df_leg2");
		return null<logical >;
	}
}
/*-----------------------------------------------------------------------
  is_approx_calc_leg1	EXT SWAP: ok 
  ----------------------------------------------------------------------*/
logical  swap_oisois.is_approx_calc_leg1(error_info option(nullable) error ) 
{	
	try{
		
		ql_ois_leg  leg1,leg2;
		get_legs( leg1, leg2);
		return leg1.approx_calc();						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_oisois.is_approx_calc_leg1");
		return null<logical >;
	}
}
/*-----------------------------------------------------------------------
  is_approx_calc_leg2	EXT SWAP: ok 
  ----------------------------------------------------------------------*/
logical  swap_oisois.is_approx_calc_leg2(error_info option(nullable) error ) 
{	
	try{
		
		ql_ois_leg  leg1,leg2;
		get_legs( leg1, leg2);
		return leg2.approx_calc();						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_oisois.is_approx_calc_leg2");
		return null<logical >;
	}
}
/*-----------------------------------------------------------------------
  is_cross_currency
  ----------------------------------------------------------------------*/
logical	 swap_oisois.is_cross_currency(error_info option(nullable) error )
{
	try{
		QL_FAIL_COND(null(ccy_swap_),"init error");
		return ccy_swap_;	
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_oisois.is_cross_currency");
		return null<logical>;
	}
}
/*-----------------------------------------------------------------------
  notional	DLL_SWAP_HANDLER: ok
  ----------------------------------------------------------------------*/
void  swap_oisois.notional(	out number  notional_leg1, 
							out number  notional_leg2, 
							error_info option(nullable) error) 
{
	swap_gen.notional( notional_leg1,notional_leg2, error ) ;
	return;
}

/*-----------------------------------------------------------------------
  notional	DLL_SWAP_HANDLER: ok
  ----------------------------------------------------------------------*/
number  swap_oisois.notional(	error_info option(nullable) error ) 
{
	return swap_gen.nominal(error);
	
}

/*-----------------------------------------------------------------------
  settle_code  EXT SWAP: ok
  ----------------------------------------------------------------------*/
string swap_oisois.settle_code(error_info option(nullable) error) option(hidden)
{
	return swap_gen.settle_code(error);
}

/*-----------------------------------------------------------------------
  start_date	DLL_SWAP_HANDLER: ok
  ----------------------------------------------------------------------*/
date  swap_oisois.start_date(error_info option(nullable) error ) 
{
	return this.issue_date(error);
}
/*-----------------------------------------------------------------------
  currency	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_oisois.currency(	out string  curr_leg1, 
							out string  curr_leg2, 
							error_info option(nullable) error) 
{	
	swap_gen.currency(curr_leg1,  curr_leg2,  error);
	return;
}
/*-----------------------------------------------------------------------
  pmt_lag   	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_oisois.pmt_lag(	out	integer 	pmt_lag_leg1,
							out	integer 	mat_pmt_lag_leg1,
							out	integer 	pmt_lag_prin_leg1,
							out	integer 	mat_pmt_lag_prin_leg1,
							out	integer 	pmt_lag_leg2,
							out	integer 	mat_pmt_lag_leg2,
							out	integer 	pmt_lag_prin_leg2,
							out	integer 	mat_pmt_lag_prin_leg2,	
							error_info option(nullable) error) 
{
	swap_gen.swap_pmt_lag(	pmt_lag_leg1, mat_pmt_lag_leg1, pmt_lag_prin_leg1, mat_pmt_lag_prin_leg1,
								pmt_lag_leg2, mat_pmt_lag_leg2, pmt_lag_prin_leg2, mat_pmt_lag_prin_leg2,error);
	return;
}

/*-----------------------------------------------------------------------
  currency(leg1- backward compat)	EXT SWAP: ok
  ----------------------------------------------------------------------*/
/*string  swap_oisois.currency(error_info option(nullable) error) option(hidden)
{	
	try{
		QL_FAIL_COND(ccy_swap_,"inapplicable function call for currency swaps (use 2-leg version)", this,true);
		
		instr_error_type t;
   		string 			s;	
		string c1,c2;
		i().__swap_currency(c1,c2,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_oisois.currency");	
		return e ? null<string>: c1;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_oisois.currency");
		
		return null<string>;
	}
}*/

/*-----------------------------------------------------------------------
  quote 	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_oisois.quote(	out number  quote_leg1, 
							out number  quote_leg2, 
							error_info option(nullable) error) 
{	
	swap_gen.quote(quote_leg1,  quote_leg2, error);
}
/*-----------------------------------------------------------------------
  quote   
  ----------------------------------------------------------------------*/
number  swap_oisois.quote(error_info option(nullable) error)
{	
	return swap_gen.quote(error);
}
/*-----------------------------------------------------------------------
  spread_leg1 	EXT SWAP: ok
  ----------------------------------------------------------------------*/
number  swap_oisois.spread_leg1(error_info option(nullable) error ) 
{	
	try{	
		instr_error_type t;
   		string 			s;
		number quote_ois_leg1,q;
		i().__swap_def_quote(quote_ois_leg1,q,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_oisois.spread_leg1");
		if( e) {
			return null<number> ;
		}
		else {			
			..quote_style qs = i().__swap_quote_style_e_leg1(t,s);
			e = CORE_INT.add_error_info(error,t,s, "swap_oisois.spread_leg1");
			if( e) {
				return null<number> ;
			}
			switch(qs) {
				case ..quote_style.SPREAD:
					return quote_ois_leg1;
				case ..quote_style.SPREAD_BP:					
				default:
					return quote_ois_leg1/10000;
			}
		}
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_oisois.spread_leg1");
		return null<number> ;
	}
}
/*-----------------------------------------------------------------------
  spread_leg2 	EXT SWAP: ok
  ----------------------------------------------------------------------*/
number  swap_oisois.spread_leg2(error_info option(nullable) error ) 
{	
	try{	
		instr_error_type t;
   		string 			s;
		number q,quote_ois_leg2;
		i().__swap_def_quote(q,quote_ois_leg2,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_oisois.spread_leg2");
		if( e) {
			return null<number> ;
		}
		else {
			..quote_style qs = i().__swap_quote_style_e_leg2(t,s);
			e = CORE_INT.add_error_info(error,t,s, "swap_oisois.spread_leg2");
			if( e) {
				return null<number> ;
			}
			switch(qs) {
				case ..quote_style.SPREAD:
					return quote_ois_leg2;
				case ..quote_style.SPREAD_BP:				
				default:
					return quote_ois_leg2/10000;
			}
		}						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_oisois.spread_leg2");
		return null<number> ;
	}
}
/*-----------------------------------------------------------------------
  coupon   DLL_SWAP_HANDLER: ok
  ----------------------------------------------------------------------*/
void  swap_oisois.coupon(	out number  cpn_ois_leg1, 
							out number  cpn_ois_leg2, 
							error_info option(nullable) error) 
{	
	try{	
		instr_error_type t;
   		string 			s;	
		i().__swap_coupon(cpn_ois_leg1,cpn_ois_leg2,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_oisois.coupon");
		if(e)
			cpn_ois_leg1 = cpn_ois_leg2 = null<number>;
		return ;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_oisois.coupon");		
		cpn_ois_leg1 = cpn_ois_leg2 = null<number>;
		return ;
	}
}
/*-----------------------------------------------------------------------
  coupon   (leg1- backward compat)	DLL_SWAP_HANDLER: ok
  ----------------------------------------------------------------------*/
/*number  swap_oisois.coupon(error_info option(nullable) error) option(hidden)
{	
	try{
		QL_FAIL("inapplicable function call for swap_oisois (use 2-leg version)", this.name(),true);
		
		instr_error_type t;
   		string 			s;	
		number c1,c2;
		i().__swap_coupon(c1,c2,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_oisois.coupon");	
		return e ? null<number>: c1;					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_oisois.coupon");		
		return null<number>;
	}
}*/

/*-----------------------------------------------------------------------
  dc_method   	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_oisois.dc_method(	out day_count_method  dc_method_ois_leg1, 
								out day_count_method  dc_method_ois_leg2, 
								error_info option(nullable) error) 
{
	swap_gen.dc_method(dc_method_ois_leg1,dc_method_ois_leg2,error);
	return;

}

/*-----------------------------------------------------------------------
  ir_rule_leg1
  ----------------------------------------------------------------------*/
interest_rule  swap_oisois.ir_rule_leg1(error_info option(nullable) error)
	{	
	interest_rule if1, if2;
	swap_gen.ir_rule(if1, if2,  error ) ;
	return if1;
}
/*-----------------------------------------------------------------------
  ir_rule_leg2
  ----------------------------------------------------------------------*/
interest_rule  swap_oisois.ir_rule_leg2(error_info option(nullable) error)
	{	
	interest_rule if1, if2;
	swap_gen.ir_rule(if1, if2,  error ) ;
	return if2;
}

/*-----------------------------------------------------------------------
  avg_method_leg1
  ----------------------------------------------------------------------*/
flt_avg_method  swap_oisois.avg_method_leg1(error_info option(nullable) error)
{	
	return swap_gen.swap_avg_method_leg1(error) ;
}
/*-----------------------------------------------------------------------
  sprd_comp_method_leg1
  ----------------------------------------------------------------------*/
flt_sprd_comp_method  swap_oisois.sprd_comp_method_leg1(error_info option(nullable) error)
{	
	return swap_gen.swap_sprd_comp_method_leg1(error) ;
}
/*-----------------------------------------------------------------------
  comp_avg_type_leg1
  ----------------------------------------------------------------------*/
flt_comp_avg_type  swap_oisois.comp_avg_type_leg1(error_info option(nullable) error)
{	
	return swap_gen.swap_comp_avg_type_leg1(error) ;
}

/*-----------------------------------------------------------------------
  rfr_arrears_type_leg1
  ----------------------------------------------------------------------*/
rfr_arrears_type  swap_oisois.rfr_arrears_type_leg1(error_info option(nullable) error)
{	
	return swap_gen.swap_rfr_arr_type_leg1(error) ;
}
/*-----------------------------------------------------------------------
  rfr_arrears_type_leg1
  ----------------------------------------------------------------------*/
integer  swap_oisois.rfr_arrears_days_leg1(error_info option(nullable) error)
{	
	return swap_gen.swap_rfr_arr_days_leg1(error) ;
}

/*-----------------------------------------------------------------------
  avg_method_leg2
  ----------------------------------------------------------------------*/
flt_avg_method  swap_oisois.avg_method_leg2(error_info option(nullable) error)
{	
	return swap_gen.swap_avg_method_leg2(error) ;
}
/*-----------------------------------------------------------------------
  sprd_comp_method_leg2
  ----------------------------------------------------------------------*/
flt_sprd_comp_method  swap_oisois.sprd_comp_method_leg2(error_info option(nullable) error)
{	
	return swap_gen.swap_sprd_comp_method_leg2(error) ;
}
/*-----------------------------------------------------------------------
  comp_avg_type_leg2
  ----------------------------------------------------------------------*/
flt_comp_avg_type  swap_oisois.comp_avg_type_leg2(error_info option(nullable) error)
{	
	return swap_gen.swap_comp_avg_type_leg2(error) ;
}

/*-----------------------------------------------------------------------
  rfr_arrears_type_leg2
  ----------------------------------------------------------------------*/
rfr_arrears_type  swap_oisois.rfr_arrears_type_leg2(error_info option(nullable) error)
{	
	return swap_gen.swap_rfr_arr_type_leg2(error) ;
}
/*-----------------------------------------------------------------------
  rfr_arrears_type_leg2
  ----------------------------------------------------------------------*/
integer  swap_oisois.rfr_arrears_days_leg2(error_info option(nullable) error)
{	
	return swap_gen.swap_rfr_arr_days_leg2(error) ;
}
/*-----------------------------------------------------------------------
  dc_method   (leg1- backward compat)	EXT SWAP: ok
  ----------------------------------------------------------------------*/
/*day_count_method  swap_oisois.dc_method(error_info option(nullable) error) option(hidden)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		day_count_method c1,c2;
		i().__swap_dc_method(c1,c2,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_oisois.dc_method");	
		return e ? null<day_count_method>: c1;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_oisois.dc_method");
		
		return null<day_count_method>;
	}
}
*/

/*-----------------------------------------------------------------------
  effective_date   	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_oisois.effective_date(	out date  effective_date_leg1, 
									out date  effective_date_leg2, 
									error_info option(nullable) error) 
{
	try{
		error_info ee = error_info(true,true);
		vector(ql_swap_leg) l = this.legs(false,ee);
		
		QL_FAIL_COND(v_size(l) < 2,"invalid swap_oisois", this, true);				
		effective_date_leg1 = l[0].effective_date();
		effective_date_leg2 = l[1].effective_date();
				
		return ;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_oisois.effective_date");		
		effective_date_leg1 = effective_date_leg2 = null<date>;
		return ;
	}
}

/*-----------------------------------------------------------------------
  cpn_start_date	EXT SWAP: ok
  ----------------------------------------------------------------------*/
/*date swap_oisois.cpn_start_date(error_info option(nullable) error) option(hidden)
{	
	try{	
		error_info ee = error_info(true,true);
		date  d1,  d2;
		this.effective_date(d1, d2, ee) ;
		CORE_INT.instr_fail_check(null(d1), "cpn_start_date", this, ee);
		return d1;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_oisois.cpn_start_date");
		return null<date>;
	}
}

*/
/*-----------------------------------------------------------------------
  first_cpn_date   	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_oisois.first_cpn_date(	out date  first_cpn_date_leg1, 
									out date  first_cpn_date_leg2, 
									error_info option(nullable) error) 
{
	try{
		error_info ee = error_info(true,true);
		vector(ql_swap_leg) flt = this.legs(false,ee);
		
		QL_FAIL_COND(v_size(flt) < 2,"invalid swap_oisois", this, true);				
		first_cpn_date_leg1 = flt[0].first_cpn_date();
		first_cpn_date_leg2 = flt[1].first_cpn_date();
				
		return ;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_oisois.first_cpn_date");		
		first_cpn_date_leg1 = first_cpn_date_leg2 = null<date>;
		return ;
	}
}
/*-----------------------------------------------------------------------
  first_cpn_date  backward compat
  ----------------------------------------------------------------------*/
/*date swap_oisois.first_cpn_date(error_info option(nullable) error) option(hidden)
{	
	try{
		error_info ee = error_info(true,true);
		date  d1,  d2;
		this.first_cpn_date(d1, d2, ee) ;
		CORE_INT.instr_fail_check(null(d1), "last_reg_cpn_date", this, ee);
		return d1;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_oisois.first_cpn_date");
		return null<date>;
	}
}*/
/*-----------------------------------------------------------------------
  last_reg_cpn_date   	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_oisois.last_reg_cpn_date(out date  last_reg_cpn_date_leg1, 
									out date  last_reg_cpn_date_leg2, 
									error_info option(nullable) error) 
{
	try{
		error_info ee = error_info(true,true);
		vector(ql_swap_leg) flt = this.legs(false,ee);
		
		QL_FAIL_COND(v_size(flt) < 2,"invalid swap_oisois", this, true);				
		last_reg_cpn_date_leg1 = flt[0].last_reg_cpn_date();
		last_reg_cpn_date_leg2 = flt[1].last_reg_cpn_date();
				
		return ;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_oisois.last_reg_cpn_date");		
		last_reg_cpn_date_leg1 = last_reg_cpn_date_leg2 = null<date>;
		return ;
	}
}
/*-----------------------------------------------------------------------
  last_reg_cpn_date backward compat
  ----------------------------------------------------------------------*/
/*date swap_oisois.last_reg_cpn_date(error_info option(nullable) error) option(hidden)
{	
	try{
		error_info ee = error_info(true,true);
		date  d1,  d2;
		this.last_reg_cpn_date(d1, d2, ee) ;		
		CORE_INT.instr_fail_check(null(d1), "last_reg_cpn_date", this, ee);
		return d1;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_oisois.last_reg_cpn_date");
		return null<date>;
	}
}*/
/*-----------------------------------------------------------------------
  coupon_freq   	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_oisois.coupon_freq(	out integer  cpn_freq_ois_leg1, 
								out integer  cpn_freq_ois_leg2, 
								error_info option(nullable) error) 
{	
	swap_gen.coupon_freq(cpn_freq_ois_leg1,cpn_freq_ois_leg2,error);
	return;
}
/*-----------------------------------------------------------------------
  coupon_freq   (leg 1- backward compat)	EXT SWAP: ok
  ----------------------------------------------------------------------*/
/*integer  swap_oisois.coupon_freq(error_info option(nullable) error) option(hidden)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		integer c1,c2;
		i().__swap_cpn_freq(c1,c2,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_oisois.coupon_freq");	
		return e ? err_freq(): c1;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_oisois.coupon_freq");		
		return err_freq();
	}
}*/
/*-----------------------------------------------------------------------
  reset_freq   	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_oisois.reset_freq(	out integer  reset_freq_leg1, 
								out integer  reset_freq_leg2, 
								error_info option(nullable) error) 
{	
	try{	
		error_info ee = error_info(true,true);
		vector(ql_ois_leg) flt = this.ois_legs(false,ee);
		QL_FAIL_COND(v_size(flt) < 2,"invalid swap_oisois", this, true);				
		reset_freq_leg1 = reset_freq_leg2 = 365;
		return ;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_oisois.reset_freq");		
		reset_freq_leg1 = reset_freq_leg2 = err_freq();
		return ;
	}
}


/*-----------------------------------------------------------------------
  roll_day   	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_oisois.roll_day(	out integer  roll_day_ois_leg1, 
								out integer  roll_day_ois_leg2, 
								error_info option(nullable) error) 
{	
	try{	
		instr_error_type t;
   		string 			s;	
		i().__swap_roll_day(roll_day_ois_leg1,roll_day_ois_leg2,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_oisois.roll_day");
		if(e)
			roll_day_ois_leg1 = roll_day_ois_leg2 = err_int();
		return ;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_oisois.roll_day");		
		roll_day_ois_leg1 = roll_day_ois_leg2 = err_int();
		return ;
	}
}

/*-----------------------------------------------------------------------
  roll_day	EXT SWAP: ok
  ----------------------------------------------------------------------*/
/*integer swap_oisois.roll_day(error_info option(nullable) error) option(hidden)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		integer c1,c2;
		i().__swap_roll_day(c1,c2,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_oisois.roll_day");	
		return e ? err_int(): c1;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_oisois.roll_day");		
		return err_int();
	}
}*/

/*-----------------------------------------------------------------------
  eom   	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_oisois.eom(	out logical   eom_ois_leg1, 
						out logical  eom_ois_leg2, 
						error_info option(nullable) error) 
{	
	swap_gen.eom(eom_ois_leg1, eom_ois_leg2,  error ) ;
	return;
}

/*-----------------------------------------------------------------------
  is_mtm_leg1	EXT SWAP: ok
  ----------------------------------------------------------------------*/
logical  swap_oisois.is_mtm_leg1(error_info option(nullable) error) 
{	
	return swap_gen.is_mtm_leg1(error) ;
}
/*-----------------------------------------------------------------------
  is_mtm_leg1	EXT SWAP: ok
  ----------------------------------------------------------------------*/
logical  swap_oisois.is_mtm_leg2(error_info option(nullable) error) 
{	
	return swap_gen.is_mtm_leg2(error) ;
}

/*-----------------------------------------------------------------------
  eom	EXT SWAP: ok
  ----------------------------------------------------------------------*/
/*logical swap_oisois.eom(error_info option(nullable) error) option(hidden)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		logical c1,c2;
		i().__swap_eom(c1,c2,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_oisois.eom");	
		return e ? null<logical>: c1;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_oisois.eom");		
		return null<logical>;
	}
}*/

/*-----------------------------------------------------------------------
  cal   	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_oisois.calendar(	out ..calendar   cal_ois_leg1, 
							out ..calendar  cal_ois_leg2, 
							error_info option(nullable) error) 
{	
	swap_gen.calendar(cal_ois_leg1, cal_ois_leg2,  error ) ;
	return;
}

/*-----------------------------------------------------------------------
  calendar  	EXT SWAP: ok
  ----------------------------------------------------------------------*/
/*..calendar swap_oisois.calendar(error_info option(nullable) error)  option(hidden)
{	
	try{
		
		instr_error_type t;
   		string 			s;	
		..calendar c1,c2;
		i().__swap_calendar(c1,c2,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_fixois.calendar");	
		return e ? null<..calendar>: c1;					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_oisois.calendar");		
		return null<..calendar>;
	}
}*/

/*-----------------------------------------------------------------------
  calendar
  ----------------------------------------------------------------------*/
/*calendar swap_oisois.calendar(integer index, error_info option(nullable) error) option(hidden)
{
	try {
		QL_FAIL_COND(index != 0,"function call not applicable swaps (only index = 0 is supported)", this,true);

		return this.calendar(error );
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_oisois.calendar");
		return null<..calendar>;
	}
}*/
/*-----------------------------------------------------------------------
  calendar_name  	
  ----------------------------------------------------------------------*/
/*string swap_oisois.calendar_name(error_info option(nullable) error )  option(hidden)
{	
	try{
		QL_FAIL_COND(ext_swap_,"inapplicable function call for non-db swaps", this,true);
		QL_FAIL_COND(ccy_swap_,"inapplicable function call for currency swaps (use 2-leg version)", this,true);

		return this.instr_def(error).swap_calendar_name_leg1(error);
								
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_oisois.calendar_name");
		return null<string>;
	}
}*/
/*-----------------------------------------------------------------------
  calendar_name  	
  ----------------------------------------------------------------------*/
/*string swap_oisois.calendar_name(integer index, error_info option(nullable) error )  option(hidden)
{	
	try{
		QL_FAIL_COND(index != 0,"function call not applicable swaps (only index = 0 is supported)", this,true);		
		return this.calendar_name(error);
								
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_oisois.calendar_name");
		return null<string>;
	}
}*/
/*-----------------------------------------------------------------------
  pmt_bus_day 	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_oisois.pmt_bus_day(	out bd_convention  pmt_bus_day_ois_leg1, 
								out bd_convention  pmt_bus_day_ois_leg2, 
								error_info option(nullable) error) 
{	
	swap_gen.pmt_bus_day(pmt_bus_day_ois_leg1, pmt_bus_day_ois_leg2,  error ) ;
	return;
}

/*-----------------------------------------------------------------------
  pmt_bus_day   ( leg1- backward compat)	EXT SWAP: ok
  ----------------------------------------------------------------------*/
/*bd_convention swap_oisois.pmt_bus_day(error_info option(nullable) error) option(hidden)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		bd_convention c1,c2;
		i().__swap_bd(c1,c2,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_oisois.pmt_bus_day");	
		return e ? null<bd_convention>: c1;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_oisois.pmt_bus_day");		
		return null<bd_convention>;
	}
}*/

/*-----------------------------------------------------------------------
  accr_dates	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_oisois.accr_dates(	logical 			post_settle,									
								out vector(date) 	accr_start_dates_leg1,									
								out vector(date) 	accr_end_dates_leg1,
								out vector(number) 	accr_period_leg1,
								out vector(date) 	accr_start_dates_leg2,									
								out vector(date) 	accr_end_dates_leg2,
								out vector(number) 	accr_period_leg2,
								error_info option(nullable) error) 
{
	try{	
		instr_error_type t;
   		string 			s;
	
		i().__swap_accr_dates(post_settle,accr_start_dates_leg1,accr_end_dates_leg1,accr_period_leg1,
									  accr_start_dates_leg2,accr_end_dates_leg2,accr_period_leg2,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_oisois.accr_dates");
		if(e) {
			accr_start_dates_leg1 = accr_start_dates_leg2 = null<vector(date)>;
			accr_end_dates_leg1 = accr_end_dates_leg2 = null<vector(date)>;
			accr_period_leg1 = accr_period_leg2 = null<vector(number)>;
		
		}			
		return ;					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_oisois.accr_dates");		
		accr_start_dates_leg1 = accr_start_dates_leg2 = null<vector(date)>;
		accr_end_dates_leg1 = accr_end_dates_leg2 = null<vector(date)>;
		accr_period_leg1 = accr_period_leg2 = null<vector(number)>; 		 
		return ;
	}
}

/*-----------------------------------------------------------------------
  index_dates_leg1	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_oisois.index_dates_leg1(	logical 			post_settle,
									logical 			all_dates,
									out vector(date) 	index_start_dates,									
									out vector(date) 	index_end_dates,
									out vector(logical)  index_regular,
									error_info option(nullable) error) 
{	
	try{	
		instr_error_type t;
   		string 			s;
		logical leg1 = true;
		i().__swap_index_dates(post_settle,index_start_dates,index_end_dates,index_regular, leg1,all_dates,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_oisois.index_dates_leg1");
		if(e) {
			index_start_dates = index_end_dates = null<vector(date)>; 
			index_regular = null<vector(logical)>; 
		}			
		return ;					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_oisois.index_dates_leg1");		
		index_start_dates = index_end_dates = null<vector(date)>; 
		index_regular = null<vector(logical)>; 
		return ;
	}
}

/*-----------------------------------------------------------------------
  index_dates_leg2	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_oisois.index_dates_leg2(	logical 			post_settle,
									logical 			all_dates,
									out vector(date) 	index_start_dates,									
									out vector(date) 	index_end_dates,
									out vector(logical)  index_regular,
									error_info option(nullable) error) 
{	
	try{	
		instr_error_type t;
   		string 			s;
		logical leg1 = false;
		i().__swap_index_dates(post_settle,index_start_dates,index_end_dates,index_regular, leg1,all_dates,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_oisois.index_dates_leg2");
		if(e) {
			index_start_dates = index_end_dates = null<vector(date)>; 
			index_regular = null<vector(logical)>; 
		}			
		return ;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_oisois.index_dates_leg2");		
		index_start_dates = index_end_dates = null<vector(date)>; 
		index_regular = null<vector(logical)>; 
		return ;
	}
}


/*-----------------------------------------------------------------------
  fixing_data_leg1	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_oisois.fixing_data_leg1(	logical 							post_trade_date,
									logical option(nullable)			only_fixed, 
									out vector(date)  	reset_date,									
									out vector(number)  rate,
									out vector(logical) is_fixed,
									error_info option(nullable) 	error) 
{	
	try{
		error_info ee = error_info(true,true);
		vector(ql_ois_leg) ois = this.ois_legs(false,ee);
		QL_FAIL_COND(v_size(ois) < 2,"invalid swap_oisois", this, true);
		
		date cut_off = post_trade_date ? this.trade_date(): null<date>;
		ois[0].fixing_data(only_fixed,reset_date,rate,is_fixed,cut_off);

		return ;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_oisois.fixing_data_leg1");		
		reset_date = null<vector(date)>; 
		rate = null<vector(number)>; 
		is_fixed = null<vector(logical)>;
		return ;
	}
}

/*-----------------------------------------------------------------------
  fixing_data_leg2	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_oisois.fixing_data_leg2(	logical 							post_trade_date,
									logical option(nullable)			only_fixed, 
									out vector(date)  	reset_date,									
									out vector(number)  rate,
									out vector(logical) is_fixed,
									error_info option(nullable) 	error) 
{	
	try{	
		error_info ee = error_info(true,true);
		vector(ql_ois_leg) ois = this.ois_legs(false,ee);
		QL_FAIL_COND(v_size(ois) < 2,"invalid swap_oisois", this, true);
		
		date cut_off = post_trade_date ? this.trade_date(): null<date>;
		ois[1].fixing_data(only_fixed,reset_date,rate,is_fixed,cut_off);

		return ;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_oisois.fixing_data_leg2");		
		reset_date = null<vector(date)>; 
		rate = null<vector(number)>; 
		is_fixed = null<vector(logical)>;
		return ;
	}
}

/*-----------------------------------------------------------------------
  current_fixings_leg1	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void swap_oisois.current_fixings_leg1(	logical only_fixed,
										out vector(date) reset_dates,
										out vector(number) rates,
										out vector(logical) is_fixed,
										error_info option(nullable) error)
{
	try{
		error_info ee = error_info(true,true);
		vector(ql_ois_leg) ois = this.ois_legs(false,ee);
		QL_FAIL_COND(v_size(ois) < 2,"invalid swap_oisois", this, true);
		ois[0].current_fixing_rates(only_fixed,reset_dates,rates,is_fixed);
		
		return ;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_oisois.current_fixings_leg1");		
		return ;
	}
}
/*-----------------------------------------------------------------------
  current_fixings_leg2	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void swap_oisois.current_fixings_leg2(	logical only_fixed,
										out vector(date) reset_dates,
										out vector(number) rates,
										out vector(logical) is_fixed,
										error_info option(nullable) error)
{
	try{
		error_info ee = error_info(true,true);
		vector(ql_ois_leg) ois = this.ois_legs(false,ee);
		QL_FAIL_COND(v_size(ois) < 2,"invalid swap_oisois", this, true);
		ois[1].current_fixing_rates(only_fixed,reset_dates,rates,is_fixed);
		
		return ;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_oisois.current_fixings_leg2");		
		return ;
	}
}
/*-----------------------------------------------------------------------
  cash_flow_dates	EXT SWAP: ok   <PUBLIC>   interest payment dates, not principal pmt dates
  ----------------------------------------------------------------------*/
void  swap_oisois.cash_flow_dates(	logical 			post_settle, 
									out vector(date) 	pmt_dates_leg1,									
									out vector(date) 	pmt_dates_leg2,
									error_info option(nullable) error) 
{	
	try{	
		instr_error_type t;
   		string 			s;	
		i().__swap_ir_pmt_dates(post_settle,pmt_dates_leg1,pmt_dates_leg2, t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_oisois.cash_flow_dates");
		if(e) {
			pmt_dates_leg1 = pmt_dates_leg2 = null<vector(date)>;  
		}
		return;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_oisois.cash_flow_dates");		
		pmt_dates_leg1 = pmt_dates_leg2 = null<vector(date)>; 
		return ;
	}
}
/*-----------------------------------------------------------------------
  prin_cash_flow_dates	EXT SWAP: ok   <PUBLIC>   
  ----------------------------------------------------------------------*/
void  swap_oisois.prin_cash_flow_dates(	logical 			post_settle, 
										out vector(date) 	pmt_dates_leg1,									
										out vector(date) 	pmt_dates_leg2,
										error_info option(nullable) error) 
{	
	try{	
		instr_error_type t;
   		string 			s;	
		i().__swap_prin_pmt_dates(post_settle,pmt_dates_leg1,pmt_dates_leg2, t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_oisois.prin_cash_flow_dates");
		if(e) {
			pmt_dates_leg1 = pmt_dates_leg2 = null<vector(date)>;  
		}
		return;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_oisois.prin_cash_flow_dates");		
		pmt_dates_leg1 = pmt_dates_leg2 = null<vector(date)>; 
		return ;
	}
}
/*-----------------------------------------------------------------------
  cash_flow_dates override (leg 1- backward compat)	EXT SWAP: ok
  ----------------------------------------------------------------------*/
/*vector(date) swap_oisois.cash_flow_dates(	logical post_settle, 
											logical adj_dates,   
											logical keep_size,  
											error_info option(nullable) error)
{	
	try{
		QL_FAIL_COND(keep_size == true,"keep size = true not applicable for swaps", this, true);

		vector(date) pmt_dates_leg1,pmt_dates_leg2;
		this.cash_flow_dates(post_settle,pmt_dates_leg1,pmt_dates_leg2,error);
		return pmt_dates_leg1;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_oisois.cash_flow_dates");		
		return null<vector(date)>;
	}
}*/

/*-----------------------------------------------------------------------
  cash_flows_cpn	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_oisois.cash_flows_cpn(	logical 			post_settle, 
									out vector(number) 	cpn_cf_leg1,									
									out vector(number) 	cpn_cf_leg2,
									error_info option(nullable) error) 
{	
	try{	
		instr_error_type t;
   		string 			s;	
		i().__swap_cashflows_cpn(post_settle,cpn_cf_leg1,cpn_cf_leg2, t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_oisois.cash_flows_cpn");
		if(e) {
			cpn_cf_leg1 = cpn_cf_leg2 = null<vector(number)>;
		}
		return;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_oisois.cash_flows_cpn");		
		cpn_cf_leg1 = cpn_cf_leg2 = null<vector(number)>;
		return ;
	}
}

/*-----------------------------------------------------------------------
  cash_flows_cpn override-protected  (leg1- backward compat)	EXT SWAP: ok
  ----------------------------------------------------------------------*/
/*vector(number) swap_oisois.cash_flows_cpn(	number option(nullable) notional, 
											logical post_settle, 
											logical keep_size,  
											error_info option(nullable) error)
{	
	try{
		QL_FAIL_COND(keep_size == true,"keep size = true not applicable for swaps", this, true);
		QL_FAIL_COND(!null(notional) && notional != this.nominal(),"input of notional not applicable for swaps", this, true);

		error_info ee = new error_info(true,true);
		vector(number) cf_leg1,cf_leg2;
		this.cash_flows_cpn(post_settle,cf_leg1,cf_leg2, ee);
		
		for(integer i=0;i<v_size(cf_leg1);i++)
			cf_leg1[i] = abs(cf_leg1[i]);
		return cf_leg1;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_oisois.cash_flows_cpn");		
		return null<vector(number)>;
	}

}*/

/*-----------------------------------------------------------------------
  cash_flows	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_oisois.cash_flows(	logical 			post_settle, 
								out vector(number) 	cf_leg1,									
								out vector(number) 	cf_leg2,
								error_info option(nullable) error) 
{	
	try{	
		instr_error_type t;
   		string 			s;	
		logical or=true;
		i().__swap_cashflows(post_settle,or,cf_leg1,cf_leg2, t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_oisois.cash_flows");
		if(e) {
			cf_leg1 = cf_leg2 = null<vector(number)>;
		}
		return;					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_oisois.cash_flows");		
		cf_leg1 = cf_leg2 = null<vector(number)>;
		return ;
	}
}


/*-----------------------------------------------------------------------
  cash_flows  override, protected	EXT SWAP: ok
  ----------------------------------------------------------------------*/
/*vector(number) swap_oisois.cash_flows(number option(nullable) notional, 
									logical post_settle, 
									logical keep_size,  
									error_info option(nullable) error)
{	
	try{
		QL_FAIL_COND(keep_size == true,"keep size = true not applicable for swaps", this, true);
		QL_FAIL_COND(!null(notional) && notional != this.nominal(),"input of notional not applicable for swaps", this, true);

		error_info ee = new error_info(true,true);
		vector(number) cf_leg1,cf_leg2;
		this.cash_flows(post_settle,cf_leg1,cf_leg2, ee);
	
		for(integer i=0;i<v_size(cf_leg1);i++)
			cf_leg1[i] = abs(cf_leg1[i]);
		return cf_leg1;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_oisois.cash_flows");		
		return null<vector(number)>;
	}
}*/
/*-----------------------------------------------------------------------
  cash_flows  LEGACY, prot
  ----------------------------------------------------------------------*/
/*void swap_oisois.cash_flows(out vector(date)  dates,
    						out vector(number)  amounts,
							number option(nullable) notional ,
							logical post_settle,							
							error_info option(nullable) error)  
{
	QL_FAIL_COND(!null(notional) && notional != this.nominal(),"input of notional not applicable for swaps", this, true);
	vector(date) pmt_dates_flt_leg;									
	vector(number) cf_flt_leg;

	this.cash_flow_data(	post_settle, ir_cf_code.COUPON, dates,amounts,
							pmt_dates_flt_leg,	cf_flt_leg,error );

	number notional_fix_leg,  notional_flt_leg;
	this.notional(notional_fix_leg, notional_flt_leg, error ) ;
	integer s = v_size(amounts);
	for(integer i=0; i<s;i++){
		amounts[i] = abs(amounts[i]);
	}
	amounts[s-1] += abs(notional_fix_leg);
	
}*/

/*-----------------------------------------------------------------------
  cash_flow_dates_noadj  LEGACY, prot
  ----------------------------------------------------------------------*/
/*vector(date) swap_oisois.cash_flow_dates_noadj(	logical 	post_settle,
												error_info option(nullable) error) 
												
{
	vector(date)  dates;
	vector(number)  amounts;
	this.cash_flow_data(null<number>, post_settle, ir_cf_code.TOTAL,false,false,  
						dates,  amounts, error );
	return dates;
}
*/
/*-----------------------------------------------------------------------
  cash_flow_amounts  LEGACY, prot
  ----------------------------------------------------------------------*/
/*vector(number) swap_oisois.cash_flow_amounts(number option(nullable) notional,
											logical post_settle,
											logical keep_size,											
											error_info option(nullable) error) 

{	
	vector(date)  dates;
	vector(number)  amounts;
	this.cash_flow_data(notional, post_settle, ir_cf_code.COUPON,false,keep_size,  
						dates,  amounts, error );

	number notional_fix_leg,  notional_flt_leg;
	this.notional(notional_fix_leg, notional_flt_leg, error ) ;
	integer s = v_size(amounts);
	for(integer i=0; i<s;i++){
		amounts[i] = abs(amounts[i]);
	}
	amounts[s-1] += abs(notional_fix_leg);
	
	return amounts;
}*/
/*-----------------------------------------------------------------------
  cash_flow_nom_amounts  LEGACY, prot
  ----------------------------------------------------------------------*/
/*vector(number) swap_oisois.cash_flow_nom_amounts(number option(nullable) notional,
												logical post_settle,
												logical keep_size,
												error_info option(nullable) error) option(hidden)
{	
	return cash_flow_amounts(notional,post_settle, keep_size,error) ;
}*/
/*-----------------------------------------------------------------------
  cash_flow_data	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_oisois.cash_flow_data(logical 			post_settle,
								ir_cf_code 			cf_code, 
								out vector(date) 	pmt_dates_leg1,									
								out vector(number)  cf_leg1,
								out vector(date) 	pmt_dates_leg2,									
								out vector(number) 	cf_leg2,
								error_info option(nullable) error) 
{	
	try{
		error_info ee = new error_info(true,true);
		this.cash_flow_dates(post_settle, pmt_dates_leg1,pmt_dates_leg2,ee) ;
		
		if(cf_code == ir_cf_code.COUPON) {
			this.cash_flows_cpn(post_settle, cf_leg1,cf_leg2,ee) ;
		}
		else if	(cf_code == ir_cf_code.PRINCIPAL) {
			this.cash_flows(post_settle,cf_leg1,cf_leg2,ee) ;
	
			vector(number) cpn1,cpn2;
			this.cash_flows_cpn(post_settle,cpn1,cpn2,ee) ;

			cf_leg1 -= cpn1;
			cf_leg2 -= cpn2;
		}
		else {
			this.cash_flows(post_settle,cf_leg1,cf_leg2,ee) ;
		}
		return ;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_oisois.cash_flow_data");		
		cf_leg1 = cf_leg2 = null<vector(number)>;
		pmt_dates_leg1 = pmt_dates_leg2 = null<vector(date)>;
		return ;
	}
}

/*-----------------------------------------------------------------------
  cash_flow_data protected, override	EXT SWAP: ok
  ----------------------------------------------------------------------*/
/*void swap_oisois.cash_flow_data(number option(nullable) notional, 
								logical post_settle, 
								ir_cf_code cf_code,
								logical adj_dates, 
								logical keep_size,  
								out vector(date)  dates,  
								out vector(number)  amounts,								
								error_info option(nullable) error) 
{	
	try{
		QL_FAIL_COND(keep_size == true,"keep size = true not applicable for swaps", this, true);
		QL_FAIL_COND(!null(notional) && notional != this.nominal(),"input of notional not applicable for swaps", this, true);

		error_info ee = new error_info(true,true);
		vector(number) cf_leg2;
		vector(date) dates_leg2;
		this.cash_flow_data(post_settle,cf_code, dates,amounts,  dates_leg2, cf_leg2, ee);

		for(integer i=0;i<v_size(amounts);i++)
			amounts[i] = abs(amounts[i]);
		return ;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_oisois.cash_flow_data");
		
		return ;
	}

}*/
/*-----------------------------------------------------------------------
  cash_flow_data	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_oisois.cash_flow_data(logical 			post_settle,
								logical option(nullable) trade_date_pv,
								out vector(date)  	pmt_date_leg1,
								out vector(number)  cpn_rate_leg1,
								out vector(number)  cpn_cashflow_leg1,
								out vector(number)  pv_cpn_cashflow_leg1,
								out vector(number)  fee_leg1,
								out vector(number)  pv_fee_leg1,
								out vector(number)  notional_leg1,
								out vector(date)  	pmt_date_leg2,
								out vector(number)  cpn_rate_leg2,
								out vector(number)  cpn_cashflow_leg2,
								out vector(number)  pv_cpn_cashflow_leg2,
								out vector(number)  fee_leg2,
								out vector(number)  pv_fee_leg2,
								out vector(number)  notional_leg2,
								error_info option(nullable) 	error) 
{	
	try{	
		instr_error_type t;
   		string 			s;	
		i().__swap_payment_data(trade_date_pv,post_settle, 
								pmt_date_leg1,
								cpn_rate_leg1,
								cpn_cashflow_leg1,
								pv_cpn_cashflow_leg1,
								fee_leg1,
								pv_fee_leg1,
								notional_leg1,
								pmt_date_leg2,
								cpn_rate_leg2,
								cpn_cashflow_leg2,
								pv_cpn_cashflow_leg2,
								fee_leg2,
								pv_fee_leg2,
								notional_leg2, t,s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_oisois.cash_flow_data");
		if(e) {
			cpn_rate_leg1 = cpn_cashflow_leg1 = pv_cpn_cashflow_leg1 = fee_leg1 = null<vector(number)>;
			pv_fee_leg1 = notional_leg1 = null<vector(number)>;
			cpn_rate_leg2 = cpn_cashflow_leg2 = pv_cpn_cashflow_leg2 = fee_leg2 = null<vector(number)>;
			pv_fee_leg2 = notional_leg2 = null<vector(number)>;
			pmt_date_leg1= pmt_date_leg2 = null<vector(date)>; 
		}			
		return ;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_oisois.cash_flow_data");		
		cpn_rate_leg1 = cpn_cashflow_leg1 = pv_cpn_cashflow_leg1 = fee_leg1 = null<vector(number)>;
		pv_fee_leg1 = notional_leg1 = null<vector(number)>;
		cpn_rate_leg2 = cpn_cashflow_leg2 = pv_cpn_cashflow_leg2 = fee_leg2 = null<vector(number)>;
		pv_fee_leg2 = notional_leg2 = null<vector(number)>;
		pmt_date_leg1= pmt_date_leg2 = null<vector(date)>; 
		return ;
	}
}

/*-----------------------------------------------------------------------
  data_leg1	EXT SWAP: ok
  ----------------------------------------------------------------------*/
swap_ois_leg_data  swap_oisois.data_leg1(logical all_dates,error_info option(nullable) 	error) 
{	
	try{
		error_info ee = new error_info(true,false);
		ql_ois_leg leg = ois_leg1(false,ee);
		QL_REQUIRE(!ee.is_error(), ee.message());
		return new swap_ois_leg_data(leg,all_dates);							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_oisois.data_leg1");				
		return null<swap_ois_leg_data>;
	}
}
/*-----------------------------------------------------------------------
  data_leg2	EXT SWAP: ok
  ----------------------------------------------------------------------*/
swap_ois_leg_data  swap_oisois.data_leg2(logical all_dates,error_info option(nullable) 	error) 
{	
	try{
		error_info ee = new error_info(true,false);
		ql_ois_leg leg = ois_leg2(false,ee);
		QL_REQUIRE(!ee.is_error(), ee.message());
		return new swap_ois_leg_data(leg,all_dates);							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_oisois.data_leg2");				
		return null<swap_ois_leg_data>;
	}
}
/*-----------------------------------------------------------------------
  accrued
  ----------------------------------------------------------------------*/
/*number  swap_oisois.accrued(logical 	disable_rounding,
							logical 	in_pcnt,
							error_info option(nullable) error) 
{
	number accr_leg1,accr_leg2;
	return this.accrued(in_pcnt,accr_leg1,accr_leg2,error);
}*/
/*-----------------------------------------------------------------------
  accrued
  ----------------------------------------------------------------------*/
number  swap_oisois.accrued(logical 	in_pcnt,
							out number accr_leg1,									
							out number accr_leg2,
							error_info option(nullable) error) 
{	
	try{	
		instr_error_type t;
   		string 			s;	
		number c = i().__swap_accrued(in_pcnt,accr_leg1,accr_leg2, t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_oisois.accrued");
		if(e) {
			accr_leg1 = accr_leg2 = null<number>; 
			return  null<number>;
		}
		return c;					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_oisois.accrued");		
		accr_leg1 = accr_leg2 = null<number>; 
		return null<number>;
	}
}

/*-----------------------------------------------------------------------
  accrued_period	backward compat, returns leg1 data  EXT SWAP: ok
  ----------------------------------------------------------------------*/
/*number  swap_oisois.accrued_period(	out integer n_days_leg1,
									error_info option(nullable) error) 
{
	try {
		error_info ee = new error_info(true,true);
		number period_leg1,period_leg2;
		integer n_days_leg2;
		this.accrued_period(period_leg1,period_leg2,n_days_leg1,n_days_leg2,ee);
		return period_leg1;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_oisois.accrued_period");
		n_days_leg1 = err_int();
		return null<number>;
	}
}*/
/*-----------------------------------------------------------------------
  accrued_period  EXT SWAP: ok
  ----------------------------------------------------------------------*/
void swap_oisois.accrued_period(	out number  period_leg1,
									out number  period_leg2,
									out integer n_days_leg1,
									out integer n_days_leg2,
									error_info option(nullable) error) 
{	
	try{	
		instr_error_type t;
   		string 			s;	
		i().__swap_accrued_period(period_leg1,period_leg2,n_days_leg1,n_days_leg2,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_oisois.accrued_period");
		if(e) {
			period_leg1 = period_leg2 = null<number>;
			n_days_leg1 = n_days_leg2 = err_int();
		}
		return ;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_oisois.accrued_period");		
		period_leg1 = period_leg2 = null<number>;
		n_days_leg1 = n_days_leg2 = err_int();
		return ;
	}
}

/*-----------------------------------------------------------------------
  accrued_chg  protected
  ----------------------------------------------------------------------*/
/*number  swap_oisois.accrued_chg(integer 					bus_days,
								out number 	cpn_cashflow,
								out date  settle,
								out date  settle_next,	
								logical 	in_pcnt,								
								error_info option(nullable) error) 
{	
	try {
		QL_FAIL_COND(in_pcnt,"in_pcnt = true not applicable", this, true);
		
		error_info ee = new error_info(true,true);
		number cpn_cashflow_leg2,ai_chg_leg1,ai_chg_leg2;
		number c = this.accrued_chg(	bus_days,ai_chg_leg1,ai_chg_leg2,
									cpn_cashflow,cpn_cashflow_leg2,
									settle,settle_next,ee);		
		return c;		
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_oisois.accrued_chg");		
		cpn_cashflow = null<number>;
		settle = settle_next = null<date>;
		return null<number>;
	}
*/

/*-----------------------------------------------------------------------
  accrued_chg  EXT SWAP: ok
  ----------------------------------------------------------------------*/
number swap_oisois.accrued_chg  (	integer bus_days,
									out number 	ai_chg_leg1,
									out number 	ai_chg_leg2,
									out number 	cpn_cashflow_leg1,
									out number 	cpn_cashflow_leg2,
									out date  settle,
									out date  settle_next,	
									error_info option(nullable) error) 
{	
	try{	
		instr_error_type t;
   		string 			s;	
		number c = i().__swap_accrued_chg(bus_days,ai_chg_leg1,ai_chg_leg2,cpn_cashflow_leg1,cpn_cashflow_leg2,settle, settle_next,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_oisois.accrued_chg");
		if(e) {
			ai_chg_leg1 = ai_chg_leg2 = cpn_cashflow_leg1 = cpn_cashflow_leg2 = null<number>;
			settle = settle_next = null<date>;
		}
		return c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_oisois.accrued_chg");		
		ai_chg_leg1 = ai_chg_leg2 = cpn_cashflow_leg1 = cpn_cashflow_leg2 = null<number>;
		settle = settle_next = null<date>;
		return null<number>; 
	}
}


/*-----------------------------------------------------------------------
  pvbp	EXT SWAP: ok
  ----------------------------------------------------------------------*/
number  swap_oisois.pvbp(	number option(nullable) notional,
							number option(nullable) delta,
							logical option(nullable) centered,
							logical option(nullable) disable_rounding,	
							error_info option(nullable) error) 
{	
	return null<number>;//this.pvbp_fix_leg(notional,delta,false,error) ;
}


/*-----------------------------------------------------------------------
  pvbp	EXT SWAP: ok
  ----------------------------------------------------------------------*/
number  swap_oisois.pvbp(	number 	option(nullable) notional,
							number  option(nullable) delta,																																		
							error_info option(nullable) error) 
{	
	try{	
		return this.pvbp(notional,delta, false,false,error);							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_oisois.pvbp");		
		return null<number>;
	}
}

/*-----------------------------------------------------------------------
  ir_index	protected	EXT SWAP: ok
  ----------------------------------------------------------------------*/
ir_index swap_oisois.ir_index(error_info option(nullable) error) option(hidden)
{	
	return swap_gen.swap_ir_index_leg1(error);
}
/*-----------------------------------------------------------------------
  swap_oisois: ir_index
  ----------------------------------------------------------------------*/
ir_index swap_oisois.ir_index_leg1(error_info option(nullable) error)
{	
	return swap_gen.swap_ir_index_leg1(error);
}

/*-----------------------------------------------------------------------
  swap_oisois: ir_index
  ----------------------------------------------------------------------*/
ir_index swap_oisois.ir_index_leg2(error_info option(nullable) error)
{	
	return swap_gen.swap_ir_index_leg2(error);
}
/*-----------------------------------------------------------------------
  index_tenor_leg1
  ----------------------------------------------------------------------*/
string swap_oisois.index_tenor_leg1(error_info option(nullable) error) 
{	
	return swap_gen.swap_index_tenor_leg1(error);
}

/*-----------------------------------------------------------------------
  index_tenor_leg2
  ----------------------------------------------------------------------*/
string swap_oisois.index_tenor_leg2(error_info option(nullable) error) 
{	
	return swap_gen.swap_index_tenor_leg2(error);
}

/*-----------------------------------------------------------------------
  index_tenor_code_leg1
  ----------------------------------------------------------------------*/
tenor_code swap_oisois.index_tenor_code_leg1(error_info option(nullable) error) 
{	
	return swap_gen.swap_index_tenor_code_leg1(error);
}

/*-----------------------------------------------------------------------
  index_tenor_code_leg2
  ----------------------------------------------------------------------*/
tenor_code swap_oisois.index_tenor_code_leg2(error_info option(nullable) error) 
{	
	return swap_gen.swap_index_tenor_code_leg2(error);
}


/*-----------------------------------------------------------------------
  swap_oisois: disc_func_leg1 / disc_func_leg
  ----------------------------------------------------------------------*/
disc_func swap_oisois.disc_func_leg1(error_info option(nullable) error) 	{ return swap_gen.swap_disc_func_leg1(error);}
disc_func swap_oisois.disc_func_leg2(error_info option(nullable) error) 	{ return swap_gen.swap_disc_func_leg2(error);}

/*-----------------------------------------------------------------------
  tenor_surface_leg   EXT SWAP: ok
  ----------------------------------------------------------------------*/
tenor_surface swap_oisois.tenor_surface_leg1(error_info option(nullable) error) 	{ return swap_gen.swap_tenor_surface_leg1(error);}
tenor_surface swap_oisois.tenor_surface_leg2(error_info option(nullable) error) 	{ return swap_gen.swap_tenor_surface_leg2(error);}

/*-----------------------------------------------------------------------
  solver
  ----------------------------------------------------------------------*/
number swap_oisois.solver(	number 				pv,
							swap_solver_code 	solver_code,
							logical option(nullable) trade_date_pv,
							error_info option(nullable) error)
{	
	return swap_gen.solver(pv,solver_code,trade_date_pv,error);
}
/*-----------------------------------------------------------------------
  imp_spread_leg1    EXT SWAP: ok
  ----------------------------------------------------------------------*/
number  swap_oisois.imp_spread_leg1(	number 				pv,							
									logical option(nullable) trade_date_pv,
									error_info option(nullable) error) 
{	
	try{	
		instr_error_type t;
   		string 			s;	
		number c = i().__swap_imp_ois_sprd(pv,trade_date_pv,true,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_oisois.imp_spread_leg1");	
		return e ? null<number>: c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_oisois.imp_spread_leg1");		
		return null<number>;
	}
}


/*-----------------------------------------------------------------------
  imp_spread_leg2    EXT SWAP: ok
  ----------------------------------------------------------------------*/
number  swap_oisois.imp_spread_leg2(number 				pv,							
									logical option(nullable) trade_date_pv,
									error_info option(nullable) error) 
{	
	try{	
		instr_error_type t;
   		string 			s;	
		number c = i().__swap_imp_ois_sprd(pv,trade_date_pv,false,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_oisois.imp_spread_leg2");	
		return e ? null<number>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_oisois.imp_spread_leg2");		
		return null<number>;
	}
}



/*-----------------------------------------------------------------------
  swap_instrument
  ----------------------------------------------------------------------*/
ql_fixed_income_swap swap_oisois.swap_instrument(error_info option(nullable) error)
{
	
	return swap_gen.swap_instrument(error);

}

/*-----------------------------------------------------------------------
  ois_legs
  ----------------------------------------------------------------------*/
vector(ql_ois_leg) swap_oisois.ois_legs(logical clone,error_info option(nullable) error)
{
	
	return swap_gen.swap_ois_leg(clone,error);
}

/*-----------------------------------------------------------------------
  legs
  ----------------------------------------------------------------------*/
vector(ql_swap_leg) swap_oisois.legs(logical clone,error_info option(nullable) error)
{
	
	return swap_gen.swap_leg(clone,error);
}

/*-----------------------------------------------------------------------
  float_leg
  ----------------------------------------------------------------------*/
ql_ois_leg swap_oisois.ois_leg1(logical clone,error_info option(nullable) error)
{
	
	vector(ql_ois_leg) l = swap_gen.swap_ois_leg(clone,error);
	return !null(l) ? l[0] : null<ql_ois_leg>;
}

/*-----------------------------------------------------------------------
  ois_leg
  ----------------------------------------------------------------------*/
ql_ois_leg swap_oisois.ois_leg2(logical clone,error_info option(nullable) error)
{
	
	vector(ql_ois_leg) l = swap_gen.swap_ois_leg(clone,error);
	return !null(l) ? l[1] : null<ql_ois_leg>;
}

/*-----------------------------------------------------------------------
  get_legs	EXT SWAP: ok  prot
  ----------------------------------------------------------------------*/
void  swap_oisois.get_legs(	out ql_ois_leg  leg1, 
							out ql_ois_leg  leg2) 
{
	
	error_info ee = new error_info(true,true);
	vector(ql_ois_leg) ois = this.ois_legs(false,ee);
	QL_FAIL_COND(v_size(ois) < 2,"invalid swap_oisois", this, true);
	leg1 = ois[0];
	leg2 = ois[1];
}

/*-----------------------------------------------------------------------
  present_value
  ----------------------------------------------------------------------*/
number swap_oisois.present_value(	disc_func option(nullable) disc_func_leg1,
									disc_func option(nullable) 	disc_func_leg2,
									out number  pv_leg1,
									out number  pv_leg2,
									number option(nullable) 	notional,
									logical option(nullable) 	trade_date_pv,																								
									error_info option(nullable) error)
{	
	return swap_gen.present_value(disc_func_leg1,disc_func_leg2,pv_leg1,pv_leg2,notional,trade_date_pv,error);
}

number swap_oisois.present_value(	disc_func option(nullable)	disc_func_leg1,
									disc_func option(nullable) 	disc_func_leg2,
									out number  pv_leg1,
									out number  pv_leg2,
									date option(nullable) pv_date,
									date option(nullable) settle_date,
									logical  	incl_issue_cf,
									logical  	incl_mat_cf,	
									error_info option(nullable) error)
{	
	return swap_gen.present_value(disc_func_leg1,disc_func_leg2,pv_leg1,pv_leg2,pv_date, settle_date ,incl_issue_cf,incl_mat_cf,error );
}

number swap_oisois.present_value(	out number  pv_leg1,
									out number  pv_leg2,
									logical option(nullable) 	trade_date_pv,
									error_info option(nullable) error)
{	
	return swap_gen.present_value(pv_leg1,pv_leg2,trade_date_pv ,error );
}

/*-----------------------------------------------------------------------
  present_value override and prot
  ----------------------------------------------------------------------*/
/*number  swap_oisois.present_value(	number option(nullable) 	notional,
									logical 					trade_date_pv,
									disc_func option(nullable) 	disc_func_disc,
									error_info option(nullable) error)
{	
	try{	
		notional= conv_null_number_com(notional) ;		
		QL_FAIL_COND(!null(disc_func_disc),"input of disc_func (for trade_date_pv calculation) not supported for swaps", this, true);
		
		QL_FAIL_COND(!null(notional) && ccy_swap_,"input of notional not applicable for currency swaps", this, true);//use a version with 2 notionals or set notional to null	

		number pv_leg1, pv_leg2;
		return present_value(	null<disc_func>,null<disc_func>, pv_leg1, pv_leg2, notional,trade_date_pv,error);					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_oisois.present_value");		
		return null<number>;
	}
}*/

/*-----------------------------------------------------------------------
  present_value  override and prot
  ----------------------------------------------------------------------*/
/*number  swap_oisois.present_value(	disc_func					disc_func,
									number option(nullable) 	notional,
									logical 					trade_date_pv,
									disc_func option(nullable) 	disc_func_disc,
									error_info option(nullable) error) 
{	
	try{	
		notional= conv_null_number_com(notional) ;
		QL_FAIL_COND(!null(disc_func_disc),"input of disc_func (for trade_date_pv calculation) not supported for swaps", this, true);

		QL_FAIL_COND(ccy_swap_,"inapplicable function call for cross currency swaps", this, true);//use a version with 2 disc_funcs	

		number pv_leg1, pv_leg2;
		return present_value(	disc_func,disc_func, pv_leg1, pv_leg2, notional,trade_date_pv,error);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_oisois.present_value");		
		return null<number>;
	}
}*/

/*-----------------------------------------------------------------------
  pv01_spread_leg1	EXT SWAP: ok  - always returns a positive number regardless of pay/receive and sign of notional
  Note: not a "true" measure of risk, does not take into account if the swap has a pv <> 0
   PV01 refers to present value of 1 basis point spread and it's the discounted value of the cashflows
  for a float rate of 0.01% 
  ----------------------------------------------------------------------*/
number  swap_oisois.pv01_spread_leg1(number option(nullable) notional,
										number option(nullable) delta,
										//logical option(nullable) trade_date_pv,
										disc_func option(nullable) df,
										error_info option(nullable) error ) 
{	
	try{	
		instr_error_type t;
   		string 			s;	

		error_info ee 		= new error_info(true,true);
		disc_func df_orig 	= this.disc_func_leg1(ee);
		logical upd 		= false;
		
		if(!null(df)){
			this.add_disc_func_leg1(df);
			upd = true;
		}
		else if(null(df_orig)) {	
			QL_FAIL("discount function not set",this,true);
		}
		
		number c = i().__swap_pvbp_float_leg(notional,delta, true,t, s);
		if(!null(c))
			c = abs(c);
		
		if(upd && !null(df_orig))
			this.add_disc_func_leg1(df_orig);		

		logical e = CORE_INT.add_error_info(error,t,s, "swap_oisois.pv01_spread_leg1");	
		return e ? null<number>: c;								
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_oisois.pv01_spread_leg1");
		return null<number>;
	}
}
/*-----------------------------------------------------------------------
  pv01_spread_leg2	EXT SWAP: ok  - always returns a positive number regardless of pay/receive and sign of notional
  Note: not a "true" measure of risk, does not take into account if the swap has a pv <> 0
   PV01 refers to present value of 1 basis point spread and it's the discounted value of the cashflows
  for a float rate of 0.01% 
  ----------------------------------------------------------------------*/
number  swap_oisois.pv01_spread_leg2(number option(nullable) notional,
										number option(nullable) delta,
										//logical option(nullable) trade_date_pv,
										disc_func option(nullable) df,
										error_info option(nullable) error ) 
{	
	try{	
		instr_error_type t;
   		string 			s;	

		error_info ee 		= new error_info(true,true);
		disc_func df_orig 	= this.disc_func_leg2(ee);
		logical upd 		= false;
		
		if(!null(df)){
			this.add_disc_func_leg2(df);
			upd = true;
		}
		else if(null(df_orig)) {	
			QL_FAIL("discount function not set",this,true);
		}
		
		number c = i().__swap_pvbp_float_leg(notional,delta, false,t, s);
		if(!null(c))
			c = abs(c);
		
		if(upd && !null(df_orig))
			this.add_disc_func_leg2(df_orig);		

		logical e = CORE_INT.add_error_info(error,t,s, "swap_oisois.pv01_spread_leg2");	
		return e ? null<number>: c;								
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_oisois.pv01_spread_leg2");
		return null<number>;
	}
}


/*-----------------------------------------------------------------------
  payment_data_leg1	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_oisois.payment_data_leg1(logical 				post_settle,
									logical option(nullable) trade_date_pv,
									out vector(date)  		fixing_date,
									out vector(number)  	fixing_rate,
									out vector(logical)  	is_fixed,									
									out vector(date)  		pmt_date,
									out vector(number) 		cpn_rate,
									out vector(number)  	cpn_cashflow,
									out vector(number)  	pv_cpn_cashflow,
									out vector(number)  	fee,
									out vector(number)  	pv_fee,
									out vector(number)  	notional ,
									error_info option(nullable)  error ) 
{	
	swap_gen.payment_data_ois_leg(false, post_settle, trade_date_pv, fixing_date, fixing_rate,
						  is_fixed,pmt_date,cpn_rate,cpn_cashflow,pv_cpn_cashflow,
						  fee,pv_fee, notional, error);

}
/*-----------------------------------------------------------------------
  payment_data_leg2	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_oisois.payment_data_leg2(logical 				post_settle,
									logical option(nullable) trade_date_pv,
									out vector(date)  		fixing_date,
									out vector(number)  	fixing_rate,
									out vector(logical)  	is_fixed,									
									out vector(date)  		pmt_date,
									out vector(number) 		cpn_rate,
									out vector(number)  	cpn_cashflow,
									out vector(number)  	pv_cpn_cashflow,
									out vector(number)  	fee,
									out vector(number)  	pv_fee,
									out vector(number)  	notional ,
									error_info option(nullable)  error ) 
{	
	swap_gen.payment_data_ois_leg(true, post_settle, trade_date_pv, fixing_date, fixing_rate,
						  is_fixed,pmt_date,cpn_rate,cpn_cashflow,pv_cpn_cashflow,
						  fee,pv_fee, notional, error);

}

/*-----------------------------------------------------------------------
  principal_data_leg1	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_oisois.principal_data_leg1( 	logical 				post_settle,
											logical option(nullable) trade_date_pv,
											logical 				only_real_cf,
											out vector(date) 		prin_date,
											out vector(number) 		prin_cf,	
											out vector(number) 		pv_prin_cf,
											error_info option(nullable)  error )
{
	swap_gen.principal_data_ois_leg(false, post_settle, trade_date_pv, only_real_cf,
									prin_date,prin_cf,pv_prin_cf,error);
}

/*-----------------------------------------------------------------------
  principal_data_leg2	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_oisois.principal_data_leg2( 	logical 				post_settle,
											logical option(nullable) trade_date_pv,
											logical 				only_real_cf,
											out vector(date) 		prin_date,
											out vector(number) 		prin_cf,	
											out vector(number) 		pv_prin_cf,
											error_info option(nullable)  error )
{
	swap_gen.principal_data_ois_leg(true, post_settle, trade_date_pv, only_real_cf,
									prin_date,prin_cf,pv_prin_cf,error);
}

/*-----------------------------------------------------------------------
  final_pmt_date	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_oisois.final_pmt_date(out date 	final_pmt_date_ois_leg1,									
								out date 	final_pmt_date_ois_leg2,
								error_info option(nullable) error ) 
{	
	swap_gen.final_pmt_date( final_pmt_date_ois_leg1, final_pmt_date_ois_leg2, error ) ;
}