option(null: hard);	
/*	
	instrument wrapper functions
	Developer: Algorithmica Research, Magnus Nyström			

	--------------------------------------------------------------------
	overnight index linked future
	--------------------------------------------------------------------
*/


//-----------------------------------------------------------------------
//  class on_future
//----------------------------------------------------------------------
class on_future: public instrument
option(category: "Instrument/Overnight Future")
//option(allow_undeclared_mfuncs)
{
public:

	//override string	instr_type_s();
	override instrument 	inst();

	//-----add-funcs-----			
	override void 	add_nominal(number );										
	override void 	add_quote(number,logical option(nullable) = null<logical> );
	void 			add_quote(number,..quote_style,logical option(nullable)  = null<logical>);
	void 			add_quote_from_rate(number,logical option(nullable)  = null<logical>);
	void 			add_fixing(	vector(date) option(nullable),vector(number) option(nullable));

	//--general--
	logical 		is_daily_mtm(error_info option(nullable) = null<error_info> );		
	number 			tick_value(number option(nullable),error_info option(nullable) = null<error_info> );
	number 			contract_size(error_info option(nullable) = null<error_info> );	
	number 			tick_size(error_info option(nullable) = null<error_info> );	

	void 			implied_curve_rate(number option(nullable),out number, out number, error_info option(nullable) = null<error_info>);
	number 			settlement_price(out number,out number ,error_info option(nullable) = null<error_info>);
	
	void 			dates(	out vector(date)   option(nullable),out vector(date)   option(nullable),out vector(date)   option(nullable)	,
							out vector(date)   option(nullable)	,out vector(integer) option(nullable),error_info option(nullable) = null<error_info> );

	void 			fixing_data(out vector(date)   option(nullable),out vector(number)   option(nullable),out vector(string)   option(nullable),
							error_info option(nullable) = null<error_info>);

	void 			avg_rates(logical,out number,out number,error_info option(nullable) = null<error_info> );
	void			comp_avg_factor(out number,out number,out date,out date ,error_info option(nullable) = null<error_info> );
	
	number 			adj_coupon(error_info option(nullable) = null<error_info>);
	date			maturity_synt(error_info option(nullable) = null<error_info>);
	date			final_settle_date(error_info option(nullable) = null<error_info>);
	date			last_trade_date(error_info option(nullable) = null<error_info>);
	number 			par_rate(disc_func,error_info option(nullable) = null<error_info>);
	number 			par_rate(fwd_func,error_info option(nullable) = null<error_info>);
	override logical required_fixings_valid(error_info option(nullable) error = null<error_info> ) ;
	date 			fix_period_end_date(error_info option(nullable) error = null<error_info>);
	logical 		in_fixing_period(error_info option(nullable) error= null<error_info>);
	
	override on_future		set_quote(number option(nullable),error_info option(nullable) = null<error_info>);
	override on_future		set_quote(string option(nullable),error_info option(nullable) = null<error_info>);
	override on_future		set_yield(number option(nullable) ,error_info option(nullable) = null<error_info>);


	on_future(__instrument);	
	override on_future clone();
	on_future(on_future);
	
protected:
	
	override on_future		create(__instrument option(nullable),out instr_error option(nullable),error_type type = E_INVALID_ARG);

	override number 		clean_price(disc_func,logical disable_rounding = false,logical in_pcnt = true,
										error_info option(nullable) error = null<error_info>);
	override number 		clean_price(number option(nullable),logical disable_rounding = false,
									logical in_pcnt = true,
									error_info option(nullable) error = null<error_info>);
	
	override number 		yield_to_clean(number,logical disable_rounding = false);						/*legacy*/

	override logical 		on_future_in_fixing_period(error_info option(nullable) error = null<error_info>);
};



//------------------------------------------------
// constructor [HIDDEN, cannot be protected]
//------------------------------------------------
on_future.on_future(__instrument i) option(hidden) : instrument(i){}

//------------------------------------------------
// create  [PROTECTED]
// create frn from internal instrument
//------------------------------------------------
on_future on_future.create(	__instrument option(nullable) c,
										out instr_error option(nullable) error,
										error_type type )
{
	QL_FAIL_COND(null(c), "invalid/unknown (null) instrument",type );

	logical valid = c.is_valid(error);
	if( !valid && INSTR_CREATE_NULL_ERR)
		return null<on_future>; 
	
	..instr_type it = c.instr_type(error);
	QL_FAIL_COND(null(it), "invalid instrument type (unknown)",type );
	QL_FAIL_COND(it != ..instr_type.OVERNIGHT_FUTURE, "invalid instrument type",type );//should not happen

	
	return new on_future(c);
}


/*-----------------------------------------------------------------------
  create_on_future <FUNCTION>
  ----------------------------------------------------------------------*/
on_future create_on_future(	__instrument option(nullable) c,
										out instr_error option(nullable) error,
										error_type type = E_INVALID_ARG)
option(com_name: 'INTERNAL_create_on_future')
{
	QL_FAIL_COND(null(c), "invalid/unknown (null) instrument",type );

	logical valid = c.is_valid(error);
	if( !valid && INSTR_CREATE_NULL_ERR)
		return null<on_future>; 
	
	..instr_type it = c.instr_type(error);
	QL_FAIL_COND(null(it), "invalid instrument type (unknown)",type );
	QL_FAIL_COND(it != ..instr_type.OVERNIGHT_FUTURE, "invalid instrument type",type );//should not happen

	return new on_future(c);
}

on_future create_on_future(	__instrument option(nullable) 		c,
							error_info option(nullable) 		error,
							error_type 							type = E_INIT)
option(com_name: 'INTERNAL_create_on_future_ei')
{
	instr_error ee 	= instr_error();
	on_future b 	= create_on_future(c,ee, E_INIT);
	if(ee.is_error())
		CORE_INT.add_error_info(error,ee.type(),ee.message(), "create_on_future");
	return b;
}
//------------------------------------------------
// instr_type_s
//------------------------------------------------
//string on_future.instr_type_s()  		{ return string(..instr_type.OVERNIGHT_FUTURE);}
//------------------------------------------------
// inst
//------------------------------------------------
instrument 	on_future.inst()			{ return this;}
//------------------------------------------------
// copy constructor
//------------------------------------------------
on_future.on_future(on_future c) : instrument(c) {}
//------------------------------------------------
// copy constructor <FUNCTION>
//------------------------------------------------
on_future on_future(on_future b)			{ return new on_future(b);}
//------------------------------------------------
// clone
//------------------------------------------------
on_future on_future.clone()		{ return new on_future(this);}
//-----------------------------------------------
// dynamic cast <FUNCTION>
//-----------------------------------------------
on_future	on_future(instrument i, error_info option(nullable) error = null<error_info>) 	
option (category: 'Instrument/Overnight Future')
option(com_name: 'on_future_dyncast') 
{ 
	try {
		on_future d = dynamic_cast<on_future>(i); 
		if(null(d))
			CORE_INT.add_error_info(error,ERR_T_INIT,"invalid cast (instrument is not a on_future)","on_future" );

		return d;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "on_future");
		return null<on_future>;
	}
}
/*-----------------------------------------------------------------------
  add_nominal 
  ----------------------------------------------------------------------*/
void on_future.add_nominal(number nominal) 
{			
	instrument.add_nominal(nominal );
	return ;						
}

/*-----------------------------------------------------------------------
  ir_future: add_quote
  ----------------------------------------------------------------------*/
void on_future.add_quote(	number  quote,
							logical option(nullable) set_to_par ) 
{	
	instrument.add_quote(quote, set_to_par);
	return ;					
	
}
/*-----------------------------------------------------------------------
  on_future: add_quote
  ----------------------------------------------------------------------*/
void on_future.add_quote(	number  quote,
							..quote_style quote_style,
							logical option(nullable) set_to_par ) 
{
	error_info ee = new error_info(true,true);
	..quote_style qs = instrument.quote_style_e(ee);
	
	if(quote_style == qs)
		instrument.add_quote(quote, set_to_par);
	else{
		if(quote_style == ..quote_style.YIELD) {
			if(qs == ..quote_style.YIELD_PCT)
				instrument.add_quote(quote*100, set_to_par);
			else if(qs == ..quote_style.EDFUT)
				instrument.add_quote(100-quote*100,set_to_par);
			else
				QL_FAIL("invalid quote style", this, true);
		}
		else if(quote_style == ..quote_style.YIELD_PCT){
			if(qs == ..quote_style.YIELD)
				instrument.add_quote(quote/100, set_to_par);
			else if(qs == ..quote_style.EDFUT)
				instrument.add_quote(100-quote, set_to_par);
			else
				QL_FAIL("invalid quote style", this, true);
		}
		else if(quote_style == ..quote_style.EDFUT){
			if(qs == ..quote_style.YIELD)
				instrument.add_quote((100.0-quote)/100, set_to_par);
			else if(qs == ..quote_style.YIELD_PCT)
				instrument.add_quote(100.0-quote, set_to_par);
			else
				QL_FAIL("invalid quote style", this, true);
		}
		else
			QL_FAIL("invalid quote style", this, true);
	}					
}
/*-----------------------------------------------------------------------
  add_quote_from_rate
  ----------------------------------------------------------------------*/
void on_future.add_quote_from_rate(	number  rate,
								logical option(nullable) set_to_par ) 
{	
	instrument.add_quote_from_yield(rate,  set_to_par );
	return ;						
}
/*-----------------------------------------------------------------------
  add_fixing
  currently it is necessary to update all rates/dates
  ----------------------------------------------------------------------*/
void on_future.add_fixing(vector(date) option(nullable) fixing_dates,	
					vector(number) option(nullable) fixing_rates)
{	
	i().__onfut_add_fixing(fixing_dates,fixing_rates);
	return ;						
}
/*-----------------------------------------------------------------------
  riba: set_quote 
  ----------------------------------------------------------------------*/
on_future on_future.set_quote(	number 	option(nullable) quote,
						error_info option(nullable) error)
{	
	instrument cc = instrument._set_quote(quote,null<date>, null<date>, true,error);
	return null(cc) ? null<on_future>: dynamic_cast<on_future>(cc);
}

/*-----------------------------------------------------------------------
  set_quote 
  ----------------------------------------------------------------------*/
on_future on_future.set_quote(	string 	option(nullable) quote_side,
							error_info option(nullable) error)
{	
	instrument cc = instrument._set_quote(quote_side,null<date>, null<date>, true,error);
	return null(cc) ? null<on_future>: dynamic_cast<on_future>(cc);
}

/*-----------------------------------------------------------------------
  set_yield
  ----------------------------------------------------------------------*/
on_future on_future.set_yield(	number 	option(nullable) yield,						
						error_info option(nullable) error)
{	
	instrument cc = instrument._set_yield(	yield, null<date>, null<date>,true, error);
	return null(cc) ? null<on_future>: dynamic_cast<on_future>(cc);
}


logical on_future.is_daily_mtm(error_info option(nullable) error) 	{ return instrument.fut_daily_mtm(error);}
number  on_future.tick_value(number  option(nullable) tick_size,									
							error_info option(nullable) error) 		{ return instrument.fut_tick_value(tick_size,error); }
number  on_future.contract_size(error_info option(nullable) error)	{ return instrument.fut_contract_size(error);}
number  on_future.tick_size(error_info option(nullable) error)		{ return instrument.fut_tick_size(error);}

/*-----------------------------------------------------------------------
  maturity_synt
  ----------------------------------------------------------------------*/
date on_future.maturity_synt(error_info option(nullable) error)
{
	try{	
		instr_error_type t;
   		string 			s;	
		date c = i().__onfut_maturity_risk(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "on_future.maturity_synt");	
		return e ? null<date>: c;			
								
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "on_future.maturity_synt");	
		return null<date>;
	}
}

/*-----------------------------------------------------------------------
  final_settle_date
  ----------------------------------------------------------------------*/
date on_future.final_settle_date(error_info option(nullable) error)
{
	try{	
		instr_error_type t;
   		string 			s;	
		date c = i().__onfut_final_settle(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "on_future.final_settle_date");	
		return e ? null<date>: c;	
								
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "on_future.final_settle_date");	
		return null<date>;
	}
}

/*-----------------------------------------------------------------------
  last_trade_date
  ----------------------------------------------------------------------*/
date on_future.last_trade_date(error_info option(nullable) error)
{
	try{	
		instr_error_type t;
   		string 			s;	
		date c = i().__onfut_last_trade(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "on_future.last_trade_date");	
		return e ? null<date>: c;			
								
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "on_future.last_trade_date");	
		return null<date>;
	}
}

/*-----------------------------------------------------------------------
  required_fixings_valid  must be overridden for instruments that have fixings that may be required at init
  ----------------------------------------------------------------------*/
logical	on_future.required_fixings_valid(error_info option(nullable) error ) 
{
	try{	
		instr_error_type t;
   		string 			s;	
		logical c = i().__onfut_req_fixing_ok(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "on_future.required_fixings_valid");	
		return e ? null<logical>: c;			
								
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "on_future.required_fixings_valid");	
		return null<logical>;
	}
}

/*-----------------------------------------------------------------------
  on_future: dates

  ----------------------------------------------------------------------*/
void on_future.dates(	out vector(date)   option(nullable)	dates,
						out vector(date)   option(nullable)	publish_dates,
						out vector(date)   option(nullable)	on_start,
						out vector(date)   option(nullable)	on_end,
						out vector(integer) option(nullable) weight,
						error_info option(nullable) error)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		i().__onfut_dates(dates,publish_dates,on_start,on_end,weight,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "on_future.dates");	
		if(e){ 
			dates = publish_dates = on_start = on_end = null<vector(date)>;
			weight = null<vector(integer)>;
		}		
		return ;						
	}
	catch {
		dates = publish_dates = on_start = on_end = null<vector(date)>;
		weight = null<vector(integer)>;
		CORE_INT.catch_error_info(error,err.type(),err.message(), "on_future.dates");	
		return ;
	}
}

/*-----------------------------------------------------------------------
  on_future: fixing
//status code: 0 = not used, 1= required, 2 = optional
  ----------------------------------------------------------------------*/
void on_future.fixing_data(	out vector(date)   option(nullable)		publish_dates,
							out vector(number)   option(nullable)	rates,
							out vector(string)   option(nullable)	status_code,																
							error_info option(nullable) 			error)
{	
	try{	
		instr_error_type t;
   		string 			s;
		vector(integer)  s_code;	
		i().__onfut_fixing_data(publish_dates,rates,s_code,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "on_future.fixing_data");	
		if(e){ 
			publish_dates = null<vector(date)>;
			rates = null<vector(number)>;
			status_code = null<vector(string)>;
		}
		else {
			resize(status_code,v_size(s_code));
			for (integer i=0;i<v_size(s_code);i++) {
				switch (s_code[i]) {
				case 0:
					status_code[i] = "not fixed";
					break;
				case 1:
					status_code[i] = "fixed";
					break;
				case 2:	
					status_code[i] = "optional";
					break;
				default:
					status_code[i] = null<string>;
				}
			}
		}		
		return ;						
	}
	catch {
		publish_dates = null<vector(date)>;
		rates = null<vector(number)>;
		status_code = null<vector(string)>;
		CORE_INT.catch_error_info(error,err.type(),err.message(), "on_future.fixing_data");	
		return ;
	}
}

/*-----------------------------------------------------------------------
  on_future: avg_rates

  ----------------------------------------------------------------------*/
void on_future.avg_rates(	logical adjust,
							out number	hist_avg,
							out number	imp_fwd_avg,															
							error_info option(nullable) error)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		i().__onfut_avg(adjust,hist_avg,imp_fwd_avg,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "on_future.avg_rates");	
		if(e){ 		
			hist_avg = imp_fwd_avg = null<number>;			
		}		
		return ;						
	}
	catch {
		hist_avg = imp_fwd_avg = null<number>;	
		CORE_INT.catch_error_info(error,err.type(),err.message(), "on_future.avg_rates");	
		return ;
	}
}

/*-----------------------------------------------------------------------
  on_future: adj_coupon
  ----------------------------------------------------------------------*/
number  on_future.adj_coupon(error_info option(nullable) error)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		number c = i().__onfut_adj_coupon(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "on_future.adj_coupon");	
		return e ? null<number>: c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "on_future.adj_coupon");	
		return null<number>;
	}
}

/*-----------------------------------------------------------------------
  implied_curve_rate
  ----------------------------------------------------------------------*/
void on_future.implied_curve_rate(number option(nullable) market_rate,  
									out number imp_rate, 
									out number imp_rate_comp,
									error_info option(nullable) error)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		i().__onfut_implied_curve_rate(market_rate,imp_rate,imp_rate_comp,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "on_future.implied_curve_rate");	
		if(e){
			imp_rate_comp = imp_rate = null<number>;
		}
		return ;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "on_future.implied_curve_rate");	
		imp_rate_comp = imp_rate = null<number>;
		return ;
	}
}

/*-----------------------------------------------------------------------
  settlement_price
  ----------------------------------------------------------------------*/
number on_future.settlement_price(out number term, 
								out number settlement_rate,
								error_info option(nullable) error)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		number c = i().__onfut_settle_price(term,settlement_rate,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "on_future.settlement_price");	
		if(e){
			term = settlement_rate = null<number>;
			return null<number>;
		}
		return c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "on_future.settlement_price");
		term = settlement_rate = null<number>;
		return null<number>;
	}
}

/*-----------------------------------------------------------------------
  comp_avg_factor
  ----------------------------------------------------------------------*/
void on_future.comp_avg_factor(out number curr_comp_avg, 
								out number curr_rate,
								 out date start,
								 out date end,
								error_info option(nullable) error)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		i().__onfut_comp_avg_factor(curr_comp_avg,curr_rate,start,end,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "on_future.comp_avg_factor");	
		if(e){
			curr_comp_avg = curr_rate = null<number>;
			start = end = null<date>;
			return ;
		}
		return ;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "on_future.comp_avg_factor");
		curr_comp_avg = curr_rate = null<number>;
		start = end = null<date>;
		return ;
	}
}
/*-----------------------------------------------------------------------
  fix_period_end_date
  if expired --> returns maturity
  if before fixing period --> returns null
  otherwise --> return end_date_;
  ----------------------------------------------------------------------*/
date on_future.fix_period_end_date(error_info option(nullable) error)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		date c = i().__onfut_fix_period_end_date(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "on_future.fix_period_end_date");	
		return e ? null<date>: c;					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "on_future.fix_period_end_date");	
		return null<date>;
	}
}
/*-----------------------------------------------------------------------
  in_fixing_period
  ----------------------------------------------------------------------*/
logical on_future.in_fixing_period(error_info option(nullable) error)
{
	try{
		error_info ee = new error_info(true,true);	
		date fe = this.fix_period_end_date(ee);
		return !null(fe);					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "on_future.in_fixing_period");	
		return null<logical>;
	}
}

logical on_future.on_future_in_fixing_period(error_info option(nullable) error) { return this.in_fixing_period(error);}

/*-----------------------------------------------------------------------
  par_rate
  ----------------------------------------------------------------------*/
number on_future.par_rate(disc_func disc_func,
						error_info option(nullable) error)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		number r = i().__onfut_par_rate_df(disc_func,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "on_future.par_rate");	
		if(e){
			return null<number>;;
		}
		return r;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "on_future.par_rate");
		return null<number>;
	}
}


/*-----------------------------------------------------------------------
  par_rate
  ----------------------------------------------------------------------*/
number on_future.par_rate(fwd_func fwd_func,
						error_info option(nullable) error)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		number r = i().__onfut_par_rate_f(fwd_func,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "on_future.par_rate");	
		if(e){
			return null<number>;;
		}
		return r;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "on_future.par_rate");
		return null<number>;
	}
}


/*-----------------------------------------------------------------------
  clean_price  disable clean price for on futures since it has no clear meaning (especially in fixing period)
  ----------------------------------------------------------------------*/
number  on_future.clean_price(	disc_func		df,
							logical 		d,								
							logical 		in_p,									
							error_info option(nullable) e) 
{	
 	return fin_instr.err_type(null<number>, e,"clean_price(disc_func)");
}

number on_future.yield_to_clean(	number	yield,
							logical disable_rounding) 
{
	error_info  e;
	return fin_instr.err_type(null<number>, e,"yield_to_clean()");
}

number  on_future.clean_price(	number	option(nullable)	yield,
								logical 					disable_rounding,
								logical 					in_pcnt,									
								error_info option(nullable) e)
{	
 	return fin_instr.err_type(null<number>, e,"clean_price()");
}

