option(null: hard);	
/*	
	instrument wrapper functions
	Developer: Algorithmica Research, Magnus Nyström			

	--------------------------------------------------------------------
	riba
	--------------------------------------------------------------------
*/

//-----------------------------------------------------------------------
//  class riba
//----------------------------------------------------------------------
class riba: public instrument
option(category: "Instrument/Riba")
//option(allow_undeclared_mfuncs)
{
public:

	//override string			instr_type_s();
	override instrument 	inst();

	//-----add-funcs-----			
	override void 			add_nominal(number );										
	override void 			add_quote(number,logical option(nullable) l = null<logical> );

	//-----general-----
	
	override string 		maturity_code(error_info option(nullable) error = null<error_info> );
	override day_count_method dc_method(error_info option(nullable) error = null<error_info> );
	number 					contract_rate(error_info option(nullable) error = null<error_info> );
	override logical 		required_fixings_valid(error_info option(nullable) error = null<error_info> ) ;
	//-----price-----
	number 					rate(logical dr = false,error_info option(nullable) error = null<error_info> );	
	number 					rate(disc_func ,logical disable_rounding = false,error_info option(nullable) error = null<error_info>);

	number 					accrued(logical , logical disable_rounding = false,logical in_pcnt = true,
									error_info option(nullable) error = null<error_info>);
	
	//-----
	logical 				is_daily_mtm(error_info option(nullable) error = null<error_info> );		
	number 					tick_value(number,error_info option(nullable) error = null<error_info> );	
	number 					contract_size(error_info option(nullable) error = null<error_info> );	
	override calendar 		fixing_calendar(error_info option(nullable) error = null<error_info> );			
	override string 		fixing_calendar_name(error_info option(nullable) error = null<error_info> );

	logical 				is_fixed(error_info option(nullable) error = null<error_info>); 
	number 					final_fix_rate(error_info option(nullable) error = null<error_info>);
	date 					final_settlement_date(error_info option(nullable) error = null<error_info>);
	date 					expiry_date(error_info option(nullable) error = null<error_info>);
	date 					fix_period_end_date(error_info option(nullable) error = null<error_info>);
	logical 				in_fixing_period(error_info option(nullable) error= null<error_info>);
	number 					price(error_info option(nullable) error = null<error_info>);

	number 					settle_amount(	number ,number option(nullable) contract_rate = null<number>,
											number option(nullable) nominal = 100,
											logical option(nullable) l=null<logical>,
											error_info option(nullable) error = null<error_info>);
	
	number 					settle_amount_df(	disc_func,number option(nullable) contract_rate = null<number>,
												number option(nullable) nominal = 100,
												logical option(nullable) l=null<logical>,
												error_info option(nullable) error = null<error_info>);

	number 					settle_amount_to_market_rate(number, number option(nullable),logical option(nullable),
														error_info option(nullable) error = null<error_info>);	

	number 					settle_amount_to_contract_rate(number, number option(nullable),logical option(nullable),
														error_info option(nullable) error = null<error_info>);	

	number 					pv_curve(number,number ,disc_func ,logical option(nullable) l=null<logical>,
									 error_info option(nullable) error = null<error_info>);
	
	override number 		pvbp(number option(nullable) ,number  option(nullable),	error_info option(nullable) error = null<error_info>) ;

	number 					pvbp_df(number,disc_func,number ,error_info option(nullable) error = null<error_info>);
	number 					pvbp_implied(number,number ,error_info option(nullable) error = null<error_info>);
	number 					implied_curve_rate(number,error_info option(nullable) error = null<error_info>);
	number 					implied_rate(disc_func,error_info option(nullable) error = null<error_info>);
	number 					implied_rate_risk(disc_func,number ,error_info option(nullable) error = null<error_info>);
	void 					repo_data(disc_func,out vector(number) ,out vector(date),
										out vector(date)  , error_info option(nullable) error = null<error_info>);


	//-----cashflow-funcs-----
	vector(date) 		cash_flow_dates(logical in_period_adj = false, error_info option(nullable) error = null<error_info>);
	vector(number) 		cash_flows(logical,number option(nullable),logical,logical in_period_adj = false,error_info option(nullable) error = null<error_info> );
	vector(number) 		cash_flows_cpn(logical,number option(nullable),error_info option(nullable) error = null<error_info> );
	void  				cash_flow_data(	logical	,number option(nullable),logical,logical,out vector(date) ,out vector(number) ,
										error_info option(nullable) error = null<error_info>);	//here to hide cash_flow_data in root
	
	/*---set functions-required--*/	
	override riba		set_quote(number option(nullable),error_info option(nullable) error = null<error_info>);
	override riba		set_quote(string option(nullable),error_info option(nullable) error = null<error_info>);	

	//local set
	riba  				set_date(date,/*date option(nullable),*/logical,logical ,error_info option(nullable) error = null<error_info>);	
	
	riba				set_quote(	number option(nullable),date option(nullable) trade_date ,
									logical option(nullable) set_to_par = true,
									error_info option(nullable) error = null<error_info>);
	
	riba				set_quote(string option(nullable),date option(nullable) trade_date  , 
								logical option(nullable) set_to_par= true, error_info option(nullable) error = null<error_info>);

	riba				set_rate(number option(nullable) ,error_info option(nullable) error = null<error_info>);

	riba				set_rate(number option(nullable) ,date option(nullable),
								logical option(nullable) set_to_par = true, error_info option(nullable) error = null<error_info>);

	// does not work since sd=id when not in fix period
	//override riba  		set_settle_date(date,logical,out instr_error option(nullable) );


	riba(__instrument);	
	override riba clone();
	riba(riba);
	
protected:
	
	override riba 			create(__instrument option(nullable),out instr_error option(nullable),error_type type = E_INVALID_ARG); 

	override riba			set_yield(number option(nullable) ,error_info option(nullable) error = null<error_info>);
	
	override riba  			set_date(date,date option(nullable),logical,logical ,error_info option(nullable) error = null<error_info>);						

	override riba 			set_date(date,logical ,error_info option(nullable) error = null<error_info>);								/*legacy*/
	override riba 			move_date(date,date option(nullable) s = null<date>, error_info option(nullable) error = null<error_info>);  		/*legacy*/  

	override vector(date)	cash_flow_dates(logical ,logical, logical, error_info option(nullable) error = null<error_info> );
	override vector(date) 	cash_flow_dates_noadj(	logical ,error_info option(nullable) error = null<error_info>) ;
	override vector(number)	cash_flows_cpn(number option(nullable) nom = null<number>,logical posts = true, logical k=false,
										   error_info option(nullable) error = null<error_info>); 
	override void 			cash_flows(	out vector(date),out vector(number),number option(nullable) ,
										logical ,error_info option(nullable) error = null<error_info>);
	override vector(number)	cash_flows(number option(nullable) nom = null<number>,logical posts = true, logical k=false,
									   error_info option(nullable) error = null<error_info>);
	override vector(number)	cash_flow_nom_amounts(number option(nullable) ,logical ,logical ,error_info option(nullable) error= null<error_info>) ;
	override vector(number)	cash_flow_amounts(number option(nullable) ,logical ,logical ,error_info option(nullable) error= null<error_info>) ;
	
	override void 			cash_flow_data(	number option(nullable) ,logical ,ir_cf_code ,logical, logical ,out vector(date)   ,
											out vector(number)   ,error_info option(nullable) error = null<error_info>);

	override number  		accrued(logical ,logical,error_info option(nullable) ) ;
	
	override logical 		riba_is_fixed(error_info option(nullable) error = null<error_info>);
	override logical 		riba_in_fixing_period(error_info option(nullable) error = null<error_info>);
	override number 		riba_final_fix_rate(error_info option(nullable) error = null<error_info>);
	override date 			riba_final_settlement_date(error_info option(nullable) error = null<error_info>);
	override date 			riba_expiry_date(error_info option(nullable) error = null<error_info>);
	override date 			riba_fix_period_end_date(error_info option(nullable) error = null<error_info>);
	override number 		riba_price(error_info option(nullable) error = null<error_info>);

	override number 		riba_settle_amount(	number ,number option(nullable) contract_rate = null<number>,
												number option(nullable) nominal = 100,
												error_info option(nullable) error = null<error_info>);
	
	override number 		riba_settle_amount_df(	disc_func,number option(nullable) contract_rate = null<number>,
												number option(nullable) nominal = 100,
												error_info option(nullable) error = null<error_info>);
	
	override number 		riba_pv_curve(number,number ,disc_func ,error_info option(nullable) error = null<error_info>);
	override number 		riba_pvbp(number option(nullable),number option(nullable),error_info option(nullable) error = null<error_info>);
	override number 		riba_pvbp_df(number,disc_func,number ,error_info option(nullable) error = null<error_info>);
	override number 		riba_pvbp_implied(number,number ,error_info option(nullable) error = null<error_info>);
	override number 		riba_implied_curve_rate(number,error_info option(nullable) error = null<error_info>);
	override number 		riba_implied_rate(disc_func,error_info option(nullable) error = null<error_info>);
	override number 		riba_implied_rate_risk(disc_func,number ,error_info option(nullable) error = null<error_info>);
	override void 			riba_repo_data(disc_func,out vector(number)  	,out vector(date)  	,
									out vector(date)  	, error_info option(nullable) error = null<error_info>);


	override number 		clean_price(disc_func,logical disable_rounding = false,logical in_pcnt = true,
										error_info option(nullable) error = null<error_info>);
	override number 		clean_price(number option(nullable),logical disable_rounding = false,
									logical in_pcnt = true,
									error_info option(nullable) error = null<error_info>);
	
	override number 		yield_to_clean(number,logical disable_rounding = false);						/*legacy*/	
};

//------------------------------------------------
// constructor [HIDDEN, cannot be protected]
//------------------------------------------------
riba.riba(__instrument i) option(hidden) : instrument(i){}

//------------------------------------------------
// create  [PROTECTED]
// create riba from internal instrument
//------------------------------------------------
riba riba.create(	__instrument option(nullable) c,
					out instr_error option(nullable) error,
					error_type type )
{
	QL_FAIL_COND(null(c), "invalid/unknown (null) instrument",type );

	logical valid = c.is_valid(error);
	if( !valid && INSTR_CREATE_NULL_ERR)
		return null<riba>; 
	
	..instr_type it = c.instr_type(error);
	QL_FAIL_COND(null(it), "invalid instrument type (unknown)",type );
	QL_FAIL_COND(it != ..instr_type.RIBA, "invalid instrument type",type );//should not happen
	
	return new riba(c);
}

/*-----------------------------------------------------------------------
  create_riba <FUNCTION>
  ----------------------------------------------------------------------*/

riba create_riba(	__instrument option(nullable) c,
				out instr_error option(nullable) error,
				error_type type = E_INVALID_ARG)
option(com_name: 'INTERNAL_create_riba')
{
	QL_FAIL_COND(null(c), "invalid/unknown (null) instrument",type );

	logical valid = c.is_valid(error);
	if( !valid && INSTR_CREATE_NULL_ERR)
		return null<riba>; 
	
	..instr_type it = c.instr_type(error);
	QL_FAIL_COND(null(it), "invalid instrument type (unknown)",type );
	QL_FAIL_COND(it != ..instr_type.RIBA, "invalid instrument type",type );//should not happen
	
	return new riba(c);
}

riba create_riba(	__instrument option(nullable) 		c,
					error_info option(nullable) 		error,
					error_type 							type = E_INIT)
option(com_name: 'INTERNAL_create_riba_ei')
{
	instr_error ee 	= instr_error();
	riba b 	= create_riba(c,ee, E_INIT);
	if(ee.is_error())
		CORE_INT.add_error_info(error,ee.type(),ee.message(), "create_riba");
	return b;
}

//------------------------------------------------
// instr_type_s
//------------------------------------------------
//string riba.instr_type_s()  { return string(..instr_type.RIBA);}
//------------------------------------------------
// inst
//------------------------------------------------
instrument 	riba.inst()		{ return this;}
//------------------------------------------------
// copy constructor
//------------------------------------------------
riba.riba(riba c) : instrument(c) {}
//------------------------------------------------
// copy constructor <FUNCTION>
//------------------------------------------------
riba riba(riba b)			{ return new riba(b);}
//------------------------------------------------
// clone
//------------------------------------------------
riba riba.clone()			{ return new riba(this);}
//-----------------------------------------------
// dynamic cast <FUNCTION>
//-----------------------------------------------
riba 	riba (instrument i, error_info option(nullable) error = null<error_info>) 	
option (category: 'Instrument/Riba')
option(com_name: 'riba_dyncast')
{ 
	try {
		riba d = dynamic_cast<riba>(i); 
		if(null(d))
			CORE_INT.add_error_info(error,ERR_T_INIT,"invalid cast (instrument is not a riba)","riba" );

		return d;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "riba");
		return null<riba>;
	}
}


/*-----------------------------------------------------------------------
  add_nominal 
  ----------------------------------------------------------------------*/
void riba.add_nominal(number nominal) 
{			
	instrument.add_nominal(nominal );
	return ;						
}

/*-----------------------------------------------------------------------
  add_quote
  ----------------------------------------------------------------------*/
void riba.add_quote(	number  quote,
						logical option(nullable) set_to_par ) 
{	
	instrument.add_quote(quote, set_to_par);
	return ;						
}

/*-----------------------------------------------------------------------
  hidden in root members
  ----------------------------------------------------------------------*/
string 	riba.maturity_code(error_info option(nullable) error) 		{ return instrument.maturity_code(error);}
number  riba.contract_rate(error_info option(nullable) error)		{ return instrument.coupon(error);}
day_count_method riba.dc_method(error_info option(nullable) error)	{ return instrument.dc_method(error);}
number  riba.rate(logical disable_rounding, error_info option(nullable) error) 	{ return instrument.yield( disable_rounding,error);}
number  riba.rate(disc_func disc_func, logical disable_rounding,
				  error_info option(nullable) error)				{ return instrument.yield( disc_func,disable_rounding,error);}
logical riba.is_daily_mtm(error_info option(nullable) error) 		{ return instrument.fut_daily_mtm(error);}
number  riba.tick_value(number tick_size, error_info option(nullable) error) 	{ return instrument.fut_tick_value(tick_size,error); }
number  riba.contract_size(error_info option(nullable) error)		{ return instrument.fut_contract_size(error);}
calendar riba.fixing_calendar(error_info option(nullable) error) 	{ return instrument.fixing_calendar(error) ;}
string riba.fixing_calendar_name(error_info option(nullable) error) option(hidden) 		{ return instrument.fixing_calendar_name(error) ;}

logical riba.riba_is_fixed(error_info option(nullable) error)		{ return this.is_fixed(error);}
logical riba.riba_in_fixing_period(error_info option(nullable) error) { return this.in_fixing_period(error);}

number riba.riba_final_fix_rate(error_info option(nullable) error)	{ return this.final_fix_rate(error);}
date riba.riba_fix_period_end_date(error_info option(nullable) error) option(hidden)	{ return this.fix_period_end_date(error);}
date riba.riba_final_settlement_date(error_info option(nullable) error)					{ return this.final_settlement_date(error);}
date riba.riba_expiry_date(error_info option(nullable) error)			{ return this.expiry_date(error);	}
number riba.riba_price(error_info option(nullable) error)				{ return this.price(error);	}
number riba.riba_settle_amount(	number 					market_rate,
								number option(nullable) contract_rate,
								number option(nullable) nominal,			
								error_info option(nullable) error)		{ return this.settle_amount(market_rate,contract_rate,nominal,null<logical>,error);	}
number riba.riba_settle_amount_df(	disc_func   disc_func,
									number  option(nullable)	contract_rate,
									number  option(nullable) 	nominal,
									error_info option(nullable) error) 	{ return this.settle_amount_df(disc_func,contract_rate,nominal,null<logical>,error);	}
number riba.riba_pv_curve(	number  	contract_rate,
							number  	nominal,
							disc_func   disc_func,
							error_info option(nullable) error) 			{ return this.pv_curve(contract_rate,nominal,disc_func,null<logical>,error);}
number riba.riba_pvbp(	number option(nullable) 	nominal,   
						number option(nullable) 	risk_shift,	
						error_info option(nullable) error)				{ return this.pvbp(nominal, risk_shift, error);}
number riba.riba_pvbp_df(	number  	nominal,
							disc_func   disc_func,   
							number  	risk_shift,	
							error_info option(nullable) error) 			{ return this.pvbp_df(nominal, disc_func,risk_shift,error);}
number riba.riba_pvbp_implied(	number  	nominal,   
								number  	risk_shift,	
								error_info option(nullable) error)		{ return this.pvbp_implied(nominal, risk_shift,error);}
number riba.riba_implied_curve_rate(number  	market_rate,   
									error_info option(nullable) error) 	{ return this.implied_curve_rate(	market_rate,  error);}
number riba.riba_implied_rate(	disc_func  	disc_func,   
								error_info option(nullable) error)		{ return this.implied_rate(disc_func,  error);}
number riba.riba_implied_rate_risk(	disc_func  	disc_func, 
									number 		risk_shift,  
									error_info option(nullable) error) 	{ return this.implied_rate_risk(disc_func,  risk_shift, error);}
void riba.riba_repo_data(disc_func  disc_func,						
						out vector(number)  repo_rates,
						out vector(date)  	start_dates,
						out vector(date)  	end_dates,							
						error_info option(nullable) error) 				{ this.repo_data( disc_func,repo_rates,start_dates,end_dates,error);}

/*-----------------------------------------------------------------------
  riba: set_date
	if trade date is the same --> the settle date will be preserved (if not input)	

  ----------------------------------------------------------------------*/
riba riba.set_date(	date  				trade_date, 
					logical 			re_init_static, 
					logical 			re_init_quote, 
					error_info option(nullable) error)
{	
	instrument cc = instrument._set_date(trade_date,null<date>,re_init_static,re_init_quote,error);
	return null(cc) ? null<riba>: dynamic_cast<riba>(cc);	
}

/*-----------------------------------------------------------------------
  riba: set_date
	if trade date is the same --> the settle date will be preserved (if not input)	

  ----------------------------------------------------------------------*/
riba riba.set_date(	date  				trade_date, 
					date  option(nullable)	settle_date,
					logical 			re_init_static, 
					logical 			re_init_quote, 
					error_info option(nullable) error)
{	
	instrument cc = instrument._set_date(trade_date,null<date>,re_init_static,re_init_quote,error);
	return null(cc) ? null<riba>: dynamic_cast<riba>(cc);	
}

/*-----------------------------------------------------------------------
  set_date  <protected/legacy>
	quote is NOT kept even if trade_date is unchanged
  ----------------------------------------------------------------------*/
riba riba.set_date(	date  				trade_date, 
					logical 			re_initialize, 
					error_info option(nullable) error) 
{	
	instrument cc = instrument._set_date(trade_date,re_initialize,error);
	return null(cc) ? null<riba>: dynamic_cast<riba>(cc);	
}

/*-----------------------------------------------------------------------
  riba: move_date  <protected/legacy>
	changes the trade date of the instrument without retrieving the 
 	corresponding quote from the database or the real-time feed.
	if trade date is the same --> the settle date will be preserved
  ----------------------------------------------------------------------*/
riba riba.move_date(	date  				trade_date, 
						date option(nullable) settle_date,
						error_info option(nullable) error)
{	
	instrument cc = instrument._move_date(trade_date,null<date>,error);
	return null(cc) ? null<riba>: dynamic_cast<riba>(cc);
}

/*-----------------------------------------------------------------------
  riba: set_settle_date
  ----------------------------------------------------------------------*/
/*riba riba.set_settle_date(	date  				settle_date, 
							logical 			re_init_static, 
							error_info option(nullable) error)
option(com_name: 'set_settle_date_e')
{		
	instrument cc = instrument._set_settle_date(settle_date, re_init_static, error);
	return null(cc) ? null<riba>: dynamic_cast<riba>(cc);
}
*/
/*-----------------------------------------------------------------------
  set_rate
  ----------------------------------------------------------------------*/
riba riba.set_rate(	number 	option(nullable) rate,
					error_info option(nullable) error)
{
	logical set_to_par = true;
	instrument cc = instrument._set_yield(	rate, null<date>, null<date>,set_to_par, error);
	return null(cc) ? null<riba>: dynamic_cast<riba>(cc);
}


/*-----------------------------------------------------------------------
  riba: set_rate
  ----------------------------------------------------------------------*/
riba riba.set_rate(number 	option(nullable) rate,
					date  	option(nullable) trade_date, 
					logical option(nullable) set_to_par,
					error_info option(nullable) error) option(com_name: 'set_rate_ext')
{	
	instrument cc = instrument._set_yield(	rate, trade_date,  null<date>,set_to_par, error);
	return null(cc) ? null<riba>: dynamic_cast<riba>(cc);
}

/*-----------------------------------------------------------------------
  riba: set_yield
  ----------------------------------------------------------------------*/
riba riba.set_yield(	number 	option(nullable) yield,						
						error_info option(nullable) error)
{
	logical set_to_par = true;
	instrument cc = instrument._set_yield(	yield, null<date>, null<date>,set_to_par, error);
	return null(cc) ? null<riba>: dynamic_cast<riba>(cc);
}

/*-----------------------------------------------------------------------
  riba: set_quote 
  ----------------------------------------------------------------------*/
riba riba.set_quote(	number 	option(nullable) quote,
						error_info option(nullable) error)
{
	logical set_to_par = true;
	instrument cc = instrument._set_quote(quote,null<date>, null<date>, set_to_par,error);
	return null(cc) ? null<riba>: dynamic_cast<riba>(cc);
}


/*-----------------------------------------------------------------------
  riba: set_quote 
  ----------------------------------------------------------------------*/
riba riba.set_quote(	number 	option(nullable) quote,
						date  	option(nullable) trade_date, 
						//date  	option(nullable) settle_date, 
						logical option(nullable) set_to_par,
						error_info option(nullable) error)
{	
	instrument cc = instrument._set_quote(quote,trade_date, null<date>, set_to_par,error);
	return null(cc) ? null<riba>: dynamic_cast<riba>(cc);
}

/*-----------------------------------------------------------------------
  riba: set_quote 
  ----------------------------------------------------------------------*/
riba riba.set_quote(	string 	option(nullable) quote_side,
						error_info option(nullable) error)
{
	logical set_to_par = true;
	instrument cc = instrument._set_quote(quote_side,null<date>, null<date>, set_to_par,error);
	return null(cc) ? null<riba>: dynamic_cast<riba>(cc);
}

/*-----------------------------------------------------------------------
  riba: set_quote
  ----------------------------------------------------------------------*/
riba riba.set_quote(	string 	option(nullable) quote_side,
						date  	option(nullable) trade_date, 
						//date  	option(nullable) settle_date, 
						logical option(nullable) set_to_par,
						error_info option(nullable) error)
{	
	instrument cc = instrument._set_quote(quote_side,trade_date, null<date>, set_to_par,error);
	return null(cc) ? null<riba>: dynamic_cast<riba>(cc);
}

/*-----------------------------------------------------------------------
  riba: is_fixed
  ----------------------------------------------------------------------*/
logical riba.is_fixed(error_info option(nullable) error)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		logical c = i().__riba_is_fixed(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "riba.is_fixed");	
		return e ? null<logical>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "riba.is_fixed");	
		return null<logical>;
	}
}
/*-----------------------------------------------------------------------
  required_fixings_valid  must be overridden for instruments that have fixings that may be required at init
  ----------------------------------------------------------------------*/
logical	riba.required_fixings_valid(error_info option(nullable) error ) 
{
	try{	
		instr_error_type t;
   		string 			s;	
		logical c = i().__riba_req_fixing_ok(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "riba.required_fixings_valid");	
		return e ? null<logical>: c;			
								
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "riba.required_fixings_valid");	
		return null<logical>;
	}
}
/*-----------------------------------------------------------------------
  riba: final_fix_rate
  ----------------------------------------------------------------------*/
number riba.final_fix_rate(error_info option(nullable) error)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		number c = i().__riba_final_fix_rate(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "riba.final_fix_rate");	
		return e ? null<number>: c;					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "riba.final_fix_rate");	
		return null<number>;
	}

}

/*-----------------------------------------------------------------------
  riba: fix_period_end_date
  if is_fixed --> returns maturity
  if before fixing period --> returns null
  otherwise --> return end_date_;
  ----------------------------------------------------------------------*/
date riba.fix_period_end_date(error_info option(nullable) error)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		date c = i().__riba_fix_period_end_date(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "riba.fix_period_end_date");	
		return e ? null<date>: c;					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "riba.fix_period_end_date");	
		return null<date>;
	}
}
/*-----------------------------------------------------------------------
  in_fixing_period
  ----------------------------------------------------------------------*/
logical riba.in_fixing_period(error_info option(nullable) error)
{
	try{
		error_info ee = new error_info(true,true);	
		date fe = this.fix_period_end_date(ee);
		return !null(fe);					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "riba.in_fixing_period");	
		return null<logical>;
	}
}
/*-----------------------------------------------------------------------
  riba: final_settlement_date
  ----------------------------------------------------------------------*/
date riba.final_settlement_date(error_info option(nullable) error)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		date c = i().__riba_final_settlement_date(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "riba.final_settlement_date");	
		return e ? null<date>: c;					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "riba.final_settlement_date");	
		return null<date>;
	}
}

/*-----------------------------------------------------------------------
  riba: expiry_date
  ----------------------------------------------------------------------*/
date riba.expiry_date(error_info option(nullable) error)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		date c = i().__riba_expiry_date(t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "riba.expiry_date");	
		return e ? null<date>: c;					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "riba.expiry_date");	
		return null<date>;
	}
}

/*-----------------------------------------------------------------------
  riba: price  --> 100-r*100
  equivalent to quote(..quote_style.EDFUT,ee);
  ----------------------------------------------------------------------*/
number riba.price(error_info option(nullable) error) option(hidden)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		number c = i().__riba_price(t, s);
		
		logical e = CORE_INT.add_error_info(error,t,s, "riba.price");	
		return e ? null<number>: c;					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "riba.price");	
		return null<number >;
	}
}

/*-----------------------------------------------------------------------
  riba: settle_amount
  ----------------------------------------------------------------------*/
number riba.settle_amount(	number 					market_rate,
							number option(nullable) contract_rate,
							number option(nullable) nominal,
							logical option(nullable) sign_lend,
							error_info option(nullable) error)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		number c = i().__riba_settle_amount(market_rate,contract_rate,nominal,sign_lend,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "riba.settle_amount");	
		return e ? null<number>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "riba.settle_amount");	
		return null<number >;
	}
}

/*-----------------------------------------------------------------------
  riba: settle_amount_df
  ----------------------------------------------------------------------*/
number riba.settle_amount_df(	disc_func   disc_func,
								number  option(nullable)	contract_rate,
								number  option(nullable) 	nominal,
								logical option(nullable) sign_lend,
								error_info option(nullable) error)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		number c = i().__riba_settle_amount_df(disc_func,contract_rate,nominal,sign_lend,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "riba.settle_amount_df");	
		return e ? null<number>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "riba.settle_amount_df");	
		return null<number >;
	}
}

/*-----------------------------------------------------------------------
  riba_pv_curve
  ----------------------------------------------------------------------*/
number riba.pv_curve(	number  	contract_rate,
						number  	nominal,
						disc_func   disc_func,
						logical option(nullable) sign_lend,
						error_info option(nullable) error) 
{	
	try{	
		instr_error_type t;
   		string 			s;	
		number c = i().__riba_pv_curve(contract_rate,nominal,disc_func,sign_lend,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "riba.pv_curve");	
		return e ? null<number>: c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "riba.pv_curve");	
		return null<number >;
	}
}

/*-----------------------------------------------------------------------
  riba: pvbp  simple tick value calculation i.e. FULL PERIOD
  ----------------------------------------------------------------------*/
number riba.pvbp(	number  option(nullable)	nominal,   
					number  option(nullable)	risk_shift,	
					error_info option(nullable) error)  
{	
	try{	
		instr_error_type t;
   		string 			s;	
		number c = i().__riba_pvbp(nominal,risk_shift,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "riba.pvbp");	
		return e ? null<number>: c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "riba.pvbp");	
		return null<number >;
	}
}

/*-----------------------------------------------------------------------
  riba: pvbp_df
  ----------------------------------------------------------------------*/
number riba.pvbp_df(	number  	nominal,
						disc_func   disc_func,   
						number  	risk_shift,	
						error_info option(nullable) error)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		number c = i().__riba_pvbp_df(nominal,disc_func,risk_shift,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "riba.pvbp_df");	
		return e ? null<number>: c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "riba.pvbp_df");	
		return null<number >;
	}
}

/*-----------------------------------------------------------------------
  riba: pvbp_implied
  ----------------------------------------------------------------------*/
number riba.pvbp_implied(	number  	nominal,   
							number  	risk_shift,	
							error_info option(nullable) error)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		number c = i().__riba_pvbp_implied(nominal,risk_shift,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "riba.pvbp_implied");	
		return e ? null<number>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "riba.pvbp_implied");	
		return null<number >;
	}
}

/*-----------------------------------------------------------------------
  riba: implied_curve_rate
  ----------------------------------------------------------------------*/
number riba.implied_curve_rate(	number  	market_rate,   
								error_info option(nullable) error)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		number c = i().__riba_implied_curve_rate(market_rate,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "riba.implied_curve_rate");	
		return e ? null<number>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "riba.implied_curve_rate");	
		return null<number >;
	}
}

/*-----------------------------------------------------------------------
  riba: implied_rate
  ----------------------------------------------------------------------*/
number riba.implied_rate(	disc_func  	disc_func,   
							error_info option(nullable) error)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		number c = i().__riba_implied_rate(disc_func,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "riba.implied_rate");	
		return e ? null<number>: c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "riba.implied_rate");	
		return null<number >;
	}
}

/*-----------------------------------------------------------------------
  riba: implied_rate_risk
  ----------------------------------------------------------------------*/
number riba.implied_rate_risk(	disc_func  	disc_func, 
								number 		risk_shift,  
								error_info option(nullable) error)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		number c = i().__riba_implied_rate_risk(disc_func,risk_shift,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "riba.implied_rate_risk");	
		return e ? null<number>: c;							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "riba.implied_rate_risk");	
		return null<number >;
	}
}

/*-----------------------------------------------------------------------
  riba: repo_data

  ----------------------------------------------------------------------*/
void riba.repo_data(	disc_func  			disc_func,						
						out vector(number)  repo_rates,
						out vector(date)  	start_dates,
						out vector(date)  	end_dates,							
						error_info option(nullable) 		error)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		i().__riba_repo_data(disc_func,repo_rates,start_dates,end_dates,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "riba.repo_data");	
		
		if(e){ 
			repo_rates = null<vector(number)>;
			start_dates = end_dates = null<vector(date)>;
		}		
		return ;						
	}
	catch {
		repo_rates = null<vector(number)>;
		start_dates = end_dates = null<vector(date)>;
		CORE_INT.catch_error_info(error,err.type(),err.message(), "riba.repo_data");	
		return ;
	}
}

/*-----------------------------------------------------------------------
  clean_price  disable clean price for riba since it has no clear meaning (especially in fixing period)
  ----------------------------------------------------------------------*/
number  riba.clean_price(	disc_func		df,
							logical 		d,								
							logical 		in_p,									
							error_info option(nullable) e) 
{	
 	return fin_instr.err_type(null<number>, e,"clean_price(disc_func)");
}

number riba.yield_to_clean(	number	yield,
							logical disable_rounding) 
{
	error_info  e;
	return fin_instr.err_type(null<number>, e,"yield_to_clean()");
}

number  riba.clean_price(	number	option(nullable)	yield,
								logical 					disable_rounding,
								logical 					in_pcnt,									
								error_info option(nullable) e)
{	
 	return fin_instr.err_type(null<number>, e,"clean_price()");
}
/*-----------------------------------------------------------------------
  riba: cash_flow_dates
  ----------------------------------------------------------------------*/
vector(date) riba.cash_flow_dates(logical in_fix_period_adj,error_info option(nullable) error)
{	
	try{	
		instr_error_type t;
   		string 			s;
		vector(date) dates;	
		vector(number) a;
		
		i().__riba_cash_flows(100,true,true,false,in_fix_period_adj,dates,a,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "riba.cash_flow_dates");	
		return e ? null<vector(date)>: dates;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "riba.cash_flow_dates");	
		return null<vector(date)>;
	}
}

/*-----------------------------------------------------------------------
  riba: cash_flow_dates  (override+protected)
  ----------------------------------------------------------------------*/
vector(date) riba.cash_flow_dates(logical post_settle,
										logical adj_dates, 
										logical keep_size,
										error_info option(nullable) error)
{	
	return this.cash_flow_dates(true,error );
}

/*-----------------------------------------------------------------------
 cash_flow_dates_noadj  (override+protected)  LEGACY
  ----------------------------------------------------------------------*/
vector(date) riba.cash_flow_dates_noadj(	logical 	post_settle,
											error_info option(nullable) error) 												
{	
	return this.cash_flow_dates(true,error );
}

/*-----------------------------------------------------------------------
  cash_flow_amounts   (override+protected)  LEGACY
  ----------------------------------------------------------------------*/
vector(number) riba.cash_flow_amounts(number option(nullable) nominal,
											logical post_settle,
											logical keep_size,											
											error_info option(nullable) error) 
{	
	return this.cash_flows(false,nominal,true,true,error);
}


/*-----------------------------------------------------------------------
  cash_flow_nom_amounts  (override+protected)  LEGACY
  ----------------------------------------------------------------------*/
vector(number) riba.cash_flow_nom_amounts(number option(nullable) nominal,
												logical post_settle,
												logical keep_size,
												error_info option(nullable) error) 
{	
	return this.cash_flows(false,nominal,true,true,error);
}
/*-----------------------------------------------------------------------
  cash_flows  (override+protected)  LEGACY
  ----------------------------------------------------------------------*/
void riba.cash_flows(	out vector(date)   dates,
						out vector(number)   amounts,
						number option(nullable) nominal ,
						logical post_settle,							
						error_info option(nullable) error)
{
	try{
		nominal= conv_null_number_com(nominal) ;
		error_info ee = new error_info(true,true);
		
		dates = this.cash_flow_dates(true,ee );			
		amounts = this.cash_flows(false,nominal,true,true,ee);
		
		return;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.cash_flows");
		dates = null<vector(date)>;
		amounts = null<vector(number)>;
		return ;
	}
}
/*-----------------------------------------------------------------------
  riba: cash_flows
  ----------------------------------------------------------------------*/
vector(number) riba.cash_flows(		logical					borrow,
									number option(nullable) nominal,
									logical					imp_loan_flow,
									logical 				in_fix_period_adj,
									error_info option(nullable) error)
{	
	try{	
		instr_error_type t;
   		string 			s;
		vector(date) d;	
		vector(number) amounts;	
		i().__riba_cash_flows(nominal,borrow,imp_loan_flow,false,in_fix_period_adj,d,amounts,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "riba.cash_flows");	
		return e ? null<vector(number)>: amounts;					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "riba.cash_flows");	
		return null<vector(number)>;
	}
}

/*-----------------------------------------------------------------------
  riba: cash_flows (override+protected)
  ----------------------------------------------------------------------*/
vector(number) riba.cash_flows(number option(nullable) nominal ,
										logical post_settle, 
										logical keep_size,
										error_info option(nullable) error)
{	
	return this.cash_flows(false,nominal,true,true,error);
}

/*-----------------------------------------------------------------------
  riba: cash_flows_cpn
  ----------------------------------------------------------------------*/
vector(number) riba.cash_flows_cpn(	logical					borrow,
									number option(nullable) nominal,
									error_info option(nullable) error)
{	
	try{	
		instr_error_type t;
   		string 			s;
		vector(date) d;	
		vector(number) amounts;	
		i().__riba_cash_flows(nominal,borrow,true,true,false,d,amounts,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "riba.cash_flows_cpn");	
		return e ? null<vector(number)>: amounts;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "riba.cash_flows_cpn");	
		return null<vector(number)>;
	}
}

/*-----------------------------------------------------------------------
  riba: cash_flows_cpn  (override+protected)
  ----------------------------------------------------------------------*/
vector(number) riba.cash_flows_cpn(number option(nullable) nominal ,
										logical post_settle, 
										logical keep_size,
										error_info option(nullable) error)
{	
	return this.cash_flows_cpn(false,nominal,error);
}

/*-----------------------------------------------------------------------
  riba: cash_flows
  ----------------------------------------------------------------------*/
/*void riba.cash_flows(	number option(nullable) nominal ,
							logical post_settle,
							out vector(date)   dates,
    						out vector(number)   amounts,
							error_info option(nullable) error)
{	
	this.cash_flows(false,nominal,true,dates,amounts,error);
}
*/
/*-----------------------------------------------------------------------
  riba: cash_flow_data
  ----------------------------------------------------------------------*/
void riba.cash_flow_data(	logical					borrow,
							number option(nullable) nominal,
							logical					imp_loan_flow,
							logical 				in_fix_period_adj,
							out vector(date)   		dates,
							out vector(number)   	amounts,								
							error_info option(nullable) error)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		i().__riba_cash_flows(nominal,borrow,imp_loan_flow,false,in_fix_period_adj,dates,amounts,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "riba.cash_flow_data");	
		if(e){ 
			dates = null<vector(date)>;
			amounts = null<vector(number)>;
		}		
		return ;						
	}
	catch {
		dates = null<vector(date)>;
		amounts = null<vector(number)>;
		CORE_INT.catch_error_info(error,err.type(),err.message(), "riba.cash_flow_data");	
		return ;
	}
}

/*-----------------------------------------------------------------------
  riba: cash_flow_data  (override+protected)
  ----------------------------------------------------------------------*/
void riba.cash_flow_data(	number option(nullable) 	nominal,
								logical 				post_settle,
								ir_cf_code 				cf_code,
								logical 				adj_dates, 
								logical 				keep_size,
								out vector(date)   		dates,
								out vector(number)   	amounts,								
								error_info option(nullable) error)
{	
	try {
		error_info ee = error_info(true,true);
		dates = this.cash_flow_dates(true,ee);

		if(cf_code == ir_cf_code.COUPON) {
			amounts = this.cash_flows_cpn(false,nominal,ee);
		}
		else if(cf_code == ir_cf_code.PRINCIPAL){
			vector(number) cpn = this.cash_flows_cpn(false,nominal,ee);
			amounts = this.cash_flows(false,nominal,true,true,ee);
			amounts[1] -= cpn[1]; 
		}
		else {
			amounts = this.cash_flows(false,nominal,true,true,ee);
		}
	}
	catch {
		dates = null<vector(date)>;
		amounts = null<vector(number)>;
		CORE_INT.catch_error_info(error,err.type(),err.message(), "riba.cash_flow_data");	
		return;
	}
}


/*-----------------------------------------------------------------------
  settle_amount_to_market_rate 
  ----------------------------------------------------------------------*/
number riba.settle_amount_to_market_rate(number amount_pcnt,
										number option(nullable)	contract_rate,								
										logical option(nullable) sign_lend,
										error_info option(nullable) error)	
{	
	try{	
		instr_error_type t;
   		string 			s;	
		number c = i().__riba_settle_amount_to_mkt_rate(amount_pcnt,contract_rate,sign_lend,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "riba.settle_amount_to_market_rate");	
		return e ? null<number>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "riba.settle_amount_to_market_rate");	
		return null<number>;
	}
}

/*-----------------------------------------------------------------------
  settle_amount_to_rate 
  ----------------------------------------------------------------------*/
number  riba.settle_amount_to_contract_rate(	number amount_pcnt,
												number option(nullable)	market_rate,								
												logical option(nullable) sign_lend,
												error_info option(nullable) error)
{	
	try{	
		instr_error_type t;
   		string 			s;	
		number c = i().__riba_settle_amount_to_contract_rate(amount_pcnt,market_rate,sign_lend,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "riba.settle_amount_to_contract_rate");	
		return e ? null<number>: c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "riba.settle_amount_to_contract_rate");	
		return null<number>;
	}
}

/*-----------------------------------------------------------------------
  riba: accrued
  ----------------------------------------------------------------------*/
number  riba.accrued(logical in_fix_period_adj,
					logical disable_rounding,
					logical in_pcnt,									
					error_info option(nullable) error) 
{	
	try{	
		instr_error_type t;
   		string 			s;
		number c;
		if(in_fix_period_adj){
			number accr_net_s,accr_period_s,accr_net_fix,accr_period_fix;
			number accr_s, accr_hist_s, accr_fix, accr_hist_fix;
			
			i().__riba_accrued_legacy(	in_pcnt, null<date>,accr_s, accr_hist_s,accr_net_s,accr_period_s,
										accr_fix, accr_hist_fix,accr_net_fix,accr_period_fix, t, s);
			c = accr_net_s;
		}
		else {
			c = i().__accrued(disable_rounding,in_pcnt, t, s);//0 for riba even if "in_fix_period"			
		}		
		logical e = CORE_INT.add_error_info(error,t,s, "riba.accrued");	
		return e ? null<number>: c;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "riba.accrued");
		return null<number>;
	}
}

/*-----------------------------------------------------------------------
  riba: accrued (override+protected)
  ----------------------------------------------------------------------*/
number  riba.accrued(	logical 	disable_rounding,
						logical 	in_pcnt,									
						error_info option(nullable) error) 
{
	logical in_fix_period_adj = false;
	return this.accrued(in_fix_period_adj, disable_rounding, in_pcnt,error);
}