option(null: hard);	
/*	
	instrument wrapper functions
	Developer: Algorithmica Research, Magnus Nyström			

	--------------------------------------------------------------------
	swap_il_fixyy
	--------------------------------------------------------------------
*/


//-----------------------------------------------------------------------
//  class swap_il_fixyy
//----------------------------------------------------------------------
class swap_il_fixyy: public swap_gen
option (category: 'Instrument/Inflation Linked/Fixed vs Y-Y')
//option(allow_undeclared_mfuncs)
{
public:

	//override string			instr_type_s();
	override instrument 	inst();
	override swap_il_fixyy 	clone();
	
	override void                	__dbg_print(__dbg_label);
    override void                	__dbg_browse(__dbg_split);

	/*----------ADD FUNCS [PUBLIC]---------------*/
	
	void 		add_quote(number,..quote_style );//???i.e. means add new cpn --> should be a new instrument
	override void 		add_quote(number);	
	void 		add_notional(number );
	void 		add_notional(number , number);
	void 		add_disc_func(disc_func option(nullable)); 
	void 		add_disc_func_fix_leg(disc_func option(nullable));
	void 		add_disc_func_infl_index_leg(disc_func option(nullable));	
	void 		add_cpi_link(..cpi_link);
	void 		add_cpi_link_forecast(..cpi_link);
	
	/*----------MISC FUNCS [PUBLIC]---------------*/
	logical		pay_inflation(error_info option(nullable) error = null<error_info>);
	number 		notional(error_info option(nullable) error = null<error_info>);

	/*----------CASHFLOW FUNCS [PUBLIC]---------------*/

	/*----------PV FUNCS [PUBLIC]---------------*/

	number  	present_value(	disc_func option(nullable),out number ,
											out number ,number option(nullable) ,
											logical option(nullable) trade_date_pv = false,		
											error_info option(nullable) error = null<error_info>);
	
	number  	present_value(	disc_func option(nullable),out number ,
											out number,date option(nullable) ,date option(nullable) ,
											logical,logical  ,error_info option(nullable) error = null<error_info>);
	
	override number  	present_value(	out number ,out number ,
											logical option(nullable) ,error_info option(nullable) error = null<error_info> );

	number		pv01(	number option(nullable),number option(nullable),
									disc_func option(nullable) df = null<disc_func>,
									error_info option(nullable) error = null<error_info>);
	
	/*----------INFL-FIX-RATE LEG FUNCS [PUBLIC]---------------*/
	disc_func 	disc_func_fix_leg(error_info option(nullable) error = null<error_info> ) ;			
	number		infl_fix_rate(error_info option(nullable) error = null<error_info> );

	/*----------INFL-INDEX-LEG FUNCS [PUBLIC]---------------*/
	disc_func 	disc_func_infl_leg(error_info option(nullable) error = null<error_info> ) ;
	integer 	index_freq(	error_info option(nullable) error = null<error_info> ); 
	//number 			index_factor(error_info option(nullable) error = null<error_info> ); 
	//number 			index_factor(date option(nullable),date,error_info option(nullable) error = null<error_info> );
	
	infl_index_method 	index_method(error_info option(nullable) error = null<error_info> );
	logical 			is_noip_index_method(error_info option(nullable) error = null<error_info>);
	
	..cpi_link 	cpi_link(error_info option(nullable) error = null<error_info> );
	..cpi_link 	cpi_link_forecast(error_info option(nullable) error = null<error_info> );	
	//void  		cpi_knots(	logical ,out date ,out date  ,out logical 	,
	//							out logical  	,error_info option(nullable) error = null<error_info> );
	//void  		cpi_values(logical,out date ,out date  ,out number  ,out number   ,error_info option(nullable) error = null<error_info> ); 
	
	
	//-----external swap specific-----
	override instrument_type 	swap_type(error_info option(nullable) error = null<error_info> );
	vector(ql_swap_leg) 	legs(logical,error_info option(nullable) error = null<error_info>);
	ql_yy_infl_leg 			infl_index_leg(logical,error_info option(nullable) error = null<error_info>);
	ql_fix_leg 				infl_rate_leg(logical,error_info option(nullable) error = null<error_info>);
	override ql_fixed_income_swap 	swap_instrument(error_info option(nullable) error = null<error_info>) ;

	/*---set functions-required--*/
	override swap_il_fixyy	set_quote(number option(nullable),error_info option(nullable) error = null<error_info>);
	override swap_il_fixyy	set_quote(string option(nullable),error_info option(nullable) error = null<error_info>);

	/*-----set functions-if applicable-----*/
	swap_il_fixyy			set_infl_rate_fix_leg(number option(nullable) ,error_info option(nullable) error = null<error_info>);
	swap_il_fixyy			set_pay_leg(logical ,error_info option(nullable) error = null<error_info>);

	//local set funcs
	swap_il_fixyy 			set_date(date,date option(nullable) settle_date=null<date>, error_info option(nullable) error = null<error_info>);
	override swap_il_fixyy 	set_date(date,date option(nullable),logical,logical , error_info option(nullable) error = null<error_info> );

	
	/*----------HIDDEN FUNCS [PUBLIC]-(mostly for backward compat)--------------*/
	swap_il_fixyy(__instrument);
	
	
	swap_il_fixyy(swap_il_fixyy);
protected:
	override swap_il_fixyy		create(__instrument option(nullable),out instr_error option(nullable),error_type type = E_INVALID_ARG);
	swap_il_fixyy 				err_type(swap_il_fixyy option(nullable), error_info option(nullable) error = null<error_info>);

		
	override number 		pvbp(number option(nullable),number option(nullable),logical option(nullable),
								logical option(nullable),	error_info option(nullable) error = null<error_info>) ;
	
	override number 		pvbp(number option(nullable),number  option(nullable),
								 error_info option(nullable) error = null<error_info>);

	//set funcs
	override swap_il_fixyy	set_date(date,logical ,error_info option(nullable) error = null<error_info> );							/*legacy*/
	
	override swap_il_fixyy 	move_date(	date,date option(nullable) settle_date=null<date> ,
										error_info option(nullable) error = null<error_info>);

	override swap_il_fixyy	set_yield(number option(nullable) ,error_info option(nullable) error = null<error_info> );
	override swap_il_fixyy	set_quote_from_yield(number option(nullable),error_info option(nullable) error = null<error_info> );		/*legacy*/
	
	//logical ext_swap_;
	//logical ccy_swap_;
	//logical full_swap_;
 
};

//------------------------------------------------
// __dbg_print
//------------------------------------------------
void swap_il_fixyy.__dbg_print(__dbg_label l)
{
    error_info ee 	= new error_info(true,false);
    l.set_text(strcat([
						"name: ",
						name(ee),
						",  ext_swap: ",
						null(ext_swap_) ? "" : string(ext_swap_),
                        ", ccy_swap: ",
						null(ccy_swap_) ? "" : string(ccy_swap_),
						", valid: ",
						null(this.is_valid(ee)) ? "" : string(this.is_valid(ee))
					]));
}
//------------------------------------------------
// __dbg_browse
//------------------------------------------------
void swap_il_fixyy.__dbg_browse(__dbg_split s)
{
    s.resize(4);
	error_info ee 	= new error_info(true,false);
    s.set_text(0, "name");
    s.set_value(0, this.name(ee));

    s.set_text(1, "ext_swap");
    s.set_value(1, ext_swap_);

    s.set_text(2, "ccy_swap");
    s.set_value(2, ccy_swap_);

	s.set_text(3, "valid");
    s.set_value(3, is_valid(ee));
}
//------------------------------------------------
// copy constructor
//------------------------------------------------
swap_il_fixyy.swap_il_fixyy(swap_il_fixyy c) : swap_gen(c) {}
//------------------------------------------------
// constructor [HIDDEN, cannot be protected]
//------------------------------------------------
swap_il_fixyy.swap_il_fixyy(__instrument i) option(hidden) : swap_gen(i)
{
	//try {
		error_info ee = new error_info(true,false);
		if(!this.is_valid(ee)) {
			ext_swap_ = ccy_swap_ = full_swap_ = false;
			return;
		}
		ext_swap_ = this.is_ext_swap(ee);
		ccy_swap_ = this.is_ccy_swap(ee);
		full_swap_	= this.verify_full_swap(true,ee);
		
			
		return;									
	//}
	//catch {		
	//	CORE_INT.write_warning_message(err.message());
	//}
}
//------------------------------------------------
// instr_type_s
//------------------------------------------------
//string swap_il_fixyy.instr_type_s()  { return string(..instr_type.IL_SWAP_FIX_Y_Y);}
//------------------------------------------------
// inst
//------------------------------------------------
instrument 	swap_il_fixyy.inst()		{ return this;}

//------------------------------------------------
// copy constructor <FUNCTION>
//------------------------------------------------
swap_il_fixyy swap_il_fixyy(swap_il_fixyy b)			{ return new swap_il_fixyy(b);}
//------------------------------------------------
// clone
//------------------------------------------------
swap_il_fixyy swap_il_fixyy.clone() 	{ return new swap_il_fixyy(this);}
//------------------------------------------------
// create  [PROTECTED]
// create swap_il_fixyy from internal instrument
//------------------------------------------------
swap_il_fixyy swap_il_fixyy.create(__instrument option(nullable) c,
								out instr_error option(nullable) error,
								error_type type )
{
	QL_FAIL_COND(null(c), "invalid/unknown (null) instrument",type );

	logical valid = c.is_valid(error);
	if( !valid && INSTR_CREATE_NULL_ERR)
		return null<swap_il_fixyy>; 
	
	..instr_type it = c.instr_type(error);
	QL_FAIL_COND(null(it), "invalid instrument type (unknown)",type );
	QL_FAIL_COND(it != ..instr_type.IL_SWAP_FIX_Y_Y, "invalid instrument type",type );//should not happen
	
	return new swap_il_fixyy(c);
}
/*-----------------------------------------------------------------------
  create_swap_il_fixyy  <FUNCTION>
  ----------------------------------------------------------------------*/
swap_il_fixyy create_swap_il_fixyy(	__instrument option(nullable) c,
											out instr_error option(nullable) error,
											error_type type = E_INVALID_ARG)
option(com_name: 'INTERNAL_create_swap_il_fixyy')
{
	QL_FAIL_COND(null(c), "invalid/unknown (null) instrument",type );

	logical valid = c.is_valid(error);
	if(!valid && INSTR_CREATE_NULL_ERR)
		return null<swap_il_fixyy>; 
	
	..instr_type it = c.instr_type(error);
	QL_FAIL_COND(null(it), "invalid instrument type (unknown)",type );
	QL_FAIL_COND(it != ..instr_type.IL_SWAP_FIX_Y_Y, "invalid instrument type",type );//should not happen
	
	return new swap_il_fixyy(c);
}

swap_il_fixyy create_swap_il_fixyy(	__instrument option(nullable) 		c,
								error_info option(nullable) 		error,
								error_type 							type = E_INIT)
option(com_name: 'INTERNAL_create_swap_il_fixyy_ei')
{
	instr_error ee 	= instr_error();
	swap_il_fixyy b 	= create_swap_il_fixyy(c,ee, E_INIT);
	if(ee.is_error())
		 CORE_INT.add_error_info(error,ee.type(),ee.message(), "create_swap_il_fixyy");
	return b;
}
//-----------------------------------------------
// constructor <FUNCTION> dynamic cast  EXT SWAP: ok
//-----------------------------------------------
swap_il_fixyy	swap_il_fixyy(instrument i, error_info option(nullable) error = null<error_info>) 	
option (category: 'Instrument/Inflation Linked/Fixed vs Y-Y')
option(com_name: 'swap_il_fixyy_dyncast') 
{ 
	try {
		swap_il_fixyy d = dynamic_cast<swap_il_fixyy>(i); 
		if(null(d))
			CORE_INT.add_error_info(error,ERR_T_INIT,"invalid cast (instrument is not an swap_il_fixyy)","swap_il_fixyy" );

		return d;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_il_fixyy");
		return null<swap_il_fixyy>;
	}
}

/*-----------------------------------------------------------------------
  err_type	EXT SWAP: ok
  ----------------------------------------------------------------------*/
swap_il_fixyy swap_il_fixyy.err_type(swap_il_fixyy option(nullable) nul, error_info option(nullable) error )
{	
	CORE_INT.add_error_info(error,ERR_T_CALC,"mwlib(ql) error: inapplicable function call for current instrument type");
	return null<swap_il_fixyy>;
}

/*-----------------------------------------------------------------------
  add_quote		EXT SWAP: ok
  ----------------------------------------------------------------------*/
void swap_il_fixyy.add_quote(	number  quote ) 
{	
	instrument.add_quote(quote, true);
	return ;						
}
/*-----------------------------------------------------------------------
  add_quote		EXT SWAP: ok
  ----------------------------------------------------------------------*/
void swap_il_fixyy.add_quote(	number  quote,
							..quote_style quote_style) 
{
	error_info ee = new error_info(true,true);
	..quote_style qs = instrument.quote_style_e(ee);
	
	if(quote_style == qs)
		this.add_quote(quote);
	else{
		if(quote_style == ..quote_style.YIELD)
			this.add_quote(quote*100);//instr quotestyle must be pct
		else if(quote_style == ..quote_style.YIELD_PCT)
			this.add_quote(quote/100);//instr quotestyle is not pct
		else
			QL_FAIL("invalid quote style");
	}					
}

/*-----------------------------------------------------------------------
  swap_il_fixyy: add_funcs   EXT SWAP: ok
  ----------------------------------------------------------------------*/
void swap_il_fixyy.add_notional(number notional)							{ swap_gen.swap_add_notional(notional);}		//if ccy swap: err
void swap_il_fixyy.add_notional(number notional1, number notional2)			{ swap_gen.swap_add_notional(notional1, notional2);}
void swap_il_fixyy.add_disc_func(disc_func option(nullable) df)				{ swap_gen.swap_add_disc_func(df); }	//if ccy swap: err
void swap_il_fixyy.add_disc_func_fix_leg(disc_func option(nullable) df)		{ swap_gen.swap_add_disc_func_leg1(df); } //if non ccy swap: both legs will be updated
void swap_il_fixyy.add_disc_func_infl_index_leg(disc_func  option(nullable) df) { swap_gen.swap_add_disc_func_leg2(df); }	//if non ccy swap: both legs will be updated
/*-----------------------------------------------------------------------
  add_cpi_link	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void swap_il_fixyy.add_cpi_link(..cpi_link cpi_link)
{	
	error_info ee = error_info(true,true);
	ql_yy_infl_leg l = infl_index_leg(false,ee );			
	l.set_cpi(cpi_link);
	return;
	
}
/*-----------------------------------------------------------------------
  add_cpi_link_forecast	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void swap_il_fixyy.add_cpi_link_forecast(..cpi_link cpi_link)
{
	error_info ee = error_info(true,true);
	ql_yy_infl_leg l = infl_index_leg(false,ee );			
	l.set_cpi_forecast(cpi_link);
	return;
}
/*-----------------------------------------------------------------------
  notional	EXT SWAP: ok
  ----------------------------------------------------------------------*/
/*void  swap_il_fixyy.notional(out number notional_fix_leg, 
							out number notional_flt_leg, 
							error_info option(nullable) error ) 
{	
	try{	
		instr_error_type t;
   		string 			s;	
		i().__swap_notional(notional_fix_leg,notional_flt_leg,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_il_fixyy.notional");
		if(e)
			notional_fix_leg = notional_flt_leg = null<number >;
		return;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_il_fixyy.notional");
		notional_fix_leg = notional_flt_leg = null<number >;
		return ;
	}
}*/


/*-----------------------------------------------------------------------
  notional	EXT SWAP: ok
  ----------------------------------------------------------------------*/
number  swap_il_fixyy.notional(	error_info option(nullable) error ) 
{	
	return swap_gen.nominal(error);
}

/*-----------------------------------------------------------------------
  swap_type   EXT SWAP: ok
  ----------------------------------------------------------------------*/
instrument_type swap_il_fixyy.swap_type(error_info option(nullable) error ) 
{	
	return swap_gen.swap_type(error);
}
/*-----------------------------------------------------------------------
  swap_instrument   EXT SWAP: ok
  ----------------------------------------------------------------------*/
ql_fixed_income_swap swap_il_fixyy.swap_instrument(error_info option(nullable) error )
{
	return swap_gen.swap_instrument(error);
}

/*-----------------------------------------------------------------------
  swap_leg   EXT SWAP: ok
  ----------------------------------------------------------------------*/
vector(ql_swap_leg) swap_il_fixyy.legs(logical clone,error_info option(nullable) error )
{	
	return swap_gen.swap_leg(clone,error);
}

/*-----------------------------------------------------------------------
  infl_index_leg   EXT SWAP: ok
  ----------------------------------------------------------------------*/
ql_yy_infl_leg swap_il_fixyy.infl_index_leg(logical clone,error_info option(nullable) error )
{
	
	vector(ql_yy_infl_leg) l;// = instrument.swap_yy_infl_leg(clone,error);
	return !null(l) ? l[0] : null<ql_yy_infl_leg>;
}

/*-----------------------------------------------------------------------
  infl_rate_leg   EXT SWAP: ok
  ----------------------------------------------------------------------*/
ql_fix_leg swap_il_fixyy.infl_rate_leg(logical clone,error_info option(nullable) error )
{

	vector(ql_fix_leg) l = swap_gen.swap_fix_leg(clone,error);
	return !null(l) ? l[0] : null<ql_fix_leg>;
}

/*-----------------------------------------------------------------------
  pay_inflation  EXT SWAP: ok
  ----------------------------------------------------------------------*/
logical	 swap_il_fixyy.pay_inflation(error_info option(nullable) error )
{
	return !swap_gen.swap_payleg1(error);
}

/*-----------------------------------------------------------------------
  present_value
  ----------------------------------------------------------------------*/
number swap_il_fixyy.present_value(	disc_func option(nullable)	disc_func,
									//disc_func option(nullable) 	disc_func_infl_leg,
									out number pv_fix_leg,
									out number pv_infl_leg,
									number option(nullable) 	notional,
									logical option(nullable) 	trade_date_pv,																								
									error_info option(nullable) error )
{	
	return swap_gen.present_value(disc_func,disc_func,pv_fix_leg,pv_infl_leg,notional,trade_date_pv,error);
}

/*-----------------------------------------------------------------------
  present_value
  ----------------------------------------------------------------------*/
number swap_il_fixyy.present_value(	disc_func option(nullable)	disc_func,
									//disc_func option(nullable) 	disc_func_infl_leg,
									out number pv_fix_leg,
									out number pv_infl_leg,
									date option(nullable) 		pv_date,
									date option(nullable) 		settle_date,
									logical  					incl_issue_cf,
									logical  					incl_mat_cf,	
									error_info option(nullable) error )
{	
	return swap_gen.present_value(disc_func,disc_func,pv_fix_leg,pv_infl_leg,pv_date, settle_date ,incl_issue_cf,incl_mat_cf,error );
}


number swap_il_fixyy.present_value(	out number pv_fix_leg,
									out number pv_infl_leg,
									logical option(nullable) 	trade_date_pv,	
									error_info option(nullable) error )
{	
	return swap_gen.present_value(pv_fix_leg,pv_infl_leg,trade_date_pv ,error );
}


/*-----------------------------------------------------------------------
  present_value override prot
  ----------------------------------------------------------------------*/
/*number  swap_il_fixyy.present_value(	number option(nullable) 	notional,
									logical 					trade_date_pv,
									disc_func option(nullable) 	disc_func_disc,
									error_info option(nullable) error )
{	
	try{	
		notional = conv_null_number_com(notional) ;		
		QL_FAIL_COND(!null(disc_func_disc),"input of disc_func (for trade_date_pv calculation) not supported for swaps", this, true);
		
		QL_FAIL_COND(!null(notional) && ccy_swap_,"input of notional not applicable for currency swaps", this, true);//use a version with 2 notionals or set notional to null	

		number pv_fix_leg,pv_flt_leg;
		return present_value(	null<disc_func>, pv_fix_leg, pv_flt_leg,
								notional,trade_date_pv,error);					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_il_fixyy.present_value");
		return null<number>;
	}
}*/

/*-----------------------------------------------------------------------
  present_value  override prot
  ----------------------------------------------------------------------*/
/*number  swap_il_fixyy.present_value(	disc_func					disc_func,
									number option(nullable) 	notional,
									logical 					trade_date_pv,
									disc_func option(nullable) 	disc_func_disc,
									error_info option(nullable) error ) 
{	
	try{	
		notional= conv_null_number_com(notional) ;
		QL_FAIL_COND(!null(disc_func_disc),"input of disc_func (for trade_date_pv calculation) not supported for swaps");
		
		QL_FAIL_COND(ccy_swap_,"inapplicable function call for cross currency swaps");//use a version with 2 disc_funcs	

		number pv_fix_leg,pv_flt_leg;
		return present_value(	disc_func, pv_fix_leg, pv_flt_leg,
								notional,trade_date_pv,error);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_il_fixyy.present_value");
		return null<number>;
	}
}*/
/*-----------------------------------------------------------------------
  pv01	EXT SWAP: ok  - always returns a positive number regardless of pay/receive and sign of notional
  Note: not a "true" measure of risk, does not take into account if the swap has a pv <> 0
   PV01 refers to present value of 1 basis point and it's the discounted value of the cashflows
  for a rate of 0.01% for all periods of a particular instrument, ie, the npv of the fixed leg with a rate of 0.01%
  ----------------------------------------------------------------------*/
number  swap_il_fixyy.pv01(	number option(nullable) notional,
							number option(nullable) delta,
							//logical option(nullable) trade_date_pv,
							disc_func option(nullable) df,
							error_info option(nullable) error ) 
{	
	try{	
		instr_error_type t;
   		string 			s;	

		error_info ee 		= new error_info(true,true);
		disc_func df_orig 	= this.disc_func_fix_leg(ee);
		logical upd 		= false;
		
		if(!null(df)){
			this.add_disc_func_fix_leg(df);
			upd = true;
		}
		else if(null(df_orig)) {	
			QL_FAIL("discount function not available");
		}
		
		number c = i().__swap_pvbp_fix_leg(notional,delta, true,t, s);
		if(!null(c))
			c = abs(c);
		
		if(upd )
			this.add_disc_func_fix_leg(df_orig);		

		logical e = CORE_INT.add_error_info(error,t,s, "swap_il_fixyy.pv01");	
		return e ? null<number>: c;								
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_il_fixyy.pv01");
		return null<number>;
	}
}
/*-----------------------------------------------------------------------
  pvbp	EXT SWAP: ok
  ----------------------------------------------------------------------*/
number  swap_il_fixyy.pvbp(	number option(nullable) nominal,
							number option(nullable) delta,
							logical option(nullable) centered,
							logical option(nullable) disable_rounding,	
							error_info option(nullable) error ) 
{	
	try {
		error_info ee = new error_info(true,true);
		number pv01_ = this.pv01(nominal,delta,null<disc_func>,ee); //always positive
		if(!null(nominal) && nominal < 0)
			return -pv01_;
		else
			return pv01_;					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_il_fixyy.pvbp");
		return null<number>;
	}
}

/*-----------------------------------------------------------------------
  pvbp	EXT SWAP: ok
  ----------------------------------------------------------------------*/
number  swap_il_fixyy.pvbp(	number 	option(nullable) nominal,
							number  option(nullable) delta,																																		
							error_info option(nullable) error ) 
{	
	try{	
		error_info ee = new error_info(true,true);
		number pv01_ = this.pv01(nominal,delta, null<disc_func>,ee);//always positive
		if(!null(nominal) && nominal < 0)
			return -pv01_;
		else
			return pv01_;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_il_fixyy.pvbp");
		return null<number>;
	}
}
/*-----------------------------------------------------------------------
  set_quote_from_yield  EXT SWAP: throws
  ----------------------------------------------------------------------*/
swap_il_fixyy swap_il_fixyy.set_quote_from_yield(number 	option(nullable) yield,
											error_info option(nullable) error )
{	
	instrument cc = instrument._set_quote_from_yield(yield,  true,error);
	return null(cc) ? null<swap_il_fixyy>: dynamic_cast<swap_il_fixyy>(cc);
}

/*-----------------------------------------------------------------------
  set_pay_leg   --> returns an external swap, a db swap cannot be changed in regards to pay vs receive 
  ----------------------------------------------------------------------*/
swap_il_fixyy swap_il_fixyy.set_pay_leg(logical pay_inflation,							
									error_info option(nullable) error )
{
	try{
		
		__instrument  c = i().__swap_set_pay_leg1(!pay_inflation );
		
		instr_error e = new instr_error();
		instrument cc 	= this.create( c, e, E_INIT);
		CORE_INT.instr_fail_check(null(cc), "invalid swap_il_fixyy", this, e);
		
		if(!cc.is_valid(error)) 
			return null<swap_il_fixyy>;	
				
		return dynamic_cast<swap_il_fixyy>(cc);					
	}	
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_il_fixyy.set_pay_leg");
		return null<swap_il_fixyy>;
	}
}
/*-----------------------------------------------------------------------
  set_date 		EXT SWAP: ok
  ext_swap: if trade date is the same --> the settle date will be preserved (if not input)
  ----------------------------------------------------------------------*/
swap_il_fixyy swap_il_fixyy.set_date(	date  					trade_date, 
									date  option(nullable)	settle_date,
									error_info option(nullable) error )
{
	instrument cc;
	if(ext_swap_) {
		logical re_init = false; 
		logical init_quote = false;
		cc = instrument._set_date(trade_date,settle_date,re_init,init_quote,error);
	}
	else {
		QL_FAIL_COND(!null(settle_date),"input of settlement date only supported for non-db swaps" ,this,true );
		logical re_init = true; 
		logical init_quote = true;
		cc = instrument._set_date(trade_date,settle_date,re_init,init_quote,error);
	}
	return null(cc) ? null<swap_il_fixyy>: dynamic_cast<swap_il_fixyy>(cc);
	
}
/*-----------------------------------------------------------------------
  set_date <protected>
	if trade date is the same --> the settle date will be preserved (if not input)	
	NOTE: 	if coupon is not null in instr_def it is kept unchanged --> deposit will be non-par 
			when a deposit is defined in db the coupon is always null
  ----------------------------------------------------------------------*/
swap_il_fixyy swap_il_fixyy.set_date(	date  				trade_date, 
									date  option(nullable)	settle_date,
									logical 			re_init, //true->fail for ext_swap
									logical 			re_init_quote, //true->fail for ext_swap
									error_info option(nullable) error)
{	
	//instrument cc = instrument._set_date(trade_date,null<date>,true,re_init_quote,error);
	//return null(cc) ? null<swap_il_fixyy>: dynamic_cast<swap_il_fixyy>(cc);

	QL_FAIL_COND(ext_swap_ && (re_init || re_init_quote),"re_init/re_init_quote flags = true not supported for non-db swaps" ,this,true );
	QL_FAIL_COND(!ext_swap_ && !null(settle_date),"input of settlement date only supported for non-db swaps" ,this,true );
	instrument cc = instrument._set_date(trade_date,settle_date,re_init,re_init_quote,error);
	return null(cc) ? null<swap_il_fixyy>: dynamic_cast<swap_il_fixyy>(cc);
	
}

/*-----------------------------------------------------------------------
  set_date <protected/legacy>
	quote is NOT kept even if trade_date is unchanged
  ----------------------------------------------------------------------*/
swap_il_fixyy swap_il_fixyy.set_date(	date  				trade_date, 
									logical 			re_init, 
									error_info option(nullable) error) 

{	
	//instrument cc = instrument._set_date(trade_date,true,error);
	//return null(cc) ? null<swap_il_fixyy>: dynamic_cast<swap_il_fixyy>(cc);

	instrument cc;
	if(ext_swap_){
		QL_FAIL_COND(re_init,"re_init = true not supported for non-db swaps" ,this,true );
		logical init_quote = false;
		cc = instrument._set_date(trade_date,null<date>,re_init,init_quote,error);
	}
	else{		
		logical init_quote = true;
		cc = instrument._set_date(trade_date,null<date>,re_init,init_quote,error);
	}
	return null(cc) ? null<swap_il_fixyy>: dynamic_cast<swap_il_fixyy>(cc);	
}

/*-----------------------------------------------------------------------
   move_date  <protected/legacy>		EXT SWAP: ok
	changes the trade date of the instrument without retrieving the 
 	corresponding quote from the database or the real-time feed.
	ext_swap: if trade date is the same --> the settle date will be preserved (if not input)	
  ----------------------------------------------------------------------*/
swap_il_fixyy swap_il_fixyy.move_date(	date  				trade_date, 
									date option(nullable) settle_date,
									error_info option(nullable) error ) 
{
	QL_FAIL_COND(!ext_swap_ && !null(settle_date),"input of settlement date only supported for non-db swaps" ,this,true );
	instrument cc = instrument._move_date(trade_date,settle_date,error);
	return null(cc) ? null<swap_il_fixyy>: dynamic_cast<swap_il_fixyy>(cc);
}

/*-----------------------------------------------------------------------
  set_quote		EXT SWAP: ok
  ----------------------------------------------------------------------*/
swap_il_fixyy swap_il_fixyy.set_quote(	number 	option(nullable) quote,									
									error_info option(nullable) error )
{		
	instrument cc = instrument._set_quote(quote,null<date>, null<date>, true,error);
	return null(cc) ? null<swap_il_fixyy>: dynamic_cast<swap_il_fixyy>(cc);
}

/*-----------------------------------------------------------------------
  set_quote 		EXT SWAP: will throw because of quote_side
  ----------------------------------------------------------------------*/
swap_il_fixyy swap_il_fixyy.set_quote(	string 	option(nullable) quote_side,
									error_info option(nullable) error )
{	
	instrument cc = instrument._set_quote(quote_side,null<date>, null<date>, true,error);
	return null(cc) ? null<swap_il_fixyy>: dynamic_cast<swap_il_fixyy>(cc);
}

/*-----------------------------------------------------------------------
  set_yield   FIX-FLT SWAP: yield == fix_cpn_rate  backward compat
  ----------------------------------------------------------------------*/
swap_il_fixyy swap_il_fixyy.set_yield(	number 	option(nullable) yield,							
									error_info option(nullable) error )
{	
	return this.set_infl_rate_fix_leg(yield,error);
}
/*-----------------------------------------------------------------------
  set_infl_rate_fix_leg  EXT SWAP: ok
  ----------------------------------------------------------------------*/
swap_il_fixyy swap_il_fixyy.set_infl_rate_fix_leg(number 	option(nullable) rate,							
											error_info option(nullable) error )
{
	try{
	
		if(!ext_swap_) {
			instrument cc = instrument._set_yield(	rate, null<date>, null<date>,true, error);
			return null(cc) ? null<swap_il_fixyy>: dynamic_cast<swap_il_fixyy>(cc);
		}

		
		error_info ee = new error_info(true,true);
		..quote_style qs = this.quote_style_e(ee);
		
		number q;
		if(qs == ..quote_style.YIELD_PCT)
			q = rate * 100;		
		__instrument  c = i().__swap_ext_set_quote(q, null<date>, null<date> );

		instr_error e = new instr_error();
		instrument cc 	= this.create( c, e, E_INIT);
		CORE_INT.instr_fail_check(null(cc), "invalid swap_il_fixyy", this, e);
		
		if(!cc.is_valid(error)) 
			return null<swap_il_fixyy>;	
				
		return dynamic_cast<swap_il_fixyy>(cc);					
	}	
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_il_fixyy.set_infl_rate_fix_leg");
		return null<swap_il_fixyy>;
	}
}


/*-----------------------------------------------------------------------
  disc_func_fix_leg / disc_func_infl_leg   EXT SWAP: ok
  ----------------------------------------------------------------------*/
disc_func swap_il_fixyy.disc_func_fix_leg(error_info option(nullable) error ) 	{ return swap_gen.swap_disc_func_leg1(error);}
disc_func swap_il_fixyy.disc_func_infl_leg(error_info option(nullable) error ) 	{ return swap_gen.swap_disc_func_leg2(error);}


/*-----------------------------------------------------------------------
  infl_fix_rate	DLL_SWAP_HANDLER: ok
  ----------------------------------------------------------------------*/
number  swap_il_fixyy.infl_fix_rate(error_info option(nullable) error ) 
{	
	try{	
		instr_error_type t;
   		string 			s;	
		number c1,c2;
		i().__swap_coupon(c1,c2,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "swap_il_fixyy.infl_fix_rate");	
		return e ? null<number>: c1;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_il_fixyy.infl_fix_rate");
		return null<number>;
	}
}


/*-----------------------------------------------------------------------
  cpi_link
  ----------------------------------------------------------------------*/
cpi_link swap_il_fixyy.cpi_link(error_info option(nullable) error)
{	
	try{
		error_info ee = error_info(true,true);
		ql_yy_infl_leg l = infl_index_leg(false,ee );			
		return l.cpi_link();						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_il_fixyy.cpi_link");
		return null<..cpi_link> ;
	}
}

/*-----------------------------------------------------------------------
  cpi_link
  ----------------------------------------------------------------------*/
cpi_link swap_il_fixyy.cpi_link_forecast(error_info option(nullable) error)
{	
	try{
		error_info ee = error_info(true,true);
		ql_yy_infl_leg l = infl_index_leg(false,ee );			
		return l.cpi_link_fcast();						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_il_fixyy.cpi_link_forecast");
		return null<..cpi_link> ;
	}
}
/*-----------------------------------------------------------------------
  cpi_knots
	lag1 always less than lag2 --> mth_lag1 always after mth_lag2 in time
	|-------|-------|--------
	   mth2    mth1    start
  ----------------------------------------------------------------------*/
/*void swap_il_fixyy.cpi_knots(	logical 	start_date,//if false will return data for maturity
								out date  	mth_lag1,//commonly 2m
								out date   	mth_lag2,//commonly 3m
								out logical	active_lag1,
								out logical	active_lag2,
								error_info option(nullable) error)
{	
	try{
		error_info ee = error_info(true,true);
		ql_yy_infl_leg l = infl_index_leg(false,ee );			
		l.cpi_knots(start_date,mth_lag1,mth_lag2,active_lag1,active_lag2);
		return;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_il_fixyy.cpi_knots");
		mth_lag1 = mth_lag2 = null<date>;
		active_lag1 = active_lag2 = null<logical>;
		return  ;
	}
}*/

/*-----------------------------------------------------------------------
  cpi_values
	lag1 always less than lag2 --> mth_lag1 always after mth_lag2 in time
	|-------|-------|--------
	   mth2    mth1    start
  ----------------------------------------------------------------------*/
/*void swap_il_fixyy.cpi_values(	logical 	start_date,//if false will return data for maturity
								out date  	dt_lag1,//commonly 2m
								out date   	dt_lag2,//commonly 3m
								out number 	val_lag1,
								out number 	val_lag2,
								error_info option(nullable) error)
{	
	try{
		error_info ee = error_info(true,true);
		ql_yy_infl_leg l = infl_index_leg(false,ee );			
		l.cpi_values(start_date,dt_lag1,dt_lag2,val_lag1,val_lag2);
		return;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_il_fixyy.cpi_value");
		dt_lag1 = dt_lag2 = null<date>;
		val_lag1 = val_lag2 = null<number>;
		return  ;
	}
}*/
/*-----------------------------------------------------------------------
  index_freq
  ----------------------------------------------------------------------*/
integer swap_il_fixyy.index_freq(	error_info option(nullable) error)
{	
	 
	try{
		error_info ee = error_info(true,true);
		ql_yy_infl_leg l = infl_index_leg(false,ee );				
		
		return l.index_freq();						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_il_fixyy.index_freq");		
		return err_int();
	}
}


/*-----------------------------------------------------------------------
  index_method
  ----------------------------------------------------------------------*/
infl_index_method swap_il_fixyy.index_method(error_info option(nullable) error)
{	
	 
	try{
		error_info ee = error_info(true,true);
		ql_yy_infl_leg l = infl_index_leg(false,ee );				
		
		return l.index_method();						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_il_fixyy.index_method");		
		return null<infl_index_method>;
	}
}
/*-----------------------------------------------------------------------
  is_noip_index_method
  ----------------------------------------------------------------------*/
logical swap_il_fixyy.is_noip_index_method(error_info option(nullable) error)
{	
	 
	try{
		error_info ee = error_info(true,true);
		ql_yy_infl_leg l = infl_index_leg(false,ee );				
		
		return l.is_noip_index_method();						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_il_fixyy.is_noip_index_method");		
		return null<logical>;
	}
}