option(null: hard);	
/*	
	instrument wrapper functions
	Developer: Algorithmica Research, Magnus Nyström			

	--------------------------------------------------------------------
	swap_il_fltyy
	--------------------------------------------------------------------
*/


//-----------------------------------------------------------------------
//  class swap_il_fltyy
//----------------------------------------------------------------------
class swap_il_fltyy: public swap_gen
option (category: 'Instrument/Inflation Linked/Float vs Y-Y')
//option(allow_undeclared_mfuncs)
{
public:

	//override string	instr_type_s();
	override instrument 	inst();	
	override swap_il_fltyy clone();

	override void                	__dbg_print(__dbg_label);
    override void                	__dbg_browse(__dbg_split);

	override instrument_type 		swap_type(error_info option(nullable) error = null<error_info> );
	vector(ql_swap_leg) 			legs(logical,error_info option(nullable) error = null<error_info>);
	ql_yy_infl_leg 					infl_index_leg(logical,error_info option(nullable) error = null<error_info>);
	ql_float_leg 					infl_rate_leg(logical,error_info option(nullable) error = null<error_info>);
	override ql_fixed_income_swap 	swap_instrument(error_info option(nullable) error = null<error_info>) ;
	
	/*----------ADD FUNCS [PUBLIC]---------------*/
	swap_il_fltyy(__instrument);

	swap_il_fltyy(swap_il_fltyy);
protected:
	override swap_il_fltyy		create(__instrument option(nullable),out instr_error option(nullable),error_type type = E_INVALID_ARG);

	//logical ext_swap_;
	//logical ccy_swap_;
	//logical full_swap_;
 
};

//------------------------------------------------
// __dbg_print
//------------------------------------------------
void swap_il_fltyy.__dbg_print(__dbg_label l)
{

	error_info ee 	= new error_info(true,false);
    l.set_text(strcat([
						"name: ",
						name(ee),
						",  ext_swap: ",
						null(ext_swap_) ? "" : string(ext_swap_),
                        ", ccy_swap: ",
						null(ccy_swap_) ? "" : string(ccy_swap_),
						", valid: ",
						null(this.is_valid(ee)) ? "" : string(this.is_valid(ee))
					]));
}
//------------------------------------------------
// __dbg_browse
//------------------------------------------------
void swap_il_fltyy.__dbg_browse(__dbg_split s)
{
    s.resize(4);
	error_info ee 	= new error_info(true,false);
    s.set_text(0, "name");
    s.set_value(0, this.name(ee));

    s.set_text(1, "ext_swap");
    s.set_value(1, ext_swap_);

    s.set_text(2, "ccy_swap");
    s.set_value(2, ccy_swap_);

	s.set_text(3, "valid");
    s.set_value(3, is_valid(ee));
}


//------------------------------------------------
// constructor [HIDDEN, cannot be protected]
//------------------------------------------------
swap_il_fltyy.swap_il_fltyy(__instrument i) option(hidden) : swap_gen(i)
{
	//try {
		error_info ee = new error_info(true,false);
		if(!this.is_valid(ee)) {
			ext_swap_ = ccy_swap_ = full_swap_ = false;
			return;
		}
		ext_swap_ = this.is_ext_swap(ee);
		ccy_swap_ = this.is_ccy_swap(ee);
		full_swap_	= this.verify_full_swap(true,ee);
		
			
		return;									
	//}
	//catch {		
	//	CORE_INT.write_warning_message(err.message());
	//}
}
//------------------------------------------------
// instr_type_s
//------------------------------------------------
//string swap_il_fltyy.instr_type_s()  { return string(..instr_type.IL_SWAP_FLT_Y_Y);}
//------------------------------------------------
// inst
//------------------------------------------------
instrument 	swap_il_fltyy.inst()		{ return this;}
//------------------------------------------------
// copy constructor
//------------------------------------------------
swap_il_fltyy.swap_il_fltyy(swap_il_fltyy c) : swap_gen(c) {}
//------------------------------------------------
// copy constructor <FUNCTION>
//------------------------------------------------
swap_il_fltyy swap_il_fltyy(swap_il_fltyy b)			{ return new swap_il_fltyy(b);}
//------------------------------------------------
// clone
//------------------------------------------------
swap_il_fltyy swap_il_fltyy.clone() 	{ return new swap_il_fltyy(this);}

//-----------------------------------------------
// dynamic cast <FUNCTION>
//-----------------------------------------------
swap_il_fltyy	swap_il_fltyy(instrument i, error_info option(nullable) error = null<error_info>) 	
option (category: 'Instrument/Inflation Linked/Float vs Y-Y')
option(com_name: 'swap_il_fltyy_dyncast') 
{ 
	try {
		swap_il_fltyy d = dynamic_cast<swap_il_fltyy>(i); 
		if(null(d))
			CORE_INT.add_error_info(error,ERR_T_INIT,"invalid cast (instrument is not an swap_il_fltyy)","swap_il_fltyy" );

		return d;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_il_fltyy");
		return null<swap_il_fltyy>;
	}
}
//------------------------------------------------
// create  [PROTECTED]
// create swap_il_zero from internal instrument
//------------------------------------------------
swap_il_fltyy swap_il_fltyy.create(__instrument option(nullable) c,
								out instr_error option(nullable) error,
								error_type type )
{
	QL_FAIL_COND(null(c), "invalid/unknown (null) instrument",type );

	logical valid = c.is_valid(error);
	if( !valid && INSTR_CREATE_NULL_ERR)
		return null<swap_il_fltyy>; 
	
	..instr_type it = c.instr_type(error);
	QL_FAIL_COND(null(it), "invalid instrument type (unknown)",type );
	QL_FAIL_COND(it != ..instr_type.IL_SWAP_FLT_Y_Y, "invalid instrument type",type );//should not happen
	
	return new swap_il_fltyy(c);
}

/*-----------------------------------------------------------------------
  create_swap_il_zero  <FUNCTION>
  ----------------------------------------------------------------------*/
swap_il_fltyy create_swap_il_fltyy(	__instrument option(nullable) c,
											out instr_error option(nullable) error,
											error_type type = E_INVALID_ARG)
option(com_name: 'INTERNAL_create_swap_il_fltyy')
{
	QL_FAIL_COND(null(c), "invalid/unknown (null) instrument",type );

	logical valid = c.is_valid(error);
	if(!valid && INSTR_CREATE_NULL_ERR)
		return null<swap_il_fltyy>; 
	
	..instr_type it = c.instr_type(error);
	QL_FAIL_COND(null(it), "invalid instrument type (unknown)",type );
	QL_FAIL_COND(it != ..instr_type.IL_SWAP_FLT_Y_Y, "invalid instrument type",type );//should not happen
	
	return new swap_il_fltyy(c);
}

swap_il_fltyy create_swap_il_fltyy(	__instrument option(nullable) 		c,
								error_info option(nullable) 		error,
								error_type 							type = E_INIT)
option(com_name: 'INTERNAL_create_swap_il_fltyy_ei')
{
	instr_error ee 	= instr_error();
	swap_il_fltyy b 	= create_swap_il_fltyy(c,ee, E_INIT);
	if(ee.is_error())
		CORE_INT.add_error_info(error,ee.type(),ee.message(), "create_swap_il_fltyy");
	return b;
}

/*-----------------------------------------------------------------------
  swap_type   EXT SWAP: ok
  ----------------------------------------------------------------------*/
instrument_type swap_il_fltyy.swap_type(error_info option(nullable) error ) 
{	
	return swap_gen.swap_type(error);
}
/*-----------------------------------------------------------------------
  swap_instrument   EXT SWAP: ok
  ----------------------------------------------------------------------*/
ql_fixed_income_swap swap_il_fltyy.swap_instrument(error_info option(nullable) error )
{
	return swap_gen.swap_instrument(error);
}

/*-----------------------------------------------------------------------
  swap_leg   EXT SWAP: ok
  ----------------------------------------------------------------------*/
vector(ql_swap_leg) swap_il_fltyy.legs(logical clone,error_info option(nullable) error )
{	
	return swap_gen.swap_leg(clone,error);
}

/*-----------------------------------------------------------------------
  infl_index_leg   EXT SWAP: ok
  ----------------------------------------------------------------------*/
ql_yy_infl_leg swap_il_fltyy.infl_index_leg(logical clone,error_info option(nullable) error )
{
	
	vector(ql_yy_infl_leg) l;// = swap_gen.swap_yy_infl_leg(clone,error);
	return !null(l) ? l[0] : null<ql_yy_infl_leg>;
}

/*-----------------------------------------------------------------------
  infl_rate_leg   EXT SWAP: ok
  ----------------------------------------------------------------------*/
ql_float_leg swap_il_fltyy.infl_rate_leg(logical clone,error_info option(nullable) error )
{
	
	vector(ql_float_leg) l = swap_gen.swap_float_leg(clone,error);
	return !null(l) ? l[0] : null<ql_float_leg>;
}