option(null: hard);	
/*	
	instrument wrapper functions
	Developer: Algorithmica Research, Magnus Nyström			

	--------------------------------------------------------------------
	zero bond
	--------------------------------------------------------------------
*/


//-----------------------------------------------------------------------
//  class zero_bond
//----------------------------------------------------------------------
class zero_bond: public instrument
option(category: "Instrument/Zero Bond")
//option(allow_undeclared_mfuncs)
{
public:

	//override string	instr_type_s();
	override instrument 	inst();

/*	--------------------------------
	---OVERRIDES (HIDDEN IN ROOT) --- 
	--------------------------------
		- implemented in root for backward compat reasons
*/
	
	//-----add-funcs-----			
	override void 			add_nominal(number );										
	void 					add_quote(number );				/*set cpn to quote removed --> local*/
	void 					add_quote_from_yield(number );	/*set cpn to quote removed --> local*/
	
	//-----general-----
	override logical 		eom(error_info option(nullable) error = null<error_info>  );
	override string 		maturity_code(error_info option(nullable) error = null<error_info> );
	override bd_convention 	pmt_bus_day(error_info option(nullable) error = null<error_info> );
	override day_count_method dc_method(error_info option(nullable) error = null<error_info>);
	override date 			first_settle_date(error_info option(nullable) error = null<error_info>  );
	override integer 		comp_freq(error_info option(nullable) error = null<error_info>  );
	override day_count_method next_dc_method(error_info option(nullable) error = null<error_info>  );	
	override day_count_method next_last_dc_method(error_info option(nullable) error = null<error_info>  );	
	override  number 		redemp_price(error_info option(nullable) error = null<error_info> );		
	override  number 		issued_amount(error_info option(nullable) error = null<error_info> );
	
	//-----fwd price  (/*cpn_reinv removed --> locals*/)-----
	void 					funding(date ,number  ,
									day_count_method ,rate_type option(nullable) ,disc_func option(nullable) ,number option(nullable) ,
									out number	,out number,
									out number	,out number,
									error_info option(nullable) error = null<error_info> ) ;						/*root impl.*/

	number  				clean_price_fwd(date ,number ,day_count_method,rate_type option(nullable) ,
											disc_func option(nullable) ,
											error_info option(nullable) error = null<error_info> ) ; 				/*root impl.*/
	
	number  				dirty_price_fwd(date ,number ,day_count_method,rate_type option(nullable) ,
											disc_func option(nullable) ,
											error_info option(nullable) error = null<error_info> ) ; 				/*root impl.*/

	number  				yield_fwd(	date ,number ,day_count_method,rate_type option(nullable) ,
										disc_func option(nullable) ,
										error_info option(nullable) error = null<error_info> ) ; 					/*root impl.*/

	number  				horizon_return(	date ,number ,..quote_style	option(nullable),
											day_count_method,rate_type option(nullable) ,
											disc_func option(nullable) ,
											error_info option(nullable) error = null<error_info> ) ; 				/*root impl.*/

	override void  			roll_down(	date,disc_func option(nullable) ,day_count_method,
										rate_type option(nullable),logical option(nullable) ,
										out number,out number ,
										out number ,out number ,out date,
										error_info option(nullable) error = null<error_info> ) ; /*root impl.*/

	void  					imp_fwd(instrument ,number option(nullable),number option(nullable),day_count_method,rate_type  ,disc_func,
									number option(nullable),number option(nullable), out number,out number,out number,out number,
									out number,  error_info option(nullable) error = null<error_info>) ;

	/*
		convexity_cf, pl_intraday
	*/

/*	--------------------------------
	---OVERRIDES (PUBLIC i.e. NOT HIDDEN IN ROOT) --- 
	--------------------------------
		-implemented in root
		-required
*/
	override zero_bond 		set_quote(number option(nullable),error_info option(nullable) error = null<error_info> );
	override zero_bond 		set_quote(string option(nullable),error_info option(nullable) error = null<error_info> );
	override zero_bond		set_quote_from_yield(number option(nullable),
												 error_info option(nullable) error = null<error_info> );  /*legacy, hidden in root*/

/*	--------------------------------
	---OVERRIDES (HIDDEN IN ROOT, THROWS IN ROOT) --- 
	--------------------------------
		-implemented in root with "-" prefix
		-here if applicable
*/
	override zero_bond 		set_date(date,
									 date option(nullable) settle_date = null<date>,
									 logical re_init_static = true,
									 logical init_quote = true ,
									 error_info option(nullable) error = null<error_info> );

	override zero_bond		set_settle_date(date ,
											logical re_initialize = false,
											error_info option(nullable) error = null<error_info>  );

	override zero_bond		set_clean_price(number option(nullable),
											date option(nullable) trade_date  = null<date>,
											date option(nullable) settle_date = null<date>,
											error_info option(nullable) error = null<error_info> );
	
	override zero_bond 		set_dirty_price(number option(nullable),
											date option(nullable) trade_date  = null<date>,
											date option(nullable) settle_date = null<date>,
											error_info option(nullable) error = null<error_info> );

	override zero_bond 		set_yield(number option(nullable) ,
									  error_info option(nullable) error = null<error_info> );
	
/*	--------------------------------
	---LOCALS (NOT EXPOSED IN ROOT) 
	--------------------------------
		-implemented in root with "-" prefix
		-here if applicable
*/
	zero_bond 				set_quote(	number option(nullable),date option(nullable) trade_date ,
										date option(nullable) settle_date = null<date>,
										error_info option(nullable) error = null<error_info> );
	zero_bond 				set_quote(	string option(nullable),date option(nullable) trade_date  ,
										date option(nullable) settle_date = null<date>,
										error_info option(nullable) error = null<error_info> );

	zero_bond				set_yield( 	number option(nullable) ,date option(nullable) ,
										date option(nullable) settle_date = null<date>,
										error_info option(nullable) error = null<error_info> );
			
	zero_bond(__instrument);	
	override zero_bond clone();
	zero_bond(zero_bond);
protected:
	
	override zero_bond 		create(__instrument option(nullable),out instr_error option(nullable),error_type type = E_INVALID_ARG);    
	override void 			add_quote(number,logical option(nullable) ); 
	override void 			add_quote_from_yield(number,logical option(nullable) );

	override zero_bond 		set_date(	date,logical ,error_info option(nullable) error = null<error_info> );		/*legacy*/
	override zero_bond 		move_date(	date,date option(nullable) settle_date = null<date>,
										error_info option(nullable) error = null<error_info> );						/*legacy*/
};

//------------------------------------------------
// constructor [HIDDEN, cannot be protected]
//------------------------------------------------
zero_bond.zero_bond(__instrument i) option(hidden) : instrument(i){}
//------------------------------------------------
// instr_type_s
//------------------------------------------------
//string zero_bond.instr_type_s()  	{ return string(..instr_type.ZERO_CPN_BOND);}
//------------------------------------------------
// inst
//------------------------------------------------
instrument 	zero_bond.inst()		{ return this;}
//------------------------------------------------
// copy constructor
//------------------------------------------------
zero_bond.zero_bond(zero_bond c) : instrument(c) {}
//------------------------------------------------
// copy constructor <FUNCTION>
//------------------------------------------------
zero_bond zero_bond(zero_bond zb)			{ return new zero_bond(zb);}
//------------------------------------------------
// clone
//------------------------------------------------
zero_bond zero_bond.clone()				{ return new zero_bond(this);}
//-----------------------------------------------
// dynamic cast <FUNCTION>
//-----------------------------------------------
zero_bond	zero_bond(instrument i,
					  error_info option(nullable) error = null<error_info>) 	
option (category: 'Instrument/Zero Bond')
option(com_name: 'zero_bond_dyncast') 
{ 
	try {
		zero_bond d = dynamic_cast<zero_bond>(i); 
		if(null(d))
			CORE_INT.add_error_info(error,ERR_T_INIT,"invalid cast (instrument is not a zero_bond)","zero_bond" );

		return d;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "zero_bond");
		return null<zero_bond>;
	}
}
//------------------------------------------------
// create  [PROTECTED]
// create zero_bond from internal instrument
//------------------------------------------------
zero_bond zero_bond.create(	__instrument option(nullable) 		c,
							out instr_error option(nullable) 	error,
							error_type 							type )
{
	QL_FAIL_COND(null(c), "invalid/unknown (null) instrument",type );

	logical valid = c.is_valid(error);
	if( !valid && INSTR_CREATE_NULL_ERR)
		return null<zero_bond>; 
		
	..instr_type it = c.instr_type(error);
	QL_FAIL_COND(null(it), "invalid instrument type (unknown)",type );
	QL_FAIL_COND(it != ..instr_type.ZERO_CPN_BOND, "invalid instrument type",type );//should not happen	
	
	return new zero_bond(c);
}
/*-----------------------------------------------------------------------
  create_zero_bond <FUNCTION>
  ----------------------------------------------------------------------*/
zero_bond create_zero_bond(__instrument option(nullable) 					c,
										out instr_error option(nullable) 	error,
										error_type 							type = E_INIT)
option(com_name: 'INTERNAL_create_zero_bond')
{
	QL_FAIL_COND(null(c), "invalid/unknown (null) instrument",type );

	logical valid = c.is_valid(error);
	if( !valid && INSTR_CREATE_NULL_ERR)
		return null<zero_bond>; 
	
	..instr_type it = c.instr_type(error);
	QL_FAIL_COND(null(it), "invalid instrument type (unknown)",type );
	QL_FAIL_COND(it != ..instr_type.ZERO_CPN_BOND, "invalid instrument type",type );//should not happen
	
	return new zero_bond(c);
}

zero_bond create_zero_bond(	__instrument option(nullable) 		c,
							error_info option(nullable) 		error,
							error_type 							type = E_INIT)
option(com_name: 'INTERNAL_create_zero_bond_ei')
{
	instr_error ee 	= instr_error();
	zero_bond b 	= create_zero_bond(c,ee, E_INIT);
	if(ee.is_error())
		CORE_INT.add_error_info(error,ee.type(),ee.message(), "create_zero_bond");
	return b;
}
/*-----------------------------------------------------------------------
  add_nominal 
  ----------------------------------------------------------------------*/
void zero_bond.add_nominal(number nominal) 
{			
	instrument.add_nominal(nominal );
	return ;						
}

/*-----------------------------------------------------------------------
  add_quote
  ----------------------------------------------------------------------*/
void zero_bond.add_quote(number  quote ) 
{	
	instrument.add_quote(quote, false);
	return ;					
	
}
void zero_bond.add_quote(number  quote, logical option(nullable) set_coupon_to_quote ) 
{	
	if(null(set_coupon_to_quote)) set_coupon_to_quote = false;
	QL_FAIL_COND(set_coupon_to_quote, "invalid argument: set coupon to quote not applicable for zero cpn bond", name(), true);
	instrument.add_quote(quote, set_coupon_to_quote);
	return ;						
}

/*-----------------------------------------------------------------------
  add_quote_from_yield
  ----------------------------------------------------------------------*/
void zero_bond.add_quote_from_yield(number  yield ) 
{	
	instrument.add_quote_from_yield(yield, false);
	return ;					
	
}
void zero_bond.add_quote_from_yield(number  yield, logical option(nullable) set_coupon_to_yield ) 
{	
	if(null(set_coupon_to_yield)) set_coupon_to_yield= false;
	QL_FAIL_COND(set_coupon_to_yield, "invalid argument: set coupon to yield not applicable for zero cpn bond", name(), true);
	instrument.add_quote_from_yield(yield, set_coupon_to_yield);
	return ;						
}

/*-----------------------------------------------------------------------
  hidden in root members
  ----------------------------------------------------------------------*/
logical zero_bond.eom(error_info option(nullable) error) 							{ return instrument.eom(error);}
string 	zero_bond.maturity_code(error_info option(nullable) error)					{ return instrument.maturity_code(error);}
date  	zero_bond.first_settle_date(error_info option(nullable) error)				{ return instrument.first_settle_date(error);}
bd_convention zero_bond.pmt_bus_day(error_info option(nullable) error) 				{ return instrument.pmt_bus_day(error);}
integer zero_bond.comp_freq(error_info option(nullable) error) 						{ return instrument.comp_freq(error);}
number  zero_bond.redemp_price(error_info option(nullable) error)					{ return instrument.redemp_price(error);}
day_count_method zero_bond.next_last_dc_method(error_info option(nullable) error) 	{ return instrument.next_last_dc_method(error);}
day_count_method zero_bond.next_dc_method(error_info option(nullable) error) 		{ return instrument.next_dc_method(error);}
day_count_method zero_bond.dc_method(error_info option(nullable) error) 			{ return instrument.next_dc_method(error);}
number zero_bond.issued_amount(error_info option(nullable) error)					{ return instrument.issued_amount(error);}

/*-----------------------------------------------------------------------
  zero_bond: set_date
	if trade date is the same --> the settle date will be preserved (if not input)	
	NOTE: 	if coupon is not null in instr_def it is kept unchanged --> deposit will be non-par 
			when a deposit is defined in db the coupon is always null
  ----------------------------------------------------------------------*/
zero_bond zero_bond.set_date(	date  				trade_date, 
								date  option(nullable)	settle_date,
								logical 			re_init_static, 
								logical 			re_init_quote, 
								error_info option(nullable) error)
{	
	instrument cc = instrument._set_date(trade_date,settle_date,re_init_static,re_init_quote,error);
	return null(cc) ? null<zero_bond>: dynamic_cast<zero_bond>(cc);	
}

/*-----------------------------------------------------------------------
  set_date <protected/legacy>
	quote is NOT kept even if trade_date is unchanged i.e. the quote is reinitalized
	(as opposed to move_date)
  ----------------------------------------------------------------------*/
zero_bond zero_bond.set_date(	date  				trade_date, 
					logical 			re_initialize, 
					error_info option(nullable) error) 
{	
	instrument cc = instrument._set_date(	trade_date,re_initialize,error);
	return null(cc) ? null<zero_bond>: dynamic_cast<zero_bond>(cc);
}

/*-----------------------------------------------------------------------
  move_date <protected/legacy>
	changes the trade date of the instrument without retrieving the 
 	corresponding quote from the database or the real-time feed.
	if trade date is the same --> the settle date will be preserved	
  ----------------------------------------------------------------------*/
zero_bond zero_bond.move_date(date  				trade_date, 
					date option(nullable) settle_date,
					error_info option(nullable) error)  
{	
	instrument cc = instrument._move_date(trade_date,settle_date,error);
	return null(cc) ? null<zero_bond>: dynamic_cast<zero_bond>(cc);
}

/*-----------------------------------------------------------------------
  zero_bond: set_quote 
  ----------------------------------------------------------------------*/
zero_bond zero_bond.set_quote(	number 	option(nullable) quote,
						error_info option(nullable) error)
{	
	instrument cc = instrument._set_quote(quote,null<date>, null<date>, false,error);
	return null(cc) ? null<zero_bond>: dynamic_cast<zero_bond>(cc);
}

/*-----------------------------------------------------------------------
  zero_bond: set_quote 
  ----------------------------------------------------------------------*/
zero_bond zero_bond.set_quote(	string 	option(nullable) quote_side,
						error_info option(nullable) error)
{	
	instrument cc = instrument._set_quote(quote_side,null<date>, null<date>, false,error);
	return null(cc) ? null<zero_bond>: dynamic_cast<zero_bond>(cc);
}

/*-----------------------------------------------------------------------
  zero_bond: set_quote 
  ----------------------------------------------------------------------*/
zero_bond zero_bond.set_quote(	number 	option(nullable) quote,
						date  	option(nullable) trade_date, 
						date  	option(nullable) settle_date, 
						error_info option(nullable) error)
{	
	instrument cc = instrument._set_quote(quote,trade_date, settle_date, false,error);
	return null(cc) ? null<zero_bond>: dynamic_cast<zero_bond>(cc);
}

/*-----------------------------------------------------------------------
  zero_bond: set_quote
  ----------------------------------------------------------------------*/
zero_bond zero_bond.set_quote(	string 	option(nullable) quote_side,
						date  	option(nullable) trade_date, 
						date  	option(nullable) settle_date, 
						error_info option(nullable) error)
{	
	instrument cc = instrument._set_quote(quote_side,trade_date, settle_date, false,error);
	return null(cc) ? null<zero_bond>: dynamic_cast<zero_bond>(cc);
}

/*-----------------------------------------------------------------------
  zero_bond: set_clean_price
  ----------------------------------------------------------------------*/
zero_bond zero_bond.set_clean_price(	number 	option(nullable) clean_pct,
									date  	option(nullable) trade_date, 
									date  	option(nullable) settle_date, 
									error_info option(nullable) error)
{	
	instrument cc = instrument._set_clean_price(	clean_pct,trade_date, settle_date,error);
	return null(cc) ? null<zero_bond>: dynamic_cast<zero_bond>(cc);
}

/*-----------------------------------------------------------------------
  set_dirty_price
  ----------------------------------------------------------------------*/
zero_bond zero_bond.set_dirty_price(	number 	option(nullable) dirty_pct,
							date  	option(nullable) trade_date, 
							date  	option(nullable) settle_date, 
							error_info option(nullable) error)
{	
	instrument cc = instrument._set_dirty_price(	dirty_pct,trade_date, settle_date,error);
	return null(cc) ? null<zero_bond>: dynamic_cast<zero_bond>(cc);
}

/*-----------------------------------------------------------------------
  zero_bond: set_yield
  ----------------------------------------------------------------------*/
zero_bond zero_bond.set_yield(	number 	option(nullable) yield,							
						error_info option(nullable) error)
{	
	instrument cc = instrument._set_yield(	yield, null<date>, null<date>,false, error);
	return null(cc) ? null<zero_bond>: dynamic_cast<zero_bond>(cc);
}

/*-----------------------------------------------------------------------
  zero_bond: set_yield
  ----------------------------------------------------------------------*/
zero_bond zero_bond.set_yield(	number 	option(nullable) yield,
									date  	option(nullable) trade_date, 
									date  	option(nullable) settle_date, 
									//logical option(nullable) set_coupon_to_yield,
									error_info option(nullable) error)
{	
	instrument cc = instrument._set_yield(	yield, trade_date, settle_date,false, error);
	return null(cc) ? null<zero_bond>: dynamic_cast<zero_bond>(cc);
}

/*-----------------------------------------------------------------------
  zero_bond: set_settle_date
  ----------------------------------------------------------------------*/
zero_bond zero_bond.set_settle_date(	date  				settle_date, 
									logical 			re_initialize, 
									error_info option(nullable) error)
{	
	
	instrument cc = instrument._set_settle_date(	settle_date, re_initialize, error);
	return null(cc) ? null<zero_bond>: dynamic_cast<zero_bond>(cc);
}

/*-----------------------------------------------------------------------
  zero_bond: set_quote_from_yield
  ----------------------------------------------------------------------*/
zero_bond zero_bond.set_quote_from_yield(	number 	option(nullable) yield,
											error_info option(nullable) error)
{	
	instrument cc = instrument._set_quote_from_yield(yield,  false,error);
	return null(cc) ? null<zero_bond>: dynamic_cast<zero_bond>(cc);
}
/*-----------------------------------------------------------------------
  zero_bond: funding

  ----------------------------------------------------------------------*/
void zero_bond.funding(	date 						fwd_settle_date,
						number  					repo_rate,								
						day_count_method 			day_count_method,
						rate_type option(nullable) 	rate_type,
						disc_func option(nullable) 	disc_func,
						number option(nullable) 	nominal,
						out number	dirty_price_fwd,
						out number	cf_fund_cost,
						out number cf_net_fund_cost,								
						out number	cf_coc,														
						error_info option(nullable) error) 
{	
	number cpn_reinv_rate;
	cpn_reinv_type 	crt= cpn_reinv_type.FIXED;
	number cf_cpn, cf_cpn_reinv, cf_accr;
	instrument.funding(fwd_settle_date,repo_rate,cpn_reinv_rate,day_count_method,rate_type,disc_func,crt,nominal,							
							dirty_price_fwd,cf_fund_cost,cf_net_fund_cost,cf_accr,cf_coc,cf_cpn,cf_cpn_reinv,error);
	return;
}
/*-----------------------------------------------------------------------
  clean_price_fwd
  ----------------------------------------------------------------------*/
number zero_bond.clean_price_fwd(	date 						fwd_settle_date,
								number  					repo_rate,								
								day_count_method 			day_count_method,
								rate_type option(nullable) 	rate_type,
								disc_func option(nullable) 	disc_func,																
								error_info option(nullable) error)
{	
	number cpn_reinv_rate;
	cpn_reinv_type 	crt= cpn_reinv_type.FIXED;
	return instrument.clean_price_fwd(fwd_settle_date,repo_rate,cpn_reinv_rate,day_count_method,
							rate_type,disc_func,crt,error);
}

/*-----------------------------------------------------------------------
  dirty_price_fwd
  ----------------------------------------------------------------------*/
number zero_bond.dirty_price_fwd(	date 						fwd_settle_date,
								number  					repo_rate,								
								day_count_method 			day_count_method,
								rate_type option(nullable) 	rate_type,
								disc_func option(nullable) 	disc_func,																
								error_info option(nullable) error)
{	
	number cpn_reinv_rate;
	cpn_reinv_type 	crt = cpn_reinv_type.FIXED;
	return instrument.dirty_price_fwd(fwd_settle_date,repo_rate,cpn_reinv_rate,day_count_method,
							rate_type,disc_func,crt,error);
}

/*-----------------------------------------------------------------------
  yield_fwd

  ----------------------------------------------------------------------*/
number zero_bond.yield_fwd(	date 						fwd_settle_date,
							number  					repo_rate,						
							day_count_method 			day_count_method,
							rate_type option(nullable) 	rate_type,
							disc_func option(nullable) 	disc_func,														
							error_info option(nullable) error)
{	
	number cpn_reinv_rate;
	cpn_reinv_type 	crt = cpn_reinv_type.FIXED;
	return instrument.yield_fwd(fwd_settle_date,repo_rate,cpn_reinv_rate,day_count_method,
							rate_type,disc_func,crt,error);
}

/*-----------------------------------------------------------------------
  horizon_return

  ----------------------------------------------------------------------*/
number zero_bond.horizon_return(date 						fwd_settle_date,
								number  					quote,
								..quote_style	option(nullable) quote_style,								
								day_count_method 			day_count_method,
								rate_type option(nullable) 	rate_type,
								disc_func option(nullable) 	disc_func,																
								error_info option(nullable) error)
{	
	number cpn_reinv_rate;
	cpn_reinv_type 	crt = cpn_reinv_type.FIXED;
	return instrument.horizon_return(fwd_settle_date,quote,quote_style,cpn_reinv_rate,day_count_method,
							rate_type,disc_func,crt,error);
}

/*-----------------------------------------------------------------------
  roll_down

  ----------------------------------------------------------------------*/
void zero_bond.roll_down(	date 						fwd_settle_date,							
							disc_func option(nullable) 	disc_func,
							day_count_method 			day_count_method,
							rate_type option(nullable) 	rate_type,
							logical option(nullable) 	realized_fwd,
							out number fwd_yield,
							out number sprd_vs_crv,
							out number roll_sprd,
							out number roll_return,
							out date fwd_trade_date,
							error_info option(nullable) error)
{	
	instrument.roll_down(fwd_settle_date,disc_func,day_count_method,rate_type,realized_fwd,
					 fwd_yield,sprd_vs_crv,roll_sprd,roll_return,fwd_trade_date,error);
}


/*-----------------------------------------------------------------------
  imp_fwd

  ----------------------------------------------------------------------*/
void zero_bond.imp_fwd(	instrument 				instr_long,
						number	option(nullable)	nominal_short,
						number	option(nullable)	nominal_long,
						day_count_method	day_count_method,
						rate_type 			rate_type,
						disc_func 			reinv_disc_func,
						number option(nullable) reinv_sprd_long,
						number option(nullable) take_out_sprd,					
						out number cf_short,
						out number	cf_cpn_long,
						out number cf_cpn_reinv_long,
						out number cf_long,
						out number imp_rate,
						error_info option(nullable) error)
{	
	
	try{
		if(null(nominal_short) && null(nominal_long)) {			
			nominal_short = 100;
			error_info ee 	= new error_info(true,true);
			number dps = this.dirty_price(null<number>,false,true,ee);
			number dpl = instr_long.dirty_price(null<number>,false,true,ee);
			nominal_long = dps/dpl*nominal_short;
		}
		else if(null(nominal_short)) {
			error_info ee 	= new error_info(true,true);
			number dps = this.dirty_price(null<number>,false,true,ee);
			number dpl = instr_long.dirty_price(null<number>,false,true,ee);
			nominal_short = dpl/dps*nominal_long;
		}
		else if(null(nominal_long)) {
			error_info ee 	= new error_info(true,true);
			number dps = this.dirty_price(null<number>,false,true,ee);
			number dpl = instr_long.dirty_price(null<number>,false,true,ee);
			nominal_long = dps/dpl*nominal_short;
		}
		
		instr_error_type t;
   		string 			s;
		number cf_cpn_short,cf_cpn_reinv_short;
		i().__imp_fwd(	instr_long.i(), nominal_short,nominal_long, day_count_method,rate_type,reinv_disc_func,0,
						reinv_sprd_long,take_out_sprd,cf_cpn_short,cf_cpn_reinv_short,cf_short,cf_cpn_long,cf_cpn_reinv_long,cf_long,imp_rate,t, s);
		logical e = CORE_INT.add_error_info(error,t,s, "zero_bond.imp_fwd");
		if(e){ 
			cf_short = cf_long = imp_rate = null<number>;		
		}		
		return ;						
	}
	catch {
		cf_short = cf_long = imp_rate = null<number>;
		CORE_INT.catch_error_info(error,err.type(),err.message(), "zero_bond.imp_fwd");
		return ;
	}
}

