option(null: hard);	
/*	
	instrument wrapper functions
	Developer: Algorithmica Research, Magnus Nyström			

INCOMPLETE

	--------------------------------------------------------------------
	swap_zeroois
	--------------------------------------------------------------------
*/


//----------------------------------------------------------------------
//  class swap_zeroois
//----------------------------------------------------------------------
class swap_zeroois: public swap_gen
option(category: "Instrument/Interest Rate Swap/Zero vs ONIndex")
//option(allow_undeclared_mfuncs)
{
public:
    //override string	instr_type_s();
	override instrument 	inst();
	override swap_zeroois clone();
	
	override void                	__dbg_print(__dbg_label);
    override void                	__dbg_browse(__dbg_split);
	
	/*----------ADD FUNCS [PUBLIC]---------------*/

	override void			final_pmt_date(out date ,out date ,error_info option(nullable) error = null); 
	//override number 		fix_leg_y_to_pv(number option(nullable) y = null<number>,logical l= true ,error_info option(nullable) error = null<error_info>);
	override ir_index 		ir_index(error_info option(nullable) error = null<error_info> ); 
	//override string 		index_tenor(error_info option(nullable) error = null<error_info>) ;
	//override tenor_code 	index_tenor_code(error_info option(nullable) error = null<error_info>) ;


	override instrument_type swap_type(error_info option(nullable) error = null<error_info> );
	vector(ql_swap_leg) 	legs(logical,error_info option(nullable) error = null<error_info>);
	ql_ois_leg 				ois_leg(logical,error_info option(nullable) error = null<error_info>);
	ql_fix_zero_leg 		zero_leg(logical,error_info option(nullable) error = null<error_info>);


	override number  		present_value(	disc_func option(nullable),disc_func option(nullable),out number ,
											out number ,number option(nullable) = null<number>,logical option(nullable) trade_date_pv = false,		
											error_info option(nullable) error = null<error_info>);
	
	override number  		present_value(	disc_func option(nullable),disc_func option(nullable),out number ,out number ,
											date option(nullable) ,date option(nullable) ,
											logical,logical  ,error_info option(nullable) error = null<error_info>);
	
	override number  		present_value(	out number ,out number pv_ois_leg,
											logical option(nullable) ,error_info option(nullable) error = null<error_info> );

	/*---set functions-required--*/
	
	override swap_zeroois	set_quote(number option(nullable),error_info option(nullable) error = null<error_info>);
	override swap_zeroois	set_quote(string option(nullable),error_info option(nullable) error = null<error_info>);

	swap_zeroois			set_quote(number option(nullable),logical option(nullable),error_info option(nullable) error = null<error_info>);
	swap_zeroois			set_quote(string option(nullable),logical option(nullable),error_info option(nullable) error = null<error_info>);

	/*-----set functions-if applicable-----*/

	override swap_zeroois	set_yield(number option(nullable) ,error_info option(nullable) error = null<error_info>);
	
	//local set funcs
	swap_zeroois			set_yield(number option(nullable) ,logical option(nullable),error_info option(nullable) error = null<error_info>);
	swap_zeroois			set_quote_from_yield(number option(nullable),logical option(nullable) set_coupon_to_yield = true, error_info option(nullable) error = null<error_info>);
	

	void 		add_notional(number );
	void 		add_notional(number , number);
	void		add_fx_rate(number,logical,string,string );
	void 		add_fx_mult_zero_leg(number );
	void 		add_fx_mult_ois_leg(number );
	void 		add_disc_func(disc_func ); 
	void 		add_disc_func_zero_leg(disc_func );
	void 		add_disc_func_ois_leg(disc_func );
	disc_func 	disc_func_zero_leg(error_info option(nullable) error = null<error_info>) ;
	disc_func 	disc_func_ois_leg(error_info option(nullable) error = null<error_info> ) ;
	void 		add_surface(tenor_surface option(nullable));
	void		add_fixing(vector(date) ,vector(number) ,logical option(nullable) fixing_as_fwd = false);
	void		add_fixing(number ,logical option(nullable) fixing_as_fwd = false);
	/*void 		add_data( number ,disc_func,tenor_surface,vector(date) ,vector(number) ,
						logical option(nullable) fixing_as_fwd_ois_leg = false);
	void 		add_ccy_data(number,disc_func,number,number,disc_func,number,
							tenor_surface,vector(date),vector(number),logical option(nullable) fixing_as_fwd_ois_leg = false);*/

	override number		solver(number,swap_solver_code ,logical option(nullable) trade_date_pv = false,
						error_info option(nullable) error = null<error_info>);

	override ql_fixed_income_swap 	swap_instrument(error_info option(nullable) error = null<error_info>) ;	

	//override void add_quote(number,logical option(nullable) setc2q = true );
	//void add_quote(number,..quote_style,logical option(nullable) setc2q = true );
	
	swap_zeroois(__instrument);	
	
	swap_zeroois(swap_zeroois);
protected:
	
	override swap_zeroois	create(__instrument option(nullable),out instr_error option(nullable),error_type type = E_INVALID_ARG); 
					
	override swap_zeroois		set_date(date,date option(nullable) s=null<date> ,logical r = true,logical rq = true ,
										 error_info option(nullable) error = null<error_info>);	
	override swap_zeroois		set_date(date,logical ,error_info option(nullable) error = null<error_info>);			/*legacy*/
	override swap_zeroois		move_date(	date,date option(nullable) s=null<date> ,
											error_info option(nullable) error = null<error_info>);						/*legacy*/


	//logical ext_swap_;
	//logical ccy_swap_;
	//logical full_swap_;
};
//------------------------------------------------
// __dbg_print
//------------------------------------------------
void swap_zeroois.__dbg_print(__dbg_label l)
{

	error_info ee 	= new error_info(true,false);
    l.set_text(strcat([
						"name: ",
						name(ee),
						",  ext_swap: ",
						null(ext_swap_) ? "" : string(ext_swap_),
                        ", ccy_swap: ",
						null(ccy_swap_) ? "" : string(ccy_swap_),
						", valid: ",
						null(this.is_valid(ee)) ? "" : string(this.is_valid(ee))
					]));
}
//------------------------------------------------
// __dbg_browse
//------------------------------------------------
void swap_zeroois.__dbg_browse(__dbg_split s)
{
    s.resize(4);
	error_info ee 	= new error_info(true,false);
	
    s.set_text(0, "name");
    s.set_value(0, this.name(ee));

    s.set_text(1, "ext_swap");
    s.set_value(1, ext_swap_);

    s.set_text(2, "ccy_swap");
    s.set_value(2, ccy_swap_);

	s.set_text(3, "valid");
    s.set_value(3, is_valid(ee));
}

//------------------------------------------------
// constructor [HIDDEN, cannot be protected]
//------------------------------------------------
swap_zeroois.swap_zeroois(__instrument i) option(hidden): swap_gen(i)
{
	//try {
		error_info ee 	= new error_info(true,true);
		if(!this.is_valid(ee)) {
			ext_swap_ = ccy_swap_ = full_swap_ = false;
			return;
		}
		ext_swap_ 		= this.is_ext_swap(ee);
		ccy_swap_ 		= this.is_ccy_swap(ee);
		full_swap_ 		= this.verify_full_swap(true,ee);
		return;									
	//}
	//catch {		
	//	CORE_INT.write_warning_message(err.message());
	//}
}
//------------------------------------------------
// instr_type_s
//------------------------------------------------
//string swap_zeroois.instr_type_s() { return string(..instr_type.SWAP_ZEROOIS);}
//------------------------------------------------
// inst
//------------------------------------------------
instrument 	swap_zeroois.inst()		{ return this;}
//------------------------------------------------
// copy constructor
//------------------------------------------------
swap_zeroois.swap_zeroois(swap_zeroois c) : swap_gen(c) {}
//------------------------------------------------
// copy constructor <FUNCTION>
//------------------------------------------------
swap_zeroois swap_zeroois(swap_zeroois b)			{ return new swap_zeroois(b);}
//------------------------------------------------
// clone
//------------------------------------------------
swap_zeroois swap_zeroois.clone() 	{ return new swap_zeroois(this);}
//-----------------------------------------------
// dynamic cast <FUNCTION>   
//-----------------------------------------------
swap_zeroois swap_zeroois(instrument i, error_info option(nullable) error = null<error_info>) 	
option (category: 'Instrument/Interest Rate Swap/Zero vs ONIndex')
option(com_name: 'swap_zeroois_dyncast')
{ 
	try {
		swap_zeroois d = dynamic_cast<swap_zeroois>(i); 
		if(null(d))
			CORE_INT.add_error_info(error,ERR_T_INIT,"invalid cast (instrument is not a swap_zeroois)","swap_zeroois" );

		return d;
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_zeroois");
		return null<swap_zeroois>;
	}
}
//------------------------------------------------
// create  [PROTECTED]
// create swap_zeroois from internal instrument
//------------------------------------------------
swap_zeroois swap_zeroois.create(	__instrument option(nullable) c,
								out instr_error option(nullable) error,
								error_type type )
{
	QL_FAIL_COND(null(c), "invalid/unknown (null) instrument",type );

	logical valid = c.is_valid(error);
	if( !valid && INSTR_CREATE_NULL_ERR)
		return null<swap_zeroois>; 
	
	..instr_type it = c.instr_type(error);
	QL_FAIL_COND(null(it), "invalid instrument type (unknown)",type );
	QL_FAIL_COND(it != ..instr_type.SWAP_ZEROOIS, "invalid instrument type",type );//should not happen
	
	return new swap_zeroois(c);
}
/*-----------------------------------------------------------------------
  create_swap_zeroois
  ----------------------------------------------------------------------*/
swap_zeroois create_swap_zeroois(	__instrument option(nullable) c,
									out instr_error option(nullable) error,
									error_type type = E_INVALID_ARG)
option(com_name: 'INTERNAL_create_swap_zeroois')
{
	QL_FAIL_COND(null(c), "invalid/unknown (null) instrument",type );

	logical valid = c.is_valid(error);
	if( !valid && INSTR_CREATE_NULL_ERR)
		return null<swap_zeroois>; 
	
	..instr_type it = c.instr_type(error);
	QL_FAIL_COND(null(it), "invalid instrument type (unknown)",type );
	QL_FAIL_COND(it != ..instr_type.SWAP_ZEROOIS, "invalid instrument type",type );//should not happen
	
	return new swap_zeroois(c);
}
swap_zeroois create_swap_zeroois(	__instrument option(nullable) 		c,
								error_info option(nullable) 		error,
								error_type 							type = E_INIT)
option(com_name: 'INTERNAL_create_swap_zeroois_ei')
{
	instr_error ee 	= instr_error();
	swap_zeroois b 	= create_swap_zeroois(c,ee, E_INIT);
	if(ee.is_error())
		CORE_INT.add_error_info(error,ee.type(),ee.message(), "create_swap_zeroois");
	return b;
}


/*-----------------------------------------------------------------------
  set_date <protected>
	if trade date is the same --> the settle date will be preserved (if not input)	
	NOTE: 	if coupon is not null in instr_def it is kept unchanged --> deposit will be non-par 
			when a deposit is defined in db the coupon is always null
  ----------------------------------------------------------------------*/
swap_zeroois swap_zeroois.set_date(	date  				trade_date, 
									date  option(nullable)	settle_date,
									logical 			re_init_static, 
									logical 			re_init_quote, 
									error_info option(nullable) error)
{	
	instrument cc = instrument._set_date(trade_date,settle_date,true,re_init_quote,error);
	return null(cc) ? null<swap_zeroois>: dynamic_cast<swap_zeroois>(cc);
	
}

/*-----------------------------------------------------------------------
  set_date <protected/legacy>
	quote is NOT kept even if trade_date is unchanged
  ----------------------------------------------------------------------*/
swap_zeroois swap_zeroois.set_date(	date  				trade_date, 
									logical 			re_init_static, 
									error_info option(nullable) error) 

{	
	instrument cc = instrument._set_date(trade_date,true,error);
	return null(cc) ? null<swap_zeroois>: dynamic_cast<swap_zeroois>(cc);	
}


/*-----------------------------------------------------------------------
   move_date  <protected/legacy>
	changes the trade date of the instrument without retrieving the 
 	corresponding quote from the database or the real-time feed.
	if trade date is the same --> the settle date will be preserved	
  ----------------------------------------------------------------------*/
swap_zeroois swap_zeroois.move_date(	date  				trade_date, 
									date option(nullable) settle_date,
									error_info option(nullable) error) 
{	
	instrument cc = instrument._move_date(trade_date,settle_date,error);
	return null(cc) ? null<swap_zeroois>: dynamic_cast<swap_zeroois>(cc);
}
/*-----------------------------------------------------------------------
  swap_zeroois: set_quote 
  ----------------------------------------------------------------------*/
swap_zeroois swap_zeroois.set_quote(	number 	option(nullable) quote,									
									error_info option(nullable) error)
{	
	instrument cc = instrument._set_quote(quote,null<date>, null<date>, true,error);
	return null(cc) ? null<swap_zeroois>: dynamic_cast<swap_zeroois>(cc);
}

/*-----------------------------------------------------------------------
  swap_zeroois: set_quote 
  ----------------------------------------------------------------------*/
swap_zeroois swap_zeroois.set_quote(	number 	option(nullable) quote,									
									logical option(nullable) set_coupon_to_quote,
									error_info option(nullable) error)
{	
	instrument cc = instrument._set_quote(quote,null<date>, null<date>, set_coupon_to_quote,error);
	return null(cc) ? null<swap_zeroois>: dynamic_cast<swap_zeroois>(cc);
}

/*-----------------------------------------------------------------------
  swap_zeroois: set_quote
  ----------------------------------------------------------------------*/
swap_zeroois swap_zeroois.set_quote(	string 	option(nullable) quote_side,
									error_info option(nullable) error)
{	
	instrument cc = instrument._set_quote(quote_side,null<date>, null<date>, true,error);
	return null(cc) ? null<swap_zeroois>: dynamic_cast<swap_zeroois>(cc);
}

/*-----------------------------------------------------------------------
  swap_zeroois: set_quote
  ----------------------------------------------------------------------*/
swap_zeroois swap_zeroois.set_quote(	string 	option(nullable) quote_side,								
									logical option(nullable) set_coupon_to_quote,
									error_info option(nullable) error)
{	
	instrument cc = instrument._set_quote(quote_side,null<date>, null<date>, set_coupon_to_quote,error);
	return null(cc) ? null<swap_zeroois>: dynamic_cast<swap_zeroois>(cc);
}


/*-----------------------------------------------------------------------
  set_yield
  ----------------------------------------------------------------------*/
swap_zeroois swap_zeroois.set_yield(	number 	option(nullable) yield,							
									error_info option(nullable) error)
{	
	instrument cc = instrument._set_yield(	yield, null<date>, null<date>,true, error);
	return null(cc) ? null<swap_zeroois>: dynamic_cast<swap_zeroois>(cc);
}

/*-----------------------------------------------------------------------
  set_yield
  ----------------------------------------------------------------------*/
swap_zeroois swap_zeroois.set_yield(	number 	option(nullable) yield,
									//date  	option(nullable) trade_date, 
									//date  	option(nullable) settle_date,
									logical option(nullable) set_coupon_to_yield, 								
									error_info option(nullable) error)
option(com_name: 'set_yield_ext')
{	
	instrument cc = instrument._set_yield(	yield, null<date>, null<date>,set_coupon_to_yield, error);
	return null(cc) ? null<swap_zeroois>: dynamic_cast<swap_zeroois>(cc);
}


/*-----------------------------------------------------------------------
  set_quote_from_yield
  ----------------------------------------------------------------------*/
swap_zeroois swap_zeroois.set_quote_from_yield(number 	option(nullable) yield,
											logical option(nullable) set_coupon_to_yield,
											error_info option(nullable) error)
{	
	instrument cc = instrument._set_quote_from_yield(yield,  set_coupon_to_yield,error);
	return null(cc) ? null<swap_zeroois>: dynamic_cast<swap_zeroois>(cc);
}

/*-----------------------------------------------------------------------
  swap_zeroois: add_funcs
  ----------------------------------------------------------------------*/
void swap_zeroois.add_notional(number notional)				{ swap_gen.swap_add_notional(notional);}
void swap_zeroois.add_notional(number notional1, number notional2)	{ swap_gen.swap_add_notional(notional1, notional2);}
void swap_zeroois.add_fx_mult_zero_leg(number fx_mult)		{ swap_gen.swap_add_fx_mult_leg1(fx_mult);}
void swap_zeroois.add_fx_mult_ois_leg(number fx_mult)		{ swap_gen.swap_add_fx_mult_leg2(fx_mult);}
/*-----------------------------------------------------------------------
  add_fx_rate EXT SWAP: ok
  ----------------------------------------------------------------------*/
void swap_zeroois.add_fx_rate(number fx_quote_dec,//must be a quote per unit of base ccy 
							logical pv_in_base_ccy,
							string 	base_ccy,
							string 	price_ccy)
{
	
	swap_gen.swap_add_fx_rate(fx_quote_dec,pv_in_base_ccy,base_ccy,price_ccy);
}
void swap_zeroois.add_disc_func(disc_func disc_func)		{ swap_gen.swap_add_disc_func(disc_func); }
void swap_zeroois.add_disc_func_zero_leg(disc_func disc_func) { swap_gen.swap_add_disc_func_leg1(disc_func); }
void swap_zeroois.add_disc_func_ois_leg(disc_func  disc_func){ swap_gen.swap_add_disc_func_leg2(disc_func); }
void swap_zeroois.add_surface(tenor_surface option(nullable) tenor_surface) 	{ swap_gen.swap_add_surface_leg2(tenor_surface);}
void swap_zeroois.add_fixing(	vector(date) fixing_dates,
								vector(number) fixings,
								logical option(nullable) fixing_as_fwd )
{			
	swap_gen.swap_add_fixing_leg2(fixing_dates,fixings,fixing_as_fwd);						
}
void swap_zeroois.add_fixing(	number fixing_proxy,
								logical option(nullable) fixing_as_fwd ) 
{			
	swap_gen.swap_add_fixing_leg2(fixing_proxy, fixing_as_fwd);						
}
/*-----------------------------------------------------------------------
  swap_zeroois: disc_func_zero_leg / disc_func_ois_leg
  ----------------------------------------------------------------------*/
disc_func swap_zeroois.disc_func_zero_leg(error_info option(nullable) error) 	{ return swap_gen.swap_disc_func_leg1(error);}
disc_func swap_zeroois.disc_func_ois_leg(error_info option(nullable) error) 	{ return swap_gen.swap_disc_func_leg2(error);}
/*-----------------------------------------------------------------------
  swap_type
  ----------------------------------------------------------------------*/
instrument_type swap_zeroois.swap_type(error_info option(nullable) error) 
{	
	return swap_gen.swap_type(error);
}

/*-----------------------------------------------------------------------
  solver
  ----------------------------------------------------------------------*/
number swap_zeroois.solver(	number 				pv,
							swap_solver_code 	solver_code,
							logical option(nullable) trade_date_pv,
							error_info option(nullable) error)
{	
	return swap_gen.solver(pv,solver_code,trade_date_pv,error);
}

/*-----------------------------------------------------------------------
  swap_instrument
  ----------------------------------------------------------------------*/
ql_fixed_income_swap swap_zeroois.swap_instrument(error_info option(nullable) error)
{
	return swap_gen.swap_instrument(error);

}
/*-----------------------------------------------------------------------
  swap_leg
  ----------------------------------------------------------------------*/
vector(ql_swap_leg) swap_zeroois.legs(logical clone,error_info option(nullable) error)
{	
	return swap_gen.swap_leg(clone,error);
}


/*-----------------------------------------------------------------------
  ois_leg
  ----------------------------------------------------------------------*/
ql_ois_leg swap_zeroois.ois_leg(logical clone,error_info option(nullable) error)
{	
	vector(ql_ois_leg) l = swap_gen.swap_ois_leg(clone,error);
	return !null(l) ? l[0] : null<ql_ois_leg>;
}


/*-----------------------------------------------------------------------
  zero_leg
  ----------------------------------------------------------------------*/
ql_fix_zero_leg swap_zeroois.zero_leg(logical clone,error_info option(nullable) error)
{	
	vector(ql_fix_zero_leg) l = swap_gen.swap_fix_zero_leg(clone,error);
	return !null(l) ? l[0] : null<ql_fix_zero_leg>;
}


/*-----------------------------------------------------------------------
  swap_zeroois : ir_index
  ----------------------------------------------------------------------*/
ir_index swap_zeroois.ir_index(error_info option(nullable) error)
{	
	return swap_gen.swap_ir_index_leg2(error);
}

/*-----------------------------------------------------------------------
  index_tenor
  ----------------------------------------------------------------------*/
/*string swap_zeroois.index_tenor(error_info option(nullable) error) 
{	
	return instrument.swap_index_tenor_leg2(error);
}*/

/*-----------------------------------------------------------------------
  index_tenor_code
  ----------------------------------------------------------------------*/
/*tenor_code swap_zeroois.index_tenor_code(error_info option(nullable) error) 
{	
	return instrument.swap_index_tenor_code_leg2(error);
}*/

/*-----------------------------------------------------------------------
  present_value
  ----------------------------------------------------------------------*/
number swap_zeroois.present_value(	disc_func option(nullable)	disc_func_zero_leg,
									disc_func option(nullable) 	disc_func_ois_leg,
									out number pv_zero_leg,
									out number pv_ois_leg,
									number option(nullable) notional,
									logical option(nullable) 	trade_date_pv,																								
									error_info option(nullable) error)
{	
	return swap_gen.present_value(disc_func_zero_leg,disc_func_ois_leg,pv_zero_leg,pv_ois_leg,notional,trade_date_pv,error);
}


number swap_zeroois.present_value(	disc_func option(nullable)	disc_func_zero_leg,
									disc_func option(nullable) 	disc_func_ois_leg,
									out number pv_zero_leg,
									out number pv_ois_leg,
									date option(nullable) pv_date,
									date option(nullable) settle_date,
									logical  	incl_issue_cf,
									logical  	incl_mat_cf,	
									error_info option(nullable) error)
{	
	return swap_gen.present_value(disc_func_zero_leg,disc_func_ois_leg,pv_zero_leg,pv_ois_leg,pv_date, settle_date ,incl_issue_cf,incl_mat_cf,error );
}


number swap_zeroois.present_value(	out number pv_zero_leg,
									out number pv_ois_leg,
									logical option(nullable) 	trade_date_pv,
									error_info option(nullable) error)
{	
	return swap_gen.present_value(pv_zero_leg,pv_ois_leg,trade_date_pv ,error );
}


/*-----------------------------------------------------------------------
  fix_leg_y_to_pv
  ----------------------------------------------------------------------*/
/*number  swap_zeroois.fix_leg_y_to_pv(number option(nullable)	yield,
									logical 				in_pcnt,
									error_info option(nullable) error) 
{	
	return instrument.fix_leg_y_to_pv(yield, in_pcnt, error);
}*/
/*-----------------------------------------------------------------------
  final_pmt_date	EXT SWAP: ok
  ----------------------------------------------------------------------*/
void  swap_zeroois.final_pmt_date(out date 	final_pmt_date_zero_leg,									
								out date 	final_pmt_date_ois_leg,
								error_info option(nullable) error ) 
{	
	swap_gen.final_pmt_date( final_pmt_date_zero_leg, final_pmt_date_ois_leg, error ) ;
}