/*	
	instrument wrapper functions
	Developer: Algorithmica Research, Magnus Nyström			
*/

option(null: hard);	

//***----------GENERAL INSTRUMENT CREATORS [FUNCTION]-----------***
//  ONLY FOR INSTRUMENTS WITH A __instrument root i.e. type supported in instr-dll


/*
if there is an error:
all create functions returns either 
1) a null instrument (if INSTR_CREATE_NULL_ERR is set to true) or,
2) an non-null instrument but which is invalid (if INSTR_CREATE_NULL_ERR is set to false) 

create functions are NOT intended to be public. They are called from "constructor functions".

*/
		
/*-----------------------------------------------------------------------
  create_instrument
  ----------------------------------------------------------------------*/

instrument create_instrument(	__instrument option(nullable) c,
								out instr_error option(nullable) error,
								error_type type = E_INVALID_ARG)
option(com_name: 'INTERNAL_create_instrument')
{
	QL_FAIL_COND(null(c), "invalid/unknown (null) instrument",type );

	logical valid = c.is_valid(error);

	if(!valid && INSTR_CREATE_NULL_ERR)
		return null<instrument>; 

	
	__instr_type __ty = c.__instr_type();
		
	if(null(__ty)){
		if(!valid)
			return null<instrument>; 
		else
			QL_FAIL("invalid/unknown instrument",type); 
	}	

	instr_type ty = CORE_INT.conv_instr_type(__ty);
	
	switch(ty){
	case instr_type.FRA:
		return new fra(c);
	case instr_type.DEPOSIT:
	case instr_type.DEPOSIT_INDEX:
		return new deposit(c);				
	case instr_type.FRN:
		return new frn(c);
	case instr_type.RIBA:
		return new riba(c);
	case instr_type.BILL:
		return new bill(c);
	case instr_type.BILL_FUTURE:
		return new bill_future(c);
	case instr_type.OVERNIGHT_FUTURE:
		return new on_future(c);
	case instr_type.IR_FUTURE:
		return new ir_future(c);
	case instr_type.FIXED_CPN_BOND:
		return new bond(c);
	case instr_type.BOND_FUTURE:
		return new bond_future(c, null<string>);
	case instr_type.ZERO_CPN_BOND:
		return new zero_bond(c);
	case instr_type.FX_SPOT:
		return new ..fx_spot(c);
	case instr_type.FX_SWAP:
		return new fx_swap(c);
	case instr_type.FX_FORWARD:
		return new fx_fwd(c);
	case instr_type.GENERIC:
		return new generic(c);
	case instr_type.EQUITY:
		return new equity(c);	
	case instr_type.SWAP_FIXFLT:
		return new swap_fixflt(c);
	case instr_type.SWAP_FIXFIX:
		return new swap_fixfix(c);
	case instr_type.SWAP_FLTFLT:
		return new swap_fltflt(c);
	case instr_type.SWAP_FLTFLT2S:
		return new swap_fltflt2s(c);
	case instr_type.SWAP_FLTOIS2S:
		return new swap_fltois2s(c);
	case instr_type.SWAP_FIXOIS:
		return new swap_fixois(c);
	case instr_type.SWAP_OISOIS:
		return new swap_oisois(c);
	case instr_type.SWAP_FLTOIS:
		return new swap_fltois(c);
	case instr_type.SWAP_ZEROFLT:
		return new swap_zeroflt(c);		
	case instr_type.IL_REAL_FIXED_CPN_BOND:
		return new il_bond(c);
	case instr_type.IL_REAL_ZERO_CPN_BOND:
		return new il_zero_bond(c);
		
	case instr_type.IL_SWAP_REAL_FIXFLT:
		return new swap_il_rr_fixflt(c);
	case instr_type.IL_SWAP_REAL_FIXOIS:
		return new swap_il_rr_fixois(c);
	case instr_type.IL_SWAP_ZERO:
		return new swap_il_zero(c);
	case instr_type.IL_SWAP_FIX_Y_Y:
		return new swap_il_fixyy(c);
	case instr_type.IL_SWAP_FLT_Y_Y:
		return new swap_il_fltyy(c);
	case instr_type.IL_SWAP_OIS_Y_Y:
		return new swap_il_oisyy(c);
		
	
	case instr_type.SWAP_ZEROOIS:
			
	case instr_type.CALLABLE_FRN:
	case instr_type.RATING_ADJ_BOND:
	case instr_type.CALLABLE_FIX_CPN_BOND:
	case instr_type.NOIS:
	case instr_type.IL_REAL_BILL:	
	default:
		QL_FAIL("invalid instrument type",type );
	}
}

/*-----------------------------------------------------------------------
  create_instrument
  ----------------------------------------------------------------------*/
instrument create_instrument(	__instrument option(nullable) c,
								error_info option(nullable) error,
								error_type type = E_INVALID_ARG)
option(com_name: 'INTERNAL_create_instrument_ei')
{
	instr_error ee = new instr_error();
	instrument cc = create_instrument( c, ee, type);
	if(ee.is_error())
		CORE_INT.add_error_info(error,ee.type(),ee.message(), "create_instrument");
	return cc;
}
/*-----------------------------------------------------------------------
  create_instrument
  ----------------------------------------------------------------------*/

/*instrument create_instrument(	instrument c,
								out instr_error option(nullable) error)
{
	logical valid = c.is_valid(error);

	if(!valid && INSTR_CREATE_NULL_ERR)
		return null<instrument>; 

	instr_type.instr_type ty = c.instr_type();
	QL_FAIL_COND(null(ty),"invalid/unknown instrument",E_INVALID_ARG); 

	switch(ty){
	case instr_type.FRA:
		return new fra(dynamic_cast<fra>(c));
	case instr_type.DEPOSIT:
		return new deposit(dynamic_cast<deposit>(c));
	case instr_type.FRN:
		return new frn(dynamic_cast<frn>(c));
	case instr_type.RIBA:
		return new riba(dynamic_cast<riba>(c));
	case instr_type.BILL:
		return new bill(dynamic_cast<bill>(c));
	case instr_type.BILL_FUTURE:
		return new bill_future(dynamic_cast<bill_future>(c));
	case instr_type.FEDFUND_FUTURE:
		return new fedfund_future(dynamic_cast<fedfund_future>(c));
	case instr_type.IR_FUTURE:
		return new ir_future(dynamic_cast<ir_future>(c));
	case instr_type.FIX_CPN_BOND:
		return new bond(dynamic_cast<bond>(c));
	case instr_type.BOND_FUTURE:
		return new bond_future(dynamic_cast<bond_future>(c));
	case instr_type.ZERO_BOND:
		return new zero_bond(dynamic_cast<zero_bond>(c));
	case instr_type.FX_SPOT:
		return new ..fx_spot(dynamic_cast<fx_spot>(c));
	case instr_type.FX_SWAP:
		return new fx_swap(dynamic_cast<fx_swap>(c));
	case instr_type.FX_FWD:
		return new fx_fwd(dynamic_cast<fx_fwd>(c));
	case instr_type.GENERIC:
		return new generic(dynamic_cast<generic>(c));

	case instr_type.SWAP_FIXFLT:
		return new swap_fixflt(dynamic_cast<swap_fixflt>(c));
	case instr_type.SWAP_FIXFIX:
		return new swap_fixfix(dynamic_cast<swap_fixfix>(c));
	case instr_type.SWAP_FLTFLT:
		return new swap_fltflt(dynamic_cast<swap_fltflt>(c));
	case instr_type.SWAP_FLTFLT2S:
		return new swap_fltflt2s(dynamic_cast<swap_fltflt2s>(c));
	case instr_type.SWAP_FIXOIS:
		return new swap_fixois(dynamic_cast<swap_fixois>(c));
	case instr_type.SWAP_FLTOIS:
		return new swap_fltois(dynamic_cast<swap_fltois>(c));
	case instr_type.SWAP_ZEROFLT:
		return new swap_zeroflt(dynamic_cast<swap_zeroflt>(c));

	case instr_type.IL_BOND:
		return new il_bond(dynamic_cast<il_bond>(c));
	case instr_type.IL_ZERO_BOND:
		return new il_zero_bond(dynamic_cast<il_zero_bond>(c));

	case instr_type.IL_REAL_RATE_SWAP_FIXFLT:
		return new il_rr_swap_fixflt(dynamic_cast<il_rr_swap_fixflt>(c));
	case instr_type.IL_ZERO_SWAP:
		return new il_zero_swap(dynamic_cast<il_zero_swap>(c));

	case instr_type.IL_Y_Y_FIX_SWAP:
	case instr_type.IL_Y_Y_FLT_SWAP:
	case instr_type.CALLABLE_FRN:
	case instr_type.RATING_ADJ_BOND:
	case instr_type.CALLABLE_FIX_CPN_BOND:
	case instr_type.NOIS:
	case instr_type.IL_BILL:
	
	default:
		QL_FAIL("invalid instrument type",E_INVALID_ARG);
	}
}
*/

/*
public "constructor functions" for instrument
*/

/*-----------------------------------------------------------------------
  instrument
  ----------------------------------------------------------------------*/
instrument instrument(	instrument_name 			instrument_name, 
						date option(nullable) 		trade_date 	= null<date>,
						string option(nullable) 	quote_side 	= null<string>,
						date option(nullable) 		settle_date = null<date>,
						error_info option(nullable) error = null<error_info>)
option(com_name: 'db_instrument')
option (category: 'Instrument')
{	
	try{	
		trade_date = conv_null_date_com(trade_date) ;	
		quote_side = conv_null_string_com(quote_side) ;
		settle_date = conv_null_date_com(settle_date) ;

		/*logical use_prefetch = false;//for now
		if(use_prefetch && !null(trade_date) && trade_date == today()) {
			try {
				error_info e = new error_info(true,true);				
				instr_def def = instr_def(instrument_name,e);
				CORE_INT.instr_prefetch(def, quote_side);	
			}
			catch {}
		}*/
		__instrument c = __instrument(instrument_name,trade_date,quote_side, settle_date );		
		return create_instrument( c, error);
					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument");
		return null<instrument>;
	}
}

/*-----------------------------------------------------------------------
  instrument
  ----------------------------------------------------------------------*/
instrument instrument(	instrument_name 			instrument_name, 
						date option(nullable) 		trade_date ,
						string option(nullable) 	quote_side ,
						error_info option(nullable) error)
option(com_name: 'db_instrument_qs2')
option (category: 'Instrument')
{
	return instrument(	instrument_name, trade_date ,quote_side , null<date>,error );
}

/*-----------------------------------------------------------------------
  instrument
  ----------------------------------------------------------------------*/
instrument instrument(	instrument_name 			instrument_name, 
						date option(nullable) 		trade_date ,
						number  option(nullable) 	quote ,
						date option(nullable) 		settle_date ,
						error_info option(nullable) error = null<error_info>)
option(com_name: 'db_instrument_q')
option (category: 'Instrument')
{	
	try{
		trade_date 	= conv_null_date_com(trade_date) ;	
		quote		= conv_null_number_com(quote) ;
		settle_date = conv_null_date_com(settle_date) ;
				
		__instrument c = __instrument(instrument_name,trade_date,quote, settle_date );
		return create_instrument( c, error);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument");
		return null<instrument>;
	}
}

/*-----------------------------------------------------------------------
  instrument
  ----------------------------------------------------------------------*/
instrument instrument(	instrument_name 			instrument_name, 
						date option(nullable) 		trade_date ,
						number  option(nullable) 	quote ,
						error_info option(nullable) error = null<error_info>)
option(com_name: 'db_instrument_q2')
option (category: 'Instrument')
{
	return instrument(	instrument_name, trade_date ,quote , null<date>,error );
}

/*-----------------------------------------------------------------------
  instrument
  ----------------------------------------------------------------------*/
instrument instrument(	instr_def 					def, 
						date option(nullable) 		trade_date 	= null<date>,
						string option(nullable) 	quote_side 	= null<string>,
						date option(nullable) 		settle_date = null<date>,
						error_info option(nullable) error = null<error_info>)
option(com_name: 'db_instrument_from_def_qs')
option (category: 'Instrument')
{	
	try{	
		trade_date = conv_null_date_com(trade_date) ;	
		quote_side = conv_null_string_com(quote_side) ;
		settle_date = conv_null_date_com(settle_date) ;

		/*logical use_prefetch = false;//for now
		if(use_prefetch && !null(trade_date) && trade_date == today()) {
			CORE_INT.instr_prefetch(def, quote_side);	
		}*/
		
		__instrument c = __instrument(def,trade_date,quote_side, settle_date );
		return create_instrument( c, error);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument");
		return null<instrument>;
	}
}
/*-----------------------------------------------------------------------
  instrument
  ----------------------------------------------------------------------*/
instrument instrument(	instr_def 					def,  
						date option(nullable) 		trade_date ,
						string option(nullable) 	quote_side ,
						error_info option(nullable) error)
option(com_name: 'db_instrument_from_def_qs2')
option (category: 'Instrument')
{
	return instrument(	def, trade_date ,quote_side , null<date>,error );
}
/*-----------------------------------------------------------------------
  instrument
  ----------------------------------------------------------------------*/
instrument instrument(	instr_def 					def, 
						date option(nullable) 		trade_date ,
						number  option(nullable) 	quote ,
						date option(nullable) 		settle_date ,
						error_info option(nullable) error = null<error_info>)
option(com_name: 'db_instrument_from_def')
option (category: 'Instrument')
{	
	try{	
		trade_date 	= conv_null_date_com(trade_date) ;	
		quote 		= conv_null_number_com(quote) ;
		settle_date = conv_null_date_com(settle_date) ;
		
		__instrument c = __instrument(def,trade_date,quote, settle_date );
		return create_instrument( c, error);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument");
		return null<instrument>;
	}
}

/*-----------------------------------------------------------------------
  instrument
  ----------------------------------------------------------------------*/
instrument instrument(	instr_def 					def,  
						date option(nullable) 		trade_date ,
						number  option(nullable) 	quote ,
						error_info option(nullable) error= null<error_info>)
option(com_name: 'db_instrument_from_def2')
option (category: 'Instrument')
{
	return instrument(	def, trade_date ,quote , null<date>,error );
}

/*-----------------------------------------------------------------------
  instrument
  ----------------------------------------------------------------------*/
instrument instrument(	instr_def 					def, 
						date option(nullable) 		trade_date ,
						quote_link option(nullable) quote_link ,
						error_info option(nullable) error = null<error_info>)
option(com_name: 'db_instrument_from_def_ql')
option (category: 'Instrument')
{	
	try{
		
		number quote = quote_link.quote();			
		__instrument c = __instrument(def,trade_date,quote, null<date> );
		return create_instrument( c, error);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument");
		return null<instrument>;
	}
}

//***----------SPECIFIC INSTRUMENT CREATORS [FUNCTIONS]-----------***

/*-----------------------------------------------------------------------
  func: instrument_swap
  ----------------------------------------------------------------------*/
instrument instrument_swap(	ql_swap_leg 	ql_swap_leg1, 							
							ql_swap_leg 	ql_swap_leg2,
							string 			id,
							error_info option(nullable) error = null<error_info>)
option(com_name: 'db_instrument_swap_leg_e')
option (category: 'Instrument/Interest Rate Swap')
{	
	try{			
		__instrument c = __instrument_swap(ql_swap_leg1,ql_swap_leg2,id);
		return create_instrument( c, error);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument_swap");
		return null<instrument>;
	}
}

/*-----------------------------------------------------------------------
  func: instrument_swap
  ----------------------------------------------------------------------*/
instrument instrument_swap(	ql_fixed_income_swap ql_fixed_income_swap,
							error_info option(nullable) error = null<error_info>)
option(com_name: 'db_instrument_swap_e')
option (category: 'Instrument/Interest Rate Swap')
{	
	try{			
		__instrument c = __instrument_swap(ql_fixed_income_swap);
		return create_instrument( c, error);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument_swap");
		return null<instrument>;
	}
}




