/*	
	instrument wrapper functions
	Developer: Algorithmica Research, Magnus Nyström

	------------------------
	 ir_future create funcs	
	------------------------				
*/

option(null: hard);	

//--------
// from db
//--------


/*-----------------------------------------------------------------------
  ir_future
  ----------------------------------------------------------------------*/
ir_future ir_future(instrument_name 			instrument_name, 
					date option(nullable) 		trade_date 	= null<date>,
					string option(nullable)	 	quote_side 	= null<string>,					
					error_info option(nullable) error		= null<error_info>)
option (category: 'Instrument/Interest Rate Future')
{	
	try{			
		__instrument c = __instrument(instrument_name,trade_date,quote_side, null<date> );		
		return create_ir_future(c,error, E_INIT);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "ir_future");
		return null<ir_future>;
	}
}

/*-----------------------------------------------------------------------
  ir_future
  ----------------------------------------------------------------------*/
ir_future ir_future(instrument_name 			instrument_name, 
					date option(nullable) 		trade_date ,
					number  option(nullable) 	quote ,				
					error_info option(nullable) error		= null<error_info>)
option (category: 'Instrument/Interest Rate Future')
{	
	try{				
		__instrument c = __instrument(instrument_name,trade_date,quote,null<date> );
		return create_ir_future(c,error, E_INIT);							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "ir_future");
		return null<ir_future>;
	}
}

/*-----------------------------------------------------------------------
  ir_future
  ----------------------------------------------------------------------*/
ir_future ir_future(instr_def 					instr_def, 
					date option(nullable) 		trade_date 	= null<date>,
					string option(nullable) 	quote_side 	= null<string>,			
					error_info option(nullable) error		= null<error_info>)
option (category: 'Instrument/Interest Rate Future')
{	
	try{				
		__instrument c = __instrument(instr_def,trade_date,quote_side, null<date> );
		return create_ir_future(c,error, E_INIT);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "ir_future");
		return null<ir_future>;
	}
}
/*-----------------------------------------------------------------------
  ir_future
  ----------------------------------------------------------------------*/
ir_future ir_future(instr_def 					instr_def, 
					date option(nullable) 		trade_date ,
					number  option(nullable) 	quote ,				
					error_info option(nullable) error		= null<error_info>)
option (category: 'Instrument/Interest Rate Future')
{	
	try{			
		__instrument c = __instrument(instr_def,trade_date,quote, null<date> );
		return create_ir_future(c,error, E_INIT);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "ir_future");
		return null<ir_future>;
	}
}

//----------------
// from db or not
//----------------

/*-----------------------------------------------------------------------
  func: instrument_irfut_nodb
	arguments: 
	instr_def: 	can be created either from the db or user defined 
				no lookup of quotes 
				instr_def is copied and modified
  ----------------------------------------------------------------------*/
ir_future ir_future(	instr_def 				instr_def, 
						string 					instrument_name  ,
						date option(nullable) 	trade_date ,
						date option(nullable)	expiry_settle_date ,
						number option(nullable) market_quote,//note: quote
						number option(nullable)	contract_quote,	//note: quote					
						number 	option(nullable) nominal = 100,
						error_info option(nullable) error		= null<error_info>)
option (category: 'Instrument/Interest Rate Future')
{	
	try{			
		__instrument c = __instrument_irfut_nodb(instr_def,instrument_name,trade_date,expiry_settle_date,
												market_quote,contract_quote,nominal);
		return create_ir_future(c, error);					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "ir_future");
		return null<ir_future >;
	}
}
 

