option(null: hard);	

/*	
	swaplib wrapper functions
	Developer: Algorithmica Research, Magnus Nyström

	--------------------------------------------------------------------
	 	swap help functions for create funcs
	--------------------------------------------------------------------			
*/

//----------------
// swaps created here can be created from an instr_def (swaps that originates in the database), from templates or from individual arguments 
// - swaps that originates in the database (db-swaps) are limited to swaps as seen on a market-screen i.e. plainvanilla markets swaps that are not aged
// - swaps created here does not have the limitations of the db-swaps.
//----------------

/*
Note on mtm:
- database swaps: 	all swaps have mtm on leg2  --> fltois: mtm is currently only possible to have on the ois leg
- database swaps: 	mtm is only applicable for fltflt, oisois and fltois
*/

module CORE_SWAPLIB
{
		
	/*-----------------------------------------------------------------------
	 -----------------------------------------------------------------------
	 -----class legleg_parm--------------------------------------------------
	 -----------------------------------------------------------------------
	 -----------------------------------------------------------------------*/
	class legleg_parm
	{
	protected:
		virtual instr_type	type() = 0;
	public:

		logical			is_inited();
		logical 		is_cross_currency();
		void			set_inited(logical);
		void 			set_fwd_start(date, string , calendar option(nullable) );
		void 			set_spot_start(date, string , calendar option(nullable) );		
		void 			set_settle(date, date, calendar option(nullable) cal );
		void 			maturity_helper(fix_parm);
		void 			maturity_helper(flt_parm);
		void 			maturity_helper(ois_parm);
		void 			maturity_helper(bd_convention option(nullable) ,logical option(nullable) ,calendar option(nullable) );
		void 			set_imp_calc_dec(integer);
		void 			set_pv01_not_unit(number);
protected:

		legleg_parm();
		
		void			create_ois_surface(	ois_parm op,
											disc_func option(nullable)	 df_disc_func,
											fwd_func  option(nullable)		ois_fwd_func,
											disc_func  option(nullable)		ois_fwddf_func,
											out disc_func 	flt_disc_func,
											out disc_func 	ois_disc_func,
											out tenor_surface ois_tenor_surface);
	
		
		ql_swap_fix_def 	create_swap_fix_def(fix_parm , string );
		ql_swap_float_def 	create_swap_float_def(flt_parm , string );
		ql_swap_ois_def 	create_swap_ois_def(ois_parm,string name);
		ql_fix_leg 			create_swap_fix_leg(	fix_parm ,ql_swap_fix_def,string,logical,disc_func option(nullable));
		ql_float_leg 		create_swap_float_leg(	flt_parm ,ql_swap_float_def,string,logical ,disc_func option(nullable),tenor_surface option(nullable));		
		ql_ois_leg 			create_swap_ois_leg(ois_parm , ql_swap_ois_def ,string,logical, disc_func option(nullable), tenor_surface option(nullable));		
		
		void 			schedule_helper(date option(nullable),
										date option(nullable),
										integer							freq,
										calendar option(nullable) 		cal,
										bd_convention option(nullable) 	bus_day,
										bd_convention option(nullable) 	bus_day_mat,
										stub_type 						stub,
										logical option(nullable) 		eom,
										date option(nullable) 			eff_date,
										date option(nullable) 			first_cpn_date,
										date option(nullable) 			last_reg_cpn_date,
										integer							roll_day,
										out date 						eff_date_out,
										out date 						first_cpn_date_out,
										out date 						last_reg_cpn_date_out,
										out integer 					roll_day_out,
										integer	    					pmt_delay ,
										integer	    					pmt_delay_mat ,
										integer	    					min_dflt_period	= 5);
		
		void 			set_fx_input( 	string option(nullable), string option(nullable),
										number 	option(nullable)	fx_quote,
										string  option(nullable)	fx_quote_baseccy,
										string 	option(nullable)	fx_quote_priceccy,
										logical option(nullable)	pv_in_base_ccy,
										number 	option(nullable)	not_leg1,
										number 	option(nullable)	not_leg2,
										out number ,
										out number );
		
		void 			fx_notional_helper(out number,out number,out number,out number);
		void 			schedule_helper(out fix_parm );
		void 			schedule_helper(out flt_parm );
		void 			schedule_helper(out ois_parm );
		void 			start_date_helper(date option(nullable) ,date option(nullable) ,calendar option(nullable));
		tenor_surface 	create_flt_surface(flt_parm ,disc_func option(nullable) ,fwd_func option(nullable) ,
										   disc_func option(nullable),  logical option(nullable) );
		tenor_surface 	create_flt_surface(flt_parm ,disc_func option(nullable) ,vector(fwd_func) option(nullable) ,
										   vector(disc_func) option(nullable),vector(tenor_code) option(nullable),
										   logical option(nullable) );
		
		void			fx_rate_init(string 		leg1_curr,
									 string 		leg2_curr,
									 string option(nullable) fx_quote_base_ccy,
									 string option(nullable) fx_quote_price_ccy,
									 logical option(nullable)	pv_in_base_ccy,
									 number 		fx_quote,
									 out logical 	leg1_is_base_ccy,
									 out number 	leg1_fx_mult,
									 out number 	leg2_fx_mult)	;

		logical 		is_aged_swap();
		logical 		is_mtm_leg2() ;
		logical 		is_mtm_leg1() ;

		void set_mtm_data(	string 		ccy_leg1,
									string 		ccy_leg2,
									calendar 	cal_leg1,
									calendar	cal_leg2,
									number 	option(nullable)  mtm_fx_quote,
									calendar option(nullable) mtm_usd_calendar);

		number 		mtm_fx_spot_rate();
	public:

		//def
						
		notional_exchg_style 	ne_;		
		string 					spot_code_;
		
		//leg
		date 			trade_date_;
		date 			maturity_;
		string 			maturity_code_;
		tenor_code 		mat_code_;
		string 			fwd_start_code_;
		logical			fwd_code_spot_offset_;
		date 			start_date_;
		date 			settle_date_;
		//integer 		cpn_roll_day_;

		number 	 		fx_quote_;
		string  		fx_quote_baseccy_;
		string 	 		fx_quote_priceccy_;
		logical  		pv_in_base_ccy_;

		string 			name_;
		logical 		pay_leg1_;
		number 			leg_pv01_;
		integer 		imp_calc_dec_;
		number 			pv01_not_unit_;
	protected:
		logical 		is_ccy_;	
		logical 		is_inited_;
		//mtm
		logical 		is_mtm_ ;	
		logical 		is_mtm_leg1_;
		number 			mtm_fx_spot_rate_;
		integer 		mtm_fx_spot_days_;
		fx_spot_rule 	mtm_fx_rule_;
		date 			mtm_fx_spot_dt_;
		calendar 		mtm_usd_calendar_;
	};
	/*-----------------------------------------------------------------------
	  constructor
	  ----------------------------------------------------------------------*/
	legleg_parm.legleg_parm()
	{
		is_ccy_				= null;
		name_				= "no_name";
		pay_leg1_			= false;
		fwd_code_spot_offset_ = true;
		fx_quote_ 			= 1;
		fx_quote_baseccy_ 	= null;
		fx_quote_priceccy_ 	= null;
		pv_in_base_ccy_		= true;
		//cpn_roll_day_ 		= 0;
		leg_pv01_			= null;
		imp_calc_dec_		= -1;
		pv01_not_unit_		= -1;
		is_inited_			= false;

		is_mtm_ 			= false;
		is_mtm_leg1_		= false;
		mtm_fx_spot_rate_ 	= null;
		mtm_fx_spot_days_	= 2;
		mtm_fx_rule_		= fx_spot_rule.STD;
		mtm_fx_spot_dt_		= null;
		mtm_usd_calendar_	= null;
	}

	/*-----------------------------------------------------------------------
	  set_inited / is_inited
	  ----------------------------------------------------------------------*/
	void 	legleg_parm.set_inited(logical is_inited) 	{ is_inited_ = is_inited;}
	logical	legleg_parm.is_inited() 					{return is_inited_;}
	logical legleg_parm.is_cross_currency()				{ return is_ccy_;}
	/*-----------------------------------------------------------------------
	  set 
	  ----------------------------------------------------------------------*/
	void legleg_parm.set_imp_calc_dec(integer dec) 	{ imp_calc_dec_ = dec;}
	void legleg_parm.set_pv01_not_unit(number n) 	{ pv01_not_unit_ = n;}
	/*-----------------------------------------------------------------------
	  is_aged_swap 
	  ----------------------------------------------------------------------*/
	logical legleg_parm.is_aged_swap()
	{
		return !null(start_date_) && !null(settle_date_) && start_date_ < settle_date_;
	}
	/*-----------------------------------------------------------------------
	  is_mtm 
	  ----------------------------------------------------------------------*/
	//logical 	legleg_parm.is_mtm_leg2() { return false;}
	//logical 	legleg_parm.is_mtm_leg1() { return false;}
	logical legleg_parm.is_mtm_leg2()		{ return is_mtm_ && !is_mtm_leg1_ ;}
	logical legleg_parm.is_mtm_leg1()		{ return is_mtm_leg1_ ;}
	/*-----------------------------------------------------------------------
	  mtm_fx_spot_rate
	  ----------------------------------------------------------------------*/
	number 	legleg_parm.mtm_fx_spot_rate() { return mtm_fx_spot_rate_;}
	/*-----------------------------------------------------------------------
	  set_fx_input
	  ----------------------------------------------------------------------*/
	void legleg_parm.set_fx_input(	string 	option(nullable)	ccy_leg1,
									string 	option(nullable)	ccy_leg2,
									number 	option(nullable)	fx_quote,
									string  option(nullable)	fx_quote_baseccy,
									string 	option(nullable)	fx_quote_priceccy,
									logical option(nullable)	pv_in_base_ccy,
									number 	option(nullable)	not_leg1,
									number 	option(nullable)	not_leg2,
									out number 					fx_mult1,
									out number 					fx_mult2)
	{
		QL_REQUIRE(!null(ccy_leg1), "invalid currency (leg1)");
		QL_REQUIRE(!null(ccy_leg2), "invalid currency (leg2)");
		
		is_ccy_ = !equal_casei(ccy_leg1, ccy_leg2);
		
		if(is_ccy_) {
			if(null(not_leg1) || null(not_leg2))
				QL_REQUIRE(!null(fx_quote),"invalid fx quote (required for cross currency swaps)");
			QL_REQUIRE(!null(fx_quote_baseccy),"invalid fx base currency (required for cross currency swaps)");
			QL_REQUIRE(!null(fx_quote_priceccy),"invalid fx price currency (required for cross currency swaps)");

			if(null(fx_quote)) {				
				fx_quote = equal_casei(fx_quote_priceccy,ccy_leg1) ? not_leg1/not_leg2 : not_leg2/not_leg1;			
			}
			
			fx_quote_ 			= fx_quote;
			fx_quote_baseccy_ 	= fx_quote_baseccy;
			fx_quote_priceccy_ 	= fx_quote_priceccy;
			pv_in_base_ccy_		= pv_in_base_ccy;
		
			logical leg1_is_base_ccy;			
			fx_rate_init(ccy_leg1,ccy_leg2, fx_quote_baseccy_, fx_quote_priceccy_, pv_in_base_ccy_,
						 fx_quote_, leg1_is_base_ccy, fx_mult1, fx_mult2);
		}
		else {
			fx_quote_ 			= 1;
			fx_quote_baseccy_ 	= null;
			fx_quote_priceccy_ 	= null;
			pv_in_base_ccy_		= true;
			fx_mult1 			= 1;
			fx_mult2 			= 1;
		}
	}

	/*-----------------------------------------------------------------------
	  set_mtm_fx_spot_rate
	  ----------------------------------------------------------------------*/
	void legleg_parm.set_mtm_data(	string 		ccy_leg1,
									string 		ccy_leg2,
									calendar 	cal_leg1,
									calendar	cal_leg2,
									number 	option(nullable)  mtm_fx_quote,
									calendar option(nullable) mtm_usd_calendar)
	{
		

		mtm_usd_calendar_ = mtm_usd_calendar;
		
		if(!is_ccy_) {
			mtm_fx_spot_rate_ = null;
			return;
		}	
			
		if(is_mtm_leg1()){

			CORE_INT_SWAPLIB.mtm_data(trade_date_,ccy_leg1, cal_leg1,
								  ccy_leg2, cal_leg2,
								  mtm_usd_calendar_,
								  mtm_fx_spot_days_, mtm_fx_rule_, mtm_fx_spot_dt_);

			if(null(mtm_fx_quote)){
				if(!null(settle_date_) && !null(mtm_fx_spot_dt_) &&  settle_date_ == mtm_fx_spot_dt_)
					mtm_fx_quote = fx_quote_;
			}
			
			if(equal_casei(ccy_leg1, fx_quote_baseccy_))
				mtm_fx_spot_rate_ = mtm_fx_quote;
			else
				mtm_fx_spot_rate_ = 1.0/mtm_fx_quote;

			
		}
		else {
			CORE_INT_SWAPLIB.mtm_data(trade_date_,ccy_leg2, cal_leg2,
								  ccy_leg1, cal_leg1,
								  mtm_usd_calendar_,
								  mtm_fx_spot_days_, mtm_fx_rule_, mtm_fx_spot_dt_);

			if(null(mtm_fx_quote)){
				if(!null(settle_date_) && !null(mtm_fx_spot_dt_) &&  settle_date_ == mtm_fx_spot_dt_)
					mtm_fx_quote = fx_quote_;
			}
			
			if(equal_casei(ccy_leg2, fx_quote_baseccy_))
				mtm_fx_spot_rate_ = mtm_fx_quote;
			else
				mtm_fx_spot_rate_ = 1.0/mtm_fx_quote;
			
		}		
	}
	/*-----------------------------------------------------------------------
	  create_flt_surface
	  ----------------------------------------------------------------------*/
	tenor_surface legleg_parm.create_flt_surface(	flt_parm fp,
													disc_func option(nullable) 	flt_disc_func,
													fwd_func option(nullable) 	flt_fwd_func,
													disc_func option(nullable) 	flt_fwd_disc_func,
													logical option(nullable) allow_extrap)
										
	{
		//return this.create_flt_surface(fp.flt_ir_index_,flt_disc_func,flt_fwd_func,flt_fwd_disc_func);	
		tenor_surface flt_tenor_surface;
		CORE_INT_SWAPLIB.create_tenor_surface_flt(trade_date_, flt_disc_func, [flt_fwd_func], [flt_fwd_disc_func],
												  null<vector(tenor_code)>, fp.flt_ir_index_, allow_extrap,flt_tenor_surface);
		return flt_tenor_surface;
	}

	
	
	/*-----------------------------------------------------------------------
	  create_flt_surface
	  ----------------------------------------------------------------------*/
	tenor_surface legleg_parm.create_flt_surface(	flt_parm fp,
													disc_func option(nullable) 	flt_disc_func,
													vector(fwd_func) option(nullable) 	flt_fwd_func,
													vector(disc_func) option(nullable) 	flt_fwd_disc_func,
													vector(tenor_code) option(nullable) flt_tenor_code,
													logical option(nullable) allow_extrap)
										
	{
		//return this.create_flt_surface(fp.flt_ir_index_,flt_disc_func,flt_fwd_func,flt_fwd_disc_func);	
		tenor_surface flt_tenor_surface;
		CORE_INT_SWAPLIB.create_tenor_surface_flt(trade_date_, flt_disc_func, flt_fwd_func, flt_fwd_disc_func,
												  flt_tenor_code, fp.flt_ir_index_, allow_extrap,flt_tenor_surface);
		return flt_tenor_surface;
	}
	/*-----------------------------------------------------------------------
	  create_ois_surface
	  ----------------------------------------------------------------------*/
	void legleg_parm.create_ois_surface(	ois_parm op,
										disc_func option(nullable)	 df_disc_func,
										fwd_func  option(nullable)		ois_fwd_func,
										disc_func  option(nullable)		ois_fwddf_func,
										out disc_func 	flt_disc_func,
										out disc_func 	ois_disc_func,
										out tenor_surface ois_tenor_surface)
	{
		CORE_INT_SWAPLIB.ois_df_fwd_helper(	is_ccy_,  df_disc_func, ois_fwd_func, ois_fwddf_func,
											op.ois_ir_index_, op.ois_endog_df_, op.ois_is_approx_calc_,
											trade_date_, settle_date_, maturity_, maturity_code_,
											flt_disc_func,ois_disc_func,ois_tenor_surface);
	}
	/*-----------------------------------------------------------------------
	  set_maturity
	  ----------------------------------------------------------------------*/
	/*void legleg_parm.set_maturity(	date option(nullable) maturity,
									string 	option(nullable) maturity_code)
	{
		QL_FAIL_COND(null(maturity) && null(maturity_code) , "invalid maturity/maturity_code", E_INIT);

		maturity_ = maturity;
		maturity_code_ = maturity_code;
		maturity_helper(null );
		//date m = mat_code_.date(d, bd, eom, cal)
	}*/
	/*-----------------------------------------------------------------------
	  set_settle
	  ----------------------------------------------------------------------*/	
	void legleg_parm.set_settle(date trade_date,
								date settle_date,
								calendar option(nullable) cal)
	{
		trade_date_ = trade_date;
		settle_date_ = settle_date;

		CORE_INT_SWAPLIB.swap_start_date_helper(spot_code_, trade_date_,cal,fwd_start_code_,
												fwd_code_spot_offset_,start_date_,settle_date_);
		QL_FAIL_COND(null(settle_date),"invalid settle date", E_INIT);
	}
	/*-----------------------------------------------------------------------
	  set_fwd_start
	  ----------------------------------------------------------------------*/	
	void legleg_parm.set_fwd_start(date trade_date,
								   string fwd_start_code,
								   calendar option(nullable) cal)
	{
		trade_date_ 	= trade_date;
		fwd_start_code_ = fwd_start_code;
		start_date_ 	= null;
		settle_date_ 	= null;
		CORE_INT_SWAPLIB.swap_start_date_helper(spot_code_,trade_date_,cal,fwd_start_code_,fwd_code_spot_offset_,start_date_,settle_date_);
		QL_FAIL_COND(null(settle_date_),"invalid settle date", E_INIT);
	}
	/*-----------------------------------------------------------------------
	  set_spot_start
	  ----------------------------------------------------------------------*/	
	void legleg_parm.set_spot_start(date trade_date,
									string spot_code,
									calendar option(nullable) cal)
	{
		trade_date_ 	= trade_date;
		fwd_start_code_ = null;
		start_date_ 	= null;
		settle_date_ 	= null;
		CORE_INT_SWAPLIB.swap_start_date_helper(spot_code_,trade_date_,cal,fwd_start_code_,fwd_code_spot_offset_,start_date_,settle_date_);
		QL_FAIL_COND(null(settle_date_),"invalid settle date", E_INIT);
	}
	/*-----------------------------------------------------------------------
	  start_date_helper
	  ----------------------------------------------------------------------*/	
	void legleg_parm.start_date_helper(date option(nullable) leg1_eff,
									   date option(nullable) leg2_eff,
									   calendar option(nullable) cal)
	{
		logical start_dt_inp = !null(start_date_);
		
		CORE_INT_SWAPLIB.swap_start_date_helper(spot_code_,trade_date_,cal,fwd_start_code_,fwd_code_spot_offset_,start_date_,settle_date_);
		QL_FAIL_COND(null(settle_date_),"invalid settle date", E_INIT);//start_date is ok if settle is ok

		if(null(leg1_eff) && null(leg2_eff))
			return;
			
		if(!start_dt_inp){
			if(null(leg1_eff)){
				if(leg2_eff > start_date_)				
					//start_date = null;
				   QL_FAIL("invalid settle date", E_INIT);
			}
			else if(null(leg2_eff)){
				if(leg1_eff > start_date_)
					//start_date = null;
					QL_FAIL("invalid settle date", E_INIT);
			}
			else {
				if(leg1_eff > start_date_ || leg2_eff > start_date_)
					//start_date = null;
					QL_FAIL("invalid settle date", E_INIT);
			}
		}
	}
	/*-----------------------------------------------------------------------
	  maturity_helper
	  ----------------------------------------------------------------------*/	
	void legleg_parm.maturity_helper(bd_convention option(nullable) pmt_bus_day,
									 logical option(nullable) 		end_of_month,
									 calendar option(nullable) 		cal)
	{
		mat_code_ = CORE_INT_SWAPLIB.swap_maturity_helper(null, maturity_, maturity_code_);//will throw if neither date or code is ok

		if(null(maturity_)){
			QL_REQUIRE(!null(settle_date_),"settle date not initialized (required to calculate maturity from maturity code)");
			QL_REQUIRE(!null(pmt_bus_day),"bus day convention  not initialized (required to calculate maturity from maturity code)");
			QL_REQUIRE(!null(end_of_month),"end of month not initialized (required to calculate maturity from maturity code)");
			QL_REQUIRE(!null(cal),"calendar inot initialized (required to calculate maturity from maturity code)");
			maturity_ = mat_code_.date(settle_date_, pmt_bus_day, end_of_month, cal);
			QL_REQUIRE(!null(maturity_),"error calculating maturity from maturity code)");
		}
	}
	/*-----------------------------------------------------------------------
	  maturity_helper
	  ----------------------------------------------------------------------*/	
	void legleg_parm.maturity_helper(fix_parm fip)
	{
		this.maturity_helper(fip.fix_pmt_bus_day_,fip.fix_end_of_month_,fip.fix_pmt_calendar_);
	}
	void legleg_parm.maturity_helper(flt_parm fp)
	{
		this.maturity_helper(fp.flt_pmt_bus_day_,fp.flt_end_of_month_,fp.flt_pmt_calendar_);
	}
	void legleg_parm.maturity_helper(ois_parm op)
	{
		this.maturity_helper(op.ois_pmt_bus_day_,op.ois_end_of_month_,op.ois_pmt_calendar_);
	}

	/*-----------------------------------------------------------------------
	  fx_notional_helper
	  ----------------------------------------------------------------------*/
	void legleg_parm.fx_notional_helper(out number leg1_notional,
										out number leg2_notional,
										out number leg1_fx_mult ,
										out number leg2_fx_mult)
	{
		CORE_INT_SWAPLIB.set_ccy(is_ccy_,leg1_notional, leg2_notional, leg1_fx_mult , leg2_fx_mult);
	}

	/*-----------------------------------------------------------------------
	  schedule_helper
	  ----------------------------------------------------------------------*/
	void legleg_parm.schedule_helper(out fix_parm fip)
	{
		integer pmt_delay 		= 0;
		integer pmt_delay_mat 	= 0;
		integer freq 			= coupon_freq_to_int(fip.fix_cpn_freq_);
		integer roll_day_out;
		date eff_date_out, first_cpn_date_out, last_reg_cpn_date_out;
		schedule_helper(start_date_, maturity_,freq, fip.fix_pmt_calendar_, fip.fix_pmt_bus_day_, fip.fix_pmt_bus_day_mat(),
						fip.fix_stub_type_, fip.fix_end_of_month_,
						fip.fix_eff_date_, fip.fix_first_cpn_date_, fip.fix_last_reg_date_,fip.fix_roll_day_,
						eff_date_out, first_cpn_date_out, last_reg_cpn_date_out,roll_day_out, pmt_delay,pmt_delay_mat);

		fip.fix_eff_date_ 		= eff_date_out;
		fip.fix_first_cpn_date_ = first_cpn_date_out;
		fip.fix_last_reg_date_ 	= last_reg_cpn_date_out;
		fip.fix_roll_day_		= roll_day_out;
	}
	/*-----------------------------------------------------------------------
	  schedule_helper
	  ----------------------------------------------------------------------*/
	void legleg_parm.schedule_helper(out flt_parm fp)
	{
		integer pmt_delay 		= 0;
		integer pmt_delay_mat 	= 0;
		integer freq 			= coupon_freq_to_int(fp.flt_cpn_freq_);
		integer roll_day_out;
		date eff_date_out, first_cpn_date_out, last_reg_cpn_date_out;
		schedule_helper(start_date_, maturity_,freq, fp.flt_pmt_calendar_, fp.flt_pmt_bus_day_, fp.flt_pmt_bus_day_mat(),
						fp.flt_stub_type_, fp.flt_end_of_month_,
						fp.flt_eff_date_, fp.flt_first_cpn_date_, fp.flt_last_reg_date_,fp.flt_roll_day_,
						eff_date_out, first_cpn_date_out, last_reg_cpn_date_out,roll_day_out, pmt_delay,pmt_delay_mat);

		fp.flt_eff_date_ 		= eff_date_out;
		fp.flt_first_cpn_date_ 	= first_cpn_date_out;
		fp.flt_last_reg_date_ 	= last_reg_cpn_date_out;
		fp.flt_roll_day_		= roll_day_out;
	}
	/*-----------------------------------------------------------------------
	  schedule_helper
	  ----------------------------------------------------------------------*/
	void legleg_parm.schedule_helper(out ois_parm op)
	{
		integer pmt_delay 		= 0;
		integer pmt_delay_mat 	= 0;
		integer freq 			= coupon_freq_to_int(op.ois_cpn_freq_);
		integer roll_day_out;
		date eff_date_out, first_cpn_date_out, last_reg_cpn_date_out;
		schedule_helper(start_date_, maturity_,freq, op.ois_pmt_calendar_, op.ois_pmt_bus_day_, op.ois_pmt_bus_day_mat(), 
						op.ois_stub_type_, op.ois_end_of_month_,
						op.ois_eff_date_, op.ois_first_cpn_date_, op.ois_last_reg_date_,op.ois_roll_day_,
						eff_date_out, first_cpn_date_out, last_reg_cpn_date_out,roll_day_out, pmt_delay,pmt_delay_mat);

		op.ois_eff_date_ 		= eff_date_out;
		op.ois_first_cpn_date_ 	= first_cpn_date_out;
		op.ois_last_reg_date_ 	= last_reg_cpn_date_out;
		op.ois_roll_day_		= roll_day_out;
	}
	
	/*-----------------------------------------------------------------------
	  schedule_helper
	  ----------------------------------------------------------------------*/
	void legleg_parm.schedule_helper(	date 	option(nullable)		start_date,
										date 	option(nullable)		maturity,
										integer							freq,
										calendar option(nullable) 		cal,
										bd_convention option(nullable) 	bus_day,
										bd_convention option(nullable) 	bus_day_mat,
										stub_type 						stub,
										logical option(nullable) 		eom,
										date option(nullable) 			eff_date,
										date option(nullable) 			first_cpn_date,
										date option(nullable) 			last_reg_cpn_date,
										integer 						roll_day,
										out date 						eff_date_out,
										out date 						first_cpn_date_out,
										out date 						last_reg_cpn_date_out,
										out integer						roll_day_out,
										integer	    					pmt_delay,
										integer	    					pmt_delay_mat,
										integer	    					min_dflt_period)
	{		
		if(null(start_date))
			start_date = start_date_;
		QL_FAIL_COND(null(start_date),"invalid start date", E_INIT);
		
		if(null(maturity))
			maturity = maturity_;		
		QL_FAIL_COND(null(maturity),"invalid maturity", E_INIT);
		
		schedule_period_type first_type, last_type;
		
		CORE_INT_SWAPLIB.schedule_helper(	start_date, maturity, freq, roll_day,
											cal, bus_day, bus_day_mat, stub, eom,
											eff_date, first_cpn_date, last_reg_cpn_date,
											eff_date_out, first_cpn_date_out, last_reg_cpn_date_out,
											roll_day_out, first_type, last_type, pmt_delay,pmt_delay_mat,
											min_dflt_period);

		switch(stub){
		case stub_type.SHORT_FIRST:
		case stub_type.LONG_FIRST:
		case stub_type.SPECIFIC_FIRST:
			QL_REQUIRE(last_type == schedule_period_type.REGULAR || last_type == schedule_period_type.NONE ,"stub type inconsistent with input (last period not regular)", E_INIT);
			last_reg_cpn_date_out = null;
			break;
		case stub_type.SHORT_LAST:
		case stub_type.LONG_LAST:
		case stub_type.SPECIFIC_LAST:
			QL_REQUIRE(first_type == schedule_period_type.REGULAR || first_type == schedule_period_type.NONE ,"stub type inconsistent with input (first period not regular)", E_INIT);
			first_cpn_date_out = null;
			break;
		};
	}
	/*-----------------------------------------------------------------------
	  fx_rate_init
	  ----------------------------------------------------------------------*/
	void legleg_parm.fx_rate_init(string 		leg1_curr,
								 string 		leg2_curr,
								 string option(nullable) fx_quote_base_ccy,
								 string option(nullable) fx_quote_price_ccy,
								 logical option(nullable) pv_in_base_ccy,
								 number 		fx_quote,
								 out logical 	leg1_is_base_ccy,
								 out number 	leg1_fx_mult,
								 out number 	leg2_fx_mult)		
	{
		if(null(pv_in_base_ccy))
			pv_in_base_ccy = true;
		if(null(fx_quote_base_ccy)) {
			if(null(fx_quote_price_ccy)){
				fx_quote_base_ccy = leg2_curr;
				fx_quote_price_ccy = leg1_curr;
			}
			else {
				fx_quote_base_ccy = equal_casei(fx_quote_price_ccy,leg1_curr) ? leg2_curr : leg1_curr;
			}
		}
		else if(null(fx_quote_price_ccy)){
			fx_quote_price_ccy = equal_casei(fx_quote_base_ccy,leg1_curr) ? leg2_curr : leg1_curr;
		}
		
		CORE_INT_SWAPLIB.swap_lib_fx_handler_ccy(leg1_curr,leg2_curr,fx_quote_base_ccy,fx_quote_price_ccy,pv_in_base_ccy,
												 fx_quote,leg1_is_base_ccy,leg1_fx_mult,leg2_fx_mult);
	}
	/*-----------------------------------------------------------------------
	  create_swap_fix_def
	  ----------------------------------------------------------------------*/	
	ql_swap_fix_def legleg_parm.create_swap_fix_def(fix_parm fip,
													string name)
	{
		QL_REQUIRE(!null(spot_code_),"invalid spot settle code");
		return fip.create_swap_fix_def(name, date_code(spot_code_), ne_ );
	}
	/*-----------------------------------------------------------------------
	  create_swap_float_def
	  ----------------------------------------------------------------------*/	
	ql_swap_float_def legleg_parm.create_swap_float_def(flt_parm fp,
														string name)
	{
		QL_REQUIRE(!null(spot_code_),"invalid spot settle code");
		return fp.create_swap_float_def( name, date_code(spot_code_), ne_ );
	}
	/*-----------------------------------------------------------------------
	  create_swap_fix_leg
	  ----------------------------------------------------------------------*/
	ql_fix_leg legleg_parm.create_swap_fix_leg(	fix_parm 		fip,
												ql_swap_fix_def fix_def,
												string 			name,
												logical 		pay,
												disc_func 	option(nullable)	fix_disc_func )													
	{
		return fip.create_swap_fix_leg(fix_def,name,pay,fix_disc_func,trade_date_,settle_date_,
										start_date_, maturity_ , mat_code_/*,cpn_roll_day_*/);
	}
	/*-----------------------------------------------------------------------
	  create_swap_float_leg
	  ----------------------------------------------------------------------*/	
	ql_float_leg legleg_parm.create_swap_float_leg(	flt_parm 			fp,
													ql_swap_float_def 	flt_def,
													string 				name,
													logical 			pay,
													disc_func 	option(nullable)	flt_disc_func,
													tenor_surface option(nullable)	flt_tenor_surface)													
	{
		return fp.create_swap_float_leg(flt_def,name,pay,flt_disc_func,flt_tenor_surface,
										trade_date_,settle_date_,start_date_, maturity_ ,
										mat_code_/*,cpn_roll_day_*/);
	}

	
	/*-----------------------------------------------------------------------
	  create_swap_ois_def
	  ----------------------------------------------------------------------*/	
	ql_swap_ois_def legleg_parm.create_swap_ois_def(ois_parm op,
													string name)
	{
		QL_REQUIRE(!null(spot_code_),"invalid spot settle code");
		return op.create_swap_ois_def( name, date_code(spot_code_), ne_ );
	}
	/*-----------------------------------------------------------------------
	  create_swap_ois_leg
	  ----------------------------------------------------------------------*/
	ql_ois_leg legleg_parm.create_swap_ois_leg(ois_parm op,
											   ql_swap_ois_def 	ois_def,
											   string 			name,
											   logical 			pay,
											   disc_func option(nullable)		ois_disc_func,
											   tenor_surface option(nullable)	ois_tenor_surface)
	{
		return op.create_swap_ois_leg(ois_def,name,pay,ois_disc_func,ois_tenor_surface,
										trade_date_,settle_date_,start_date_, maturity_ ,
									  mat_code_/*,cpn_roll_day_*/);
	}
	
	
}