option(null: hard);	

/*	
	swaplib wrapper functions
	Developer: Algorithmica Research, Magnus Nyström

	--------------------------------------------------------------------
	 	swap help functions for create funcs
	--------------------------------------------------------------------			
*/
module CORE_SWAPLIB
{
	/*-----------------------------------------------------------------------
	 -----------------------------------------------------------------------
	 -----class fixflt_parm--------------------------------------------------
	 -----------------------------------------------------------------------
	 -----------------------------------------------------------------------*/
	class fixflt_parm : public legleg_parm
	{
	public:
		fixflt_parm();

		override instr_type	type() ;
		void 				start_date_helper( );		
		void 				fx_notional_helper();			
		//void 				maturity_helper();
		
		void				init_static(instr_def, string option(nullable) );
		void				init_static(INSTR_TMPL.swap_fixflt_def_tmpl);
		void				init_static(swap_fixflt , string option(nullable) );
		void				init_static(	string option(nullable) ,
											bd_convention  		pmt_bus_day,
											calendar 			pmt_cal,
											logical				end_of_month,
											notional_exchg_style option(nullable) ne,												
											//fix
											string				fix_ccy,
											integer 			fix_cpn_freq,
											day_count_method  	fix_day_count,
											interest_rule		fix_ir_rule,
											logical option(nullable) fix_avg_not,
											fix_roll_method option(nullable) fix_roll,
											logical option(nullable) fix_const_cpn,
											logical option(nullable) fix_comp_to_mat,
											//flt
											string				flt_ccy,
											integer 			flt_cpn_freq,
											integer 			flt_reset_freq,
											day_count_method 	flt_day_count,
											interest_rule		flt_ir_rule,
											ir_index 			flt_ir_index,
											
											flt_comp_avg_type option(nullable)		flt_comp_avg_t ,
											flt_sprd_comp_method option(nullable)	flt_sprd_comp_m,
											flt_avg_method 	option(nullable)		flt_avg_m,

											logical option(nullable) flt_avg_not,
											..flt_roll_method option(nullable)  flt_roll,
											logical option(nullable) flt_comp_to_mat,
											flt_stub_fwd_style option(nullable)  );
		
		void 				set_notional_fix(number);
		void 				set_notional_flt(number);
		void 				set_pv01(number);
		fix_parm			fix_leg_parm();
		flt_parm 			flt_leg_parm();

	protected:
		void 			check();
		//void 			__set_plain_vanilla();
		void 			__set_plain(bd_convention option(nullable),calendar option(nullable),logical	option(nullable) ,
									integer  , number option(nullable) , string	option(nullable),number option(nullable),
									day_count_method option(nullable), interest_rule	option(nullable) ,number option(nullable),
									number	option(nullable),  string	option(nullable),number option(nullable),day_count_method  option(nullable) ,
									interest_rule	option(nullable) ,ir_index option(nullable),flt_stub_fwd_style option(nullable) ,number option(nullable),
									number option(nullable),number option(nullable), number option(nullable) ,number option(nullable)  );

		swap_fixflt 	__create_swap(	disc_func option(nullable) ,disc_func option(nullable) ,
										vector(fwd_func) option(nullable),vector(disc_func) option(nullable),
										vector(tenor_code) option(nullable),logical option(nullable) allow_extrap );
		
	public:

		void 			set_plain_single_ccy(string 					name,
											date option(nullable) 		trade_date,
											date option(nullable) 		settle_date,
											
											date option(nullable) 		start_date,
											string option(nullable) 	fwd_start_code,
											date option(nullable) 		maturity,
											string option(nullable) 	maturity_code,
											logical 					pay_fixed,
											number	option(nullable) 	notional,
											number	option(nullable) 	fix_pv01,
											number option(nullable)		pv01_not_unit,
											//fix
											number	option(nullable)	fix_cpn_rate,
											integer 					imp_fix_rate_dec,
											//flt
											 number option(nullable) 	flt_spread,
											number option(nullable) 	flt_curr_fix,
											 number option(nullable) 	flt_start_stub_rate,
											number option(nullable) 	flt_end_stub_rate);
			
		void 			set_plain_single_ccy(	string 					name,											 
												date option(nullable) 	trade,
												date option(nullable) 	settle,
												string option(nullable) spot_settle_code,
												date option(nullable),
												string option(nullable) 	fwd_start_code,
												date option(nullable) 	mat,
												string option(nullable) mat_code,
												logical 				pay_fixed,
												bd_convention option(nullable) 	pmt_bus_day,
												calendar option(nullable)	pmt_cal,
												logical	option(nullable) 	end_of_month,
												string	option(nullable) 	ccy,
												integer 					imp_fix_rate_dec,
												number option(nullable)		pv01_not_unit,
												number	option(nullable) 	notional,
												number	option(nullable) 	pv01,
												number option(nullable)		fix_cpn_freq,
												day_count_method option(nullable)	fix_day_count,
												interest_rule	option(nullable) ,
												number	option(nullable)	fix_cpn_rate,												
												number option(nullable)		flt_cpn_freq,
												day_count_method  option(nullable)	flt_day_count,
												interest_rule	option(nullable) ,
												ir_index option(nullable)	flt_ir_index,
												flt_stub_fwd_style option(nullable)  ,
												number option(nullable) 	flt_spread,
												number option(nullable) 	flt_curr_fix,
												number option(nullable) 	flt_start_stub_rate,
												number option(nullable) 	flt_end_stub_rate);
	
		void			set_plain(	string 							name,								  
									date option(nullable)			trade,
									date option(nullable) 			settle,
									string option(nullable) 		spot_settle_code,
									date option(nullable),
									string option(nullable) 		fwd_start_code,
									date option(nullable) 			mat,
									string option(nullable) 		mat_code,
									logical 						pay_fixed,
									bd_convention option(nullable)	pmt_bus_day,
									calendar option(nullable)		pmt_cal,
									logical	 option(nullable)		end_of_month,
									notional_exchg_style option(nullable),
									integer 						imp_fix_rate_dec,
									number 	option(nullable) 		pv01_not_unit,
									number 		option(nullable) 	fx_quote,
									string 		option(nullable) 	fx_quote_baseccy,
									string 		option(nullable) 	fx_quote_priceccy,
									logical 	option(nullable) 	pv_in_base_ccy,
									//fix
									string	 option(nullable) 	,
									number	option(nullable)	fix_cpn_freq,
									day_count_method option(nullable) fix_day_count,
									interest_rule option(nullable) fix_ir_rule,
									number	option(nullable)	fix_cpn_rate,
									stub_type option(nullable)	fix_stub_type,
									date option(nullable)  		fix_eff_date,
									date option(nullable)  		fix_first_cpn_date,
									date option(nullable)  		fix_last_reg_date,
									number	option(nullable),
									number	option(nullable) ,									
									//flt
									string	 option(nullable) 	,
									number option(nullable)	 		flt_cpn_freq,
									day_count_method  option(nullable)	flt_day_count,
									interest_rule option(nullable)	flt_ir_rule,
									ir_index option(nullable)		flt_ir_index,
									flt_stub_fwd_style option(nullable)  ,
									number option(nullable) 		flt_spread,
									stub_type option(nullable)		flt_stub_type,
									date option(nullable)  			flt_eff_date,
									date option(nullable)  			flt_first_cpn_date,
									date option(nullable)  			flt_last_reg_date,
									number	option(nullable),									
									number option(nullable) 		flt_curr_fix,
									vector(date) option(nullable) 	flt_fixing_dates ,	
									vector(number) option(nullable) flt_fixing_rates,
									number option(nullable) 		flt_fix_proxy ,
									logical option(nullable) 		flt_allow_fwd_fix,
									number option(nullable) 		flt_start_stub_rate,
									number option(nullable) 		flt_end_stub_rate);
		void			set_plain(	//common
								string 							name,								
								date option(nullable)			trade_date,
								date option(nullable) 			settle_date,
								
								date option(nullable) 			start_date,
								string option(nullable) 		fwd_start_code,
								date option(nullable) 			maturity,
								string option(nullable) 		maturity_code,
								logical 						pay_fixed,						
								integer 						imp_fix_rate_dec,
								number option(nullable) 		pv01_not_unit,																		
								number 		option(nullable) 	fx_quote,
								string 		option(nullable) 	fx_quote_baseccy,
								string 		option(nullable) 	fx_quote_priceccy,
								logical 	option(nullable) 	pv_in_base_ccy,
								//fix
								number	option(nullable)		fix_cpn_rate,
								stub_type option(nullable)		fix_stub_type,
								date option(nullable)  			fix_eff_date,
								date option(nullable)  			fix_first_cpn_date,
								date option(nullable)  			fix_last_reg_date,
								number	option(nullable) 		fix_notional,
								number	option(nullable) 		fix_pv01,
								//flt
								number option(nullable) 		flt_spread,
								stub_type option(nullable)		flt_stub_type,
								date option(nullable)  			flt_eff_date,
								date option(nullable)  			flt_first_cpn_date,
								date option(nullable)  			flt_last_reg_date,
								number	option(nullable) 		flt_notional,
								number option(nullable) 		flt_curr_fix,
								vector(date) option(nullable) 	flt_fixing_dates ,	
								vector(number) option(nullable) flt_fixing_rates,
								number option(nullable) 		flt_fix_proxy ,
								logical option(nullable) 		flt_allow_fwd_fix,
								number option(nullable) 		flt_start_stub_rate,
								number option(nullable) 		flt_end_stub_rate);
		
		void			set_plain_amort_single_curr(string 							name,												
													date option(nullable)			trade_date,
													date option(nullable) 			settle_date,
													string option(nullable) 		spot_settle_code,
													date option(nullable) 			start_date,
													string option(nullable) 		fwd_start_code,
													date option(nullable) 			maturity,
													string option(nullable) 		maturity_code,
													 logical 						pay_fixed,
													bd_convention option(nullable)	pmt_bus_day,
													calendar option(nullable)		pmt_cal,
													logical	 option(nullable)		end_of_month,
													notional_exchg_style option(nullable) notional_exchg,											
													string	 						ccy,
													integer 						imp_fix_rate_dec,
													//number option(nullable) pv01_not_unit,
													number	 						notional,	
													number	option(nullable)		fix_cpn_freq_n,
													day_count_method option(nullable) fix_day_count,
													interest_rule option(nullable) 	fix_ir_rule ,
													number	option(nullable)		fix_cpn_rate,
													stub_type option(nullable)		fix_stub_type,
													date option(nullable)  			fix_eff_date,
													date option(nullable)  			fix_first_cpn_date,
													date option(nullable)  			fix_last_reg_date,
													sink_fund_style option(nullable)  	fix_sink_fund_style,
													vector(date)  option(nullable)  	fix_sink_fund_dates,
													vector(number)  option(nullable)  	fix_sink_fund,	
													number option(nullable)	 		flt_cpn_freq_n,
													day_count_method  option(nullable) flt_day_count,
													interest_rule option(nullable) 	flt_ir_rule ,
													ir_index option(nullable)		flt_ir_index,
													flt_stub_fwd_style option(nullable)  ,
													number option(nullable) 		flt_spread,
													stub_type option(nullable)		flt_stub_type,
													date option(nullable)  			flt_eff_date,
													date option(nullable)  			flt_first_cpn_date,
													date option(nullable)  			flt_last_reg_date,
													sink_fund_style option(nullable) flt_sink_fund_style ,
													vector(date) option(nullable) 	flt_sink_fund_dates ,
													vector(number) option(nullable) flt_sink_fund ,											
													number option(nullable) 		flt_curr_fix,
													vector(date) option(nullable) 	flt_fixing_dates ,	
													vector(number) option(nullable) flt_fixing_rates,
													number option(nullable) 		flt_fix_proxy ,
													logical option(nullable) 		flt_allow_fwd_fix,
													number option(nullable) 		flt_start_stub_rate,
													number option(nullable) 		flt_end_stub_rate);

		void			set_plain_amort_single_curr( string 						name,
													date option(nullable)			trade_date,
													date option(nullable) 			settle_date,
													
													date option(nullable) 			start_date,
													 string option(nullable) 		fwd_start_code,
													date option(nullable) 			maturity,
													string option(nullable) 		maturity_code,
													logical 						pay_fixed,	
													integer 						imp_fix_rate_dec,
													//number 	option(nullable) 		pv01_not_unit,
													number	 						notional,
													//fix												
													number	option(nullable)		fix_cpn_rate,
													stub_type option(nullable)		fix_stub_type,
													date option(nullable)  			fix_eff_date,
													date option(nullable)  			fix_first_cpn_date,
													date option(nullable)  			fix_last_reg_date,
													sink_fund_style option(nullable)  	fix_sink_fund_style,
													vector(date)  option(nullable)  	fix_sink_fund_dates,
													vector(number)  option(nullable)  	fix_sink_fund,
													number option(nullable) 		flt_spread,
													stub_type option(nullable)		flt_stub_type,
													date option(nullable)  			flt_eff_date,
													date option(nullable)  			flt_first_cpn_date,
													date option(nullable)  			flt_last_reg_date,
													sink_fund_style option(nullable) flt_sink_fund_style ,
													vector(date) option(nullable) 	flt_sink_fund_dates ,
													vector(number) option(nullable) flt_sink_fund ,
													number option(nullable) 		flt_curr_fix,
													vector(date) option(nullable) 	flt_fixing_dates ,	
													vector(number) option(nullable) flt_fixing_rates,
													number option(nullable) 		flt_fix_proxy ,
													logical option(nullable) 		flt_allow_fwd_fix,
													number option(nullable) 		flt_start_stub_rate,
													number option(nullable) 		flt_end_stub_rate);
		
		swap_fixflt 	create_swap(disc_func option(nullable) fix_disc_func,
									disc_func option(nullable) flt_disc_func,
									fwd_func option(nullable), logical option(nullable) allow_extrap = null );

		swap_fixflt 	create_swap(disc_func option(nullable) fix_disc_func,
									disc_func option(nullable) flt_disc_func,
									disc_func option(nullable) , logical option(nullable) allow_extrap = null);

		swap_fixflt 	create_swap(disc_func option(nullable) fix_disc_func,
									disc_func option(nullable) flt_disc_func,
									vector(fwd_func) option(nullable) ,vector(tenor_code) option(nullable),
									logical option(nullable) allow_extrap = null);

		swap_fixflt 	create_swap(disc_func option(nullable) fix_disc_func,
									disc_func option(nullable) flt_disc_func,
									vector(disc_func) option(nullable),vector(tenor_code) option(nullable) ,
									logical option(nullable) allow_extrap = null);
		
		
		fix_parm 	fip_;
		flt_parm	fp_;
	};

	/*-----------------------------------------------------------------------
	  constructor
	  ----------------------------------------------------------------------*/
	fixflt_parm.fixflt_parm()
	{
		fip_ 			= new fix_parm();
		fp_ 			= new flt_parm();
	}
	/*-----------------------------------------------------------------------
	  type
	  ----------------------------------------------------------------------*/
	instr_type fixflt_parm.type() { return instr_type.SWAP_FIXFLT;}
	/*-----------------------------------------------------------------------
	  fix_leg_parm / flt_leg_parm
	  ----------------------------------------------------------------------*/
	fix_parm fixflt_parm.fix_leg_parm() { return fip_;}
	flt_parm fixflt_parm.flt_leg_parm() { return fp_;}

	/*-----------------------------------------------------------------------
	  check
	  ----------------------------------------------------------------------*/
	void fixflt_parm.check()
	{
		if(is_aged_swap()){
			QL_REQUIRE(!null(fip_.fix_coupon_rate_),"fix cpn rate required for aged swap");
			if(is_ccy_ ) {
				QL_REQUIRE(!null(fip_.fix_notional_) && !null(fp_.flt_notional_),"notionals are required for aged swap");
			}
			else {
				QL_REQUIRE(!null(fip_.fix_notional_) || !null(fp_.flt_notional_),"notional is required for aged swap");
			}
		}
	}
	/*-----------------------------------------------------------------------
	  fx_notional_helper
	  ----------------------------------------------------------------------*/
	void fixflt_parm.fx_notional_helper()
	{
		legleg_parm.fx_notional_helper(fip_.fix_notional_, fp_.flt_notional_, fip_.fix_fx_mult_ , fp_.flt_fx_mult_);
	}
	/*-----------------------------------------------------------------------
	  start_date_helper
	  ----------------------------------------------------------------------*/	
	void fixflt_parm.start_date_helper()
	{
		legleg_parm.start_date_helper(fip_.fix_eff_date_, fp_.flt_eff_date_, fp_.flt_pmt_calendar_);
	}
		
	/*-----------------------------------------------------------------------
	  set_notional_fix
	  ----------------------------------------------------------------------*/
	void fixflt_parm.set_notional_fix(number not)
	{
		fip_.fix_notional_ 	= not;
		if(!is_ccy_)
			fp_.flt_notional_ = not;
		leg_pv01_ 			= null;
		fx_notional_helper();
	}
	/*-----------------------------------------------------------------------
	  set_notional_flt
	  ----------------------------------------------------------------------*/
	void fixflt_parm.set_notional_flt(number not)
	{
		fp_.flt_notional_ 	= not;
		if(!is_ccy_)
			fip_.fix_notional_ 	= not;
		leg_pv01_ 			= null;
		fx_notional_helper();
	}
	/*-----------------------------------------------------------------------
	  set_notional
	  ----------------------------------------------------------------------*/
	void fixflt_parm.set_pv01(number pv01)
	{
		fip_.fix_notional_ 	= 1000000;
		fp_.flt_notional_ 	= null;//if null it will be calculated in ccy_helper
		leg_pv01_ 			= pv01;
		fx_notional_helper();
	}

	/*-----------------------------------------------------------------------
	  create_swap
	  ----------------------------------------------------------------------*/	
	swap_fixflt fixflt_parm.create_swap(disc_func option(nullable) 	fix_disc_func,
										disc_func option(nullable) 	flt_disc_func,
										disc_func option(nullable) 	flt_fwd_disc_func,
										logical option(nullable) allow_extrap)
	{
		return __create_swap(  fix_disc_func, flt_disc_func, null,[flt_fwd_disc_func], null,allow_extrap);
	}
	/*-----------------------------------------------------------------------
	  create_swap
	  ----------------------------------------------------------------------*/	
	swap_fixflt fixflt_parm.create_swap(disc_func option(nullable) 	fix_disc_func,
										disc_func option(nullable) 	flt_disc_func,
										fwd_func option(nullable) 	flt_fwd_func,
										logical option(nullable) allow_extrap)
	{
		return __create_swap( fix_disc_func, flt_disc_func, [flt_fwd_func],null, null,allow_extrap);
	}
	/*-----------------------------------------------------------------------
	  create_swap
	  ----------------------------------------------------------------------*/	
	swap_fixflt fixflt_parm.create_swap(disc_func option(nullable) 	fix_disc_func,
										disc_func option(nullable) 	flt_disc_func,
										vector(disc_func) option(nullable) 	flt_fwd_disc_func,
										vector(tenor_code) option(nullable) flt_tenor_code,
										logical option(nullable) allow_extrap)
	{
		return __create_swap(  fix_disc_func, flt_disc_func, null,flt_fwd_disc_func,flt_tenor_code,allow_extrap);
	}
	/*-----------------------------------------------------------------------
	  create_swap
	  ----------------------------------------------------------------------*/	
	swap_fixflt fixflt_parm.create_swap(disc_func option(nullable) 	fix_disc_func,
										disc_func option(nullable) 	flt_disc_func,
										vector(fwd_func) option(nullable) 	flt_fwd_func,
										vector(tenor_code) option(nullable) flt_tenor_code,
										logical option(nullable) allow_extrap)
	{
		return __create_swap( fix_disc_func, flt_disc_func, flt_fwd_func,null,flt_tenor_code,allow_extrap);
	}
	/*-----------------------------------------------------------------------
	  __create_swap <protected>
	  ----------------------------------------------------------------------*/	
	swap_fixflt fixflt_parm.__create_swap(	disc_func option(nullable) fix_disc_func,
											disc_func option(nullable) flt_disc_func,
											vector(fwd_func) option(nullable) 	flt_fwd_func,
											vector(disc_func) option(nullable) 	flt_fwd_disc_func,
											vector(tenor_code) option(nullable) flt_tenor_code,
											logical option(nullable) allow_extrap)
	{
		//-----checks--------
		QL_FAIL_COND(!null(flt_fwd_func) && !null(flt_fwd_disc_func),"ambigious input (fwd_func/disc_func)");

		if(!is_ccy_ && !null(fix_disc_func) && !null(flt_disc_func))
			fix_disc_func = flt_disc_func;

		//-----defs--------
		ql_swap_fix_def fix_def 	= this.create_swap_fix_def(fip_,"fix_def");
		QL_FAIL_COND(null(fix_def),"error creating fixed leg def");
		ql_swap_float_def flt_def 	= this.create_swap_float_def(fp_,"flt_def");
		QL_FAIL_COND(null(flt_def),"error creating float leg def");

		//-----fix leg--------
		ql_fix_leg fix 				= this.create_swap_fix_leg(fip_,fix_def, "fix_leg",pay_leg1_, fix_disc_func);
		QL_FAIL_COND(null(fix),"error creating fix leg");

		//-----flt leg--------
		tenor_surface flt_ts;
		
			
		if(CORE_INT_SWAPLIB.vector_is_null(flt_fwd_func) && CORE_INT_SWAPLIB.vector_is_null(flt_fwd_disc_func)){
			flt_ts = null;
		}
		else if(!null(flt_fwd_func)){
			flt_ts = create_flt_surface(fp_, flt_disc_func,flt_fwd_func,null, flt_tenor_code, allow_extrap);
			QL_FAIL_COND(null(flt_ts),"error creating tenor surface");
		}
		else{
			flt_ts = create_flt_surface(fp_, flt_disc_func,null,flt_fwd_disc_func,flt_tenor_code,allow_extrap);
			QL_FAIL_COND(null(flt_ts),"error creating tenor surface");
		}

		ql_float_leg flt = this.create_swap_float_leg(fp_,flt_def, "float_leg",!pay_leg1_, flt_disc_func, flt_ts);
		QL_FAIL_COND(null(flt),"error creating float leg");

		//-----swap--------
		ql_fixed_income_swap sw 	= ql_fixed_income_swap(fix,flt,name_);
		QL_FAIL_COND(null(sw),"error creating swap");
		
		if(!null(fp_.flt_curr_fix_))
			sw.float_leg(false)[0].set_current_fixing(fp_.flt_curr_fix_);

		//----solve for rate if null-----
		if(null(fip_.fix_coupon_rate_)) {
			
			number fix_r	= sw.solver(0,swap_solver_code.SS_FIX_RATE_LEG1,false);
			QL_FAIL_COND(null(fix_r),"error calculating implied fixed coupon rate", E_INIT);

			if(imp_calc_dec_ >= 0)
				fix_r = round(fix_r,imp_calc_dec_);
				
			fip_.fix_coupon_rate_ = fix_r;
			//---recreate fix leg------
			fix 	= this.create_swap_fix_leg(fip_,fix_def, "fix_leg",pay_leg1_, fix_disc_func);
			QL_FAIL_COND(null(fix),"error creating fixed leg");
			//----recreate swap-------
			sw 		= ql_fixed_income_swap(fix,flt,name_);
			QL_FAIL_COND(null(sw),"error creating swap");

			if(!null(fp_.flt_curr_fix_))
				sw.float_leg(false)[0].set_current_fixing(fp_.flt_curr_fix_);
		}

		error_info ee 	= new error_info(true,true);
		swap_fixflt swff = swap_fixflt(sw, ee);

		//--calc notional if pv01 input---
		if(!null(leg_pv01_)) {
			
			number pv01_1m 	= swff.pv01(1000000,null,null,ee);//keep 1000000 as notional because this is the default notional when notional is not input (not really necessary) 
			number fix_not 	= abs(leg_pv01_)/pv01_1m*1000000;

			if(pv01_not_unit_>0){
				number a = fix_not/pv01_not_unit_;
				a = round(a,0);
				fix_not = a * pv01_not_unit_;
			}
			//update parm with new notional
			fip_.fix_notional_ = fix_not;
			fp_.flt_notional_ = null;
			fx_notional_helper();

			//update the newly created swap with new notional
			if(swff.is_cross_currency(ee)){
				swff.add_notional(fip_.fix_notional_,fp_.flt_notional_);				
			}
			else {
				swff.add_notional(fix_not);
			}
		}
		return swff;
	}

	/*-----------------------------------------------------------------------
	  init_basic_static
	  Note: a possible maturity code in the template is never "carried over" to the swap
	  Note to self: tmpl --> def --> ql_fixed_income_swap --> swap_fixflt (and the def is lost in the process since it is only part of the translation)
					(a direct route without the def is possible but not sure if it will save much compute time)
	  ----------------------------------------------------------------------*/
	void fixflt_parm.init_static(INSTR_TMPL.swap_fixflt_def_tmpl tmpl )
	{
		//----fixflt_parm-----		
		is_ccy_ 		= tmpl.is_cross_curr();		
		ne_ 			= tmpl.not_exchange();
		if(null(ne_))
			ne_ 	= is_ccy_ ? NE_BOTH : NE_NONE;

		
		spot_code_ 		= tmpl.spot_settle_code();
		trade_date_ 	= null;
		maturity_ 		= null;
		maturity_code_ 	= tmpl.maturity_code();
		mat_code_ 		= null;
		fwd_start_code_ = tmpl.fwd_start_code();
		start_date_ 	= null;
		settle_date_	= null;
		//cpn_roll_day_ 	= 0;

		
		//---fix---
		fix_roll_method	roll 		= null;
		logical const_cpn 			= null;		
		..fix_comp_freq comp_freq 	= null;
		logical compound_to_mat		= null;
		logical  avg_not 			= null;
		fip_.init_static(	tmpl.fix_bd_convention(), tmpl.fix_calendar(),tmpl.fix_eom(),
							tmpl.fix_currency(), tmpl.fix_cpn_freq(), tmpl.fix_day_count_method(),
							tmpl.fix_ir_rule(), 0,0,0,0,avg_not, roll, const_cpn, comp_freq, compound_to_mat);

		//---flt---
		..flt_roll_method	flt_roll 	= null;
		logical flt_compound_to_mat 	= null;
		fp_.init_static(tmpl.flt_bd_convention(),tmpl.flt_calendar(),tmpl.flt_eom(),tmpl.flt_currency(),
						tmpl.flt_cpn_freq(), tmpl.flt_reset_freq(),
						tmpl.flt_day_count_method(),tmpl.flt_ir_rule(),tmpl.flt_ir_index(),
						0,0,0,0,
						tmpl.flt_comp_avg(), tmpl.flt_spread_comp_method(), tmpl.flt_avg_method(),
						avg_not,flt_roll ,flt_compound_to_mat, tmpl.flt_fwd_stub_rate_style());
	}
	/*-----------------------------------------------------------------------
	  init_basic_static
	  ----------------------------------------------------------------------*/
	void fixflt_parm.init_static(instr_def  def,
								 string option(nullable) spot_code)
	{
		QL_REQUIRE(CORE_INT.check_instr_def(def),"invalid instr_def");
		QL_FAIL_COND(!def.is_swap_fixflt(), "instr_def not a fix-float swap", E_INIT);

		//----fixflt_parm-----		
		is_ccy_ 		= def.is_ccy_swap();			
		error_info ees 	= new error_info(true,false);
		ne_ 			= def.swap_not_exchange(ees);
		if(null(ne_))
			ne_ 	= is_ccy_ ? NE_BOTH : NE_NONE;

		spot_code_ 		= null(spot_code) ? "BD2": spot_code;
		trade_date_ 	= null;
		maturity_ 		= null;
		maturity_code_ 	= def.maturity_code(ees);
		mat_code_ 		= null;
		fwd_start_code_ = null;
		start_date_ 	= null;
		settle_date_	= null;
		//cpn_roll_day_ 	= 0;

		//---fix---
		fip_.init_static(def);
		//---flt---
		fp_.init_basic_static_leg2(def);
	}
	
	/*-----------------------------------------------------------------------
	  init_basic_static
	  ----------------------------------------------------------------------*/	
	void fixflt_parm.init_static(swap_fixflt sw_base,
								 string  option(nullable) spot_code)	//ext swap i.e. instr_def = null											
	{
		//----fixflt_parm-----
		error_info ee 	= new error_info(true,true);
		is_ccy_ 		= sw_base.is_ccy_swap();			
		ne_ 			= sw_base.notional_exchg_style_fix_leg(ee);		//assume both legs are same
		spot_code_ 		= null(spot_code) ? "BD2": spot_code;
		trade_date_ 	= null;
		maturity_ 		= null;
		maturity_code_ 	= null;
		mat_code_ 		= null;
		fwd_start_code_ = null;
		start_date_ 	= null;
		settle_date_	= null;
		//cpn_roll_day_ 	= 0;
		
		//---fix---
		fix_roll_method	roll 		= null;
		logical const_cpn 			= null;		
		..fix_comp_freq comp_freq 	= null;
		logical compound_to_mat		= null;
		logical  avg_not 			= null;
		integer cfreq_fix 			= sw_base.coupon_freq_fix_leg(ee);
		fip_.init_static(	sw_base.pmt_bus_day_fix_leg(ee), sw_base.calendar_fix_leg(ee),sw_base.eom_fix_leg(ee),
							sw_base.currency_fix_leg(ee), cfreq_fix, sw_base.dc_method_fix_leg(ee),
							sw_base.ir_rule_fix_leg(ee),0,0,0,0,avg_not, roll, const_cpn, comp_freq, compound_to_mat);

		//---flt---		
		flt_comp_avg_type comp_avg_type 		= sw_base.comp_avg_type_flt_leg(ee);//OBS n/a for ext swap
		flt_sprd_comp_method  sprd_comp_method 	= sw_base.sprd_comp_method_flt_leg(ee);//OBS n/a for ext swap
		flt_avg_method avg_method 				= sw_base.avg_method_flt_leg(ee);//OBS n/a for ext swap		
		..flt_roll_method	flt_roll 			= null;
		logical flt_compound_to_mat 			= null;
		flt_stub_fwd_style stub_rate_style 		= sw_base.stub_fwd_style_flt_leg(ee);
		
		integer cfreq_flt = sw_base.coupon_freq_flt_leg(ee);
		fp_.init_static(sw_base.pmt_bus_day_flt_leg(ee),sw_base.calendar_flt_leg(ee),sw_base.eom_flt_leg(ee),sw_base.currency_flt_leg(ee),
									cfreq_flt, sw_base.reset_freq_flt_leg(ee),
									sw_base.dc_method_flt_leg(ee),sw_base.ir_rule_flt_leg(ee),sw_base.ir_index_flt_leg(ee),
									0,0,0,0,
									comp_avg_type, sprd_comp_method, avg_method,avg_not,flt_roll,flt_compound_to_mat,stub_rate_style);
	}
	/*-----------------------------------------------------------------------
	  set_static_data  
	  ----------------------------------------------------------------------*/
	void fixflt_parm.init_static( 	string  option(nullable) spot_code,
									bd_convention  		pmt_bus_day,
									calendar 			pmt_cal,
									logical				end_of_month,
									notional_exchg_style option(nullable) ne,
									
									//fix
									string				fix_ccy,
									integer 			fix_cpn_freq,
									day_count_method  	fix_day_count,
									interest_rule		fix_ir_rule,
									logical option(nullable) fix_avg_not,
									fix_roll_method option(nullable) fix_roll,
									logical option(nullable) fix_const_cpn,
									logical option(nullable) fix_comp_to_mat,
									//flt
									string				flt_ccy,
									integer 			flt_cpn_freq,
									integer 			flt_reset_freq,
									day_count_method 	flt_day_count,
									interest_rule		flt_ir_rule,
									ir_index 			flt_ir_index,
									
									flt_comp_avg_type option(nullable)		flt_comp_avg_t ,
									flt_sprd_comp_method option(nullable)	flt_sprd_comp_m,
									flt_avg_method 	option(nullable)		flt_avg_m,

									logical option(nullable) flt_avg_not,
									..flt_roll_method option(nullable)  flt_roll,
									logical option(nullable) flt_comp_to_mat,
									flt_stub_fwd_style option(nullable)  flt_stub_rate_style )
	{
		//----fixflt_parm-----		
		is_ccy_ 		= !equal_casei(fix_ccy, flt_ccy);	
		ne_ 			= ne;
		if(null(ne_))
			ne_ = is_ccy_ ? NE_BOTH : NE_NONE;

		spot_code_ 		= null(spot_code) ? "BD2": spot_code;
		trade_date_ 	= null;
		maturity_ 		= null;
		maturity_code_ 	= null;
		mat_code_ 		= null;
		fwd_start_code_ = null;
		start_date_ 	= null;
		settle_date_	= null;
		//cpn_roll_day_ 	= 0;
		
		//---fix---	
		..fix_comp_freq comp_freq 	= null;
		fip_.init_static(	pmt_bus_day, pmt_cal,end_of_month,fix_ccy,
							fix_cpn_freq, fix_day_count,fix_ir_rule,0,0,0,0, fix_avg_not,
							fix_roll, fix_const_cpn, comp_freq, fix_comp_to_mat);

		//---flt---
		fp_.init_static(	pmt_bus_day,pmt_cal,end_of_month,flt_ccy,
							flt_cpn_freq, flt_reset_freq,flt_day_count,flt_ir_rule,flt_ir_index,
							0,0,0,0,flt_comp_avg_t, flt_sprd_comp_m, flt_avg_m,flt_avg_not,flt_roll,
							flt_comp_to_mat,flt_stub_rate_style);
	}
	
	/*-----------------------------------------------------------------------
	  __set_plain_vanilla  protected
	  ----------------------------------------------------------------------*/
	/*void fixflt_parm.__set_plain_vanilla()
	{
		
		// ----fixflt_parm-------
		//will not set:
		//	is_ccy;
		//	ne;
		//	settle_code;			

		//	trade_date;
		//	maturity;
		//	maturity_code;
		//	mat_code;
		//	fwd_start_code;
		//	start_date;
		//	settle_date
		
		cpn_roll_day_ = 0;
		
		// ----fix_parm-------
		fip_.set_plain_vanilla();
		
		// ----flt parm-------
		fp_.set_plain_vanilla();

	}*/
	/*-----------------------------------------------------------------------
	  __set_plain  <protected>    
	  ----------------------------------------------------------------------*/
	void fixflt_parm.__set_plain(	bd_convention option(nullable) 	pmt_bus_day,
									calendar option(nullable)	pmt_cal,
									logical	option(nullable) 	end_of_month,
									
									integer 					imp_fix_rate_dec,
									number option(nullable)		pv01_not_unit,
									//fix
									string	option(nullable) 	fix_ccy,
									number option(nullable)		fix_cpn_freq_n,
									day_count_method option(nullable) fix_day_count,
									interest_rule	option(nullable) fix_ir_rule,
									number	option(nullable)	fix_notional,
									number	option(nullable)	fix_cpn_rate,
									
									//flt
									string	option(nullable) 	flt_ccy,
									number option(nullable)		flt_cpn_freq_n,
									day_count_method  option(nullable) flt_day_count,
									interest_rule	option(nullable) flt_ir_rule,
									ir_index option(nullable)	flt_ir_index,
									flt_stub_fwd_style option(nullable)  flt_stub_rate_style,
									number	option(nullable)	flt_notional,
									number option(nullable) 	flt_spread,
									number option(nullable) 	flt_curr_fix,
									number option(nullable) 	flt_start_stub_rate,
									number option(nullable) 	flt_end_stub_rate)
	{
		/*init_static(...) cannot be run here because arguments are non-nullable*/
		
		imp_calc_dec_  	= imp_fix_rate_dec;//rounding decimals of the implied cpn rate (on decimal value)
		pv01_not_unit_  = null(pv01_not_unit) ? -1: pv01_not_unit;//rounding unit for notional when implied from pv01

		if(null(fix_ccy))
			fix_ccy = fip_.fix_ccy_;

		if(null(flt_ccy))
			flt_ccy = fp_.flt_ccy_;
		
		is_ccy_  = !equal_casei(fix_ccy, flt_ccy);
	
		//fix
		fip_.set_plain(pmt_bus_day, pmt_cal, end_of_month, fix_ccy, fix_cpn_freq_n,
					   fix_day_count, fix_ir_rule,0,0,0,0,fix_cpn_rate, stub_type.SHORT_FIRST,
					   null,null,null,fix_notional,null);

		//flt		
		number flt_reset_freq_n = flt_cpn_freq_n;
		
		fp_.set_plain(pmt_bus_day, pmt_cal, end_of_month, flt_ccy, flt_cpn_freq_n, flt_reset_freq_n,flt_day_count,
					  flt_ir_rule,flt_ir_index,0,0,0,0,flt_stub_rate_style,flt_spread,stub_type.SHORT_FIRST,
					  null,null,null,flt_notional,null,flt_curr_fix,null,null,null,false,
					  flt_start_stub_rate, flt_end_stub_rate);
	}

	/*-----------------------------------------------------------------------
	  set_plain_single_ccy
	  ----------------------------------------------------------------------*/
	void fixflt_parm.set_plain_single_ccy(	//common
											string 						name,
											date option(nullable) 		trade_date,
											date option(nullable) 		settle_date,											
											date option(nullable) 		start_date,
											string option(nullable) 	fwd_start_code,
											date option(nullable) 		maturity,
											string option(nullable) 	maturity_code,
											logical 					pay_fixed,
											number	option(nullable) 	notional,
											number	option(nullable) 	fix_pv01,
											number option(nullable)		pv01_not_unit,
											//fix
											number	option(nullable)	fix_cpn_rate,
											integer 					imp_fix_rate_dec,
											//flt
											number option(nullable) 	flt_spread,
											number option(nullable) 	flt_curr_fix,
											 number option(nullable) 	flt_start_stub_rate,
											number option(nullable) 	flt_end_stub_rate)
	{
		QL_FAIL_COND(null(is_ccy_),"fixflt_parm is not initalized (init_static() must be run) ");
		QL_REQUIRE(!is_ccy_,"function not applicable to cross currency swaps");
		
		if(null(notional))
			QL_REQUIRE(!null(fix_pv01),"one of notional and pv01 must be input");
		else if(null(fix_pv01))
			QL_REQUIRE(!null(notional),"one of notional and pv01 must be input");
		else if(!null(notional) && !null(fix_pv01))
			QL_FAIL("ambigious input of notional and pv01");

		this.__set_plain(	null,null,null,imp_fix_rate_dec,pv01_not_unit, null,null,null,null,notional,fix_cpn_rate,
							null,null,null,null,null,null,notional,flt_spread,flt_curr_fix,flt_start_stub_rate,flt_end_stub_rate);

		//-----common--------
		name_			= name;
		pay_leg1_ 		= pay_fixed;		
		
		trade_date_ 	= trade_date;
		fwd_start_code_ = fwd_start_code;
		start_date_ 	= start_date;
		maturity_ 		= maturity;
		if(!null(maturity_code))
			maturity_code_ 	= maturity_code;
		settle_date_	= settle_date;
		//cpn_roll_day_ 	= 0;

		this.start_date_helper();
		this.maturity_helper(fip_);
		this.check();
		//if single ccy set_pv01/set_notional will also set the other notional as well as both fxrates to 1
		if(null(notional))
			this.set_pv01(fix_pv01);
		else
			this.set_notional_fix(notional);
		
		ne_ = notional_exchg_style.NE_NONE;

		is_inited_ = true;
	}
	/*-----------------------------------------------------------------------
	  set_plain_single_ccy <ALL ARGS>
	  ----------------------------------------------------------------------*/
	void fixflt_parm.set_plain_single_ccy(	//common
											string 						name,											
											date option(nullable)		trade_date,
											date option(nullable) 		settle_date,
											string option(nullable) 	spot_settle_code,
											date option(nullable) 		start_date,
											string option(nullable) 	fwd_start_code,
											date option(nullable) 		maturity,
											string option(nullable) 	maturity_code,
											logical 					pay_fixed,
											bd_convention option(nullable) 	pmt_bus_day,
											calendar option(nullable)	pmt_cal,
											logical	option(nullable) 	end_of_month,
											string	option(nullable) 	ccy,
											integer 					imp_fix_rate_dec,
											 number option(nullable)	pv01_not_unit,
											number	option(nullable) 	notional,
											number	option(nullable) 	fix_pv01,
											//fix
											number option(nullable)		fix_cpn_freq_n,
											day_count_method option(nullable) fix_day_count,
											interest_rule	option(nullable) fix_ir_rule,
											number	option(nullable)	fix_cpn_rate,
											//flt													
											number option(nullable)		flt_cpn_freq_n,
											day_count_method  option(nullable) flt_day_count,
											interest_rule	option(nullable) flt_ir_rule,
											ir_index option(nullable)	flt_ir_index,
											flt_stub_fwd_style option(nullable)  flt_stub_rate_style,
											number option(nullable) 	flt_spread,
											number option(nullable) 	flt_curr_fix,
											number option(nullable) 	flt_start_stub_rate,
											number option(nullable) 	flt_end_stub_rate)
	{
		if(null(notional))
			QL_REQUIRE(!null(fix_pv01),"one of notional and pv01 must be input");
		else if(null(fix_pv01))
			QL_REQUIRE(!null(notional),"one of notional and pv01 must be input");
		else if(!null(notional) && !null(fix_pv01))
			QL_FAIL("ambigious input of notional and pv01");
		
		this.__set_plain(pmt_bus_day,pmt_cal,end_of_month,imp_fix_rate_dec,pv01_not_unit,
									//fix
									ccy,
									fix_cpn_freq_n,fix_day_count, fix_ir_rule, notional,fix_cpn_rate,
									//flt
									ccy,
									flt_cpn_freq_n,flt_day_count, flt_ir_rule,flt_ir_index, flt_stub_rate_style,
									notional,flt_spread,flt_curr_fix,flt_start_stub_rate,flt_end_stub_rate);

		//-----common--------
		name_			= name;
		pay_leg1_ 		= pay_fixed;
		is_ccy_ 		= false;
		if(!null(spot_settle_code))
			spot_code_ 	= spot_settle_code;
		trade_date_ 	= trade_date;
		fwd_start_code_ = fwd_start_code;
		start_date_ 	= start_date;
		maturity_ 		= maturity;
		if(!null(maturity_code))
			maturity_code_ 	= maturity_code;
		settle_date_	= settle_date;
		//cpn_roll_day_ 	= 0;

		this.start_date_helper();
		this.maturity_helper(fip_);
		this.check();
		//if single ccy set_pv01/set_notional will also set the other notional as well as both fxrates to 1
		if(null(notional))
			this.set_pv01(fix_pv01);
		else
			this.set_notional_fix(notional);
		
		ne_ = notional_exchg_style.NE_NONE;

		is_inited_ = true;
	}
	
	/*-----------------------------------------------------------------------
	  set_plain
	  ----------------------------------------------------------------------*/
	void fixflt_parm.set_plain(	//common
								string 							name,								
								date option(nullable)			trade_date,
								date option(nullable) 			settle_date,
								
								date option(nullable) 			start_date,
								string option(nullable) 		fwd_start_code,
								date option(nullable) 			maturity,
								string option(nullable) 		maturity_code,
								logical 						pay_fixed,						
								integer 						imp_fix_rate_dec,
								number option(nullable) 		pv01_not_unit,																		
								number 		option(nullable) 	fx_quote,
								string 		option(nullable) 	fx_quote_baseccy,
								string 		option(nullable) 	fx_quote_priceccy,
								logical 	option(nullable) 	pv_in_base_ccy,
								//fix
								number	option(nullable)		fix_cpn_rate,
								stub_type option(nullable)		fix_stub_type,
								date option(nullable)  			fix_eff_date,
								date option(nullable)  			fix_first_cpn_date,
								date option(nullable)  			fix_last_reg_date,
								number	option(nullable) 		fix_notional,
								number	option(nullable) 		fix_pv01,
								//flt
								number option(nullable) 		flt_spread,
								stub_type option(nullable)		flt_stub_type,
								date option(nullable)  			flt_eff_date,
								date option(nullable)  			flt_first_cpn_date,
								date option(nullable)  			flt_last_reg_date,
								number	option(nullable) 		flt_notional,
								number option(nullable) 		flt_curr_fix,
								vector(date) option(nullable) 	flt_fixing_dates ,	
								vector(number) option(nullable) flt_fixing_rates,
								number option(nullable) 		flt_fix_proxy ,
								logical option(nullable) 		flt_allow_fwd_fix,
								number option(nullable) 		flt_start_stub_rate,
								number option(nullable) 		flt_end_stub_rate)
	{
		QL_FAIL_COND(null(is_ccy_),"fixflt_parm is not initalized (init_static() must be run) ");
		
		if(null(fix_notional) && null(flt_notional))
			QL_REQUIRE(!null(fix_pv01),"one of notionals and fix_pv01 must be input");
		else if(null(fix_pv01))
			QL_REQUIRE(!null(fix_notional) || !null(flt_notional),"one of notionals and fix_pv01 must be input");
		else if(!null(fix_notional) && !null(flt_notional) && !null(fix_pv01))
			QL_FAIL("ambigious input of notionals and fix_pv01");

		number 	fix_fx_mult, flt_fx_mult;
		set_fx_input(fip_.fix_ccy_,fp_.flt_ccy_, fx_quote, fx_quote_baseccy, fx_quote_priceccy, pv_in_base_ccy, fix_notional,flt_notional,fix_fx_mult, flt_fx_mult);
					
		//----fix_parm-----
		fip_.set_plain(	null, null, null, null, null, null, null ,0,0,0,0, fix_cpn_rate, fix_stub_type,
						fix_eff_date, fix_first_cpn_date, fix_last_reg_date, fix_notional, fix_fx_mult);		
		
		//----flt_parm--------
		
		fp_.set_plain(	null, null, null, null, null, null,null,null , null, 
						0,0,0,0,null,flt_spread, flt_stub_type,flt_eff_date, flt_first_cpn_date,
						flt_last_reg_date, flt_notional, flt_fx_mult, flt_curr_fix,
						flt_fixing_dates ,flt_fixing_rates,flt_fix_proxy ,flt_allow_fwd_fix,
						flt_start_stub_rate,flt_end_stub_rate);
		
		//---common---		
		name_			= name;
		imp_calc_dec_  	= imp_fix_rate_dec;//rounding decimals of the implied cpn rate (on decimal value)
		pv01_not_unit_  = null(pv01_not_unit) ? -1: pv01_not_unit;//rounding unit for notional when implied from pv01
		pay_leg1_ 		= pay_fixed;

		trade_date_ 	= trade_date;
		fwd_start_code_ = fwd_start_code;
		start_date_ 	= start_date;
		maturity_ 		= maturity;
		if(!null(maturity_code))
			maturity_code_ 	= maturity_code;	
		settle_date_	= settle_date;
		//cpn_roll_day_ 	= 0;

		this.start_date_helper();
		this.maturity_helper(fip_);
		this.schedule_helper(fip_);
		this.schedule_helper(fp_);
		this.check();		
		
		//if single ccy set_pv01/set_notional will also set the other notional as well as both fxrates to 1
		if(null(fix_notional) && null(flt_notional)){
			this.set_pv01(fix_pv01);
		}
		else if(!null(fix_notional)){
			this.set_notional_fix(fix_notional);
		}
		else if(!null(flt_notional)){
			this.set_notional_flt(flt_notional);
		}
		
		is_inited_ = true;

	}
	

	/*-----------------------------------------------------------------------
	  set_plain  <ALL ARGS>
	  ----------------------------------------------------------------------*/
	void fixflt_parm.set_plain(	//common
								string 							name,								
								date option(nullable)			trade_date,
								date option(nullable) 			settle_date,
								string option(nullable) 		spot_settle_code,
								date option(nullable) 			start_date,
								string option(nullable) 		fwd_start_code,
								date option(nullable) 			maturity,
								string option(nullable) 		maturity_code,
								logical 						pay_fixed,
								bd_convention option(nullable)	pmt_bus_day,/**/
								calendar option(nullable)		pmt_cal,/**/
								logical	 option(nullable)		end_of_month,/**/
								notional_exchg_style option(nullable) notional_exchg,/**/
								integer 						imp_fix_rate_dec,
								number option(nullable) 		pv01_not_unit,
																			
								number 		option(nullable) 	fx_quote,
								string 		option(nullable) 	fx_quote_baseccy,
								string 		option(nullable) 	fx_quote_priceccy,
								logical 	option(nullable) 	pv_in_base_ccy,
								//fix
								string	 option(nullable) 		fix_ccy,/**/
								number	option(nullable)		fix_cpn_freq_n,/**/
								day_count_method option(nullable) fix_day_count,/**/
								interest_rule option(nullable) 	fix_ir_rule ,/**/
								number	option(nullable)		fix_cpn_rate,
								stub_type option(nullable)		fix_stub_type,
								date option(nullable)  			fix_eff_date,
								date option(nullable)  			fix_first_cpn_date,
								date option(nullable)  			fix_last_reg_date,
								number	option(nullable) 		fix_notional,
								number	option(nullable) 		fix_pv01,								
								//flt
								string	 option(nullable) 		flt_ccy,/**/
								number option(nullable)	 		flt_cpn_freq_n,/**/
								day_count_method  option(nullable) flt_day_count,/**/
								interest_rule option(nullable) 	flt_ir_rule ,/**/
								ir_index option(nullable)		flt_ir_index,/**/
								flt_stub_fwd_style option(nullable)  flt_stub_rate_style,
								number option(nullable) 		flt_spread,
								stub_type option(nullable)		flt_stub_type,
								date option(nullable)  			flt_eff_date,
								date option(nullable)  			flt_first_cpn_date,
								date option(nullable)  			flt_last_reg_date,
								number	option(nullable) 		flt_notional,
								//number	option(nullable)		flt_fx_mult,
								number option(nullable) 		flt_curr_fix,
								vector(date) option(nullable) 	flt_fixing_dates ,	
								vector(number) option(nullable) flt_fixing_rates,
								number option(nullable) 		flt_fix_proxy ,
								logical option(nullable) 		flt_allow_fwd_fix,
								number option(nullable) 		flt_start_stub_rate,
								number option(nullable) 		flt_end_stub_rate)
	{
		QL_FAIL_COND(null(is_ccy_),"fixflt_parm is not initalized (init_static() must be run) ");
		
		if(null(fix_notional) && null(flt_notional))
			QL_REQUIRE(!null(fix_pv01),"one of notionals and fix_pv01 must be input");
		else if(null(fix_pv01))
			QL_REQUIRE(!null(fix_notional) || !null(flt_notional),"one of notionals and fix_pv01 must be input");
		else if(!null(fix_notional) && !null(flt_notional) && !null(fix_pv01))
			QL_FAIL("ambigious input of notionals and fix_pv01");

		if(null(fix_ccy))
			fix_ccy = fip_.fix_ccy_ ;//could be set in init from a def or swap
		
		if(null(flt_ccy))
			flt_ccy = fp_.flt_ccy_ ;//could be set in init from a def or swap
		
		number 	fix_fx_mult, flt_fx_mult;
		set_fx_input(fix_ccy,flt_ccy, fx_quote, fx_quote_baseccy, fx_quote_priceccy, pv_in_base_ccy, fix_notional,flt_notional,fix_fx_mult, flt_fx_mult);
					
		//----fix_parm-----
		fip_.set_plain(	pmt_bus_day, pmt_cal, end_of_month, fix_ccy, fix_cpn_freq_n, fix_day_count, fix_ir_rule ,0,0,0,0,
						fix_cpn_rate, fix_stub_type,fix_eff_date, fix_first_cpn_date, fix_last_reg_date, fix_notional,
						fix_fx_mult);		
		
		//----flt_parm--------
		number flt_reset_freq_n = flt_cpn_freq_n;
		fp_.set_plain(	pmt_bus_day, pmt_cal, end_of_month, flt_ccy, flt_cpn_freq_n, flt_reset_freq_n,flt_day_count,
						flt_ir_rule , flt_ir_index, 0,0,0,0,flt_stub_rate_style,flt_spread, flt_stub_type,flt_eff_date, flt_first_cpn_date,
						flt_last_reg_date, flt_notional, flt_fx_mult, flt_curr_fix,
						flt_fixing_dates ,flt_fixing_rates,flt_fix_proxy ,flt_allow_fwd_fix,flt_start_stub_rate,flt_end_stub_rate);
		
		//---common---
		
		name_			= name;
		imp_calc_dec_  	= imp_fix_rate_dec;//rounding decimals of the implied cpn rate (on decimal value)
		pv01_not_unit_  = null(pv01_not_unit) ? -1: pv01_not_unit;//rounding unit for notional when implied from pv01
		pay_leg1_ 		= pay_fixed;
		if(null(notional_exchg)) {
			if(null(ne_))
				ne_ = is_ccy_ ? notional_exchg_style.NE_BOTH : notional_exchg_style.NE_NONE;
		}
		else {
			ne_ = notional_exchg;
		}

		if(!null(spot_settle_code))
			spot_code_ 	= spot_settle_code;
		trade_date_ 	= trade_date;
		fwd_start_code_ = fwd_start_code;
		start_date_ 	= start_date;
		maturity_ 		= maturity;
		if(!null(maturity_code))
			maturity_code_ 	= maturity_code;	
		settle_date_	= settle_date;
		//cpn_roll_day_ 	= 0;

		this.start_date_helper();
		this.maturity_helper(fip_);
		this.schedule_helper(fip_);
		this.schedule_helper(fp_);
		this.check();
		//if single ccy set_pv01/set_notional will also set the other notional as well as both fxrates to 1
		if(null(fix_notional) && null(flt_notional)){
			this.set_pv01(fix_pv01);
		}
		else if(!null(fix_notional)){
			this.set_notional_fix(fix_notional);
		}
		else if(!null(flt_notional)){
			this.set_notional_flt(flt_notional);
		}

		is_inited_ = true;

	}
	/*-----------------------------------------------------------------------
	  set_plain_amort_single_curr
	  ----------------------------------------------------------------------*/
	void fixflt_parm.set_plain_amort_single_curr(	//common
												string 							name,												
												date option(nullable)			trade_date,
												date option(nullable) 			settle_date,
												
												date option(nullable) 			start_date,
												string option(nullable) 		fwd_start_code,
												date option(nullable) 			maturity,
												string option(nullable) 		maturity_code,
												logical 						pay_fixed,																															
												integer 						imp_fix_rate_dec,
												//number 	option(nullable) 		pv01_not_unit,
												number	 						notional,
												//fix												
												number	option(nullable)		fix_cpn_rate,
												stub_type option(nullable)		fix_stub_type,
												date option(nullable)  			fix_eff_date,
												date option(nullable)  			fix_first_cpn_date,
												date option(nullable)  			fix_last_reg_date,
												sink_fund_style option(nullable)  	fix_sink_fund_style,
												vector(date)  option(nullable)  	fix_sink_fund_dates,
												vector(number)  option(nullable)  	fix_sink_fund,
												number option(nullable) 		flt_spread,
												stub_type option(nullable)		flt_stub_type,
												date option(nullable)  			flt_eff_date,
												date option(nullable)  			flt_first_cpn_date,
												date option(nullable)  			flt_last_reg_date,
												sink_fund_style option(nullable) flt_sink_fund_style ,
												vector(date) option(nullable) 	flt_sink_fund_dates ,
												vector(number) option(nullable) flt_sink_fund ,
												number option(nullable) 		flt_curr_fix,
												vector(date) option(nullable) 	flt_fixing_dates ,	
												vector(number) option(nullable) flt_fixing_rates,
												number option(nullable) 		flt_fix_proxy ,
												logical option(nullable) 		flt_allow_fwd_fix,
												number option(nullable) 		flt_start_stub_rate,
												number option(nullable) 		flt_end_stub_rate)
	{
		QL_FAIL_COND(null(is_ccy_),"fixflt_parm is not initalized (init_static() must be run) ");
		QL_REQUIRE(!is_ccy_,"function not applicable to cross currency swaps");
		
		QL_FAIL_COND(null(fix_sink_fund_style) && null(flt_sink_fund_style),"invalid sinkfund style (this function is for single currency amortizing swaps only)");
		QL_FAIL_COND(null(fix_sink_fund_dates) && null(flt_sink_fund_dates),"invalid sinkfund dates (this function is for single currency amortizing swaps only)");
		QL_FAIL_COND(null(fix_sink_fund) && null(flt_sink_fund),"invalid sinkfund (this function is for single currency amortizing swaps only)");
		
		//----fix_parm-----
		fip_.set_plain_amort(null,null,null,null,notional,	null, null,null,null ,0,0,0,0,
							fix_cpn_rate,fix_stub_type,fix_eff_date,fix_first_cpn_date,
							fix_last_reg_date,fix_sink_fund_style,fix_sink_fund_dates,
							fix_sink_fund,1);
		
		//----flt_parm-----		
		fp_.set_plain_amort(null,null,null,null,notional,null,null,null,null, null ,null,0,0,0,0,null,flt_spread,flt_stub_type,
							flt_eff_date,flt_first_cpn_date,flt_last_reg_date,
							flt_sink_fund_style ,flt_sink_fund_dates ,flt_sink_fund ,flt_curr_fix,flt_fixing_dates ,	
							flt_fixing_rates,flt_fix_proxy ,flt_allow_fwd_fix,flt_start_stub_rate,flt_end_stub_rate,1);
		
		//---common---
		name_			= name;
		imp_calc_dec_  	= imp_fix_rate_dec;//rounding decimals of the implied cpn rate (on decimal value)
		pv01_not_unit_  = -1;//null(pv01_not_unit) ? -1: pv01_not_unit;//rounding unit for notional when implied from pv01
		pay_leg1_ 		= pay_fixed;

		trade_date_ 	= trade_date;
		fwd_start_code_ = fwd_start_code;
		start_date_ 	= start_date;
		maturity_ 		= maturity;
		if(!null(maturity_code))
			maturity_code_ 	= maturity_code;	
		settle_date_	= settle_date;
		//cpn_roll_day_ 	= 0;

		this.start_date_helper();
		this.maturity_helper(fip_);
		this.schedule_helper(fip_);
		this.schedule_helper(fp_);
		this.check();
		this.set_notional_fix(notional);
		
		is_inited_ = true;
	}
	/*-----------------------------------------------------------------------
	  set_plain_amort_single_curr <ALL ARGS>
	  ----------------------------------------------------------------------*/
	void fixflt_parm.set_plain_amort_single_curr(	//common
												string 							name,												
												date option(nullable)			trade_date,
												date option(nullable) 			settle_date,
												string option(nullable) 		spot_settle_code,
												date option(nullable) 			start_date,
												string option(nullable) 		fwd_start_code,
												date option(nullable) 			maturity,
												string option(nullable) 		maturity_code,
												logical 						pay_fixed,
												bd_convention option(nullable)	pmt_bus_day,
												calendar option(nullable)		pmt_cal,
												logical	 option(nullable)		end_of_month,
												notional_exchg_style option(nullable) notional_exchg,											
												string	 						ccy,
												integer 						imp_fix_rate_dec,
												//number 	option(nullable) 		pv01_not_unit,
												number	 						notional,
												//fix
												number	option(nullable)		fix_cpn_freq_n,
												day_count_method option(nullable) fix_day_count,
												interest_rule option(nullable) 	fix_ir_rule ,
												number	option(nullable)		fix_cpn_rate,
												stub_type option(nullable)		fix_stub_type,
												date option(nullable)  			fix_eff_date,
												date option(nullable)  			fix_first_cpn_date,
												date option(nullable)  			fix_last_reg_date,
												sink_fund_style option(nullable)  	fix_sink_fund_style,
												vector(date)  option(nullable)  	fix_sink_fund_dates,
												vector(number)  option(nullable)  	fix_sink_fund,
												//flt
												number option(nullable)	 		flt_cpn_freq_n,
												day_count_method  option(nullable) flt_day_count,
												interest_rule option(nullable) 	flt_ir_rule ,
												ir_index option(nullable)		flt_ir_index,
												flt_stub_fwd_style option(nullable)  flt_stub_rate_style,
												number option(nullable) 		flt_spread,
												stub_type option(nullable)		flt_stub_type,
												date option(nullable)  			flt_eff_date,
												date option(nullable)  			flt_first_cpn_date,
												date option(nullable)  			flt_last_reg_date,
												sink_fund_style option(nullable) flt_sink_fund_style ,
												vector(date) option(nullable) 	flt_sink_fund_dates ,
												vector(number) option(nullable) flt_sink_fund ,
												number option(nullable) 		flt_curr_fix,
												vector(date) option(nullable) 	flt_fixing_dates ,	
												vector(number) option(nullable) flt_fixing_rates,
												number option(nullable) 		flt_fix_proxy ,
												logical option(nullable) 		flt_allow_fwd_fix,
												number option(nullable) 		flt_start_stub_rate,
												number option(nullable) 		flt_end_stub_rate)
	{
	
		QL_FAIL_COND(null(fix_sink_fund_style) && null(flt_sink_fund_style),"invalid sinkfund style (this function is for single currency amortizing swaps only)");
		QL_FAIL_COND(null(fix_sink_fund_dates) && null(flt_sink_fund_dates),"invalid sinkfund dates (this function is for single currency amortizing swaps only)");
		QL_FAIL_COND(null(fix_sink_fund) && null(flt_sink_fund),"invalid sinkfund (this function is for single currency amortizing swaps only)");
		
		//----fix_parm-----
		fip_.set_plain_amort(pmt_bus_day,pmt_cal,end_of_month,ccy,notional,null,fix_cpn_freq_n,fix_day_count,fix_ir_rule ,0,0,0,0,
										fix_cpn_rate,fix_stub_type,fix_eff_date,fix_first_cpn_date,fix_last_reg_date,fix_sink_fund_style,fix_sink_fund_dates,
										fix_sink_fund,1);
		
		//----flt_parm-----
		number flt_reset_freq_n = flt_cpn_freq_n;
		fp_.set_plain_amort(pmt_bus_day,pmt_cal,end_of_month,ccy,notional,null,flt_cpn_freq_n,flt_reset_freq_n,flt_day_count,
							flt_ir_rule ,flt_ir_index,0,0,0,0,flt_stub_rate_style,flt_spread,flt_stub_type,flt_eff_date,
							flt_first_cpn_date,flt_last_reg_date,
							flt_sink_fund_style ,flt_sink_fund_dates ,flt_sink_fund ,flt_curr_fix,flt_fixing_dates ,	
							flt_fixing_rates,flt_fix_proxy ,flt_allow_fwd_fix,flt_start_stub_rate,flt_end_stub_rate,1);
		
		//---common---
		name_			= name;
		imp_calc_dec_  	= imp_fix_rate_dec;//rounding decimals of the implied cpn rate (on decimal value)
		pv01_not_unit_  = null;//null(pv01_not_unit) ? -1: pv01_not_unit;//rounding unit for notional when implied from pv01
		pay_leg1_ 		= pay_fixed;
		is_ccy_ 		= false;
		
		if(null(notional_exchg)) {
			if(null(ne_))
				ne_ = is_ccy_ ? notional_exchg_style.NE_BOTH : notional_exchg_style.NE_NONE;
		}
		else {
			ne_ = notional_exchg;
		}

		if(!null(spot_settle_code))
			spot_code_ 	= spot_settle_code;
		trade_date_ 	= trade_date;
		fwd_start_code_ = fwd_start_code;
		start_date_ 	= start_date;
		maturity_ 		= maturity;
		if(!null(maturity_code))
			maturity_code_ 	= maturity_code;	
		settle_date_	= settle_date;
		//cpn_roll_day_ 	= 0;

		this.start_date_helper();
		this.maturity_helper(fip_);
		this.schedule_helper(fip_);
		this.schedule_helper(fp_);
		this.check();
		this.set_notional_fix(notional);
		
		is_inited_ = true;
	}
}