option(null: hard);	

/*	
	swaplib wrapper functions
	Developer: Algorithmica Research, Magnus Nyström

	--------------------------------------------------------------------
	 	swap help functions for create funcs
	--------------------------------------------------------------------			
*/
module CORE_SWAPLIB
{
	
		
	/*-----------------------------------------------------------------------
	 -----------------------------------------------------------------------
	 -----class fixois_parm--------------------------------------------------
	 -----------------------------------------------------------------------
	 -----------------------------------------------------------------------*/
	class fixois_parm : public legleg_parm
	{
	public:
		override instr_type type() ;
		
		fixois_parm();
		void 				start_date_helper();
		void 				fx_notional_helper();

		logical 			ois_df_check( ..disc_func option(nullable) disc_func_rev_leg,
										 ..disc_func option(nullable) ois_disc_func,
										 ..fwd_func option(nullable) ois_fwd_func,
										 ..disc_func option(nullable) ois_fwd_disc_func,
										 out string err_msg);
		
		void				init_static(instr_def,string option(nullable) );
		void				init_static(INSTR_TMPL.swap_fixois_def_tmpl);
		void				init_static(swap_fixois,string option(nullable) );
		void				init_static(string option(nullable),
										bd_convention  		pmt_bus_day,
										calendar 			pmt_cal,
										logical				end_of_month,
										notional_exchg_style option(nullable) ne,												
										//fix
										string				fix_ccy,
										integer 			fix_cpn_freq,
										day_count_method  	fix_day_count,
										interest_rule		fix_ir_rule,
										number,number,
										//flt
										string				ois_ccy,
										integer				ois_cpn_freq,
										day_count_method   	ois_day_count,
										interest_rule		ois_ir_rule,
										ir_index 			ois_ir_index,
										avg_comp_method option(nullable) ois_comp_avg,
										//flt_comp_avg_type option(nullable)		ois_comp_avg_t ,
										//flt_sprd_comp_method option(nullable)	ois_sprd_comp_m,
										//flt_avg_method 	option(nullable)		ois_avg_m,
										rfr_arrears_type  option(nullable)		ois_arr_type,
										number option(nullable) 				ois_arr_days ,
										number				ois_pmt_delay,
										number,
										logical				ois_endog_df,
										logical 			ois_approx_calc,
										logical option(nullable) fix_avg_not = null,
										logical option(nullable) ois_avg_not = null);
		
		void 				set_notional_fix(number);
		void 				set_notional_ois(number);
		void 				set_pv01(number);
		fix_parm			fix_leg_parm();
		ois_parm 			ois_leg_parm();
	protected:
		void 		check();
		//void 		__set_plain_vanilla();
		void 		__set_plain(bd_convention option(nullable) 	pmt_bus_day,
								calendar option(nullable)	pmt_cal,
								logical	option(nullable) 	end_of_month,
								integer 					imp_sprd_dec,
								number option(nullable)		pv01_not_unit,											
								//fix
								string	option(nullable),
								number option(nullable)		fix_cpn_freq_n,
								day_count_method option(nullable) fix_day_count,
								 interest_rule option(nullable) 	fix_ir_rule ,
								number  option(nullable),
								number	option(nullable),number	option(nullable),
								number	option(nullable)	fix_cpn_rate,
								//ois
								string	option(nullable),
								number option(nullable)		ois_cpn_freq_n,
								day_count_method  option(nullable) ois_day_count,
								interest_rule option(nullable) ois_ir_rule,
								ir_index option(nullable)	ois_ir_index,
								number  option(nullable),
								flt_comp_avg_type option(nullable)		ois_comp_avg_t ,
								flt_sprd_comp_method option(nullable)	ois_sprd_comp_m,
								flt_avg_method 	option(nullable)		ois_avg_m,
								rfr_arrears_type  option(nullable)		ois_arr_type,
								number option(nullable) 				ois_arr_days ,
								number  option(nullable)		ois_pmt_delay,
								number	option(nullable),
								logical	option(nullable)	ois_endog_df,
								logical option(nullable)	ois_approx_calc,
								number	option(nullable)	ois_spread);
		
		swap_fixois __create_swap( disc_func option(nullable) fix_disc_func,
									disc_func option(nullable) ois_disc_func,
									fwd_func option(nullable) 	ois_fwd_func,
									disc_func option(nullable) 	ois_fwd_disc_func );
	public:

		void 		set_plain_single_ccy(string,
										date option(nullable) 		trade_date,
										date option(nullable) 		settle_date,
										string option(nullable) 	spot_settle_code,
										date option(nullable) 		start_date,
										string option(nullable)		fwd_start_code,
										date option(nullable) 		maturity,
										string option(nullable) 	maturity_code,
										logical,
										bd_convention option(nullable) 	pmt_bus_day,
										calendar option(nullable)	pmt_cal,
										logical	option(nullable) 	end_of_month,
										string	option(nullable) 	ccy,
										integer 					,
										number 	option(nullable)	,
										number	option(nullable) 	notional,
										number	option(nullable) 	fix_pv01,
										//fix
										number option(nullable)		fix_cpn_freq_n,
										day_count_method option(nullable) fix_day_count,
										interest_rule option(nullable) fix_ir_rule,
										 number	option(nullable),number	option(nullable),
										number	option(nullable)	fix_cpn_rate,
										//ois
										number option(nullable)		ois_cpn_freq_n,
										day_count_method  option(nullable) ois_day_count,
										 interest_rule option(nullable) ois_ir_rule,
										ir_index option(nullable)	ois_ir_index,
										 avg_comp_method option(nullable) ois_comp_avg,
											//flt_comp_avg_type option(nullable)		ois_comp_avg_t ,
											//flt_sprd_comp_method option(nullable)	ois_sprd_comp_m,
											//flt_avg_method 	option(nullable)		ois_avg_m,
											rfr_arrears_type  option(nullable)		ois_arr_type,
											number option(nullable) 				ois_arr_days ,
										number  option(nullable)	ois_pmt_delay,
										 number	option(nullable),
										logical	option(nullable)	ois_endog_df,
										logical option(nullable)	ois_approx_calc,
										number	option(nullable)	ois_spread);
		
		void 		set_plain_single_ccy(string,
										date option(nullable) 		trade_date,
										date option(nullable) 		settle_date,
										
										date option(nullable) 		start_date,
										 string option(nullable)	fwd_start_code,
										date option(nullable) 		maturity,
										string option(nullable) 	maturity_code,
										logical,											
										integer 					,
										number 	option(nullable)	,
										number	option(nullable) 	notional,
										number	option(nullable) 	fix_pv01,
										//fix
										number	option(nullable)	fix_cpn_rate,
										//ois
										number	option(nullable)	ois_spread);

		void 		set_plain(	string,								
								date option(nullable) 			trade_date,
								date option(nullable) 			settle_date,
								string option(nullable) 		spot_settle_code,
								date option(nullable) 			start_date,
								string option(nullable) 		fwd_start_code,
								date option(nullable)			maturity,
								string option(nullable) 		maturity_code,
								logical,
								bd_convention option(nullable)	pmt_bus_day,
								calendar option(nullable)		pmt_cal,
								logical	 option(nullable)		end_of_month,
								notional_exchg_style option(nullable) notional_exchg,
								integer 					,
								number 	option(nullable)	,
								number 	option(nullable) 		fx_quote,
								string 	option(nullable) 		fx_quote_baseccy,
								string 	option(nullable) 		fx_quote_priceccy,
								logical option(nullable) 		pv_in_base_ccy,
								//fix
								string	option(nullable)		fix_ccy,
								number	option(nullable)		fix_cpn_freq_n,
								day_count_method option(nullable) fix_day_count,
								interest_rule option(nullable) 	fix_ir_rule ,
								number	option(nullable),number	option(nullable),
								number	option(nullable)		fix_cpn_rate,
								stub_type option(nullable)		fix_stub_type,
								date option(nullable)  			fix_eff_date,
								date option(nullable)  			fix_first_cpn_date,
								date option(nullable)  			fix_last_reg_date,
								number	option(nullable) 		fix_notional,
								number	option(nullable) 		fix_pv01,
								//ois
								string	option(nullable)		ois_ccy,
								number option(nullable)	 		ois_cpn_freq_n,
								day_count_method  option(nullable) ois_day_count,
								interest_rule option(nullable) ois_ir_rule,
								ir_index option(nullable)		ois_ir_index,
								avg_comp_method option(nullable) ois_comp_avg,
											//flt_comp_avg_type option(nullable)		ois_comp_avg_t ,
											//flt_sprd_comp_method option(nullable)	ois_sprd_comp_m,
											//flt_avg_method 	option(nullable)		ois_avg_m,
								rfr_arrears_type  option(nullable)		ois_arr_type,
								number option(nullable) 				ois_arr_days ,
								number  option(nullable)		ois_pmt_delay,
								number	option(nullable),
								logical	option(nullable)		ois_endog_df,
								logical option(nullable)		ois_approx_calc,
								number option(nullable) 		ois_spread,
								stub_type option(nullable)		ois_stub_type,
								date option(nullable)  			ois_eff_date,
								date option(nullable)  			ois_first_cpn_date,
								date option(nullable)  			ois_last_reg_date,
								number	option(nullable) 		ois_notional,
								vector(date) option(nullable) 	ois_fixing_dates ,	
								vector(number) option(nullable) ois_fixing_rates,
								number option(nullable) 		ois_fix_proxy ,
								logical option(nullable) 		ois_allow_fwd_fix);

		void 		set_plain(	string,								
								date option(nullable) 			trade_date,
								date option(nullable) 			settle_date,
								
								date option(nullable) 			start_date,
								string option(nullable) 		fwd_start_code,
								date option(nullable)			maturity,
								string option(nullable) 		maturity_code,
								logical,
								integer 					,
								number 	option(nullable)	,
								number 	option(nullable) 		fx_quote,
								string 	option(nullable) 		fx_quote_baseccy,
								string 	option(nullable) 		fx_quote_priceccy,
								logical option(nullable) 		pv_in_base_ccy,
								//fix
								number	option(nullable)		fix_cpn_rate,
								stub_type option(nullable)		fix_stub_type,
								date option(nullable)  			fix_eff_date,
								date option(nullable)  			fix_first_cpn_date,
								date option(nullable)  			fix_last_reg_date,
								number	option(nullable) 		fix_notional,
								number	option(nullable) 		fix_pv01,
								//ois
								number option(nullable) 		ois_spread,
								stub_type option(nullable)		ois_stub_type,
								date option(nullable)  			ois_eff_date,
								date option(nullable)  			ois_first_cpn_date,
								date option(nullable)  			ois_last_reg_date,
								number	option(nullable) 		ois_notional,
								vector(date) option(nullable) 	ois_fixing_dates ,	
								vector(number) option(nullable) ois_fixing_rates,
								number option(nullable) 		ois_fix_proxy ,
								logical option(nullable) 		ois_allow_fwd_fix);

		void 		set_plain_amort_single_curr(string,													
												date option(nullable) 			trade_date,
												date option(nullable) 			settle_date,
												string option(nullable) 		spot_settle_code,
												date option(nullable) 			start_date,
												string option(nullable) 		fwd_start_code,
												date option(nullable)			maturity,
												string option(nullable) 		maturity_code,
												logical,
												bd_convention option(nullable)	pmt_bus_day,
												calendar option(nullable)		pmt_cal,
												logical	 option(nullable)		end_of_month,
												notional_exchg_style option(nullable) notional_exchg,
												integer 					,
												number 	option(nullable)	,
												string	 						ccy,
												number	 						notional,
												//fix
												number	option(nullable)		fix_cpn_freq_n,
												day_count_method option(nullable) fix_day_count,
												interest_rule option(nullable) 	fix_ir_rule ,
												number	option(nullable),number	option(nullable),
												number	option(nullable)		fix_cpn_rate,
												stub_type option(nullable)		fix_stub_type,
												date option(nullable)  			fix_eff_date,
												date option(nullable)  			fix_first_cpn_date,
												date option(nullable)  			fix_last_reg_date,
												sink_fund_style option(nullable)  fix_sink_fund_style,
												vector(date)  option(nullable)  fix_sink_fund_dates,
												vector(number)  option(nullable)  fix_sink_fund,
												//ois
												number option(nullable)	 		ois_cpn_freq_n,
												day_count_method  option(nullable) ois_day_count,
												interest_rule option(nullable) ois_ir_rule,
												ir_index option(nullable)		ois_ir_index,												
												number  option(nullable)		ois_pmt_delay,
												number	option(nullable),
												logical	option(nullable)		ois_endog_df,
												logical option(nullable)		ois_approx_calc,
												number option(nullable) 		ois_spread,
												stub_type option(nullable)		ois_stub_type,
												date option(nullable)  			ois_eff_date,
												date option(nullable)  			ois_first_cpn_date,
												date option(nullable)  			ois_last_reg_date,									
												sink_fund_style option(nullable) ois_sink_fund_style ,
												vector(date) option(nullable) 	ois_sink_fund_dates ,
												vector(number) option(nullable) ois_sink_fund,						
												vector(date) option(nullable) 	ois_fixing_dates ,	
												vector(number) option(nullable) ois_fixing_rates,
												number option(nullable) 		ois_fix_proxy ,
												logical option(nullable) 		ois_allow_fwd_fix);

		void 		set_plain_amort_single_curr(string,													
												date option(nullable) 			trade_date,
												date option(nullable) 			settle_date,
												
												date option(nullable) 			start_date,
												string option(nullable) 		fwd_start_code,
												date option(nullable)			maturity,
												string option(nullable) 		maturity_code,
												logical 						pay_fixed,
												integer 						imp_fix_rate_dec,
												number option(nullable)			pv01_not_unit,
												number	 						notional,
												//fix
												number	option(nullable)		fix_cpn_rate,
												stub_type option(nullable)		fix_stub_type,
												date option(nullable)  			fix_eff_date,
												date option(nullable)  			fix_first_cpn_date,
												date option(nullable)  			fix_last_reg_date,
												sink_fund_style option(nullable)  fix_sink_fund_style,
												vector(date)  option(nullable)  fix_sink_fund_dates,
												vector(number)  option(nullable)  fix_sink_fund,
												//ois
												number option(nullable) 		ois_spread,
												stub_type option(nullable)		ois_stub_type,
												date option(nullable)  			ois_eff_date,
												date option(nullable)  			ois_first_cpn_date,
												date option(nullable)  			ois_last_reg_date,									
												sink_fund_style option(nullable) ois_sink_fund_style ,
												vector(date) option(nullable) 	ois_sink_fund_dates ,
												vector(number) option(nullable) ois_sink_fund,						
												vector(date) option(nullable) 	ois_fixing_dates ,	
												vector(number) option(nullable) ois_fixing_rates,
												number option(nullable) 		ois_fix_proxy ,
												logical option(nullable) 		ois_allow_fwd_fix);

		swap_fixois 		create_swap( disc_func option(nullable) 	fix_disc_func,
										disc_func option(nullable) 	ois_disc_func,
										fwd_func option(nullable) 	ois_fwd_func,
										disc_func option(nullable) 	ois_fwd_disc_func,
										logical sync_endog_ok);

		/*swap_fixois 		create_swap( disc_func option(nullable) 	fix_disc_func,
										disc_func option(nullable) 	ois_disc_func,
										fwd_func option(nullable) 	ois_fwd_func );*/

			
		fix_parm	fip_;
		ois_parm	op_;
	};
	/*-----------------------------------------------------------------------
	  constructor
	  ----------------------------------------------------------------------*/
	fixois_parm.fixois_parm()
	{
		fip_ 			= new fix_parm();
		op_ 			= new ois_parm();
	}
	/*-----------------------------------------------------------------------
	  type
	  ----------------------------------------------------------------------*/
	instr_type fixois_parm.type() { return instr_type.SWAP_FIXOIS;}
	/*-----------------------------------------------------------------------
	  set_notional_fix
	  ----------------------------------------------------------------------*/
	void fixois_parm.set_notional_fix(number not)
	{
		fip_.fix_notional_ 	= not;
		if(!is_ccy_)
			op_.ois_notional_ 	= not;
		leg_pv01_ 			= null;
		fx_notional_helper();
	}
	/*-----------------------------------------------------------------------
	  set_notional_ois
	  ----------------------------------------------------------------------*/
	void fixois_parm.set_notional_ois(number not)
	{
		op_.ois_notional_ 	= not;
		if(!is_ccy_)			
			fip_.fix_notional_ 	= not;
		leg_pv01_ 			= null;
		fx_notional_helper();
	}
	/*-----------------------------------------------------------------------
	  set_notional
	  ----------------------------------------------------------------------*/
	void fixois_parm.set_pv01(number pv01)
	{
		fip_.fix_notional_ 	= 1000000;
		op_.ois_notional_ 	= null;//if null it will be calculated in ccy_helper
		leg_pv01_ 			= pv01;
		fx_notional_helper();
	}
	/*-----------------------------------------------------------------------
	  fix_leg_parm / ois_leg_parm
	  ----------------------------------------------------------------------*/
	fix_parm fixois_parm.fix_leg_parm() { return fip_;}
	ois_parm fixois_parm.ois_leg_parm() { return op_;}
	/*-----------------------------------------------------------------------
	  ccy_helper
	  ----------------------------------------------------------------------*/
	void fixois_parm.fx_notional_helper()
	{
		legleg_parm.fx_notional_helper(fip_.fix_notional_, op_.ois_notional_, fip_.fix_fx_mult_ , op_.ois_fx_mult_);
	}
	/*-----------------------------------------------------------------------
	  start_date_helper
	  ----------------------------------------------------------------------*/
	void fixois_parm.start_date_helper()
	{
		legleg_parm.start_date_helper(fip_.fix_eff_date_, op_.ois_eff_date_, fip_.fix_pmt_calendar_);
	}
	/*-----------------------------------------------------------------------
	  check
	  ----------------------------------------------------------------------*/
	void fixois_parm.check()
	{
		if(is_aged_swap()){
			QL_REQUIRE(!null(fip_.fix_coupon_rate_),"fix cpn rate required for aged swap");
			if(is_ccy_ ) {
				QL_REQUIRE(!null(fip_.fix_notional_) && !null(op_.ois_notional_),"notionals are required for aged swap");
			}
			else {
				QL_REQUIRE(!null(fip_.fix_notional_) || !null(op_.ois_notional_),"notional is required for aged swap");
			}
		}
	}
	/*-----------------------------------------------------------------------
	  ois_df_check
	  ----------------------------------------------------------------------*/
	logical fixois_parm.ois_df_check(..disc_func option(nullable) disc_func_rev_leg,
									 ..disc_func option(nullable) ois_disc_func,
									 ..fwd_func option(nullable) ois_fwd_func,
									 ..disc_func option(nullable) ois_fwd_disc_func,
									 out string err_msg)
	{
		logical ok = CORE_INT_SWAPLIB.ois_df_check(	op_.ois_endog_df_,is_ccy_,
													disc_func_rev_leg,ois_disc_func, ois_fwd_func,
													ois_fwd_disc_func, err_msg);
		return ok;
	}
	/*-----------------------------------------------------------------------
	  __set_plain_vanilla
	  ----------------------------------------------------------------------*/
	/*void fixois_parm.__set_plain_vanilla()
	{		
		cpn_roll_day_ 		= 0;

		// ----fix_parm-------
		fip_.set_plain_vanilla();
		
		// ----ois parm-------
		logical fed_fund_style = false;
		op_.set_plain_vanilla(fed_fund_style);
				
	}*/
	/*-----------------------------------------------------------------------
	  init_basic_static
	  ----------------------------------------------------------------------*/
	void fixois_parm.init_static(	instr_def def,
									string option(nullable) spot_code )
	{
		QL_REQUIRE(CORE_INT.check_instr_def(def),"invalid instr_def");
		QL_FAIL_COND(!def.is_swap_fixois(), "instr_def not a fix-ois swap", E_INIT);

		//----fixois_parm-----
		is_ccy_ 		= def.is_ccy_swap();		
		error_info ees 	= new error_info(true,false);
		ne_ 			= def.swap_not_exchange(ees);
		if(null(ne_))
			ne_ 	= is_ccy_ ? NE_BOTH : NE_NONE;
		
		spot_code_ 		= null(spot_code) ? "BD2" : spot_code;
		trade_date_ 	= null;
		maturity_ 		= null;
		maturity_code_ 	= def.maturity_code(ees);
		mat_code_ 		= null;
		fwd_start_code_ = null;
		start_date_ 	= null;
		settle_date_	= null;
		//cpn_roll_day_ 	= 0;

		//----fix_parm-----
		fip_.init_static(def);
		
		//----ois_parm--------
		op_.init_basic_static_leg2(def);		
	
	}
	/*-----------------------------------------------------------------------
	  init_basic_static
	  Note: a possible maturity code in the template is never "carried over" to the swap
	  Note to self: tmpl --> def --> ql_fixed_income_swap --> swap_fixflt (and the def is lost in the process since it is only part of the translation)
					(a direct route without the def is possible but not sure if it will save much compute time)
	  ----------------------------------------------------------------------*/
	void fixois_parm.init_static(INSTR_TMPL.swap_fixois_def_tmpl tmpl)
	{

		is_ccy_ 		= tmpl.is_cross_curr();		
		ne_ 			= tmpl.not_exchange();
		if(null(ne_))
			ne_ 	= is_ccy_ ? NE_BOTH : NE_NONE;

		
		spot_code_ 		= tmpl.spot_settle_code();
		trade_date_ 	= null;
		maturity_ 		= null;
		maturity_code_ 	= tmpl.maturity_code();
		mat_code_ 		= null;
		fwd_start_code_ = null;//tmpl.fwd_start_code();
		start_date_ 	= null;
		settle_date_	= null;
		//cpn_roll_day_ 	= 0;

		//----fix_parm-----
		fix_roll_method	roll 		= null;
		logical const_cpn 			= null;		
		..fix_comp_freq comp_freq 	= null;
		logical compound_to_mat		= null;
		logical average_notional 	= null;
		fip_.init_static(	tmpl.bd_convention(), tmpl.calendar(),tmpl.eom(),
							tmpl.fix_currency(), tmpl.fix_cpn_freq(), tmpl.fix_day_count_method(),
							tmpl.fix_ir_rule(),tmpl.payment_delay(),tmpl.payment_delay(),tmpl.payment_delay_prin(),
							tmpl.payment_delay_prin(),average_notional, roll, const_cpn, comp_freq,compound_to_mat);
		
		//----ois_parm--------
		flt_roll_method ois_roll = null; 
		op_.init_static(tmpl.bd_convention(), tmpl.calendar(),tmpl.eom(), tmpl.ois_currency(),
						tmpl.ois_cpn_freq(), tmpl.ois_day_count_method(),
						tmpl.ois_ir_rule(),tmpl.ois_ir_index(),
						tmpl.ois_comp_avg(),
						tmpl.ois_spread_comp_method(),
						tmpl.ois_avg_method(),tmpl.payment_delay() ,
						tmpl.payment_delay(),tmpl.payment_delay_prin(), tmpl.payment_delay_prin() ,
						tmpl.ois_arr_type(), tmpl.ois_arr_days(),tmpl.ois_endog_df(),
						tmpl.ois_approx_calc(),average_notional, ois_roll);
	}
	/*-----------------------------------------------------------------------
	  init_basic_static
	  ----------------------------------------------------------------------*/
	void fixois_parm.init_static(swap_fixois sw_base,
								 string option(nullable) spot_code)	//ext swap i.e. instr_def = null
	{

		//----fixois_parm-----
		error_info ee 	= new error_info(true,true);
		is_ccy_ 		= sw_base.is_ccy_swap();				
		ne_ 			= null;//notional_exchg_style.NE_NONE;
		if(null(ne_))
			ne_ = is_ccy_ ? NE_BOTH : NE_NONE;
		//ne 				= sw_base.notional_exchg_style_fix_leg(ee);		//assume both legs are same
		spot_code_ 		= null(spot_code) ? "BD2" : spot_code;
		trade_date_ 	= null;
		maturity_ 		= null;
		maturity_code_ 	= null;
		mat_code_ 		= null;
		fwd_start_code_ = null;
		start_date_ 	= null;
		settle_date_	= null;
		//cpn_roll_day_ 	= 0;

		integer mat_pmt_delay1,mat_pmt_delay_prin1;
		integer mat_pmt_delay2,mat_pmt_delay_prin2;
		integer pmt_delay1,pmt_delay2 ;
		integer pmt_delay_prin1,pmt_delay_prin2 ;
		sw_base.pmt_lag(pmt_delay1,mat_pmt_delay1, pmt_delay_prin1, mat_pmt_delay_prin1,
						pmt_delay2,mat_pmt_delay2, pmt_delay_prin2, mat_pmt_delay_prin2,ee);

		integer cfreq_ois, cfreq_fix;
		sw_base.coupon_freq( cfreq_fix,cfreq_ois, ee);
		sw_base.calendar(fip_.fix_pmt_calendar_,op_.ois_pmt_calendar_,ee);
		sw_base.pmt_bus_day(fip_.fix_pmt_bus_day_,op_.ois_pmt_bus_day_,ee);
		sw_base.eom(fip_.fix_end_of_month_,op_.ois_end_of_month_,ee);
		sw_base.dc_method(fip_.fix_dc_,op_.ois_dc_ ,ee);
		sw_base.currency(fip_.fix_ccy_ ,op_.ois_ccy_ ,ee);		

		//---fix---
		fix_roll_method	roll 		= null;
		logical const_cpn 			= null;		
		..fix_comp_freq comp_freq 	= null;
		logical compound_to_mat		= null;
		logical average_notional 	= null;
		fip_.init_static(	fip_.fix_pmt_bus_day_, fip_.fix_pmt_calendar_,fip_.fix_end_of_month_,
							fip_.fix_ccy_, cfreq_fix, fip_.fix_dc_,
							sw_base.ir_rule_fix_leg(ee),pmt_delay1,mat_pmt_delay1,
							pmt_delay_prin1,mat_pmt_delay_prin1,average_notional, roll ,const_cpn, comp_freq,
							compound_to_mat);

		//----ois_parm--------
		flt_comp_avg_type ois_comp_avg_type 		= sw_base.comp_avg_type_ois_leg(ee);//OBS n/a for ext swap
		flt_sprd_comp_method  ois_sprd_comp_method 	= sw_base.sprd_comp_method_ois_leg(ee);//OBS n/a for ext swap
		flt_avg_method ois_avg_method 				= sw_base.avg_method_ois_leg(ee);//OBS n/a for ext swap
		rfr_arrears_type at  						= sw_base.rfr_arrears_type_ois_leg(ee);//OBS n/a for ext swap
		integer a 									= sw_base.rfr_arrears_days_ois_leg(ee);//OBS n/a for ext swap
		number ad 									= a == err_int() ? null : a ;
		logical  ois_average_notional				= null;
		flt_roll_method ois_roll 					= null; 
		op_.init_static(op_.ois_pmt_bus_day_,op_.ois_pmt_calendar_,op_.ois_end_of_month_, op_.ois_ccy_,
						cfreq_ois, op_.ois_dc_,
						sw_base.ir_rule_ois_leg(),sw_base.ir_index_ois_leg(ee),
						ois_comp_avg_type,ois_sprd_comp_method,ois_avg_method,
						pmt_delay2,mat_pmt_delay2,pmt_delay_prin2,mat_pmt_delay_prin2,
						at ,ad,sw_base.is_endog_df(ee),
						sw_base.is_approx_calc(ee),ois_average_notional, ois_roll);
	}

	void fixois_parm.init_static(string option(nullable) spot_code,
								 bd_convention  	pmt_bus_day,
								calendar 			pmt_cal,
								logical				end_of_month,
								notional_exchg_style option(nullable) ne,												
								//fix
								string				fix_ccy,
								integer 			fix_cpn_freq,
								day_count_method  	fix_day_count,
								interest_rule		fix_ir_rule,
								number				fix_pmt_delay,
								number				fix_pmt_delay_prin,
								//ois
								string				ois_ccy,
								integer				ois_cpn_freq,
								day_count_method   	ois_day_count,
								interest_rule		ois_ir_rule,
								ir_index 			ois_ir_index,
								avg_comp_method option(nullable) ois_comp_avg,
								//flt_comp_avg_type option(nullable)		ois_comp_avg_t ,
								//flt_sprd_comp_method option(nullable)	ois_sprd_comp_m,
								//flt_avg_method 	option(nullable)		ois_avg_m,
								rfr_arrears_type  option(nullable)		ois_arr_type,
								number option(nullable) 				ois_arr_days ,
								number				ois_pmt_delay,
								 number				ois_pmt_delay_prin,
								logical				ois_endog_df,
								logical 			ois_approx_calc,
								logical option(nullable) fix_avg_not,
								logical option(nullable) ois_avg_not)
	{
		//----fixflt_parm-----		
		is_ccy_ 		= !equal_casei(fix_ccy, ois_ccy);	
		ne_ 			= ne;
		if(null(ne_))
			ne_ = is_ccy_ ? NE_BOTH : NE_NONE;

		spot_code_ 		= null(spot_code) ? "BD2" : spot_code;
		trade_date_ 	= null;
		maturity_ 		= null;
		maturity_code_ 	= null;
		mat_code_ 		= null;
		fwd_start_code_ = null;
		start_date_ 	= null;
		settle_date_	= null;
		//cpn_roll_day_ 	= 0;
		
		//---fix---
		fix_roll_method	roll 		= fix_roll_method.FIR_STRAIGHT;
		logical const_cpn 			= false;		
		..fix_comp_freq comp_freq 	= fix_comp_freq.FCF_AS_FREQ;
		logical compound_to_mat		= false;
		fip_.init_static(	pmt_bus_day, pmt_cal,end_of_month,fix_ccy,
							fix_cpn_freq, fix_day_count,fix_ir_rule,
							fix_pmt_delay,fix_pmt_delay,fix_pmt_delay_prin,
							fix_pmt_delay_prin,fix_avg_not,roll, const_cpn, comp_freq,
							compound_to_mat);

		//----ois_parm--------	
		flt_roll_method ois_roll 	= null;
		flt_comp_avg_type  ois_comp_avg_t 		= null;
		flt_sprd_comp_method  ois_sprd_comp_m 	= null;
		flt_avg_method  ois_avg_m 				= null;
		if(!null(ois_comp_avg)){
			conv_from_avg_comp_method(ois_comp_avg,ois_comp_avg_t,ois_sprd_comp_m,ois_avg_m);
		}
		op_.init_static(pmt_bus_day, pmt_cal,end_of_month,ois_ccy,
								ois_cpn_freq, ois_day_count,
								ois_ir_rule,ois_ir_index,
								ois_comp_avg_t, ois_sprd_comp_m, ois_avg_m,
								ois_pmt_delay,	ois_pmt_delay, ois_pmt_delay_prin, ois_pmt_delay_prin ,
								ois_arr_type, ois_arr_days,ois_endog_df,
								ois_approx_calc,ois_avg_not, ois_roll);		
	}
	/*-----------------------------------------------------------------------
	  __set_plain  <protected>    internal
	  ----------------------------------------------------------------------*/
	void fixois_parm.__set_plain(	bd_convention option(nullable) 	pmt_bus_day,
									calendar option(nullable)		pmt_cal,
									logical	option(nullable) 		end_of_month,
							
									integer 					imp_sprd_dec,
									number option(nullable)		pv01_not_unit,											
									//fix
									string	option(nullable) 	fix_ccy,
									number option(nullable)		fix_cpn_freq_n,
									day_count_method option(nullable) 	fix_day_count,
									interest_rule option(nullable) 		fix_ir_rule,
									number  option(nullable)	fix_notional,
									number  option(nullable)	fix_pmt_delay,
									number  option(nullable)	fix_pmt_delay_prin,
									number	option(nullable)	fix_cpn_rate,
									//ois
									string	option(nullable) 	ois_ccy,
									number option(nullable)		ois_cpn_freq_n,
									day_count_method  option(nullable) 	ois_day_count,
									interest_rule option(nullable) 		ois_ir_rule,
									ir_index option(nullable)	ois_ir_index,
									number  option(nullable)	ois_notional,
									flt_comp_avg_type option(nullable)		ois_comp_avg_t ,
									flt_sprd_comp_method option(nullable)	ois_sprd_comp_m,
									flt_avg_method 	option(nullable)		ois_avg_m,
									rfr_arrears_type  option(nullable)		ois_arr_type,
									number option(nullable) 				ois_arr_days ,
									number  option(nullable)	ois_pmt_delay,
									number  option(nullable)	ois_pmt_delay_prin,
									logical	option(nullable)	ois_endog_df,
									logical option(nullable)	ois_approx_calc,
									number	option(nullable)	ois_spread)
	{
		imp_calc_dec_  	= imp_sprd_dec;//rounding decimals of the implied cpn rate (on decimal value)
		pv01_not_unit_  = null(pv01_not_unit) ? -1: pv01_not_unit;//rounding unit for notional when implied from pv01

		if(null(fix_ccy))
			fix_ccy = fip_.fix_ccy_;

		if(null(ois_ccy))
			ois_ccy = op_.ois_ccy_;
		
		is_ccy_ 		= !equal_casei(fix_ccy, ois_ccy);
		
		fip_.set_plain(pmt_bus_day, pmt_cal, end_of_month, fix_ccy, fix_cpn_freq_n, fix_day_count, fix_ir_rule,
					   fix_pmt_delay,fix_pmt_delay,fix_pmt_delay_prin,fix_pmt_delay_prin,fix_cpn_rate,
					   stub_type.SHORT_FIRST,null,null,null,fix_notional,null);
		
		op_.set_plain(	pmt_bus_day, pmt_cal, end_of_month, ois_ccy, ois_cpn_freq_n, ois_day_count, ois_ir_rule,ois_ir_index,
					    ois_spread, ois_comp_avg_t , ois_sprd_comp_m, ois_avg_m, ois_arr_type, ois_arr_days,
						ois_pmt_delay ,ois_pmt_delay,ois_pmt_delay_prin,ois_pmt_delay_prin,
						ois_endog_df,ois_approx_calc,stub_type.SHORT_FIRST,null,null,null,ois_notional,null,
						null,null,null,false);
	}
	/*-----------------------------------------------------------------------
	  set_plain_single_ccy <ALL ARGS>
	  ----------------------------------------------------------------------*/
	void fixois_parm.set_plain_single_ccy(	string name,											
											date option(nullable) 		trade_date,
											date option(nullable) 		settle_date,
											string option(nullable) 	spot_settle_code,
											date option(nullable) 		start_date,
											string option(nullable)		fwd_start_code,
											date option(nullable) 		maturity,
											string option(nullable) 	maturity_code,
											logical 					pay_fixed,
											bd_convention option(nullable) 	pmt_bus_day,
											calendar option(nullable)	pmt_cal,
											logical	option(nullable) 	end_of_month,
											string	option(nullable) 	ccy,
											integer 					imp_fix_rate_dec,
											number option(nullable)		pv01_not_unit,
											number	option(nullable) 	notional,
											number	option(nullable) 	fix_pv01,
											//fix
											number option(nullable)		fix_cpn_freq_n,
											day_count_method option(nullable) fix_day_count,
											interest_rule option(nullable) fix_ir_rule,
											number	option(nullable)	fix_pmt_delay,
											number	option(nullable)	fix_pmt_delay_prin,
											number	option(nullable)	fix_cpn_rate,
											//ois
											number option(nullable)		ois_cpn_freq_n,
											day_count_method  option(nullable) ois_day_count,
											interest_rule option(nullable) ois_ir_rule,
											ir_index option(nullable)	ois_ir_index,
											avg_comp_method option(nullable) ois_comp_avg,
											//flt_comp_avg_type option(nullable)		ois_comp_avg_t ,
											//flt_sprd_comp_method option(nullable)	ois_sprd_comp_m,
											//flt_avg_method 	option(nullable)		ois_avg_m,
											rfr_arrears_type  option(nullable)		ois_arr_type,
											number option(nullable) 				ois_arr_days ,
											number  option(nullable)	ois_pmt_delay,
											number  option(nullable)	ois_pmt_delay_prin,
											logical	option(nullable)	ois_endog_df,
											logical option(nullable)	ois_approx_calc,											
											number	option(nullable)	ois_spread)
	{
		if(null(notional))
			QL_REQUIRE(!null(fix_pv01),"one of notional and pv01 must be input");
		else if(null(fix_pv01))
			QL_REQUIRE(!null(notional),"one of notional and pv01 must be input");
		else if(!null(notional) && !null(fix_pv01))
			QL_FAIL("ambigious input of notional and pv01");

		flt_comp_avg_type  ois_comp_avg_t 		= null;
		flt_sprd_comp_method  ois_sprd_comp_m 	= null;
		flt_avg_method  ois_avg_m 				= null;
		if(!null(ois_comp_avg)){
			conv_from_avg_comp_method(ois_comp_avg,ois_comp_avg_t,ois_sprd_comp_m,ois_avg_m);
		}
		
		this.__set_plain(pmt_bus_day,pmt_cal,end_of_month,imp_fix_rate_dec,pv01_not_unit,ccy,
						fix_cpn_freq_n,fix_day_count,fix_ir_rule,notional,fix_pmt_delay,fix_pmt_delay_prin,fix_cpn_rate,
						ccy,ois_cpn_freq_n,ois_day_count,ois_ir_rule,ois_ir_index,notional,
						ois_comp_avg_t , ois_sprd_comp_m, ois_avg_m, ois_arr_type, ois_arr_days,
						ois_pmt_delay,ois_pmt_delay_prin,
						ois_endog_df, ois_approx_calc,ois_spread);

		//-----common--------
		name_			= name;
		pay_leg1_		= pay_fixed;
		is_ccy_ 		= false;
		if(!null(spot_settle_code))
			spot_code_ 	= spot_settle_code;
		trade_date_ 	= trade_date;
		fwd_start_code_ = fwd_start_code;
		start_date_ 	= start_date;
		maturity_ 		= maturity;
		if(!null(maturity_code))
			maturity_code_ 	= maturity_code;
		settle_date_	= settle_date;
		//cpn_roll_day_ 	= 0;

		this.start_date_helper();
		this.maturity_helper(fip_);
		this.check();
		//if single ccy set_pv01/set_notional will also set the other notional as well as both fxrates to 1
		if(null(notional))
			this.set_pv01(fix_pv01);
		else
			this.set_notional_fix(notional);
		ne_ = notional_exchg_style.NE_NONE;
		is_inited_ = true;
	}

	/*-----------------------------------------------------------------------
	  set_plain_single_ccy 
	  ----------------------------------------------------------------------*/
	void fixois_parm.set_plain_single_ccy(	string name,											
											date option(nullable) 		trade_date,
											date option(nullable) 		settle_date,										
											date option(nullable) 		start_date,
											string option(nullable)		fwd_start_code,
											date option(nullable) 		maturity,
											string option(nullable) 	maturity_code,
											logical 					pay_fixed,
											integer 					imp_fix_rate_dec,
											number option(nullable)		pv01_not_unit,
											number	option(nullable) 	notional,
											number	option(nullable) 	fix_pv01,
											//fix
											number	option(nullable)	fix_cpn_rate,
											//ois
											number	option(nullable)	ois_spread)
	{
		QL_FAIL_COND(null(is_ccy_),"fixois_parm is not initalized (init_static() must be run) ");
		QL_REQUIRE(!is_ccy_,"function not applicable to cross currency swaps");
		
		if(null(notional))
			QL_REQUIRE(!null(fix_pv01),"one of notional and pv01 must be input");
		else if(null(fix_pv01))
			QL_REQUIRE(!null(notional),"one of notional and pv01 must be input");
		else if(!null(notional) && !null(fix_pv01))
			QL_FAIL("ambigious input of notional and pv01");

		
		this.__set_plain(null,null,null,imp_fix_rate_dec,pv01_not_unit,null,
						null,null,null,notional,null,null,fix_cpn_rate,
						null,null,null,null,null,notional,null,null, null,null,null,
						 null,null, null,null,ois_spread);

		//-----common--------
		name_			= name;
		pay_leg1_		= pay_fixed;
		is_ccy_ 		= false;
		
		trade_date_ 	= trade_date;
		fwd_start_code_ = fwd_start_code;
		start_date_ 	= start_date;
		maturity_ 		= maturity;
		if(!null(maturity_code))
			maturity_code_ 	= maturity_code;
		settle_date_	= settle_date;
		//cpn_roll_day_ 	= 0;

		this.start_date_helper();
		this.maturity_helper(fip_);
		this.check();
		//if single ccy set_pv01/set_notional will also set the other notional as well as both fxrates to 1
		if(null(notional))
			this.set_pv01(fix_pv01);
		else
			this.set_notional_fix(notional);
		ne_ = notional_exchg_style.NE_NONE;
		is_inited_ = true;
	}
	
	/*-----------------------------------------------------------------------
	  set_plain <ALL ARGS>
	  ----------------------------------------------------------------------*/
	void fixois_parm.set_plain(	string name,								
								date option(nullable) 			trade_date,
								date option(nullable) 			settle_date,
								string option(nullable) 		spot_settle_code,
								date option(nullable) 			start_date,
								string option(nullable) 		fwd_start_code,
								date option(nullable)			maturity,
								string option(nullable) 		maturity_code,
								logical 						pay_fixed,
								bd_convention option(nullable)	pmt_bus_day,
								calendar option(nullable)		pmt_cal,
								logical	 option(nullable)		end_of_month,
								notional_exchg_style option(nullable) notional_exchg,
								integer 						imp_fix_rate_dec,
								number option(nullable)			pv01_not_unit,
								number 	option(nullable) 		fx_quote,
								string 	option(nullable) 		fx_quote_baseccy,
								string 	option(nullable) 		fx_quote_priceccy,
								logical option(nullable) 		pv_in_base_ccy,
								//fix
								string	option(nullable)		fix_ccy,
								number	option(nullable)		fix_cpn_freq_n,
								day_count_method option(nullable) fix_day_count,
								interest_rule option(nullable) 	fix_ir_rule ,
								number  option(nullable)		fix_pmt_delay,
								number  option(nullable)		fix_pmt_delay_prin,
								number	option(nullable)		fix_cpn_rate,
								stub_type option(nullable)		fix_stub_type,
								date option(nullable)  			fix_eff_date,
								date option(nullable)  			fix_first_cpn_date,
								date option(nullable)  			fix_last_reg_date,
								number	option(nullable) 		fix_notional,
								number	option(nullable) 		fix_pv01,
								//ois
								string	option(nullable)		ois_ccy,
								number option(nullable)	 		ois_cpn_freq_n,
								day_count_method  option(nullable) ois_day_count,
								interest_rule option(nullable) ois_ir_rule,
								ir_index option(nullable)		ois_ir_index,
								avg_comp_method option(nullable) ois_comp_avg,
											//flt_comp_avg_type option(nullable)		ois_comp_avg_t ,
											//flt_sprd_comp_method option(nullable)	ois_sprd_comp_m,
											//flt_avg_method 	option(nullable)		ois_avg_m,
								rfr_arrears_type  option(nullable)		ois_arr_type,
								number option(nullable) 				ois_arr_days ,
								number  option(nullable)		ois_pmt_delay,
								number  option(nullable)		ois_pmt_delay_prin,
								logical	option(nullable)		ois_endog_df,
								logical option(nullable)		ois_approx_calc,
								number option(nullable) 		ois_spread,
								stub_type option(nullable)		ois_stub_type,
								date option(nullable)  			ois_eff_date,
								date option(nullable)  			ois_first_cpn_date,
								date option(nullable)  			ois_last_reg_date,
								number	option(nullable) 		ois_notional,							
								vector(date) option(nullable) 	ois_fixing_dates ,	
								vector(number) option(nullable) ois_fixing_rates,
								number option(nullable) 		ois_fix_proxy ,
								logical option(nullable) 		ois_allow_fwd_fix)
	{
		if(null(fix_notional) && null(ois_notional))
			QL_REQUIRE(!null(fix_pv01),"one of notionals and fix_pv01 must be input");
		else if(null(fix_pv01))
			QL_REQUIRE(!null(fix_notional) || !null(ois_notional),"one of notionals and fix_pv01 must be input");
		else if(!null(fix_notional) && !null(ois_notional) && !null(fix_pv01))
			QL_FAIL("ambigious input of notionals and fix_pv01");

		if(null(fix_ccy))
			fix_ccy = fip_.fix_ccy_ ;
		
		if(null(ois_ccy))
			ois_ccy = op_.ois_ccy_ ;
		
		number 	fix_fx_mult, ois_fx_mult;
		set_fx_input(fix_ccy,ois_ccy, fx_quote, fx_quote_baseccy, fx_quote_priceccy, pv_in_base_ccy, fix_notional,ois_notional,fix_fx_mult, ois_fx_mult);
		
		//----fix_parm-----
		number  fix_mat_pmt_delay = fix_pmt_delay;		
		number  fix_mat_pmt_delay_prin= fix_pmt_delay_prin;
		fip_.set_plain(	pmt_bus_day, pmt_cal, end_of_month, fix_ccy, fix_cpn_freq_n, fix_day_count, fix_ir_rule ,
						fix_pmt_delay,fix_mat_pmt_delay,fix_pmt_delay_prin,fix_mat_pmt_delay_prin,fix_cpn_rate, fix_stub_type,fix_eff_date, fix_first_cpn_date,
						fix_last_reg_date, fix_notional, fix_fx_mult);		
		
		//----ois_parm--------
		flt_comp_avg_type  ois_comp_avg_t 		= null;
		flt_sprd_comp_method  ois_sprd_comp_m 	= null;
		flt_avg_method  ois_avg_m 				= null;
		if(!null(ois_comp_avg)){
			conv_from_avg_comp_method(ois_comp_avg,ois_comp_avg_t,ois_sprd_comp_m,ois_avg_m);
		}
		number  ois_mat_pmt_delay = ois_pmt_delay;		
		number  ois_mat_pmt_delay_prin= ois_pmt_delay_prin;
		op_.set_plain(	pmt_bus_day,pmt_cal,end_of_month,ois_ccy,ois_cpn_freq_n,
						ois_day_count, ois_ir_rule,ois_ir_index, ois_spread,
						ois_comp_avg_t , ois_sprd_comp_m, ois_avg_m, ois_arr_type, ois_arr_days ,
						ois_pmt_delay,ois_mat_pmt_delay,ois_pmt_delay_prin,ois_mat_pmt_delay_prin,
						ois_endog_df,ois_approx_calc,ois_stub_type,ois_eff_date, ois_first_cpn_date,
						ois_last_reg_date, ois_notional, ois_fx_mult, ois_fixing_dates , ois_fixing_rates,
						ois_fix_proxy , ois_allow_fwd_fix);
		
		//---common---
		name_			= name;
		imp_calc_dec_  	= imp_fix_rate_dec;//rounding decimals of the implied cpn rate (on decimal value)
		pv01_not_unit_  = null(pv01_not_unit) ? -1: pv01_not_unit;//rounding unit for notional when implied from pv01
		pay_leg1_		= pay_fixed;
		
		if(null(notional_exchg)) {
			if(null(ne_))
				ne_ = is_ccy_ ? notional_exchg_style.NE_BOTH : notional_exchg_style.NE_NONE;
		}
		else {
			ne_ = notional_exchg;
		}

		if(!null(spot_settle_code))
			spot_code_ 	= spot_settle_code;
		trade_date_ 	= trade_date;
		fwd_start_code_ = fwd_start_code;
		start_date_ 	= start_date;
		maturity_ 		= maturity;
		if(!null(maturity_code))
			maturity_code_ 	= maturity_code;	
		settle_date_	= settle_date;
		//cpn_roll_day_ 	= 0;

		this.start_date_helper();
		this.maturity_helper(fip_);
		this.schedule_helper(fip_);
		this.schedule_helper(op_);
		this.check();	
		//if single ccy set_pv01/set_notional will also set the other notional as well as both fxrates to 1
		if(null(fix_notional) && null(ois_notional))
			this.set_pv01(fix_pv01);
		else if(!null(fix_notional)){
			this.set_notional_fix(fix_notional);
		}
		else if(!null(ois_notional)){
			this.set_notional_ois(ois_notional);
		}
		
		is_inited_ = true;
	}
	/*-----------------------------------------------------------------------
	  set_plain 
	  ----------------------------------------------------------------------*/
	void fixois_parm.set_plain(	string name,								
								date option(nullable) 			trade_date,
								date option(nullable) 			settle_date,
								
								date option(nullable) 			start_date,
								string option(nullable) 		fwd_start_code,
								date option(nullable)			maturity,
								string option(nullable) 		maturity_code,
								logical 						pay_fixed,
								integer 						imp_fix_rate_dec,
								number option(nullable)			pv01_not_unit,
								number 	option(nullable) 		fx_quote,
								string 	option(nullable) 		fx_quote_baseccy,
								string 	option(nullable) 		fx_quote_priceccy,
								logical option(nullable) 		pv_in_base_ccy,
								//fix
								number	option(nullable)		fix_cpn_rate,
								stub_type option(nullable)		fix_stub_type,
								date option(nullable)  			fix_eff_date,
								date option(nullable)  			fix_first_cpn_date,
								date option(nullable)  			fix_last_reg_date,
								number	option(nullable) 		fix_notional,
								number	option(nullable) 		fix_pv01,
								//ois
								number option(nullable) 		ois_spread,
								stub_type option(nullable)		ois_stub_type,
								date option(nullable)  			ois_eff_date,
								date option(nullable)  			ois_first_cpn_date,
								date option(nullable)  			ois_last_reg_date,
								number	option(nullable) 		ois_notional,							
								vector(date) option(nullable) 	ois_fixing_dates ,	
								vector(number) option(nullable) ois_fixing_rates,
								number option(nullable) 		ois_fix_proxy ,
								logical option(nullable) 		ois_allow_fwd_fix)
	{
		QL_FAIL_COND(null(is_ccy_),"fixois_parm is not initalized (init_static() must be run) ");
		
		if(null(fix_notional) && null(ois_notional))
			QL_REQUIRE(!null(fix_pv01),"one of notionals and fix_pv01 must be input");
		else if(null(fix_pv01))
			QL_REQUIRE(!null(fix_notional) || !null(ois_notional),"one of notionals and fix_pv01 must be input");
		else if(!null(fix_notional) && !null(ois_notional) && !null(fix_pv01))
			QL_FAIL("ambigious input of notionals and fix_pv01");
		
		number 	fix_fx_mult, ois_fx_mult;
		set_fx_input(fip_.fix_ccy_,op_.ois_ccy_, fx_quote, fx_quote_baseccy, fx_quote_priceccy, pv_in_base_ccy, fix_notional,ois_notional,fix_fx_mult, ois_fx_mult);
		
		//----fix_parm-----
		fip_.set_plain(	null, null, null, null, null, null, null ,null,null,null,null,
						fix_cpn_rate, fix_stub_type,fix_eff_date, fix_first_cpn_date, fix_last_reg_date, fix_notional,
						fix_fx_mult);		
		
		//----ois_parm--------
		op_.set_plain(	null,null,null,null,null, null, null, null,ois_spread,null,null, null, null, null,
						null,null,null,null, null,null,ois_stub_type,ois_eff_date, ois_first_cpn_date,
						ois_last_reg_date, ois_notional, ois_fx_mult, ois_fixing_dates , ois_fixing_rates,
						ois_fix_proxy , ois_allow_fwd_fix);
		
		//---common---
		name_			= name;
		imp_calc_dec_  	= imp_fix_rate_dec;//rounding decimals of the implied cpn rate (on decimal value)
		pv01_not_unit_  = null(pv01_not_unit) ? -1: pv01_not_unit;//rounding unit for notional when implied from pv01
		pay_leg1_		= pay_fixed;

		
		trade_date_ 	= trade_date;
		fwd_start_code_ = fwd_start_code;
		start_date_ 	= start_date;
		maturity_ 		= maturity;
		if(!null(maturity_code))
			maturity_code_ 	= maturity_code;	
		settle_date_	= settle_date;
		//cpn_roll_day_ 	= 0;

		this.start_date_helper();
		this.maturity_helper(fip_);
		this.schedule_helper(fip_);
		this.schedule_helper(op_);
		this.check();		
		//if single ccy set_pv01/set_notional will also set the other notional as well as both fxrates to 1
		if(null(fix_notional) && null(ois_notional))
			this.set_pv01(fix_pv01);
		else if(!null(fix_notional)){
			this.set_notional_fix(fix_notional);
		}
		else if(!null(ois_notional)){
			this.set_notional_ois(ois_notional);
		}
		
		is_inited_ = true;
	}
	/*-----------------------------------------------------------------------
	  set_plain_amort_single_curr <ALL ARGS>
	  ----------------------------------------------------------------------*/
	void fixois_parm.set_plain_amort_single_curr(string name,												
												date option(nullable) 			trade_date,
												date option(nullable) 			settle_date,
												string option(nullable) 		spot_settle_code,
												date option(nullable) 			start_date,
												 string option(nullable) 		fwd_start_code,
												date option(nullable)			maturity,
												string option(nullable) 		maturity_code,
												logical 						pay_fixed,
												bd_convention option(nullable)	pmt_bus_day,
												calendar option(nullable)		pmt_cal,
												logical	 option(nullable)		end_of_month,
												notional_exchg_style option(nullable) notional_exchg,
												integer 						imp_fix_rate_dec,
												number option(nullable)			pv01_not_unit,
												string	 						ccy,
												number	 						notional,
												//fix
												number	option(nullable)		fix_cpn_freq_n,
												day_count_method option(nullable) fix_day_count,
												interest_rule option(nullable) 	fix_ir_rule ,
												number  option(nullable)		fix_pmt_delay,
												number  option(nullable)		fix_pmt_delay_prin,
												number	option(nullable)		fix_cpn_rate,
												stub_type option(nullable)		fix_stub_type,
												date option(nullable)  			fix_eff_date,
												date option(nullable)  			fix_first_cpn_date,
												date option(nullable)  			fix_last_reg_date,
												sink_fund_style option(nullable)  fix_sink_fund_style,
												vector(date)  option(nullable)  fix_sink_fund_dates,
												vector(number)  option(nullable)  fix_sink_fund,
												//number	option(nullable) 	fix_pv01,
												//ois
												number option(nullable)	 		ois_cpn_freq_n,
												day_count_method  option(nullable) ois_day_count,
												interest_rule option(nullable) 	ois_ir_rule,
												ir_index option(nullable)		ois_ir_index,
												number  option(nullable)		ois_pmt_delay,
												number  option(nullable)		ois_pmt_delay_prin,
												logical	option(nullable)		ois_endog_df,
												logical option(nullable)		ois_approx_calc,
												number option(nullable) 		ois_spread,
												stub_type option(nullable)		ois_stub_type,
												date option(nullable)  			ois_eff_date,
												date option(nullable)  			ois_first_cpn_date,
												date option(nullable)  			ois_last_reg_date,
												sink_fund_style option(nullable) ois_sink_fund_style ,
												vector(date) option(nullable) 	ois_sink_fund_dates ,
												vector(number) option(nullable) ois_sink_fund,							
												vector(date) option(nullable) 	ois_fixing_dates ,	
												vector(number) option(nullable) ois_fixing_rates,
												number option(nullable) 		ois_fix_proxy ,
												logical option(nullable) 		ois_allow_fwd_fix)
	{
	
		QL_FAIL_COND(null(fix_sink_fund_style) && null(ois_sink_fund_style),"invalid sinkfund style (this function is for single currency amortizing swaps only)");
		QL_FAIL_COND(null(fix_sink_fund_dates) && null(ois_sink_fund_dates),"invalid sinkfund dates (this function is for single currency amortizing swaps only)");
		QL_FAIL_COND(null(fix_sink_fund) && null(ois_sink_fund),"invalid sinkfund (this function is for single currency amortizing swaps only)");
		
		//----fix_parm-----
		number  fix_mat_pmt_delay = fix_pmt_delay;		
		number  fix_mat_pmt_delay_prin= fix_pmt_delay_prin;
		fip_.set_plain_amort(	pmt_bus_day,pmt_cal,end_of_month,ccy,notional,	null,fix_cpn_freq_n,fix_day_count,fix_ir_rule ,
								fix_pmt_delay,fix_mat_pmt_delay,fix_pmt_delay_prin,fix_mat_pmt_delay_prin,
								fix_cpn_rate,fix_stub_type,fix_eff_date,fix_first_cpn_date,fix_last_reg_date,fix_sink_fund_style,
								fix_sink_fund_dates, fix_sink_fund,1);
				
		//----ois_parm--------
		number  ois_mat_pmt_delay = ois_pmt_delay;		
		number  ois_mat_pmt_delay_prin= ois_pmt_delay_prin;
		
		QL_FAIL_COND(!null(ois_sink_fund_style),"amortizing ois leg is work in progress");
		op_.set_plain(	pmt_bus_day,pmt_cal,end_of_month,ccy,ois_cpn_freq_n,
						ois_day_count, ois_ir_rule,ois_ir_index, ois_spread,
						null,null, null, null, null,
						ois_pmt_delay,ois_mat_pmt_delay,ois_pmt_delay_prin,ois_mat_pmt_delay_prin,
						ois_endog_df,ois_approx_calc,ois_stub_type,ois_eff_date, ois_first_cpn_date,
						ois_last_reg_date, notional, 1, ois_fixing_dates , ois_fixing_rates,
						ois_fix_proxy , ois_allow_fwd_fix);//sink fund currently missing
		
		//---common---
		name_			= name;
		imp_calc_dec_  	= imp_fix_rate_dec;//rounding decimals of the implied cpn rate (on decimal value)
		pv01_not_unit_  = null(pv01_not_unit) ? -1: pv01_not_unit;//rounding unit for notional when implied from pv01
		pay_leg1_		= pay_fixed;
		is_ccy_ 		= false;
		
		if(null(notional_exchg)) {
			if(null(ne_))
				ne_ = is_ccy_ ? notional_exchg_style.NE_BOTH : notional_exchg_style.NE_NONE;
		}
		else {
			ne_ = notional_exchg;
		}

		if(!null(spot_settle_code))
			spot_code_ 	= spot_settle_code;
		trade_date_ 	= trade_date;
		fwd_start_code_ = fwd_start_code;
		start_date_ 	= start_date;
		maturity_ 		= maturity;
		if(!null(maturity_code))
			maturity_code_ 	= maturity_code;
		settle_date_	= settle_date;
		//cpn_roll_day_ 	= 0;

		this.start_date_helper();
		this.maturity_helper(fip_);
		this.schedule_helper(fip_);
		this.schedule_helper(op_);
		this.check();		
		this.set_notional_fix(notional);
		
		is_inited_ = true;
	}
	/*-----------------------------------------------------------------------
	  set_plain_amort_single_curr 
	  ----------------------------------------------------------------------*/
	void fixois_parm.set_plain_amort_single_curr(string name,												
												date option(nullable) 			trade_date,
												date option(nullable) 			settle_date,
												
												date option(nullable) 			start_date,
												 string option(nullable) 		fwd_start_code,
												date option(nullable)			maturity,
												string option(nullable) 		maturity_code,
												logical 						pay_fixed,
												integer 						imp_fix_rate_dec,
												number option(nullable)			pv01_not_unit,
												number	 						notional,
												//fix
												number	option(nullable)		fix_cpn_rate,
												stub_type option(nullable)		fix_stub_type,
												date option(nullable)  			fix_eff_date,
												date option(nullable)  			fix_first_cpn_date,
												date option(nullable)  			fix_last_reg_date,
												sink_fund_style option(nullable)  fix_sink_fund_style,
												vector(date)  option(nullable)  fix_sink_fund_dates,
												vector(number)  option(nullable)  fix_sink_fund,
												//number	option(nullable) 	fix_pv01,
												//ois
												number option(nullable) 		ois_spread,
												stub_type option(nullable)		ois_stub_type,
												date option(nullable)  			ois_eff_date,
												date option(nullable)  			ois_first_cpn_date,
												date option(nullable)  			ois_last_reg_date,
												sink_fund_style option(nullable) ois_sink_fund_style ,
												vector(date) option(nullable) 	ois_sink_fund_dates ,
												vector(number) option(nullable) ois_sink_fund,							
												vector(date) option(nullable) 	ois_fixing_dates ,	
												vector(number) option(nullable) ois_fixing_rates,
												number option(nullable) 		ois_fix_proxy ,
												logical option(nullable) 		ois_allow_fwd_fix)
	{
		QL_FAIL_COND(null(is_ccy_),"fixois_parm is not initalized (init_static() must be run) ");
		
		QL_FAIL_COND(null(fix_sink_fund_style) && null(ois_sink_fund_style),"invalid sinkfund style (this function is for single currency amortizing swaps only)");
		QL_FAIL_COND(null(fix_sink_fund_dates) && null(ois_sink_fund_dates),"invalid sinkfund dates (this function is for single currency amortizing swaps only)");
		QL_FAIL_COND(null(fix_sink_fund) && null(ois_sink_fund),"invalid sinkfund (this function is for single currency amortizing swaps only)");
		
		//----fix_parm-----
		fip_.set_plain_amort(	null,null,null,null,notional,null,null,null,null ,
								null,null,null,null,fix_cpn_rate,fix_stub_type,fix_eff_date,fix_first_cpn_date,fix_last_reg_date,fix_sink_fund_style,
								fix_sink_fund_dates, fix_sink_fund,1);
				
		//----ois_parm--------	
		QL_FAIL_COND(!null(ois_sink_fund_style),"amortizing ois leg is work in progress");
		op_.set_plain(	null,null,null,null,null, null, null, null,ois_spread,
						null,null, null, null, null,
						null,null,null,null, null,null,ois_stub_type,ois_eff_date, ois_first_cpn_date,
						ois_last_reg_date, notional, 1, ois_fixing_dates , ois_fixing_rates,
						ois_fix_proxy , ois_allow_fwd_fix);//sink fund currently missing
		
		//---common---
		name_			= name;
		imp_calc_dec_  	= imp_fix_rate_dec;//rounding decimals of the implied cpn rate (on decimal value)
		pv01_not_unit_  = null(pv01_not_unit) ? -1: pv01_not_unit;//rounding unit for notional when implied from pv01
		pay_leg1_		= pay_fixed;
		
	
		trade_date_ 	= trade_date;
		fwd_start_code_ = fwd_start_code;
		start_date_ 	= start_date;
		maturity_ 		= maturity;
		if(!null(maturity_code))
			maturity_code_ 	= maturity_code;
		settle_date_	= settle_date;
		//cpn_roll_day_ 	= 0;

		this.start_date_helper();
		this.maturity_helper(fip_);
		this.schedule_helper(fip_);
		this.schedule_helper(op_);
		this.check();		
		this.set_notional_fix(notional);
		
		is_inited_ = true;
	}
	/*-----------------------------------------------------------------------
	  create_swap
	  ----------------------------------------------------------------------*/	
	swap_fixois fixois_parm.create_swap(disc_func option(nullable) 	fix_disc_func,
										disc_func option(nullable) 	ois_disc_func,
										fwd_func option(nullable) 	ois_fwd_func,
										disc_func option(nullable) 	ois_fwd_disc_func,
										logical sync_endog_ok )
	{
		logical rev_leg_prio 	= true ;

		disc_func 	odf,ofdf, dfr;
		fwd_func 	of;							
		op_.ois_df_helper( ois_disc_func,ois_fwd_func,ois_fwd_disc_func,
							fix_disc_func,
							is_cross_currency(), rev_leg_prio, sync_endog_ok,
							trade_date_,
							maturity_,
							odf,of,ofdf,dfr);
		
		return __create_swap( fix_disc_func, odf, of, ofdf);
	}

	/*-----------------------------------------------------------------------
	  __create_swap <protected>
	  ----------------------------------------------------------------------*/	
	swap_fixois fixois_parm.__create_swap(disc_func option(nullable) fix_disc_func,
											disc_func option(nullable) ois_disc_func,
											fwd_func option(nullable) 	ois_fwd_func,
											disc_func option(nullable) 	ois_fwd_disc_func )
	{
		//string err_msg;
		//logical ok = this.ois_df_check(fix_disc_func,ois_disc_func, ois_fwd_func, ois_fwd_disc_func, err_msg);			
		//QL_REQUIRE(ok,err_msg);
		
		//QL_FAIL_COND(!null(ois_fwd_func) && !null(ois_fwd_disc_func),"ambigious input (fwd_func/disc_func)");//already checked?

		if(!is_ccy_ ){
			if(!null(fix_disc_func))
				ois_disc_func = fix_disc_func;
			else if(!null(ois_disc_func))
				fix_disc_func = ois_disc_func;
		}
		tenor_surface ois_tenor_surface;
		create_ois_surface(op_,null, ois_fwd_func, ois_fwd_disc_func, fix_disc_func, ois_disc_func, ois_tenor_surface);
		
		ql_swap_fix_def fix_def 	= this.create_swap_fix_def(fip_,"fix_def");
		QL_FAIL_COND(null(fix_def),"error creating fixed leg def");
		ql_swap_ois_def ois_def 	= this.create_swap_ois_def(op_,"ois_def");
		QL_FAIL_COND(null(ois_def),"error creating ois leg def");
		
		ql_fix_leg fix 				= this.create_swap_fix_leg(fip_,fix_def, "fix_leg",pay_leg1_, fix_disc_func);
		QL_FAIL_COND(null(fix),"error creating fix leg");
		ql_ois_leg ois 				= this.create_swap_ois_leg(op_,ois_def, "ois_leg",!pay_leg1_, ois_disc_func, ois_tenor_surface);		
		QL_FAIL_COND(null(ois),"error creating ois leg");
		
		ql_fixed_income_swap sw 	= ql_fixed_income_swap(fix,ois,name_);
		QL_FAIL_COND(null(sw),"error creating swap");
		
		//if(!null(op_.ois_curr_fix_))
			//sw.float_leg(false).set_current_fixing(fp_.flt_curr_fix_);
		
		if(null(fip_.fix_coupon_rate_)) {
			number fix_r	= sw.solver(0,swap_solver_code.SS_FIX_RATE_LEG1,false);
			QL_FAIL_COND(null(fix_r),"error calculating implied fixed coupon rate", E_INIT);

			if(imp_calc_dec_ >= 0)
				fix_r = round(fix_r,imp_calc_dec_);
				
			fip_.fix_coupon_rate_ = fix_r;						
			fix 	= this.create_swap_fix_leg(fip_,fix_def, "fix_leg",pay_leg1_, fix_disc_func);
			QL_FAIL_COND(null(fix),"error creating fixed leg");
			sw 		= ql_fixed_income_swap(fix,ois,name_);
			QL_FAIL_COND(null(sw),"error creating swap");
		}

		error_info ee 	= new error_info(true,true);
		swap_fixois swff = swap_fixois(sw, ee);

		if(!null(leg_pv01_)) {
			
			number pv01_1m 	= swff.pv01(1000000,null,null,ee);//keep 1000000 as notional because this is the default notional when notional is not input (not really necessary) 
			number fix_not 	= abs(leg_pv01_)/pv01_1m*1000000;

			if(pv01_not_unit_>0){
				number a = fix_not/pv01_not_unit_;
				a = round(a,0);
				fix_not = a * pv01_not_unit_;
			}
			//update parm with new notional
			fip_.fix_notional_ = fix_not;
			op_.ois_notional_ = null;
			fx_notional_helper();

			//update the newly created swap with new notional
			if(swff.is_cross_currency(ee)){
				swff.add_notional(fip_.fix_notional_,op_.ois_notional_);				
			}
			else {
				swff.add_notional(fix_not);
			}
		}
		return swff;
	}
}