option(null: hard);	

/*	
	swaplib wrapper functions
	Developer: Algorithmica Research, Magnus Nyström

	--------------------------------------------------------------------
	 	swap help functions for create funcs
	--------------------------------------------------------------------			
*/
module CORE_SWAPLIB
{
	/*-----------------------------------------------------------------------
	 -----------------------------------------------------------------------
	 -----class fix_parm--------------------------------------------------
	 -----------------------------------------------------------------------
	 -----------------------------------------------------------------------*/
	class fix_parm
	{
	public:
		fix_parm();
		
		void	init_def_parm( 	string option(nullable) ,coupon_freq option(nullable) ,day_count_method option(nullable) ,fix_roll_method option(nullable) ,
								bd_convention option(nullable) ,calendar option(nullable)  ,logical option(nullable) ,logical option(nullable)  ,
								fix_comp_freq option(nullable)  ,round_code option(nullable)  ,logical option(nullable)  ,logical option(nullable) ,
								interest_rule option(nullable) ,number option(nullable) ,number option(nullable) ,number option(nullable),number option(nullable),
								logical option(nullable) ,logical option(nullable) );

		void	init_leg_parm(	number option(nullable) ,stub_type option(nullable) ,date option(nullable)  ,date option(nullable) ,date option(nullable) ,
								number option(nullable)  ,number option(nullable)  ,sink_fund_style  option(nullable) ,vector(date)  option(nullable) ,
								vector(number)  option(nullable) );
		
		void 	init_static(bd_convention,calendar ,logical,string,integer ,day_count_method ,interest_rule,
							number option(nullable),number option(nullable),number option(nullable),number option(nullable),
							logical  option(nullable),fix_roll_method	option(nullable) ,
							logical option(nullable)  ,		
							..fix_comp_freq  option(nullable)  ,
							logical option(nullable)  );
		void 	init_static(instr_def);
		void 	init_basic_static_leg2(instr_def);
		void 	basic_static_null_check(out bd_convention ,out calendar,out logical ,out string	,number option(nullable) ,
										out coupon_freq , out day_count_method ,out interest_rule,out number,out number,
										out number,out number,out logical  );
		
		ql_swap_fix_def create_swap_fix_def(string name, date_code ,notional_exchg_style);
		ql_fix_leg 		create_swap_fix_leg(ql_swap_fix_def,string ,logical,disc_func option(nullable),													
											date option(nullable) ,date option(nullable) ,date option(nullable) ,date option(nullable)  ,
											tenor_code option(nullable)  );
	
		//void 	set_plain_vanilla();

		void	set_plain(	bd_convention option(nullable) 	fix_pmt_bus_day,
							calendar option(nullable)		fix_pmt_cal,
							logical	option(nullable) 		fix_end_of_month,
							string	option(nullable) 		fix_ccy,											
							number option(nullable)			fix_cpn_freq_n,
							day_count_method option(nullable) fix_day_count,
							interest_rule option(nullable) 	fix_ir_rule,
							number  option(nullable) 		fix_pmt_delay,
							number  option(nullable) 		fix_mat_pmt_delay,
							number  option(nullable) 		fix_pmt_delay_prin,
							number  option(nullable) 		fix_mat_pmt_delay_prin,
							number	option(nullable)		fix_cpn_rate );

		void	set_plain(	bd_convention option(nullable)	fix_pmt_bus_day,
							calendar option(nullable)		fix_pmt_cal,
							logical	 option(nullable)		fix_end_of_month,
							string	 option(nullable)		fix_ccy,
							number	option(nullable)		fix_cpn_freq_n,
							day_count_method option(nullable) fix_day_count,
							interest_rule option(nullable) 	fix_ir_rule ,
							number  option(nullable) 		fix_pmt_delay,
							number  option(nullable) 		fix_mat_pmt_delay,
							number  option(nullable) 		fix_pmt_delay_prin,
							number  option(nullable) 		fix_mat_pmt_delay_prin,
							number	option(nullable)		fix_cpn_rate,
							stub_type option(nullable) 		fix_stub_type,
							date option(nullable)  			fix_eff_date,
							date option(nullable)  			fix_first_cpn_date,
							date option(nullable)  			fix_last_reg_date,
							number	option(nullable) 		fix_notional,							
							number	option(nullable)		fix_fx_mult);
		
		void 	set_plain_amort(bd_convention option(nullable)		fix_pmt_bus_day,
								calendar option(nullable)			fix_pmt_cal,
								logical	 option(nullable)			fix_end_of_month,																						
								string	 option(nullable)			fix_ccy,
								number	 							fix_notional,
								logical	option(nullable),
								number	option(nullable)			fix_cpn_freq_n,
								day_count_method option(nullable) 	fix_day_count,
								interest_rule option(nullable) 		fix_ir_rule ,
								number  option(nullable) 			fix_pmt_delay,
								number  option(nullable) 			fix_mat_pmt_delay,
								number  option(nullable) 			fix_pmt_delay_prin,
								number  option(nullable) 			fix_mat_pmt_delay_prin,
								number	option(nullable)			fix_cpn_rate,
								stub_type option(nullable) 			fix_stub_type,
								date option(nullable)  				fix_eff_date,
								date option(nullable)  				fix_first_cpn_date,
								date option(nullable)  				fix_last_reg_date,
								sink_fund_style option(nullable)  	fix_sink_fund_style,
								vector(date)  option(nullable)  	fix_sink_fund_dates,
								vector(number)  option(nullable)  	fix_sink_fund,
								number	option(nullable)			fix_fx_mult);

		bd_convention 		fix_pmt_bus_day_mat();
		
		//---def---
		coupon_freq  		fix_cpn_freq_;
		string 				fix_ccy_;
		calendar 			fix_pmt_calendar_;
		bd_convention 		fix_pmt_bus_day_;
		logical				fix_end_of_month_;
		day_count_method 	fix_dc_;		
		fix_roll_method 	fix_roll_;
		logical 			fix_const_cpn_;
		fix_comp_freq 		fix_comp_freq_;
		round_code 			fix_pv_round_code_;
		logical 			fix_start_stub_decomp_;
		logical 			fix_end_stub_decomp_;
		interest_rule 		fix_ir_rule_;
		number 				fix_pmt_delay_;
		number 				fix_mat_pmt_delay_;
		number 				fix_pmt_delay_prin_;
		number 				fix_mat_pmt_delay_prin_;
		logical 			fix_average_notional_;
		logical 			fix_compound_to_mat_;

		//---leg---
		stub_type			fix_stub_type_;
		date 				fix_eff_date_;		
		date 				fix_first_cpn_date_;
		date 				fix_last_reg_date_;
		number 				fix_coupon_rate_;
		number 				fix_notional_;
		number				fix_fx_mult_;
		sink_fund_style 	fix_sink_fund_style_;
		vector(date) 		fix_sink_fund_dates_;
		vector(number) 		fix_sink_fund_;

		integer				fix_roll_day_;
	};

	/*-----------------------------------------------------------------------
	  fix_parm constructor
	  ----------------------------------------------------------------------*/
	fix_parm.fix_parm():fix_cpn_freq_(null),
						fix_ccy_(null),
						fix_pmt_calendar_(null),
						fix_pmt_bus_day_(null),
						fix_end_of_month_(null),
						fix_dc_(null),		
						fix_roll_(null),
						fix_const_cpn_(null),
						fix_comp_freq_(null),
						fix_pv_round_code_(null),
						fix_start_stub_decomp_(null),
						fix_end_stub_decomp_(null),
						fix_ir_rule_(null),
						fix_pmt_delay_(null),
						fix_mat_pmt_delay_(null),
						fix_pmt_delay_prin_(null),
						fix_mat_pmt_delay_prin_(null),
						fix_average_notional_(null),
						fix_compound_to_mat_(null),
						fix_stub_type_(null),
						fix_eff_date_(null),		
						fix_first_cpn_date_(null),
						fix_last_reg_date_(null),
						fix_coupon_rate_(null),
						fix_notional_(null),
						fix_fx_mult_(null),
						fix_sink_fund_style_(null),
						fix_sink_fund_dates_(null),
						fix_sink_fund_(null),
						fix_roll_day_(0)
	{}

	
	bd_convention 		fix_parm.fix_pmt_bus_day_mat() { return fix_pmt_bus_day_;}
	/*-----------------------------------------------------------------------
	  create_swap_fix_def
	  //settle_code/ne args are here because they are parameters for the whole swap and not for the leg 
	  ----------------------------------------------------------------------*/
	ql_swap_fix_def fix_parm.create_swap_fix_def(	string 					name,
													date_code 				settle_code,
													notional_exchg_style 	ne )
	{		
		return ql_swap_fix_def(name,fix_ccy_, settle_code, fix_cpn_freq_, fix_dc_,fix_roll_, fix_pmt_bus_day_, fix_pmt_calendar_,
							   fix_end_of_month_, fix_const_cpn_, fix_comp_freq_, null<quote_style>, fix_pv_round_code_,
							   fix_start_stub_decomp_,fix_end_stub_decomp_,fix_ir_rule_,
							   fix_pmt_delay_,fix_mat_pmt_delay_,fix_pmt_delay_prin_,fix_mat_pmt_delay_prin_,
							   ne,fix_average_notional_,fix_compound_to_mat_);
		
	}
	/*-----------------------------------------------------------------------
	  create_swap_fix_leg
	  ----------------------------------------------------------------------*/
	ql_fix_leg fix_parm.create_swap_fix_leg(ql_swap_fix_def fix_def,
											string name,
											logical pay,
											disc_func option(nullable) fix_disc_func,											
											date option(nullable) trade_date,
											date option(nullable) settle_date,
											date option(nullable) start_date,
											date option(nullable) maturity ,
											tenor_code option(nullable) mat_code/*,
											integer cpn_roll_day*/)
	{
		return ql_fix_leg(	fix_def,name,trade_date,settle_date,start_date,maturity,mat_code,
							pay,fix_notional_,fix_eff_date_,fix_first_cpn_date_,fix_last_reg_date_,
							null(fix_coupon_rate_) ? 0 : fix_coupon_rate_,
							fix_disc_func, fix_roll_day_,fix_fx_mult_,fix_sink_fund_style_,
							fix_sink_fund_dates_,fix_sink_fund_ );
	}
	/*-----------------------------------------------------------------------
	  init_def_parm
	  ----------------------------------------------------------------------*/
	void fix_parm.init_def_parm( string option(nullable) ccy,
								coupon_freq option(nullable)  cpn_freq,
								day_count_method option(nullable)  dc,
								fix_roll_method option(nullable)  roll,
								bd_convention option(nullable)  pmt_bus_day,
								calendar option(nullable)  pmt_calendar,
								logical option(nullable)  end_of_month,
								logical option(nullable)  const_cpn,
								..fix_comp_freq option(nullable)  comp_freq,
								round_code option(nullable)  pv_round_code,
								logical option(nullable)  start_stub_decomp,
								logical option(nullable)  end_stub_decomp,
								interest_rule option(nullable)  ir_rule,
								number option(nullable)  pmt_delay,
								 number option(nullable)  mat_pmt_delay,
								number option(nullable)  pmt_delay_prin,
								number option(nullable)  mat_pmt_delay_prin,
								logical option(nullable)  average_notional,
								logical option(nullable)  compound_to_mat)
	{
		fix_ccy_ 			= ccy;
		fix_cpn_freq_ 		= cpn_freq;
		fix_dc_ 			= dc;
		fix_roll_ 			= roll;
		fix_pmt_calendar_ 	= pmt_calendar;
		fix_pmt_bus_day_ 	= pmt_bus_day;
		fix_end_of_month_ 	= end_of_month;
		fix_const_cpn_ 		= const_cpn;
		fix_comp_freq_ 		= comp_freq;
		fix_pv_round_code_ 	= pv_round_code;
		fix_start_stub_decomp_ = start_stub_decomp;
		fix_end_stub_decomp_ = end_stub_decomp;
		fix_ir_rule_ 		= ir_rule;
		fix_pmt_delay_ 			= pmt_delay;
		fix_mat_pmt_delay_ 		= mat_pmt_delay;
		fix_pmt_delay_prin_ 	= pmt_delay_prin;
		fix_mat_pmt_delay_prin_ = mat_pmt_delay_prin;
		fix_average_notional_ = average_notional;
		fix_compound_to_mat_ = compound_to_mat;
	}
	/*-----------------------------------------------------------------------
	  init_leg_parm
	  ----------------------------------------------------------------------*/
	void fix_parm.init_leg_parm(number option(nullable)  	notional,
								stub_type option(nullable) 	stub_type,
								date option(nullable)  		eff_date,
								date option(nullable)  		first_cpn_date,
								date option(nullable)  		last_reg_date,
								number option(nullable)  	coupon_rate,								
								number option(nullable)  	fx_mult,
								sink_fund_style option(nullable) 	sink_fund_style,
								vector(date)  option(nullable) 		sink_fund_dates,
								vector(number)  option(nullable) 	sink_fund)
	{
		fix_notional_ 		= notional;
		fix_stub_type_		= stub_type;
		fix_eff_date_ 		= eff_date;		
		fix_first_cpn_date_ = first_cpn_date;
		fix_last_reg_date_ 	= last_reg_date;
		fix_coupon_rate_ 	= coupon_rate;		
		fix_fx_mult_ 		= fx_mult;			
		fix_sink_fund_style_ = sink_fund_style;
		fix_sink_fund_dates_ = sink_fund_dates;
		fix_sink_fund_ 		= sink_fund;
		fix_roll_day_		= 0;
	}
	/*-----------------------------------------------------------------------
	  init_basic_static
	  Note: no leg name in instr_def member -->
	  for fixflt/fixois swaps --> fixleg == leg1 
	  for fltflt2s --> the fix leg, leg1/leg2 is reserved for the float legs
	  for fixfix --> use leg2 for 2nd leg
	  ----------------------------------------------------------------------*/
	void fix_parm.init_static(instr_def  def)
	{
		error_info ee = new error_info(true,true);

		fix_roll_method	roll		= fix_roll_method.FIR_STRAIGHT;
		logical const_cpn 			= false;		
		..fix_comp_freq  comp_freq 	= null;
		round_code  pv_round_code 	= null;
		logical start_stub_decomp 	= null;
		logical  end_stub_decomp 	= null;
		interest_rule ir_rule 		= interest_rule.IR_MATURITY_NOADJ;
		logical  average_notional 	= true;
		logical compound_to_mat		= false;
		
		init_def_parm(	def.currency(),
						coupon_freq_from_int(def.coupon_freq(ee)),
						def.dc_method(ee),
						roll,
						def.pmt_bus_day(ee),
						def.calendar(ee),
						def.eom(ee),
						const_cpn, comp_freq, pv_round_code, start_stub_decomp, end_stub_decomp, ir_rule,
						def.swap_pmt_lag_leg1(), def.swap_pmt_lag_leg1(),def.swap_pmt_lag_prin_leg1(),def.swap_pmt_lag_prin_leg1(),
						average_notional, compound_to_mat);
		
		init_leg_parm(	null, null, null, null, null, null, null, null, null,null);

	}
	/*-----------------------------------------------------------------------
	  init_basic_static_leg2
	  ----------------------------------------------------------------------*/
	void fix_parm.init_basic_static_leg2(instr_def  def)
	{
		error_info ee = new error_info(true,true);

		fix_roll_method	roll		= fix_roll_method.FIR_STRAIGHT;
		logical const_cpn 			= false;		
		..fix_comp_freq  comp_freq 	= null;
		round_code  pv_round_code 	= null;
		logical start_stub_decomp 	= null;
		logical  end_stub_decomp 	= null;
		interest_rule ir_rule 		= interest_rule.IR_MATURITY_NOADJ;
		logical  average_notional 	= true;
		logical compound_to_mat		= false;
		
		init_def_parm(	def.swap_currency_leg2(ee),
						coupon_freq_from_int(def.swap_coupon_freq_leg2(ee)),
						def.swap_dc_method_leg2(ee),
						roll,
						def.swap_pmt_bus_day_leg2(ee),
						def.swap_calendar_leg2(ee),
						def.swap_eom_leg2(ee),
						const_cpn, comp_freq, pv_round_code, start_stub_decomp, end_stub_decomp, ir_rule,
						def.swap_pmt_lag_leg2(), def.swap_pmt_lag_leg2(),def.swap_pmt_lag_prin_leg2(),def.swap_pmt_lag_prin_leg2(),
						average_notional, compound_to_mat);
		
		init_leg_parm(	null, null, null, null, null, null, null, null, null, null);

	}
	/*-----------------------------------------------------------------------
	  init_basic_static
	  ----------------------------------------------------------------------*/
	void fix_parm.init_static(	bd_convention 	pmt_bus_day,
								calendar  		pmt_cal,
								logical 		eom,
								string	 		ccy,
								integer 		cpn_freq,									
								day_count_method dc,
								interest_rule 	ir_rule,
								number option(nullable)  pmt_delay,
								number option(nullable)  mat_pmt_delay,
								number option(nullable)  pmt_delay_prin,
								number option(nullable)  mat_pmt_delay_prin,
								logical  option(nullable)  average_notional,
								fix_roll_method	option(nullable) roll,
								logical option(nullable) 	const_cpn ,		
								..fix_comp_freq  option(nullable)  comp_freq,
								logical option(nullable) 	compound_to_mat	)
	{
		coupon_freq cf 				= coupon_freq_from_int(cpn_freq);
		round_code  pv_round_code 	= null;
		logical start_stub_decomp 	= null;
		logical  end_stub_decomp 	= null;						
		
		init_def_parm(	ccy,
						cf,
						dc,
						null(roll) ? fix_roll_method.FIR_STRAIGHT : roll,
						pmt_bus_day,
						pmt_cal,
						eom,
						null(const_cpn) ? false : const_cpn,
						null(comp_freq) ? ..fix_comp_freq.FCF_AS_FREQ : comp_freq,
						pv_round_code, start_stub_decomp, end_stub_decomp, ir_rule,
						pmt_delay, mat_pmt_delay,pmt_delay_prin,mat_pmt_delay_prin,
						null(average_notional) ? true : average_notional,
						null(compound_to_mat) ? false : compound_to_mat);
		
		init_leg_parm(	null, null, null, null, null, null, null, null, null, null);
	}
	
	/*-----------------------------------------------------------------------
	  basic_static_null_check
	  ----------------------------------------------------------------------*/
	void fix_parm.basic_static_null_check(	out bd_convention 	pmt_bus_day,
											out calendar  		pmt_cal,
											out logical 		end_of_month,
											out string	 		ccy,
											number option(nullable) cpn_freq_n,
											out coupon_freq 	cpn_freq,
											out day_count_method day_count,
											out interest_rule 	ir_rule,
											out number  		pmt_delay,
											out number  		mat_pmt_delay,
											out number  		pmt_delay_prin,
											out number  		mat_pmt_delay_prin,
											out logical 		avg_not)
	{
		if(null(pmt_bus_day))
		   pmt_bus_day = fix_pmt_bus_day_;
		QL_REQUIRE(!null(pmt_bus_day), "invalid fix leg business day convention");
		
		if(null(pmt_cal))
			pmt_cal = fix_pmt_calendar_;
		QL_REQUIRE(!null(pmt_cal), "invalid fix leg calendar");

		if(null(end_of_month))
			end_of_month = fix_end_of_month_ ;
		QL_REQUIRE(!null(end_of_month), "invalid fix leg end of month");

		if(null(ccy))
			ccy = fix_ccy_ ;
		QL_REQUIRE(!null(ccy), "invalid fix leg currency");

		if(null(cpn_freq_n))
			cpn_freq = fix_cpn_freq_ ;
		else
			cpn_freq = coupon_freq_from_int(integer(cpn_freq_n));
		QL_REQUIRE(!null(cpn_freq), "invalid fix leg coupon frequency");
		
		if(null(day_count))
		   day_count = fix_dc_ ;
		QL_REQUIRE(!null(day_count), "invalid fix leg daycount method");

		if(null(ir_rule))
		   ir_rule = fix_ir_rule_;
		QL_REQUIRE(!null(ir_rule), "invalid fix leg interest rule");
		
		if(null(pmt_delay))
			pmt_delay = fix_pmt_delay_ ;
		QL_REQUIRE(!null(pmt_delay), "invalid fix leg payment delay");

		if(null(mat_pmt_delay))
			mat_pmt_delay = null(fix_mat_pmt_delay_) ? pmt_delay :  fix_mat_pmt_delay_;
		
		if(null(pmt_delay_prin))
			pmt_delay_prin = fix_pmt_delay_prin_ ;
		QL_REQUIRE(!null(pmt_delay_prin), "invalid fix leg principal payment delay");

		if(null(mat_pmt_delay_prin))
			mat_pmt_delay_prin = null(fix_mat_pmt_delay_prin_) ? fix_mat_pmt_delay_prin_ : pmt_delay_prin;

		if(null(avg_not))
			avg_not = fix_average_notional_ ;
		QL_REQUIRE(!null(avg_not), "invalid average notional setting (for amortizing swaps only)");
		
	}
	/*-----------------------------------------------------------------------
	  set_plain_vanilla
	  ----------------------------------------------------------------------*/	
	/*void fix_parm.set_plain_vanilla()
	{
		// ----fix_parm-------
		//will not set:
		//	fix_cpn_freq;
		//	fix_ccy;
		//	fix_pmt_calendar;
		//	fix_pmt_bus_day;
		//	fix_end_of_month;
		//	fix_dc;		
		//	fix_coupon_rate;
		//	fix_notional;
		//	fix_fx_mult;
		

		fix_roll_ 				= fix_roll_method.FIR_STRAIGHT;
		fix_const_cpn_			= false;
		fix_comp_freq_ 			= null;
		fix_pv_round_code_ 		= null;
		fix_start_stub_decomp_ 	= null;
		fix_end_stub_decomp_	= null;
		fix_ir_rule_ 			= interest_rule.IR_MATURITY_NOADJ;
		fix_pmt_delay_			= 0;
		fix_mat_pmt_delay_		= 0;
		fix_pmt_delay_prin_		= 0;
		fix_mat_pmt_delay_prin_	= 0;
		fix_average_notional_ 	= true;
		fix_compound_to_mat_ 	= false;

		fix_stub_type_			= stub_type.SHORT_FIRST;
		fix_eff_date_ 			= null<date>;
		fix_first_cpn_date_ 	= null<date>;
		fix_last_reg_date_ 		= null<date>;
		fix_sink_fund_style_	= null;
		fix_sink_fund_dates_	= null;
		fix_sink_fund_			= null;
	}
	*/
	/*-----------------------------------------------------------------------
	  set_plain 
	  ----------------------------------------------------------------------*/
	void fix_parm.set_plain(bd_convention option(nullable) 	pmt_bus_day,
							calendar option(nullable)		pmt_cal,
							logical	option(nullable) 		end_of_month,
							string	option(nullable) 		fix_ccy,											
							number option(nullable)			fix_cpn_freq_n,
							day_count_method option(nullable) fix_day_count,
							interest_rule option(nullable) 	fix_ir_rule,
							number  option(nullable) 		fix_pmt_delay,
							number  option(nullable) 		fix_mat_pmt_delay,
							number  option(nullable) 		fix_pmt_delay_prin,
							number  option(nullable) 		fix_mat_pmt_delay_prin,
							number	option(nullable)		fix_cpn_rate )
	{
		coupon_freq fix_cpn_freq = null;
		logical average_notional = true;
		
		basic_static_null_check(pmt_bus_day,pmt_cal,end_of_month,fix_ccy,fix_cpn_freq_n, fix_cpn_freq, fix_day_count,
								fix_ir_rule,fix_pmt_delay, fix_mat_pmt_delay,fix_pmt_delay_prin,fix_mat_pmt_delay_prin,average_notional);

		fix_roll_method	roll		= fix_roll_method.FIR_STRAIGHT;
		logical const_cpn 			= false;		
		..fix_comp_freq  comp_freq 	= null;
		round_code  pv_round_code 	= null;
		logical start_stub_decomp 	= null;
		logical  end_stub_decomp 	= null;		
		logical compound_to_mat		= false;
		
		init_def_parm(	fix_ccy, fix_cpn_freq, fix_day_count, roll, pmt_bus_day, pmt_cal,
						end_of_month, const_cpn, comp_freq, pv_round_code, start_stub_decomp, end_stub_decomp, fix_ir_rule,
						fix_pmt_delay, fix_mat_pmt_delay,fix_pmt_delay_prin,fix_mat_pmt_delay_prin,
						average_notional, compound_to_mat);

		//no null checks in init_leg_parm
		
		number notional 		= null;
		stub_type stub_t 		= stub_type.SHORT_FIRST;
		date   eff_date			= null;
		date  first_cpn_date	= null;
		date  last_reg_date		= null;									
		number fx_mult			= null;
		sink_fund_style sink_fund_style	= null;
		vector(date) sink_fund_dates	= null;
		vector(number) sink_fund		= null;
									
		init_leg_parm(notional, stub_t, eff_date, first_cpn_date, last_reg_date, fix_cpn_rate,
					  fx_mult, sink_fund_style, sink_fund_dates, sink_fund);

	}
	/*-----------------------------------------------------------------------
	  set_plain
	  ----------------------------------------------------------------------*/
	void fix_parm.set_plain(	bd_convention option(nullable)	pmt_bus_day,
								calendar option(nullable)		pmt_cal,
								logical	 option(nullable)		end_of_month,																		
								string	 option(nullable)		fix_ccy,
								number	option(nullable)		fix_cpn_freq_n,
								day_count_method option(nullable) fix_day_count,
								interest_rule option(nullable) 	fix_ir_rule ,
								number  option(nullable) 		fix_pmt_delay,
								number  option(nullable) 		fix_mat_pmt_delay,
								number  option(nullable) 		fix_pmt_delay_prin,
								number  option(nullable) 		fix_mat_pmt_delay_prin,
								number	option(nullable)		fix_cpn_rate,
								stub_type option(nullable) 		fix_stub_type,
								date option(nullable)  			fix_eff_date,
								date option(nullable)  			fix_first_cpn_date,
								date option(nullable)  			fix_last_reg_date,
								number	option(nullable) 		fix_notional,								
								number	option(nullable)		fix_fx_mult)
	{
	
		coupon_freq fix_cpn_freq = null;
		logical	 		fix_avg_not =true;
		//all input args of def type must be checked
		basic_static_null_check(pmt_bus_day,pmt_cal,end_of_month,fix_ccy,fix_cpn_freq_n,
								fix_cpn_freq, fix_day_count,fix_ir_rule,fix_pmt_delay,
								fix_mat_pmt_delay,fix_pmt_delay_prin,fix_mat_pmt_delay_prin,fix_avg_not);

		logical 		fix_const_cpn 		= false ;		
		logical 		fix_comp_to_mat 	= false ;
		..fix_comp_freq fix_comp_freq		= null ;
		round_code 		fix_pv_round_code	= null ;
		logical 		fix_start_stub_decomp= null ;
		logical 		fix_end_stub_decomp	= null ;	
		fix_roll_method fix_roll 			= fix_roll_method.FIR_STRAIGHT;
		
		init_def_parm(	str_to_upper(fix_ccy), fix_cpn_freq, fix_day_count, fix_roll, pmt_bus_day, pmt_cal,
						end_of_month, fix_const_cpn , fix_comp_freq, fix_pv_round_code, fix_start_stub_decomp,
						fix_end_stub_decomp,fix_ir_rule, fix_pmt_delay, fix_mat_pmt_delay, fix_pmt_delay_prin,
						fix_mat_pmt_delay_prin, fix_avg_not, fix_comp_to_mat);

		sink_fund_style fix_sink_fund_style = null;
		vector(date)  	fix_sink_fund_dates = null;
		vector(number)  fix_sink_fund 		= null;

		if(null(fix_stub_type))
			fix_stub_type = stub_type.SHORT_FIRST;
		
		init_leg_parm(	fix_notional, fix_stub_type,fix_eff_date, fix_first_cpn_date, fix_last_reg_date,
						fix_cpn_rate, fix_fx_mult, fix_sink_fund_style, fix_sink_fund_dates, fix_sink_fund);
				
	}

	/*-----------------------------------------------------------------------
	  set_plain_amort
	  ----------------------------------------------------------------------*/
	void fix_parm.set_plain_amort(	bd_convention option(nullable)	pmt_bus_day,
									calendar option(nullable)		pmt_cal,
									logical	 option(nullable)		end_of_month,																						
									string	 option(nullable)		ccy,
									number	 						notional,
									logical	option(nullable)		fix_avg_not,
									number	option(nullable)		fix_cpn_freq_n,
									day_count_method option(nullable) fix_day_count,
									interest_rule option(nullable) 	fix_ir_rule ,
									number  option(nullable) 		fix_pmt_delay,
									number  option(nullable) 		fix_mat_pmt_delay,
									number  option(nullable) 		fix_pmt_delay_prin,
									number  option(nullable) 		fix_mat_pmt_delay_prin,
									number	option(nullable)		fix_cpn_rate,
									stub_type option(nullable) 		fix_stub_type,
									date option(nullable)  			fix_eff_date,
									date option(nullable)  			fix_first_cpn_date,
									date option(nullable)  			fix_last_reg_date,
									sink_fund_style option(nullable)  fix_sink_fund_style,
									vector(date)  option(nullable)  	fix_sink_fund_dates,
									vector(number)  option(nullable)  fix_sink_fund,									
									number	option(nullable)		fix_fx_mult)
	{
	
		
		coupon_freq fix_cpn_freq = null;
		//all input args of def type must be checked
		basic_static_null_check(pmt_bus_day,pmt_cal,end_of_month,ccy,fix_cpn_freq_n,
								fix_cpn_freq, fix_day_count,fix_ir_rule,fix_pmt_delay,
								fix_mat_pmt_delay,fix_pmt_delay_prin,fix_mat_pmt_delay_prin,fix_avg_not);

		logical 		fix_const_cpn 		= false ;
		logical 		fix_comp_to_mat 	= false ;
		..fix_comp_freq fix_comp_freq		= null ;
		round_code 		fix_pv_round_code	= null ;
		logical 		fix_start_stub_decomp= null ;
		logical 		fix_end_stub_decomp	= null ;	
		fix_roll_method fix_roll 			= fix_roll_method.FIR_STRAIGHT;

		init_def_parm(	ccy, fix_cpn_freq, fix_day_count, fix_roll, pmt_bus_day, pmt_cal,
						end_of_month, fix_const_cpn , fix_comp_freq, fix_pv_round_code, fix_start_stub_decomp,
						fix_end_stub_decomp,fix_ir_rule, fix_pmt_delay, fix_mat_pmt_delay,fix_pmt_delay_prin,
						fix_mat_pmt_delay_prin, fix_avg_not, fix_comp_to_mat);

		if(null(fix_stub_type))
			fix_stub_type = stub_type.SHORT_FIRST;
		
		init_leg_parm(	notional, fix_stub_type, fix_eff_date, fix_first_cpn_date, fix_last_reg_date,
						 fix_cpn_rate, fix_fx_mult, fix_sink_fund_style, fix_sink_fund_dates, fix_sink_fund);
				
	}
	
}