option(null: hard);	

/*	
	swaplib wrapper functions
	Developer: Algorithmica Research, Magnus Nyström

	--------------------------------------------------------------------
	 	swap help functions for create funcs
	--------------------------------------------------------------------			
*/
module CORE_SWAPLIB
{
	
	/*-----------------------------------------------------------------------
	 -----------------------------------------------------------------------
	 -----class fltflt_parm--------------------------------------------------
	 -----------------------------------------------------------------------
	 -----------------------------------------------------------------------*/
	class fltflt_parm : public legleg_parm
	{
	public:
		override instr_type	type() ;
		
		fltflt_parm();
	
		ql_float_leg 		create_swap_float_mtm_leg1(ql_swap_float_def , string ,logical, disc_func  option(nullable),tenor_surface  option(nullable), disc_func  option(nullable));
		ql_float_leg 		create_swap_float_mtm_leg2(ql_swap_float_def , string ,logical, disc_func  option(nullable),tenor_surface  option(nullable), disc_func  option(nullable));
		
		void 				start_date_helper();
		void 				fx_notional_helper();
		
		void				init_static(instr_def,string option(nullable)  );
		void				init_static(INSTR_TMPL.swap_fltflt_def_tmpl);
		void				init_static(swap_fltflt,string option(nullable) spot_code );
		void				init_static(	string option(nullable) spot_code,
											bd_convention  		pmt_bus_day,
											calendar 			pmt_cal,
											logical				end_of_month,
											notional_exchg_style option(nullable) ne,												
											//flt1
											string				flt1_ccy,
											logical,
											integer 			flt1_cpn_freq,
											integer 			flt1_reset_freq,
											day_count_method 	flt1_day_count,
											interest_rule		flt1_ir_rule,
											ir_index 			flt1_ir_index,
											flt_comp_avg_type option(nullable)		flt1_comp_avg_t ,
											flt_sprd_comp_method option(nullable)	flt1_sprd_comp_m,
											flt_avg_method 	option(nullable)		flt1_avg_m,
											//flt2
											string				flt2_ccy,
											logical,
											integer 			flt2_cpn_freq,
											integer 			flt2_reset_freq,
											day_count_method 	flt2_day_count,
											interest_rule		flt2_ir_rule,
											ir_index 			flt2_ir_index,
											flt_comp_avg_type option(nullable)		flt2_comp_avg_t ,
											flt_sprd_comp_method option(nullable)	flt2_sprd_comp_m,
											flt_avg_method 	option(nullable)		flt2_avg_m,
											logical option(nullable) = null,
											logical option(nullable) = null);
		
		void 				set_notional_leg1(number);
		void 				set_notional_leg2(number);
		void 				set_pv01(number);
		flt_parm			flt_leg_parm1();
		flt_parm 			flt_leg_parm2();
		
		logical 			primary_quote_is_leg1();
	protected:
		number 				imp_mtm_fx_rate_leg1();
		number 				imp_mtm_fx_rate_leg2();
		
		void 			check();
		//void 			__set_plain_vanilla();
		void 			__set_plain(	bd_convention option(nullable) 	pmt_bus_day,
										calendar option(nullable)	pmt_cal,
										logical	option(nullable) 	end_of_month,
										integer 					imp_fix_rate_dec,
										number option(nullable)		pv01_not_unit,												
										//flt1
										string	option(nullable),
										logical	option(nullable),
										number option(nullable)		flt1_cpn_freq_n,
										number option(nullable)		,
										day_count_method  option(nullable) flt1_day_count,
											interest_rule option(nullable) 	flt1_ir_rule ,
										ir_index option(nullable)	flt1_ir_index,number option(nullable)  ,
										number option(nullable)  ,
										number option(nullable) 	flt1_curr_fix,
										//flt2
										string	option(nullable),
										logical	option(nullable),	
										number option(nullable)		flt2_cpn_freq_n,
											number option(nullable)		,
										day_count_method  option(nullable) flt2_day_count,
											interest_rule option(nullable) 	flt2_ir_rule ,
										ir_index option(nullable)	flt2_ir_index,number option(nullable)  ,
										number option(nullable)  ,
										number option(nullable) 	flt2_curr_fix);
		
		swap_fltflt 	__create_swap(	disc_func option(nullable) flt1_disc_func,
										fwd_func option(nullable) 	flt1_fwd_func,
										disc_func option(nullable) 	flt1_fwd_disc_func,
										disc_func option(nullable) flt2_disc_func,
										fwd_func option(nullable) 	flt2_fwd_func,
										disc_func option(nullable) 	flt2_fwd_disc_func,
										logical option(nullable));
		
	public:
		void		set_plain_single_ccy(string,											
										date option(nullable) 		trade_date,
										date option(nullable) 		settle_date,
										string option(nullable) 	spot_settle_code,
										date option(nullable) 		start_date,
										 string option(nullable) 		fwd_start_code,
										date option(nullable) 		maturity,
										string option(nullable) 	maturity_code,
										logical,
										bd_convention option(nullable) 	pmt_bus_day,
										calendar option(nullable)	pmt_cal,
										logical	option(nullable) 	end_of_month,
										string	option(nullable) 	ccy,
										integer 					,
										number 	option(nullable)	,
										number	option(nullable) 	notional,
										number	option(nullable) 	flt1_pv01,
										//flt1
										number option(nullable)		flt1_cpn_freq_n,
										number option(nullable)		,
										day_count_method  option(nullable) flt1_day_count,
										interest_rule option(nullable) 	flt1_ir_rule ,
										ir_index option(nullable)	flt1_ir_index,
										number option(nullable)  ,
										number option(nullable) 	flt1_curr_fix,
										//flt2													
										number option(nullable)		flt2_cpn_freq_n,
										number option(nullable)		,
										day_count_method  option(nullable) flt2_day_count,
										interest_rule option(nullable) 	flt2_ir_rule ,
										ir_index option(nullable)	flt2_ir_index,
										number option(nullable)  ,
										number option(nullable) 	flt2_curr_fix);

		void		set_plain_single_ccy(string,											
										date option(nullable) 		trade_date,
										date option(nullable) 		settle_date,
										
										date option(nullable) 		start_date,
										 string option(nullable) 		fwd_start_code,
										date option(nullable) 		maturity,
										string option(nullable) 	maturity_code,
										logical 					pay_float1,
										integer 					imp_sprd_dec,
										number 	option(nullable) 	pv01_not_unit,
										number	option(nullable) 	notional,
										number	option(nullable) 	flt1_pv01,
										//flt1
										number option(nullable)  	flt1_spread,
										number option(nullable) 	flt1_curr_fix,
										//flt2													
										number option(nullable)  	flt2_spread,
										number option(nullable) 	flt2_curr_fix);
				
		
		void 		set_plain(	string,								
								date option(nullable) 			trade_date,
								date option(nullable) 			settle_date,
								string option(nullable) 		spot_settle_code,
								date option(nullable) 			start_date,
								string option(nullable) 		fwd_start_code,
								date option(nullable)			maturity,
								string option(nullable) 		maturity_code,
								logical							pay_float1,								
								bd_convention option(nullable)	pmt_bus_day,
								calendar option(nullable)		pmt_cal,
								logical	 option(nullable)		end_of_month,
								notional_exchg_style option(nullable) notional_exchg,
								integer 						imp_sprd_dec,
								number 	option(nullable) 		pv01_not_unit,
								number 	option(nullable) 		fx_quote,
								string 	option(nullable) 		fx_quote_baseccy,
								string 	option(nullable) 		fx_quote_priceccy,
								logical option(nullable) 		pv_in_base_ccy,
								//flt1
								string	option(nullable)		flt1_ccy,
								logical	option(nullable)		flt1_is_mtm,
								number option(nullable)	 		flt1_cpn_freq_n,
								number option(nullable)			flt1_reset_freq_n,
								day_count_method  option(nullable) flt1_day_count,
								interest_rule option(nullable) 	flt1_ir_rule ,
								ir_index option(nullable)		flt1_ir_index,
								number option(nullable) 		flt1_spread,
								stub_type option(nullable)		flt1_stub_type,
								date option(nullable)  			flt1_eff_date,
								date option(nullable)  			flt1_first_cpn_date,
								date option(nullable)  			flt1_last_reg_date,
								number	option(nullable) 		flt1_notional,
								number	option(nullable) 		flt1_pv01,
								number option(nullable) 		flt1_curr_fix,
								vector(date) option(nullable) 	flt1_fixing_dates ,	
								vector(number) option(nullable) flt1_fixing_rates,
								number option(nullable) 		flt1_fix_proxy ,
								logical option(nullable) 		flt1_allow_fwd_fix,
								//flt2
								string	option(nullable)		flt2_ccy,
								logical	option(nullable)		flt2_is_mtm,
								number option(nullable)	 		flt2_cpn_freq_n,
								number option(nullable)			flt2_reset_freq_n,
								day_count_method  option(nullable) flt2_day_count,
								interest_rule option(nullable) 	flt2_ir_rule ,
								ir_index option(nullable)		flt2_ir_index,
								number option(nullable) 		flt2_spread,
								stub_type option(nullable)		flt2_stub_type,
								date option(nullable)  			flt2_eff_date,
								date option(nullable)  			flt2_first_cpn_date,
								date option(nullable)  			flt2_last_reg_date,
								number	option(nullable) 		flt2_notional,								
								number option(nullable) 		flt2_curr_fix,
								vector(date) option(nullable) 	flt2_fixing_dates ,	
								vector(number) option(nullable) flt2_fixing_rates,
								number option(nullable) 		flt2_fix_proxy ,
								logical option(nullable) 		flt2_allow_fwd_fix);

		void 		set_plain(	string,								
								date option(nullable) 			trade_date,
								date option(nullable) 			settle_date,
								
								date option(nullable) 			start_date,
								string option(nullable) 		fwd_start_code,
								date option(nullable)			maturity,
								string option(nullable) 		maturity_code,
								logical							pay_float1,	
								integer 						imp_sprd_dec,
								number 	option(nullable) 		pv01_not_unit,
								number 	option(nullable) 		fx_quote,
								string 	option(nullable) 		fx_quote_baseccy,
								string 	option(nullable) 		fx_quote_priceccy,
								logical option(nullable) 		pv_in_base_ccy,
								//flt1
								number option(nullable) 		flt1_spread,
								stub_type option(nullable)		flt1_stub_type,
								date option(nullable)  			flt1_eff_date,
								date option(nullable)  			flt1_first_cpn_date,
								date option(nullable)  			flt1_last_reg_date,
								number	option(nullable) 		flt1_notional,
								number	option(nullable) 		flt1_pv01,
								number option(nullable) 		flt1_curr_fix,
								vector(date) option(nullable) 	flt1_fixing_dates ,	
								vector(number) option(nullable) flt1_fixing_rates,
								number option(nullable) 		flt1_fix_proxy ,
								logical option(nullable) 		flt1_allow_fwd_fix,
								//flt2
								number option(nullable) 		flt2_spread,
								stub_type option(nullable)		flt2_stub_type,
								date option(nullable)  			flt2_eff_date,
								date option(nullable)  			flt2_first_cpn_date,
								date option(nullable)  			flt2_last_reg_date,
								number	option(nullable) 		flt2_notional,								
								number option(nullable) 		flt2_curr_fix,
								vector(date) option(nullable) 	flt2_fixing_dates ,	
								vector(number) option(nullable) flt2_fixing_rates,
								number option(nullable) 		flt2_fix_proxy ,
								logical option(nullable) 		flt2_allow_fwd_fix);
		
		swap_fltflt 	create_swap( disc_func option(nullable) ,
									disc_func option(nullable) ,
									disc_func option(nullable) ,
									disc_func option(nullable),logical option(nullable)  allow_extrap = null );

		swap_fltflt 	create_swap(disc_func option(nullable) ,
									fwd_func option(nullable) ,
									disc_func option(nullable),
									fwd_func option(nullable),logical option(nullable)  allow_extrap = null );
		
		flt_parm	fp1_;
		flt_parm	fp2_;

		void set_mtm_data(	number 	option(nullable)  fx_quote );
	};

	/*-----------------------------------------------------------------------
	  constructor
	  ----------------------------------------------------------------------*/
	fltflt_parm.fltflt_parm()
	{
		fp1_ 			= new flt_parm();
		fp2_ 			= new flt_parm();
	}
	/*-----------------------------------------------------------------------
	  type
	  ----------------------------------------------------------------------*/
	instr_type fltflt_parm.type() { return instr_type.SWAP_FLTFLT;}
	/*-----------------------------------------------------------------------
	  flt_leg_parm/mtm
	  ----------------------------------------------------------------------*/
	flt_parm fltflt_parm.flt_leg_parm1() 	{ return fp1_;}
	flt_parm fltflt_parm.flt_leg_parm2() 	{ return fp2_;}

	/*-----------------------------------------------------------------------
	  set_mtm_data
	  ----------------------------------------------------------------------*/
	void fltflt_parm.set_mtm_data(	number 	option(nullable)  mtm_fx_quote )
	{
		calendar mtm_usd_calendar = null;//for now, FIX_ME
		legleg_parm.set_mtm_data(fp1_.flt_ccy_, fp2_.flt_ccy_, fp1_.flt_pmt_calendar_,fp2_.flt_pmt_calendar_, mtm_fx_quote, mtm_usd_calendar);
		
	}
	/*-----------------------------------------------------------------------
	  check
	  ----------------------------------------------------------------------*/
	void fltflt_parm.check()
	{
		if(is_aged_swap()){
			QL_REQUIRE(!null(fp1_.flt_spread_),"float spread required for aged swap");
			if(is_ccy_ ) {
				QL_REQUIRE(!null(fp1_.flt_notional_) && !null(fp2_.flt_notional_),"notionals are required for aged swap");
			}
			else {
				QL_REQUIRE(!null(fp1_.flt_notional_) || !null(fp2_.flt_notional_),"notional is required for aged swap");
			}
		}
	}
	/*-----------------------------------------------------------------------
	  set_notional_leg1
	  ----------------------------------------------------------------------*/
	void fltflt_parm.set_notional_leg1(number not)
	{
		fp1_.flt_notional_ 	= not;
		if(!is_ccy_)
			fp2_.flt_notional_ 	= not;
		leg_pv01_ 			= null;
		fx_notional_helper();
	}
	/*-----------------------------------------------------------------------
	  set_notional_leg2
	  ----------------------------------------------------------------------*/
	void fltflt_parm.set_notional_leg2(number not)
	{
		fp2_.flt_notional_ 	= not;
		if(!is_ccy_)
			fp1_.flt_notional_ 	= not;
		leg_pv01_ 			= null;
		fx_notional_helper();
	}
	/*-----------------------------------------------------------------------
	  set_notional
	  ----------------------------------------------------------------------*/
	void fltflt_parm.set_pv01(number pv01)
	{
		fp1_.flt_notional_ 	= 1000000;
		fp2_.flt_notional_ 	= null;//if null it will be calculated in ccy_helper, --> assume pv01 is leg1  FIX_ME
		leg_pv01_ 			= pv01;
		fx_notional_helper();
	}
	/*-----------------------------------------------------------------------
	  ccy_helper
	  ----------------------------------------------------------------------*/
	void fltflt_parm.fx_notional_helper()
	{
		legleg_parm.fx_notional_helper(fp1_.flt_notional_, fp2_.flt_notional_, fp1_.flt_fx_mult_ , fp2_.flt_fx_mult_);
	}

	/*-----------------------------------------------------------------------
	  start_date_helper
	  ----------------------------------------------------------------------*/	
	void fltflt_parm.start_date_helper()
	{
		legleg_parm.start_date_helper(fp1_.flt_eff_date_, fp2_.flt_eff_date_, fp1_.flt_pmt_calendar_);
	}

	/*-----------------------------------------------------------------------
	  create_swap_float_leg1
	  note using fp2_.flt_fx_mult for mtm means swap_settle == fx_spot_settle
	  ----------------------------------------------------------------------*/	
	ql_float_leg fltflt_parm.create_swap_float_mtm_leg1(ql_swap_float_def 	flt_def,
														string 				name,
														logical 			pay,
														disc_func 	 option(nullable)		flt_disc_func,
														tenor_surface 	 option(nullable)	flt_tenor_surface,
														disc_func 	 option(nullable)		flt2_disc_func)													
	{
		//date fxs = fx_spot_date(td, calbase,baseccy,cal_p, p_ccy, fxrule, spotd, calny, adjtd);
		calendar usd_cal = null; //used for calc of fx spot date, not used for all currency pairs
		return fp1_.create_swap_float_mtm_leg(	flt_def, name, pay, flt_disc_func, flt_tenor_surface, trade_date_,
												settle_date_,start_date_, maturity_ , mat_code_,fp2_.flt_roll_day_,
												fp2_.flt_fx_mult_,
												flt2_disc_func,
												fp2_.flt_notional_,
												fp2_.flt_ccy_,
												fp2_.flt_pmt_calendar_,usd_cal,mtm_fx_spot_rate_);
		
	}
	/*-----------------------------------------------------------------------
	  create_swap_float_leg2
	  ----------------------------------------------------------------------*/	
	ql_float_leg fltflt_parm.create_swap_float_mtm_leg2(ql_swap_float_def 	flt_def,
														string 				name,
														logical 			pay,
														disc_func  option(nullable)			flt_disc_func,
														tenor_surface  option(nullable)		flt_tenor_surface,
														disc_func  option(nullable)			flt1_disc_func)													
	{
		calendar usd_cal = null; //used for calc of fx spot date, not used for all currency pairs
		return fp2_.create_swap_float_mtm_leg(	flt_def, name, pay, flt_disc_func, flt_tenor_surface, trade_date_,
												settle_date_,start_date_, maturity_ , mat_code_,fp1_.flt_roll_day_,
												fp1_.flt_fx_mult_,
												flt1_disc_func,
												fp1_.flt_notional_,
												fp1_.flt_ccy_,
												fp1_.flt_pmt_calendar_,usd_cal,mtm_fx_spot_rate_);
	}
	/*-----------------------------------------------------------------------
	  imp_mtm_fx_rate_leg2
	  ----------------------------------------------------------------------*/	
	number fltflt_parm.imp_mtm_fx_rate_leg2()
	{
		number opp_leg_fx_mult = fp1_.flt_fx_mult_;
		return fp2_.flt_fx_mult_/opp_leg_fx_mult;
	}
	/*-----------------------------------------------------------------------
	  imp_mtm_fx_rate_leg1
	  ----------------------------------------------------------------------*/	
	number fltflt_parm.imp_mtm_fx_rate_leg1()
	{
		number 	opp_leg_fx_mult = fp2_.flt_fx_mult_;
		return 	fp1_.flt_fx_mult_/opp_leg_fx_mult;
	}
	
	/*-----------------------------------------------------------------------
	  init_basic_static
	  Note: a possible maturity code in the template is never "carried over" to the swap
	  Note to self: tmpl --> def --> ql_fixed_income_swap --> swap_fixflt (and the def is lost in the process since it is only part of the translation)
					(a direct route without the def is possible but not sure if it will save much compute time)
	  ----------------------------------------------------------------------*/
	void fltflt_parm.init_static(INSTR_TMPL.swap_fltflt_def_tmpl tmpl)
	{
		//----fltflt_parm-----		
		is_ccy_	 		= tmpl.is_cross_curr();		
		ne_ 			= tmpl.not_exchange();
		if(null(ne_))
			ne_ 	= is_ccy_ ? NE_BOTH : NE_NONE;
		
		spot_code_ 		= tmpl.spot_settle_code();
		trade_date_ 	= null;
		maturity_ 		= null;
		maturity_code_ 	= tmpl.maturity_code();
		mat_code_ 		= null;
		fwd_start_code_ = tmpl.fwd_start_code();
		start_date_ 	= null;
		settle_date_	= null;
		//cpn_roll_day_ 	= 0;
		is_mtm_ 		= tmpl.is_mtm(is_mtm_leg1_);

		integer pmt_delay = 0;//FIX_ME
		
		//---flt1---
		..flt_roll_method flt_roll 	= null;
		logical flt_compound_to_mat = null;

		fp1_.init_static(tmpl.flt1_bd_convention(),tmpl.flt1_calendar(),tmpl.flt1_eom(),tmpl.flt1_currency(),
						tmpl.flt1_cpn_freq(), tmpl.flt1_reset_freq(),
						tmpl.flt1_day_count_method(),tmpl.flt1_ir_rule(),tmpl.flt1_ir_index(),pmt_delay,pmt_delay,pmt_delay,pmt_delay,
						tmpl.flt1_comp_avg(), tmpl.flt1_spread_comp_method(), tmpl.flt1_avg_method(),null,
						flt_roll,flt_compound_to_mat,tmpl.flt1_fwd_stub_rate_style());

		//---flt2---
		fp2_.init_static(tmpl.flt2_bd_convention(),tmpl.flt2_calendar(),tmpl.flt2_eom(),tmpl.flt2_currency(),
						tmpl.flt2_cpn_freq(), tmpl.flt2_reset_freq(),
						tmpl.flt2_day_count_method(),tmpl.flt2_ir_rule(),tmpl.flt2_ir_index(),pmt_delay,pmt_delay,pmt_delay,pmt_delay,
						tmpl.flt2_comp_avg(), tmpl.flt2_spread_comp_method(), tmpl.flt2_avg_method(),null,
						flt_roll,flt_compound_to_mat,tmpl.flt2_fwd_stub_rate_style());

	}
	/*-----------------------------------------------------------------------
	  init_basic_static
	  ----------------------------------------------------------------------*/
	void fltflt_parm.init_static(	instr_def  def,
									string option(nullable) spot_code)
	{
		QL_REQUIRE(CORE_INT.check_instr_def(def),"invalid instr_def");
		QL_FAIL_COND(!def.is_swap_fltflt(), "instr_def not a float-float swap", E_INIT);

		//----fltflt_parm-----		
		is_ccy_	 		= def.is_ccy_swap();		
		error_info ees 	= new error_info(true,false);
		ne_ 			= def.swap_not_exchange(ees);
		if(null(ne_))
			ne_ 	= is_ccy_ ? NE_BOTH : NE_NONE;

		spot_code_ 		= null(spot_code) ? "BD2" : spot_code;;
		trade_date_ 	= null;
		maturity_ 		= null;
		maturity_code_ 	= def.maturity_code(ees);
		mat_code_ 		= null;
		fwd_start_code_ = null;
		start_date_ 	= null;
		settle_date_	= null;
		//cpn_roll_day_ 	= 0;
		is_mtm_ 		= def.is_swap_fltflt_mtm();
		is_mtm_leg1_ 	= def.is_swap_fltflt_mtm_leg1();
		
		//----flt_parm1--------
		fp1_.init_basic_static_leg1(def);
	
		//----flt_parm2--------
		fp2_.init_basic_static_leg2(def);
	
	}
	
	/*-----------------------------------------------------------------------
	  init_basic_static
	  ----------------------------------------------------------------------*/	
	void fltflt_parm.init_static(swap_fltflt sw_base,
								 string option(nullable) spot_code)	//ext swap i.e. instr_def = null
	{
		//----fltflt_parm-----
		error_info ee 	= new error_info(true,true);
		is_ccy_ 		= sw_base.is_ccy_swap();			
		ne_ 			= null;//sw_base.notional_exchg_style_fix_leg(ee);		//assume both legs are same
		if(null(ne_))
			ne_ = is_ccy_ ? NE_BOTH : NE_NONE;
		
		spot_code_ 		= null(spot_code) ? "BD2" : spot_code;;
		trade_date_ 	= null;
		maturity_ 		= null;
		maturity_code_ 	= null;
		mat_code_ 		= null;
		fwd_start_code_ = null;
		start_date_ 	= null;
		settle_date_	= null;
		//cpn_roll_day_ 	= 0;
		is_mtm_leg1_ 	= sw_base.is_mtm_leg1(ee);
		is_mtm_ 		= is_mtm_leg1_|| sw_base.is_mtm_leg2(ee) ;
	
		//----fix_parm / flt_parm--------
		integer cfreq_flt1, cfreq_flt2;
		sw_base.coupon_freq(cfreq_flt1, cfreq_flt2, ee);		
		sw_base.calendar(fp1_.flt_pmt_calendar_,fp2_.flt_pmt_calendar_,ee);
		sw_base.pmt_bus_day(fp1_.flt_pmt_bus_day_,fp2_.flt_pmt_bus_day_,ee);
		sw_base.eom(fp1_.flt_end_of_month_,fp2_.flt_end_of_month_,ee);
		sw_base.dc_method(fp1_.flt_dc_ ,fp2_.flt_dc_,ee);
		sw_base.currency(fp1_.flt_ccy_ ,fp2_.flt_ccy_ ,ee);
		
		integer mat_pmt_delay1,mat_pmt_delay_prin1;
		integer mat_pmt_delay2,mat_pmt_delay_prin2;
		integer pmt_delay1,pmt_delay2 ;
		integer pmt_delay_prin1,pmt_delay_prin2 ;
		sw_base.pmt_lag(pmt_delay1,mat_pmt_delay1, pmt_delay_prin1, mat_pmt_delay_prin1,
						pmt_delay2,mat_pmt_delay2, pmt_delay_prin2, mat_pmt_delay_prin2,ee);

		flt_stub_fwd_style flt_stub_rate_style = null;//FIX_ME
		
		//---flt1---
		flt_comp_avg_type flt1_comp_avg_type 		= sw_base.comp_avg_type_leg1(ee);//OBS n/a for ext swap
		flt_sprd_comp_method  flt1_sprd_comp_method = sw_base.sprd_comp_method_leg1(ee);//OBS n/a for ext swap
		flt_avg_method flt1_avg_method 				= sw_base.avg_method_leg1(ee);//OBS n/a for ext swap
		
		..flt_roll_method flt_roll 				= null;
		logical flt_compound_to_mat 			= null;
		logical   average_notional				= null;
		fp1_.init_static(fp1_.flt_pmt_bus_day_,fp1_.flt_pmt_calendar_,fp1_.flt_end_of_month_,fp1_.flt_ccy_,
									cfreq_flt1, sw_base.reset_freq_leg1(ee),
									fp1_.flt_dc_,sw_base.ir_rule_leg1(ee),sw_base.ir_index_leg1(ee),
									pmt_delay1,mat_pmt_delay1,
									pmt_delay_prin1,mat_pmt_delay_prin1,
									flt1_comp_avg_type, flt1_sprd_comp_method, flt1_avg_method,
									average_notional,flt_roll,flt_compound_to_mat,flt_stub_rate_style);

		//---flt2---
		flt_comp_avg_type flt2_comp_avg_type 		= sw_base.comp_avg_type_leg2(ee);//OBS n/a for ext swap
		flt_sprd_comp_method  flt2_sprd_comp_method = sw_base.sprd_comp_method_leg2(ee);//OBS n/a for ext swap
		flt_avg_method flt2_avg_method 				= sw_base.avg_method_leg2(ee);//OBS n/a for ext swap
		
		fp2_.init_static(fp2_.flt_pmt_bus_day_,fp2_.flt_pmt_calendar_,fp2_.flt_end_of_month_,fp2_.flt_ccy_,
							cfreq_flt2, sw_base.reset_freq_leg2(ee),
							fp2_.flt_dc_,sw_base.ir_rule_leg2(ee),sw_base.ir_index_leg2(ee),
							pmt_delay2,mat_pmt_delay2,
							pmt_delay_prin2,mat_pmt_delay_prin2,
							flt2_comp_avg_type, flt2_sprd_comp_method, flt2_avg_method,
							average_notional,flt_roll,flt_compound_to_mat,flt_stub_rate_style);
		
	}
	void fltflt_parm.init_static(	string 	option(nullable) spot_code,
									bd_convention  		pmt_bus_day,
									calendar 			pmt_cal,
									logical				end_of_month,
									notional_exchg_style option(nullable) ne,												
									//flt1
									string				flt1_ccy,
									logical				flt1_is_mtm,
									integer 			flt1_cpn_freq,
									integer 			flt1_reset_freq,
									day_count_method 	flt1_day_count,
									interest_rule		flt1_ir_rule,
									ir_index 			flt1_ir_index,
									flt_comp_avg_type option(nullable)		flt1_comp_avg_t ,
									flt_sprd_comp_method option(nullable)	flt1_sprd_comp_m,
									flt_avg_method 	option(nullable)		flt1_avg_m,
									//flt2
									string				flt2_ccy,
									logical				flt2_is_mtm,
									integer 			flt2_cpn_freq,
									integer 			flt2_reset_freq,
									day_count_method 	flt2_day_count,
									interest_rule		flt2_ir_rule,
									ir_index 			flt2_ir_index,
									flt_comp_avg_type option(nullable)		flt2_comp_avg_t ,
									flt_sprd_comp_method option(nullable)	flt2_sprd_comp_m,
									flt_avg_method 	option(nullable)		flt2_avg_m,
									logical option(nullable) flt1_avg_not ,
									logical option(nullable) flt2_avg_not )
	{
		//----fltflt_parm-----		
		is_ccy_ 		= !equal_casei(flt1_ccy, flt2_ccy);	
		ne_ 			= ne;
		if(null(ne_))
			ne_ = is_ccy_ ? NE_BOTH : NE_NONE;

		spot_code_ 		= null(spot_code) ? "BD2" : spot_code;;
		trade_date_ 	= null;
		maturity_ 		= null;
		maturity_code_ 	= null;
		mat_code_ 		= null;
		fwd_start_code_ = null;
		start_date_ 	= null;
		settle_date_	= null;
		//cpn_roll_day_ 	= 0;

		if(is_ccy_) {
			if(!null(flt1_is_mtm)) {
				is_mtm_leg1_ = flt1_is_mtm;
				if(is_mtm_leg1_)
					is_mtm_ = true;
			}
			if(!null(flt2_is_mtm) && flt2_is_mtm) {			
				is_mtm_ = true;
			}
		}
		integer pmt_delay = 0;//FIX_ME
		..flt_roll_method flt_roll 	= null;
		logical flt_compound_to_mat = null;
		flt_stub_fwd_style flt_stub_rate_style = null;//FIX_ME
		//---flt1---			
		fp1_.init_static(	pmt_bus_day,pmt_cal,end_of_month,flt1_ccy,
							flt1_cpn_freq, flt1_reset_freq,flt1_day_count,flt1_ir_rule,flt1_ir_index,
							pmt_delay,pmt_delay,pmt_delay,pmt_delay,
							flt1_comp_avg_t, flt1_sprd_comp_m, flt1_avg_m,flt1_avg_not,flt_roll,flt_compound_to_mat,flt_stub_rate_style);

		//---flt2---
		fp2_.init_static(	pmt_bus_day,pmt_cal,end_of_month,flt2_ccy,
							flt2_cpn_freq, flt2_reset_freq,flt2_day_count,flt2_ir_rule,flt2_ir_index,
							pmt_delay,pmt_delay,pmt_delay,pmt_delay,flt2_comp_avg_t, flt2_sprd_comp_m, flt2_avg_m,
							flt2_avg_not, flt_roll,flt_compound_to_mat,flt_stub_rate_style);
	}
	/*-----------------------------------------------------------------------
	  set_plain_vanilla
	  ----------------------------------------------------------------------*/
	/*void fltflt_parm.__set_plain_vanilla()
	{
		
		// ----fltflt_parm-------
		//will not set:
		//	is_ccy;
		//	ne;
		//	settle_code;			

		//	trade_date;
		//	maturity;
		//maturity_code;
		//	mat_code;
		//	fwd_start_code;
		//	start_date;
		//	settle_date
		
		cpn_roll_day_ = 0;
		
		// ----fix_parm-------
		fp1_.set_plain_vanilla();
		
		// ----flt parm-------
		fp2_.set_plain_vanilla();
	}*/
	
	/*-----------------------------------------------------------------------
	  __set_plain  <protected>    internal
	  ----------------------------------------------------------------------*/
	void fltflt_parm.__set_plain(	bd_convention option(nullable) 	pmt_bus_day,
									calendar option(nullable)	pmt_cal,
									logical	option(nullable) 	end_of_month,
									integer 					imp_sprd_dec,
									number option(nullable)		pv01_not_unit,											
									//flt1
									string	option(nullable) 	flt1_ccy,
									logical	option(nullable)	flt1_is_mtm,
									number option(nullable)		flt1_cpn_freq_n,
									number option(nullable)		flt1_reset_freq_n,
									day_count_method  option(nullable) flt1_day_count,
									interest_rule option(nullable) 	flt1_ir_rule ,
									ir_index option(nullable)	flt1_ir_index,
									number option(nullable) 	flt1_notional,
									number option(nullable) 	flt1_spread,
									number option(nullable) 	flt1_curr_fix,
									//flt2
									string	option(nullable) 	flt2_ccy,
									logical	option(nullable)	flt2_is_mtm,
									number option(nullable)		flt2_cpn_freq_n,
									number option(nullable)		flt2_reset_freq_n,
									day_count_method  option(nullable) flt2_day_count,
									interest_rule option(nullable) 	flt2_ir_rule ,
									ir_index option(nullable)	flt2_ir_index,
									number option(nullable) 	flt2_notional,
									number option(nullable) 	flt2_spread,
									number option(nullable) 	flt2_curr_fix)
	{
		imp_calc_dec_  	= imp_sprd_dec;//rounding decimals of the implied cpn rate (on decimal value)
		pv01_not_unit_  = null(pv01_not_unit) ? -1: pv01_not_unit;//rounding unit for notional when implied from pv01

		if(null(flt1_ccy))
			flt1_ccy = fp1_.flt_ccy_;

		if(null(flt2_ccy))
			flt2_ccy = fp2_.flt_ccy_;
		
		is_ccy_  = !equal_casei(flt1_ccy, flt2_ccy);

		if(is_ccy_){
			if(!null(flt1_is_mtm)) {
				is_mtm_leg1_ = flt1_is_mtm;
				if(is_mtm_leg1_)
					is_mtm_ = true;
			}
			if(!null(flt2_is_mtm) && flt2_is_mtm) {			
				is_mtm_ = true;
			}
		}

		integer pmt_delay = 0;//FIX_ME
		flt_stub_fwd_style flt_stub_rate_style = null;//FIX_ME
		
		fp1_.set_plain(	pmt_bus_day, pmt_cal, end_of_month, flt1_ccy, flt1_cpn_freq_n, flt1_reset_freq_n,flt1_day_count,flt1_ir_rule,
						flt1_ir_index,pmt_delay,pmt_delay,pmt_delay,pmt_delay,flt_stub_rate_style,flt1_spread,stub_type.SHORT_FIRST,
						null,null,null,flt1_notional,null,flt1_curr_fix,null,null,null,false,null,null);
		
		fp2_.set_plain(	pmt_bus_day, pmt_cal, end_of_month, flt2_ccy, flt2_cpn_freq_n, flt2_reset_freq_n,flt2_day_count,flt2_ir_rule,
						flt2_ir_index,pmt_delay,pmt_delay,pmt_delay,pmt_delay,flt_stub_rate_style,flt2_spread,stub_type.SHORT_FIRST,
						null,null,null,flt2_notional,null,flt2_curr_fix,null,null,null,false,null,null);
	}
	/*-----------------------------------------------------------------------
	  set_plain_single_ccy <ALL ARGS>
	  ----------------------------------------------------------------------*/
	void fltflt_parm.set_plain_single_ccy(	string name,											
											date option(nullable) 		trade_date,
											date option(nullable) 		settle_date,
											string option(nullable) 	spot_settle_code,
											date option(nullable) 		start_date,
											string option(nullable) 	fwd_start_code,
											date option(nullable) 		maturity,
											string option(nullable) 	maturity_code,
											logical 					pay_float1,
											bd_convention option(nullable) 	pmt_bus_day,
											calendar option(nullable)	pmt_cal,
											logical	option(nullable) 	end_of_month,
											string	option(nullable) 	ccy,
											integer 					imp_sprd_dec	,
											number 	option(nullable) 	pv01_not_unit	,
											number	option(nullable) 	notional,
											number	option(nullable) 	flt1_pv01,
											//flt1
											number option(nullable)		flt1_cpn_freq_n,
											number option(nullable)		flt1_reset_freq_n,
											day_count_method  option(nullable) flt1_day_count,
											interest_rule option(nullable) 	flt1_ir_rule ,
											ir_index option(nullable)	flt1_ir_index,
											number option(nullable) 	flt1_spread,
											number option(nullable) 	flt1_curr_fix,
											//flt2													
											number option(nullable)		flt2_cpn_freq_n,
											number option(nullable)		flt2_reset_freq_n,
											day_count_method  option(nullable) flt2_day_count,
											interest_rule option(nullable) 	flt2_ir_rule ,
											ir_index option(nullable)	flt2_ir_index,
											number option(nullable) 	flt2_spread,
											number option(nullable) 	flt2_curr_fix)
	{
		if(null(notional))
			QL_REQUIRE(!null(flt1_pv01),"one of notional and pv01 must be input");
		else if(null(flt1_pv01))
			QL_REQUIRE(!null(notional),"one of notional and pv01 must be input");
		else if(!null(notional) && !null(flt1_pv01))
			QL_FAIL("ambigious input of notional and pv01");

		
		this.__set_plain(	pmt_bus_day,pmt_cal,end_of_month,imp_sprd_dec,pv01_not_unit,ccy,false,
							flt1_cpn_freq_n,flt1_reset_freq_n,flt1_day_count,flt1_ir_rule,flt1_ir_index,
							notional,flt1_spread,flt1_curr_fix,
							ccy,false,flt2_cpn_freq_n,flt2_reset_freq_n,flt2_day_count,flt2_ir_rule,flt2_ir_index,
							notional,flt2_spread,flt2_curr_fix);

		//-----common--------
		name_			= name;
		pay_leg1_		= pay_float1;
		is_ccy_ 		= false;
		if(!null(spot_settle_code))
			spot_code_ 	= spot_settle_code;
		trade_date_ 	= trade_date;
		fwd_start_code_ = fwd_start_code;
		start_date_ 	= start_date;
		maturity_ 		= maturity;
		if(!null(maturity_code))
			maturity_code_ 	= maturity_code;
		settle_date_	= settle_date;
		//cpn_roll_day_ 	= 0;

		this.start_date_helper();
		this.maturity_helper(fp1_);
		this.check();
		//if single ccy set_pv01/set_notional will also set the other notional as well as both fxrates to 1
		if(null(notional))
			this.set_pv01(flt1_pv01);
		else
			this.set_notional_leg1(notional);
		ne_ = notional_exchg_style.NE_NONE;
		is_inited_ = true;
	}

	/*-----------------------------------------------------------------------
	  set_plain_single_ccy 
	  ----------------------------------------------------------------------*/
	void fltflt_parm.set_plain_single_ccy(	string name,											
											date option(nullable) 		trade_date,
											date option(nullable) 		settle_date,
											
											date option(nullable) 		start_date,
											string option(nullable) 	fwd_start_code,
											date option(nullable) 		maturity,
											string option(nullable) 	maturity_code,
											logical 					pay_float1,		
											integer 					imp_sprd_dec,
											number 	option(nullable) 	pv01_not_unit,
											number	option(nullable) 	notional,
											number	option(nullable) 	flt1_pv01,
											//flt1
											number option(nullable) 	flt1_spread,
											number option(nullable) 	flt1_curr_fix,
											//flt2													
											number option(nullable) 	flt2_spread,
											number option(nullable) 	flt2_curr_fix)
	{
		QL_FAIL_COND(null(is_ccy_),"fltflt_parm is not initalized (init_static() must be run) ");
		QL_REQUIRE(!is_ccy_,"function not applicable to cross currency swaps");
		
		if(null(notional))
			QL_REQUIRE(!null(flt1_pv01),"one of notional and pv01 must be input");
		else if(null(flt1_pv01))
			QL_REQUIRE(!null(notional),"one of notional and pv01 must be input");
		else if(!null(notional) && !null(flt1_pv01))
			QL_FAIL("ambigious input of notional and pv01");

		
		this.__set_plain(null,null,null,imp_sprd_dec,pv01_not_unit,null,
						false,null,null,null,null,null,notional,flt1_spread,flt1_curr_fix,
						null,false,null,null,null,null,null,notional,flt2_spread,flt2_curr_fix);

		//-----common--------
		name_			= name;
		pay_leg1_		= pay_float1;
		is_ccy_ 		= false;
	
		trade_date_ 	= trade_date;
		fwd_start_code_ = fwd_start_code;
		start_date_ 	= start_date;
		maturity_ 		= maturity;
		if(!null(maturity_code))
			maturity_code_ 	= maturity_code;
		settle_date_	= settle_date;
		//cpn_roll_day_ 	= 0;

		this.start_date_helper();
		this.maturity_helper(fp1_);
		this.check();
		//if single ccy set_pv01/set_notional will also set the other notional as well as both fxrates to 1
		if(null(notional))
			this.set_pv01(flt1_pv01);
		else
			this.set_notional_leg1(notional);
		ne_ = notional_exchg_style.NE_NONE;
		is_inited_ = true;
	}
	
	
	/*-----------------------------------------------------------------------
	  set_plain  <ALL ARGS>
	  ----------------------------------------------------------------------*/
	void fltflt_parm.set_plain(	string name,								
								date option(nullable) 			trade_date,
								date option(nullable) 			settle_date,
								string option(nullable) 		spot_settle_code,
								date option(nullable) 			start_date,
								string option(nullable) 		fwd_start_code,
								date option(nullable)			maturity,
								string option(nullable) 		maturity_code,
								logical 						pay_float1,
								bd_convention option(nullable)	pmt_bus_day,
								calendar option(nullable)		pmt_cal,
								logical	 option(nullable)		end_of_month,
								notional_exchg_style option(nullable) notional_exchg,
								integer 						imp_sprd_dec	,
								number 	option(nullable) 		pv01_not_unit	,
								number 		option(nullable) 	fx_quote,
								string 		option(nullable) 	fx_quote_baseccy,
								string 		option(nullable) 	fx_quote_priceccy,
								logical 	option(nullable) 	pv_in_base_ccy,
								//flt1
								string	option(nullable)		flt1_ccy,
								logical	option(nullable)		flt1_is_mtm,
								number option(nullable)	 		flt1_cpn_freq_n,
								number option(nullable)			flt1_reset_freq_n,
								day_count_method  option(nullable) flt1_day_count,
								interest_rule option(nullable) 	flt1_ir_rule ,
								ir_index option(nullable)		flt1_ir_index,
								number option(nullable) 		flt1_spread,
								stub_type option(nullable)		flt1_stub_type,
								date option(nullable)  			flt1_eff_date,
								date option(nullable)  			flt1_first_cpn_date,
								date option(nullable)  			flt1_last_reg_date,
								number	option(nullable) 		flt1_notional,
								number	option(nullable) 		flt1_pv01,
								number option(nullable) 		flt1_curr_fix,
								vector(date) option(nullable) 	flt1_fixing_dates ,	
								vector(number) option(nullable) flt1_fixing_rates,
								number option(nullable) 		flt1_fix_proxy ,
								logical option(nullable) 		flt1_allow_fwd_fix,
								//flt2
								string	option(nullable) 		flt2_ccy,
								logical	option(nullable)		flt2_is_mtm,
								number option(nullable)	 		flt2_cpn_freq_n,
								number option(nullable)			flt2_reset_freq_n,
								day_count_method  option(nullable) flt2_day_count,
								interest_rule option(nullable) 	flt2_ir_rule ,
								ir_index option(nullable)		flt2_ir_index,
								number option(nullable) 		flt2_spread,
								stub_type option(nullable)		flt2_stub_type,
								date option(nullable)  			flt2_eff_date,
								date option(nullable)  			flt2_first_cpn_date,
								date option(nullable)  			flt2_last_reg_date,
								number	option(nullable) 		flt2_notional,
								number option(nullable) 		flt2_curr_fix,
								vector(date) option(nullable) 	flt2_fixing_dates ,	
								vector(number) option(nullable) flt2_fixing_rates,
								number option(nullable) 		flt2_fix_proxy ,
								logical option(nullable) 		flt2_allow_fwd_fix)
	{
		if(null(flt1_notional) && null(flt2_notional))
			QL_REQUIRE(!null(flt1_pv01),"one of notionals and flt1_pv01 must be input");
		else if(null(flt1_pv01))
			QL_REQUIRE(!null(flt1_notional)|| !null(flt2_notional),"one of notionals and flt1_pv01 must be input");
		else if(!null(flt1_notional) && !null(flt2_notional) && !null(flt1_pv01))
			QL_FAIL("ambigious input of notionals and flt1_pv01");

		if(null(flt1_ccy))
			flt1_ccy = fp1_.flt_ccy_ ;
		
		if(null(flt2_ccy))
			flt2_ccy = fp2_.flt_ccy_ ;
		
		number 	flt1_fx_mult, flt2_fx_mult;
		set_fx_input(flt1_ccy,flt2_ccy, fx_quote, fx_quote_baseccy, fx_quote_priceccy, pv_in_base_ccy, flt1_notional,flt2_notional,flt1_fx_mult, flt2_fx_mult);

		integer pmt_delay = 0 ;//FIX_ME
		flt_stub_fwd_style flt_stub_rate_style = null;//FIX_ME
		number fix_start_stub = null;//FIX_ME
		number fix_end_stub = null;//FIX_ME
		//----flt1_parm-----
		fp1_.set_plain(	pmt_bus_day, pmt_cal, end_of_month, flt1_ccy, flt1_cpn_freq_n, flt1_reset_freq_n,flt1_day_count,
						flt1_ir_rule , flt1_ir_index, pmt_delay,pmt_delay,pmt_delay,pmt_delay,flt_stub_rate_style,flt1_spread,
						flt1_stub_type,flt1_eff_date, flt1_first_cpn_date,
						flt1_last_reg_date, flt1_notional, flt1_fx_mult, flt1_curr_fix,
						flt1_fixing_dates ,flt1_fixing_rates,flt1_fix_proxy ,flt1_allow_fwd_fix,fix_start_stub,fix_end_stub);	
		
		//----flt2_parm--------
		fp2_.set_plain(	pmt_bus_day, pmt_cal, end_of_month, flt2_ccy, flt2_cpn_freq_n, flt2_reset_freq_n,flt2_day_count,
						flt2_ir_rule , flt2_ir_index, pmt_delay,pmt_delay,pmt_delay,pmt_delay,flt_stub_rate_style,flt2_spread,
						flt2_stub_type,flt2_eff_date, flt2_first_cpn_date,
						flt2_last_reg_date, flt2_notional, flt2_fx_mult, flt2_curr_fix,
						flt2_fixing_dates ,flt2_fixing_rates,flt2_fix_proxy ,flt2_allow_fwd_fix,fix_start_stub,fix_end_stub);
		
		//---common---
		name_			= name;
		imp_calc_dec_  	= imp_sprd_dec;//rounding decimals of the implied cpn rate (on decimal value)
		pv01_not_unit_  = null(pv01_not_unit) ? -1: pv01_not_unit;//rounding unit for notional when implied from pv01
		pay_leg1_		= pay_float1;
		is_ccy_ 		= !equal_casei(flt1_ccy, flt2_ccy);
		
		if(null(notional_exchg)) {
			if(null(ne_))
				ne_ = is_ccy_ ? notional_exchg_style.NE_BOTH : notional_exchg_style.NE_NONE;
		}
		else {
			ne_ = notional_exchg;
		}

		if(!null(spot_settle_code))
			spot_code_ 	= spot_settle_code;
		trade_date_ 	= trade_date;
		fwd_start_code_ = fwd_start_code;
		start_date_ 	= start_date;
		maturity_ 		= maturity;
		if(!null(maturity_code))
			maturity_code_ 	= maturity_code;
		settle_date_	= settle_date;
		//cpn_roll_day_ 	= 0;
		
		if(is_ccy_){
			if(!null(flt1_is_mtm)) {
				is_mtm_leg1_ = flt1_is_mtm;
				if(is_mtm_leg1_)
					is_mtm_ = true;
			}
			if(!null(flt2_is_mtm) && flt2_is_mtm) {			
				is_mtm_ = true;
			}
		}
		//QL_FAIL_COND(is_mtm_ && is_mtm_leg1_,"mtm is only supported on leg2");
		
		this.start_date_helper();
		this.maturity_helper(fp1_);
		this.schedule_helper(fp1_);
		this.schedule_helper(fp2_);
		this.check();
		//if single ccy set_pv01/set_notional will also set the other notional as well as both fxrates to 1
		if(null(flt1_notional) && null(flt2_notional)){
			this.set_pv01(flt1_pv01);
		}
		else if(!null(flt1_notional)){
			this.set_notional_leg1(flt1_notional);
		}
		else if(!null(flt2_notional)){
			this.set_notional_leg2(flt2_notional);
		}
		
		is_inited_ = true;
	}
	/*-----------------------------------------------------------------------
	  set_plain  
	  ----------------------------------------------------------------------*/
	void fltflt_parm.set_plain(	string name,								
								date option(nullable) 			trade_date,
								date option(nullable) 			settle_date,
								
								date option(nullable) 			start_date,
								string option(nullable) 		fwd_start_code,
								date option(nullable)			maturity,
								string option(nullable) 		maturity_code,
								logical 						pay_float1,								
								integer 						imp_sprd_dec,
								number 	option(nullable) 		pv01_not_unit,
								number 		option(nullable) 	fx_quote,// as of settle but note for mtm we should use fx spot
								string 		option(nullable) 	fx_quote_baseccy,
								string 		option(nullable) 	fx_quote_priceccy,
								logical 	option(nullable) 	pv_in_base_ccy,
								//flt1
								number option(nullable) 		flt1_spread,
								stub_type option(nullable)		flt1_stub_type,
								date option(nullable)  			flt1_eff_date,
								date option(nullable)  			flt1_first_cpn_date,
								date option(nullable)  			flt1_last_reg_date,
								number	option(nullable) 		flt1_notional,
								number	option(nullable) 		flt1_pv01,
								number option(nullable) 		flt1_curr_fix,
								vector(date) option(nullable) 	flt1_fixing_dates ,	
								vector(number) option(nullable) flt1_fixing_rates,
								number option(nullable) 		flt1_fix_proxy ,
								logical option(nullable) 		flt1_allow_fwd_fix,
								//flt2
								number option(nullable) 		flt2_spread,
								stub_type option(nullable)		flt2_stub_type,
								date option(nullable)  			flt2_eff_date,
								date option(nullable)  			flt2_first_cpn_date,
								date option(nullable)  			flt2_last_reg_date,
								number	option(nullable) 		flt2_notional,
								number option(nullable) 		flt2_curr_fix,
								vector(date) option(nullable) 	flt2_fixing_dates ,	
								vector(number) option(nullable) flt2_fixing_rates,
								number option(nullable) 		flt2_fix_proxy ,
								logical option(nullable) 		flt2_allow_fwd_fix)
	{
		QL_FAIL_COND(null(is_ccy_),"fltflt_parm is not initalized (init_static() must be run) ");
		
		if(null(flt1_notional) && null(flt2_notional))
			QL_REQUIRE(!null(flt1_pv01),"one of notionals and flt1_pv01 must be input");
		else if(null(flt1_pv01))
			QL_REQUIRE(!null(flt1_notional)|| !null(flt2_notional),"one of notionals and flt1_pv01 must be input");
		else if(!null(flt1_notional) && !null(flt2_notional) && !null(flt1_pv01))
			QL_FAIL("ambigious input of notionals and flt1_pv01");
		
		number 	flt1_fx_mult, flt2_fx_mult;
		set_fx_input(fp1_.flt_ccy_,fp2_.flt_ccy_, fx_quote, fx_quote_baseccy, fx_quote_priceccy, pv_in_base_ccy, flt1_notional,flt2_notional,flt1_fx_mult, flt2_fx_mult);

		
		number fix_start_stub = null;//FIX_ME
		number fix_end_stub = null;//FIX_ME
		
		//----flt1_parm-----
		fp1_.set_plain(	null, null, null, null, null, null,null,
						null , null, null,null,null,null,null,flt1_spread, flt1_stub_type,flt1_eff_date, flt1_first_cpn_date,
						flt1_last_reg_date, flt1_notional, flt1_fx_mult, flt1_curr_fix,
						flt1_fixing_dates ,flt1_fixing_rates,flt1_fix_proxy ,flt1_allow_fwd_fix,fix_start_stub,fix_end_stub);	
		
		//----flt2_parm--------
		fp2_.set_plain(	null, null, null, null, null, null,null,
						null , null, null,null,null,null,null,flt2_spread, flt2_stub_type,flt2_eff_date, flt2_first_cpn_date,
						flt2_last_reg_date, flt2_notional, flt2_fx_mult, flt2_curr_fix,
						flt2_fixing_dates ,flt2_fixing_rates,flt2_fix_proxy ,flt2_allow_fwd_fix,fix_start_stub,fix_end_stub);
		
		//---common---
		name_			= name;
		imp_calc_dec_  	= imp_sprd_dec;//rounding decimals of the implied cpn rate (on decimal value)
		pv01_not_unit_  = null(pv01_not_unit) ? -1: pv01_not_unit;//rounding unit for notional when implied from pv01
		pay_leg1_		= pay_float1;

	
		trade_date_ 	= trade_date;
		fwd_start_code_ = fwd_start_code;
		start_date_ 	= start_date;
		maturity_ 		= maturity;
		if(!null(maturity_code))
			maturity_code_ 	= maturity_code;
		settle_date_	= settle_date;
		//cpn_roll_day_ 	= 0;
	
		//QL_FAIL_COND(is_mtm_ && is_mtm_leg1_,"mtm is only supported on leg2");
		
		this.start_date_helper();
		this.maturity_helper(fp1_);
		this.schedule_helper(fp1_);
		this.schedule_helper(fp2_);
		this.check();
		//if single ccy set_pv01/set_notional will also set the other notional as well as both fxrates to 1
		if(null(flt1_notional) && null(flt2_notional)){
			this.set_pv01(flt1_pv01);
		}
		else if(!null(flt1_notional)){
			this.set_notional_leg1(flt1_notional);
		}
		else if(!null(flt2_notional)){
			this.set_notional_leg2(flt2_notional);
		}
		is_inited_ = true;
	}
	/*-----------------------------------------------------------------------
	  primary_quote_is_leg1  CHECK
	  ----------------------------------------------------------------------*/
	logical fltflt_parm.primary_quote_is_leg1()
	{
		//return leg1_is_primary_quote(__instr_type.SWAP_FLTOIS,fp_.flt_ccy_,op_.ois_ccy_);
		integer rfreq1 = reset_freq_to_int(fp1_.flt_reset_freq_);
		integer rfreq2 = reset_freq_to_int(fp2_.flt_reset_freq_);
		return leg1_is_primary_quote(CORE_INT.conv_rev_instr_type(type()),fp1_.flt_ccy_,fp2_.flt_ccy_, rfreq1, rfreq2);
	}
	/*-----------------------------------------------------------------------
	  create_swap
	  ----------------------------------------------------------------------*/	
	swap_fltflt fltflt_parm.create_swap(disc_func option(nullable) 	flt1_disc_func,
										disc_func option(nullable) 	flt1_fwd_disc_func,
										disc_func option(nullable) 	flt2_disc_func,
										disc_func option(nullable) 	flt2_fwd_disc_func,
										logical option(nullable) 	allow_extrap)
	{
		return __create_swap(flt1_disc_func, null, flt1_fwd_disc_func,flt2_disc_func,  null, flt2_fwd_disc_func,allow_extrap);
	}
	/*-----------------------------------------------------------------------
	  create_swap
	  ----------------------------------------------------------------------*/	
	swap_fltflt fltflt_parm.create_swap(disc_func option(nullable) 	flt1_disc_func,
										fwd_func option(nullable) 	flt1_fwd_func, 
										disc_func option(nullable) 	flt2_disc_func,
										fwd_func option(nullable) 	flt2_fwd_func,
										logical option(nullable) 	allow_extrap)
	{
		return __create_swap(  flt1_disc_func, flt1_fwd_func, null, flt2_disc_func, flt2_fwd_func,null,allow_extrap);
	}
	
	/*-----------------------------------------------------------------------
	  __create_swap <protected>
	  ----------------------------------------------------------------------*/	
	swap_fltflt fltflt_parm.__create_swap(	disc_func option(nullable) 	flt1_disc_func,
											fwd_func option(nullable) 	flt1_fwd_func,
											disc_func option(nullable) 	flt1_fwd_disc_func,
											disc_func option(nullable) 	flt2_disc_func,
											fwd_func option(nullable) 	flt2_fwd_func,
											disc_func option(nullable) 	flt2_fwd_disc_func,
											logical option(nullable) 	allow_extrap)
	{
		/*ql_float_leg flt1;
		tenor_surface flt2_ts;
		create_swap_init_int(flt1_disc_func,flt1_fwd_func,flt1_fwd_disc_func,flt2_disc_func,flt2_fwd_func,
							flt2_fwd_disc_func,flt1,flt2_ts);*/
		
		//-----checks--------
		QL_FAIL_COND(!null(flt1_fwd_func) && !null(flt1_fwd_disc_func),"ambigious input leg1 (fwd_func/disc_func)");
		QL_FAIL_COND(!null(flt2_fwd_func) && !null(flt2_fwd_disc_func),"ambigious input leg2 (fwd_func/disc_func)");

		if(!is_ccy_ && !null(flt1_disc_func) && !null(flt2_disc_func))
			flt1_disc_func = flt2_disc_func;

		//-----defs--------
		ql_swap_float_def flt1_def 	= this.create_swap_float_def(fp1_,"flt_def1");
		QL_FAIL_COND(null(flt1_def),"error creating float leg1 def");
		ql_swap_float_def flt2_def 	= this.create_swap_float_def(fp2_,"flt_def2");
		QL_FAIL_COND(null(flt2_def),"error creating float leg2 def");

		//-----flt1 tenor surface--------
		tenor_surface flt1_ts;
		if(null(flt1_fwd_func) && null(flt1_fwd_disc_func)){
			flt1_ts = null;
		}
		else if(!null(flt1_fwd_func)){
			flt1_ts = create_flt_surface(fp1_, flt1_disc_func,flt1_fwd_func,null,allow_extrap);
			QL_FAIL_COND(null(flt1_ts),"error creating tenor surface1");
		}
		else{
			flt1_ts = create_flt_surface(fp1_, flt1_disc_func,null,flt1_fwd_disc_func,allow_extrap);
			QL_FAIL_COND(null(flt1_ts),"error creating tenor surface1");
		}

		//-----flt2 tenor surface--------
		tenor_surface flt2_ts;
		if(null(flt2_fwd_func) && null(flt2_fwd_disc_func)){
			flt2_ts = null;
		}
		else if(!null(flt2_fwd_func)){
			flt2_ts = create_flt_surface(fp2_, flt2_disc_func,flt2_fwd_func,null,allow_extrap);
			QL_FAIL_COND(null(flt2_ts),"error creating tenor surface2");
		}
		else{
			flt2_ts = create_flt_surface(fp2_, flt2_disc_func,null,flt2_fwd_disc_func,allow_extrap);
			QL_FAIL_COND(null(flt2_ts),"error creating tenor surface2");
		}
		
		//-----flt1 leg--------
		ql_float_leg flt1;
		if(is_mtm_leg1()){
			flt1 = this.create_swap_float_mtm_leg1(flt1_def, "float_leg1_mtm",pay_leg1_, flt1_disc_func, flt1_ts,flt2_disc_func);
			QL_FAIL_COND(null(flt1),"error creating float leg1 (mtm)");
		}
		else {
			flt1 = this.create_swap_float_leg(fp1_,flt1_def, "float_leg1",pay_leg1_, flt1_disc_func, flt1_ts);
			QL_FAIL_COND(null(flt1),"error creating float leg1");
		}
		
		//-----flt2 leg--------
		ql_float_leg flt2;
		if(is_mtm_leg2()){
			flt2 = this.create_swap_float_mtm_leg2(flt2_def, "float_leg2_mtm",!pay_leg1_, flt2_disc_func, flt2_ts,flt1_disc_func);
			QL_FAIL_COND(null(flt2),"error creating float leg2 (mtm)");
		}
		else {
			flt2 = this.create_swap_float_leg(fp2_,flt2_def, "float_leg2",!pay_leg1_, flt2_disc_func, flt2_ts);
			QL_FAIL_COND(null(flt2),"error creating float leg2");
		}
		
		//-----swap--------
		ql_fixed_income_swap sw 	= ql_fixed_income_swap(flt1,flt2,name_);
		QL_FAIL_COND(null(sw),"error creating swap");
		
		if(!null(fp1_.flt_curr_fix_))
			sw.float_leg(false)[0].set_current_fixing(fp1_.flt_curr_fix_);

		if(!null(fp2_.flt_curr_fix_))
			sw.float_leg(false)[1].set_current_fixing(fp2_.flt_curr_fix_);
		
		//----solve for rate if null-----
		if(null(fp1_.flt_spread_)) {
			number s	= sw.solver(0,swap_solver_code.SS_FLT_SPRD_LEG1,false);
			QL_FAIL_COND(null(s),"error calculating implied spread (leg1)", E_INIT);

			if(imp_calc_dec_ >= 0)
				s = round(s,imp_calc_dec_);
				
			fp1_.flt_spread_ = s;
			//---recreate float1 leg------

			if(is_mtm_leg1()){
				flt1 = this.create_swap_float_mtm_leg1(flt1_def, "float_leg1_mtm",pay_leg1_, flt1_disc_func, flt1_ts, flt2_disc_func);
				QL_FAIL_COND(null(flt1),"error creating float leg1 (mtm)");
			}
			else {
				flt1 = this.create_swap_float_leg(fp1_,flt1_def, "float_leg1",pay_leg1_, flt1_disc_func, flt1_ts);
				QL_FAIL_COND(null(flt1),"error creating float leg1");
			}
			
			//----recreate swap-------
			sw 		= ql_fixed_income_swap(flt1,flt2,name_);
			QL_FAIL_COND(null(sw),"error creating swap");

			if(!null(fp1_.flt_curr_fix_))
				sw.float_leg(false)[0].set_current_fixing(fp1_.flt_curr_fix_);

			if(!null(fp2_.flt_curr_fix_))
				sw.float_leg(false)[1].set_current_fixing(fp2_.flt_curr_fix_);
		}

		error_info ee 	= new error_info(true,true);
		swap_fltflt swff = swap_fltflt(sw, ee);

		//--calc notional if pv01 input---
		if(!null(leg_pv01_)) {
			
			number pv01_1m = swff.pv01_spread_leg1(1000000,null,null,ee);//keep 1000000 as notional because this is the default notional when notional is not input (not really necessary) 
			number flt_not 	= abs(leg_pv01_)/pv01_1m*1000000;

			if(pv01_not_unit_>0){
				number a = flt_not/pv01_not_unit_;
				a = round(a,0);
				flt_not = a * pv01_not_unit_;
			}
			//update parm with new notional
			fp1_.flt_notional_ = flt_not;
			fp2_.flt_notional_ = null;
			fx_notional_helper();

			//update the newly created swap with new notional
			if(!swff.is_cross_currency(ee)){
				swff.add_notional(fp1_.flt_notional_);
			}
			else {
				swff.add_notional(fp1_.flt_notional_, fp2_.flt_notional_);
			}
			
		/*		if(!is_mtm_leg1()){
					swff.add_notional_leg1(fp1_.flt_notional_);
				}
				else {
					flt1 = this.create_swap_float_mtm_leg1(flt1_def, "float_leg1_mtm",pay_leg1_, flt1_disc_func, flt1_ts, flt2_disc_func);
					QL_FAIL_COND(null(flt1),"error creating float leg1 (mtm)");
					sw 		= ql_fixed_income_swap(flt1,flt2,name_);
					QL_FAIL_COND(null(sw),"error creating swap");

					if(!null(fp1_.flt_curr_fix_))
						sw.float_leg(false)[0].set_current_fixing(fp1_.flt_curr_fix_);

					if(!null(fp2_.flt_curr_fix_))
						sw.float_leg(false)[1].set_current_fixing(fp2_.flt_curr_fix_);
				}
				if(!is_mtm_leg2()){
					swff.add_notional_leg2(fp2_.flt_notional_);
				}
				else {
					flt2 = this.create_swap_float_mtm_leg2(flt2_def, "float_leg2_mtm",!pay_leg1_, flt2_disc_func, flt2_ts,flt1_disc_func);
					QL_FAIL_COND(null(flt2),"error creating float leg2 (mtm)");
					
					sw 		= ql_fixed_income_swap(flt1,flt2,name_);
					QL_FAIL_COND(null(sw),"error creating swap");

					if(!null(fp1_.flt_curr_fix_))
						sw.float_leg(false)[0].set_current_fixing(fp1_.flt_curr_fix_);

					if(!null(fp2_.flt_curr_fix_))
						sw.float_leg(false)[1].set_current_fixing(fp2_.flt_curr_fix_);
				}
			}
			else {
				swff.add_notional(flt_not);
			}*/
		}
		return swff;
	}
	
}