option(null: hard);	

/*	
	swaplib wrapper functions
	Developer: Algorithmica Research, Magnus Nyström

	--------------------------------------------------------------------
	 	swap help functions for create funcs
	--------------------------------------------------------------------			
*/
module CORE_SWAPLIB
{
	
	/*-----------------------------------------------------------------------
	 -----------------------------------------------------------------------
	 -----class fltflt2s_parm--------------------------------------------------
	 -----leg1 == spread leg-----------------------------------------------------
	 -----------------------------------------------------------------------*/
	class fltflt2s_parm : public legleg_parm
	{
	public:
		override instr_type	type() ;
		
		fltflt2s_parm();
	
		void 				start_date_helper( );
		void 				fx_notional_helper();

		void				init_static(instr_def,string option(nullable) spot_code  );
		void				init_static(INSTR_TMPL.swap_fltflt2s_def_tmpl);
		void				init_static(swap_fltflt2s,string option(nullable) spot_code );
		void 				init_static(	string option(nullable) spot_code,
											bd_convention  		pmt_bus_day,
											calendar 			pmt_cal,
											logical				end_of_month,
											notional_exchg_style option(nullable) ne,
											string				ccy,
											//fix											
											integer 			fix_cpn_freq,
											day_count_method  	fix_day_count,
											interest_rule		fix_ir_rule,
											//flt1											
											integer 			flt_sprd_cpn_freq,											
											day_count_method 	flt_sprd_day_count,
											interest_rule		flt_sprd_ir_rule,
											ir_index 			flt_sprd_ir_index,
											//flt2											
											integer 			flt_flat_cpn_freq,										
											day_count_method 	flt_flat_day_count,
											interest_rule		flt_flat_ir_rule,
											ir_index 			flt_flat_ir_index);
		void 				set_notional(number);
		void 				set_pv01(number);
		fix_parm			fix_leg_parm_flat();
		fix_parm			fix_leg_parm_sprd();
		flt_parm 			flt_leg_parm_flat();
		flt_parm 			flt_leg_parm_sprd();
		

	protected:
				
		void 		check();
		//void 		__set_plain_vanilla();
		void 		__set_plain(	bd_convention option(nullable) 	pmt_bus_day,
									calendar option(nullable)	pmt_cal,
									logical	option(nullable) 	end_of_month,
									integer 					imp_sprd_dec,
									number option(nullable)		pv01_not_unit,
									string option(nullable),
									number option(nullable),
									//fix
									number option(nullable)		fix_cpn_freq_n,
									day_count_method option(nullable) fix_day_count,
									interest_rule option(nullable) 	,
									number	option(nullable)	fix_cpn_rate_flat,
									number	option(nullable)	fix_spread,
									//flt1	sprd												
									number option(nullable)		flt1_cpn_freq_n,
									day_count_method  option(nullable) flt1_day_count,
									interest_rule option(nullable) 	,
									ir_index option(nullable)	flt1_ir_index,
									number option(nullable) 	flt1_curr_fix,
									//flt2	flat												
									number option(nullable)		flt2_cpn_freq_n,
									day_count_method  option(nullable) flt2_day_count,
									interest_rule option(nullable) 	,
									ir_index option(nullable)	flt2_ir_index,
									number option(nullable) 	flt2_curr_fix );

		void 		__create_swap(//string 						name,
									//logical 					pay_fixed,
									disc_func option(nullable) 	disc_func,
									fwd_func option(nullable) 	flt1_fwd_func,
									fwd_func option(nullable) 	flt2_fwd_func,
									disc_func option(nullable) 	flt1_fwd_disc_func,
									disc_func option(nullable) 	flt2_fwd_disc_func,
									logical option(nullable),
									out swap_fixflt 			swap_flat,
									out swap_fixflt 			swap_sprd );
		swap_fltflt __create_swap(//	string 						name,
									//			logical 					pay_fixed_flat,
									disc_func option(nullable) 	disc_func,
									fwd_func option(nullable) 	flt1_fwd_func,//sprd
									fwd_func option(nullable) 	flt2_fwd_func,
									disc_func option(nullable) 	flt1_fwd_disc_func,//sprd
									disc_func option(nullable) 	flt2_fwd_disc_func,
									logical option(nullable) 	allow_extrap);
		
	public:
		void 		set_plain(	string 						name,							  
								date option(nullable) 		trade,
								date option(nullable) 		settle,
								string option(nullable) 	spot_settle_code,
								date option(nullable),
								string option(nullable) 		fwd_start_code,
								date option(nullable) 		mat,
								string option(nullable) 	mat_code,
								logical,
								bd_convention option(nullable) 	pmt_bus_day,
								calendar option(nullable)	pmt_cal,
								logical	option(nullable) 	end_of_month,

								string	option(nullable) 	ccy,
								integer 					imp_fix_rate_dec,
								number option(nullable) 	pv01_not_unit,
								number	option(nullable) 	notional,
								number	option(nullable) 	pv01,
								//fix
								number option(nullable)		fix_cpn_freq,
								day_count_method option(nullable) fix_day_count,
								interest_rule option(nullable) 	,
								number	option(nullable)	fix_cpn_rate_flat,
								number	option(nullable)	fix_spread,
								//flt1													
								number option(nullable)		flt1_cpn_freq,
								day_count_method  option(nullable)	flt1_day_count,
								interest_rule option(nullable) 	,
								ir_index option(nullable)	flt1_ir_index,
								number option(nullable) 	flt1_curr_fix,
								//flt2													
								number option(nullable)		flt2_cpn_freq,
								day_count_method  option(nullable)	flt2_day_count,
								interest_rule option(nullable) 	,
								ir_index option(nullable)	flt2_ir_index,
								number option(nullable) 	flt2_curr_fix);
		
		void 		set_plain(	string 						name,							  
								date option(nullable) 		trade,
								date option(nullable) 		settle,
								
								date option(nullable),
								string option(nullable) 		fwd_start_code,
								date option(nullable) 		mat,
								string option(nullable) 	mat_code,
								logical,
								integer 					imp_fix_rate_dec,
								number option(nullable) 	pv01_not_unit,
								number	option(nullable) 	notional,
								number	option(nullable) 	pv01,
								//fix
								number	option(nullable)	fix_cpn_rate_flat,
								number	option(nullable)	fix_spread,
								//flt1													
								number option(nullable) 	flt1_curr_fix,
								//flt2	
								number option(nullable) 	flt2_curr_fix);
				
		
		void		set_plain(	string,
								date option(nullable) 			trade_date,
								date option(nullable) 			settle_date,
								string option(nullable) 		spot_settle_code,
								date option(nullable) 			start_date,
								string option(nullable) 		fwd_start_code,
								date option(nullable)			maturity,
								string option(nullable) 		maturity_code,
								logical,
								bd_convention option(nullable)	pmt_bus_day,
								calendar option(nullable)		pmt_cal,
								logical	 option(nullable)		end_of_month,
								//notional_exchg_style option(nullable) notional_exchg,											
								string	 						ccy,
								integer 						imp_fix_rate_dec,
								number option(nullable) 		pv01_not_unit,
								number	option(nullable) 		notional,
								number	option(nullable) 		fix_pv01,
								//fix								
								number	option(nullable)		fix_cpn_freq_n,
								day_count_method option(nullable) fix_day_count,
								interest_rule option(nullable) 	fix_ir_rule ,
								number	option(nullable)		fix_cpn_rate_flat,
								number	option(nullable)		fix_spread,
								stub_type option(nullable)		fix_stub_type,
								date option(nullable)  			fix_eff_date,
								date option(nullable)  			fix_first_cpn_date,
								date option(nullable)  			fix_last_reg_date,								
								//flt1							
								number option(nullable)	 		flt1_cpn_freq_n,
								day_count_method  option(nullable) flt1_day_count,
								interest_rule option(nullable) 	flt1_ir_rule ,
								ir_index option(nullable)		flt1_ir_index,
								stub_type option(nullable)		flt1_stub_type,
								date option(nullable)  			flt1_eff_date,
								date option(nullable)  			flt1_first_cpn_date,
								date option(nullable)  			flt1_last_reg_date,							
								number option(nullable) 		flt1_curr_fix,
								vector(date) option(nullable) 	flt1_fixing_dates ,	
								vector(number) option(nullable) flt1_fixing_rates,
								number option(nullable) 		flt1_fix_proxy ,
								logical option(nullable) 		flt1_allow_fwd_fix,
								//flt2							
								number option(nullable)	 		flt2_cpn_freq_n,
								day_count_method  option(nullable) flt2_day_count,
								interest_rule option(nullable) 	flt2_ir_rule ,
								ir_index option(nullable)		flt2_ir_index,
								stub_type option(nullable)		flt2_stub_type,
								date option(nullable)  			flt2_eff_date,
								date option(nullable)  			flt2_first_cpn_date,
								date option(nullable)  			flt2_last_reg_date,							
								number option(nullable) 		flt2_curr_fix,
								vector(date) option(nullable) 	flt2_fixing_dates ,	
								vector(number) option(nullable) flt2_fixing_rates,
								number option(nullable) 		flt2_fix_proxy ,
								logical option(nullable) 		flt2_allow_fwd_fix);

		void		set_plain(	string,
								date option(nullable) 			trade_date,
								date option(nullable) 			settle_date,
								
								date option(nullable) 			start_date,
								string option(nullable) 		fwd_start_code,
								date option(nullable)			maturity,
								string option(nullable) 		maturity_code,
								logical,
								integer 						imp_fix_rate_dec,
								number option(nullable) 		pv01_not_unit,
								number	option(nullable) 		notional,
								number	option(nullable) 		fix_pv01,
								//fix								
								number	option(nullable)		fix_cpn_rate_flat,
								number	option(nullable)		fix_spread,
								stub_type option(nullable)		fix_stub_type,
								date option(nullable)  			fix_eff_date,
								date option(nullable)  			fix_first_cpn_date,
								date option(nullable)  			fix_last_reg_date,								
								//flt1							
								stub_type option(nullable)		flt1_stub_type,
								date option(nullable)  			flt1_eff_date,
								date option(nullable)  			flt1_first_cpn_date,
								date option(nullable)  			flt1_last_reg_date,							
								number option(nullable) 		flt1_curr_fix,
								vector(date) option(nullable) 	flt1_fixing_dates ,	
								vector(number) option(nullable) flt1_fixing_rates,
								number option(nullable) 		flt1_fix_proxy ,
								logical option(nullable) 		flt1_allow_fwd_fix,
								//flt2							
								stub_type option(nullable)		flt2_stub_type,
								date option(nullable)  			flt2_eff_date,
								date option(nullable)  			flt2_first_cpn_date,
								date option(nullable)  			flt2_last_reg_date,							
								number option(nullable) 		flt2_curr_fix,
								vector(date) option(nullable) 	flt2_fixing_dates ,	
								vector(number) option(nullable) flt2_fixing_rates,
								number option(nullable) 		flt2_fix_proxy ,
								logical option(nullable) 		flt2_allow_fwd_fix);
	
		void 		create_swap(	disc_func option(nullable) 	disc_func,
									disc_func option(nullable) 	,
									disc_func option(nullable) 	,
									out swap_fixflt 			,
									out swap_fixflt 			,
									logical option(nullable) 	allow_extrap , logical);
		void 		create_swap(	disc_func option(nullable) 	disc_func,
									fwd_func option(nullable) 	,
									fwd_func option(nullable) 	,
									out swap_fixflt 			,
									out swap_fixflt 			,
									logical option(nullable) 	allow_extrap  , logical);

		swap_fltflt create_swap(disc_func option(nullable) 	disc_func,
								fwd_func option(nullable) 	flt_sprd_fwd_func,
								fwd_func option(nullable) 	flt_flat_fwd_func,
								logical option(nullable) 	allow_extrap);

		swap_fltflt create_swap(disc_func option(nullable) 	disc_func,
								disc_func option(nullable) 	flt_sprd_fwd_func,
								disc_func option(nullable) 	flt_flat_fwd_func,
								logical option(nullable) 	allow_extrap );
		
		fix_parm 	fip1_;
		fix_parm 	fip2_;
		flt_parm	fp1_;
		flt_parm	fp2_;

		number		fix_spread_;
	};

	/*-----------------------------------------------------------------------
	  constructor
	  ----------------------------------------------------------------------*/
	fltflt2s_parm.fltflt2s_parm()
	{
		fip1_ 			= new fix_parm();
		fip2_ 			= new fix_parm();
		fp1_ 			= new flt_parm();
		fp2_ 			= new flt_parm();
		fix_spread_		= null;
	}
	/*-----------------------------------------------------------------------
	  type
	  ----------------------------------------------------------------------*/
	instr_type fltflt2s_parm.type() { return instr_type.SWAP_FLTFLT2S;}
	/*-----------------------------------------------------------------------
	  fix_leg_parm / flt_leg_parm
	  ----------------------------------------------------------------------*/
	fix_parm fltflt2s_parm.fix_leg_parm_sprd() { return fip1_;}
	fix_parm fltflt2s_parm.fix_leg_parm_flat() { return fip2_;}
	flt_parm fltflt2s_parm.flt_leg_parm_sprd() { return fp1_;}
	flt_parm fltflt2s_parm.flt_leg_parm_flat() { return fp2_;}
	
	/*-----------------------------------------------------------------------
	  ccy_helper
	  ----------------------------------------------------------------------*/
	void fltflt2s_parm.fx_notional_helper()
	{
		//never cross curr
		fip2_.fix_notional_		= fip1_.fix_notional_;
		fp1_.flt_notional_		= fip1_.fix_notional_;		
		fp2_.flt_notional_		= fip1_.fix_notional_;
		
		fip1_.fix_fx_mult_		= 1;
		fip2_.fix_fx_mult_		= 1;
		fp1_.flt_fx_mult_		= 1;
		fp2_.flt_fx_mult_		= 1;
	}
	/*-----------------------------------------------------------------------
	  start_date_helper  //FIX_ME for the fact that we have 2 flt legs
	  ----------------------------------------------------------------------*/	
	void fltflt2s_parm.start_date_helper()
	{
		legleg_parm.start_date_helper(fip1_.fix_eff_date_, fp1_.flt_eff_date_, fp1_.flt_pmt_calendar_);
	}
	/*-----------------------------------------------------------------------
	  check
	  ----------------------------------------------------------------------*/
	void fltflt2s_parm.check()
	{
		if(is_aged_swap()){
			QL_REQUIRE(!null(fip2_.fix_coupon_rate_),"fix coupon rate for flat leg required for aged swap");
			if(null(fip1_.fix_coupon_rate_))
				QL_REQUIRE(!null(fix_spread_),"fix coupon rate for flat leg or fix_spread required for aged swap");
			if(null(fix_spread_))
				QL_REQUIRE(!null(fip1_.fix_coupon_rate_),"fix coupon rate for flat leg or fix_spread required for aged swap");
			
			QL_REQUIRE(!null(fip1_.fix_notional_),"notional is required for aged swap");
		}
	}
	/*-----------------------------------------------------------------------
	  set_notional
	  ----------------------------------------------------------------------*/
	void fltflt2s_parm.set_notional(number not)
	{
		fip1_.fix_notional_ = not;
		leg_pv01_ 			= null;
		fx_notional_helper();
	}
	/*-----------------------------------------------------------------------
	  set_notional
	  ----------------------------------------------------------------------*/
	void fltflt2s_parm.set_pv01(number pv01)
	{
		fip1_.fix_notional_ = 1000000;
		leg_pv01_ 			= pv01;
		fx_notional_helper();
	}
	/*-----------------------------------------------------------------------
	  init_basic_static
	  Note: a possible maturity code in the template is never "carried over" to the swap
	  Note to self: tmpl --> def --> ql_fixed_income_swap --> swap_fixflt (and the def is lost in the process since it is only part of the translation)
					(a direct route without the def is possible but not sure if it will save much compute time)
	  ----------------------------------------------------------------------*/
	void fltflt2s_parm.init_static(INSTR_TMPL.swap_fltflt2s_def_tmpl tmpl )
	{
		//----fixflt_parm-----		
		is_ccy_ 		= false;		
		ne_ 			= tmpl.not_exchange();
		if(null(ne_))
			ne_ 	= is_ccy_ ? NE_BOTH : NE_NONE;
		
		spot_code_ 		= tmpl.spot_settle_code();
		trade_date_ 	= null;
		maturity_ 		= null;
		maturity_code_ 	= tmpl.maturity_code();
		mat_code_ 		= null;
		fwd_start_code_ = null;//tmpl.fwd_start_code();
		start_date_ 	= null;
		settle_date_	= null;
		//cpn_roll_day_ 	= 0;
		
		//fix1
		fix_roll_method	roll 		= fix_roll_method.FIR_STRAIGHT;
		logical const_cpn 			= false;		
		..fix_comp_freq comp_freq 	= fix_comp_freq.FCF_AS_FREQ;
		logical compound_to_mat		= false;
		
		fip1_.init_static(tmpl.fix_bd_convention(), tmpl.calendar(),tmpl.fix_eom(),tmpl.currency(), 
							tmpl.fix_cpn_freq(), tmpl.fix_day_count_method(),tmpl.fix_ir_rule(),0,0,0,0,null,
						  roll, const_cpn, comp_freq,compound_to_mat);

		//fix2
		fip2_.init_static(tmpl.fix_bd_convention(), tmpl.calendar(),tmpl.fix_eom(),tmpl.currency(), 
							tmpl.fix_cpn_freq(), tmpl.fix_day_count_method(),tmpl.fix_ir_rule(),0,0,0,0,null,
						  roll, const_cpn, comp_freq,compound_to_mat);
	
		//----flt_parm1--------
		//flt
		integer flt1_sprd_r_freq = null(tmpl.flt_sprd_reset_freq()) ? tmpl.flt_sprd_cpn_freq() : integer(tmpl.flt_sprd_reset_freq());
		//tmpl.flt_comp_avg()
		//tmpl.flt_spread_comp_method(),
		//tmpl.flt_avg_method(),
		..flt_roll_method flt_roll 	= ..flt_roll_method.FLR_STRAIGHT;
		logical flt_compound_to_mat = false;
		
		fp1_.init_static(tmpl.flt_sprd_bd_convention(),tmpl.calendar(),tmpl.flt_sprd_eom(),tmpl.currency(),
						tmpl.flt_sprd_cpn_freq(), flt1_sprd_r_freq,
						tmpl.flt_sprd_day_count_method(),tmpl.flt_sprd_ir_rule(),tmpl.flt_sprd_ir_index(),0,0,0,0,
						null,null,null,null,flt_roll,flt_compound_to_mat,tmpl.flt_sprd_fwd_stub_rate_style());

		//----flt_parm2--------
		//flt
		integer flt2_flat_r_freq = null(tmpl.flt_flat_reset_freq()) ? tmpl.flt_flat_cpn_freq() : integer(tmpl.flt_flat_reset_freq());
		//tmpl.flt_comp_avg()
		//tmpl.flt_spread_comp_method(),
		//tmpl.flt_avg_method(),
		fp2_.init_static(tmpl.flt_flat_bd_convention(),tmpl.calendar(),tmpl.flt_flat_eom(),tmpl.currency(),
								tmpl.flt_flat_cpn_freq(), flt2_flat_r_freq,
								tmpl.flt_flat_day_count_method(),tmpl.flt_flat_ir_rule(),tmpl.flt_flat_ir_index(),0,0,0,0,
								null,null,null,null,flt_roll,flt_compound_to_mat,tmpl.flt_flat_fwd_stub_rate_style());
		
	}
	/*-----------------------------------------------------------------------
	  init_basic_static
	  ----------------------------------------------------------------------*/
	void fltflt2s_parm.init_static(instr_def  def,
								   string option(nullable) spot_code)
	{
		QL_REQUIRE(CORE_INT.check_instr_def(def),"invalid instr_def");
		QL_FAIL_COND(!def.is_swap_fltflt2s(), "instr_def not a float-float (2 swaps) swap", E_INIT);

		//----fltflt2s_parm-----		
		is_ccy_ 		= def.is_ccy_swap();
		QL_REQUIRE(!is_ccy_,"cross currency not supported for float-float (2 swaps)");
		error_info ees 	= new  error_info(true,false);
		ne_ 			= def.swap_not_exchange(ees);
		if(null(ne_))
			ne_ 	= is_ccy_ ? NE_BOTH : NE_NONE;

		spot_code_ 		= null(spot_code) ? "BD2" : spot_code;
		trade_date_ 	= null;
		maturity_ 		= null;
		maturity_code_ 	= def.maturity_code(ees);
		mat_code_ 		= null;
		fwd_start_code_ = null;
		start_date_ 	= null;
		settle_date_	= null;
		//cpn_roll_day_ 	= 0;
		
		fip1_.init_static(def);
		fip2_.init_static(def);
		fp1_.init_basic_static_leg1(def);
		fp2_.init_basic_static_leg2(def);
	}
	
	/*-----------------------------------------------------------------------
	  init_basic_static
	  ----------------------------------------------------------------------*/	
	void fltflt2s_parm.init_static(swap_fltflt2s sw_base,
								   string option(nullable) spot_code)	//ext swap i.e. instr_def = null
	{
		//----fltflt2s_parm-----
		error_info ee 	= new error_info(true,true);
		is_ccy_ 		= sw_base.is_ccy_swap();
		QL_REQUIRE(!is_ccy_,"cross currency not supported for float-float (2 swaps)");
		ne_ 			= NE_NONE;//sw_base.notional_exchg_style_fix_leg(ee);		//assume both legs are same
		spot_code_ 		= null(spot_code) ? "BD2" : spot_code;
		trade_date_ 	= null;
		maturity_ 		= null;
		maturity_code_ 	= null;
		mat_code_ 		= null;
		fwd_start_code_ = null;
		start_date_ 	= null;
		settle_date_	= null;
		//cpn_roll_day_ 	= 0;
				
		//----fix_parm1--------
		integer cfreq_fix = sw_base.coupon_freq_fix_leg(ee);
		fix_roll_method	roll 		= fix_roll_method.FIR_STRAIGHT;
		logical const_cpn 			= false;		
		..fix_comp_freq comp_freq 	= fix_comp_freq.FCF_AS_FREQ;
		logical compound_to_mat		= false;
		
		fip1_.init_static(	sw_base.pmt_bus_day_fix_leg(ee), sw_base.calendar_fix_leg(ee),sw_base.eom_fix_leg(ee),
							sw_base.currency(ee), cfreq_fix, sw_base.dc_method_fix_leg(ee),
							sw_base.ir_rule_fix_leg(ee),0,0,0,0,null,
						  roll, const_cpn, comp_freq,compound_to_mat);
		//----fix_parm2--------
		fip2_.init_static(	sw_base.pmt_bus_day_fix_leg(ee), sw_base.calendar_fix_leg(ee),sw_base.eom_fix_leg(ee),
							sw_base.currency(ee), cfreq_fix, sw_base.dc_method_fix_leg(ee),
							sw_base.ir_rule_fix_leg(ee),0,0,0,0,null,
						  roll, const_cpn, comp_freq,compound_to_mat);
		
		//----flt_parm1--------

		flt_comp_avg_type comp_avg_type 		= flt_comp_avg_type.CA_COMP;//for now because we don't have a member func for this one
		flt_sprd_comp_method sprd_comp_method 	= flt_sprd_comp_method.SC_FLAT;//for now because we don't have a member func for this one
		flt_avg_method avg_method 				= flt_avg_method.AVG_UNWEIGHTED;//for now because we don't have a member func for this one
		..flt_roll_method flt_roll 				= ..flt_roll_method.FLR_STRAIGHT;
		logical flt_compound_to_mat 			= false;
		
		integer cfreq_sprd = sw_base.coupon_freq_sprd_leg(ee);
		fp1_.init_static(sw_base.pmt_bus_day_sprd_leg(ee),sw_base.calendar_sprd_leg(ee),sw_base.eom_sprd_leg(ee),sw_base.currency(ee),
									cfreq_sprd, sw_base.reset_freq_sprd_leg(ee),
									sw_base.dc_method_sprd_leg(ee),sw_base.ir_rule_sprd_leg(ee),sw_base.ir_index_sprd_leg(ee),0,0,0,0,
									comp_avg_type, sprd_comp_method, avg_method,null,flt_roll,flt_compound_to_mat,null);
		//----flt_parm2--------
		integer cfreq_flat = sw_base.coupon_freq_flat_leg(ee);
		fp2_.init_static(sw_base.pmt_bus_day_flat_leg(ee),sw_base.calendar_flat_leg(ee),sw_base.eom_flat_leg(ee),sw_base.currency(ee),
									cfreq_flat, sw_base.reset_freq_flat_leg(ee),
									sw_base.dc_method_flat_leg(ee),sw_base.ir_rule_flat_leg(ee),sw_base.ir_index_flat_leg(ee),0,0,0,0,
									comp_avg_type, sprd_comp_method, avg_method,null,flt_roll,flt_compound_to_mat,null);
		
	}
	/*-----------------------------------------------------------------------
	  init_basic_static
	  ----------------------------------------------------------------------*/
	void fltflt2s_parm.init_static(	string 	option(nullable)	spot_code,
									bd_convention  		pmt_bus_day,
									calendar 			pmt_cal,
									logical				end_of_month,
									notional_exchg_style option(nullable) ne,
									string				ccy,
									//fix											
									integer 			fix_cpn_freq,
									day_count_method  	fix_day_count,
									interest_rule		fix_ir_rule,
									//flt1											
									integer 			flt_sprd_cpn_freq,											
									day_count_method 	flt_sprd_day_count,
									interest_rule		flt_sprd_ir_rule,
									ir_index 			flt_sprd_ir_index,
									//flt2											
									integer 			flt_flat_cpn_freq,										
									day_count_method 	flt_flat_day_count,
									interest_rule		flt_flat_ir_rule,
									ir_index 			flt_flat_ir_index)
	{		
		//----fltflt2s_parm-----		
		is_ccy_ 		= false;	
		ne_ 			= ne;
		if(null(ne_))
			ne_ = is_ccy_ ? NE_BOTH : NE_NONE;

		spot_code_ 		= null(spot_code) ? "BD2" : spot_code;
		trade_date_ 	= null;
		maturity_ 		= null;
		maturity_code_ 	= null;
		mat_code_ 		= null;
		fwd_start_code_ = null;
		start_date_ 	= null;
		settle_date_	= null;
		//cpn_roll_day_ 	= 0;

		//----fix_parm1--------
		fix_roll_method	roll 		= fix_roll_method.FIR_STRAIGHT;
		logical const_cpn 			= false;		
		..fix_comp_freq comp_freq 	= fix_comp_freq.FCF_AS_FREQ;
		logical compound_to_mat		= false;
		
		fip1_.init_static(	pmt_bus_day, pmt_cal,end_of_month,ccy,
							fix_cpn_freq, fix_day_count,fix_ir_rule,0,0,0,0,null,
							roll, const_cpn, comp_freq,compound_to_mat);
		//----fix_parm2--------
		fip2_.init_static(	pmt_bus_day, pmt_cal,end_of_month,ccy,
							fix_cpn_freq, fix_day_count,fix_ir_rule,0,0,0,0,null,
							roll, const_cpn, comp_freq,compound_to_mat);
		
		//---flt1---
		..flt_roll_method flt_roll 	= ..flt_roll_method.FLR_STRAIGHT;
		logical flt_compound_to_mat = false;
		integer flt_sprd_reset_freq = flt_sprd_cpn_freq;
		fp1_.init_static(pmt_bus_day,pmt_cal,end_of_month,ccy,
								flt_sprd_cpn_freq, flt_sprd_reset_freq,flt_sprd_day_count,flt_sprd_ir_rule,flt_sprd_ir_index,
								0,0,0,0,null, null, null,null,flt_roll,flt_compound_to_mat,null);

		//---flt2---
		integer flt_flat_reset_freq = flt_flat_cpn_freq;
		
		fp2_.init_static(pmt_bus_day,pmt_cal,end_of_month,ccy,
								flt_flat_cpn_freq, flt_flat_reset_freq,flt_flat_day_count,flt_flat_ir_rule,flt_flat_ir_index,
								0,0,0,0,null, null, null,null,flt_roll,flt_compound_to_mat,null);
	}
	/*-----------------------------------------------------------------------
	  set_plain_vanilla
	  ----------------------------------------------------------------------*/
	/*void fltflt2s_parm.__set_plain_vanilla()
	{
		
		// ----fltflt2s_parm-------
		//will not set:
		//	is_ccy;
		//	ne;
		//	settle_code;			

		//	trade_date;
		//	maturity;
		//	maturity_code;
		//	mat_code;
		//	fwd_start_code;
		//	start_date;
		//	settle_date
		
		cpn_roll_day_ = 0;
		
		// ----fix_parm1-------
		fip1_.set_plain_vanilla();
		// ----fix_parm2-------
		fip2_.set_plain_vanilla();
		// ----flt parm1-------
		fp1_.set_plain_vanilla();
		// ----flt parm2-------
		fp2_.set_plain_vanilla();

	}*/
	/*-----------------------------------------------------------------------
	  __set_spot_fwd  <protected>    internal
	  ----------------------------------------------------------------------*/
	void fltflt2s_parm.__set_plain(	bd_convention option(nullable) 	pmt_bus_day,
									calendar option(nullable)	pmt_cal,
									logical	option(nullable) 	end_of_month,
									integer 					imp_fix_rate_dec,
									number option(nullable)		pv01_not_unit,
									string	option(nullable) 	ccy,
									number option(nullable)		notional,
									//fix
									number option(nullable)		fix_cpn_freq_n,
									day_count_method option(nullable) fix_day_count,
									interest_rule option(nullable) 	fix_ir_rule ,
									number	option(nullable)	fix_cpn_rate_flat,
									number	option(nullable)	fix_spread,
									//flt1													
									number option(nullable)		flt1_cpn_freq_n,
									day_count_method  option(nullable) flt1_day_count,
									interest_rule option(nullable) 	flt1_ir_rule ,
									ir_index option(nullable)	flt1_ir_index,
									number option(nullable) 	flt1_curr_fix,
									//flt2													
									number option(nullable)		flt2_cpn_freq_n,
									day_count_method  option(nullable) flt2_day_count,
									interest_rule option(nullable) 	flt2_ir_rule ,
									ir_index option(nullable)	flt2_ir_index,
									number option(nullable) 	flt2_curr_fix)
	{
		imp_calc_dec_  	= imp_fix_rate_dec;//rounding decimals of the implied cpn rate (on decimal value)
		pv01_not_unit_  = null(pv01_not_unit) ? -1: pv01_not_unit;//rounding unit for notional when implied from pv01
		
		fix_spread_ = /*null(fix_spread) ? 0 :*/ fix_spread;
		number r = null(fix_cpn_rate_flat) || null(fix_spread) ? null : fix_cpn_rate_flat - fix_spread_;
		fip1_.set_plain(pmt_bus_day, pmt_cal, end_of_month, ccy, fix_cpn_freq_n, fix_day_count, fix_ir_rule,0,0,0,0,r,
						stub_type.SHORT_FIRST,null,null,null,notional,null);
		fip2_.set_plain(pmt_bus_day, pmt_cal, end_of_month, ccy, fix_cpn_freq_n, fix_day_count, fix_ir_rule,0,0,0,0,fix_cpn_rate_flat,
						stub_type.SHORT_FIRST,null,null,null,notional,null);

		number flt1_reset_freq_n = flt1_cpn_freq_n;
		fp1_.set_plain(pmt_bus_day, pmt_cal, end_of_month, ccy, flt1_cpn_freq_n, flt1_reset_freq_n,flt1_day_count, flt1_ir_rule,
					   flt1_ir_index,0,0,0,0,null,0,stub_type.SHORT_FIRST,null,null,null,notional,null,flt1_curr_fix,
					   null,null,null,false,null,null);
		
		number flt2_reset_freq_n = flt2_cpn_freq_n;
		fp2_.set_plain(pmt_bus_day, pmt_cal, end_of_month, ccy, flt2_cpn_freq_n, flt2_reset_freq_n,flt2_day_count, flt2_ir_rule,
					   flt2_ir_index,0,0,0,0,null,0,stub_type.SHORT_FIRST,null,null,null,notional,null,flt2_curr_fix,
					   null,null,null,false,null,null);
	}

	/*-----------------------------------------------------------------------
	  set_plain <ALL ARGS>
	  ----------------------------------------------------------------------*/
	void fltflt2s_parm.set_plain(//common
								string 						name,								
								date option(nullable) 		trade_date,
								date option(nullable) 		settle_date,
								string option(nullable) 	spot_settle_code,
								date option(nullable) 		start_date,
								string option(nullable) 	fwd_start_code,
								date option(nullable) 		maturity,
								string option(nullable) 	maturity_code,
								logical						pay_sprd_leg,
								bd_convention option(nullable) 	pmt_bus_day,
								calendar option(nullable)	pmt_cal,
								logical	option(nullable) 	end_of_month,
								string	option(nullable) 	ccy,
								integer 					imp_fix_rate_dec,
								number option(nullable) 	pv01_not_unit,
								number	option(nullable) 	notional,
								number	option(nullable) 	fix_pv01,
								//fix
								number option(nullable)		fix_cpn_freq_n,
								day_count_method option(nullable) fix_day_count,
								interest_rule option(nullable) 	fix_ir_rule ,
								number	option(nullable)	fix_cpn_rate_flat,
								number	option(nullable)	fix_spread,
								//flt1													
								number option(nullable)		flt_sprd_cpn_freq_n,
								day_count_method  option(nullable) flt_sprd_day_count,
								interest_rule option(nullable) 	flt_sprd_ir_rule ,
								ir_index option(nullable)	flt_sprd_ir_index,
								number option(nullable) 	flt_sprd_curr_fix,
								//flt2													
								number option(nullable)		flt_flat_cpn_freq_n,
								day_count_method  option(nullable) flt_flat_day_count,
								interest_rule option(nullable) 	flt_flat_ir_rule ,
								ir_index option(nullable)	flt_flat_ir_index,
								number option(nullable) 	flt_flat_curr_fix)
	{
		if(null(notional))
			QL_REQUIRE(!null(fix_pv01),"one of notional and pv01 must be input");
		else if(null(fix_pv01))
			QL_REQUIRE(!null(notional),"one of notional and pv01 must be input");
		else if(!null(notional) && !null(fix_pv01))
			QL_FAIL("ambigious input of notional and pv01");
		
		this.__set_plain(	pmt_bus_day,pmt_cal,end_of_month,imp_fix_rate_dec,pv01_not_unit,ccy,notional,
							fix_cpn_freq_n,fix_day_count,fix_ir_rule,fix_cpn_rate_flat,fix_spread,
							flt_sprd_cpn_freq_n,flt_sprd_day_count,flt_sprd_ir_rule,flt_sprd_ir_index,flt_sprd_curr_fix,
							flt_flat_cpn_freq_n,flt_flat_day_count,flt_flat_ir_rule,flt_flat_ir_index,flt_flat_curr_fix);

		//-----common--------
		name_			= name;
		pay_leg1_		= pay_sprd_leg;
		is_ccy_ 		= false;
		if(!null(spot_settle_code))
			spot_code_ 	= spot_settle_code;
		trade_date_ 	= trade_date;
		fwd_start_code_ = fwd_start_code;
		start_date_ 	= start_date;
		maturity_ 		= maturity;
		if(!null(maturity_code))
			maturity_code_ 	= maturity_code;
		settle_date_	= settle_date;
		//cpn_roll_day_ 	= 0;

		this.start_date_helper();
		this.maturity_helper(fip1_);
		this.check();
		//if single ccy set_pv01/set_notional will also set the other notional as well as both fxrates to 1
		if(null(notional))
			this.set_pv01(fix_pv01);
		else
			this.set_notional(notional);
		ne_ = notional_exchg_style.NE_NONE;
		is_inited_ = true;
	}

	/*-----------------------------------------------------------------------
	  set_plain 
	  ----------------------------------------------------------------------*/
	void fltflt2s_parm.set_plain(//common
								string name,								
								date option(nullable) 		trade_date,
								date option(nullable) 		settle_date,
								
								date option(nullable) 		start_date,
								string option(nullable) 	fwd_start_code,
								date option(nullable) 		maturity,
								string option(nullable) 	maturity_code,
								logical						pay_sprd_leg,
								integer 					imp_fix_rate_dec,
								number option(nullable) 	pv01_not_unit,
								number	option(nullable) 	notional,
								number	option(nullable) 	fix_pv01,
								//fix
								number	option(nullable)	fix_cpn_rate_flat,
								number	option(nullable)	fix_spread,
								//flt1													
								number option(nullable) 	flt_sprd_curr_fix,
								//flt2	
								number option(nullable) 	flt_flat_curr_fix)
	{
		QL_FAIL_COND(null(is_ccy_),"fltflt2s_parm is not initalized (init_static() must be run) ");
		QL_REQUIRE(!is_ccy_,"function not applicable to cross currency swaps");
		
		if(null(notional))
			QL_REQUIRE(!null(fix_pv01),"one of notional and pv01 must be input");
		else if(null(fix_pv01))
			QL_REQUIRE(!null(notional),"one of notional and pv01 must be input");
		else if(!null(notional) && !null(fix_pv01))
			QL_FAIL("ambigious input of notional and pv01");
		
		this.__set_plain(	null,null,null,imp_fix_rate_dec,pv01_not_unit,null,notional,
							null,null,null,fix_cpn_rate_flat,fix_spread,
							null,null,null,null,flt_sprd_curr_fix,
							null,null,null,null,flt_flat_curr_fix);

		//-----common--------
		name_			= name;
		pay_leg1_		= pay_sprd_leg;
		trade_date_ 	= trade_date;
		fwd_start_code_ = fwd_start_code;
		start_date_ 	= start_date;
		maturity_ 		= maturity;
		if(!null(maturity_code))
			maturity_code_ 	= maturity_code;
		settle_date_	= settle_date;
		//cpn_roll_day_ 	= 0;

		this.start_date_helper();
		this.maturity_helper(fip1_);
		this.check();
		//if single ccy set_pv01/set_notional will also set the other notional as well as both fxrates to 1
		if(null(notional))
			this.set_pv01(fix_pv01);
		else
			this.set_notional(notional);
		
		is_inited_ = true;
	}
	
	/*-----------------------------------------------------------------------
	  set_plain <ALL ARGS>
	  ----------------------------------------------------------------------*/
	void fltflt2s_parm.set_plain(string name,								
								date option(nullable) 			trade_date,
								date option(nullable) 			settle_date,
								string option(nullable) 		spot_settle_code,
								date option(nullable) 			start_date,
								 string option(nullable) 		fwd_start_code,
								date option(nullable)			maturity,
								string option(nullable) 		maturity_code,
								logical 						pay_sprd_leg,
								bd_convention option(nullable)	pmt_bus_day,
								calendar option(nullable)		pmt_cal,
								logical	 option(nullable)		end_of_month,										
								string	 						ccy,
								integer 						imp_fix_rate_dec,
								number option(nullable) 		pv01_not_unit,
								number	option(nullable) 		notional,
								number	option(nullable) 		fix_pv01,
								//fix
								number	option(nullable)		fix_cpn_freq_n,
								day_count_method option(nullable) fix_day_count,
								interest_rule option(nullable) 	fix_ir_rule ,
								number	option(nullable)		fix_cpn_rate_flat,
								number	option(nullable)		fix_spread,
								stub_type option(nullable)		fix_stub_type,
								date option(nullable)  			fix_eff_date,
								date option(nullable)  			fix_first_cpn_date,
								date option(nullable)  			fix_last_reg_date,
								//flt1							
								number option(nullable)	 		flt_sprd_cpn_freq_n,
								day_count_method  option(nullable) flt_sprd_day_count,
								interest_rule option(nullable) 	flt_sprd_ir_rule ,
								ir_index option(nullable)		flt_sprd_ir_index,
								stub_type option(nullable)		flt_sprd_stub_type,
								date option(nullable)  			flt_sprd_eff_date,
								date option(nullable)  			flt_sprd_first_cpn_date,
								date option(nullable)  			flt_sprd_last_reg_date,							
								number option(nullable) 		flt_sprd_curr_fix,
								vector(date) option(nullable) 	flt_sprd_fixing_dates ,	
								vector(number) option(nullable) flt_sprd_fixing_rates,
								number option(nullable) 		flt_sprd_fix_proxy ,
								logical option(nullable) 		flt_sprd_allow_fwd_fix,
								//flt2							
								number option(nullable)	 		flt_flat_cpn_freq_n,
								day_count_method  option(nullable) flt_flat_day_count,
								interest_rule option(nullable) 	flt_flat_ir_rule ,
								ir_index option(nullable)		flt_flat_ir_index,
								stub_type option(nullable)		flt_flat_stub_type,
								date option(nullable)  			flt_flat_eff_date,
								date option(nullable)  			flt_flat_first_cpn_date,
								date option(nullable)  			flt_flat_last_reg_date,							
								number option(nullable) 		flt_flat_curr_fix,
								vector(date) option(nullable) 	flt_flat_fixing_dates ,	
								vector(number) option(nullable) flt_flat_fixing_rates,
								number option(nullable) 		flt_flat_fix_proxy ,
								logical option(nullable) 		flt_flat_allow_fwd_fix)
	{
		if(null(notional))
			QL_REQUIRE(!null(fix_pv01),"one of notional and fix_pv01 must be input");
		else if(null(fix_pv01))
			QL_REQUIRE(!null(notional),"one of notional and fix_pv01 must be input");
		else if(!null(notional) && !null(fix_pv01))
			QL_FAIL("ambigious input of notional and fix_pv01");

		fix_spread_ = /*null(fix_spread) ? 0 :*/ fix_spread;
		number r = null(fix_cpn_rate_flat)  || null(fix_spread) ? null : fix_cpn_rate_flat - fix_spread_;

		//----fix_parm1-----
		fip1_.set_plain(pmt_bus_day, pmt_cal, end_of_month, ccy, fix_cpn_freq_n, fix_day_count, fix_ir_rule ,0,0,0,0,
						r, fix_stub_type,fix_eff_date, fix_first_cpn_date, fix_last_reg_date, notional, 1);
		
		//----fix_parm2-----
		fip2_.set_plain(pmt_bus_day, pmt_cal, end_of_month, ccy, fix_cpn_freq_n, fix_day_count, fix_ir_rule ,0,0,0,0,
						fix_cpn_rate_flat, fix_stub_type,fix_eff_date, fix_first_cpn_date, fix_last_reg_date, notional, 1);		
		
		//----flt_sprd_parm1--------
		number flt_sprd_reset_freq_n = flt_sprd_cpn_freq_n;
		fp1_.set_plain(	pmt_bus_day, pmt_cal, end_of_month, ccy, flt_sprd_cpn_freq_n,flt_sprd_reset_freq_n, flt_sprd_day_count,
						flt_sprd_ir_rule , flt_sprd_ir_index, 0, 0,0,0,null,0,flt_sprd_stub_type,flt_sprd_eff_date, flt_sprd_first_cpn_date,
						flt_sprd_last_reg_date, notional, 1, flt_sprd_curr_fix,
						flt_sprd_fixing_dates ,flt_sprd_fixing_rates,flt_sprd_fix_proxy ,flt_sprd_allow_fwd_fix,null,null);
		
		//----flt_parm2--------
		number flt_flat_reset_freq_n = flt_flat_cpn_freq_n;
		fp2_.set_plain(	pmt_bus_day, pmt_cal, end_of_month, ccy, flt_flat_cpn_freq_n, flt_flat_reset_freq_n,flt_flat_day_count,
						flt_flat_ir_rule , flt_flat_ir_index, 0,0,0,0,null,0, flt_flat_stub_type,flt_flat_eff_date, flt_flat_first_cpn_date,
						flt_flat_last_reg_date, notional, 1, flt_flat_curr_fix,
						flt_flat_fixing_dates ,flt_flat_fixing_rates,flt_flat_fix_proxy ,flt_flat_allow_fwd_fix,null,null);
		//---common---
		name_			= name;
		imp_calc_dec_  	= imp_fix_rate_dec;//rounding decimals of the implied cpn rate (on decimal value)
		pv01_not_unit_  = null(pv01_not_unit) ? -1: pv01_not_unit;//rounding unit for notional when implied from pv01
		pay_leg1_		= pay_sprd_leg;
		is_ccy_ 		= false;
				
		if(null(ne_))
			ne_ = notional_exchg_style.NE_NONE;
		

		if(!null(spot_settle_code))
			spot_code_ 	= spot_settle_code;
		trade_date_ 	= trade_date;
		fwd_start_code_ = fwd_start_code;
		start_date_ 	= start_date;
		maturity_ 		= maturity;
		if(!null(maturity_code))
			maturity_code_ 	= maturity_code;
		settle_date_	= settle_date;
		//cpn_roll_day_ 	= 0;

		this.start_date_helper();
		this.maturity_helper(fip1_);
		this.schedule_helper(fip1_);
		this.schedule_helper(fp1_);
		this.schedule_helper(fp2_);
		this.check();
		
		if(null(notional))
			this.set_pv01(fix_pv01);
		else
			this.set_notional(notional);
		is_inited_ = true;
	}
	/*-----------------------------------------------------------------------
	  set_plain
	  ----------------------------------------------------------------------*/
	void fltflt2s_parm.set_plain(string name,								
								date option(nullable) 			trade_date,
								date option(nullable) 			settle_date,								
								date option(nullable) 			start_date,
								string option(nullable) 		fwd_start_code,
								date option(nullable)			maturity,
								string option(nullable) 		maturity_code,
								logical 						pay_sprd_leg, 
								integer 						imp_fix_rate_dec,
								number option(nullable) 		pv01_not_unit,
								number	option(nullable) 		notional,
								number	option(nullable) 		fix_pv01,
								//fix 
								number	option(nullable)		fix_cpn_rate_flat,
								number	option(nullable)		fix_spread,
								stub_type option(nullable)		fix_stub_type,
								date option(nullable)  			fix_eff_date,
								date option(nullable)  			fix_first_cpn_date,
								date option(nullable)  			fix_last_reg_date,
								//flt1	 
								stub_type option(nullable)		flt_sprd_stub_type,
								date option(nullable)  			flt_sprd_eff_date,
								date option(nullable)  			flt_sprd_first_cpn_date,
								date option(nullable)  			flt_sprd_last_reg_date,							
								number option(nullable) 		flt_sprd_curr_fix,
								vector(date) option(nullable) 	flt_sprd_fixing_dates ,	
								vector(number) option(nullable) flt_sprd_fixing_rates,
								number option(nullable) 		flt_sprd_fix_proxy ,
								logical option(nullable) 		flt_sprd_allow_fwd_fix,
								//flt2	 
								stub_type option(nullable)		flt_flat_stub_type,
								date option(nullable)  			flt_flat_eff_date,
								date option(nullable)  			flt_flat_first_cpn_date,
								date option(nullable)  			flt_flat_last_reg_date,							
								number option(nullable) 		flt_flat_curr_fix,
								vector(date) option(nullable) 	flt_flat_fixing_dates ,	
								vector(number) option(nullable) flt_flat_fixing_rates,
								number option(nullable) 		flt_flat_fix_proxy ,
								logical option(nullable) 		flt_flat_allow_fwd_fix)
	{
		QL_FAIL_COND(null(is_ccy_),"fltflt2s_parm is not initalized (init_static() must be run) ");
		
		if(null(notional))
			QL_REQUIRE(!null(fix_pv01),"one of notional and fix_pv01 must be input");
		else if(null(fix_pv01))
			QL_REQUIRE(!null(notional),"one of notional and fix_pv01 must be input");
		else if(!null(notional) && !null(fix_pv01))
			QL_FAIL("ambigious input of notional and fix_pv01");

		fix_spread_ = /*null(fix_spread) ? 0 :*/ fix_spread;
		number r = null(fix_cpn_rate_flat)  || null(fix_spread) ? null : fix_cpn_rate_flat - fix_spread_;

		//----fix_parm1-----
		fip1_.set_plain(null, null, null, fip1_.fix_ccy_, null, null, null ,0,0,0,0,
						r, fix_stub_type,fix_eff_date, fix_first_cpn_date, fix_last_reg_date, notional, 1);
		
		//----fix_parm2-----
		fip2_.set_plain(null, null, null, fip2_.fix_ccy_, null, null, null ,0,0,0,0,
						fix_cpn_rate_flat, fix_stub_type,fix_eff_date, fix_first_cpn_date, fix_last_reg_date, notional, 1);		
		
		//----flt_sprd_parm1--------
	
		fp1_.set_plain(	null, null, null, fp1_.flt_ccy_, null,null, null,
						null , null, 0, 0,0,0,null,0,flt_sprd_stub_type,flt_sprd_eff_date, flt_sprd_first_cpn_date,
						flt_sprd_last_reg_date, notional, 1, flt_sprd_curr_fix,
						flt_sprd_fixing_dates ,flt_sprd_fixing_rates,flt_sprd_fix_proxy ,flt_sprd_allow_fwd_fix,null,null);
		
		//----flt_parm2--------
		
		fp2_.set_plain(	null, null, null, fp2_.flt_ccy_, null, null,null,
						null , null, 0, 0,0,0,null,0,flt_flat_stub_type,flt_flat_eff_date, flt_flat_first_cpn_date,
						flt_flat_last_reg_date, notional, 1, flt_flat_curr_fix,
						flt_flat_fixing_dates ,flt_flat_fixing_rates,flt_flat_fix_proxy ,flt_flat_allow_fwd_fix,null,null);
		//---common---
		name_			= name;
		imp_calc_dec_  	= imp_fix_rate_dec;//rounding decimals of the implied cpn rate (on decimal value)
		pv01_not_unit_  = null(pv01_not_unit) ? -1: pv01_not_unit;//rounding unit for notional when implied from pv01
		pay_leg1_		= pay_sprd_leg;				

	
		trade_date_ 	= trade_date;
		fwd_start_code_ = fwd_start_code;
		start_date_ 	= start_date;
		maturity_ 		= maturity;
		if(!null(maturity_code))
			maturity_code_ 	= maturity_code;
		settle_date_	= settle_date;
		//cpn_roll_day_ 	= 0;

		this.start_date_helper();
		this.maturity_helper(fip1_);
		this.schedule_helper(fip1_);
		this.schedule_helper(fp1_);
		this.schedule_helper(fp2_);
		this.check();
		
		if(null(notional))
			this.set_pv01(fix_pv01);
		else
			this.set_notional(notional);
		
		is_inited_ = true;
	}
	/*-----------------------------------------------------------------------
	  create_swap
	  ----------------------------------------------------------------------*/	
	void fltflt2s_parm.create_swap(	disc_func option(nullable) 	disc_func,
									disc_func option(nullable) 	flt_sprd_fwd_disc_func,
									disc_func option(nullable) 	flt_flat_fwd_disc_func,
									out swap_fixflt 			swap_sprd,
									out swap_fixflt 			swap_flat,									
									logical option(nullable) 	allow_extrap, logical)
	{
		__create_swap( disc_func,  null,null,  flt_sprd_fwd_disc_func,flt_flat_fwd_disc_func,allow_extrap,swap_sprd,swap_flat);
	}
	/*-----------------------------------------------------------------------
	  create_swap
	  ----------------------------------------------------------------------*/	
	void fltflt2s_parm.create_swap(	disc_func option(nullable) 	disc_func,
									fwd_func option(nullable) 	flt_sprd_fwd_func,
									fwd_func option(nullable) 	flt_flat_fwd_func,
									out swap_fixflt 			swap_sprd,
									out swap_fixflt 			swap_flat,									
									logical option(nullable) 	allow_extrap, logical)
	{
		__create_swap(  disc_func, flt_sprd_fwd_func,flt_flat_fwd_func,null, null, allow_extrap,swap_sprd,swap_flat);
	}
	/*-----------------------------------------------------------------------
	  __create_swap <protected>
	  leg1 == spread leg
	  ----------------------------------------------------------------------*/	
	void fltflt2s_parm.__create_swap(	disc_func option(nullable) 	disc_func,
										fwd_func option(nullable) 	flt1_fwd_func,//sprd
										fwd_func option(nullable) 	flt2_fwd_func,
										disc_func option(nullable) 	flt1_fwd_disc_func,//sprd
										disc_func option(nullable) 	flt2_fwd_disc_func,
										logical option(nullable) 	allow_extrap,										
										out swap_fixflt 			swap_sprd,
										out swap_fixflt 			swap_flat)
	{
		logical pay_fixed_flat =  pay_leg1_;
		//checking
		if(!null(flt1_fwd_func)){
			QL_REQUIRE(null(flt1_fwd_disc_func),"ambigious input (leg1 fwd_func/disc_func)");
			QL_REQUIRE(!null(flt2_fwd_func),"leg2 fwd_func required when leg1 fwd_func is input");
			QL_REQUIRE(null(flt2_fwd_disc_func),"ambigious input (leg2 fwd_func/disc_func)");			
		}
		else if(!null(flt1_fwd_disc_func)){
			QL_REQUIRE(null(flt1_fwd_func),"ambigious input (leg1 fwd_func/disc_func)");
			QL_REQUIRE(!null(flt2_fwd_disc_func),"leg2 disc_func required when leg1 disc_func is input");
			QL_REQUIRE(null(flt2_fwd_func),"ambigious input (leg2 fwd_func/disc_func)");			
		}

		//defs
		ql_swap_fix_def fix_def 	= this.create_swap_fix_def(fip1_,"fix_def");
		QL_FAIL_COND(null(fix_def),"error creating fixed leg def");
		ql_swap_float_def flt_def1 	= this.create_swap_float_def(fp1_,"float_def sprd(1)");
		QL_FAIL_COND(null(flt_def1),"error creating float leg def (sprd)");
		ql_swap_float_def flt_def2 	= this.create_swap_float_def(fp2_,"float_def flat(2)");
		QL_FAIL_COND(null(flt_def2),"error creating float leg def (flat)");

		//legs
		ql_fix_leg fix_flat 		= this.create_swap_fix_leg(fip2_,fix_def, "fix_leg flat(2)",pay_fixed_flat, disc_func);
		QL_FAIL_COND(null(fix_flat),"error creating fixed leg (flat)");
		ql_fix_leg fix_sprd 		= this.create_swap_fix_leg(fip1_,fix_def, "fix_leg sprd(1)",!pay_fixed_flat, disc_func);
		QL_FAIL_COND(null(fix_sprd),"error creating fixed leg (sprd)");
		
		tenor_surface flt1_ts;
		if(null(flt1_fwd_func) && null(flt1_fwd_disc_func)){
			flt1_ts = null;
		}
		else if(!null(flt1_fwd_func)){
			flt1_ts = create_flt_surface(fp1_, disc_func,flt1_fwd_func,null,allow_extrap);
			QL_FAIL_COND(null(flt1_ts),"error creating tenor surface leg (sprd)");
		}
		else{
			flt1_ts = create_flt_surface(fp1_, disc_func,null,flt1_fwd_disc_func,allow_extrap);
			QL_FAIL_COND(null(flt1_ts),"error creating tenor surface leg (sprd)");
		}
		tenor_surface flt2_ts;
		if(null(flt2_fwd_func) && null(flt2_fwd_disc_func)){
			flt2_ts = null;
		}
		else if(!null(flt2_fwd_func)){
			flt2_ts = create_flt_surface(fp2_, disc_func,flt2_fwd_func,null,allow_extrap);
			QL_FAIL_COND(null(flt2_ts),"error creating tenor surface leg (flat)");
		}		
		else {
			flt2_ts = create_flt_surface(fp2_, disc_func,null,flt2_fwd_disc_func,allow_extrap);
			QL_FAIL_COND(null(flt2_ts),"error creating tenor surface leg (flat)");
		}
		
		ql_float_leg flt_s1 		= this.create_swap_float_leg(fp1_,flt_def1, "float_leg sprd(1)",pay_fixed_flat, disc_func, flt1_ts);
		QL_FAIL_COND(null(flt_s1),"error creating float leg (sprd)");
		ql_float_leg flt_f2 		= this.create_swap_float_leg(fp2_,flt_def2, "float_leg flat(2)",!pay_fixed_flat, disc_func, flt2_ts);
		QL_FAIL_COND(null(flt_f2),"error creating float leg (flat)");
		//swap2
		ql_fixed_income_swap sw_flat = ql_fixed_income_swap(fix_flat,flt_f2,name_);
		QL_FAIL_COND(null(sw_flat),"error creating swap (flat)");
		ql_fixed_income_swap sw_sprd = ql_fixed_income_swap(fix_sprd,flt_s1,name_);
		QL_FAIL_COND(null(sw_sprd),"error creating swap (sprd)");

		if(!null(fp1_.flt_curr_fix_))	
			sw_sprd.float_leg(false).set_current_fixing(fp1_.flt_curr_fix_);
		if(!null(fp2_.flt_curr_fix_))	
			sw_flat.float_leg(false).set_current_fixing(fp2_.flt_curr_fix_);		

		//implied flat leg
		if(null(fip2_.fix_coupon_rate_)) {
			number fix_r	= sw_flat.solver(0,swap_solver_code.SS_FIX_RATE_LEG1,false);
			QL_FAIL_COND(null(fix_r),"error calculating implied fixed coupon rate (flat)", E_INIT);

			if(imp_calc_dec_ >= 0)
				fix_r = round(fix_r,imp_calc_dec_);
				
			fip2_.fix_coupon_rate_ = fix_r;						
			fix_flat 	= this.create_swap_fix_leg(fip2_,fix_def, "fix_leg flat(2)",pay_fixed_flat, disc_func);
			QL_FAIL_COND(null(fix_flat),"error creating fixed leg (flat)");
			sw_flat 	= ql_fixed_income_swap(fix_flat,flt_f2,name_);
			QL_FAIL_COND(null(sw_flat),"error creating swap (flat)");
			//is it necessary to add fixing again here?
			if(!null(fp2_.flt_curr_fix_))	
				sw_flat.float_leg(false).set_current_fixing(fp2_.flt_curr_fix_);
		}

		error_info ee 			= new error_info(true,true);
		swap_flat 				= swap_fixflt(sw_flat, ee);			
		number fix_rate_flat 	= swap_flat.coupon_fix_leg(ee);
		//number pv1,pv2;
		//number pv = swap_flat.present_value(pv1,pv2,false,ee);

		//implied sprd leg
		if(null(fip1_.fix_coupon_rate_)) {//we could have a spred
			
			number fix_r	= null;

			if(null(fix_spread_)) {
				fix_r = sw_sprd.solver(0,swap_solver_code.SS_FIX_RATE_LEG1,false);
				QL_FAIL_COND(null(fix_r),"error calculating implied fixed coupon rate (sprd)", E_INIT);
				if(imp_calc_dec_ >= 0)
						fix_r = round(fix_r,imp_calc_dec_);
			
				fix_spread_ = fix_rate_flat - fix_r;
			}
			else {
				fix_r = fix_rate_flat - fix_spread_;
			}
			
			fip1_.fix_coupon_rate_ = fix_r;
			
			fix_sprd 	= this.create_swap_fix_leg(fip1_,fix_def, "fix_leg sprd(1)",!pay_fixed_flat, disc_func);
			QL_FAIL_COND(null(fix_sprd),"error creating fixed leg (sprd)");
			sw_sprd 	= ql_fixed_income_swap(fix_sprd,flt_s1,name_);
			QL_FAIL_COND(null(sw_sprd),"error creating swap (sprd)");
			//is it necessary to add fixing again here?
			if(!null(fp1_.flt_curr_fix_))	
				sw_sprd.float_leg(false).set_current_fixing(fp1_.flt_curr_fix_);
		}

		if(null(fix_spread_))
			fix_spread_ = fix_rate_flat - fip1_.fix_coupon_rate_;
		
		swap_sprd = swap_fixflt(sw_sprd, ee);
		
		//pv = swap_sprd.present_value(pv1,pv2,false,ee);
		
		if(!null(leg_pv01_)) {
			
			number pv01_1m 	= swap_flat.pv01(1000000,null,null,ee);//keep 1000000 as notional because this is the default notional when notional is not input (not really necessary) 
			number fix_not 	= abs(leg_pv01_)/pv01_1m*1000000;

			if(pv01_not_unit_>0){
				number a = fix_not/pv01_not_unit_;
				a = round(a,0);
				fix_not = a * pv01_not_unit_;
			}
			//update parm with new notional
			fip1_.fix_notional_ = fix_not;
			fip2_.fix_notional_ = fix_not;	
			fx_notional_helper();

			//update the newly created swap with new notional
			swap_flat.add_notional(fix_not);
			swap_sprd.add_notional(fix_not);
		}

		/*number fix_rate_flat 	= swap_flat.coupon_fix_leg(ee);		
		number fix_rate_sprd 	= fix_rate_flat + fix_spread_;
		fip1_.fix_coupon_rate_ 	= fix_rate_sprd;
		
		ql_fix_leg  fix_sprd 	= this.create_swap_fix_leg_sprd(fix_def, "fix_leg (sprd)",!pay_fixed_flat, disc_func);
		QL_FAIL_COND(null(fix_sprd),"error creating fixed leg (spread leg)");
		ql_fixed_income_swap sw_sprd = ql_fixed_income_swap(fix_sprd,flt_s1,name);		
		QL_FAIL_COND(null(sw_sprd),"error creating swap");*/

		
		
		//swap_sprd 				= swap_fixflt(sw_sprd, ee);
		
		return ;
	}
	/*-----------------------------------------------------------------------
	  create_swap
	  ----------------------------------------------------------------------*/	
	swap_fltflt fltflt2s_parm.create_swap(	disc_func option(nullable) 	disc_func,
											disc_func option(nullable) 	flt_sprd_fwd_disc_func,
											disc_func option(nullable) 	flt_flat_fwd_disc_func,
											logical option(nullable) 	allow_extrap)
	{
		return __create_swap(  disc_func,  null,null,  flt_sprd_fwd_disc_func,flt_flat_fwd_disc_func,allow_extrap);
	}
	/*-----------------------------------------------------------------------
	  create_swap
	  ----------------------------------------------------------------------*/	
	swap_fltflt fltflt2s_parm.create_swap(	disc_func option(nullable) 	disc_func,
											fwd_func option(nullable) 	flt_sprd_fwd_func,
											fwd_func option(nullable) 	flt_flat_fwd_func,
											logical option(nullable) 	allow_extrap)
	{
		return __create_swap(  disc_func, flt_sprd_fwd_func,flt_flat_fwd_func,null, null,allow_extrap);
	}
	/*-----------------------------------------------------------------------
	  __create_swap <protected>
	  ----------------------------------------------------------------------*/	
	swap_fltflt fltflt2s_parm.__create_swap(	disc_func option(nullable) 	disc_func,
												fwd_func option(nullable) 	flt1_fwd_func,//sprd
												fwd_func option(nullable) 	flt2_fwd_func,
												disc_func option(nullable) 	flt1_fwd_disc_func,//sprd
												disc_func option(nullable) 	flt2_fwd_disc_func,
												logical option(nullable) 	allow_extrap)
	{
	
		swap_fixflt swap_flat,swap_sprd;

		__create_swap(disc_func,flt1_fwd_func,flt2_fwd_func,flt1_fwd_disc_func,flt2_fwd_disc_func,allow_extrap,swap_flat,swap_sprd );

		error_info ee = new error_info(true,true);
		number pv_fix_sprd,pv_flt_sprd;
		number pv_sprd = swap_sprd.present_value(pv_fix_sprd,pv_flt_sprd,false, ee);
	
		number pv_fix_flat,pv_flt_flat;
		number pv_flat 		= swap_flat.present_value(pv_fix_flat,pv_flt_flat,false, ee);

		//create fltflt swap
		ql_float_leg flt_s 			= swap_sprd.float_leg(true,ee);
		ql_float_leg flt_f 			= swap_flat.float_leg(true,ee);
		ql_fixed_income_swap sw_ff 	= ql_fixed_income_swap(flt_s,flt_f,"implied_fltflt");
		swap_fltflt sw 				= swap_fltflt(sw_ff);

		//solve for and add spread to spread leg (=leg1)
		/*
		 ql_fix_leg fix 			= ql_fix_leg(fix_def,"fix_leg",trade_date,settle_date,settle_date,maturity,mat_code,
													false,notional,null<date>,null<date>,null<date>,fix_spread,	
													flt1_disc_func,cpn_roll_day,1);

		number pv_sprd 				= fix.present_value(false);//pv of the spread only
		
		 ql_fixed_income_swap sw_flat 	= ql_fixed_income_swap(flt1_flat,flt2_flat,"no_name");
		 number pv1,pv2;
		number pv = sw_flat.present_value(pv1,pv2,false);
		number pv_adj = pay_float1 ? pv - pv_sprd : pv + pv_sprd;

		number flt1_sprd 				= sw_flat.solver(pv_adj, SS_FLT_SPRD_LEG1,false);
		 */
		number pv 					= pv_sprd + pv_flat;
		number flt_sprd 			= sw_ff.solver(pv, SS_FLT_SPRD_LEG1,false);
		sw.add_quote(flt_sprd*10000);
		
		return sw;
		
	}

}