option(null: hard);	

/*	
	swaplib wrapper functions
	Developer: Algorithmica Research, Magnus Nyström

	--------------------------------------------------------------------
	 	swap help functions for create funcs
	--------------------------------------------------------------------

	ToDo:
	flt_comp_avg_type comp_avg_type 		= sw_base.comp_avg_type_flt_leg(ee);//OBS n/a for ext swap
	etc
*/
module CORE_SWAPLIB
{
	/*-----------------------------------------------------------------------
	 -----------------------------------------------------------------------
	 -----class fltois_parm--------------------------------------------------
	 -----------------------------------------------------------------------
	 -----------------------------------------------------------------------*/
	class fltois_parm : public legleg_parm
	{
	public:
		override instr_type 	type();
		fltois_parm();
		
		void 				start_date_helper();
		void 				fx_notional_helper();
		ql_float_leg 		create_swap_float_mtm_leg1(ql_swap_float_def , string ,logical,  disc_func   option(nullable),tenor_surface  option(nullable), disc_func  option(nullable));		
		ql_ois_leg 			create_swap_ois_mtm_leg2(ql_swap_ois_def , string ,logical,   disc_func   option(nullable),tenor_surface  option(nullable), disc_func  option(nullable));

		
		void				init_static(instr_def,string option(nullable) );
		void				init_static(INSTR_TMPL.swap_fltois_def_tmpl);
		void				init_static(swap_fltois,string option(nullable) );
		void				init_static(string option(nullable),
										bd_convention  		pmt_bus_day,
										calendar 			pmt_cal,
										logical				end_of_month,
										notional_exchg_style option(nullable) ne,												
										//flt
										string				flt_ccy,logical	,
										integer 			flt_cpn_freq,
										day_count_method 	flt_day_count,
										interest_rule		flt_ir_rule,
										ir_index 			flt_ir_index,number,number,
										flt_stub_fwd_style option(nullable) flt_stub_rate_style,
										//avg_comp_method option(nullable) flt_comp_avg,
											//flt_comp_avg_type option(nullable)		ois_comp_avg_t ,
											//flt_sprd_comp_method option(nullable)	ois_sprd_comp_m,
											//flt_avg_method 	option(nullable)		ois_avg_m,
										//flt
										string				ois_ccy,logical	,
										integer				ois_cpn_freq,
										day_count_method   	ois_day_count,
										interest_rule		ois_ir_rule,
										ir_index 			ois_ir_index,
										avg_comp_method option(nullable) ois_comp_avg,
											//flt_comp_avg_type option(nullable)		ois_comp_avg_t ,
											//flt_sprd_comp_method option(nullable)	ois_sprd_comp_m,
											//flt_avg_method 	option(nullable)		ois_avg_m,
										rfr_arrears_type  option(nullable)		ois_arr_type,
										number option(nullable) 				ois_arr_days ,
										number				ois_pmt_delay,number,
										logical				ois_endog_df,
										logical 			ois_approx_calc);
		
		void 				set_notional_flt(number);
		void 				set_notional_ois(number);
		void 				set_pv01(number);
		flt_parm			flt_leg_parm();
		ois_parm 			ois_leg_parm();
		
		
		logical 			ois_df_check( ..disc_func option(nullable) disc_func_rev_leg,
										 ..disc_func option(nullable) ois_disc_func,
										 ..fwd_func option(nullable) ois_fwd_func,
										 ..disc_func option(nullable) ois_fwd_disc_func,
										 out string err_msg);
		logical 			primary_quote_is_leg1();

	protected:
		number 				imp_mtm_fx_rate_leg1();
		number 				imp_mtm_fx_rate_leg2();
		void 		check();
		
		//void 		__set_plain_vanilla();
		void 		__set_plain(bd_convention option(nullable) 	pmt_bus_day,
								calendar option(nullable)	pmt_cal,
								logical	option(nullable) 	end_of_month,
								integer 					imp_sprd_dec,
								number option(nullable)		pv01_not_unit,										
								//flt
								string	option(nullable) ,logical	option(nullable),
								number option(nullable)		flt_cpn_freq_n,
								day_count_method  option(nullable) flt_day_count,
								 interest_rule option(nullable) flt_ir_rule,
								ir_index option(nullable)	flt_ir_index,number option(nullable),
								number  option(nullable),number  option(nullable),
								number option(nullable) 	flt_curr_fix,
								number option(nullable)		flt_spread,
								//ois
								string	option(nullable) ,logical	option(nullable),
								number option(nullable)		ois_cpn_freq_n,
								day_count_method  option(nullable) ois_day_count,
								interest_rule option(nullable) ois_ir_rule,
								ir_index option(nullable)	ois_ir_index,
								number option(nullable),
								flt_comp_avg_type option(nullable)		ois_comp_avg_t ,
								flt_sprd_comp_method option(nullable)	ois_sprd_comp_m,
								flt_avg_method 	option(nullable)		ois_avg_m,
								rfr_arrears_type  option(nullable)		ois_arr_type,
								number option(nullable) 				ois_arr_days ,
								number  option(nullable)				ois_pmt_delay,
								number  option(nullable),
								logical	option(nullable)	ois_endog_df,
								logical option(nullable)	ois_approx_calc,
								number option(nullable)		ois_spread );
		
		swap_fltois __create_swap(	disc_func option(nullable) ,
									fwd_func option(nullable),
									disc_func option(nullable) ,
									disc_func option(nullable) ois_disc_func,
									fwd_func option(nullable) 	ois_fwd_func,
									disc_func option(nullable) 	ois_fwd_disc_func,logical option(nullable) );
		
		void __create_swap_solve_flt(disc_func option(nullable) ,disc_func option(nullable) , ql_swap_float_def,ql_swap_ois_def  ,
									tenor_surface option(nullable) ,out ql_float_leg ,out ql_ois_leg ,out ql_fixed_income_swap );
		void __create_swap_solve_ois(disc_func option(nullable) ,disc_func option(nullable), ql_swap_float_def,ql_swap_ois_def  ,
									tenor_surface option(nullable) ,out ql_float_leg ,out ql_ois_leg ,out ql_fixed_income_swap );

		void calc_not_pv01_flt(swap_fltois);
		void calc_not_pv01_ois(swap_fltois);
		
	public:
		void	set_plain_single_ccy(string 					name,											
									date  option(nullable) 		trade_date,
									date option(nullable) 		settle_date,
									
									date option(nullable) 		start_date,
									 string option(nullable)	fwd_start_code,
									date option(nullable) 		maturity,
									string option(nullable) 	maturity_code,
									logical 					pay_float,											 											
									integer 					imp_sprd_dec,
									number 	option(nullable)	pv01_not_unit,
									number	option(nullable) 	notional,
									number	option(nullable) 	flt_pv01,											
									//flt
									number option(nullable)		flt_spread,
									number option(nullable) 	flt_curr_fix ,
									//ois											
									number option(nullable)		ois_spread);
		
		void 	set_plain_single_ccy(string name,
									date  option(nullable) 		trade_date,
									date option(nullable) 		settle_date,
									string option(nullable) 	spot_settle_code,
									date option(nullable) 		start_date,
									string option(nullable)		fwd_start_code,
									date option(nullable) 		maturity,
									string option(nullable) 	maturity_code,
									logical 					pay_float,
									bd_convention option(nullable) 	pmt_bus_day,
									calendar option(nullable)	pmt_cal,
									logical	option(nullable) 	end_of_month,
									string	option(nullable) 	ccy,
									integer 					imp_sprd_dec,
									number 	option(nullable)	pv01_not_unit,
									number	option(nullable) 	notional,
									number	option(nullable) 	flt_pv01,											
									//flt													
									number option(nullable)		flt_cpn_freq_n,
									day_count_method  option(nullable) flt_day_count,
									interest_rule option(nullable) flt_ir_rule,
									ir_index option(nullable)	flt_ir_index,
									number  option(nullable),
									number  option(nullable),
									number option(nullable)		flt_spread,
									number option(nullable) 	flt_curr_fix,
									//ois
									number option(nullable)		ois_cpn_freq_n,
									day_count_method  option(nullable) ois_day_count,
									interest_rule option(nullable) ois_ir_rule,
									ir_index option(nullable)	ois_ir_index,
									avg_comp_method option(nullable) ois_comp_avg,
											//flt_comp_avg_type option(nullable)		ois_comp_avg_t ,
											//flt_sprd_comp_method option(nullable)	ois_sprd_comp_m,
											//flt_avg_method 	option(nullable)		ois_avg_m,
									rfr_arrears_type  option(nullable)		ois_arr_type,
									number option(nullable) 				ois_arr_days ,
									number  option(nullable)	ois_pmt_delay,
									number  option(nullable),
									logical	option(nullable)	ois_endog_df,
									logical option(nullable)	ois_approx_calc,
									number option(nullable)		ois_spread );

		void 	set_plain(	string 							name,						
							date option(nullable) 			trade_date,
							date option(nullable) 			settle_date,
							
							date option(nullable) 			start_date,
							string option(nullable) 		fwd_start_code,
							date option(nullable)			maturity,
							string option(nullable) 		maturity_code,
							logical 						pay_float,							
							integer 						imp_sprd_dec,
							number 	option(nullable)		pv01_not_unit,
							number	option(nullable) 		leg_pv01,
							number 		option(nullable) 	fx_quote,
							string 		option(nullable) 	fx_quote_baseccy,
							string 		option(nullable) 	fx_quote_priceccy,
							logical 	option(nullable) 	pv_in_base_ccy,							
							//flt
							number option(nullable) 		flt_spread,
							stub_type option(nullable)		flt_stub_type,
							date option(nullable)  			flt_eff_date,
							date option(nullable)  			flt_first_cpn_date,
							date option(nullable)  			flt_last_reg_date,
							number	option(nullable) 		flt_notional,
														
							number option(nullable) 		flt_curr_fix,
							vector(date) option(nullable) 	flt_fixing_dates ,	
							vector(number) option(nullable) flt_fixing_rates,
							number option(nullable) 		flt_fix_proxy ,
							logical option(nullable) 		flt_allow_fwd_fix,
							//ois
							number option(nullable) 		ois_spread,
							stub_type option(nullable)		ois_stub_type,
							date option(nullable)  			ois_eff_date,
							date option(nullable)  			ois_first_cpn_date,
							date option(nullable)  			ois_last_reg_date,
							number	option(nullable) 		ois_notional,
							
							vector(date) option(nullable) 	ois_fixing_dates ,	
							vector(number) option(nullable) ois_fixing_rates,
							number option(nullable) 		ois_fix_proxy ,
							logical option(nullable) 		ois_allow_fwd_fix );
		
		void 	set_plain(	string 							name,						
							date option(nullable) 			trade_date,
							date option(nullable) 			settle_date,
							string option(nullable) 		spot_settle_code,
							date option(nullable) 			start_date,
							string option(nullable) 		fwd_start_code,
							date option(nullable)			maturity,
							string option(nullable) 		maturity_code,
							logical 						pay_float,
							bd_convention option(nullable)	pmt_bus_day,
							calendar option(nullable)		pmt_cal,
							logical	 option(nullable)		end_of_month,
							notional_exchg_style option(nullable) notional_exchg,
							integer 						imp_sprd_dec,
							number 	option(nullable)		pv01_not_unit,
							number	option(nullable) 		leg_pv01,
							number 		option(nullable) 	fx_quote,
							string 		option(nullable) 	fx_quote_baseccy,
							string 		option(nullable) 	fx_quote_priceccy,
							logical 	option(nullable) 	pv_in_base_ccy,
							
							//flt
							string	 option(nullable) 		flt_ccy,logical	option(nullable),
							number option(nullable)	 		flt_cpn_freq_n,
							day_count_method  option(nullable) flt_day_count,
							interest_rule option(nullable) 	flt_ir_rule ,
							ir_index option(nullable)		flt_ir_index,number  option(nullable),number  option(nullable),
							number option(nullable) 		flt_spread,
							stub_type option(nullable)		flt_stub_type,
							date option(nullable)  			flt_eff_date,
							date option(nullable)  			flt_first_cpn_date,
							date option(nullable)  			flt_last_reg_date,
							number	option(nullable) 		flt_notional,
							
							number option(nullable) 		flt_curr_fix,
							vector(date) option(nullable) 	flt_fixing_dates ,	
							vector(number) option(nullable) flt_fixing_rates,
							number option(nullable) 		flt_fix_proxy ,
							logical option(nullable) 		flt_allow_fwd_fix,
							//ois
							string	option(nullable) 		ois_ccy,logical	option(nullable),
							number option(nullable)	 		ois_cpn_freq_n,
							day_count_method  option(nullable) ois_day_count,
							interest_rule option(nullable) ois_ir_rule,
							ir_index option(nullable)		ois_ir_index,
							number  option(nullable)		ois_pmt_delay,
							number  option(nullable),
							avg_comp_method option(nullable) ois_comp_avg,
											//flt_comp_avg_type option(nullable)		ois_comp_avg_t ,
											//flt_sprd_comp_method option(nullable)	ois_sprd_comp_m,
											//flt_avg_method 	option(nullable)		ois_avg_m,
							rfr_arrears_type option(nullable)  	ois_arr_type,
							number option(nullable)  			ois_arr_days,
							logical	option(nullable)		ois_endog_df,
							logical option(nullable)		ois_approx_calc,
							number option(nullable) 		ois_spread,
							stub_type option(nullable)		ois_stub_type,
							date option(nullable)  			ois_eff_date,
							date option(nullable)  			ois_first_cpn_date,
							date option(nullable)  			ois_last_reg_date,
							number	option(nullable) 		ois_notional,
							//number	option(nullable) 		ois_pv01,
							vector(date) option(nullable) 	ois_fixing_dates ,	
							vector(number) option(nullable) ois_fixing_rates,
							number option(nullable) 		ois_fix_proxy ,
							logical option(nullable) 		ois_allow_fwd_fix );

		//set_plain_amort_single_curr() --> TODO
		
		swap_fltois 	create_swap(disc_func option(nullable) 	flt_disc_func,
									fwd_func option(nullable) 	flt_fwd_func,
									disc_func option(nullable) ,	
									disc_func option(nullable) 	ois_disc_func,
									fwd_func option(nullable) 	ois_fwd_func,
									disc_func option(nullable) 	ois_fwd_disc_func,
									logical sync_endog_ok,
									logical option(nullable) 	flt_allow_extrap = null);
			
				
		flt_parm	fp_;
		ois_parm	op_;

		logical 	is_mtm_leg_ois() ;
		logical 	is_mtm_leg_flt() ;
		
		void set_mtm_data(	number 	option(nullable) );
	};
	
	/*-----------------------------------------------------------------------
	  constructor
	  ----------------------------------------------------------------------*/
	fltois_parm.fltois_parm()
	{
		op_ = new ois_parm();
		fp_ = new flt_parm();
	}
	/*-----------------------------------------------------------------------
	  primary_quote_is_leg1  CHECK
	  ----------------------------------------------------------------------*/
	logical fltois_parm.primary_quote_is_leg1()
	{
		//return leg1_is_primary_quote(__instr_type.SWAP_FLTOIS,fp_.flt_ccy_,op_.ois_ccy_);
		integer rfreq = reset_freq_to_int(fp_.flt_reset_freq_);
		return leg1_is_primary_quote(CORE_INT.conv_rev_instr_type(type()),fp_.flt_ccy_,op_.ois_ccy_, rfreq, 365);
	}
	/*-----------------------------------------------------------------------
	  set_mtm_data
	  ----------------------------------------------------------------------*/
	void fltois_parm.set_mtm_data(	number 	option(nullable)  mtm_fx_quote )
	{
		/*set_mtm_data(	string 		ccy_leg1,
									string 		ccy_leg2,
									calendar 	cal_leg1,
									calendar	cal_leg2,
									number 	option(nullable)  mtm_fx_quote,
									calendar option(nullable) mtm_usd_calendar);*/
		calendar mtm_usd_calendar = null;//for now
		legleg_parm.set_mtm_data(fp_.flt_ccy_, op_.ois_ccy_, fp_.flt_pmt_calendar_,op_.ois_pmt_calendar_, mtm_fx_quote, mtm_usd_calendar);
	}
	/*-----------------------------------------------------------------------
	  primary_quote_is_leg1  CHECK
	  1) created from def
	  2) created from template
	  3) created from scratch
	  ----------------------------------------------------------------------*/
	/*logical legleg_parm.primary_quote_is_leg1(instr_type t)
	{		
		if (is_ccy_) {
			if(t == instr_type.SWAP_FLTOIS) {
				if(equal_casei(fp_.flt_ccy_, "USD"))
					return false;
				else if(equal_casei(op_.ois_ccy_, "USD"))
					return true;
				else 
					return false;//this is a guess, what if it is EUR vs minor ccy??
			}
		}
		else {
			return false;
		}
	}*/
	/*-----------------------------------------------------------------------
	  type
	  ----------------------------------------------------------------------*/
	instr_type fltois_parm.type() { return instr_type.SWAP_FLTOIS;}
	/*-----------------------------------------------------------------------
	  ois_leg_parm / flt_leg_parm
	  ----------------------------------------------------------------------*/
	ois_parm fltois_parm.ois_leg_parm() 	{ return op_;}
	flt_parm fltois_parm.flt_leg_parm() 	{ return fp_;}
	logical fltois_parm.is_mtm_leg_ois()	{ return legleg_parm.is_mtm_leg2() ;}
	logical fltois_parm.is_mtm_leg_flt()	{ return legleg_parm.is_mtm_leg1() ;}
	/*-----------------------------------------------------------------------
	  set_notional_flt
	  ----------------------------------------------------------------------*/
	void fltois_parm.set_notional_flt(number not)
	{
		fp_.flt_notional_ 	= not;
		if(!is_ccy_)
			op_.ois_notional_ 	= not;
		leg_pv01_ 			= null;
		fx_notional_helper();
	}
	/*-----------------------------------------------------------------------
	  set_notional_ois
	  ----------------------------------------------------------------------*/
	void fltois_parm.set_notional_ois(number not)
	{		
		op_.ois_notional_ 	= not;
		if(!is_ccy_)
			fp_.flt_notional_ 	= not;
		leg_pv01_ 			= null;
		fx_notional_helper();
	}
	/*-----------------------------------------------------------------------
	  set_pv01, pv01 is the ois leg pv01
	  ----------------------------------------------------------------------*/
	void fltois_parm.set_pv01(number pv01)
	{
		fp_.flt_notional_ 	= null;//if null it will be calculated in ccy_helper
		op_.ois_notional_ 	= 1000000;
		//fltois_not_ 		= null;
		leg_pv01_ 			= pv01;
		fx_notional_helper();
	}
	/*-----------------------------------------------------------------------
	  __set_plain_vanilla
	  ----------------------------------------------------------------------*/
	/*void fltois_parm.__set_plain_vanilla()
	{		
		cpn_roll_day_ = 0;

		fp_.set_plain_vanilla();
		logical fed_fund_style = false;
		op_.set_plain_vanilla(fed_fund_style);
	}*/
	/*-----------------------------------------------------------------------
	  check
	  ----------------------------------------------------------------------*/
	void fltois_parm.check()
	{
		if(is_aged_swap()){
			QL_REQUIRE(!null(op_.ois_spread_),"ois-leg spread required for aged swap");
			if(is_ccy_ ) {
				QL_REQUIRE(!null(fp_.flt_notional_) && !null(op_.ois_notional_),"notionals are required for aged swap");
			}
			else {
				QL_REQUIRE(!null(fp_.flt_notional_) || !null(op_.ois_notional_),"notional is required for aged swap");
			}
		}
	}
	/*-----------------------------------------------------------------------
	  ccy_helper
	  ----------------------------------------------------------------------*/
	void fltois_parm.fx_notional_helper()
	{
		legleg_parm.fx_notional_helper(fp_.flt_notional_, op_.ois_notional_, fp_.flt_fx_mult_ , op_.ois_fx_mult_);
	}

	/*-----------------------------------------------------------------------
	  start_date_helper
	  ----------------------------------------------------------------------*/	
	void fltois_parm.start_date_helper()
	{
		legleg_parm.start_date_helper(fp_.flt_eff_date_, op_.ois_eff_date_, fp_.flt_pmt_calendar_);
	}
	/*-----------------------------------------------------------------------
	  ois_df_check
	  ----------------------------------------------------------------------*/
	logical fltois_parm.ois_df_check(..disc_func option(nullable) disc_func_rev_leg,
									 ..disc_func option(nullable) ois_disc_func,
									 ..fwd_func option(nullable) ois_fwd_func,
									 ..disc_func option(nullable) ois_fwd_disc_func,
									 out string err_msg)
	{
		logical ok = CORE_INT_SWAPLIB.ois_df_check(	op_.ois_endog_df_,is_ccy_,
													disc_func_rev_leg,ois_disc_func, ois_fwd_func, ois_fwd_disc_func, err_msg);
		return ok;
	}
	/*-----------------------------------------------------------------------
	  create_swap_float_leg1
	  ----------------------------------------------------------------------*/	
	ql_float_leg fltois_parm.create_swap_float_mtm_leg1(ql_swap_float_def 	flt_def,
														string 				name,
														logical 			pay,
														disc_func  option(nullable)			flt_disc_func,
														tenor_surface 	 option(nullable)	flt_tenor_surface,
														disc_func 	 option(nullable)		ois_disc_func)													
	{
		calendar usd_cal = null; //used for calc of fx spot date, not used for all currency pairs
		return fp_.create_swap_float_mtm_leg(	flt_def, name, pay, flt_disc_func, flt_tenor_surface, trade_date_,
												settle_date_,start_date_, maturity_ , mat_code_,op_.ois_roll_day_,
												op_.ois_fx_mult_,
												ois_disc_func,
												op_.ois_notional_,
												op_.ois_ccy_,
												op_.ois_pmt_calendar_, usd_cal, mtm_fx_spot_rate_ );
		
	}
	/*-----------------------------------------------------------------------
	  create_swap_ois_leg2
	  ----------------------------------------------------------------------*/	
	ql_ois_leg fltois_parm.create_swap_ois_mtm_leg2(ql_swap_ois_def 	ois_def,
													string 				name,
													logical 			pay,
													disc_func  option(nullable)			ois_disc_func,
													tenor_surface  option(nullable)		ois_tenor_surface,
													disc_func  option(nullable)			flt_disc_func)													
	{
		calendar usd_cal = null; //used for calc of fx spot date, not used for all currency pairs
		return op_.create_swap_ois_mtm_leg(	ois_def, name, pay, ois_disc_func, ois_tenor_surface, trade_date_,
												settle_date_,start_date_, maturity_ , mat_code_,fp_.flt_roll_day_,
												fp_.flt_fx_mult_,
												flt_disc_func,
												fp_.flt_notional_,
												fp_.flt_ccy_,
												fp_.flt_pmt_calendar_, usd_cal, mtm_fx_spot_rate_);
	}
	/*-----------------------------------------------------------------------
	  imp_mtm_fx_rate_leg2
	  ----------------------------------------------------------------------*/	
	number fltois_parm.imp_mtm_fx_rate_leg2()
	{
		number opp_leg_fx_mult = fp_.flt_fx_mult_;
		return op_.ois_fx_mult_/opp_leg_fx_mult;
	}
	/*-----------------------------------------------------------------------
	  imp_mtm_fx_rate_leg1
	  ----------------------------------------------------------------------*/	
	number fltois_parm.imp_mtm_fx_rate_leg1()
	{
		number 	opp_leg_fx_mult = op_.ois_fx_mult_;
		return 	fp_.flt_fx_mult_/opp_leg_fx_mult;
	}
	/*-----------------------------------------------------------------------
	  init_from_instr_def
	  Note: a possible maturity code in the template is never "carried over" to the swap
	  Note to self: tmpl --> def --> ql_fixed_income_swap --> swap_fltois (and the def is lost in the process since it is only part of the translation)
					(a direct route without the def is possible but not sure if it will save much compute time)
	  ----------------------------------------------------------------------*/
	void fltois_parm.init_static(INSTR_TMPL.swap_fltois_def_tmpl tmpl )
	{
		is_ccy_ 		= tmpl.is_cross_curr();		
		ne_ 			= tmpl.not_exchange();
		if(null(ne_))
			ne_ 	= is_ccy_ ? NE_BOTH : NE_NONE;
		
		spot_code_ 		= tmpl.spot_settle_code();
		trade_date_ 	= null;
		maturity_ 		= null;
		maturity_code_ 	= tmpl.maturity_code();
		mat_code_ 		= null;
		fwd_start_code_ = null;//tmpl.fwd_start_code();
		start_date_ 	= null;
		settle_date_	= null;
		//cpn_roll_day_ 	= 0;
		is_mtm_ 		= tmpl.is_mtm(is_mtm_leg1_);
		
		//flt		
		//tmpl.flt_comp_avg()
		//tmpl.flt_spread_comp_method(),
		//tmpl.flt_avg_method(),
		
		..flt_roll_method flt_roll 		= null;
		logical flt_compound_to_mat 	= null;
		flt_comp_avg_type comp_avg_type = null;
		flt_sprd_comp_method sprd_comp_method = null;
		flt_avg_method avg_method 		= null;
		logical average_notional 		= null;
		//all nulls --> defaults handled in flt_parm.init_static 
		fp_.init_static(	tmpl.flt_bd_convention(),tmpl.flt_calendar(),tmpl.flt_eom(),tmpl.flt_currency(),
							tmpl.flt_cpn_freq(), integer(tmpl.flt_reset_freq()),
							tmpl.flt_day_count_method(),tmpl.flt_ir_rule(),tmpl.flt_ir_index(),
							tmpl.payment_delay(),tmpl.payment_delay(),tmpl.payment_delay_prin(),tmpl.payment_delay_prin(),
							comp_avg_type,sprd_comp_method,avg_method,average_notional,flt_roll,flt_compound_to_mat,tmpl.flt_fwd_stub_rate_style());

		//ois
		flt_roll_method ois_roll 		= null;
		logical  ois_average_notional 	= null;
		//all nulls --> defaults handled in flt_parm.init_static 
		op_.init_static(	tmpl.ois_bd_convention(),tmpl.ois_calendar(),tmpl.ois_eom(), tmpl.ois_currency(),tmpl.ois_cpn_freq(),									
							tmpl.ois_day_count_method(),tmpl.ois_ir_rule(),tmpl.ois_ir_index(),
							tmpl.ois_comp_avg(),//.swap_comp_avg_type_leg1(ee),
							tmpl.ois_spread_comp_method(),//swap_sprd_comp_method_leg1(ee),
							tmpl.ois_avg_method(),//swap_avg_method_leg1(ee),
							tmpl.payment_delay() , tmpl.payment_delay(),tmpl.payment_delay_prin(), tmpl.payment_delay_prin() ,
							tmpl.ois_arr_type(), tmpl.ois_arr_days(),tmpl.ois_endog_df(),
							tmpl.ois_approx_calc(),ois_average_notional, ois_roll);
	}
	/*-----------------------------------------------------------------------
	  unpack_instr_def
	  ----------------------------------------------------------------------*/
	void fltois_parm.init_static(	instr_def def,
									string option(nullable) spot_code)
	{
		QL_REQUIRE(CORE_INT.check_instr_def(def),"invalid instr_def");
		QL_FAIL_COND(!def.is_swap_fltois(), "instr_def not a float-ois swap", E_INIT);

		//----fltois_parm-----
		is_ccy_ 		= def.is_ccy_swap();		
		error_info ees 	= new error_info(true,false);
		ne_ 			= def.swap_not_exchange(ees);
		if(null(ne_))
			ne_ 	= is_ccy_ ? NE_BOTH : NE_NONE;
		
		spot_code_ 		= null(spot_code) ? "BD2" : spot_code;
		trade_date_ 	= null;
		maturity_ 		= null;
		maturity_code_ 	= def.maturity_code(ees);
		mat_code_ 		= null;
		fwd_start_code_ = null;
		start_date_ 	= null;
		settle_date_	= null;
		//cpn_roll_day_ 	= 0;
		is_mtm_ 		= def.is_swap_fltois_mtm();
		is_mtm_leg1_ 	= def.is_swap_fltois_mtm_leg1();
		
		op_.init_basic_static_leg2( def );
		fp_.init_basic_static_leg1( def);
		
	}
	/*-----------------------------------------------------------------------
	  unpack_ext_swap
	  ----------------------------------------------------------------------*/
	void fltois_parm.init_static(swap_fltois sw_base,
									string option(nullable) spot_code)	//ext swap i.e. instr_def = null						
	{
		//----fltois_parm--------
		is_ccy_ 		= sw_base.is_ccy_swap();		
		error_info ee 	= new error_info(true,true);
		ne_ 			= null;//notional_exchg_style.NE_NONE;
		if(null(ne_))
			ne_ = is_ccy_ ? NE_BOTH : NE_NONE;
		//ne 				= sw_base.notional_exchg_style_fix_leg(ee);		//assume both legs are same

		spot_code_ 		= null(spot_code) ? "BD2" : spot_code;
		trade_date_ 	= null;
		maturity_ 		= null;
		maturity_code_ 	= null;
		mat_code_ 		= null;
		fwd_start_code_ = null;
		start_date_ 	= null;
		settle_date_	= null;
		//cpn_roll_day_ 	= 0;
		is_mtm_leg1_ 	= sw_base.is_mtm_flt_leg(ee);
		is_mtm_ 		= is_mtm_leg1_|| sw_base.is_mtm_ois_leg(ee) ;

		integer mat_pmt_delay1,mat_pmt_delay_prin1;
		integer mat_pmt_delay2,mat_pmt_delay_prin2;
		integer pmt_delay1,pmt_delay2 ;
		integer pmt_delay_prin1,pmt_delay_prin2 ;
		sw_base.pmt_lag(pmt_delay1,mat_pmt_delay1, pmt_delay_prin1, mat_pmt_delay_prin1,
						pmt_delay2,mat_pmt_delay2, pmt_delay_prin2, mat_pmt_delay_prin2,ee);
		
		//----flt_parm / ois_parm--------
		integer cfreq_ois, cfreq_flt;
		sw_base.coupon_freq( cfreq_flt,cfreq_ois, ee);		
		sw_base.calendar(fp_.flt_pmt_calendar_,op_.ois_pmt_calendar_,ee);
		sw_base.pmt_bus_day(fp_.flt_pmt_bus_day_,op_.ois_pmt_bus_day_,ee);
		sw_base.eom(fp_.flt_end_of_month_,op_.ois_end_of_month_,ee);
		sw_base.dc_method(fp_.flt_dc_,op_.ois_dc_ ,ee);
		sw_base.currency(fp_.flt_ccy_ ,op_.ois_ccy_ ,ee);		
	
		//flt	
		flt_comp_avg_type comp_avg_type 		= sw_base.comp_avg_type_flt_leg(ee);//OBS n/a for ext swap
		flt_sprd_comp_method  sprd_comp_method 	= sw_base.sprd_comp_method_flt_leg(ee);//OBS n/a for ext swap
		flt_avg_method avg_method 				= sw_base.avg_method_flt_leg(ee);//OBS n/a for ext swap
		logical average_notional 				= null;
		..flt_roll_method flt_roll 				= null;
		logical flt_compound_to_mat 			= null;
		flt_stub_fwd_style flt_stub_rate_style 	= sw_base.stub_fwd_style_flt_leg(ee);
		fp_.init_static(fp_.flt_pmt_bus_day_,fp_.flt_pmt_calendar_,fp_.flt_end_of_month_,fp_.flt_ccy_,
						cfreq_flt, sw_base.reset_freq_flt_leg(ee),
						fp_.flt_dc_,sw_base.ir_rule_flt_leg(ee),sw_base.ir_index_flt_leg(ee),
						pmt_delay1,mat_pmt_delay1,pmt_delay_prin1,mat_pmt_delay_prin1,
						comp_avg_type,sprd_comp_method,avg_method,average_notional, flt_roll, flt_compound_to_mat,flt_stub_rate_style);

		//ois
		flt_comp_avg_type ois_comp_avg_type 		= sw_base.comp_avg_type_ois_leg(ee);//OBS n/a for ext swap
		flt_sprd_comp_method  ois_sprd_comp_method 	= sw_base.sprd_comp_method_ois_leg(ee);//OBS n/a for ext swap
		flt_avg_method ois_avg_method 				= sw_base.avg_method_ois_leg(ee);//OBS n/a for ext swap
		rfr_arrears_type at  						= sw_base.rfr_arrears_type_ois_leg(ee);//OBS n/a for ext swap
		integer a 									= sw_base.rfr_arrears_days_ois_leg(ee);//OBS n/a for ext swap
		number ad 									= a == err_int() ? null : a ;
		logical  ois_average_notional 				= null;
		flt_roll_method ois_roll 					= null; 
		op_.init_static(	op_.ois_pmt_bus_day_,op_.ois_pmt_calendar_,op_.ois_end_of_month_, op_.ois_ccy_,cfreq_ois,									
							op_.ois_dc_,sw_base.ir_rule_ois_leg(ee),sw_base.ir_index_ois_leg(ee),
							ois_comp_avg_type,ois_sprd_comp_method,ois_avg_method,
							pmt_delay2,mat_pmt_delay2,pmt_delay_prin2,mat_pmt_delay_prin2,
							at ,ad,sw_base.is_endog_df(ee),
							sw_base.is_approx_calc(ee),ois_average_notional,ois_roll);
		
	}
	void fltois_parm.init_static(	string option(nullable) spot_code,
									bd_convention  		pmt_bus_day,
									calendar 			pmt_cal,
									logical				end_of_month,
									notional_exchg_style option(nullable) ne,												
									//flt
									string				flt_ccy,
									logical				flt_is_mtm,
									integer 			flt_cpn_freq,
									day_count_method 	flt_day_count,
									interest_rule		flt_ir_rule,
									ir_index 			flt_ir_index,
									number				flt_pmt_delay,
									number				flt_pmt_delay_prin,
									flt_stub_fwd_style option(nullable) flt_stub_rate_style,
									//avg_comp_method option(nullable) flt_comp_avg,
											//flt_comp_avg_type option(nullable)		ois_comp_avg_t ,
											//flt_sprd_comp_method option(nullable)	ois_sprd_comp_m,
											//flt_avg_method 	option(nullable)		ois_avg_m,
									//ois
									string				ois_ccy,
									logical				ois_is_mtm,
									integer				ois_cpn_freq,
									day_count_method   	ois_day_count,
									interest_rule		ois_ir_rule,
									ir_index 			ois_ir_index,
									avg_comp_method option(nullable) ois_comp_avg,
											//flt_comp_avg_type option(nullable)		ois_comp_avg_t ,
											//flt_sprd_comp_method option(nullable)	ois_sprd_comp_m,
											//flt_avg_method 	option(nullable)		ois_avg_m,
									rfr_arrears_type  option(nullable)		ois_arr_type,
									number option(nullable) 				ois_arr_days ,
									number				ois_pmt_delay,
									number				ois_pmt_delay_prin,
									logical				ois_endog_df,
									logical 			ois_approx_calc)
	{
		//----fltois_parm-----		
		is_ccy_ 		= !equal_casei(flt_ccy, ois_ccy);	
		ne_ 			= ne;
		if(null(ne_))
			ne_ = is_ccy_ ? NE_BOTH : NE_NONE;

		spot_code_ 		= null(spot_code) ? "BD2": spot_code;
		trade_date_ 	= null;
		maturity_ 		= null;
		maturity_code_ 	= null;
		mat_code_ 		= null;
		fwd_start_code_ = null;
		start_date_ 	= null;
		settle_date_	= null;
		//cpn_roll_day_ 	= 0;

		if(is_ccy_) {
			if(!null(flt_is_mtm)) {
				is_mtm_leg1_ = flt_is_mtm;
				if(is_mtm_leg1_)
					is_mtm_ = true;
			}
			if(!null(ois_is_mtm) && ois_is_mtm) {			
				is_mtm_ = true;
			}
		}
		
		//---flt---
		logical flt_avg_not 		= null;
		..flt_roll_method flt_roll 	= null;
		logical flt_compound_to_mat = null;
		integer r_freq 				= flt_cpn_freq;
		flt_comp_avg_type  flt_comp_avg_t 		= null;
		flt_sprd_comp_method  flt_sprd_comp_m 	= null;
		flt_avg_method  flt_avg_m 				= null;
		//if(!null(flt_comp_avg)){
			//conv_from_avg_comp_method(flt_comp_avg,flt_comp_avg_t,flt_sprd_comp_m,flt_avg_m);
		//}
		
		
		fp_.init_static(pmt_bus_day,pmt_cal,end_of_month,flt_ccy,
						flt_cpn_freq, r_freq,flt_day_count,flt_ir_rule,flt_ir_index,
						flt_pmt_delay,	flt_pmt_delay, flt_pmt_delay_prin, flt_pmt_delay_prin ,
						flt_comp_avg_t, flt_sprd_comp_m, flt_avg_m,flt_avg_not,flt_roll,
						flt_compound_to_mat,flt_stub_rate_style);
	

		//----ois_parm--------
		flt_comp_avg_type  ois_comp_avg_t 		= null;
		flt_sprd_comp_method  ois_sprd_comp_m 	= null;
		flt_avg_method  ois_avg_m 				= null;
		if(!null(ois_comp_avg)){
			conv_from_avg_comp_method(ois_comp_avg,ois_comp_avg_t,ois_sprd_comp_m,ois_avg_m);
		}
		logical ois_avg_not 			= null;
		flt_roll_method ois_roll 		= null; 
		op_.init_static(pmt_bus_day, pmt_cal,end_of_month,ois_ccy,
								ois_cpn_freq, ois_day_count,
								ois_ir_rule,ois_ir_index,
								ois_comp_avg_t, ois_sprd_comp_m, ois_avg_m,
								ois_pmt_delay,	ois_pmt_delay, ois_pmt_delay_prin, ois_pmt_delay_prin ,
								ois_arr_type, ois_arr_days,ois_endog_df,
								ois_approx_calc,ois_avg_not, ois_roll);	
	}
	/*-----------------------------------------------------------------------
	  __set_spot_fwd  <protected>    
	  ----------------------------------------------------------------------*/
	void fltois_parm.__set_plain(	bd_convention option(nullable) 	pmt_bus_day,
									calendar option(nullable)	pmt_cal,
									logical	option(nullable) 	end_of_month,
									integer 					imp_sprd_dec,
									number option(nullable)		pv01_not_unit,									
									//flt1
									string	option(nullable) 	flt_ccy,
									logical	option(nullable)	flt_is_mtm,
									number option(nullable)		flt_cpn_freq_n,
									day_count_method  option(nullable) flt_day_count,
									interest_rule option(nullable) flt_ir_rule,
									ir_index option(nullable)	flt_ir_index,
									number option(nullable) 	flt_notional,
									number  option(nullable)	flt_pmt_delay,
									number  option(nullable)	flt_pmt_delay_prin,									
									number option(nullable) 	flt_curr_fix,
									number option(nullable)		flt_spread,
									//ois
									string	option(nullable) 	ois_ccy,
									logical	option(nullable)	ois_is_mtm,
									number option(nullable)		ois_cpn_freq_n,
									day_count_method  option(nullable) ois_day_count,
									interest_rule option(nullable) ois_ir_rule,
									ir_index option(nullable)	ois_ir_index,
									number option(nullable) 	ois_notional,
									flt_comp_avg_type option(nullable)		ois_comp_avg_t ,
									flt_sprd_comp_method option(nullable)	ois_sprd_comp_m,
									flt_avg_method 	option(nullable)		ois_avg_m,
									rfr_arrears_type  option(nullable)		ois_arr_type,
									number option(nullable) 				ois_arr_days ,
									number  option(nullable)	ois_pmt_delay,
									number  option(nullable)	ois_pmt_delay_prin,
									logical	option(nullable)	ois_endog_df,
									logical option(nullable)	ois_approx_calc,
									number option(nullable)		ois_spread)
	{
		imp_calc_dec_  	= imp_sprd_dec;//rounding decimals of the implied cpn rate (on decimal value)
		pv01_not_unit_  = null(pv01_not_unit) ? -1: pv01_not_unit;//rounding unit for notional when implied from pv01

		if(null(ois_ccy))
			ois_ccy = op_.ois_ccy_;

		if(null(flt_ccy))
			flt_ccy = fp_.flt_ccy_;
		
		is_ccy_ 		= !equal_casei(flt_ccy, ois_ccy);

		if(is_ccy_) {
			if(!null(flt_is_mtm)) {
				is_mtm_leg1_ = flt_is_mtm;
				if(is_mtm_leg1_)
					is_mtm_ = true;
			}
			if(!null(ois_is_mtm) && ois_is_mtm) {			
				is_mtm_ = true;
			}
		}
				
		date eff_date				= null;	
		date first_cpn_date			= null;	
		date last_reg_date			= null;
		number fx_mult 				= null;							
		vector(date) fixing_dates 	= null;	
		vector(number) fixing_rates	= null;
		number fix_proxy			= null;

		number 	flt_reset_freq_n 		= flt_cpn_freq_n;
		number  flt_mat_pmt_delay 		= flt_pmt_delay;
		number  flt_mat_pmt_delay_prin	= flt_pmt_delay_prin;
		stub_type flt_stub_type			= stub_type.SHORT_FIRST;
		flt_stub_fwd_style flt_stub_rate_style = null;//FIX_ME
		number  flt_fix_start_stub = null;//FIX_ME
		number  flt_fix_end_stub = null;//FIX_ME
		
		fp_.set_plain(pmt_bus_day, pmt_cal, end_of_month, flt_ccy, flt_cpn_freq_n, flt_reset_freq_n,flt_day_count,
					  flt_ir_rule,flt_ir_index, flt_pmt_delay,flt_mat_pmt_delay,flt_pmt_delay_prin,flt_mat_pmt_delay_prin,
					  flt_stub_rate_style,
					  flt_spread,flt_stub_type,eff_date,first_cpn_date,last_reg_date,flt_notional,
					  fx_mult,flt_curr_fix, fixing_dates,fixing_rates,fix_proxy,false,flt_fix_start_stub,flt_fix_end_stub);
		
		number  ois_mat_pmt_delay 		= ois_pmt_delay;
		number  ois_mat_pmt_delay_prin	= ois_pmt_delay_prin;
		stub_type ois_stub_type			= stub_type.SHORT_FIRST;					
		op_.set_plain(pmt_bus_day, pmt_cal, end_of_month, ois_ccy, ois_cpn_freq_n, ois_day_count,
					  ois_ir_rule,ois_ir_index,ois_spread,
					  ois_comp_avg_t,ois_sprd_comp_m,ois_avg_m,ois_arr_type,ois_arr_days,
					  ois_pmt_delay,ois_mat_pmt_delay,ois_pmt_delay_prin,ois_mat_pmt_delay_prin,ois_endog_df,
					  ois_approx_calc, ois_stub_type, eff_date,first_cpn_date,last_reg_date,ois_notional,
					  fx_mult,fixing_dates,fixing_rates,fix_proxy,false);
	}

	/*-----------------------------------------------------------------------
	  set_plain_single_ccy
	  ----------------------------------------------------------------------*/
	void fltois_parm.set_plain_single_ccy(	//common
											string 						name,											
											date option(nullable) 		trade_date,
											date option(nullable) 		settle_date,
											
											date option(nullable) 		start_date,
											string option(nullable) 	fwd_start_code,
											date option(nullable) 		maturity,
											string option(nullable) 	maturity_code,
											logical 					pay_float,											 											
											integer 					imp_sprd_dec,
											number 	option(nullable)	pv01_not_unit,
											number	option(nullable) 	notional,
											number	option(nullable) 	leg_pv01,											
											//flt
											number option(nullable)		flt_spread,
											number option(nullable) 	flt_curr_fix ,
											//ois											
											number option(nullable)		ois_spread)
	{
		QL_FAIL_COND(null(is_ccy_),"fltois_parm is not initalized (init_static() must be run) ");
		QL_REQUIRE(!is_ccy_,"function not applicable to cross currency swaps");
		
		if(null(notional))
			QL_REQUIRE(!null(leg_pv01),"one of notional and pv01 must be input");
		else if(null(leg_pv01))
			QL_REQUIRE(!null(notional),"one of notional and pv01 must be input");
		else if(!null(notional) && !null(leg_pv01))
			QL_FAIL("ambigious input of notional and pv01");
		
		this.__set_plain(null,null,null,imp_sprd_dec,pv01_not_unit,							
						null,false,null,null,null,null,notional,null,null,flt_curr_fix,
						flt_spread,null,false,null,null,null,null,notional,
						 null,null,null,null,null,
						 null,null,null,null,ois_spread);

		//-----common--------
		name_			= name;
		pay_leg1_ 		= pay_float;
		is_ccy_ 			= false;
	
		trade_date_ 	= trade_date;
		fwd_start_code_ = fwd_start_code;
		start_date_ 	= start_date;
		maturity_ 		= maturity;
		if(!null(maturity_code))
			maturity_code_ 	= maturity_code;
		settle_date_	= settle_date;
		//cpn_roll_day_ 	= 0;

		this.start_date_helper();
		this.maturity_helper(fp_);
		this.check();
		//if single ccy set_pv01/set_notional will also set the other notional as well as both fxrates to 1
		if(null(notional))
			this.set_pv01(leg_pv01);
		else
			this.set_notional_flt(notional);
		
		ne_ = notional_exchg_style.NE_NONE;
		
		is_inited_ = true;
	}
	/*-----------------------------------------------------------------------
	  set_plain_single_ccy <ALL ARGS>
	  ----------------------------------------------------------------------*/
	void fltois_parm.set_plain_single_ccy(	//common
											string 						name,											
											date option(nullable) 		trade_date,
											date option(nullable) 		settle_date,
											string option(nullable) 	spot_settle_code,
											date option(nullable) 		start_date,
											string option(nullable) 	fwd_start_code,
											date option(nullable) 		maturity,
											string option(nullable) 	maturity_code,
											logical pay_float,
											bd_convention option(nullable) 	pmt_bus_day,
											calendar option(nullable)	pmt_cal,
											logical	option(nullable) 	end_of_month,
											string	option(nullable) 	ccy,
											integer 					imp_sprd_dec,
											number 	option(nullable)	pv01_not_unit,
											number	option(nullable) 	notional,
											number	option(nullable) 	leg_pv01,											
											//flt													
											number option(nullable)		flt_cpn_freq_n,
											day_count_method  option(nullable) flt_day_count,
											interest_rule option(nullable) flt_ir_rule,
											ir_index option(nullable)	flt_ir_index,
											number  option(nullable)	flt_pmt_delay,
											number  option(nullable)	flt_pmt_delay_prin,
											number option(nullable)		flt_spread,
											number option(nullable) 	flt_curr_fix ,
											//ois
											number option(nullable)		ois_cpn_freq_n,
											day_count_method  option(nullable) ois_day_count,
											interest_rule option(nullable) ois_ir_rule,
											ir_index option(nullable)	ois_ir_index,
											avg_comp_method option(nullable) ois_comp_avg,
											//flt_comp_avg_type option(nullable)		ois_comp_avg_t ,
											//flt_sprd_comp_method option(nullable)	ois_sprd_comp_m,
											//flt_avg_method 	option(nullable)		ois_avg_m,
											rfr_arrears_type  option(nullable)		ois_arr_type,
											number option(nullable) 				ois_arr_days ,
											number  option(nullable)	ois_pmt_delay,
											number  option(nullable)	ois_pmt_delay_prin,
											logical	option(nullable)	ois_endog_df,
											logical option(nullable)	ois_approx_calc,
											number option(nullable)		ois_spread)
	{
		if(null(notional))
			QL_REQUIRE(!null(leg_pv01),"one of notional and pv01 must be input");
		else if(null(leg_pv01))
			QL_REQUIRE(!null(notional),"one of notional and pv01 must be input");
		else if(!null(notional) && !null(leg_pv01))
			QL_FAIL("ambigious input of notional and pv01");

		flt_comp_avg_type  ois_comp_avg_t 		= null;
		flt_sprd_comp_method  ois_sprd_comp_m 	= null;
		flt_avg_method  ois_avg_m 				= null;
		if(!null(ois_comp_avg)){
			conv_from_avg_comp_method(ois_comp_avg,ois_comp_avg_t,ois_sprd_comp_m,ois_avg_m);
		}
		
		this.__set_plain(	pmt_bus_day,pmt_cal,end_of_month,imp_sprd_dec,pv01_not_unit,							
							ccy,false,flt_cpn_freq_n,flt_day_count,flt_ir_rule,flt_ir_index,notional,
							flt_pmt_delay,flt_pmt_delay_prin, flt_curr_fix,flt_spread,
							ccy,false,ois_cpn_freq_n,ois_day_count,ois_ir_rule,ois_ir_index,notional,
							ois_comp_avg_t ,ois_sprd_comp_m,ois_avg_m,ois_arr_type,ois_arr_days ,							
							ois_pmt_delay,ois_pmt_delay_prin,
							ois_endog_df,ois_approx_calc,ois_spread);

		//-----common--------
		name_			= name;
		pay_leg1_ 		= pay_float;
		is_ccy_ 			= false;
		if(!null(spot_settle_code))
			spot_code_ 	= spot_settle_code;
		trade_date_ 	= trade_date;
		fwd_start_code_ = fwd_start_code;
		start_date_ 	= start_date;
		maturity_ 		= maturity;
		if(!null(maturity_code))
			maturity_code_ 	= maturity_code;
		settle_date_	= settle_date;
		//cpn_roll_day_ 	= 0;

		this.start_date_helper();
		this.maturity_helper(fp_);
		this.check();
		//if single ccy set_pv01/set_notional will also set the other notional as well as both fxrates to 1
		if(null(notional))
			this.set_pv01(leg_pv01);
		else
			this.set_notional_flt(notional);
		
		ne_ = notional_exchg_style.NE_NONE;
		
		is_inited_ = true;
	}

	
	
	/*-----------------------------------------------------------------------
	  set_plain
	  ----------------------------------------------------------------------*/
	void fltois_parm.set_plain(	string 							name,								
								date option(nullable) 			trade_date,
								date option(nullable) 			settle_date,
								
								date option(nullable) 			start_date,
								string option(nullable) 		fwd_start_code,
								date option(nullable)			maturity,
								string option(nullable) 		maturity_code,
								logical 						pay_float,
								integer 						imp_sprd_dec,
								number 	option(nullable)		pv01_not_unit,
								number	option(nullable) 		leg_pv01,
								number 	option(nullable) 		fx_quote,
								string 	option(nullable) 		fx_quote_baseccy,
								string 	option(nullable) 		fx_quote_priceccy,
								logical option(nullable) 		pv_in_base_ccy,
								//flt
								number option(nullable) 		flt_spread,
								stub_type option(nullable)		flt_stub_type,
								date option(nullable)  			flt_eff_date,
								date option(nullable)  			flt_first_cpn_date,
								date option(nullable)  			flt_last_reg_date,
								number	option(nullable) 		flt_notional,								
								number option(nullable) 		flt_curr_fix,
								vector(date) option(nullable) 	flt_fixing_dates ,	
								vector(number) option(nullable) flt_fixing_rates,
								number option(nullable) 		flt_fix_proxy ,
								logical option(nullable) 		flt_allow_fwd_fix,
								//ois
								number option(nullable) 		ois_spread,
								stub_type option(nullable)		ois_stub_type,
								date option(nullable)  			ois_eff_date,
								date option(nullable)  			ois_first_cpn_date,
								date option(nullable)  			ois_last_reg_date,
								number	option(nullable) 		ois_notional,
								//number	option(nullable) 		ois_pv01,
								vector(date) option(nullable) 	ois_fixing_dates ,	
								vector(number) option(nullable) ois_fixing_rates,
								number option(nullable) 		ois_fix_proxy ,
								logical option(nullable) 		ois_allow_fwd_fix)
	{
		QL_FAIL_COND(null(is_ccy_),"fltois_parm is not initalized (init_static() must be run) ");
		
		if(null(flt_notional) && null(ois_notional))
			QL_REQUIRE(!null(leg_pv01),"one of notionals and leg_pv01 must be input");
		else if(null(leg_pv01))
			QL_REQUIRE(!null(flt_notional) || !null(ois_notional),"one of notionals and leg_pv01 must be input");
		else if(!null(flt_notional) && !null(ois_notional) && !null(leg_pv01))
			QL_FAIL("ambigious input of notionals and leg_pv01");		
		
		number 	flt_fx_mult, ois_fx_mult;
		set_fx_input(fp_.flt_ccy_,op_.ois_ccy_, fx_quote, fx_quote_baseccy, fx_quote_priceccy, pv_in_base_ccy, flt_notional,ois_notional, flt_fx_mult, ois_fx_mult);	

		flt_stub_fwd_style flt_stub_rate_style = null;//FIX_ME
		number  flt_fix_start_stub = null;//FIX_ME
		number  flt_fix_end_stub = null;//FIX_ME
		
		//----flt_parm--------
		fp_.set_plain(	null, null, null, null, null,null,null,
						null , null, null,null,null,null,flt_stub_rate_style,flt_spread, flt_stub_type,flt_eff_date, flt_first_cpn_date,
						flt_last_reg_date, flt_notional, flt_fx_mult, flt_curr_fix,
						flt_fixing_dates ,flt_fixing_rates,flt_fix_proxy ,flt_allow_fwd_fix,flt_fix_start_stub,flt_fix_end_stub);

		//----ois_parm--------		

		op_.set_plain(	null,null,null,null,null,null, null,null, ois_spread,null,null,null,null,null,
						null,null ,null ,null,null,null,
						ois_stub_type,ois_eff_date, ois_first_cpn_date,
						ois_last_reg_date, ois_notional, ois_fx_mult, ois_fixing_dates , ois_fixing_rates,
						ois_fix_proxy , ois_allow_fwd_fix);
		
		
		//---common---
		name_			= name;
		imp_calc_dec_  	= imp_sprd_dec;
		pv01_not_unit_  = null(pv01_not_unit) ? -1: pv01_not_unit;//rounding unit for notional when implied from pv01
		pay_leg1_ 		= pay_float;

		
		trade_date_ 	= trade_date;
		fwd_start_code_ = fwd_start_code;
		start_date_ 	= start_date;
		maturity_ 		= maturity;
		if(!null(maturity_code))
			maturity_code_ 	= maturity_code;
		settle_date_	= settle_date;
		//cpn_roll_day_ 	= 0;

		this.start_date_helper();
		this.maturity_helper(fp_);
		this.schedule_helper(fp_);
		this.schedule_helper(op_);
		this.check();		
		//if single ccy set_pv01/set_notional will also set the other notional as well as both fxrates to 1
		if(null(flt_notional) && null(ois_notional)){
			this.set_pv01(leg_pv01);
		}
		else if(!null(flt_notional)){
			this.set_notional_flt(flt_notional);
		}
		else if(!null(ois_notional)){
			this.set_notional_ois(ois_notional);
		}
		
		is_inited_ = true;
	}
	/*-----------------------------------------------------------------------
	  set_plain <ALL ARGS>
	  ----------------------------------------------------------------------*/
	void fltois_parm.set_plain(	//common
								string 							name,								
								date option(nullable) 			trade_date,
								date option(nullable) 			settle_date,
								string option(nullable) 		spot_settle_code,
								date option(nullable) 			start_date,
								string option(nullable) 		fwd_start_code,
								date option(nullable)			maturity,
								string option(nullable) 		maturity_code,
								logical 						pay_float,
								bd_convention option(nullable)	pmt_bus_day,
								calendar option(nullable)		pmt_cal,
								logical	 option(nullable)		end_of_month,
								notional_exchg_style option(nullable) notional_exchg,
								integer 						imp_sprd_dec,
								number 	option(nullable)		pv01_not_unit,
								number	option(nullable) 		leg_pv01,
								number 	option(nullable) 		fx_quote,
								string 	option(nullable) 		fx_quote_baseccy,
								string 	option(nullable) 		fx_quote_priceccy,
								logical option(nullable) 		pv_in_base_ccy,
								//flt
								string	 option(nullable) 		flt_ccy,
								logical	option(nullable)		flt_is_mtm,
								number option(nullable)	 		flt_cpn_freq_n,
								day_count_method  option(nullable) flt_day_count,
								interest_rule option(nullable) 	flt_ir_rule ,
								ir_index option(nullable)		flt_ir_index,
								number  option(nullable)		flt_pmt_delay,
								number  option(nullable)		flt_pmt_delay_prin,
								number option(nullable) 		flt_spread,
								stub_type option(nullable)		flt_stub_type,
								date option(nullable)  			flt_eff_date,
								date option(nullable)  			flt_first_cpn_date,
								date option(nullable)  			flt_last_reg_date,
								number	option(nullable) 		flt_notional,
								
								number option(nullable) 		flt_curr_fix,
								vector(date) option(nullable) 	flt_fixing_dates ,	
								vector(number) option(nullable) flt_fixing_rates,
								number option(nullable) 		flt_fix_proxy ,
								logical option(nullable) 		flt_allow_fwd_fix,
								//ois
								string	option(nullable) 		ois_ccy,
								logical	option(nullable)		ois_is_mtm,
								number option(nullable)	 		ois_cpn_freq_n,
								day_count_method  option(nullable) ois_day_count,
								interest_rule option(nullable) ois_ir_rule,
								ir_index option(nullable)		ois_ir_index,
								number  option(nullable)		ois_pmt_delay,
								number  option(nullable)		ois_pmt_delay_prin,
								
								avg_comp_method option(nullable) ois_comp_avg,
											//flt_comp_avg_type option(nullable)		ois_comp_avg_t ,
											//flt_sprd_comp_method option(nullable)	ois_sprd_comp_m,
											//flt_avg_method 	option(nullable)		ois_avg_m,
								rfr_arrears_type option(nullable)  	ois_arr_type,
								number option(nullable)  			ois_arr_days,
								
								logical	option(nullable)		ois_endog_df,
								logical option(nullable)		ois_approx_calc,
								number option(nullable) 		ois_spread,
								stub_type option(nullable)		ois_stub_type,
								date option(nullable)  			ois_eff_date,
								date option(nullable)  			ois_first_cpn_date,
								date option(nullable)  			ois_last_reg_date,
								number	option(nullable) 		ois_notional,
								//number	option(nullable) 		ois_pv01,
								vector(date) option(nullable) 	ois_fixing_dates ,	
								vector(number) option(nullable) ois_fixing_rates,
								number option(nullable) 		ois_fix_proxy ,
								logical option(nullable) 		ois_allow_fwd_fix)
	{
		if(null(flt_notional) && null(ois_notional))
			QL_REQUIRE(!null(leg_pv01),"one of notionals and leg_pv01 must be input");
		else if(null(leg_pv01))
			QL_REQUIRE(!null(flt_notional) || !null(ois_notional),"one of notionals and leg_pv01 must be input");
		else if(!null(flt_notional) && !null(ois_notional) && !null(leg_pv01))
			QL_FAIL("ambigious input of notionals and leg_pv01");	

		if(null(flt_ccy))
			flt_ccy = fp_.flt_ccy_ ;
		
		if(null(ois_ccy))
			ois_ccy = op_.ois_ccy_ ;
		
		number 	flt_fx_mult, ois_fx_mult;
		set_fx_input(flt_ccy,ois_ccy, fx_quote, fx_quote_baseccy, fx_quote_priceccy, pv_in_base_ccy, flt_notional,ois_notional,flt_fx_mult, ois_fx_mult);	
		
		//----flt_parm--------
		number  flt_mat_pmt_delay 		= flt_pmt_delay;		
		number  flt_mat_pmt_delay_prin	= flt_pmt_delay_prin;	
		number flt_reset_freq_n 		= flt_cpn_freq_n;
		flt_stub_fwd_style flt_stub_rate_style = null;//FIX_ME
		number  flt_fix_start_stub = null;//FIX_ME
		number  flt_fix_end_stub = null;//FIX_ME
		
		fp_.set_plain(	pmt_bus_day, pmt_cal, end_of_month, flt_ccy, flt_cpn_freq_n,flt_reset_freq_n,flt_day_count,
						flt_ir_rule , flt_ir_index,flt_pmt_delay ,flt_mat_pmt_delay ,flt_pmt_delay_prin,flt_mat_pmt_delay_prin,
						flt_stub_rate_style,flt_spread, flt_stub_type,flt_eff_date, flt_first_cpn_date,
						flt_last_reg_date, flt_notional, flt_fx_mult, flt_curr_fix,
						flt_fixing_dates ,flt_fixing_rates,flt_fix_proxy ,flt_allow_fwd_fix,flt_fix_start_stub,flt_fix_end_stub);

		//----ois_parm--------
		
		number  ois_mat_pmt_delay 		= ois_pmt_delay;		
		number  ois_mat_pmt_delay_prin	= ois_pmt_delay_prin;
		flt_comp_avg_type  ois_comp_avg_t 		= null;
		flt_sprd_comp_method  ois_sprd_comp_m 	= null;
		flt_avg_method  ois_avg_m 				= null;
		if(!null(ois_comp_avg)){
			conv_from_avg_comp_method(ois_comp_avg,ois_comp_avg_t,ois_sprd_comp_m,ois_avg_m);
		}
		
		op_.set_plain(pmt_bus_day,pmt_cal,end_of_month,ois_ccy,ois_cpn_freq_n,
						ois_day_count,ois_ir_rule, ois_ir_index, ois_spread,					  
						ois_comp_avg_t, ois_sprd_comp_m, ois_avg_m, ois_arr_type, ois_arr_days,					  
						ois_pmt_delay ,ois_mat_pmt_delay ,ois_pmt_delay_prin,ois_mat_pmt_delay_prin,ois_endog_df,ois_approx_calc,
						ois_stub_type,ois_eff_date, ois_first_cpn_date,
						ois_last_reg_date, ois_notional, ois_fx_mult, ois_fixing_dates , ois_fixing_rates,
						ois_fix_proxy , ois_allow_fwd_fix);
		
		
		//---common---
		name_			= name;
		imp_calc_dec_  	= imp_sprd_dec;
		pv01_not_unit_  = null(pv01_not_unit) ? -1: pv01_not_unit;//rounding unit for notional when implied from pv01
		pay_leg1_ 		= pay_float;
		
		if(null(notional_exchg)) {
			if(null(ne_))
				ne_ = is_ccy_ ? notional_exchg_style.NE_BOTH : notional_exchg_style.NE_NONE;
		}
		else {
			ne_ = notional_exchg;
		}

		if(!null(spot_settle_code))
			spot_code_ 	= spot_settle_code;
		trade_date_ 	= trade_date;
		fwd_start_code_ = fwd_start_code;
		start_date_ 	= start_date;
		maturity_ 		= maturity;
		if(!null(maturity_code))
			maturity_code_ 	= maturity_code;
		settle_date_	= settle_date;
		//cpn_roll_day_ 	= 0;

		if(is_ccy_) {
			if(!null(flt_is_mtm)) {
				is_mtm_leg1_ = flt_is_mtm;
				if(is_mtm_leg1_)
					is_mtm_ = true;
			}
			if(!null(ois_is_mtm) && ois_is_mtm) {			
				is_mtm_ = true;
			}
		}
		
		this.start_date_helper();
		this.maturity_helper(fp_);
		this.schedule_helper(fp_);
		this.schedule_helper(op_);
		this.check();		
		//if single ccy set_pv01/set_notional will also set the other notional as well as both fxrates to 1
		if(null(flt_notional) && null(ois_notional)){
			this.set_pv01(leg_pv01);
		}
		else if(!null(flt_notional)){
			this.set_notional_flt(flt_notional);
		}
		else if(!null(ois_notional)){
			this.set_notional_ois(ois_notional);
		}
		
		is_inited_ = true;
	}
	/*-----------------------------------------------------------------------
	  create_swap
	  ----------------------------------------------------------------------*/	
	/*swap_fltois fltois_parm.create_swap(disc_func option(nullable) 	flt_disc_func,
										disc_func option(nullable) 	flt_fwd_disc_func,
										disc_func option(nullable) 	ois_disc_func,
										fwd_func option(nullable) 	ois_fwd_func,
										disc_func option(nullable) 	ois_fwd_disc_func,
										logical sync_endog_ok)
	{
		logical rev_leg_prio 	= true ;

		disc_func 	odf,ofdf, dfr;
		fwd_func 	of;							
		op_.ois_df_helper( ois_disc_func,ois_fwd_func,ois_fwd_disc_func,
							flt_disc_func,
							is_cross_currency(), rev_leg_prio, sync_endog_ok,
							trade_date_,
							maturity_,
							odf,of,ofdf,dfr);
		
		return __create_swap( flt_disc_func,null,flt_fwd_disc_func, odf, of, ofdf);
	}*/
	/*-----------------------------------------------------------------------
	  create_swap
	  ----------------------------------------------------------------------*/	
	swap_fltois fltois_parm.create_swap(disc_func option(nullable) 	flt_disc_func,
										fwd_func option(nullable) 	flt_fwd_func,
										disc_func option(nullable) 	flt_fwd_disc_func,
										disc_func option(nullable) 	ois_disc_func,
										fwd_func option(nullable) 	ois_fwd_func,
										disc_func option(nullable) 	ois_fwd_disc_func,
										logical sync_endog_ok,
										logical option(nullable) 	flt_allow_extrap )
	{
		logical rev_leg_prio 	= true ;

		disc_func 	odf,ofdf, dfr;
		fwd_func 	of;							
		op_.ois_df_helper( ois_disc_func,ois_fwd_func,ois_fwd_disc_func,
							flt_disc_func,
							is_cross_currency(), rev_leg_prio, sync_endog_ok,
							trade_date_,
							maturity_,
							odf,of,ofdf,dfr);
		
		return __create_swap(  flt_disc_func,flt_fwd_func, flt_fwd_disc_func,  odf, of, ofdf,flt_allow_extrap);
	}
	
	/*-----------------------------------------------------------------------
	  __create_swap <protected>
	  ----------------------------------------------------------------------*/	
	swap_fltois fltois_parm.__create_swap(disc_func option(nullable) 	flt_disc_func,
											fwd_func option(nullable) 	flt_fwd_func,
											disc_func option(nullable) 	flt_fwd_disc_func,
											disc_func option(nullable) 	ois_disc_func,
											fwd_func option(nullable) 	ois_fwd_func,
											disc_func option(nullable) 	ois_fwd_disc_func,
											logical option(nullable) 	flt_allow_extrap )
	{
		//string err_msg;
		//logical ok = this.ois_df_check(flt_disc_func,ois_disc_func, ois_fwd_func, ois_fwd_disc_func, err_msg);			
		//QL_REQUIRE(ok,err_msg);

		
		QL_FAIL_COND(!null(flt_fwd_func) && !null(flt_fwd_disc_func),"ambigious input float leg (fwd_func/disc_func)");//already checked?
		//QL_FAIL_COND(!null(ois_fwd_func) && !null(ois_fwd_disc_func),"ambigious input ois leg (fwd_func/disc_func)");//already checked?

		if(!is_ccy_){
			if(!null(flt_disc_func))
				ois_disc_func = flt_disc_func;
			else if(!null(ois_disc_func))
				flt_disc_func = ois_disc_func;
		}
		//----defs-----
		ql_swap_float_def flt_def 	= this.create_swap_float_def(fp_,"flt_def");
		QL_FAIL_COND(null(flt_def),"error creating float leg def");
		ql_swap_ois_def ois_def 	= this.create_swap_ois_def(op_,"ois_def");
		QL_FAIL_COND(null(ois_def),"error creating ois leg def");

		//tenor surface flt
		tenor_surface flt_ts;
		if(null(flt_fwd_func) && null(flt_fwd_disc_func)){
			flt_ts = null;
		}
		else if(!null(flt_fwd_func)){
			flt_ts = create_flt_surface(fp_, flt_disc_func,flt_fwd_func,null,flt_allow_extrap);
			QL_FAIL_COND(null(flt_ts),"error creating tenor surface");
		}
		else{
			flt_ts = create_flt_surface(fp_, flt_disc_func,null,flt_fwd_disc_func,flt_allow_extrap);
			QL_FAIL_COND(null(flt_ts),"error creating tenor surface");
		}

		//tenor surface ois
		tenor_surface ois_tenor_surface;
		create_ois_surface(op_,null, ois_fwd_func, ois_fwd_disc_func, flt_disc_func, ois_disc_func, ois_tenor_surface);

		
		//----flt leg------

		ql_float_leg flt;
		if(is_mtm_leg_flt()){
			flt = this.create_swap_float_mtm_leg1(flt_def, "float_leg_mtm",pay_leg1_, flt_disc_func, flt_ts, ois_disc_func);
			QL_FAIL_COND(null(flt),"error creating float leg (mtm)");
		}
		else {
			flt = this.create_swap_float_leg(fp_,flt_def, "float_leg",pay_leg1_, flt_disc_func, flt_ts);
			QL_FAIL_COND(null(flt),"error creating float leg");
		}

		//----ois leg------
		
		ql_ois_leg ois;
		if(is_mtm_leg_ois()){
			ois = this.create_swap_ois_mtm_leg2(ois_def, "ois_leg_mtm",!pay_leg1_, ois_disc_func, ois_tenor_surface,flt_disc_func);
			QL_FAIL_COND(null(ois),"error creating ois leg (mtm)");
		}
		else {
			ois = this.create_swap_ois_leg(op_,ois_def, "ois_leg",!pay_leg1_, ois_disc_func, ois_tenor_surface);
			QL_FAIL_COND(null(ois),"error creating ois leg");
		}
		
		//----swap----
		ql_fixed_income_swap sw 	= ql_fixed_income_swap(flt,ois,name_);
		QL_FAIL_COND(null(sw),"error creating swap");

		if(!null(fp_.flt_curr_fix_))
			sw.float_leg(false)[0].set_current_fixing(fp_.flt_curr_fix_);

		//logical flat_is_ois = sw.flat_leg_is_ois_leg();

		logical solve_sprd_flt = primary_quote_is_leg1();

	
		if(solve_sprd_flt) {
			__create_swap_solve_flt(flt_disc_func,ois_disc_func,
									flt_def ,ois_def ,
									flt_ts,flt,ois,sw);
			
		}
		else {
			__create_swap_solve_ois(flt_disc_func,ois_disc_func,flt_def ,ois_def ,
									ois_tenor_surface,flt,ois,sw);
			

			
		}

		error_info ee 	= new error_info(true,true);
		swap_fltois swfo = swap_fltois(sw, ee);

		if(!null(leg_pv01_)) {//
			if(solve_sprd_flt) {
				calc_not_pv01_flt(swfo);
			}
			else {				
				calc_not_pv01_ois(swfo);
			}
			//update the newly created swap with new notional
			if(!swfo.is_cross_currency(ee)){
				swfo.add_notional(op_.ois_notional_);
			}
			else {
				swfo.add_notional(fp_.flt_notional_, op_.ois_notional_);
				
				/*if(!is_mtm_leg_flt()) {
					swfo.add_notional(fp_.flt_notional_);
				}
				else {
					flt = this.create_swap_float_mtm_leg1(flt_def, "float_leg_mtm",pay_leg1_, flt_disc_func, flt_ts, ois_disc_func);
					QL_FAIL_COND(null(flt),"error creating float leg (mtm)");
					sw 		= ql_fixed_income_swap(flt,ois,name_);
					QL_FAIL_COND(null(sw),"error creating swap");

					if(!null(fp_.flt_curr_fix_))
						sw.float_leg(false)[0].set_current_fixing(fp_.flt_curr_fix_);					
					
				}
				if(!is_mtm_leg_ois()) {
					swfo.add_notional_ois_leg(op_.ois_notional_);
				}
				else {
					ois = this.create_swap_ois_mtm_leg2(ois_def, "ois_leg_mtm",!pay_leg1_, ois_disc_func, ois_tenor_surface,flt_disc_func);
					QL_FAIL_COND(null(ois),"error creating ois leg (mtm)");
					sw 		= ql_fixed_income_swap(flt,ois,name_);
					QL_FAIL_COND(null(sw),"error creating swap");
					
				}*/
			}
			
		}
		//--calc notional if pv01 input---
		/*if(!null(leg_pv01_)) {
			
			number pv01_1m 	= swfo.pv01_spread_ois_leg(1000000,null,null,ee);//keep 1000000 as notional because this is the default notional when notional is not input (not really necessary) 
			number ois_not 	= abs(leg_pv01_)/pv01_1m*1000000;

			if(pv01_not_unit_>0){
				number a = ois_not/pv01_not_unit_;
				a = round(a,0);
				ois_not = a * pv01_not_unit_;
			}
			//update parm with new notional
			op_.ois_notional_ = ois_not;
			fp_.flt_notional_ = null;	
			fx_notional_helper();

			//update the newly created swap with new notional
			if(swfo.is_cross_currency(ee)){
				if(!is_mtm_leg_flt()) {
					swfo.add_notional_flt_leg(fp_.flt_notional_);
				}
				else {
					flt = this.create_swap_float_mtm_leg1(flt_def, "float_leg_mtm",pay_leg1_, flt_disc_func, flt_ts, ois_disc_func);
					QL_FAIL_COND(null(flt),"error creating float leg (mtm)");
					sw 		= ql_fixed_income_swap(flt,ois,name_);
					QL_FAIL_COND(null(sw),"error creating swap");

					if(!null(fp_.flt_curr_fix_))
						sw.float_leg(false)[0].set_current_fixing(fp_.flt_curr_fix_);					
					
				}
				if(!is_mtm_leg_ois()) {
					swfo.add_notional_ois_leg(op_.ois_notional_);
				}
				else {
					ois = this.create_swap_ois_mtm_leg2(ois_def, "ois_leg_mtm",!pay_leg1_, ois_disc_func, ois_tenor_surface,flt_disc_func);
					QL_FAIL_COND(null(ois),"error creating ois leg (mtm)");
					sw 		= ql_fixed_income_swap(flt,ois,name_);
					QL_FAIL_COND(null(sw),"error creating swap");
					
				}
			}
			else {
				swfo.add_notional(ois_not);
			}
		}*/
		return swfo;
	}
	/*-----------------------------------------------------------------------
	  __create_swap_pv01_ois
	  ----------------------------------------------------------------------*/
	void fltois_parm.calc_not_pv01_ois(swap_fltois swfo )
	{
		//if(!null(leg_pv01_)) {

		error_info ee 	= new error_info(true,true);
		number pv01_1m 	= swfo.pv01_spread_flt_leg(1000000,null,null,ee);//keep 1000000 as notional because this is the default notional when notional is not input (not really necessary) 
		number flt_not 	= abs(leg_pv01_)/pv01_1m*1000000;

		if(pv01_not_unit_>0){
			number a = flt_not/pv01_not_unit_;
			a = round(a,0);
			flt_not = a * pv01_not_unit_;
		}
		//update parm with new notional
		op_.ois_notional_ = null;
		fp_.flt_notional_ = flt_not;	
		fx_notional_helper();
	}
	/*-----------------------------------------------------------------------
	  calc_not_pv01_flt
	  ----------------------------------------------------------------------*/
	void fltois_parm.calc_not_pv01_flt(swap_fltois swfo )
	{
		//if(!null(leg_pv01_)) {

		error_info ee 	= new error_info(true,true);
		number pv01_1m 	= swfo.pv01_spread_ois_leg(1000000,null,null,ee);//keep 1000000 as notional because this is the default notional when notional is not input (not really necessary) 
		number ois_not 	= abs(leg_pv01_)/pv01_1m*1000000;

		if(pv01_not_unit_>0){
			number a = ois_not/pv01_not_unit_;
			a = round(a,0);
			ois_not = a * pv01_not_unit_;
		}
		//update parm with new notional
		op_.ois_notional_ = ois_not;
		fp_.flt_notional_ = null;	
		fx_notional_helper();
			
		//}
	}
	/*-----------------------------------------------------------------------
	  ___create_swap_solve_flt
	  ----------------------------------------------------------------------*/
	void fltois_parm.__create_swap_solve_flt(	disc_func option(nullable) 	flt_disc_func,
												disc_func option(nullable) 	ois_disc_func,
												ql_swap_float_def 			flt_def ,
												ql_swap_ois_def 			ois_def ,
												tenor_surface 	option(nullable) flt_ts,
												out ql_float_leg 			flt,
												out ql_ois_leg 				ois,
												out ql_fixed_income_swap 	sw)
	{
		//solve for spread if null
		
		if(null(fp_.flt_spread_)){
			number s	= sw.solver(0,swap_solver_code.SS_FLT_SPRD_LEG1,false);
			QL_FAIL_COND(null(s),"error calculating implied spread on float leg", E_INIT);

			if(imp_calc_dec_ >= 0)
				s = round(s,imp_calc_dec_);
				
			fp_.flt_spread_ = s;
			
			//---recreate flt leg------
			if(is_mtm_leg_flt()){
				flt = this.create_swap_float_mtm_leg1(flt_def, "float_leg_mtm",pay_leg1_, flt_disc_func, flt_ts, ois_disc_func);
				QL_FAIL_COND(null(flt),"error creating float leg (mtm)");
			}
			else {
				flt = this.create_swap_float_leg(fp_,flt_def, "float_leg",pay_leg1_, flt_disc_func, flt_ts);
				QL_FAIL_COND(null(flt),"error creating float leg");
			}
			//----recreate swap-------
			sw 		= ql_fixed_income_swap(flt,ois,name_);
			QL_FAIL_COND(null(sw),"error creating swap");

			if(!null(fp_.flt_curr_fix_))
				sw.float_leg(false)[0].set_current_fixing(fp_.flt_curr_fix_);
		}
	}
	/*-----------------------------------------------------------------------
	  __create_swap_solve_ois
	  ----------------------------------------------------------------------*/
	void fltois_parm.__create_swap_solve_ois(disc_func option(nullable) flt_disc_func,													
											disc_func option(nullable) 	ois_disc_func,											
											ql_swap_float_def 			flt_def ,
											ql_swap_ois_def 			ois_def ,
											tenor_surface 	option(nullable)  ois_tenor_surface,
											out ql_float_leg 			flt,
											out ql_ois_leg 				ois,
											out ql_fixed_income_swap 	sw)
	{
		//solve for spread if null
		
		if(null(op_.ois_spread_)){
			number s	= sw.solver(0,swap_solver_code.SS_OIS_SPRD_LEG2,false);
			QL_FAIL_COND(null(s),"error calculating implied spread on ois leg", E_INIT);

			if(imp_calc_dec_ >= 0)
				s = round(s,imp_calc_dec_);
				
			op_.ois_spread_ = s;
			
			//---recreate ois leg------
			if(is_mtm_leg_ois()){
				ois = this.create_swap_ois_mtm_leg2(ois_def, "ois_leg_mtm",!pay_leg1_, ois_disc_func, ois_tenor_surface,flt_disc_func);
				QL_FAIL_COND(null(ois),"error creating ois leg (mtm)");
			}
			else {
				ois = this.create_swap_ois_leg(op_,ois_def, "ois_leg",!pay_leg1_, ois_disc_func, ois_tenor_surface);
				QL_FAIL_COND(null(ois),"error creating ois leg");
			}
			//----recreate swap-------
			sw 		= ql_fixed_income_swap(flt,ois,name_);
			QL_FAIL_COND(null(sw),"error creating swap");

			if(!null(fp_.flt_curr_fix_))
				sw.float_leg(false)[0].set_current_fixing(fp_.flt_curr_fix_);
		}
	}
}