option(null: hard);	

/*	
	swaplib wrapper functions
	Developer: Algorithmica Research, Magnus Nyström

	--------------------------------------------------------------------
	 	swap help functions for create funcs
	--------------------------------------------------------------------			
*/
module CORE_SWAPLIB
{
	
	/*-----------------------------------------------------------------------
	 ------------------------------------------------------------------------
	 -----class fltois2s_parm------------------------------------------------
	 -------leg1 == fixois---> leg2 == flat--??--------------------------------
	 -----------------------------------------------------------------------*/
	class fltois2s_parm : public legleg_parm
	{
	public:
		override instr_type	type() ;
		
		fltois2s_parm();
	
		void 				start_date_helper( );
		void 				fx_notional_helper();

		void				init_static(instr_def,string option(nullable) spot_code  );
		void				init_static(INSTR_TMPL.swap_fltois2s_def_tmpl);
		//void				init_static(swap_fltois2s,string option(nullable) spot_code );
		void 				init_static(	string option(nullable) spot_code,
											bd_convention  		pmt_bus_day,
											calendar 			pmt_cal,
											logical				end_of_month,
											notional_exchg_style option(nullable) ne,
											string				ccy,
											//fixois											
											integer 			fix_sprd_cpn_freq,
											day_count_method  	fix_sprd_day_count,
											interest_rule		fix_sprd_ir_rule,
											//fixflt											
											integer 			fix_flat_cpn_freq,
											day_count_method  	fix_flat_day_count,
											interest_rule		fix_flat_ir_rule,											
											//ois											
											integer 			ois_cpn_freq,										
											day_count_method 	ois_day_count,
											interest_rule		ois_ir_rule,
											ir_index 			ois_ir_index,
											number				ois_pmt_delay,											
											logical				ois_endog_df,
											logical 			ois_approx_calc,
											//flt											
											integer 			flt_cpn_freq,											
											day_count_method 	flt_day_count,
											interest_rule		flt_ir_rule,
											ir_index 			flt_ir_index);
		
		void 				set_notional(number);
		void 				set_pv01(number);
		fix_parm			fix_leg_parm_flat();
		fix_parm			fix_leg_parm_sprd();
		flt_parm 			flt_leg_parm();
		ois_parm 			ois_leg_parm();
		

	protected:
				
		void 		check();
		//void 		__set_plain_vanilla();
		void 		__set_plain(	bd_convention option(nullable) 	pmt_bus_day,
									calendar option(nullable)	pmt_cal,
									logical	option(nullable) 	end_of_month,
									integer 					imp_sprd_dec,
									number option(nullable)		pv01_not_unit,
									string option(nullable),
									number option(nullable)	,
									//fixois=spread
									number option(nullable)		fixo_cpn_freq_n,
									day_count_method option(nullable) fixo_day_count,
									interest_rule option(nullable) fixo_ir_rule	,									
									number	option(nullable)	fixo_spread,
									//fixflt=flat
									number option(nullable)		fixf_cpn_freq_n,
									day_count_method option(nullable) fixf_day_count,
									interest_rule option(nullable) fixf_ir_rule	,
									number	option(nullable)	fixf_cpn_rate_flat,
									//ois	sprd												
									number option(nullable)		ois_cpn_freq_n,
									day_count_method  option(nullable) ois_day_count,
									interest_rule option(nullable) 	,
									ir_index option(nullable)	ois_ir_index,
									number  option(nullable)	ois_pmt_delay,
									number  option(nullable)	ois_pmt_delay_prin,
									logical	option(nullable)	ois_endog_df,
									logical option(nullable)	ois_approx_calc,									
									//flt	flat												
									number option(nullable)		flt_cpn_freq_n,
									day_count_method  option(nullable) flt_day_count,
									interest_rule option(nullable) 	,
									ir_index option(nullable)	flt_ir_index,
									number option(nullable) 	flt_curr_fix );

		void 		__create_swap(	disc_func option(nullable) 	disc_func,
									disc_func option(nullable) 	flt_fwd_disc_func,
									fwd_func option(nullable) 	flt_fwd_func,
									logical option(nullable) 	flt_allow_extrap,
									disc_func option(nullable) 	ois_fwd_disc_func,//sprd
									fwd_func option(nullable) 	ois_fwd_func,//sprd
									
									out swap_fixois 			swap_fixois,
									out swap_fixflt 			swap_fixflt );
		
		swap_fltois __create_swap(	disc_func option(nullable) 	disc_func,
									disc_func option(nullable) 	flt_fwd_disc_func,
									fwd_func option(nullable) 	flt_fwd_func,
									logical option(nullable) 	flt_allow_extrap,
									disc_func option(nullable) 	ois_fwd_disc_func,
									fwd_func option(nullable) 	ois_fwd_func);
		
	public:
		void 		set_plain(	string 						name,							  
								date option(nullable) 		trade,
								date option(nullable) 		settle,
								string option(nullable) 	spot_settle_code,
								date option(nullable),
								string option(nullable) 	fwd_start_code,
								date option(nullable) 		mat,
								string option(nullable) 	mat_code,
								logical,
								bd_convention option(nullable) 	pmt_bus_day,
								calendar option(nullable)	pmt_cal,
								logical	option(nullable) 	end_of_month,

								string	option(nullable) 	ccy,
								integer 					imp_fix_rate_dec,
								number option(nullable) 	pv01_not_unit,
								number	option(nullable) 	notional,
								number	option(nullable) 	pv01,
								//fixois=spread
								number option(nullable)		fixo_cpn_freq,
								day_count_method option(nullable) fixo_day_count,
								interest_rule option(nullable) 	fixo_ir_rule,
								
								number	option(nullable)	fixo_spread,
								//fixflt
								number option(nullable)		fixf_cpn_freq,
								day_count_method option(nullable) fixf_day_count,
								interest_rule option(nullable) 	fixf_ir_rule,
								number	option(nullable)	fixf_cpn_rate_flat,
								//ois sprd												
								number option(nullable)		ois_cpn_freq,
								day_count_method  option(nullable)	ois_day_count,
								interest_rule option(nullable) 	,
								ir_index option(nullable)	ois_ir_index,
								number  option(nullable)	ois_pmt_delay,
								number  option(nullable)	ois_pmt_delay_prin,
								logical	option(nullable)	ois_endog_df,
								logical option(nullable)	ois_approx_calc,
								
								//flt sprd													
								number option(nullable)		flt_cpn_freq,
								day_count_method  option(nullable)	flt_day_count,
								interest_rule option(nullable) 	,
								ir_index option(nullable)	flt_ir_index,
								number option(nullable) 	flt_curr_fix);
		
		void 		set_plain(	string 						name,							  
								date option(nullable) 		trade,
								date option(nullable) 		settle,								
								date option(nullable),
								string option(nullable) 	fwd_start_code,
								date option(nullable) 		mat,
								string option(nullable) 	mat_code,
								logical,
								integer 					imp_fix_rate_dec,
								number option(nullable) 	pv01_not_unit,
								number	option(nullable) 	notional,
								number	option(nullable) 	pv01,
								//fixois
								
								number	option(nullable)	fixo_spread,
								number	option(nullable)	fixf_cpn_rate_flat,
								//flt													
								number option(nullable) 	flt_curr_fix);
				
		
		void		set_plain(	string,
								date option(nullable) 			trade_date,
								date option(nullable) 			settle_date,
								string option(nullable) 		spot_settle_code,
								date option(nullable) 			start_date,
								string option(nullable) 		fwd_start_code,
								date option(nullable)			maturity,
								string option(nullable) 		maturity_code,
								logical,
								bd_convention option(nullable)	pmt_bus_day,
								calendar option(nullable)		pmt_cal,
								logical	 option(nullable)		end_of_month,
								//notional_exchg_style option(nullable) notional_exchg,											
								string	 						ccy,
								integer 						imp_fix_rate_dec,
								number option(nullable) 		pv01_not_unit,
								number	option(nullable) 		notional,
								number	option(nullable) 		fix_pv01,
								//fixois								
								number	option(nullable)		fixo_cpn_freq_n,
								day_count_method option(nullable) fixo_day_count,
								interest_rule option(nullable) 	fixo_ir_rule ,								
								number	option(nullable)		fixo_spread,
								stub_type option(nullable)		fixo_stub_type,
								date option(nullable)  			fixo_eff_date,
								date option(nullable)  			fixo_first_cpn_date,
								date option(nullable)  			fixo_last_reg_date,
								//fixflt								
								number	option(nullable)		fixf_cpn_freq_n,
								day_count_method option(nullable) fixf_day_count,
								interest_rule option(nullable) 	fixf_ir_rule ,
								number	option(nullable)		fixf_cpn_rate_flat,
								stub_type option(nullable)		fixf_stub_type,
								date option(nullable)  			fixf_eff_date,
								date option(nullable)  			fixf_first_cpn_date,
								date option(nullable)  			fixf_last_reg_date,	
								//ois							
								number option(nullable)	 		ois_cpn_freq_n,
								day_count_method  option(nullable) ois_day_count,
								interest_rule option(nullable) 	ois_ir_rule ,
								ir_index option(nullable)		ois_ir_index,
								number  option(nullable)		ois_pmt_delay,
								number  option(nullable)		ois_pmt_delay_prin,
								logical	option(nullable)		ois_endog_df,
								logical option(nullable)		ois_approx_calc,
								stub_type option(nullable)		ois_stub_type,
								date option(nullable)  			ois_eff_date,
								date option(nullable)  			ois_first_cpn_date,
								date option(nullable)  			ois_last_reg_date,															
								vector(date) option(nullable) 	ois_fixing_dates ,	
								vector(number) option(nullable) ois_fixing_rates,
								number option(nullable) 		ois_fix_proxy ,
								logical option(nullable) 		ois_allow_fwd_fix,
								//flt							
								number option(nullable)	 		flt_cpn_freq_n,
								day_count_method  option(nullable) flt_day_count,
								interest_rule option(nullable) 	flt_ir_rule ,
								ir_index option(nullable)		flt_ir_index,
								stub_type option(nullable)		flt_stub_type,
								date option(nullable)  			flt_eff_date,
								date option(nullable)  			flt_first_cpn_date,
								date option(nullable)  			flt_last_reg_date,							
								number option(nullable) 		flt_curr_fix,
								vector(date) option(nullable) 	flt_fixing_dates ,	
								vector(number) option(nullable) flt_fixing_rates,
								number option(nullable) 		flt_fix_proxy ,
								logical option(nullable) 		flt_allow_fwd_fix);

		void		set_plain(	string,
								date option(nullable) 			trade_date,
								date option(nullable) 			settle_date,
								
								date option(nullable) 			start_date,
								string option(nullable) 		fwd_start_code,
								date option(nullable)			maturity,
								string option(nullable) 		maturity_code,
								logical,
								integer 						imp_fix_rate_dec,
								number option(nullable) 		pv01_not_unit,
								number	option(nullable) 		notional,
								number	option(nullable) 		fix_pv01,
								//fixois								
								
								number	option(nullable)		fixo_spread,
								stub_type option(nullable)		fixo_stub_type,
								date option(nullable)  			fixo_eff_date,
								date option(nullable)  			fixo_first_cpn_date,
								date option(nullable)  			fixo_last_reg_date,
								//fixflt
								number	option(nullable)		fixf_cpn_rate_flat,
								stub_type option(nullable)		fixf_stub_type,
								date option(nullable)  			fixf_eff_date,
								date option(nullable)  			fixf_first_cpn_date,
								date option(nullable)  			fixf_last_reg_date,
								//ois							
								stub_type option(nullable)		ois_stub_type,
								date option(nullable)  			ois_eff_date,
								date option(nullable)  			ois_first_cpn_date,
								date option(nullable)  			ois_last_reg_date,															
								vector(date) option(nullable) 	ois_fixing_dates ,	
								vector(number) option(nullable) ois_fixing_rates,
								number option(nullable) 		ois_fix_proxy ,
								logical option(nullable) 		ois_allow_fwd_fix,
								//flt						
								stub_type option(nullable)		flt_stub_type,
								date option(nullable)  			flt_eff_date,
								date option(nullable)  			flt_first_cpn_date,
								date option(nullable)  			flt_last_reg_date,							
								number option(nullable) 		flt_curr_fix,
								vector(date) option(nullable) 	flt_fixing_dates ,	
								vector(number) option(nullable) flt_fixing_rates,
								number option(nullable) 		flt_fix_proxy ,
								logical option(nullable) 		flt_allow_fwd_fix);
	
		void 		create_swap(	disc_func option(nullable) 	disc_func,
									disc_func option(nullable) 	flt_fwd_disc_func,
									fwd_func option(nullable) 	flt_fwd_func,
									
									disc_func option(nullable) 	ois_fwd_disc_func,
									fwd_func option(nullable) 	ois_fwd_func,
									logical 					sync_endog_ok,
									out swap_fixois 			sw_fixois,
									out swap_fixflt 			sw_fixflt,
									logical option(nullable) 	flt_allow_extrap=null);
		
		/*void 		create_swap(	disc_func option(nullable) 	disc_func,
									fwd_func option(nullable) 	flt1_fwd_func,
									fwd_func option(nullable) 	flt2_fwd_func,
									out swap_fixois 			swap_fixois,
									out swap_fixflt 			swap_fixflt);*/

		swap_fltois create_swap(disc_func option(nullable) 	disc_func,
								disc_func option(nullable) 	flt_fwd_disc_func,
								fwd_func option(nullable) 	flt_fwd_func,
								
								disc_func option(nullable) 	ois_fwd_disc_func,
								fwd_func option(nullable) 	ois_fwd_func,
								logical 					sync_endog_ok,
								logical option(nullable) 	flt_allow_extrap=null);

		/*swap_fltois create_swap(disc_func option(nullable) 	disc_func,
								disc_func option(nullable) 	flt_sprd_fwd_func,
								disc_func option(nullable) 	flt_flat_fwd_func );*/
		
		fix_parm 	fip1_;//fixois
		fix_parm 	fip2_;//fixflt
		ois_parm	op_;
		flt_parm	fp_;

		number		fixois_spread_;

	};

	/*-----------------------------------------------------------------------
	  constructor
	  ----------------------------------------------------------------------*/
	fltois2s_parm.fltois2s_parm()
	{
		fip1_ 			= new fix_parm();
		fip2_ 			= new fix_parm();
		fp_ 			= new flt_parm();
		op_ 			= new ois_parm();
		fixois_spread_	= null;
	
	}
	/*-----------------------------------------------------------------------
	  type
	  ----------------------------------------------------------------------*/
	instr_type fltois2s_parm.type() { return instr_type.SWAP_FLTOIS2S ;}
	/*-----------------------------------------------------------------------
	  fix_leg_parm / flt_leg_parm
	  ----------------------------------------------------------------------*/
	fix_parm fltois2s_parm.fix_leg_parm_sprd() { return fip1_;}
	fix_parm fltois2s_parm.fix_leg_parm_flat() { return fip2_;}
	flt_parm fltois2s_parm.flt_leg_parm() { return fp_;}
	ois_parm fltois2s_parm.ois_leg_parm() { return op_;}

	/*-----------------------------------------------------------------------
	  check
	  ----------------------------------------------------------------------*/
	void fltois2s_parm.check()
	{
		if(is_aged_swap()){
			QL_REQUIRE(!null(fip2_.fix_coupon_rate_),"fix coupon rate for flat leg required for aged swap");
			if(null(fip1_.fix_coupon_rate_))
				QL_REQUIRE(!null(fixois_spread_),"fix coupon rate for spread leg or spread required for aged swap");
			if(null(fixois_spread_))
				QL_REQUIRE(!null(fip1_.fix_coupon_rate_),"fix coupon rate for flat leg or spread required for aged swap");

			QL_REQUIRE(!null(fip1_.fix_notional_),"notional is required for aged swap");
		}
	}
	/*-----------------------------------------------------------------------
	  ccy_helper
	  ----------------------------------------------------------------------*/
	void fltois2s_parm.fx_notional_helper()
	{
		//never cross curr
		fip2_.fix_notional_		= fip1_.fix_notional_;
		fp_.flt_notional_		= fip1_.fix_notional_;		
		op_.ois_notional_		= fip1_.fix_notional_;
		
		fip1_.fix_fx_mult_		= 1;
		fip2_.fix_fx_mult_		= 1;
		fp_.flt_fx_mult_		= 1;
		op_.ois_fx_mult_		= 1;
	}
	/*-----------------------------------------------------------------------
	  start_date_helper  //FIX_ME for the fact that we have 2 flt legs
	  ----------------------------------------------------------------------*/	
	void fltois2s_parm.start_date_helper()
	{
		legleg_parm.start_date_helper(fip1_.fix_eff_date_, fp_.flt_eff_date_, fp_.flt_pmt_calendar_);
	}
	/*-----------------------------------------------------------------------
	  set_notional
	  ----------------------------------------------------------------------*/
	void fltois2s_parm.set_notional(number not)
	{
		fip1_.fix_notional_ = not;
		leg_pv01_ 			= null;
		fx_notional_helper();
	}
	/*-----------------------------------------------------------------------
	  set_notional
	  ----------------------------------------------------------------------*/
	void fltois2s_parm.set_pv01(number pv01)
	{
		fip1_.fix_notional_ = 1000000;
		leg_pv01_ 			= pv01;
		fx_notional_helper();
	}
	
	/*-----------------------------------------------------------------------
	  init_basic_static
	  ----------------------------------------------------------------------*/
	void fltois2s_parm.init_static(	string option(nullable) spot_code,
									bd_convention  		pmt_bus_day,
									calendar 			pmt_cal,
									logical				end_of_month,
									notional_exchg_style option(nullable) ne,
									string				ccy,
									//fixois											
									integer 			fix_sprd_cpn_freq,
									day_count_method  	fix_sprd_day_count,
									interest_rule		fix_sprd_ir_rule,
									//fixflt											
									integer 			fix_flat_cpn_freq,
									day_count_method  	fix_flat_day_count,
									interest_rule		fix_flat_ir_rule,											
									//ois											
									integer 			ois_cpn_freq,										
									day_count_method 	ois_day_count,
									interest_rule		ois_ir_rule,
									ir_index 			ois_ir_index,
									number				ois_pmt_delay,									
									logical				ois_endog_df,
									logical 			ois_approx_calc,
									//flt											
									integer 			flt_cpn_freq,											
									day_count_method 	flt_day_count,
									interest_rule		flt_ir_rule,
									ir_index 			flt_ir_index)
	{		
		//----fltflt2s_parm-----		
		is_ccy_ 		= false;	
		ne_ 			= ne;
		if(null(ne_))
			ne_ = is_ccy_ ? NE_BOTH : NE_NONE;

		spot_code_ 		= null(spot_code) ? "BD2" : spot_code;
		trade_date_ 	= null;
		maturity_ 		= null;
		maturity_code_ 	= null;
		mat_code_ 		= null;
		fwd_start_code_ = null;
		start_date_ 	= null;
		settle_date_	= null;
		//cpn_roll_day_ 	= 0;

		//----fix_parm1(fixois)--------
		fix_roll_method	roll 		= fix_roll_method.FIR_STRAIGHT;
		logical const_cpn 			= false;		
		..fix_comp_freq comp_freq 	= fix_comp_freq.FCF_AS_FREQ;
		logical compound_to_mat		= false;
		
		fip1_.init_static(pmt_bus_day, pmt_cal,end_of_month,ccy,
							fix_sprd_cpn_freq, fix_sprd_day_count,fix_sprd_ir_rule,0,0,0,0,null,
							roll, const_cpn, comp_freq,compound_to_mat);
		//----fix_parm2 (fixflt)--------
		fip2_.init_static(pmt_bus_day, pmt_cal,end_of_month,ccy,
							fix_flat_cpn_freq, fix_flat_day_count,fix_flat_ir_rule,0,0,0,0,null,
							roll, const_cpn, comp_freq,compound_to_mat);
		
		//---ois---
		flt_comp_avg_type ois_cat 		= flt_comp_avg_type.CA_COMP ;
		flt_sprd_comp_method ois_scm 	= flt_sprd_comp_method.SC_FLAT ;
		flt_avg_method ois_am 			= flt_avg_method.AVG_UNWEIGHTED ;
		rfr_arrears_type  at 			= rfr_arrears_type.PLAIN;
		number ad 						= 0;
		flt_roll_method ois_roll 		= flt_roll_method.FLR_STRAIGHT; 
		op_.init_static(pmt_bus_day,pmt_cal,end_of_month,ccy,
						ois_cpn_freq, ois_day_count,ois_ir_rule,ois_ir_index,
						ois_cat, ois_scm, ois_am,ois_pmt_delay,ois_pmt_delay,ois_pmt_delay,ois_pmt_delay,
						at, ad, ois_endog_df, ois_approx_calc,null, ois_roll);

		//---flt---
		flt_comp_avg_type cat 		= flt_comp_avg_type.CA_COMP;//null(flt_comp_avg_t) ? flt_comp_avg_type.CA_COMP : flt_comp_avg_t;
		flt_sprd_comp_method scm 	= flt_sprd_comp_method.SC_FLAT;//null(flt_sprd_comp_m) ? flt_sprd_comp_method.SC_FLAT : flt_sprd_comp_m;
		flt_avg_method am 			= flt_avg_method.AVG_UNWEIGHTED;//null(flt_avg_m) ? flt_avg_method.AVG_UNWEIGHTED : flt_avg_m;
		integer flt_reset_freq 		= flt_cpn_freq;
		..flt_roll_method flt_roll 	= ..flt_roll_method.FLR_STRAIGHT;
		logical flt_compound_to_mat = false;
		fp_.init_static(pmt_bus_day,pmt_cal,end_of_month,ccy,
						flt_cpn_freq, flt_reset_freq,flt_day_count,flt_ir_rule,flt_ir_index,
						0,0,0,0,cat, scm, am,null,flt_roll,flt_compound_to_mat,null);
		
	}
	/*-----------------------------------------------------------------------
	  init_basic_static
	  ----------------------------------------------------------------------*/
	void fltois2s_parm.init_static(instr_def  def,
								   string option(nullable) spot_code)
	{
		QL_REQUIRE(CORE_INT.check_instr_def(def),"invalid instr_def");
		QL_FAIL_COND(!def.is_swap_fltois2s(), "instr_def not a float-ois (2 swaps) swap", E_INIT);

		//----fltflt2s_parm-----		
		is_ccy_ 		= def.is_ccy_swap();
		QL_REQUIRE(!is_ccy_,"cross currency not supported for float-ois (2 swaps)");
		error_info ees 	= new  error_info(true,false);
		ne_ 			= def.swap_not_exchange(ees);
		if(null(ne_))
			ne_ 	= is_ccy_ ? NE_BOTH : NE_NONE;

		spot_code_ 		= null(spot_code) ? "BD2" : spot_code;
		trade_date_ 	= null;
		maturity_ 		= null;
		maturity_code_ 	= def.maturity_code(ees);
		mat_code_ 		= null;
		fwd_start_code_ = null;
		start_date_ 	= null;
		settle_date_	= null;
		//cpn_roll_day_ 	= 0;

		//leg1 = sprd = ois
		fip1_.init_static(def);
			
		//leg2 = flat = flt
		fip2_.init_static(def);
		
		//flt
		fp_.init_basic_static_leg1(def);

		//ois
		op_.init_basic_static_leg2(def);

		//fixleg overrides
		error_info ee = new error_info(true,true);
		integer fixleg_flat_cpn_freq,fltleg_flat_cpn_freq,fixleg_sprd_cpn_freq,oisleg_sprd_cpn_freq;
		def.swap_cpn_freq_fltois2s(	fixleg_flat_cpn_freq, fltleg_flat_cpn_freq, fixleg_sprd_cpn_freq, oisleg_sprd_cpn_freq,ee);

		day_count_method fixleg_flat_dc, fltleg_flat_dc, fixleg_sprd_dc, oisleg_sprd_dc;
		def.swap_dc_method_fltois2s(fixleg_flat_dc,fltleg_flat_dc,fixleg_sprd_dc,oisleg_sprd_dc,ee);

		//leg1 = sprd overrides (because the def has only one fixedleg and for a fltois2s the fixed legs can be different)
		fip1_.fix_dc_ 				= fixleg_sprd_dc;
		fip1_.fix_cpn_freq_ 		= coupon_freq_from_int(fixleg_sprd_cpn_freq);	
		fip1_.fix_pmt_delay_ 		= op_.ois_pmt_delay_;
		fip1_.fix_pmt_delay_prin_ 	= op_.ois_pmt_delay_prin_;
		fip1_.fix_ir_rule_ 			= op_.ois_ir_rule_;
		fip1_.fix_pmt_bus_day_ 		= op_.ois_pmt_bus_day_;
		fip1_.fix_end_of_month_ 	= op_.ois_end_of_month_ ;

		//leg2 = flat overrides
		fip2_.fix_dc_ 				= fixleg_flat_dc;
		fip2_.fix_cpn_freq_ 		= coupon_freq_from_int(fixleg_flat_cpn_freq);
		fip2_.fix_pmt_delay_ 		= fp_.flt_pmt_delay_;
		fip2_.fix_pmt_delay_prin_ 	= fp_.flt_pmt_delay_prin_;
		fip2_.fix_ir_rule_ 			= fp_.flt_ir_rule_;
		fip2_.fix_pmt_bus_day_ 		= fp_.flt_pmt_bus_day_;
		fip2_.fix_end_of_month_ 	= fp_.flt_end_of_month_ ; 
	}
	/*-----------------------------------------------------------------------
	  init_basic_static
	  Note: a possible maturity code in the template is never "carried over" to the swap
	  ----------------------------------------------------------------------*/
	void fltois2s_parm.init_static(INSTR_TMPL.swap_fltois2s_def_tmpl tmpl )
	{
		//----fixflt_parm-----		
		is_ccy_ 		= false;		
		ne_ 			= tmpl.not_exchange();
		if(null(ne_))
			ne_ 	= is_ccy_ ? NE_BOTH : NE_NONE;
		
		spot_code_ 		= tmpl.spot_settle_code();
		trade_date_ 	= null;
		maturity_ 		= null;
		maturity_code_ 	= tmpl.maturity_code();
		mat_code_ 		= null;
		fwd_start_code_ = null;//tmpl.fwd_start_code();
		start_date_ 	= null;
		settle_date_	= null;
		//cpn_roll_day_ 	= 0;
		
		//fix1, sprd, ois
		fix_roll_method	roll 		= fix_roll_method.FIR_STRAIGHT;
		logical const_cpn 			= false;		
		..fix_comp_freq comp_freq 	= fix_comp_freq.FCF_AS_FREQ;
		logical compound_to_mat		= false;
		
		fip1_.init_static(	tmpl.fixo_bd_convention(), tmpl.calendar(),tmpl.fixo_eom(),tmpl.currency(), 
							tmpl.fixo_cpn_freq(), tmpl.fixo_day_count_method(),tmpl.fixo_ir_rule(),
							tmpl.ois_payment_delay(),tmpl.ois_payment_delay(),tmpl.ois_payment_delay_prin(),
							tmpl.ois_payment_delay_prin(),null,
							roll, const_cpn, comp_freq,compound_to_mat);

		//fix2, flat, flt
		fip2_.init_static(	tmpl.fixf_bd_convention(), tmpl.calendar(),tmpl.fixf_eom(),tmpl.currency(), 
							tmpl.fixf_cpn_freq(), tmpl.fixf_day_count_method(),tmpl.fixf_ir_rule(),
							tmpl.flt_payment_delay(),tmpl.flt_payment_delay(),tmpl.flt_payment_delay_prin(),
							tmpl.flt_payment_delay_prin(),null,
							roll, const_cpn, comp_freq,compound_to_mat);
	
		//----ois_parm--------
		flt_roll_method ois_roll = flt_roll_method.FLR_STRAIGHT; 
		op_.init_static(tmpl.ois_bd_convention(),tmpl.calendar(),tmpl.ois_eom(),tmpl.currency(),
								tmpl.ois_cpn_freq(),  tmpl.ois_day_count_method(),tmpl.ois_ir_rule(),tmpl.ois_ir_index(),
								tmpl.ois_comp_avg(), tmpl.ois_spread_comp_method(), tmpl.ois_avg_method(), tmpl.ois_payment_delay(),
								tmpl.ois_payment_delay(),tmpl.ois_payment_delay_prin(),tmpl.ois_payment_delay_prin(),
								tmpl.ois_arr_type(),tmpl.ois_arr_days(),tmpl.ois_endog_df(),tmpl.ois_approx_calc(),null, ois_roll);

		//----flt_parm--------
		//flt
		..flt_roll_method flt_roll 	= ..flt_roll_method.FLR_STRAIGHT;
		logical flt_compound_to_mat = false;
		integer flt2_r_freq 		= null(tmpl.flt_reset_freq()) ? tmpl.flt_cpn_freq() : integer(tmpl.flt_reset_freq());
		fp_.init_static(tmpl.flt_bd_convention(),tmpl.calendar(),tmpl.flt_eom(),tmpl.currency(),
						tmpl.flt_cpn_freq(), flt2_r_freq,
						tmpl.flt_day_count_method(),tmpl.flt_ir_rule(),tmpl.flt_ir_index(),
						tmpl.flt_payment_delay(),tmpl.flt_payment_delay(),tmpl.flt_payment_delay_prin(),tmpl.flt_payment_delay_prin(),
						tmpl.flt_comp_avg(),tmpl.flt_spread_comp_method(),tmpl.flt_avg_method(),null,
						flt_roll,flt_compound_to_mat,tmpl.flt_fwd_stub_rate_style());
		
	}
	/*-----------------------------------------------------------------------
	  set_plain_vanilla
	  ----------------------------------------------------------------------*/
	/*void fltois2s_parm.__set_plain_vanilla()
	{
		
		// ----fltflt2s_parm-------
		//will not set:
		//	is_ccy;
		//	ne;
		//	settle_code;			

		//	trade_date;
		//	maturity;
		//	maturity_code;
		//	mat_code;
		//	fwd_start_code;
		//	start_date;
		//	settle_date
		
		cpn_roll_day_ = 0;
		
		// ----fix_parm1-------
		fip1_.set_plain_vanilla();
		// ----fix_parm2-------
		fip2_.set_plain_vanilla();
		// ----ois parm-------
		logical fed_fund_style = false;
		op_.set_plain_vanilla(fed_fund_style);
		// ----flt parm-------
		fp_.set_plain_vanilla();

	}*/
	/*-----------------------------------------------------------------------
	  __set_spot_fwd  <protected>    internal
	  ----------------------------------------------------------------------*/
	void fltois2s_parm.__set_plain(	bd_convention option(nullable) 	pmt_bus_day,
									calendar option(nullable)	pmt_cal,
									logical	option(nullable) 	end_of_month,
									integer 					imp_fix_rate_dec,
									number option(nullable)		pv01_not_unit,
									string option(nullable)		ccy,
									number option(nullable)		notional,
									//fixois=spread
									number option(nullable)		fixo_cpn_freq_n,
									day_count_method option(nullable) fixo_day_count,
									interest_rule option(nullable) fixo_ir_rule	,									
									number	option(nullable)	fixo_spread,
									//fixflt=flat
									number option(nullable)		fixf_cpn_freq_n,
									day_count_method option(nullable) fixf_day_count,
									interest_rule option(nullable) fixf_ir_rule	,
									number	option(nullable)	fixf_cpn_rate_flat,
									//ois	sprd												
									number option(nullable)		ois_cpn_freq_n,
									day_count_method  option(nullable) ois_day_count,
									interest_rule option(nullable) ois_ir_rule	,
									ir_index option(nullable)	ois_ir_index,
									number  option(nullable)	ois_pmt_delay,
									number  option(nullable)	ois_pmt_delay_prin,
									logical	option(nullable)	ois_endog_df,
									logical option(nullable)	ois_approx_calc,								
									
									//flt	flat												
									number option(nullable)		flt_cpn_freq_n,
									day_count_method  option(nullable) flt_day_count,
									interest_rule option(nullable) 	flt_ir_rule,
									ir_index option(nullable)	flt_ir_index,
									number option(nullable) 	flt_curr_fix)
	{
		imp_calc_dec_  	= imp_fix_rate_dec;//rounding decimals of the implied cpn rate (on decimal value)
		pv01_not_unit_  = null(pv01_not_unit) ? -1: pv01_not_unit;//rounding unit for notional when implied from pv01
		
		fixois_spread_ = /*null(fix_spread) ? 0 :*/ fixo_spread;
		number r = null(fixf_cpn_rate_flat) || null(fixo_spread) ? null : fixf_cpn_rate_flat - fixois_spread_;
		
		fip1_.set_plain(pmt_bus_day, pmt_cal, end_of_month, ccy, fixo_cpn_freq_n, fixo_day_count, fixo_ir_rule,0,0,0,0,r,
						stub_type.SHORT_FIRST,null,null,null,notional,null);
		fip2_.set_plain(pmt_bus_day, pmt_cal, end_of_month, ccy, fixf_cpn_freq_n, fixf_day_count, fixf_ir_rule,0,0,0,0,fixf_cpn_rate_flat,
						stub_type.SHORT_FIRST,null,null,null,notional,null);
	
		number  ois_mat_pmt_delay 		= ois_pmt_delay;
		number  ois_mat_pmt_delay_prin	= ois_pmt_delay_prin;
		flt_comp_avg_type  ois_comp_avg_t 		= flt_comp_avg_type.CA_COMP;
		flt_sprd_comp_method  ois_sprd_comp_m 	= flt_sprd_comp_method.SC_SPRD_EXCL;
		flt_avg_method  ois_avg_m 				= flt_avg_method.AVG_WEIGHTED;
		rfr_arrears_type   ois_arr_type 		= rfr_arrears_type.PLAIN;
		number ois_arr_days 					= 0;

		op_.set_plain(pmt_bus_day, pmt_cal, end_of_month, ccy, ois_cpn_freq_n, ois_day_count, ois_ir_rule,ois_ir_index,0,
					  ois_comp_avg_t,ois_sprd_comp_m,ois_avg_m,ois_arr_type,ois_arr_days,
					  ois_pmt_delay,ois_mat_pmt_delay,ois_pmt_delay_prin,ois_mat_pmt_delay_prin,ois_endog_df,ois_approx_calc,
					  stub_type.SHORT_FIRST,null,null,null, notional,null,null,null,null,false);
		
		number flt_reset_freq_n = flt_cpn_freq_n;
		fp_.set_plain(pmt_bus_day, pmt_cal, end_of_month, ccy, flt_cpn_freq_n, flt_reset_freq_n,flt_day_count, flt_ir_rule,
					  flt_ir_index,0,0,0,0,null,0,stub_type.SHORT_FIRST,null,null,null, notional,null,flt_curr_fix,null,null,null,
					  false,null,null);
	}

	/*-----------------------------------------------------------------------
	  set_plain <ALL ARGS>
	  ----------------------------------------------------------------------*/
	void fltois2s_parm.set_plain(string 					name,								
								date option(nullable) 		trade_date,
								date option(nullable) 		settle_date,
								string option(nullable) 	spot_settle_code,
								date option(nullable) 		start_date,
								string option(nullable) 	fwd_start_code,
								date option(nullable) 		maturity,
								string option(nullable) 	maturity_code,
								logical						pay_sprd_leg,
								bd_convention option(nullable) 	pmt_bus_day,
								calendar option(nullable)	pmt_cal,
								logical	option(nullable) 	end_of_month,
								string	option(nullable) 	ccy,
								integer 					imp_fix_rate_dec,
								number option(nullable) 	pv01_not_unit,
								number	option(nullable) 	notional,
								number	option(nullable) 	fix_pv01,								 
								//fixois=spread
								number option(nullable)		fixo_cpn_freq,
								day_count_method option(nullable) fixo_day_count,
								interest_rule option(nullable) 	fixo_ir_rule,
								
								number	option(nullable)	fixo_spread,
								//fixflt
								number option(nullable)		fixf_cpn_freq,
								day_count_method option(nullable) fixf_day_count,
								interest_rule option(nullable) 	fixf_ir_rule,
								number	option(nullable)	fixf_cpn_rate_flat,
								//ois sprd												
								number option(nullable)		ois_cpn_freq,
								day_count_method  option(nullable)	ois_day_count,
								interest_rule option(nullable) ois_ir_rule,
								ir_index option(nullable)	ois_ir_index,
								number  option(nullable)	ois_pmt_delay,
								number  option(nullable)	ois_pmt_delay_prin,
								logical	option(nullable)	ois_endog_df,
								logical option(nullable)	ois_approx_calc,
							
								//flt sprd													
								number option(nullable)		flt_cpn_freq,
								day_count_method  option(nullable)	flt_day_count,
								interest_rule option(nullable) 	flt_ir_rule,
								ir_index option(nullable)	flt_ir_index,
								number option(nullable) 	flt_curr_fix)
	{
		if(null(notional))
			QL_REQUIRE(!null(fix_pv01),"one of notional and pv01 must be input");
		else if(null(fix_pv01))
			QL_REQUIRE(!null(notional),"one of notional and pv01 must be input");
		else if(!null(notional) && !null(fix_pv01))
			QL_FAIL("ambigious input of notional and pv01");
		
		this.__set_plain(pmt_bus_day,pmt_cal,end_of_month,imp_fix_rate_dec,pv01_not_unit,ccy,notional,
						//fixois=spread
						fixo_cpn_freq,fixo_day_count,fixo_ir_rule	,fixo_spread,
						//fixflt=flat
						fixf_cpn_freq,fixf_day_count,fixf_ir_rule	,fixf_cpn_rate_flat,
						//ois	sprd												
						ois_cpn_freq, ois_day_count,ois_ir_rule,ois_ir_index,ois_pmt_delay,
						ois_pmt_delay_prin,ois_endog_df,ois_approx_calc,								
						//flt	flat												
						flt_cpn_freq,flt_day_count,	flt_ir_rule,flt_ir_index,flt_curr_fix);

		//-----common--------
		name_			= name;
		pay_leg1_		= pay_sprd_leg;
		is_ccy_ 		= false;
		if(!null(spot_settle_code))
			spot_code_ 	= spot_settle_code;
		trade_date_ 	= trade_date;
		fwd_start_code_ = fwd_start_code;
		start_date_ 	= start_date;
		maturity_ 		= maturity;
		if(!null(maturity_code))
			maturity_code_ 	= maturity_code;
		settle_date_	= settle_date;
		//cpn_roll_day_ 	= 0;

		this.start_date_helper();
		this.maturity_helper(fip1_);
		this.check();
		//if single ccy set_pv01/set_notional will also set the other notional as well as both fxrates to 1
		if(null(notional))
			this.set_pv01(fix_pv01);
		else
			this.set_notional(notional);
		ne_ = notional_exchg_style.NE_NONE;
		is_inited_ = true;
	}

	/*-----------------------------------------------------------------------
	  set_plain 
	  ----------------------------------------------------------------------*/
	void fltois2s_parm.set_plain(//common
								string 						name,								
								date option(nullable) 		trade_date,
								date option(nullable) 		settle_date,
								
								date option(nullable) 		start_date,
								string option(nullable) 	fwd_start_code,
								date option(nullable) 		maturity,
								string option(nullable) 	maturity_code,
								logical						pay_sprd_leg,
								integer 					imp_fix_rate_dec,
								number option(nullable) 	pv01_not_unit,
								number	option(nullable) 	notional,
								number	option(nullable) 	fix_pv01,
								//fixois								
								number	option(nullable)	fixo_spread,
								number	option(nullable)	fixf_cpn_rate_flat,
								//flt													
								number option(nullable) 	flt_curr_fix)									
	{
		QL_FAIL_COND(null(is_ccy_),"fltois2s_parm is not initalized (init_static() must be run) ");
		QL_REQUIRE(!is_ccy_,"function not applicable to cross currency swaps");
		
		if(null(notional))
			QL_REQUIRE(!null(fix_pv01),"one of notional and pv01 must be input");
		else if(null(fix_pv01))
			QL_REQUIRE(!null(notional),"one of notional and pv01 must be input");
		else if(!null(notional) && !null(fix_pv01))
			QL_FAIL("ambigious input of notional and pv01");			

		this.__set_plain(null,null,null,imp_fix_rate_dec,pv01_not_unit,null,notional,
						//fixois=spread
						null,null,null,fixo_spread,
						//fixflt=flat
						null,null,null,fixf_cpn_rate_flat,
						//ois	sprd												
						null, null,null,null,null, null,null,null,								
						//flt	flat												
						null,null,	null,null,flt_curr_fix);
		

		//-----common--------
		name_			= name;
		pay_leg1_		= pay_sprd_leg;
		trade_date_ 	= trade_date;
		fwd_start_code_ = fwd_start_code;
		start_date_ 	= start_date;
		maturity_ 		= maturity;
		if(!null(maturity_code))
			maturity_code_ 	= maturity_code;
		settle_date_	= settle_date;
		//cpn_roll_day_ 	= 0;

		this.start_date_helper();
		this.maturity_helper(fip1_);
		this.check();
		//if single ccy set_pv01/set_notional will also set the other notional as well as both fxrates to 1
		if(null(notional))
			this.set_pv01(fix_pv01);
		else
			this.set_notional(notional);
		
		is_inited_ = true;
	}
	
	/*-----------------------------------------------------------------------
	  set_plain <ALL ARGS>
	  ----------------------------------------------------------------------*/									
	void fltois2s_parm.set_plain(string 						name,								
								date option(nullable) 			trade_date,
								date option(nullable) 			settle_date,
								string option(nullable) 		spot_settle_code,
								date option(nullable) 			start_date,
								 string option(nullable) 		fwd_start_code,
								date option(nullable)			maturity,
								string option(nullable) 		maturity_code,
								logical 						pay_sprd_leg,
								bd_convention option(nullable)	pmt_bus_day,
								calendar option(nullable)		pmt_cal,
								logical	 option(nullable)		end_of_month,										
								string	 						ccy,
								integer 						imp_fix_rate_dec,
								number option(nullable) 		pv01_not_unit,
								number	option(nullable) 		notional,
								number	option(nullable) 		fix_pv01,
								//fixois								
								number	option(nullable)		fixo_cpn_freq_n,
								day_count_method option(nullable) fixo_day_count,
								interest_rule option(nullable) 	fixo_ir_rule ,								
								number	option(nullable)		fixo_spread,
								stub_type option(nullable)		fixo_stub_type,
								date option(nullable)  			fixo_eff_date,
								date option(nullable)  			fixo_first_cpn_date,
								date option(nullable)  			fixo_last_reg_date,
								 //fixflt								
								number	option(nullable)		fixf_cpn_freq_n,
								day_count_method option(nullable) fixf_day_count,
								interest_rule option(nullable) 	fixf_ir_rule ,
								number	option(nullable)		fixf_cpn_rate_flat,
								stub_type option(nullable)		fixf_stub_type,
								date option(nullable)  			fixf_eff_date,
								date option(nullable)  			fixf_first_cpn_date,
								date option(nullable)  			fixf_last_reg_date,								 
								//ois							
								number option(nullable)	 		ois_cpn_freq_n,
								day_count_method  option(nullable) ois_day_count,
								interest_rule option(nullable) 	ois_ir_rule ,
								ir_index option(nullable)		ois_ir_index,
								number  option(nullable)		ois_pmt_delay,
								number  option(nullable)		ois_pmt_delay_prin,
								logical	option(nullable)		ois_endog_df,
								logical option(nullable)		ois_approx_calc,
								stub_type option(nullable)		ois_stub_type,
								date option(nullable)  			ois_eff_date,
								date option(nullable)  			ois_first_cpn_date,
								date option(nullable)  			ois_last_reg_date,															
								vector(date) option(nullable) 	ois_fixing_dates ,	
								vector(number) option(nullable) ois_fixing_rates,
								number option(nullable) 		ois_fix_proxy ,
								logical option(nullable) 		ois_allow_fwd_fix,
								//flt							
								number option(nullable)	 		flt_cpn_freq_n,
								day_count_method  option(nullable) flt_day_count,
								interest_rule option(nullable) 	flt_ir_rule ,
								ir_index option(nullable)		flt_ir_index,
								stub_type option(nullable)		flt_stub_type,
								date option(nullable)  			flt_eff_date,
								date option(nullable)  			flt_first_cpn_date,
								date option(nullable)  			flt_last_reg_date,							
								number option(nullable) 		flt_curr_fix,
								vector(date) option(nullable) 	flt_fixing_dates ,	
								vector(number) option(nullable) flt_fixing_rates,
								number option(nullable) 		flt_fix_proxy ,
								logical option(nullable) 		flt_allow_fwd_fix)
	{
		if(null(notional))
			QL_REQUIRE(!null(fix_pv01),"one of notional and fix_pv01 must be input");
		else if(null(fix_pv01))
			QL_REQUIRE(!null(notional),"one of notional and fix_pv01 must be input");
		else if(!null(notional) && !null(fix_pv01))
			QL_FAIL("ambigious input of notional and fix_pv01");

		fixois_spread_ = /*null(fix_spread) ? 0 :*/ fixo_spread;
		number r = null(fixf_cpn_rate_flat)  || null(fixo_spread) ? null : fixf_cpn_rate_flat - fixois_spread_;

		//----fix_parm1-----
		fip1_.set_plain(pmt_bus_day, pmt_cal, end_of_month, ccy, fixo_cpn_freq_n, fixo_day_count, fixo_ir_rule ,0,0,0,0,
						r, fixo_stub_type,fixo_eff_date, fixo_first_cpn_date, fixo_last_reg_date, notional, 1);
		
		//----fix_parm2-----
		fip2_.set_plain(pmt_bus_day, pmt_cal, end_of_month, ccy, fixf_cpn_freq_n, fixf_day_count, fixf_ir_rule ,0,0,0,0,
						fixf_cpn_rate_flat, fixf_stub_type,fixf_eff_date, fixf_first_cpn_date, fixf_last_reg_date, notional, 1);		
		
		//----ois_parm--------
		number  ois_mat_pmt_delay 		= ois_pmt_delay;
		number  ois_mat_pmt_delay_prin	= ois_pmt_delay_prin;
		flt_comp_avg_type  ois_comp_avg_t 		= flt_comp_avg_type.CA_COMP;
		flt_sprd_comp_method  ois_sprd_comp_m 	= flt_sprd_comp_method.SC_SPRD_EXCL;
		flt_avg_method  ois_avg_m 				= flt_avg_method.AVG_WEIGHTED;
		rfr_arrears_type   ois_arr_type 		= rfr_arrears_type.PLAIN;
		number ois_arr_days 					= 0;
		op_.set_plain(pmt_bus_day, pmt_cal, end_of_month, ccy, ois_cpn_freq_n, ois_day_count, ois_ir_rule,ois_ir_index,0,
					   ois_comp_avg_t,ois_sprd_comp_m,ois_avg_m,ois_arr_type,ois_arr_days,
					  ois_pmt_delay,ois_mat_pmt_delay,ois_pmt_delay_prin,ois_mat_pmt_delay_prin,ois_endog_df,ois_approx_calc,
					  stub_type.SHORT_FIRST,
					  null,null,null,notional,null,null,null,null,false);
		
		//----flt_parm--------
		number flt_reset_freq_n = flt_cpn_freq_n;
		fp_.set_plain(	pmt_bus_day, pmt_cal, end_of_month, ccy, flt_cpn_freq_n, flt_reset_freq_n,flt_day_count,
						flt_ir_rule , flt_ir_index, 0,0,0,0,null,0, flt_stub_type,flt_eff_date, flt_first_cpn_date,
						flt_last_reg_date, notional, 1, flt_curr_fix,
						flt_fixing_dates ,flt_fixing_rates,flt_fix_proxy ,flt_allow_fwd_fix,null,null);
		//---common---
		name_			= name;
		imp_calc_dec_  	= imp_fix_rate_dec;//rounding decimals of the implied cpn rate (on decimal value)
		pv01_not_unit_  = null(pv01_not_unit) ? -1: pv01_not_unit;//rounding unit for notional when implied from pv01
		pay_leg1_		= pay_sprd_leg;
		is_ccy_ 		= false;
				
		if(null(ne_))
			ne_ = notional_exchg_style.NE_NONE;
		

		if(!null(spot_settle_code))
			spot_code_ 	= spot_settle_code;
		trade_date_ 	= trade_date;
		fwd_start_code_ = fwd_start_code;
		start_date_ 	= start_date;
		maturity_ 		= maturity;
		if(!null(maturity_code))
			maturity_code_ 	= maturity_code;
		settle_date_	= settle_date;
		//cpn_roll_day_ 	= 0;

		this.start_date_helper();
		this.maturity_helper(fip1_);
		this.schedule_helper(fip1_);
		this.schedule_helper(fp_);
		this.schedule_helper(op_);
		this.check();
		
		if(null(notional))
			this.set_pv01(fix_pv01);
		else
			this.set_notional(notional);
		is_inited_ = true;
	}
	/*-----------------------------------------------------------------------
	  set_plain
	  ----------------------------------------------------------------------*/
	void fltois2s_parm.set_plain(string name,								
								date option(nullable) 			trade_date,
								date option(nullable) 			settle_date,
								
								date option(nullable) 			start_date,
								string option(nullable) 		fwd_start_code,
								date option(nullable)			maturity,
								string option(nullable) 		maturity_code,
								logical 						pay_sprd_leg, 
								integer 						imp_fix_rate_dec,
								number option(nullable) 		pv01_not_unit,
								number	option(nullable) 		notional,
								number	option(nullable) 		fix_pv01,
								//fixois																
								number	option(nullable)		fixo_spread,
								stub_type option(nullable)		fixo_stub_type,
								date option(nullable)  			fixo_eff_date,
								date option(nullable)  			fixo_first_cpn_date,
								date option(nullable)  			fixo_last_reg_date,
								//fixflt
								number	option(nullable)		fixf_cpn_rate_flat,
								stub_type option(nullable)		fixf_stub_type,
								date option(nullable)  			fixf_eff_date,
								date option(nullable)  			fixf_first_cpn_date,
								date option(nullable)  			fixf_last_reg_date,
								//ois							
								stub_type option(nullable)		ois_stub_type,
								date option(nullable)  			ois_eff_date,
								date option(nullable)  			ois_first_cpn_date,
								date option(nullable)  			ois_last_reg_date,															
								vector(date) option(nullable) 	ois_fixing_dates ,	
								vector(number) option(nullable) ois_fixing_rates,
								number option(nullable) 		ois_fix_proxy ,
								logical option(nullable) 		ois_allow_fwd_fix,
								//flt						
								stub_type option(nullable)		flt_stub_type,
								date option(nullable)  			flt_eff_date,
								date option(nullable)  			flt_first_cpn_date,
								date option(nullable)  			flt_last_reg_date,							
								number option(nullable) 		flt_curr_fix,
								vector(date) option(nullable) 	flt_fixing_dates ,	
								vector(number) option(nullable) flt_fixing_rates,
								number option(nullable) 		flt_fix_proxy ,
								logical option(nullable) 		flt_allow_fwd_fix)
	{
		QL_FAIL_COND(null(is_ccy_),"fltflt2s_parm is not initalized (init_static() must be run) ");
		
		if(null(notional))
			QL_REQUIRE(!null(fix_pv01),"one of notional and fix_pv01 must be input");
		else if(null(fix_pv01))
			QL_REQUIRE(!null(notional),"one of notional and fix_pv01 must be input");
		else if(!null(notional) && !null(fix_pv01))
			QL_FAIL("ambigious input of notional and fix_pv01");

		fixois_spread_ = /*null(fix_spread) ? 0 :*/ fixo_spread;
		number r = null(fixf_cpn_rate_flat)  || null(fixo_spread) ? null : fixf_cpn_rate_flat - fixois_spread_;

		//----fix_parm1-----
		fip1_.set_plain(null, null, null, fip1_.fix_ccy_, null, null, null ,0,0,0,0,
						r, fixo_stub_type,fixo_eff_date, fixo_first_cpn_date, fixo_last_reg_date, notional, 1);
		
		//----fix_parm2-----
		fip2_.set_plain(null, null, null, fip2_.fix_ccy_, null, null, null ,0,0,0,0,
						fixf_cpn_rate_flat, fixf_stub_type,fixf_eff_date, fixf_first_cpn_date, fixf_last_reg_date, notional, 1);		
		
		//----ois_parm--------
	
		op_.set_plain(	null, null,null, op_.ois_ccy_, null, null, null, null,0,null, null, null, null,null,
						null, null,null, null,null,null,ois_stub_type,ois_eff_date, ois_first_cpn_date,
						ois_last_reg_date,notional,1,ois_fixing_dates,ois_fixing_rates,ois_fix_proxy,ois_allow_fwd_fix);
		
		//----flt_parm2--------
		
		fp_.set_plain(	null, null, null, fp_.flt_ccy_, null, null,null,
						null , null, 0, 0,0,0,null,0,flt_stub_type,flt_eff_date, flt_first_cpn_date,
						flt_last_reg_date, notional, 1, flt_curr_fix,
						flt_fixing_dates ,flt_fixing_rates,flt_fix_proxy ,flt_allow_fwd_fix,null,null);
		//---common---
		name_			= name;
		imp_calc_dec_  	= imp_fix_rate_dec;//rounding decimals of the implied cpn rate (on decimal value)
		pv01_not_unit_  = null(pv01_not_unit) ? -1: pv01_not_unit;//rounding unit for notional when implied from pv01
		pay_leg1_		= pay_sprd_leg;				

	
		trade_date_ 	= trade_date;
		fwd_start_code_ = fwd_start_code;
		start_date_ 	= start_date;
		maturity_ 		= maturity;
		if(!null(maturity_code))
			maturity_code_ 	= maturity_code;
		settle_date_	= settle_date;
		//cpn_roll_day_ 	= 0;

		this.start_date_helper();
		this.maturity_helper(fip1_);
		this.schedule_helper(fip1_);
		this.schedule_helper(fp_);
		this.schedule_helper(op_);
		this.check();
		
		if(null(notional))
			this.set_pv01(fix_pv01);
		else
			this.set_notional(notional);
		
		is_inited_ = true;
	}

	/*-----------------------------------------------------------------------
	  create_swap
	  ----------------------------------------------------------------------*/	
	void fltois2s_parm.create_swap(	disc_func option(nullable) 	disc_func,
									disc_func option(nullable) 	flt_fwd_disc_func,
									fwd_func option(nullable) 	flt_fwd_func,
									
									disc_func option(nullable) 	ois_fwd_disc_func,
									fwd_func option(nullable) 	ois_fwd_func,
									
									logical 					sync_endog_ok,
									
									out swap_fixois 			swap_fixois,
									out swap_fixflt 			swap_fixflt,
									logical option(nullable) 	flt_allow_extrap)
	{
		logical rev_leg_prio 	= true ;

		..disc_func 	odf, ofdf, dfr;
		fwd_func 	of;							
		op_.ois_df_helper( 	disc_func,ois_fwd_func,ois_fwd_disc_func,
							disc_func,
							false, rev_leg_prio, sync_endog_ok,
							trade_date_,
							maturity_,
							odf,of,ofdf,dfr);
		
		__create_swap( odf,  flt_fwd_disc_func, flt_fwd_func,flt_allow_extrap,ofdf,of,swap_fixois ,swap_fixflt);
	}
	
	/*-----------------------------------------------------------------------
	  __create_swap <protected>  leg2 == flat == fixflt
	  ----------------------------------------------------------------------*/	
	void fltois2s_parm.__create_swap(	disc_func option(nullable) 	disc_func,
										disc_func option(nullable) 	flt_fwd_disc_func,
										fwd_func option(nullable) 	flt_fwd_func,
										logical option(nullable) 	flt_allow_extrap,
										disc_func option(nullable) 	ois_fwd_disc_func,//sprd
										fwd_func option(nullable) 	ois_fwd_func,//sprd
										
										out swap_fixois 			sw_fixois,
										out swap_fixflt 			sw_fixflt )
	{
		logical pay_fixed_flat =  pay_leg1_;

		QL_FAIL_COND(!null(flt_fwd_disc_func) && !null(flt_fwd_func),"ambigious input (float fwd_func/flt_fwd_disc_func)");
				
		//defs
		ql_swap_fix_def fix_def1 	= this.create_swap_fix_def(fip1_,"fix_def(fixois)");
		QL_FAIL_COND(null(fix_def1),"error creating fixed leg def");

		ql_swap_fix_def fix_def2 	= this.create_swap_fix_def(fip2_,"fix_def(fixflt)");
		QL_FAIL_COND(null(fix_def2),"error creating fixed leg def");
		
		ql_swap_float_def flt_def 	= this.create_swap_float_def(fp_,"float_def");
		QL_FAIL_COND(null(flt_def),"error creating float leg def");
		
		ql_swap_ois_def ois_def 	= this.create_swap_ois_def(op_,"ois_def");
		QL_FAIL_COND(null(ois_def),"error creating ois leg def");
		
		//fix legs
		ql_fix_leg fix_flat 		= this.create_swap_fix_leg(fip2_,fix_def2, "fix_leg flat(2)",pay_fixed_flat, disc_func);
		QL_FAIL_COND(null(fix_flat),"error creating fixed leg (flat)");
		ql_fix_leg fix_sprd 		= this.create_swap_fix_leg(fip1_,fix_def1, "fix_leg sprd(1)",!pay_fixed_flat, disc_func);
		QL_FAIL_COND(null(fix_sprd),"error creating fixed leg (sprd)");

		//tenor surface ois
		tenor_surface ois_ts;
		create_ois_surface(op_,null, ois_fwd_func, ois_fwd_disc_func, disc_func, disc_func, ois_ts);

		//tenor surface flt
		tenor_surface flt_ts;
		if(null(flt_fwd_func) && null(flt_fwd_disc_func)){
			flt_ts = null;
		}
		else if(!null(flt_fwd_func)){
			flt_ts = create_flt_surface(fp_, disc_func,flt_fwd_func,null,flt_allow_extrap);
			QL_FAIL_COND(null(flt_ts),"error creating tenor surface leg (float)");
		}		
		else {
			flt_ts = create_flt_surface(fp_, disc_func,null,flt_fwd_disc_func,flt_allow_extrap);
			QL_FAIL_COND(null(flt_ts),"error creating tenor surface leg (float)");
		}

		//-----ois leg--------				
		ql_ois_leg  ois_s = this.create_swap_ois_leg(op_,ois_def, "ois_leg_sprd(1)",pay_fixed_flat, disc_func, ois_ts);
		QL_FAIL_COND(null(ois_s),"error creating ois leg (sprd)");
		
		//-----flt leg--------		
		ql_float_leg flt_f 		= this.create_swap_float_leg(fp_,flt_def, "float_leg flat(2)",!pay_fixed_flat, disc_func, flt_ts);
		QL_FAIL_COND(null(flt_f),"error creating float leg (flat)");

		//swap2
		ql_fixed_income_swap sw_flat = ql_fixed_income_swap(fix_flat,flt_f,name_);
		QL_FAIL_COND(null(sw_flat),"error creating swap (flat)");
		ql_fixed_income_swap sw_sprd = ql_fixed_income_swap(fix_sprd,ois_s,name_);
		QL_FAIL_COND(null(sw_sprd),"error creating swap (sprd)");

		if(!null(fp_.flt_curr_fix_))	
			sw_flat.float_leg(false).set_current_fixing(fp_.flt_curr_fix_);		

		/*-----------*/
		
		//implied flat leg
		if(null(fip2_.fix_coupon_rate_)) {
			number fix_r	= sw_flat.solver(0,swap_solver_code.SS_FIX_RATE_LEG1,false);
			QL_FAIL_COND(null(fix_r),"error calculating implied fixed coupon rate (flat)", E_INIT);

			if(imp_calc_dec_ >= 0)
				fix_r = round(fix_r,imp_calc_dec_);
				
			fip2_.fix_coupon_rate_ = fix_r;						
			fix_flat 	= this.create_swap_fix_leg(fip2_,fix_def2, "fix_leg flat(2)",pay_fixed_flat, disc_func);
			QL_FAIL_COND(null(fix_flat),"error creating fixed leg (flat)");
			sw_flat 	= ql_fixed_income_swap(fix_flat,flt_f,name_);
			QL_FAIL_COND(null(sw_flat),"error creating swap (flat)");
			//is it necessary to add fixing again here?
			if(!null(fp_.flt_curr_fix_))	
				sw_flat.float_leg(false).set_current_fixing(fp_.flt_curr_fix_);
		}

		error_info ee 			= new error_info(true,true);
		sw_fixflt 				= swap_fixflt(sw_flat, ee);			
		number fix_rate_flat 	= fip2_.fix_coupon_rate_;
		//number pv1,pv2;
		//number pv = swap_flat.present_value(pv1,pv2,false,ee);

		//implied sprd leg		
		if(null(fip1_.fix_coupon_rate_)) {//we could have a spread
									
			number fix_r = null;
			if(null(fixois_spread_)) {
				fix_r	= sw_sprd.solver(0,swap_solver_code.SS_FIX_RATE_LEG1,false);
				QL_FAIL_COND(null(fix_r),"error calculating implied fixed coupon rate (sprd)", E_INIT);
				if(imp_calc_dec_ >= 0)
					fix_r = round(fix_r,imp_calc_dec_);
			
				fixois_spread_ = fix_rate_flat - fix_r;
			}
			else {
				fix_r = fix_rate_flat - fixois_spread_;
			}
			
			fip1_.fix_coupon_rate_ = fix_r;
			
			fix_sprd 	= this.create_swap_fix_leg(fip1_,fix_def1, "fix_leg sprd(1)",!pay_fixed_flat, disc_func);
			QL_FAIL_COND(null(fix_sprd),"error creating fixed leg (sprd)");
			sw_sprd 	= ql_fixed_income_swap(fix_sprd,ois_s,name_);
			QL_FAIL_COND(null(sw_sprd),"error creating swap (sprd)");
			
		}

		if(null(fixois_spread_))
			fixois_spread_ = fix_rate_flat - fip1_.fix_coupon_rate_;
				
		sw_fixois = swap_fixois(sw_sprd, ee);
		
		//pv = swap_sprd.present_value(pv1,pv2,false,ee);
		
		if(!null(leg_pv01_)) {
			
			number pv01_1m 	= sw_fixflt.pv01(1000000,null,null,ee);//keep 1000000 as notional because this is the default notional when notional is not input (not really necessary) 
			number fix_not 	= abs(leg_pv01_)/pv01_1m*1000000;

			if(pv01_not_unit_>0){
				number a = fix_not/pv01_not_unit_;
				a = round(a,0);
				fix_not = a * pv01_not_unit_;
			}
			//update parm with new notional
			fip1_.fix_notional_ = fix_not;
			fip2_.fix_notional_ = fix_not;	
			fx_notional_helper();

			//update the newly created swap with new notional
			sw_fixflt.add_notional(fix_not);
			sw_fixois.add_notional(fix_not);
		}

		/*number fix_rate_flat 	= swap_flat.coupon_fix_leg(ee);		
		number fix_rate_sprd 	= fix_rate_flat + fix_spread_;
		fip1_.fix_coupon_rate_ 	= fix_rate_sprd;
		
		ql_fix_leg  fix_sprd 	= this.create_swap_fix_leg_sprd(fix_def, "fix_leg (sprd)",!pay_fixed_flat, disc_func);
		QL_FAIL_COND(null(fix_sprd),"error creating fixed leg (spread leg)");
		ql_fixed_income_swap sw_sprd = ql_fixed_income_swap(fix_sprd,flt_s1,name);		
		QL_FAIL_COND(null(sw_sprd),"error creating swap");*/

		
		
		//swap_sprd 				= swap_fixflt(sw_sprd, ee);
		
		return ;
	}
	/*-----------------------------------------------------------------------
	  create_swap
	  ----------------------------------------------------------------------*/	
	/*swap_fltois fltois2s_parm.create_swap(	disc_func option(nullable) 	disc_func,
											disc_func option(nullable) 	ois_sprd_fwd_disc_func,
											disc_func option(nullable) 	flt_flat_fwd_disc_func )
	{
		return __create_swap(  disc_func,  null,null,  ois_sprd_fwd_disc_func,flt_flat_fwd_disc_func);
	}*/
	/*-----------------------------------------------------------------------
	  create_swap
	  ----------------------------------------------------------------------*/	
	swap_fltois fltois2s_parm.create_swap(	disc_func option(nullable) 	disc_func,
											disc_func option(nullable) 	flt_fwd_disc_func,
											fwd_func option(nullable) 	flt_fwd_func,
											
											disc_func option(nullable) 	ois_fwd_disc_func,
											fwd_func option(nullable) 	ois_fwd_func,
											
											logical 					sync_endog_ok,
											logical option(nullable) 	flt_allow_extrap)
	{
		logical rev_leg_prio 	= true ;

		..disc_func 	odf,ofdf, dfr;
		fwd_func 	of;							
		op_.ois_df_helper( 	disc_func,ois_fwd_func,ois_fwd_disc_func,
							disc_func,
							false, rev_leg_prio, sync_endog_ok,
							trade_date_,
							maturity_,
							odf,of,ofdf,dfr);
		
		return __create_swap(  disc_func, flt_fwd_disc_func,flt_fwd_func, flt_allow_extrap,ofdf,of);
	}
	/*-----------------------------------------------------------------------
	  __create_swap <protected>
	  ----------------------------------------------------------------------*/	
	swap_fltois fltois2s_parm.__create_swap(disc_func option(nullable) 	disc_func,
											disc_func option(nullable) 	flt_fwd_disc_func,
											fwd_func option(nullable) 	flt_fwd_func,
											logical option(nullable) 	flt_allow_extrap,
											disc_func option(nullable) 	ois_fwd_disc_func,//sprd
											fwd_func option(nullable) 	ois_fwd_func)//sprd )
	{
	
		swap_fixois  sw_fixois;
		swap_fixflt  sw_fixflt;

		__create_swap(disc_func, flt_fwd_disc_func, flt_fwd_func,flt_allow_extrap,ois_fwd_disc_func,ois_fwd_func, sw_fixois, sw_fixflt );

		error_info ee = new error_info(true,true);
		number pv_fix_sprd,pv_ois;
		number pv_fixois = sw_fixois.present_value(pv_fix_sprd,pv_ois,false, ee);
	
		number pv_fix_flat,pv_flt;
		number pv_fixflt 		= sw_fixflt.present_value(pv_fix_flat,pv_flt,false, ee);

		//create fltflt swap
		ql_float_leg flt_f 			= sw_fixflt.float_leg(true,ee);
		ql_ois_leg ois_s 			= sw_fixois.ois_leg(true,ee);
		ql_fixed_income_swap sw_ff 	= ql_fixed_income_swap(flt_f,ois_s,"implied_fltois");
		swap_fltois sw 				= swap_fltois(sw_ff);

		//solve for and add spread to spread leg (=leg1)
		/*
		 ql_fix_leg fix 			= ql_fix_leg(fix_def,"fix_leg",trade_date,settle_date,settle_date,maturity,mat_code,
													false,notional,null<date>,null<date>,null<date>,fix_spread,	
													flt1_disc_func,cpn_roll_day,1);

		number pv_sprd 				= fix.present_value(false);//pv of the spread only
		
		 ql_fixed_income_swap sw_flat 	= ql_fixed_income_swap(flt1_flat,flt2_flat,"no_name");
		 number pv1,pv2;
		number pv = sw_flat.present_value(pv1,pv2,false);
		number pv_adj = pay_float1 ? pv - pv_sprd : pv + pv_sprd;

		number flt1_sprd 				= sw_flat.solver(pv_adj, SS_FLT_SPRD_LEG1,false);
		 */
		number pv 					= pv_fixois + pv_fixflt;
		number ois_sprd 			= sw_ff.solver(pv, SS_OIS_SPRD_LEG2,false);
		sw.add_quote(ois_sprd*10000);
		
		return sw;
		
	}
}