option(null: hard);	

/*	
	swaplib wrapper functions
	Developer: Algorithmica Research, Magnus Nyström

	--------------------------------------------------------------------
	 	swap help functions for create funcs
	--------------------------------------------------------------------			
*/
module CORE_SWAPLIB
{
	/*-----------------------------------------------------------------------
	 -----------------------------------------------------------------------
	 -----class flt_parm--------------------------------------------------
	 -----------------------------------------------------------------------
	 -----------------------------------------------------------------------*/
	class flt_parm
	{
	public:
		flt_parm();
		
		void	init_def_parm( 	string option(nullable) ,coupon_freq option(nullable),calendar option(nullable),bd_convention option(nullable) ,
								logical option(nullable) ,day_count_method  option(nullable),flt_reset_style  option(nullable),reset_freq  option(nullable) ,
								ir_index  option(nullable) ,flt_comp_avg_type  option(nullable) ,flt_sprd_comp_method option(nullable) ,flt_avg_method  option(nullable) ,
								flt_roll_method option(nullable),logical  option(nullable)  ,round_code  option(nullable) ,round_code  option(nullable) ,
								flt_fwd_style  option(nullable) ,flt_stub_fwd_style  option(nullable) ,logical  option(nullable) ,logical  option(nullable) ,
								interest_rule option(nullable) 	,fixing_stub_style option(nullable)  ,number  option(nullable) ,number  option(nullable) ,		
								number  option(nullable),number  option(nullable),logical option(nullable) ,number  option(nullable)  ,number option(nullable) ,number  option(nullable) );
	
		void	init_leg_parm(	number option(nullable) ,stub_type option(nullable) ,date option(nullable) ,date option(nullable) ,date option(nullable) ,
								number option(nullable)  ,number option(nullable)  ,number option(nullable) ,sink_fund_style option(nullable) ,
								vector(date)  option(nullable) ,vector(number)  option(nullable) ,vector(date)  option(nullable) ,vector(number) option(nullable) ,
								number 	 option(nullable) ,logical  option(nullable), number 	 option(nullable) ,number 	 option(nullable) ,number 	 option(nullable) ,
								number 	 option(nullable) ,number 	 option(nullable) );

		void	init_static(	bd_convention,calendar,logical,string,integer ,integer,day_count_method,interest_rule ,ir_index ,
								number,number,number,number,
								flt_comp_avg_type option(nullable) ,flt_sprd_comp_method option(nullable) ,flt_avg_method option(nullable),
								logical option(nullable), flt_roll_method	option(nullable) , logical option(nullable),flt_stub_fwd_style  option(nullable));
		void 	init_basic_static_leg1(instr_def );
		void 	init_basic_static_leg2(instr_def );
		void	basic_static_null_check(out bd_convention ,out calendar,out logical,out string	,number option(nullable) ,out coupon_freq ,
										number option(nullable) ,out reset_freq ,out day_count_method ,out ir_index ,out interest_rule,
										out number,out number,out number,out number, out logical, out flt_stub_fwd_style  );
		
		
		ql_swap_float_def 	create_swap_float_def(	string name, date_code ,notional_exchg_style);
		ql_float_leg 		create_swap_float_leg(	ql_swap_float_def,string ,logical ,disc_func option(nullable),tenor_surface option(nullable),
													date option(nullable),date option(nullable),date option(nullable) ,date option(nullable)  ,
													tenor_code option(nullable) );
		
		ql_float_leg 		create_swap_float_mtm_leg(	ql_swap_float_def 	flt_def,
														string 				name,
														logical 			pay,
														disc_func 	option(nullable)		flt_disc_func,
														tenor_surface 	option(nullable)	flt_tenor_surface,
														date option(nullable) trade_date,
														date option(nullable) settle_date,
														date option(nullable) start_date,
														date option(nullable) maturity ,
														tenor_code option(nullable) mat_code,
														integer 			cpn_roll_day,
														number 				opp_leg_fx_mult,
														disc_func option(nullable)	opp_leg_disc_func,
														number 				opp_leg_notional,
														string,
														calendar,
														calendar option(nullable) ,number option(nullable) );
		
		

		void	set_curr_fix(number option(nullable) fix);
		//void	set_plain_vanilla();
		void 	set_plain(	bd_convention option(nullable) 	pmt_bus_day,
							calendar option(nullable)	pmt_cal,
							logical	option(nullable) 	end_of_month,
							string	option(nullable) 	ccy,																								
							number option(nullable)		flt_cpn_freq_n,
							number option(nullable)		flt_reset_freq_n,
							day_count_method  option(nullable) flt_day_count,
							interest_rule	option(nullable),
							ir_index option(nullable)	flt_ir_index,
							number  option(nullable),number  option(nullable),number  option(nullable),number  option(nullable),
							flt_stub_fwd_style  option(nullable) ,
							number option(nullable) 	flt_spread,
							number option(nullable) 	flt_curr_fix );

		void	set_plain(	bd_convention option(nullable)	pmt_bus_day,
							calendar option(nullable)		pmt_cal,
							logical	 option(nullable)		end_of_month,
							string	option(nullable)		flt_ccy,
							number option(nullable)	 		flt_cpn_freq_n,
							number option(nullable)			flt_reset_freq_n,
							day_count_method  option(nullable) flt_day_count,
							interest_rule option(nullable) 	flt_ir_rule ,
							ir_index option(nullable)		flt_ir_index,
							number  option(nullable),number  option(nullable),number  option(nullable),number  option(nullable),
							flt_stub_fwd_style  option(nullable) ,
							number option(nullable) 		flt_spread,
							stub_type option(nullable) 		flt_stub_type,
							date option(nullable)  			flt_eff_date,
							date option(nullable)  			flt_first_cpn_date,
							date option(nullable)  			flt_last_reg_date,
							number	option(nullable) 		flt_notional,
							number	option(nullable)		flt_fx_mult,
							number option(nullable) 		flt_curr_fix,
							vector(date) option(nullable) 	flt_fixing_dates ,	
							vector(number) option(nullable) flt_fixing_rates,
							number option(nullable) 		flt_fix_proxy ,
							logical option(nullable) 		flt_allow_fwd_fix, number option(nullable) ,number option(nullable) );

		void 	set_plain_amort(bd_convention option(nullable)	pmt_bus_day,
								calendar option(nullable)		pmt_cal,
								logical	 option(nullable)		end_of_month,
								string	option(nullable)		ccy,
								number	 						notional,
								logical option(nullable)		,
								number option(nullable)	 		flt_cpn_freq_n,
								number option(nullable)			flt_reset_freq_n,
								day_count_method  option(nullable) flt_day_count,
								interest_rule option(nullable) 	flt_ir_rule ,
								ir_index option(nullable)		flt_ir_index,
								number  option(nullable),number  option(nullable),number  option(nullable),number  option(nullable),
								flt_stub_fwd_style  option(nullable) ,
								number option(nullable) 		flt_spread,
								stub_type option(nullable) 		flt_stub_type,
								date option(nullable)  			flt_eff_date,
								date option(nullable)  			flt_first_cpn_date,
								date option(nullable)  			flt_last_reg_date,
								sink_fund_style option(nullable) flt_sink_fund_style ,
								vector(date) option(nullable) 	flt_sink_fund_dates ,
								vector(number) option(nullable) flt_sink_fund ,
								//number	option(nullable) 		flt_notional,
								//number	option(nullable)		flt_fx_mult,
								number option(nullable) 		flt_curr_fix,
								vector(date) option(nullable) 	flt_fixing_dates ,	
								vector(number) option(nullable) flt_fixing_rates,
								number option(nullable) 		flt_fix_proxy ,
								logical option(nullable) 		flt_allow_fwd_fix,number option(nullable) ,number option(nullable) ,
								number option(nullable) 		flt_fx_mult);

		bd_convention 		flt_pmt_bus_day_mat();
		//---def---
		string 				flt_ccy_;		
		coupon_freq  		flt_cpn_freq_;		
		calendar 			flt_pmt_calendar_;
		bd_convention 		flt_pmt_bus_day_;
		logical				flt_end_of_month_;
		day_count_method 	flt_dc_;
		flt_reset_style 	flt_reset_style_;
		reset_freq  		flt_reset_freq_;
		ir_index 			flt_ir_index_;
		flt_comp_avg_type 	flt_ca_t_;
		flt_sprd_comp_method flt_comp_m_;
		flt_avg_method 		flt_avg_;
		flt_roll_method		flt_roll_;
		logical 			flt_average_notional_;		
		round_code 			flt_pv_round_code_;
		round_code 			flt_fwd_rate_round_code_;
		flt_fwd_style 		flt_fwd_rate_style_;
		flt_stub_fwd_style 	flt_fwd_stub_rate_style_;
		logical 			flt_start_stub_sprd_decomp_;
		logical 			flt_end_stub_sprd_decomp_;
		interest_rule		flt_ir_rule_;
		fixing_stub_style 	flt_fixing_stub_style_;
		number 				flt_pmt_delay_;
		number 				flt_mat_pmt_delay_;
		number 				flt_mat_pmt_delay_prin_;
		number 				flt_pmt_delay_prin_;
		logical 			flt_compound_to_mat_;
		number 				flt_sub_factor_;
		number 				flt_multi_factor_;
		number 				flt_power_factor_;
		
		//---leg---
		stub_type			flt_stub_type_;
		date 				flt_eff_date_;		
		date 				flt_first_cpn_date_;
		date 				flt_last_reg_date_;
		number 				flt_spread_;
		vector(date) 		flt_fixing_dates_;	
		vector(number) 		flt_fixing_rates_;
		number 				flt_fix_proxy_;
		logical 			flt_allow_fwd_fix_;
		number 				flt_notional_;
		number				flt_fx_mult_;
		number				flt_curr_fix_;
		sink_fund_style 	flt_sink_fund_style_;
		vector(date) 		flt_sink_fund_dates_;
		vector(number) 		flt_sink_fund_;
		//number flt_first_fixing,
		//number flt_last_fixing,
		number 				flt_fixing_start_stub_;
		number 				flt_start_stub_sprd_;
		number 				flt_fixing_end_stub_;
		number 				flt_end_stub_sprd_;
		number 				flt_comp_spread_;

		integer 			flt_roll_day_;
	};

	/*-----------------------------------------------------------------------
	  flt_parm constructor
	  ----------------------------------------------------------------------*/
	flt_parm.flt_parm():flt_ccy_(null),
						flt_cpn_freq_(null),		
						flt_pmt_calendar_(null),
						flt_pmt_bus_day_(null),
						flt_end_of_month_(null),
						flt_dc_(null),
						flt_reset_style_(null),
						flt_reset_freq_(null),
						flt_ir_index_(null),
						flt_ca_t_(null),
						flt_comp_m_(null),
						flt_avg_(null),
						flt_roll_(null),
						flt_average_notional_(null),		
						flt_pv_round_code_(null),
						flt_fwd_rate_round_code_(null),
						flt_fwd_rate_style_(null),
						flt_fwd_stub_rate_style_(null),
						flt_start_stub_sprd_decomp_(null),
						flt_end_stub_sprd_decomp_(null),
						flt_ir_rule_(null),
						flt_fixing_stub_style_(null),
						flt_pmt_delay_(null),
						flt_mat_pmt_delay_(null),
						flt_mat_pmt_delay_prin_(null),
						flt_pmt_delay_prin_(null),
						flt_compound_to_mat_(null),
						flt_sub_factor_(null),
						flt_multi_factor_(null),
						flt_power_factor_(null),			
						flt_stub_type_(null),
						flt_eff_date_(null),		
						flt_first_cpn_date_(null),
						flt_last_reg_date_(null),
						flt_spread_(null),
						flt_fixing_dates_(null),	
						flt_fixing_rates_(null),
						flt_fix_proxy_(null),
						flt_allow_fwd_fix_(null),
						flt_notional_(null),
						flt_fx_mult_(null),
						flt_curr_fix_(null),
						flt_sink_fund_style_(null),
						flt_sink_fund_dates_(null),
						flt_sink_fund_(null),
						flt_fixing_start_stub_(null),
						flt_start_stub_sprd_(null),
						flt_fixing_end_stub_(null),
						flt_end_stub_sprd_(null),
						flt_comp_spread_(null),
						flt_roll_day_(0)
	{}
	
	bd_convention 		flt_parm.flt_pmt_bus_day_mat() { return flt_pmt_bus_day_;}
	
	/*-----------------------------------------------------------------------
	  create_swap_float_def
	  ----------------------------------------------------------------------*/
	ql_swap_float_def flt_parm.create_swap_float_def(	string name,
														date_code settle_code,
														notional_exchg_style ne )
	{

		coupon_freq idx_cpn_freq 	= null;
		flt_index_rate_type idx_rt 	= null;
		tenor_code idx_tenor 		= null;
		return ql_swap_float_def(name,flt_ccy_, settle_code, flt_cpn_freq_, flt_dc_,flt_roll_, flt_pmt_bus_day_,
								flt_pmt_calendar_,flt_end_of_month_,flt_reset_freq_,flt_ir_index_,
								idx_tenor,idx_rt,idx_cpn_freq, null<quote_style>,
								flt_pv_round_code_,flt_fwd_rate_round_code_,flt_fwd_rate_style_,flt_fwd_stub_rate_style_,
								flt_start_stub_sprd_decomp_,flt_end_stub_sprd_decomp_,flt_ir_rule_,flt_fixing_stub_style_,
								flt_pmt_delay_,flt_mat_pmt_delay_,flt_pmt_delay_prin_,flt_mat_pmt_delay_prin_,
								flt_ca_t_,flt_comp_m_,flt_avg_,
								flt_reset_style_, ne,flt_average_notional_,flt_compound_to_mat_,
								flt_sub_factor_,flt_multi_factor_,flt_power_factor_);
	}
	/*-----------------------------------------------------------------------
	  create_swap_float_leg
	  ----------------------------------------------------------------------*/
	ql_float_leg flt_parm.create_swap_float_leg(	ql_swap_float_def 		flt_def,
													string 					name,
													logical 				pay,
													disc_func 	option(nullable)	flt_disc_func,
													tenor_surface option(nullable)	flt_tenor_surface,
													date option(nullable)	trade_date,
													date option(nullable)	settle_date,
													date option(nullable) 	start_date,
													date option(nullable)	maturity ,
													tenor_code option(nullable) mat_code/*,
													integer 				cpn_roll_day*/)
	{
		return ql_float_leg(flt_def,name,trade_date,settle_date,start_date,maturity,mat_code,
							pay,flt_notional_,flt_eff_date_,flt_first_cpn_date_,flt_last_reg_date_,
							null(flt_spread_) ? 0 : flt_spread_,
							flt_disc_func, flt_tenor_surface,flt_roll_day_,flt_fx_mult_,
							flt_sink_fund_style_,flt_sink_fund_dates_,flt_sink_fund_,
							flt_fixing_dates_,flt_fixing_rates_,
							flt_fix_proxy_,flt_allow_fwd_fix_,
							flt_fixing_start_stub_,
							flt_start_stub_sprd_,
							flt_fixing_end_stub_,
							flt_end_stub_sprd_,
							flt_comp_spread_);
	}

	
	/*-----------------------------------------------------------------------
	  create_swap_float_mtm_leg
	  ----------------------------------------------------------------------*/
	ql_float_leg flt_parm.create_swap_float_mtm_leg(ql_swap_float_def 	flt_def,
													string 				name,
													logical 			pay,
													disc_func 	option(nullable)		flt_disc_func,
													tenor_surface option(nullable)		flt_tenor_surface,
													date option(nullable) trade_date,
													date option(nullable) settle_date,
													date option(nullable) start_date,
													date option(nullable) maturity ,
													tenor_code option(nullable) mat_code,
													integer 			cpn_roll_day,
													number 				opp_leg_fx_mult,
													disc_func 	option(nullable)	opp_leg_disc_func,
													number 				opp_leg_notional,
													string				opp_leg_ccy,
													calendar			opp_leg_cal,
													calendar option(nullable) usd_calendar,
													number option(nullable) mtm_fx_spot_rate)
	{
	
		//base_ccy == reset_leg ccy
		//ex USD = reset_leg, SEK is constant leg --> fxrate is USDSEK
		//pv_in_sek --> this.flt_fx_mult(USD)_ = 10 and opp_leg_fx_mult(SEK) = 1 --> mtm_fx = 10/1
		
		//date flt_mtm_fx_date 				= settle_date;//fx_spot_date; 
		//number flt_mtm_fx_spot_res_base		= this.flt_fx_mult_/opp_leg_fx_mult;//resetleg ccy is baseccy, may not be equal to the fx spot date
		vector(date) flt_mtm_fx_fix_dates 	= null<vector(date)>;
		vector(number) flt_mtm_fx_fix 		= null<vector(number)>;
		number flt_mtm_fx_fix_proxy 		= null;
		logical flt_mtm_fx_fix_as_fwd 		= false;
		integer flt_mtm_fx_spot_days;
		fx_spot_rule fx_rule;
		
						
		if(null(mtm_fx_spot_rate)) {
			date fx_spot_dt;
			CORE_INT_SWAPLIB.mtm_data(trade_date,flt_def.currency(), flt_def.calendar(),
								  opp_leg_ccy, opp_leg_cal,
								  usd_calendar, flt_mtm_fx_spot_days, fx_rule, fx_spot_dt);
			
			logical settle_is_spot = !null(settle_date) && !null(fx_spot_dt) && settle_date == fx_spot_dt;
			
			if(settle_is_spot) {
				mtm_fx_spot_rate = this.flt_fx_mult_/opp_leg_fx_mult;//resetleg ccy is baseccy
			}
		}
		else {
			flt_mtm_fx_spot_days 	= fx_spot_days_dflt(flt_def.currency(), opp_leg_ccy);
			fx_rule			= fx_spot_rule_dflt(flt_def.currency(), opp_leg_ccy, usd_calendar);
		}
		
		return  ql_float_leg(flt_def,name,trade_date,settle_date,start_date,maturity,mat_code,
							pay,flt_notional_,flt_eff_date_,flt_first_cpn_date_,flt_last_reg_date_,
							null(flt_spread_) ? 0 : flt_spread_,
							flt_disc_func, flt_tenor_surface,cpn_roll_day,flt_fx_mult_,
							flt_fixing_dates_,flt_fixing_rates_,
							flt_fix_proxy_,flt_allow_fwd_fix_,
							flt_fixing_start_stub_,
							flt_start_stub_sprd_,
							flt_fixing_end_stub_,
							flt_end_stub_sprd_,
							flt_comp_spread_,
							//mtm	 
							//flt_mtm_fx_date,
							mtm_fx_spot_rate,
							flt_mtm_fx_spot_days,
							 opp_leg_ccy,
							 opp_leg_cal,
							 fx_rule,
							 usd_calendar,
							flt_disc_func,
							opp_leg_disc_func,
							opp_leg_notional,
							flt_mtm_fx_fix_dates,
							flt_mtm_fx_fix,
							flt_mtm_fx_fix_proxy,
							flt_mtm_fx_fix_as_fwd);
				 
	}
	/*-----------------------------------------------------------------------
	  init_def_parm
	  ----------------------------------------------------------------------*/
	void flt_parm.init_def_parm( string 	 option(nullable) 		ccy,		
								coupon_freq  option(nullable)  		cpn_freq,		
								calendar  option(nullable) 			pmt_calendar,
								bd_convention  option(nullable) 	pmt_bus_day,
								logical	 option(nullable) 			end_of_month,
								day_count_method option(nullable)  	dc,
								..flt_reset_style option(nullable)  reset_style,
								reset_freq option(nullable)   		reset_freq,
								ir_index 	 option(nullable) 		ir_index,
								flt_comp_avg_type option(nullable)  comp_avg_type,
								flt_sprd_comp_method option(nullable) sprd_comp_method,
								flt_avg_method  option(nullable) 	avg_method,
								flt_roll_method	 option(nullable) 	roll_method,
								logical  option(nullable) 			average_notional ,		
								round_code  option(nullable) 		pv_round_code,
								round_code  option(nullable) 		fwd_rate_round_code,
								flt_fwd_style  option(nullable) 	fwd_rate_style,
								flt_stub_fwd_style option(nullable) fwd_stub_rate_style,
								logical  option(nullable) 			start_stub_sprd_decomp,
								logical  option(nullable) 			end_stub_sprd_decomp,
								interest_rule option(nullable) 		ir_rule,
								fixing_stub_style  option(nullable) fixing_stub_style,
								number  option(nullable) 			pmt_delay,
								number  option(nullable) 			mat_pmt_delay,
								number  option(nullable) 			pmt_delay_prin,
								number  option(nullable) 			mat_pmt_delay_prin,	
								logical  option(nullable) 			compound_to_mat,
								number 	 option(nullable) 			sub_factor ,
								number 	 option(nullable) 			multi_factor ,
								number 	 option(nullable) 			power_factor)
	{
		flt_ccy_ 			= ccy;		
		flt_cpn_freq_ 		= cpn_freq;		
		flt_pmt_calendar_ 	= pmt_calendar;
		flt_pmt_bus_day_ 	= pmt_bus_day;
		flt_end_of_month_ 	= end_of_month;
		flt_dc_ 			= dc;
		flt_reset_style_ 	= reset_style;
		flt_reset_freq_ 	= reset_freq;
		flt_ir_index_ 		= ir_index;
		flt_ca_t_ 			= comp_avg_type;
		flt_comp_m_ 		= sprd_comp_method;
		flt_avg_ 			= avg_method;
		flt_roll_ 			= roll_method;
		flt_average_notional_ 		= average_notional;		
		flt_pv_round_code_ 			= pv_round_code;
		flt_fwd_rate_round_code_ 	= fwd_rate_round_code;
		flt_fwd_rate_style_ 		= fwd_rate_style;
		flt_fwd_stub_rate_style_ 	= fwd_stub_rate_style;
		flt_start_stub_sprd_decomp_ = start_stub_sprd_decomp;
		flt_end_stub_sprd_decomp_ 	= end_stub_sprd_decomp;
		flt_ir_rule_ 			= ir_rule;
		flt_fixing_stub_style_ 	= fixing_stub_style;
		flt_pmt_delay_ 			= pmt_delay;
		flt_mat_pmt_delay_ 		= mat_pmt_delay;
		flt_pmt_delay_prin_ 	= pmt_delay_prin;
		flt_mat_pmt_delay_prin_ = mat_pmt_delay_prin;	
		flt_compound_to_mat_	= compound_to_mat;
		flt_sub_factor_  		= sub_factor;
		flt_multi_factor_  		= multi_factor;
		flt_power_factor_  		= power_factor;

		
	}
	/*-----------------------------------------------------------------------
	  init_leg_parm
	  ----------------------------------------------------------------------*/
	void flt_parm.init_leg_parm(number option(nullable)  	notional,
								stub_type option(nullable) 	stub_type,
								date option(nullable)  		eff_date,
								date option(nullable)  		first_cpn_date,
								date option(nullable)  		last_reg_date,
								number option(nullable)  	spread,					
								number option(nullable)  	fx_mult,
								number option(nullable) 	curr_fix,
								sink_fund_style option(nullable) 	sink_fund_style,
								vector(date)  option(nullable) 		sink_fund_dates,
								vector(number)  option(nullable) 	sink_fund,
								vector(date)  option(nullable) 		fixing_dates ,	
								vector(number)  option(nullable) 	fixing_rates,
								number 	 option(nullable) 			fix_proxy ,
								logical  option(nullable) 			allow_fwd_fix,
								number 	 option(nullable) 			fixing_start_stub,
								number 	 option(nullable) 			start_stub_sprd,
								number 	 option(nullable) 			fixing_end_stub,
								number 	 option(nullable) 			end_stub_sprd,
								number 	 option(nullable) 			comp_spread)
	{
		flt_notional_ 		= notional;
		flt_stub_type_		= stub_type;
		flt_eff_date_		= eff_date;		
		flt_first_cpn_date_  = first_cpn_date;
		flt_last_reg_date_ 	= last_reg_date;
		flt_spread_ 		= spread;		
		flt_fx_mult_ 		= fx_mult;
		flt_curr_fix_ 		= curr_fix;
		flt_sink_fund_style_ = sink_fund_style;
		flt_sink_fund_dates_ = sink_fund_dates;
		flt_sink_fund_ 		= sink_fund;		
		flt_fixing_dates_ 	= fixing_dates;	
		flt_fixing_rates_ 	= fixing_rates;
		flt_fix_proxy_ 		= fix_proxy;
		flt_allow_fwd_fix_ 	= allow_fwd_fix;

		flt_fixing_start_stub_	= fixing_start_stub;
		flt_start_stub_sprd_	= start_stub_sprd;
		flt_fixing_end_stub_	= fixing_end_stub;
		flt_end_stub_sprd_		= end_stub_sprd;
		flt_comp_spread_		= comp_spread;
		flt_roll_day_			= 0;
	}
	/*-----------------------------------------------------------------------
	  init_basic_static_leg1
	  ----------------------------------------------------------------------*/
	void flt_parm.init_basic_static_leg1(instr_def  def )
	{
		flt_reset_style  	reset_st 			= flt_reset_style.RS_NORM;
		flt_roll_method 	roll 				= flt_roll_method.FLR_STRAIGHT;
		logical   			average_notional 	= true;		
		round_code   		pv_round_code 		= null;
		round_code   		fwd_rate_round_code = null;
		flt_fwd_style   	fwd_rate_style 		= flt_fwd_style.FF_INDEX;
		logical   			start_stub_sprd_decomp = null;
		logical   			end_stub_sprd_decomp = null;
		interest_rule  		ir_rule 			= interest_rule.IR_MATURITY_NOADJ;
		fixing_stub_style   fixing_stub_style 	= null;
		logical  			compound_to_mat 	= false;
		number 				sub_factor  		= null;
		number 	 			multi_factor  		= null;
		number 	 			power_factor 		= null;
		
		error_info ee = new error_info(true,true);
		init_def_parm( 	def.swap_currency_leg1(ee),		
						coupon_freq_from_int(def.swap_coupon_freq_leg1(ee)),		
						def.swap_calendar_leg1(ee),
						def.swap_pmt_bus_day_leg1(ee),
						def.swap_eom_leg1(ee),
						def.swap_dc_method_leg1(ee),
						reset_st,
						reset_freq_from_int(def.swap_reset_freq_leg1(ee)),
						def.swap_ir_index_leg1(ee),
						def.swap_comp_avg_type_leg1(ee),
						def.swap_sprd_comp_method_leg1(ee),
						def.swap_avg_method_leg1(ee),
						roll,
						average_notional,pv_round_code ,fwd_rate_round_code,fwd_rate_style,def.swap_fwd_stub_style_leg1(),
						start_stub_sprd_decomp,end_stub_sprd_decomp,ir_rule,fixing_stub_style,
						def.swap_pmt_lag_leg1(ee),def.swap_pmt_lag_leg1(ee),
						def.swap_pmt_lag_prin_leg1(ee),def.swap_pmt_lag_prin_leg1(ee),
						compound_to_mat,sub_factor,multi_factor ,power_factor);		

		init_leg_parm(	null,null,null,null,null,null,null,null,null,null,null,null ,null,null,null,null,null ,null,null,null);
	}
	/*-----------------------------------------------------------------------
	  init_basic_static_leg2
	  ----------------------------------------------------------------------*/
	void flt_parm.init_basic_static_leg2(instr_def  def )
	{
		error_info ee = new error_info(true,true);

		flt_reset_style  	reset_st 			= flt_reset_style.RS_NORM;
		flt_roll_method 	roll 				= flt_roll_method.FLR_STRAIGHT;
		logical   			average_notional 	= true;		
		round_code   		pv_round_code 		= null;
		round_code   		fwd_rate_round_code = null;
		flt_fwd_style   	fwd_rate_style 		= flt_fwd_style.FF_INDEX;
		logical   			start_stub_sprd_decomp = null;
		logical   			end_stub_sprd_decomp = null;
		interest_rule  		ir_rule 			= interest_rule.IR_MATURITY_NOADJ;
		fixing_stub_style   fixing_stub_style 	= null;
		logical  			compound_to_mat 	= false;
		number 				sub_factor  		= null;
		number 	 			multi_factor  		= null;
		number 	 			power_factor 		= null;
		
		init_def_parm( 	def.swap_currency_leg2(ee),		
						coupon_freq_from_int(def.swap_coupon_freq_leg2(ee)),		
						def.swap_calendar_leg2(ee),
						def.swap_pmt_bus_day_leg2(ee),
						def.swap_eom_leg2(ee),
						def.swap_dc_method_leg2(ee),
						reset_st,
						reset_freq_from_int(def.swap_reset_freq_leg2(ee)),
						def.swap_ir_index_leg2(ee),
						def.swap_comp_avg_type_leg2(ee),
						def.swap_sprd_comp_method_leg2(ee),
						def.swap_avg_method_leg2(ee),
						roll,
						average_notional,pv_round_code ,fwd_rate_round_code,fwd_rate_style,def.swap_fwd_stub_style_leg2(),
						start_stub_sprd_decomp,end_stub_sprd_decomp,ir_rule,fixing_stub_style,
						def.swap_pmt_lag_leg2(ee),def.swap_pmt_lag_leg2(ee),
						def.swap_pmt_lag_prin_leg2(ee),def.swap_pmt_lag_prin_leg2(ee),
						compound_to_mat,sub_factor,multi_factor ,power_factor);

		init_leg_parm(	null,null,null,null,null,null,null,null,null,null,null,null ,null,null,null,null,null ,null,null,null);
	}
	/*-----------------------------------------------------------------------
	  init_basic_static
	  ----------------------------------------------------------------------*/
	void flt_parm.init_static(	bd_convention 		pmt_bus_day,
								calendar  			pmt_cal,
								logical 			eom,
								string	 			ccy,
								integer 			cpn_freq,
								integer 			reset_freq,
								day_count_method 	dc,
								interest_rule 		ir_rule,
								ir_index 	 		ir_index,
								number   			pmt_delay,
								number   			mat_pmt_delay,
								number   			pmt_delay_prin,
								number   			mat_pmt_delay_prin,	
								flt_comp_avg_type  	option(nullable) 	comp_avg_type,
								flt_sprd_comp_method  option(nullable) 	sprd_comp_method,
								flt_avg_method  	option(nullable) 	avg_method,
								logical  option(nullable)  				average_notional,								
								flt_roll_method	option(nullable) 		roll,
								logical option(nullable) 				compound_to_mat,
								flt_stub_fwd_style  option(nullable)  	fwd_stub_rate_style)
	{
		//Note: fwd_stub_rate_style == flt_stub_fwd_style.FSF_CPN_DATES --> the stub will be interpolated
		flt_reset_style  	reset_st 			= flt_reset_style.RS_NORM;
		round_code   		pv_round_code 		= null;
		round_code   		fwd_rate_round_code = null;
		flt_fwd_style   	fwd_rate_style 		= flt_fwd_style.FF_INDEX;
		logical   			start_stub_sprd_decomp = null;
		logical   			end_stub_sprd_decomp = null;		
		fixing_stub_style   fixing_stub_style 	= null;
		number 				sub_factor  		= null;
		number 	 			multi_factor  		= null;
		number 	 			power_factor 		= null;
				
		init_def_parm( 	ccy,		
						coupon_freq_from_int(cpn_freq),		
						pmt_cal,
						pmt_bus_day,
						eom,
						dc,
						reset_st,
						reset_freq_from_int(reset_freq),
						ir_index,
						null(comp_avg_type) ? flt_comp_avg_type.CA_COMP : comp_avg_type,
						null(sprd_comp_method) ? flt_sprd_comp_method.SC_FLAT : sprd_comp_method,
						null(avg_method) ? flt_avg_method.AVG_UNWEIGHTED : avg_method,
						null(roll)? flt_roll_method.FLR_STRAIGHT : roll,
						null(average_notional) ? true :average_notional ,
						pv_round_code ,fwd_rate_round_code,fwd_rate_style,
						null(fwd_stub_rate_style) ? flt_stub_fwd_style.FSF_INDEX : fwd_stub_rate_style,
						start_stub_sprd_decomp,end_stub_sprd_decomp,ir_rule,fixing_stub_style,
						pmt_delay, mat_pmt_delay, pmt_delay_prin, mat_pmt_delay_prin,
						null(compound_to_mat) ? false : compound_to_mat,
						sub_factor,multi_factor ,power_factor);

		init_leg_parm(	null,null,null,null,null,null,null,null,null,null,null,null ,null,null,null,null,null ,null,null,null);
	}
	/*-----------------------------------------------------------------------
	  basic_static_null_check
	  ----------------------------------------------------------------------*/
	void flt_parm.basic_static_null_check(	out bd_convention 	pmt_bus_day,
											out calendar  		pmt_cal,
											out logical 		end_of_month,
											out string	 		ccy,
											number option(nullable) cpn_freq_n,
											out coupon_freq 	cpn_freq,
											number option(nullable) reset_freq_n,
											out reset_freq 		reset_freq,
											out day_count_method day_count,
											out ir_index 		ir_index,
											out interest_rule 	ir_rule,
											out number   		pmt_delay,
											out number   		mat_pmt_delay,
											out number   		pmt_delay_prin,
											out number   		mat_pmt_delay_prin,
											out logical			avg_notional,
											out flt_stub_fwd_style fwd_stub_rate_style) 	
	{
		if(null(pmt_bus_day))
		   pmt_bus_day = flt_pmt_bus_day_;
		QL_REQUIRE(!null(pmt_bus_day), "invalid float leg business day convention");
		
		if(null(pmt_cal))
			pmt_cal = flt_pmt_calendar_;
		QL_REQUIRE(!null(pmt_cal), "invalid float leg calendar");

		if(null(end_of_month))
			end_of_month = flt_end_of_month_ ;
		QL_REQUIRE(!null(end_of_month), "invalid float leg end of month");

		if(null(ccy))
			ccy = flt_ccy_ ;
		QL_REQUIRE(!null(ccy), "invalid float leg currency");

		if(null(cpn_freq_n))
			cpn_freq = flt_cpn_freq_;
		else
			cpn_freq = coupon_freq_from_int(integer(cpn_freq_n));
		QL_REQUIRE(!null(cpn_freq), "invalid float leg coupon frequency");
		
		if(null(day_count))
		   day_count = flt_dc_ ;
		QL_REQUIRE(!null(day_count), "invalid float leg daycount method");

		if(null(ir_index))
		   ir_index = flt_ir_index_;
		QL_REQUIRE(!null(ir_index), "invalid float leg index");

		if(null(reset_freq_n))
			reset_freq = flt_reset_freq_ ;
		else
			reset_freq = reset_freq_from_int(integer(reset_freq_n));
		QL_REQUIRE(!null(reset_freq), "invalid float leg coupon frequency");

		if(null(ir_rule))
		   ir_rule = flt_ir_rule_;
		QL_REQUIRE(!null(ir_rule), "invalid float leg interest rule");

		if(null(pmt_delay))
		   pmt_delay = flt_pmt_delay_;
		QL_REQUIRE(!null(pmt_delay), "invalid float leg pmt delay");

		if(null(mat_pmt_delay))
		   mat_pmt_delay = null(flt_mat_pmt_delay_) ? pmt_delay :  flt_mat_pmt_delay_;
		
		if(null(pmt_delay_prin))
		   pmt_delay_prin = flt_pmt_delay_prin_;
		QL_REQUIRE(!null(pmt_delay_prin), "invalid float leg principal pmt delay");

		if(null(mat_pmt_delay_prin))
		   mat_pmt_delay = null(flt_pmt_delay_prin_) ? pmt_delay_prin :  flt_pmt_delay_prin_;

		if(null(avg_notional))
			avg_notional = flt_average_notional_;
		QL_REQUIRE(!null(avg_notional), "invalid average notional setting (for amortizing swaps only)");

		if(null(fwd_stub_rate_style))
			fwd_stub_rate_style = flt_fwd_stub_rate_style_;
		QL_REQUIRE(!null(fwd_stub_rate_style), "invalid start stub rate style");
	}
	/*-----------------------------------------------------------------------
	  set_curr_fix
	  ----------------------------------------------------------------------*/
	void flt_parm.set_curr_fix(number option(nullable) fix)
	{
		flt_curr_fix_ = fix;
	}
	/*-----------------------------------------------------------------------
	  set_plain_vanilla
	  ----------------------------------------------------------------------*/	
	/*void flt_parm.set_plain_vanilla()
	{
		//will not set:
		//	flt_cpn_freq;
		//	flt_ccy;
		//	flt_pmt_calendar;
		//	flt_pmt_bus_day;
		//	flt_end_of_month;
		//	flt_dc
		//	flt_ir_index
		
		//	flt_notional;
		//	flt_fx_mult;
		//	flt_curr_fix;
		 
		
		flt_eff_date_ 		= null<date>;		
		flt_first_cpn_date_ = null<date>;
		flt_last_reg_date_ 	= null<date>;
		flt_spread_ 		= 0;
		
		flt_sink_fund_style_= null;
		flt_sink_fund_dates_= null;
		flt_sink_fund_		= null;
		flt_fixing_dates_ 	= null<vector(date)>;	
		flt_fixing_rates_	= null<vector(number)>;
		flt_fix_proxy_ 		= null;
		flt_allow_fwd_fix_	= false;

		flt_reset_style_ 		= ..flt_reset_style.RS_NORM;
		flt_reset_freq_ 		= null;
		flt_ca_t_				= null;
		flt_comp_m_				= null;
		flt_avg_				= null;
		flt_pv_round_code_		= null;
		flt_fwd_rate_round_code_= null;
		flt_fwd_rate_style_		= flt_fwd_style.FF_INDEX;
		flt_fwd_stub_rate_style_= null;
		flt_start_stub_sprd_decomp_= null;
		flt_end_stub_sprd_decomp_= null;
		
		flt_average_notional_	= true ;
		flt_sub_factor_			= null ;
		flt_multi_factor_		= null ;
		flt_power_factor_		= null ;
		flt_roll_ 				= ..flt_roll_method.FLR_STRAIGHT;
		flt_ir_rule_			= interest_rule.IR_MATURITY_NOADJ;
		flt_fixing_stub_style_	= null;
		flt_pmt_delay_			= 0;
		flt_mat_pmt_delay_		= 0;
		flt_pmt_delay_prin_		= 0;
		flt_mat_pmt_delay_prin_	= 0;
		flt_compound_to_mat_	= false;
	}*/
	
	/*-----------------------------------------------------------------------
	  set_plain
	  ----------------------------------------------------------------------*/
	void flt_parm.set_plain(bd_convention option(nullable) 	pmt_bus_day,
							calendar option(nullable)	pmt_cal,
							logical	option(nullable) 	end_of_month,
							string	option(nullable) 	ccy,																								
							number option(nullable)		flt_cpn_freq_n,
							number option(nullable)		flt_reset_freq_n,
							day_count_method  option(nullable) flt_day_count,
							interest_rule	option(nullable)	flt_ir_rule,
							ir_index option(nullable)	flt_ir_index,
							number  option(nullable)	flt_pmt_delay,
							number  option(nullable)	flt_mat_pmt_delay,
							number   option(nullable)	flt_pmt_delay_prin,
							number   option(nullable)	flt_mat_pmt_delay_prin,
							flt_stub_fwd_style  option(nullable) flt_fwd_stub_rate_style,//flt_stub_fwd_style.FSF_CPN_DATES --> the stub will be interpolated
							number option(nullable) 	flt_spread,
							number option(nullable) 	flt_curr_fix)
	{

		coupon_freq flt_cpn_freq = null;
		reset_freq flt_reset_freq = null;
		logical  average_notional 	= true;
		
		basic_static_null_check(pmt_bus_day,pmt_cal,end_of_month,ccy,flt_cpn_freq_n, flt_cpn_freq, flt_reset_freq_n,
								flt_reset_freq, flt_day_count, flt_ir_index,flt_ir_rule,
								flt_pmt_delay,flt_mat_pmt_delay,flt_pmt_delay_prin,flt_mat_pmt_delay_prin,
								average_notional,flt_fwd_stub_rate_style);

		flt_comp_avg_type cat 					= flt_comp_avg_type.CA_COMP;
		flt_sprd_comp_method scm 				= flt_sprd_comp_method.SC_FLAT;
		flt_avg_method am 						= flt_avg_method.AVG_UNWEIGHTED;

		flt_reset_style  	reset_st 			= flt_reset_style.RS_NORM;
		flt_roll_method 	roll 				= flt_roll_method.FLR_STRAIGHT;
			
		round_code   		pv_round_code 		= null;
		round_code   		fwd_rate_round_code = null;
		flt_fwd_style   	fwd_rate_style 		= flt_fwd_style.FF_INDEX;
		
		logical   			start_stub_sprd_decomp = null;
		logical   			end_stub_sprd_decomp = null;		
		fixing_stub_style   fixing_stub_style 	= null;
		logical  			compound_to_mat 	= false;
		number 				sub_factor  		= null;
		number 	 			multi_factor  		= null;
		number 	 			power_factor 		= null;
		
		init_def_parm(	ccy, flt_cpn_freq,pmt_cal, pmt_bus_day, end_of_month, flt_day_count, reset_st,
						flt_reset_freq, flt_ir_index, cat, scm, am, roll,
						average_notional,pv_round_code ,fwd_rate_round_code,fwd_rate_style,flt_fwd_stub_rate_style,
						start_stub_sprd_decomp,end_stub_sprd_decomp,flt_ir_rule,fixing_stub_style,
					    flt_pmt_delay,flt_mat_pmt_delay,flt_pmt_delay_prin,flt_mat_pmt_delay_prin,
						compound_to_mat,sub_factor,multi_factor ,power_factor);

		number   			notional 		= null;
		stub_type  			stub_t 			= stub_type.SHORT_FIRST;
		date   				eff_date		= null;
		date   				first_cpn_date	= null;
		date   				last_reg_date	= null;				
		number   			fx_mult			= null;
		sink_fund_style  	sink_fund_style	= null;
		vector(date)   		sink_fund_dates	= null;
		vector(number)   	sink_fund		= null;
		vector(date)   		fixing_dates 	= null;	
		vector(number)   	fixing_rates	= null;
		number 	  			fix_proxy 		= null;
		logical   			allow_fwd_fix 	= false;

		number 				fixing_start_stub= null;	
		number 				fixing_end_stub	= null;		
		number				start_stub_sprd	= null;		
		number				end_stub_sprd	= null;
		number				comp_spread		= null;

		init_leg_parm(	notional,stub_t,eff_date,first_cpn_date,last_reg_date,flt_spread,fx_mult,flt_curr_fix,
						sink_fund_style,sink_fund_dates,sink_fund,fixing_dates ,fixing_rates,fix_proxy,allow_fwd_fix,
						fixing_start_stub, start_stub_sprd, fixing_end_stub, end_stub_sprd, comp_spread);
	}
	/*-----------------------------------------------------------------------
	  set_plain
	  ----------------------------------------------------------------------*/
	void flt_parm.set_plain(	bd_convention option(nullable)	pmt_bus_day,
								calendar option(nullable)		pmt_cal,
								logical	 option(nullable)		end_of_month,
								string	 option(nullable)		flt_ccy,
								number option(nullable)	 		flt_cpn_freq_n,
								number option(nullable)			flt_reset_freq_n,
								day_count_method  option(nullable) flt_day_count,
								interest_rule option(nullable) 	flt_ir_rule ,
								ir_index option(nullable)		flt_ir_index,
								number  option(nullable)		flt_pmt_delay,
								number  option(nullable)		flt_mat_pmt_delay,
								number   option(nullable)		flt_pmt_delay_prin,
								number   option(nullable)		flt_mat_pmt_delay_prin,
								flt_stub_fwd_style  option(nullable) flt_fwd_stub_rate_style,//flt_stub_fwd_style.FSF_CPN_DATES --> the stub will be interpolated
								number option(nullable) 		flt_spread,
								stub_type option(nullable)  	flt_stub_type,
								date option(nullable)  			flt_eff_date,
								date option(nullable)  			flt_first_cpn_date,
								date option(nullable)  			flt_last_reg_date,
								number	option(nullable) 		flt_notional,								
								number	option(nullable)		flt_fx_mult,
								number option(nullable) 		flt_curr_fix,
								vector(date) option(nullable) 	flt_fixing_dates ,	
								vector(number) option(nullable) flt_fixing_rates,
								number option(nullable) 		flt_fix_proxy ,
								logical option(nullable) 		flt_allow_fwd_fix,
								number option(nullable)			flt_fix_start_stub,
								number option(nullable) 		flt_fix_end_stub)
	{
		
		coupon_freq 	flt_cpn_freq 	= null;
		reset_freq 		flt_reset_freq 	= null;
		logical  		flt_avg_not 	= true;	
		//all input args of def type must be checked
		basic_static_null_check(pmt_bus_day,pmt_cal,end_of_month,flt_ccy,flt_cpn_freq_n,flt_cpn_freq, 
							   flt_reset_freq_n, flt_reset_freq, flt_day_count, flt_ir_index,flt_ir_rule,
								flt_pmt_delay,flt_mat_pmt_delay,flt_pmt_delay_prin,flt_mat_pmt_delay_prin,
								flt_avg_not,flt_fwd_stub_rate_style);

		flt_reset_style  	flt_reset_st 			= flt_reset_style.RS_NORM;		
		logical 			flt_comp_to_mat 		= false ;
		flt_roll_method 	flt_roll 				= flt_roll_method.FLR_STRAIGHT;
		flt_comp_avg_type  	flt_comp_avg_t			= flt_comp_avg_type.CA_COMP ;
		flt_sprd_comp_method  flt_sprd_comp_m		= flt_sprd_comp_method.SC_FLAT ;
		flt_avg_method   	flt_avg_m				= flt_avg_method.AVG_UNWEIGHTED ;
		round_code 			flt_pv_round_code		= null ;
		round_code 			flt_fwd_rate_round_code	= null ;
		flt_fwd_style 		flt_fwd_rate_style		= flt_fwd_style.FF_INDEX ;
		//flt_stub_fwd_style 	flt_fwd_stub_rate_style	= flt_stub_fwd_style.FSF_INDEX;//flt_stub_fwd_style.FSF_CPN_DATES --> the stub will be interpolated
		logical 			flt_start_stub_sprd_decomp = null ;
		logical 			flt_end_stub_sprd_decomp = null ;
		fixing_stub_style   flt_fixing_stub_style	= null;		
		number 	  			flt_sub_factor 			= null;
		number 	  			flt_multi_factor 		= null;
		number 	  			flt_power_factor		= null;
								
		init_def_parm(	str_to_upper(flt_ccy), flt_cpn_freq,pmt_cal, pmt_bus_day, end_of_month,
						flt_day_count, flt_reset_st, flt_reset_freq, flt_ir_index, flt_comp_avg_t,
						flt_sprd_comp_m, flt_avg_m, flt_roll,flt_avg_not,flt_pv_round_code ,flt_fwd_rate_round_code,
						flt_fwd_rate_style,flt_fwd_stub_rate_style,flt_start_stub_sprd_decomp,flt_end_stub_sprd_decomp,
						flt_ir_rule,flt_fixing_stub_style,
						flt_pmt_delay,flt_mat_pmt_delay,flt_pmt_delay_prin,flt_mat_pmt_delay_prin,
						flt_comp_to_mat,
						flt_sub_factor,flt_multi_factor ,flt_power_factor);

		sink_fund_style flt_sink_fund_style = null;
		vector(date)  	flt_sink_fund_dates = null;
		vector(number)  flt_sink_fund 		= null;

		if(null(flt_stub_type))
			flt_stub_type = stub_type.SHORT_FIRST;

		number			flt_start_stub_sprd	= null;		
		number			flt_end_stub_sprd	= null;
		number			flt_comp_spread		= null;
									
		init_leg_parm(	flt_notional,flt_stub_type,flt_eff_date,flt_first_cpn_date,flt_last_reg_date,flt_spread,
						flt_fx_mult,flt_curr_fix,flt_sink_fund_style, flt_sink_fund_dates, flt_sink_fund,
						flt_fixing_dates ,flt_fixing_rates,flt_fix_proxy,flt_allow_fwd_fix,
						flt_fix_start_stub, flt_start_stub_sprd, flt_fix_end_stub, flt_end_stub_sprd, flt_comp_spread);
	}
	/*-----------------------------------------------------------------------
	  set_plain_amort
	  ----------------------------------------------------------------------*/
	void flt_parm.set_plain_amort(	bd_convention option(nullable)	pmt_bus_day,
									calendar option(nullable)		pmt_cal,
									logical	 option(nullable)		end_of_month,
									string	option(nullable)		ccy,
									number	 						notional,
									logical option(nullable)		flt_avg_not ,
									number option(nullable)	 		flt_cpn_freq_n,
									number option(nullable)			flt_reset_freq_n,
									day_count_method  option(nullable) flt_day_count,
									interest_rule option(nullable) 	flt_ir_rule ,
									ir_index option(nullable)		flt_ir_index,
									number  option(nullable)		flt_pmt_delay,
									number  option(nullable)		flt_mat_pmt_delay,
									number   option(nullable)		flt_pmt_delay_prin,
									number   option(nullable)		flt_mat_pmt_delay_prin,
									flt_stub_fwd_style  option(nullable) flt_fwd_stub_rate_style,//flt_stub_fwd_style.FSF_CPN_DATES --> the stub will be interpolated
									number option(nullable) 		flt_spread,
									stub_type option(nullable)  	flt_stub_type,
									date option(nullable)  			flt_eff_date,
									date option(nullable)  			flt_first_cpn_date,
									date option(nullable)  			flt_last_reg_date,
									sink_fund_style option(nullable) flt_sink_fund_style ,
									vector(date) option(nullable) 	flt_sink_fund_dates ,
									vector(number) option(nullable) flt_sink_fund ,
									//number	option(nullable) 		flt_notional,
									//number	option(nullable)		flt_fx_mult,
									number option(nullable) 		flt_curr_fix,
									vector(date) option(nullable) 	flt_fixing_dates ,	
									vector(number) option(nullable) flt_fixing_rates,
									number option(nullable) 		flt_fix_proxy ,
									logical option(nullable) 		flt_allow_fwd_fix,
									number option(nullable)			fixing_start_stub,
									number option(nullable) 		fixing_end_stub,								
									number	option(nullable)		flt_fx_mult)
	{
	
		
		coupon_freq 	flt_cpn_freq 	= null;
		reset_freq 		flt_reset_freq 	= null;
		//all input args of def type must be checked
		basic_static_null_check(pmt_bus_day,pmt_cal,end_of_month,ccy,flt_cpn_freq_n,flt_cpn_freq, 
							   flt_reset_freq_n, flt_reset_freq, flt_day_count, flt_ir_index,flt_ir_rule,
								flt_pmt_delay,flt_mat_pmt_delay,flt_pmt_delay_prin,flt_mat_pmt_delay_prin,
								flt_avg_not,flt_fwd_stub_rate_style);

		flt_reset_style  	flt_reset_st 			= flt_reset_style.RS_NORM;	
		logical 			flt_comp_to_mat 		= false ;
		flt_roll_method 	flt_roll 				= flt_roll_method.FLR_STRAIGHT;
		flt_comp_avg_type  	flt_comp_avg_t			= flt_comp_avg_type.CA_COMP ;
		flt_sprd_comp_method  flt_sprd_comp_m		= flt_sprd_comp_method.SC_FLAT ;
		flt_avg_method   	flt_avg_m				= flt_avg_method.AVG_UNWEIGHTED ;
		round_code 			flt_pv_round_code		= null ;
		round_code 			flt_fwd_rate_round_code	= null ;
		flt_fwd_style 		flt_fwd_rate_style		= flt_fwd_style.FF_INDEX ;
		//flt_stub_fwd_style 	flt_fwd_stub_rate_style	= flt_stub_fwd_style.FSF_INDEX;//flt_stub_fwd_style.FSF_CPN_DATES --> the stub will be interpolated
		logical 			flt_start_stub_sprd_decomp = null ;
		logical 			flt_end_stub_sprd_decomp = null ;
		fixing_stub_style   flt_fixing_stub_style	= null;		
		number 	  			flt_sub_factor 			= null;
		number 	  			flt_multi_factor 		= null;
		number 	  			flt_power_factor		= null;
								
		init_def_parm(	ccy, flt_cpn_freq,pmt_cal, pmt_bus_day, end_of_month,
						flt_day_count, flt_reset_st, flt_reset_freq, flt_ir_index, flt_comp_avg_t,
						flt_sprd_comp_m, flt_avg_m, flt_roll,flt_avg_not,flt_pv_round_code ,flt_fwd_rate_round_code,
						flt_fwd_rate_style,flt_fwd_stub_rate_style,flt_start_stub_sprd_decomp,flt_end_stub_sprd_decomp,
						flt_ir_rule,flt_fixing_stub_style,flt_pmt_delay,flt_mat_pmt_delay,flt_pmt_delay_prin,flt_mat_pmt_delay_prin,
						flt_comp_to_mat, flt_sub_factor,flt_multi_factor ,flt_power_factor);

		if(null(flt_stub_type))
			flt_stub_type = stub_type.SHORT_FIRST;

		number				start_stub_sprd	= null;		
		number				end_stub_sprd	= null;
		number				comp_spread		= null;
		
		init_leg_parm(notional,flt_stub_type,flt_eff_date,flt_first_cpn_date,flt_last_reg_date,flt_spread,
					flt_fx_mult,flt_curr_fix,flt_sink_fund_style, flt_sink_fund_dates, flt_sink_fund,
					flt_fixing_dates ,flt_fixing_rates,flt_fix_proxy,flt_allow_fwd_fix,
					fixing_start_stub, start_stub_sprd, fixing_end_stub, end_stub_sprd, comp_spread);
	}
}