option(null: hard);	

/*	
	swaplib wrapper functions
	Developer: Algorithmica Research, Magnus Nyström

	--------------------------------------------------------------------
	 	swap help functions for create funcs
	--------------------------------------------------------------------			
*/
module CORE_SWAPLIB
{
	
	/*-----------------------------------------------------------------------
	 -----------------------------------------------------------------------
	 -----class oisois_parm--------------------------------------------------
	 -----------------------------------------------------------------------
	 -----------------------------------------------------------------------*/
	class oisois_parm : public legleg_parm
	{
	public:
		override instr_type	type() ;
		oisois_parm();
		
		ql_ois_leg 			create_swap_ois_mtm_leg1(ql_swap_ois_def , string ,logical, disc_func  option(nullable) ,tenor_surface  option(nullable) , disc_func  option(nullable) );
		ql_ois_leg 			create_swap_ois_mtm_leg2(ql_swap_ois_def , string ,logical, disc_func  option(nullable) ,tenor_surface  option(nullable) , disc_func  option(nullable) );

		logical 			ois_df_check1( ..disc_func option(nullable) disc_func_rev_leg,
										 ..disc_func option(nullable) ois_disc_func,
										 ..fwd_func option(nullable) ois_fwd_func,
										 ..disc_func option(nullable) ois_fwd_disc_func,
										 out string err_msg);
		
		logical 			ois_df_check2( ..disc_func option(nullable) disc_func_rev_leg,
										 ..disc_func option(nullable) ois_disc_func,
										 ..fwd_func option(nullable) ois_fwd_func,
										 ..disc_func option(nullable) ois_fwd_disc_func,
										 out string err_msg);
		
		void 				start_date_helper();
		void 				fx_notional_helper();
					
		void 				create_ois_surface1(	disc_func option(nullable),fwd_func option(nullable),disc_func option(nullable),out disc_func,out tenor_surface);
		void 				create_ois_surface2(	disc_func option(nullable),fwd_func option(nullable),disc_func option(nullable),out disc_func,out tenor_surface);	
		
		void				init_static(instr_def,string option(nullable) spot_code );
		void				init_static(INSTR_TMPL.swap_oisois_def_tmpl);
		void				init_static(swap_oisois,string option(nullable) spot_code );
		void				init_static(string option(nullable) spot_code,
										bd_convention  		pmt_bus_day,
										calendar 			pmt_cal,
										logical				end_of_month,
										notional_exchg_style option(nullable) ne,												
										//ois1
										string				ois1_ccy,
										logical,
										integer				ois1_cpn_freq,
										day_count_method   	ois1_day_count,
										interest_rule		ois1_ir_rule,
										ir_index 			ois1_ir_index,
										avg_comp_method option(nullable) ois1_comp_avg,
											//flt_comp_avg_type option(nullable)		ois_comp_avg_t ,
											//flt_sprd_comp_method option(nullable)	ois_sprd_comp_m,
											//flt_avg_method 	option(nullable)		ois_avg_m,
										rfr_arrears_type  option(nullable)		ois1_arr_type,
										number option(nullable) 				ois1_arr_days ,
										number				ois1_pmt_delay,number,
										logical				ois1_endog_df,
										logical 			ois1_approx_calc,
										//ois2
										string				ois2_ccy,
										logical,
										integer				ois2_cpn_freq,
										day_count_method   	ois2_day_count,
										interest_rule		ois2_ir_rule,
										ir_index 			ois2_ir_index,
										avg_comp_method option(nullable) ois2_comp_avg,
											//flt_comp_avg_type option(nullable)		ois_comp_avg_t ,
											//flt_sprd_comp_method option(nullable)	ois_sprd_comp_m,
											//flt_avg_method 	option(nullable)		ois_avg_m,
										rfr_arrears_type  option(nullable)		ois2_arr_type,
										number option(nullable) 				ois2_arr_days ,
										number				ois2_pmt_delay,number,
										logical				ois2_endog_df,
										logical 			ois2_approx_calc );
		
		void 				set_notional_leg1(number);
		void 				set_notional_leg2(number);
		void 				set_pv01(number);
		ois_parm			ois_leg_parm1();
		ois_parm 			ois_leg_parm2();
		
		logical 			primary_quote_is_leg1();
		
		protected:
		number 				imp_mtm_fx_rate_leg1();
		number 				imp_mtm_fx_rate_leg2();
		void 				check();
		//void 				__set_plain_vanilla();
		void 			__set_plain(	bd_convention option(nullable) 	pmt_bus_day,
											calendar option(nullable)	pmt_cal,
											logical	option(nullable) 	end_of_month,											
											integer 					imp_sprd_dec,
											number option(nullable)		pv01_not_unit,
											//ois1											
											string	option(nullable) 	ois1_ccy,
											logical option(nullable),
											number option(nullable)		ois1_cpn_freq_n,
											day_count_method  option(nullable) ois1_day_count,
											interest_rule option(nullable)	ois1_ir_rule,
											ir_index option(nullable)	ois1_ir_index,number option(nullable),
											number option(nullable) 	ois1_spread,
											flt_comp_avg_type option(nullable)		ois1_comp_avg_t ,
											flt_sprd_comp_method option(nullable)	ois1_sprd_comp_m,
											flt_avg_method 	option(nullable)		ois1_avg_m,
											rfr_arrears_type  option(nullable)		ois1_arr_type,
											number option(nullable) 				ois1_arr_days ,
											number  option(nullable)	ois1_pmt_delay,number  option(nullable),
											logical	option(nullable)	ois1_endog_df,
											logical option(nullable)	ois1_approx_calc,
											//ois2											
											string	option(nullable) 	ois2_ccy,
											logical option(nullable),
											number option(nullable)		ois2_cpn_freq_n,
											day_count_method  option(nullable) ois2_day_count,
											interest_rule option(nullable)	ois2_ir_rule,
											ir_index option(nullable)	ois2_ir_index,number option(nullable),
											number option(nullable) 	ois2_spread,
											flt_comp_avg_type option(nullable)		ois2_comp_avg_t ,
											flt_sprd_comp_method option(nullable)	ois2_sprd_comp_m,
											flt_avg_method 	option(nullable)		ois2_avg_m,
											rfr_arrears_type  option(nullable)		ois2_arr_type,
											number option(nullable) 				ois2_arr_days ,
											number  option(nullable)	ois2_pmt_delay,number  option(nullable),
											logical	option(nullable)	ois2_endog_df,
											logical option(nullable)	ois2_approx_calc);

			swap_oisois 	__create_swap(disc_func option(nullable) 	ois1_disc_func,
											fwd_func option(nullable) 	ois1_fwd_func,
											disc_func option(nullable) 	ois1_fwd_disc_func,
											disc_func option(nullable) 	ois2_disc_func,
											fwd_func option(nullable) 	ois2_fwd_func,
											disc_func option(nullable) 	ois2_fwd_disc_func);
		
	public:
		void 		set_plain_single_ccy( string,											
										date option(nullable) 		trade_date,
										date option(nullable) 		settle_date,
										string option(nullable) 	spot_settle_code,
										date option(nullable) 		start_date,
										string option(nullable) 	fwd_start_code,
										date option(nullable) 		maturity,
										string option(nullable) 	maturity_code,
										logical,
										bd_convention option(nullable) 	pmt_bus_day,
										calendar option(nullable)	pmt_cal,
										logical	option(nullable) 	end_of_month,
										string	option(nullable) 	ccy,
										integer 					imp_sprd_dec	,
										number 	option(nullable) 	pv01_not_unit	,
										number	option(nullable) 	notional,
										number	option(nullable) 	ois1_pv01,
										//ois1
										number option(nullable)		ois1_cpn_freq_n,
										day_count_method  option(nullable) ois1_day_count,
										interest_rule option(nullable)	ois1_ir_rule,
										ir_index option(nullable)	ois1_ir_index,
										number option(nullable) 	ois1_spread ,
										avg_comp_method option(nullable) ois1_comp_avg,
											//flt_comp_avg_type option(nullable)		ois_comp_avg_t ,
											//flt_sprd_comp_method option(nullable)	ois_sprd_comp_m,
											//flt_avg_method 	option(nullable)		ois_avg_m,
										rfr_arrears_type  option(nullable)		ois1_arr_type,
										number option(nullable) 				ois1_arr_days ,
										number  option(nullable)	ois1_pmt_delay,
										logical	option(nullable)	ois1_endog_df,
										logical option(nullable)	ois1_approx_calc,
										//ois2													
										number option(nullable)		ois2_cpn_freq_n,
										day_count_method  option(nullable) ois2_day_count,
										interest_rule option(nullable)	ois2_ir_rule,
										ir_index option(nullable)	ois2_ir_index,
										number option(nullable) 	ois2_spread,
										avg_comp_method option(nullable) ois2_comp_avg,
											//flt_comp_avg_type option(nullable)		ois_comp_avg_t ,
											//flt_sprd_comp_method option(nullable)	ois_sprd_comp_m,
											//flt_avg_method 	option(nullable)		ois_avg_m,
										rfr_arrears_type  option(nullable)		ois2_arr_type,
										number option(nullable) 				ois2_arr_days ,
										number  option(nullable)	ois2_pmt_delay,
										logical	option(nullable)	ois2_endog_df,
										logical option(nullable)	ois2_approx_calc);

		void 		set_plain_single_ccy( string,											
										date option(nullable) 		trade_date,
										date option(nullable) 		settle_date,
										
										date option(nullable) 		start_date,
										string option(nullable) 	fwd_start_code,
										date option(nullable) 		maturity,
										string option(nullable) 	maturity_code,
										logical,
										integer 					imp_sprd_dec	,
										number 	option(nullable) 	pv01_not_unit	,
										number	option(nullable) 	notional,
										number	option(nullable) 	ois1_pv01,
										//ois1
										number option(nullable) 	ois1_spread ,
										//ois2	
										number option(nullable) 	ois2_spread);
		
		void		set_plain(	string,
								date option(nullable) 			trade_date,
								date option(nullable) 			settle_date,
								string option(nullable) 		spot_settle_code,
								date option(nullable) 			start_date,
								string option(nullable) 		fwd_start_code,
								date option(nullable)			maturity,
								string option(nullable) 		maturity_code,
								logical,
								bd_convention option(nullable)	pmt_bus_day,
								calendar option(nullable)		pmt_cal,
								logical	 option(nullable)		end_of_month,
								notional_exchg_style option(nullable) notional_exchg,
								integer 						imp_sprd_dec	,
								number 	option(nullable) 		pv01_not_unit	,
								number 	option(nullable) 		fx_quote,
								string 	option(nullable) 		fx_quote_baseccy,
								string 	option(nullable) 		fx_quote_priceccy,
								logical option(nullable) 		pv_in_base_ccy,
								//ois1
								string	option(nullable)		ois1_ccy,
								logical	option(nullable)		ois1_is_mtm,
								number option(nullable)	 		ois1_cpn_freq_n,
								day_count_method  option(nullable) ois1_day_count,
								interest_rule option(nullable) 	ois1_ir_rule ,
								ir_index option(nullable)		ois1_ir_index,
								number option(nullable) 		ois1_spread,
								avg_comp_method option(nullable) ois1_comp_avg,
											//flt_comp_avg_type option(nullable)		ois_comp_avg_t ,
											//flt_sprd_comp_method option(nullable)	ois_sprd_comp_m,
											//flt_avg_method 	option(nullable)		ois_avg_m,
								rfr_arrears_type  option(nullable)		ois1_arr_type,
								number option(nullable) 				ois1_arr_days ,
								number  option(nullable)		ois1_pmt_delay,number  option(nullable),
								logical	option(nullable)		ois1_endog_df,
								logical option(nullable)		ois1_approx_calc,
								stub_type option(nullable)		ois1_stub_type,
								date option(nullable)  			ois1_eff_date,
								date option(nullable)  			ois1_first_cpn_date,
								date option(nullable)  			ois1_last_reg_date,
								number	option(nullable) 		ois1_notional,
								number	option(nullable) 		ois1_pv01,								
								vector(date) option(nullable) 	ois1_fixing_dates ,	
								vector(number) option(nullable) ois1_fixing_rates,
								number option(nullable) 		ois1_fix_proxy ,
								logical option(nullable) 		ois1_allow_fwd_fix,
								//ois2
								string	option(nullable) 		ois2_ccy,
								logical	option(nullable)		ois2_is_mtm,
								number option(nullable)	 		ois2_cpn_freq_n,
								day_count_method  option(nullable) ois2_day_count,
								interest_rule option(nullable) 	ois2_ir_rule ,
								ir_index option(nullable)		ois2_ir_index,
								number option(nullable) 		ois2_spread,
								avg_comp_method option(nullable) ois2_comp_avg,
											//flt_comp_avg_type option(nullable)		ois_comp_avg_t ,
											//flt_sprd_comp_method option(nullable)	ois_sprd_comp_m,
											//flt_avg_method 	option(nullable)		ois_avg_m,
								rfr_arrears_type  option(nullable)		ois2_arr_type,
								number option(nullable) 				ois2_arr_days ,
								number  option(nullable)		ois2_pmt_delay,number  option(nullable),
								logical	option(nullable)		ois2_endog_df,
								logical option(nullable)		ois2_approx_calc,
								stub_type option(nullable)		ois2_stub_type,
								date option(nullable)  			ois2_eff_date,
								date option(nullable)  			ois2_first_cpn_date,
								date option(nullable)  			ois2_last_reg_date,
								number	option(nullable) 		ois2_notional,
								vector(date) option(nullable) 	ois2_fixing_dates ,	
								vector(number) option(nullable) ois2_fixing_rates,
								number option(nullable) 		ois2_fix_proxy ,
								logical option(nullable) 		ois2_allow_fwd_fix);

		void		set_plain(	string,
								date option(nullable) 			trade_date,
								date option(nullable) 			settle_date,
								
								date option(nullable) 			start_date,
								string option(nullable) 		fwd_start_code,
								date option(nullable)			maturity,
								string option(nullable) 		maturity_code,
								logical,
								integer 						imp_sprd_dec	,
								number 	option(nullable) 		pv01_not_unit	,
								number 	option(nullable) 		fx_quote,
								string 	option(nullable) 		fx_quote_baseccy,
								string 	option(nullable) 		fx_quote_priceccy,
								logical option(nullable) 		pv_in_base_ccy,
								//ois1
								number option(nullable) 		ois1_spread,
								stub_type option(nullable)		ois1_stub_type,
								date option(nullable)  			ois1_eff_date,
								date option(nullable)  			ois1_first_cpn_date,
								date option(nullable)  			ois1_last_reg_date,
								number	option(nullable) 		ois1_notional,
								number	option(nullable) 		ois1_pv01,								
								vector(date) option(nullable) 	ois1_fixing_dates ,	
								vector(number) option(nullable) ois1_fixing_rates,
								number option(nullable) 		ois1_fix_proxy ,
								logical option(nullable) 		ois1_allow_fwd_fix,
								//ois2
								number option(nullable) 		ois2_spread,
								stub_type option(nullable)		ois2_stub_type,
								date option(nullable)  			ois2_eff_date,
								date option(nullable)  			ois2_first_cpn_date,
								date option(nullable)  			ois2_last_reg_date,
								number	option(nullable) 		ois2_notional,
								vector(date) option(nullable) 	ois2_fixing_dates ,	
								vector(number) option(nullable) ois2_fixing_rates,
								number option(nullable) 		ois2_fix_proxy ,
								logical option(nullable) 		ois2_allow_fwd_fix);


		//set_plain_amort_single_curr

		swap_oisois 	create_swap(disc_func option(nullable) 	ois1_disc_func,
									disc_func option(nullable) 	ois1_fwd_disc_func,
									disc_func option(nullable) 	ois2_disc_func,
									disc_func option(nullable) 	ois2_fwd_disc_func );

		swap_oisois 	create_swap(disc_func option(nullable) 	ois1_disc_func,
									fwd_func option(nullable) 	ois1_fwd_func, 
									disc_func option(nullable) 	ois2_disc_func,
									fwd_func option(nullable) 	ois2_fwd_func);

		swap_oisois 	create_swap(disc_func option(nullable) 	ois1_disc_func,
									fwd_func option(nullable) 	ois1_fwd_func,
									disc_func option(nullable) 	ois1_fwd_disc_func,
									disc_func option(nullable) 	ois2_disc_func,
									fwd_func option(nullable) 	ois2_fwd_func,
									disc_func option(nullable) 	ois2_fwd_disc_func,
									logical sync_endog_ok);
		 
		ois_parm	op1_;
		ois_parm	op2_;

		void set_mtm_data(	number 	option(nullable)  fx_quote );
		
	};
	/*-----------------------------------------------------------------------
	  constructor
	  ----------------------------------------------------------------------*/
	oisois_parm.oisois_parm()
	{
		op1_ 			= new ois_parm();
		op2_ 			= new ois_parm();
	}
	/*-----------------------------------------------------------------------
	  type
	  ----------------------------------------------------------------------*/
	instr_type oisois_parm.type() { return instr_type.SWAP_OISOIS;}
	/*-----------------------------------------------------------------------
	  ois_leg_parm/mtm
	  ----------------------------------------------------------------------*/
	ois_parm oisois_parm.ois_leg_parm1() 	{ return op1_;}
	ois_parm oisois_parm.ois_leg_parm2() 	{ return op2_;}

	/*-----------------------------------------------------------------------
	  set_mtm_data
	  ----------------------------------------------------------------------*/
	void oisois_parm.set_mtm_data(	number 	option(nullable)  mtm_fx_quote )
	{
		calendar mtm_usd_calendar = null;//for now
		legleg_parm.set_mtm_data(op1_.ois_ccy_, op2_.ois_ccy_, op1_.ois_pmt_calendar_,op2_.ois_pmt_calendar_, mtm_fx_quote, mtm_usd_calendar);			
	}
	/*-----------------------------------------------------------------------
	  check
	  ----------------------------------------------------------------------*/
	void oisois_parm.check()
	{
		if(is_aged_swap()){
			QL_REQUIRE(!null(op1_.ois_spread_),"ois leg spread required for aged swap");
			if(is_ccy_ ) {
				QL_REQUIRE(!null(op1_.ois_notional_) && !null(op2_.ois_notional_),"notionals are required for aged swap");
			}
			else {
				QL_REQUIRE(!null(op1_.ois_notional_) || !null(op2_.ois_notional_),"notional is required for aged swap");
			}
		}
	}
	/*-----------------------------------------------------------------------
	  set_notional_leg1
	  ----------------------------------------------------------------------*/
	void oisois_parm.set_notional_leg1(number not)
	{
		op1_.ois_notional_ 	= not;
		if(!is_ccy_)
			op2_.ois_notional_ 	= not;
		leg_pv01_ 			= null;
		fx_notional_helper();
	}
	/*-----------------------------------------------------------------------
	  set_notional_leg2
	  ----------------------------------------------------------------------*/
	void oisois_parm.set_notional_leg2(number not)
	{
		op2_.ois_notional_ 	= not;
		if(!is_ccy_)
			op1_.ois_notional_ 	= not;
		leg_pv01_ 			= null;
		fx_notional_helper();
	}
	/*-----------------------------------------------------------------------
	  set_notional
	  ----------------------------------------------------------------------*/
	void oisois_parm.set_pv01(number pv01)
	{
		op1_.ois_notional_ 	= 1000000;
		op2_.ois_notional_ 	= null;//if null it will be calculated in ccy_helper, assume pv01 is leg1  FIX_ME
		leg_pv01_ 			= pv01;
		fx_notional_helper();
	}
	/*-----------------------------------------------------------------------
	  ccy_helper
	  ----------------------------------------------------------------------*/
	void oisois_parm.fx_notional_helper()
	{
		legleg_parm.fx_notional_helper(op1_.ois_notional_, op2_.ois_notional_, op1_.ois_fx_mult_ , op2_.ois_fx_mult_);
	}
	/*-----------------------------------------------------------------------
	  start_date_helper
	  ----------------------------------------------------------------------*/
	void oisois_parm.start_date_helper()
	{
		legleg_parm.start_date_helper(op1_.ois_eff_date_, op2_.ois_eff_date_, op1_.ois_pmt_calendar_);
	}

	/*-----------------------------------------------------------------------
	  mtm_fx_rate_leg1
	  ----------------------------------------------------------------------*/	
	number oisois_parm.imp_mtm_fx_rate_leg1()
	{
		number 	opp_leg_fx_mult = op2_.ois_fx_mult_;
		return 	op1_.ois_fx_mult_/opp_leg_fx_mult;
	}
	/*-----------------------------------------------------------------------
	  mtm_fx_rate_leg2
	  ----------------------------------------------------------------------*/	
	number oisois_parm.imp_mtm_fx_rate_leg2()
	{
		number opp_leg_fx_mult = op1_.ois_fx_mult_;
		return op2_.ois_fx_mult_/opp_leg_fx_mult;
	}
	/*-----------------------------------------------------------------------
	  ois_df_check
	  ----------------------------------------------------------------------*/
	logical oisois_parm.ois_df_check1(..disc_func option(nullable) disc_func_rev_leg,
									 ..disc_func option(nullable) ois_disc_func,
									 ..fwd_func option(nullable) ois_fwd_func,
									 ..disc_func option(nullable) ois_fwd_disc_func,
									 out string err_msg)
	{
		logical ok = CORE_INT_SWAPLIB.ois_df_check(	op1_.ois_endog_df_,is_ccy_,
													disc_func_rev_leg,ois_disc_func, ois_fwd_func, ois_fwd_disc_func, err_msg);
		return ok;
	}
	/*-----------------------------------------------------------------------
	  ois_df_check
	  ----------------------------------------------------------------------*/
	logical oisois_parm.ois_df_check2(..disc_func option(nullable) disc_func_rev_leg,
									 ..disc_func option(nullable) ois_disc_func,
									 ..fwd_func option(nullable) ois_fwd_func,
									 ..disc_func option(nullable) ois_fwd_disc_func,
									 out string err_msg)
	{
		logical ok = CORE_INT_SWAPLIB.ois_df_check(	op2_.ois_endog_df_,is_ccy_,
													disc_func_rev_leg,ois_disc_func, ois_fwd_func, ois_fwd_disc_func, err_msg);
		return ok;
	}
		
	/*-----------------------------------------------------------------------
	  create_ois_surface1
	  ----------------------------------------------------------------------*/
	void oisois_parm.create_ois_surface1(disc_func option(nullable)	df_disc_func,
										fwd_func  option(nullable)	ois_fwd_func,
										disc_func  option(nullable)	ois_fwddf_func,
										//out disc_func 				flt_disc_func,
										out disc_func 				ois_disc_func,
										out tenor_surface 			ois_tenor_surface)
	{
		disc_func df;
		CORE_INT_SWAPLIB.ois_df_fwd_helper(	is_ccy_,  df_disc_func, ois_fwd_func, ois_fwddf_func,
											op1_.ois_ir_index_, op1_.ois_endog_df_, op1_.ois_is_approx_calc_,
											trade_date_, settle_date_, maturity_, maturity_code_,
											df,ois_disc_func,ois_tenor_surface);
	}
	/*-----------------------------------------------------------------------
	  create_ois_surface2
	  ----------------------------------------------------------------------*/
	void oisois_parm.create_ois_surface2(disc_func option(nullable)	df_disc_func,
										fwd_func  option(nullable)		ois_fwd_func,
										disc_func  option(nullable)		ois_fwddf_func,
										//out disc_func 	flt_disc_func,
										out disc_func 	ois_disc_func,
										out tenor_surface ois_tenor_surface)
	{
		disc_func df;
		CORE_INT_SWAPLIB.ois_df_fwd_helper(	is_ccy_,  df_disc_func, ois_fwd_func, ois_fwddf_func,
											op2_.ois_ir_index_, op2_.ois_endog_df_, op2_.ois_is_approx_calc_,
											trade_date_, settle_date_, maturity_, maturity_code_,
											df,ois_disc_func,ois_tenor_surface);
	}
	/*-----------------------------------------------------------------------
	  create_swap_ois_leg1
	  ----------------------------------------------------------------------*/	
	ql_ois_leg oisois_parm.create_swap_ois_mtm_leg1(ql_swap_ois_def 	ois_def,
													string 				name,
													logical 			pay,
													disc_func option(nullable) 		ois_disc_func,
													tenor_surface option(nullable) 	ois_tenor_surface,
													disc_func option(nullable) 		ois2_disc_func)													
	{
		calendar usd_cal = null; //used for calc of fx spot date, not used for all currency pairs
		return op1_.create_swap_ois_mtm_leg(	ois_def, name, pay, ois_disc_func, ois_tenor_surface, trade_date_,
												settle_date_,start_date_, maturity_ , mat_code_,op2_.ois_roll_day_,
												op2_.ois_fx_mult_,
												ois2_disc_func,
												op2_.ois_notional_,
												op2_.ois_ccy_,
												op2_.ois_pmt_calendar_, usd_cal,mtm_fx_spot_rate_);
	}
	/*-----------------------------------------------------------------------
	  create_swap_ois_leg2
	  ----------------------------------------------------------------------*/	
	ql_ois_leg oisois_parm.create_swap_ois_mtm_leg2(ql_swap_ois_def 	ois_def,
													string 				name,
													logical 			pay,
													disc_func option(nullable) 		ois_disc_func,
													tenor_surface option(nullable) 	ois_tenor_surface,
													disc_func option(nullable) 		ois1_disc_func)													
	{
		calendar usd_cal = null; //used for calc of fx spot date, not used for all currency pairs
		return op2_.create_swap_ois_mtm_leg(	ois_def, name, pay, ois_disc_func, ois_tenor_surface, trade_date_,
												settle_date_,start_date_, maturity_ , mat_code_,op1_.ois_roll_day_,
												op1_.ois_fx_mult_,
												ois1_disc_func,
												op1_.ois_notional_,
												op1_.ois_ccy_,
												op1_.ois_pmt_calendar_, usd_cal,mtm_fx_spot_rate_);
	}
	
	/*-----------------------------------------------------------------------
	  init_basic_static
	  Note: a possible maturity code in the template is never "carried over" to the swap
	  Note to self: tmpl --> def --> ql_fixed_income_swap --> swap_fixflt (and the def is lost in the process since it is only part of the translation)
					(a direct route without the def is possible but not sure if it will save much compute time)
	  ----------------------------------------------------------------------*/
	void oisois_parm.init_static(INSTR_TMPL.swap_oisois_def_tmpl tmpl)
	{
		//----oisois_parm-----		
		is_ccy_	 		= tmpl.is_cross_curr();		
		ne_ 			= tmpl.not_exchange();
		if(null(ne_))
			ne_ 	= is_ccy_ ? NE_BOTH : NE_NONE;
		
		spot_code_ 		= tmpl.spot_settle_code(); 
		trade_date_ 	= null;
		maturity_ 		= null;
		maturity_code_ 	= tmpl.maturity_code();
		mat_code_ 		= null;
		fwd_start_code_ = null;//tmpl.fwd_start_code();
		start_date_ 	= null;
		settle_date_	= null;
		//cpn_roll_day_ 	= 0;
		is_mtm_ 		= tmpl.is_mtm(is_mtm_leg1_);

		//ois1
		flt_roll_method ois_roll 	= null;
		logical ois_avg_not 		= null;
		op1_.init_static(	tmpl.ois1_bd_convention(),tmpl.ois1_calendar(),tmpl.ois1_eom(), tmpl.ois1_currency(),tmpl.ois1_cpn_freq(),									
								tmpl.ois1_day_count_method(),tmpl.ois1_ir_rule(),tmpl.ois1_ir_index(),
								tmpl.ois1_comp_avg(),
								tmpl.ois1_spread_comp_method(),
								tmpl.ois1_avg_method(),
								tmpl.payment_delay() ,
								tmpl.payment_delay(),tmpl.payment_delay(), tmpl.payment_delay() ,
								tmpl.ois1_arr_type(), tmpl.ois1_arr_days(),tmpl.ois1_endog_df(),
								tmpl.ois1_approx_calc(),ois_avg_not, ois_roll);

		//ois2
		op2_.init_static(	tmpl.ois2_bd_convention(),tmpl.ois2_calendar(),tmpl.ois2_eom(), tmpl.ois2_currency(),tmpl.ois2_cpn_freq(),									
								tmpl.ois2_day_count_method(),tmpl.ois2_ir_rule(),tmpl.ois2_ir_index(),
								tmpl.ois2_comp_avg(),
								tmpl.ois2_spread_comp_method(),
								tmpl.ois2_avg_method(),
								tmpl.payment_delay() ,
								tmpl.payment_delay(),tmpl.payment_delay(), tmpl.payment_delay() ,
								tmpl.ois2_arr_type(), tmpl.ois2_arr_days(),tmpl.ois2_endog_df(),
								tmpl.ois2_approx_calc(),ois_avg_not, ois_roll);				
	}
	/*-----------------------------------------------------------------------
	  init_basic_static
	  ----------------------------------------------------------------------*/
	void oisois_parm.init_static(	instr_def def,
									string option(nullable) spot_code)
	{
		QL_REQUIRE(CORE_INT.check_instr_def(def),"invalid instr_def");
		QL_FAIL_COND(!def.is_swap_oisois(), "instr_def not a ois-ois swap", E_INIT);

		//----oisois_parm-----
		is_ccy_ 		= def.is_ccy_swap();		
		error_info ees 	= new error_info(true,false);
		ne_ 			= def.swap_not_exchange(ees);
		if(null(ne_))
			ne_ = is_ccy_ ? NE_BOTH : NE_NONE;
		
		spot_code_ 		= null(spot_code) ? "BD2" : spot_code;
		trade_date_ 	= null;
		maturity_ 		= null;
		maturity_code_ 	= def.maturity_code(ees);
		mat_code_ 		= null;
		fwd_start_code_ = null;
		start_date_ 	= null;
		settle_date_	= null;
		//cpn_roll_day_ 	= 0;
		is_mtm_ 		= def.is_swap_oisois_mtm();
		is_mtm_leg1_ 	= def.is_swap_oisois_mtm_leg1();

		op1_.init_basic_static_leg1(def);
		op2_.init_basic_static_leg2(def);
	}
	/*-----------------------------------------------------------------------
	  init_basic_static
	  ----------------------------------------------------------------------*/
	void oisois_parm.init_static(	swap_oisois sw_base,
									string option(nullable) spot_code)	//ext swap i.e. instr_def = null
	{

		//----oisois_parm-----
		is_ccy_ 		= sw_base.is_ccy_swap();		
		error_info ee 	= new error_info(true,true);
		ne_ 			= null;//notional_exchg_style.NE_NONE;
		if(null(ne_))
			ne_ = is_ccy_ ? NE_BOTH : NE_NONE;
		//ne 				= sw_base.notional_exchg_style_fix_leg(ee);		//assume both legs are same

		spot_code_ 		= null(spot_code) ? "BD2" : spot_code;
		trade_date_ 	= null;
		maturity_ 		= null;
		maturity_code_ 	= null;
		mat_code_ 		= null;
		fwd_start_code_ = null;
		start_date_ 	= null;
		settle_date_	= null;
		//cpn_roll_day_ 	= 0;
		is_mtm_leg1_ 	= sw_base.is_mtm_leg1(ee);
		is_mtm_ 		= is_mtm_leg1_|| sw_base.is_mtm_leg2(ee) ;
		
		integer cfreq_ois1, cfreq_ois2;
		sw_base.coupon_freq( cfreq_ois1,cfreq_ois2, ee);
		sw_base.calendar(op1_.ois_pmt_calendar_,op2_.ois_pmt_calendar_,ee);
		sw_base.pmt_bus_day(op1_.ois_pmt_bus_day_,op2_.ois_pmt_bus_day_,ee);
		sw_base.eom(op1_.ois_end_of_month_,op2_.ois_end_of_month_,ee);
		sw_base.dc_method(op1_.ois_dc_,op2_.ois_dc_ ,ee);
		sw_base.currency(op1_.ois_ccy_ ,op2_.ois_ccy_ ,ee);		

		//ois1
		integer mat_pmt_delay1,mat_pmt_delay_prin1;
		integer mat_pmt_delay2,mat_pmt_delay_prin2;
		integer pmt_delay1,pmt_delay2 ;
		integer pmt_delay_prin1,pmt_delay_prin2 ;
		sw_base.pmt_lag(pmt_delay1,mat_pmt_delay1, pmt_delay_prin1, mat_pmt_delay_prin1,
						pmt_delay2,mat_pmt_delay2, pmt_delay_prin2, mat_pmt_delay_prin2,ee);

		flt_comp_avg_type ois1_comp_avg_type 		= sw_base.comp_avg_type_leg1(ee);//OBS n/a for ext swap
		flt_sprd_comp_method  ois1_sprd_comp_method = sw_base.sprd_comp_method_leg1(ee);//OBS n/a for ext swap
		flt_avg_method ois1_avg_method 				= sw_base.avg_method_leg1(ee);//OBS n/a for ext swap
		rfr_arrears_type at1  						= sw_base.rfr_arrears_type_leg1(ee);//OBS n/a for ext swap
		integer a1 									= sw_base.rfr_arrears_days_leg1(ee);//OBS n/a for ext swap
		number ad1 									= a1 == err_int() ? null : a1 ;
		logical  ois_average_notional 				= null;
		flt_roll_method ois_roll 					= null; 
		op1_.init_static(	op1_.ois_pmt_bus_day_,op1_.ois_pmt_calendar_,op1_.ois_end_of_month_,
							op1_.ois_ccy_,cfreq_ois1,
							op1_.ois_dc_,sw_base.ir_rule_leg1(ee),sw_base.ir_index_leg1(ee),
							ois1_comp_avg_type,ois1_sprd_comp_method,ois1_avg_method,							
							pmt_delay1,mat_pmt_delay1,pmt_delay_prin1,mat_pmt_delay_prin1,
							at1 ,ad1,sw_base.is_endog_df_leg1(ee),
							sw_base.is_approx_calc_leg1(ee),ois_average_notional, ois_roll);

		//ois2
		flt_comp_avg_type ois2_comp_avg_type 		= sw_base.comp_avg_type_leg2(ee);//OBS n/a for ext swap
		flt_sprd_comp_method  ois2_sprd_comp_method = sw_base.sprd_comp_method_leg2(ee);//OBS n/a for ext swap
		flt_avg_method ois2_avg_method 				= sw_base.avg_method_leg2(ee);//OBS n/a for ext swap
		rfr_arrears_type at2  						= sw_base.rfr_arrears_type_leg2(ee);//OBS n/a for ext swap
		integer a2 									= sw_base.rfr_arrears_days_leg2(ee);//OBS n/a for ext swap
		number ad2 									= a2 == err_int() ? null : a2 ;
		op2_.init_static(	op2_.ois_pmt_bus_day_,op2_.ois_pmt_calendar_,op2_.ois_end_of_month_,
							op2_.ois_ccy_,cfreq_ois1,
							op2_.ois_dc_,sw_base.ir_rule_leg2(ee),sw_base.ir_index_leg2(ee),
							ois2_comp_avg_type,ois2_sprd_comp_method,ois2_avg_method,
							pmt_delay2,mat_pmt_delay2,pmt_delay_prin2,mat_pmt_delay_prin2,
							at2 ,ad2,sw_base.is_endog_df_leg2(ee),
							sw_base.is_approx_calc_leg2(ee),ois_average_notional, ois_roll);
		
	}

	void oisois_parm.init_static(	string 	option(nullable)	spot_code,
									bd_convention  		pmt_bus_day,
									calendar 			pmt_cal,
									logical				end_of_month,
									notional_exchg_style option(nullable) ne,												
									//ois1
									string				ois1_ccy,
									logical 			ois1_is_mtm,
									integer				ois1_cpn_freq,
									day_count_method   	ois1_day_count,
									interest_rule		ois1_ir_rule,
									ir_index 			ois1_ir_index,
									avg_comp_method option(nullable) ois1_comp_avg,
											//flt_comp_avg_type option(nullable)		ois_comp_avg_t ,
											//flt_sprd_comp_method option(nullable)	ois_sprd_comp_m,
											//flt_avg_method 	option(nullable)		ois_avg_m,
									rfr_arrears_type  option(nullable)		ois1_arr_type,
									number option(nullable) 				ois1_arr_days ,
									number				ois1_pmt_delay,
									number				ois1_pmt_delay_prin,
									logical				ois1_endog_df,
									logical 			ois1_approx_calc,
									//ois2
									string				ois2_ccy,
									logical 			ois2_is_mtm,
									integer				ois2_cpn_freq,
									day_count_method   	ois2_day_count,
									interest_rule		ois2_ir_rule,
									ir_index 			ois2_ir_index,
									avg_comp_method option(nullable) ois2_comp_avg,
											//flt_comp_avg_type option(nullable)		ois_comp_avg_t ,
											//flt_sprd_comp_method option(nullable)	ois_sprd_comp_m,
											//flt_avg_method 	option(nullable)		ois_avg_m,
									rfr_arrears_type  option(nullable)		ois2_arr_type,
									number option(nullable) 				ois2_arr_days ,
									number				ois2_pmt_delay,
									number				ois2_pmt_delay_prin,
									logical				ois2_endog_df,
									logical 			ois2_approx_calc )
	{
		//----oisois_parm-----		
		is_ccy_ 		= !equal_casei(ois1_ccy, ois2_ccy);	
		ne_ 			= ne;
		if(null(ne_))
			ne_ = is_ccy_ ? NE_BOTH : NE_NONE;

		spot_code_ 		= null(spot_code) ? "BD2" : spot_code;
		trade_date_ 	= null;
		maturity_ 		= null;
		maturity_code_ 	= null;
		mat_code_ 		= null;
		fwd_start_code_ = null;
		start_date_ 	= null;
		settle_date_	= null;
		//cpn_roll_day_ 	= 0;
		
		if(is_ccy_) {
			if(!null(ois1_is_mtm)) {
				is_mtm_leg1_ = ois1_is_mtm;
				if(is_mtm_leg1_)
					is_mtm_ = true;
			}
			if(!null(ois2_is_mtm) && ois2_is_mtm) {			
				is_mtm_ = true;
			}
		}
		//----ois1_parm--------
		logical ois1_avg_not 		= null;
		flt_roll_method ois1_roll 	= null;
		flt_comp_avg_type  ois1_comp_avg_t 		= null;
		flt_sprd_comp_method  ois1_sprd_comp_m 	= null;
		flt_avg_method  ois1_avg_m 				= null;
		if(!null(ois1_comp_avg)){
			conv_from_avg_comp_method(ois1_comp_avg,ois1_comp_avg_t,ois1_sprd_comp_m,ois1_avg_m);
		}
		op1_.init_static(pmt_bus_day, pmt_cal,end_of_month,ois1_ccy,
								ois1_cpn_freq, ois1_day_count,
								ois1_ir_rule,ois1_ir_index,
								ois1_comp_avg_t, ois1_sprd_comp_m, ois1_avg_m,
								ois1_pmt_delay,	ois1_pmt_delay, ois1_pmt_delay_prin, ois1_pmt_delay_prin ,
								ois1_arr_type, ois1_arr_days, ois1_endog_df,
								ois1_approx_calc,ois1_avg_not, ois1_roll);

		//----ois2_parm--------
		logical ois2_avg_not 		= null;
		flt_roll_method ois2_roll 	= null;
		flt_comp_avg_type  ois2_comp_avg_t 		= null;
		flt_sprd_comp_method  ois2_sprd_comp_m 	= null;
		flt_avg_method  ois2_avg_m 				= null;
		if(!null(ois2_comp_avg)){
			conv_from_avg_comp_method(ois2_comp_avg,ois2_comp_avg_t,ois2_sprd_comp_m,ois2_avg_m);
		}
		op2_.init_static(pmt_bus_day, pmt_cal,end_of_month,ois2_ccy,
								ois2_cpn_freq, ois2_day_count,
								ois2_ir_rule,ois2_ir_index,
								ois2_comp_avg_t, ois2_sprd_comp_m, ois2_avg_m,
								ois2_pmt_delay,	ois2_pmt_delay, ois2_pmt_delay_prin, ois2_pmt_delay_prin ,
								ois2_arr_type, ois2_arr_days, ois2_endog_df,
								ois2_approx_calc,ois2_avg_not, ois2_roll);
	}
	/*-----------------------------------------------------------------------
	  create_swap
	  ----------------------------------------------------------------------*/	
	swap_oisois oisois_parm.create_swap(disc_func option(nullable) 	ois1_disc_func,
										disc_func option(nullable) 	ois1_fwd_disc_func,
										disc_func option(nullable) 	ois2_disc_func,
										disc_func option(nullable) 	ois2_fwd_disc_func )
	{
		return __create_swap(   ois1_disc_func, null, ois1_fwd_disc_func,ois2_disc_func,  null, ois2_fwd_disc_func);
	}
	/*-----------------------------------------------------------------------
	  create_swap
	  ----------------------------------------------------------------------*/	
	swap_oisois oisois_parm.create_swap( 	disc_func option(nullable) 	ois1_disc_func,
											fwd_func option(nullable) 	ois1_fwd_func, 
											disc_func option(nullable) 	ois2_disc_func,
											fwd_func option(nullable) 	ois2_fwd_func )
	{
		return __create_swap( ois1_disc_func, ois1_fwd_func, null, ois2_disc_func, ois2_fwd_func,null);
	}
	/*-----------------------------------------------------------------------
	  create_swap
	  ----------------------------------------------------------------------*/	
	swap_oisois oisois_parm.create_swap( 	disc_func option(nullable) 	ois1_disc_func,
											fwd_func option(nullable) 	ois1_fwd_func,
											disc_func option(nullable) 	ois1_fwd_disc_func,
											disc_func option(nullable) 	ois2_disc_func,
											fwd_func option(nullable) 	ois2_fwd_func,
											disc_func option(nullable) 	ois2_fwd_disc_func,
											logical sync_endog_ok)
	{
		logical rev_leg_prio = false ;
		
		disc_func 	o1df, o1fdf, dfr2;
		fwd_func 	o1f;								
		op1_.ois_df_helper( ois1_disc_func,ois1_fwd_func,ois1_fwd_disc_func,
							ois2_disc_func,
							is_cross_currency(), rev_leg_prio, sync_endog_ok,
							trade_date_,
							maturity_,
							o1df,o1f,o1fdf,dfr2);
		
		rev_leg_prio 	= true ;
		ois2_disc_func 	= dfr2;

		disc_func 	o2df,o2fdf, dfr1;
		fwd_func 	o2f;							
		op2_.ois_df_helper( ois2_disc_func,ois2_fwd_func,ois2_fwd_disc_func,
							ois1_disc_func,
							is_cross_currency(), rev_leg_prio, sync_endog_ok,
							trade_date_,
							maturity_,
							o2df,o2f,o2fdf,dfr1);
		
		return __create_swap(o1df, o1f, o1fdf, o2df, o2f, o2fdf);
	}
	/*-----------------------------------------------------------------------
	  __create_swap <protected>
	  ----------------------------------------------------------------------*/	
	swap_oisois oisois_parm.__create_swap( 	disc_func option(nullable) 	ois1_disc_func,
											fwd_func option(nullable) 	ois1_fwd_func,
											disc_func option(nullable) 	ois1_fwd_disc_func,
											disc_func option(nullable) 	ois2_disc_func,
											fwd_func option(nullable) 	ois2_fwd_func,
											disc_func option(nullable) 	ois2_fwd_disc_func )
	{
		//-----checks--------
		//string err_msg;
		//logical ok = this.ois_df_check1(ois2_disc_func,ois1_disc_func, ois1_fwd_func, ois1_fwd_disc_func, err_msg);			
		//QL_REQUIRE(ok,err_msg);

		//ok = this.ois_df_check2(ois1_disc_func,ois2_disc_func, ois2_fwd_func, ois2_fwd_disc_func, err_msg);			
		//QL_REQUIRE(ok,err_msg);
		
		//QL_FAIL_COND(!null(ois1_fwd_func) && !null(ois1_fwd_disc_func),"ambigious input leg1 (fwd_func/disc_func)");//already checked?
		//QL_FAIL_COND(!null(ois2_fwd_func) && !null(ois2_fwd_disc_func),"ambigious input leg2 (fwd_func/disc_func)");//already checked?

		//if(!is_ccy_ ){
			//if(!null(ois1_disc_func))
			//	ois2_disc_func = ois1_disc_func;
			//else if(!null(ois2_disc_func))
			//	ois1_disc_func = ois2_disc_func;
		//}
		
		//-----defs--------
		ql_swap_ois_def ois1_def 	= this.create_swap_ois_def(op1_,"ois_def1");
		QL_FAIL_COND(null(ois1_def),"error creating ois leg1 def");
		ql_swap_ois_def ois2_def 	= this.create_swap_ois_def(op2_,"ois_def2");
		QL_FAIL_COND(null(ois2_def),"error creating ois leg2 def");

		//-----tenor surfaces leg1-------
		tenor_surface ois1_ts;
		if(null(ois1_fwd_func) && null(ois1_fwd_disc_func)){
			ois1_ts = null;
		}		
		else{
			create_ois_surface1(ois1_disc_func,ois1_fwd_func,ois1_fwd_disc_func,ois1_disc_func,ois1_ts);
			QL_FAIL_COND(null(ois1_ts),"error creating tenor surface1");
		}

		//-----tenor surfaces leg2-------
		tenor_surface ois2_ts;
		if(null(ois2_fwd_func) && null(ois2_fwd_disc_func)){
			ois2_ts = null;
		}
		else{
			create_ois_surface2(ois2_disc_func,ois2_fwd_func,ois2_fwd_disc_func,ois2_disc_func,ois2_ts);
			QL_FAIL_COND(null(ois2_ts),"error creating tenor surface2");
		}

		//QL_FAIL_COND(is_mtm_leg1() && null(ois2_disc_func),"leg2 disc_func required for mtm on leg1");
		//QL_FAIL_COND(is_mtm_leg2() && null(ois1_disc_func),"leg1 disc_func required for mtm on leg2");
		
		//-----ois1 leg--------		
		ql_ois_leg ois1;
		if(is_mtm_leg1()){
			ois1 = this.create_swap_ois_mtm_leg1(ois1_def, "ois_leg1_mtm",pay_leg1_, ois1_disc_func, ois1_ts,ois2_disc_func);
			QL_FAIL_COND(null(ois1),"error creating ois leg1 (mtm)");
		}
		else {
			ois1 = this.create_swap_ois_leg(op1_,ois1_def, "ois_leg1",pay_leg1_, ois1_disc_func, ois1_ts);
			QL_FAIL_COND(null(ois1),"error creating ois leg1");
		}
		
		//-----ois2 leg--------		
		ql_ois_leg ois2;
		if(is_mtm_leg2()){
			ois2 = this.create_swap_ois_mtm_leg2(ois2_def, "ois_leg2_mtm",!pay_leg1_, ois2_disc_func, ois2_ts,ois1_disc_func);
			QL_FAIL_COND(null(ois2),"error creating ois leg2 (mtm)");
		}
		else {
			ois2 = this.create_swap_ois_leg(op2_,ois2_def, "ois_leg2",!pay_leg1_, ois2_disc_func, ois2_ts);
			QL_FAIL_COND(null(ois2),"error creating ois leg2");
		}
		//-----swap--------
		ql_fixed_income_swap sw 	= ql_fixed_income_swap(ois1,ois2,name_);
		QL_FAIL_COND(null(sw),"error creating swap");

		//----solve for rate if null-----
		if(null(op1_.ois_spread_)) {
			number s	= sw.solver(0,swap_solver_code.SS_OIS_SPRD_LEG1,false);
			QL_FAIL_COND(null(s),"error calculating implied spread (leg1)", E_INIT);

			if(imp_calc_dec_ >= 0)
				s = round(s,imp_calc_dec_);
				
			op1_.ois_spread_ = s;
			//---recreate ois1 leg------

			if(is_mtm_leg1()){
				ois1 = this.create_swap_ois_mtm_leg1(ois1_def, "ois_leg1_mtm",pay_leg1_, ois1_disc_func, ois1_ts, ois2_disc_func);
				QL_FAIL_COND(null(ois1),"error creating ois leg1 (mtm)");
			}
			else {
				ois1 = this.create_swap_ois_leg(op1_,ois1_def, "ois_leg1",pay_leg1_, ois1_disc_func, ois1_ts);
				QL_FAIL_COND(null(ois1),"error creating ois leg1");
			}
			
			//----recreate swap-------
			sw 		= ql_fixed_income_swap(ois1,ois2,name_);
			QL_FAIL_COND(null(sw),"error creating swap");

		}

		error_info ee 	= new error_info(true,true);
		swap_oisois swff = swap_oisois(sw, ee);

		//--calc notional if pv01 input---
		if(!null(leg_pv01_)) {
			
			number pv01_1m = swff.pv01_spread_leg1(1000000,null,null,ee);//keep 1000000 as notional because this is the default notional when notional is not input (not really necessary) 
			number ois_not 	= abs(leg_pv01_)/pv01_1m*1000000;

			if(pv01_not_unit_>0){
				number a = ois_not/pv01_not_unit_;
				a = round(a,0);
				ois_not = a * pv01_not_unit_;
			}
			//update parm with new notional
			op1_.ois_notional_ = ois_not;
			op2_.ois_notional_ = null;	
			fx_notional_helper();

			//update the newly created swap with new notional
			if(!swff.is_cross_currency(ee)){
				swff.add_notional(op1_.ois_notional_);
			}
			else {
				swff.add_notional(op1_.ois_notional_,op2_.ois_notional_);
			}
			/*
				if(!is_mtm_leg1()) {
					swff.add_notional_leg1(op1_.ois_notional_);
				}
				else {
					ois1 = this.create_swap_ois_mtm_leg1(ois1_def, "ois_leg1_mtm",pay_leg1_, ois1_disc_func, ois1_ts, ois2_disc_func);
					QL_FAIL_COND(null(ois1),"error creating ois leg1 (mtm)");
					sw 		= ql_fixed_income_swap(ois1,ois2,name_);
					QL_FAIL_COND(null(sw),"error creating swap");
					
				}
				
				if(!is_mtm_leg2()) {
					swff.add_notional_leg2(op2_.ois_notional_);
				}
				else {
					ois2 = this.create_swap_ois_mtm_leg2(ois2_def, "ois_leg2_mtm",!pay_leg1_, ois2_disc_func, ois2_ts,ois1_disc_func);
					QL_FAIL_COND(null(ois2),"error creating ois leg2 (mtm)");
					sw 		= ql_fixed_income_swap(ois1,ois2,name_);
					QL_FAIL_COND(null(sw),"error creating swap");
				}
			}
			else {
				swff.add_notional(ois_not);
			}*/
		}
		return swff;
		
	}
	/*-----------------------------------------------------------------------
	  set_plain_vanilla
	  ----------------------------------------------------------------------*/
	/*void oisois_parm.__set_plain_vanilla()
	{		
		cpn_roll_day_ 		= 0;
		logical fed_fund_style = false;
		// ----fix_parm-------
		op1_.set_plain_vanilla(fed_fund_style);
		
		// ----ois parm-------
		op2_.set_plain_vanilla(fed_fund_style);

	}*/

	/*-----------------------------------------------------------------------
	  __set_plain  <protected>    internal
	  ----------------------------------------------------------------------*/
	void oisois_parm.__set_plain(	bd_convention option(nullable) 	pmt_bus_day,
									calendar option(nullable)		pmt_cal,
									logical	option(nullable) 		end_of_month,
									integer 						imp_sprd_dec,
									number option(nullable)			pv01_not_unit,										
									//ois1
									string	option(nullable) 	ois1_ccy,
									logical option(nullable)	ois1_is_mtm,
									number option(nullable)		ois1_cpn_freq_n,
									day_count_method  option(nullable) ois1_day_count,
									interest_rule option(nullable)	ois1_ir_rule,
									ir_index option(nullable)	ois1_ir_index,
									number option(nullable) 	ois1_notional ,
									number option(nullable) 	ois1_spread ,
									flt_comp_avg_type option(nullable)		ois1_comp_avg_t ,
									flt_sprd_comp_method option(nullable)	ois1_sprd_comp_m,
									flt_avg_method 	option(nullable)		ois1_avg_m,
									rfr_arrears_type  option(nullable)		ois1_arr_type,
									number option(nullable) 				ois1_arr_days ,
									number  option(nullable)	ois1_pmt_delay,
									number  option(nullable)	ois1_pmt_delay_prin,
									logical	option(nullable)	ois1_endog_df,
									logical option(nullable)	ois1_approx_calc,
									//ois2
									string	option(nullable) 	ois2_ccy,
									logical option(nullable)	ois2_is_mtm,
									number option(nullable)		ois2_cpn_freq_n,
									day_count_method  option(nullable) ois2_day_count,
									interest_rule option(nullable)	ois2_ir_rule,
									ir_index option(nullable)	ois2_ir_index,
									number option(nullable) 	ois2_notional ,
									number option(nullable) 	ois2_spread,
									flt_comp_avg_type option(nullable)		ois2_comp_avg_t ,
									flt_sprd_comp_method option(nullable)	ois2_sprd_comp_m,
									flt_avg_method 	option(nullable)		ois2_avg_m,
									rfr_arrears_type  option(nullable)		ois2_arr_type,
									number option(nullable) 				ois2_arr_days ,
									number  option(nullable)	ois2_pmt_delay,
									number  option(nullable)	ois2_pmt_delay_prin,
									logical	option(nullable)	ois2_endog_df,
									logical option(nullable)	ois2_approx_calc)
	{
		imp_calc_dec_  	= imp_sprd_dec;//rounding decimals of the implied cpn rate (on decimal value)
		pv01_not_unit_  = null(pv01_not_unit) ? -1: pv01_not_unit;//rounding unit for notional when implied from pv01

		if(null(ois1_ccy))
			ois1_ccy = op1_.ois_ccy_;

		if(null(ois2_ccy))
			ois2_ccy = op2_.ois_ccy_;
		
		is_ccy_ 		= !equal_casei(ois1_ccy, ois2_ccy);

		if(is_ccy_) {
			if(!null(ois1_is_mtm)) {
				is_mtm_leg1_ = ois1_is_mtm;
				if(is_mtm_leg1_)
					is_mtm_ = true;
			}
			if(!null(ois2_is_mtm) && ois2_is_mtm) {			
				is_mtm_ = true;
			}
		}
		
		number  ois1_mat_pmt_delay 		= ois1_pmt_delay;
		number  ois1_mat_pmt_delay_prin	= ois1_pmt_delay_prin;
		number  ois2_mat_pmt_delay 		= ois2_pmt_delay;
		number  ois2_mat_pmt_delay_prin	= ois2_pmt_delay_prin;
		
		op1_.set_plain(	pmt_bus_day, pmt_cal, end_of_month, ois1_ccy, ois1_cpn_freq_n, ois1_day_count,
						ois1_ir_rule,ois1_ir_index,ois1_spread,
						ois1_comp_avg_t , ois1_sprd_comp_m, ois1_avg_m, ois1_arr_type, ois1_arr_days,
						ois1_pmt_delay,ois1_mat_pmt_delay,ois1_pmt_delay_prin ,ois1_mat_pmt_delay_prin,
						ois1_endog_df,ois1_approx_calc, stub_type.SHORT_FIRST,null,null,null,
						ois1_notional,null,null,null,null,false);
		
		op2_.set_plain(	pmt_bus_day, pmt_cal, end_of_month, ois2_ccy, ois2_cpn_freq_n, ois2_day_count,
						ois2_ir_rule,ois2_ir_index,ois2_spread,
						ois2_comp_avg_t , ois2_sprd_comp_m, ois2_avg_m, ois2_arr_type, ois2_arr_days,
						ois2_pmt_delay,ois2_mat_pmt_delay,ois2_pmt_delay_prin ,ois2_mat_pmt_delay_prin,
						ois2_endog_df,ois2_approx_calc, stub_type.SHORT_FIRST,null,null,null,
						ois2_notional,null,null,null,null,false);
	}
	/*-----------------------------------------------------------------------
	  set_plain_single_ccy <ALL ARGS>
	  ----------------------------------------------------------------------*/
	void oisois_parm.set_plain_single_ccy(	string 						name,
											date option(nullable) 		trade_date,
											date option(nullable) 		settle_date,
											string option(nullable) 	spot_settle_code,
											date option(nullable) 		start_date,
											string option(nullable) 	fwd_start_code,
											date option(nullable) 		maturity,
											string option(nullable) 	maturity_code,
											logical 					pay_ois1,
											bd_convention option(nullable) 	pmt_bus_day,
											calendar option(nullable)	pmt_cal,
											logical	option(nullable) 	end_of_month,
											string	option(nullable) 	ccy,
											integer 					imp_sprd_dec,
											number 	option(nullable) 	pv01_not_unit,
											number	option(nullable) 	notional,
											number	option(nullable) 	ois1_pv01,
											//ois1
											number option(nullable)		ois1_cpn_freq_n,
											day_count_method  option(nullable) ois1_day_count,
											interest_rule option(nullable)	ois1_ir_rule,
											ir_index option(nullable)	ois1_ir_index,
											number option(nullable) 	ois1_spread ,
											avg_comp_method option(nullable) ois1_comp_avg,
											//flt_comp_avg_type option(nullable)		ois_comp_avg_t ,
											//flt_sprd_comp_method option(nullable)	ois_sprd_comp_m,
											//flt_avg_method 	option(nullable)		ois_avg_m,
											rfr_arrears_type  option(nullable)		ois1_arr_type,
											number option(nullable) 				ois1_arr_days ,
											number  option(nullable)	ois1_pmt_delay,
											logical	option(nullable)	ois1_endog_df,
											logical option(nullable)	ois1_approx_calc,
											//ois2													
											number option(nullable)		ois2_cpn_freq_n,
											day_count_method  option(nullable) ois2_day_count,
											interest_rule option(nullable)	ois2_ir_rule,
											ir_index option(nullable)	ois2_ir_index,
											number option(nullable) 	ois2_spread ,
											avg_comp_method option(nullable) ois2_comp_avg,
											//flt_comp_avg_type option(nullable)		ois_comp_avg_t ,
											//flt_sprd_comp_method option(nullable)	ois_sprd_comp_m,
											//flt_avg_method 	option(nullable)		ois_avg_m,
											rfr_arrears_type  option(nullable)		ois2_arr_type,
											number option(nullable) 				ois2_arr_days ,
											number  option(nullable)	ois2_pmt_delay,
											logical	option(nullable)	ois2_endog_df,
											logical option(nullable)	ois2_approx_calc)
	{
		if(null(notional))
			QL_REQUIRE(!null(ois1_pv01),"one of notional and pv01 must be input");
		else if(null(ois1_pv01))
			QL_REQUIRE(!null(notional),"one of notional and pv01 must be input");
		else if(!null(notional) && !null(ois1_pv01))
			QL_FAIL("ambigious input of notional and pv01");

		flt_comp_avg_type  ois1_comp_avg_t 		= null;
		flt_sprd_comp_method  ois1_sprd_comp_m 	= null;
		flt_avg_method  ois1_avg_m 				= null;
		if(!null(ois1_comp_avg)){
			conv_from_avg_comp_method(ois1_comp_avg,ois1_comp_avg_t,ois1_sprd_comp_m,ois1_avg_m);
		}

		flt_comp_avg_type  ois2_comp_avg_t 		= null;
		flt_sprd_comp_method  ois2_sprd_comp_m 	= null;
		flt_avg_method  ois2_avg_m 				= null;
		if(!null(ois2_comp_avg)){
			conv_from_avg_comp_method(ois2_comp_avg,ois2_comp_avg_t,ois2_sprd_comp_m,ois2_avg_m);
		}
		
		this.__set_plain(pmt_bus_day,pmt_cal,end_of_month,imp_sprd_dec,pv01_not_unit,ccy,false,
						ois1_cpn_freq_n,ois1_day_count,ois1_ir_rule,ois1_ir_index,notional,ois1_spread,
						 ois1_comp_avg_t , ois1_sprd_comp_m, ois1_avg_m, ois1_arr_type, ois1_arr_days,
						ois1_pmt_delay,ois1_pmt_delay,ois1_endog_df,ois1_approx_calc,
						ccy,false,ois2_cpn_freq_n,ois2_day_count,ois2_ir_rule,ois2_ir_index,notional,ois2_spread,
						 ois2_comp_avg_t , ois2_sprd_comp_m, ois2_avg_m, ois2_arr_type, ois2_arr_days,
						 ois2_pmt_delay,ois2_pmt_delay,ois2_endog_df,ois2_approx_calc);

		//-----common--------
		name_ 			= name;
		pay_leg1_		= pay_ois1;
		is_ccy_ 		= false;
		if(!null(spot_settle_code))
			spot_code_ 	= spot_settle_code;
		trade_date_ 	= trade_date;
		fwd_start_code_ = fwd_start_code;
		start_date_ 	= start_date;
		maturity_ 		= maturity;
		if(!null(maturity_code))
			maturity_code_ 	= maturity_code;
		settle_date_	= settle_date;
		//cpn_roll_day_ 	= 0;

		this.start_date_helper();
		this.maturity_helper(op1_);
		this.check();
		//if single ccy set_pv01/set_notional will also set the other notional as well as both fxrates to 1
		if(null(notional))
			this.set_pv01(ois1_pv01);
		else
			this.set_notional_leg1(notional);
		ne_ = notional_exchg_style.NE_NONE;
		is_inited_ = true;
	}

	/*-----------------------------------------------------------------------
	  set_plain_single_ccy
	  ----------------------------------------------------------------------*/
	void oisois_parm.set_plain_single_ccy(	string 						name,
											date option(nullable) 		trade_date,
											date option(nullable) 		settle_date,											
											date option(nullable) 		start_date,
											string option(nullable) 	fwd_start_code,
											date option(nullable) 		maturity,
											string option(nullable) 	maturity_code,
											logical 					pay_ois1,
											integer 					imp_sprd_dec,
											number 	option(nullable) 	pv01_not_unit,
											number	option(nullable) 	notional,
											number	option(nullable) 	ois1_pv01,
											//ois1
											number option(nullable) 	ois1_spread ,
											//ois2
											number option(nullable) 	ois2_spread )
	{
		QL_FAIL_COND(null(is_ccy_),"oisois_parm is not initalized (init_static() must be run) ");
		QL_REQUIRE(!is_ccy_,"function not applicable to cross currency swaps");
		
		if(null(notional))
			QL_REQUIRE(!null(ois1_pv01),"one of notional and pv01 must be input");
		else if(null(ois1_pv01))
			QL_REQUIRE(!null(notional),"one of notional and pv01 must be input");
		else if(!null(notional) && !null(ois1_pv01))
			QL_FAIL("ambigious input of notional and pv01");

		
		this.__set_plain(	null,null,null,imp_sprd_dec,pv01_not_unit,null,false,
							null,null,null,null,notional,ois1_spread,
							null,null,null,null, null,
							null,null,null,null, null,false,null,null,null,null,notional,ois2_spread,
							null,null,null,null, null,
							null,null,null, null);

		//-----common--------
		name_ 			= name;
		pay_leg1_		= pay_ois1;
	
		trade_date_ 	= trade_date;
		fwd_start_code_ = fwd_start_code;
		start_date_ 	= start_date;
		maturity_ 		= maturity;
		if(!null(maturity_code))
			maturity_code_ 	= maturity_code;
		settle_date_	= settle_date;
		//cpn_roll_day_ 	= 0;

		this.start_date_helper();
		this.maturity_helper(op1_);
		this.check();
		//if single ccy set_pv01/set_notional will also set the other notional as well as both fxrates to 1
		if(null(notional))
			this.set_pv01(ois1_pv01);
		else
			this.set_notional_leg1(notional);
		
		is_inited_ = true;
	}

	/*-----------------------------------------------------------------------
	  set_plain <ALL ARGS>
	  ----------------------------------------------------------------------*/
	void oisois_parm.set_plain(	string 							name,								
								date option(nullable) 			trade_date,
								date option(nullable) 			settle_date,
								string option(nullable) 		spot_settle_code,
								date option(nullable) 			start_date,
								string option(nullable) 		fwd_start_code,
								date option(nullable)			maturity,
								string option(nullable) 		maturity_code,
								logical 						pay_ois1,
								bd_convention option(nullable)	pmt_bus_day,
								calendar option(nullable)		pmt_cal,
								logical	 option(nullable)		end_of_month,
								notional_exchg_style option(nullable) notional_exchg,
								integer 						imp_sprd_dec,
								number 	option(nullable) 		pv01_not_unit,
								number 	option(nullable) 		fx_quote,
								string 	option(nullable) 		fx_quote_baseccy,
								string 	option(nullable) 		fx_quote_priceccy,
								logical option(nullable) 		pv_in_base_ccy,
								//ois1
								string	option(nullable)		ois1_ccy,
								logical	option(nullable)		ois1_is_mtm,
								number option(nullable)	 		ois1_cpn_freq_n,
								day_count_method  option(nullable) ois1_day_count,
								interest_rule option(nullable) 	ois1_ir_rule ,
								ir_index option(nullable)		ois1_ir_index,
								number option(nullable) 		ois1_spread,
								avg_comp_method option(nullable) ois1_comp_avg,
											//flt_comp_avg_type option(nullable)		ois_comp_avg_t ,
											//flt_sprd_comp_method option(nullable)	ois_sprd_comp_m,
											//flt_avg_method 	option(nullable)		ois_avg_m,
								rfr_arrears_type  option(nullable)		ois1_arr_type,
								number option(nullable) 				ois1_arr_days ,
								number  option(nullable)		ois1_pmt_delay,
								number  option(nullable)		ois1_pmt_delay_prin,
								logical	option(nullable)		ois1_endog_df,
								logical option(nullable)		ois1_approx_calc,
								stub_type option(nullable)		ois1_stub_type,
								date option(nullable)  			ois1_eff_date,
								date option(nullable)  			ois1_first_cpn_date,
								date option(nullable)  			ois1_last_reg_date,
								number	option(nullable) 		ois1_notional,
								number	option(nullable) 		ois1_pv01,
								vector(date) option(nullable) 	ois1_fixing_dates ,	
								vector(number) option(nullable) ois1_fixing_rates,
								number option(nullable) 		ois1_fix_proxy ,
								logical option(nullable) 		ois1_allow_fwd_fix,
								//ois2
								string	option(nullable) 		ois2_ccy,
								logical	option(nullable)		ois2_is_mtm,
								number option(nullable)	 		ois2_cpn_freq_n,
								day_count_method  option(nullable) ois2_day_count,
								interest_rule option(nullable) 	ois2_ir_rule ,
								ir_index option(nullable)		ois2_ir_index,
								number option(nullable) 		ois2_spread,
								avg_comp_method option(nullable) ois2_comp_avg,
											//flt_comp_avg_type option(nullable)		ois_comp_avg_t ,
											//flt_sprd_comp_method option(nullable)	ois_sprd_comp_m,
											//flt_avg_method 	option(nullable)		ois_avg_m,
								rfr_arrears_type  option(nullable)		ois2_arr_type,
								number option(nullable) 				ois2_arr_days ,
								number  option(nullable)		ois2_pmt_delay,
								number  option(nullable)		ois2_pmt_delay_prin,
								logical	option(nullable)		ois2_endog_df,
								logical option(nullable)		ois2_approx_calc,
								stub_type option(nullable)		ois2_stub_type,
								date option(nullable)  			ois2_eff_date,
								date option(nullable)  			ois2_first_cpn_date,
								date option(nullable)  			ois2_last_reg_date,
								number	option(nullable) 		ois2_notional,
								vector(date) option(nullable) 	ois2_fixing_dates ,	
								vector(number) option(nullable) ois2_fixing_rates,
								number option(nullable) 		ois2_fix_proxy ,
								logical option(nullable) 		ois2_allow_fwd_fix)
	{
		if(null(ois1_notional) && null(ois2_notional))
			QL_REQUIRE(!null(ois1_pv01),"one of notionals and ois1_pv01 must be input");
		else if(null(ois1_pv01))
			QL_REQUIRE(!null(ois1_notional) || !null(ois2_notional),"one of notionals and ois1_pv01 must be input");
		else if(!null(ois1_notional) && !null(ois2_notional) && !null(ois1_pv01))
			QL_FAIL("ambigious input of notionals and ois1_pv01");

		if(null(ois1_ccy))
			ois1_ccy = op1_.ois_ccy_ ;
		
		if(null(ois2_ccy))
			ois2_ccy = op2_.ois_ccy_ ;
		
		number 	ois1_fx_mult, ois2_fx_mult;
		set_fx_input(ois1_ccy,ois2_ccy, fx_quote, fx_quote_baseccy, fx_quote_priceccy, pv_in_base_ccy, ois1_notional,ois2_notional,ois1_fx_mult, ois2_fx_mult);

	
		number  ois1_mat_pmt_delay = ois1_pmt_delay;
		number  ois1_mat_pmt_delay_prin= ois1_pmt_delay_prin;
		number  ois2_mat_pmt_delay = ois2_pmt_delay;
		number  ois2_mat_pmt_delay_prin= ois2_pmt_delay_prin;
		
		//----ois1_parm-----
		flt_comp_avg_type  ois1_comp_avg_t 		= null;
		flt_sprd_comp_method  ois1_sprd_comp_m 	= null;
		flt_avg_method  ois1_avg_m 				= null;
		if(!null(ois1_comp_avg)){
			conv_from_avg_comp_method(ois1_comp_avg,ois1_comp_avg_t,ois1_sprd_comp_m,ois1_avg_m);
		}
		op1_.set_plain(	pmt_bus_day, pmt_cal, end_of_month, ois1_ccy, ois1_cpn_freq_n, ois1_day_count,
						ois1_ir_rule,ois1_ir_index, ois1_spread,
						ois1_comp_avg_t , ois1_sprd_comp_m, ois1_avg_m, ois1_arr_type, ois1_arr_days,
						ois1_pmt_delay,ois1_mat_pmt_delay,ois1_pmt_delay_prin ,ois1_mat_pmt_delay_prin,
						ois1_endog_df,ois1_approx_calc,ois1_stub_type,ois1_eff_date, ois1_first_cpn_date,
						ois1_last_reg_date, ois1_notional, ois1_fx_mult,
						ois1_fixing_dates ,ois1_fixing_rates,ois1_fix_proxy ,ois1_allow_fwd_fix);	
		
		//----ois2_parm--------
		flt_comp_avg_type  ois2_comp_avg_t 		= null;
		flt_sprd_comp_method  ois2_sprd_comp_m 	= null;
		flt_avg_method  ois2_avg_m 				= null;
		if(!null(ois2_comp_avg)){
			conv_from_avg_comp_method(ois2_comp_avg,ois2_comp_avg_t,ois2_sprd_comp_m,ois2_avg_m);
		}
		op2_.set_plain(	pmt_bus_day, pmt_cal, end_of_month, ois2_ccy, ois2_cpn_freq_n, ois2_day_count,
						ois2_ir_rule,ois2_ir_index, ois2_spread,
						ois2_comp_avg_t , ois2_sprd_comp_m, ois2_avg_m, ois2_arr_type, ois2_arr_days,
						ois2_pmt_delay,ois2_mat_pmt_delay,ois2_pmt_delay_prin ,ois2_mat_pmt_delay_prin,
						ois2_endog_df,ois2_approx_calc,ois2_stub_type,ois2_eff_date, ois2_first_cpn_date,
						ois2_last_reg_date, ois2_notional, ois2_fx_mult,
						ois2_fixing_dates ,ois2_fixing_rates,ois2_fix_proxy ,ois2_allow_fwd_fix);
		
		//---common---
		name_ 			= name;
		imp_calc_dec_  	= imp_sprd_dec;
		pv01_not_unit_  = null(pv01_not_unit) ? -1: pv01_not_unit;
		pay_leg1_		= pay_ois1;
		
		if(null(notional_exchg)) {
			if(null(ne_))
				ne_ = is_ccy_ ? notional_exchg_style.NE_BOTH : notional_exchg_style.NE_NONE;
		}
		else {
			ne_ = notional_exchg;
		}

		if(!null(spot_settle_code))
			spot_code_ 	= spot_settle_code;
		trade_date_ 	= trade_date;
		fwd_start_code_ = fwd_start_code;
		start_date_ 	= start_date;
		maturity_ 		= maturity;
		if(!null(maturity_code))
			maturity_code_ 	= maturity_code;
		settle_date_	= settle_date;
		//cpn_roll_day_ 	= 0;
		if(!null(ois1_is_mtm)) {
			is_mtm_leg1_ = ois1_is_mtm;
			if(is_mtm_leg1_)
				is_mtm_ = true;
		}
		if(!null(ois2_is_mtm) && ois2_is_mtm) {			
			is_mtm_ = true;
		}
		//QL_FAIL_COND(is_mtm_ && is_mtm_leg1_,"mtm is only supported on leg2");
		
		this.start_date_helper();
		this.maturity_helper(op1_);
		this.schedule_helper(op1_);
		this.schedule_helper(op2_);
		this.check();
		//if single ccy set_pv01/set_notional will also set the other notional as well as both fxrates to 1
		if(null(ois1_notional) && null(ois2_notional)){
			this.set_pv01(ois1_pv01);
		}
		else if(!null(ois1_notional)){
			this.set_notional_leg1(ois1_notional);
		}
		else if(!null(ois2_notional)){
			this.set_notional_leg2(ois2_notional);
		}
		is_inited_ = true;
	}
	/*-----------------------------------------------------------------------
	  set_plain 
	  ----------------------------------------------------------------------*/
	void oisois_parm.set_plain(	string 							name,								
								date option(nullable) 			trade_date,
								date option(nullable) 			settle_date,
								
								date option(nullable) 			start_date,
								string option(nullable) 		fwd_start_code,
								date option(nullable)			maturity,
								string option(nullable) 		maturity_code,
								logical 						pay_ois1,
								integer 						imp_sprd_dec,
								number 	option(nullable) 		pv01_not_unit,
								number 	option(nullable) 		fx_quote,
								string 	option(nullable) 		fx_quote_baseccy,
								string 	option(nullable) 		fx_quote_priceccy,
								logical option(nullable) 		pv_in_base_ccy,
								//ois1
								number option(nullable) 		ois1_spread,
								stub_type option(nullable)		ois1_stub_type,
								date option(nullable)  			ois1_eff_date,
								date option(nullable)  			ois1_first_cpn_date,
								date option(nullable)  			ois1_last_reg_date,
								number	option(nullable) 		ois1_notional,
								number	option(nullable) 		ois1_pv01,
								vector(date) option(nullable) 	ois1_fixing_dates ,	
								vector(number) option(nullable) ois1_fixing_rates,
								number option(nullable) 		ois1_fix_proxy ,
								logical option(nullable) 		ois1_allow_fwd_fix,
								//ois2
								number option(nullable) 		ois2_spread,
								stub_type option(nullable)		ois2_stub_type,
								date option(nullable)  			ois2_eff_date,
								date option(nullable)  			ois2_first_cpn_date,
								date option(nullable)  			ois2_last_reg_date,
								number	option(nullable) 		ois2_notional,
								vector(date) option(nullable) 	ois2_fixing_dates ,	
								vector(number) option(nullable) ois2_fixing_rates,
								number option(nullable) 		ois2_fix_proxy ,
								logical option(nullable) 		ois2_allow_fwd_fix)
	{
		QL_FAIL_COND(null(is_ccy_),"oisois_parm is not initalized (init_static() must be run) ");
		
		if(null(ois1_notional) && null(ois2_notional))
			QL_REQUIRE(!null(ois1_pv01),"one of notionals and ois1_pv01 must be input");
		else if(null(ois1_pv01))
			QL_REQUIRE(!null(ois1_notional) || !null(ois2_notional),"one of notionals and ois1_pv01 must be input");
		else if(!null(ois1_notional) && !null(ois2_notional) && !null(ois1_pv01))
			QL_FAIL("ambigious input of notionals and ois1_pv01");
		
		number 	ois1_fx_mult, ois2_fx_mult;
		set_fx_input(op1_.ois_ccy_,op2_.ois_ccy_, fx_quote, fx_quote_baseccy, fx_quote_priceccy, pv_in_base_ccy, ois1_notional,ois2_notional,ois1_fx_mult, ois2_fx_mult);

		//----ois1_parm-----
		op1_.set_plain(	null, null, null, null, null, null,
						null, null,ois1_spread,null,null,null ,null,null,
						null,null,null ,null,
						null,null,ois1_stub_type,ois1_eff_date, ois1_first_cpn_date,
						ois1_last_reg_date, ois1_notional, ois1_fx_mult,
						ois1_fixing_dates ,ois1_fixing_rates,ois1_fix_proxy ,ois1_allow_fwd_fix);	
		
		//----ois2_parm--------
		op2_.set_plain(	null, null, null, null, null, null,
						null, null,ois2_spread,null,null,null ,null,null,
						null,null,null ,null,
						null,null,ois2_stub_type,ois2_eff_date, ois2_first_cpn_date,
						ois2_last_reg_date, ois2_notional, ois2_fx_mult,
						ois2_fixing_dates ,ois2_fixing_rates,ois2_fix_proxy ,ois2_allow_fwd_fix);
		
		//---common---
		name_ 			= name;
		imp_calc_dec_  	= imp_sprd_dec;
		pv01_not_unit_  = null(pv01_not_unit) ? -1: pv01_not_unit;
		pay_leg1_		= pay_ois1;

		trade_date_ 	= trade_date;
		fwd_start_code_ = fwd_start_code;
		start_date_ 	= start_date;
		maturity_ 		= maturity;
		if(!null(maturity_code))
			maturity_code_ 	= maturity_code;
		settle_date_	= settle_date;
		//cpn_roll_day_ 	= 0;
	
		//QL_FAIL_COND(is_mtm_ && is_mtm_leg1_,"mtm is only supported on leg2");
		
		this.start_date_helper();
		this.maturity_helper(op1_);
		this.schedule_helper(op1_);
		this.schedule_helper(op2_);
		this.check();
		//if single ccy set_pv01/set_notional will also set the other notional as well as both fxrates to 1
		if(null(ois1_notional) && null(ois2_notional)){
			this.set_pv01(ois1_pv01);
		}
		else if(!null(ois1_notional)){
			this.set_notional_leg1(ois1_notional);
		}
		else if(!null(ois2_notional)){
			this.set_notional_leg2(ois2_notional);
		}
		
		is_inited_ = true;
	}
	/*-----------------------------------------------------------------------
	  primary_quote_is_leg1  CHECK
	  ----------------------------------------------------------------------*/
	logical oisois_parm.primary_quote_is_leg1()
	{
		return leg1_is_primary_quote(CORE_INT.conv_rev_instr_type(type()),op1_.ois_ccy_,op2_.ois_ccy_, 365, 365);
	}
}