option(null: hard);	

/*	
	swaplib wrapper functions
	Developer: Algorithmica Research, Magnus Nyström

	--------------------------------------------------------------------
	 	swap help functions for create funcs
	--------------------------------------------------------------------			
*/
module CORE_SWAPLIB
{
	/*-----------------------------------------------------------------------
	 -----------------------------------------------------------------------
	 -----class ois_parm--------------------------------------------------
	 -----------------------------------------------------------------------
	 -----------------------------------------------------------------------*/
	class ois_parm
	{
	public:
		ois_parm();
		
		void	init_def_parm( 	string option(nullable), coupon_freq  option(nullable), calendar  option(nullable), bd_convention option(nullable) ,
								logical	option(nullable) ,day_count_method option(nullable),ir_index option(nullable) ,flt_comp_avg_type option(nullable) ,
								flt_sprd_comp_method option(nullable),flt_avg_method option(nullable) ,round_code option(nullable) ,round_code 	option(nullable) ,
								round_code  option(nullable) ,interest_rule option(nullable),number option(nullable),number option(nullable) ,
								number option(nullable) ,number option(nullable) ,rfr_arrears_type option(nullable) ,number option(nullable) ,
								logical option(nullable) ,flt_roll_method option(nullable) ,logical  option(nullable) ,number 	option(nullable)  ,
								number option(nullable) ,number option(nullable)  );
	
		void	init_leg_parm(	number option(nullable) ,stub_type option(nullable) ,date option(nullable),date option(nullable)  ,
								date option(nullable) ,number 	option(nullable) ,vector(date) option(nullable) ,vector(number) option(nullable) ,
								number 	option(nullable) ,logical option(nullable) ,number	option(nullable) ,logical option(nullable) );

		void	basic_static_null_check(out bd_convention,out calendar ,out logical ,out string	,number option(nullable) ,
										out coupon_freq ,out day_count_method ,out ir_index,out interest_rule ,out number ,out number ,out number ,
										out number, out logical, out logical,out logical ,
										out flt_comp_avg_type 	,
										out flt_sprd_comp_method ,
										out flt_avg_method 	,
										out rfr_arrears_type ,
										out number 	);

		void 	init_basic_static_leg1(instr_def );
		void 	init_basic_static_leg2(instr_def );
		void	init_static(	bd_convention,calendar,logical,string,integer ,day_count_method,interest_rule ,ir_index,
								flt_comp_avg_type option(nullable), flt_sprd_comp_method option(nullable),flt_avg_method option(nullable),
								number,number,number,number,rfr_arrears_type option(nullable) ,number option(nullable) ,logical ,logical, logical option(nullable),
								flt_roll_method option(nullable) );
		
		
		ql_swap_ois_def create_swap_ois_def(string ,date_code,notional_exchg_style);
		ql_ois_leg 		create_swap_ois_leg(ql_swap_ois_def ,string ,logical ,disc_func option(nullable),
											tenor_surface option(nullable),
											date option(nullable),date option(nullable),date option(nullable) ,date option(nullable),
											tenor_code option(nullable) );
		ql_ois_leg 		create_swap_ois_mtm_leg(ql_swap_ois_def 	ois_def,
													string 				name,
													logical 			pay,
													disc_func 	option(nullable)		ois_disc_func,
													tenor_surface option(nullable)		ois_tenor_surface,
													date option(nullable)	trade_date,
													date option(nullable)settle_date,
													date option(nullable) start_date,
													date option(nullable) maturity ,
													tenor_code option(nullable) mat_code,
													integer 			cpn_roll_day,
													number 				opp_leg_fx_mult,
													disc_func option(nullable) opp_leg_disc_func,
													number 				opp_leg_notional, string,												
													calendar				opp_leg_cal,
													calendar option(nullable) usd_calendar, number option(nullable) );
		
	
		//void 	set_plain_vanilla(logical);

		/*void 	set_plain(	bd_convention option(nullable) 	pmt_bus_day,
							calendar option(nullable)	pmt_cal,
							logical	option(nullable) 	end_of_month,
							string	option(nullable) 	ccy,																								
							number option(nullable)		cpn_freq_n,
							day_count_method  option(nullable) _day_count,
							
							interest_rule option(nullable)	ir_rule,
							ir_index option(nullable)	ir_index ,
							number option(nullable)		spread,
							number option(nullable),
							number option(nullable),
							number option(nullable),
							number option(nullable),
							logical	option(nullable)		endog_df,
							logical option(nullable)		approx_calc, logical);*/

		void	set_plain(	bd_convention option(nullable)	pmt_bus_day,
							calendar option(nullable)		pmt_cal,
							logical	 option(nullable)		end_of_month,
							string	 option(nullable)		ccy,
							number option(nullable)	 		cpn_freq_n,
							day_count_method  option(nullable) day_count,
							interest_rule option(nullable)	ir_rule,
							ir_index option(nullable)		ir_index,								
							number option(nullable) 		spread,

							flt_comp_avg_type option(nullable)  	comp_avg_type,
							flt_sprd_comp_method option(nullable) 	sprd_comp_method,
							flt_avg_method option(nullable)   		avg_method,
							rfr_arrears_type option(nullable)  		arr_type,
							number option(nullable)  				arr_days,
							
							number option(nullable)			pmt_delay ,
							number option(nullable)			mat_pmt_delay ,
							number option(nullable)			pmt_delay_prin ,
							number option(nullable)			mat_pmt_delay_prin,
							logical	option(nullable)		endog_df,
							logical option(nullable)		approx_calc,
							//leg
							stub_type option(nullable)		stub_t,								
							date option(nullable)  			eff_date,
							date option(nullable)  			first_cpn_date,
							date option(nullable)  			last_reg_date,
							number	option(nullable) 		notional,
							number	option(nullable)		fx_mult,							
							vector(date) option(nullable) 	fixing_dates ,	
							vector(number) option(nullable) fixing_rates,
							number option(nullable) 		fix_proxy ,
							logical option(nullable) 		allow_fwd_fix);

		void ois_df_helper( disc_func option(nullable) 	ois_disc_func,
								fwd_func option(nullable) 	ois_fwd_func,
								disc_func option(nullable) 	ois_fwd_disc_func,
								disc_func option(nullable) 	rev_disc_func,
								logical is_cross_currency,
								logical rev_leg_prio,
								logical sync_endog_ok,
								date option(nullable) td,
								date m,
								out disc_func 	o1df,
								out fwd_func 	o1f,
								out disc_func 	o1fdf,
								out disc_func 	dfr2);
		
		bd_convention 		ois_pmt_bus_day_mat();
		//def
		string 				ois_ccy_;
		coupon_freq  		ois_cpn_freq_;		
		calendar 			ois_pmt_calendar_;
		bd_convention 		ois_pmt_bus_day_;
		logical				ois_end_of_month_;
		day_count_method 	ois_dc_;
		ir_index 			ois_ir_index_;
		flt_comp_avg_type 	ois_ca_t_;
		flt_sprd_comp_method ois_comp_m_;
		flt_avg_method 		ois_avg_;
		round_code			ois_pv_round_code_;
		round_code 			ois_comp_factor_round_code_;
		round_code  		ois_imp_rate_pcnt_round_code_; 							
		interest_rule  		ois_ir_rule_;															
		number  			ois_pmt_delay_;
		number  			ois_mat_pmt_delay_;
		number  			ois_pmt_delay_prin_;
		number  			ois_mat_pmt_delay_prin_;
		rfr_arrears_type  	ois_arr_type_;
		number  			ois_arr_days_;
		logical 			ois_endog_df_;		
		flt_roll_method		ois_roll_;
		logical 			ois_average_notional_;
		number 				ois_sub_factor_;
		number 				ois_multi_factor_;
		number 				ois_power_factor_;
		
		//leg
		stub_type			ois_stub_type_;
		date 				ois_eff_date_;
		date 				ois_first_cpn_date_;
		date 				ois_last_reg_date_;
		number 				ois_spread_;
		vector(date) 		ois_fixing_dates_;	
		vector(number) 		ois_fixing_rates_;
		number 				ois_fix_proxy_;
		logical 			ois_allow_fwd_fix_;
		number 				ois_notional_;
		number				ois_fx_mult_;
		logical 			ois_is_approx_calc_;

		integer 			ois_roll_day_;
	};

	/*-----------------------------------------------------------------------
	  ois_parm constructor
	  ----------------------------------------------------------------------*/
	ois_parm.ois_parm():ois_ccy_(null),
						ois_cpn_freq_(null),		
						ois_pmt_calendar_(null),
						ois_pmt_bus_day_(null),
						ois_end_of_month_(null),
						ois_dc_(null),
						ois_ir_index_(null),
						ois_ca_t_(null),
						ois_comp_m_(null),
						ois_avg_(null),
						ois_pv_round_code_(null),
						ois_comp_factor_round_code_(null),
						ois_imp_rate_pcnt_round_code_(null), 							
						ois_ir_rule_(null),															
						ois_pmt_delay_(null),
						ois_mat_pmt_delay_(null),
						ois_pmt_delay_prin_(null),
						ois_mat_pmt_delay_prin_(null),
						ois_arr_type_(null),
						ois_arr_days_(null),
						ois_endog_df_(null),		
						ois_roll_(null),
						ois_average_notional_(null),
						ois_sub_factor_(null),
						ois_multi_factor_(null),
						ois_power_factor_(null),				
						ois_stub_type_(null),
						ois_eff_date_(null),
						ois_first_cpn_date_(null),
						ois_last_reg_date_(null),
						ois_spread_(null),
						ois_fixing_dates_(null),	
						ois_fixing_rates_(null),
						ois_fix_proxy_(null),
						ois_allow_fwd_fix_(null),
						ois_notional_(null),
						ois_fx_mult_(null),
						ois_is_approx_calc_(null),
						ois_roll_day_(0)
	{}
		
	bd_convention 		ois_parm.ois_pmt_bus_day_mat() { return ois_pmt_bus_day_;}
	/*-----------------------------------------------------------------------
	  create_swap_ois_def
	  ----------------------------------------------------------------------*/
	ql_swap_ois_def ois_parm.create_swap_ois_def(string 		name,
												 date_code 		settle_code,
												 notional_exchg_style ne)
	{
		return ql_swap_ois_def(name, ois_ccy_, settle_code, ois_cpn_freq_, ois_dc_,ois_roll_,ois_pmt_bus_day_, ois_pmt_calendar_,
							   ois_end_of_month_,ois_ir_index_, null<quote_style>,ois_pv_round_code_,
								ois_comp_factor_round_code_,ois_imp_rate_pcnt_round_code_, ois_ir_rule_, 															
								ois_pmt_delay_, ois_mat_pmt_delay_, ois_pmt_delay_prin_, ois_mat_pmt_delay_prin_,
								ois_arr_type_,ois_arr_days_, ois_ca_t_, ois_comp_m_, ois_avg_,
								ne,ois_average_notional_,ois_sub_factor_,
								ois_multi_factor_,ois_power_factor_, ois_endog_df_);

	}
	/*-----------------------------------------------------------------------
	  create_swap_ois_leg
	  ----------------------------------------------------------------------*/
	ql_ois_leg ois_parm.create_swap_ois_leg(ql_swap_ois_def 		ois_def,
											string 					name,
											logical 				pay,
											disc_func option(nullable)		ois_disc_func,
											tenor_surface option(nullable)	ois_tenor_surface,
											date option(nullable)	trade_date,
											date option(nullable)	settle_date,
											date option(nullable) 	start_date,
											date option(nullable)	maturity ,
											tenor_code option(nullable)	mat_code/*,
											integer 				cpn_roll_day*/)
	{
		return ql_ois_leg(	ois_def,name,trade_date,settle_date,start_date,maturity,mat_code,
							pay,ois_notional_,ois_eff_date_,ois_first_cpn_date_,ois_last_reg_date_,
							null(ois_spread_) ? 0 : ois_spread_,
							ois_disc_func,ois_tenor_surface,ois_roll_day_,ois_fx_mult_,
							ois_fixing_dates_,ois_fixing_rates_,ois_fix_proxy_,ois_allow_fwd_fix_,
							ois_is_approx_calc_);
	}

	/*-----------------------------------------------------------------------
	  create_swap_float_mtm_leg
	  ----------------------------------------------------------------------*/
	ql_ois_leg ois_parm.create_swap_ois_mtm_leg(ql_swap_ois_def 		ois_def,
												string 					name,
												logical 				pay,
												disc_func option(nullable)		ois_disc_func,
												tenor_surface option(nullable) 	ois_tenor_surface,
												date option(nullable)	trade_date,
												date option(nullable)	settle_date,
												date option(nullable) 	start_date,
												date option(nullable) 	maturity ,
												tenor_code option(nullable) mat_code,
												integer 				cpn_roll_day,
												number 					opp_leg_fx_mult,
												disc_func option(nullable) opp_leg_disc_func,
												number 					opp_leg_notional,
												string					opp_leg_ccy,
												calendar				opp_leg_cal,
												calendar option(nullable) usd_calendar,
												number option(nullable) mtm_fx_spot_rate)
	{
		//base_ccy == reset_leg ccy
		//ex USD = reset_leg, SEK is constant leg --> fxrate is USDSEK
		//pv_in_sek --> this.flt_fx_mult(USD)_ = 10 and opp_leg_fx_mult(SEK) = 1 --> mtm_fx = 10/1
		
		//date ois_mtm_fx_date 				= settle_date;//fx_spot_date; 
		//number ois_mtm_fx_spot_rate_res_base = this.ois_fx_mult_/ opp_leg_fx_mult;//resetleg ccy is baseccy, may not be equal to the fx spot date
		vector(date) ois_mtm_fx_fix_dates 	= null<vector(date)>;
		vector(number) ois_mtm_fx_fix 		= null<vector(number)>;
		number ois_mtm_fx_fix_proxy 		= null;
		logical ois_mtm_fx_fix_as_fwd 		= false;

		integer ois_mtm_fx_spot_days;
		fx_spot_rule fx_rule;
		
		if(null(mtm_fx_spot_rate)) {
			date fx_spot_dt;
		
			CORE_INT_SWAPLIB.mtm_data(trade_date,ois_def.currency(), ois_def.calendar(),
								  opp_leg_ccy, opp_leg_cal,
								  usd_calendar, ois_mtm_fx_spot_days, fx_rule, fx_spot_dt);
		
			logical settle_is_spot = !null(settle_date) && !null(fx_spot_dt) && settle_date == fx_spot_dt;
			
			if(settle_is_spot) {
				mtm_fx_spot_rate = this.ois_fx_mult_/opp_leg_fx_mult;//resetleg ccy is baseccy
			}
		}
		else {
			ois_mtm_fx_spot_days 	= fx_spot_days_dflt(ois_def.currency(), opp_leg_ccy);
			fx_rule					= fx_spot_rule_dflt(ois_def.currency(), opp_leg_ccy, usd_calendar);
		}
		
		return  ql_ois_leg(ois_def,name,trade_date,settle_date,start_date,maturity,mat_code,
							pay,ois_notional_,ois_eff_date_,ois_first_cpn_date_,ois_last_reg_date_,
							null(ois_spread_) ? 0 : ois_spread_,
							ois_disc_func, ois_tenor_surface,cpn_roll_day,ois_fx_mult_,
							ois_fixing_dates_,ois_fixing_rates_,
							ois_fix_proxy_,ois_allow_fwd_fix_,
							//mtm	 
							//ois_mtm_fx_date,
							mtm_fx_spot_rate,
						    ois_mtm_fx_spot_days,
						   opp_leg_ccy,
						   opp_leg_cal,
						   fx_rule,
						   usd_calendar,
							ois_disc_func,
							opp_leg_disc_func,
							opp_leg_notional,
						    ois_mtm_fx_fix_dates,
							ois_mtm_fx_fix,
							ois_mtm_fx_fix_proxy,
							ois_mtm_fx_fix_as_fwd);
				 
	}
	/*-----------------------------------------------------------------------
	  init_def_parm
	  ----------------------------------------------------------------------*/
	void ois_parm.init_def_parm( string option(nullable) ccy,
								coupon_freq  option(nullable) cpn_freq ,		
								calendar option(nullable) pmt_calendar,
								bd_convention option(nullable) pmt_bus_day,
								logical	option(nullable) end_of_month,
								day_count_method option(nullable) dc,
								ir_index option(nullable) ir_index,
								flt_comp_avg_type option(nullable) ca_t,
								flt_sprd_comp_method option(nullable) comp_m,
								flt_avg_method 	option(nullable) avg,
								round_code option(nullable) pv_round_code,
								round_code option(nullable) comp_factor_round_code ,
								round_code option(nullable) imp_rate_pcnt_round_code, 							
								interest_rule  	option(nullable) ir_rule ,
								number  option(nullable) pmt_delay ,
								number  option(nullable) mat_pmt_delay ,
								number  option(nullable) pmt_delay_prin ,
								number  option(nullable) mat_pmt_delay_prin ,
								rfr_arrears_type  option(nullable) arr_type ,
								number  option(nullable) arr_days,
								logical option(nullable) endog_df,		
								flt_roll_method	option(nullable) roll,
								logical option(nullable) average_notional ,
								number 	option(nullable) sub_factor ,
								number 	option(nullable) multi_factor ,
								number 	option(nullable) power_factor )
	{
		ois_ccy_ 			= ccy;
		ois_cpn_freq_  		= cpn_freq;		
		ois_pmt_calendar_ 	= pmt_calendar;
		ois_pmt_bus_day_ 	= pmt_bus_day;
		ois_end_of_month_ 	= end_of_month;
		ois_dc_ 			= dc;
		ois_ir_index_ 		= ir_index;
		ois_ca_t_ 			= ca_t;
		ois_comp_m_ 		= comp_m;
		ois_avg_ 			= avg;
		ois_pv_round_code_ 	= pv_round_code;
		ois_comp_factor_round_code_ 	= comp_factor_round_code;
		ois_imp_rate_pcnt_round_code_ 	= imp_rate_pcnt_round_code; 							
		ois_ir_rule_  		= ir_rule;															
		ois_pmt_delay_  	= pmt_delay;
		ois_mat_pmt_delay_  = mat_pmt_delay;
		ois_pmt_delay_prin_ = pmt_delay_prin;
		ois_mat_pmt_delay_prin_ = mat_pmt_delay_prin;
		ois_arr_type_  		= arr_type;
		ois_arr_days_ 		= arr_days ;
		ois_endog_df_ 		= endog_df;		
		ois_roll_			= roll;
		ois_average_notional_ = average_notional;
		ois_sub_factor_  	= sub_factor;
		ois_multi_factor_  = multi_factor;
		ois_power_factor_  = power_factor;

		
	}
	/*-----------------------------------------------------------------------
	  init_leg_parm
	  ----------------------------------------------------------------------*/
	void ois_parm.init_leg_parm(number option(nullable)  		notional,
								stub_type option(nullable) 		stub_type,
								date 		option(nullable) 	eff_date ,
								date 		option(nullable) 	first_cpn_date ,
								date 		option(nullable) 	last_reg_date ,
								number 		option(nullable) 	spread ,
								vector(date) option(nullable) 	fixing_dates ,	
								vector(number) 	option(nullable) fixing_rates,
								number 		option(nullable) 	fix_proxy ,
								logical 	option(nullable) 	allow_fwd_fix,								
								number		option(nullable) 	fx_mult,
								logical 	option(nullable) 	is_approx_calc)
	{
		ois_stub_type_		= stub_type;
		ois_eff_date_  		= eff_date ;
		ois_first_cpn_date_  = first_cpn_date;
		ois_last_reg_date_  = last_reg_date;
		ois_spread_  		= spread;
		ois_fixing_dates_  	= fixing_dates;	
		ois_fixing_rates_ 	= fixing_rates;
		ois_fix_proxy_  	= fix_proxy;
		ois_allow_fwd_fix_ 	= allow_fwd_fix;
		ois_notional_ 		= notional;
		ois_fx_mult_ 		= fx_mult;
		ois_is_approx_calc_ = is_approx_calc;
		ois_roll_day_		= 0;
	}
	/*-----------------------------------------------------------------------
	  basic_static_null_check
	  ----------------------------------------------------------------------*/
	void ois_parm.basic_static_null_check(	out bd_convention 		pmt_bus_day,
											out calendar  			pmt_cal,
											out logical 			end_of_month,
											out string	 			ccy,
											number option(nullable) cpn_freq_n,
											out coupon_freq 		cpn_freq,										
											out day_count_method 	day_count,
											out ir_index 			ir_index,
											out interest_rule 		ir_rule,
											out number  		 	pmt_delay ,
											out number  			mat_pmt_delay ,
											out number   			pmt_delay_prin ,
											out number  			mat_pmt_delay_prin,
											out logical				endog_df,
											out logical				approx_calc,
											out logical 			avg_notional,
											out flt_comp_avg_type 	comp_avg_type,
											out flt_sprd_comp_method sprd_comp_method,
											out flt_avg_method 		avg_method,
											out rfr_arrears_type 	arr_type,
											out number 				arr_days)
	{
		if(null(pmt_bus_day))
		   pmt_bus_day = ois_pmt_bus_day_;
		QL_REQUIRE(!null(pmt_bus_day), "invalid ois leg business day convention");
		
		if(null(pmt_cal))
			pmt_cal = ois_pmt_calendar_;
		QL_REQUIRE(!null(pmt_cal), "invalid ois leg calendar");

		if(null(end_of_month))
			end_of_month = ois_end_of_month_ ;
		QL_REQUIRE(!null(end_of_month), "invalid ois leg end of month");

		if(null(ccy))
			ccy = ois_ccy_ ;
		QL_REQUIRE(!null(ccy), "invalid ois leg currency");

		if(null(cpn_freq_n))
			cpn_freq = ois_cpn_freq_ ;
		else
			cpn_freq = coupon_freq_from_int(integer(cpn_freq_n));
		QL_REQUIRE(!null(cpn_freq), "invalid ois leg coupon frequency");
		
		if(null(day_count))
		   day_count = ois_dc_ ;
		QL_REQUIRE(!null(day_count), "invalid ois leg daycount method");

		if(null(ir_index))
		   ir_index = ois_ir_index_;
		QL_REQUIRE(!null(ir_index), "invalid ois leg index");

		if(null(ir_rule))
		   ir_rule = ois_ir_rule_;
		QL_REQUIRE(!null(ir_rule), "invalid ois leg interest rule");
		
		if(null(pmt_delay))
		   pmt_delay = ois_pmt_delay_ ;
		QL_REQUIRE(!null(pmt_delay), "invalid ois leg payment delay");

		if(null(mat_pmt_delay))
		   mat_pmt_delay = null(ois_mat_pmt_delay_) ? pmt_delay : ois_mat_pmt_delay_  ;

		if(null(pmt_delay_prin))
		   pmt_delay_prin = ois_pmt_delay_prin_ ;
		QL_REQUIRE(!null(pmt_delay_prin), "invalid ois leg payment delay (principal)");

		if(null(mat_pmt_delay_prin))
		   mat_pmt_delay_prin = null(ois_mat_pmt_delay_prin_) ? pmt_delay_prin : ois_mat_pmt_delay_prin_  ;

		if(null(endog_df))
		   endog_df = ois_endog_df_ ;
		QL_REQUIRE(!null(endog_df), "invalid ois leg self discounting flag");

		if(null(approx_calc))
		   approx_calc = ois_is_approx_calc_ ;
		QL_REQUIRE(!null(approx_calc), "invalid ois leg approx calc flag");

		if(null(avg_notional))
			avg_notional = ois_average_notional_;
		QL_REQUIRE(!null(avg_notional), "invalid average notional setting (for amortizing swaps only)");

		if(null(comp_avg_type))
		   comp_avg_type = ois_ca_t_ ;
		QL_REQUIRE(!null(comp_avg_type), "invalid ois leg comp_avg_type");
		
		if(null(sprd_comp_method))
		   sprd_comp_method = ois_comp_m_ ;
		if(comp_avg_type == flt_comp_avg_type.CA_COMP)
			QL_REQUIRE(!null(sprd_comp_method), "invalid ois leg sprd_comp_method");

		if(null(avg_method))
		   avg_method = ois_avg_ ;
		if(comp_avg_type == flt_comp_avg_type.CA_AVG)
			QL_REQUIRE(!null(avg_method), "invalid ois leg avg_method");

		if(null(arr_type))
		   arr_type = ois_arr_type_ ;
		QL_REQUIRE(!null(arr_type), "invalid ois leg arr_type");
											
		if(null(arr_days))
		   arr_days = ois_arr_days_ ;
		QL_REQUIRE(!null(arr_days), "invalid ois leg arr_days");									
	}
	/*-----------------------------------------------------------------------
	  init_basic_static
	  ----------------------------------------------------------------------*/
	void ois_parm.init_static(	bd_convention 		pmt_bus_day,
								calendar  			pmt_cal,
								logical 			eom,
								string	 			ccy,
								integer 			cpn_freq,									
								day_count_method 	dc,
								interest_rule 		ir_rule,
								ir_index 	 		ir_index,
								flt_comp_avg_type option(nullable) 		comp_avg_type,
								flt_sprd_comp_method option(nullable) 	sprd_comp_method,
								flt_avg_method option(nullable) 		avg_method,
								number  		 	pmt_delay ,
								number  			mat_pmt_delay ,
								number   			pmt_delay_prin ,
								number  			mat_pmt_delay_prin ,
								rfr_arrears_type option(nullable) 	arr_type ,
								number option(nullable) 			arr_days,
								logical 			endog_df,
								logical 			is_approx_calc,
								logical  option(nullable)  average_notional,
								flt_roll_method option(nullable) roll )
	{	
		round_code pv_round_code			= null;
		round_code comp_factor_round_code 	= null;
		round_code imp_rate_pcnt_round_code	= null; 			
		number sub_factor 					= null;
		number multi_factor  				= null;
		number power_factor 				= null;
		
		init_def_parm( 	ccy,
						coupon_freq_from_int(cpn_freq) ,		
						pmt_cal,
						pmt_bus_day,
						eom,
						dc,
						ir_index,
						null(comp_avg_type) ? flt_comp_avg_type.CA_COMP : comp_avg_type,
						null(sprd_comp_method) ? flt_sprd_comp_method.SC_SPRD_EXCL : sprd_comp_method,
						null(avg_method) ? flt_avg_method.AVG_WEIGHTED : avg_method,
						pv_round_code,comp_factor_round_code ,imp_rate_pcnt_round_code, ir_rule ,
						pmt_delay ,mat_pmt_delay,pmt_delay_prin ,mat_pmt_delay_prin ,
						null(arr_type) ? rfr_arrears_type.PLAIN : arr_type,
						null(arr_days) ? 0 : arr_days,
						endog_df,
						null(roll) ? flt_roll_method.FLR_STRAIGHT : roll,
						null(average_notional) ? true : average_notional ,
						sub_factor,multi_factor,power_factor);

		init_leg_parm(null ,null,null,null ,null,null ,null,null,null,null,null,is_approx_calc);
	}
	/*-----------------------------------------------------------------------
	  init_basic_static_leg1
	  ----------------------------------------------------------------------*/
	void ois_parm.init_basic_static_leg1(instr_def  def)
	{
		error_info ee = new error_info(true,true);

		interest_rule ir_rule				= interest_rule.IR_ADJ;
		round_code pv_round_code			= null;
		round_code comp_factor_round_code 	= null;
		round_code imp_rate_pcnt_round_code	= null; 
		flt_roll_method roll 				= flt_roll_method.FLR_STRAIGHT;
		logical average_notional 			= true;
		number sub_factor 					= null;
		number multi_factor  				= null;
		number power_factor 				= null;

		init_def_parm( 	def.swap_currency_leg1(ee),
						coupon_freq_from_int(def.swap_coupon_freq_leg1(ee)) ,		
						def.swap_calendar_leg1(ee),
						def.swap_pmt_bus_day_leg1(ee),
						def.swap_eom_leg1(ee),
						def.swap_dc_method_leg1(ee),
						def.swap_ir_index_leg1(ee),
						def.swap_comp_avg_type_leg1(ee),
						def.swap_sprd_comp_method_leg1(ee),
						def.swap_avg_method_leg1(ee),
						pv_round_code,comp_factor_round_code ,imp_rate_pcnt_round_code, ir_rule ,
						def.swap_pmt_lag_leg1(ee),
						def.swap_pmt_lag_leg1(ee),
						def.swap_pmt_lag_prin_leg1(ee),
						def.swap_pmt_lag_prin_leg1(ee),
						def.swap_rfr_arr_type_leg1(ee) ,def.swap_rfr_arr_days_leg1(ee),def.ois_is_endog_df_leg1(),		
						roll,
						average_notional ,sub_factor,multi_factor,power_factor);

		init_leg_parm(null ,null,null,null ,null,null ,null,null,null,null,null,def.ois_is_approx_calc_leg1(ee));
	}
	
	/*-----------------------------------------------------------------------
	  init_basic_static_leg2
	  ----------------------------------------------------------------------*/
	void ois_parm.init_basic_static_leg2(instr_def  def)
	{
		error_info ee = new error_info(true,true);

		interest_rule ir_rule				= interest_rule.IR_ADJ;
		round_code pv_round_code			= null;
		round_code comp_factor_round_code 	= null;
		round_code imp_rate_pcnt_round_code	= null; 
		flt_roll_method roll 				= flt_roll_method.FLR_STRAIGHT;
		logical average_notional 			= true;
		number sub_factor 					= null;
		number multi_factor  				= null;
		number power_factor 				= null;
		
		init_def_parm( 	def.swap_currency_leg2(ee),
						coupon_freq_from_int(def.swap_coupon_freq_leg2(ee)) ,		
						def.swap_calendar_leg2(ee),
						def.swap_pmt_bus_day_leg2(ee),
						def.swap_eom_leg2(ee),
						def.swap_dc_method_leg2(ee),
						def.swap_ir_index_leg2(ee),
						def.swap_comp_avg_type_leg2(ee),
						def.swap_sprd_comp_method_leg2(ee),
						def.swap_avg_method_leg2(ee),
						pv_round_code,comp_factor_round_code ,imp_rate_pcnt_round_code, ir_rule ,
						def.swap_pmt_lag_leg2(ee),
						def.swap_pmt_lag_leg2(ee),
						def.swap_pmt_lag_prin_leg2(ee),
						def.swap_pmt_lag_prin_leg2(ee),
						def.swap_rfr_arr_type_leg2(ee) ,def.swap_rfr_arr_days_leg2(ee),def.ois_is_endog_df_leg2(),		
						roll,
						average_notional ,sub_factor,multi_factor,power_factor);

		init_leg_parm(null ,null,null,null ,null,null ,null,null,null,null,null,def.ois_is_approx_calc_leg2(ee));
	}
	/*-----------------------------------------------------------------------
	  set_plain_vanilla
	  ----------------------------------------------------------------------*/
	/*void ois_parm.set_plain_vanilla(logical fedfund_style)
	{
		if(fedfund_style){
			ois_ca_t_			= flt_comp_avg_type.CA_AVG;
			ois_comp_m_			= flt_sprd_comp_method.SC_SPRD_EXCL;
			ois_avg_			= flt_avg_method.AVG_WEIGHTED;
			ois_arr_type_  		= rfr_arrears_type.LOCKOUT;
			ois_arr_days_ 		= 2 ;
		}
		else {
			ois_ca_t_			= flt_comp_avg_type.CA_COMP;
			ois_comp_m_			= flt_sprd_comp_method.SC_SPRD_EXCL;
			ois_avg_			= flt_avg_method.AVG_WEIGHTED;
			ois_arr_type_  		= rfr_arrears_type.PLAIN;
			ois_arr_days_ 		= 0 ;
		}
		//def
		ois_pv_round_code_ 	= null;
		ois_comp_factor_round_code_ 	= null;
		ois_imp_rate_pcnt_round_code_ 	= null;
		ois_ir_rule_  		= interest_rule.IR_ADJ;
		ois_roll_			= ..flt_roll_method.FLR_STRAIGHT;
		ois_average_notional_ = true;
		ois_sub_factor_  	= null;
		ois_multi_factor_  = null;
		ois_power_factor_  = null;
		ois_pmt_delay_  	= 0;
		ois_mat_pmt_delay_  = 0;
		ois_pmt_delay_prin_ = 0;
		ois_mat_pmt_delay_prin_ = 0;
		//leg
		ois_stub_type_		= stub_type.SHORT_FIRST;		
		ois_endog_df_ 		= true;		
		ois_eff_date_ 		= null<date>;
		ois_first_cpn_date_ = null<date>;
		ois_last_reg_date_ 	= null<date>;
		ois_spread_ 		= 0;		

		ois_fixing_dates_ 	= null<vector(date)>;	
		ois_fixing_rates_	= null<vector(number)>;
		ois_fix_proxy_ 		= null;
		ois_allow_fwd_fix_	= false;

		
		// def parms that are kep as is
		 //string 			ois_ccy_;
		 //coupon_freq  		ois_cpn_freq_;		
		 //calendar 			ois_pmt_calendar_;
		 //bd_convention 		ois_pmt_bus_day_;
		 //logical			ois_end_of_month_;
		 //day_count_method 	ois_dc_;
		 //ir_index 			ois_ir_index_;
		
		
		//  leg parms that are kep as is
		 //number 			ois_notional_;
		 //number				ois_fx_mult_;
		 //logical 			ois_is_approx_calc_;
		 
	}*/

	/*-----------------------------------------------------------------------
	  set_plain
	  ----------------------------------------------------------------------*/
	/*void ois_parm.set_plain(	bd_convention option(nullable) 	pmt_bus_day,
								calendar option(nullable)		pmt_calendar,
								logical	option(nullable) 		end_of_month,
								string	option(nullable) 		ccy,																								
								number option(nullable)			cpn_freq_n,
								day_count_method  option(nullable) day_count,
								interest_rule option(nullable)	ir_rule,
								ir_index option(nullable)		ir_index,
								number option(nullable)			spread,
								number option(nullable)			pmt_delay ,
								number option(nullable)			mat_pmt_delay ,
								number option(nullable)			pmt_delay_prin ,
								number option(nullable)			mat_pmt_delay_prin,
								logical	option(nullable)		endog_df,
								logical option(nullable)		approx_calc,logical)
	{
		coupon_freq cpn_freq 				= null;
		logical average_notional 			= true;
		flt_comp_avg_type comp_avg_type 	= flt_comp_avg_type.CA_COMP;
		flt_sprd_comp_method sprd_comp_method = flt_sprd_comp_method.SC_SPRD_EXCL ;
		flt_avg_method  avg_method 			= flt_avg_method.AVG_WEIGHTED ;
		rfr_arrears_type arr_t 				= rfr_arrears_type.PLAIN;
		number arr_d 						= 0;
		
		basic_static_null_check(pmt_bus_day,pmt_calendar,end_of_month,ccy,cpn_freq_n,cpn_freq,day_count,
								ir_index,ir_rule,pmt_delay,mat_pmt_delay,pmt_delay_prin,mat_pmt_delay_prin,endog_df,
								approx_calc,average_notional,comp_avg_type,sprd_comp_method ,avg_method ,arr_t ,arr_d);

		
		round_code pv_round_code			= null;
		round_code comp_factor_round_code 	= null;
		round_code imp_rate_pcnt_round_code	= null; 
		flt_roll_method roll 				= flt_roll_method.FLR_STRAIGHT;		
		number sub_factor 					= null;
		number multi_factor  				= null;
		number power_factor 				= null;
		
		init_def_parm(	str_to_upper(ccy),cpn_freq ,pmt_calendar,pmt_bus_day,end_of_month,day_count,ir_index,
						comp_avg_type ,sprd_comp_method,avg_method ,pv_round_code,comp_factor_round_code ,
						imp_rate_pcnt_round_code, ir_rule ,pmt_delay ,mat_pmt_delay ,
						pmt_delay_prin ,mat_pmt_delay_prin,arr_t ,arr_d,
						endog_df,roll,average_notional ,sub_factor,multi_factor,power_factor);

		number  notional 	= null;
		stub_type stub_t 	= stub_type.SHORT_FIRST;
		date  eff_date 		= null;
		date first_cpn_date = null;
		date  last_reg_date = null;
		vector(date) fixing_dates 	= null;	
		vector(number)  fixing_rates= null;
		number 	fix_proxy			= null;
		logical allow_fwd_fix 		= false;							
		number	fx_mult 			= null;

		init_leg_parm(notional ,stub_t,eff_date,first_cpn_date ,last_reg_date,spread,fixing_dates,fixing_rates,
					  fix_proxy,allow_fwd_fix,fx_mult,approx_calc);
	}*/
	/*-----------------------------------------------------------------------
	  set_plain
	  ----------------------------------------------------------------------*/
	void ois_parm.set_plain(	bd_convention option(nullable)	pmt_bus_day,
								calendar option(nullable)		pmt_cal,
								logical	 option(nullable)		end_of_month,
								string	 option(nullable)		ccy,
								number option(nullable)	 		cpn_freq_n,
								day_count_method  option(nullable) day_count,
								interest_rule option(nullable)	ir_rule,
								ir_index option(nullable)		ir_index,								
								number option(nullable) 		spread,

								flt_comp_avg_type option(nullable)  	comp_avg_type,
								flt_sprd_comp_method option(nullable) 	sprd_comp_method,
								flt_avg_method option(nullable)   		avg_method,
								rfr_arrears_type option(nullable)  		arr_type,
								number option(nullable)  				arr_days,
								
								number option(nullable)			pmt_delay ,
								number option(nullable)			mat_pmt_delay ,
								number option(nullable)			pmt_delay_prin ,
								number option(nullable)			mat_pmt_delay_prin,
								logical	option(nullable)		endog_df,
								logical option(nullable)		approx_calc,
								//leg
								stub_type option(nullable)		stub_t,								
								date option(nullable)  			eff_date,
								date option(nullable)  			first_cpn_date,
								date option(nullable)  			last_reg_date,
								number	option(nullable) 		notional,
								number	option(nullable)		fx_mult,							
								vector(date) option(nullable) 	fixing_dates ,	
								vector(number) option(nullable) fixing_rates,
								number option(nullable) 		fix_proxy ,
								logical option(nullable) 		allow_fwd_fix)
	{
		
		coupon_freq 	cpn_freq 	= null;
		logical avg_not 			= true;
		
		//some input args of def type must not be null --> if null in this funcs args they must be defined before in init
		basic_static_null_check(pmt_bus_day,pmt_cal,end_of_month,ccy,cpn_freq_n, cpn_freq, day_count,
								ir_index,ir_rule,pmt_delay,mat_pmt_delay,pmt_delay_prin,mat_pmt_delay_prin,endog_df,
								approx_calc,avg_not,comp_avg_type,sprd_comp_method,avg_method,arr_type,arr_days);
		
		flt_roll_method 	roll 				= flt_roll_method.FLR_STRAIGHT;
		round_code 			pv_round_code		= null ;
		round_code 			comp_factor_round_code	= null ;
		round_code			imp_rate_pcnt_round_code = null;
		number 	  			sub_factor 			= null;
		number 	  			multi_factor 		= null;
		number 	  			power_factor		= null;
								
		init_def_parm(	str_to_upper(ccy), cpn_freq,pmt_cal, pmt_bus_day, end_of_month,day_count, 
						ir_index, comp_avg_type,sprd_comp_method, avg_method, 
						pv_round_code ,comp_factor_round_code,imp_rate_pcnt_round_code,ir_rule,
						pmt_delay,mat_pmt_delay,pmt_delay_prin,mat_pmt_delay_prin,arr_type,arr_days,
						endog_df, roll,avg_not, sub_factor,multi_factor ,power_factor);

		//sink_fund_style sink_fund_style = null;
		//vector(date)  	sink_fund_dates = null;
		//vector(number)  sink_fund 		= null;
		if(null(stub_t))
			stub_t = stub_type.SHORT_FIRST;
		
		init_leg_parm(	notional,stub_t,eff_date,first_cpn_date,last_reg_date,spread,
						fixing_dates ,fixing_rates,fix_proxy,allow_fwd_fix, fx_mult,
						approx_calc);
	}
	/*-----------------------------------------------------------------------
	  ois_df_helper
	  ----------------------------------------------------------------------*/
	void ois_parm.ois_df_helper( disc_func option(nullable) 	ois_disc_func,
								fwd_func option(nullable) 	ois_fwd_func,
								disc_func option(nullable) 	ois_fwd_disc_func,
								disc_func option(nullable) 	rev_disc_func,
								logical is_cross_currency,
								logical rev_leg_prio,
								logical sync_endog_ok,
								date option(nullable) td,
								date m,
								out disc_func 	o1df,
								out fwd_func 	o1f,
								out disc_func 	o1fdf,
								out disc_func 	dfr2)
	{
		if(null(td)){
			o1df 	= null;
			o1fdf 	= null;
			o1f 	= null;		
			dfr2 	= null;
			return;
		}
		
		CORE_INT_SWAPLIB.ois_df_helper od = new CORE_INT_SWAPLIB.ois_df_helper(ois_endog_df_,
																				ois_is_approx_calc_,
																				is_cross_currency,
																				rev_leg_prio,
																				sync_endog_ok,
																				rev_disc_func,
																				ois_disc_func,
																				ois_fwd_func,
																				ois_fwd_disc_func );

		
		o1df 	= od.get_ois_disc_func(td, m, ois_ir_index_.day_count_method(), ois_ir_index_.fixing_calendar());
		o1fdf 	= od.get_ois_fwd_disc_func( td, m, ois_ir_index_.day_count_method(), ois_ir_index_.fixing_calendar());
		o1f 	= od.get_ois_fwd_func( td, m, ois_ir_index_.day_count_method(), ois_ir_index_.fixing_calendar());		
		dfr2 	= od.get_disc_func_rev_leg( td, m, ois_ir_index_.day_count_method(), ois_ir_index_.fixing_calendar());
	}
	
}
