option(null: hard);	

/*	
	instrument wrapper functions
	Developer: Algorithmica Research, Magnus Nyström	

INCOMPLETE

	--------------------------------------------------------------------
		swap_oisois create funcs
	--------------------------------------------------------------------		
*/

//--------
// from db
//--------


/*-----------------------------------------------------------------------
  swap_oisois
  ----------------------------------------------------------------------*/
swap_oisois swap_oisois(instrument_name 			instrument_name, 
							date option(nullable) 		trade_date 	= null<date>,
							string option(nullable) 	quote_side 	= null<string>,
							error_info option(nullable) error		= null<error_info>)
option (category: 'Instrument/Interest Rate Swap/ONIndex vs ONIndex')
{	
	try{			
		__instrument c = __instrument(instrument_name,trade_date,quote_side, null<date> );		
		return create_swap_oisois(c,error, E_INIT);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_oisois");
		return null<swap_oisois>;
	}
}


/*-----------------------------------------------------------------------
  swap_oisois
  ----------------------------------------------------------------------*/
swap_oisois swap_oisois(instrument_name 			instrument_name, 
							date option(nullable) 		trade_date ,
							number  option(nullable) 	quote ,
							error_info option(nullable) error		= null<error_info>)
option (category: 'Instrument/Interest Rate Swap/ONIndex vs ONIndex')
{	
	try{				
		__instrument c = __instrument(instrument_name,trade_date,quote, null<date> );//if quote is null --> c flagged as err-instrument
		return create_swap_oisois(c,error, E_INIT);							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_oisois");
		return null<swap_oisois>;
	}
}


/*-----------------------------------------------------------------------
  swap_oisois
  ----------------------------------------------------------------------*/
swap_oisois swap_oisois(instr_def 					instr_def, 
							date option(nullable) 	trade_date 	= null<date>,
							string option(nullable) quote_side 	= null<string>,
							error_info option(nullable) error		= null<error_info>)
option (category: 'Instrument/Interest Rate Swap/ONIndex vs ONIndex')
{	
	try{				
		__instrument c = __instrument(instr_def,trade_date,quote_side, null<date> );
		return create_swap_oisois(c,error, E_INIT);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_oisois");
		return null<swap_oisois>;
	}
}
/*-----------------------------------------------------------------------
  swap_oisois
  ----------------------------------------------------------------------*/
swap_oisois swap_oisois(instr_def 					instr_def, 
							date option(nullable) 		trade_date ,
							number  option(nullable) 	quote ,
							error_info option(nullable) error		= null<error_info>)
option (category: 'Instrument/Interest Rate Swap/ONIndex vs ONIndex')
{	
	try{			
		__instrument c = __instrument(instr_def,trade_date,quote, null<date> );
		return create_swap_oisois(c,error, E_INIT);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_oisois");
		return null<swap_oisois>;
	}
}

//----------------
// from db or not
//----------------

/*-----------------------------------------------------------------------
  func: swap_oisois
  arguments: 
	instr_def: 	can be created either from the db or user defined 				 
				instr_def is copied and modified
				no lookup of quotes
	instrument_name: user defined name
--> will throw for currency swaps
  ----------------------------------------------------------------------*/
swap_oisois swap_oisois(	instr_def 				instr_def, 
							string 					instrument_name  ,
							date option(nullable) 	trade_date ,
							date option(nullable) 	settle_date ,							
							date  option(nullable) 	maturity,//maturity has precedence over mat_code
							string option(nullable) maturity_code,
							number option(nullable)	spread,							
							number 					nominal= 100,
							error_info option(nullable) error		= null<error_info>)
option (category: 'Instrument/Interest Rate Swap/ONIndex vs ONIndex')
{	
	try{
		__instrument c;

		if(!null(maturity))
			c = __instrument_oisois_par_nodb(instr_def,instrument_name,trade_date,settle_date, maturity,spread,nominal );
		else if(!null(maturity_code))
			c = __instrument_oisois_par_nodb(instr_def,instrument_name,trade_date,settle_date, maturity_code,spread,nominal );
		else
			QL_FAIL("invalid maturity/maturity_code");
		return create_swap_oisois( c, error);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_oisois");
		return null<swap_oisois>;
	}
}


module CORE_INT_OISOIS
{
	/*-----------------------------------------------------------------------
	  func: swap_oisois_plain_int
	  minimal constructor for "screen"-swap  --> NO STUBS
	    normally: leg1 = sprd_leg, leg2 = flat_leg
	  ----------------------------------------------------------------------*/
	swap_oisois swap_oisois_plain_int(	instr_def option(nullable)		def,//only one of the def, tmpl, sw_base can be input
										swap_oisois option(nullable)	sw_base,
										INSTR_TMPL.swap_oisois_def_tmpl	option(nullable) tmpl,
										string 						name,	
										date option(nullable) 		trade_date,
										date option(nullable) 		settle_date,
										string option(nullable) 	spot_code,//not used with a template
										date option(nullable) 		start_date,										
										string option(nullable) 	fwd_start_code,
										date 	option(nullable)	maturity,
										string 	option(nullable)	maturity_code,
										logical 					pay_ois1,
										integer 					sprd_rnd_dec,
										
										number 	option(nullable) 	fx_quote,			//required if instr_def is a cross curr
										string 	option(nullable) 	fx_quote_baseccy,	//required if instr_def is a cross curr
										string 	option(nullable) 	fx_quote_priceccy,	//required if instr_def is a cross curr
										logical option(nullable) 	pv_in_base_ccy,										
										//ois1
										number option(nullable)			ois1_notional,
										number option(nullable)			ois1_spread ,//if null --> will be set to par, spread on leg1	
										..disc_func option(nullable) 	ois1_disc_func,								
										fwd_func option(nullable) 		ois1_fwd_func,
										..disc_func option(nullable) 	ois1_fwd_disc_func,

										//ois2
										number 	 						ois2_notional,										
										number option(nullable)			ois2_spread ,//if null --> will be set to 0
										..disc_func option(nullable) 	ois2_disc_func,								
										fwd_func option(nullable) 		ois2_fwd_func,
										..disc_func option(nullable) 	ois2_fwd_disc_func,											
										
										error_info option(nullable) error )
	{	
		try{

			CORE_INT.reset_single(error);
			
			//create empty parm
			CORE_SWAPLIB.oisois_parm oo = new CORE_SWAPLIB.oisois_parm();

			//update parm with init_basic_static 
			if(!null(def)) {
				oo.init_static(def,spot_code);
			}
			else if(!null(sw_base)){							
				oo.init_static(sw_base,spot_code);
			}
			else if(!null(tmpl)){
				oo.init_static(tmpl);
			}
			else{
				QL_FAIL("err");
			}
			
			//basic checks of input
			QL_FAIL_COND(!null(ois1_fwd_func) && null(ois2_fwd_func),"fwd_func required for leg2 when leg1 has a fwd_func");//for now, FIX_ME should be relaxed
			
			//update parm with current input
			number pv01_not_unit	= 100000;//rounding unit for notional when implied from pv01
			number ois1_pv01 = null;
			
			if(!oo.is_cross_currency()) {

				oo.set_plain_single_ccy(name, trade_date,settle_date,start_date,fwd_start_code,maturity ,maturity_code,pay_ois1,
										sprd_rnd_dec,pv01_not_unit,ois1_notional,ois1_pv01,
										ois1_spread, ois2_spread);
			}

			else {
				oo.set_plain(	name, trade_date,settle_date,start_date,fwd_start_code,maturity ,maturity_code, pay_ois1,					
								sprd_rnd_dec,pv01_not_unit,fx_quote,fx_quote_baseccy,fx_quote_priceccy,pv_in_base_ccy,
								//ois1
								 ois1_spread,null,null,null,null,ois1_notional,	ois1_pv01,null,null, null, null,
								//ois2
								 ois2_spread,null,null,null,null,ois2_notional,null,null, null, null);
				
			}
			swap_oisois swap;
			if(!null(ois1_fwd_func))
				swap = oo.create_swap( ois1_disc_func, ois1_fwd_func, ois1_disc_func,ois2_fwd_func );
			else
				swap = oo.create_swap( ois1_disc_func, ois1_fwd_disc_func, ois1_disc_func,ois2_fwd_disc_func );
			
			return swap;

		}
		catch {
			CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_oisois_plain_int");
			return null<swap_oisois>;
		}
	}
}


/*-----------------------------------------------------------------------
  func: swap_oisois_plain
  minimal constructor for "screen"-swap, --> NO STUBS
  this version: disc_func input
  normally: leg1 = sprd_leg, leg2 = flat_leg
  ----------------------------------------------------------------------*/
swap_oisois swap_oisois_plain(	instr_def 					def,
								string 						name,	
								date option(nullable) 		trade_date,
								date option(nullable) 		settle_date,
								string option(nullable) 	spot_settle_code,
								date option(nullable) 		start_date,			//start_date has precedence over start_date_code
								string option(nullable) 	fwd_start_code,
								date option(nullable)		maturity,			//maturity has precedence over mat_code
								string 	option(nullable)	maturity_code,
								logical 					pay_leg1,
								integer 					sprd_rnd_dec,
								
								number 	option(nullable) 	fx_quote,			//required if instr_def is a cross curr
								string 	option(nullable) 	fx_quote_baseccy,	//required if instr_def is a cross curr
								string 	option(nullable) 	fx_quote_priceccy,	//required if instr_def is a cross curr								
								logical option(nullable) 	pv_in_base_ccy,
								
								//ois1
								number option(nullable)		notional_leg1,							
								number option(nullable)		spread_leg1 ,//if null --> will be set to par							
								disc_func option(nullable) 	disc_func_leg1,
								disc_func option(nullable) 	fwd_disc_func_leg1,
								//ois2
								number 	 					notional_leg2,
								number option(nullable)		spread_leg2 ,//if null --> will be set to 0													
								disc_func option(nullable) 	disc_func_leg2,
								disc_func option(nullable) 	fwd_disc_func_leg2,																																												
								
								error_info option(nullable) error = null<error_info>)
option (category: 'Instrument/Interest Rate Swap/ONIndex vs ONIndex')
{
	return CORE_INT_OISOIS.swap_oisois_plain_int(	def,null,null,name,trade_date,settle_date,spot_settle_code,start_date,fwd_start_code,maturity,maturity_code,
											pay_leg1,sprd_rnd_dec,fx_quote, fx_quote_baseccy,fx_quote_priceccy,pv_in_base_ccy,
											notional_leg1,spread_leg1 , disc_func_leg1,null, fwd_disc_func_leg1,notional_leg2,
													spread_leg2,disc_func_leg2, null, fwd_disc_func_leg2,error );
}

/*-----------------------------------------------------------------------
  func: swap_oisois_plain
  minimal constructor for single curr "screen"-swap,
  normally: leg1 = sprd_leg, leg2 = flat_leg
  ----------------------------------------------------------------------*/
swap_oisois swap_oisois_plain(	INSTR_TMPL.swap_oisois_def_tmpl	tmpl,
								string 						name,	
								date option(nullable) 		trade_date,
								date option(nullable) 		settle_date,	
								date option(nullable) 		start_date,//if tmpl have a code it is ignored
								date option(nullable)		maturity,//if tmpl have a code it is ignored
								logical 					pay_leg1,
								integer 					sprd_rnd_dec,

								number 	option(nullable) 	fx_quote,			//required if instr_def is a cross curr
								string 	option(nullable) 	fx_quote_baseccy,	//required if instr_def is a cross curr
								string 	option(nullable) 	fx_quote_priceccy,	//required if instr_def is a cross curr								
								logical option(nullable) 	pv_in_base_ccy,

								//ois1
								number option(nullable)		notional_leg1,							
								number option(nullable)		spread_leg1 ,//if null --> will be set to par							
								disc_func option(nullable) 	disc_func_leg1,
								disc_func option(nullable) 	fwd_disc_func_leg1,
								//ois2
								number 	 					notional_leg2,
								number option(nullable)		spread_leg2 ,//if null --> will be set to 0													
								disc_func option(nullable) 	disc_func_leg2,
								disc_func option(nullable) 	fwd_disc_func_leg2,	
								error_info option(nullable) error = null<error_info>)
option (category: 'Instrument/Interest Rate Swap/ONIndex vs ONIndex')
{
	try{		
		return CORE_INT_OISOIS.swap_oisois_plain_int(null,null,tmpl,name,trade_date,settle_date,null,start_date,null,maturity,null,
											pay_leg1,sprd_rnd_dec,fx_quote, fx_quote_baseccy,fx_quote_priceccy,pv_in_base_ccy,
											notional_leg1,spread_leg1 , disc_func_leg1,null, fwd_disc_func_leg1,notional_leg2,
													spread_leg2,disc_func_leg2, null, fwd_disc_func_leg2,error );

	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_oisois");
		return null<swap_oisois>;
	}
}