/*	
	instrument wrapper functions
	Developer: Algorithmica Research, Magnus Nyström	

	-----------------
	 on_future	create funcs
	-----------------			
*/

option(null: hard);	

//--------
// from db
//--------


/*-----------------------------------------------------------------------
  on_future
  ----------------------------------------------------------------------*/
on_future on_future(instrument_name 			instrument_name, 
					date option(nullable) 		trade_date 	= null<date>,
					string option(nullable) 	quote_side 	= null<string>,					
					error_info option(nullable) error		= null<error_info>)
option (category: 'Instrument/Overnight Future')
{	
	try{			
		__instrument c = __instrument(instrument_name,trade_date,quote_side, null<date> );		
		return create_on_future(c,error, E_INIT);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "on_future");
		return null<on_future>;
	}
}


/*-----------------------------------------------------------------------
  on_future
  ----------------------------------------------------------------------*/
on_future on_future(instrument_name 			instrument_name, 
					date option(nullable) 		trade_date ,
					number  option(nullable) 	quote ,				
					error_info option(nullable) error		= null<error_info>)
option (category: 'Instrument/Overnight Future')
{	
	try{				
		__instrument c = __instrument(instrument_name,trade_date,quote,null<date> );
		return create_on_future(c,error, E_INIT);							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "on_future");
		return null<on_future>;
	}
}

/*-----------------------------------------------------------------------
  on_future
  ----------------------------------------------------------------------*/
on_future on_future(instr_def 					instr_def, 
					date option(nullable) 		trade_date 	= null<date>,
					string option(nullable) 	quote_side 	= null<string>,			
					error_info option(nullable) error		= null<error_info>)
option (category: 'Instrument/Overnight Future')
{	
	try{				
		__instrument c = __instrument(instr_def,trade_date,quote_side, null<date> );
		return create_on_future(c,error, E_INIT);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "on_future");
		return null<on_future>;
	}
}
/*-----------------------------------------------------------------------
  on_future
  ----------------------------------------------------------------------*/
on_future on_future(instr_def 					instr_def, 
					date option(nullable) 		trade_date ,
					number  option(nullable) 	quote ,				
					error_info option(nullable) error		= null<error_info>)
option (category: 'Instrument/Overnight Future')
{	
	try{			
		__instrument c = __instrument(instr_def,trade_date,quote, null<date> );
		return create_on_future(c,error, E_INIT);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "on_future");
		return null<on_future>;
	}
}

//----------------
// from db or not
//----------------

/*-----------------------------------------------------------------------
  func: instrument_onfut_nodb
	arguments: 
	instr_def: 	can be created either from the db or user defined 
				no lookup of quotes 
				instr_def is copied and modified
  ----------------------------------------------------------------------*/
on_future on_future(	instr_def 				instr_def, 
						string 					instrument_name  ,
						date option(nullable) 	trade_date ,
						date  option(nullable) 	accr_start_date ,
						number option(nullable) market_quote,//note: quote
						number option(nullable)	contract_quote,	//note: quote					
						number 	option(nullable) nominal = 100,
						vector(date) option(nullable) fixing_dates = null<vector(date) >,
						vector(number) option(nullable) fixing_rates = null<vector(number) >,
						error_info option(nullable) error		= null<error_info>)
option (category: 'Instrument/Overnight Future')
{	
	try{			
		__instrument c = __instrument_onfut_nodb(instr_def,instrument_name,trade_date,accr_start_date,
												market_quote,contract_quote,nominal,fixing_dates,fixing_rates);
		return create_on_future(c, error);					
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "on_future");
		return null<on_future >;
	}
}


/*-----------------------------------------------------------------------
  func: dates_on_future
  ----------------------------------------------------------------------*/
void dates_on_future(	instr_def 				instr_def, 
						date option(nullable) 	accr_start_date ,			
						out vector(date)   option(nullable)	dates,
						out vector(date)   option(nullable)	publish_dates,
						out vector(date)   option(nullable)	on_start,
						out vector(date)   option(nullable)	on_end,
						out vector(integer) option(nullable) weight,
						error_info option(nullable) error		= null<error_info>)
option (category: 'Instrument/Overnight Future')
{	
	try{
		instr_error_type t;
   		string 			s;	
		__onfut_dates(	instr_def,accr_start_date,dates,publish_dates,on_start,on_end, weight, t,s);
		logical e = CORE_INT.add_error_info(error,t,s, "dates_on_future");
		if(e){ 
			dates = publish_dates = on_start = on_end = null<vector(date)>;
			weight = null<vector(integer)>;
		}		
		return ;				
	}
	catch {
		dates = publish_dates = on_start = on_end = null<vector(date)>;
		weight = null<vector(integer)>;
		CORE_INT.catch_error_info(error,err.type(),err.message(), "dates_on_future");
		return ;
	}
}


