option(null: hard);	// Throw error if a null value is used in a non-nullable context

/*-----------------------------------------------------------------------
  position_nom
  ----------------------------------------------------------------------*/
class position_nom
{
public:
	position_nom();
	void 	add_pos(instrument, number, number);
	date 	settle_date();	
	date 	trade_date();
	logical null_pos();
	integer count_pos();
	number	nominal();
protected:
	
	instrument i_nom_;
};

position_nom.position_nom(): i_nom_(null<instrument>) {}

date 	position_nom.settle_date()	{ return null(i_nom_) ? null<date>:i_nom_.settle_date();}
date 	position_nom.trade_date() 	{ return null(i_nom_) ? null<date>:i_nom_.trade_date();}
logical position_nom.null_pos() 	{ return null(i_nom_);}
integer position_nom.count_pos()	{ return null_pos() ? 0 : 1; }
number  position_nom.nominal() 		{ return null(i_nom_) ? 0:i_nom_.nominal();}

void position_nom.add_pos(instrument i, number nom, number q)
{
	logical set_c2q = false;

	if(null_pos()) {
		i_nom_ 	= i.clone();//(i,error);//make a copy

		i_nom_.add_quote(q,set_c2q);
		i_nom_.add_nominal(nom);
	}
	else {
		QL_REQUIRE(i.trade_date() == this.trade_date(),"invalid trade date",i.name(),true);
		QL_REQUIRE(i.settle_date() == this.settle_date(),"invalid settlement date",i.name(),true);
		number n = i_nom_.nominal();		
		i_nom_.add_quote(q,set_c2q);
		i_nom_.add_nominal(n + nom);
	}
}
position_nom position_nom() { return new position_nom();}

/*-----------------------------------------------------------------------
  position_settle
  ----------------------------------------------------------------------*/
class position_settle
{
public:
	position_settle(string);
	date 	trade_date();
	string 	name();
	logical null_pos();
	logical settle_exist(date ,out integer );
	integer count_pos();
	vector(position_nom) pos();
	void add_pos(instrument i, number nom, number q);

protected:
	
	vector(position_nom) pos_nom_v_;
	string name_;
};

position_settle.position_settle(string name): name_(name) { resize(pos_nom_v_,0) ;}

date 	position_settle.trade_date() 		{ return null_pos() ? null<date>:pos_nom_v_[0].trade_date();}
string 	position_settle.name()				{ return name_;}
logical position_settle.null_pos() 			{ return null(pos_nom_v_) || v_size(pos_nom_v_) == 0;}

vector(position_nom) position_settle.pos() 
{
	if(null_pos()) return null<vector(position_nom)>;
	vector(position_nom) p;
	for(integer i=0;i<v_size(pos_nom_v_);i++){
		if( pos_nom_v_[i].count_pos() == 1)
			push_back(p,pos_nom_v_[i]);
	}
	return p;
}

integer position_settle.count_pos()	
{ 
	if(null_pos()) return 0;
	integer c = 0;
	for(integer i=0;i<v_size(pos_nom_v_);i++){
		c += pos_nom_v_[i].count_pos();
	}
	return c;
}

logical position_settle.settle_exist(date settle, out integer idx ) 	
{ 
	idx  = -1;
	if(null_pos()) return false;
	for(integer i=0;i<v_size(pos_nom_v_);i++){
		if(settle == pos_nom_v_[i].settle_date()){
			idx  = i;
			return true;
		}
	}

	return false;
}

void position_settle.add_pos(instrument i, number nom, number q)
{
	integer idx;
	logical settle_match = settle_exist(i.settle_date(), idx );
	if(null_pos() || !settle_match) {
		position_nom p = position_nom();
		p.add_pos(i,nom,q);
		push_back(pos_nom_v_,p);
	}
	else {
		QL_REQUIRE(i.trade_date() == this.trade_date(),"invalid trade date",i.name(),true);		
		pos_nom_v_[idx].add_pos(i,nom,q);
	}
	
}

position_settle position_settle(string name) { return new position_settle(name);}

/*-----------------------------------------------------------------------
  portfolio
  ----------------------------------------------------------------------*/
class portfolio
{
public:
	portfolio(string);
	date 	trade_date();
	logical null_port();
	logical name_exist(string ,out integer );
	integer count_pos();
	string name();
	vector(position_settle) pos_s();
	vector(position_nom) 	pos();

	void add_pos(instrument , number , number );
	void add_pos(instrument_name , date , date option(nullable), number , number );

protected:
	string name_;
	vector(position_settle) pos_settle_v_;
};

portfolio.portfolio(string name): name_(name) { resize(pos_settle_v_,0) ;}

string 	portfolio.name() 			{ return name_;}
date 	portfolio.trade_date() 		{ return null_port() ? null<date>:pos_settle_v_[0].trade_date();}
logical portfolio.null_port() 		{ return null(pos_settle_v_) || v_size(pos_settle_v_) == 0;}

vector(position_settle) portfolio.pos_s() 
{ 
	if(null_port()) return null<vector(position_settle)>; 
	vector(position_settle) p;
	for(integer i=0;i<v_size(pos_settle_v_);i++){
		if(!null(pos_settle_v_[i].pos()))
			push_back(p,pos_settle_v_[i]);

	}
	return p;
}

vector(position_nom) portfolio.pos()
{ 
	if(null_port()) return null<vector(position_nom)>; 
	vector(position_nom) p;
	logical first = true;
	for(integer i=0;i<v_size(pos_settle_v_);i++){
		if(!null(pos_settle_v_[i].pos())){
			if(first) {
				p = pos_settle_v_[i].pos();
				first = false;	
			}
			else  
				p = concat(p,pos_settle_v_[i].pos());							
		}
	}
	return p;
}

integer portfolio.count_pos()	
{ 
	if(null_port()) return 0;
	integer c = 0;
	for(integer i=0;i<v_size(pos_settle_v_);i++){
		c += pos_settle_v_[i].count_pos();
	}
	return c;
}

logical portfolio.name_exist(string name, out integer idx ) 	
{ 
	idx  = -1;
	if(null_port()) return false;
	for(integer i=0;i<v_size(pos_settle_v_);i++){
		if(name == pos_settle_v_[i].name()){
			idx  = i;
			return true;
		}
	}

	return false;
}

void portfolio.add_pos(instrument_name in, date trade, date option(nullable) settle, number nom, number q)
{
	error_info error = new error_info(true,true);
	instrument i = instrument(in, trade, q,settle, error);	
	this.add_pos(i, nom, q)	;
}

void portfolio.add_pos(instrument i, number nom, number q)
{
	integer idx;
	logical name_match = name_exist(i.name(), idx );
	if(null_port() || !name_match) {
		position_settle p = position_settle(i.name());
		p.add_pos(i,nom,q);
		push_back(pos_settle_v_,p);
	}
	else {				
		pos_settle_v_[idx].add_pos(i,nom,q);
	}
	
}

portfolio portfolio(string name) { return new portfolio(name);}



