/*	
	instrument wrapper functions
	Developer: Algorithmica Research, Magnus Nyström

	-----------------
	 riba create funcs	
	-----------------			
*/

option(null: hard);	



//--------
// from db
//--------


/*-----------------------------------------------------------------------
  riba
  ----------------------------------------------------------------------*/
riba riba(	instrument_name 			instrument_name, 
			date option(nullable) 		trade_date 	= null<date>,
			string option(nullable) 	quote_side 	= null<string>,				
			error_info option(nullable) error		= null<error_info>)
option (category: 'Instrument/Riba')
{	
	try{			
		__instrument c = __instrument(instrument_name,trade_date,quote_side, null<date> );		
		return create_riba(c,error, E_INIT);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "riba");
		return null<riba>;
	}
}

/*-----------------------------------------------------------------------
  riba
  ----------------------------------------------------------------------*/
riba riba(	instrument_name 			instrument_name, 
			date option(nullable) 		trade_date ,
			number  option(nullable) 	quote ,				
			error_info option(nullable) error		= null<error_info>)
option (category: 'Instrument/Riba')
{	
	try{				
		__instrument c = __instrument(instrument_name,trade_date,quote,null<date> );
		return create_riba(c,error, E_INIT);							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "riba");
		return null<riba>;
	}
}

/*-----------------------------------------------------------------------
  riba
  ----------------------------------------------------------------------*/
riba riba(	instr_def 					instr_def, 
			date option(nullable) 		trade_date 	= null<date>,
			string option(nullable) 	quote_side 	= null<string>,			
			error_info option(nullable) error		= null<error_info>)
option (category: 'Instrument/Riba')
{	
	try{				
		__instrument c = __instrument(instr_def,trade_date,quote_side, null<date> );
		return create_riba(c,error, E_INIT);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "riba");
		return null<riba>;
	}
}
/*-----------------------------------------------------------------------
  riba
  ----------------------------------------------------------------------*/
riba riba(	instr_def 					instr_def, 
			date option(nullable) 		trade_date ,
			number  option(nullable) 	quote ,				
			error_info option(nullable) error		= null<error_info>)
option (category: 'Instrument/Riba')
{	
	try{			
		__instrument c = __instrument(instr_def,trade_date,quote, null<date> );
		return create_riba(c,error, E_INIT);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "riba");
		return null<riba>;
	}
}

//----------------
// from db or not
//----------------


//-----------------------------------------------------------------------
//	func: instrument_riba_nodb
//		arguments: 
//		instr_def: 	can be created either from the db or user defined 
//					no lookup of quotes 
//					instr_def is copied and modified
//  ----------------------------------------------------------------------
riba riba(	instr_def 				instr_def, 
			string 					instrument_name  ,
			date option(nullable) 	trade_date ,
			date  option(nullable) 	accr_start_date ,
			date  option(nullable) 	accr_end_date,
			number option(nullable) market_rate,//dec
			number 	option(nullable) contract_rate,//dec
			number 	option(nullable) nominal = 100,
			vector(date) option(nullable)	eff_dates = null<vector(date)>,
			vector(number) option(nullable)	repo_rates = null<vector(number)>,
			error_info option(nullable) error		= null<error_info>) 
option (category: 'Instrument/Riba')
{	
	try{	
		//number nominal = null<number>;		
		__instrument c = __instrument_riba_nodb(instr_def,instrument_name,trade_date,accr_start_date,
											accr_end_date,market_rate, contract_rate,nominal,eff_dates, repo_rates );
		return create_riba(c, error);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "riba");
		return null<riba>;
	}
}

//-----------------------------------------------------------------------
//	func: 
//		arguments: 
//		instr_def: 	can be created either from the db or user defined 
//					no lookup of quotes 
//					instr_def is copied and modified
//  ----------------------------------------------------------------------
/*riba riba(	instr_def 				instr_def, 
			string 					instrument_name  ,
			date option(nullable) 	trade_date ,
			string 					underl_start_code ,
			string   				underl_maturity_code,
			logical  				maturity_code_off_trade,
			number option(nullable) market_rate,//dec
			number 	option(nullable) contract_rate,//dec
			number 	option(nullable) nominal,
			vector(date) option(nullable)			eff_dates= null<vector(date)>,
			vector(number) option(nullable)			repo_rates= null<vector(number)>,
			out instr_error option(nullable) error) 
option (category: 'Instrument/Riba')
{	
	try{	
		number nominal = null<number>;		
		__instrument c = __instrument_riba_nodb(instr_def,instrument_name,trade_date,underl_start_code,underl_maturity_code,
											maturity_code_off_trade,market_rate, contract_rate,nominal,eff_dates, repo_rates);
		return create_riba(c, error);						
	}
	catch {
		set_error(error,ERR_T_INIT,err.message());
		return null<riba>;
	}
}
*/

/*-----------------------------------------------------------------------
  func: dates_riba
  ----------------------------------------------------------------------*/
void dates_riba(instr_def 				instr_def, 
				date option(nullable) 	accr_start_date ,
				date option(nullable) 	accr_end_date ,			
				out vector(date)   option(nullable)	eff_dates,
				error_info option(nullable) error		= null<error_info>)
option (category: 'Instrument/Riba')
{	
	try{
		instr_error_type t;
   		string 			s;	
		__riba_eff_dates(instr_def,accr_start_date,accr_end_date,eff_dates, t,s);
		logical e = CORE_INT.add_error_info(error,t,s, "dates_riba");
		if(e){ 
			eff_dates = null<vector(date)>;			
		}		
		return ;					
	}
	catch {
		eff_dates = null<vector(date)>;
		CORE_INT.catch_error_info(error,err.type(),err.message(), "dates_riba");
		return ;
	}
}


