/*	
	template definitions - selected examples
	Developer: Algorithmica Research, Magnus Nyström

			
*/

option(null: hard);	

calendar 	CAL_SE 	 = calendar_exist("SWEDEN") ? calendar("SWEDEN") : calendar("");
string 		CAL_SE_NAME = calendar_exist("SWEDEN") ? "SWEDEN" : "EMPTY";

calendar CAL_US = calendar_exist("USA") ? calendar("USA") : calendar("");
string CAL_US_NAME = calendar_exist("USA") ? "USA" : "EMPTY";

calendar CAL_SIFMA_US = calendar_exist("USA_SIFMA") ? calendar("USA_SIFMA") : calendar("");
string CAL_US_SIFMA_NAME = calendar_exist("USA_SIFMA") ? "USA_SIFMA" : "EMPTY";

calendar CAL_SOFR_US = calendar_exist("USA_SIFMA") && calendar_exist("USA") ? CORE_INT.calendar_ext(["USA_SIFMA","USA"]) : calendar("");
string CAL_SOFR_US_NAME = calendar_exist("USA_SIFMA") && calendar_exist("USA") ? strcat(["USA_SIFMA",CORE_INT.CAL_MERGE_TOKEN,"USA"]) : "EMPTY";

calendar CAL_UK = calendar_exist("ENGLAND") ? calendar("ENGLAND") : calendar("");
string CAL_UK_NAME = calendar_exist("ENGLAND") ? "ENGLAND" : "EMPTY";

calendar CAL_TARGET = calendar_exist("TARGET") ? calendar("TARGET") : calendar("");
string CAL_TARGET_NAME = calendar_exist("TARGET") ? "TARGET" : "EMPTY";

calendar CAL_DK = calendar_exist("DENMARK") ? calendar("DENMARK") : calendar("");
string CAL_DK_NAME = calendar_exist("DENMARK") ? "DENMARK" : "EMPTY";

calendar CAL_NO = calendar_exist("NORWAY") ? calendar("NORWAY") : calendar("");
string CAL_NO_NAME = calendar_exist("NORWAY") ? "NORWAY" : "EMPTY";

calendar CAL_CA = calendar_exist("CANADA") ? calendar("CANADA") : calendar("");
string CAL_CA_NAME = calendar_exist("CANADA") ? "CANADA" : "EMPTY";

calendar CAL_CN = calendar_exist("CHINA") ? calendar("CHINA") : calendar("");
string CAL_CN_NAME = calendar_exist("CHINA") ? "CHINA" : "EMPTY";

calendar CAL_AU = calendar_exist("AUSTRALIA") ? calendar("AUSTRALIA") : calendar("");
string CAL_AU_NAME = calendar_exist("AUSTRALIA") ? "AUSTRALIA" : "EMPTY";

calendar CAL_CH = calendar_exist("SWITZERLAND") ? calendar("SWITZERLAND") : calendar("");
string CAL_CH_NAME = calendar_exist("SWITZERLAND") ? "SWITZERLAND" : "EMPTY";

calendar CAL_JP = calendar_exist("JAPAN") ? calendar("JAPAN") : calendar("");
string CAL_JP_NAME = calendar_exist("JAPAN") ? "JAPAN" : "EMPTY";

calendar CAL_FXO = calendar_exist("FXO") ? calendar("FXO") : calendar("");
string CAL_FXO_NAME = calendar_exist("FXO") ? "FXO" : "EMPTY";

module INSTR_TMPL_IR_INDEX 
{
	/*
	fix_days (=reset_days) determines the relation between value_date and fixing_date
    ex1. fixing_date, fix_days = -1 --> fixing_date =value_date+1
    ex2. fixing_date, fix_days = 2 --> fixing_date =value_date-2

    val_days determines the relation between value_date and trade_date
    t + val_days --> value_date
    ex1. o/n,			    val_days = 0, fix_days =  0 --> value_date = t  , fixing_date = value_date   = t	    (fix_delay_days = 0)
    ex2. stina(tn),		    val_days = 1, fix_days =  1 --> value_date = t+1, fixing_date = value_date-1 = t	    (fix_delay_days = 0)	
	ex3. fedfund		    val_days = 0, fix_days = -1 --> value_date = t  , fixing_date = value_date+1 = t+1	    (fix_delay_days = 1)

	if index family name is "LIBOR" we need a supplementary calendar
	ex. USD LIBOR --> main calendar = UK, supplementary = primary = USA

	ICE-LIBOR: CHF, EUR, GBP, JPY, USD
	
	*/
	
	/*ibor/libor*/
	INSTR_TMPL.ir_index_tmpl stibor 		= new INSTR_TMPL.ir_index_tmpl("STIBOR", "IBOR", DC_ACT_360, BD_MOD_FOLLOWING, true, CAL_SE, CAL_SE_NAME,"SEK",2);
	INSTR_TMPL.ir_index_tenor_tmpl stibor_3m= new INSTR_TMPL.ir_index_tenor_tmpl(stibor,"STIBOR-3M","3M",  2);
	INSTR_TMPL.ir_index_tenor_tmpl stibor_6m= new INSTR_TMPL.ir_index_tenor_tmpl(stibor,"STIBOR-6M","6M",  2);
	INSTR_TMPL.ir_index_tenor_tmpl stibor_tn= new INSTR_TMPL.ir_index_tenor_tmpl(stibor,"STIBOR-TN","BD1", 1);
	
	INSTR_TMPL.ir_index_tmpl cibor 			= new INSTR_TMPL.ir_index_tmpl("CIBOR", "IBOR", DC_ACT_360, BD_MOD_FOLLOWING, true, CAL_DK, CAL_DK_NAME,"DKK",2);
	INSTR_TMPL.ir_index_tenor_tmpl cibor_3m	= new INSTR_TMPL.ir_index_tenor_tmpl(cibor,"CIBOR-3M","3M",  2);
	INSTR_TMPL.ir_index_tenor_tmpl cibor_6m	= new INSTR_TMPL.ir_index_tenor_tmpl(cibor,"CIBOR-6M","6M",  2);
	
	
	INSTR_TMPL.ir_index_tmpl cdor 			= new INSTR_TMPL.ir_index_tmpl("CDOR",  "IBOR", DC_ACT_365, BD_MOD_FOLLOWING, true, CAL_CA, CAL_CA_NAME,"CAD",0);
	INSTR_TMPL.ir_index_tmpl shibor 		= new INSTR_TMPL.ir_index_tmpl("SHIBOR","IBOR", DC_ACT_360, BD_MOD_FOLLOWING, true, CAL_CN, CAL_CN_NAME,"RMB",0);

	INSTR_TMPL.ir_index_tmpl nibor 			= new INSTR_TMPL.ir_index_tmpl("NIBOR", "IBOR", DC_ACT_360, BD_MOD_FOLLOWING, true, CAL_NO, CAL_NO_NAME,"NOK",2);
	INSTR_TMPL.ir_index_tenor_tmpl nibor_3m	= new INSTR_TMPL.ir_index_tenor_tmpl(nibor,"NIBOR-3M","3M",  2);
	INSTR_TMPL.ir_index_tenor_tmpl nibor_6m	= new INSTR_TMPL.ir_index_tenor_tmpl(nibor,"NIBOR-6M","6M",  2);	

	INSTR_TMPL.ir_index_tmpl nowa_base 		= new INSTR_TMPL.ir_index_tmpl("NOWA", "RFR", DC_ACT_365, BD_FOLLOWING, false, CAL_NO, CAL_NO_NAME,"NOK",0);
	INSTR_TMPL.ir_index_tenor_tmpl nowa		= new INSTR_TMPL.ir_index_tenor_tmpl(nowa_base ,"NOWA","BD1", 0,-1);
	
	INSTR_TMPL.ir_index_tmpl usd_libor		= new INSTR_TMPL.ir_index_tmpl("USD-LIBOR","LIBOR", DC_ACT_360, BD_MOD_FOLLOWING, true, CAL_UK,CAL_UK_NAME,"USD",2,CAL_US,CAL_US_NAME);
	INSTR_TMPL.ir_index_tenor_tmpl usd_libor_3m=new INSTR_TMPL.ir_index_tenor_tmpl(usd_libor,"USD-LIBOR-3M", "3M",2);
	INSTR_TMPL.ir_index_tenor_tmpl usd_libor_1m=new INSTR_TMPL.ir_index_tenor_tmpl(usd_libor,"USD-LIBOR-1M", "1M",2);

	INSTR_TMPL.ir_index_tmpl euribor 		= new INSTR_TMPL.ir_index_tmpl("EURIBOR", "IBOR", DC_ACT_360, BD_MOD_FOLLOWING, true, CAL_TARGET,CAL_TARGET_NAME, "EUR",2);
	INSTR_TMPL.ir_index_tenor_tmpl euribor_3m= new INSTR_TMPL.ir_index_tenor_tmpl(euribor,"EURIBOR-3M","3M",  2);
	INSTR_TMPL.ir_index_tenor_tmpl euribor_6m= new INSTR_TMPL.ir_index_tenor_tmpl(euribor,"EURIBOR-6M","6M",  2);
	
	INSTR_TMPL.ir_index_tmpl eur_libor 		= new INSTR_TMPL.ir_index_tmpl("EUR-LIBOR", "LIBOR", DC_ACT_360, BD_MOD_FOLLOWING, true, CAL_TARGET, CAL_TARGET_NAME,"EUR",2);
	INSTR_TMPL.ir_index_tenor_tmpl eur_libor_3m= new INSTR_TMPL.ir_index_tenor_tmpl(eur_libor,"EUR-LIBOR-3M","3M",  2);
	INSTR_TMPL.ir_index_tenor_tmpl eur_libor_6m= new INSTR_TMPL.ir_index_tenor_tmpl(eur_libor,"EUR-LIBOR-6M","6M",  2);
		
	INSTR_TMPL.ir_index_tmpl gbp_libor 		= new INSTR_TMPL.ir_index_tmpl("GBP-LIBOR", "LIBOR", DC_ACT_365, BD_MOD_FOLLOWING, true, CAL_UK, CAL_UK_NAME,"GBP",0,CAL_UK,CAL_UK_NAME);
	INSTR_TMPL.ir_index_tenor_tmpl gbp_libor_3m= new INSTR_TMPL.ir_index_tenor_tmpl(gbp_libor,"GBP-LIBOR-3M","3M",  0);

	INSTR_TMPL.ir_index_tmpl chf_libor 		= new INSTR_TMPL.ir_index_tmpl("CHF-LIBOR", "LIBOR", DC_ACT_360, BD_MOD_FOLLOWING, true, CAL_UK, CAL_UK_NAME,"CHF",2,CAL_CH);
	INSTR_TMPL.ir_index_tmpl jpy_libor 		= new INSTR_TMPL.ir_index_tmpl("JPY-LIBOR", "LIBOR", DC_ACT_360, BD_MOD_FOLLOWING, true, CAL_UK, CAL_UK_NAME,"JPY",2,CAL_JP);
	INSTR_TMPL.ir_index_tmpl jpy_tibor 		= new INSTR_TMPL.ir_index_tmpl("JPY-TIBOR", "IBOR", DC_ACT_365, BD_MOD_FOLLOWING, true, CAL_JP, CAL_UK_NAME,"JPY",2);

	/*rfr*/
	INSTR_TMPL.ir_index_tmpl swestr_base 	= new INSTR_TMPL.ir_index_tmpl("SWESTR", "RFR", DC_ACT_360, BD_FOLLOWING, false, CAL_SE, CAL_SE_NAME,"SEK",0);
	INSTR_TMPL.ir_index_tenor_tmpl swestr	= new INSTR_TMPL.ir_index_tenor_tmpl(swestr_base ,"SWESTR","BD1", 0,-1);
	
	INSTR_TMPL.ir_index_tmpl effr_base 	= new INSTR_TMPL.ir_index_tmpl("EFFR","RFR", DC_ACT_360, BD_FOLLOWING, false, CAL_US, CAL_US_NAME,"USD",0);
	INSTR_TMPL.ir_index_tenor_tmpl effr	= new INSTR_TMPL.ir_index_tenor_tmpl(effr_base ,"EFFR","BD1", 0, -1);/*Effective Federal Funding Rate = EFFR*/

	INSTR_TMPL.ir_index_tmpl sofr_base 	= new INSTR_TMPL.ir_index_tmpl("SOFR","RFR", DC_ACT_360, BD_FOLLOWING, false, CAL_SOFR_US, CAL_SOFR_US_NAME,"USD",0);
	INSTR_TMPL.ir_index_tenor_tmpl sofr	= new INSTR_TMPL.ir_index_tenor_tmpl(sofr_base ,"SOFR","BD1", 0, -1);

	INSTR_TMPL.ir_index_tmpl sofr_idx_base 	= new INSTR_TMPL.ir_index_tmpl("SOFR","RFRCOMPIDX", DC_ACT_360, BD_FOLLOWING, false, CAL_SOFR_US, CAL_SOFR_US_NAME,"USD",0);
	INSTR_TMPL.ir_index_tenor_tmpl sofr_idx	= new INSTR_TMPL.ir_index_tenor_tmpl(sofr_idx_base ,"SOFR","BD1", 0, -1);
	
	INSTR_TMPL.ir_index_tmpl au_oncash_base 	= new INSTR_TMPL.ir_index_tmpl("AONIA","RFR", DC_ACT_365, BD_FOLLOWING, false, CAL_AU, CAL_AU_NAME,"AUD",0);
	INSTR_TMPL.ir_index_tenor_tmpl au_oncash	= new INSTR_TMPL.ir_index_tenor_tmpl(au_oncash_base ,"AONIA","BD1", 0, -1);

	INSTR_TMPL.ir_index_tmpl estr_base 	= new INSTR_TMPL.ir_index_tmpl("ESTR","RFR", DC_ACT_360, BD_FOLLOWING, false, CAL_TARGET, CAL_TARGET_NAME,"EUR",0);
	INSTR_TMPL.ir_index_tenor_tmpl estr	= new INSTR_TMPL.ir_index_tenor_tmpl(estr_base ,"ESTR","BD1", 0, -1);

	INSTR_TMPL.ir_index_tmpl destr_base 	= new INSTR_TMPL.ir_index_tmpl("DESTR","RFR", DC_ACT_360, BD_FOLLOWING, false, CAL_DK, CAL_DK_NAME,"DKK",0);
	INSTR_TMPL.ir_index_tenor_tmpl destr	= new INSTR_TMPL.ir_index_tenor_tmpl(estr_base ,"DESTR","BD1", 0, -1);
	
	INSTR_TMPL.ir_index_tmpl eonia_base 	= new INSTR_TMPL.ir_index_tmpl("EONIA", "RFR", DC_ACT_360, BD_FOLLOWING, false, CAL_TARGET, CAL_TARGET_NAME,"EUR",0);
	INSTR_TMPL.ir_index_tenor_tmpl eonia	= new INSTR_TMPL.ir_index_tenor_tmpl(eonia_base ,"EONIA","BD1", 0);/*old eonia*/
	INSTR_TMPL.ir_index_tenor_tmpl eonia_estr	= new INSTR_TMPL.ir_index_tenor_tmpl(eonia_base ,"EONIA+","BD1", 0,-1, 8.5);
	
	INSTR_TMPL.ir_index_tmpl sonia_base 	= new INSTR_TMPL.ir_index_tmpl("SONIA","RFR", DC_ACT_365, BD_FOLLOWING, false, CAL_UK, CAL_UK_NAME,"GBP",0);
	INSTR_TMPL.ir_index_tenor_tmpl sonia	= new INSTR_TMPL.ir_index_tenor_tmpl(sonia_base ,"SONIA","BD1", 0, -1);

	INSTR_TMPL.ir_index_tmpl saron_base 	= new INSTR_TMPL.ir_index_tmpl("SARON","RFR", DC_ACT_360, BD_FOLLOWING, false, CAL_CH, CAL_CH_NAME, "CHF",0);
	INSTR_TMPL.ir_index_tenor_tmpl saron	= new INSTR_TMPL.ir_index_tenor_tmpl(saron_base ,"SARON","BD1", 0);

	INSTR_TMPL.ir_index_tmpl tonar_base 	= new INSTR_TMPL.ir_index_tmpl("TONAR","RFR", DC_ACT_365, BD_FOLLOWING, false, CAL_JP, CAL_JP_NAME,"JPY",0);
	INSTR_TMPL.ir_index_tenor_tmpl tonar	= new INSTR_TMPL.ir_index_tenor_tmpl(tonar_base ,"TONAR","BD1", 0,-1);

	
}

module INSTR_TMPL_DEPO 
{

	INSTR_TMPL.deposit_def_tmpl depo_swe 	= new INSTR_TMPL.deposit_def_tmpl("DEPO_SWE",   DC_ACT_360, BD_MOD_FOLLOWING, 
																				true, "BD2",null<string>,CAL_SE,"SEK");
	INSTR_TMPL.deposit_def_tmpl depo_swe_on = new INSTR_TMPL.deposit_def_tmpl("DEPO_SWE_ON",   DC_ACT_360, BD_MOD_FOLLOWING,  
																				false, "BD0","BD1",CAL_SE,"SEK");
	INSTR_TMPL.deposit_def_tmpl depo_swe_tn = new INSTR_TMPL.deposit_def_tmpl("DEPO_SWE_TN",   DC_ACT_360, BD_MOD_FOLLOWING,  
																				false, "BD1","BD1",CAL_SE,"SEK");
	INSTR_TMPL.deposit_def_tmpl depo_swe_sn = new INSTR_TMPL.deposit_def_tmpl("DEPO_SWE_SN",   DC_ACT_360, BD_MOD_FOLLOWING,  
																				false, "BD2","BD1",CAL_SE,"SEK");

	INSTR_TMPL.deposit_def_tmpl depo_eur 	= new INSTR_TMPL.deposit_def_tmpl("DEPO_EUR",   DC_ACT_360, BD_MOD_FOLLOWING,  
																				true, "BD2",null<string>,CAL_TARGET,"EUR");
	INSTR_TMPL.deposit_def_tmpl depo_eur_on = new INSTR_TMPL.deposit_def_tmpl("DEPO_EUR_ON",DC_ACT_360, BD_FOLLOWING,      
																				false,"BD0","BD1",CAL_TARGET,"EUR");
	INSTR_TMPL.deposit_def_tmpl depo_eur_tn = new INSTR_TMPL.deposit_def_tmpl("DEPO_EUR_TN",DC_ACT_360, BD_FOLLOWING,      
																				false,"BD1","BD1",CAL_TARGET,"EUR");
	INSTR_TMPL.deposit_def_tmpl depo_eur_sn = new INSTR_TMPL.deposit_def_tmpl("DEPO_EUR_SN",DC_ACT_360, BD_FOLLOWING,      
																				false,"BD2","BD1",CAL_TARGET,"EUR");

	INSTR_TMPL.deposit_def_tmpl depo_dol 	= new INSTR_TMPL.deposit_def_tmpl("DEPO_USD",   DC_ACT_360, BD_MOD_FOLLOWING,  
																				true, "BD2",null<string>,CAL_US,   "USD");
	INSTR_TMPL.deposit_def_tmpl depo_dol_on = new INSTR_TMPL.deposit_def_tmpl("DEPO_USD_ON",   DC_ACT_360, BD_MOD_FOLLOWING,  
																				false, "BD0","BD1",CAL_US,   "USD");
	INSTR_TMPL.deposit_def_tmpl depo_dol_tn = new INSTR_TMPL.deposit_def_tmpl("DEPO_USD_TN",   DC_ACT_360, BD_MOD_FOLLOWING,  
																				false, "BD1","BD1", CAL_US,  "USD");
	INSTR_TMPL.deposit_def_tmpl depo_dol_sn = new INSTR_TMPL.deposit_def_tmpl("DEPO_USD_SN",   DC_ACT_360, BD_MOD_FOLLOWING,  
																				false, "BD2","BD1", CAL_US,  "USD");

	INSTR_TMPL.deposit_def_tmpl depo_lib_dol 	= new INSTR_TMPL.deposit_def_tmpl("DEPO_LIB_USD", DC_ACT_360, BD_MOD_FOLLOWING,  
																				true, "BD2",null<string>,CAL_UK,"USD", true, CAL_US);
	INSTR_TMPL.deposit_def_tmpl depo_lib_dol_on	= new INSTR_TMPL.deposit_def_tmpl("DEPO_LIB_USD_ON", DC_ACT_360, BD_MOD_FOLLOWING,  
																				false, "BD0","BD1",CAL_UK,"USD", true, CAL_US);
	INSTR_TMPL.deposit_def_tmpl depo_lib_dol_tn	= new INSTR_TMPL.deposit_def_tmpl("DEPO_LIB_USD_TN", DC_ACT_360, BD_MOD_FOLLOWING,  
																				false, "BD1","BD1",CAL_UK,"USD", true, CAL_US);
	INSTR_TMPL.deposit_def_tmpl depo_lib_dol_sn	= new INSTR_TMPL.deposit_def_tmpl("DEPO_LIB_USD_SN", DC_ACT_360, BD_MOD_FOLLOWING,  
																				false, "BD2","BD1",CAL_UK,"USD", true, CAL_US);

}

module INSTR_TMPL_RIBA 
{
	INSTR_TMPL.riba_def_tmpl riba = new INSTR_TMPL.riba_def_tmpl("RIBA", null<date>,null<string>,null<date>,
																"IMM1",false,DC_ACT_360, CAL_SE,"SEK");
	INSTR_TMPL.riba_def_tmpl riba_c1 = new INSTR_TMPL.riba_def_tmpl("RIBA", null<date>,"BD2;IMM1",null<date>,
																"IMM1",false,DC_ACT_360, CAL_SE,"SEK");
	INSTR_TMPL.riba_def_tmpl riba_c2 = new INSTR_TMPL.riba_def_tmpl("RIBA", null<date>,"BD2;IMM2",null<date>,
																"IMM1",false,DC_ACT_360, CAL_SE,"SEK");
}

module INSTR_TMPL_FRA 
{
	/*se*/
	INSTR_TMPL.fra_def_tmpl fra_swe_3m = new INSTR_TMPL.fra_def_tmpl("FRA_SWE", null<date>, null<string>,
																	null<date>, null<string>, null<logical>,DC_ACT_360, BD_MOD_FOLLOWING,true,  
																	CAL_SE,"SEK",fra_calc_method.BBA, INSTR_TMPL_IR_INDEX.stibor_3m);

	INSTR_TMPL.fra_def_tmpl fra_swe_6m = new INSTR_TMPL.fra_def_tmpl("FRA_SWE", null<date>, null<string>,
																	null<date>, null<string>, null<logical>,DC_ACT_360, BD_MOD_FOLLOWING,true,  
																	CAL_SE,"SEK",fra_calc_method.BBA, INSTR_TMPL_IR_INDEX.stibor_6m);
	
	INSTR_TMPL.fra_def_tmpl fra_swe_imm = new INSTR_TMPL.fra_def_tmpl("FRA_SWE_IMM",  null<date>,null<string>, 
																	null<date>,"IMM1", false, DC_ACT_360, BD_MOD_FOLLOWING, true, 
																	CAL_SE,"SEK",fra_calc_method.BBA, INSTR_TMPL_IR_INDEX.stibor_3m);

	INSTR_TMPL.fra_def_tmpl fra_swe_imm_c1 = new INSTR_TMPL.fra_def_tmpl("FRA_SWE_IMM",  null<date>,"BD2;IMM1", 
																	null<date>,"IMM1", false, DC_ACT_360, BD_MOD_FOLLOWING, true, 
																	CAL_SE,"SEK",fra_calc_method.BBA, INSTR_TMPL_IR_INDEX.stibor_3m);

	INSTR_TMPL.fra_def_tmpl fra_swe_imm_c2 = new INSTR_TMPL.fra_def_tmpl("FRA_SWE_IMM",  null<date>,"BD2;IMM2", 
																	null<date>,"IMM1", false, DC_ACT_360, BD_MOD_FOLLOWING, true, 
																	CAL_SE,"SEK",fra_calc_method.BBA, INSTR_TMPL_IR_INDEX.stibor_3m);

	INSTR_TMPL.fra_def_tmpl fra_swe_3x6 = new INSTR_TMPL.fra_def_tmpl("FRA_SWE_3X6",  null<date>,"BD2;3M",     
																	null<date>,"BD2;6M", true, DC_ACT_360, BD_MOD_FOLLOWING, true,  
																	CAL_SE,"SEK",fra_calc_method.BBA, INSTR_TMPL_IR_INDEX.stibor_3m);

	/*eur*/
	INSTR_TMPL.fra_def_tmpl fra_eur_3m = new INSTR_TMPL.fra_def_tmpl("FRA_EUR", null<date>, null<string>,
																	null<date>, null<string>, null<logical>,DC_ACT_360, BD_MOD_FOLLOWING,true,  
																	CAL_TARGET,"EUR",fra_calc_method.BBA, INSTR_TMPL_IR_INDEX.euribor_3m);

	/*NOK*/
	INSTR_TMPL.fra_def_tmpl fra_nok_3m = new INSTR_TMPL.fra_def_tmpl("FRA_NOK3M", null<date>, null<string>,
																	null<date>, null<string>, null<logical>,DC_ACT_360, BD_MOD_FOLLOWING,true,  
																	CAL_NO,"NOK",fra_calc_method.BBA, INSTR_TMPL_IR_INDEX.nibor_3m);

	INSTR_TMPL.fra_def_tmpl fra_nok_6m = new INSTR_TMPL.fra_def_tmpl("FRA_NOK6M", null<date>, null<string>,
																	null<date>, null<string>, null<logical>,DC_ACT_360, BD_MOD_FOLLOWING,true,  
																	CAL_NO,"NOK",fra_calc_method.BBA, INSTR_TMPL_IR_INDEX.nibor_6m);

}

module INSTR_TMPL_IRFUT 
{
	/*STIBOR FUTURES - Nasdaq*/
	INSTR_TMPL.irfut_def_tmpl stibfut_swe = new INSTR_TMPL.irfut_def_tmpl(	"STIBFUT_SWE", null<date>,null<string>,"IMM1", DC_ACT_360, BD_MOD_FOLLOWING, true, 
																			CAL_SE,"SEK",irfut_calc_method.FRA, fut_tick_value_style.PERIOD,quote_style.
																			YIELD_PCT, 1000000, 0.0001, INSTR_TMPL_IR_INDEX.stibor_3m);
	/*Eurodollar Futures - CME*/
	INSTR_TMPL.irfut_def_tmpl usdliborfut_3m = new INSTR_TMPL.irfut_def_tmpl("USD_LIBOR_3M", null<date>,null<string>,null<string>,DC_ACT_360, BD_MOD_FOLLOWING, true, 
																			CAL_UK,"USD", irfut_calc_method.IR_FUTURE,fut_tick_value_style.FIX_90_360,quote_style.
																			EDFUT, 1000000, 0.00005,INSTR_TMPL_IR_INDEX.usd_libor_3m);
	INSTR_TMPL.irfut_def_tmpl usdliborfut_1m = new INSTR_TMPL.irfut_def_tmpl("USD_LIBOR_1M", null<date>,null<string>,null<string>,DC_ACT_360, BD_MOD_FOLLOWING, true, 
																			CAL_UK,"USD", irfut_calc_method.IR_FUTURE,fut_tick_value_style.FIX_30_360,quote_style.
																			EDFUT, 1000000, 0.00005,INSTR_TMPL_IR_INDEX.usd_libor_1m);	
	/*EUREX Three-Month EURIBOR Futures*/
	INSTR_TMPL.irfut_def_tmpl euriborfut_3m = new INSTR_TMPL.irfut_def_tmpl("EUREX_3M", null<date>,null<string>,null<string>,DC_ACT_360, BD_MOD_FOLLOWING, true, 
																			CAL_TARGET,"EUR", irfut_calc_method.IR_FUTURE,fut_tick_value_style.FIX_90_360,quote_style.
																			EDFUT, 1000000,  0.00005,INSTR_TMPL_IR_INDEX.euribor_3m);	
	/*THREE MONTH STERLING (SHORT STERLING) FUTURE - ICE*/
	INSTR_TMPL.irfut_def_tmpl gbpliborfut_3m = new INSTR_TMPL.irfut_def_tmpl("GBP_LIBOR_3M", null<date>,null<string>,null<string>,DC_ACT_365, BD_MOD_FOLLOWING, true, 
																			CAL_UK,"GBP", irfut_calc_method.IR_FUTURE,fut_tick_value_style.FIX_9125_365,quote_style.
																			EDFUT, 500000, 0.00005,INSTR_TMPL_IR_INDEX.gbp_libor_3m);
}

module INSTR_TMPL_BILL 
{
	INSTR_TMPL.bill_def_tmpl bill_swe = new INSTR_TMPL.bill_def_tmpl("SWEBILL", bill_yld_method.SIMPLE, DC_ACT_360, null<string>, 
									null<bill_cpn_type>,"BD2",CAL_SE,"SEK",	quote_style.YIELD_PCT);
}

module INSTR_TMPL_BOND 
{
	INSTR_TMPL.bond_def_tmpl bond_swe = new INSTR_TMPL.bond_def_tmpl("SWE_BOND", bond_yld_method.ISMA, 1, DC_30E_360, false, "BD4",first_cpn_type.REG, last_per_yld_method.SIMPLE, 
																	next_per_yld_method.EFFECTIVE,odd_last_cpn_type.REG,"BD2",CAL_SE,"SEK",	quote_style.YIELD_PCT);

	INSTR_TMPL.bond_def_tmpl odd_first_bond_swe = new INSTR_TMPL.bond_def_tmpl(	"SWE_BOND_ODD", bond_yld_method.ISMA, 1, DC_30E_360, false, "BD4",first_cpn_type.PROP_BOND, 
																				last_per_yld_method.SIMPLE, next_per_yld_method.EFFECTIVE,
																				odd_last_cpn_type.REG,"BD2",CAL_SE,"SEK",quote_style.YIELD_PCT);

	INSTR_TMPL.bond_def_tmpl bund_ger = new INSTR_TMPL.bond_def_tmpl("BUND", bond_yld_method.ISMA, 1, DC_ACT_ACT, false, "BD0",first_cpn_type.PROP_BOND, last_per_yld_method.NONE, 
																	next_per_yld_method.EFFECTIVE,odd_last_cpn_type.REG,"BD2",CAL_TARGET,"EUR",	quote_style.CLEAN_PCT);


}

module INSTR_TMPL_ZERO 
{
	INSTR_TMPL.zero_def_tmpl zero_swe = new INSTR_TMPL.zero_def_tmpl("SWE_ZERO", zero_yld_method.EFFECTIVE, 1, DC_30E_360, "BD2",CAL_SE,"SEK",quote_style.YIELD_PCT);

}

module INSTR_TMPL_IL_BOND 
{
	INSTR_TMPL.il_bond_def_tmpl il_bond_swe = new INSTR_TMPL.il_bond_def_tmpl(	"SWE_IL_BOND", il_bond_yld_method.ISMA, infl_index_method.LAG_3M_IP_SE, 1, DC_30E_360, false, "BD4",
																				first_cpn_type.REG, last_per_yld_method.SIMPLE, next_per_yld_method.EFFECTIVE, odd_last_cpn_type.REG,
																				"BD2",CAL_SE,"SEK",	quote_style.YIELD_PCT);

}

module INSTR_TMPL_IL_ZERO /*zero bond*/
{
	INSTR_TMPL.il_zero_def_tmpl il_zero_swe = new INSTR_TMPL.il_zero_def_tmpl(	"SWE_IL_ZERO", il_zero_yld_method.EFFECTIVE, infl_index_method.LAG_3M_IP_SE, 1, DC_30E_360, 
																				"BD2",CAL_SE,"SEK",quote_style.YIELD_PCT);
}


module INSTR_TMPL_SWAP_IL_ZERO 
{
	INSTR_TMPL.swap_il_zero_def_tmpl infl_z_swap_swe = new INSTR_TMPL.swap_il_zero_def_tmpl("SWE_INFL_SWAP",  "SEK",CAL_SE, BD_MOD_FOLLOWING, 
																							"BD2",err_int(),infl_index_method.LAG_3M_IP);

	INSTR_TMPL.swap_il_zero_def_tmpl infl_z_swap_5y_swe = new INSTR_TMPL.swap_il_zero_def_tmpl("SWE_INFL_SWAP", "SEK",CAL_SE, BD_MOD_FOLLOWING, 
																							"BD2",5,infl_index_method.LAG_3M_IP);
}


module INSTR_TMPL_IL_YY
{
	
	INSTR_TMPL.swap_il_fixyy_def_tmpl il_fixyy_swe = new INSTR_TMPL.swap_il_fixyy_def_tmpl(	"SWE_IL_FIXYY", "BD2", null<string>,1, DC_30E_360, "SEK",CAL_SE,
																							BD_MOD_FOLLOWING,true,infl_index_method.LAG_3M_IP);
		
}

module INSTR_TMPL_FRN 
{
	INSTR_TMPL.frn_def_tmpl frn_swe = new INSTR_TMPL.frn_def_tmpl(	"SWE_FRN", 4, frn_roll_method.STRAIGHT,DC_ACT_360, BD_MOD_FOLLOWING, CAL_SE,true, 
																	"BD4","BD2","SEK",frn_neg_rate_rule.NEG_CPN_FLOOR, INSTR_TMPL_IR_INDEX.stibor_3m);

	/*rfr frn's, work in progress*/
	INSTR_TMPL.frn_def_tmpl frn_swestr = new INSTR_TMPL.frn_def_tmpl("SWE_FRN", 4, frn_roll_method.STRAIGHT,DC_ACT_360, BD_MOD_FOLLOWING, CAL_SE,true, 
																	"BD0","BD2","SEK",frn_neg_rate_rule.NEG_CPN_FLOOR,
																	 INSTR_TMPL_IR_INDEX.swestr, rfr_arrears_type.PLAIN,0);

	INSTR_TMPL.frn_def_tmpl frn_sofr_avg = new INSTR_TMPL.frn_def_tmpl("SOFR_FRN_AVG", 4, frn_roll_method.STRAIGHT,DC_ACT_360, BD_MOD_FOLLOWING, CAL_US,true, 
																	"BD0","BD2","USD",frn_neg_rate_rule.NEG_CPN_FLOOR,
																	 INSTR_TMPL_IR_INDEX.sofr, rfr_arrears_type.LOCKOUT,2,false);

	INSTR_TMPL.frn_def_tmpl frn_sofr_comp = new INSTR_TMPL.frn_def_tmpl("SOFR_FRN_COMP", 4, frn_roll_method.STRAIGHT,DC_ACT_360, BD_MOD_FOLLOWING, CAL_US,true, 
																	"BD0","BD2","USD",frn_neg_rate_rule.NEG_CPN_FLOOR,
																	 INSTR_TMPL_IR_INDEX.sofr, rfr_arrears_type.LOOKBACKSHIFT,2);

	INSTR_TMPL.frn_def_tmpl frn_sofr_ms = new INSTR_TMPL.frn_def_tmpl("SOFR_FRN_MS", 4, frn_roll_method.STRAIGHT,DC_ACT_360, BD_MOD_FOLLOWING, CAL_US,true, 
																	"BD0","BD2","USD",frn_neg_rate_rule.NEG_CPN_FLOOR,
																	 INSTR_TMPL_IR_INDEX.sofr, rfr_arrears_type.LOCKOUT,2,true,
																	 2,true);//morgan stanley issue

	INSTR_TMPL.frn_def_tmpl frn_sonia = new INSTR_TMPL.frn_def_tmpl("SONIA_FRN", 4, frn_roll_method.STRAIGHT,DC_ACT_365, BD_MOD_FOLLOWING, CAL_UK,true, 
																	"BD0","BD2","GBP",frn_neg_rate_rule.NEG_CPN_FLOOR,
																	 INSTR_TMPL_IR_INDEX.sonia, rfr_arrears_type.LOOKBACKLAG,5);
	
	INSTR_TMPL.frn_def_tmpl frn_estr = new INSTR_TMPL.frn_def_tmpl("ESTR_FRN", 4, frn_roll_method.STRAIGHT,DC_ACT_360, BD_MOD_FOLLOWING, CAL_TARGET,true, 
																	"BD0","BD2","EUR",frn_neg_rate_rule.NEG_CPN_FLOOR,
																	 INSTR_TMPL_IR_INDEX.estr, rfr_arrears_type.LOOKBACKLAG,5);
}

module INSTR_TMPL_SWAP_FIXFLT 
{
	INSTR_TMPL.swap_fixflt_def_tmpl fixflt_swe = new INSTR_TMPL.swap_fixflt_def_tmpl("SWE_FIXFLT","BD2",null<string>,null<string>, 1, DC_30E_360, interest_rule.IR_MATURITY_NOADJ,"SEK",
																					 CAL_SE, BD_MOD_FOLLOWING, false, 4,4, DC_ACT_360, interest_rule.IR_MATURITY_NOADJ,
																					"SEK",CAL_SE, BD_MOD_FOLLOWING, false, null<flt_comp_avg_type>, null<flt_sprd_comp_method>,
																					null<flt_avg_method>,null<notional_exchg_style>,null<flt_stub_fwd_style>,INSTR_TMPL_IR_INDEX.stibor_3m);

	INSTR_TMPL.swap_fixflt_def_tmpl fixflt3m_swe = new INSTR_TMPL.swap_fixflt_def_tmpl("SWE_FIXFLT_3M","BD2",null<string>,null<string>, 1, DC_30E_360, interest_rule.IR_MATURITY_NOADJ, "SEK",
																					   CAL_SE, BD_MOD_FOLLOWING, false, 4,4, DC_ACT_360, interest_rule.IR_MATURITY_NOADJ,
																					"SEK",CAL_SE, BD_MOD_FOLLOWING, false, null<flt_comp_avg_type>, null<flt_sprd_comp_method>,
																					null<flt_avg_method>,null<notional_exchg_style>,null<flt_stub_fwd_style>,INSTR_TMPL_IR_INDEX.stibor_3m);
	
	INSTR_TMPL.swap_fixflt_def_tmpl fixflt6m_swe = new INSTR_TMPL.swap_fixflt_def_tmpl("SWE_FIXFLT_6M","BD2",null<string>,null<string>, 1, DC_30E_360, interest_rule.IR_MATURITY_NOADJ, "SEK",
																					   CAL_SE, BD_MOD_FOLLOWING, false, 2,2, DC_ACT_360, interest_rule.IR_MATURITY_NOADJ,
																					"SEK",CAL_SE, BD_MOD_FOLLOWING, false, null<flt_comp_avg_type>, null<flt_sprd_comp_method>,
																					null<flt_avg_method>,null<notional_exchg_style>,null<flt_stub_fwd_style>,INSTR_TMPL_IR_INDEX.stibor_6m);

	
		
	INSTR_TMPL.swap_fixflt_def_tmpl fixflt3m_nok = new INSTR_TMPL.swap_fixflt_def_tmpl("NOK_FIXFLT_3M","BD2",null<string>,null<string>, 1, DC_30E_360, interest_rule.IR_MATURITY_NOADJ, "NOK",
																					   CAL_NO, BD_MOD_FOLLOWING, false, 4,4, DC_ACT_360, interest_rule.IR_MATURITY_NOADJ,
																						"NOK",CAL_NO, BD_MOD_FOLLOWING, false, null<flt_comp_avg_type>, null<flt_sprd_comp_method>,
																						null<flt_avg_method>,null<notional_exchg_style>,flt_stub_fwd_style.FSF_CPN_DATES,INSTR_TMPL_IR_INDEX.nibor_3m);

	INSTR_TMPL.swap_fixflt_def_tmpl fixflt6m_nok = new INSTR_TMPL.swap_fixflt_def_tmpl("NOK_FIXFLT_6M","BD2",null<string>,null<string>, 1, DC_30E_360, interest_rule.IR_MATURITY_NOADJ, "NOK",
																					   CAL_NO, BD_MOD_FOLLOWING, false, 2,2, DC_ACT_360, interest_rule.IR_MATURITY_NOADJ,
																						"NOK",CAL_NO, BD_MOD_FOLLOWING, false, null<flt_comp_avg_type>, null<flt_sprd_comp_method>,
																						null<flt_avg_method>,null<notional_exchg_style>,flt_stub_fwd_style.FSF_CPN_DATES,INSTR_TMPL_IR_INDEX.nibor_6m);

	INSTR_TMPL.swap_fixflt_def_tmpl fixflt3m_dkk = new INSTR_TMPL.swap_fixflt_def_tmpl("DKK_FIXFLT_3M","BD2",null<string>,null<string>, 1, DC_30E_360, interest_rule.IR_MATURITY_NOADJ, "DKK",
																					   CAL_DK, BD_MOD_FOLLOWING, false, 4,4, DC_ACT_360, interest_rule.IR_MATURITY_NOADJ,
																						"DKK",CAL_DK, BD_MOD_FOLLOWING, false, null<flt_comp_avg_type>, null<flt_sprd_comp_method>,
																						null<flt_avg_method>,null<notional_exchg_style>,null,INSTR_TMPL_IR_INDEX.cibor_3m);

	INSTR_TMPL.swap_fixflt_def_tmpl fixflt6m_dkk = new INSTR_TMPL.swap_fixflt_def_tmpl("DKK_FIXFLT_6M","BD2",null<string>,null<string>, 1, DC_30E_360, interest_rule.IR_MATURITY_NOADJ, "DKK",
																					   CAL_DK, BD_MOD_FOLLOWING, false, 2,2, DC_ACT_360, interest_rule.IR_MATURITY_NOADJ,
																						"DKK",CAL_DK, BD_MOD_FOLLOWING, false, null<flt_comp_avg_type>, null<flt_sprd_comp_method>,
																						null<flt_avg_method>,null<notional_exchg_style>,null,INSTR_TMPL_IR_INDEX.cibor_6m);
	
	INSTR_TMPL.swap_fixflt_def_tmpl fixflt_5y_swe = new INSTR_TMPL.swap_fixflt_def_tmpl("SWE_FIXFLT","BD2",null<string>,"5Y", 1, DC_30E_360, interest_rule.IR_MATURITY_NOADJ, "SEK",
																						CAL_SE, BD_MOD_FOLLOWING, false, 4,4, DC_ACT_360, interest_rule.IR_MATURITY_NOADJ,
																						"SEK",CAL_SE, BD_MOD_FOLLOWING, false, null<flt_comp_avg_type>, null<flt_sprd_comp_method>,
																						null<flt_avg_method>,null<notional_exchg_style>,null,INSTR_TMPL_IR_INDEX.stibor_3m);

	INSTR_TMPL.swap_fixflt_def_tmpl fixflt_5y_swe_ne = new INSTR_TMPL.swap_fixflt_def_tmpl("SWE_FIXFLT","BD2",null<string>,"5Y", 1, DC_30E_360, interest_rule.IR_MATURITY_NOADJ, "SEK",
																						   CAL_SE, BD_MOD_FOLLOWING, false, 4,4, DC_ACT_360, interest_rule.IR_MATURITY_NOADJ,
																						"SEK",CAL_SE, BD_MOD_FOLLOWING, false, null<flt_comp_avg_type>, null<flt_sprd_comp_method>,
																						null<flt_avg_method>,NE_END,null,INSTR_TMPL_IR_INDEX.stibor_3m);


	INSTR_TMPL.swap_fixflt_def_tmpl fixflt_6m5y_swe = new INSTR_TMPL.swap_fixflt_def_tmpl("SWE_FIXFLT","BD2","6M","5Y", 1, DC_30E_360, interest_rule.IR_MATURITY_NOADJ, "SEK",
																						  CAL_SE, BD_MOD_FOLLOWING, false, 4,4, DC_ACT_360, interest_rule.IR_MATURITY_NOADJ,
																					"SEK",CAL_SE, BD_MOD_FOLLOWING, false, null<flt_comp_avg_type>, null<flt_sprd_comp_method>,
																					null<flt_avg_method>,null<notional_exchg_style>,null,INSTR_TMPL_IR_INDEX.stibor_3m);


	INSTR_TMPL.swap_fixflt_def_tmpl fixflt_eur = new INSTR_TMPL.swap_fixflt_def_tmpl("EUR_FIXFLT","BD2",null<string>,null<string>, 1, DC_30E_360, interest_rule.IR_MATURITY_NOADJ, "EUR",
																					 CAL_TARGET, BD_MOD_FOLLOWING, false, 2,2, DC_ACT_360, interest_rule.IR_MATURITY_NOADJ,
																					"EUR",CAL_TARGET, BD_MOD_FOLLOWING, false, null<flt_comp_avg_type>, null<flt_sprd_comp_method>,
																					null<flt_avg_method>,null<notional_exchg_style>,null,INSTR_TMPL_IR_INDEX.euribor_6m);

	INSTR_TMPL.swap_fixflt_def_tmpl fixflt3m_eur = new INSTR_TMPL.swap_fixflt_def_tmpl("EUR_FIXFLT","BD2",null<string>,null<string>, 1, DC_30E_360, interest_rule.IR_MATURITY_NOADJ, "EUR",
																					   CAL_TARGET, BD_MOD_FOLLOWING, false, 4,4, DC_ACT_360, interest_rule.IR_MATURITY_NOADJ,
																					"EUR",CAL_TARGET, BD_MOD_FOLLOWING, false, null<flt_comp_avg_type>, null<flt_sprd_comp_method>,
																					null<flt_avg_method>,null<notional_exchg_style>,null,INSTR_TMPL_IR_INDEX.euribor_3m);

	INSTR_TMPL.swap_fixflt_def_tmpl fixflt6m_eur = new INSTR_TMPL.swap_fixflt_def_tmpl("EUR_FIXFLT","BD2",null<string>,null<string>, 1, DC_30E_360, interest_rule.IR_MATURITY_NOADJ, "EUR",
																					   CAL_TARGET, BD_MOD_FOLLOWING, false, 2,2, DC_ACT_360, interest_rule.IR_MATURITY_NOADJ,
																					"EUR",CAL_TARGET, BD_MOD_FOLLOWING, false, null<flt_comp_avg_type>, null<flt_sprd_comp_method>,
																					null<flt_avg_method>,null<notional_exchg_style>,null,INSTR_TMPL_IR_INDEX.euribor_6m);
	
	
	INSTR_TMPL.swap_fixflt_def_tmpl fixflt_eur_swe = new INSTR_TMPL.swap_fixflt_def_tmpl("EURSWE_FIXFLT","BD2",null<string>,null<string>, 1, DC_30E_360, interest_rule.IR_MATURITY_NOADJ, "EUR",
																						 CAL_TARGET, BD_MOD_FOLLOWING, false, 4,4, DC_ACT_360, interest_rule.IR_MATURITY_NOADJ,
																					"SEK",CAL_SE, BD_MOD_FOLLOWING, false, null<flt_comp_avg_type>, null<flt_sprd_comp_method>,
																					null<flt_avg_method>,NE_BOTH,null,INSTR_TMPL_IR_INDEX.stibor_3m);

	INSTR_TMPL.swap_fixflt_def_tmpl fixflt_us_sb = new INSTR_TMPL.swap_fixflt_def_tmpl("US_FIXFLT_SB","BD2",null<string>,null<string>, 2, DC_30E_360, interest_rule.IR_MATURITY_NOADJ, "USD",
																					   CAL_US, BD_MOD_FOLLOWING, false, 4,4, DC_ACT_360, interest_rule.IR_MATURITY_NOADJ,
																						"USD",CAL_US, BD_MOD_FOLLOWING, false, null<flt_comp_avg_type>, null<flt_sprd_comp_method>,
																						null<flt_avg_method>,null<notional_exchg_style>,null,INSTR_TMPL_IR_INDEX.usd_libor_3m);

}

module INSTR_TMPL_SWAP_ZEROFLT 
{
	INSTR_TMPL.swap_zeroflt_def_tmpl zeroflt_swe = new INSTR_TMPL.swap_zeroflt_def_tmpl("SWE_ZEROFLT", "BD2",null,null<string>,DC_30E_360, "SEK",CAL_SE, BD_MOD_FOLLOWING, false, 1, 4, DC_ACT_360, 
																						interest_rule.IR_MATURITY_NOADJ,"SEK",CAL_SE, BD_MOD_FOLLOWING, false, 
																						null<notional_exchg_style>,INSTR_TMPL_IR_INDEX.stibor_3m);

	INSTR_TMPL.swap_zeroflt_def_tmpl zeroflt_swe_0 = new INSTR_TMPL.swap_zeroflt_def_tmpl("SWE_ZEROFLT", "BD2",null,null<string>,DC_30E_360, "SEK",CAL_SE, BD_MOD_FOLLOWING, false, 0, 4, DC_ACT_360, 
																						interest_rule.IR_MATURITY_NOADJ,"SEK",CAL_SE, BD_MOD_FOLLOWING, false, 
																						null<notional_exchg_style>,INSTR_TMPL_IR_INDEX.stibor_3m);

	INSTR_TMPL.swap_zeroflt_def_tmpl zeroflt_swe_1 = new INSTR_TMPL.swap_zeroflt_def_tmpl("SWE_ZEROFLT", "BD2",null,null<string>,DC_30E_360, "SEK",CAL_SE, BD_MOD_FOLLOWING, false, -1, 4, DC_ACT_360, 
																						interest_rule.IR_MATURITY_NOADJ,"SEK",CAL_SE, BD_MOD_FOLLOWING, false, 
																						null<notional_exchg_style>,INSTR_TMPL_IR_INDEX.stibor_3m);
	INSTR_TMPL.swap_zeroflt_def_tmpl zeroflt_swe_2 = new INSTR_TMPL.swap_zeroflt_def_tmpl("SWE_ZEROFLT", "BD2",null,null<string>,DC_30E_360, "SEK",CAL_SE, BD_MOD_FOLLOWING, false, 12, 4, DC_ACT_360, 
																						interest_rule.IR_MATURITY_NOADJ,"SEK",CAL_SE, BD_MOD_FOLLOWING, false, 
																						null<notional_exchg_style>,INSTR_TMPL_IR_INDEX.stibor_3m);

}
module INSTR_TMPL_SWAP_FLTFLT 
//Note: this is NOT a basis swap quoted as a spread between two fixed legs
//use leg1 as the leg with a spread
{
	/*SEK*/
	INSTR_TMPL.swap_fltflt_def_tmpl tenorbasis_3M6M_swe = new INSTR_TMPL.swap_fltflt_def_tmpl("SWE_BASIS3M6M", "BD2",null<string>,null<string>,null<notional_exchg_style>,
																mtm_code.NONE, 4,4, DC_ACT_360,
																interest_rule.IR_MATURITY_NOADJ, "SEK",CAL_SE, BD_MOD_FOLLOWING, false,
																CA_COMP,SC_FLAT, null<..flt_avg_method>,null<flt_stub_fwd_style>, INSTR_TMPL_IR_INDEX.stibor_3m, 2, 2, DC_ACT_360,
																interest_rule.IR_MATURITY_NOADJ,
																"SEK",CAL_SE, BD_MOD_FOLLOWING, false, CA_COMP,SC_FLAT, null<..flt_avg_method>,null<flt_stub_fwd_style>,
																INSTR_TMPL_IR_INDEX.stibor_6m);

	INSTR_TMPL.swap_fltflt_def_tmpl tenorbasis_3M6M_5y_swe = new INSTR_TMPL.swap_fltflt_def_tmpl("SWE_BASIS3M6M", "BD2",null<string>,"5Y",null<notional_exchg_style>,
																	mtm_code.NONE, 4,4, DC_ACT_360,
																 interest_rule.IR_MATURITY_NOADJ, "SEK",CAL_SE, BD_MOD_FOLLOWING, false,
																CA_COMP,SC_FLAT, null<..flt_avg_method>,null<flt_stub_fwd_style>,INSTR_TMPL_IR_INDEX.stibor_3m,2, 2, DC_ACT_360, interest_rule.IR_MATURITY_NOADJ, 
																"SEK",CAL_SE, BD_MOD_FOLLOWING, false, CA_COMP,SC_FLAT, null<..flt_avg_method>,null<flt_stub_fwd_style>,
																INSTR_TMPL_IR_INDEX.stibor_6m);
	/*EUR*/
	INSTR_TMPL.swap_fltflt_def_tmpl tenorbasis_3M6M_eur = new INSTR_TMPL.swap_fltflt_def_tmpl("EUR_BASIS3M6M", "BD2",null<string>,null<string>,null<notional_exchg_style>,
																	mtm_code.NONE, 4,4, DC_ACT_360,
																	interest_rule.IR_MATURITY_NOADJ, "EUR",CAL_TARGET, BD_MOD_FOLLOWING, false,
																	CA_COMP,SC_FLAT, null<..flt_avg_method>,null<flt_stub_fwd_style>,INSTR_TMPL_IR_INDEX.euribor_3m, 2, 2, DC_ACT_360,
																	interest_rule.IR_MATURITY_NOADJ,
																	"EUR",CAL_TARGET, BD_MOD_FOLLOWING, false, CA_COMP,SC_FLAT, null<..flt_avg_method>,null<flt_stub_fwd_style>,
																	INSTR_TMPL_IR_INDEX.euribor_6m);

	/*EUR/SEK*/
	INSTR_TMPL.swap_fltflt_def_tmpl basis_3M3M_eursek = new INSTR_TMPL.swap_fltflt_def_tmpl("EURSEK_BASIS3M3M", "BD2",null<string>,null<string>, NE_BOTH,
																	mtm_code.NONE, 4,4,DC_ACT_360,
																	interest_rule.IR_MATURITY_NOADJ, "SEK",CAL_SE, BD_MOD_FOLLOWING, false,
																	CA_COMP,SC_FLAT, null<..flt_avg_method>,null<flt_stub_fwd_style>,INSTR_TMPL_IR_INDEX.stibor_3m, 4, 4, DC_ACT_360,
																	interest_rule.IR_MATURITY_NOADJ,
																	"EUR",CAL_TARGET, BD_MOD_FOLLOWING, false, CA_COMP,SC_FLAT, null<..flt_avg_method>,null<flt_stub_fwd_style>,
																	INSTR_TMPL_IR_INDEX.euribor_3m);
}

module INSTR_TMPL_SWAP_FLTFLT2S 
{
	/*INSTR_TMPL.swap_fltflt2s_def_tmpl tenorbasis_3M6M_swe = new INSTR_TMPL.swap_fltflt2s_def_tmpl("SWE_BASIS3M6M_2S", "BD2",null,null<string>,1,DC_30E_360, interest_rule.IR_MATURITY_NOADJ, 4, 4,DC_ACT_360, interest_rule.IR_MATURITY_NOADJ, CA_COMP,SC_FLAT, null<..flt_avg_method>,
																								2,2, DC_ACT_360, interest_rule.IR_MATURITY_NOADJ, CA_COMP,SC_FLAT, null<..flt_avg_method>, "SEK",CAL_SE, 
																								BD_MOD_FOLLOWING, false,null<notional_exchg_style>,
																								INSTR_TMPL_IR_INDEX.stibor_3m, INSTR_TMPL_IR_INDEX.stibor_6m);

	INSTR_TMPL.swap_fltflt2s_def_tmpl tenorbasis_3M6M_5y_swe = new INSTR_TMPL.swap_fltflt2s_def_tmpl("SWE_BASIS3M6M_2S", "BD2",null,"5Y",1,DC_30E_360, interest_rule.IR_MATURITY_NOADJ, 4, 4,DC_ACT_360, interest_rule.IR_MATURITY_NOADJ, CA_COMP,SC_FLAT, null<..flt_avg_method>,
																								2, 2,DC_ACT_360, interest_rule.IR_MATURITY_NOADJ,  CA_COMP,SC_FLAT, null<..flt_avg_method>,"SEK",CAL_SE, 
																								BD_MOD_FOLLOWING, false,null<notional_exchg_style>,
																								INSTR_TMPL_IR_INDEX.stibor_3m, INSTR_TMPL_IR_INDEX.stibor_6m);*/

	INSTR_TMPL.swap_fltflt2s_def_tmpl tenorbasis_3M6M_swe = new INSTR_TMPL.swap_fltflt2s_def_tmpl("SWE_BASIS3M6M_2S", null<string>,null<string>,INSTR_TMPL_SWAP_FIXFLT.fixflt3m_swe,
																								  INSTR_TMPL_SWAP_FIXFLT.fixflt6m_swe);

	INSTR_TMPL.swap_fltflt2s_def_tmpl tenorbasis_3M6M_5y_swe = new INSTR_TMPL.swap_fltflt2s_def_tmpl("SWE_BASIS3M6M_2S", null<string>,"5Y",INSTR_TMPL_SWAP_FIXFLT.fixflt3m_swe,
																								  INSTR_TMPL_SWAP_FIXFLT.fixflt6m_swe);

}



module INSTR_TMPL_SWAP_FIXFIX 
{
	INSTR_TMPL.swap_fixfix_def_tmpl fixfix_swe_eur = new INSTR_TMPL.swap_fixfix_def_tmpl("SWEEUR_FIXFIX", "BD2",null,null<string>,1, DC_30E_360, interest_rule.IR_MATURITY_NOADJ, "SEK",CAL_SE, BD_MOD_FOLLOWING, false, 
																						1, DC_30E_360, interest_rule.IR_MATURITY_NOADJ, "EUR",CAL_TARGET, BD_MOD_FOLLOWING, false, 
																						null<notional_exchg_style>);

	INSTR_TMPL.swap_fixfix_def_tmpl fixfix_swe_eur_5y = new INSTR_TMPL.swap_fixfix_def_tmpl("SWEEUR_FIXFIX", "BD2",null,"5Y",1, DC_30E_360, interest_rule.IR_MATURITY_NOADJ, "SEK",CAL_SE, BD_MOD_FOLLOWING, false, 
																						1, DC_30E_360, interest_rule.IR_MATURITY_NOADJ, "EUR",CAL_TARGET, BD_MOD_FOLLOWING, false, 
																						null<notional_exchg_style>);

}
module INSTR_TMPL_SWAP_FIXOIS 
{
	/*
	Ccy		ISDA/FpML Code							val_days	fix_days		payment lag		BBG 		dc
	----	---------------							--------	--------		-----------		----		---
	AUD		AUD-AONIA-OIS-COMPOUND					0			0				2				ADSO*		Act365
	CAD		CAD-CORRA-OIS-COMPOUND					0			-1				1				CDSO*		Act365
	CHF		CHF-TOIS-OIS-COMPOUND(TN)				1			1				2				SFSWT*		Act360
	CHF		CHF-SARON-OIS-COMPOUND					0			0				2	
	EUR		EUR-EONIA-OIS-COMPOUND					0			0				1				EUSWE*		Act360
	GBP		GBP-WMBA-SONIA-COMPOUND					0			0				0				BPSWS*		Act365
	JPY		JPY-TONA-OIS-COMPOUND					0			-1				2				JYSO*		Act365
	NZD		NZD-NZIONA-OIS-COMPOUND					0			0				1				NDSO*		Act365
	PLN		PLN-POLONIA-OIS-COMPOUND				0			0				?				PZSO*		Act365
	USD		USD-FEDERAL FUNDS-H.15-OIS-COMPOUND					-1				2				USSO*		Act360
	SEK		TN										1			1				0							Act360
	*/

	INSTR_TMPL.swap_fixois_def_tmpl stina = new INSTR_TMPL.swap_fixois_def_tmpl("STINA", "BD2",null,null<string>,1, DC_ACT_360, CAL_SE, BD_MOD_FOLLOWING, false,"SEK",interest_rule.IR_MATURITY_NOADJ, "SEK", 
																				rfr_arrears_type.PLAIN,0, CA_COMP, SC_SPRD_EXCL, null<flt_avg_method>,true,true,0,0,INSTR_TMPL_IR_INDEX.stibor_tn);
	INSTR_TMPL.swap_fixois_def_tmpl fedfunds = new INSTR_TMPL.swap_fixois_def_tmpl("FEDFUNDS","BD2",null,null<string>, 1, DC_ACT_360,  CAL_US, BD_MOD_FOLLOWING, false, "USD",interest_rule.IR_MATURITY_NOADJ,"USD",
																				rfr_arrears_type.LOCKOUT,2,CA_AVG, null, flt_avg_method.AVG_WEIGHTED,true,true,0,0,INSTR_TMPL_IR_INDEX.effr);
	INSTR_TMPL.swap_fixois_def_tmpl sofr = new INSTR_TMPL.swap_fixois_def_tmpl("SOFR","BD2",null,null<string>, 1, DC_ACT_360, CAL_US, BD_MOD_FOLLOWING, false, "USD",interest_rule.IR_MATURITY_NOADJ,"USD",
																				rfr_arrears_type.LOOKBACKSHIFT,2,CA_COMP, SC_SPRD_EXCL, null<flt_avg_method>,true,true,0,0,INSTR_TMPL_IR_INDEX.sofr);
	INSTR_TMPL.swap_fixois_def_tmpl eonia = new INSTR_TMPL.swap_fixois_def_tmpl("EONIA", "BD2",null,null<string>,1, DC_ACT_360,  CAL_TARGET, BD_MOD_FOLLOWING, false, "EUR",interest_rule.IR_MATURITY_NOADJ,"EUR",
																				rfr_arrears_type.PLAIN,0,CA_COMP, SC_SPRD_EXCL, null<flt_avg_method>,true,true,1,1,INSTR_TMPL_IR_INDEX.eonia);
	INSTR_TMPL.swap_fixois_def_tmpl saron = new INSTR_TMPL.swap_fixois_def_tmpl("SARON","BD2",null,null<string>, 1, DC_ACT_360,  CAL_CH, BD_MOD_FOLLOWING, false, "CHF",interest_rule.IR_MATURITY_NOADJ,"CHF",
																				rfr_arrears_type.PLAIN,0,CA_COMP, SC_SPRD_EXCL, null<flt_avg_method>,true,true,2,2,INSTR_TMPL_IR_INDEX.saron);
	INSTR_TMPL.swap_fixois_def_tmpl sonia = new INSTR_TMPL.swap_fixois_def_tmpl("SONIA","BD0",null,null<string>, 1, DC_ACT_365,  CAL_UK, BD_MOD_FOLLOWING, false,"GBP",interest_rule.IR_MATURITY_NOADJ,"GBP", 
																				rfr_arrears_type.PLAIN,0,CA_COMP, SC_SPRD_EXCL, null<flt_avg_method>,true,true,0,0,INSTR_TMPL_IR_INDEX.sonia);
	INSTR_TMPL.swap_fixois_def_tmpl tonar = new INSTR_TMPL.swap_fixois_def_tmpl("TONAR","BD2",null,null<string>, 1, DC_ACT_365,  CAL_JP, BD_MOD_FOLLOWING, false, "JPY",interest_rule.IR_MATURITY_NOADJ,"JPY",
																				rfr_arrears_type.PLAIN,0,CA_COMP, SC_SPRD_EXCL, null<flt_avg_method>,true,true,2,2,INSTR_TMPL_IR_INDEX.tonar);
	INSTR_TMPL.swap_fixois_def_tmpl swestr = new INSTR_TMPL.swap_fixois_def_tmpl("SWESTR", "BD2",null,null<string>,1, DC_ACT_360, CAL_SE, BD_MOD_FOLLOWING, false, "SEK",interest_rule.IR_MATURITY_NOADJ,"SEK",
																				rfr_arrears_type.PLAIN,0,CA_COMP, SC_SPRD_EXCL, null<flt_avg_method>,true,true,1,1,INSTR_TMPL_IR_INDEX.swestr);
	INSTR_TMPL.swap_fixois_def_tmpl nowa = new INSTR_TMPL.swap_fixois_def_tmpl("NOWA", "BD2",null,null<string>,1, DC_ACT_365, CAL_NO, BD_MOD_FOLLOWING, false, "NOK",interest_rule.IR_MATURITY_NOADJ,"NOK",
																				rfr_arrears_type.PLAIN,0,CA_COMP, SC_SPRD_EXCL, null<flt_avg_method>,true,true,1,1,INSTR_TMPL_IR_INDEX.nowa);
	
}

module INSTR_TMPL_SWAP_FLTOIS2S 
{
	INSTR_TMPL.swap_fltois2s_def_tmpl basis_3MNOWA_nok = new INSTR_TMPL.swap_fltois2s_def_tmpl( "NOR_BASIS3MNOWA_2S", null,null,INSTR_TMPL_SWAP_FIXFLT.fixflt3m_nok,
																								INSTR_TMPL_SWAP_FIXOIS.nowa);
			
	/*INSTR_TMPL.swap_fltois2s_def_tmpl basis_3MNOWA_nok = new INSTR_TMPL.swap_fltois2s_def_tmpl(
			"NOR_BASIS3MNOWA_2S", "BD2",null,null,"NOK",CAL_NO, BD_MOD_FOLLOWING, false,notional_exchg_style.NE_NONE,			
			1,DC_ACT_365, 4, DC_ACT_365, interest_rule.IR_ADJ, CA_COMP,SC_FLAT, null,true,true,2,2,INSTR_TMPL_IR_INDEX.nowa,
			1,DC_30E_360, 4,4, DC_ACT_360, interest_rule.IR_MATURITY_NOADJ, CA_COMP,SC_FLAT, null, INSTR_TMPL_IR_INDEX.nibor_3m);*/
}

module INSTR_TMPL_SWAP_FLTOIS 
{
	
	INSTR_TMPL.swap_fltois_def_tmpl fedfunds = new INSTR_TMPL.swap_fltois_def_tmpl("FEDFUNDS","BD2",null,null<string>, 2,2,notional_exchg_style.NE_NONE,mtm_code.NONE,
																				   4, 4, DC_ACT_360,  CAL_US, BD_MOD_FOLLOWING, false, "USD",interest_rule.IR_ADJ, null,INSTR_TMPL_IR_INDEX.usd_libor_3m,
																				   4, DC_ACT_360,  CAL_US, BD_MOD_FOLLOWING, false, "USD",rfr_arrears_type.LOCKOUT,2,
																					CA_AVG, null<flt_sprd_comp_method>, flt_avg_method.AVG_WEIGHTED,
																				   interest_rule.IR_ADJ,true,true, INSTR_TMPL_IR_INDEX.effr);//check the reset cutoff, set to 0 for now
	
	INSTR_TMPL.swap_fltois_def_tmpl eonia = new INSTR_TMPL.swap_fltois_def_tmpl("EONIA","BD2",null,null<string>,1,1,notional_exchg_style.NE_NONE,mtm_code.NONE,
																				4,4,  DC_ACT_360, CAL_TARGET, BD_MOD_FOLLOWING, false, "EUR",interest_rule.IR_ADJ,  null,INSTR_TMPL_IR_INDEX.euribor_3m,
																				4,  DC_ACT_360, CAL_TARGET, BD_MOD_FOLLOWING, false, "EUR",rfr_arrears_type.PLAIN,0,
																				CA_COMP, SC_SPRD_EXCL, null<flt_avg_method>,interest_rule.IR_ADJ,true,true, INSTR_TMPL_IR_INDEX.eonia);

	INSTR_TMPL.swap_fltois_def_tmpl swestr = new INSTR_TMPL.swap_fltois_def_tmpl("SWESTR","BD2",null,null<string>,1, 1,notional_exchg_style.NE_NONE,mtm_code.NONE,
																				 4,4,  DC_ACT_360, CAL_SE, BD_MOD_FOLLOWING, false, "SEK",interest_rule.IR_ADJ, null,INSTR_TMPL_IR_INDEX.stibor_3m,
																				 4,  DC_ACT_360, CAL_SE, BD_MOD_FOLLOWING, false, "SEK",rfr_arrears_type.PLAIN,0,
																				CA_COMP, SC_SPRD_EXCL, null<flt_avg_method>,interest_rule.IR_ADJ,true,true, INSTR_TMPL_IR_INDEX.swestr);
	
	INSTR_TMPL.swap_fltois_def_tmpl nowa = new INSTR_TMPL.swap_fltois_def_tmpl("NOWA","BD2",null,null<string>,2,2, notional_exchg_style.NE_NONE,mtm_code.NONE,
																			   4,4,  DC_ACT_365, CAL_NO, BD_MOD_FOLLOWING, false, "NOK",interest_rule.IR_ADJ, flt_stub_fwd_style.FSF_CPN_DATES,INSTR_TMPL_IR_INDEX.nibor_3m,
																			   4,  DC_ACT_365, CAL_NO, BD_MOD_FOLLOWING, false, "NOK", rfr_arrears_type.PLAIN,0,
																				CA_COMP, SC_SPRD_EXCL, null<flt_avg_method>,interest_rule.IR_ADJ,true,true, INSTR_TMPL_IR_INDEX.nowa);	

	INSTR_TMPL.swap_fltois_def_tmpl niborsofr = new INSTR_TMPL.swap_fltois_def_tmpl("NIBORSOFR","BD2",null,null<string>,2,0, notional_exchg_style.NE_BOTH,mtm_code.LEG2_MTM,
																					4,4,  DC_ACT_360, CAL_NO, BD_MOD_FOLLOWING, false, "NOK",interest_rule.IR_ADJ, flt_stub_fwd_style.FSF_CPN_DATES,INSTR_TMPL_IR_INDEX.nibor_3m,
																					4,  DC_ACT_360, CAL_US, BD_MOD_FOLLOWING, false, "USD",
																					rfr_arrears_type.PLAIN,0,CA_COMP, SC_SPRD_EXCL, null<flt_avg_method>,interest_rule.IR_ADJ,true,true,
																					INSTR_TMPL_IR_INDEX.sofr);

}

module INSTR_TMPL_SWAP_OISOIS 
{

	INSTR_TMPL.swap_oisois_def_tmpl basis_3M3M_sonia_sofr = new INSTR_TMPL.swap_oisois_def_tmpl("SONIASOFR_3M3M", "BD2",null,null<string>,2,0, mtm_code.LEG2_MTM,4,DC_ACT_365, "GBP",CAL_UK, BD_MOD_FOLLOWING, false, 
																								rfr_arrears_type.PLAIN,0,CA_COMP,SC_SPRD_EXCL, null<..flt_avg_method>,true,true,INSTR_TMPL_IR_INDEX.sonia,
																								4, DC_ACT_360, "USD",CAL_US, BD_MOD_FOLLOWING, false, rfr_arrears_type.PLAIN,0,
																								CA_COMP,SC_SPRD_EXCL, null<..flt_avg_method>,true,true,INSTR_TMPL_IR_INDEX.sofr,NE_BOTH);

	INSTR_TMPL.swap_oisois_def_tmpl basis_3M3M_estr_sofr = new INSTR_TMPL.swap_oisois_def_tmpl("ESTRSOFR_3M3M", "BD2",null,null<string>,2,0, mtm_code.LEG2_MTM,4,DC_ACT_360, "EUR",CAL_TARGET, BD_MOD_FOLLOWING, false, 
																								rfr_arrears_type.PLAIN,0,CA_COMP,SC_SPRD_EXCL, null<..flt_avg_method>,true,true,INSTR_TMPL_IR_INDEX.estr,
																								4, DC_ACT_360, "USD",CAL_US, BD_MOD_FOLLOWING, false, rfr_arrears_type.PLAIN,0,
																								CA_COMP,SC_SPRD_EXCL, null<..flt_avg_method>,true,true,INSTR_TMPL_IR_INDEX.sofr,NE_BOTH);

	INSTR_TMPL.swap_oisois_def_tmpl basis_3M3M_nowa_sofr = new INSTR_TMPL.swap_oisois_def_tmpl("NOWASOFR_3M3M", "BD2",null,null<string>,2,0, mtm_code.LEG2_MTM,4,DC_ACT_365, "NOK",CAL_NO, BD_MOD_FOLLOWING, false, 
																								rfr_arrears_type.PLAIN,0,CA_COMP,SC_SPRD_EXCL, null<..flt_avg_method>,true,true,INSTR_TMPL_IR_INDEX.nowa,
																								4, DC_ACT_360, "USD",CAL_US, BD_MOD_FOLLOWING, false, rfr_arrears_type.PLAIN,0,
																								CA_COMP,SC_SPRD_EXCL, null<..flt_avg_method>,true,true,INSTR_TMPL_IR_INDEX.sofr,NE_BOTH);

	INSTR_TMPL.swap_oisois_def_tmpl basis_3M3M_fed_sofr = new INSTR_TMPL.swap_oisois_def_tmpl(	"FEDSOFR_3M3M", "BD2",null,null<string>,2,2, mtm_code.NONE,4,DC_ACT_360, "USD",CAL_US, BD_MOD_FOLLOWING, false, 
																								rfr_arrears_type.LOCKOUT,2,flt_comp_avg_type.CA_AVG, null, flt_avg_method.AVG_WEIGHTED,true,true,
																								INSTR_TMPL_IR_INDEX.effr,																							  
																								4, DC_ACT_360, "USD",CAL_US, BD_MOD_FOLLOWING, false, rfr_arrears_type.PLAIN,0,
																								CA_COMP,SC_SPRD_EXCL, null<..flt_avg_method>,true,true,INSTR_TMPL_IR_INDEX.sofr,NE_BOTH);
	
	/*Note payment lags are common for both legs but in the case of fedfund vs sofr it needs to be per leg */
	
	
}

module INSTR_TMPL_SWAP_ZEROOIS 
{
}

module INSTR_TMPL_SWAP_RR_FIXFLT 
{
	INSTR_TMPL.swap_rr_fixflt_def_tmpl fixflt_rr_swe = new INSTR_TMPL.swap_rr_fixflt_def_tmpl(	"SWE_FIXFLT","BD2",null<string>,null<string>, 1, DC_30E_360,interest_rule.IR_MATURITY_NOADJ, "SEK",
																								CAL_SE, BD_MOD_FOLLOWING, false, 4,4, DC_ACT_360,interest_rule.IR_MATURITY_NOADJ,
																								"SEK",CAL_SE, BD_MOD_FOLLOWING, false, 
																								null<flt_comp_avg_type>, null<flt_sprd_comp_method>,null<flt_avg_method>,null<flt_stub_fwd_style>,																								
																								null<notional_exchg_style>,infl_index_method.LAG_3M_IP_SE,INSTR_TMPL_IR_INDEX.stibor_3m);
}

module INSTR_TMPL_SWAP_RR_FIXOIS 
{
	INSTR_TMPL.swap_rr_fixois_def_tmpl fixois_rr_swe = new INSTR_TMPL.swap_rr_fixois_def_tmpl(	"SWE_FIXOIS","BD2",null<string>,null<string>, 1, DC_30E_360,interest_rule.IR_MATURITY_NOADJ, "SEK",
																								CAL_SE, BD_MOD_FOLLOWING, false, 4, DC_ACT_360,
																								"SEK",CAL_SE, BD_MOD_FOLLOWING, false, 
																								rfr_arrears_type.PLAIN,0,CA_COMP, SC_SPRD_EXCL, null<flt_avg_method>,
																								true,true,1,1,
																								null<notional_exchg_style>,infl_index_method.LAG_3M_IP_SE,INSTR_TMPL_IR_INDEX.swestr);		
}


module INSTR_TMPL_BOND_FUTURE 
{
	INSTR_TMPL.bondfut_def_tmpl nasdaq_2y_swe = new INSTR_TMPL.bondfut_def_tmpl("NASDAQ_2Y", "2Y_NONE", 0.06,1,DC_30E_360, false, bond_fut_style.SYNT_CASH_SETTLE_MTM,
																				null<bond_fut_pf>, 
																				CAL_SE,"SEK",quote_style.YIELD_PCT, 1000000,0.001,"BD4");
	INSTR_TMPL.bondfut_def_tmpl nasdaq_5y_swe = new INSTR_TMPL.bondfut_def_tmpl("NASDAQ_5Y", "5Y_NONE", 0.06,1,DC_30E_360, false, bond_fut_style.SYNT_CASH_SETTLE_MTM,
																				null<bond_fut_pf>, 
																				CAL_SE,"SEK",quote_style.YIELD_PCT, 1000000,0.001,"BD4");
	INSTR_TMPL.bondfut_def_tmpl nasdaq_10y_swe =new INSTR_TMPL.bondfut_def_tmpl("NASDAQ_10Y","10Y_NONE",0.06,1,DC_30E_360, false, bond_fut_style.SYNT_CASH_SETTLE_MTM,
																				null<bond_fut_pf>, 
																				CAL_SE,"SEK",quote_style.YIELD_PCT, 1000000,0.001,"BD4");	
	INSTR_TMPL.bondfut_def_tmpl eurex_bund = 	new INSTR_TMPL.bondfut_def_tmpl("EUREX_BUND","10Y_NONE",0.06,1,DC_ACT_ACT, false, bond_fut_style.PRICE_FACTOR_MTM,
																				bond_fut_pf.EUREX_EUR, CAL_TARGET,"EUR",quote_style.CLEAN_PCT, 100000, 0.01, "BD2");
	


/*Contract	Product ID	Remaining term in years	Coupon in percent	Currency
Euro-Schatz Futures			FGBS	1.75 to 2.25	6				EUR
Euro-Bobl Futures			FGBM	4.5 to 5.5		6				EUR
Euro-Bund Futures			FGBL	8.5 to 10.5		6				EUR
Euro-Buxl® Futures			FGBX	24.0 to 35.0	4				EUR
Short-Term Euro-BTP Futures	FBTS	2.0 to 3.25		6				EUR
Mid-Term Euro-BTP Futures	FBTM	4.5 to 6.0		6				EUR
Long-Term Euro-BTP Futures	FBTP	8.5 to 11.0		6				EUR
Mid-Term Euro-OAT Futures	FOAM	4.5 to 5.5		6				EUR
Euro-OAT Futures			FOAT	8.5 to 10.5		6				EUR
Euro-BONO Futures			FBON	8.5 to 10.5		6				EUR
CONF Futures				CONF	8.0 to 13.0		6				CHF

Contract					Minimum price change  Percent	Value
Euro-Schatz Futures			0.005							EUR 5
Euro-Bobl Futures			0.01							EUR 10
Euro-Bund Futures			0.01							EUR 10
Euro-Buxl® Futures			0.02							EUR 20
Short-Term Euro-BTP Futures	0.01							EUR 10
Mid-Term Euro-BTP Futures	0.01							EUR 10
Long-Term Euro-BTP Futures	0.01							EUR 10
Mid-Term Euro-OAT Futures	0.01							EUR 10
Euro-OAT Futures			0.01							EUR 10
Euro-BONO Futures			0.01							EUR 10
CONF Futures				0.01							CHF 10

*/

}

module INSTR_TMPL_FX 
{
	INSTR_TMPL.fx_spot_def_tmpl usdsek = new INSTR_TMPL.fx_spot_def_tmpl("USDSEK_T", "USD","SEK",CAL_US, CAL_SE,CAL_US,"BD2",4,1,5,fx_spot_rule.STD_USD_ADJ);	
	INSTR_TMPL.fx_swap_def_tmpl usdsek_swap = new INSTR_TMPL.fx_swap_def_tmpl("USDSEKSWAP", usdsek,BD_MOD_FOLLOWING, true,null<string>,null<string>,2, true);
	INSTR_TMPL.fx_swap_def_tmpl usdsek_swap_on = new INSTR_TMPL.fx_swap_def_tmpl("USDSEKSWAP", usdsek,BD_MOD_FOLLOWING, true,"BD0","BD1",2, true);
	INSTR_TMPL.fx_swap_def_tmpl usdsek_swap_tn = new INSTR_TMPL.fx_swap_def_tmpl("USDSEKSWAP", usdsek,BD_MOD_FOLLOWING, true,"BD1","BD1",2, true);
		
	INSTR_TMPL.fx_spot_def_tmpl eursek = new INSTR_TMPL.fx_spot_def_tmpl("EURSEK_T", "EUR","SEK",CAL_TARGET, CAL_SE,null<calendar>,"BD2",4,1,5,fx_spot_rule.STD);
	INSTR_TMPL.fx_swap_def_tmpl eursek_swap = new INSTR_TMPL.fx_swap_def_tmpl("EURSEKSWAP", eursek,BD_MOD_FOLLOWING, true,null<string>,null<string>, 2,true);
	INSTR_TMPL.fx_swap_def_tmpl eursek_swap_on = new INSTR_TMPL.fx_swap_def_tmpl("EURSEKSWAP", eursek,BD_MOD_FOLLOWING, true,"BD0","BD1", 2,true);
	INSTR_TMPL.fx_swap_def_tmpl eursek_swap_tn = new INSTR_TMPL.fx_swap_def_tmpl("EURSEKSWAP", eursek,BD_MOD_FOLLOWING, true,"BD1","BD1", 2,true);

	INSTR_TMPL.fx_spot_def_tmpl eurusd = new INSTR_TMPL.fx_spot_def_tmpl("EURUSD_T", "EUR","USD",CAL_TARGET, CAL_US,null<calendar>,"BD2",4,1,5,fx_spot_rule.STD);
	INSTR_TMPL.fx_spot_def_tmpl gbpsek = new INSTR_TMPL.fx_spot_def_tmpl("GBPSEK_T", "GBP","SEK",CAL_UK, CAL_SE,CAL_US,"BD2",4,1,5,fx_spot_rule.STD_USD_ADJ);
	INSTR_TMPL.fx_spot_def_tmpl noksek = new INSTR_TMPL.fx_spot_def_tmpl("NOKSEK_T", "NOK","SEK",CAL_NO, CAL_SE,CAL_US,"BD2",4,1,5,fx_spot_rule.STD_USD_ADJ);
	INSTR_TMPL.fx_spot_def_tmpl usdnok = new INSTR_TMPL.fx_spot_def_tmpl("USDNOK_T", "USD","NOK",CAL_US, CAL_NO,CAL_US,"BD2",4,1,5,fx_spot_rule.STD_USD_ADJ);
	
	INSTR_TMPL.fx_fwd_def_tmpl noksek_outr = new INSTR_TMPL.fx_fwd_def_tmpl("NOKSEKOUTR", null,noksek,bd_convention.BD_MOD_FOLLOWING,true,6);
	INSTR_TMPL.fx_fwd_def_tmpl usdsek_outr = new INSTR_TMPL.fx_fwd_def_tmpl("USDSEKOUTR", null,usdsek,bd_convention.BD_MOD_FOLLOWING, true,6);
	INSTR_TMPL.fx_fwd_def_tmpl usdnok_outr = new INSTR_TMPL.fx_fwd_def_tmpl("USDNOKOUTR", null,usdnok,bd_convention.BD_MOD_FOLLOWING,true,6);
	INSTR_TMPL.fx_fwd_def_tmpl usdnok_outr_1y = new INSTR_TMPL.fx_fwd_def_tmpl("USDNOKOUTR1Y", "1Y",usdnok,bd_convention.BD_MOD_FOLLOWING,true,6);
}

module INSTR_TMPL_ONFUT 
{
																	
	/*Fed Fund Futures - CME*/
	INSTR_TMPL.onfut_def_tmpl fedfund30d = new INSTR_TMPL.onfut_def_tmpl(	"FED_FUND_FUT_30D", null<date>,null<string>,"CD30_NONE", DC_ACT_360, CAL_US,
																			"USD",onfut_calc_method.AVERAGE_FF_30D,  
																			fut_tick_value_style.FIX_30_360,quote_style.EDFUT, 5000000, 
																			0.005,"BD1", INSTR_TMPL_IR_INDEX.effr);
	
	/*30 Day Interbank Cash Rate Futures - ASX*/
	INSTR_TMPL.onfut_def_tmpl audcashfut30d = new INSTR_TMPL.onfut_def_tmpl("AUD_CASH_FUT_30D", null<date>,null<string>,"CD30_NONE", DC_ACT_365, CAL_AU,"AUD",
																			onfut_calc_method.AVERAGE_FF_30D,  
																			fut_tick_value_style.FIX_30_365,quote_style.EDFUT, 3000000, 
																			0.005,"BD2", INSTR_TMPL_IR_INDEX.au_oncash);

	/*1M Eonia Futures - EUREX*/
	INSTR_TMPL.onfut_def_tmpl eonia1m = new INSTR_TMPL.onfut_def_tmpl("EONIA_1M", null<date>,null<string>,"CD30_NONE", DC_ACT_360, CAL_TARGET,"EUR",
																		onfut_calc_method.COMPOUND_1M,  
																		fut_tick_value_style.FIX_30_360,quote_style.EDFUT, 1000000, 
																		0.005,"BD1", INSTR_TMPL_IR_INDEX.eonia);

	/*1M SOFR Futures*/
	//Rate Cutoff=0
	INSTR_TMPL.onfut_def_tmpl sofr1m = new INSTR_TMPL.onfut_def_tmpl("SOFR_1M", null<date>,null<string>,"CD30_NONE", DC_ACT_360, CAL_US,"USD",
																		onfut_calc_method.AVERAGE_FF_30D,  
																		fut_tick_value_style.FIX_30_360,quote_style.EDFUT, 5000000, 
																		0.005,"BD1", INSTR_TMPL_IR_INDEX.sofr);

	/*3M SOFR Futures*/
	//OBS! no check that first_settle is imm (as opposed to when db calc-type is used)
	INSTR_TMPL.onfut_def_tmpl sofr3m = new INSTR_TMPL.onfut_def_tmpl("SOFR_3M", null<date>,null<string>,"IMM1", DC_ACT_360, CAL_US,"USD",
																		onfut_calc_method.COMPOUND,  
																		fut_tick_value_style.FIX_90_360,quote_style.EDFUT, 1000000, 
																		0.005,"BD1", INSTR_TMPL_IR_INDEX.sofr);
}

module INSTR_TMPL_FX_OPTION 
{

	INSTR_TMPL.vanilla_option_fx_def_tmpl usdsek_call() 	{ return new INSTR_TMPL.vanilla_option_fx_def_tmpl("USDSEK",exercise_type.EURO,opt_type.OPT_CALL, "NYK",  BD_MOD_FOLLOWING, 	 								
																										true, null<string>,	CAL_FXO,null<string>,null<string>,null<string>,true,
																									   null<fx_delta_type>, null<fx_atm_type>, delivery_type.PHYS);}

	INSTR_TMPL.vanilla_option_fx_def_tmpl usdsek_put() 	{ return new INSTR_TMPL.vanilla_option_fx_def_tmpl("USDSEK",exercise_type.EURO,opt_type.OPT_PUT, "NYK",  BD_MOD_FOLLOWING, 	 								
																										true, null<string>,	CAL_FXO,null<string>,null<string>,null<string>,true,
																									   null<fx_delta_type>, null<fx_atm_type>, delivery_type.PHYS);}
	
	INSTR_TMPL.vanilla_option_fx_def_tmpl usdsek1m25d_call() { return new INSTR_TMPL.vanilla_option_fx_def_tmpl("USDSEK",exercise_type.EURO,opt_type.OPT_CALL, "NYK",  BD_MOD_FOLLOWING, 	 								
																										true, "1M",	CAL_FXO,"25d",null<string>,null<string>,true,
																									   null<fx_delta_type>, null<fx_atm_type>, delivery_type.PHYS);}

	INSTR_TMPL.vanilla_option_fx_def_tmpl usdsek1m25d_put() { return new INSTR_TMPL.vanilla_option_fx_def_tmpl("USDSEK",exercise_type.EURO,opt_type.OPT_PUT, "NYK",  BD_MOD_FOLLOWING, 	 								
																										true, "1M",	CAL_FXO,"25d",null<string>,null<string>,true,
																									  null<fx_delta_type>, null<fx_atm_type>, delivery_type.PHYS);}
	
	INSTR_TMPL.vanilla_option_fx_def_tmpl eurusd1m25d_call() { return new INSTR_TMPL.vanilla_option_fx_def_tmpl("EURUSD",exercise_type.EURO,opt_type.OPT_CALL, "NYK",  BD_MOD_FOLLOWING, 	 								
																										true, "1M",	CAL_FXO,"25d",null<string>,null<string>,true,
																									   null<fx_delta_type>, null<fx_atm_type>, delivery_type.PHYS);}
}

module INSTR_TMPL_EQ_OPTION 
{
	//expiry code for third friday? 
	INSTR_TMPL.vanilla_option_eq_def_tmpl sek_stock_call() 	{ return new INSTR_TMPL.vanilla_option_eq_def_tmpl(exercise_type.AMER,opt_type.OPT_CALL, 100, BD_PREVIOUS,"BD1", "BD2", null<string>,/*3rd friday*/ 	 								
																											CAL_SE, null<string>,"SEK", true, delivery_type.PHYS, quote_style_eq_opt.VOL);}

	INSTR_TMPL.vanilla_option_eq_def_tmpl sek_stock_put() 	{ return new INSTR_TMPL.vanilla_option_eq_def_tmpl(exercise_type.AMER,opt_type.OPT_PUT, 100, BD_PREVIOUS,"BD1", "BD2", null<string>, /*3rd friday*/	 								
																											CAL_SE, null<string>,"SEK", true, delivery_type.PHYS, quote_style_eq_opt.VOL);}

	
}
