option(null: hard);

logical fin_instr.is_inflation_linked() option(hidden) 										{ return CORE_INT.is_idx_link( this.instr_type(), true) ;}
logical fin_instr.is_cpi_linked() option(hidden) option(com_name: 'LEGACY_is_cpi_linked')	{return this.is_inflation_linked();}

logical fin_instr.is_il_fix_cpn_bond()	option(hidden) 	{ return this.instr_type() == ..instr_type.IL_REAL_FIXED_CPN_BOND;}
logical fin_instr.is_il_bond()	option(hidden) 	{ return this.instr_type() == ..instr_type.IL_REAL_FIXED_CPN_BOND;}
logical fin_instr.is_il_zero_bond()	option(hidden) 	{ return this.instr_type() == ..instr_type.IL_REAL_ZERO_CPN_BOND;}
logical fin_instr.is_il_rr_swap_fixflt()	option(hidden) 	{ return this.instr_type() == ..instr_type.IL_SWAP_REAL_FIXFLT;}
logical fin_instr.is_il_rr_swap_fixois()	option(hidden) 	{ return this.instr_type() == ..instr_type.IL_SWAP_REAL_FIXOIS;}
logical fin_instr.is_il_zero_swap()	option(hidden) 	{ return this.instr_type() == ..instr_type.IL_SWAP_ZERO;}


logical fin_instr.is_fx_spot()	option(hidden) 	{ return this.instr_type() == ..instr_type.FX_SPOT;}
logical fin_instr.is_fx_swap()	option(hidden) 	{ return this.instr_type() == ..instr_type.FX_SWAP;}
logical fin_instr.is_fx_fwd()	option(hidden) 	{ return this.instr_type() == ..instr_type.FX_FORWARD;}
logical fin_instr.is_generic()	option(hidden) 	{ return this.instr_type() == ..instr_type.GENERIC;}
logical fin_instr.is_equity()	option(hidden) 	{ return this.instr_type() == ..instr_type.EQUITY;}
logical fin_instr.is_equity_option_vanilla() option(hidden) 	{ return this.instr_type() == ..instr_type.EQUITY_OPTION_VANILLA;}

logical fin_instr.is_fix_cpn_bond()	option(hidden) 	{ return this.instr_type() == ..instr_type.FIXED_CPN_BOND;}
logical fin_instr.is_bond()	option(hidden) option(com_name: 'LEGACY_is_bond')	{ return this.instr_type() == ..instr_type.FIXED_CPN_BOND;}

logical fin_instr.is_zero_bond()	option(hidden) 	{ return this.instr_type() == ..instr_type.ZERO_CPN_BOND;}
logical fin_instr.is_bill()	option(hidden) 	{ return this.instr_type() == ..instr_type.BILL;}
logical fin_instr.is_bill_future()	option(hidden) 	{ return this.instr_type() == ..instr_type.BILL_FUTURE;}
logical fin_instr.is_bond_future()	option(hidden) 	{ return this.instr_type() == ..instr_type.BOND_FUTURE;}
logical fin_instr.is_riba()	option(hidden) 	{ return this.instr_type() == ..instr_type.RIBA;}
logical fin_instr.is_nois()	option(hidden) 	{ return this.instr_type() == ..instr_type.NOIS;}

logical fin_instr.is_fra()	option(hidden) 	{ return this.instr_type() == ..instr_type.FRA;}
logical fin_instr.is_frn()	option(hidden) 	{ return this.instr_type() == ..instr_type.FRN;}
logical fin_instr.is_ir_future()	option(hidden) 	{ return this.instr_type() == ..instr_type.IR_FUTURE;}
logical fin_instr.is_on_future()	option(hidden) 	{ return this.instr_type() == ..instr_type.OVERNIGHT_FUTURE;}

logical fin_instr.is_deposit()	option(hidden) 	{ return this.instr_type() == ..instr_type.DEPOSIT || this.instr_type() == ..instr_type.DEPOSIT_INDEX;}
logical fin_instr.is_depo()	option(hidden) option(com_name: 'LEGACY_is_depo') 	{ return this.instr_type() == ..instr_type.DEPOSIT || this.instr_type() == ..instr_type.DEPOSIT_INDEX;}
logical fin_instr.is_deposit_index()	option(hidden) 	{ return this.instr_type() == ..instr_type.DEPOSIT_INDEX;}

logical fin_instr.is_swap_fixflt()	option(hidden) 	{ return this.instr_type() == ..instr_type.SWAP_FIXFLT;}
logical fin_instr.is_fix_flt_swap()	option(hidden) 	{ return this.instr_type() == ..instr_type.SWAP_FIXFLT;}

logical fin_instr.is_swap_fltflt()	option(hidden) 	{ return this.instr_type() == ..instr_type.SWAP_FLTFLT;}
logical fin_instr.is_basis_swap_1()	option(hidden) 	{ return this.instr_type() == ..instr_type.SWAP_FLTFLT;}

logical fin_instr.is_swap_fltflt2s()	option(hidden) 	{ return this.instr_type() == ..instr_type.SWAP_FLTFLT2S;}
logical fin_instr.is_swap_fltois2s()	option(hidden) 	{ return this.instr_type() == ..instr_type.SWAP_FLTOIS2S;}
logical fin_instr.is_basis_swap_2()	option(hidden) option(com_name: 'LEGACY_is_basis_swap_2')	{ return this.instr_type() == ..instr_type.SWAP_FLTFLT2S;}

logical fin_instr.is_swap_fixois()	option(hidden) 	{ return this.instr_type() == ..instr_type.SWAP_FIXOIS;}
logical fin_instr.is_ois()	option(hidden) option(com_name: 'LEGACY_is_ois')	{ return this.instr_type() == ..instr_type.SWAP_FIXOIS;}
logical fin_instr.is_swap_fltois()	option(hidden) 	{ return this.instr_type() == ..instr_type.SWAP_FLTOIS;}
logical fin_instr.is_swap_fixfix()	option(hidden) 	{ return this.instr_type() == ..instr_type.SWAP_FIXFIX;}
logical fin_instr.is_swap_oisois()	option(hidden) 	{ return this.instr_type() == ..instr_type.SWAP_OISOIS;}
logical fin_instr.is_swap_zeroflt()	option(hidden) 	{ return this.instr_type() == ..instr_type.SWAP_ZEROFLT;}
logical fin_instr.is_swap_zeroois()	option(hidden) 	{ return this.instr_type() == ..instr_type.SWAP_ZEROOIS;}

logical fin_instr.is_il_swap_fix_yy()	option(hidden) 	{ return this.instr_type() == ..instr_type.IL_SWAP_FIX_Y_Y;}
logical fin_instr.is_il_swap_flt_yy()	option(hidden) 	{ return this.instr_type() == ..instr_type.IL_SWAP_FLT_Y_Y;}
logical fin_instr.is_il_swap_ois_yy()	option(hidden) 	{ return this.instr_type() == ..instr_type.IL_SWAP_OIS_Y_Y;}


logical instrument.is_stina() option(hidden)
{
	try{
		return this.instr_type() == ..instr_type.SWAP_FIXOIS && this.instr_def().currency()=="SEK";
	}
	catch {
		return false;
	}
}

/*-----------------------------------------------------------------------
  Name :  	instrument.is_bond_future_omx
  Notes :           
  Changes:
  			Date    		Who     Detail
  			6-Dec-2013 		MN      Original code (moved from fiws)  
			2-Apr-2014 		MN      removed instrument i 
			8-Apr-2016		MN		INST_BOND_FWD_OMX no longer available
			26-Sep-2016		MN		name change is_om_fwd() --> is_bond_future_omx()
			23-Apr-2018		MN		moved to i_instrument_class 
  ----------------------------------------------------------------------*/
logical instrument.is_bond_future_omx() option(hidden)
option(com_name: 'LEGACY_is_bond_future_omx')
{
	try{
		logical bf = this.instr_type() == ..instr_type.BOND_FUTURE;
		if(!bf)
			return false;
		return (bondfut_style() == bond_fut_style.FWD_CASH_SETTLE 
				|| bondfut_style() == bond_fut_style.SYNT_CASH_SETTLE
				|| bondfut_style() == bond_fut_style.SYNT_CASH_SETTLE_MTM);
	}
	catch {
		return false;
	}
}

/*-----------------------------------------------------------------------
  is_frn_rfr
  ----------------------------------------------------------------------*/
logical instrument.is_frn_rfr(error_info option(nullable) error) option(hidden)
{	
	try{
		if(!mw_lib_type())
			return false;

		logical c = i().__is_frn_rfr();
		return c;						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "instrument.is_frn_rfr");
		return false;
	}
}

