option(null: hard);	

/*	
	instrument wrapper functions
	Developer: Algorithmica Research, Magnus Nyström

	--------------------------------------------------------------------
	swap_il_fltyy create funcs
	--------------------------------------------------------------------			
*/

//--------
// from db
//--------
/*-----------------------------------------------------------------------
  swap_il_fltyy
  ----------------------------------------------------------------------*/
swap_il_fltyy swap_il_fltyy(instrument_name 			instrument_name, 
							date option(nullable) 		trade_date 	= null<date>,
							string option(nullable) 	quote_side 	= null<string>,
							error_info option(nullable) error		= null<error_info>)
option (category: "Instrument/Inflation Linked/Float vs Y-Y")
{	
	try{			
		__instrument c = __instrument(instrument_name,trade_date,quote_side, null<date> );		
		return create_swap_il_fltyy(c,error, E_INIT);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_il_fltyy");
		return null<swap_il_fltyy>;
	}
}


/*-----------------------------------------------------------------------
  swap_il_fltyy
  ----------------------------------------------------------------------*/
swap_il_fltyy swap_il_fltyy(instrument_name 			instrument_name, 
							date option(nullable) 		trade_date ,
							number  option(nullable) 	quote ,
							error_info option(nullable) error		= null<error_info>)
option (category: 'Instrument/Inflation Linked/Float vs Y-Y')
{	
	try{				
		__instrument c = __instrument(instrument_name,trade_date,quote, null<date> );
		return create_swap_il_fltyy(c,error, E_INIT);							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_il_fltyy");
		return null<swap_il_fltyy>;
	}
}


/*-----------------------------------------------------------------------
  swap_il_fltyy
  ----------------------------------------------------------------------*/
swap_il_fltyy swap_il_fltyy(instr_def 					instr_def, 
							date option(nullable) 		trade_date 	= null<date>,
							string option(nullable) 	quote_side 	= null<string>,
							error_info option(nullable) error		= null<error_info>)
option (category: 'Instrument/Inflation Linked/Float vs Y-Y')
{	
	try{				
		__instrument c = __instrument(instr_def,trade_date,quote_side, null<date> );
		return create_swap_il_fltyy(c,error, E_INIT);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_il_fltyy");
		return null<swap_il_fltyy>;
	}
}
/*-----------------------------------------------------------------------
  instrument
  ----------------------------------------------------------------------*/
swap_il_fltyy swap_il_fltyy(instr_def 					instr_def, 
							date option(nullable) 		trade_date ,
							number  option(nullable) 	quote ,
							error_info option(nullable) error		= null<error_info>)
option (category: 'Instrument/Inflation Linked/Float vs Y-Y')
{	
	try{			
		__instrument c = __instrument(instr_def,trade_date,quote, null<date> );
		return create_swap_il_fltyy(c,error, E_INIT);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_il_fltyy");
		return null<swap_il_fltyy>;
	}
}

//----------------
// from db or not
//----------------


/*-----------------------------------------------------------------------
  func: swap_il_fltyy 
  arguments: 
	instr_def: 	can be created either from the db or user defined 				 
				instr_def is copied and modified
				no lookup of quotes
	instrument_name: user defined name

  ----------------------------------------------------------------------*/