option(null: hard);	

/*	
	instrument wrapper functions
	Developer: Algorithmica Research, Magnus Nyström

	--------------------------------------------------------------------
		swap_zeroflt create funcs
	--------------------------------------------------------------------			
*/

//--------
// from db
//--------

/*-----------------------------------------------------------------------
  swap_zeroflt
  ----------------------------------------------------------------------*/
swap_zeroflt swap_zeroflt(instrument_name 			instrument_name, 
							date option(nullable) 	trade_date 	= null<date>,
							string option(nullable) quote_side 	= null<string>,
							error_info option(nullable) error = null<error_info>)
option (category: 'Instrument/Interest Rate Swap/Zero vs Float')
{	
	try{			
		__instrument c = __instrument(instrument_name,trade_date,quote_side, null<date> );		
		return create_swap_zeroflt(c,error, E_INIT);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_zeroflt");
		return null<swap_zeroflt>;
	}
}

/*-----------------------------------------------------------------------
  swap_zeroflt
  ----------------------------------------------------------------------*/
swap_zeroflt swap_zeroflt(instrument_name 			instrument_name, 
							date option(nullable) 		trade_date ,
							number  option(nullable) 	quote ,
							error_info option(nullable) error = null<error_info>)
option (category: 'Instrument/Interest Rate Swap/Zero vs Float')
{	
	try{				
		__instrument c = __instrument(instrument_name,trade_date,quote, null<date> );
		return create_swap_zeroflt(c,error, E_INIT);							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_zeroflt");
		return null<swap_zeroflt>;
	}
}

/*-----------------------------------------------------------------------
  swap_zeroflt
  ----------------------------------------------------------------------*/
swap_zeroflt swap_zeroflt(instr_def 				instr_def, 
							date option(nullable) 	trade_date 	= null<date>,
							string option(nullable) quote_side 	= null<string>,
							error_info option(nullable) error = null<error_info>)
option (category: 'Instrument/Interest Rate Swap/Zero vs Float')
{	
	try{				
		__instrument c = __instrument(instr_def,trade_date,quote_side, null<date> );
		return create_swap_zeroflt(c,error, E_INIT);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_zeroflt");
		return null<swap_zeroflt>;
	}
}
/*-----------------------------------------------------------------------
  swap_zeroflt
  ----------------------------------------------------------------------*/
swap_zeroflt swap_zeroflt(instr_def 				instr_def, 
							date option(nullable) 		trade_date ,
							number  option(nullable) 	quote ,
							error_info option(nullable) error = null<error_info>)
option (category: 'Instrument/Interest Rate Swap/Zero vs Float')
{	
	try{			
		__instrument c = __instrument(instr_def,trade_date,quote, null<date> );
		return create_swap_zeroflt(c,error, E_INIT);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_zeroflt");
		return null<swap_zeroflt>;
	}
}


//----------------
// from db or not
//----------------

/*-----------------------------------------------------------------------
  func: swap_zeroflt
  arguments: 
	instr_def: 	can be created either from the db or user defined 				 
				instr_def is copied and modified
				no lookup of quotes
	instrument_name: user defined name

  ----------------------------------------------------------------------*/
swap_zeroflt swap_zeroflt(instr_def 				instr_def, 
							string 					instrument_name  ,
							date option(nullable) 	trade_date ,
							date option(nullable) 	settle_date ,							
							date  option(nullable) 	maturity,//maturity has precedence over mat_code
							string option(nullable)	maturity_code,
							number option(nullable)	zero_rate,							
							number 					nominal = 100,
							error_info option(nullable) error = null<error_info>)
option (category: 'Instrument/Interest Rate Swap/Zero vs Float')
{	
	try{

		__instrument c;
		if(!null(maturity))
			c = __instrument_zeroflt_par_nodb(instr_def,instrument_name,trade_date,settle_date,
														maturity,zero_rate,nominal );
		else if(!null(maturity_code))
			c = __instrument_zeroflt_par_nodb(instr_def,instrument_name,trade_date,settle_date,
														maturity_code,zero_rate,nominal );
		else
			QL_FAIL("invalid maturity/maturity_code");

		return create_swap_zeroflt( c, error);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_zeroflt");
		return null<swap_zeroflt>;
	}
}


module CORE_INT_ZEROFLT
{	
	/*-----------------------------------------------------------------------
	  swap_zeroflt_par
	  ----------------------------------------------------------------------*/

	swap_zeroflt swap_zeroflt_par(instr_class_name 	class_name, 
								string				instrument_name, 									
								date 				trade_date, 
								date				settle_date,
								date 				maturity,
								number				zero_rate)
	//option (category: 'Instrument/Interest Rate Swap/Zero vs Float')
	{
		try {
			error_info ee = new error_info(true,false);
			instr_def i_d 	= instr_def(class_name ,ee);
			
			ee = new error_info(true,true);
			swap_zeroflt sw 	= ..swap_zeroflt(	i_d, instrument_name,trade_date,settle_date, 
														maturity,null<string>,zero_rate,100, ee);			
			return sw;
		}
		catch {
			CORE_INT.write_warning_message(err.message());
			return null<swap_zeroflt>;
		}
	}
}




