option(null: hard);	

/*	
	instrument wrapper functions
	Developer: Algorithmica Research, Magnus Nyström

	INCOMPLETE
	--------------------------------------------------------------------
		swap_zeroois create funcs
	--------------------------------------------------------------------			
*/

//--------
// from db
//--------

/*-----------------------------------------------------------------------
  swap_zeroois
  ----------------------------------------------------------------------*/
swap_zeroois swap_zeroois(instrument_name 			instrument_name, 
							date option(nullable) 	trade_date 	= null<date>,
							string option(nullable) quote_side 	= null<string>,
							error_info option(nullable) error = null<error_info>)
option (category: 'Instrument/Interest Rate Swap/Zero vs ONIndex')
{	
	try{			
		__instrument c = __instrument(instrument_name,trade_date,quote_side, null<date> );		
		return create_swap_zeroois(c,error, E_INIT);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_zeroois");
		return null<swap_zeroois>;
	}
}

/*-----------------------------------------------------------------------
  swap_zeroois
  ----------------------------------------------------------------------*/
swap_zeroois swap_zeroois(instrument_name 			instrument_name, 
							date option(nullable) 		trade_date ,
							number  option(nullable) 	quote ,
							error_info option(nullable) error = null<error_info>)
option (category: 'Instrument/Interest Rate Swap/Zero vs ONIndex')
{	
	try{				
		__instrument c = __instrument(instrument_name,trade_date,quote, null<date> );
		return create_swap_zeroois(c,error, E_INIT);							
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_zeroois");
		return null<swap_zeroois>;
	}
}

/*-----------------------------------------------------------------------
  swap_zeroois
  ----------------------------------------------------------------------*/
swap_zeroois swap_zeroois(instr_def 				instr_def, 
							date option(nullable) 	trade_date 	= null<date>,
							string option(nullable) quote_side 	= null<string>,
							error_info option(nullable) error = null<error_info>)
option (category: 'Instrument/Interest Rate Swap/Zero vs ONIndex')
{	
	try{				
		__instrument c = __instrument(instr_def,trade_date,quote_side, null<date> );
		return create_swap_zeroois(c,error, E_INIT);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_zeroois");
		return null<swap_zeroois>;
	}
}
/*-----------------------------------------------------------------------
  swap_zeroois
  ----------------------------------------------------------------------*/
swap_zeroois swap_zeroois(instr_def 				instr_def, 
							date option(nullable) 		trade_date ,
							number  option(nullable) 	quote ,
							error_info option(nullable) error = null<error_info>)
option (category: 'Instrument/Interest Rate Swap/Zero vs ONIndex')
{	
	try{			
		__instrument c = __instrument(instr_def,trade_date,quote, null<date> );
		return create_swap_zeroois(c,error, E_INIT);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_zeroois");
		return null<swap_zeroois>;
	}
}


//----------------
// from db or not
//----------------

/*-----------------------------------------------------------------------
  func: swap_zeroois
  arguments: 
	instr_def: 	can be created either from the db or user defined 				 
				instr_def is copied and modified
				no lookup of quotes
	instrument_name: user defined name

  ----------------------------------------------------------------------*/
swap_zeroois swap_zeroois(instr_def 				instr_def, 
							string 					instrument_name  ,
							date option(nullable) 	trade_date ,
							date option(nullable) 	settle_date ,							
							date  option(nullable) 	maturity,//maturity has precedence
							string option(nullable) maturity_code,
							number option(nullable)	zero_rate,							
							number 					nominal = 100,
							error_info option(nullable) error = null<error_info>)
option (category: 'Instrument/Interest Rate Swap/Zero vs ONIndex')
{	
	try{			
		__instrument c;
		
		if(!null(maturity))
			{}//c =  __instrument_zeroois_par_nodb(instr_def,instrument_name,trade_date,settle_date,maturity,zero_rate,nominal );
		else if(!null(maturity_code))
			{}//c = __instrument_zeroois_par_nodb(instr_def,instrument_name,trade_date,settle_date,maturity_code,zero_rate,nominal );
		else
			QL_FAIL("invalid maturity/maturity_code");
		
		return create_swap_zeroois( c, error);						
	}
	catch {
		CORE_INT.catch_error_info(error,err.type(),err.message(), "swap_zeroois");
		return null<swap_zeroois>;
	}
}


module CORE_INT_ZEROOIS
{	
	/*-----------------------------------------------------------------------
	  swap_zeroois_par
	  ----------------------------------------------------------------------*/

	swap_zeroois swap_zeroois_par(instr_class_name 	class_name, 
								string				instrument_name, 									
								date 				trade_date, 
								date				settle_date,
								date 				maturity,
								number				zero_rate)
	//option (category: 'Instrument/Interest Rate Swap/Zero vs ONIndex')
	{
		try {
			error_info ee = new error_info(true,false);
			instr_def i_d 	= instr_def(class_name ,ee);
			
			ee = new error_info(true,true);
			swap_zeroois sw 	= ..swap_zeroois(	i_d, instrument_name,trade_date,settle_date, 
														maturity,null<string>,zero_rate,100, ee);			
			return sw;
		}
		catch {
			CORE_INT.write_warning_message(err.message());
			return null<swap_zeroois>;
		}
	}
}

