/*	
	Basic swap wrapper classes and functions for "dual" bootstrap
	Developed by Algorithmica Research, Magnus Nyström
	
	
	Comments:
	
	
*/
option(null: hard);	

 
//-------------------------------------------------------
// fwd_b1_curve_create_synt (base case with basis swaps quoted as 1 swap)
// Example 
//  - disc_c 						OIS								[EONIA], [USDOIS]
//	- fwd_in						EUR 6M FRA, USD 3M FRA			[EUR6MFRA] [USD3MFRA], EUR 6m = flat leg, USD 3m != flat leg
//	- short_out_crv,				EURIBOR 3M, USD LIBOR 6M 
//	- fra_out_crv					EUR 3M FRA, USD 6M FRA			[EUR3MFRA] [USD6MFRA]	
// 	- basis_t1t2_crv 				EUR 3M/6M,  USD 3M/6M			[EUR3M6MSWAP[1SWP]] [USD3M6MSWAP[1SWP]] 
//-------------------------------------------------------
swap_curve_b1_ext fwd_b1_curve_create_synt(	date 						d,
											disc_func					df_disc,
											fwd_func_tenor fwd_tenor_in,
											fwd_func					fwd_func_in,
											fwd_func_tenor fwd_tenor_out,
											swap_curve_b1_f_parm		fwd_b1_parm,//short_out_crv, fra_out, basis
											disc_func option(nullable)	df_synt_base,
											date 						synt_end,
											fwd_z_model option(nullable) fwd_model_synt,										
											vector(date) option(nullable) basis_ip_mat ,
											fwd_func option(nullable) 	fwd_pre , 
											date option(nullable)		fwd_pre_cut_off )
option (category: 'Yield Curve/003 Curve Building')
{	
	
	string fwd_tenor_s = string(fwd_tenor_out);
	string name = strcat(["fwd_basis1_",fwd_tenor_s]);
	return swap_curve_b1_ext(fwd_tenor_out, fwd_b1_parm, d, df_disc, fwd_func_in, basis_ip_mat,
							 fwd_tenor_in, df_synt_base,synt_end,fwd_model_synt,name,fwd_pre,fwd_pre_cut_off);
}

//-------------------------------------------------------
// fwd_b1_curve_create (base case with basis swaps quoted as 1 swap)
// Example 
//  - disc_c 						OIS								[EONIA], [USDOIS]
//	- fwd_in						EUR 6M FRA, USD 3M FRA			[EUR6MFRA] [USD3MFRA], EUR 6m = flat leg, USD 3m != flat leg
//	- short_out_crv,				EURIBOR 3M, USD LIBOR 6M 		"solve-tenor"
//	- fra_out_crv					EUR 3M FRA, USD 6M FRA			[EUR3MFRA] [USD6MFRA]	"solve-tenor"
// 	- basis_t1t2_crv 				EUR 3M/6M,  USD 3M/6M			[EUR3M6MSWAP[1SWP]] [USD3M6MSWAP[1SWP]] 
//-------------------------------------------------------
swap_curve_b1_ext fwd_b1_curve_create(	date 						d,
										disc_func					df_disc,
										fwd_func_tenor fwd_tenor_in,
										fwd_func					fwd_func_in,
										fwd_func_tenor fwd_tenor_out,	//"solve-tenor"
										swap_curve_b1_f_parm		fwd_b1_parm,		////"solve-tenor": short_out_crv, fra_out, basis										
										vector(date) option(nullable) basis_ip_mat ,
										fwd_func option(nullable) 	fwd_pre , 
										date option(nullable)		fwd_pre_cut_off )
option (category: 'Yield Curve/003 Curve Building')
{
	
	string fwd_tenor_s = string(fwd_tenor_out);
	string name = strcat(["fwd_basis1_",fwd_tenor_s]);	
	return swap_curve_b1_ext(fwd_tenor_out, fwd_b1_parm, d, df_disc, fwd_func_in,
							 basis_ip_mat, fwd_tenor_in, name,fwd_pre,fwd_pre_cut_off);
}
//-------------------------------------------------------
// fwd_b1_curve_create_f_synt
//-------------------------------------------------------
fwd_func fwd_b1_curve_create_f_synt(date 						d,
									disc_func					df_disc,
									fwd_func_tenor fwd_tenor_in,
									fwd_func					fwd_func_in,
									fwd_func_tenor fwd_tenor_out,
									swap_curve_b1_f_parm		fwd_b1_parm,//short_out_crv, fra_out, basis								
									disc_func option(nullable)	df_synt_base,
									date 						synt_end,
									fwd_z_model option(nullable) fwd_model,
									logical 					model_spr,
									out swap_curve_b1_ext  		fwd_crv,
									vector(date) option(nullable) basis_ip_mat ,
									fwd_func option(nullable) 	fwd_pre , 
									date option(nullable)		fwd_pre_cut_off )
option (category: 'Yield Curve/003 Curve Building')
{
	fwd_crv = fwd_b1_curve_create_synt(	d,df_disc,fwd_tenor_in,fwd_func_in,fwd_tenor_out,fwd_b1_parm,df_synt_base,
									synt_end,fwd_model,basis_ip_mat ,fwd_pre ,fwd_pre_cut_off );
	return model_spr ? fwd_crv.fwd_spr(fwd_model) : fwd_crv.fwd(fwd_model);	
}

//-------------------------------------------------------
// fwd_b1_curve_create_f
//-------------------------------------------------------
fwd_func fwd_b1_curve_create_f(	date 						d,
								disc_func					df_disc,
								fwd_func_tenor	fwd_tenor_in,
								fwd_func					fwd_func_in,
								fwd_func_tenor	fwd_tenor_out,
								swap_curve_b1_f_parm		fwd_b1_parm,//short_out_crv, fra_out, basis								
								fwd_z_model option(nullable) fwd_model,
								logical 					model_spr,
								out swap_curve_b1_ext  		fwd_crv,
								vector(date) option(nullable) basis_ip_mat ,
								fwd_func option(nullable) 	fwd_pre , 
								date option(nullable)		fwd_pre_cut_off )
option (category: 'Yield Curve/003 Curve Building')
{
	fwd_crv = fwd_b1_curve_create(	d,df_disc,fwd_tenor_in,fwd_func_in,fwd_tenor_out,fwd_b1_parm,
									basis_ip_mat ,fwd_pre ,fwd_pre_cut_off );
	return model_spr ? fwd_crv.fwd_spr(fwd_model) : fwd_crv.fwd(fwd_model);	
}


//-------------------------------------------------------
// fwd_b1_curve_create_tmpl
//-------------------------------------------------------
swap_curve_b1_ext fwd_b1_curve_create_tmpl(	date 							d,											
											fwd_func_tenor	fwd_tenor_base,
											fwd_func						fwd_func_base,
											fwd_func_tenor	fwd_tenor,
											CURVE_TMPL.fwd_curve_model_tmpl model,											
											curve option(nullable)			short_crv,
											logical	option(nullable)		short_crv_is_fix,
											curve option(nullable)			fra_crv,
											curve 							basis_crv,
											disc_func						df,
											disc_func option(nullable)		df_synt_base,
											date option(nullable)			synt_end,
											out fwd_z_model 				fwd_model,
											vector(date) option(nullable) 	basis_ip_mat ,
											fwd_func option(nullable) 		fwd_pre , 
											date option(nullable)			fwd_pre_cut_off,
											vector(number) option(nullable) edfut_cvx_adj )
	option (category: 'Yield Curve/003 Curve Building')
{
	/*fwd_model_parm fwd_p = fwd_model_parm();
	
	if(!null(model.z_model_e()))
		fwd_p.set_model(model.z_model_e());
	
	fwd_model = init_fwd_model(fwd_p);*/

	fwd_model = model.fwd_model();
	
	vector(number) fra_crv_y_spr, basis_crv_q_spr;
	swap_curve_b1_f_parm fwd_parm;

	QL_FAIL_COND(!null(short_crv) && null(short_crv_is_fix),"invalid fixing flag for short curve");
	if(null(short_crv_is_fix))
		short_crv_is_fix = false;
	
	if(short_crv_is_fix)
		fwd_parm = swap_curve_b1_f_parm(fixing_curve(short_crv),fra_crv,basis_crv, model.blend_parm(),
										fra_crv_y_spr, basis_crv_q_spr,edfut_cvx_adj);
	else
		fwd_parm = swap_curve_b1_f_parm(short_crv, fra_crv, basis_crv,  model.blend_parm(),
										fra_crv_y_spr, basis_crv_q_spr,edfut_cvx_adj);
	
	swap_curve_b1_ext fwd_crv;
	if(model.incl_synt())			
		fwd_crv	= fwd_b1_curve_create_synt(	d,df,fwd_tenor_base,fwd_func_base,
											fwd_tenor,
											fwd_parm,//short_out_crv, fra_out, basis
											df_synt_base,
											synt_end,
											fwd_model,										
											basis_ip_mat ,
											fwd_pre , 
											fwd_pre_cut_off );

		
	else
		fwd_crv	= fwd_b1_curve_create(d,df,fwd_tenor_base,fwd_func_base,
										fwd_tenor,	//"solve-tenor"
										fwd_parm,		////"solve-tenor": short_out_crv, fra_out, basis										
										basis_ip_mat ,
										fwd_pre , 
										fwd_pre_cut_off);

	
	
	return fwd_crv;
}

//-------------------------------------------------------
// fwd_b1_curve_create_tmpl
//-------------------------------------------------------
swap_curve_b1_ext fwd_b1_curve_create_tmpl(	date 								d,
											CURVE_TMPL.fwd_basis_curve_tmpl 	fwd_c,
											CURVE_TMPL.fwd_curve_model_tmpl 	model,
											fwd_func							fwd_func_base,
											disc_func							df,
											disc_func option(nullable)			df_synt_base,
											date option(nullable)				synt_end,
											out fwd_z_model 					fwd_model,
											vector(date) option(nullable) 		basis_ip_mat ,
											fwd_func option(nullable) 			fwd_pre , 
											date option(nullable)				fwd_pre_cut_off,
											vector(number) option(nullable) edfut_cvx_adj = null<vector(number)> )
	option (category: 'Yield Curve/003 Curve Building')
{
	error_info err = new error_info(true,true);
	return fwd_b1_curve_create_tmpl(d,fwd_c.fwd_tenor_base(),fwd_func_base,fwd_c.fwd_tenor(),
									model,
									fwd_c.short_crv(d, null<quote_side>,err),
									fwd_c.short_crv_is_fix(),
									fwd_c.middle_crv(d, null<quote_side>,err),
									fwd_c.basis_crv(d, null<quote_side>,err),
									df,df_synt_base,synt_end,fwd_model,
									basis_ip_mat,fwd_pre,fwd_pre_cut_off,edfut_cvx_adj);
}

//-------------------------------------------------------
// fwd_b1_curve_create_tmpl
//-------------------------------------------------------
fwd_func fwd_b1_curve_create_f_tmpl(date 							d,											
									fwd_func_tenor	fwd_tenor_base,
									fwd_func						fwd_func_base,
									fwd_func_tenor	fwd_tenor,
									CURVE_TMPL.fwd_curve_model_tmpl model,											
									curve option(nullable)			short_crv,
									logical	option(nullable)		short_crv_is_fix,
									curve option(nullable)			middle_crv,
									curve 							basis_crv,
									disc_func						df,
									disc_func option(nullable)		df_synt_base,
									date option(nullable)			synt_end,
									out swap_curve_b1_ext 			fwd_crv,
									vector(date) option(nullable) 	basis_ip_mat ,
									fwd_func option(nullable) 		fwd_pre , 
									date option(nullable)			fwd_pre_cut_off,
									vector(number) option(nullable) edfut_cvx_adj  )
	option (category: 'Yield Curve/003 Curve Building')
{
	fwd_z_model fwd_model;
	fwd_crv = fwd_b1_curve_create_tmpl(d,fwd_tenor_base,fwd_func_base,fwd_tenor,
									model,
									short_crv,short_crv_is_fix,
									middle_crv,
									basis_crv,
									df,df_synt_base,synt_end,fwd_model,
									basis_ip_mat,fwd_pre,fwd_pre_cut_off,
									edfut_cvx_adj);
	return model.model_spr() ? fwd_crv.fwd_spr(fwd_func_base,fwd_model) : fwd_crv.fwd(fwd_model);
}
//-------------------------------------------------------
// fwd_b1_curve_create_tmpl
//-------------------------------------------------------
fwd_func fwd_b1_curve_create_f_tmpl(date 								d,
									CURVE_TMPL.fwd_basis_curve_tmpl 	fwd_c,
									CURVE_TMPL.fwd_curve_model_tmpl 	model,
									fwd_func							fwd_func_base,
									disc_func							df,
									disc_func option(nullable)			df_synt_base,
									date option(nullable)				synt_end,
									out swap_curve_b1_ext 				fwd_crv,
									vector(date) option(nullable) 		basis_ip_mat ,
									fwd_func option(nullable) 			fwd_pre , 
									date option(nullable)				fwd_pre_cut_off,
									vector(number) option(nullable) 	edfut_cvx_adj = null<vector(number)>)
	option (category: 'Yield Curve/003 Curve Building')
{
	error_info err = new error_info(true,true);
	fwd_z_model fwd_model;
	fwd_crv = fwd_b1_curve_create_tmpl(	d,
										fwd_c.fwd_tenor_base(),
										fwd_func_base,
										fwd_c.fwd_tenor(),
										model,
										fwd_c.short_crv(d, null<quote_side>,err),
										fwd_c.short_crv_is_fix(),
										fwd_c.middle_crv(d, null<quote_side>,err),
										fwd_c.basis_crv(d, null<quote_side>,err),
										df,df_synt_base,synt_end,fwd_model,
										basis_ip_mat,fwd_pre,fwd_pre_cut_off,
										edfut_cvx_adj);

	return model.model_spr() ? fwd_crv.fwd_spr(fwd_func_base,fwd_model) : fwd_crv.fwd(fwd_model);
	
}

