
/*
	Basic swap wrapper classes and functions for "dual" bootstrap
	Developed by Algorithmica Research, Magnus Nyström
	
	
	Comments:
	
	
*/
option(null: hard);	

 
//-------------------------------------------------------
// fwd_b2_curve_create_synt (base case with basis swaps quoted as 2 swaps) (create synthetic fra(s) for fwd curve via basis spreads)
// Example 
//	1) fra_out_c = EUR 3M FRA, USD 6M FRA							[EUR3MFRA], [USD6MFRA]
//	2) swap_in_c = EUR IRS 6M EURIBOR, USD IRS 3M LIBOR				[EUR6MSWAP], [USD3MSWAP]
// 	3) basis_t1t2_c = EUR 3M/6M EURIBOR, USD 3M/6M LIBOR 		  	[EUR3M6MSWAP[2SWP]], [USD3M6MSWAP[2SWP]] 
//-------------------------------------------------------

swap_curve_b2_ext fwd_b2_curve_create_synt(	date 					d,
										disc_func option(nullable)	df_disc,
										fwd_func_tenor 				fwd_tenor,
										swap_curve_b2_f_parm		fwd_b2_parm,//contains fixing_crv, fra_out_crv, swap_in, basis
										disc_func option(nullable)	df_synt_base,
										date 						synt_end,
										logical 					x_pol_basis,										
										fwd_func option(nullable) 	fwd_pre , 
										date option(nullable)		fwd_pre_cut_off,
										logical 					no_checking = false )
option (category: 'Yield Curve/003 Curve Building')
{	
	
	string fwd_tenor_s = string(fwd_tenor);
	string name = strcat(["fwd_basis2_",fwd_tenor_s]);
	return swap_curve_b2_ext(fwd_tenor, fwd_b2_parm, d, df_disc,df_synt_base,synt_end, x_pol_basis, name,
							 fwd_pre,fwd_pre_cut_off, no_checking);
				
}

//-------------------------------------------------------
// fwd_b2_curve_create (base case with basis swaps quoted as 2 swaps)
// Example 
//	1) fra_out_c = EUR 3M FRA, USD 6M FRA							[EUR3MFRA], [USD6MFRA]
//	2) swap_in_c = EUR IRS 6M EURIBOR, USD IRS 3M LIBOR				[EUR6MSWAP], [USD3MSWAP]
// 	3) basis_t1t2_c = EUR 3M/6M EURIBOR, USD 3M/6M LIBOR 		  	[EUR3M6MSWAP[2SWP]], [USD3M6MSWAP[2SWP]] 
//-------------------------------------------------------

swap_curve_b2_ext fwd_b2_curve_create(	date 						d,
										disc_func	option(nullable) df_disc,
										fwd_func_tenor 				fwd_tenor,
										swap_curve_b2_f_parm		fwd_b2_parm,//contains fixing_crv, fra_out_crv, swap_in, basis
										logical 					x_pol_basis,										
										fwd_func option(nullable) 	fwd_pre , 
										date option(nullable)		fwd_pre_cut_off,
										logical 					no_checking = false )
option (category: 'Yield Curve/003 Curve Building')
{	
	string fwd_tenor_s = string(fwd_tenor);
	string name = strcat(["fwd_basis2_",fwd_tenor_s]);
	return swap_curve_b2_ext(fwd_tenor, fwd_b2_parm, d, df_disc, x_pol_basis, name,fwd_pre,
							 fwd_pre_cut_off, no_checking);
				
}

//-------------------------------------------------------
// fwd_b2_curve_create_f_synt (base case with basis swaps quoted as 2 swaps)
//-------------------------------------------------------

fwd_func fwd_b2_curve_create_f_synt(date 						d,
									disc_func 					df_disc,
									fwd_func_tenor 				fwd_tenor,
									swap_curve_b2_f_parm		fwd_b2_parm,//contains fixing_crv, fra_out_crv, swap_in, basis
									disc_func option(nullable)	df_synt_base,
									date 						synt_end,
									fwd_z_model  				fwd_model,							
									logical 					x_pol_basis,
									out swap_curve_b2_ext 		fwd_crv,													
									fwd_func option(nullable) 	fwd_pre , 
									date option(nullable)		fwd_pre_cut_off,
									logical 					no_checking = false)
option (category: 'Yield Curve/003 Curve Building')
{			
	fwd_crv = fwd_b2_curve_create_synt(d,df_disc,fwd_tenor, fwd_b2_parm, df_synt_base,synt_end, x_pol_basis,
									   fwd_pre,fwd_pre_cut_off, no_checking);
	return fwd_crv.fwd(fwd_model);							
}

//-------------------------------------------------------
// fwd_b2_curve_create_f (base case with basis swaps quoted as 2 swaps)
//-------------------------------------------------------

fwd_func fwd_b2_curve_create_f(	date 						d,
								disc_func					df_disc,
								fwd_func_tenor 				fwd_tenor,
								swap_curve_b2_f_parm		fwd_b2_parm,//contains fixing_crv, fra_out_crv, swap_in, basis							
								fwd_z_model  				fwd_model,							
								logical 					x_pol_basis,
								out swap_curve_b2_ext 		fwd_crv,													
								fwd_func option(nullable) 	fwd_pre , 
								date option(nullable)		fwd_pre_cut_off,
								logical 					no_checking = false )
option (category: 'Yield Curve/003 Curve Building')
{			
	fwd_crv = fwd_b2_curve_create(d,df_disc,fwd_tenor, fwd_b2_parm, x_pol_basis, fwd_pre,fwd_pre_cut_off, no_checking);
	return fwd_crv.fwd(fwd_model);							
}
//-------------------------------------------------------
// fwd_b2_curve_create_synt (base case with basis swaps quoted as 2 swaps)
//-------------------------------------------------------

fwd_func fwd_b2_curve_create_f_synt(date 						d,
									disc_func					df_disc,
									fwd_func_tenor 				fwd_tenor,
									swap_curve_b2_f_parm		fwd_b2_parm,//contains fixing_crv, fra_out_crv, swap_in, basis
									disc_func option(nullable)	df_synt_base,
									date 						synt_end,
									fwd_z_model  				fwd_model,							
									logical						model_spr,
									fwd_func option(nullable)	fwd_func_base,
									logical 					x_pol_basis,
									out swap_curve_b2_ext 		fwd_crv,													
									fwd_func option(nullable) 	fwd_pre , 
									date option(nullable)		fwd_pre_cut_off,
									logical 					no_checking = false)
option (category: 'Yield Curve/003 Curve Building')
{			
	fwd_crv = fwd_b2_curve_create_synt(d,df_disc,fwd_tenor, fwd_b2_parm, df_synt_base,synt_end, x_pol_basis,
									   fwd_pre,fwd_pre_cut_off,no_checking);
	if(model_spr){
		QL_REQUIRE(!null(fwd_func_base), "invalid fwd_func_base (required when modelling the spread)");
		return fwd_crv.fwd_spr(fwd_func_base,fwd_model);
	}
	else
		return fwd_crv.fwd(fwd_model);							
}



//-------------------------------------------------------
// fwd_b2_curve_create (base case with basis swaps quoted as 2 swaps)
//-------------------------------------------------------

fwd_func fwd_b2_curve_create_f(	date 						d,
								disc_func					df_disc,
								fwd_func_tenor 				fwd_tenor,
								swap_curve_b2_f_parm		fwd_b2_parm,//contains fixing_crv, fra_out_crv, swap_in, basis							
								fwd_z_model  				fwd_model,							
								logical						model_spr,
								fwd_func option(nullable)	fwd_func_base,
								logical 					x_pol_basis,
								out swap_curve_b2_ext 		fwd_crv,													
								fwd_func option(nullable) 	fwd_pre , 
								date option(nullable)		fwd_pre_cut_off,
								logical 					no_checking = false)
option (category: 'Yield Curve/003 Curve Building')
{			
	fwd_crv = fwd_b2_curve_create(d,df_disc,fwd_tenor, fwd_b2_parm, x_pol_basis, fwd_pre,fwd_pre_cut_off,no_checking);
	if(model_spr){
		QL_REQUIRE(!null(fwd_func_base), "invalid fwd_func_base (required when modelling the spread)");
		return fwd_crv.fwd_spr(fwd_func_base,fwd_model);
	}
	else
		return fwd_crv.fwd(fwd_model);							
}

//-------------------------------------------------------
// fwd_b2_curve_create_tmpl
//-------------------------------------------------------
swap_curve_b2_ext fwd_b2_curve_create_tmpl(	date 							d,											
											fwd_func_tenor					fwd_tenor,
											CURVE_TMPL.fwd_curve_model_tmpl model,											
											curve option(nullable)			short_crv,
											logical	option(nullable)		short_crv_is_fix,
											curve option(nullable)			fra_crv,
											curve 							swap_crv,
											curve 							basis_crv,
											disc_func option(nullable)		df,
											disc_func option(nullable)		df_synt_base,
											date option(nullable)			synt_end,											
											out fwd_z_model 				fwd_model,
											fwd_func option(nullable) 		fwd_pre , 
											date option(nullable)			fwd_pre_cut_off,
											vector(number) option(nullable) edfut_cvx_adj )
	option (category: 'Yield Curve/003 Curve Building')
{
	/*fwd_model_parm fwd_p = fwd_model_parm();
	
	if(!null(model.z_model_e()))
		fwd_p.set_model(model.z_model_e());
	
	fwd_model = init_fwd_model(fwd_p);*/
	
	fwd_model = model.fwd_model();
	
	vector(number) fra_crv_y_spr, basis_crv_q_spr,swap_crv_y_spr;
	swap_curve_b2_f_parm fwd_parm;

	QL_FAIL_COND(!null(short_crv) && null(short_crv_is_fix),"invalid fixing flag for short curve");
	if(null(short_crv_is_fix))
		short_crv_is_fix = false;
	
	if(short_crv_is_fix)
		fwd_parm = swap_curve_b2_f_parm(fixing_curve(short_crv),fra_crv,swap_crv,basis_crv, model.blend_parm(),
										fra_crv_y_spr,swap_crv_y_spr, basis_crv_q_spr,edfut_cvx_adj);
	else
		fwd_parm = swap_curve_b2_f_parm(short_crv, fra_crv, swap_crv,basis_crv,  model.blend_parm(),
										fra_crv_y_spr, swap_crv_y_spr,basis_crv_q_spr,edfut_cvx_adj);
	
	swap_curve_b2_ext fwd_crv;
	if(model.incl_synt())			
		fwd_crv	= fwd_b2_curve_create_synt(	d,df,fwd_tenor,
											fwd_parm,
											df_synt_base,
											synt_end,
											model.x_pol_basis(),
											fwd_pre , 
											fwd_pre_cut_off );
	else
		fwd_crv	= fwd_b2_curve_create(d,df,
										fwd_tenor,	
										fwd_parm,		
										model.x_pol_basis(),
										fwd_pre , 
										fwd_pre_cut_off);
	return fwd_crv;
}

//-------------------------------------------------------
// fwd_b2_curve_create_tmpl
//-------------------------------------------------------
swap_curve_b2_ext fwd_b2_curve_create_tmpl(	date 								d,
											CURVE_TMPL.fwd_basis_2swp_curve_tmpl 	fwd_c,
											CURVE_TMPL.fwd_curve_model_tmpl 	model,
											disc_func option(nullable)			df,
											disc_func option(nullable)			df_synt_base,
											date option(nullable)				synt_end,
											out fwd_z_model 					fwd_model,
											fwd_func option(nullable) 			fwd_pre , 
											date option(nullable)				fwd_pre_cut_off,
											vector(number) option(nullable) 	edfut_cvx_adj = null<vector(number)> )
	option (category: 'Yield Curve/003 Curve Building')
{
	error_info err = new error_info(true,true);
	return fwd_b2_curve_create_tmpl(d,fwd_c.fwd_tenor(),
									model,
									fwd_c.short_crv(d, null<quote_side>,err),
									fwd_c.short_crv_is_fix(),
									fwd_c.middle_crv(d, null<quote_side>,err),
									fwd_c.long_base_crv(d, null<quote_side>,err),
									fwd_c.basis_crv(d, null<quote_side>,err),
									df,df_synt_base,synt_end,fwd_model,
									fwd_pre,fwd_pre_cut_off,edfut_cvx_adj);
}


//-------------------------------------------------------
// fwd_b2_curve_create_tmpl
//-------------------------------------------------------
fwd_func fwd_b2_curve_create_f_tmpl(date 							d,											
									fwd_func_tenor					fwd_tenor,
									CURVE_TMPL.fwd_curve_model_tmpl model,											
									curve option(nullable)			short_crv,
									logical	option(nullable)		short_crv_is_fix,
									curve option(nullable)			middle_crv,
									curve 							long_crv,
									curve 							basis_crv,
									disc_func						df,
									disc_func option(nullable)		df_synt_base,
									date option(nullable)			synt_end,
									fwd_func option(nullable) 		fwd_func_base,
									out swap_curve_b2_ext 			fwd_crv,								
									fwd_func option(nullable) 		fwd_pre , 
									date option(nullable)			fwd_pre_cut_off,
									vector(number) option(nullable) edfut_cvx_adj  )
	option (category: 'Yield Curve/003 Curve Building')
{
	fwd_z_model fwd_model;
	fwd_crv = fwd_b2_curve_create_tmpl(d,fwd_tenor,
									model,
									short_crv,short_crv_is_fix,
									middle_crv,
									long_crv,
									basis_crv,
									df,df_synt_base,synt_end,fwd_model,
									fwd_pre,fwd_pre_cut_off,edfut_cvx_adj);
	
	if(model.model_spr()){
		QL_REQUIRE(!null(fwd_func_base), "invalid fwd_func_base (required when modelling the spread)");
		return fwd_crv.fwd_spr(fwd_func_base,fwd_model);
	}
	else
		return fwd_crv.fwd(fwd_model);
}

//-------------------------------------------------------
// fwd_b2_curve_create_tmpl
//-------------------------------------------------------
fwd_func fwd_b2_curve_create_f_tmpl(date 								d,
									CURVE_TMPL.fwd_basis_2swp_curve_tmpl 	fwd_c,
									CURVE_TMPL.fwd_curve_model_tmpl 	model,
									disc_func							df,
									disc_func option(nullable)			df_synt_base,
									date option(nullable)				synt_end,
									fwd_func option(nullable) 			fwd_func_base,
									out swap_curve_b2_ext 				fwd_crv,									
									fwd_func option(nullable) 			fwd_pre , 
									date option(nullable)				fwd_pre_cut_off,
									vector(number) option(nullable) 	edfut_cvx_adj = null<vector(number)>)
	option (category: 'Yield Curve/003 Curve Building')
{
	error_info err = new error_info(true,true);
	fwd_z_model fwd_model;
	fwd_crv = fwd_b2_curve_create_tmpl(	d,
										fwd_c.fwd_tenor(),
										model,
										fwd_c.short_crv(d, null<quote_side>,err),
										fwd_c.short_crv_is_fix(),
										fwd_c.middle_crv(d, null<quote_side>,err),
										fwd_c.long_base_crv(d, null<quote_side>,err),
										fwd_c.basis_crv(d, null<quote_side>,err),
										df,df_synt_base,synt_end,fwd_model,
										fwd_pre,fwd_pre_cut_off,edfut_cvx_adj);

	
	if(model.model_spr()){
		QL_REQUIRE(!null(fwd_func_base), "invalid fwd_func_base (required when modelling the spread)");
		return fwd_crv.fwd_spr(fwd_func_base,fwd_model);
	}
	else
		return fwd_crv.fwd(fwd_model);
}
