/*	
	Basic swap wrapper classes and functions for "dual" bootstrap
	Developed by Algorithmica Research, Magnus Nyström
	
	
	Comments:
	
	
*/
option(null: hard);	


//-------------------------------------------------------
// cbois_curve_create
//-------------------------------------------------------
swap_curve_bc_ois cbois_curve_create(	date 						d,
										swap_curve_cbois1_f_parm	cb1_parm,
										disc_func option(nullable)	df_disc_flat,
										disc_func option(nullable)	df_disc_sprd,
										disc_func					df_fwd_flat,			
										disc_func 					df_fwd_sprd,	
										string option(nullable)		name)
option (category: 'Yield Curve/003 Curve Building Cross Currency')
{
	return swap_curve_bc_ois(d,cb1_parm,df_disc_flat,df_disc_sprd,  df_fwd_flat,df_fwd_sprd,name) ;
}

//-------------------------------------------------------
// cbfltois_curve_create
//-------------------------------------------------------
swap_curve_bc_fltois cbfltois_curve_create(	date 						d,
											swap_curve_cbois1_f_parm	cb1_parm,
											disc_func option(nullable)	df_disc_flat,
											disc_func option(nullable)	df_disc_sprd,
											disc_func					df_fwd,	//ois index rates		
											fwd_func 					f_fwd,
											fwd_func_tenor 				fwd_tenor,
											//logical						ois_leg_is_flat,
											string option(nullable)		name)
option (category: 'Yield Curve/003 Curve Building Cross Currency')
{
	logical ois_leg_is_flat = true;
	return swap_curve_bc_fltois(d,cb1_parm,df_disc_flat,df_disc_sprd, df_fwd,f_fwd,fwd_tenor,ois_leg_is_flat,name) ;
}

//-------------------------------------------------------
// cb_curve_create
//-------------------------------------------------------
swap_curve_bc_ext cb_curve_create(	date 						d,
									swap_curve_cb1_f_parm		cb1_parm,
									disc_func option(nullable)	df_disc_flat,
									disc_func option(nullable)	df_disc_sprd,
									fwd_func					f_fwd_flat,
									fwd_func_tenor				fwd_tenor_flat,			
									fwd_func 					f_fwd_sprd,
									fwd_func_tenor				fwd_tenor_sprd,	
									string option(nullable)		name)
option (category: 'Yield Curve/003 Curve Building Cross Currency')
{
	return swap_curve_bc_ext(d,cb1_parm,df_disc_flat,df_disc_sprd, f_fwd_flat,fwd_tenor_flat,f_fwd_sprd,fwd_tenor_sprd, name) ;
}
//-------------------------------------------------------
// cb_curve_flat_disc
//-------------------------------------------------------
disc_func cb_curve_flat_disc(	date 						d,
								swap_curve_cb1_f_parm		cb1_parm,
								disc_func option(nullable)	df_disc_flat,
								disc_func 					df_disc_sprd,
								fwd_func					f_fwd_flat,
								fwd_func_tenor 				fwd_tenor_flat,			
								fwd_func 					f_fwd_sprd,
								fwd_func_tenor 				fwd_tenor_sprd,
								string option(nullable) 	name,
								disc_z_model 				disc_model,									
								out swap_curve_bc_ext option(nullable)		curve_bc)
option (category: 'Yield Curve/003 Curve Building Cross Currency')

{
	curve_bc	= cb_curve_create(	d,cb1_parm,df_disc_flat, df_disc_sprd,f_fwd_flat,fwd_tenor_flat, f_fwd_sprd,fwd_tenor_sprd, name);

	return curve_bc.adj_disc_df_flat(disc_model);
}
//-------------------------------------------------------
// cb_curve_sprd_disc
//-------------------------------------------------------
disc_func cb_curve_sprd_disc(	date 						d,
								swap_curve_cb1_f_parm		cb1_parm,
								disc_func 					df_disc_flat,
								disc_func option(nullable)	df_disc_sprd,
								fwd_func					f_fwd_flat,
								fwd_func_tenor fwd_tenor_flat,			
								fwd_func 					f_fwd_sprd,
								fwd_func_tenor fwd_tenor_sprd,
								string option(nullable) 	name,
								disc_z_model 				disc_model,									
								out swap_curve_bc_ext option(nullable) curve_bc)
option (category: 'Yield Curve/003 Curve Building Cross Currency')

{
	curve_bc	= cb_curve_create(	d,cb1_parm,df_disc_flat, df_disc_sprd,f_fwd_flat,fwd_tenor_flat, f_fwd_sprd,fwd_tenor_sprd, name);

	return curve_bc.adj_disc_df_sprd(disc_model);
}

//-------------------------------------------------------
// cb_curve_create_tmpl
//-------------------------------------------------------
swap_curve_bc_ext cb_curve_create_tmpl(	date 							d,											
										disc_func 						df_flat,
										fwd_func						fwd_flat,
										instrument						fixing_instr_flat,
										disc_func 						df_sprd,
										fwd_func						fwd_sprd,
										instrument						fixing_instr_sprd,
										CURVE_TMPL.currbasis_curve_model_tmpl model,
										curve  option(nullable) 		fxswap_crv,
										curve  option(nullable) 		basis_crv,
										fx_spot							fx_sp)
	option (category: 'Yield Curve/003 Curve Building Cross Currency')
{
	fixing_curve  fixing_crv_flat 	= fixing_curve(curve([fixing_instr_flat]));
	fixing_curve  fixing_crv_sprd 	= fixing_curve(curve([fixing_instr_sprd]));

	ir_index idx_flat 				= fixing_instr_flat.ir_index();
	QL_REQUIRE(!null(idx_flat), "invalid fixing instrument (flat leg)");
	tenor_code tc 					= idx_flat.tenor_code();
	fwd_func_tenor fwd_tenor_flat = fwd_func_tenor_from_tc(tc);
		
	ir_index idx_sprd 				= fixing_instr_sprd.ir_index();
	QL_REQUIRE(!null(idx_sprd), "invalid fixing instrument (spread leg)");
	tc 								= idx_sprd.tenor_code();
	fwd_func_tenor fwd_tenor_sprd = fwd_func_tenor_from_tc(tc);
	
	swap_curve_cb1_f_parm cb1_parm = swap_curve_cb1_f_parm(	fx_sp,fxswap_crv,fixing_crv_flat,fixing_crv_sprd,											
															basis_crv,model.merge_crv(),model.prio_fx_swap(),
															model.blend_buf_days());
	
	swap_curve_bc_ext bc 			= cb_curve_create(	d,cb1_parm,df_flat, df_sprd,fwd_flat,fwd_tenor_flat,
														fwd_sprd,fwd_tenor_sprd,"noname");

	return bc;
}

//-------------------------------------------------------
// cb_curve_create_tmpl
//-------------------------------------------------------
swap_curve_bc_ext cb_curve_create_tmpl(	date 							d,											
										disc_func 						df_flat,
										fwd_func						fwd_flat,
										disc_func 						df_sprd,
										fwd_func						fwd_sprd,
										CURVE_TMPL.currbasis_curve_tmpl fcrvg,
										CURVE_TMPL.currbasis_curve_model_tmpl model )
	option (category: 'Yield Curve/003 Curve Building Cross Currency')
{
	error_info err = new error_info(true,true);

	instrument fix_instr_sprd 	= instrument(fcrvg.fixing_instr_sprd(),d,fcrvg.fixing_instr_qs());
	instrument fix_instr_flat	= instrument(fcrvg.fixing_instr_flat(),d,fcrvg.fixing_instr_qs());
	//fcrvg.fwd_curve_tmpl_flat().fwd_tenor()
	//fcrvg.fwd_curve_tmpl_sprd().fwd_tenor()
	return cb_curve_create_tmpl(d,df_flat,fwd_flat,fix_instr_flat,
								df_sprd,fwd_sprd,fix_instr_sprd,
								model,
								fcrvg.fx_swap_crv(d, null<quote_side>, err),
								fcrvg.basis_crv(d, null<quote_side>, err),
								fcrvg.fx_sp(d,null<quote_side>, err));
}