/*	
	Basic swap wrapper classes and functions for "dual" bootstrap
	Developed by Algorithmica Research, Magnus Nyström
	
	
	Comments:
	
	
*/
option(null: hard);



//-------------------------------------------------------
// cff_curve_create
//-------------------------------------------------------
swap_curve_cff_ext cff_curve_create(date 						d,
									swap_curve_cff_f_parm 		cff_parm,
									disc_func option(nullable)	fix_df_disc,
									disc_func option(nullable)	flt_df_disc,
									fwd_func					flt_fwd,
									fwd_func_tenor fwd_tenor,													
									string option(nullable)		name)
option (category: 'Yield Curve/003 Curve Building Cross Currency')
{
	/*integer freq 		= fwd_func_tenor.to_freq(fwd_tenor);
	string	fwd_tenor_s = string(fwd_tenor);			
	ir_index 	fwd_idx = null<ir_index>;
	
	fixing_curve new_f_crv;	
	CORE_INT.fwd_init(d,cff_parm.fixing_crv(),fwd_tenor,fwd_tenor_s,fwd_idx,new_f_crv);//after fwd_init the fixing curve will contain only 1 fixing instrument (for fwd_tenor) 
	if(!null(new_f_crv)) cff_parm =  swap_curve_cff_f_parm(cff_parm,new_f_crv); 

	vector(instrument) v_i	= cff_parm.fixflt_crv().instruments();
	QL_REQUIRE(v_size(v_i) > 0, "invalid fixflt swap curve");
	integer freq_i 			= v_i[0].swap_coupon_freq_leg2();
	QL_REQUIRE(freq_i == freq, "invalid float coupon frequency (fixflt swap curve)");*/

	return swap_curve_cff_ext(d,cff_parm,fix_df_disc,flt_df_disc, flt_fwd, fwd_tenor, name) ;
}

//-------------------------------------------------------
// cff_curve_fix_disc
//-------------------------------------------------------
disc_func cff_curve_fix_disc(date 						d,
							swap_curve_cff_f_parm 		cff_parm,							
							disc_func option(nullable)	fix_df_disc,
							disc_func 					flt_df_disc,
							fwd_func					flt_fwd,
							fwd_func_tenor fwd_tenor,													
							string option(nullable)		name,
							disc_z_model 				disc_model,									
							out swap_curve_cff_ext option(nullable)	 curve_cff)
option (category: 'Yield Curve/003 Curve Building Cross Currency')
{
	curve_cff = cff_curve_create(d,cff_parm,fix_df_disc,flt_df_disc,flt_fwd,fwd_tenor,name);
	return curve_cff.fix_adj_disc_df(disc_model);
}

//-------------------------------------------------------
// cff_curve_flt_disc
//-------------------------------------------------------
disc_func cff_curve_flt_disc(date 						d,
							swap_curve_cff_f_parm 		cff_parm,							
							disc_func					fix_df_disc,
							disc_func  option(nullable)	flt_df_disc,
							fwd_func					flt_fwd,
							fwd_func_tenor fwd_tenor,													
							string option(nullable)		name,
							disc_z_model 				disc_model,									
							out swap_curve_cff_ext option(nullable)	 curve_cff)
option (category: 'Yield Curve/003 Curve Building Cross Currency')
{
	curve_cff = cff_curve_create(d,cff_parm,fix_df_disc,flt_df_disc,flt_fwd,fwd_tenor,name);
	return curve_cff.flt_adj_disc_df(disc_model);
}
