/*	
	Basic swap wrapper classes and functions for "dual" bootstrap
	Developed by Algorithmica Research, Magnus Nyström
	
	
	Comments:
	
	
*/
option(null: hard);	

 
//-------------------------------------------------------
// disc_curve_create
// create discounting curve object
//-------------------------------------------------------
swap_curve_disc_ext disc_curve_create(	date 					d,
										swap_curve_disc_parm	disc_parm)
option (category: 'Yield Curve/003 Curve Building')								   
{	
	return swap_curve_disc_ext(disc_parm, d, "disc");	
}
//-------------------------------------------------------
// disc_curve_create_df
// create discounting disc_func
//-------------------------------------------------------
disc_func disc_curve_create_df(	date 						d,
								swap_curve_disc_parm		disc_parm,
								disc_z_model 				disc_model,								
								out swap_curve_disc_ext 	disc)
option (category: 'Yield Curve/003 Curve Building')								   
{
	disc = disc_curve_create(d,disc_parm);
	return disc.disc_df(disc_model);
}
//-------------------------------------------------------
// disc_curve_create (with extension of the curve)
// create discounting curve with extension
//-------------------------------------------------------

swap_curve_disc_ext disc_curve_create(	date 				d,										
										swap_curve_disc_ext	disc_base,					
										curve  				extrap_crv,																						
										disc_z_model 		extrap_model)
option (category: 'Yield Curve/003 Curve Building')								   
{
	curve disc_blended	= disc_base.blended_curve();	
	
	vector(instrument) disc_ext = CORE_INT.extend_disc_curve(d,disc_blended,extrap_crv,extrap_model);
	if(!null(disc_ext) && v_size(disc_ext) > 0){
		vector(instrument) v_i 			= disc_blended.instruments();					
		disc_blended 					= curve(concat (v_i, disc_ext),strcat(disc_blended.name(),"-ext"));
		swap_curve_disc_parm disc_parm	= swap_curve_disc_parm(	null<curve>,null<curve>,disc_blended, 
																false,false,false,curve_prio.LONG,curve_prio.MIDDLE,0);	
		return disc_curve_create(d,disc_parm) ;		
	}	
	else
		return disc_base;
}
//-------------------------------------------------------
// disc_curve_create_df  (with extension of the curve)
// create discounting disc_func with extension
//-------------------------------------------------------
disc_func disc_curve_create_df(	date 						d,
								swap_curve_disc_parm		disc_parm,															
								curve  						extrap_crv,																							
								disc_z_model 				disc_model,															
								disc_z_model 				extrap_model,																								
								out swap_curve_disc_ext 	disc)
option (category: 'Yield Curve/003 Curve Building')								   
{
	swap_curve_disc_ext	disc_base = disc_curve_create(d,disc_parm) ;
	disc = disc_curve_create(d,disc_base,extrap_crv,extrap_model);
	return disc.disc_df(disc_model);
}



//-------------------------------------------------------
// disc_curve_create_tmpl
//-------------------------------------------------------
swap_curve_disc_ext disc_curve_create_tmpl(	date 								d,
											CURVE_TMPL.disc_curve_model_tmpl 	model,
											curve option(nullable)				short_crv,
											curve option(nullable)				middle_crv,
											curve option(nullable)				long_crv,
											curve option(nullable)				extrap_crv,
											//number option(nullable) 			long_first_fix,
											out disc_z_model 					disc_model,
											vector(date) option(nullable) 		cb_dates,
											vector(number) option(nullable) 	edfut_cvx_adj)
{
	vector(number)  short_crv_y_spr, fra_crv_y_spr,  swap_crv_y_spr;
	swap_curve_disc_parm disc_parm	= swap_curve_disc_parm(	short_crv,
															middle_crv,
															long_crv,
															model.blend_parm(),
															//long_first_fix,
															short_crv_y_spr,fra_crv_y_spr, swap_crv_y_spr,
															edfut_cvx_adj);
	
	swap_curve_disc_ext disc_curve 	= disc_curve_create(d,disc_parm);

	disc_model = model.disc_model(disc_parm.cal(),cb_dates);

	if(null(extrap_crv))
		return disc_curve;
			
	disc_z_model extrap_model = model.extrap_model();
	
	return disc_curve_create(d, disc_curve, extrap_crv, extrap_model);
}

//-------------------------------------------------------
// disc_curve_create_tmpl
//-------------------------------------------------------
swap_curve_disc_ext disc_curve_create_tmpl(	date 								d,
											CURVE_TMPL.disc_curve_tmpl 			disc_c,
											CURVE_TMPL.disc_curve_model_tmpl 	model,
											out disc_z_model 					disc_model,
											vector(date) option(nullable) 		cb_dates = null<vector(date)>,
											vector(number) option(nullable) 	edfut_cvx_adj = null<vector(number)> )
	option (category: 'Yield Curve/003 Curve Building')	
{
	error_info err = new error_info(true,true);
	return disc_curve_create_tmpl(	d,model,
									disc_c.short_crv(d, null<quote_side>,err),
									disc_c.middle_crv(d, null<quote_side>,err),
									disc_c.long_crv(d, null<quote_side>,err),
									disc_c.extrap_crv(d, null<quote_side>,err),									
									disc_model,cb_dates,edfut_cvx_adj);
}
	
//-------------------------------------------------------
// disc_curve_create_df_tmpl
//-------------------------------------------------------
disc_func disc_curve_create_df_tmpl(	date 								d,
										CURVE_TMPL.disc_curve_model_tmpl 	model,
										curve option(nullable)				short_crv,
										curve option(nullable)				middle_crv,
										curve option(nullable)				long_crv,
										curve option(nullable)				extrap_crv,
										//number option(nullable) 			long_first_fix,
										out swap_curve_disc_ext 			disc,
										vector(date) option(nullable) 		cb_dates,
										vector(number) option(nullable) 	edfut_cvx_adj)	
{
	disc_z_model disc_model;
	disc 			= disc_curve_create_tmpl(d,model,short_crv,middle_crv,long_crv,
											 extrap_crv,disc_model,cb_dates,edfut_cvx_adj);
	return disc.disc_df(disc_model);
}
//-------------------------------------------------------
// disc_curve_create_df_tmpl
//-------------------------------------------------------
disc_func disc_curve_create_df_tmpl(	date 								d,
										CURVE_TMPL.disc_curve_tmpl 			disc_c,
										CURVE_TMPL.disc_curve_model_tmpl 	model,
										out swap_curve_disc_ext 			disc,
										vector(date) option(nullable) 		cb_dates = null<vector(date)>,
										vector(number) option(nullable) 	edfut_cvx_adj = null<vector(number)>)
	option (category: 'Yield Curve/003 Curve Building')	
{
	disc_z_model disc_model;
	disc 			= disc_curve_create_tmpl(d,disc_c,model,disc_model,cb_dates,edfut_cvx_adj);
	return disc.disc_df(disc_model);
}

