/*	
	Basic swap wrapper classes and functions for "dual" bootstrap
	Developed by Algorithmica Research, Magnus Nyström
	
	
	Comments:

	Fix/LIB  +  LIB/ois(+s)  =  Fix(+adjs)/ois
*/
option(null: hard);	

//-------------------------------------------------------
// disc_curve_create
// create discounting curve object
//-------------------------------------------------------
swap_curve_disc_b1_ext disc_curve_create(	date 					d,
											swap_curve_b1_disc_parm	disc_parm,
											logical					extrap_ok)
option (category: 'Yield Curve/003 Curve Building')								   
{	
	return swap_curve_disc_b1_ext(disc_parm, d, extrap_ok, "disc");	
}
//-------------------------------------------------------
// disc_curve_create
// create discounting curve object
// this version needs to be used when there is a mismatch between ois/ibor basis swap and fix/flt swap
//-------------------------------------------------------
swap_curve_disc_b1_ext disc_curve_create(	date 					d,
											swap_curve_b1_disc_parm	disc_parm,
											swap_curve_fwd_f_parm 	fwd_parm,
											disc_z_model 			disc_model,
											fwd_z_model 			fwd_model,
											logical					extrap_ok)											
option (category: 'Yield Curve/003 Curve Building')								   
{	
	return swap_curve_disc_b1_ext(disc_parm, fwd_parm, d,disc_model, fwd_model, extrap_ok, "disc");	
}
//-------------------------------------------------------
// disc_curve_create_df
// create discounting disc_func
//-------------------------------------------------------
disc_func disc_curve_create_df(	date 						d,
								swap_curve_b1_disc_parm		disc_parm,
								logical						extrap_ok,
								disc_z_model 				disc_model,								
								out swap_curve_disc_b1_ext 	disc)
option (category: 'Yield Curve/003 Curve Building')								   
{
	disc = disc_curve_create(d,disc_parm, extrap_ok);
	return disc.disc_df(disc_model);
}

//-------------------------------------------------------
// disc_b1_curve_create_tmpl
//-------------------------------------------------------
swap_curve_disc_b1_ext disc_b1_curve_create_tmpl(	date 								d,
													CURVE_TMPL.disc_curve_model_tmpl 	model,
													curve option(nullable)				short_crv,
													curve option(nullable)				middle_crv,
													curve option(nullable)				long_crv,
													curve 								lib_swap_crv,
													curve 								ois_lib_basis_crv,	
													out disc_z_model 					disc_model,
													vector(date) option(nullable) 		cb_dates,
													vector(number) option(nullable) 	edfut_cvx_adj,
													logical allow_fra_swap_adj = true)
{
	vector(number)  short_crv_y_spr, fra_crv_y_spr,  lo_crv_y_spr, basis_crv_y_spr,bb_crv_y_spr;
	swap_curve_b1_disc_parm disc_parm	= swap_curve_b1_disc_parm(	short_crv,
																	middle_crv,
																	long_crv,
																	lib_swap_crv,
																	ois_lib_basis_crv,															
																	model.blend_parm(),
																	allow_fra_swap_adj,
																	short_crv_y_spr,fra_crv_y_spr, lo_crv_y_spr,
																	bb_crv_y_spr,basis_crv_y_spr, edfut_cvx_adj);

	logical extrap_ok = true;
	
	disc_model = model.disc_model(disc_parm.cal(),cb_dates);
	return disc_curve_create(d,disc_parm,extrap_ok);
	
/*	if(null(extrap_crv))
		return disc_curve;
			
	disc_z_model extrap_model = model.extrap_model();
	
	return disc_curve_create(d, disc_curve, extrap_crv, extrap_model);*/
}
//-------------------------------------------------------
// disc_b1_curve_create_tmpl
//-------------------------------------------------------
swap_curve_disc_b1_ext disc_b1_curve_create_tmpl(date 								d,
												CURVE_TMPL.disc_basis_curve_tmpl 	disc_c,
												CURVE_TMPL.disc_curve_model_tmpl 	model,
												out disc_z_model 					disc_model,
												vector(date) option(nullable) 		cb_dates = null<vector(date)>,
												vector(number) option(nullable) 	edfut_cvx_adj = null<vector(number)> )
	option (category: 'Yield Curve/003 Curve Building')	
{
	error_info err = new error_info(true,true);
	return disc_b1_curve_create_tmpl(	d,model,
										disc_c.short_crv(d, null<quote_side>,err),
										disc_c.middle_crv(d, null<quote_side>,err),
										disc_c.long_crv(d, null<quote_side>,err),
										disc_c.lib_swap_crv(d, null<quote_side>,err),
										disc_c.ois_lib_basis_crv(d, null<quote_side>,err),																		
										disc_model,cb_dates,edfut_cvx_adj);
}

//-------------------------------------------------------
// disc_b1_curve_create_df_tmpl
//-------------------------------------------------------
disc_func disc_b1_curve_create_df_tmpl(	date 								d,
										CURVE_TMPL.disc_curve_model_tmpl 	model,
										curve option(nullable)				short_crv,
										curve option(nullable)				middle_crv,
										curve option(nullable)				long_crv,
										curve 								lib_swap_crv,
										curve 								ois_lib_basis_crv,	
										out swap_curve_disc_b1_ext 			disc,
										vector(date) option(nullable) 		cb_dates,
										vector(number) option(nullable) 	edfut_cvx_adj)
{
	disc_z_model disc_model;
	disc 			= disc_b1_curve_create_tmpl(d,model,short_crv,middle_crv,long_crv,
												lib_swap_crv,ois_lib_basis_crv,
												disc_model,cb_dates,edfut_cvx_adj);
	return disc.disc_df(disc_model);
}
//-------------------------------------------------------
// disc_b1_curve_create_df_tmpl
//-------------------------------------------------------
disc_func disc_b1_curve_create_df_tmpl(	date 								d,
										CURVE_TMPL.disc_basis_curve_tmpl 	disc_c,
										CURVE_TMPL.disc_curve_model_tmpl 	model,
										out swap_curve_disc_b1_ext 			disc,
										vector(date) option(nullable) 		cb_dates = null<vector(date)>,
										vector(number) option(nullable) 	edfut_cvx_adj = null<vector(number)>)
	option (category: 'Yield Curve/003 Curve Building')	
{
	disc_z_model disc_model;
	disc 			= disc_b1_curve_create_tmpl(d,disc_c,model,disc_model,cb_dates,edfut_cvx_adj);
	return disc.disc_df(disc_model);
}