/*	
	Basic swap wrapper classes and functions for "dual" bootstrap
	Developed by Algorithmica Research, Magnus Nyström
	
	
	Comments:
	
	
*/
option(null: hard);	

//-------------------------------------------------------
// disc_curve_create
// create discounting curve object
//-------------------------------------------------------
swap_curve_disc_b1o_ext disc_curve_create(	date 						d,
											swap_curve_b1o_disc_parm	disc_parm,
											logical						extrap_ok)
option (category: 'Yield Curve/003 Curve Building')								   
{	
	return swap_curve_disc_b1o_ext(disc_parm, d, extrap_ok, "disc");	//no mismatch allowed
}

//-------------------------------------------------------
// disc_curve_create_df
// create discounting disc_func
//-------------------------------------------------------
disc_func disc_curve_create_df(	date 						d,
								swap_curve_b1o_disc_parm	disc_parm,
								logical						extrap_ok,
								disc_z_model 				disc_model,								
								out swap_curve_disc_b1o_ext	disc)
option (category: 'Yield Curve/003 Curve Building')								   
{
	disc = disc_curve_create(d,disc_parm, extrap_ok);
	return disc.disc_df(disc_model);
}
