/*	
	Basic swap wrapper classes and functions for "dual" bootstrap
	Developed by Algorithmica Research, Magnus Nyström
	
	
	Comments:
	
	
*/
option(null: hard);	

//-------------------------------------------------------
// disc_curve_create
// create discounting curve object
//-------------------------------------------------------
swap_curve_disc_b2_ext disc_curve_create(	date 					d,
											swap_curve_b2_disc_parm	disc_parm,
											logical					extrap_ok,
											logical 				no_checking = false)
option (category: 'Yield Curve/003 Curve Building')								   
{	
	return swap_curve_disc_b2_ext(disc_parm, d, extrap_ok, "disc", no_checking);	//no mismatch allowed
}
//-------------------------------------------------------
// disc_curve_create
// create discounting curve object
// this version needs to be used when there is a mismatch between ois/ibor basis swap and fix/flt swap
//-------------------------------------------------------
swap_curve_disc_b2_ext disc_curve_create(	date 					d,
											swap_curve_b2_disc_parm	disc_parm,
											swap_curve_fwd_f_parm 	fwd_parm,
											disc_z_model 			disc_model,
											fwd_z_model 			fwd_model,
											logical					extrap_ok,
											logical 				no_checking = false)											
option (category: 'Yield Curve/003 Curve Building')								   
{	
	return swap_curve_disc_b2_ext(disc_parm, fwd_parm, d,disc_model, fwd_model, extrap_ok, "disc", no_checking);	
}
//-------------------------------------------------------
// disc_curve_create_df
// create discounting disc_func
//-------------------------------------------------------
disc_func disc_curve_create_df(	date 						d,
								swap_curve_b2_disc_parm		disc_parm,
								logical						extrap_ok,
								disc_z_model 				disc_model,								
								out swap_curve_disc_b2_ext 	disc,
								logical 					no_checking = false)
option (category: 'Yield Curve/003 Curve Building')								   
{
	disc = disc_curve_create(d,disc_parm, extrap_ok, no_checking );
	return disc.disc_df(disc_model);
}
