/*	
	Basic swap wrapper classes and functions for "dual" bootstrap
	Developed by Algorithmica Research, Magnus Nyström
	
	
	Comments:
	
	
*/
option(null: hard);	
//-------------------------------------------------------
// get_fwd_func_tenor
//-------------------------------------------------------
fwd_func_tenor get_fwd_func_tenor(swap_curve_fwd_f_parm fwd_parm)
{
	try {
		error_info ee = new error_info(true,true);
		fwd_func_tenor ft;
		
		tenor_code tc;
		if(check_curve(fwd_parm.fra_crv())){
			instrument ii = fwd_parm.fra_crv().instruments()[0];
			tc = ii.index_tenor_code(ee);
			ft = fwd_func_tenor_from_tc(tc);		
			return ft;
			
		}
		else if(check_curve(fwd_parm.swap_crv())) { 
			instrument ii = fwd_parm.swap_crv().instruments()[0];
			tc = ii.index_tenor_code(ee);
			ft = fwd_func_tenor_from_tc(tc);		
			return ft;
		}
		else {
			if(fwd_parm.short_is_fix_crv()) {
				if(fwd_parm.fixing_crv().n_instruments() == 1) {
					string mc = fwd_parm.fixing_crv().instruments()[0].maturity_code(ee);
					return CORE_INT.date_code_str_to_fwd_func_tenor(mc);
				}				
			}
			else if(check_curve(fwd_parm.short_crv())) {
				if(v_size(fwd_parm.short_crv().instruments()) == 1) {
					string mc = fwd_parm.short_crv().instruments()[0].maturity_code(ee);
					return CORE_INT.date_code_str_to_fwd_func_tenor(mc);
				}
			}		
		}
		
		return null<fwd_func_tenor>;
	}
	catch {
		return null<fwd_func_tenor>;
	}
}

//-------------------------------------------------------
// fwd_curve_create_synt  (base case without basis swaps, create synts on short end)
// Example
//  1) disc_c = Eonia or similar	[EONIA]
//	2) fra_c = EUR 6M FRA			[EUR6MFRA]
//	3) swap_c = EUR IRS 6M EURIBOR	[EUR6MSWAP]
//-------------------------------------------------------
swap_curve_fwd_ext fwd_curve_create_synt(date 							d,
										disc_func						df_disc,
										fwd_func_tenor	option(nullable) fwd_tenor,
										swap_curve_fwd_f_parm			fwd_parm,									
										disc_func option(nullable)		df_synt_base,
										date 							synt_end,																			
										fwd_func option(nullable) 		fwd_pre , 
										date option(nullable)			fwd_pre_cut_off,
										logical 						no_checking = false )
option (category: 'Yield Curve/003 Curve Building')
{					
	if(null(fwd_tenor)){

		fwd_tenor = get_fwd_func_tenor(fwd_parm);
		QL_REQUIRE(!null(fwd_tenor),"invalid fwd tenor");
	}
	
	string fwd_tenor_s = string(fwd_tenor);
	string name = strcat(["fwd_",fwd_tenor_s]);
	return swap_curve_fwd_ext(fwd_tenor, fwd_parm, d, df_disc, df_synt_base,synt_end, name, fwd_pre, fwd_pre_cut_off,no_checking);
}

//-------------------------------------------------------
// fwd_curve_create  (base case without basis swaps)
// Example
//  1) disc_c = Eonia or similar	[EONIA]
//	2) fra_c = EUR 6M FRA			[EUR6MFRA]
//	3) swap_c = EUR IRS 6M EURIBOR	[EUR6MSWAP]
//-------------------------------------------------------
swap_curve_fwd_ext fwd_curve_create(date 							d,
									disc_func option(nullable)		df_disc,//nullable as a test
									fwd_func_tenor option(nullable)	fwd_tenor,
									swap_curve_fwd_f_parm			fwd_parm,																										
									fwd_func option(nullable) 		fwd_pre , 
									date option(nullable)			fwd_pre_cut_off,
									logical 						no_checking = false)
option (category: 'Yield Curve/003 Curve Building')
{
	if(null(fwd_tenor)){
		fwd_tenor = get_fwd_func_tenor(fwd_parm);
		QL_REQUIRE(!null(fwd_tenor),"invalid fwd tenor");
	}
	
	string fwd_tenor_s	= string(fwd_tenor);
	string name = strcat(["fwd_",fwd_tenor_s]);
	return swap_curve_fwd_ext(fwd_tenor, fwd_parm, d, df_disc, name, fwd_pre, fwd_pre_cut_off,no_checking);						
}

//-------------------------------------------------------
// fwd_ois_curve_create 
//-------------------------------------------------------
swap_curve_fwd_ext fwd_ois_curve_create(date 							d,										
										swap_curve_fwd_f_parm			fwd_parm,																										
										fwd_func option(nullable) 		fwd_pre , 
										date option(nullable)			fwd_pre_cut_off,
										logical 						no_checking = false )
option (category: 'Yield Curve/003 Curve Building')
{
	fwd_func_tenor fwd_tenor = get_fwd_func_tenor(fwd_parm);
	
	string fwd_tenor_s	= string(fwd_tenor);
	string name = strcat(["fwd_",fwd_tenor_s]);
	return swap_curve_fwd_ext(fwd_tenor, fwd_parm, d, null<disc_func>, name, fwd_pre, fwd_pre_cut_off,no_checking);						
}

//-------------------------------------------------------
// fwd_curve_create_f_synt  (base case without basis swaps, create synts on short end)
//-------------------------------------------------------
fwd_func fwd_curve_create_f_synt(	date 							d,
									disc_func						df_disc,														
									fwd_func_tenor option(nullable) fwd_tenor,
									swap_curve_fwd_f_parm			fwd_parm,								
									disc_func option(nullable)		df_synt_base,
									date 							synt_end,
									fwd_z_model  					fwd_model,
									logical							model_spr,																					
									out swap_curve_fwd_ext 			fwd_crv,							
									fwd_func option(nullable) 		fwd_pre , 
									date option(nullable)			fwd_pre_cut_off,
									logical 						no_checking = false  )
option (category: 'Yield Curve/003 Curve Building')
{		
	fwd_crv = fwd_curve_create_synt(d,df_disc,fwd_tenor,fwd_parm,df_synt_base,synt_end,fwd_pre,fwd_pre_cut_off,no_checking);
	return model_spr ? fwd_crv.fwd_spr(df_disc,fwd_model) : fwd_crv.fwd(fwd_model);				
}

//-------------------------------------------------------
// fwd_curve_create_f  (base case without basis swaps)
//-------------------------------------------------------
fwd_func fwd_curve_create_f(date 							d,
							disc_func						df_disc,														
							fwd_func_tenor option(nullable)	fwd_tenor,
							swap_curve_fwd_f_parm			fwd_parm,												
							fwd_z_model  					fwd_model,
							logical							model_spr,																					
							out swap_curve_fwd_ext 			fwd_crv,							
							fwd_func option(nullable) 		fwd_pre, 
							date option(nullable)			fwd_pre_cut_off,
							logical 						no_checking = false  )
option (category: 'Yield Curve/003 Curve Building')
{		
	fwd_crv = fwd_curve_create(d,df_disc,fwd_tenor,fwd_parm,fwd_pre,fwd_pre_cut_off,no_checking);
	return model_spr ? fwd_crv.fwd_spr(df_disc,fwd_model) : fwd_crv.fwd(fwd_model);				
}

//-------------------------------------------------------
// fwd_ois_curve_create_f 
//-------------------------------------------------------
fwd_func fwd_ois_curve_create_f(date 							d,										
								swap_curve_fwd_f_parm			fwd_parm,
								fwd_z_model  					fwd_model,
								out swap_curve_fwd_ext 			fwd_crv,
								fwd_func option(nullable) 		fwd_pre , 
								date option(nullable)			fwd_pre_cut_off )
option (category: 'Yield Curve/003 Curve Building')
{
	fwd_crv = fwd_ois_curve_create(d,fwd_parm,fwd_pre,fwd_pre_cut_off);
	return fwd_crv.fwd(fwd_model);	
}

//-------------------------------------------------------
// fwd_curve_create_tmpl
//-------------------------------------------------------
swap_curve_fwd_ext fwd_curve_create_tmpl(	date 								d,
											fwd_func_tenor option(nullable)		tenor,
											CURVE_TMPL.fwd_curve_model_tmpl 	model,
											curve option(nullable)				short_crv,
											logical	option(nullable)			short_crv_is_fix,
											curve option(nullable)				fra_crv,
											curve option(nullable)				swap_crv,
											disc_func	option(nullable)		df_disc,
											disc_func option(nullable)			df_synt_base,
											date option(nullable)				synt_end,
											out fwd_z_model 					fwd_model,							
											fwd_func option(nullable) 			fwd_pre, 
											date option(nullable)				fwd_pre_cut_off,
											vector(number) option(nullable) 	edfut_cvx_adj,
											logical								force_null_swap_first_fix)
	option (category: 'Yield Curve/003 Curve Building')
{
	vector(number) fra_crv_y_spr, swap_crv_y_spr;
	swap_curve_fwd_f_parm fwd_parm;

	
	QL_FAIL_COND(!null(short_crv) && null(short_crv_is_fix),"invalid fixing flag for short curve");
	if(null(short_crv_is_fix))
		short_crv_is_fix = false;
	
	if(short_crv_is_fix){
		fwd_parm = swap_curve_fwd_f_parm(fixing_curve(short_crv),fra_crv,swap_crv, model.blend_parm(),
										fra_crv_y_spr, swap_crv_y_spr,edfut_cvx_adj,force_null_swap_first_fix);
	}
	else {
		QL_REQUIRE(!null(fra_crv) || !null(swap_crv),"fra/fut/sps-curve and/or swap-curve is required when short curve is a deposit-curve");
		number swap_first_fix = null<number>;
		fwd_parm = swap_curve_fwd_f_parm(short_crv, fra_crv, swap_crv,  model.blend_parm(),
										fra_crv_y_spr, swap_crv_y_spr,edfut_cvx_adj,swap_first_fix);
	}
	
	swap_curve_fwd_ext fwd_crv;
	if(model.incl_synt()){
		QL_FAIL_COND(null(df_disc) ,"invalid df_disc (required when including synthetic instruments)");
		QL_FAIL_COND(null(synt_end) ,"invalid synt end date (required when including synthetic instruments)");
		fwd_crv	= fwd_curve_create_synt(d, df_disc,tenor, fwd_parm, df_synt_base, synt_end,fwd_pre,fwd_pre_cut_off);
	}
	else{
		fwd_crv	= fwd_curve_create(d, df_disc,tenor, fwd_parm,fwd_pre,fwd_pre_cut_off);
	}
	
	fwd_model = model.fwd_model();
	
	return fwd_crv;
}

//-------------------------------------------------------
// fwd_curve_create_tmpl
//-------------------------------------------------------
swap_curve_fwd_ext fwd_curve_create_tmpl(	date 								d,
											CURVE_TMPL.fwd_curve_tmpl 			fwd_c,
											CURVE_TMPL.fwd_curve_model_tmpl 	model,
											disc_func							df_disc,
											disc_func option(nullable)			df_synt_base,
											date option(nullable)				synt_end,
											out fwd_z_model 					fwd_model,							
											fwd_func option(nullable) 			fwd_pre, 
											date option(nullable)				fwd_pre_cut_off,
											vector(number) option(nullable) 	edfut_cvx_adj, 
											logical								force_null_swap_first_fix )
	option (category: 'Yield Curve/003 Curve Building')
{
	error_info err = new error_info(true,true);
	return fwd_curve_create_tmpl(	d,fwd_c.fwd_tenor(),model,
									fwd_c.short_crv(d, null<quote_side>,err),
									fwd_c.short_crv_is_fix(),
									fwd_c.middle_crv(d, null<quote_side>,err),
									fwd_c.long_crv(d, null<quote_side>,err),
									df_disc,df_synt_base,synt_end,fwd_model,fwd_pre,fwd_pre_cut_off,
									edfut_cvx_adj,force_null_swap_first_fix);
}
//-------------------------------------------------------
// fwd_curve_create_f_tmpl
//-------------------------------------------------------
fwd_func fwd_curve_create_f_tmpl(	date 								d,
									fwd_func_tenor option(nullable) 	tenor,
									CURVE_TMPL.fwd_curve_model_tmpl 	model,
									curve option(nullable)				short_crv,
									logical	option(nullable)			short_crv_is_fix,
									curve option(nullable)				middle_crv,
									curve option(nullable)				long_crv,
									disc_func							df_disc,
									disc_func option(nullable)			df_synt_base,
									date option(nullable)				synt_end,
									out swap_curve_fwd_ext 	 			fwd_crv,							
									fwd_func option(nullable) 			fwd_pre, 
									date option(nullable)				fwd_pre_cut_off,
									vector(number) option(nullable) 	edfut_cvx_adj,
									logical								force_null_swap_first_fix)
	option (category: 'Yield Curve/003 Curve Building')
{
	fwd_z_model fwd_model;
	fwd_crv = fwd_curve_create_tmpl(d,tenor,model,short_crv,short_crv_is_fix,middle_crv,long_crv,df_disc,
									df_synt_base,synt_end, fwd_model,fwd_pre,
									fwd_pre_cut_off,edfut_cvx_adj,force_null_swap_first_fix);
	return model.model_spr() ? fwd_crv.fwd_spr(df_disc,fwd_model) : fwd_crv.fwd(fwd_model);
}
//-------------------------------------------------------
// fwd_curve_create_f_tmpl
//-------------------------------------------------------
fwd_func fwd_curve_create_f_tmpl(	date 								d,
									CURVE_TMPL.fwd_curve_tmpl 			fwd_c,
									CURVE_TMPL.fwd_curve_model_tmpl 	model,
									disc_func							df_disc,
									disc_func option(nullable)			df_synt_base,
									date option(nullable)				synt_end,
									out swap_curve_fwd_ext 	 			fwd_crv,							
									fwd_func option(nullable) 			fwd_pre, 
									date option(nullable)				fwd_pre_cut_off,
									vector(number) option(nullable) 	edfut_cvx_adj,									
									logical								force_null_swap_first_fix)
	option (category: 'Yield Curve/003 Curve Building')
{
	fwd_z_model fwd_model;
	fwd_crv = fwd_curve_create_tmpl(d,fwd_c,model,df_disc,df_synt_base,synt_end, fwd_model,
									fwd_pre,fwd_pre_cut_off,edfut_cvx_adj,force_null_swap_first_fix);
	return model.model_spr() ? fwd_crv.fwd_spr(df_disc,fwd_model) : fwd_crv.fwd(fwd_model);
}

//-------------------------------------------------------
// fwd_ois_curve_create_tmpl
//-------------------------------------------------------
swap_curve_fwd_ext fwd_ois_curve_create_tmpl(date 								d,
											CURVE_TMPL.fwd_curve_model_tmpl 	model,
											curve option(nullable)				short_crv,
											logical	option(nullable)			short_crv_is_fix,
											curve option(nullable)				middle_crv,
											curve option(nullable)				long_crv,											
											out fwd_z_model 					fwd_model,							
											fwd_func option(nullable) 			fwd_pre, 
											date option(nullable)				fwd_pre_cut_off )
	option (category: 'Yield Curve/003 Curve Building')
{
	vector(number) mi_crv_y_spr, lo_crv_y_spr,edfut_cvx_adj;
	swap_curve_fwd_f_parm fwd_parm;

	
	QL_FAIL_COND(!null(short_crv) && null(short_crv_is_fix),"invalid fixing flag for short curve");
	if(null(short_crv_is_fix))
		short_crv_is_fix = false;
	
	if(short_crv_is_fix){
		fwd_parm = swap_curve_fwd_f_parm(fixing_curve(short_crv),middle_crv,long_crv, model.blend_parm(),
										mi_crv_y_spr, lo_crv_y_spr,edfut_cvx_adj,false);
	}
	else {
		QL_REQUIRE(!null(middle_crv) || !null(long_crv),"middle-curve and/or long-curve is required when short curve is a deposit-curve");
		number swap_first_fix = null<number>;
		fwd_parm = swap_curve_fwd_f_parm(short_crv, middle_crv, long_crv,  model.blend_parm(),
										mi_crv_y_spr, lo_crv_y_spr,edfut_cvx_adj,swap_first_fix);
	}
	
	swap_curve_fwd_ext fwd_crv	= fwd_ois_curve_create(d, fwd_parm,fwd_pre,fwd_pre_cut_off);
	
	fwd_model = model.fwd_model();
	
	return fwd_crv;
}

//-------------------------------------------------------
// fwd_ois_curve_create_tmpl
//-------------------------------------------------------
swap_curve_fwd_ext fwd_ois_curve_create_tmpl(	date 								d,
												CURVE_TMPL.fwd_curve_tmpl 			fwd_c,
												CURVE_TMPL.fwd_curve_model_tmpl 	model,										
												out fwd_z_model 					fwd_model,							
												fwd_func option(nullable) 			fwd_pre, 
												date option(nullable)				fwd_pre_cut_off)
	option (category: 'Yield Curve/003 Curve Building')
{
	error_info err = new error_info(true,true);
	return fwd_ois_curve_create_tmpl(d,model,
									fwd_c.short_crv(d, null<quote_side>,err),
									fwd_c.short_crv_is_fix(),
									fwd_c.middle_crv(d, null<quote_side>,err),
									fwd_c.long_crv(d, null<quote_side>,err),
									fwd_model,fwd_pre,fwd_pre_cut_off );
}

//-------------------------------------------------------
// fwd_ois_curve_create_f_tmpl
//-------------------------------------------------------
fwd_func fwd_ois_curve_create_f_tmpl(	date 								d,
										CURVE_TMPL.fwd_curve_model_tmpl 	model,
										curve option(nullable)				short_crv,
										logical	option(nullable)			short_crv_is_fix,
										curve option(nullable)				middle_crv,
										curve option(nullable)				long_crv,
										out swap_curve_fwd_ext 	 			fwd_crv,							
										fwd_func option(nullable) 			fwd_pre, 
										date option(nullable)				fwd_pre_cut_off )
	option (category: 'Yield Curve/003 Curve Building')
{
	fwd_z_model fwd_model;
	fwd_crv = fwd_ois_curve_create_tmpl(d,model,short_crv,short_crv_is_fix,middle_crv,long_crv,
										fwd_model,fwd_pre,fwd_pre_cut_off);
	return fwd_crv.fwd(fwd_model);
}
//-------------------------------------------------------
// fwd_ois_curve_create_f_tmpl
//-------------------------------------------------------
fwd_func fwd_ois_curve_create_f_tmpl(	date 								d,
										CURVE_TMPL.fwd_curve_tmpl 			fwd_c,
										CURVE_TMPL.fwd_curve_model_tmpl 	model,
										out swap_curve_fwd_ext 	 			fwd_crv,							
										fwd_func option(nullable) 			fwd_pre, 
										date option(nullable)				fwd_pre_cut_off)
	option (category: 'Yield Curve/003 Curve Building')
{
	fwd_z_model fwd_model;
	fwd_crv = fwd_ois_curve_create_tmpl(d,fwd_c,model,fwd_model, fwd_pre,fwd_pre_cut_off);
	return fwd_crv.fwd(fwd_model);
}
