/*	
	Basic swap wrapper classes and functions for "dual" bootstrap
	Developed by Algorithmica Research, Magnus Nyström
	
	
	Comments:
	
	
*/
option(null: hard);

module LEGACY
{
	
	//-------------------------------------------------------
	// df_swap
	//-------------------------------------------------------
	void df_swap(	date					d,
					swap_curve_disc_parm	disc_parm,
					disc_z_model 			disc_model,								
					LEGACY.swap_curve_fwd_parm 	fwd_parm,				
					fwd_z_model  			fwd_model,		
					out disc_func 			df,
					out fwd_func 			fwd_f)
									   
	{
		swap_curve_disc_ext disc_crv = swap_curve_disc_ext(disc_parm,d,"");
		df 							= disc_crv.disc_df(disc_model);
		swap_curve_fwd_ext fwd_crv	= swap_curve_fwd_ext(fwd_parm, d,df, "");
		fwd_f						= fwd_crv.fwd(fwd_model);		
	}	
	//-------------------------------------------------------
	// df_bswap (2 swap basis swap quote)
	//-------------------------------------------------------
	void df_bswap(	date					d,
					swap_curve_disc_parm	disc_parm,
					disc_z_model			disc_model,													
					LEGACY.swap_curve_b2_parm 		fwd_parm,				
					fwd_z_model 			fwd_model,
					logical 				x_pol_basis,				
					out disc_func 			df,
					out fwd_func 			fwd_f,
					out curve 				swap_crv)
									   
	{
		swap_curve_disc_ext disc_crv = swap_curve_disc_ext(disc_parm,d,"");
		df 							= disc_crv.disc_df(disc_model);
		swap_curve_b2_ext fwd_crv 	= swap_curve_b2_ext(fwd_parm, d, df, x_pol_basis, "");		
		fwd_f						= fwd_crv.fwd(fwd_model);
	}
	 
	//-------------------------------------------------------
	// disc_curve_create
	// create discounting curve object
	//-------------------------------------------------------
	swap_curve_disc_ext disc_curve_create(	date 						d,
											curve option(nullable) 		disc_sh_crv,
											curve option(nullable) 		disc_mi_crv,
											curve option(nullable) 		disc_lo_crv,
											curve_prio  				prio1,
											curve_prio					prio2,
											logical 					no_overlap_fwd,
											logical 					merge_fra,
											logical 					merge_crv,
											integer						blend_buf_days)
									   
	{	
		CORE_INT.set_prio_order(disc_sh_crv,disc_mi_crv,disc_lo_crv,prio1,prio2);

		// first create the param object which is just a container for parameters
		swap_curve_disc_parm disc_data = swap_curve_disc_parm(	disc_sh_crv,disc_mi_crv,disc_lo_crv,no_overlap_fwd, 
																merge_fra,merge_crv,prio1 ,prio2, blend_buf_days);

		// then create a swap_curve_ext object, here we use the specific constructor just for a discounting curve
		return swap_curve_disc_ext(disc_data, d, "disc");	
	}

	//-------------------------------------------------------
	// disc_curve_create
	// create discounting disc_func
	//-------------------------------------------------------

	disc_func disc_curve_create(	date 						d,
									curve option(nullable) 		disc_sh_crv,
									curve option(nullable) 		disc_mi_crv,
									curve option(nullable) 		disc_lo_crv,
									curve_prio					prio1,
									curve_prio					prio2,
									logical 					no_overlap_fwd,
									logical 					merge_fra,
									logical 					merge_crv,
									integer						blend_buf_days,
									disc_z_model 				disc_model,								
									out swap_curve_disc_ext 	disc)
								   
	{
		CORE_INT.set_prio_order(disc_sh_crv,disc_mi_crv,disc_lo_crv,prio1,prio2);

		// first create the param object which is just a container for parameters
		swap_curve_disc_parm disc_data 	= swap_curve_disc_parm(disc_sh_crv,disc_mi_crv,disc_lo_crv,no_overlap_fwd, 
																merge_fra, merge_crv, prio1 ,prio2, blend_buf_days);

		// then create a swap_curve_ext object, here we use the specific constructor just for a discounting curve
		disc = swap_curve_disc_ext(disc_data, d,"disc");
		
		return disc.disc_df(disc_model);
	}
	//-------------------------------------------------------
	// disc_curve_create
	// create discounting curve with extension
	//-------------------------------------------------------

	swap_curve_disc_ext disc_curve_create(	date 						d,										
											swap_curve_disc_ext			disc_base,					
											curve  						extrap_crv,						
											string  					class_name,							
											disc_z_model 				extrap_model)
									   
	{
		curve disc_blended	= disc_base.blended_curve();	
		
		vector(instrument) ois_ext 	= CORE_INT_COMPAT.extend_ois(d,disc_blended,extrap_crv,class_name,extrap_model);
		if(!null(ois_ext) && v_size(ois_ext) > 0){
			vector(instrument) v_i =  disc_blended.instruments();			
			v_i = concat (v_i, ois_ext);
			disc_blended = curve(v_i,strcat(disc_blended.name(),"-ext"));
			return disc_curve_create(d,null<curve>,null<curve>,disc_blended,curve_prio.LONG,curve_prio.MIDDLE, false,false,false,0) ;		
		}	
		else
			return disc_base;
	}
	//-------------------------------------------------------
	// disc_curve_create
	// create discounting disc_func with extension
	//-------------------------------------------------------

	disc_func disc_curve_create(	date 						d,
									curve option(nullable) 		disc_sh_crv,
									curve option(nullable) 		disc_mi_crv,
									curve option(nullable) 		disc_lo_crv,								
									curve  						extrap_crv,								
									string  					class_name,							
									curve_prio					prio1,
									curve_prio					prio2,
									logical 					no_overlap_fwd,
									logical 					merge_fra,
									logical 					merge_crv,
									integer						blend_buf_days,
									disc_z_model 				disc_model,															
									disc_z_model 				extrap_model,																								
									out swap_curve_disc_ext 	disc)
									   
	{
		disc = disc_curve_create(	d,disc_sh_crv, disc_mi_crv,disc_lo_crv,prio1,prio2, no_overlap_fwd,
									merge_fra,merge_crv, blend_buf_days) ;

		disc = disc_curve_create(	d,disc,	extrap_crv,	class_name,	extrap_model);

		return disc.disc_df(disc_model);
	}

	enum synt_short_style  {SY_FRA, SY_DEPO,SY_NONE};
}


module CORE_INT_COMPAT
{
	//-------------------------------------------------------
	// synt_curve_create
	//-------------------------------------------------------
	void synt_curve_create(	date 			d,
							curve option(nullable)	fra_crv,
							curve option(nullable)	short_crv,
							disc_func_spr 	df_basis,
							curve			df_basis_crv,
							integer 		freq,						
							string option(nullable)	fra_class_name,						
							string option(nullable)	depo_class_name,
							LEGACY.synt_short_style synt,						
							out curve 		fra_ext_crv,
							out curve 		short_ext_crv)
	{
		integer null_cut_days = 400;
		if(synt == LEGACY.SY_FRA){
			QL_REQUIRE(!null(depo_class_name), "depo_class_name is required when creating synthetic instruments");	
			
			if(null(fra_class_name)){ 			
				QL_REQUIRE(!null(fra_crv), "fra_curve required when fra_class_name is null (fra_class_name is required when creating synthetic instruments)");
				fra_class_name 	=  fra_crv.instruments()[0].class_name();
				QL_REQUIRE(!null(fra_class_name), "unable to set fra_class_name (fra_class_name is required when creating synthetic instruments)");	
			}
	
			string settle_code = CORE_INT.create_class_depo(depo_class_name,d).settle_code();
	
			date cut_off_f = CORE_INT.cut_off_fra(d,fra_crv,df_basis_crv,freq,null_cut_days);
	 		
			fra_ext_crv = CORE_INT_COMPAT.create_synt_fra_crv(d,12/freq, cut_off_f,fra_class_name,settle_code,df_basis);					 
			if(check_curve(fra_ext_crv)) {
				fra_ext_crv = merge(fra_ext_crv, fra_crv) ;
				string cname = (null(fra_crv) || null(fra_crv.name())) ? fra_ext_crv.name() : strcat(fra_crv.name(),"-ext");
				if(null(cname )) cname  = "";
				fra_ext_crv = fra_ext_crv.set_name(cname); 			
			}
			else 
				fra_ext_crv = fra_crv;
				
			date cut_off_d = CORE_INT.cut_off_depo(d,short_crv,df_basis_crv, null_cut_days) ; 
				
			short_ext_crv = CORE_INT_COMPAT.create_synt_depo_tenor_crv(depo_class_name, d, 12/freq, cut_off_d, df_basis);			
			if(check_curve(short_ext_crv)){
				short_ext_crv = merge(short_ext_crv, short_crv) ;
				string cname = (null(short_crv) || null(short_crv.name()))  ? short_ext_crv.name() : strcat(short_crv.name(),"-ext");
				if(null(cname )) cname  = "";			
				short_ext_crv = short_ext_crv.set_name(cname); 
			}
			else 
				short_ext_crv = short_crv;
		}
		else if(synt == LEGACY.SY_DEPO){
			QL_REQUIRE(!null(depo_class_name), "depo_class_name is required when creating synthetic instruments");
	
			fra_ext_crv = fra_crv;		
			date cut_off_d = CORE_INT.cut_off_depo(d,short_crv,df_basis_crv, null_cut_days) ;	
			short_ext_crv = CORE_INT_COMPAT.create_synt_depo_tenor_crv(depo_class_name, d, 12/freq, cut_off_d, df_basis);			
			if(check_curve(short_ext_crv)){
				short_ext_crv = merge(short_ext_crv, short_crv) ;
				string cname = (null(short_crv) || null(short_crv.name())) ? short_ext_crv.name() : strcat(short_crv.name(),"-ext");
				if(null(cname )) cname  = "";			
				short_ext_crv = short_ext_crv.set_name(cname); 
			}
			else 
				short_ext_crv = short_crv;
		}
		/*else if(synt == SY_DEPO){
			fra_ext_crv = fra_crv;
	
			short_ext_crv = create_synt_depo_crv(depo_class_name, d, 12/freq, cut_off, df_basis);		
			if(..check_curve(short_ext_crv)){
				short_ext_crv = ..merge(short_ext_crv, short_crv) ;
				string cname = null(short_crv.name()) ? short_ext_crv.name() : strcat(short_crv.name(),"-ext");
				if(null(cname )) cname  = "";
				short_ext_crv = short_ext_crv.set_name(cname); 			
			}
			else 
				short_ext_crv = short_crv;
		}*/
		else {
			fra_ext_crv = fra_crv;
			short_ext_crv = short_crv;
		}
	}
}

//-------------------------------------------------------
// fwd_curve_create  (base case without basis swaps)
// Example
//  1) disc_c = Eonia or similar	[EONIA]
//	2) fra_c = EUR 6M FRA			[EUR6MFRA]
//	3) swap_c = EUR IRS 6M EURIBOR	[EUR6MSWAP]
//-------------------------------------------------------
module LEGACY
{

	swap_curve_fwd_ext fwd_curve_create(date 							d,
										disc_func 						df_ois,
										disc_func option(nullable)		df_synt_base,
										date option(nullable)			synt_end,
										curve option(nullable)			short_crv, 				
										curve option(nullable)			fra_crv, 	
										curve option(nullable)			swap_crv,
										curve_prio						prio1,
										curve_prio						prio2,
										string option(nullable)			depo_class_name,
										string option(nullable)			fra_class_name,	
										synt_short_style				synt,
										//fwd_z_model 					fwd_model,	
										logical 						merge_fra,
										logical 						merge_crv,
										integer							blend_buf_days,
										vector(number) option(nullable) edfut_cvx_adj,							
										//number option(nullable) 		short_first_fix = null<number>,
										number option(nullable) 		swap_first_fix = null<number>,
										fwd_func option(nullable) 		fwd_pre = null<fwd_func>, 
										date option(nullable)			fwd_pre_cut_off = null<date>)

	{			
		logical no_overlap_fwd = false;	
		QL_REQUIRE(!null(fra_crv) || !null(swap_crv), "invalid fra and swap curve");	
		integer freq;
		if(null(swap_crv)){
			freq = fra_crv.instruments()[0].coupon_freq() ;
		}
		else {
			swap_fixflt sw = swap_fixflt(swap_crv.instruments()[0]);
			freq = sw.coupon_freq_flt_leg();
		}
		QL_REQUIRE(freq>0, "invalid float coupon frequency");		

		LEGACY.swap_curve_fwd_parm fwd;
		if(synt == SY_NONE){
			//create the param object for the fwd curve		
			fwd = LEGACY.swap_curve_fwd_parm(	short_crv,fra_crv,swap_crv,swap_first_fix,no_overlap_fwd,merge_fra,merge_crv,prio1,prio2,blend_buf_days,edfut_cvx_adj);
		}
		else {
			QL_REQUIRE(!null(synt_end), "invalid synt_end (required when creating synthetic instruments)");
			if(null(df_synt_base)) df_synt_base = df_ois;
			// create synthetic depo(s) or fra(s) for fwd curve via basis spreads		
			//---create basis curve---
			curve short_adj_crv = CORE_INT_COMPAT.extract_tenor_depo(short_crv,12/freq);//remove non tenor deposits

			CORE_INT.set_prio_order(short_adj_crv,fra_crv,swap_crv,prio1,prio2);

			curve	df_basis_crv;
			disc_func_spr df_basis = CORE_INT.df_tenor_spread(d,df_synt_base, synt_end, short_adj_crv, fra_crv,swap_crv,prio1,prio2,merge_fra,blend_buf_days, df_basis_crv);		
			QL_REQUIRE(!null(df_basis), "failed to create basis spread function");
			
			curve fra_ext_crv,short_ext_crv;	
			CORE_INT_COMPAT.synt_curve_create(d,fra_crv, short_adj_crv, df_basis, df_basis_crv, freq, fra_class_name, depo_class_name, synt, fra_ext_crv, short_ext_crv);
		
			//create the param object for the fwd curve		
			fwd = LEGACY.swap_curve_fwd_parm(short_ext_crv,fra_ext_crv,swap_crv,swap_first_fix,no_overlap_fwd,merge_fra,merge_crv,prio1,prio2,blend_buf_days,edfut_cvx_adj);
		}

		string name = freq == 365 ? strcat(["fwd_","1D"]) : strcat(["fwd_",str(12/freq,0),"M"]);
		if(check_curve(swap_crv))
			return swap_curve_fwd_ext(fwd, d, df_ois, name,fwd_pre,fwd_pre_cut_off);
		else {
			instrument fra = fra_crv.instruments()[0];
			QL_REQUIRE(!null(depo_class_name), "depo_class_name is required swap curve is null");	
			string settle_code = CORE_INT.create_class_depo(depo_class_name, d).settle_code(); 	
			return swap_curve_fwd_ext(	fwd, d,df_ois,  freq, fra.accr_dc_method(), fra.pmt_bus_day_d(BD_MOD_FOLLOWING), fra.calendar(), fra.eom_d(true),
										integer(fra.flt_reset_days_d(2)), settle_code, name,fwd_pre,fwd_pre_cut_off) ;		
		}					
	}

	//-------------------------------------------------------
	// fwd_curve_create  (base case without basis swaps)
	//-------------------------------------------------------

	fwd_func fwd_curve_create(	date 							d,
								disc_func						df_ois,
								disc_func option(nullable)		df_synt_base,
								date option(nullable)			synt_end,
								curve option(nullable)			short_crv, 					
								curve option(nullable)			fra_crv, 	
								curve option(nullable)			swap_crv,
								curve_prio						prio1,
								curve_prio						prio2,
								string option(nullable)			depo_class_name,
								string option(nullable)			fra_class_name,						
								synt_short_style				synt,							
								fwd_z_model  					fwd_model,																					
								logical 						merge_fra,
								logical 						merge_crv,
								integer							blend_buf_days,
								vector(number) option(nullable) edfut_cvx_adj,
								out swap_curve_fwd_ext 			fwd_crv,
								//number option(nullable) 		short_first_fix = null<number>,
								number option(nullable) 		swap_first_fix = null<number>,
								fwd_func option(nullable) 		fwd_pre = null<fwd_func>, 
								date option(nullable)			fwd_pre_cut_off = null<date>)

	{		
		fwd_crv = fwd_curve_create(	d,df_ois,df_synt_base,synt_end,short_crv, fra_crv,swap_crv,prio1,prio2,depo_class_name,fra_class_name,
									synt,merge_fra,merge_crv,blend_buf_days,edfut_cvx_adj,swap_first_fix,fwd_pre,fwd_pre_cut_off );
		return fwd_crv.fwd(fwd_model);					
	}

	//-------------------------------------------------------
	// fwd_b2_curve_create (base case with basis swaps quoted as 2 swaps)
	// Example 
	//	1) fra_out_c = EUR 3M FRA, USD 6M FRA							[EUR3MFRA], [USD6MFRA]
	//	2) swap_in_c = EUR IRS 6M EURIBOR, USD IRS 3M LIBOR				[EUR6MSWAP], [USD3MSWAP]
	// 	3) basis_t1t2_c = EUR 3M/6M EURIBOR, USD 3M/6M LIBOR 		  	[EUR3M6MSWAP[2SWP]], [USD3M6MSWAP[2SWP]] 
	//-------------------------------------------------------

	swap_curve_b2_ext fwd_b2_curve_create(	date 						d,
											disc_func					df_ois,	
											disc_func option(nullable)	df_synt_base,
											date option(nullable)		synt_end,
											curve option(nullable)		short_out_crv, 	
											curve option(nullable)		fra_out_crv, 
											curve 						swap_in_crv,//this swap will be converted with the basis curve to out curve
											curve 						basis_t1t2_crv,
											curve_prio					prio1,
											curve_prio					prio2,
											string option(nullable)		depo_class_name,
											string option(nullable)		fra_out_class_name,										
											synt_short_style			synt,
											//fwd_z_model  				fwd_model,																													
											logical 					merge_fra,
											logical 					merge_crv,
											integer						blend_buf_days,
											vector(number) option(nullable) edfut_cvx_adj,
											logical 					x_pol_basis,
											number option(nullable) 	first_fix_out = null<number>,
											fwd_func option(nullable) 	fwd_pre = null<fwd_func>, 
											date option(nullable)		fwd_pre_cut_off = null<date>)

	{				
		logical no_overlap_fwd = false;

		swap_fixflt sw = swap_fixflt(swap_in_crv.instruments()[0]);
		
		integer freq_in = sw.coupon_freq_flt_leg();
		QL_REQUIRE(freq_in>0 && freq_in != 365, "invalid float coupon frequency (in)", sw.name(), true);
		
		instrument inst = basis_t1t2_crv.instruments()[0];
		
		string class_name_base = inst.instr_def().fltflt_swap_class_sprd();
		QL_REQUIRE(!null(class_name_base),'invalid class name tag - base leg (b2 fwd)', inst.name(), true);	
		swap_fixflt sw_base = CORE_INT_FIXFLT.create_class_fixflt(class_name_base);
		QL_REQUIRE(!null(sw_base),'invalid swap creation - base leg (b2 fwd)',class_name_base,true);

		integer freq_fix,freq_b;
		sw_base.coupon_freq(freq_fix,freq_b);

		swap_fltflt2s swinst = swap_fltflt2s(inst);
		
		QL_REQUIRE(freq_b>0 && freq_b != 365, "invalid float coupon frequency (basis)");
		QL_REQUIRE(freq_b == swinst.coupon_freq_sprd_leg(), "flt_coupon_freq not compatible with class name float leg");

		integer freq_out; 
		if( freq_in != freq_b )
			freq_out = freq_b;
		else {
			string class_name_flat = inst.instr_def().fltflt_swap_class_flat();
			QL_REQUIRE(!null(class_name_flat),'invalid class name tag - flat leg (b2 fwd)', inst.name(), true);
			swap_fixflt sw_flat = CORE_INT_FIXFLT.create_class_fixflt(class_name_flat);
			QL_REQUIRE(!null(sw_flat),'invalid swap creation - flat leg (b2 fwd)',class_name_flat,true);
			
			sw_flat.coupon_freq(freq_fix,freq_out);
			QL_REQUIRE(freq_out == swinst.coupon_freq_flat_leg(), "flt_coupon_freq_flat not compatible with class name float leg");
			QL_REQUIRE(freq_out>0 && freq_out != 365, "invalid float coupon frequency (out)");
		}	

		LEGACY.swap_curve_b2_parm fwd;
		if(synt == SY_NONE){
			CORE_INT.set_prio_order(short_out_crv,fra_out_crv,swap_in_crv,prio1,prio2);

			fwd = LEGACY.swap_curve_b2_parm(	short_out_crv,fra_out_crv,swap_in_crv,basis_t1t2_crv,first_fix_out,no_overlap_fwd,
										merge_fra,merge_crv,prio1,prio2,blend_buf_days,edfut_cvx_adj);
		}
		else {// create synthetic depo(s) or fra(s) for fwd curve via basis spreads

			QL_REQUIRE(!null(synt_end), "invalid synt_end (required when creating synthetic instruments)");
			if(null(df_synt_base)) df_synt_base = df_ois;

			LEGACY.swap_curve_b2_parm fwd_tmp = LEGACY.swap_curve_b2_parm(null<curve>, null<curve>, swap_in_crv, basis_t1t2_crv, first_fix_out, 
															false,false,false,curve_prio.LONG,curve_prio.MIDDLE, blend_buf_days, null<vector(number)>);

			swap_curve_ext s_tmp = swap_curve_b2_ext(fwd_tmp, d,df_ois, false, "");
			curve swap_out_crv = s_tmp.swap_curve();
			
			curve short_adj_out_crv = CORE_INT_COMPAT.extract_tenor_depo(short_out_crv,12/freq_out);//remove non tenor deposits

			curve_prio prio1_t = prio1;
			curve_prio prio2_t = prio2;					
			CORE_INT.set_prio_order(short_adj_out_crv, fra_out_crv, swap_out_crv,prio1_t,prio2_t);

			curve	df_basis_crv;
			disc_func_spr df_basis = CORE_INT.df_tenor_spread(d,df_synt_base, synt_end, short_adj_out_crv, fra_out_crv, swap_out_crv, prio1_t,prio2_t,
													merge_fra,blend_buf_days, df_basis_crv);		
			QL_REQUIRE(!null(df_basis), "failed to create basis spread function");
			
			CORE_INT.set_prio_order(short_adj_out_crv,fra_out_crv,swap_in_crv,prio1,prio2);
			
			curve fra_ext_crv,short_ext_crv;
			CORE_INT_COMPAT.synt_curve_create(d,fra_out_crv,short_adj_out_crv,df_basis,df_basis_crv,freq_out,fra_out_class_name,depo_class_name,synt,fra_ext_crv,short_ext_crv);
						
			fwd = LEGACY.swap_curve_b2_parm(	short_ext_crv,fra_ext_crv,swap_in_crv, basis_t1t2_crv ,first_fix_out,no_overlap_fwd,
										merge_fra,merge_crv,prio1,prio2,blend_buf_days,edfut_cvx_adj);
		}
		// create the swap_curve_b2_ext object now for the out forwarding function
		// the "b2" means that we are going to use a basis swap - quoted as 2 swaps when we create the forwarding function
		// note that this time we use a constructor with the discounting function as argument 		
		return swap_curve_b2_ext(fwd, d, df_ois, x_pol_basis, strcat(["fwd_basis2_",str(12/freq_out,0),"M"]),fwd_pre,fwd_pre_cut_off);	
					
	}

	//-------------------------------------------------------
	// fwd_b2_curve_create (base case with basis swaps quoted as 2 swaps)
	//-------------------------------------------------------

	fwd_func fwd_b2_curve_create(date 						d,
								disc_func					df_ois,	
								disc_func option(nullable)	df_synt_base,
								date option(nullable)		synt_end,
								curve option(nullable)		short_out_crv, 		
								curve option(nullable)		fra_out_crv,  	
								curve 						swap_in_crv,//this swap will be converted with the basis curve to out freq
								curve 						basis_t1t2_crv,
								curve_prio				prio1,
								curve_prio				prio2,
								string option(nullable)		depo_class_name,
								string option(nullable)		fra_out_class_name,								
								synt_short_style			synt,							
								fwd_z_model  				fwd_model,												
								logical 					merge_fra,
								logical 					merge_crv,
								integer						blend_buf_days,
								vector(number) option(nullable) edfut_cvx_adj,
								logical 					x_pol_basis,
								out swap_curve_b2_ext 		fwd_crv,						
								number option(nullable) 	first_fix_out = null<number>,
								fwd_func option(nullable) 	fwd_pre = null<fwd_func>, 
								date option(nullable)		fwd_pre_cut_off = null<date>)

	{			
		fwd_crv = fwd_b2_curve_create(	d,df_ois,df_synt_base,synt_end, short_out_crv,fra_out_crv,swap_in_crv,basis_t1t2_crv,
										prio1, prio2,depo_class_name,fra_out_class_name,synt,merge_fra,merge_crv,blend_buf_days,
										edfut_cvx_adj,x_pol_basis, first_fix_out,fwd_pre,fwd_pre_cut_off);
		return fwd_crv.fwd(fwd_model);							
	}

	//-------------------------------------------------------
	// fwd_b2_ext_curve_create (base case with basis swaps quoted as 2 swaps)
	// only here for backward compatibility
	//-------------------------------------------------------
	fwd_func fwd_b2_ext_curve_create(	date 					d,
										disc_func				df_ois,	
										disc_func option(nullable)	df_synt_base,
										date option(nullable)	synt_end,
										fwd_func 				fwd_pre,
										date					fwd_pre_cut_off,
										curve option(nullable)	short_out_crv, 			
										curve option(nullable)	fra_out_crv, 	
										curve 					swap_in_crv,//this swap will be converted with the basis curve to out
										curve 					basis_t1t2_crv,
										curve_prio			prio1,
										curve_prio			prio2,
										string option(nullable) depo_class_name,
										string option(nullable)	fra_out_class_name,									
										synt_short_style 		synt,									
										fwd_z_model  			fwd_model,																		
										logical 				merge_fra,
										logical 				merge_crv,
										integer					blend_buf_days,
										vector(number) option(nullable) edfut_cvx_adj,
										logical 				x_pol_basis,
										out swap_curve_b2_ext 	fwd_crv,						
										number option(nullable) swap_first_fix_out = null<number>)
	//option (category: 'Obsolete Functions/Yield Curve/003 Curve Building')
	{		
		fwd_crv = fwd_b2_curve_create(	d,df_ois,df_synt_base,synt_end, short_out_crv,fra_out_crv,swap_in_crv,basis_t1t2_crv,
										prio1,prio2,depo_class_name,fra_out_class_name,synt,merge_fra,merge_crv,blend_buf_days,
										edfut_cvx_adj,x_pol_basis,swap_first_fix_out,fwd_pre,fwd_pre_cut_off);
		//return fwd_crv.fwd_comb(fwd_model,ff_pre, cut_off);
		return fwd_crv.fwd(fwd_model);
	}

	//-------------------------------------------------------
	// fwd_b1_curve_create (base case with basis swaps quoted as 1 swap)
	// Example 
	//  - disc_c 						OIS								[EONIA], [USDOIS]
	//	- fwd_in						EUR 6M FRA, USD 3M FRA			[EUR6MFRA] [USD3MFRA], EUR 6m = flat leg, USD 3m != flat leg
	//	- short_out_crv,				EURIBOR 3M, USD LIBOR 6M 
	//	- fra_out_crv					EUR 3M FRA, USD 6M FRA			[EUR3MFRA] [USD6MFRA]	
	// 	- basis_t1t2_crv 				EUR 3M/6M,  USD 3M/6M			[EUR3M6MSWAP[1SWP]] [USD3M6MSWAP[1SWP]] 
	//-------------------------------------------------------
	swap_curve_b1_ext fwd_b1_curve_create(	date 			d,
											disc_func		df_ois,	
											disc_func option(nullable)	df_synt_base,
											date option(nullable)		synt_end,
											fwd_func		fwd_in, 
											integer			fwd_in_freq,
											curve option(nullable)		short_out_crv, 				
											curve option(nullable)		fra_out_crv, 	
											curve 			basis_t1t2_crv,
											curve_prio	prio1,
											curve_prio	prio2,
											string option(nullable) depo_class_name,
											string option(nullable) fra_out_class_name,										
											synt_short_style synt,										
											fwd_z_model  	fwd_model,										
											logical 		merge_fra,
											logical 		merge_crv,
											integer			blend_buf_days,
											vector(number) option(nullable) 	edfut_cvx_adj,
											number option(nullable) first_fix_base = null<number>,
											number option(nullable) first_fix_flat = null<number>,
											vector(date) option(nullable) basis_ip_mat = null<vector(date)>,
											fwd_func option(nullable) 	fwd_pre = null<fwd_func>, 
											date option(nullable)		fwd_pre_cut_off = null<date>)

	{		
		logical no_overlap_fwd = false;
				
		LEGACY.swap_curve_b1_parm fwd = LEGACY.swap_curve_b1_parm(short_out_crv,fra_out_crv,basis_t1t2_crv, first_fix_flat,
													first_fix_base,no_overlap_fwd,merge_fra,merge_crv,prio1,prio2,
													blend_buf_days,edfut_cvx_adj);
		
		CORE_INT.set_prio_order(short_out_crv,fra_out_crv,basis_t1t2_crv,prio1,prio2);

		if(synt != SY_NONE) {
			QL_REQUIRE(!null(synt_end), "invalid synt_end (required when creating synthetic instruments)");
			if(null(df_synt_base)) df_synt_base = df_ois;
			
			swap_curve_b1_ext s_t 	= swap_curve_b1_ext(fwd, d, df_ois, fwd_in, basis_ip_mat, fwd_in_freq, "");	
			curve swap_out_crv 		= s_t.swap_curve(fwd_model);

			swap_fltflt swb = swap_fltflt(basis_t1t2_crv.instruments()[0]);
			
			integer freq_b 			= swb.coupon_freq_leg1();
			QL_REQUIRE(freq_b>0 && freq_b != 365, "invalid float coupon frequency (basis)");
			integer freq_out 		= fwd_in_freq != freq_b ? freq_b : swb.coupon_freq_leg2();					
			QL_REQUIRE(freq_out>0 && freq_out != 365, "invalid float coupon frequency (out)");

			curve short_adj_out_crv = CORE_INT_COMPAT.extract_tenor_depo(short_out_crv,12/freq_out);//remove non tenor deposits

			curve_prio prio1_t = prio1;
			curve_prio prio2_t = prio2;

			CORE_INT.set_prio_order(short_adj_out_crv,fra_out_crv,swap_out_crv,prio1_t,prio2_t);

			curve df_basis_crv;
			disc_func_spr df_basis = CORE_INT.df_tenor_spread(	d,df_synt_base, synt_end, short_adj_out_crv, fra_out_crv, swap_out_crv, 
														prio1_t, prio2_t,merge_fra,blend_buf_days, df_basis_crv);
			
			QL_REQUIRE(!null(df_basis), "failed to create basis spread function");
			
			//note: both fra and swap are nullable
			//TODO see b2
			// create synthetic depo(s) or fra(s) for fwd curve via basis spreads
				
			CORE_INT.set_prio_order(short_adj_out_crv,fra_out_crv,basis_t1t2_crv,prio1,prio2);				
			
			curve fra_ext_crv,short_ext_crv;	
			CORE_INT_COMPAT.synt_curve_create(d,fra_out_crv,short_adj_out_crv,df_basis,df_basis_crv,freq_out,fra_out_class_name,depo_class_name,synt,fra_ext_crv,short_ext_crv);
						
			fwd = LEGACY.swap_curve_b1_parm(	short_ext_crv ,fra_ext_crv,basis_t1t2_crv, first_fix_flat,first_fix_base,no_overlap_fwd,
										merge_fra,merge_crv,prio1,prio2, blend_buf_days,edfut_cvx_adj);	
		}
		return swap_curve_b1_ext(fwd, d, df_ois, fwd_in, basis_ip_mat,fwd_in_freq, "fwd_basis1",fwd_pre,fwd_pre_cut_off);							
	}

	//-------------------------------------------------------
	// fwd_b1_curve_create (base case with basis swaps quoted as 1 swap)
	//-------------------------------------------------------
	fwd_func fwd_b1_curve_create(date 			d,
								disc_func		df_ois,	
								disc_func option(nullable)	df_synt_base,
								date option(nullable) synt_end,
								fwd_func		fwd_in,
								integer			fwd_in_freq,
								curve option(nullable)		short_out_crv, 			
								curve option(nullable)		fra_out_crv, 								
								curve 			basis_t1t2_crv,
								curve_prio	prio1,
								curve_prio	prio2,
								string option(nullable)	depo_class_name,
								string option(nullable) fra_out_class_name,								
								synt_short_style synt,							
								fwd_z_model  	fwd_model,														
								logical 		merge_fra,
								logical 		merge_crv,
								integer			blend_buf_days,
								vector(number) option(nullable) 	edfut_cvx_adj,
								out swap_curve_b1_ext option(nullable) 	fwd_crv,
								number option(nullable) first_fix_base = null<number>,
								number option(nullable) first_fix_flat = null<number>,
								vector(date) option(nullable) basis_ip_mat = null<vector(date)>,
								fwd_func option(nullable) 	fwd_pre = null<fwd_func>, 
								date option(nullable)		fwd_pre_cut_off = null<date>)

	{
		fwd_crv = fwd_b1_curve_create(	d,df_ois,df_synt_base,synt_end,fwd_in,fwd_in_freq,short_out_crv,fra_out_crv,basis_t1t2_crv,
										prio1,prio2,depo_class_name,fra_out_class_name,synt,fwd_model,merge_fra,merge_crv,blend_buf_days,edfut_cvx_adj,
										first_fix_base,first_fix_flat, basis_ip_mat,fwd_pre,fwd_pre_cut_off);
		return fwd_crv.fwd(fwd_model);							
	}

	//-------------------------------------------------------
	// fwd_b1_curve_create (base case with basis swaps quoted as 1 swap)
	//-------------------------------------------------------
	fwd_func fwd_b1_curve_create(date 						d,
								disc_func					df_ois,	
								disc_func option(nullable)	df_synt_base,
								date option(nullable)		synt_end,
								curve option(nullable)		short_in_crv, 
								curve option(nullable)		fra_in_crv, 	
								curve option(nullable)		swap_in_crv,
								number						in_freq,
								curve option(nullable)		short_out_crv, 	
								curve option(nullable)		fra_out_crv,  								
								curve 						basis_t1t2_crv,
								curve_prio				prio1,
								curve_prio				prio2,
								string option(nullable)		depo_class_name,
								string option(nullable)		fra_in_class_name,	
								string option(nullable)		fra_out_class_name,							
								synt_short_style 			synt,							
								fwd_z_model  				fwd_model,												
								logical 					merge_fra,
								logical 					merge_crv,
								integer						blend_buf_days,
								vector(number) option(nullable) 	edfut_cvx_adj_in,
								vector(number) option(nullable) 	edfut_cvx_adj_out,
								out swap_curve_b1_ext 		fwd_crv,							
								number option(nullable) 	first_fix_base = null<number>,
								number option(nullable) 	first_fix_flat = null<number>,
								fwd_func option(nullable) 	fwd_pre = null<fwd_func>, 
								date option(nullable)		fwd_pre_cut_off = null<date>)

	{
		swap_curve_fwd_ext fwd_crv_in;			

		number freq_b = basis_t1t2_crv.instruments()[0].coupon_freq();
		QL_REQUIRE(!null(freq_b) && freq_b != 365, "invalid float coupon frequency (basis)");
		number first_fix_in = in_freq == freq_b ? first_fix_base : first_fix_flat ;
		
		fwd_func fwd_in = fwd_curve_create(	d,df_ois,df_synt_base,synt_end,short_in_crv,fra_in_crv,swap_in_crv,prio1,prio2,
											depo_class_name, fra_in_class_name,synt,fwd_model, merge_fra, merge_crv,
											blend_buf_days, edfut_cvx_adj_in, fwd_crv_in, first_fix_in);
		
		integer fwd_in_freq = fwd_crv_in.flt_freq() ;
		vector(date) basis_ip_mat = ..check_curve(swap_in_crv) ? swap_in_crv.instruments().maturity() : null<vector(date)>;
		
		return fwd_b1_curve_create(	d,df_ois,df_synt_base,synt_end,fwd_in,fwd_in_freq,short_out_crv,fra_out_crv,basis_t1t2_crv,
									prio1,prio2,depo_class_name,fra_out_class_name,synt,fwd_model,merge_fra,merge_crv,
									blend_buf_days,edfut_cvx_adj_out, fwd_crv, first_fix_base,first_fix_flat, basis_ip_mat,fwd_pre,fwd_pre_cut_off );
	}

	//-------------------------------------------------------
	// fwd_b1_ext_curve_create (base case with basis swaps quoted as 1 swap)
	// only here for backward compatibility
	//-------------------------------------------------------
	fwd_func fwd_b1_ext_curve_create(	date 			d,
										disc_func		df_ois,	
										disc_func option(nullable)	df_synt_base,
										date option(nullable) synt_end,
										fwd_func 		fwd_pre,
										date			fwd_pre_cut_off,
										fwd_func		fwd_in,
										integer			fwd_in_freq,
										curve option(nullable)		short_out_crv, 			
										curve option(nullable)		fra_out_crv, 										
										curve 			basis_t1t2_crv,
										curve_prio	prio1,
										curve_prio	prio2,
										string option(nullable) depo_class_name,
										string option(nullable) fra_out_class_name,									
										synt_short_style synt,									
										fwd_z_model  	fwd_model,																			
										logical 		merge_fra,
										logical 		merge_crv,
										integer			blend_buf_days,
										vector(number) option(nullable) 	edfut_cvx_adj,
										out swap_curve_b1_ext  	fwd_crv,									
										number option(nullable) first_fix_base = null<number>,
										number option(nullable) first_fix_flat = null<number>)

	{	
		fwd_crv = fwd_b1_curve_create(	d,df_ois,df_synt_base,synt_end,fwd_in,fwd_in_freq,short_out_crv,fra_out_crv,
										basis_t1t2_crv,prio1,prio2,depo_class_name,fra_out_class_name,synt,fwd_model,
										merge_fra,merge_crv,blend_buf_days,edfut_cvx_adj, first_fix_base,first_fix_flat,
										null<vector(date)>,fwd_pre,fwd_pre_cut_off);
		//return fwd_crv.fwd_comb(fwd_model,ff_pre, cut_off);	
		return fwd_crv.fwd(fwd_model);					
	}
	//-------------------------------------------------------
	// cb_curve_create

	//-------------------------------------------------------
	swap_curve_bc_ext cb_curve_create(	date 						trade_date,
										instrument option(nullable)	fx_sp,
										curve option(nullable) 		fxswap_crv,
										instr_class_name option(nullable) depo_class_fxbase,
										instr_class_name option(nullable) depo_class_fxprice,			
										curve 						basis_crv,									
										number option(nullable)		basis_first_fix_flat,
										number option(nullable)		basis_first_fix_sprd,				
										logical						merge_crv,
										logical						prio_fxswap,				
										integer						blend_buf_days,
										disc_func option(nullable)	df_disc_flat,
										disc_func option(nullable)	df_disc_sprd,
										fwd_func					f_fwd_flat,			
										fwd_func 					f_fwd_sprd,	
										string option(nullable)		name)

	{
		LEGACY.swap_curve_cb1_parm p = LEGACY.swap_curve_cb1_parm(fx_spot(fx_sp),fxswap_crv,depo_class_fxbase,depo_class_fxprice,basis_crv,
													basis_first_fix_flat,basis_first_fix_sprd,merge_crv,prio_fxswap,blend_buf_days) ;

		return swap_curve_bc_ext(trade_date,p,df_disc_flat,df_disc_sprd, f_fwd_flat,f_fwd_sprd, name) ;
	}

	//-------------------------------------------------------
	// cb_curve_flat_disc
	//-------------------------------------------------------
	disc_func cb_curve_flat_disc(date 			trade_date,
								instrument option(nullable)	fx_spot,
								curve option(nullable) 		fxswap_crv,
								instr_class_name option(nullable) depo_class_fxbase,
								instr_class_name option(nullable) depo_class_fxprice,	
								curve 						basis_crv,							
								number option(nullable)		basis_first_fix_flat,
								number option(nullable)		basis_first_fix_sprd,
								logical						merge_crv,
								logical						prio_fxswap,
								integer						blend_buf_days,
								disc_func option(nullable)	df_disc_flat,
								disc_func 					df_disc_sprd,
								fwd_func					f_fwd_flat,	
								fwd_func 					f_fwd_sprd,	
								string option(nullable) 	name,
								interpolator option(nullable) boot_ip,
								rate_type option(nullable)	boot_ip_rt,
								out swap_curve_bc_ext 		currb)


	{
		currb	= cb_curve_create(	trade_date,fx_spot,fxswap_crv,depo_class_fxbase,depo_class_fxprice,basis_crv,
									basis_first_fix_flat,basis_first_fix_sprd,merge_crv,prio_fxswap,blend_buf_days,df_disc_flat,
									df_disc_sprd,f_fwd_flat,f_fwd_sprd,name);

		return currb.adj_disc_df_flat(boot_ip,boot_ip_rt);
	}

	//-------------------------------------------------------
	// cb_curve_flat_disc
	//-------------------------------------------------------
	disc_func cb_curve_flat_disc(date 			trade_date,
								instrument option(nullable)	fx_spot,
								curve option(nullable) 		fxswap_crv,
								instr_class_name option(nullable) depo_class_fxbase,
								instr_class_name option(nullable) depo_class_fxprice,	
								curve 						basis_crv,							
								number option(nullable)		basis_first_fix_flat,
								number option(nullable)		basis_first_fix_sprd,
								logical						merge_crv,
								logical						prio_fxswap,
								integer						blend_buf_days,
								disc_func option(nullable)	df_disc_flat,
								disc_func 					df_disc_sprd,
								fwd_func					f_fwd_flat,	
								fwd_func 					f_fwd_sprd,	
								string option(nullable) 	name,
								disc_z_model 				disc_model,	
								//interpolator option(nullable) boot_ip,
								//rate_type option(nullable)	boot_ip_rt,
								out swap_curve_bc_ext 		currb)


	{
		currb	= cb_curve_create(	trade_date,fx_spot,fxswap_crv,depo_class_fxbase,depo_class_fxprice,basis_crv,
									basis_first_fix_flat,basis_first_fix_sprd,merge_crv,prio_fxswap,blend_buf_days,df_disc_flat,
									df_disc_sprd,f_fwd_flat,f_fwd_sprd,name);

		return currb.adj_disc_df_flat(disc_model);
	}
	//-------------------------------------------------------
	// cb_curve_sprd_disc
	//-------------------------------------------------------
	disc_func cb_curve_sprd_disc(date 			trade_date,
								instrument option(nullable)	fx_spot,
								curve option(nullable) 		fxswap_crv,
								instr_class_name option(nullable) depo_class_fxbase,
								instr_class_name option(nullable) depo_class_fxprice,												
								curve 						basis_crv,							
								number option(nullable)		basis_first_fix_flat,
								number option(nullable)		basis_first_fix_sprd,											
								logical						merge_crv,
								logical						prio_fxswap,											
								integer						blend_buf_days,
								disc_func 					df_disc_flat,
								disc_func option(nullable)	df_disc_sprd,
								fwd_func					f_fwd_flat,																	
								fwd_func 					f_fwd_sprd,									
								string option(nullable) 	name,
								interpolator option(nullable) boot_ip,
								rate_type option(nullable)	boot_ip_rt,
								out swap_curve_bc_ext 		currb)

	{
		currb	= cb_curve_create(	trade_date,fx_spot,fxswap_crv,depo_class_fxbase,depo_class_fxprice,basis_crv,
									basis_first_fix_flat,basis_first_fix_sprd,merge_crv,prio_fxswap,blend_buf_days,df_disc_flat,
									df_disc_sprd,f_fwd_flat,f_fwd_sprd,name);

		return currb.adj_disc_df_sprd(boot_ip,boot_ip_rt);
	}
	//-------------------------------------------------------
	// cb_curve_sprd_disc
	//-------------------------------------------------------
	disc_func cb_curve_sprd_disc(date 			trade_date,
								instrument option(nullable)	fx_spot,
								curve option(nullable) 		fxswap_crv,
								instr_class_name option(nullable) depo_class_fxbase,
								instr_class_name option(nullable) depo_class_fxprice,												
								curve 						basis_crv,							
								number option(nullable)		basis_first_fix_flat,
								number option(nullable)		basis_first_fix_sprd,											
								logical						merge_crv,
								logical						prio_fxswap,											
								integer						blend_buf_days,
								disc_func 					df_disc_flat,
								disc_func option(nullable)	df_disc_sprd,
								fwd_func					f_fwd_flat,																	
								fwd_func 					f_fwd_sprd,									
								string option(nullable) 	name,
								disc_z_model  				disc_model,
								//interpolator option(nullable) boot_ip,
								//rate_type option(nullable)	boot_ip_rt,
								out swap_curve_bc_ext 		currb)

	{
		currb	= cb_curve_create(	trade_date,fx_spot,fxswap_crv,depo_class_fxbase,depo_class_fxprice,basis_crv,
									basis_first_fix_flat,basis_first_fix_sprd,merge_crv,prio_fxswap,blend_buf_days,df_disc_flat,
									df_disc_sprd,f_fwd_flat,f_fwd_sprd,name);

		return currb.adj_disc_df_sprd(disc_model);
	}
	//-------------------------------------------------------
	// cb_curve_base_disc
	// just for backward compatibility
	//-------------------------------------------------------
	disc_func cb_curve_base_disc(date 			trade_date,
								instrument option(nullable)	fx_spot,
								curve option(nullable) 		fxswap_crv,
								instr_class_name option(nullable) depo_class_fxbase,
								instr_class_name option(nullable) depo_class_fxprice,												
								curve 						basis_crv,						
								number option(nullable)		basis_first_fix_flat,
								number option(nullable)		basis_first_fix_sprd,											
								logical						merge_crv,
								logical						prio_fxswap,											
								integer						blend_buf_days,
								disc_func 					df_disc_flat,
								disc_func option(nullable)	df_disc_sprd,
								fwd_func					f_fwd_flat,																	
								fwd_func 					f_fwd_sprd,									
								string option(nullable) 	name,
								interpolator option(nullable) boot_ip,
								rate_type option(nullable)	boot_ip_rt,
								out swap_curve_bc_ext 		currb)
	{
		return cb_curve_sprd_disc(	trade_date,fx_spot,fxswap_crv,depo_class_fxbase,depo_class_fxprice,basis_crv,
									basis_first_fix_flat,basis_first_fix_sprd,merge_crv,prio_fxswap,blend_buf_days,
									df_disc_flat,df_disc_sprd,f_fwd_flat,f_fwd_sprd,name,boot_ip,boot_ip_rt,currb);
	}
	//-------------------------------------------------------
	// cff_curve_create

	//-------------------------------------------------------
	swap_curve_cff_ext cff_curve_create(date 						trade_date,
										instrument option(nullable)	fx_sp,
										curve option(nullable) 		fxswap_crv,
										instr_class_name option(nullable) depo_class_fxbase,
										instr_class_name option(nullable) depo_class_fxprice,			
										curve 						fixflt_crv,
										number option(nullable)		flt_first_fix,												
										logical						merge_crv,
										logical						prio_fxswap,				
										integer						blend_buf_days,
										disc_func option(nullable)	fix_df_disc,
										disc_func option(nullable)	flt_df_disc,
										fwd_func					flt_fwd,												
										string option(nullable)		name)

	{
		LEGACY.swap_curve_cff_parm p = LEGACY.swap_curve_cff_parm(fx_spot(fx_sp),fxswap_crv,depo_class_fxbase,depo_class_fxprice,fixflt_crv,
													flt_first_fix,merge_crv,prio_fxswap,blend_buf_days) ;

		return swap_curve_cff_ext(trade_date,p,fix_df_disc,flt_df_disc, flt_fwd, name) ;
	}

	//-------------------------------------------------------
	// cff_curve_fix_disc
	//-------------------------------------------------------
	disc_func cff_curve_fix_disc(date 						trade_date,
								instrument option(nullable)	fx_spot,
								curve option(nullable) 		fxswap_crv,
								instr_class_name option(nullable) depo_class_fxbase,
								instr_class_name option(nullable) depo_class_fxprice,												
								curve 						fixflt_crv,
								number option(nullable)		flt_first_fix,											
								logical						merge_crv,
								logical						prio_fxswap,											
								integer						blend_buf_days,
								disc_func option(nullable)	fix_df_disc,
								disc_func 					flt_df_disc,
								fwd_func					flt_fwd,									
								string option(nullable) 	name,
								interpolator option(nullable) boot_ip,
								rate_type option(nullable)	boot_ip_rt,
								out swap_curve_cff_ext 		currff)
	{
		currff	= cff_curve_create(	trade_date,fx_spot,fxswap_crv,depo_class_fxbase,depo_class_fxprice,fixflt_crv,
									flt_first_fix,merge_crv,prio_fxswap,blend_buf_days,fix_df_disc,
									flt_df_disc,flt_fwd,name);

		return currff.fix_adj_disc_df(boot_ip,boot_ip_rt);
	}
	//-------------------------------------------------------
	// cff_curve_flt_disc
	//-------------------------------------------------------
	disc_func cff_curve_flt_disc(date 			trade_date,
								instrument option(nullable)	fx_spot,
								curve option(nullable) 		fxswap_crv,
								instr_class_name option(nullable) depo_class_fxbase,
								instr_class_name option(nullable) depo_class_fxprice,												
								curve 						fixflt_crv,
								number option(nullable)		flt_first_fix,											
								logical						merge_crv,
								logical						prio_fxswap,											
								integer						blend_buf_days,
								disc_func 					fix_df_disc,
								disc_func option(nullable)	flt_df_disc,
								fwd_func					flt_fwd,									
								string option(nullable) 	name,
								interpolator option(nullable) boot_ip,
								rate_type option(nullable)	boot_ip_rt,
								out swap_curve_cff_ext   	currff)

	{
		currff	= cff_curve_create(	trade_date,fx_spot,fxswap_crv,depo_class_fxbase,depo_class_fxprice,fixflt_crv,
									flt_first_fix,merge_crv,prio_fxswap,blend_buf_days,fix_df_disc,
									flt_df_disc,flt_fwd,name);

		return currff.flt_adj_disc_df(boot_ip,boot_ip_rt);
	}
	//-------------------------------------------------------
	// swap_surface_create
	//-------------------------------------------------------
	swap_curve_surface swap_surface_b2_create(	date 							d,
												disc_func						df_ois,	
												date 							ois_end,
												curve option(nullable)			short_main_crv, 											
												curve option(nullable)			fra_main_crv,  	
												curve option(nullable)			swap_main_crv,
												vector(curve)					short_t_crv,
												vector(curve)					fra_t_crv,
												vector(curve)					basis_t_crv,
												curve_prio						prio1,
												curve_prio						prio2,
												string							depo_class_name,
												string							fra_main_class_name,
												vector(string)					fra_t_class_name,																						
												synt_short_style				synt,
												fwd_z_model						fwd_model,																											
												logical 						merge_fra,
												logical 						merge_crv,
												integer							blend_buf_days,
												vector(number) option(nullable) edfut_cvx_adj,
												logical 						x_pol_basis,							
												number option(nullable) 		swap_first_fix = null<number> )

	{	
		integer t_size = v_size(basis_t_crv); 
		
		QL_REQUIRE(t_size == v_size(fra_t_crv), "invalid tenor curve vectors (fra curve)");
		QL_REQUIRE(t_size == v_size(fra_t_class_name), "invalid tenor curve vectors (fra class names)");
		QL_REQUIRE(t_size == v_size(short_t_crv), "invalid tenor curve vectors (short curve)");

		vector(fwd_func) f_fwd[t_size+1];
		vector(number) freq[t_size+1];
		swap_curve_fwd_ext 	fwd_crv_m;
		f_fwd[0] = fwd_curve_create(	d,df_ois,df_ois, ois_end,short_main_crv,fra_main_crv,swap_main_crv,prio1,prio2,depo_class_name,
										fra_main_class_name,synt,fwd_model,merge_fra,merge_crv,blend_buf_days,edfut_cvx_adj,fwd_crv_m,swap_first_fix);
		freq[0] = fwd_crv_m.flt_freq();
		QL_REQUIRE(!null(freq[0]) && freq[0] != 365, "invalid float coupon frequency");
		string ccy = fwd_crv_m.blended_curve().instruments()[0].currency();
		vector(swap_curve_b2_ext) fwd_crv_t[t_size];
		
		for(integer i = 0; i < t_size; i++){
			f_fwd[i+1] = fwd_b2_curve_create(	d,df_ois,df_ois,ois_end,short_t_crv[i],fra_t_crv[i],swap_main_crv,basis_t_crv[i],
												prio1,prio2,depo_class_name,fra_t_class_name[i], synt,fwd_model,merge_fra,merge_crv,
												blend_buf_days,edfut_cvx_adj,x_pol_basis, fwd_crv_t[i],swap_first_fix );
			freq[i+1] = fwd_crv_t[i].flt_freq();
			QL_REQUIRE(!null(freq[i+1]) && freq[i+1] != 365, "invalid float coupon frequency");
							
		}
		return new swap_curve_surface(d, df_ois, f_fwd,12/freq, ccy);					
	}
}

