/*	
	wsp_util functions for "dual" bootstrap
	Developed by Algorithmica Research, Magnus Nyström
	
	
	Comments:
	
	
*/

module WSP_UTIL
{
	//-------------------------------------------------------
	// disc_crv_calc_int
	//-------------------------------------------------------
	disc_func disc_crv_calc_int(curve_ext 					disc_base,
								curve_data_disc 			cd,
								string option(nullable) 	z_model,
								string option(nullable) 	ip_model,
								string option(nullable) 	ip_rt )
	{									
		string err_msg;
		if(!disc_base.check(err_msg))
			QL_FAIL(err_msg);

		disc_model_parm disc_p 		= disc_model_parm(); 
	
		if(!null(z_model)) 	disc_p.set_model(z_model) ;		
		if(!null(ip_rt)) 	disc_p.set_rt(ip_rt) ;			
		if(!null(ip_model)) disc_p.set_ip(ip_model) ;
			
		disc_z_model disc_model 	= init_disc_model(disc_p);													
		disc_func df 				= disc_base.disc_df(disc_model);
		date df_end 				= disc_base.curve_end();				
		QL_REQUIRE(!null(df),'invalid disc_func');			
		
		if(cd.no_extrap_) {
			date td = disc_base.trade_date();
			number min_t = 0;//(vi[0].maturity()-g_trade_date)/365.0;
			number max_t = (df_end-td)/365.0;
			df = disc_func_restrict(df, min_t,max_t);				
			QL_REQUIRE(!null(df),'invalid disc_func (restrict)');
		}
		
		return df;
		
	}
	//-------------------------------------------------------
	// bond_disc_crv_calc
	//-------------------------------------------------------
	logical bond_disc_crv_calc(	out curve_data_disc 		cd,//members df_ and crv_ will be updated
								string option(nullable) 	z_model,
								string option(nullable) 	ip_model,
								string option(nullable) 	ip_rt,
								out string 					err_msg)
	{		
		try{
			err_msg = "";
			QL_REQUIRE(!null(cd),'invalid curve_data_disc');
			
			vector(number)  short_crv_y_spr, middle_crv_y_spr,  long_crv_y_spr;
			curve_ext_parm parm		= curve_ext_parm(	cd.short_crv_, cd.middle_crv_,cd.long_crv_,
														cd.blend_parm(),short_crv_y_spr, middle_crv_y_spr,  long_crv_y_spr,false);
						
			curve_ext disc_base 	= curve_ext(parm,null<date>,"bond");			
			cd.update_blend_curve(disc_base.blended_curve());
			disc_func df 			= disc_crv_calc_int(disc_base,cd,z_model,ip_model,ip_rt );
			cd.update_df(df);	
			
			return true;
			
			/*cd.crv_ 				= disc_base.blended_curve();

			if(!disc_base.check(err_msg))
				QL_FAIL(err_msg);

			disc_model_parm disc_p 		= disc_model_parm(); 
		
			if(!null(z_model)) 	disc_p.set_model(z_model) ;		
			if(!null(ip_rt)) 	disc_p.set_rt(ip_rt) ;			
			if(!null(ip_model)) disc_p.set_ip(ip_model) ;
				
			disc_z_model disc_model 	= init_disc_model(disc_p);													
			cd.df_ 						= disc_base.disc_df(disc_model);
			date df_end 				= disc_base.curve_end();				
			QL_REQUIRE(!null(cd.df_),'invalid disc_func');			
			
			if(cd.no_extrap_) {
				number min_t = 0;//(vi[0].maturity()-g_trade_date)/365.0;
				number max_t = (df_end-trade_date)/365.0;
				cd.df_ = disc_func_restrict(cd.df_, min_t,max_t);				
				QL_REQUIRE(!null(cd.df_),'invalid disc_func (restrict)');
			}
			
			return true;*/
		}
		catch {
			err_msg = err.message();
			
			if(!null(cd)) {
				cd.crv_ = null<curve>;
				cd.df_ = null<disc_func>;	
			}
			//warning(err.message());
			
			return false;
		}
	}
	//-------------------------------------------------------
	// bond_crv_hist
	//-------------------------------------------------------
	void bond_crv_hist( vector(date) dates,
						curve_data_disc data_disc,
						input_curve_data_ext option(nullable) inp_short_sd,
						input_curve_data_ext option(nullable) inp_middle_sd,
						input_curve_data_ext option(nullable) inp_long_sd,
						vector(instr_type) option(nullable) allowed_types,
						string  z_model	,
						string   option(nullable) ip_model,
						string   option(nullable) ip_rt,
						out vector(curve) blend_crv_hist,
						out vector(disc_func) df_hist,
						out vector(date) err_date,
						out vector(string) err_msg)
	{
			
		if(null(inp_short_sd) && null(inp_middle_sd) && null(inp_long_sd)) {
			resize(blend_crv_hist,0);
			resize(df_hist,0);
			err_date = dates;
			resize(err_msg,v_size(dates));
			err_msg = "no curve data";
			QL_FAIL("no curve data");
		}
		
		curve_data_disc crv_hist = new curve_data_disc(data_disc.short_name_, data_disc.middle_name_, data_disc.long_name_);

		crv_hist.prio1_ 	= data_disc.prio1_;			
		crv_hist.prio2_		= data_disc.prio2_;
		crv_hist.merge_ 	= data_disc.merge_;

		resize(err_date,0);
		resize(err_msg,0);
		integer size = v_size(dates);
		resize(blend_crv_hist,size);
		resize(df_hist,size);
			
		for(integer i=0;i<size;i++) {

			if(!null(inp_short_sd)){
				input_curve_data_ext short_sd =  new input_curve_data_ext(dates[i],crv_hist.short_name_, inp_short_sd.qs_, false,allowed_types);
				if(short_sd.is_init()){
					crv_hist.update_short_curve(short_sd.crv_incl_,short_sd.crv_orig_);
				}
			}

			if(!null(inp_middle_sd)){
				input_curve_data_ext middle_sd =  new input_curve_data_ext(	dates[i],crv_hist.middle_name_, inp_middle_sd.qs_, false,allowed_types);
				if(middle_sd.is_init()){
					crv_hist.update_short_curve(middle_sd.crv_incl_,middle_sd.crv_orig_);
				}
			}
			
			if(!null(inp_long_sd)){
				input_curve_data_ext long_sd =  new input_curve_data_ext(	dates[i],crv_hist.long_name_, inp_long_sd.qs_, false,allowed_types);
				if(long_sd.is_init()){
					crv_hist.update_short_curve(long_sd.crv_incl_,long_sd.crv_orig_);
				}
			}
			
			string e_msg;
			logical ok = bond_disc_crv_calc(crv_hist,z_model,ip_model,ip_rt,e_msg);
			if(ok) {
				blend_crv_hist[i] 	= crv_hist.crv_;
				df_hist[i] 			= crv_hist.df_;
			}
			else {
				blend_crv_hist[i] 	= null<curve>;
				df_hist[i] 			= null<disc_func>;
				push_back(err_date,dates[i]);
				push_back(err_msg, e_msg);
			}
		}
	}
	
	
	//-------------------------------------------------------
	// disc_crv_calc
	//-------------------------------------------------------
	logical disc_crv_calc(	out curve_data_disc 		cd,//members df_ and crv_ will be updated
							string option(nullable) 	z_model,
							string option(nullable) 	ip_model,
							string option(nullable) 	ip_rt,
							out string 					err_msg)
	{		
		try{
			err_msg = "";
			
			QL_REQUIRE(!null(cd),'invalid curve_data_disc');			
			
			vector(number)  short_crv_y_spr, middle_crv_y_spr,  long_crv_y_spr;
			swap_curve_disc_parm disc_parm	= swap_curve_disc_parm(	cd.short_crv_, cd.middle_crv_,cd.long_crv_,
																	cd.blend_parm(),
																	short_crv_y_spr, middle_crv_y_spr,  long_crv_y_spr);

			
			swap_curve_disc_ext disc_base 	= disc_curve_create(cd.trade_date_crv(),disc_parm);
			cd.crv_ 						= disc_base.blended_curve();			
			cd.df_ 							= disc_crv_calc_int(disc_base,cd,z_model,ip_model,ip_rt );

			return true;
			
			/*
			cd.crv_ 						= disc_base.blended_curve();

			if(!disc_base.check(err_msg))
				QL_FAIL(err_msg);

			disc_model_parm disc_p 			= disc_model_parm(); 
		
			if(!null(z_model)) 	disc_p.set_model(z_model) ;		
			if(!null(ip_rt)) 	disc_p.set_rt(ip_rt) ;			
			if(!null(ip_model)) disc_p.set_ip(ip_model) ;
				
			disc_z_model disc_model 	= init_disc_model(disc_p);													
			cd.df_ 						= disc_base.disc_df(disc_model);
			date df_end 				= disc_base.curve_end();				
			QL_REQUIRE(!null(cd.df_),'invalid disc_func');			
			
			if(cd.no_extrap_) {
				number min_t = 0;//(vi[0].maturity()-g_trade_date)/365.0;
				number max_t = (df_end-trade_date)/365.0;
				cd.df_ = disc_func_restrict(cd.df_, min_t,max_t);				
				QL_REQUIRE(!null(cd.df_),'invalid disc_func (restrict)');
			}
			
			return true;*/
		}
		catch {
			err_msg = err.message();
			
			if(!null(cd)) {
				cd.crv_ = null<curve>;
				cd.df_ = null<disc_func>;	
			}
			//warning(err.message());
			
			return false;
		}
	}
	//-------------------------------------------------------
	// create_mid_curve
	//-------------------------------------------------------
	void create_mid_curve(curve bid_crv,curve ask_crv, out curve mid_crv)
	{
		
		vector(instrument) vib = bid_crv.instruments();
		vector(instrument) via = ask_crv.instruments();
		integer size = v_size(vib);
		vector(instrument) vim[size];

		for(integer i=0;i<size;i++) {
			number mid = (vib[i].quote() + via[i].quote() ) / 2.0;
			vim[i] = vib[i].set_quote(mid);
		}
		//string n = strcat(bid_crv.name(),"-MID");
		mid_crv = curve(vim, bid_crv.name());
	}
	//-------------------------------------------------------
	// disc_crv_calc
	//-------------------------------------------------------
	logical disc_crv_calc(	out curve_data_disc 		cd_bid,
							out curve_data_disc 		cd_ask,
							string option(nullable) 	z_model,
							string option(nullable) 	ip_model,
							string option(nullable) 	ip_rt,
							out string 					err_msg)
	{		
		try{
			err_msg = "";
			
			QL_REQUIRE(!null(cd_bid),'invalid curve_data_disc (bid)');
			QL_REQUIRE(!null(cd_ask),'invalid curve_data_disc (ask)');

			date td = cd_bid.trade_date_crv();
			
			vector(number)  short_crv_y_spr, middle_crv_y_spr,  long_crv_y_spr;
			swap_curve_disc_parm disc_parm_bid	= swap_curve_disc_parm(	cd_bid.short_crv_, cd_bid.middle_crv_,cd_bid.long_crv_,
																	cd_bid.blend_parm(), short_crv_y_spr, middle_crv_y_spr,  long_crv_y_spr);
			swap_curve_disc_ext disc_bid 	= disc_curve_create(td,disc_parm_bid);
			cd_bid.crv_ 					= disc_bid.blended_curve();

			if(!disc_bid.check(err_msg))
				QL_FAIL(err_msg);

			swap_curve_disc_parm disc_parm_ask	= swap_curve_disc_parm(	cd_ask.short_crv_, cd_ask.middle_crv_,cd_ask.long_crv_,
																	cd_ask.blend_parm(), short_crv_y_spr, middle_crv_y_spr,  long_crv_y_spr);
			swap_curve_disc_ext disc_ask 	= disc_curve_create(td,disc_parm_ask);
			cd_ask.crv_ 					= disc_ask.blended_curve();

			if(!disc_ask.check(err_msg))
				QL_FAIL(err_msg);


			curve mid_crv;
			create_mid_curve(cd_bid.crv_,cd_ask.crv_, mid_crv);

			swap_curve_disc_parm disc_parm_mid	= swap_curve_disc_parm(	null<curve>, null<curve>,mid_crv,
																	cd_bid.blend_parm(), short_crv_y_spr, middle_crv_y_spr,  long_crv_y_spr);
			swap_curve_disc_ext disc_mid 		= disc_curve_create(td,disc_parm_mid);
			

			if(!disc_mid.check(err_msg))
				QL_FAIL(err_msg);
			
			
			disc_model_parm disc_p 			= disc_model_parm(); 
		
			if(!null(z_model)) 	disc_p.set_model(z_model) ;		
			if(!null(ip_rt)) 	disc_p.set_rt(ip_rt) ;			
			if(!null(ip_model)) disc_p.set_ip(ip_model) ;
				
			disc_z_model disc_model 	= init_disc_model(disc_p);													
			cd_bid.df_ 					= disc_mid.disc_df(disc_model);
			date df_end 				= disc_mid.curve_end();				
			QL_REQUIRE(!null(cd_bid.df_),'invalid bid disc_func');			
			cd_ask.df_					= cd_bid.df_;

			disc_p.set_model("BOOT") ;		
			disc_p.set_rt("RT_CONT") ;			
			disc_p.set_ip("LINEAR") ;
			disc_model 	= init_disc_model(disc_p);
			
			cd_bid.df_spr_ = disc_bid.disc_df(cd_bid.df_,disc_model);
			cd_ask.df_spr_ = disc_ask.disc_df(cd_ask.df_,disc_model);
			
			if(cd_bid.no_extrap_) {
				number min_t = 0;//(vi[0].maturity()-g_trade_date)/365.0;
				number max_t = (df_end-td)/365.0;
				cd_bid.df_ = disc_func_restrict(cd_bid.df_, min_t,max_t);				
				QL_REQUIRE(!null(cd_bid.df_),'invalid bid disc_func (restrict)');
				cd_ask.df_	= cd_bid.df_;

				cd_bid.df_spr_ = disc_func_restrict(cd_bid.df_spr_, min_t,max_t);				
				QL_REQUIRE(!null(cd_bid.df_spr_),'invalid bid disc_func_spr (restrict)');
				cd_ask.df_spr_ = disc_func_restrict(cd_ask.df_spr_, min_t,max_t);				
				QL_REQUIRE(!null(cd_ask.df_spr_),'invalid ask disc_func_spr (restrict)');
			}
			
			return true;
		}
		catch {
			err_msg = err.message();
			
			if(!null(cd_bid)) {
				cd_bid.crv_ = null<curve>;
				cd_bid.df_ = cd_bid.df_spr_ = null<disc_func>;	
			}
			if(!null(cd_ask)) {
				cd_ask.crv_ = null<curve>;
				cd_ask.df_ = cd_ask.df_spr_ = null<disc_func>;	
			}
			//warning(err.message());
			
			return false;
		}
	}

	//-------------------------------------------------------
	// fwd_crv_calc
	//-------------------------------------------------------
	logical fwd_crv_calc(	out curve_data_fwd 			cd,
							string option(nullable) 	z_model,
							logical	 					model_spr,
							out string 					err_msg)
	{		
		try{
			
			err_msg = "";

			QL_REQUIRE(!null(cd),'invalid curve_data_disc');

			date td = cd.trade_date_crv();
			
			vector(number)  edfut_crv_y_spr, middle_crv_y_spr,  long_crv_y_spr;
			swap_curve_fwd_f_parm fwd_parm;
			
			if(!check_curve(cd.short_crv_)) {
				fwd_parm	= swap_curve_fwd_f_parm(null<fixing_curve>, cd.middle_crv_,cd.long_crv_, cd.blend_parm(),
													middle_crv_y_spr,  long_crv_y_spr, edfut_crv_y_spr,false);
			}
			else {
				instrument i = cd.short_crv_.instruments()[0];
				if(i.instr_type() == instr_type.DEPOSIT_INDEX){
				
					fwd_parm	= swap_curve_fwd_f_parm(fixing_curve(cd.short_crv_), cd.middle_crv_,cd.long_crv_, cd.blend_parm(),
													middle_crv_y_spr,  long_crv_y_spr, edfut_crv_y_spr,false);
				}
				else {
					number swap_first_fix = null<number>;
					fwd_parm	= swap_curve_fwd_f_parm(cd.short_crv_, cd.middle_crv_,cd.long_crv_, cd.blend_parm(),
													middle_crv_y_spr,  long_crv_y_spr, edfut_crv_y_spr,swap_first_fix);
				}
			}

			fwd_func_tenor fwd_tenor;
			if(null(cd.fwd_tenor_)){
				fwd_tenor = get_fwd_func_tenor(fwd_parm) ;
				cd.fwd_tenor_ = fwd_tenor;
			}
			else {
				fwd_tenor = cd.fwd_tenor_;
			}
			fwd_func fwd_pre = null<fwd_func>;
			date fwd_pre_cut_off = null<date>;
			swap_curve_fwd_ext fwd_base 	= fwd_curve_create(td, cd.disc_.df_,fwd_tenor, fwd_parm,fwd_pre,fwd_pre_cut_off);
			cd.crv_ 						= fwd_base.blended_curve();

			if(!fwd_base.check(err_msg))
				QL_FAIL(err_msg);

			fwd_model_parm fwd_p 			= fwd_model_parm(); 
		
			if(!null(z_model))
				fwd_p.set_model(z_model) ;
							
			fwd_z_model fwd_model 		= init_fwd_model(fwd_p);
			cd.f_fwd_ 					= model_spr ? fwd_base.fwd_spr(cd.disc_.df_,fwd_model) : fwd_base.fwd(fwd_model);
			
			QL_REQUIRE(!null(cd.f_fwd_),'invalid fwd_func');				
			
			return true;
		}
		catch {
			err_msg = err.message();
			
			if(!null(cd)) {
				cd.crv_ = null<curve>;
				cd.df_ = null<disc_func>;	
			}
			//warning(err.message());
			
			return false;
		}
	}
}


module CORE_INT
{
	//-------------------------------------------------------
	// fra_turn_fwd_func
	/* turn_instr are fra's of a certain tenor. Settle is the date the turn is starting to have an effect on the fra's
	  and index_maturity is when that effect is gone. All fra's in between will be affected by the turn.
	  result: a fwd_func with spreads only
	 */
	//-------------------------------------------------------
	/*fwd_func fra_turn_fwd_func(date td, vector(instrument) turn_instr)
	{
		integer size 	= v_size(turn_instr);
		if(size==0)
			return null<fwd_func>;
		
		fwd_func f 		= fwd_func_interp([1],[0], ip_linear());
		//quote_style qs = turn_instr[0].quote_style_e();
		for(integer i=0; i < size; i++) {
			number spread 	= turn_instr[i].yield();
			QL_REQUIRE(!null(spread), "spread quote is null");
			integer start 	= (turn_instr[i].settle_date()-td);
			QL_REQUIRE(turn_instr[i].is_instr_type(instr_type.FRA),"invalid instrument type");
			fra fr 			= fra(turn_instr[i]);
			fwd_func_tenor fwd_tenor;
			if(i==0)
				fwd_tenor = fwd_func_tenor_from_tc(fr.index_tenor_code());
			else
				QL_REQUIRE(fwd_tenor == fwd_func_tenor_from_tc(fr.index_tenor_code()),"invalid fra index tenor");
			integer end		= (fr.index_maturity()-td);
			fwd_func ff 	= fwd_func_add_spread(f, spread, start, end, true, true);
			f 				= ff;
		}
		return f;
	}*/

	
	/*fwd_func fra_turn_fwd_func(date td,
							   vector(fwd_turns) turnv)
	{
		integer size 	= v_size(turnv);
		if(size==0)
			return null<fwd_func>;
		
		fwd_func f 		= fwd_func_interp([1],[0], ip_linear());
		for(integer i=0; i < size; i++) {
			
			QL_REQUIRE(turnv[i].valid(), "turn information not valid");
			number spread 	= turnv[i].spread_;
			integer start 	= (turnv[i].start_-td);			
			integer end		= (turnv[i].end_-td);			
			fwd_func ff 	= fwd_func_add_spread(f, spread, start, end, true, true);
			f 				= ff;
		}
		return f;
	}*/

	//-------------------------------------------------------
	// fra_imp_turns
	// result: a vector of implied turns

	// currently the linear model is used for interpolation of the fwd_func
	//
	//-------------------------------------------------------
	/*vector(number) fra_imp_turns(date td,
								 vector(instrument) fra_v,
								 vector(fwd_turns) turnv)
	{
		integer size 				= v_size(turnv);
		integer size_fra 			= v_size(fra_v);
		if(size == 0 || size_fra == 0)
			return null<vector(number)>;

		for(integer i=0; i < size_fra; i++) {
			QL_REQUIRE(fra_v[i].is_instr_type(instr_type.FRA),"invalid instrument type (only fra supported for calculating implied turns)");
		}
		
		fwd_func f_turn_step 		= turns_base_fwd_func(td, turnv);		
		QL_REQUIRE(!null(f_turn_step),'invalid fwd_func (f_turn_step)');

		//init curvefit parms
		logical merge_fra 			= false;
		logical merge_crv			= false;						
		integer  blend_buf_days		= DFLT_BLEND_BUF_DAYS;
		logical no_overlap_fwd		= false;						
		curve_prio prio1 			= curve_prio.MIDDLE ;
		curve_prio prio2 			= curve_prio.LONG;
		curve_blend_parm blend_parm	= curve_blend_parm(prio1,prio2,no_overlap_fwd,merge_fra,merge_crv,blend_buf_days);
	
		vector(number) fra_crv_y_spr, swap_crv_y_spr;
		vector(number) edfut_cvx_adj 	= null<vector(number)>;
		swap_curve_fwd_f_parm fwd_parm 	= swap_curve_fwd_f_parm(null<fixing_curve>, curve(fra_v), null<curve>, blend_parm,
														   fra_crv_y_spr, swap_crv_y_spr,edfut_cvx_adj,false);

		disc_func df 					= disc_func_interp([1],[1],ip_linear());//a 0-rate disc_func is ok since we create the fwd_func only from fra's
		fra fr 							= fra(fra_v[0]);
		fwd_func_tenor fwd_tenor 		= fwd_func_tenor_from_tc(fr.index_tenor_code());			
		swap_curve_fwd_ext fwd_crv 		= fwd_curve_create(td, df,fwd_tenor, fwd_parm,null<fwd_func>,null<date>);
		
		fwd_model_parm fwd_p 			= fwd_model_parm();
		fwd_p.set_model(fwd_z_model_type.FZM_LINEAR);//use linear model
		
		fwd_z_model fwd_model 			= init_fwd_model(fwd_p);//create the fwd model based on the parameter object	
		fwd_func f_fwd_incl_turn 		= fwd_crv.fwd(fwd_model);//this is a fwd_func for all fra's (with market quotes i.e. incl turns)
		QL_REQUIRE(!null(f_fwd_incl_turn),'invalid fwd_func (f_fwd_incl_turn)');
	}*/
	//-------------------------------------------------------
	// fra_imp_turns
	/* turn_instr are fra's of a certain tenor. Settle is the date the turn is starting to have an effect on the fra's
	  and index_maturity is when that effect is gone. All fra's in between will be affected by the turn.
	  result: a vector of implied turns

	  currently the linear model is used for interpolation of the fwd_func
	 */
	//-------------------------------------------------------
	vector(number) fra_imp_turns(date td,
								 vector(instrument) fra_v,
								 vector(instrument) turn_instr)
	{
		integer size 				= v_size(turn_instr);
		integer size_fra 			= v_size(fra_v);
		if(size == 0 || size_fra == 0)
			return null<vector(number)>;

		for(integer i=0; i < size_fra; i++) {
			QL_REQUIRE(fra_v[i].is_instr_type(instr_type.FRA),"invalid instrument type (only fra supported for calculating implied turns)");
		}
		
		vector(fwd_turns) turnv 	= create_fwd_turn_v(curve(turn_instr));
		
		//fwd_func f_turn_step 		= fra_turn_fwd_func(td, turnv);
		fwd_func f_turn_step 		= turns_base_fwd_func(td, turnv);		
		QL_REQUIRE(!null(f_turn_step),'invalid fwd_func (f_turn_step)');
		
		
		
		//init curvefit parms
		logical merge_fra 			= false;
		logical merge_crv			= false;						
		integer  blend_buf_days		= DFLT_BLEND_BUF_DAYS;
		logical no_overlap_fwd		= false;						
		curve_prio prio1 			= curve_prio.MIDDLE ;
		curve_prio prio2 			= curve_prio.LONG;
		curve_blend_parm blend_parm	= curve_blend_parm(prio1,prio2,no_overlap_fwd,merge_fra,merge_crv,blend_buf_days);
	
		vector(number) fra_crv_y_spr, swap_crv_y_spr;
		vector(number) edfut_cvx_adj 	= null<vector(number)>;
		swap_curve_fwd_f_parm fwd_parm 	= swap_curve_fwd_f_parm(null<fixing_curve>, curve(fra_v), null<curve>, blend_parm,
														   fra_crv_y_spr, swap_crv_y_spr,edfut_cvx_adj,false);

		disc_func df 					= disc_func_interp([1],[1],ip_linear());//a 0-rate disc_func is ok since we create the fwd_func only from fra's
		fra fr 							= fra(fra_v[0]);
		fwd_func_tenor fwd_tenor 		= fwd_func_tenor_from_tc(fr.index_tenor_code());			
		swap_curve_fwd_ext fwd_crv 		= fwd_curve_create(td, df,fwd_tenor, fwd_parm,null<fwd_func>,null<date>);
		
		fwd_model_parm fwd_p 			= fwd_model_parm();
		fwd_p.set_model(fwd_z_model_type.FZM_LINEAR);//use linear model
		
		fwd_z_model fwd_model 			= init_fwd_model(fwd_p);//create the fwd model based on the parameter object	
		fwd_func f_fwd_incl_turn 		= fwd_crv.fwd(fwd_model);//this is a fwd_func for all fra's (with market quotes i.e. incl turns)
		QL_REQUIRE(!null(f_fwd_incl_turn),'invalid fwd_func (f_fwd_incl_turn)');
		
		fwd_func f_fwd_excl_turn 		= fwd_func_sub(f_fwd_incl_turn,f_turn_step);//this is a fwd_func with the turn subtracted
		//f_fwd_incl_turn and f_fwd_excl_turn are not a flat fwd_func with a parallell shift between 2 dates since the fit is done with turns
		
		//calculate the turn to see which fra's have a turn
		//turn will be zero if unaffected
		vector(number) qv[size_fra];
		vector(number) turn[size_fra];
		vector(number) t[size_fra];
		for(integer i=0;i<size_fra;i++) {
			t[i] 		= (fra_v[i].settle_date() -td)/365.0;
			qv[i] 		= f_fwd_incl_turn.fwd(t[i]);
			turn[i] 	= round((qv[i] - f_fwd_excl_turn.fwd(t[i]))*10000, 2);//rounding in order to ignore fra's with very small turn effect
		}

		//exclude all fra's which are affected by turns
		vector(integer) v_i 	= v_find_ne(turn, 0);
		vector(instrument) fra_ex_v = v_exclude(fra_v, v_i);
		fwd_parm 				= swap_curve_fwd_f_parm(null<fixing_curve>, curve(fra_ex_v), null<curve>, blend_parm,
														fra_crv_y_spr, swap_crv_y_spr,edfut_cvx_adj,false);
		fwd_crv 				= fwd_curve_create(td, df,fwd_tenor, fwd_parm,null<fwd_func>,null<date>);
		fwd_func f_fwd_pricing	= fwd_crv.fwd(fwd_model);//this is a fwd_func based on all fra's which are unaffected by turns --> our pricing curve		
		QL_REQUIRE(!null(f_fwd_pricing),'invalid fwd_func (f_fwd_pricing)');

		//calc fra's prices for all fra's with our pricing curve --> implied turns
		for(integer i=0;i<size_fra;i++) {
			qv[i] 		= f_fwd_pricing.fwd(t[i]);
			turn[i] 	= round((fra_v[i].yield() - qv[i])*10000, 2);
		}
		return turn;
	}
	//-------------------------------------------------------
	// fra_turns
	/* turn_instr are fra's of a certain tenor. Settle is the date the turn is starting to have an effect on the fra's
	  and index_maturity is when that effect is gone. All fra's in between will be affected by the turn.
	  input: 	a fra vector without turns
	  result: 	a vector of turns for every fra
	 */
	//-------------------------------------------------------
	vector(number) fra_turns(date td,
							 vector(instrument) fra_flat_v,
							 vector(instrument) turn_instr,
							 out fwd_func f_fwd_excl_turn,
							 out fwd_func f_fwd_incl_turn)
	{
		f_fwd_excl_turn = null<fwd_func>;
		f_fwd_incl_turn	= null<fwd_func>;
		integer size 				= v_size(turn_instr);
		integer size_fra 			= v_size(fra_flat_v);
		if(size == 0 || size_fra == 0)
			return null<vector(number)>;
				
		//fwd_func f_turn_step 		= fra_turn_fwd_func(td, turn_instr);
		vector(fwd_turns) turnv 	= create_fwd_turn_v(curve(turn_instr));
		fwd_func f_turn_step 		= turns_base_fwd_func(td, turnv);
		QL_REQUIRE(!null(f_turn_step),'invalid fwd_func (f_turn_step)');
		
		for(integer i=0; i < size_fra; i++) {
			QL_REQUIRE(fra_flat_v[i].is_instr_type(instr_type.FRA),"invalid instrument type (only fra supported for turns)");
		}
		
		//init curvefit parms
		logical merge_fra 			= false;
		logical merge_crv			= false;						
		integer blend_buf_days		= DFLT_BLEND_BUF_DAYS;
		logical no_overlap_fwd		= false;						
		curve_prio prio1 			= curve_prio.MIDDLE ;
		curve_prio prio2 			= curve_prio.LONG;
		curve_blend_parm blend_parm	= curve_blend_parm(prio1,prio2,no_overlap_fwd,merge_fra,merge_crv,blend_buf_days);
	
		vector(number) fra_crv_y_spr, swap_crv_y_spr;
		vector(number) edfut_cvx_adj 	= null<vector(number)>;
		swap_curve_fwd_f_parm fwd_parm 	= swap_curve_fwd_f_parm(null<fixing_curve>, curve(fra_flat_v), null<curve>, blend_parm,
														   fra_crv_y_spr, swap_crv_y_spr,edfut_cvx_adj,false);

		disc_func df 					= disc_func_interp([1],[1],ip_linear());
		fra fr 							= fra(fra_flat_v[0]);
		fwd_func_tenor fwd_tenor 		= fwd_func_tenor_from_tc(fr.index_tenor_code());			
		swap_curve_fwd_ext fwd_crv 		= fwd_curve_create(td, df,fwd_tenor, fwd_parm,null<fwd_func>,null<date>);
		fwd_model_parm fwd_p 			= fwd_model_parm();	
		fwd_z_model fwd_model 			= init_fwd_model(fwd_p);//create the fwd model based on the parameter object	
		f_fwd_excl_turn 				= fwd_crv.fwd(fwd_model);//this is a fwd_func for all fra's (excl turns)
		QL_REQUIRE(!null(f_fwd_excl_turn),'invalid fwd_func (f_fwd_excl_turn)');
		f_fwd_incl_turn 				= fwd_func_add(f_fwd_excl_turn,f_turn_step);//this is a fwd_func with the turn added

		//calculate the turn to see which fra's have a turn
		//turn will be zero if unaffected
		vector(number) qv[size_fra];
		vector(number) turn[size_fra];
		vector(number) t[size_fra];
		for(integer i=0;i<size_fra;i++) {
			t[i] 		= (fra_flat_v[i].settle_date() -td)/365.0;
			qv[i] 		= f_fwd_incl_turn.fwd(t[i]);
			turn[i] 	= round((qv[i] - f_fwd_excl_turn.fwd(t[i]))*10000, 2);
		}
		return turn;
	}
}
