/*	
	curve template definitions - selected examples
	Developer: Algorithmica Research, Magnus Nyström

			
*/

option(null: hard);

module CRV_TMPL_DISC 
{
	/*SEK*/	
	CURVE_TMPL.disc_curve_tmpl stina 	= new CURVE_TMPL.disc_curve_tmpl("STIBOR",null<string>,"SEKSTINA",null<string>,																		
																		 "Mid","Mid","Mid");

	CURVE_TMPL.disc_curve_tmpl stina2 	= new CURVE_TMPL.disc_curve_tmpl("SEKSTINA","Mid");

	CURVE_TMPL.disc_basis_curve_tmpl stina_basis 	= new CURVE_TMPL.disc_basis_curve_tmpl(null<string>,null<string>,null<string>,
																						   "SEK3MSWAP","SEK3MOISSWAP[1SWP]",
																							"Mid","Mid","Mid","Mid","Mid");//for testing
	
	/*EUR*/
	CURVE_TMPL.disc_curve_tmpl eonia 	= new CURVE_TMPL.disc_curve_tmpl("EONIA",null<string>,null<string>,null<string>,																		
																		 "Mid","Mid","Mid");
	
	CURVE_TMPL.disc_curve_tmpl eonia_exp = new CURVE_TMPL.disc_curve_tmpl("EONIA",null<string>,null<string>,"EUR6MSWAP",																		
																		 "Mid","Mid","Mid");
	
	/*CHF*/
	CURVE_TMPL.disc_curve_tmpl saron 	= new CURVE_TMPL.disc_curve_tmpl("SARON",null<string>,null<string>,null<string>,																		
																		 "Mid","Mid","Mid");
	
	/*model*/
	/*models: 	"BOOT","ON_STEP","MAX_SMOOTH","MAX_SMOOTH_SPREAD","ON_STEP_BOOT","TANGGAARD","TENSION_W_EXACT","TENSION_W_SPREAD",
				"TENSION_Y_EXACT","TENSION_Y_SPREAD","TENSION_Z_EXACT","TENSION_Z_SPREAD":*/

	/*ip_model: "LINEAR","SPLINE_NAT","SPLINE_FIN","STEP","HAGANWEST","HAGAN_WEST","HERMITE_AKIMA","HERMITE_CR","HERMITE_FINDIFF",
				"HERMITE_FB","HERMITE_KRUGER","HERMITE_MONO","HERMITE_P"*/

	/*ip_rt: "CONT","SIMPLE","EFFECTIVE","LOGDF","ON","SEMIANNUAL","QUARTERLY","MONTHLY"*/
	
	CURVE_TMPL.disc_curve_model_tmpl def_model = new CURVE_TMPL.disc_curve_model_tmpl(false,false,false,curve_prio.LONG,curve_prio.MIDDLE,
																					  5,"BOOT","LINEAR","LOG_DF");

	CURVE_TMPL.disc_curve_model_tmpl def_ois_model = new CURVE_TMPL.disc_curve_model_tmpl(false,false,false,curve_prio.LONG,curve_prio.MIDDLE,
																							5,"ON_STEP","STEP",null<string>);
}
module CRV_TMPL_FIX 
{
	CURVE_TMPL.fixing_curve_tmpl stibor = new CURVE_TMPL.fixing_curve_tmpl("STIBOR");
	CURVE_TMPL.fixing_curve_tmpl euribor = new CURVE_TMPL.fixing_curve_tmpl("EURIBOR");
}

module CRV_TMPL_FWD 
{	
	/*SEK single tenor*/
	
	CURVE_TMPL.fwd_curve_tmpl stina = new CURVE_TMPL.fwd_curve_tmpl(	"STIBOR", null<string>, "SEKSTINA",fwd_func_tenor.FT_1D,
																		"Ask","Mid","Mid", true, "STIBORFIXTN");
	
	CURVE_TMPL.fwd_curve_tmpl stibor3m = new CURVE_TMPL.fwd_curve_tmpl(	"STIBOR", "SEK3MIMMFRA", "SEKSWAP",fwd_func_tenor.FT_3M,
																		"Ask","Mid","Mid", true, "STIBORFIX3M");

	/*EUR single tenor*/
	CURVE_TMPL.fwd_curve_tmpl euribor6m = new CURVE_TMPL.fwd_curve_tmpl("EURIBOR", "EUR6MFRA", "EUR6MSWAP",fwd_func_tenor.FT_6M,
																		"Ask","Mid","Mid", true, "EURIBORFIX6M");

	CURVE_TMPL.fwd_curve_tmpl euribor6m_depo = new CURVE_TMPL.fwd_curve_tmpl("EURDEPO", "EUR6MFRA", "EUR6MSWAP",fwd_func_tenor.FT_6M,
																			 "Ask","Mid","Mid", false, "EURIBORFIX6M");

	CURVE_TMPL.fwd_curve_tmpl euribor3m_depo = new CURVE_TMPL.fwd_curve_tmpl("EURDEPO", "EUR3MFRA", "EUR3MSWAP",fwd_func_tenor.FT_3M,
																				"Ask","Mid","Mid", false, "EURIBORFIX3M");

	
	/*CHF single tenor*/
	CURVE_TMPL.fwd_curve_tmpl chflibor3m = new CURVE_TMPL.fwd_curve_tmpl("CHFDEPO", null<string>, "CHF3MSWAP",fwd_func_tenor.FT_3M,
																		 "Ask","Mid","Mid", false, "CHFLIBORFIX3M");
	
	/*EUR basis flt-flt (basis - 1swap)*/
	CURVE_TMPL.fwd_basis_curve_tmpl euribor3m_b1 = new CURVE_TMPL.fwd_basis_curve_tmpl(euribor6m,"EURIBOR", "EUR3MFRA", "EUR3M6MSWAP[1SWP]",
																					fwd_func_tenor.FT_3M, "Ask","Mid","Mid", true, true, "EURIBORFIX3M");

	CURVE_TMPL.fwd_basis_curve_tmpl euribor3m_b1_depo = new CURVE_TMPL.fwd_basis_curve_tmpl(euribor6m,"EURDEPO", "EUR3MFRA", "EUR3M6MSWAP[1SWP]",
																						fwd_func_tenor.FT_3M, "Ask","Mid","Mid", false, true, "EURIBORFIX3M");
	

	/*EUR basis flt-flt (spread between 2 fixlegs, basis - 2swaps)*/
	CURVE_TMPL.fwd_basis_2swp_curve_tmpl euribor1m_b2 = new CURVE_TMPL.fwd_basis_2swp_curve_tmpl(euribor6m,"EURIBOR", "EUR1MSPS", "EUR1M6MSWAP[2SWP]",
																								fwd_func_tenor.FT_1M, "Ask","Mid","Mid", true, "EURIBORFIX1M");
	
	CURVE_TMPL.fwd_basis_2swp_curve_tmpl euribor3m_b2 = new CURVE_TMPL.fwd_basis_2swp_curve_tmpl(euribor6m,"EURIBOR", "EUR3MFRA", "EUR3M6MSWAP[2SWP]",
																								fwd_func_tenor.FT_3M, "Ask","Mid","Mid", true, "EURIBORFIX3M");

	CURVE_TMPL.fwd_basis_2swp_curve_tmpl euribor3m_b2_depo = new CURVE_TMPL.fwd_basis_2swp_curve_tmpl(euribor6m,"EURDEPO", "EUR3MFRA", "EUR3M6MSWAP[2SWP]",
																								fwd_func_tenor.FT_3M, "Ask","Mid","Mid", false, "EURIBORFIX3M");

	CURVE_TMPL.fwd_basis_2swp_curve_tmpl euribor12m_b2 = new CURVE_TMPL.fwd_basis_2swp_curve_tmpl(euribor6m,"EURIBOR", "EUR12MFRA", "EUR6M12MSWAP[2SWP]",
																								fwd_func_tenor.FT_12M, "Ask","Mid","Mid", true, "EURIBORFIX1Y");

	/*model*/
	/*models: 	"LINEAR","SPLINE_NAT","SPLINE_FIN","STEP","HERMITE_AKIMA","HERMITE_CR","HERMITE_FINDIFF","HERMITE_FB","HERMITE_KRUGER":
				"HERMITE_MONO","HERMITE_P","STEP_LINEAR","TENSION_EXACT","TENSION_SPREAD"*/
	
	CURVE_TMPL.fwd_curve_model_tmpl def_model_synt = new CURVE_TMPL.fwd_curve_model_tmpl(false,false,false,curve_prio.SHORT,curve_prio.MIDDLE,
																					5,null<string>,true,false);

	CURVE_TMPL.fwd_curve_model_tmpl def_model = new CURVE_TMPL.fwd_curve_model_tmpl(false,false,false,curve_prio.SHORT,curve_prio.MIDDLE,
																					5,null<string>,false,false);
	
	CURVE_TMPL.fwd_curve_model_tmpl def_model_spr = new CURVE_TMPL.fwd_curve_model_tmpl(false,false,false,curve_prio.SHORT,curve_prio.MIDDLE,
																					5,null<string>,false,true);
	
	CURVE_TMPL.fwd_curve_model_tmpl def_ois_model = new CURVE_TMPL.fwd_curve_model_tmpl(false,false,false,curve_prio.SHORT,curve_prio.MIDDLE,
																					5,"LINEAR",true,false);
				
}

module CRV_TMPL_CC 
{
	/*EURSEK*/
	CURVE_TMPL.currbasis_curve_tmpl eursek3m3m = new CURVE_TMPL.currbasis_curve_tmpl(CRV_TMPL_FWD.euribor3m_b2,CRV_TMPL_FWD.stibor3m,
																				 "EURSEKFX","EURSEK3M3M_BASISSWAP","EURSEK","Mid","Mid","Mid");/*eur 3m fwd via basis swap*/

	CURVE_TMPL.currbasis_curve_tmpl eursek3m3m_alt = new CURVE_TMPL.currbasis_curve_tmpl(CRV_TMPL_FWD.euribor3m_depo,CRV_TMPL_FWD.stibor3m,
																						"EURSEKFX","EURSEK3M3M_BASISSWAP","EURSEK","Mid","Mid","Mid");/*eur 3m fwd without basis swap*/
	/*EURCHF*/
	CURVE_TMPL.currbasis_curve_tmpl eurchf3m3m = new CURVE_TMPL.currbasis_curve_tmpl(CRV_TMPL_FWD.euribor3m_depo,CRV_TMPL_FWD.chflibor3m,
																					"EURCHFFX","EURCHF3M3M_BASISSWAP","EURCHF","Mid","Mid","Mid");/*eur 3m fwd without basis swap*/

	/*model*/
	CURVE_TMPL.currbasis_curve_model_tmpl def_model = new CURVE_TMPL.currbasis_curve_model_tmpl();
	
		
}

//-------------------------------------------------------
// curve_map
//-------------------------------------------------------
CURVE_TMPL.curve_tmpl curve_map(logical 		is_fwd,
								string 			curr,
								fwd_func_tenor option(nullable) tenor,
								out error_info err)
{	
	CURVE_TMPL.curve_tmpl res;
	logical undef = false;
	
	if(!is_fwd) {
		switch (curr){
		case "SEK":
			res = CRV_TMPL_DISC.stina;
			break;
		case "EUR":
			res = CRV_TMPL_DISC.eonia;
			break;
		case "CHF":
			res = CRV_TMPL_DISC.saron;
			break;	
		default:
			undef = true;
		}
	}
	else { 
		if(null(tenor)){
			CORE_INT.add_error_info(err,ERR_T_INIT,"tenor missing","curve_map" );
			return null<CURVE_TMPL.curve_tmpl>; 
		}

		switch (curr){
		case "SEK":
			switch (tenor){
			case fwd_func_tenor.FT_3M:
				res = CRV_TMPL_FWD.stibor3m;
				break;
			default:
				undef = true;
			}
			break;
		case "EUR":
			switch (tenor){
			case fwd_func_tenor.FT_6M:
				res = CRV_TMPL_FWD.euribor6m;
				break;
			case fwd_func_tenor.FT_3M:
				res = CRV_TMPL_FWD.euribor3m_b2;
				break;
			default:
				undef = true;
			}
			break;
		case "CHF":
			switch (tenor){
			case fwd_func_tenor.FT_3M:
				res = CRV_TMPL_FWD.chflibor3m;
				break;
			default:
				undef = true;
			}
			break;
		default:
			undef = true;
		}
	}

	if(undef || null(res)) {
		CORE_INT.add_error_info(err,ERR_T_INIT,"curve not defined","curve_map" );
		return null<CURVE_TMPL.curve_tmpl>;
	}
	res.check(err);
	return err.is_error() ? null<CURVE_TMPL.curve_tmpl> : res;
}
//-------------------------------------------------------
// disc_curve_map
//-------------------------------------------------------
CURVE_TMPL.disc_curve_tmpl disc_curve_map(	string curr,
											out error_info err)
{
	CURVE_TMPL.curve_tmpl c = curve_map(false, curr,null<fwd_func_tenor>, err);	
	return null(c) ? null<CURVE_TMPL.disc_curve_tmpl> : dynamic_cast< CURVE_TMPL.disc_curve_tmpl>(c);	
}

//-------------------------------------------------------
// fixing_curve_map
//-------------------------------------------------------
CURVE_TMPL.fixing_curve_tmpl fixing_curve_map(	string 			curr,										
												out error_info 	err)
{
	CURVE_TMPL.fixing_curve_tmpl res;
	logical undef = false;
	
	switch (curr){
	case "SEK":
		res = CRV_TMPL_FIX.stibor;
		break;
	case "EUR":
		res = CRV_TMPL_FIX.euribor;
		break;
	case "CHF":
		//res = CRV_TMPL_FIX.saron;
		break;	
	default:
		undef = true;
	}
	if(undef || null(res)) {
		CORE_INT.add_error_info(err,ERR_T_INIT,"curve not defined","fixing_curve_map" );
		return null<CURVE_TMPL.fixing_curve_tmpl>;
	}
	res.check(err);
	return err.is_error() ? null<CURVE_TMPL.fixing_curve_tmpl> : res;
}

//-------------------------------------------------------
// fwd_curve_map
//-------------------------------------------------------
CURVE_TMPL.curve_tmpl fwd_curve_map(string 							curr,
									fwd_func_tenor 	tenor,
									out error_info 					err)
{
	return curve_map(true, curr, tenor, err);
}

//-------------------------------------------------------
// curve_basis_map
//-------------------------------------------------------
CURVE_TMPL.currbasis_curve_tmpl curve_basis_map(string 							curr_flat,
												fwd_func_tenor 	tenor_flat,
												string 							curr_sprd,
												fwd_func_tenor 	tenor_sprd,											
												out error_info 					err)
{
	CURVE_TMPL.currbasis_curve_tmpl res;
	logical undef = false;
	
	switch (curr_flat){		
	case "EUR":
		switch (curr_sprd){
		case "SEK":
			if(tenor_flat == fwd_func_tenor.FT_3M && tenor_sprd == 	fwd_func_tenor.FT_3M)
				res = CRV_TMPL_CC.eursek3m3m;
			break;
		case "CHF":
			if(tenor_flat == fwd_func_tenor.FT_3M && tenor_sprd == 	fwd_func_tenor.FT_3M)
				res = CRV_TMPL_CC.eurchf3m3m;
			break;	
		default:
			undef = true;
		}
		break;
	default:
		undef = true;
	}

	if(undef || null(res)) {
		CORE_INT.add_error_info(err,ERR_T_INIT,"curve not defined","curve_basis_map" );
		return null<CURVE_TMPL.currbasis_curve_tmpl>;
	}
	res.check(err);
	return err.is_error() ? null<CURVE_TMPL.currbasis_curve_tmpl> : res;
}



//-------------------------------------------------------
// curve_model_map
//-------------------------------------------------------
CURVE_TMPL.curve_model_tmpl curve_model_map(logical is_fwd,
											string curr,
											out error_info err)
{
	CURVE_TMPL.curve_model_tmpl res;
	if(!is_fwd){
		switch (curr){
		case "SEK":
		case "EUR":
		case "CHF":
		default:
			res = CRV_TMPL_DISC.def_model;
		}
	}
	else {	
		switch (curr){
		case "SEK":
		case "EUR":
		case "CHF":
		default:
			res = CRV_TMPL_FWD.def_model;
		}
	}

	if(null(res)) {
		CORE_INT.add_error_info(err,ERR_T_INIT,"model not defined","curve_model_map" );
		return null<CURVE_TMPL.curve_model_tmpl>;
	}
		
	return res;
}
//-------------------------------------------------------
// disc_curve_model_map
//-------------------------------------------------------
CURVE_TMPL.disc_curve_model_tmpl disc_curve_model_map(string curr,
											out error_info err)
{
	CURVE_TMPL.curve_model_tmpl c = curve_model_map(false, curr, err);
	return null(c) ? null<CURVE_TMPL.disc_curve_model_tmpl> : dynamic_cast< CURVE_TMPL.disc_curve_model_tmpl>(c);	
}
//-------------------------------------------------------
// fwd_curve_model_map
//-------------------------------------------------------
CURVE_TMPL.fwd_curve_model_tmpl fwd_curve_model_map(string curr,
											out error_info err)
{
	CURVE_TMPL.curve_model_tmpl c = curve_model_map(true, curr, err);
	return null(c) ? null<CURVE_TMPL.fwd_curve_model_tmpl> : dynamic_cast< CURVE_TMPL.fwd_curve_model_tmpl>(c);	
}

//-------------------------------------------------------
// fwd_curve_model_map
//-------------------------------------------------------
CURVE_TMPL.currbasis_curve_model_tmpl currbasis_curve_model_map(string  curr_flat,
																string  curr_sprd,
																out error_info err)
{
	CURVE_TMPL.currbasis_curve_model_tmpl res;
	
	switch (curr_flat){		
	case "EUR":
		switch (curr_sprd){
		case "SEK":
		case "CHF":	
		default:
			res = CRV_TMPL_CC.def_model;
		}
		break;
	default:
		res = CRV_TMPL_CC.def_model;
	}

	if(null(res)) {
		CORE_INT.add_error_info(err,ERR_T_INIT,"model not defined","currbasis_curve_model_map" );
		return null<CURVE_TMPL.currbasis_curve_model_tmpl>;
	}
	return res;
}