/*	
	curve model template classes
	Developer: Algorithmica Research, Magnus Nyström			
*/

option(null: hard);	

module CURVE_TMPL
{
	//-------------------------------------------------------
	// class curve_model_tmpl
	//-------------------------------------------------------
	public class curve_model_tmpl 
	{
	public:
		virtual swap_curve_type type() = 0;
		curve_model_tmpl(swap_curve_type);
	protected:
		swap_curve_type type_;
	};
	curve_model_tmpl.curve_model_tmpl(swap_curve_type t): type_(t){}
	
	//-------------------------------------------------------
	// class disc_curve_model_tmpl
	//-------------------------------------------------------
	public class disc_curve_model_tmpl : public  curve_model_tmpl
	{
	   	public:
		override swap_curve_type type() ;
		disc_curve_model_tmpl();
		
		disc_curve_model_tmpl(	logical						no_overlap_fwd,
								logical						merge_fra,
								logical						merge_crv,
								curve_prio					prio1,
								curve_prio					prio2,
								integer						blend_buf_days,
								string option(nullable)		z_model,
								string option(nullable) 	ip_model,
								string option(nullable) 	ip_rt);
		
		logical			no_overlap_fwd();
		logical			merge_middle();
		logical			merge_crv();
		curve_prio		prio1();
		curve_prio		prio2();
		integer			blend_buf_days();
		string  		z_model();
		disc_z_model_type z_model_e();
		string 			ip_model();
		disc_ip_type 	ip_model_e();
		string 			ip_rt();
		rate_type		ip_rt_e();
		curve_blend_parm blend_parm();
		disc_z_model 	disc_model(calendar option(nullable), vector(date) option(nullable) );
		disc_z_model 	extrap_model();
		protected:
		
		logical		no_overlap_fwd_;
		logical		merge_middle_;
		logical		merge_crv_;
		curve_prio	prio1_;
		curve_prio	prio2_;
		integer		blend_buf_days_;

		string 		z_model_;
		string 		ip_model_;
		string 		ip_rt_;
		//..calendar	cal_;
	};
	
	swap_curve_type disc_curve_model_tmpl.type() 			{return type_;}
	logical			disc_curve_model_tmpl.no_overlap_fwd()	{ return no_overlap_fwd_;}
	logical			disc_curve_model_tmpl.merge_middle()	{ return merge_middle_;}
	logical			disc_curve_model_tmpl.merge_crv()		{ return merge_crv_;}
	curve_prio		disc_curve_model_tmpl.prio1()			{ return prio1_;}
	curve_prio		disc_curve_model_tmpl.prio2()			{ return prio2_;}
	integer			disc_curve_model_tmpl.blend_buf_days()	{ return blend_buf_days_;}
	string  		disc_curve_model_tmpl.z_model()			{ return z_model_;}
	disc_z_model_type disc_curve_model_tmpl.z_model_e()		{ return disc_z_map(z_model());}
	string 			disc_curve_model_tmpl.ip_model()		{ return ip_model_;}
	disc_ip_type 	disc_curve_model_tmpl.ip_model_e()		{ return disc_ip_type_map(ip_model_);}
	string 			disc_curve_model_tmpl.ip_rt()			{ return ip_rt_;}		
	rate_type		disc_curve_model_tmpl.ip_rt_e()			{ return disc_rt_map(ip_rt_);}
	curve_blend_parm disc_curve_model_tmpl.blend_parm()		{ return curve_blend_parm(prio1_,prio2_,no_overlap_fwd_,merge_middle_,merge_crv_,blend_buf_days_);}

	
	disc_curve_model_tmpl.disc_curve_model_tmpl(logical						no_overlap_fwd,
												logical						merge_middle,
												logical						merge_crv,
												curve_prio					prio1,
												curve_prio					prio2,
												integer						blend_buf_days,
												string  option(nullable)	z_model,
												string option(nullable) 	ip_model,
												string option(nullable) 	ip_rt)
												:curve_model_tmpl(swap_curve_type.SCE_DISC),
												 no_overlap_fwd_(no_overlap_fwd),
												 merge_middle_(merge_middle),
												 merge_crv_(merge_crv),
												 prio1_(prio1),
												 prio2_(prio2),
												 blend_buf_days_(blend_buf_days),
												 z_model_(null(z_model) ? g_disc_model_s : z_model),
												 ip_model_(null(ip_model) ? g_disc_ip_s: ip_model),
												 ip_rt_(null(ip_rt) ? g_disc_rt_s : ip_rt)
	{}

	disc_curve_model_tmpl.disc_curve_model_tmpl()
								:curve_model_tmpl(swap_curve_type.SCE_DISC),no_overlap_fwd_(false),
								 merge_middle_(false), merge_crv_(false), prio1_(curve_prio.SHORT),
								 prio2_(curve_prio.MIDDLE), blend_buf_days_(5),
								 z_model_(g_disc_model_s ),
								 ip_model_(g_disc_ip_s),
								 ip_rt_(g_disc_rt_s)
	{}

	
	disc_z_model disc_curve_model_tmpl.disc_model(calendar option(nullable) cal,vector(date) option(nullable)  cb_dates  )
	{
		disc_model_parm disc_p 	= disc_model_parm(); 
		disc_z_model_type t 	= z_model_e();

		if(!null(cb_dates) && v_size(cb_dates) == 0)
			cb_dates = null<vector(date)>;
		
		switch (t) 
		{
		//case disc_z_model_type.DZ_BOOT_ON :		
			//disc_p.set_model_boot_on(disc_ip_type_map(ip_model_),g_disc_apply_hyman,
			//						g_disc_left_der,g_disc_hermite_right_der,
			//						cal, cb_dates,/*disc_extrap_type.DXP_ON_FLAT,*/g_disc_xpol_cut) ;
			//break;
		case disc_z_model_type.DZ_NS:	
			disc_p.set_model_ns(cal,cb_dates,null<vector(..on_turns)>,g_disc_std_w,g_disc_xpol_type,g_disc_xpol_cut) ;
			break;	
		case disc_z_model_type.DZ_BOOT :		
			disc_p.set_model_boot(	disc_ip_type_map(ip_model_),g_disc_apply_hyman,g_disc_mc_force_pos,
									disc_rt_map(ip_rt_),g_disc_left_der,g_disc_hermite_right_der,
									cal, cb_dates,null<vector(..on_turns)>,g_disc_xpol_type,g_disc_xpol_cut) ;				
			break;		
		case disc_z_model_type.DZ_ON_STEP:
			disc_p.set_model_step(	cal,cb_dates,null<vector(..on_turns)>,g_disc_xpol_type,g_disc_xpol_cut) ;
			break;
		case disc_z_model_type.DZ_MAX_SMOOTH:	
			disc_p.set_model_max_smooth(cal,cb_dates,null<vector(..on_turns)>,g_disc_smooth_m,g_disc_xpol_type,g_disc_xpol_cut) ;
			break;						
		case disc_z_model_type.DZ_MAX_SMOOTH_SPREAD:
			disc_p.set_model_max_smooth_spread(	cal,cb_dates,null<vector(..on_turns)>,g_disc_smooth_m, g_disc_spreads(),g_disc_spread_t,
												g_disc_xpol_type,g_disc_xpol_cut) ;
			break;
		case disc_z_model_type.DZ_ON_STEP_BOOT:			
			disc_p.set_model_step_boot(	disc_ip_type_map(ip_model_),g_disc_apply_hyman,g_disc_mc_force_pos,
										disc_rt_map(ip_rt_),g_disc_left_der,g_disc_hermite_right_der,
										cal, cb_dates,null<vector(..on_turns)>,g_disc_step_end,g_disc_xpol_type,g_disc_xpol_cut) ;									
			break;
		case disc_z_model_type.DZ_TANGGAARD:
			disc_p.set_model_tanggaard(	cal,cb_dates,null<vector(..on_turns)>,g_disc_w_factor,g_disc_std_w, g_disc_smooth_m,
										g_disc_xpol_type,g_disc_xpol_cut) ;		
			break;
		case disc_z_model_type.DZ_TENSION_W_EXACT: 
			disc_p.set_model_tension_w_exact(	cal,cb_dates,null<vector(..on_turns)>,g_disc_sigma_x(), g_disc_sigma_y(), g_disc_epsilon,													
												g_disc_xpol_type,g_disc_xpol_cut,g_disc_tension_left_der) 	;
			break;
		case disc_z_model_type.DZ_TENSION_W_SPREAD:
			disc_p.set_model_tension_w_spread(	cal,cb_dates,null<vector(..on_turns)>,g_disc_sigma_x(), g_disc_sigma_y(), g_disc_epsilon,													
												g_disc_spreads(),g_disc_spread_t,g_disc_xpol_type,g_disc_xpol_cut,
												g_disc_tension_left_der);
			break;			
		case disc_z_model_type.DZ_TENSION_Y_EXACT:
			disc_p.set_model_tension_y_exact(cal,cb_dates,null<vector(..on_turns)>,g_disc_sigma_x(), g_disc_sigma_y(),g_disc_xpol_type,
											g_disc_xpol_cut,g_disc_tension_left_der, g_disc_tension_right_der) ;
			break;
		case disc_z_model_type.DZ_TENSION_Z_EXACT:			
			disc_p.set_model_tension_z_exact(cal,cb_dates,null<vector(..on_turns)>,g_disc_sigma_x(), g_disc_sigma_y(), g_disc_xpol_type,g_disc_xpol_cut) ;	
			break;
		case disc_z_model_type.DZ_TENSION_Y_SPREAD:
			disc_p.set_model_tension_y_spread(cal,cb_dates,null<vector(..on_turns)>,g_disc_sigma_x(), g_disc_sigma_y(), g_disc_spreads(),g_disc_spread_t,
											g_disc_xpol_type,g_disc_xpol_cut,g_disc_tension_left_der, g_disc_tension_right_der);
			break;
		case disc_z_model_type.DZ_TENSION_Z_SPREAD:
			disc_p.set_model_tension_z_spread(	cal,cb_dates,null<vector(..on_turns)>,g_disc_sigma_x(), g_disc_sigma_y(), g_disc_spreads(),g_disc_spread_t,
												g_disc_xpol_type,g_disc_xpol_cut);	
			break;
		default:
			QL_FAIL("invalid disc model");		
		}
		
		return init_disc_model(disc_p);
	}

	disc_z_model disc_curve_model_tmpl.extrap_model()
	{
		return disc_model(null<calendar>,null<vector(date)>);
	}
	//-------------------------------------------------------
	// class fwd_curve_model_tmpl
	//-------------------------------------------------------
	public class fwd_curve_model_tmpl : public  curve_model_tmpl
	{
	   	public:
		override swap_curve_type type() ;
		
		fwd_curve_model_tmpl();

		fwd_curve_model_tmpl(logical					no_overlap_fwd,
							logical						merge_fra,
							logical						merge_crv,
							curve_prio					prio1,
							curve_prio					prio2,
							integer						blend_buf_days,
							string option(nullable)		z_model,
							logical 					incl_synt,
							logical						model_spr,
							logical option(nullable) 	x_pol_basis = null<logical>);//x_pol_basis used only for basis_2swap
		
		
	
		logical			no_overlap_fwd();
		logical			merge_fra();
		logical			merge_crv();
		curve_prio		prio1();
		curve_prio		prio2();
		integer			blend_buf_days();		
		string  		z_model();
		fwd_z_model_type z_model_e();
		logical			model_spr();
		logical 		incl_synt();
		curve_blend_parm blend_parm();
		logical 		x_pol_basis();
		fwd_z_model 	fwd_model();
		
		protected:
		
		logical		no_overlap_fwd_;
		logical		merge_fra_;
		logical		merge_crv_;
		curve_prio	prio1_;
		curve_prio	prio2_;
		integer		blend_buf_days_;		
		string 		z_model_;
		logical 	incl_synt_;
		logical		model_spr_;
		logical 	x_pol_basis_;
	
	};

	fwd_curve_model_tmpl.fwd_curve_model_tmpl(	logical						no_overlap_fwd,
												logical						merge_fra,
												logical						merge_crv,
												curve_prio					prio1,
												curve_prio					prio2,
												integer						blend_buf_days,
												string  option(nullable)	z_model,
												logical 					incl_synt,
												logical						model_spr,
												logical option(nullable) 	x_pol_basis)
												:curve_model_tmpl(swap_curve_type.SCE_FWD),
												 no_overlap_fwd_(no_overlap_fwd),
												 merge_fra_(merge_fra),
												 merge_crv_(merge_crv),
												 prio1_(prio1),
												 prio2_(prio2),
												 blend_buf_days_(blend_buf_days),
												 z_model_(null(z_model) ? g_fwd_model_s : z_model),
												 incl_synt_(incl_synt), model_spr_(model_spr),
												 x_pol_basis_(null(x_pol_basis) ? true : x_pol_basis)
								 
	{}

	fwd_curve_model_tmpl.fwd_curve_model_tmpl()
								: curve_model_tmpl(swap_curve_type.SCE_FWD),no_overlap_fwd_(false), merge_fra_(false),
								  merge_crv_(false), prio1_(curve_prio.SHORT),
								  prio2_(curve_prio.MIDDLE), blend_buf_days_(5),
								  z_model_(g_fwd_model_s ),
								  incl_synt_(false), model_spr_(false)
	{}
	
	swap_curve_type fwd_curve_model_tmpl.type() 			{ return type_;}
	logical			fwd_curve_model_tmpl.no_overlap_fwd()	{ return no_overlap_fwd_;}
	logical			fwd_curve_model_tmpl.merge_fra()		{ return merge_fra_;}
	logical			fwd_curve_model_tmpl.merge_crv()		{ return merge_crv_;}
	curve_prio		fwd_curve_model_tmpl.prio1()			{ return prio1_;}
	curve_prio		fwd_curve_model_tmpl.prio2()			{ return prio2_;}
	integer			fwd_curve_model_tmpl.blend_buf_days()	{ return blend_buf_days_;}	
	logical  		fwd_curve_model_tmpl.incl_synt()		{ return incl_synt_;}
	logical  		fwd_curve_model_tmpl.model_spr()		{ return model_spr_;}
	string  		fwd_curve_model_tmpl.z_model()			{ return z_model_;}
	fwd_z_model_type fwd_curve_model_tmpl.z_model_e()		{ return fwd_z_map(z_model());}
	curve_blend_parm fwd_curve_model_tmpl.blend_parm()		{ return curve_blend_parm(prio1_,prio2_,no_overlap_fwd_,merge_fra_,merge_crv_,blend_buf_days_);}
	logical 		fwd_curve_model_tmpl.x_pol_basis()		{ return x_pol_basis_;}

	
	fwd_z_model 	fwd_curve_model_tmpl.fwd_model()
	{
		fwd_model_parm fwd_p 	= fwd_model_parm();
		fwd_z_model_type t 		= fwd_z_map(z_model());																				  

		switch (t) 
		{
		case fwd_z_model_type.FZM_LINEAR:
			fwd_p.set_model_linear(null<vector(..fwd_turns)>,g_fwd_left_der,g_fwd_xpol_type,g_fwd_xpol_cut) ;
			break;
		case fwd_z_model_type.FZM_STEP:
			fwd_p.set_model_step(null<vector(..fwd_turns)>,g_fwd_xpol_type,g_fwd_xpol_cut) ;
			break;			
		case fwd_z_model_type.FZM_SPLINE_NAT:
			fwd_p.set_model_spline_nat(null<vector(..fwd_turns)>,g_fwd_apply_hyman,g_fwd_left_der, g_fwd_xpol_type,g_fwd_xpol_cut) ;
			break;
		case fwd_z_model_type.FZM_SPLINE_FIN:
			fwd_p.set_model_spline_fin(null<vector(..fwd_turns)>,g_fwd_apply_hyman,g_fwd_left_der, g_fwd_xpol_type,g_fwd_xpol_cut) ;
			break;									
		case fwd_z_model_type.FZM_HERMITE_AKIMA:
			fwd_p.set_model_hermite_akima(	null<vector(..fwd_turns)>,g_fwd_apply_hyman,g_fwd_left_der,g_fwd_hermite_right_der,
											g_fwd_xpol_type,g_fwd_xpol_cut) ;
			break;
		case fwd_z_model_type.FZM_HERMITE_CR:
			fwd_p.set_model_hermite_cr(	null<vector(..fwd_turns)>,g_fwd_apply_hyman,g_fwd_left_der,g_fwd_hermite_right_der,
										g_fwd_xpol_type,g_fwd_xpol_cut) ;
			break;
		case fwd_z_model_type.FZM_HERMITE_FINDIFF:
			fwd_p.set_model_hermite_findiff(null<vector(..fwd_turns)>,g_fwd_apply_hyman,g_fwd_left_der,g_fwd_hermite_right_der,
											g_fwd_xpol_type,g_fwd_xpol_cut) ;
			break;
		case fwd_z_model_type.FZM_HERMITE_FB:
			fwd_p.set_model_hermite_fb(null<vector(..fwd_turns)>,g_fwd_apply_hyman,g_fwd_left_der,g_fwd_hermite_right_der,
											g_fwd_xpol_type,g_fwd_xpol_cut) ;
			break;
		case fwd_z_model_type.FZM_HERMITE_KRUGER:
			fwd_p.set_model_hermite_kruger(null<vector(..fwd_turns)>,g_fwd_apply_hyman,g_fwd_left_der,g_fwd_hermite_right_der,
												g_fwd_xpol_type,g_fwd_xpol_cut) ;
			break;
		case fwd_z_model_type.FZM_HERMITE_MONO:
			fwd_p.set_model_hermite_mono(	null<vector(..fwd_turns)>,g_fwd_apply_hyman,g_fwd_left_der,g_fwd_hermite_right_der,
											g_fwd_xpol_type,g_fwd_xpol_cut) ;
			break;
		case fwd_z_model_type.FZM_HERMITE_P:	
			fwd_p.set_model_hermite_p(	null<vector(..fwd_turns)>,g_fwd_apply_hyman,g_fwd_left_der,g_fwd_hermite_right_der,
										g_fwd_xpol_type,g_fwd_xpol_cut) ;
			break;
		case fwd_z_model_type.FZM_STEP_LINEAR:			
			fwd_p.set_model_step_linear(null<vector(..fwd_turns)>,g_fwd_left_der, g_fwd_xpol_type,g_fwd_xpol_cut);
			break;	
		case fwd_z_model_type.FZM_TENSION_EXACT:
			fwd_p.set_model_tension_exact(	null<vector(..fwd_turns)>,g_fwd_sigma_x(), g_fwd_sigma_y(),
											g_fwd_xpol_type,g_fwd_xpol_cut,g_fwd_tension_left_der,
											g_fwd_tension_right_der) ;
			break;
				
		case fwd_z_model_type.FZM_TENSION_SPREAD	:
			fwd_p.set_model_tension_spread(	null<vector(..fwd_turns)>,g_fwd_sigma_x(), g_fwd_sigma_y(),g_fwd_spreads(),g_fwd_spread_t,
											g_fwd_xpol_type,g_fwd_xpol_cut,g_fwd_tension_left_der,
											g_fwd_tension_right_der);
			break;
		
		default:
			QL_FAIL("invalid fwd model");
		}
		
		return init_fwd_model(fwd_p);
	}

	//-------------------------------------------------------
	// class currbasis_curve_model_tmpl
	//-------------------------------------------------------
	public class currbasis_curve_model_tmpl : public  curve_model_tmpl
	{
	   	public:
		override swap_curve_type type() ;
		
		currbasis_curve_model_tmpl();

		currbasis_curve_model_tmpl(	logical				merge_crv,
									logical				prio_fx_swap,							
									integer				blend_buf_days,
									interpolator 		ip,
									rate_type			rt);
		
		logical			prio_fx_swap();
		logical			merge_crv();
		integer			blend_buf_days();		
		interpolator 	ip();
		rate_type		rt();
		protected:
		
		logical			prio_fx_swap_;
		logical			merge_crv_;
		integer			blend_buf_days_;		
		interpolator 	ip_;
		rate_type		rt_;
	};

	currbasis_curve_model_tmpl.currbasis_curve_model_tmpl(	logical		merge_crv,
															logical		prio_fx_swap,							
															integer		blend_buf_days,
															interpolator ip,
															rate_type	rt)
														:curve_model_tmpl(swap_curve_type.SCE_CURR_B1_F),
														 prio_fx_swap_(prio_fx_swap),
														 merge_crv_(merge_crv),												
														 blend_buf_days_(blend_buf_days),
														 ip_(ip), rt_(rt)
	{}

	currbasis_curve_model_tmpl.currbasis_curve_model_tmpl()
								: curve_model_tmpl(swap_curve_type.SCE_CURR_B1_F),prio_fx_swap_(true),
								  merge_crv_(false),  blend_buf_days_(5) , ip_(ip_linear()), rt_(RT_LOG_DF)
	{}
	
	swap_curve_type currbasis_curve_model_tmpl.type() 			{ return type_;}
	logical			currbasis_curve_model_tmpl.prio_fx_swap()	{ return prio_fx_swap_;}
	logical			currbasis_curve_model_tmpl.merge_crv()		{ return merge_crv_;}
	integer			currbasis_curve_model_tmpl.blend_buf_days()	{ return blend_buf_days_;}
	interpolator 	currbasis_curve_model_tmpl.ip()				{ return ip_;}
	rate_type		currbasis_curve_model_tmpl.rt()				{ return rt_;}
}
