module ui
{
    public class event_handler
        option(category: "User Interface")
    {
    public:
        virtual void    on_eval_done(context, qlc.unit);
        virtual void    on_rt_source_state(context, string source, rt.source_state, string option(nullable) message);
        virtual void    on_rt_feed_status(context, string source, string feed, logical up, string option(nullable) message);
        virtual void    on_rt_tick(context, rt.tick tick);
        virtual void    on_context_timer(context, integer id);
        virtual logical on_frame_close(frame frame);
        virtual void on_frame_context_menu(frame frame, integer x, integer y);
        virtual void on_frame_drag_end(logical accept, frame src, frame option(nullable) dest_frame, widget option(nullable) dest_ctrl, integer x, integer y);
        virtual void on_frame_drag_feedback(frame src, frame option(nullable) dest_frame, widget option(nullable) dest_ctrl, integer x, integer y);
        virtual void on_frame_menu_cmd(frame frame, string id);
        virtual void on_frame_pre_menu(frame frame);
        virtual void on_frame_resize(frame frame, integer w, integer h);
        virtual logical on_frame_steal_key(frame frame, integer keycode);
        virtual void on_frame_timer(frame frame, integer id);
        virtual void on_notify_icon_click(frame frame);
        virtual void on_notify_icon_context_menu(frame frame, integer x, integer y);
        virtual void on_button_click(button ctrl);
        virtual void on_combobox_closeup(combobox ctrl);
        virtual void on_combobox_dropdown(combobox ctrl);
        virtual void on_combobox_edit_change(combobox ctrl);
        virtual void on_combobox_sel_change(combobox ctrl);
        virtual void on_combobox_sel_end(combobox ctrl, logical ok);
        virtual void on_combobox_kill_focus(combobox ctrl);
        virtual void on_edit_change(edit ctrl);
        virtual void on_edit_kill_focus(edit ctrl);
        virtual void on_dateedit_change(dateedit ctrl);
        virtual void on_dateedit_select(dateedit ctrl, date date);
        virtual void on_dateedit_kill_focus(dateedit ctrl);
        virtual logical on_tree_item_expanding(tree_item item);
        virtual logical on_tree_item_selecting(tree_item item);
        virtual void on_tree_item_expanded(tree_item item);
        virtual void on_tree_item_selected(tree_item item);
        virtual void on_tree_item_click(tree_item item);
        virtual void on_tree_item_dbl_click(tree_item item);
        virtual void on_tree_item_r_click(tree_item item);
        virtual dragimage on_tree_item_begin_drag(tree_item item, integer x, integer y);
        virtual void on_toolbar_button_click(toolbar ctrl, string id);
        virtual void on_toolbar_dropdown_click(toolbar ctrl, string id, integer x, integer y);
        virtual void on_table_click(table ctrl, integer r, integer c);
        virtual void on_table_dbl_click(table ctrl, integer r, integer c);
        virtual void on_table_m_click(table ctrl, integer r, integer c);
        virtual void on_table_x_click(table ctrl, integer r, integer c, integer btn_ix);
        virtual void on_table_context_menu(table ctrl, integer r, integer c, integer x, integer y);
        virtual void on_table_context_menu(table ctrl, integer x, integer y);
        virtual logical on_table_key_down(table ctrl, integer key);
        virtual void on_table_char(table ctrl, integer ch);
        virtual void on_table_kill_focus(table ctrl);
        virtual void on_table_cell_timer(table ctrl, integer r, integer c);
        virtual void on_table_cell_edit(table ctrl, integer r, integer c, string value, table_input_action action);
        virtual void on_table_cell_edit_cancelled(table ctrl, integer r, integer c);
        virtual dragimage on_table_cell_begin_drag(table ctrl, integer r, integer c, integer x, integer y);
        virtual void on_table_scroll(table ctrl);
        virtual void on_table_move_focus(table ctrl, integer r, integer c, integer old_r, integer old_c);
        virtual void on_table_hover(table ctrl, integer r, integer c, integer x, integer y);
        virtual void on_table_row_col_sized(table ctrl, integer r, integer c);
        virtual void on_table_mouse_move(table ctrl, integer r, integer c, integer x, integer y);
        virtual void on_table_mouse_leave(table ctrl);
        virtual void on_pivot_table_click_row_cross(pivot_table ctrl, integer r);
        virtual void on_pivot_table_click_row_header(pivot_table ctrl, integer r);
        virtual void on_pivot_table_dbl_click_row_header(pivot_table ctrl, integer r);
        virtual void on_pivot_table_m_click_row_header(pivot_table ctrl, integer r);
        virtual void on_pivot_table_x_click_row_header(pivot_table ctrl, integer r, integer btn_ix);
        virtual void on_pivot_table_context_menu_row_header(pivot_table ctrl, integer r, integer x, integer y);
        virtual void on_pivot_table_click_col_header(pivot_table ctrl, integer c, integer indent);
        virtual void on_pivot_table_dbl_click_col_header(pivot_table ctrl, integer c, integer indent);
        virtual void on_pivot_table_m_click_col_header(pivot_table ctrl, integer c, integer indent);
        virtual void on_pivot_table_x_click_col_header(pivot_table ctrl, integer c, integer indent, integer btn_ix);
        virtual void on_pivot_table_context_menu_col_header(pivot_table ctrl, integer c, integer indent, integer x, integer y);
        virtual string on_graph_x_label(graph ctrl, number x, number x_next);
        virtual string on_graph_y_label(graph ctrl, number y);
        virtual string on_graph_right_y_label(graph ctrl, number y);
        virtual void on_graph_select_curve(graph ctrl, curve curve);
        virtual void on_graph_deselect_curve(graph ctrl, curve curve);
        virtual void on_graph_context_menu(graph ctrl, integer x, integer y);
        virtual void on_graph_context_menu_x_axis(graph ctrl, number c_x, integer x, integer y);
        virtual void on_graph_context_menu_y_axis(graph ctrl, number c_y, integer x, integer y);
        virtual void on_graph_context_menu_right_y_axis(graph ctrl, number c_y, integer x, integer y);
        virtual void on_graph_context_menu_curve(graph ctrl, curve curve, number c_x, number c_y, integer x, integer y);
        virtual void on_graph_context_menu_label(graph ctrl, label label, integer x, integer y);
        virtual void on_graph_context_menu_cursor(graph ctrl, graph_cursor cursor, integer x, integer y);
        virtual void on_graph_dbl_click(graph ctrl);
        virtual void on_graph_dbl_click_x_axis(graph ctrl, number c_x);
        virtual void on_graph_dbl_click_y_axis(graph ctrl, number c_y);
        virtual void on_graph_dbl_click_right_y_axis(graph ctrl, number c_y);
        virtual void on_graph_dbl_click_curve(graph ctrl, curve curve, number c_x, number c_y);
        virtual void on_graph_dbl_click_label(graph ctrl, label label);
        virtual void on_graph_dbl_click_cursor(graph ctrl, graph_cursor cursor);
        virtual void on_graph_hover(graph ctrl, integer x, integer y);
        virtual void on_graph_hover_x_axis(graph ctrl, number c_x, integer x, integer y);
        virtual void on_graph_hover_y_axis(graph ctrl, number c_y, integer x, integer y);
        virtual void on_graph_hover_right_y_axis(graph ctrl, number c_y, integer x, integer y);
        virtual void on_graph_hover_curve(graph ctrl, curve curve, number c_x, number c_y, integer x, integer y);
        virtual void on_graph_hover_label(graph ctrl, label label, integer x, integer y);
        virtual void on_graph_hover_cursor(graph ctrl, graph_cursor cursor, integer x, integer y);
        virtual void on_graph_end_hover(graph ctrl);
        virtual void on_graph_mouse_move(graph ctrl, integer x, integer y);
        virtual void on_graph_mouse_leave(graph ctrl);
        virtual void on_graph_label_moving(graph ctrl, label label);
        virtual void on_graph_label_moved(graph ctrl, label label);
        virtual void on_graph_cursor_moving(graph ctrl, graph_cursor cursor);
        virtual void on_graph_user_zoomed(graph ctrl);
    };

    void event_handler.on_eval_done(context, qlc.unit)
    { throw(E_CONSTRAINT, "Unhandled on_eval_done event"); }

    void event_handler.on_rt_source_state(context, string source, rt.source_state, string option(nullable) message)
    {}

    void event_handler.on_rt_feed_status(context, string source, string feed, logical up, string option(nullable) message)
    {}

    void event_handler.on_rt_tick(context, rt.tick tick)
    {}

    void event_handler.on_context_timer(context ctxt, integer id)
    {}

    logical event_handler.on_frame_close(frame frame)
    {
        return true;
    }

    void event_handler.on_frame_context_menu(frame frame, integer x, integer y)
    {}

    void event_handler.on_frame_drag_end(logical accept, frame src, frame option(nullable) dest_frame, widget option(nullable) dest_ctrl, integer x, integer y)
    {}

    void event_handler.on_frame_drag_feedback(frame src, frame option(nullable) dest_frame, widget option(nullable) dest_ctrl, integer x, integer y)
    {}

    void event_handler.on_frame_menu_cmd(frame frame, string id)
    {}

    void event_handler.on_frame_pre_menu(frame frame)
    {}

    void event_handler.on_frame_resize(frame frame, integer w, integer h)
    {}

    logical event_handler.on_frame_steal_key(frame frame, integer keycode)
    {
        return false;
    }

    void event_handler.on_frame_timer(frame frame, integer id)
    {}

    void event_handler.on_notify_icon_click(frame frame)
    {}

    void event_handler.on_notify_icon_context_menu(frame frame, integer x, integer y)
    {}

    void event_handler.on_button_click(button ctrl)
    {}

    void event_handler.on_combobox_closeup(combobox ctrl)
    {}

    void event_handler.on_combobox_dropdown(combobox ctrl)
    {}

    void event_handler.on_combobox_edit_change(combobox ctrl)
    {}

    void event_handler.on_combobox_sel_change(combobox ctrl)
    {}

    void event_handler.on_combobox_sel_end(combobox ctrl, logical ok)
    {}

    void event_handler.on_combobox_kill_focus(combobox ctrl)
    {}

    void event_handler.on_edit_change(edit ctrl)
    {}

    void event_handler.on_edit_kill_focus(edit ctrl)
    {}

    void event_handler.on_dateedit_change(dateedit ctrl)
    {}

    void event_handler.on_dateedit_select(dateedit ctrl, date date)
    {}

    void event_handler.on_dateedit_kill_focus(dateedit ctrl)
    {}

    logical event_handler.on_tree_item_expanding(tree_item item)
    {
        return true;
    }

    logical event_handler.on_tree_item_selecting(tree_item item)
    {
        return true;
    }

    void event_handler.on_tree_item_expanded(tree_item item)
    {}

    void event_handler.on_tree_item_selected(tree_item item)
    {}

    void event_handler.on_tree_item_click(tree_item item)
    {}

    void event_handler.on_tree_item_dbl_click(tree_item item)
    {}

    void event_handler.on_tree_item_r_click(tree_item item)
    {}

    dragimage event_handler.on_tree_item_begin_drag(tree_item item, integer x, integer y)
    {
        return null<dragimage>;
    }

    void event_handler.on_toolbar_button_click(toolbar ctrl, string id)
    {}

    void event_handler.on_toolbar_dropdown_click(toolbar ctrl, string id, integer x, integer y)
    {}

    void event_handler.on_table_click(table ctrl, integer r, integer c)
    {}

    void event_handler.on_table_dbl_click(table ctrl, integer r, integer c)
    {}

    void event_handler.on_table_m_click(table ctrl, integer r, integer c)
    {}

    void event_handler.on_table_x_click(table ctrl, integer r, integer c, integer btn_ix)
    {}

    void event_handler.on_table_context_menu(table ctrl, integer r, integer c, integer x, integer y)
    {}

    void event_handler.on_table_context_menu(table ctrl, integer x, integer y)
    {}

    logical event_handler.on_table_key_down(table ctrl, integer key)
    {
        return false;
    }

    void event_handler.on_table_char(table ctrl, integer ch)
    {}

    void event_handler.on_table_kill_focus(table ctrl)
    {}

    void event_handler.on_table_cell_timer(table ctrl, integer r, integer c)
    {}

    void event_handler.on_table_cell_edit(table ctrl, integer r, integer c, string value, table_input_action action)
    {}

    void event_handler.on_table_cell_edit_cancelled(table ctrl, integer r, integer c)
    {}

    dragimage event_handler.on_table_cell_begin_drag(table ctrl, integer r, integer c, integer x, integer y)
    {
        return null<dragimage>;
    }

    void event_handler.on_table_scroll(table ctrl)
    {}

    void event_handler.on_table_move_focus(table ctrl, integer r, integer c, integer old_r, integer old_c)
    {}

    void event_handler.on_table_hover(table ctrl, integer r, integer c, integer x, integer y)
    {}

    void event_handler.on_table_row_col_sized(table ctrl, integer r, integer c)
    {}

    void event_handler.on_table_mouse_move(table ctrl, integer r, integer c, integer x, integer y)
    {}

    void event_handler.on_table_mouse_leave(table ctrl)
    {}

    void event_handler.on_pivot_table_click_row_cross(pivot_table ctrl, integer r)
    {}

    void event_handler.on_pivot_table_click_row_header(pivot_table ctrl, integer r)
    {}

    void event_handler.on_pivot_table_dbl_click_row_header(pivot_table ctrl, integer r)
    {}

    void event_handler.on_pivot_table_m_click_row_header(pivot_table ctrl, integer r)
    {}

    void event_handler.on_pivot_table_x_click_row_header(pivot_table ctrl, integer r, integer btn_ix)
    {}

    void event_handler.on_pivot_table_context_menu_row_header(pivot_table ctrl, integer r, integer x, integer y)
    {}

    void event_handler.on_pivot_table_click_col_header(pivot_table ctrl, integer c, integer indent)
    {}

    void event_handler.on_pivot_table_dbl_click_col_header(pivot_table ctrl, integer c, integer indent)
    {}

    void event_handler.on_pivot_table_m_click_col_header(pivot_table ctrl, integer c, integer indent)
    {}

    void event_handler.on_pivot_table_x_click_col_header(pivot_table ctrl, integer c, integer indent, integer btn_ix)
    {}

    void event_handler.on_pivot_table_context_menu_col_header(pivot_table ctrl, integer c, integer indent, integer x, integer y)
    {}

    string event_handler.on_graph_x_label(graph ctrl, number x, number x_next)
    {
        return str_stripped(x, 12, 1);
    }

    string event_handler.on_graph_y_label(graph ctrl, number y)
    {
        return str_stripped(y, 12, 1);
    }

    string event_handler.on_graph_right_y_label(graph ctrl, number y)
    {
        return str_stripped(y, 12, 1);
    }

    void event_handler.on_graph_select_curve(graph ctrl, curve curve)
    {}

    void event_handler.on_graph_deselect_curve(graph ctrl, curve curve)
    {}

    void event_handler.on_graph_context_menu(graph ctrl, integer x, integer y)
    {}

    void event_handler.on_graph_context_menu_x_axis(graph ctrl, number c_x, integer x, integer y)
    {
        on_graph_context_menu(ctrl, x, y);
    }

    void event_handler.on_graph_context_menu_y_axis(graph ctrl, number c_y, integer x, integer y)
    {
        on_graph_context_menu(ctrl, x, y);
    }

    void event_handler.on_graph_context_menu_right_y_axis(graph ctrl, number c_y, integer x, integer y)
    {
        on_graph_context_menu(ctrl, x, y);
    }

    void event_handler.on_graph_context_menu_curve(graph ctrl, curve curve, number c_x, number c_y, integer x, integer y)
    {
        on_graph_context_menu(ctrl, x, y);
    }

    void event_handler.on_graph_context_menu_label(graph ctrl, label label, integer x, integer y)
    {
        on_graph_context_menu(ctrl, x, y);
    }

    void event_handler.on_graph_context_menu_cursor(graph ctrl, graph_cursor cursor, integer x, integer y)
    {
        on_graph_context_menu(ctrl, x, y);
    }

    void event_handler.on_graph_dbl_click(graph ctrl)
    {}

    void event_handler.on_graph_dbl_click_x_axis(graph ctrl, number c_x)
    {
        on_graph_dbl_click(ctrl);
    }

    void event_handler.on_graph_dbl_click_y_axis(graph ctrl, number c_y)
    {
        on_graph_dbl_click(ctrl);
    }

    void event_handler.on_graph_dbl_click_right_y_axis(graph ctrl, number c_y)
    {
        on_graph_dbl_click(ctrl);
    }

    void event_handler.on_graph_dbl_click_curve(graph ctrl, curve curve, number c_x, number c_y)
    {
        on_graph_dbl_click(ctrl);
    }

    void event_handler.on_graph_dbl_click_label(graph ctrl, label label)
    {
        on_graph_dbl_click(ctrl);
    }

    void event_handler.on_graph_dbl_click_cursor(graph ctrl, graph_cursor cursor)
    {
        on_graph_dbl_click(ctrl);
    }

    void event_handler.on_graph_hover(graph ctrl, integer x, integer y)
    {}

    void event_handler.on_graph_hover_x_axis(graph ctrl, number c_x, integer x, integer y)
    {
        on_graph_hover(ctrl, x, y);
    }

    void event_handler.on_graph_hover_y_axis(graph ctrl, number c_y, integer x, integer y)
    {
        on_graph_hover(ctrl, x, y);
    }

    void event_handler.on_graph_hover_right_y_axis(graph ctrl, number c_y, integer x, integer y)
    {
        on_graph_hover(ctrl, x, y);
    }

    void event_handler.on_graph_hover_curve(graph ctrl, curve curve, number c_x, number c_y, integer x, integer y)
    {
        on_graph_hover(ctrl, x, y);
    }

    void event_handler.on_graph_hover_label(graph ctrl, label label, integer x, integer y)
    {
        on_graph_hover(ctrl, x, y);
    }

    void event_handler.on_graph_hover_cursor(graph ctrl, graph_cursor cursor, integer x, integer y)
    {
        on_graph_hover(ctrl, x, y);
    }

    void event_handler.on_graph_end_hover(graph ctrl)
    {}

    void event_handler.on_graph_mouse_move(graph ctrl, integer x, integer y)
    {}

    void event_handler.on_graph_mouse_leave(graph ctrl)
    {}

    void event_handler.on_graph_label_moving(graph ctrl, label label)
    {}

    void event_handler.on_graph_label_moved(graph ctrl, label label)
    {}

    void event_handler.on_graph_cursor_moving(graph ctrl, graph_cursor cursor)
    {}

    void event_handler.on_graph_user_zoomed(graph ctrl)
    {}
}
